package Chart::Plotly::Trace::Ohlc::Decreasing;
use Moose;
use MooseX::ExtraArgs;
use Moose::Util::TypeConstraints qw(enum union);
if ( !defined Moose::Util::TypeConstraints::find_type_constraint('PDL') ) {
    Moose::Util::TypeConstraints::type('PDL');
}

use Chart::Plotly::Trace::Ohlc::Decreasing::Line;

our $VERSION = '0.018';    # VERSION

# ABSTRACT: This attribute is one of the possible options for the trace ohlc.

sub TO_JSON {
    my $self       = shift;
    my $extra_args = $self->extra_args // {};
    my $meta       = $self->meta;
    my %hash       = %$self;
    for my $name ( sort keys %hash ) {
        my $attr = $meta->get_attribute($name);
        if ( defined $attr ) {
            my $value = $hash{$name};
            my $type  = $attr->type_constraint;
            if ( $type && $type->equals('Bool') ) {
                $hash{$name} = $value ? \1 : \0;
            }
        }
    }
    %hash = ( %hash, %$extra_args );
    delete $hash{'extra_args'};
    if ( $self->can('type') && ( !defined $hash{'type'} ) ) {
        $hash{type} = $self->type();
    }
    return \%hash;
}

has line => ( is  => "rw",
              isa => "Maybe[HashRef]|Chart::Plotly::Trace::Ohlc::Decreasing::Line", );

has name => ( is            => "rw",
              isa           => "Str",
              documentation => "Sets the segment name. The segment name appear as the legend item and on hover.",
);

has showlegend => (
             is            => "rw",
             isa           => "Bool",
             documentation => "Determines whether or not an item corresponding to this segment is shown in the legend.",
);

__PACKAGE__->meta->make_immutable();
1;

__END__

=pod

=encoding utf-8

=head1 NAME

Chart::Plotly::Trace::Ohlc::Decreasing - This attribute is one of the possible options for the trace ohlc.

=head1 VERSION

version 0.018

=head1 SYNOPSIS

 use Chart::Plotly;
 use Chart::Plotly::Trace::Ohlc;
 my $ohlc = Chart::Plotly::Trace::Ohlc->new(
     x     => [ 1 .. 5 ],
     open  => [ 1, 6, 7 ],
     close => [ 7, 12, 5 ],
     high  => [ 8, 15, 10 ],
     low   => [ 0.5, 5, 4 ]
 );
 
 Chart::Plotly::show_plot([ $ohlc ]);

=head1 DESCRIPTION

This attribute is part of the possible options for the trace ohlc.

This file has been autogenerated from the official plotly.js source.

If you like Plotly, please support them: L<https://plot.ly/> 
Open source announcement: L<https://plot.ly/javascript/open-source-announcement/>

Full reference: L<https://plot.ly/javascript/reference/#ohlc>

=head1 DISCLAIMER

This is an unofficial Plotly Perl module. Currently I'm not affiliated in any way with Plotly. 
But I think plotly.js is a great library and I want to use it with perl.

=head1 METHODS

=head2 TO_JSON

Serialize the trace to JSON. This method should be called only by L<JSON> serializer.

=head1 ATTRIBUTES

=over

=item * line

=item * name

Sets the segment name. The segment name appear as the legend item and on hover.

=item * showlegend

Determines whether or not an item corresponding to this segment is shown in the legend.

=back

=head1 AUTHOR

Pablo Rodríguez González <pablo.rodriguez.gonzalez@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018 by Pablo Rodríguez González.

This is free software, licensed under:

  The MIT (X11) License

=cut
