package Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-06'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240506.0'; # VERSION

use Acme::CPANAuthors::Register (
    'PERLANCAR' => '',
    'KIMOTO' => '',
    'SKIM' => '',
    'ETHER' => '',
    'DERF' => '',
    'TYRRMINAL' => '',
    'MATHIAS' => '',
    'ARFREITAS' => '',
    'BRIANDFOY' => '',
    'EXODIST' => '',
    'HMBRAND' => '',
    'PEVANS' => '',
    'BPSCHUCK' => '',
    'GDT' => '',
    'JJATRIA' => '',
    'KUERBIS' => '',
    'SISYPHUS' => '',
    'UTASHIRO' => '',
    'JDEGUEST' => '',
    'JOESUF' => '',
    'LEONT' => '',
    'ABBYPAN' => '',
    'ABELTJE' => '',
    'ABRAXXA' => '',
    'BIGPRESH' => '',
    'CAPOEIRAB' => '',
    'DCANTRELL' => '',
    'JV' => '',
    'MRUEDA' => '',
    'NERDVANA' => '',
    'NLNETLABS' => '',
    'OLIVER' => '',
    'PMQS' => '',
    'SREZIC' => '',
    'TEAM' => '',
    'TIMKA' => '',
    'WYANT' => '',
    'EGILES' => '',
    'TRIZEN' => '',
    'ASPOSE' => '',
    'BDFOY' => '',
    'BPS' => '',
    'BWEST' => '',
    'CAVAC' => '',
    'COUDOT' => '',
    'DAGOLDEN' => '',
    'DAMI' => '',
    'DAVECROSS' => '',
    'DJERIUS' => '',
    'DVEEDEN' => '',
    'GBROWN' => '',
    'GRYPHON' => '',
    'HAARG' => '',
    'JRM' => '',
    'LNATION' => '',
    'MAMAWE' => '',
    'MJONDET' => '',
    'OALDERS' => '',
    'RATCLIFFE' => '',
    'RJBS' => '',
    'RURBAN' => '',
    'SCHUBIGER' => '',
    'SKAJI' => '',
    'STEFFENW' => '',
    'TEODESIAN' => '',
    'UXYZAB' => '',
    'VOJ' => '',
    'DDICK' => '',
    'DRCLAW' => '',
    'OLOF' => '',
);


1;
# ABSTRACT: Authors with ongoing weekly releases streak (do a release every week)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current - Authors with ongoing weekly releases streak (do a release every week)

=head1 VERSION

This document describes version 20240506.0 of Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-05-06.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-05-06, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | PERLANCAR | 507 | 2014-08-24 | ongoing     |
  | KIMOTO    |  15 | 2024-01-21 | might-break |
  | SKIM      |  15 | 2024-01-21 | might-break |
  | ETHER     |  11 | 2024-02-18 | might-break |
  | DERF      |   6 | 2024-03-24 | might-break |
  | TYRRMINAL |   6 | 2024-03-24 | might-break |
  | MATHIAS   |   6 | 2024-03-31 | ongoing     |
  | ARFREITAS |   4 | 2024-04-07 | might-break |
  | BRIANDFOY |   4 | 2024-04-07 | might-break |
  | EXODIST   |   4 | 2024-04-07 | might-break |
  | HMBRAND   |   4 | 2024-04-07 | might-break |
  | PEVANS    |   4 | 2024-04-07 | might-break |
  | BPSCHUCK  |   3 | 2024-04-14 | might-break |
  | GDT       |   3 | 2024-04-14 | might-break |
  | JJATRIA   |   3 | 2024-04-14 | might-break |
  | KUERBIS   |   3 | 2024-04-14 | might-break |
  | SISYPHUS  |   3 | 2024-04-14 | might-break |
  | UTASHIRO  |   3 | 2024-04-14 | might-break |
  | JDEGUEST  |   3 | 2024-04-21 | ongoing     |
  | JOESUF    |   3 | 2024-04-21 | ongoing     |
  | LEONT     |   3 | 2024-04-21 | ongoing     |
  | ABBYPAN   |   2 | 2024-04-21 | might-break |
  | ABELTJE   |   2 | 2024-04-21 | might-break |
  | ABRAXXA   |   2 | 2024-04-21 | might-break |
  | BIGPRESH  |   2 | 2024-04-21 | might-break |
  | CAPOEIRAB |   2 | 2024-04-21 | might-break |
  | DCANTRELL |   2 | 2024-04-21 | might-break |
  | JV        |   2 | 2024-04-21 | might-break |
  | MRUEDA    |   2 | 2024-04-21 | might-break |
  | NERDVANA  |   2 | 2024-04-21 | might-break |
  | NLNETLABS |   2 | 2024-04-21 | might-break |
  | OLIVER    |   2 | 2024-04-21 | might-break |
  | PMQS      |   2 | 2024-04-21 | might-break |
  | SREZIC    |   2 | 2024-04-21 | might-break |
  | TEAM      |   2 | 2024-04-21 | might-break |
  | TIMKA     |   2 | 2024-04-21 | might-break |
  | WYANT     |   2 | 2024-04-21 | might-break |
  | EGILES    |   2 | 2024-04-28 | ongoing     |
  | TRIZEN    |   2 | 2024-04-28 | ongoing     |
  | ASPOSE    |   1 | 2024-04-28 | might-break |
  | BDFOY     |   1 | 2024-04-28 | might-break |
  | BPS       |   1 | 2024-04-28 | might-break |
  | BWEST     |   1 | 2024-04-28 | might-break |
  | CAVAC     |   1 | 2024-04-28 | might-break |
  | COUDOT    |   1 | 2024-04-28 | might-break |
  | DAGOLDEN  |   1 | 2024-04-28 | might-break |
  | DAMI      |   1 | 2024-04-28 | might-break |
  | DAVECROSS |   1 | 2024-04-28 | might-break |
  | DJERIUS   |   1 | 2024-04-28 | might-break |
  | DVEEDEN   |   1 | 2024-04-28 | might-break |
  | GBROWN    |   1 | 2024-04-28 | might-break |
  | GRYPHON   |   1 | 2024-04-28 | might-break |
  | HAARG     |   1 | 2024-04-28 | might-break |
  | JRM       |   1 | 2024-04-28 | might-break |
  | LNATION   |   1 | 2024-04-28 | might-break |
  | MAMAWE    |   1 | 2024-04-28 | might-break |
  | MJONDET   |   1 | 2024-04-28 | might-break |
  | OALDERS   |   1 | 2024-04-28 | might-break |
  | RATCLIFFE |   1 | 2024-04-28 | might-break |
  | RJBS      |   1 | 2024-04-28 | might-break |
  | RURBAN    |   1 | 2024-04-28 | might-break |
  | SCHUBIGER |   1 | 2024-04-28 | might-break |
  | SKAJI     |   1 | 2024-04-28 | might-break |
  | STEFFENW  |   1 | 2024-04-28 | might-break |
  | TEODESIAN |   1 | 2024-04-28 | might-break |
  | UXYZAB    |   1 | 2024-04-28 | might-break |
  | VOJ       |   1 | 2024-04-28 | might-break |
  | DDICK     |   1 | 2024-05-05 | ongoing     |
  | DRCLAW    |   1 | 2024-05-05 | ongoing     |
  | OLOF      |   1 | 2024-05-05 | ongoing     |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
