package Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-02-21'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240221.0'; # VERSION

use Acme::CPANAuthors::Register (
    'PERLANCAR' => '',
    'BDFOY' => '',
    'JV' => '',
    'KIMOTO' => '',
    'OALDERS' => '',
    'SKIM' => '',
    'NHORNE' => '',
    'AJNN' => '',
    'BPS' => '',
    'JDEGUEST' => '',
    'JRM' => '',
    'MANWAR' => '',
    'DWHEELER' => '',
    'VVELOX' => '',
    'BRIANDFOY' => '',
    'PLICEASE' => '',
    'HOUSTON' => '',
    'RAWLEYFOW' => '',
    'SANKO' => '',
    'SISYPHUS' => '',
    'AJWOOD' => '',
    'ARISTOTLE' => '',
    'ASB' => '',
    'BKB' => '',
    'CUKEBOT' => '',
    'DAMI' => '',
    'DART' => '',
    'FELIPE' => '',
    'GRABZIT' => '',
    'HANJE' => '',
    'HESCO' => '',
    'HMBRAND' => '',
    'INGY' => '',
    'JANW' => '',
    'JAVONET' => '',
    'JCRISTY' => '',
    'JHTHORSEN' => '',
    'JONASBN' => '',
    'KUERBIS' => '',
    'MIKKOI' => '',
    'MSIMERSON' => '',
    'NEZUMI' => '',
    'NLNETLABS' => '',
    'OLIVER' => '',
    'PLAIN' => '',
    'TEAM' => '',
    'TIMKA' => '',
    'UTASHIRO' => '',
    'WOUTER' => '',
    'ZMUGHAL' => '',
    'ABALAMA' => '',
    'CRORAA' => '',
    'DAKKAR' => '',
    'ETHER' => '',
    'ETJ' => '',
    'FASTLY' => '',
    'GBROWN' => '',
    'JDDPAUSE' => '',
    'JGNI' => '',
    'JIMAVERA' => '',
    'JSF' => '',
    'KJETILK' => '',
    'KRYDE' => '',
    'LITCHIE' => '',
    'MLEHMANN' => '',
    'OETIKER' => '',
    'OODLER' => '',
    'PMQS' => '',
    'RKAPL' => '',
    'SREZIC' => '',
    'TYRRMINAL' => '',
    'VOLKENING' => '',
);


1;
# ABSTRACT: Authors with ongoing weekly releases streak (do a release every week)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current - Authors with ongoing weekly releases streak (do a release every week)

=head1 VERSION

This document describes version 20240221.0 of Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-02-21.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-02-21, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | PERLANCAR | 496 | 2014-08-24 | ongoing     |
  | BDFOY     |  16 | 2023-10-29 | might-break |
  | JV        |   5 | 2024-01-21 | ongoing     |
  | KIMOTO    |   5 | 2024-01-21 | ongoing     |
  | OALDERS   |   5 | 2024-01-21 | ongoing     |
  | SKIM      |   4 | 2024-01-21 | might-break |
  | NHORNE    |   4 | 2024-01-28 | ongoing     |
  | AJNN      |   3 | 2024-01-28 | might-break |
  | BPS       |   3 | 2024-01-28 | might-break |
  | JDEGUEST  |   3 | 2024-01-28 | might-break |
  | JRM       |   3 | 2024-01-28 | might-break |
  | MANWAR    |   3 | 2024-01-28 | might-break |
  | DWHEELER  |   3 | 2024-02-04 | ongoing     |
  | VVELOX    |   3 | 2024-02-04 | ongoing     |
  | BRIANDFOY |   2 | 2024-02-04 | might-break |
  | PLICEASE  |   2 | 2024-02-04 | might-break |
  | HOUSTON   |   2 | 2024-02-11 | ongoing     |
  | RAWLEYFOW |   2 | 2024-02-11 | ongoing     |
  | SANKO     |   2 | 2024-02-11 | ongoing     |
  | SISYPHUS  |   2 | 2024-02-11 | ongoing     |
  | AJWOOD    |   1 | 2024-02-11 | might-break |
  | ARISTOTLE |   1 | 2024-02-11 | might-break |
  | ASB       |   1 | 2024-02-11 | might-break |
  | BKB       |   1 | 2024-02-11 | might-break |
  | CUKEBOT   |   1 | 2024-02-11 | might-break |
  | DAMI      |   1 | 2024-02-11 | might-break |
  | DART      |   1 | 2024-02-11 | might-break |
  | FELIPE    |   1 | 2024-02-11 | might-break |
  | GRABZIT   |   1 | 2024-02-11 | might-break |
  | HANJE     |   1 | 2024-02-11 | might-break |
  | HESCO     |   1 | 2024-02-11 | might-break |
  | HMBRAND   |   1 | 2024-02-11 | might-break |
  | INGY      |   1 | 2024-02-11 | might-break |
  | JANW      |   1 | 2024-02-11 | might-break |
  | JAVONET   |   1 | 2024-02-11 | might-break |
  | JCRISTY   |   1 | 2024-02-11 | might-break |
  | JHTHORSEN |   1 | 2024-02-11 | might-break |
  | JONASBN   |   1 | 2024-02-11 | might-break |
  | KUERBIS   |   1 | 2024-02-11 | might-break |
  | MIKKOI    |   1 | 2024-02-11 | might-break |
  | MSIMERSON |   1 | 2024-02-11 | might-break |
  | NEZUMI    |   1 | 2024-02-11 | might-break |
  | NLNETLABS |   1 | 2024-02-11 | might-break |
  | OLIVER    |   1 | 2024-02-11 | might-break |
  | PLAIN     |   1 | 2024-02-11 | might-break |
  | TEAM      |   1 | 2024-02-11 | might-break |
  | TIMKA     |   1 | 2024-02-11 | might-break |
  | UTASHIRO  |   1 | 2024-02-11 | might-break |
  | WOUTER    |   1 | 2024-02-11 | might-break |
  | ZMUGHAL   |   1 | 2024-02-11 | might-break |
  | ABALAMA   |   1 | 2024-02-18 | ongoing     |
  | CRORAA    |   1 | 2024-02-18 | ongoing     |
  | DAKKAR    |   1 | 2024-02-18 | ongoing     |
  | ETHER     |   1 | 2024-02-18 | ongoing     |
  | ETJ       |   1 | 2024-02-18 | ongoing     |
  | FASTLY    |   1 | 2024-02-18 | ongoing     |
  | GBROWN    |   1 | 2024-02-18 | ongoing     |
  | JDDPAUSE  |   1 | 2024-02-18 | ongoing     |
  | JGNI      |   1 | 2024-02-18 | ongoing     |
  | JIMAVERA  |   1 | 2024-02-18 | ongoing     |
  | JSF       |   1 | 2024-02-18 | ongoing     |
  | KJETILK   |   1 | 2024-02-18 | ongoing     |
  | KRYDE     |   1 | 2024-02-18 | ongoing     |
  | LITCHIE   |   1 | 2024-02-18 | ongoing     |
  | MLEHMANN  |   1 | 2024-02-18 | ongoing     |
  | OETIKER   |   1 | 2024-02-18 | ongoing     |
  | OODLER    |   1 | 2024-02-18 | ongoing     |
  | PMQS      |   1 | 2024-02-18 | ongoing     |
  | RKAPL     |   1 | 2024-02-18 | ongoing     |
  | SREZIC    |   1 | 2024-02-18 | ongoing     |
  | TYRRMINAL |   1 | 2024-02-18 | ongoing     |
  | VOLKENING |   1 | 2024-02-18 | ongoing     |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
