package Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::AllTime;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-02-21'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240221.0'; # VERSION

use Acme::CPANAuthors::Register (
    'ETHER' => '',
    'PERLANCAR' => '',
    'MANWAR' => '',
    'FREW' => '',
    'IVANWILLS' => '',
    'BARBIE' => '',
    'TOBYINK' => '',
    'CJM' => '',
    'MGV' => '',
    'BOOK' => '',
    'BINGOS' => '',
    'RJBS' => '',
    'KIMOTO' => '',
    'KENTNL' => '',
    'TOKUHIROM' => '',
    'NEILB' => '',
    'KRYDE' => '',
    'RWSTAUNER' => '',
    'DROLSKY' => '',
    'PEVANS' => '',
    'JKEGL' => '',
    'SRI' => '',
    'LEONT' => '',
    'SHLOMIF' => '',
    'PLICEASE' => '',
    'SKIM' => '',
    'ADAMK' => '',
    'FLORA' => '',
    'GFUJI' => '',
    'WYANT' => '',
    'SHARYANTO' => '',
    'PETDANCE' => '',
    'DAGOLDEN' => '',
    'KUERBIS' => '',
    'FELIPE' => '',
    'EXODIST' => '',
    'AWNCORP' => '',
    'JHTHORSEN' => '',
    'BINARY' => '',
    'INGY' => '',
    'BKB' => '',
    'YANICK' => '',
    'CSSON' => '',
    'SMUELLER' => '',
    'AVAR' => '',
    'MIYAGAWA' => '',
    'NUFFIN' => '',
    'FAYLAND' => '',
    'JETTERO' => '',
    'WOLDRICH' => '',
    'UTASHIRO' => '',
    'MLEHMANN' => '',
    'PREACTION' => '',
    'ZDM' => '',
    'AUTRIJUS' => '',
    'BOBTFISH' => '',
    'GPHAT' => '',
    'REEDFISH' => '',
    'RENEEB' => '',
);


1;
# ABSTRACT: Authors with all-time weekly releases streak (do a release every week)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::AllTime - Authors with all-time weekly releases streak (do a release every week)

=head1 VERSION

This document describes version 20240221.0 of Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::AllTime (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-02-21.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-02-21, produced by L<cpan-streaks>, only streaks with length of at least 20 are included):

  +-----------+-----+------------+------------+---------+
  | author    | len | start_date | end_date   | status  |
  +-----------+-----+------------+------------+---------+
  | ETHER     | 523 | 2012-03-04 | 2022-03-06 | broken  |
  | PERLANCAR | 496 | 2014-08-24 |            | ongoing |
  | MANWAR    | 270 | 2014-09-07 | 2019-11-03 | broken  |
  | FREW      | 200 | 2012-02-12 | 2015-12-06 | broken  |
  | IVANWILLS | 177 | 2016-01-24 | 2019-06-09 | broken  |
  | BARBIE    | 165 | 2012-03-25 | 2015-05-17 | broken  |
  | TOBYINK   | 133 | 2012-04-15 | 2014-10-26 | broken  |
  | CJM       | 132 | 2012-01-01 | 2014-07-06 | broken  |
  | MGV       | 130 | 2015-01-25 | 2017-07-16 | broken  |
  | BOOK      | 129 | 2012-04-29 | 2014-10-12 | broken  |
  | BINGOS    | 125 | 2012-06-17 | 2014-11-02 | broken  |
  | RJBS      | 122 | 2008-08-24 | 2010-12-19 | broken  |
  | RJBS      | 111 | 2013-06-09 | 2015-07-19 | broken  |
  | ETHER     |  99 | 2022-03-20 | 2024-02-04 | broken  |
  | BOOK      |  98 | 2005-01-09 | 2006-11-19 | broken  |
  | KIMOTO    |  97 | 2021-12-05 | 2023-10-08 | broken  |
  | KENTNL    |  93 | 2013-02-03 | 2014-11-09 | broken  |
  | TOKUHIROM |  80 | 2012-05-27 | 2013-12-01 | broken  |
  | RJBS      |  79 | 2011-11-27 | 2013-05-26 | broken  |
  | CJM       |  75 | 2014-07-20 | 2015-12-20 | broken  |
  | NEILB     |  71 | 2013-08-11 | 2014-12-14 | broken  |
  | KRYDE     |  66 | 2010-05-23 | 2011-08-21 | broken  |
  | RWSTAUNER |  58 | 2012-03-18 | 2013-04-21 | broken  |
  | BINGOS    |  54 | 2011-04-03 | 2012-04-08 | broken  |
  | IVANWILLS |  54 | 2014-10-19 | 2015-10-25 | broken  |
  | DROLSKY   |  51 | 2009-01-18 | 2010-01-03 | broken  |
  | PEVANS    |  48 | 2013-03-31 | 2014-02-23 | broken  |
  | MGV       |  47 | 2017-07-30 | 2018-06-17 | broken  |
  | JKEGL     |  46 | 2012-09-23 | 2013-08-04 | broken  |
  | SRI       |  46 | 2014-05-25 | 2015-04-05 | broken  |
  | TOKUHIROM |  45 | 2010-05-02 | 2011-03-06 | broken  |
  | LEONT     |  44 | 2012-08-05 | 2013-06-02 | broken  |
  | MGV       |  40 | 2014-04-13 | 2015-01-11 | broken  |
  | LEONT     |  39 | 2015-01-11 | 2015-10-04 | broken  |
  | SHLOMIF   |  39 | 2019-11-24 | 2020-08-16 | broken  |
  | PLICEASE  |  38 | 2013-04-21 | 2014-01-05 | broken  |
  | SKIM      |  38 | 2014-07-20 | 2015-04-05 | broken  |
  | ADAMK     |  37 | 2010-11-21 | 2011-07-31 | broken  |
  | FLORA     |  36 | 2009-03-15 | 2009-11-15 | broken  |
  | GFUJI     |  36 | 2009-07-26 | 2010-03-28 | broken  |
  | GFUJI     |  36 | 2010-04-11 | 2010-12-12 | broken  |
  | WYANT     |  36 | 2018-03-25 | 2018-11-25 | broken  |
  | SHARYANTO |  33 | 2014-01-12 | 2014-08-24 | broken  |
  | PLICEASE  |  32 | 2015-10-11 | 2016-05-15 | broken  |
  | PLICEASE  |  32 | 2017-06-04 | 2018-01-07 | broken  |
  | ADAMK     |  31 | 2009-01-25 | 2009-08-23 | broken  |
  | PEVANS    |  31 | 2023-07-02 | 2024-01-28 | broken  |
  | PETDANCE  |  30 | 2003-10-05 | 2004-04-25 | broken  |
  | DAGOLDEN  |  30 | 2013-05-26 | 2013-12-15 | broken  |
  | PEVANS    |  30 | 2014-05-25 | 2014-12-14 | broken  |
  | KUERBIS   |  30 | 2014-10-26 | 2015-05-17 | broken  |
  | BOOK      |  30 | 2016-01-17 | 2016-08-07 | broken  |
  | KIMOTO    |  30 | 2018-01-14 | 2018-08-05 | broken  |
  | FELIPE    |  30 | 2019-10-27 | 2020-05-17 | broken  |
  | PLICEASE  |  29 | 2018-11-18 | 2019-06-02 | broken  |
  | EXODIST   |  28 | 2016-02-21 | 2016-08-28 | broken  |
  | AWNCORP   |  27 | 2012-01-01 | 2012-07-01 | broken  |
  | JHTHORSEN |  27 | 2013-07-07 | 2014-01-05 | broken  |
  | GFUJI     |  26 | 2008-04-06 | 2008-09-28 | broken  |
  | BINGOS    |  26 | 2010-01-31 | 2010-07-25 | broken  |
  | PEVANS    |  26 | 2010-10-31 | 2011-04-24 | broken  |
  | PEVANS    |  26 | 2012-01-22 | 2012-07-15 | broken  |
  | SHARYANTO |  26 | 2013-06-23 | 2013-12-15 | broken  |
  | BINARY    |  26 | 2014-05-25 | 2014-11-16 | broken  |
  | INGY      |  26 | 2014-10-19 | 2015-04-12 | broken  |
  | BKB       |  26 | 2020-12-06 | 2021-05-30 | broken  |
  | RJBS      |  25 | 2004-08-15 | 2005-01-30 | broken  |
  | ADAMK     |  25 | 2008-02-03 | 2008-07-20 | broken  |
  | BINGOS    |  25 | 2009-03-29 | 2009-09-13 | broken  |
  | DAGOLDEN  |  25 | 2012-11-25 | 2013-05-12 | broken  |
  | YANICK    |  25 | 2013-02-17 | 2013-08-04 | broken  |
  | CSSON     |  25 | 2014-11-23 | 2015-05-10 | broken  |
  | WYANT     |  25 | 2019-01-20 | 2019-07-07 | broken  |
  | WYANT     |  25 | 2019-12-01 | 2020-05-17 | broken  |
  | PEVANS    |  25 | 2021-06-13 | 2021-11-28 | broken  |
  | SMUELLER  |  24 | 2008-08-24 | 2009-02-01 | broken  |
  | DAGOLDEN  |  24 | 2010-01-10 | 2010-06-20 | broken  |
  | AVAR      |  24 | 2010-02-07 | 2010-07-18 | broken  |
  | MIYAGAWA  |  24 | 2013-01-20 | 2013-06-30 | broken  |
  | LEONT     |  24 | 2013-07-07 | 2013-12-15 | broken  |
  | KIMOTO    |  24 | 2017-06-11 | 2017-11-19 | broken  |
  | ADAMK     |  23 | 2007-06-17 | 2007-11-18 | broken  |
  | BINGOS    |  23 | 2007-10-14 | 2008-03-16 | broken  |
  | NUFFIN    |  23 | 2008-05-25 | 2008-10-26 | broken  |
  | FAYLAND   |  23 | 2009-02-01 | 2009-07-05 | broken  |
  | JETTERO   |  23 | 2009-03-22 | 2009-08-23 | broken  |
  | BINGOS    |  23 | 2010-10-17 | 2011-03-20 | broken  |
  | SHARYANTO |  23 | 2012-05-20 | 2012-10-21 | broken  |
  | SHLOMIF   |  23 | 2012-08-19 | 2013-01-20 | broken  |
  | PLICEASE  |  23 | 2014-03-16 | 2014-08-17 | broken  |
  | PLICEASE  |  23 | 2015-04-12 | 2015-09-13 | broken  |
  | WOLDRICH  |  23 | 2018-11-25 | 2019-04-28 | broken  |
  | UTASHIRO  |  23 | 2021-07-25 | 2021-12-26 | broken  |
  | LEONT     |  23 | 2022-12-25 | 2023-05-28 | broken  |
  | RJBS      |  22 | 2006-04-09 | 2006-09-03 | broken  |
  | MLEHMANN  |  22 | 2008-03-02 | 2008-07-27 | broken  |
  | INGY      |  22 | 2014-05-11 | 2014-10-05 | broken  |
  | PREACTION |  22 | 2014-11-16 | 2015-04-12 | broken  |
  | ZDM       |  22 | 2019-01-20 | 2019-06-16 | broken  |
  | AWNCORP   |  22 | 2020-02-09 | 2020-07-05 | broken  |
  | AUTRIJUS  |  21 | 2004-08-22 | 2005-01-09 | broken  |
  | ADAMK     |  21 | 2005-03-06 | 2005-07-24 | broken  |
  | ADAMK     |  21 | 2005-10-30 | 2006-03-19 | broken  |
  | BOBTFISH  |  21 | 2009-03-08 | 2009-07-26 | broken  |
  | GPHAT     |  21 | 2011-09-04 | 2012-01-22 | broken  |
  | JKEGL     |  21 | 2012-04-22 | 2012-09-09 | broken  |
  | BOOK      |  21 | 2015-04-12 | 2015-08-30 | broken  |
  | PREACTION |  21 | 2017-07-30 | 2017-12-17 | broken  |
  | TOBYINK   |  21 | 2019-10-13 | 2020-03-01 | broken  |
  | PEVANS    |  21 | 2020-02-16 | 2020-07-05 | broken  |
  | MLEHMANN  |  20 | 2007-09-16 | 2008-01-27 | broken  |
  | DROLSKY   |  20 | 2008-08-17 | 2008-12-28 | broken  |
  | MLEHMANN  |  20 | 2008-09-14 | 2009-01-25 | broken  |
  | ADAMK     |  20 | 2009-11-15 | 2010-03-28 | broken  |
  | MLEHMANN  |  20 | 2010-10-10 | 2011-02-20 | broken  |
  | REEDFISH  |  20 | 2016-07-17 | 2016-11-27 | broken  |
  | ZDM       |  20 | 2017-06-18 | 2017-10-29 | broken  |
  | RENEEB    |  20 | 2018-11-18 | 2019-03-31 | broken  |
  | UTASHIRO  |  20 | 2022-12-11 | 2023-04-23 | broken  |
  +-----------+-----+------------+------------+---------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
