package Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-02-01'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240201.0'; # VERSION

use Acme::CPANAuthors::Register (
    'PERLANCAR' => '',
    'ETHER' => '',
    'PEVANS' => '',
    'BDFOY' => '',
    'KUERBIS' => '',
    'NLNETLABS' => '',
    'VVELOX' => '',
    'TINITA' => '',
    'OLIVER' => '',
    'SANKO' => '',
    'TIMLEGGE' => '',
    'KARASIK' => '',
    'CRLCU' => '',
    'DAMI' => '',
    'JIMAVERA' => '',
    'SISYPHUS' => '',
    'DCANTRELL' => '',
    'LEONT' => '',
    'SHLOMIF' => '',
    'WYANT' => '',
    'DDICK' => '',
    'GARU' => '',
    'RKAPL' => '',
    'ABALAMA' => '',
    'ARISTOTLE' => '',
    'BKB' => '',
    'JMATES' => '',
    'JV' => '',
    'KIMOTO' => '',
    'LEEJO' => '',
    'MATHIAS' => '',
    'OALDERS' => '',
    'SKIM' => '',
    'TURNERJW' => '',
    'UTASHIRO' => '',
    'ABH' => '',
    'ANELSON' => '',
    'ASLEWIS' => '',
    'BIGPRESH' => '',
    'CGPAN' => '',
    'CHEVALIER' => '',
    'DAVECROSS' => '',
    'DEXTER' => '',
    'DOMM' => '',
    'DSKOLL' => '',
    'EZIMUEL' => '',
    'FSEITZ' => '',
    'GENE' => '',
    'GNUSTAVO' => '',
    'GSG' => '',
    'GUILLEM' => '',
    'IKEGAMI' => '',
    'ISHIGAKI' => '',
    'JEFFA' => '',
    'JUERD' => '',
    'LION' => '',
    'LNATION' => '',
    'MBRADSHAW' => '',
    'MSCHOUT' => '',
    'MSIMERSON' => '',
    'NJFRANCK' => '',
    'OLEG' => '',
    'RJET' => '',
    'SALVA' => '',
    'SHOGO' => '',
    'SULLR' => '',
    'TEAM' => '',
    'VOEGELAS' => '',
    'VOLKENING' => '',
    'WSNYDER' => '',
    'XMOLEX' => '',
    'AJNN' => '',
    'ASPOSE' => '',
    'ATRODO' => '',
    'BIGFOOT' => '',
    'BINGOS' => '',
    'BPS' => '',
    'DERF' => '',
    'DERIV' => '',
    'ETJ' => '',
    'EXIFTOOL' => '',
    'GHE' => '',
    'GLLORE' => '',
    'HOCHSTEN' => '',
    'JDEGUEST' => '',
    'JRM' => '',
    'MANWAR' => '',
    'NHORNE' => '',
    'SYBER' => '',
    'TANIGUCHI' => '',
);


1;
# ABSTRACT: Authors with ongoing weekly releases streak (do a release every week)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current - Authors with ongoing weekly releases streak (do a release every week)

=head1 VERSION

This document describes version 20240201.0 of Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-02-01.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-02-01, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | PERLANCAR | 493 | 2014-08-24 | ongoing     |
  | ETHER     |  97 | 2022-03-20 | might-break |
  | PEVANS    |  31 | 2023-07-02 | ongoing     |
  | BDFOY     |  14 | 2023-10-29 | ongoing     |
  | KUERBIS   |   6 | 2023-12-17 | might-break |
  | NLNETLABS |   5 | 2023-12-24 | might-break |
  | VVELOX    |   5 | 2023-12-24 | might-break |
  | TINITA    |   5 | 2023-12-31 | ongoing     |
  | OLIVER    |   4 | 2023-12-31 | might-break |
  | SANKO     |   4 | 2023-12-31 | might-break |
  | TIMLEGGE  |   4 | 2023-12-31 | might-break |
  | KARASIK   |   4 | 2024-01-07 | ongoing     |
  | CRLCU     |   3 | 2024-01-07 | might-break |
  | DAMI      |   3 | 2024-01-07 | might-break |
  | JIMAVERA  |   3 | 2024-01-07 | might-break |
  | SISYPHUS  |   3 | 2024-01-07 | might-break |
  | DCANTRELL |   3 | 2024-01-14 | ongoing     |
  | LEONT     |   3 | 2024-01-14 | ongoing     |
  | SHLOMIF   |   3 | 2024-01-14 | ongoing     |
  | WYANT     |   3 | 2024-01-14 | ongoing     |
  | DDICK     |   2 | 2024-01-14 | might-break |
  | GARU      |   2 | 2024-01-14 | might-break |
  | RKAPL     |   2 | 2024-01-14 | might-break |
  | ABALAMA   |   2 | 2024-01-21 | ongoing     |
  | ARISTOTLE |   2 | 2024-01-21 | ongoing     |
  | BKB       |   2 | 2024-01-21 | ongoing     |
  | JMATES    |   2 | 2024-01-21 | ongoing     |
  | JV        |   2 | 2024-01-21 | ongoing     |
  | KIMOTO    |   2 | 2024-01-21 | ongoing     |
  | LEEJO     |   2 | 2024-01-21 | ongoing     |
  | MATHIAS   |   2 | 2024-01-21 | ongoing     |
  | OALDERS   |   2 | 2024-01-21 | ongoing     |
  | SKIM      |   2 | 2024-01-21 | ongoing     |
  | TURNERJW  |   2 | 2024-01-21 | ongoing     |
  | UTASHIRO  |   2 | 2024-01-21 | ongoing     |
  | ABH       |   1 | 2024-01-21 | might-break |
  | ANELSON   |   1 | 2024-01-21 | might-break |
  | ASLEWIS   |   1 | 2024-01-21 | might-break |
  | BIGPRESH  |   1 | 2024-01-21 | might-break |
  | CGPAN     |   1 | 2024-01-21 | might-break |
  | CHEVALIER |   1 | 2024-01-21 | might-break |
  | DAVECROSS |   1 | 2024-01-21 | might-break |
  | DEXTER    |   1 | 2024-01-21 | might-break |
  | DOMM      |   1 | 2024-01-21 | might-break |
  | DSKOLL    |   1 | 2024-01-21 | might-break |
  | EZIMUEL   |   1 | 2024-01-21 | might-break |
  | FSEITZ    |   1 | 2024-01-21 | might-break |
  | GENE      |   1 | 2024-01-21 | might-break |
  | GNUSTAVO  |   1 | 2024-01-21 | might-break |
  | GSG       |   1 | 2024-01-21 | might-break |
  | GUILLEM   |   1 | 2024-01-21 | might-break |
  | IKEGAMI   |   1 | 2024-01-21 | might-break |
  | ISHIGAKI  |   1 | 2024-01-21 | might-break |
  | JEFFA     |   1 | 2024-01-21 | might-break |
  | JUERD     |   1 | 2024-01-21 | might-break |
  | LION      |   1 | 2024-01-21 | might-break |
  | LNATION   |   1 | 2024-01-21 | might-break |
  | MBRADSHAW |   1 | 2024-01-21 | might-break |
  | MSCHOUT   |   1 | 2024-01-21 | might-break |
  | MSIMERSON |   1 | 2024-01-21 | might-break |
  | NJFRANCK  |   1 | 2024-01-21 | might-break |
  | OLEG      |   1 | 2024-01-21 | might-break |
  | RJET      |   1 | 2024-01-21 | might-break |
  | SALVA     |   1 | 2024-01-21 | might-break |
  | SHOGO     |   1 | 2024-01-21 | might-break |
  | SULLR     |   1 | 2024-01-21 | might-break |
  | TEAM      |   1 | 2024-01-21 | might-break |
  | VOEGELAS  |   1 | 2024-01-21 | might-break |
  | VOLKENING |   1 | 2024-01-21 | might-break |
  | WSNYDER   |   1 | 2024-01-21 | might-break |
  | XMOLEX    |   1 | 2024-01-21 | might-break |
  | AJNN      |   1 | 2024-01-28 | ongoing     |
  | ASPOSE    |   1 | 2024-01-28 | ongoing     |
  | ATRODO    |   1 | 2024-01-28 | ongoing     |
  | BIGFOOT   |   1 | 2024-01-28 | ongoing     |
  | BINGOS    |   1 | 2024-01-28 | ongoing     |
  | BPS       |   1 | 2024-01-28 | ongoing     |
  | DERF      |   1 | 2024-01-28 | ongoing     |
  | DERIV     |   1 | 2024-01-28 | ongoing     |
  | ETJ       |   1 | 2024-01-28 | ongoing     |
  | EXIFTOOL  |   1 | 2024-01-28 | ongoing     |
  | GHE       |   1 | 2024-01-28 | ongoing     |
  | GLLORE    |   1 | 2024-01-28 | ongoing     |
  | HOCHSTEN  |   1 | 2024-01-28 | ongoing     |
  | JDEGUEST  |   1 | 2024-01-28 | ongoing     |
  | JRM       |   1 | 2024-01-28 | ongoing     |
  | MANWAR    |   1 | 2024-01-28 | ongoing     |
  | NHORNE    |   1 | 2024-01-28 | ongoing     |
  | SYBER     |   1 | 2024-01-28 | ongoing     |
  | TANIGUCHI |   1 | 2024-01-28 | ongoing     |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
