package Acme::CPANAuthors::Japanese;

use strict;
use warnings;

our $VERSION = '0.101014';

use Acme::CPANAuthors::Register (
    AERDAN    => 'Kiyoshi Aman',
    AGREW     => 'Naoyuki Okumura',
    AHIROSE   => 'Akira HIROSE',
    AKIHITO   => 'Akihito Takeda',
    AKIRA     => 'Akira Hangai',
    AKOBA     => 'Atsushi Kobayashi',
    AMARISAN  => 'Ryoji Tanida',
    AQL       => 'Tetsuya Toyoda',
    ARISAWA   => 'Kosuke Arisawa',
    ARUTEIDO  => 'satoshi ishikawa',
    ASAKURA   => 'ASAKURA Takuji',
    ASARIH    => 'Hiro Asari',
    ASKADNA   => 'Shinichiro Aska',
    BANB      => 'ITO Nobuaki',
    BASHI     => 'Toshimasa Ishibashi',
    BAYASHI   => 'Dai Okabayashi',
    BAYSIDE   => 'Jun Shimizu',
    BOBPP     => 'Tadashi Matsuda',
    BOKUTIN   => 'Tomohiro Hosaka',
    BONAR     => 'Nakano Kyohei',
    BOXPHERE  => 'Satoshi Ohkubo',
    CHIBA     => 'Masahiro Chiba',
    CLAIRVY   => 'NAGAYA Shinichiro',
    COHTAN    => 'Kota Sakoda',
    DAIBA     => 'DAIBA, Keiichi',
    DAMEO     => 'Takashi Higashigata',
    DANJOU    => 'Nobuo Danjou',
    DANKOGAI  => 'Dan Kogai',
    DGSCOPE   => 'Masayuki Komori',
    DMAKI     => 'Daisuke Maki',
    DRAWNBOY  => 'Hideaki Tanaka',
    FUJIMURA  => 'FUJIMURA Yuki',
    FUJIWARA  => 'Fujiwara Shunichiro',
    FUKUDA    => 'Keisuke Fukuda',
    FUTAYA    => 'Satoshi Futaya',
    GAOU      => 'Kazuharu Arakawa',
    GFUJI     => 'Goro Fuji',
    GUNYA     => 'GUNYARA-KUN',
    HAMANO    => 'Tsukasa Hamano',
    HAOYAYOI  => 'Soshi Tamura',
    HATA      => 'Masanori HATA',
    HAYASHI   => 'Hiroo HAYASHI',
    HEDWIG    => 'Yusuke Sugiyama',
    HHORIUCHI => 'Hiroki Horiuchi',
    HIDE      => 'Hideo Kimura',
    HIGU      => 'Higuchi hiroyuki',
    HIKARINE  => 'Hajime Kurita',
    HIMAZU    => 'Hideyo Imazu',
    HIO       => 'YAMASHINA Hio',
    HIRAFOO   => 'Tomoya Hirano',
    HIRATA    => 'HIRATA Yasuyuki',
    HIRATARA  => 'Masahiro Honma',
    HIRO      => 'hiroshi kitano',
    HIROSE    => 'HIROSE Masaaki',
    HIROYUKI  => 'Hiroyuki Yamanaka',
    HIROYUKIM => 'Yamanaka Hiroyuki',
    HRYK      => 'Hiroyuki Nakamura',
    HKOBA     => 'KOBAYASI, Hiroaki',
    HOLLY     => 'Akira Horimoto',
    HORIUCHI  => 'Yasuhiro Horiuchi',
    ICHI      => 'Takuya Ichikawa',
    IHARA     => 'Ikuhiro IHARA',
    IKEBE     => 'IKEBE Tomohiro',
    IKEGAMI   => 'ikegami',
    IKUTA     => 'Masahito Ikuta',
    INA       => 'INABA Hitoshi',
    ISHIGAKI  => 'Kenichi Ishigaki',
    ISOYA     => 'Ryohei Isoya',
    ISSM      => 'IWATA, Susumu',
    ITWARRIOR => 'Hitoshi Amano',
    JIRO      => 'Jiro Nishiguchi',
    JKONDO    => 'Junya Kondo',
    JUNICHIRO => 'Junichiro Tobe',
    KAMIPO    => 'Ryuta Kamizono',
    KAMO      => 'Yoshikazu Kamoshida',
    KAWABATA  => 'KAWABATA Kazumichi',
    KAWASAKI  => 'Kawasaki Yusuke',
    KAZEBURO  => 'Masahiro Nagano',
    KAZUHO    => 'Kazuho Oku',
    KEISUKE   => 'Keisuke Kuramata',
    KENJIRO   => 'Kenjiro Hirakawa',
    KENTARO   => 'Kentaro Kuribayashi',
    KIMOTO    => 'Yuki Kimoto',
    KIMURA    => 'Takeshi Kimura',
    KINSAN    => 'Hitoshi Yokozawa',
    KITAMAKI  => 'ryo kitamaki',
    KMIYAZAKI => 'Keitaro Miyazaki',
    KNAGANO   => 'Keiichiro Nagano',
    KNOK      => 'NOKUBI Takatsugu',
    KOBAYASHI => 'Takeshi Kobayashi',
    KOBAYASI  => 'Hiroyuki Kobayasi',
    KOGA      => 'Seiki Koga',
    KOJUN     => 'Kojun Ueno',
    KOKOGIKO  => 'OHTSUKA Ko-hei',
    KONDO     => 'Yoshiyuki KONDO',
    KOYACHI   => 'Tsutomu Koyachi',
    KTAKATA   => 'Ken Takata',
    KTAT      => 'Kato Atsushi',
    KUBOTA    => 'Tomohiro KUBOTA',
    KUMA      => 'KUMAGAI Kentaro',
    KUNIYOSHI => 'Kuniyoshi Kouji',
    KURIHARA  => 'Yoshiki KURIHARA',
    KURIYAMA  => 'Jun Kuriyama',
    KUZUHA    => 'Kuzuha SHINODA',
    KWITKNR   => 'KAWAI, Takanori',
    KYANNY    => 'Kensuke Kaneko',
    KYO       => 'Kyo Nagashima',
    KYOMAIODP => 'Kyoma Takahashi',
    KYORO     => 'Kyosuke INOUE',
    KZFM      => 'Kazufumi Ohkawa',
    KZTOMITA  => 'Kazuyoshi Tomita',
    LUSHE     => 'Masatoshi Mizuno',
    LYOKATO   => 'Lyo Kato',
    MAHITO    => 'Hogelist',
    MAIDO     => 'Masahiro Funakoshi',
    MAKAMAKA  => 'Makamaka Hannyaharamitu',
    MAKOTO    => 'Shin Honda',
    MAOE      => 'Mitsutoshi Aoe',
    MASAHITO  => 'Masahito Yoshida',
    MASAKI    => 'NAKAGAWA Masaki',
    MASANORIH => 'Masanori Hara',
    MASAP     => 'Masahiro Funakoshi',
    MATSUMOTO => 'syushi matsumoto',
    MATTN     => 'Yasuhiro Matsumoto',
    MIKAGE    => 'SANO Taku',
    MIKI      => 'Takeshi Miki',
    MIKIHOSHI => 'KAN Fushihara',
    MIKIO     => 'Mikio Hirabayashi',
    MILANO    => 'Tsukui Akihiro',
    MINORU    => 'KAWAMOTO Minoru',
    MIYAGAWA  => 'Tatsuhiko Miyagawa',
    MIYAMUKO  => 'MIYAMUKO Katsuyuki',
    MIYAZAKI  => 'Ittetsu Miyazaki',
    MIZZY     => 'Gosuke Miyashita',
    MORIYA    => 'Moriya Masaki',
    MURATA    => 'Shingo Murata',
    MYUJI     => 'Yuji Maeda',
    NABESHIMA => 'Masaaki NABESHIMA',
    NAITO     => 'Naoyuki Ito',
    NANZOU    => 'Takaaki Mizuno',
    NAOKIURAI => 'Naoki URAI',
    NAOYA     => 'Naoya Ito',
    NAOYAT    => 'Naoya "naochan" Tozuka',
    NAOYUKI   => 'Naoyuki Ito',
    NARUSE    => 'NARUSE, Yui',
    NEJIGANE  => 'Yu Nejigane',
    NEKOKAK   => 'Atsushi Kobayashi',
    NEKOYA    => 'Ryo Miyake',
    NEZUMI    => 'IKEDA Soji',
    NGS       => 'Atsushi NAGASE',
    NISHIGAYA => 'NISHIGAYA, Yuki',
    NISHIKAWA => 'Kazuhiro Nishikawa',
    NOZZZZZ   => 'Tetsunari Nozaki',
    NTSUTSUMI => 'Naoya Tsutsumi',
    NYARLA    => 'Naoki Okamura',
    OINUME    => 'Kazuhiro Oinuma',
    OISHI     => 'Eisuke Oishi',
    OUEST     => 'Daisuke NISHISAKA',
    OYAMA     => 'Hiroyuki OYAMA',
    OZAWA     => 'OZAWA Sakuro',
    PAINA     => 'SATO Taisuke',
    PEN       => 'Abe Masahiro',
    PIA       => 'Michiya Honda',
    POCKET    => 'Masato Sogame',
    POPPEN    => 'Shinsuke Matsui',
    QUEEN     => 'Yasuhiro Miyazaki',
    RINTARO   => 'Rintaro Ishizaki',
    RIYWO     => 'Ryosuke IWANAGA',
    RYOCHIN   => 'Okamoto RYO',
    SADAHIRO  => 'SADAHIRO Tomoyuki',
    SASAO     => 'SASAO Takahiro',
    SASAZUKA  => 'Seiji Sasazuka',
    SATOH     => 'cho45 (SATOH, Hiroh)',
    SAYANO    => 'Satoru Yano',
    SEKIMURA  => 'Masayoshi Sekimura',
    SERA      => 'Kazuhiro Sera',
    SEYN      => 'Yasushi Nakajima',
    SHIBUYA   => 'Kazuhiro Shibuya',
    SHIGETA   => 'Takatsugu Shigeta',
    SHIGIO    => 'Shigio Yamaguchi',
    SHIKONO   => 'Shinji KONO',
    SHIMAZU   => 'Yuki SHIMAZU',
    SHIMI     => 'Kazuhito Shimizu',
    SHINPEI   => 'HAYASHI, Shinpei',
    SHIRAIWA  => 'Kazuma Shiraiwa',
    SHOT      => 'Shota Takayama',
    SKONNO    => 'Satoshi Konno',
    SKUBOTA   => 'Satoshi KUBOTA',
    SNGJOKEN  => 'Shingo Kikugawa',
    SONGMU    => 'Masayuki Matsuki',
    SUGMAK    => 'Makoto Sugiyama',
    SUZUKI    => 'Yuji Suzuki',
    SYNCLOVER => 'Naoya Sato',
    TAIY      => 'Taisuke Yamada',
    TAKASHI   => 'Takashi Saeki',
    TAKAYUKI  => 'Takayuki Ikeda',
    TAKEFUMI  => 'KIMURA, takefumi',
    TAKEO     => 'Takeo Suzuki',
    TAKERU    => 'Takeru INOUE',
    TAKESAKO  => 'Yoshinori TAKESAKO',
    TAKESHIGE => 'Ken Takeshige',
    TAKKYUN   => 'Takayuki Ikeda',
    TAMAKOTO  => 'Tanaka Makoto',
    TAMASHIRO => 'Yuji Tamashiro',
    TANABE    => 'Hisao Tanabe',
    TANIGUCHI => 'Koichi Taniguchi',
    TANIMOTO  => 'Satoshi Tanimoto',
    TARO      => 'Daisuke Komatsu',
    TAROK     => 'Taro Kawagishi',
    TATENO    => 'Yuichi Tateno',
    TAWAN     => 'Taro Funaki',
    THORIKAWA => 'Takahiro Horikawa',
    TKURITA   => 'Tetsuro KURITA',
    TMAESAKA  => 'Toru Maesaka',
    TOCIYUKI  => 'MIZUTANI, Tociyuki',
    TOKUHIROM => 'MATSUNO Tokuhiro',
    TOMITA    => 'Naoki Tomita',
    TOMYHERO  => 'Tomohiro Teranishi',
    TONODERA  => 'Takahiro Onodera',
    TOONA     => 'Naoto Ishikawa',
    TOPIA     => 'Tatuya Noda',
    TORU      => 'Toru Hisai',
    TOSHIFJW  => 'Toshimitsu FUJIWARA',
    TRAVAIL   => 'Tomoyuki SAWA',
    TSUCCHI   => 'Takuya Tsuchida',
    TSUKAMOTO => 'Makio Tsukamoto',
    TSUNODA   => 'TSUNODA Kazuya',
    TURUGINA  => 'KATOU Akira',
    TYANO     => 'Tatsuhiro YANO',
    TYPESTER  => 'Daisuke Murase',
    UMEMOTO   => 'Hajimu Umemoto',
    USUALOMA  => 'Taku Amano',
    WATANABE  => 'WATANABE Hirofumi',
    WOREMACX  => 'Wore Macx',
    XAICRON   => 'Yuji Shimada',
    XOR       => 'Izumi Kawashima',
    XCEZX     => 'Tsuyoshi Maekawa',
    YAMAMOTO  => 'Ryuzo Yamamoto',
    YAMATO    => 'Toshiyuki Yamato',
    YANA      => 'Toshimitu Yanagisawa',
    YANMAR    => 'Yamamoto Keiichiro',
    YAPPO     => 'Kazuhiro Osawa',
    YASU      => 'Yasushi Saito',
    YASUHIRO  => 'Yasuhiro Onishi',
    YIBE      => 'Yuki Ibe',
    YOSHIDA   => 'Hironori Yoshida',
    YOSHIMI   => 'Keiji Yoshimi',
    YOSTY     => 'Koji Komatsu',
    YSAS      => 'Yasuhiro Sasama',
    YSASAKI   => 'Yoshihiro Sasaki',
    YSUZUKI   => 'Yoshihiro SUZUKI',
    YTURTLE   => 'Satoshi Azuma',
    YUKI      => 'Yuki ANAI',
    YUKINOBU  => 'NAGAYASU Yukinobu',
    YUKIO     => 'Yukio Suzuki',
    YOKKUNS   => 'Yohei Sato',
    YUPUG     => 'Yu Isobe',
    YUSUKE    => 'Yusuke Shibata',
    YUSUKEBE  => 'Yusuke Wada',
    YUTA      => 'MASUDA Yuta',
    YUYAW     => 'Yuya Watanabe',
    ZENTOOO   => 'Naosuke Yokoe',
    ZIGOROU   => 'Toru Yamaguchi',
    ZIGUZAGU  => 'Hiroshi Sakai',
);

1;

__END__

=head1 NAME

Acme::CPANAuthors::Japanese - We are Japanese CPAN authors

=head1 DESCRIPTION

This class provides a hash of Japanese CPAN authors' Pause ID/name to Acme::CPANAuthors.

=head1 MAINTENANCE

If you are a Japanese CPAN author not listed here, come CodeRepos to add your own id/name. If you are listed but are not Japanese (or just don't want to be listed), sorry to bother you but tell me via email, IRC, or RT. I'll remove.

=head1 SVN REPOSITORY

http://svn.coderepos.org/share/lang/perl/Acme-CPANAuthors-Japanese/

=head1 AUTHOR

Kenichi Ishigaki, E<lt>ishigaki at cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2007 by Kenichi Ishigaki.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut
