use utf8;

package SemanticWeb::Schema::SolveMathAction;

# ABSTRACT: The action that takes in a math expression and directs users to a page potentially capable of solving/simplifying that expression.

use v5.14;
use Moo;

extends qw/ SemanticWeb::Schema::Action /;


use MooX::JSON_LD 'SolveMathAction';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v21.0.1';


has edu_question_type => (
    is        => 'rw',
    predicate => '_has_edu_question_type',
    json_ld   => 'eduQuestionType',
);





1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::SolveMathAction - The action that takes in a math expression and directs users to a page potentially capable of solving/simplifying that expression.

=head1 VERSION

version v21.0.1

=head1 DESCRIPTION

The action that takes in a math expression and directs users to a page
potentially capable of solving/simplifying that expression.

=head1 ATTRIBUTES

=head2 C<edu_question_type>

C<eduQuestionType>

For questions that are part of learning resources (e.g. Quiz),
eduQuestionType indicates the format of question being given. Example:
"Multiple choice", "Open ended", "Flashcard".

A edu_question_type should be one of the following types:

=over

=item C<Str>

=back

=head2 C<_has_edu_question_type>

A predicate for the L</edu_question_type> attribute.

=head1 SEE ALSO

L<SemanticWeb::Schema::Action>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2023 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
