use strict;
use warnings;
use ExtUtils::MakeMaker;

our ($GSL_includes, $GSL_libs); 

sub gsl_sf_links_ok {
  my($lib,$inc) = @_;
  return defined($lib) && defined($inc) &&
  trylink('',
  << 'EOI',
#include <gsl/gsl_sf_bessel.h>
EOI
  << 'EOB', $lib, $inc);
  double x = 5.0;
  double expected = -0.17759677131433830434739701;
  double y = gsl_sf_bessel_J0 (x);
  return 0;
EOB
}

my $skip = 0;
my $msg = undef;
my $forcebuild=0;

if (defined $PDL::Config{WITH_GSL} && $PDL::Config{WITH_GSL}==0) {
  $msg = "Will skip build of PDL::GSLSF on this system\n";
  $skip = 1;
} elsif (defined $PDL::Config{WITH_GSL} && $PDL::Config{WITH_GSL}==1) {
  $forcebuild=1;
}

if (($skip && !$forcebuild) ||
    !gsl_sf_links_ok($GSL_libs, $GSL_includes)) {
  warn "trying to force GSL build but link test failed\n".
    "\t -- aborting GSL build\n" if $forcebuild;
  $msg .= "GSL Libraries not found... Skipping build of PDL::GSLSF.\n";
  write_dummy_make( $msg );
  return;
}

WriteMakefile(
	'NAME' => 'PDL::GSLSF',
	VERSION => '0.5',
	# VERSION_FROM => '../../Basic/PDL.pm',
       #DIR =>  [ qw/airy bessel chebyshev clausen coulomb coupling dawson debye dilog elementary ellint elljac erf exp expint fermi_dirac gamma gegenbauer hyperg laguerre legendre log poly pow_int psi synchrotron transport trig zeta/ ],
	NO_MYMETA => 1,
);
