use strict;
use warnings;
use MRO::Compat 'c3';

package WebService::Shippo::CustomsDeclaration;
use base (
    'WebService::Shippo::Resource',
    'WebService::Shippo::Creator',
    'WebService::Shippo::Fetcher',
);

sub api_resource ()     { 'customs/declarations' }
sub collection_class () { 'WebService::Shippo::CustomsDeclarations' }
sub item_class ()       { __PACKAGE__ }

package    # Hide from PAUSE
    WebService::Shippo::CustomsDeclarations;
use base ( 'WebService::Shippo::Collection' );
sub item_class ()       { 'WebService::Shippo::CustomsDeclaration' }
sub collection_class () { __PACKAGE__ }

BEGIN {
    no warnings 'once';
    # Forcing the dev to always use CPAN's perferred "WebService::Shippo"
    # namespace is just cruel; allow the use of "Shippo", too.
    *Shippo::CustomsDeclaration:: = *WebService::Shippo::CustomsDeclaration::;
    *Shippo::CustomsDeclarationList::
        = *WebService::Shippo::CustomsDeclarationList::;
}

1;
