package #
Date::Manip::TZ::pafiji00;
# Copyright (c) 2008-2020 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Mon Dec  2 09:44:58 EST 2019
#    Data version: tzdata2019c
#    Code version: tzcode2019c

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://ftp.iana.org/tz

use strict;
use warnings;
require 5.010000;

our (%Dates,%LastRule);
END {
   undef %Dates;
   undef %LastRule;
}

our ($VERSION);
$VERSION='6.81';
END { undef $VERSION; }

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,2,11,55,44],'+11:55:44',[11,55,44],
          'LMT',0,[1915,10,25,12,4,15],[1915,10,25,23,59,59],
          '0001010200:00:00','0001010211:55:44','1915102512:04:15','1915102523:59:59' ],
     ],
   1915 =>
     [
        [ [1915,10,25,12,4,16],[1915,10,26,0,4,16],'+12:00:00',[12,0,0],
          '+12',0,[1998,10,31,13,59,59],[1998,11,1,1,59,59],
          '1915102512:04:16','1915102600:04:16','1998103113:59:59','1998110101:59:59' ],
     ],
   1998 =>
     [
        [ [1998,10,31,14,0,0],[1998,11,1,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[1999,2,27,13,59,59],[1999,2,28,2,59,59],
          '1998103114:00:00','1998110103:00:00','1999022713:59:59','1999022802:59:59' ],
     ],
   1999 =>
     [
        [ [1999,2,27,14,0,0],[1999,2,28,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[1999,11,6,13,59,59],[1999,11,7,1,59,59],
          '1999022714:00:00','1999022802:00:00','1999110613:59:59','1999110701:59:59' ],
        [ [1999,11,6,14,0,0],[1999,11,7,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2000,2,26,13,59,59],[2000,2,27,2,59,59],
          '1999110614:00:00','1999110703:00:00','2000022613:59:59','2000022702:59:59' ],
     ],
   2000 =>
     [
        [ [2000,2,26,14,0,0],[2000,2,27,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2009,11,28,13,59,59],[2009,11,29,1,59,59],
          '2000022614:00:00','2000022702:00:00','2009112813:59:59','2009112901:59:59' ],
     ],
   2009 =>
     [
        [ [2009,11,28,14,0,0],[2009,11,29,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2010,3,27,13,59,59],[2010,3,28,2,59,59],
          '2009112814:00:00','2009112903:00:00','2010032713:59:59','2010032802:59:59' ],
     ],
   2010 =>
     [
        [ [2010,3,27,14,0,0],[2010,3,28,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2010,10,23,13,59,59],[2010,10,24,1,59,59],
          '2010032714:00:00','2010032802:00:00','2010102313:59:59','2010102401:59:59' ],
        [ [2010,10,23,14,0,0],[2010,10,24,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2011,3,5,13,59,59],[2011,3,6,2,59,59],
          '2010102314:00:00','2010102403:00:00','2011030513:59:59','2011030602:59:59' ],
     ],
   2011 =>
     [
        [ [2011,3,5,14,0,0],[2011,3,6,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2011,10,22,13,59,59],[2011,10,23,1,59,59],
          '2011030514:00:00','2011030602:00:00','2011102213:59:59','2011102301:59:59' ],
        [ [2011,10,22,14,0,0],[2011,10,23,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2012,1,21,13,59,59],[2012,1,22,2,59,59],
          '2011102214:00:00','2011102303:00:00','2012012113:59:59','2012012202:59:59' ],
     ],
   2012 =>
     [
        [ [2012,1,21,14,0,0],[2012,1,22,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2012,10,20,13,59,59],[2012,10,21,1,59,59],
          '2012012114:00:00','2012012202:00:00','2012102013:59:59','2012102101:59:59' ],
        [ [2012,10,20,14,0,0],[2012,10,21,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2013,1,19,13,59,59],[2013,1,20,2,59,59],
          '2012102014:00:00','2012102103:00:00','2013011913:59:59','2013012002:59:59' ],
     ],
   2013 =>
     [
        [ [2013,1,19,14,0,0],[2013,1,20,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2013,10,26,13,59,59],[2013,10,27,1,59,59],
          '2013011914:00:00','2013012002:00:00','2013102613:59:59','2013102701:59:59' ],
        [ [2013,10,26,14,0,0],[2013,10,27,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2014,1,18,12,59,59],[2014,1,19,1,59,59],
          '2013102614:00:00','2013102703:00:00','2014011812:59:59','2014011901:59:59' ],
     ],
   2014 =>
     [
        [ [2014,1,18,13,0,0],[2014,1,19,1,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2014,11,1,13,59,59],[2014,11,2,1,59,59],
          '2014011813:00:00','2014011901:00:00','2014110113:59:59','2014110201:59:59' ],
        [ [2014,11,1,14,0,0],[2014,11,2,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2015,1,17,13,59,59],[2015,1,18,2,59,59],
          '2014110114:00:00','2014110203:00:00','2015011713:59:59','2015011802:59:59' ],
     ],
   2015 =>
     [
        [ [2015,1,17,14,0,0],[2015,1,18,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2015,10,31,13,59,59],[2015,11,1,1,59,59],
          '2015011714:00:00','2015011802:00:00','2015103113:59:59','2015110101:59:59' ],
        [ [2015,10,31,14,0,0],[2015,11,1,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2016,1,16,13,59,59],[2016,1,17,2,59,59],
          '2015103114:00:00','2015110103:00:00','2016011613:59:59','2016011702:59:59' ],
     ],
   2016 =>
     [
        [ [2016,1,16,14,0,0],[2016,1,17,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2016,11,5,13,59,59],[2016,11,6,1,59,59],
          '2016011614:00:00','2016011702:00:00','2016110513:59:59','2016110601:59:59' ],
        [ [2016,11,5,14,0,0],[2016,11,6,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2017,1,14,13,59,59],[2017,1,15,2,59,59],
          '2016110514:00:00','2016110603:00:00','2017011413:59:59','2017011502:59:59' ],
     ],
   2017 =>
     [
        [ [2017,1,14,14,0,0],[2017,1,15,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2017,11,4,13,59,59],[2017,11,5,1,59,59],
          '2017011414:00:00','2017011502:00:00','2017110413:59:59','2017110501:59:59' ],
        [ [2017,11,4,14,0,0],[2017,11,5,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2018,1,13,13,59,59],[2018,1,14,2,59,59],
          '2017110414:00:00','2017110503:00:00','2018011313:59:59','2018011402:59:59' ],
     ],
   2018 =>
     [
        [ [2018,1,13,14,0,0],[2018,1,14,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2018,11,3,13,59,59],[2018,11,4,1,59,59],
          '2018011314:00:00','2018011402:00:00','2018110313:59:59','2018110401:59:59' ],
        [ [2018,11,3,14,0,0],[2018,11,4,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2019,1,12,13,59,59],[2019,1,13,2,59,59],
          '2018110314:00:00','2018110403:00:00','2019011213:59:59','2019011302:59:59' ],
     ],
   2019 =>
     [
        [ [2019,1,12,14,0,0],[2019,1,13,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2019,11,9,13,59,59],[2019,11,10,1,59,59],
          '2019011214:00:00','2019011302:00:00','2019110913:59:59','2019111001:59:59' ],
        [ [2019,11,9,14,0,0],[2019,11,10,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2020,1,11,13,59,59],[2020,1,12,2,59,59],
          '2019110914:00:00','2019111003:00:00','2020011113:59:59','2020011202:59:59' ],
     ],
   2020 =>
     [
        [ [2020,1,11,14,0,0],[2020,1,12,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2020,11,7,13,59,59],[2020,11,8,1,59,59],
          '2020011114:00:00','2020011202:00:00','2020110713:59:59','2020110801:59:59' ],
        [ [2020,11,7,14,0,0],[2020,11,8,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2021,1,16,13,59,59],[2021,1,17,2,59,59],
          '2020110714:00:00','2020110803:00:00','2021011613:59:59','2021011702:59:59' ],
     ],
   2021 =>
     [
        [ [2021,1,16,14,0,0],[2021,1,17,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2021,11,13,13,59,59],[2021,11,14,1,59,59],
          '2021011614:00:00','2021011702:00:00','2021111313:59:59','2021111401:59:59' ],
        [ [2021,11,13,14,0,0],[2021,11,14,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2022,1,15,13,59,59],[2022,1,16,2,59,59],
          '2021111314:00:00','2021111403:00:00','2022011513:59:59','2022011602:59:59' ],
     ],
   2022 =>
     [
        [ [2022,1,15,14,0,0],[2022,1,16,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2022,11,12,13,59,59],[2022,11,13,1,59,59],
          '2022011514:00:00','2022011602:00:00','2022111213:59:59','2022111301:59:59' ],
        [ [2022,11,12,14,0,0],[2022,11,13,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2023,1,14,13,59,59],[2023,1,15,2,59,59],
          '2022111214:00:00','2022111303:00:00','2023011413:59:59','2023011502:59:59' ],
     ],
   2023 =>
     [
        [ [2023,1,14,14,0,0],[2023,1,15,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2023,11,11,13,59,59],[2023,11,12,1,59,59],
          '2023011414:00:00','2023011502:00:00','2023111113:59:59','2023111201:59:59' ],
        [ [2023,11,11,14,0,0],[2023,11,12,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2024,1,13,13,59,59],[2024,1,14,2,59,59],
          '2023111114:00:00','2023111203:00:00','2024011313:59:59','2024011402:59:59' ],
     ],
   2024 =>
     [
        [ [2024,1,13,14,0,0],[2024,1,14,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2024,11,9,13,59,59],[2024,11,10,1,59,59],
          '2024011314:00:00','2024011402:00:00','2024110913:59:59','2024111001:59:59' ],
        [ [2024,11,9,14,0,0],[2024,11,10,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2025,1,11,13,59,59],[2025,1,12,2,59,59],
          '2024110914:00:00','2024111003:00:00','2025011113:59:59','2025011202:59:59' ],
     ],
   2025 =>
     [
        [ [2025,1,11,14,0,0],[2025,1,12,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2025,11,8,13,59,59],[2025,11,9,1,59,59],
          '2025011114:00:00','2025011202:00:00','2025110813:59:59','2025110901:59:59' ],
        [ [2025,11,8,14,0,0],[2025,11,9,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2026,1,17,13,59,59],[2026,1,18,2,59,59],
          '2025110814:00:00','2025110903:00:00','2026011713:59:59','2026011802:59:59' ],
     ],
   2026 =>
     [
        [ [2026,1,17,14,0,0],[2026,1,18,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2026,11,7,13,59,59],[2026,11,8,1,59,59],
          '2026011714:00:00','2026011802:00:00','2026110713:59:59','2026110801:59:59' ],
        [ [2026,11,7,14,0,0],[2026,11,8,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2027,1,16,13,59,59],[2027,1,17,2,59,59],
          '2026110714:00:00','2026110803:00:00','2027011613:59:59','2027011702:59:59' ],
     ],
   2027 =>
     [
        [ [2027,1,16,14,0,0],[2027,1,17,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2027,11,13,13,59,59],[2027,11,14,1,59,59],
          '2027011614:00:00','2027011702:00:00','2027111313:59:59','2027111401:59:59' ],
        [ [2027,11,13,14,0,0],[2027,11,14,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2028,1,15,13,59,59],[2028,1,16,2,59,59],
          '2027111314:00:00','2027111403:00:00','2028011513:59:59','2028011602:59:59' ],
     ],
   2028 =>
     [
        [ [2028,1,15,14,0,0],[2028,1,16,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2028,11,11,13,59,59],[2028,11,12,1,59,59],
          '2028011514:00:00','2028011602:00:00','2028111113:59:59','2028111201:59:59' ],
        [ [2028,11,11,14,0,0],[2028,11,12,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2029,1,13,13,59,59],[2029,1,14,2,59,59],
          '2028111114:00:00','2028111203:00:00','2029011313:59:59','2029011402:59:59' ],
     ],
   2029 =>
     [
        [ [2029,1,13,14,0,0],[2029,1,14,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2029,11,10,13,59,59],[2029,11,11,1,59,59],
          '2029011314:00:00','2029011402:00:00','2029111013:59:59','2029111101:59:59' ],
        [ [2029,11,10,14,0,0],[2029,11,11,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2030,1,12,13,59,59],[2030,1,13,2,59,59],
          '2029111014:00:00','2029111103:00:00','2030011213:59:59','2030011302:59:59' ],
     ],
   2030 =>
     [
        [ [2030,1,12,14,0,0],[2030,1,13,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2030,11,9,13,59,59],[2030,11,10,1,59,59],
          '2030011214:00:00','2030011302:00:00','2030110913:59:59','2030111001:59:59' ],
        [ [2030,11,9,14,0,0],[2030,11,10,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2031,1,11,13,59,59],[2031,1,12,2,59,59],
          '2030110914:00:00','2030111003:00:00','2031011113:59:59','2031011202:59:59' ],
     ],
   2031 =>
     [
        [ [2031,1,11,14,0,0],[2031,1,12,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2031,11,8,13,59,59],[2031,11,9,1,59,59],
          '2031011114:00:00','2031011202:00:00','2031110813:59:59','2031110901:59:59' ],
        [ [2031,11,8,14,0,0],[2031,11,9,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2032,1,17,13,59,59],[2032,1,18,2,59,59],
          '2031110814:00:00','2031110903:00:00','2032011713:59:59','2032011802:59:59' ],
     ],
   2032 =>
     [
        [ [2032,1,17,14,0,0],[2032,1,18,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2032,11,13,13,59,59],[2032,11,14,1,59,59],
          '2032011714:00:00','2032011802:00:00','2032111313:59:59','2032111401:59:59' ],
        [ [2032,11,13,14,0,0],[2032,11,14,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2033,1,15,13,59,59],[2033,1,16,2,59,59],
          '2032111314:00:00','2032111403:00:00','2033011513:59:59','2033011602:59:59' ],
     ],
   2033 =>
     [
        [ [2033,1,15,14,0,0],[2033,1,16,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2033,11,12,13,59,59],[2033,11,13,1,59,59],
          '2033011514:00:00','2033011602:00:00','2033111213:59:59','2033111301:59:59' ],
        [ [2033,11,12,14,0,0],[2033,11,13,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2034,1,14,13,59,59],[2034,1,15,2,59,59],
          '2033111214:00:00','2033111303:00:00','2034011413:59:59','2034011502:59:59' ],
     ],
   2034 =>
     [
        [ [2034,1,14,14,0,0],[2034,1,15,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2034,11,11,13,59,59],[2034,11,12,1,59,59],
          '2034011414:00:00','2034011502:00:00','2034111113:59:59','2034111201:59:59' ],
        [ [2034,11,11,14,0,0],[2034,11,12,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2035,1,13,13,59,59],[2035,1,14,2,59,59],
          '2034111114:00:00','2034111203:00:00','2035011313:59:59','2035011402:59:59' ],
     ],
   2035 =>
     [
        [ [2035,1,13,14,0,0],[2035,1,14,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2035,11,10,13,59,59],[2035,11,11,1,59,59],
          '2035011314:00:00','2035011402:00:00','2035111013:59:59','2035111101:59:59' ],
        [ [2035,11,10,14,0,0],[2035,11,11,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2036,1,12,13,59,59],[2036,1,13,2,59,59],
          '2035111014:00:00','2035111103:00:00','2036011213:59:59','2036011302:59:59' ],
     ],
   2036 =>
     [
        [ [2036,1,12,14,0,0],[2036,1,13,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2036,11,8,13,59,59],[2036,11,9,1,59,59],
          '2036011214:00:00','2036011302:00:00','2036110813:59:59','2036110901:59:59' ],
        [ [2036,11,8,14,0,0],[2036,11,9,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2037,1,17,13,59,59],[2037,1,18,2,59,59],
          '2036110814:00:00','2036110903:00:00','2037011713:59:59','2037011802:59:59' ],
     ],
   2037 =>
     [
        [ [2037,1,17,14,0,0],[2037,1,18,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2037,11,7,13,59,59],[2037,11,8,1,59,59],
          '2037011714:00:00','2037011802:00:00','2037110713:59:59','2037110801:59:59' ],
        [ [2037,11,7,14,0,0],[2037,11,8,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2038,1,16,13,59,59],[2038,1,17,2,59,59],
          '2037110714:00:00','2037110803:00:00','2038011613:59:59','2038011702:59:59' ],
     ],
   2038 =>
     [
        [ [2038,1,16,14,0,0],[2038,1,17,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2038,11,13,13,59,59],[2038,11,14,1,59,59],
          '2038011614:00:00','2038011702:00:00','2038111313:59:59','2038111401:59:59' ],
        [ [2038,11,13,14,0,0],[2038,11,14,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2039,1,15,13,59,59],[2039,1,16,2,59,59],
          '2038111314:00:00','2038111403:00:00','2039011513:59:59','2039011602:59:59' ],
     ],
   2039 =>
     [
        [ [2039,1,15,14,0,0],[2039,1,16,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2039,11,12,13,59,59],[2039,11,13,1,59,59],
          '2039011514:00:00','2039011602:00:00','2039111213:59:59','2039111301:59:59' ],
        [ [2039,11,12,14,0,0],[2039,11,13,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2040,1,14,13,59,59],[2040,1,15,2,59,59],
          '2039111214:00:00','2039111303:00:00','2040011413:59:59','2040011502:59:59' ],
     ],
   2040 =>
     [
        [ [2040,1,14,14,0,0],[2040,1,15,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2040,11,10,13,59,59],[2040,11,11,1,59,59],
          '2040011414:00:00','2040011502:00:00','2040111013:59:59','2040111101:59:59' ],
        [ [2040,11,10,14,0,0],[2040,11,11,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2041,1,12,13,59,59],[2041,1,13,2,59,59],
          '2040111014:00:00','2040111103:00:00','2041011213:59:59','2041011302:59:59' ],
     ],
   2041 =>
     [
        [ [2041,1,12,14,0,0],[2041,1,13,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2041,11,9,13,59,59],[2041,11,10,1,59,59],
          '2041011214:00:00','2041011302:00:00','2041110913:59:59','2041111001:59:59' ],
        [ [2041,11,9,14,0,0],[2041,11,10,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2042,1,11,13,59,59],[2042,1,12,2,59,59],
          '2041110914:00:00','2041111003:00:00','2042011113:59:59','2042011202:59:59' ],
     ],
   2042 =>
     [
        [ [2042,1,11,14,0,0],[2042,1,12,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2042,11,8,13,59,59],[2042,11,9,1,59,59],
          '2042011114:00:00','2042011202:00:00','2042110813:59:59','2042110901:59:59' ],
        [ [2042,11,8,14,0,0],[2042,11,9,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2043,1,17,13,59,59],[2043,1,18,2,59,59],
          '2042110814:00:00','2042110903:00:00','2043011713:59:59','2043011802:59:59' ],
     ],
   2043 =>
     [
        [ [2043,1,17,14,0,0],[2043,1,18,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2043,11,7,13,59,59],[2043,11,8,1,59,59],
          '2043011714:00:00','2043011802:00:00','2043110713:59:59','2043110801:59:59' ],
        [ [2043,11,7,14,0,0],[2043,11,8,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2044,1,16,13,59,59],[2044,1,17,2,59,59],
          '2043110714:00:00','2043110803:00:00','2044011613:59:59','2044011702:59:59' ],
     ],
   2044 =>
     [
        [ [2044,1,16,14,0,0],[2044,1,17,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2044,11,12,13,59,59],[2044,11,13,1,59,59],
          '2044011614:00:00','2044011702:00:00','2044111213:59:59','2044111301:59:59' ],
        [ [2044,11,12,14,0,0],[2044,11,13,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2045,1,14,13,59,59],[2045,1,15,2,59,59],
          '2044111214:00:00','2044111303:00:00','2045011413:59:59','2045011502:59:59' ],
     ],
   2045 =>
     [
        [ [2045,1,14,14,0,0],[2045,1,15,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2045,11,11,13,59,59],[2045,11,12,1,59,59],
          '2045011414:00:00','2045011502:00:00','2045111113:59:59','2045111201:59:59' ],
        [ [2045,11,11,14,0,0],[2045,11,12,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2046,1,13,13,59,59],[2046,1,14,2,59,59],
          '2045111114:00:00','2045111203:00:00','2046011313:59:59','2046011402:59:59' ],
     ],
   2046 =>
     [
        [ [2046,1,13,14,0,0],[2046,1,14,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2046,11,10,13,59,59],[2046,11,11,1,59,59],
          '2046011314:00:00','2046011402:00:00','2046111013:59:59','2046111101:59:59' ],
        [ [2046,11,10,14,0,0],[2046,11,11,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2047,1,12,13,59,59],[2047,1,13,2,59,59],
          '2046111014:00:00','2046111103:00:00','2047011213:59:59','2047011302:59:59' ],
     ],
   2047 =>
     [
        [ [2047,1,12,14,0,0],[2047,1,13,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2047,11,9,13,59,59],[2047,11,10,1,59,59],
          '2047011214:00:00','2047011302:00:00','2047110913:59:59','2047111001:59:59' ],
        [ [2047,11,9,14,0,0],[2047,11,10,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2048,1,11,13,59,59],[2048,1,12,2,59,59],
          '2047110914:00:00','2047111003:00:00','2048011113:59:59','2048011202:59:59' ],
     ],
   2048 =>
     [
        [ [2048,1,11,14,0,0],[2048,1,12,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2048,11,7,13,59,59],[2048,11,8,1,59,59],
          '2048011114:00:00','2048011202:00:00','2048110713:59:59','2048110801:59:59' ],
        [ [2048,11,7,14,0,0],[2048,11,8,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2049,1,16,13,59,59],[2049,1,17,2,59,59],
          '2048110714:00:00','2048110803:00:00','2049011613:59:59','2049011702:59:59' ],
     ],
   2049 =>
     [
        [ [2049,1,16,14,0,0],[2049,1,17,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2049,11,13,13,59,59],[2049,11,14,1,59,59],
          '2049011614:00:00','2049011702:00:00','2049111313:59:59','2049111401:59:59' ],
        [ [2049,11,13,14,0,0],[2049,11,14,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2050,1,15,13,59,59],[2050,1,16,2,59,59],
          '2049111314:00:00','2049111403:00:00','2050011513:59:59','2050011602:59:59' ],
     ],
   2050 =>
     [
        [ [2050,1,15,14,0,0],[2050,1,16,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2050,11,12,13,59,59],[2050,11,13,1,59,59],
          '2050011514:00:00','2050011602:00:00','2050111213:59:59','2050111301:59:59' ],
        [ [2050,11,12,14,0,0],[2050,11,13,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2051,1,14,13,59,59],[2051,1,15,2,59,59],
          '2050111214:00:00','2050111303:00:00','2051011413:59:59','2051011502:59:59' ],
     ],
   2051 =>
     [
        [ [2051,1,14,14,0,0],[2051,1,15,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2051,11,11,13,59,59],[2051,11,12,1,59,59],
          '2051011414:00:00','2051011502:00:00','2051111113:59:59','2051111201:59:59' ],
        [ [2051,11,11,14,0,0],[2051,11,12,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2052,1,13,13,59,59],[2052,1,14,2,59,59],
          '2051111114:00:00','2051111203:00:00','2052011313:59:59','2052011402:59:59' ],
     ],
   2052 =>
     [
        [ [2052,1,13,14,0,0],[2052,1,14,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2052,11,9,13,59,59],[2052,11,10,1,59,59],
          '2052011314:00:00','2052011402:00:00','2052110913:59:59','2052111001:59:59' ],
        [ [2052,11,9,14,0,0],[2052,11,10,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2053,1,11,13,59,59],[2053,1,12,2,59,59],
          '2052110914:00:00','2052111003:00:00','2053011113:59:59','2053011202:59:59' ],
     ],
   2053 =>
     [
        [ [2053,1,11,14,0,0],[2053,1,12,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2053,11,8,13,59,59],[2053,11,9,1,59,59],
          '2053011114:00:00','2053011202:00:00','2053110813:59:59','2053110901:59:59' ],
        [ [2053,11,8,14,0,0],[2053,11,9,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2054,1,17,13,59,59],[2054,1,18,2,59,59],
          '2053110814:00:00','2053110903:00:00','2054011713:59:59','2054011802:59:59' ],
     ],
   2054 =>
     [
        [ [2054,1,17,14,0,0],[2054,1,18,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2054,11,7,13,59,59],[2054,11,8,1,59,59],
          '2054011714:00:00','2054011802:00:00','2054110713:59:59','2054110801:59:59' ],
        [ [2054,11,7,14,0,0],[2054,11,8,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2055,1,16,13,59,59],[2055,1,17,2,59,59],
          '2054110714:00:00','2054110803:00:00','2055011613:59:59','2055011702:59:59' ],
     ],
   2055 =>
     [
        [ [2055,1,16,14,0,0],[2055,1,17,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2055,11,13,13,59,59],[2055,11,14,1,59,59],
          '2055011614:00:00','2055011702:00:00','2055111313:59:59','2055111401:59:59' ],
        [ [2055,11,13,14,0,0],[2055,11,14,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2056,1,15,13,59,59],[2056,1,16,2,59,59],
          '2055111314:00:00','2055111403:00:00','2056011513:59:59','2056011602:59:59' ],
     ],
   2056 =>
     [
        [ [2056,1,15,14,0,0],[2056,1,16,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2056,11,11,13,59,59],[2056,11,12,1,59,59],
          '2056011514:00:00','2056011602:00:00','2056111113:59:59','2056111201:59:59' ],
        [ [2056,11,11,14,0,0],[2056,11,12,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2057,1,13,13,59,59],[2057,1,14,2,59,59],
          '2056111114:00:00','2056111203:00:00','2057011313:59:59','2057011402:59:59' ],
     ],
   2057 =>
     [
        [ [2057,1,13,14,0,0],[2057,1,14,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2057,11,10,13,59,59],[2057,11,11,1,59,59],
          '2057011314:00:00','2057011402:00:00','2057111013:59:59','2057111101:59:59' ],
        [ [2057,11,10,14,0,0],[2057,11,11,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2058,1,12,13,59,59],[2058,1,13,2,59,59],
          '2057111014:00:00','2057111103:00:00','2058011213:59:59','2058011302:59:59' ],
     ],
   2058 =>
     [
        [ [2058,1,12,14,0,0],[2058,1,13,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2058,11,9,13,59,59],[2058,11,10,1,59,59],
          '2058011214:00:00','2058011302:00:00','2058110913:59:59','2058111001:59:59' ],
        [ [2058,11,9,14,0,0],[2058,11,10,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2059,1,11,13,59,59],[2059,1,12,2,59,59],
          '2058110914:00:00','2058111003:00:00','2059011113:59:59','2059011202:59:59' ],
     ],
   2059 =>
     [
        [ [2059,1,11,14,0,0],[2059,1,12,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2059,11,8,13,59,59],[2059,11,9,1,59,59],
          '2059011114:00:00','2059011202:00:00','2059110813:59:59','2059110901:59:59' ],
        [ [2059,11,8,14,0,0],[2059,11,9,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2060,1,17,13,59,59],[2060,1,18,2,59,59],
          '2059110814:00:00','2059110903:00:00','2060011713:59:59','2060011802:59:59' ],
     ],
   2060 =>
     [
        [ [2060,1,17,14,0,0],[2060,1,18,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2060,11,13,13,59,59],[2060,11,14,1,59,59],
          '2060011714:00:00','2060011802:00:00','2060111313:59:59','2060111401:59:59' ],
        [ [2060,11,13,14,0,0],[2060,11,14,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2061,1,15,13,59,59],[2061,1,16,2,59,59],
          '2060111314:00:00','2060111403:00:00','2061011513:59:59','2061011602:59:59' ],
     ],
   2061 =>
     [
        [ [2061,1,15,14,0,0],[2061,1,16,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2061,11,12,13,59,59],[2061,11,13,1,59,59],
          '2061011514:00:00','2061011602:00:00','2061111213:59:59','2061111301:59:59' ],
        [ [2061,11,12,14,0,0],[2061,11,13,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2062,1,14,13,59,59],[2062,1,15,2,59,59],
          '2061111214:00:00','2061111303:00:00','2062011413:59:59','2062011502:59:59' ],
     ],
   2062 =>
     [
        [ [2062,1,14,14,0,0],[2062,1,15,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2062,11,11,13,59,59],[2062,11,12,1,59,59],
          '2062011414:00:00','2062011502:00:00','2062111113:59:59','2062111201:59:59' ],
        [ [2062,11,11,14,0,0],[2062,11,12,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2063,1,13,13,59,59],[2063,1,14,2,59,59],
          '2062111114:00:00','2062111203:00:00','2063011313:59:59','2063011402:59:59' ],
     ],
   2063 =>
     [
        [ [2063,1,13,14,0,0],[2063,1,14,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2063,11,10,13,59,59],[2063,11,11,1,59,59],
          '2063011314:00:00','2063011402:00:00','2063111013:59:59','2063111101:59:59' ],
        [ [2063,11,10,14,0,0],[2063,11,11,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2064,1,12,13,59,59],[2064,1,13,2,59,59],
          '2063111014:00:00','2063111103:00:00','2064011213:59:59','2064011302:59:59' ],
     ],
   2064 =>
     [
        [ [2064,1,12,14,0,0],[2064,1,13,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2064,11,8,13,59,59],[2064,11,9,1,59,59],
          '2064011214:00:00','2064011302:00:00','2064110813:59:59','2064110901:59:59' ],
        [ [2064,11,8,14,0,0],[2064,11,9,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2065,1,17,13,59,59],[2065,1,18,2,59,59],
          '2064110814:00:00','2064110903:00:00','2065011713:59:59','2065011802:59:59' ],
     ],
   2065 =>
     [
        [ [2065,1,17,14,0,0],[2065,1,18,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2065,11,7,13,59,59],[2065,11,8,1,59,59],
          '2065011714:00:00','2065011802:00:00','2065110713:59:59','2065110801:59:59' ],
        [ [2065,11,7,14,0,0],[2065,11,8,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2066,1,16,13,59,59],[2066,1,17,2,59,59],
          '2065110714:00:00','2065110803:00:00','2066011613:59:59','2066011702:59:59' ],
     ],
   2066 =>
     [
        [ [2066,1,16,14,0,0],[2066,1,17,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2066,11,13,13,59,59],[2066,11,14,1,59,59],
          '2066011614:00:00','2066011702:00:00','2066111313:59:59','2066111401:59:59' ],
        [ [2066,11,13,14,0,0],[2066,11,14,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2067,1,15,13,59,59],[2067,1,16,2,59,59],
          '2066111314:00:00','2066111403:00:00','2067011513:59:59','2067011602:59:59' ],
     ],
   2067 =>
     [
        [ [2067,1,15,14,0,0],[2067,1,16,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2067,11,12,13,59,59],[2067,11,13,1,59,59],
          '2067011514:00:00','2067011602:00:00','2067111213:59:59','2067111301:59:59' ],
        [ [2067,11,12,14,0,0],[2067,11,13,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2068,1,14,13,59,59],[2068,1,15,2,59,59],
          '2067111214:00:00','2067111303:00:00','2068011413:59:59','2068011502:59:59' ],
     ],
   2068 =>
     [
        [ [2068,1,14,14,0,0],[2068,1,15,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2068,11,10,13,59,59],[2068,11,11,1,59,59],
          '2068011414:00:00','2068011502:00:00','2068111013:59:59','2068111101:59:59' ],
        [ [2068,11,10,14,0,0],[2068,11,11,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2069,1,12,13,59,59],[2069,1,13,2,59,59],
          '2068111014:00:00','2068111103:00:00','2069011213:59:59','2069011302:59:59' ],
     ],
   2069 =>
     [
        [ [2069,1,12,14,0,0],[2069,1,13,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2069,11,9,13,59,59],[2069,11,10,1,59,59],
          '2069011214:00:00','2069011302:00:00','2069110913:59:59','2069111001:59:59' ],
        [ [2069,11,9,14,0,0],[2069,11,10,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2070,1,11,13,59,59],[2070,1,12,2,59,59],
          '2069110914:00:00','2069111003:00:00','2070011113:59:59','2070011202:59:59' ],
     ],
   2070 =>
     [
        [ [2070,1,11,14,0,0],[2070,1,12,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2070,11,8,13,59,59],[2070,11,9,1,59,59],
          '2070011114:00:00','2070011202:00:00','2070110813:59:59','2070110901:59:59' ],
        [ [2070,11,8,14,0,0],[2070,11,9,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2071,1,17,13,59,59],[2071,1,18,2,59,59],
          '2070110814:00:00','2070110903:00:00','2071011713:59:59','2071011802:59:59' ],
     ],
   2071 =>
     [
        [ [2071,1,17,14,0,0],[2071,1,18,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2071,11,7,13,59,59],[2071,11,8,1,59,59],
          '2071011714:00:00','2071011802:00:00','2071110713:59:59','2071110801:59:59' ],
        [ [2071,11,7,14,0,0],[2071,11,8,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2072,1,16,13,59,59],[2072,1,17,2,59,59],
          '2071110714:00:00','2071110803:00:00','2072011613:59:59','2072011702:59:59' ],
     ],
   2072 =>
     [
        [ [2072,1,16,14,0,0],[2072,1,17,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2072,11,12,13,59,59],[2072,11,13,1,59,59],
          '2072011614:00:00','2072011702:00:00','2072111213:59:59','2072111301:59:59' ],
        [ [2072,11,12,14,0,0],[2072,11,13,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2073,1,14,13,59,59],[2073,1,15,2,59,59],
          '2072111214:00:00','2072111303:00:00','2073011413:59:59','2073011502:59:59' ],
     ],
   2073 =>
     [
        [ [2073,1,14,14,0,0],[2073,1,15,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2073,11,11,13,59,59],[2073,11,12,1,59,59],
          '2073011414:00:00','2073011502:00:00','2073111113:59:59','2073111201:59:59' ],
        [ [2073,11,11,14,0,0],[2073,11,12,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2074,1,13,13,59,59],[2074,1,14,2,59,59],
          '2073111114:00:00','2073111203:00:00','2074011313:59:59','2074011402:59:59' ],
     ],
   2074 =>
     [
        [ [2074,1,13,14,0,0],[2074,1,14,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2074,11,10,13,59,59],[2074,11,11,1,59,59],
          '2074011314:00:00','2074011402:00:00','2074111013:59:59','2074111101:59:59' ],
        [ [2074,11,10,14,0,0],[2074,11,11,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2075,1,12,13,59,59],[2075,1,13,2,59,59],
          '2074111014:00:00','2074111103:00:00','2075011213:59:59','2075011302:59:59' ],
     ],
   2075 =>
     [
        [ [2075,1,12,14,0,0],[2075,1,13,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2075,11,9,13,59,59],[2075,11,10,1,59,59],
          '2075011214:00:00','2075011302:00:00','2075110913:59:59','2075111001:59:59' ],
        [ [2075,11,9,14,0,0],[2075,11,10,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2076,1,11,13,59,59],[2076,1,12,2,59,59],
          '2075110914:00:00','2075111003:00:00','2076011113:59:59','2076011202:59:59' ],
     ],
   2076 =>
     [
        [ [2076,1,11,14,0,0],[2076,1,12,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2076,11,7,13,59,59],[2076,11,8,1,59,59],
          '2076011114:00:00','2076011202:00:00','2076110713:59:59','2076110801:59:59' ],
        [ [2076,11,7,14,0,0],[2076,11,8,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2077,1,16,13,59,59],[2077,1,17,2,59,59],
          '2076110714:00:00','2076110803:00:00','2077011613:59:59','2077011702:59:59' ],
     ],
   2077 =>
     [
        [ [2077,1,16,14,0,0],[2077,1,17,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2077,11,13,13,59,59],[2077,11,14,1,59,59],
          '2077011614:00:00','2077011702:00:00','2077111313:59:59','2077111401:59:59' ],
        [ [2077,11,13,14,0,0],[2077,11,14,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2078,1,15,13,59,59],[2078,1,16,2,59,59],
          '2077111314:00:00','2077111403:00:00','2078011513:59:59','2078011602:59:59' ],
     ],
   2078 =>
     [
        [ [2078,1,15,14,0,0],[2078,1,16,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2078,11,12,13,59,59],[2078,11,13,1,59,59],
          '2078011514:00:00','2078011602:00:00','2078111213:59:59','2078111301:59:59' ],
        [ [2078,11,12,14,0,0],[2078,11,13,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2079,1,14,13,59,59],[2079,1,15,2,59,59],
          '2078111214:00:00','2078111303:00:00','2079011413:59:59','2079011502:59:59' ],
     ],
   2079 =>
     [
        [ [2079,1,14,14,0,0],[2079,1,15,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2079,11,11,13,59,59],[2079,11,12,1,59,59],
          '2079011414:00:00','2079011502:00:00','2079111113:59:59','2079111201:59:59' ],
        [ [2079,11,11,14,0,0],[2079,11,12,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2080,1,13,13,59,59],[2080,1,14,2,59,59],
          '2079111114:00:00','2079111203:00:00','2080011313:59:59','2080011402:59:59' ],
     ],
   2080 =>
     [
        [ [2080,1,13,14,0,0],[2080,1,14,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2080,11,9,13,59,59],[2080,11,10,1,59,59],
          '2080011314:00:00','2080011402:00:00','2080110913:59:59','2080111001:59:59' ],
        [ [2080,11,9,14,0,0],[2080,11,10,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2081,1,11,13,59,59],[2081,1,12,2,59,59],
          '2080110914:00:00','2080111003:00:00','2081011113:59:59','2081011202:59:59' ],
     ],
   2081 =>
     [
        [ [2081,1,11,14,0,0],[2081,1,12,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2081,11,8,13,59,59],[2081,11,9,1,59,59],
          '2081011114:00:00','2081011202:00:00','2081110813:59:59','2081110901:59:59' ],
        [ [2081,11,8,14,0,0],[2081,11,9,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2082,1,17,13,59,59],[2082,1,18,2,59,59],
          '2081110814:00:00','2081110903:00:00','2082011713:59:59','2082011802:59:59' ],
     ],
   2082 =>
     [
        [ [2082,1,17,14,0,0],[2082,1,18,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2082,11,7,13,59,59],[2082,11,8,1,59,59],
          '2082011714:00:00','2082011802:00:00','2082110713:59:59','2082110801:59:59' ],
        [ [2082,11,7,14,0,0],[2082,11,8,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2083,1,16,13,59,59],[2083,1,17,2,59,59],
          '2082110714:00:00','2082110803:00:00','2083011613:59:59','2083011702:59:59' ],
     ],
   2083 =>
     [
        [ [2083,1,16,14,0,0],[2083,1,17,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2083,11,13,13,59,59],[2083,11,14,1,59,59],
          '2083011614:00:00','2083011702:00:00','2083111313:59:59','2083111401:59:59' ],
        [ [2083,11,13,14,0,0],[2083,11,14,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2084,1,15,13,59,59],[2084,1,16,2,59,59],
          '2083111314:00:00','2083111403:00:00','2084011513:59:59','2084011602:59:59' ],
     ],
   2084 =>
     [
        [ [2084,1,15,14,0,0],[2084,1,16,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2084,11,11,13,59,59],[2084,11,12,1,59,59],
          '2084011514:00:00','2084011602:00:00','2084111113:59:59','2084111201:59:59' ],
        [ [2084,11,11,14,0,0],[2084,11,12,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2085,1,13,13,59,59],[2085,1,14,2,59,59],
          '2084111114:00:00','2084111203:00:00','2085011313:59:59','2085011402:59:59' ],
     ],
   2085 =>
     [
        [ [2085,1,13,14,0,0],[2085,1,14,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2085,11,10,13,59,59],[2085,11,11,1,59,59],
          '2085011314:00:00','2085011402:00:00','2085111013:59:59','2085111101:59:59' ],
        [ [2085,11,10,14,0,0],[2085,11,11,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2086,1,12,13,59,59],[2086,1,13,2,59,59],
          '2085111014:00:00','2085111103:00:00','2086011213:59:59','2086011302:59:59' ],
     ],
   2086 =>
     [
        [ [2086,1,12,14,0,0],[2086,1,13,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2086,11,9,13,59,59],[2086,11,10,1,59,59],
          '2086011214:00:00','2086011302:00:00','2086110913:59:59','2086111001:59:59' ],
        [ [2086,11,9,14,0,0],[2086,11,10,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2087,1,11,13,59,59],[2087,1,12,2,59,59],
          '2086110914:00:00','2086111003:00:00','2087011113:59:59','2087011202:59:59' ],
     ],
   2087 =>
     [
        [ [2087,1,11,14,0,0],[2087,1,12,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2087,11,8,13,59,59],[2087,11,9,1,59,59],
          '2087011114:00:00','2087011202:00:00','2087110813:59:59','2087110901:59:59' ],
        [ [2087,11,8,14,0,0],[2087,11,9,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2088,1,17,13,59,59],[2088,1,18,2,59,59],
          '2087110814:00:00','2087110903:00:00','2088011713:59:59','2088011802:59:59' ],
     ],
   2088 =>
     [
        [ [2088,1,17,14,0,0],[2088,1,18,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2088,11,13,13,59,59],[2088,11,14,1,59,59],
          '2088011714:00:00','2088011802:00:00','2088111313:59:59','2088111401:59:59' ],
        [ [2088,11,13,14,0,0],[2088,11,14,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2089,1,15,13,59,59],[2089,1,16,2,59,59],
          '2088111314:00:00','2088111403:00:00','2089011513:59:59','2089011602:59:59' ],
     ],
   2089 =>
     [
        [ [2089,1,15,14,0,0],[2089,1,16,2,0,0],'+12:00:00',[12,0,0],
          '+12',0,[2089,11,12,13,59,59],[2089,11,13,1,59,59],
          '2089011514:00:00','2089011602:00:00','2089111213:59:59','2089111301:59:59' ],
        [ [2089,11,12,14,0,0],[2089,11,13,3,0,0],'+13:00:00',[13,0,0],
          '+13',1,[2090,1,14,13,59,59],[2090,1,15,2,59,59],
          '2089111214:00:00','2089111303:00:00','2090011413:59:59','2090011502:59:59' ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '+13:00:00',
                'stdoff' => '+12:00:00',
               },
   'rules'  => {
                '01' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '12',
                         'type'    => 'w',
                         'time'    => '03:00:00',
                         'isdst'   => '0',
                         'abb'     => '+12',
                        },
                '11' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '8',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '1',
                         'abb'     => '+13',
                        },
               },
);

1;
