package Regexp::Pattern::Perl::Module;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-06-16'; # DATE
our $DIST = 'Regexp-Pattern-Perl'; # DIST
our $VERSION = '0.001'; # VERSION

use strict;
#use warnings;

our %RE = (
    perl_modname => {
        pat => '\A[A-Za-z_][A-Za-z_0-9]*(::[A-Za-z_0-9]+)*\z',
        examples => [
            {str=>'', matches=>0},
            {str=>'Foo::Bar', matches=>1},
            {str=>'Foo::0Bar', matches=>1},
            {str=>'0Foo::Bar', matches=>0},
            {str=>'Foo/Bar', matches=>0},
        ],
    },
    perl_modname_with_optional_args => {
        pat => '\A[A-Za-z_][A-Za-z_0-9]*(::[A-Za-z_0-9]+)*(?:=.*)?\z',
        examples => [
            {str=>'', matches=>0},
            {str=>'Foo::Bar', matches=>1},
            {str=>'Foo::0Bar', matches=>1},
            {str=>'0Foo::Bar', matches=>0},
            {str=>'Foo/Bar', matches=>0},

            {str=>'Foo::Bar=', matches=>1},
            {str=>'Foo::Bar=a', matches=>1},
            {str=>'Foo::Bar=a,b,c', matches=>1},
            {str=>'Foo::Bar=a=1', matches=>1},
            {str=>'=Foo::Bar', matches=>0},
        ],
    },
);

1;
# ABSTRACT: Regexp patterns related to Perl modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Regexp::Pattern::Perl::Module - Regexp patterns related to Perl modules

=head1 VERSION

This document describes version 0.001 of Regexp::Pattern::Perl::Module (from Perl distribution Regexp-Pattern-Perl), released on 2020-06-16.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Regexp-Pattern-Perl>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Regexp-Pattern-Perl>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Regexp-Pattern-Perl>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

Other C<Regexp::Pattern::Perl::*> modules.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
