package Module::Features::Set;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2021-05-13'; # DATE
our $DIST = 'Module-Features-Set'; # DIST
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our %FEATURES_DEF = (
    v => 1,
    summary => 'Features of modules that handle set data structure',
    description => <<'_',

To check whether two sets are equal, you can use intersection
(`can_intersect_sets`). Two sets are equal if their intersection has the same
size as either set.

To check whether a set is a subset of another, you can use difference
(`can_difference_sets`). A set is a subset of another if the other set's
difference with the set has the same size as the first set.

To check whether set A is a superset of set B, check whether set B is a subset
of set A.

_
    features => {
        can_insert_value                         => {summary => 'Provide a way for user to insert a value to a set', tags=>['category:intraset-operation']},
        can_delete_value                         => {summary => 'Provide a way for user to delete a value from a set', tags=>['category:intraset-operation']},
        can_search_value                         => {summary => 'Provide a way for user to search a value in a set', tags=>['category:intraset-operation']},
        can_count_values                         => {summary => 'Provide a way for user to get the number of values in a set (the size of the set)', tags=>['category:intraset-operation']},

        can_union_sets                           => {summary => 'Provide a way for user to perform union operation of two or more sets', tags=>['category:interset-operation']},
        can_intersect_sets                       => {summary => 'Provide a way for user to perform intersection operation of two or more sets', tags=>['category:interset-operation']},
        can_difference_sets                      => {summary => 'Provide a way for user to perform difference operation of two or more sets (values in first set not in the rest)', tags=>['category:interset-operation']},
        can_symmetric_difference_sets            => {summary => 'Provide a way for user to perform symmetric difference operation of two or more sets (values that are only in exactly one set)', tags=>['category:interset-operation']},

        speed                                    => {summary => 'Subjective speed rating, relative to other set modules', schema=>['str', in=>[qw/slow medium fast/]], tags=>['category:speed']},

        memory_overhead                          => {summary => 'Subjective memory overhead rating, relative to other set modules', schema=>['str', in=>[qw/low medium high/]], tags=>['category:memory_overhead']},
    },
);

1;
# ABSTRACT: Features of modules that generate text tables

__END__

=pod

=encoding UTF-8

=head1 NAME

Module::Features::Set - Features of modules that generate text tables

=head1 VERSION

This document describes version 0.001 of Module::Features::Set (from Perl distribution Module-Features-Set), released on 2021-05-13.

=head1 DESCRIPTION

To check whether two sets are equal, you can use intersection
(C<can_intersect_sets>). Two sets are equal if their intersection has the same
size as either set.

To check whether a set is a subset of another, you can use difference
(C<can_difference_sets>). A set is a subset of another if the other set's
difference with the set has the same size as the first set.

To check whether set A is a superset of set B, check whether set B is a subset
of set A.

=head1 DEFINED FEATURES

Features defined by this module:

=over

=item * can_count_values

Optional. Type: bool. Provide a way for user to get the number of values in a set (the size of the set). 

=item * can_delete_value

Optional. Type: bool. Provide a way for user to delete a value from a set. 

=item * can_difference_sets

Optional. Type: bool. Provide a way for user to perform difference operation of two or more sets (values in first set not in the rest). 

=item * can_insert_value

Optional. Type: bool. Provide a way for user to insert a value to a set. 

=item * can_intersect_sets

Optional. Type: bool. Provide a way for user to perform intersection operation of two or more sets. 

=item * can_search_value

Optional. Type: bool. Provide a way for user to search a value in a set. 

=item * can_symmetric_difference_sets

Optional. Type: bool. Provide a way for user to perform symmetric difference operation of two or more sets (values that are only in exactly one set). 

=item * can_union_sets

Optional. Type: bool. Provide a way for user to perform union operation of two or more sets. 

=item * memory_overhead

Optional. Type: str. Subjective memory overhead rating, relative to other set modules. 

=item * speed

Optional. Type: str. Subjective speed rating, relative to other set modules. 

=back

For more details on module features, see L<Module::Features>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Module-Features-Set>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Module-Features-Set>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Module-Features-Set>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Module::Features>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
