package Finance::ID::KSEI;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2021-01-17'; # DATE
our $DIST = 'Finance-ID-KSEI'; # DIST
our $VERSION = '0.000'; # VERSION

use 5.010001;
use strict;
use warnings;

use Exporter qw(import);
our @EXPORT_OK = qw(
                       get_ksei_sec_ownership
                       get_ksei_sec_data
               );

our %SPEC;

$SPEC{':package'} = {
    v => 1.1,
    summary => 'Get information from KSEI (Kustodian Sentral Efek Indonesia) (Indonesian Central Securities Depository)',
};

1;
# ABSTRACT: Get information from KSEI (Kustodian Sentral Efek Indonesia) (Indonesian Central Securities Depository)

__END__

=pod

=encoding UTF-8

=head1 NAME

Finance::ID::KSEI - Get information from KSEI (Kustodian Sentral Efek Indonesia) (Indonesian Central Securities Depository)

=head1 VERSION

This document describes version 0.000 of Finance::ID::KSEI (from Perl distribution Finance-ID-KSEI), released on 2021-01-17.

=head1 DESCRIPTION

Not yet implemented, name grab only.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Finance-ID-KSEI>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Finance-ID-KSEI>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://github.com/perlancar/perl-Finance-ID-KSEI/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Finance::SE::IDX>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
