#pragma once

namespace xs {

inline SV* _typemap_out_oref (pTHX_ SV* var, HV* CLASS) {
    return var ? sv_bless(newRV_noinc(var), CLASS) : &PL_sv_undef;
}
inline SV* _typemap_out_oref (pTHX_ SV* var, const char* CLASS) {
    return _typemap_out_oref(aTHX_ var, gv_stashpvn(CLASS, strlen(CLASS), GV_ADD));
}
inline SV* _typemap_out_oref (pTHX_ SV* var, SV* CLASS) {
    return _typemap_out_oref(aTHX_ var, gv_stashsv(CLASS, GV_ADD));
}

inline SV* _typemap_out_optr (pTHX_ void* var, HV* CLASS) {
    return var ? sv_bless(newRV_noinc(newSViv((IV)var)), CLASS) : &PL_sv_undef;
}
inline SV* _typemap_out_optr (pTHX_ void* var, const char* CLASS) {
    return _typemap_out_optr(aTHX_ var, gv_stashpvn(CLASS, strlen(CLASS), GV_ADD));
}
inline SV* _typemap_out_optr (pTHX_ void* var, SV* CLASS) {
    return _typemap_out_optr(aTHX_ var, gv_stashsv(CLASS, GV_ADD));
}

template <class T, typename C>
inline SV* _typemap_out_optr (pTHX_ const panda::shared_ptr<T, true> &sp, C CLASS) {
     sp->retain();
     return _typemap_out_optr(aTHX_ sp.get(), CLASS);
}

template <class T, typename C>
inline SV* _typemap_out_optr (pTHX_ const panda::shared_ptr<T, false> &sp, C CLASS) {
    return _typemap_out_optr(aTHX_ new panda::shared_ptr<T>(sp), CLASS);
}

#ifdef CPP11X
template <class T, typename C>
inline SV* _typemap_out_optr (pTHX_ const std::shared_ptr<T> &sp, C CLASS) {
    return _typemap_out_optr(aTHX_ new std::shared_ptr<T>(sp), CLASS);
}
#endif

SV* _typemap_out_oext (pTHX_ SV* self, void* var, HV* CLASS, payload_marker_t* marker = NULL);
SV* _typemap_out_oext (pTHX_ SV* self, void* var, SV* CLASS, payload_marker_t* marker = NULL);
SV* _typemap_out_oext (pTHX_ SV* self, void* var, const char* CLASS, payload_marker_t* marker = NULL);

template <class T, typename C>
inline SV* _typemap_out_oext (pTHX_ SV* self, const panda::shared_ptr<T, true> &sp, C CLASS, payload_marker_t* marker = NULL) {
     sp->retain();
     return _typemap_out_oext(aTHX_ self, sp.get(), CLASS, marker);
}

template <class T, typename C>
inline SV* _typemap_out_oext (pTHX_ SV* self, const panda::shared_ptr<T, false> &sp, C CLASS, payload_marker_t* marker = NULL) {
    return _typemap_out_oext(aTHX_ self, new panda::shared_ptr<T>(sp), CLASS, marker);
}

#ifdef CPP11X
template <class T, typename C>
inline SV* _typemap_out_oext (pTHX_ SV* self, const std::shared_ptr<T> &sp, C CLASS, payload_marker_t* marker = NULL) {
    return _typemap_out_oext(aTHX_ self, new std::shared_ptr<T>(sp), CLASS, marker);
}
#endif

template <class T, typename FuncType>
struct _SVDupHelper {
    template <FuncType func>
    static inline int cb (pTHX_ MAGIC* mg, CLONE_PARAMS* param) {
        mg->mg_ptr = (char*)static_cast<T>(func(aTHX_ (T)mg->mg_ptr));
        return 0;
    }

};

template <class T, typename FuncType>
_SVDupHelper<T, FuncType> _typemap_oext_svdup (FuncType& arg) {
    return _SVDupHelper<T, FuncType>();
}

template <class T>
T _typemap_oext_svdup_clone (pTHX_ T obj) {
    return obj->clone();
}

template <class T>
T _typemap_oext_svdup_retain (pTHX_ T obj) {
    obj->retain();
    return obj;
}

template <class T>
inline void _typemap_in_optr (pTHX_ SV* arg, T* varptr) {
    if (sv_isobject(arg)) {
        SV* obj = SvRV(arg);
        if (SvIOK(obj)) {
            *varptr = static_cast<T>((void*)SvIVX(obj));
            return;
        }
    }
    *varptr = NULL;
}

template <class T>
inline void _typemap_in_optr (pTHX_ SV* arg, panda::shared_ptr<T,true>* sptr, bool destroy = false) {
    void* ptr;
    _typemap_in_optr(aTHX_ arg, &ptr);
    *sptr = static_cast<T*>(ptr);
    if (destroy) static_cast<T*>(ptr)->release();
}

template <class T>
inline void _typemap_in_optr (pTHX_ SV* arg, panda::shared_ptr<T,false>* sptr, bool destroy = false) {
    void* ptr;
    _typemap_in_optr(aTHX_ arg, &ptr);
    *sptr = *(static_cast<panda::shared_ptr<T,false>*>(ptr));
    if (destroy) delete static_cast<panda::shared_ptr<T,false>*>(ptr);
}

#ifdef CPP11X
template <class T>
inline void _typemap_in_optr (pTHX_ SV* arg, std::shared_ptr<T>* sptr, bool destroy = false) {
    void* ptr;
    _typemap_in_optr(aTHX_ arg, &ptr);
    *sptr = *(static_cast<std::shared_ptr<T>*>(ptr));
    if (destroy) delete static_cast<std::shared_ptr<T>*>(ptr);
}
#endif

template <class T>
inline void _typemap_in_oext (pTHX_ SV* arg, T* varptr, payload_marker_t* marker = NULL) {
    if (SvROK(arg)) *varptr = static_cast<T>(rv_payload(aTHX_ arg, marker));
    else *varptr = NULL;
}

template <class T>
inline void _typemap_in_oext (pTHX_ SV* arg, panda::shared_ptr<T,true>* sptr, payload_marker_t* marker = NULL, bool destroy = false) {
    void* ptr;
    _typemap_in_oext(aTHX_ arg, &ptr, marker);
    *sptr = static_cast<T*>(ptr);
    if (destroy) static_cast<T*>(ptr)->release();
}

template <class T>
inline void _typemap_in_oext (pTHX_ SV* arg, panda::shared_ptr<T,false>* sptr, payload_marker_t* marker = NULL, bool destroy = false) {
    void* ptr;
    _typemap_in_oext(aTHX_ arg, &ptr, marker);
    *sptr = *(static_cast<panda::shared_ptr<T,false>*>(ptr));
    if (destroy) delete static_cast<panda::shared_ptr<T,false>*>(ptr);
}

#ifdef CPP11X
template <class T>
inline void _typemap_in_oext (pTHX_ SV* arg, std::shared_ptr<T>* sptr, payload_marker_t* marker = NULL, bool destroy = false) {
    void* ptr;
    _typemap_in_oext(aTHX_ arg, &ptr, marker);
    *sptr = *(static_cast<std::shared_ptr<T>*>(ptr));
    if (destroy) delete static_cast<std::shared_ptr<T>*>(ptr);
}
#endif

}
