#!/usr/bin/env perl
use 5.012;
use warnings;
use lib 'blib/lib', 'blib/arch', 't/lib';
use Benchmark qw/timethis timethese/;
use MyTest;

say $$;

die "usage: $0 <what> [--profile]" unless @ARGV;

my @cmds;
my $time = -1;
for (@ARGV) {
    $time = -10, next if m/--profile/;
    push @cmds, $_;
}

for (@cmds) {
    no strict 'refs';
    say "$_";
    
    if (my $sub = main->can($_)) {
        $sub->();
    } else {
        my $sub = MyTest->can("bench_$_") or die "unknown $_";
        timethis($time, $sub);
    }
}

say "DONE";

sub iequals_short {
    say "val: " . MyTest::bench_iequals("Cookie", "cookie");
    timethis($time, sub { MyTest::bench_iequals("Cookie", "Cookie") });
}

sub iequals_medium {
    say "val: " . MyTest::bench_iequals("Transfer-Encoding123", "transfer-encoding123");
    timethis($time, sub { MyTest::bench_iequals("Transfer-Encoding123", "Transfer-Encoding123") });
}

sub iequals_long {
    my $s1 = "Transfer-Encoding123" x 50;
    my $s2 = "Transfer-Encoding123" x 50;
    say "val: " . MyTest::bench_iequals($s1, $s2);
    timethis($time, sub { MyTest::bench_iequals($s1, $s2) });
}
