#!/usr/bin/perl

use warnings;
use strict;
use Test::Inter;
$::ti = new Test::Inter $0;
require "tests.pl";

our $obj = new Date::Manip::Date;
$obj->config("forcedate","2000-01-21-12:00:00,America/New_York");

sub test {
   my(@test)=@_;
   if ($test[0] eq "config") {
      shift(@test);
      $obj->config(@test);
      return ();
   }

   $obj->_init();
   my $err = $obj->parse_date(@test);
   if ($err) {
      return $obj->err();
   } else {
      my $d1 = $obj->value();
      my $d2 = $obj->value("gmt");
      return($d1,$d2);
   }
}

my $tests="

# Common dates

3/5 => 2000030500:00:00 2000030505:00:00

3/5/09 => 2009030500:00:00 2009030505:00:00

3/5/2009 => 2009030500:00:00 2009030505:00:00

Mar/5 => 2000030500:00:00 2000030505:00:00

Mar/5/09 => 2009030500:00:00 2009030505:00:00

Mar/5/2009 => 2009030500:00:00 2009030505:00:00

5/Mar => 2000030500:00:00 2000030505:00:00

5/Mar/09 => 2009030500:00:00 2009030505:00:00

5/Mar/2009 => 2009030500:00:00 2009030505:00:00

2009/Mar/5 => 2009030500:00:00 2009030505:00:00

'Mar5 09' => 2009030500:00:00 2009030505:00:00

'Mar5 2009' => 2009030500:00:00 2009030505:00:00

'5Mar 09' => 2009030500:00:00 2009030505:00:00

'5Mar 2009' => 2009030500:00:00 2009030505:00:00

'Mar/5 09' => 2009030500:00:00 2009030505:00:00

'Mar/5 2009' => 2009030500:00:00 2009030505:00:00

'5/Mar 09' => 2009030500:00:00 2009030505:00:00

'5/Mar 2009' => 2009030500:00:00 2009030505:00:00

'09 Mar5' => 2009030500:00:00 2009030505:00:00

'2009 Mar5' => 2009030500:00:00 2009030505:00:00

'09 5Mar' => 2009030500:00:00 2009030505:00:00

'2009 5Mar' => 2009030500:00:00 2009030505:00:00

'09 Mar/5' => 2009030500:00:00 2009030505:00:00

'2009 Mar/5' => 2009030500:00:00 2009030505:00:00

'09 5/Mar' => 2009030500:00:00 2009030505:00:00

'2009 5/Mar' => 2009030500:00:00 2009030505:00:00

Mar5 => 2000030500:00:00 2000030505:00:00

Mar052009 => 2009030500:00:00 2009030505:00:00

5Mar => 2000030500:00:00 2000030505:00:00

5Mar09 => 2009030500:00:00 2009030505:00:00

5Mar2009 => 2009030500:00:00 2009030505:00:00

2009Mar5 => 2009030500:00:00 2009030505:00:00

5March09 => 2009030500:00:00 2009030505:00:00

5March2009 => 2009030500:00:00 2009030505:00:00

2009March5 => 2009030500:00:00 2009030505:00:00

'3 5' => 2000030500:00:00 2000030505:00:00

'3 5 09' => 2009030500:00:00 2009030505:00:00

'3 5 2009' => 2009030500:00:00 2009030505:00:00

3-5 => 2000030500:00:00 2000030505:00:00

3-5-09 => 2009030500:00:00 2009030505:00:00

3-5-2009 => 2009030500:00:00 2009030505:00:00

3.5.09 => 2009030500:00:00 2009030505:00:00

3.5.2009 => 2009030500:00:00 2009030505:00:00

3/5.2009 => '[parse_date] Invalid date string'

";

$::ti->tests(func  => \&test,
             tests => $tests);
$::ti->done_testing();

#Local Variables:
#mode: cperl
#indent-tabs-mode: nil
#cperl-indent-level: 3
#cperl-continued-statement-offset: 2
#cperl-continued-brace-offset: 0
#cperl-brace-offset: 0
#cperl-brace-imaginary-offset: 0
#cperl-label-offset: 0
#End:
