BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( Archive::Tar Carp Encode Exporter File::Spec File::Temp constant experimental parent strict utf8 warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.020; 1}) {
    print "Perl 5.020 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.63.
use strict;
use warnings;
use 5.020;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Modern Perl bindings to libarchive",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "FFI::CheckLib"       => "0.28"
  },
  "DISTNAME"         => "Archive-Libarchive",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.020",
  "NAME"             => "Archive::Libarchive",
  "PM"               => {
    "lib/Archive/Libarchive.pm"                       => "\$(INST_LIB)/Archive/Libarchive.pm",
    "lib/Archive/Libarchive/API.pm"                   => "\$(INST_LIB)/Archive/Libarchive/API.pm",
    "lib/Archive/Libarchive/Archive.pm"               => "\$(INST_LIB)/Archive/Libarchive/Archive.pm",
    "lib/Archive/Libarchive/ArchiveRead.pm"           => "\$(INST_LIB)/Archive/Libarchive/ArchiveRead.pm",
    "lib/Archive/Libarchive/ArchiveWrite.pm"          => "\$(INST_LIB)/Archive/Libarchive/ArchiveWrite.pm",
    "lib/Archive/Libarchive/DiskRead.pm"              => "\$(INST_LIB)/Archive/Libarchive/DiskRead.pm",
    "lib/Archive/Libarchive/DiskWrite.pm"             => "\$(INST_LIB)/Archive/Libarchive/DiskWrite.pm",
    "lib/Archive/Libarchive/Entry.pm"                 => "\$(INST_LIB)/Archive/Libarchive/Entry.pm",
    "lib/Archive/Libarchive/EntryLinkResolver.pm"     => "\$(INST_LIB)/Archive/Libarchive/EntryLinkResolver.pm",
    "lib/Archive/Libarchive/Lib.pm"                   => "\$(INST_LIB)/Archive/Libarchive/Lib.pm",
    "lib/Archive/Libarchive/Lib/Archive.pm"           => "\$(INST_LIB)/Archive/Libarchive/Lib/Archive.pm",
    "lib/Archive/Libarchive/Lib/ArchiveRead.pm"       => "\$(INST_LIB)/Archive/Libarchive/Lib/ArchiveRead.pm",
    "lib/Archive/Libarchive/Lib/ArchiveWrite.pm"      => "\$(INST_LIB)/Archive/Libarchive/Lib/ArchiveWrite.pm",
    "lib/Archive/Libarchive/Lib/Constants.pm"         => "\$(INST_LIB)/Archive/Libarchive/Lib/Constants.pm",
    "lib/Archive/Libarchive/Lib/DiskRead.pm"          => "\$(INST_LIB)/Archive/Libarchive/Lib/DiskRead.pm",
    "lib/Archive/Libarchive/Lib/DiskWrite.pm"         => "\$(INST_LIB)/Archive/Libarchive/Lib/DiskWrite.pm",
    "lib/Archive/Libarchive/Lib/Entry.pm"             => "\$(INST_LIB)/Archive/Libarchive/Lib/Entry.pm",
    "lib/Archive/Libarchive/Lib/EntryLinkResolver.pm" => "\$(INST_LIB)/Archive/Libarchive/Lib/EntryLinkResolver.pm",
    "lib/Archive/Libarchive/Lib/Match.pm"             => "\$(INST_LIB)/Archive/Libarchive/Lib/Match.pm",
    "lib/Archive/Libarchive/Lib/Unbound.pm"           => "\$(INST_LIB)/Archive/Libarchive/Lib/Unbound.pm",
    "lib/Archive/Libarchive/Match.pm"                 => "\$(INST_LIB)/Archive/Libarchive/Match.pm"
  },
  "PREREQ_PM" => {
    "FFI::C::Stat"                   => 0,
    "FFI::CheckLib"                  => "0.28",
    "FFI::Platypus"                  => "1.38",
    "FFI::Platypus::Buffer"          => 0,
    "FFI::Platypus::Type::Enum"      => "0.05",
    "FFI::Platypus::Type::PtrObject" => 0,
    "PeekPoke::FFI"                  => 0,
    "Ref::Util"                      => 0
  },
  "TEST_REQUIRES" => {
    "FFI::C::File"              => 0,
    "File::chdir"               => 0,
    "Path::Tiny"                => 0,
    "Sub::Identify"             => 0,
    "Term::Table"               => 0,
    "Test2::V0"                 => "0.000060",
    "Test::Archive::Libarchive" => 0,
    "Test::Script"              => "1.09"
  },
  "VERSION" => "0.02",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "FFI::C::File"                   => 0,
  "FFI::C::Stat"                   => 0,
  "FFI::CheckLib"                  => "0.28",
  "FFI::Platypus"                  => "1.38",
  "FFI::Platypus::Buffer"          => 0,
  "FFI::Platypus::Type::Enum"      => "0.05",
  "FFI::Platypus::Type::PtrObject" => 0,
  "File::chdir"                    => 0,
  "Path::Tiny"                     => 0,
  "PeekPoke::FFI"                  => 0,
  "Ref::Util"                      => 0,
  "Sub::Identify"                  => 0,
  "Term::Table"                    => 0,
  "Test2::V0"                      => "0.000060",
  "Test::Archive::Libarchive"      => 0,
  "Test::Script"                   => "1.09"
);

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.039
if ( do { require './lib/Archive/Libarchive/Lib.pm'; !eval { Archive::Libarchive::Lib->lib; 1 } } ) {
  requires( 'Alien::Libarchive3', '0.30' );
}

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.039
sub _add_prereq {
  my ( $mm_key, $module, $version_or_range ) = @_;
  $version_or_range ||= 0;
  warn "$module already exists in $mm_key (at version $WriteMakefileArgs{$mm_key}{$module}) -- need to do a sane metamerge!"
    if exists $WriteMakefileArgs{$mm_key}{$module}
    and $WriteMakefileArgs{$mm_key}{$module} ne '0'
    and $WriteMakefileArgs{$mm_key}{$module} ne $version_or_range;
  warn "$module already exists in FallbackPrereqs (at version $FallbackPrereqs{$module}) -- need to do a sane metamerge!"
    if exists $FallbackPrereqs{$module} and $FallbackPrereqs{$module} ne '0'
    and $FallbackPrereqs{$module} ne $version_or_range;
  $WriteMakefileArgs{$mm_key}{$module} = $FallbackPrereqs{$module} = $version_or_range;
  return;
}

sub requires { goto &runtime_requires }

sub runtime_requires {
  my ( $module, $version_or_range ) = @_;
  _add_prereq( PREREQ_PM => $module, $version_or_range );
}