package Sah::SchemaR::perl::tabledata::modnames_with_optional_args;

our $DATE = '2021-06-11'; # DATE
our $VERSION = '0.001'; # VERSION

our $rschema = ["array",[{description=>"\nArray of Perl TableData::* module names without the prefix and optional args.\nEach element is of `perl::tabledata::modname` schema, e.g. `Locale::US::State`,\n`WordList=wordlist,EN::Enable`.\n\nContains coercion rule that expands wildcard, so you can specify:\n\n    Locale::US::*\n\nand it will be expanded to e.g.:\n\n    [\"Locale::US::State\", \"Locale::US::City\"]\n\nThe wildcard syntax supports jokers (`?`, `*`, `**`), brackets (`[abc]`), and\nbraces (`{one,two}`). See <pm:Module::List::Wildcard> for more details.\n\n",of=>["perl::tabledata::modname_with_optional_args",{req=>1},{}],summary=>"Array of Perl TableData::* module names without the prefix, with optional args, e.g. [\"Locale::US::State\", \"WordList=wordlist,EN::Enable\"]","x.element_completion"=>["perl_modname",{ns_prefix=>"TableData"}],"x.perl.coerce_rules"=>[["From_str_or_array::expand_perl_modname_wildcard",{ns_prefix=>"TableData"}]]}],["array"]];

1;
# ABSTRACT: Array of Perl TableData::* module names without the prefix, with optional args, e.g. ["Locale::US::State", "WordList=wordlist,EN::Enable"]

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::perl::tabledata::modnames_with_optional_args - Array of Perl TableData::* module names without the prefix, with optional args, e.g. ["Locale::US::State", "WordList=wordlist,EN::Enable"]

=head1 VERSION

This document describes version 0.001 of Sah::SchemaR::perl::tabledata::modnames_with_optional_args (from Perl distribution Sah-Schemas-TableData), released on 2021-06-11.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-TableData>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-TableData>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-TableData>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
