#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
static int32_t SUB_ID_TestCase__Switch__switch_return_sub = - 1;
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Switch__switch_constant_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Switch__switch_lookup_switch(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Switch__switch_nest(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Switch__switch_no_default(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Switch__switch_return(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Switch__switch_return_sub(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Switch__switch_table_switch(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Switch__switch_constant_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x5B';
L2: // CONVERT_BYTE_TO_INT
  int_vars[1] = (int32_t)byte_vars[0];
L3: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L4: // LOOKUP_SWITCH
  switch(int_vars[1]) {
    case 3: goto L5;
    case 91: goto L7;
    case 93: goto L6;
    default: goto L9;
  }
L5: // GOTO
  goto L9;
L6: // GOTO
  goto L9;
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L8: // GOTO
  goto L9;
L9: // BOOL_INT
  int_vars[0] = int_vars[3];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L18;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L18;
L16: // INIT_INT
  int_vars[6] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L18;
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Switch__switch_lookup_switch(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[12];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L3: // LOOKUP_SWITCH
  switch(int_vars[3]) {
    case 1: goto L4;
    case 3: goto L6;
    case 10000: goto L8;
    default: goto L10;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L5: // GOTO
  goto L10;
L6: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L7: // GOTO
  goto L10;
L8: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L9: // GOTO
  goto L10;
L10: // INIT_INT
  int_vars[7] = 0;
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L12: // LOOKUP_SWITCH
  switch(int_vars[3]) {
    case 1: goto L13;
    case 3: goto L15;
    case 10000: goto L17;
    default: goto L19;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L14: // GOTO
  goto L19;
L15: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L16: // GOTO
  goto L19;
L17: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L18: // GOTO
  goto L19;
L19: // INIT_INT
  int_vars[8] = 0;
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 10000;
L21: // LOOKUP_SWITCH
  switch(int_vars[3]) {
    case 1: goto L24;
    case 3: goto L22;
    case 10000: goto L26;
    default: goto L28;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L23: // GOTO
  goto L28;
L24: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L25: // GOTO
  goto L28;
L26: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L27: // GOTO
  goto L28;
L28: // INIT_INT
  int_vars[9] = 0;
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L30: // LOOKUP_SWITCH
  switch(int_vars[3]) {
    case 1: goto L31;
    case 3: goto L32;
    case 10000: goto L33;
    default: goto L34;
  }
L31: // GOTO
  goto L35;
L32: // GOTO
  goto L35;
L33: // GOTO
  goto L35;
L34: // MOVE_CONSTANT_INT
  int_vars[9] = 1;
L35: // BOOL_INT
  int_vars[0] = int_vars[1];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L49; }
L37: // BOOL_INT
  int_vars[0] = int_vars[7];
L38: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L48; }
L39: // BOOL_INT
  int_vars[0] = int_vars[8];
L40: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L47; }
L41: // BOOL_INT
  int_vars[0] = int_vars[9];
L42: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L53;
L45: // GOTO
  goto L46;
L46: // GOTO
  goto L47;
L47: // GOTO
  goto L48;
L48: // GOTO
  goto L49;
L49: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L50: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L53;
L51: // INIT_INT
  int_vars[10] = 0;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[10];
  goto L53;
L53: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Switch__switch_nest(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L3: // LOOKUP_SWITCH
  switch(int_vars[3]) {
    case 1: goto L4;
    case 3: goto L6;
    case 10000: goto L17;
    default: goto L19;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L5: // GOTO
  goto L19;
L6: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L7: // TABLE_SWITCH
  switch(int_vars[5]) {
    case 2: goto L8;
    case 3: goto L14;
    case 4: goto L14;
    case 5: goto L10;
    case 6: goto L12;
    default: goto L14;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L9: // GOTO
  goto L16;
L10: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L11: // GOTO
  goto L16;
L12: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L13: // GOTO
  goto L16;
L14: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L15: // GOTO
  goto L16;
L16: // GOTO
  goto L19;
L17: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L18: // GOTO
  goto L19;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L22;
L20: // INIT_INT
  int_vars[8] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L22;
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Switch__switch_no_default(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // TABLE_SWITCH
  switch(int_vars[1]) {
    case 1: goto L3;
    default: goto L5;
  }
L3: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L4: // GOTO
  goto L5;
L5: // MOVE_CONSTANT_INT
  int_vars[6] = 5;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L7: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[3]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L17;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L17;
L15: // INIT_INT
  int_vars[8] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Switch__switch_return(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_INT
  // TestCase::Switch->switch_return_sub
  {
    if (SUB_ID_TestCase__Switch__switch_return_sub < 0) {
      SUB_ID_TestCase__Switch__switch_return_sub = env->get_sub_id(env, "TestCase::Switch", "switch_return_sub", "int()");
      if (SUB_ID_TestCase__Switch__switch_return_sub < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Switch switch_return_sub");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Switch__switch_return_sub;
    exception_flag = SPPRECOMPILE__TestCase__Switch__switch_return_sub(env, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Switch";
    const char* sub_name = "switch_return";
    const char* file = "TestCase/Switch.spvm";
    int32_t line = 4;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L3: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L4: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_NE_ZERO
  if (int_vars[0]) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L14;
L12: // INIT_INT
  int_vars[7] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Switch__switch_return_sub(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[12];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // TABLE_SWITCH
  switch(int_vars[1]) {
    case 1: goto L3;
    case 2: goto L5;
    default: goto L7;
  }
L3: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L9;
L5: // MOVE_CONSTANT_INT
  int_vars[6] = 5;
L6: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L9;
L7: // INIT_INT
  int_vars[10] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[10];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Switch__switch_table_switch(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L3: // TABLE_SWITCH
  switch(int_vars[3]) {
    case 3: goto L4;
    case 4: goto L6;
    case 5: goto L8;
    default: goto L10;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L5: // GOTO
  goto L10;
L6: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L7: // GOTO
  goto L10;
L8: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L9: // GOTO
  goto L10;
L10: // INIT_INT
  int_vars[7] = 0;
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L12: // TABLE_SWITCH
  switch(int_vars[3]) {
    case 3: goto L13;
    case 4: goto L15;
    case 5: goto L17;
    default: goto L19;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L14: // GOTO
  goto L19;
L15: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L16: // GOTO
  goto L19;
L17: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L18: // GOTO
  goto L19;
L19: // INIT_INT
  int_vars[8] = 0;
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 10;
L21: // TABLE_SWITCH
  switch(int_vars[3]) {
    case 3: goto L22;
    case 4: goto L24;
    case 5: goto L26;
    default: goto L28;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L23: // GOTO
  goto L29;
L24: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L25: // GOTO
  goto L29;
L26: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L27: // GOTO
  goto L29;
L28: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L29: // BOOL_INT
  int_vars[0] = int_vars[1];
L30: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L40; }
L31: // BOOL_INT
  int_vars[0] = int_vars[7];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L33: // BOOL_INT
  int_vars[0] = int_vars[8];
L34: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L38; }
L35: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L44;
L37: // GOTO
  goto L38;
L38: // GOTO
  goto L39;
L39: // GOTO
  goto L40;
L40: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L44;
L42: // INIT_INT
  int_vars[9] = 0;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[9];
  goto L44;
L44: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


