#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_all_numbers(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_exponant_E_minus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_exponant_e_nosign(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_exponant_e_plus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_exponant_no_point(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_minus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_plus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_prefix_D(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_prefix_F(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_prefix_d(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_prefix_f(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_under_line(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__hex_all_numbers(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__hex_equals_decimal(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__hex_exponent(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__hex_suffix(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__hex_underline(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_all_numbers(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.12345678912345;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.12345678912345;
L3: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_exponant_E_minus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.2e-08;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.2e-08;
L3: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_exponant_e_nosign(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1200000.0;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1200000.0;
L3: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_exponant_e_plus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1200000.0;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1200000.0;
L3: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_exponant_no_point(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 120000000.0;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 120000000.0;
L3: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_minus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = -0.25;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = -0.25;
L3: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_plus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.25;
L2: // MOVE_DOUBLE
  double_vars[1] = double_vars[0];
L3: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.25;
L4: // MOVE_DOUBLE
  double_vars[2] = double_vars[0];
L5: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[2]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_prefix_D(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.12345678912345;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.12345678912345;
L3: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_prefix_F(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.25;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.25;
L3: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_prefix_d(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.12345678912345;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.12345678912345;
L3: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_prefix_f(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.25;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.25;
L3: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__decimal_under_line(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.1234;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.1234;
L3: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__hex_all_numbers(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.071111111101345159;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.67111015319824219;
L3: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 0.67111104726791382;
L4: // MOVE_CONSTANT_DOUBLE
  double_vars[3] = 0.071111111101345159;
L5: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[3]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L29;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_DOUBLE
  double_vars[3] = 0.67111015319824219;
L12: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[3]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_NE_ZERO
  if (int_vars[0]) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L29;
L17: // GOTO
  goto L18;
L18: // MOVE_CONSTANT_DOUBLE
  double_vars[3] = 0.67111104726791382;
L19: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[3]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_NE_ZERO
  if (int_vars[0]) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L29;
L24: // GOTO
  goto L25;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L29;
L27: // INIT_INT
  int_vars[6] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L29;
L29: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__hex_equals_decimal(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.9375;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.9375;
L3: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__hex_exponent(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.05859375;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.05859375;
L3: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L29;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.05859375;
L10: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 0.05859375;
L11: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[2]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_NE_ZERO
  if (int_vars[0]) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L29;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 15.0;
L18: // MOVE_CONSTANT_DOUBLE
  double_vars[3] = 15.0;
L19: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[3]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_NE_ZERO
  if (int_vars[0]) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L29;
L24: // GOTO
  goto L25;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L29;
L27: // INIT_INT
  int_vars[6] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L29;
L29: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__hex_suffix(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.99609375;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.99609375;
L3: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.99609375;
L10: // MOVE_CONSTANT_FLOAT
  float_vars[2] = 0.99609375;
L11: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[2]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_NE_ZERO
  if (int_vars[0]) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__FloatingPoint__hex_underline(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.99609375;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.99609375;
L3: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


