use strict;
use warnings;

use FindBin;
use lib "$FindBin::Bin/common_uc";
$ENV{DBIX_CUSTOM_TEST_RUN} = 1
  if -f "$FindBin::Bin/run/common-oracle.run";
$ENV{DBIX_CUSTOM_SKIP_MESSAGE} = 'oracle private test';

use DBIx::Custom;
{
  package DBIx::Custom;
  no warnings 'redefine';
  
  has option => sub {
    {
      Callbacks => {
        connected => sub {
          shift->do(
              "ALTER SESSION SET NLS_DATE_FORMAT = 'YYYY-MM-DD HH24:MI:SS'"
          );
          return;
        },
      }
    }
  };

  my $table1 = 'TABLE1';
  my $table2 = 'TABLE2';
  my $table2_alias = 'TABLE2_ALIAS';
  my $table3 = 'TABLE3';
  my $key1 = 'KEY1';
  my $key2 = 'KEY2';
  my $key3 = 'KEY3';
  my $key4 = 'KEY4';
  my $key5 = 'KEY5';
  my $key6 = 'KEY6';
  my $key7 = 'KEY7';
  my $key8 = 'KEY8';
  my $key9 = 'KEY9';
  my $key10 = 'KEY10';
  
  has table1 => $table1;
  has table2 => $table2;
  has table2_alias => $table2_alias;
  has table3 => $table3;
  has key1 => $key1;
  has key2 => $key2;
  has key3 => $key3;
  has key4 => $key4;
  has key5 => $key5;
  has key6 => $key6;
  has key7 => $key7;
  has key8 => $key8;
  has key9 => $key9;
  has key10 => $key10;

  my $date_typename = 'CHAR(10)';
  my $datetime_typename = 'DATE';

  sub date_typename { lc 'CHAR' }
  sub datetime_typename { lc $datetime_typename }

  my $date_datatype = 1;
  my $datetime_datatype = 93;

  sub date_datatype { lc $date_datatype }
  sub datetime_datatype { lc $datetime_datatype }

  my @system_tables = qw#
    ABSPATH
    ALERT_TYPE
    ALL_ALL_TABLES
    ALL_ALL_TABLES
    ALL_ANNOTATION_TEXT_METADATA
    ALL_ANNOTATION_TEXT_METADATA
    ALL_APPLY
    ALL_APPLY
    ALL_APPLY_CHANGE_HANDLERS
    ALL_APPLY_CHANGE_HANDLERS
    ALL_APPLY_CONFLICT_COLUMNS
    ALL_APPLY_CONFLICT_COLUMNS
    ALL_APPLY_DML_CONF_HANDLERS
    ALL_APPLY_DML_CONF_HANDLERS
    ALL_APPLY_DML_HANDLERS
    ALL_APPLY_DML_HANDLERS
    ALL_APPLY_ENQUEUE
    ALL_APPLY_ENQUEUE
    ALL_APPLY_ERROR
    ALL_APPLY_ERROR
    ALL_APPLY_ERROR_MESSAGES
    ALL_APPLY_ERROR_MESSAGES
    ALL_APPLY_EXECUTE
    ALL_APPLY_EXECUTE
    ALL_APPLY_KEY_COLUMNS
    ALL_APPLY_KEY_COLUMNS
    ALL_APPLY_PARAMETERS
    ALL_APPLY_PARAMETERS
    ALL_APPLY_PROGRESS
    ALL_APPLY_PROGRESS
    ALL_APPLY_TABLE_COLUMNS
    ALL_APPLY_TABLE_COLUMNS
    ALL_ARGUMENTS
    ALL_ARGUMENTS
    ALL_ASSEMBLIES
    ALL_ASSEMBLIES
    ALL_ASSOCIATIONS
    ALL_ASSOCIATIONS
    ALL_ATTRIBUTE_TRANSFORMATIONS
    ALL_AUDIT_POLICIES
    ALL_AUDIT_POLICIES
    ALL_AUDIT_POLICY_COLUMNS
    ALL_AUDIT_POLICY_COLUMNS
    ALL_AWS
    ALL_AWS
    ALL_AW_PS
    ALL_AW_PS
    ALL_BASE_TABLE_MVIEWS
    ALL_BASE_TABLE_MVIEWS
    ALL_CAPTURE
    ALL_CAPTURE
    ALL_CAPTURE_EXTRA_ATTRIBUTES
    ALL_CAPTURE_EXTRA_ATTRIBUTES
    ALL_CAPTURE_PARAMETERS
    ALL_CAPTURE_PARAMETERS
    ALL_CAPTURE_PREPARED_DATABASE
    ALL_CAPTURE_PREPARED_DATABASE
    ALL_CAPTURE_PREPARED_SCHEMAS
    ALL_CAPTURE_PREPARED_SCHEMAS
    ALL_CAPTURE_PREPARED_TABLES
    ALL_CAPTURE_PREPARED_TABLES
    ALL_CATALOG
    ALL_CATALOG
    ALL_CHANGE_PROPAGATIONS
    ALL_CHANGE_PROPAGATIONS
    ALL_CHANGE_PROPAGATION_SETS
    ALL_CHANGE_PROPAGATION_SETS
    ALL_CHANGE_SETS
    ALL_CHANGE_SETS
    ALL_CHANGE_SOURCES
    ALL_CHANGE_SOURCES
    ALL_CHANGE_TABLES
    ALL_CHANGE_TABLES
    ALL_CLUSTERS
    ALL_CLUSTERS
    ALL_CLUSTER_HASH_EXPRESSIONS
    ALL_CLUSTER_HASH_EXPRESSIONS
    ALL_COLL_TYPES
    ALL_COLL_TYPES
    ALL_COL_COMMENTS
    ALL_COL_COMMENTS
    ALL_COL_PENDING_STATS
    ALL_COL_PENDING_STATS
    ALL_COL_PRIVS
    ALL_COL_PRIVS
    ALL_COL_PRIVS_MADE
    ALL_COL_PRIVS_MADE
    ALL_COL_PRIVS_RECD
    ALL_COL_PRIVS_RECD
    ALL_CONSTRAINTS
    ALL_CONSTRAINTS
    ALL_CONS_COLUMNS
    ALL_CONS_COLUMNS
    ALL_CONS_OBJ_COLUMNS
    ALL_CONS_OBJ_COLUMNS
    ALL_CONTEXT
    ALL_CONTEXT
    ALL_CUBES
    ALL_CUBES
    ALL_CUBE_ATTRIBUTES
    ALL_CUBE_ATTRIBUTES
    ALL_CUBE_ATTR_VISIBILITY
    ALL_CUBE_ATTR_VISIBILITY
    ALL_CUBE_BUILD_PROCESSES
    ALL_CUBE_BUILD_PROCESSES
    ALL_CUBE_CALCULATED_MEMBERS
    ALL_CUBE_CALCULATED_MEMBERS
    ALL_CUBE_DIMENSIONALITY
    ALL_CUBE_DIMENSIONALITY
    ALL_CUBE_DIMENSIONS
    ALL_CUBE_DIMENSIONS
    ALL_CUBE_DIM_LEVELS
    ALL_CUBE_DIM_LEVELS
    ALL_CUBE_DIM_MODELS
    ALL_CUBE_DIM_MODELS
    ALL_CUBE_DIM_VIEWS
    ALL_CUBE_DIM_VIEWS
    ALL_CUBE_DIM_VIEW_COLUMNS
    ALL_CUBE_DIM_VIEW_COLUMNS
    ALL_CUBE_HIERARCHIES
    ALL_CUBE_HIERARCHIES
    ALL_CUBE_HIER_LEVELS
    ALL_CUBE_HIER_LEVELS
    ALL_CUBE_HIER_VIEWS
    ALL_CUBE_HIER_VIEWS
    ALL_CUBE_HIER_VIEW_COLUMNS
    ALL_CUBE_HIER_VIEW_COLUMNS
    ALL_CUBE_MEASURES
    ALL_CUBE_MEASURES
    ALL_CUBE_VIEWS
    ALL_CUBE_VIEWS
    ALL_CUBE_VIEW_COLUMNS
    ALL_CUBE_VIEW_COLUMNS
    ALL_DB_LINKS
    ALL_DB_LINKS
    ALL_DEF_AUDIT_OPTS
    ALL_DEF_AUDIT_OPTS
    ALL_DEPENDENCIES
    ALL_DEPENDENCIES
    ALL_DEQUEUE_QUEUES
    ALL_DEQUEUE_QUEUES
    ALL_DIMENSIONS
    ALL_DIMENSIONS
    ALL_DIM_ATTRIBUTES
    ALL_DIM_ATTRIBUTES
    ALL_DIM_CHILD_OF
    ALL_DIM_CHILD_OF
    ALL_DIM_HIERARCHIES
    ALL_DIM_HIERARCHIES
    ALL_DIM_JOIN_KEY
    ALL_DIM_JOIN_KEY
    ALL_DIM_LEVELS
    ALL_DIM_LEVELS
    ALL_DIM_LEVEL_KEY
    ALL_DIM_LEVEL_KEY
    ALL_DIRECTORIES
    ALL_DIRECTORIES
    ALL_EDITIONING_VIEWS
    ALL_EDITIONING_VIEWS
    ALL_EDITIONING_VIEWS_AE
    ALL_EDITIONING_VIEWS_AE
    ALL_EDITIONING_VIEW_COLS
    ALL_EDITIONING_VIEW_COLS
    ALL_EDITIONING_VIEW_COLS_AE
    ALL_EDITIONING_VIEW_COLS_AE
    ALL_EDITIONS
    ALL_EDITIONS
    ALL_EDITION_COMMENTS
    ALL_EDITION_COMMENTS
    ALL_ENCRYPTED_COLUMNS
    ALL_ENCRYPTED_COLUMNS
    ALL_ERRORS
    ALL_ERRORS
    ALL_ERRORS_AE
    ALL_ERRORS_AE
    ALL_EVALUATION_CONTEXTS
    ALL_EVALUATION_CONTEXTS
    ALL_EVALUATION_CONTEXT_TABLES
    ALL_EVALUATION_CONTEXT_TABLES
    ALL_EVALUATION_CONTEXT_VARS
    ALL_EVALUATION_CONTEXT_VARS
    ALL_EXTERNAL_LOCATIONS
    ALL_EXTERNAL_LOCATIONS
    ALL_EXTERNAL_TABLES
    ALL_EXTERNAL_TABLES
    ALL_FILE_GROUPS
    ALL_FILE_GROUPS
    ALL_FILE_GROUP_EXPORT_INFO
    ALL_FILE_GROUP_EXPORT_INFO
    ALL_FILE_GROUP_FILES
    ALL_FILE_GROUP_FILES
    ALL_FILE_GROUP_TABLES
    ALL_FILE_GROUP_TABLES
    ALL_FILE_GROUP_TABLESPACES
    ALL_FILE_GROUP_TABLESPACES
    ALL_FILE_GROUP_VERSIONS
    ALL_FILE_GROUP_VERSIONS
    ALL_GEOMETRY_COLUMNS
    ALL_GEOMETRY_COLUMNS
    ALL_HISTOGRAMS
    ALL_IDENTIFIERS
    ALL_IDENTIFIERS
    ALL_INDEXES
    ALL_INDEXES
    ALL_INDEXTYPES
    ALL_INDEXTYPES
    ALL_INDEXTYPE_ARRAYTYPES
    ALL_INDEXTYPE_ARRAYTYPES
    ALL_INDEXTYPE_COMMENTS
    ALL_INDEXTYPE_COMMENTS
    ALL_INDEXTYPE_OPERATORS
    ALL_INDEXTYPE_OPERATORS
    ALL_IND_COLUMNS
    ALL_IND_COLUMNS
    ALL_IND_EXPRESSIONS
    ALL_IND_EXPRESSIONS
    ALL_IND_PARTITIONS
    ALL_IND_PARTITIONS
    ALL_IND_PENDING_STATS
    ALL_IND_PENDING_STATS
    ALL_IND_STATISTICS
    ALL_IND_STATISTICS
    ALL_IND_SUBPARTITIONS
    ALL_IND_SUBPARTITIONS
    ALL_INTERNAL_TRIGGERS
    ALL_INTERNAL_TRIGGERS
    ALL_INT_DEQUEUE_QUEUES
    ALL_INT_DEQUEUE_QUEUES
    ALL_JOBS
    ALL_JOIN_IND_COLUMNS
    ALL_JOIN_IND_COLUMNS
    ALL_LIBRARIES
    ALL_LIBRARIES
    ALL_LOBS
    ALL_LOBS
    ALL_LOB_PARTITIONS
    ALL_LOB_PARTITIONS
    ALL_LOB_SUBPARTITIONS
    ALL_LOB_SUBPARTITIONS
    ALL_LOB_TEMPLATES
    ALL_LOB_TEMPLATES
    ALL_LOG_GROUPS
    ALL_LOG_GROUPS
    ALL_LOG_GROUP_COLUMNS
    ALL_LOG_GROUP_COLUMNS
    ALL_MEASURE_FOLDERS
    ALL_MEASURE_FOLDERS
    ALL_MEASURE_FOLDER_CONTENTS
    ALL_MEASURE_FOLDER_CONTENTS
    ALL_METHOD_PARAMS
    ALL_METHOD_PARAMS
    ALL_METHOD_RESULTS
    ALL_METHOD_RESULTS
    ALL_MINING_MODELS
    ALL_MINING_MODELS
    ALL_MINING_MODEL_ATTRIBUTES
    ALL_MINING_MODEL_ATTRIBUTES
    ALL_MINING_MODEL_SETTINGS
    ALL_MINING_MODEL_SETTINGS
    ALL_MVIEWS
    ALL_MVIEWS
    ALL_MVIEW_AGGREGATES
    ALL_MVIEW_AGGREGATES
    ALL_MVIEW_ANALYSIS
    ALL_MVIEW_ANALYSIS
    ALL_MVIEW_COMMENTS
    ALL_MVIEW_COMMENTS
    ALL_MVIEW_DETAIL_PARTITION
    ALL_MVIEW_DETAIL_PARTITION
    ALL_MVIEW_DETAIL_RELATIONS
    ALL_MVIEW_DETAIL_RELATIONS
    ALL_MVIEW_DETAIL_SUBPARTITION
    ALL_MVIEW_DETAIL_SUBPARTITION
    ALL_MVIEW_JOINS
    ALL_MVIEW_JOINS
    ALL_MVIEW_KEYS
    ALL_MVIEW_KEYS
    ALL_MVIEW_LOGS
    ALL_MVIEW_LOGS
    ALL_MVIEW_REFRESH_TIMES
    ALL_MVIEW_REFRESH_TIMES
    ALL_NESTED_TABLES
    ALL_NESTED_TABLES
    ALL_NESTED_TABLE_COLS
    ALL_NESTED_TABLE_COLS
    ALL_OBJECTS
    ALL_OBJECTS
    ALL_OBJECTS_AE
    ALL_OBJECTS_AE
    ALL_OBJECT_TABLES
    ALL_OBJECT_TABLES
    ALL_OBJ_COLATTRS
    ALL_OBJ_COLATTRS
    ALL_OPANCILLARY
    ALL_OPANCILLARY
    ALL_OPARGUMENTS
    ALL_OPARGUMENTS
    ALL_OPBINDINGS
    ALL_OPBINDINGS
    ALL_OPERATORS
    ALL_OPERATORS
    ALL_OPERATOR_COMMENTS
    ALL_OPERATOR_COMMENTS
    ALL_OUTLINES
    ALL_OUTLINE_HINTS
    ALL_PARTIAL_DROP_TABS
    ALL_PARTIAL_DROP_TABS
    ALL_PART_COL_STATISTICS
    ALL_PART_COL_STATISTICS
    ALL_PART_HISTOGRAMS
    ALL_PART_HISTOGRAMS
    ALL_PART_INDEXES
    ALL_PART_INDEXES
    ALL_PART_KEY_COLUMNS
    ALL_PART_KEY_COLUMNS
    ALL_PART_LOBS
    ALL_PART_LOBS
    ALL_PART_TABLES
    ALL_PART_TABLES
    ALL_PATH
    ALL_PENDING_CONV_TABLES
    ALL_PENDING_CONV_TABLES
    ALL_PLSQL_OBJECT_SETTINGS
    ALL_PLSQL_OBJECT_SETTINGS
    ALL_POLICIES
    ALL_POLICIES
    ALL_POLICY_CONTEXTS
    ALL_POLICY_CONTEXTS
    ALL_POLICY_GROUPS
    ALL_POLICY_GROUPS
    ALL_PROBE_OBJECTS
    ALL_PROCEDURES
    ALL_PROCEDURES
    ALL_PROPAGATION
    ALL_PROPAGATION
    ALL_PUBLISHED_COLUMNS
    ALL_QUEUES
    ALL_QUEUES
    ALL_QUEUE_PUBLISHERS
    ALL_QUEUE_PUBLISHERS
    ALL_QUEUE_SCHEDULES
    ALL_QUEUE_SCHEDULES
    ALL_QUEUE_SUBSCRIBERS
    ALL_QUEUE_SUBSCRIBERS
    ALL_QUEUE_TABLES
    ALL_QUEUE_TABLES
    ALL_REFRESH
    ALL_REFRESH
    ALL_REFRESH_CHILDREN
    ALL_REFRESH_CHILDREN
    ALL_REFRESH_DEPENDENCIES
    ALL_REFRESH_DEPENDENCIES
    ALL_REFS
    ALL_REFS
    ALL_REGISTERED_MVIEWS
    ALL_REGISTERED_MVIEWS
    ALL_REGISTERED_SNAPSHOTS
    ALL_REGISTERED_SNAPSHOTS
    ALL_REGISTRY_BANNERS
    ALL_REGISTRY_BANNERS
    ALL_REPAUDIT_ATTRIBUTE
    ALL_REPAUDIT_ATTRIBUTE
    ALL_REPAUDIT_COLUMN
    ALL_REPAUDIT_COLUMN
    ALL_REPCAT
    ALL_REPCAT
    ALL_REPCATLOG
    ALL_REPCATLOG
    ALL_REPCAT_REFRESH_TEMPLATES
    ALL_REPCAT_REFRESH_TEMPLATES
    ALL_REPCAT_TEMPLATE_OBJECTS
    ALL_REPCAT_TEMPLATE_OBJECTS
    ALL_REPCAT_TEMPLATE_PARMS
    ALL_REPCAT_TEMPLATE_PARMS
    ALL_REPCAT_TEMPLATE_SITES
    ALL_REPCAT_TEMPLATE_SITES
    ALL_REPCAT_USER_AUTHORIZATIONS
    ALL_REPCAT_USER_AUTHORIZATIONS
    ALL_REPCAT_USER_PARM_VALUES
    ALL_REPCAT_USER_PARM_VALUES
    ALL_REPCOLUMN
    ALL_REPCOLUMN
    ALL_REPCOLUMN_GROUP
    ALL_REPCOLUMN_GROUP
    ALL_REPCONFLICT
    ALL_REPCONFLICT
    ALL_REPDDL
    ALL_REPDDL
    ALL_REPFLAVORS
    ALL_REPFLAVORS
    ALL_REPFLAVOR_COLUMNS
    ALL_REPFLAVOR_COLUMNS
    ALL_REPFLAVOR_OBJECTS
    ALL_REPFLAVOR_OBJECTS
    ALL_REPGENERATED
    ALL_REPGENERATED
    ALL_REPGENOBJECTS
    ALL_REPGENOBJECTS
    ALL_REPGROUP
    ALL_REPGROUP
    ALL_REPGROUPED_COLUMN
    ALL_REPGROUPED_COLUMN
    ALL_REPGROUP_PRIVILEGES
    ALL_REPGROUP_PRIVILEGES
    ALL_REPKEY_COLUMNS
    ALL_REPKEY_COLUMNS
    ALL_REPOBJECT
    ALL_REPOBJECT
    ALL_REPPARAMETER_COLUMN
    ALL_REPPARAMETER_COLUMN
    ALL_REPPRIORITY
    ALL_REPPRIORITY
    ALL_REPPRIORITY_GROUP
    ALL_REPPRIORITY_GROUP
    ALL_REPPROP
    ALL_REPPROP
    ALL_REPRESOLUTION
    ALL_REPRESOLUTION
    ALL_REPRESOLUTION_METHOD
    ALL_REPRESOLUTION_METHOD
    ALL_REPRESOLUTION_STATISTICS
    ALL_REPRESOLUTION_STATISTICS
    ALL_REPRESOL_STATS_CONTROL
    ALL_REPRESOL_STATS_CONTROL
    ALL_REPSCHEMA
    ALL_REPSCHEMA
    ALL_REPSITES
    ALL_REPSITES
    ALL_REWRITE_EQUIVALENCES
    ALL_REWRITE_EQUIVALENCES
    ALL_RULES
    ALL_RULES
    ALL_RULESETS
    ALL_RULESETS
    ALL_RULE_SETS
    ALL_RULE_SETS
    ALL_RULE_SET_RULES
    ALL_RULE_SET_RULES
    ALL_SCHEDULER_CHAINS
    ALL_SCHEDULER_CHAINS
    ALL_SCHEDULER_CHAIN_RULES
    ALL_SCHEDULER_CHAIN_RULES
    ALL_SCHEDULER_CHAIN_STEPS
    ALL_SCHEDULER_CHAIN_STEPS
    ALL_SCHEDULER_CREDENTIALS
    ALL_SCHEDULER_CREDENTIALS
    ALL_SCHEDULER_DB_DESTS
    ALL_SCHEDULER_DB_DESTS
    ALL_SCHEDULER_DESTS
    ALL_SCHEDULER_DESTS
    ALL_SCHEDULER_EXTERNAL_DESTS
    ALL_SCHEDULER_EXTERNAL_DESTS
    ALL_SCHEDULER_FILE_WATCHERS
    ALL_SCHEDULER_FILE_WATCHERS
    ALL_SCHEDULER_GLOBAL_ATTRIBUTE
    ALL_SCHEDULER_GLOBAL_ATTRIBUTE
    ALL_SCHEDULER_GROUPS
    ALL_SCHEDULER_GROUPS
    ALL_SCHEDULER_GROUP_MEMBERS
    ALL_SCHEDULER_GROUP_MEMBERS
    ALL_SCHEDULER_JOBS
    ALL_SCHEDULER_JOBS
    ALL_SCHEDULER_JOB_ARGS
    ALL_SCHEDULER_JOB_ARGS
    ALL_SCHEDULER_JOB_CLASSES
    ALL_SCHEDULER_JOB_CLASSES
    ALL_SCHEDULER_JOB_DESTS
    ALL_SCHEDULER_JOB_DESTS
    ALL_SCHEDULER_JOB_LOG
    ALL_SCHEDULER_JOB_LOG
    ALL_SCHEDULER_JOB_RUN_DETAILS
    ALL_SCHEDULER_JOB_RUN_DETAILS
    ALL_SCHEDULER_NOTIFICATIONS
    ALL_SCHEDULER_NOTIFICATIONS
    ALL_SCHEDULER_PROGRAMS
    ALL_SCHEDULER_PROGRAMS
    ALL_SCHEDULER_PROGRAM_ARGS
    ALL_SCHEDULER_PROGRAM_ARGS
    ALL_SCHEDULER_REMOTE_DATABASES
    ALL_SCHEDULER_REMOTE_DATABASES
    ALL_SCHEDULER_REMOTE_JOBSTATE
    ALL_SCHEDULER_REMOTE_JOBSTATE
    ALL_SCHEDULER_RUNNING_CHAINS
    ALL_SCHEDULER_RUNNING_CHAINS
    ALL_SCHEDULER_RUNNING_JOBS
    ALL_SCHEDULER_RUNNING_JOBS
    ALL_SCHEDULER_SCHEDULES
    ALL_SCHEDULER_SCHEDULES
    ALL_SCHEDULER_WINDOWS
    ALL_SCHEDULER_WINDOWS
    ALL_SCHEDULER_WINDOW_DETAILS
    ALL_SCHEDULER_WINDOW_DETAILS
    ALL_SCHEDULER_WINDOW_GROUPS
    ALL_SCHEDULER_WINDOW_GROUPS
    ALL_SCHEDULER_WINDOW_LOG
    ALL_SCHEDULER_WINDOW_LOG
    ALL_SCHEDULER_WINGROUP_MEMBERS
    ALL_SCHEDULER_WINGROUP_MEMBERS
    ALL_SDO_3DTHEMES
    ALL_SDO_3DTHEMES
    ALL_SDO_3DTXFMS
    ALL_SDO_3DTXFMS
    ALL_SDO_ANIMATIONS
    ALL_SDO_ANIMATIONS
    ALL_SDO_CACHED_MAPS
    ALL_SDO_CACHED_MAPS
    ALL_SDO_GEOM_METADATA
    ALL_SDO_GEOM_METADATA
    ALL_SDO_INDEX_INFO
    ALL_SDO_INDEX_INFO
    ALL_SDO_INDEX_METADATA
    ALL_SDO_INDEX_METADATA
    ALL_SDO_LIGHTSOURCES
    ALL_SDO_LIGHTSOURCES
    ALL_SDO_LRS_METADATA
    ALL_SDO_LRS_METADATA
    ALL_SDO_MAPS
    ALL_SDO_MAPS
    ALL_SDO_SCENES
    ALL_SDO_SCENES
    ALL_SDO_STYLES
    ALL_SDO_STYLES
    ALL_SDO_THEMES
    ALL_SDO_THEMES
    ALL_SDO_TOPO_INFO
    ALL_SDO_TOPO_INFO
    ALL_SDO_TOPO_METADATA
    ALL_SDO_TOPO_METADATA
    ALL_SDO_VIEWFRAMES
    ALL_SDO_VIEWFRAMES
    ALL_SECONDARY_OBJECTS
    ALL_SECONDARY_OBJECTS
    ALL_SEC_RELEVANT_COLS
    ALL_SEC_RELEVANT_COLS
    ALL_SEQUENCES
    ALL_SEQUENCES
    ALL_SERVICES
    ALL_SERVICES
    ALL_SNAPSHOTS
    ALL_SNAPSHOTS
    ALL_SNAPSHOT_LOGS
    ALL_SNAPSHOT_LOGS
    ALL_SNAPSHOT_REFRESH_TIMES
    ALL_SOURCE
    ALL_SOURCE
    ALL_SOURCE_AE
    ALL_SOURCE_AE
    ALL_SOURCE_TABLES
    ALL_SQLJ_TYPES
    ALL_SQLJ_TYPES
    ALL_SQLJ_TYPE_ATTRS
    ALL_SQLJ_TYPE_ATTRS
    ALL_SQLJ_TYPE_METHODS
    ALL_SQLJ_TYPE_METHODS
    ALL_SQLSET
    ALL_SQLSET
    ALL_SQLSET_BINDS
    ALL_SQLSET_BINDS
    ALL_SQLSET_PLANS
    ALL_SQLSET_PLANS
    ALL_SQLSET_REFERENCES
    ALL_SQLSET_REFERENCES
    ALL_SQLSET_STATEMENTS
    ALL_SQLSET_STATEMENTS
    ALL_STAT_EXTENSIONS
    ALL_STAT_EXTENSIONS
    ALL_STORED_SETTINGS
    ALL_STORED_SETTINGS
    ALL_STREAMS_COLUMNS
    ALL_STREAMS_COLUMNS
    ALL_STREAMS_GLOBAL_RULES
    ALL_STREAMS_GLOBAL_RULES
    ALL_STREAMS_MESSAGE_CONSUMERS
    ALL_STREAMS_MESSAGE_CONSUMERS
    ALL_STREAMS_MESSAGE_RULES
    ALL_STREAMS_MESSAGE_RULES
    ALL_STREAMS_NEWLY_SUPPORTED
    ALL_STREAMS_NEWLY_SUPPORTED
    ALL_STREAMS_RULES
    ALL_STREAMS_RULES
    ALL_STREAMS_SCHEMA_RULES
    ALL_STREAMS_SCHEMA_RULES
    ALL_STREAMS_TABLE_RULES
    ALL_STREAMS_TABLE_RULES
    ALL_STREAMS_TRANSFORM_FUNCTION
    ALL_STREAMS_TRANSFORM_FUNCTION
    ALL_STREAMS_UNSUPPORTED
    ALL_STREAMS_UNSUPPORTED
    ALL_SUBPARTITION_TEMPLATES
    ALL_SUBPARTITION_TEMPLATES
    ALL_SUBPART_COL_STATISTICS
    ALL_SUBPART_COL_STATISTICS
    ALL_SUBPART_HISTOGRAMS
    ALL_SUBPART_HISTOGRAMS
    ALL_SUBPART_KEY_COLUMNS
    ALL_SUBPART_KEY_COLUMNS
    ALL_SUBSCRIBED_COLUMNS
    ALL_SUBSCRIBED_TABLES
    ALL_SUBSCRIPTIONS
    ALL_SUMDELTA
    ALL_SUMDELTA
    ALL_SUMMAP
    ALL_SUMMAP
    ALL_SUMMARIES
    ALL_SUMMARIES
    ALL_SUMMARY_AGGREGATES
    ALL_SUMMARY_AGGREGATES
    ALL_SUMMARY_DETAIL_TABLES
    ALL_SUMMARY_DETAIL_TABLES
    ALL_SUMMARY_JOINS
    ALL_SUMMARY_JOINS
    ALL_SUMMARY_KEYS
    ALL_SUMMARY_KEYS
    ALL_SYNC_CAPTURE
    ALL_SYNC_CAPTURE
    ALL_SYNC_CAPTURE_PREPARED_TABS
    ALL_SYNC_CAPTURE_PREPARED_TABS
    ALL_SYNC_CAPTURE_TABLES
    ALL_SYNC_CAPTURE_TABLES
    ALL_SYNONYMS
    ALL_SYNONYMS
    ALL_TABLES
    ALL_TABLES
    ALL_TAB_COLS
    ALL_TAB_COLS
    ALL_TAB_COLUMNS
    ALL_TAB_COLUMNS
    ALL_TAB_COL_STATISTICS
    ALL_TAB_COL_STATISTICS
    ALL_TAB_COMMENTS
    ALL_TAB_COMMENTS
    ALL_TAB_HISTGRM_PENDING_STATS
    ALL_TAB_HISTGRM_PENDING_STATS
    ALL_TAB_HISTOGRAMS
    ALL_TAB_HISTOGRAMS
    ALL_TAB_MODIFICATIONS
    ALL_TAB_MODIFICATIONS
    ALL_TAB_PARTITIONS
    ALL_TAB_PARTITIONS
    ALL_TAB_PENDING_STATS
    ALL_TAB_PENDING_STATS
    ALL_TAB_PRIVS
    ALL_TAB_PRIVS
    ALL_TAB_PRIVS_MADE
    ALL_TAB_PRIVS_MADE
    ALL_TAB_PRIVS_RECD
    ALL_TAB_PRIVS_RECD
    ALL_TAB_STATISTICS
    ALL_TAB_STATISTICS
    ALL_TAB_STATS_HISTORY
    ALL_TAB_STATS_HISTORY
    ALL_TAB_STAT_PREFS
    ALL_TAB_STAT_PREFS
    ALL_TAB_SUBPARTITIONS
    ALL_TAB_SUBPARTITIONS
    ALL_TRANSFORMATIONS
    ALL_TRIGGERS
    ALL_TRIGGERS
    ALL_TRIGGER_COLS
    ALL_TRIGGER_COLS
    ALL_TRIGGER_ORDERING
    ALL_TRIGGER_ORDERING
    ALL_TSTZ_TABLES
    ALL_TSTZ_TABLES
    ALL_TSTZ_TAB_COLS
    ALL_TSTZ_TAB_COLS
    ALL_TYPES
    ALL_TYPES
    ALL_TYPE_ATTRS
    ALL_TYPE_ATTRS
    ALL_TYPE_METHODS
    ALL_TYPE_METHODS
    ALL_TYPE_VERSIONS
    ALL_TYPE_VERSIONS
    ALL_UNUSED_COL_TABS
    ALL_UNUSED_COL_TABS
    ALL_UPDATABLE_COLUMNS
    ALL_UPDATABLE_COLUMNS
    ALL_USERS
    ALL_USERS
    ALL_USTATS
    ALL_USTATS
    ALL_VARRAYS
    ALL_VARRAYS
    ALL_VIEWS
    ALL_VIEWS
    ALL_VIEWS_AE
    ALL_VIEWS_AE
    ALL_WARNING_SETTINGS
    ALL_WARNING_SETTINGS
    ALL_XDS_ATTRIBUTE_SECS
    ALL_XDS_ATTRIBUTE_SECS
    ALL_XDS_INSTANCE_SETS
    ALL_XDS_INSTANCE_SETS
    ALL_XDS_OBJECTS
    ALL_XDS_OBJECTS
    ALL_XML_INDEXES
    ALL_XML_INDEXES
    ALL_XML_SCHEMAS
    ALL_XML_SCHEMAS
    ALL_XML_SCHEMAS2
    ALL_XML_SCHEMAS2
    ALL_XML_TABLES
    ALL_XML_TABLES
    ALL_XML_TAB_COLS
    ALL_XML_TAB_COLS
    ALL_XML_VIEWS
    ALL_XML_VIEWS
    ALL_XML_VIEW_COLS
    ALL_XML_VIEW_COLS
    ALL_XSC_AGGREGATE_PRIVILEGE
    ALL_XSC_AGGREGATE_PRIVILEGE
    ALL_XSC_PRIVILEGE
    ALL_XSC_PRIVILEGE
    ALL_XSC_SECURITY_CLASS
    ALL_XSC_SECURITY_CLASS
    ALL_XSC_SECURITY_CLASS_DEP
    ALL_XSC_SECURITY_CLASS_DEP
    ALL_XSC_SECURITY_CLASS_STATUS
    ALL_XSC_SECURITY_CLASS_STATUS
    ALL_XSTREAM_INBOUND
    ALL_XSTREAM_INBOUND
    ALL_XSTREAM_INBOUND_PROGRESS
    ALL_XSTREAM_INBOUND_PROGRESS
    ALL_XSTREAM_OUTBOUND
    ALL_XSTREAM_OUTBOUND
    ALL_XSTREAM_OUTBOUND_PROGRESS
    ALL_XSTREAM_OUTBOUND_PROGRESS
    ALL_XSTREAM_RULES
    ALL_XSTREAM_RULES
    ANYDATA
    ANYDATASET
    ANYTYPE
    APEX
    APEX$_ACL
    APEX$_WS_FILES
    APEX$_WS_HISTORY
    APEX$_WS_LINKS
    APEX$_WS_NOTES
    APEX$_WS_ROWS
    APEX$_WS_TAGS
    APEX$_WS_WEBPG_SECTIONS
    APEX$_WS_WEBPG_SECTION_HISTORY
    APEXWS
    APEX_ACTIVITY_LOG
    APEX_ACTIVITY_LOG
    APEX_ADMIN
    APEX_APPLICATION
    APEX_APPLICATION
    APEX_APPLICATIONS
    APEX_APPLICATIONS
    APEX_APPLICATION_ALL_AUTH
    APEX_APPLICATION_ALL_AUTH
    APEX_APPLICATION_AUTH
    APEX_APPLICATION_AUTH
    APEX_APPLICATION_AUTHORIZATION
    APEX_APPLICATION_AUTHORIZATION
    APEX_APPLICATION_BC_ENTRIES
    APEX_APPLICATION_BC_ENTRIES
    APEX_APPLICATION_BREADCRUMBS
    APEX_APPLICATION_BREADCRUMBS
    APEX_APPLICATION_BUILD_OPTIONS
    APEX_APPLICATION_BUILD_OPTIONS
    APEX_APPLICATION_CACHING
    APEX_APPLICATION_CACHING
    APEX_APPLICATION_COMPUTATIONS
    APEX_APPLICATION_COMPUTATIONS
    APEX_APPLICATION_FILES
    APEX_APPLICATION_FILES
    APEX_APPLICATION_GLOBAL
    APEX_APPLICATION_GLOBAL
    APEX_APPLICATION_GROUPS
    APEX_APPLICATION_GROUPS
    APEX_APPLICATION_INSTALL
    APEX_APPLICATION_INSTALL
    APEX_APPLICATION_ITEMS
    APEX_APPLICATION_ITEMS
    APEX_APPLICATION_LISTS
    APEX_APPLICATION_LISTS
    APEX_APPLICATION_LIST_ENTRIES
    APEX_APPLICATION_LIST_ENTRIES
    APEX_APPLICATION_LOVS
    APEX_APPLICATION_LOVS
    APEX_APPLICATION_LOV_ENTRIES
    APEX_APPLICATION_LOV_ENTRIES
    APEX_APPLICATION_NAV_BAR
    APEX_APPLICATION_NAV_BAR
    APEX_APPLICATION_PAGES
    APEX_APPLICATION_PAGES
    APEX_APPLICATION_PAGE_BRANCHES
    APEX_APPLICATION_PAGE_BRANCHES
    APEX_APPLICATION_PAGE_BUTTONS
    APEX_APPLICATION_PAGE_BUTTONS
    APEX_APPLICATION_PAGE_COMP
    APEX_APPLICATION_PAGE_COMP
    APEX_APPLICATION_PAGE_DA
    APEX_APPLICATION_PAGE_DA
    APEX_APPLICATION_PAGE_DA_ACTS
    APEX_APPLICATION_PAGE_DA_ACTS
    APEX_APPLICATION_PAGE_DB_ITEMS
    APEX_APPLICATION_PAGE_DB_ITEMS
    APEX_APPLICATION_PAGE_FLASH5
    APEX_APPLICATION_PAGE_FLASH5
    APEX_APPLICATION_PAGE_FLASH5_S
    APEX_APPLICATION_PAGE_FLASH5_S
    APEX_APPLICATION_PAGE_FLASH_CH
    APEX_APPLICATION_PAGE_FLASH_CH
    APEX_APPLICATION_PAGE_FLASH_S
    APEX_APPLICATION_PAGE_FLASH_S
    APEX_APPLICATION_PAGE_GROUPS
    APEX_APPLICATION_PAGE_GROUPS
    APEX_APPLICATION_PAGE_IR
    APEX_APPLICATION_PAGE_IR
    APEX_APPLICATION_PAGE_IR_CAT
    APEX_APPLICATION_PAGE_IR_CAT
    APEX_APPLICATION_PAGE_IR_CGRPS
    APEX_APPLICATION_PAGE_IR_CGRPS
    APEX_APPLICATION_PAGE_IR_COL
    APEX_APPLICATION_PAGE_IR_COL
    APEX_APPLICATION_PAGE_IR_COMP
    APEX_APPLICATION_PAGE_IR_COMP
    APEX_APPLICATION_PAGE_IR_COND
    APEX_APPLICATION_PAGE_IR_COND
    APEX_APPLICATION_PAGE_IR_GRPBY
    APEX_APPLICATION_PAGE_IR_GRPBY
    APEX_APPLICATION_PAGE_IR_RPT
    APEX_APPLICATION_PAGE_IR_RPT
    APEX_APPLICATION_PAGE_IR_SUB
    APEX_APPLICATION_PAGE_IR_SUB
    APEX_APPLICATION_PAGE_ITEMS
    APEX_APPLICATION_PAGE_ITEMS
    APEX_APPLICATION_PAGE_MAP
    APEX_APPLICATION_PAGE_MAP
    APEX_APPLICATION_PAGE_PROC
    APEX_APPLICATION_PAGE_PROC
    APEX_APPLICATION_PAGE_REGIONS
    APEX_APPLICATION_PAGE_REGIONS
    APEX_APPLICATION_PAGE_RPT
    APEX_APPLICATION_PAGE_RPT
    APEX_APPLICATION_PAGE_RPT_COLS
    APEX_APPLICATION_PAGE_RPT_COLS
    APEX_APPLICATION_PAGE_TREES
    APEX_APPLICATION_PAGE_TREES
    APEX_APPLICATION_PAGE_VAL
    APEX_APPLICATION_PAGE_VAL
    APEX_APPLICATION_PARENT_TABS
    APEX_APPLICATION_PARENT_TABS
    APEX_APPLICATION_PROCESSES
    APEX_APPLICATION_PROCESSES
    APEX_APPLICATION_SHORTCUTS
    APEX_APPLICATION_SHORTCUTS
    APEX_APPLICATION_SUBSTITUTIONS
    APEX_APPLICATION_SUBSTITUTIONS
    APEX_APPLICATION_SUPP_OBJECTS
    APEX_APPLICATION_SUPP_OBJECTS
    APEX_APPLICATION_SUPP_OBJ_BOPT
    APEX_APPLICATION_SUPP_OBJ_BOPT
    APEX_APPLICATION_SUPP_OBJ_CHCK
    APEX_APPLICATION_SUPP_OBJ_CHCK
    APEX_APPLICATION_SUPP_OBJ_SCR
    APEX_APPLICATION_SUPP_OBJ_SCR
    APEX_APPLICATION_TABS
    APEX_APPLICATION_TABS
    APEX_APPLICATION_TEMPLATES
    APEX_APPLICATION_TEMPLATES
    APEX_APPLICATION_TEMP_BC
    APEX_APPLICATION_TEMP_BC
    APEX_APPLICATION_TEMP_BUTTON
    APEX_APPLICATION_TEMP_BUTTON
    APEX_APPLICATION_TEMP_CALENDAR
    APEX_APPLICATION_TEMP_CALENDAR
    APEX_APPLICATION_TEMP_LABEL
    APEX_APPLICATION_TEMP_LABEL
    APEX_APPLICATION_TEMP_LIST
    APEX_APPLICATION_TEMP_LIST
    APEX_APPLICATION_TEMP_PAGE
    APEX_APPLICATION_TEMP_PAGE
    APEX_APPLICATION_TEMP_POPUPLOV
    APEX_APPLICATION_TEMP_POPUPLOV
    APEX_APPLICATION_TEMP_REGION
    APEX_APPLICATION_TEMP_REGION
    APEX_APPLICATION_TEMP_REPORT
    APEX_APPLICATION_TEMP_REPORT
    APEX_APPLICATION_THEMES
    APEX_APPLICATION_THEMES
    APEX_APPLICATION_TRANSLATIONS
    APEX_APPLICATION_TRANSLATIONS
    APEX_APPLICATION_TRANS_MAP
    APEX_APPLICATION_TRANS_MAP
    APEX_APPLICATION_TREES
    APEX_APPLICATION_TREES
    APEX_APPLICATION_WEB_SERVICES
    APEX_APPLICATION_WEB_SERVICES
    APEX_APPL_PLUGINS
    APEX_APPL_PLUGINS
    APEX_APPL_PLUGIN_ATTRIBUTES
    APEX_APPL_PLUGIN_ATTRIBUTES
    APEX_APPL_PLUGIN_ATTR_VALUES
    APEX_APPL_PLUGIN_ATTR_VALUES
    APEX_APPL_PLUGIN_EVENTS
    APEX_APPL_PLUGIN_EVENTS
    APEX_APPL_PLUGIN_FILES
    APEX_APPL_PLUGIN_FILES
    APEX_COLLECTION
    APEX_COLLECTION
    APEX_COLLECTIONS
    APEX_COLLECTIONS
    APEX_COMPONENT_SIGNATURES
    APEX_CSS
    APEX_CSS
    APEX_CUSTOM_AUTH
    APEX_CUSTOM_AUTH
    APEX_DEBUG_MESSAGE
    APEX_DEBUG_MESSAGE
    APEX_DEBUG_MESSAGES
    APEX_DEBUG_MESSAGES
    APEX_DEVELOPER_ACTIVITY_LOG
    APEX_DEVELOPER_ACTIVITY_LOG
    APEX_DEVELOPER_AUDIT_LOG
    APEX_DICTIONARY
    APEX_DICTIONARY
    APEX_FEEDBACK_TYPES
    APEX_FEEDBACK_TYPES
    APEX_INSTANCE_ADMIN
    APEX_INSTANCE_ADMIN
    APEX_ITEM
    APEX_ITEM
    APEX_JAVASCRIPT
    APEX_JAVASCRIPT
    APEX_LANG
    APEX_LANG
    APEX_LDAP
    APEX_LDAP
    APEX_LOGIN
    APEX_LOGIN
    APEX_MAIL
    APEX_MAIL
    APEX_MAIL_ATTACHMENTS
    APEX_MAIL_ATTACHMENTS
    APEX_MAIL_LOG
    APEX_MAIL_LOG
    APEX_MAIL_QUEUE
    APEX_MAIL_QUEUE
    APEX_MIGRATION_ACC_FORMS
    APEX_MIGRATION_ACC_FORMS
    APEX_MIGRATION_ACC_PROJECTS
    APEX_MIGRATION_ACC_PROJECTS
    APEX_MIGRATION_ACC_QUERIES
    APEX_MIGRATION_ACC_QUERIES
    APEX_MIGRATION_ACC_RPTS
    APEX_MIGRATION_ACC_RPTS
    APEX_MIGRATION_ACC_TABLES
    APEX_MIGRATION_ACC_TABLES
    APEX_MIGRATION_PROJECTS
    APEX_MIGRATION_PROJECTS
    APEX_MIGRATION_REV_FORMS
    APEX_MIGRATION_REV_FORMS
    APEX_MIGRATION_REV_QUERIES
    APEX_MIGRATION_REV_QUERIES
    APEX_MIGRATION_REV_RPTS
    APEX_MIGRATION_REV_RPTS
    APEX_MIGRATION_REV_TABLES
    APEX_MIGRATION_REV_TABLES
    APEX_MIG_PROJECTS_UPDATE
    APEX_PLSQL_JOB
    APEX_PLSQL_JOB
    APEX_PLSQL_JOBS
    APEX_PLSQL_JOBS
    APEX_PLUGIN
    APEX_PLUGIN
    APEX_PLUGIN_UTIL
    APEX_PLUGIN_UTIL
    APEX_RELEASE
    APEX_RELEASE
    APEX_REST
    APEX_REST
    APEX_SITE_ADMIN_PRIVS
    APEX_SITE_ADMIN_PRIVS
    APEX_STANDARD_CONDITIONS
    APEX_STANDARD_CONDITIONS
    APEX_TEAM_BUGS
    APEX_TEAM_BUGS
    APEX_TEAM_FEATURES
    APEX_TEAM_FEATURES
    APEX_TEAM_FEEDBACK
    APEX_TEAM_FEEDBACK
    APEX_TEAM_FEEDBACK_FOLLOWUP
    APEX_TEAM_FEEDBACK_FOLLOWUP
    APEX_TEAM_MILESTONES
    APEX_TEAM_MILESTONES
    APEX_TEAM_TODOS
    APEX_TEAM_TODOS
    APEX_THEMES
    APEX_THEMES
    APEX_UI_DEFAULT
    APEX_UI_DEFAULT
    APEX_UI_DEFAULTS_ATTR_DICT
    APEX_UI_DEFAULTS_ATTR_DICT
    APEX_UI_DEFAULTS_COLUMNS
    APEX_UI_DEFAULTS_COLUMNS
    APEX_UI_DEFAULTS_GROUPS
    APEX_UI_DEFAULTS_GROUPS
    APEX_UI_DEFAULTS_LOV_DATA
    APEX_UI_DEFAULTS_LOV_DATA
    APEX_UI_DEFAULTS_TABLES
    APEX_UI_DEFAULTS_TABLES
    APEX_UI_DEFAULT_UPDATE
    APEX_USER_ACCESS_LOG
    APEX_USER_ACCESS_LOG
    APEX_UTIL
    APEX_UTIL
    APEX_WEB_SERVICE
    APEX_WEB_SERVICE
    APEX_WORKSPACES
    APEX_WORKSPACES
    APEX_WORKSPACE_ACCESS_LOG
    APEX_WORKSPACE_ACCESS_LOG
    APEX_WORKSPACE_ACTIVITY_LOG
    APEX_WORKSPACE_ACTIVITY_LOG
    APEX_WORKSPACE_APEX_USERS
    APEX_WORKSPACE_APEX_USERS
    APEX_WORKSPACE_CLICKS
    APEX_WORKSPACE_CLICKS
    APEX_WORKSPACE_DEVELOPERS
    APEX_WORKSPACE_DEVELOPERS
    APEX_WORKSPACE_FILES
    APEX_WORKSPACE_FILES
    APEX_WORKSPACE_LOG_ARCHIVE
    APEX_WORKSPACE_LOG_ARCHIVE
    APEX_WORKSPACE_LOG_SUMMARY
    APEX_WORKSPACE_LOG_SUMMARY
    APEX_WORKSPACE_LOG_SUMMARY_USR
    APEX_WORKSPACE_LOG_SUMMARY_USR
    APEX_WORKSPACE_SCHEMAS
    APEX_WORKSPACE_SCHEMAS
    APEX_WORKSPACE_SESSIONS
    APEX_WORKSPACE_SESSIONS
    APEX_WORKSPACE_SQL_SCRIPTS
    APEX_WORKSPACE_SQL_SCRIPTS
    APEX_WS_APPLICATIONS
    APEX_WS_APPLICATIONS
    APEX_WS_APP_PAGES
    APEX_WS_APP_PAGES
    APEX_WS_DATA_GRID
    APEX_WS_DATA_GRID
    APEX_WS_DATA_GRID_COL
    APEX_WS_DATA_GRID_COL
    AQ$INTERNET_USERS
    AQ$INTERNET_USERS
    AREA
    ASBINARY
    ASTEXT
    AUDIT_ACTIONS
    AUDIT_ACTIONS
    AWRDRPT_TEXT_TYPE
    AWRDRPT_TEXT_TYPE_TABLE
    AWRRPT_CLB_ARY
    AWRRPT_HTML_TYPE
    AWRRPT_HTML_TYPE_TABLE
    AWRRPT_NUM_ARY
    AWRRPT_ROW_TYPE
    AWRRPT_TEXT_TYPE
    AWRRPT_TEXT_TYPE_TABLE
    AWRRPT_VCH_ARY
    AWRSQRPT_TEXT_TYPE
    AWRSQRPT_TEXT_TYPE_TABLE
    BOUNDARY
    BUFFER
    CAT
    CATALOG
    CATALOG
    CATSEARCH
    CENTROID
    CHANGE_PROPAGATIONS
    CHANGE_PROPAGATION_SETS
    CHANGE_SETS
    CHANGE_SOURCES
    CHANGE_TABLES
    CIRCULARSTRING
    CLU
    CLU$
    CLUSTER_DATABASES
    CLUSTER_INSTANCES
    CLUSTER_NODES
    COL
    COL
    COL
    COL$
    COLLECT
    COLLECTION$
    COLS
    COLTYPE$
    COLUMN_PRIVILEGES
    COLUMN_PRIVILEGES
    COL_GROUP_USAGE$
    COL_USAGE$
    COMPOUNDCURVE
    CONTAINS
    CONTENTSCHEMAIS
    CONTEXT$
    CONVEXHULL
    CROSS
    CS_SRS
    CS_SRS
    CTX_CLASSES
    CTX_CLASSES
    CTX_CLS
    CTX_DDL
    CTX_DOC
    CTX_INDEX_SETS
    CTX_INDEX_SETS
    CTX_INDEX_SET_INDEXES
    CTX_INDEX_SET_INDEXES
    CTX_OBJECTS
    CTX_OBJECTS
    CTX_OBJECT_ATTRIBUTES
    CTX_OBJECT_ATTRIBUTES
    CTX_OBJECT_ATTRIBUTE_LOV
    CTX_OBJECT_ATTRIBUTE_LOV
    CTX_OUTPUT
    CTX_PARAMETERS
    CTX_PARAMETERS
    CTX_PREFERENCES
    CTX_PREFERENCES
    CTX_PREFERENCE_VALUES
    CTX_PREFERENCE_VALUES
    CTX_QUERY
    CTX_REPORT
    CTX_SECTIONS
    CTX_SECTIONS
    CTX_SECTION_GROUPS
    CTX_SECTION_GROUPS
    CTX_SQES
    CTX_SQES
    CTX_STOPLISTS
    CTX_STOPLISTS
    CTX_STOPWORDS
    CTX_STOPWORDS
    CTX_SUB_LEXERS
    CTX_SUB_LEXERS
    CTX_THES
    CTX_THESAURI
    CTX_THESAURI
    CTX_THES_PHRASES
    CTX_THES_PHRASES
    CTX_TRACE_VALUES
    CTX_TRACE_VALUES
    CTX_ULEXER
    CTX_USER_INDEXES
    CTX_USER_INDEXES
    CTX_USER_INDEX_ERRORS
    CTX_USER_INDEX_ERRORS
    CTX_USER_INDEX_OBJECTS
    CTX_USER_INDEX_OBJECTS
    CTX_USER_INDEX_PARTITIONS
    CTX_USER_INDEX_PARTITIONS
    CTX_USER_INDEX_SETS
    CTX_USER_INDEX_SETS
    CTX_USER_INDEX_SET_INDEXES
    CTX_USER_INDEX_SET_INDEXES
    CTX_USER_INDEX_SUB_LEXERS
    CTX_USER_INDEX_SUB_LEXERS
    CTX_USER_INDEX_SUB_LEXER_VALS
    CTX_USER_INDEX_SUB_LEXER_VALS
    CTX_USER_INDEX_VALUES
    CTX_USER_INDEX_VALUES
    CTX_USER_PENDING
    CTX_USER_PENDING
    CTX_USER_PREFERENCES
    CTX_USER_PREFERENCES
    CTX_USER_PREFERENCE_VALUES
    CTX_USER_PREFERENCE_VALUES
    CTX_USER_SECTIONS
    CTX_USER_SECTIONS
    CTX_USER_SECTION_GROUPS
    CTX_USER_SECTION_GROUPS
    CTX_USER_SQES
    CTX_USER_SQES
    CTX_USER_STOPLISTS
    CTX_USER_STOPLISTS
    CTX_USER_STOPWORDS
    CTX_USER_STOPWORDS
    CTX_USER_SUB_LEXERS
    CTX_USER_SUB_LEXERS
    CTX_USER_THESAURI
    CTX_USER_THESAURI
    CTX_USER_THES_PHRASES
    CTX_USER_THES_PHRASES
    CURVE
    CURVEPOLYGON
    DATABASE_COMPATIBLE_LEVEL
    DATABASE_COMPATIBLE_LEVEL
    DATABASE_EXPORT_OBJECTS
    DATABASE_EXPORT_OBJECTS
    DATABASE_PROPERTIES
    DATABASE_PROPERTIES
    DATAPUMP_DDL_TRANSFORM_PARAMS
    DATAPUMP_OBJECT_CONNECT
    DATAPUMP_OBJECT_CONNECT
    DATAPUMP_PATHMAP
    DATAPUMP_PATHMAP
    DATAPUMP_PATHS
    DATAPUMP_PATHS
    DATAPUMP_REMAP_OBJECTS
    DATAPUMP_REMAP_OBJECTS
    DATAPUMP_TABLE_DATA
    DATAPUMP_TABLE_DATA
    DBA_2PC_NEIGHBORS
    DBA_2PC_NEIGHBORS
    DBA_2PC_PENDING
    DBA_2PC_PENDING
    DBA_ADDM_FDG_BREAKDOWN
    DBA_ADDM_FDG_BREAKDOWN
    DBA_ADDM_FINDINGS
    DBA_ADDM_FINDINGS
    DBA_ADDM_INSTANCES
    DBA_ADDM_INSTANCES
    DBA_ADDM_SYSTEM_DIRECTIVES
    DBA_ADDM_SYSTEM_DIRECTIVES
    DBA_ADDM_TASKS
    DBA_ADDM_TASKS
    DBA_ADDM_TASK_DIRECTIVES
    DBA_ADDM_TASK_DIRECTIVES
    DBA_ADVISOR_ACTIONS
    DBA_ADVISOR_ACTIONS
    DBA_ADVISOR_COMMANDS
    DBA_ADVISOR_COMMANDS
    DBA_ADVISOR_DEFINITIONS
    DBA_ADVISOR_DEFINITIONS
    DBA_ADVISOR_DEF_PARAMETERS
    DBA_ADVISOR_DEF_PARAMETERS
    DBA_ADVISOR_DIR_DEFINITIONS
    DBA_ADVISOR_DIR_DEFINITIONS
    DBA_ADVISOR_DIR_INSTANCES
    DBA_ADVISOR_DIR_INSTANCES
    DBA_ADVISOR_DIR_TASK_INST
    DBA_ADVISOR_DIR_TASK_INST
    DBA_ADVISOR_EXECUTIONS
    DBA_ADVISOR_EXECUTIONS
    DBA_ADVISOR_EXECUTION_TYPES
    DBA_ADVISOR_EXECUTION_TYPES
    DBA_ADVISOR_EXEC_PARAMETERS
    DBA_ADVISOR_EXEC_PARAMETERS
    DBA_ADVISOR_FDG_BREAKDOWN
    DBA_ADVISOR_FDG_BREAKDOWN
    DBA_ADVISOR_FINDINGS
    DBA_ADVISOR_FINDINGS
    DBA_ADVISOR_FINDING_NAMES
    DBA_ADVISOR_FINDING_NAMES
    DBA_ADVISOR_JOURNAL
    DBA_ADVISOR_JOURNAL
    DBA_ADVISOR_LOG
    DBA_ADVISOR_LOG
    DBA_ADVISOR_OBJECTS
    DBA_ADVISOR_OBJECTS
    DBA_ADVISOR_OBJECT_TYPES
    DBA_ADVISOR_OBJECT_TYPES
    DBA_ADVISOR_PARAMETERS
    DBA_ADVISOR_PARAMETERS
    DBA_ADVISOR_PARAMETERS_PROJ
    DBA_ADVISOR_PARAMETERS_PROJ
    DBA_ADVISOR_RATIONALE
    DBA_ADVISOR_RATIONALE
    DBA_ADVISOR_RECOMMENDATIONS
    DBA_ADVISOR_RECOMMENDATIONS
    DBA_ADVISOR_SQLA_COLVOL
    DBA_ADVISOR_SQLA_COLVOL
    DBA_ADVISOR_SQLA_REC_SUM
    DBA_ADVISOR_SQLA_REC_SUM
    DBA_ADVISOR_SQLA_TABLES
    DBA_ADVISOR_SQLA_TABLES
    DBA_ADVISOR_SQLA_TABVOL
    DBA_ADVISOR_SQLA_TABVOL
    DBA_ADVISOR_SQLA_WK_MAP
    DBA_ADVISOR_SQLA_WK_MAP
    DBA_ADVISOR_SQLA_WK_STMTS
    DBA_ADVISOR_SQLA_WK_STMTS
    DBA_ADVISOR_SQLA_WK_SUM
    DBA_ADVISOR_SQLA_WK_SUM
    DBA_ADVISOR_SQLPLANS
    DBA_ADVISOR_SQLPLANS
    DBA_ADVISOR_SQLSTATS
    DBA_ADVISOR_SQLSTATS
    DBA_ADVISOR_SQLW_COLVOL
    DBA_ADVISOR_SQLW_COLVOL
    DBA_ADVISOR_SQLW_JOURNAL
    DBA_ADVISOR_SQLW_JOURNAL
    DBA_ADVISOR_SQLW_PARAMETERS
    DBA_ADVISOR_SQLW_PARAMETERS
    DBA_ADVISOR_SQLW_STMTS
    DBA_ADVISOR_SQLW_STMTS
    DBA_ADVISOR_SQLW_SUM
    DBA_ADVISOR_SQLW_SUM
    DBA_ADVISOR_SQLW_TABLES
    DBA_ADVISOR_SQLW_TABLES
    DBA_ADVISOR_SQLW_TABVOL
    DBA_ADVISOR_SQLW_TABVOL
    DBA_ADVISOR_SQLW_TEMPLATES
    DBA_ADVISOR_SQLW_TEMPLATES
    DBA_ADVISOR_TASKS
    DBA_ADVISOR_TASKS
    DBA_ADVISOR_TEMPLATES
    DBA_ADVISOR_TEMPLATES
    DBA_ADVISOR_USAGE
    DBA_ADVISOR_USAGE
    DBA_ALERT_ARGUMENTS
    DBA_ALERT_ARGUMENTS
    DBA_ALERT_HISTORY
    DBA_ALERT_HISTORY
    DBA_ALL_TABLES
    DBA_ALL_TABLES
    DBA_ANALYZE_OBJECTS
    DBA_APPLICATION_ROLES
    DBA_APPLICATION_ROLES
    DBA_APPLY
    DBA_APPLY
    DBA_APPLY_CHANGE_HANDLERS
    DBA_APPLY_CHANGE_HANDLERS
    DBA_APPLY_CONFLICT_COLUMNS
    DBA_APPLY_CONFLICT_COLUMNS
    DBA_APPLY_DML_CONF_HANDLERS
    DBA_APPLY_DML_CONF_HANDLERS
    DBA_APPLY_DML_HANDLERS
    DBA_APPLY_DML_HANDLERS
    DBA_APPLY_ENQUEUE
    DBA_APPLY_ENQUEUE
    DBA_APPLY_ERROR
    DBA_APPLY_ERROR
    DBA_APPLY_ERROR_MESSAGES
    DBA_APPLY_ERROR_MESSAGES
    DBA_APPLY_EXECUTE
    DBA_APPLY_EXECUTE
    DBA_APPLY_INSTANTIATED_GLOBAL
    DBA_APPLY_INSTANTIATED_GLOBAL
    DBA_APPLY_INSTANTIATED_OBJECTS
    DBA_APPLY_INSTANTIATED_OBJECTS
    DBA_APPLY_INSTANTIATED_SCHEMAS
    DBA_APPLY_INSTANTIATED_SCHEMAS
    DBA_APPLY_KEY_COLUMNS
    DBA_APPLY_KEY_COLUMNS
    DBA_APPLY_OBJECT_DEPENDENCIES
    DBA_APPLY_PARAMETERS
    DBA_APPLY_PARAMETERS
    DBA_APPLY_PROGRESS
    DBA_APPLY_PROGRESS
    DBA_APPLY_SPILL_TXN
    DBA_APPLY_SPILL_TXN
    DBA_APPLY_TABLE_COLUMNS
    DBA_APPLY_TABLE_COLUMNS
    DBA_APPLY_VALUE_DEPENDENCIES
    DBA_AQ_AGENTS
    DBA_AQ_AGENTS
    DBA_AQ_AGENT_PRIVS
    DBA_AQ_AGENT_PRIVS
    DBA_ARGUMENTS
    DBA_ARGUMENTS
    DBA_ARGUMENTS
    DBA_ASSEMBLIES
    DBA_ASSEMBLIES
    DBA_ASSOCIATIONS
    DBA_ASSOCIATIONS
    DBA_ATTRIBUTE_TRANSFORMATIONS
    DBA_AUDIT_EXISTS
    DBA_AUDIT_EXISTS
    DBA_AUDIT_MGMT_CLEANUP_JOBS
    DBA_AUDIT_MGMT_CLEANUP_JOBS
    DBA_AUDIT_MGMT_CLEAN_EVENTS
    DBA_AUDIT_MGMT_CLEAN_EVENTS
    DBA_AUDIT_MGMT_CONFIG_PARAMS
    DBA_AUDIT_MGMT_CONFIG_PARAMS
    DBA_AUDIT_MGMT_LAST_ARCH_TS
    DBA_AUDIT_MGMT_LAST_ARCH_TS
    DBA_AUDIT_OBJECT
    DBA_AUDIT_OBJECT
    DBA_AUDIT_POLICIES
    DBA_AUDIT_POLICIES
    DBA_AUDIT_POLICY_COLUMNS
    DBA_AUDIT_POLICY_COLUMNS
    DBA_AUDIT_SESSION
    DBA_AUDIT_SESSION
    DBA_AUDIT_STATEMENT
    DBA_AUDIT_STATEMENT
    DBA_AUDIT_TRAIL
    DBA_AUDIT_TRAIL
    DBA_AUTOTASK_CLIENT
    DBA_AUTOTASK_CLIENT
    DBA_AUTOTASK_CLIENT_HISTORY
    DBA_AUTOTASK_CLIENT_HISTORY
    DBA_AUTOTASK_CLIENT_JOB
    DBA_AUTOTASK_CLIENT_JOB
    DBA_AUTOTASK_JOB_HISTORY
    DBA_AUTOTASK_JOB_HISTORY
    DBA_AUTOTASK_OPERATION
    DBA_AUTOTASK_OPERATION
    DBA_AUTOTASK_SCHEDULE
    DBA_AUTOTASK_SCHEDULE
    DBA_AUTOTASK_TASK
    DBA_AUTOTASK_TASK
    DBA_AUTOTASK_WINDOW_CLIENTS
    DBA_AUTOTASK_WINDOW_CLIENTS
    DBA_AUTOTASK_WINDOW_HISTORY
    DBA_AUTOTASK_WINDOW_HISTORY
    DBA_AUTO_SEGADV_CTL
    DBA_AUTO_SEGADV_CTL
    DBA_AUTO_SEGADV_SUMMARY
    DBA_AUTO_SEGADV_SUMMARY
    DBA_AWS
    DBA_AWS
    DBA_AW_PS
    DBA_AW_PS
    DBA_BASE_TABLE_MVIEWS
    DBA_BASE_TABLE_MVIEWS
    DBA_BLOCKERS
    DBA_BLOCKERS
    DBA_CAPTURE
    DBA_CAPTURE
    DBA_CAPTURE_EXTRA_ATTRIBUTES
    DBA_CAPTURE_EXTRA_ATTRIBUTES
    DBA_CAPTURE_PARAMETERS
    DBA_CAPTURE_PARAMETERS
    DBA_CAPTURE_PREPARED_DATABASE
    DBA_CAPTURE_PREPARED_DATABASE
    DBA_CAPTURE_PREPARED_SCHEMAS
    DBA_CAPTURE_PREPARED_SCHEMAS
    DBA_CAPTURE_PREPARED_TABLES
    DBA_CAPTURE_PREPARED_TABLES
    DBA_CATALOG
    DBA_CATALOG
    DBA_CHANGE_NOTIFICATION_REGS
    DBA_CHANGE_NOTIFICATION_REGS
    DBA_CLUSTERS
    DBA_CLUSTERS
    DBA_CLUSTER_HASH_EXPRESSIONS
    DBA_CLUSTER_HASH_EXPRESSIONS
    DBA_CLU_COLUMNS
    DBA_CLU_COLUMNS
    DBA_COLL_TYPES
    DBA_COLL_TYPES
    DBA_COL_COMMENTS
    DBA_COL_COMMENTS
    DBA_COL_PENDING_STATS
    DBA_COL_PENDING_STATS
    DBA_COL_PRIVS
    DBA_COL_PRIVS
    DBA_COMMON_AUDIT_TRAIL
    DBA_COMMON_AUDIT_TRAIL
    DBA_COMPARISON
    DBA_COMPARISON
    DBA_COMPARISON_COLUMNS
    DBA_COMPARISON_COLUMNS
    DBA_COMPARISON_ROW_DIF
    DBA_COMPARISON_ROW_DIF
    DBA_COMPARISON_SCAN
    DBA_COMPARISON_SCAN
    DBA_COMPARISON_SCAN_SUMMARY
    DBA_COMPARISON_SCAN_SUMMARY
    DBA_COMPARISON_SCAN_VALUES
    DBA_COMPARISON_SCAN_VALUES
    DBA_CONNECT_ROLE_GRANTEES
    DBA_CONNECT_ROLE_GRANTEES
    DBA_CONSTRAINTS
    DBA_CONSTRAINTS
    DBA_CONS_COLUMNS
    DBA_CONS_COLUMNS
    DBA_CONS_OBJ_COLUMNS
    DBA_CONS_OBJ_COLUMNS
    DBA_CONTEXT
    DBA_CONTEXT
    DBA_CPOOL_INFO
    DBA_CPOOL_INFO
    DBA_CPU_USAGE_STATISTICS
    DBA_CPU_USAGE_STATISTICS
    DBA_CQ_NOTIFICATION_QUERIES
    DBA_CQ_NOTIFICATION_QUERIES
    DBA_CUBES
    DBA_CUBES
    DBA_CUBE_ATTRIBUTES
    DBA_CUBE_ATTRIBUTES
    DBA_CUBE_ATTR_VISIBILITY
    DBA_CUBE_ATTR_VISIBILITY
    DBA_CUBE_BUILD_PROCESSES
    DBA_CUBE_BUILD_PROCESSES
    DBA_CUBE_CALCULATED_MEMBERS
    DBA_CUBE_CALCULATED_MEMBERS
    DBA_CUBE_DIMENSIONALITY
    DBA_CUBE_DIMENSIONALITY
    DBA_CUBE_DIMENSIONS
    DBA_CUBE_DIMENSIONS
    DBA_CUBE_DIM_LEVELS
    DBA_CUBE_DIM_LEVELS
    DBA_CUBE_DIM_MODELS
    DBA_CUBE_DIM_MODELS
    DBA_CUBE_DIM_VIEWS
    DBA_CUBE_DIM_VIEWS
    DBA_CUBE_DIM_VIEW_COLUMNS
    DBA_CUBE_DIM_VIEW_COLUMNS
    DBA_CUBE_HIERARCHIES
    DBA_CUBE_HIERARCHIES
    DBA_CUBE_HIER_LEVELS
    DBA_CUBE_HIER_LEVELS
    DBA_CUBE_HIER_VIEWS
    DBA_CUBE_HIER_VIEWS
    DBA_CUBE_HIER_VIEW_COLUMNS
    DBA_CUBE_HIER_VIEW_COLUMNS
    DBA_CUBE_MEASURES
    DBA_CUBE_MEASURES
    DBA_CUBE_VIEWS
    DBA_CUBE_VIEWS
    DBA_CUBE_VIEW_COLUMNS
    DBA_CUBE_VIEW_COLUMNS
    DBA_DATAPUMP_JOBS
    DBA_DATAPUMP_JOBS
    DBA_DATAPUMP_SESSIONS
    DBA_DATAPUMP_SESSIONS
    DBA_DATA_FILES
    DBA_DATA_FILES
    DBA_DBFS_HS
    DBA_DBFS_HS
    DBA_DBFS_HS_COMMANDS
    DBA_DBFS_HS_COMMANDS
    DBA_DBFS_HS_FIXED_PROPERTIES
    DBA_DBFS_HS_FIXED_PROPERTIES
    DBA_DBFS_HS_PROPERTIES
    DBA_DBFS_HS_PROPERTIES
    DBA_DB_LINKS
    DBA_DB_LINKS
    DBA_DDL_LOCKS
    DBA_DDL_LOCKS
    DBA_DEPENDENCIES
    DBA_DEPENDENCIES
    DBA_DIMENSIONS
    DBA_DIMENSIONS
    DBA_DIM_ATTRIBUTES
    DBA_DIM_ATTRIBUTES
    DBA_DIM_CHILD_OF
    DBA_DIM_CHILD_OF
    DBA_DIM_HIERARCHIES
    DBA_DIM_HIERARCHIES
    DBA_DIM_JOIN_KEY
    DBA_DIM_JOIN_KEY
    DBA_DIM_LEVELS
    DBA_DIM_LEVELS
    DBA_DIM_LEVEL_KEY
    DBA_DIM_LEVEL_KEY
    DBA_DIRECTORIES
    DBA_DIRECTORIES
    DBA_DML_LOCKS
    DBA_DML_LOCKS
    DBA_DMT_FREE_SPACE
    DBA_DMT_FREE_SPACE
    DBA_DMT_USED_EXTENTS
    DBA_DMT_USED_EXTENTS
    DBA_EDITIONING_VIEWS
    DBA_EDITIONING_VIEWS
    DBA_EDITIONING_VIEWS_AE
    DBA_EDITIONING_VIEWS_AE
    DBA_EDITIONING_VIEW_COLS
    DBA_EDITIONING_VIEW_COLS
    DBA_EDITIONING_VIEW_COLS_AE
    DBA_EDITIONING_VIEW_COLS_AE
    DBA_EDITIONS
    DBA_EDITIONS
    DBA_EDITION_COMMENTS
    DBA_EDITION_COMMENTS
    DBA_ENABLED_AGGREGATIONS
    DBA_ENABLED_AGGREGATIONS
    DBA_ENABLED_TRACES
    DBA_ENABLED_TRACES
    DBA_ENCRYPTED_COLUMNS
    DBA_ENCRYPTED_COLUMNS
    DBA_EPG_DAD_AUTHORIZATION
    DBA_EPG_DAD_AUTHORIZATION
    DBA_ERRORS
    DBA_ERRORS
    DBA_ERRORS_AE
    DBA_ERRORS_AE
    DBA_EVALUATION_CONTEXTS
    DBA_EVALUATION_CONTEXTS
    DBA_EVALUATION_CONTEXT_TABLES
    DBA_EVALUATION_CONTEXT_TABLES
    DBA_EVALUATION_CONTEXT_VARS
    DBA_EVALUATION_CONTEXT_VARS
    DBA_EXPORT_OBJECTS
    DBA_EXPORT_OBJECTS
    DBA_EXPORT_PATHS
    DBA_EXPORT_PATHS
    DBA_EXP_FILES
    DBA_EXP_FILES
    DBA_EXP_OBJECTS
    DBA_EXP_OBJECTS
    DBA_EXP_VERSION
    DBA_EXP_VERSION
    DBA_EXTENTS
    DBA_EXTENTS
    DBA_EXTERNAL_LOCATIONS
    DBA_EXTERNAL_LOCATIONS
    DBA_EXTERNAL_TABLES
    DBA_EXTERNAL_TABLES
    DBA_FEATURE_USAGE_STATISTICS
    DBA_FEATURE_USAGE_STATISTICS
    DBA_FGA_AUDIT_TRAIL
    DBA_FGA_AUDIT_TRAIL
    DBA_FILE_GROUPS
    DBA_FILE_GROUPS
    DBA_FILE_GROUP_EXPORT_INFO
    DBA_FILE_GROUP_EXPORT_INFO
    DBA_FILE_GROUP_FILES
    DBA_FILE_GROUP_FILES
    DBA_FILE_GROUP_TABLES
    DBA_FILE_GROUP_TABLES
    DBA_FILE_GROUP_TABLESPACES
    DBA_FILE_GROUP_TABLESPACES
    DBA_FILE_GROUP_VERSIONS
    DBA_FILE_GROUP_VERSIONS
    DBA_FLASHBACK_ARCHIVE
    DBA_FLASHBACK_ARCHIVE
    DBA_FLASHBACK_ARCHIVE_TABLES
    DBA_FLASHBACK_ARCHIVE_TABLES
    DBA_FLASHBACK_ARCHIVE_TS
    DBA_FLASHBACK_ARCHIVE_TS
    DBA_FLASHBACK_TXN_REPORT
    DBA_FLASHBACK_TXN_REPORT
    DBA_FLASHBACK_TXN_STATE
    DBA_FLASHBACK_TXN_STATE
    DBA_FREE_SPACE
    DBA_FREE_SPACE
    DBA_FREE_SPACE_COALESCED
    DBA_FREE_SPACE_COALESCED
    DBA_FREE_SPACE_COALESCED_TMP1
    DBA_FREE_SPACE_COALESCED_TMP2
    DBA_FREE_SPACE_COALESCED_TMP3
    DBA_FREE_SPACE_COALESCED_TMP4
    DBA_FREE_SPACE_COALESCED_TMP5
    DBA_FREE_SPACE_COALESCED_TMP6
    DBA_GEOMETRY_COLUMNS
    DBA_GEOMETRY_COLUMNS
    DBA_GLOBAL_CONTEXT
    DBA_GLOBAL_CONTEXT
    DBA_GOLDENGATE_PRIVILEGES
    DBA_GOLDENGATE_PRIVILEGES
    DBA_HIGH_WATER_MARK_STATISTICS
    DBA_HIGH_WATER_MARK_STATISTICS
    DBA_HISTOGRAMS
    DBA_HIST_ACTIVE_SESS_HISTORY
    DBA_HIST_ACTIVE_SESS_HISTORY
    DBA_HIST_ASH_SNAPSHOT
    DBA_HIST_ASH_SNAPSHOT
    DBA_HIST_BASELINE
    DBA_HIST_BASELINE
    DBA_HIST_BASELINE_DETAILS
    DBA_HIST_BASELINE_DETAILS
    DBA_HIST_BASELINE_METADATA
    DBA_HIST_BASELINE_METADATA
    DBA_HIST_BASELINE_TEMPLATE
    DBA_HIST_BASELINE_TEMPLATE
    DBA_HIST_BG_EVENT_SUMMARY
    DBA_HIST_BG_EVENT_SUMMARY
    DBA_HIST_BUFFERED_QUEUES
    DBA_HIST_BUFFERED_QUEUES
    DBA_HIST_BUFFERED_SUBSCRIBERS
    DBA_HIST_BUFFERED_SUBSCRIBERS
    DBA_HIST_BUFFER_POOL_STAT
    DBA_HIST_BUFFER_POOL_STAT
    DBA_HIST_CLUSTER_INTERCON
    DBA_HIST_CLUSTER_INTERCON
    DBA_HIST_COLORED_SQL
    DBA_HIST_COLORED_SQL
    DBA_HIST_COMP_IOSTAT
    DBA_HIST_COMP_IOSTAT
    DBA_HIST_CR_BLOCK_SERVER
    DBA_HIST_CR_BLOCK_SERVER
    DBA_HIST_CURRENT_BLOCK_SERVER
    DBA_HIST_CURRENT_BLOCK_SERVER
    DBA_HIST_DATABASE_INSTANCE
    DBA_HIST_DATABASE_INSTANCE
    DBA_HIST_DATAFILE
    DBA_HIST_DATAFILE
    DBA_HIST_DB_CACHE_ADVICE
    DBA_HIST_DB_CACHE_ADVICE
    DBA_HIST_DISPATCHER
    DBA_HIST_DISPATCHER
    DBA_HIST_DLM_MISC
    DBA_HIST_DLM_MISC
    DBA_HIST_DYN_REMASTER_STATS
    DBA_HIST_DYN_REMASTER_STATS
    DBA_HIST_ENQUEUE_STAT
    DBA_HIST_ENQUEUE_STAT
    DBA_HIST_EVENT_HISTOGRAM
    DBA_HIST_EVENT_HISTOGRAM
    DBA_HIST_EVENT_NAME
    DBA_HIST_EVENT_NAME
    DBA_HIST_FILEMETRIC_HISTORY
    DBA_HIST_FILEMETRIC_HISTORY
    DBA_HIST_FILESTATXS
    DBA_HIST_FILESTATXS
    DBA_HIST_IC_CLIENT_STATS
    DBA_HIST_IC_CLIENT_STATS
    DBA_HIST_IC_DEVICE_STATS
    DBA_HIST_IC_DEVICE_STATS
    DBA_HIST_INSTANCE_RECOVERY
    DBA_HIST_INSTANCE_RECOVERY
    DBA_HIST_INST_CACHE_TRANSFER
    DBA_HIST_INST_CACHE_TRANSFER
    DBA_HIST_INTERCONNECT_PINGS
    DBA_HIST_INTERCONNECT_PINGS
    DBA_HIST_IOSTAT_DETAIL
    DBA_HIST_IOSTAT_DETAIL
    DBA_HIST_IOSTAT_FILETYPE
    DBA_HIST_IOSTAT_FILETYPE
    DBA_HIST_IOSTAT_FILETYPE_NAME
    DBA_HIST_IOSTAT_FILETYPE_NAME
    DBA_HIST_IOSTAT_FUNCTION
    DBA_HIST_IOSTAT_FUNCTION
    DBA_HIST_IOSTAT_FUNCTION_NAME
    DBA_HIST_IOSTAT_FUNCTION_NAME
    DBA_HIST_JAVA_POOL_ADVICE
    DBA_HIST_JAVA_POOL_ADVICE
    DBA_HIST_LATCH
    DBA_HIST_LATCH
    DBA_HIST_LATCH_CHILDREN
    DBA_HIST_LATCH_CHILDREN
    DBA_HIST_LATCH_MISSES_SUMMARY
    DBA_HIST_LATCH_MISSES_SUMMARY
    DBA_HIST_LATCH_NAME
    DBA_HIST_LATCH_NAME
    DBA_HIST_LATCH_PARENT
    DBA_HIST_LATCH_PARENT
    DBA_HIST_LIBRARYCACHE
    DBA_HIST_LIBRARYCACHE
    DBA_HIST_LOG
    DBA_HIST_LOG
    DBA_HIST_MEMORY_RESIZE_OPS
    DBA_HIST_MEMORY_RESIZE_OPS
    DBA_HIST_MEMORY_TARGET_ADVICE
    DBA_HIST_MEMORY_TARGET_ADVICE
    DBA_HIST_MEM_DYNAMIC_COMP
    DBA_HIST_MEM_DYNAMIC_COMP
    DBA_HIST_METRIC_NAME
    DBA_HIST_METRIC_NAME
    DBA_HIST_MTTR_TARGET_ADVICE
    DBA_HIST_MTTR_TARGET_ADVICE
    DBA_HIST_MUTEX_SLEEP
    DBA_HIST_MUTEX_SLEEP
    DBA_HIST_MVPARAMETER
    DBA_HIST_MVPARAMETER
    DBA_HIST_OPTIMIZER_ENV
    DBA_HIST_OPTIMIZER_ENV
    DBA_HIST_OSSTAT
    DBA_HIST_OSSTAT
    DBA_HIST_OSSTAT_NAME
    DBA_HIST_OSSTAT_NAME
    DBA_HIST_PARAMETER
    DBA_HIST_PARAMETER
    DBA_HIST_PARAMETER_NAME
    DBA_HIST_PARAMETER_NAME
    DBA_HIST_PERSISTENT_QMN_CACHE
    DBA_HIST_PERSISTENT_QMN_CACHE
    DBA_HIST_PERSISTENT_QUEUES
    DBA_HIST_PERSISTENT_QUEUES
    DBA_HIST_PERSISTENT_SUBS
    DBA_HIST_PERSISTENT_SUBS
    DBA_HIST_PGASTAT
    DBA_HIST_PGASTAT
    DBA_HIST_PGA_TARGET_ADVICE
    DBA_HIST_PGA_TARGET_ADVICE
    DBA_HIST_PLAN_OPERATION_NAME
    DBA_HIST_PLAN_OPERATION_NAME
    DBA_HIST_PLAN_OPTION_NAME
    DBA_HIST_PLAN_OPTION_NAME
    DBA_HIST_PROCESS_MEM_SUMMARY
    DBA_HIST_PROCESS_MEM_SUMMARY
    DBA_HIST_RESOURCE_LIMIT
    DBA_HIST_RESOURCE_LIMIT
    DBA_HIST_ROWCACHE_SUMMARY
    DBA_HIST_ROWCACHE_SUMMARY
    DBA_HIST_RSRC_CONSUMER_GROUP
    DBA_HIST_RSRC_CONSUMER_GROUP
    DBA_HIST_RSRC_PLAN
    DBA_HIST_RSRC_PLAN
    DBA_HIST_RULE_SET
    DBA_HIST_RULE_SET
    DBA_HIST_SEG_STAT
    DBA_HIST_SEG_STAT
    DBA_HIST_SEG_STAT_OBJ
    DBA_HIST_SEG_STAT_OBJ
    DBA_HIST_SERVICE_NAME
    DBA_HIST_SERVICE_NAME
    DBA_HIST_SERVICE_STAT
    DBA_HIST_SERVICE_STAT
    DBA_HIST_SERVICE_WAIT_CLASS
    DBA_HIST_SERVICE_WAIT_CLASS
    DBA_HIST_SESSMETRIC_HISTORY
    DBA_HIST_SESSMETRIC_HISTORY
    DBA_HIST_SESS_TIME_STATS
    DBA_HIST_SESS_TIME_STATS
    DBA_HIST_SGA
    DBA_HIST_SGA
    DBA_HIST_SGASTAT
    DBA_HIST_SGASTAT
    DBA_HIST_SGA_TARGET_ADVICE
    DBA_HIST_SGA_TARGET_ADVICE
    DBA_HIST_SHARED_POOL_ADVICE
    DBA_HIST_SHARED_POOL_ADVICE
    DBA_HIST_SHARED_SERVER_SUMMARY
    DBA_HIST_SHARED_SERVER_SUMMARY
    DBA_HIST_SNAPSHOT
    DBA_HIST_SNAPSHOT
    DBA_HIST_SNAP_ERROR
    DBA_HIST_SNAP_ERROR
    DBA_HIST_SQLBIND
    DBA_HIST_SQLBIND
    DBA_HIST_SQLCOMMAND_NAME
    DBA_HIST_SQLCOMMAND_NAME
    DBA_HIST_SQLSTAT
    DBA_HIST_SQLSTAT
    DBA_HIST_SQLTEXT
    DBA_HIST_SQLTEXT
    DBA_HIST_SQL_BIND_METADATA
    DBA_HIST_SQL_BIND_METADATA
    DBA_HIST_SQL_PLAN
    DBA_HIST_SQL_PLAN
    DBA_HIST_SQL_SUMMARY
    DBA_HIST_SQL_SUMMARY
    DBA_HIST_SQL_WORKAREA_HSTGRM
    DBA_HIST_SQL_WORKAREA_HSTGRM
    DBA_HIST_STAT_NAME
    DBA_HIST_STAT_NAME
    DBA_HIST_STREAMS_APPLY_SUM
    DBA_HIST_STREAMS_APPLY_SUM
    DBA_HIST_STREAMS_CAPTURE
    DBA_HIST_STREAMS_CAPTURE
    DBA_HIST_STREAMS_POOL_ADVICE
    DBA_HIST_STREAMS_POOL_ADVICE
    DBA_HIST_SYSMETRIC_HISTORY
    DBA_HIST_SYSMETRIC_HISTORY
    DBA_HIST_SYSMETRIC_SUMMARY
    DBA_HIST_SYSMETRIC_SUMMARY
    DBA_HIST_SYSSTAT
    DBA_HIST_SYSSTAT
    DBA_HIST_SYSTEM_EVENT
    DBA_HIST_SYSTEM_EVENT
    DBA_HIST_SYS_TIME_MODEL
    DBA_HIST_SYS_TIME_MODEL
    DBA_HIST_TABLESPACE
    DBA_HIST_TABLESPACE
    DBA_HIST_TABLESPACE_STAT
    DBA_HIST_TABLESPACE_STAT
    DBA_HIST_TBSPC_SPACE_USAGE
    DBA_HIST_TBSPC_SPACE_USAGE
    DBA_HIST_TEMPFILE
    DBA_HIST_TEMPFILE
    DBA_HIST_TEMPSTATXS
    DBA_HIST_TEMPSTATXS
    DBA_HIST_THREAD
    DBA_HIST_THREAD
    DBA_HIST_TOPLEVELCALL_NAME
    DBA_HIST_TOPLEVELCALL_NAME
    DBA_HIST_UNDOSTAT
    DBA_HIST_UNDOSTAT
    DBA_HIST_WAITCLASSMET_HISTORY
    DBA_HIST_WAITCLASSMET_HISTORY
    DBA_HIST_WAITSTAT
    DBA_HIST_WAITSTAT
    DBA_HIST_WR_CONTROL
    DBA_HIST_WR_CONTROL
    DBA_IAS_CONSTRAINT_EXP
    DBA_IAS_GEN_STMTS
    DBA_IAS_GEN_STMTS
    DBA_IAS_GEN_STMTS_EXP
    DBA_IAS_OBJECTS
    DBA_IAS_OBJECTS
    DBA_IAS_OBJECTS_BASE
    DBA_IAS_OBJECTS_EXP
    DBA_IAS_POSTGEN_STMTS
    DBA_IAS_PREGEN_STMTS
    DBA_IAS_SITES
    DBA_IAS_SITES
    DBA_IAS_TEMPLATES
    DBA_IAS_TEMPLATES
    DBA_IDENTIFIERS
    DBA_IDENTIFIERS
    DBA_INDEXES
    DBA_INDEXES
    DBA_INDEXTYPES
    DBA_INDEXTYPES
    DBA_INDEXTYPE_ARRAYTYPES
    DBA_INDEXTYPE_ARRAYTYPES
    DBA_INDEXTYPE_COMMENTS
    DBA_INDEXTYPE_COMMENTS
    DBA_INDEXTYPE_OPERATORS
    DBA_INDEXTYPE_OPERATORS
    DBA_IND_COLUMNS
    DBA_IND_COLUMNS
    DBA_IND_EXPRESSIONS
    DBA_IND_EXPRESSIONS
    DBA_IND_PARTITIONS
    DBA_IND_PARTITIONS
    DBA_IND_PENDING_STATS
    DBA_IND_PENDING_STATS
    DBA_IND_STATISTICS
    DBA_IND_STATISTICS
    DBA_IND_SUBPARTITIONS
    DBA_IND_SUBPARTITIONS
    DBA_INTERNAL_TRIGGERS
    DBA_INTERNAL_TRIGGERS
    DBA_INVALID_OBJECTS
    DBA_INVALID_OBJECTS
    DBA_JOBS
    DBA_JOBS
    DBA_JOBS_RUNNING
    DBA_JOBS_RUNNING
    DBA_JOIN_IND_COLUMNS
    DBA_JOIN_IND_COLUMNS
    DBA_KEEPSIZES
    DBA_KGLLOCK
    DBA_KGLLOCK
    DBA_LIBRARIES
    DBA_LIBRARIES
    DBA_LMT_FREE_SPACE
    DBA_LMT_FREE_SPACE
    DBA_LMT_USED_EXTENTS
    DBA_LMT_USED_EXTENTS
    DBA_LOBS
    DBA_LOBS
    DBA_LOB_PARTITIONS
    DBA_LOB_PARTITIONS
    DBA_LOB_SUBPARTITIONS
    DBA_LOB_SUBPARTITIONS
    DBA_LOB_TEMPLATES
    DBA_LOB_TEMPLATES
    DBA_LOCK
    DBA_LOCK
    DBA_LOCKS
    DBA_LOCK_INTERNAL
    DBA_LOCK_INTERNAL
    DBA_LOGMNR_LOG
    DBA_LOGMNR_LOG
    DBA_LOGMNR_PURGED_LOG
    DBA_LOGMNR_PURGED_LOG
    DBA_LOGMNR_SESSION
    DBA_LOGMNR_SESSION
    DBA_LOGSTDBY_EDS_SUPPORTED
    DBA_LOGSTDBY_EDS_SUPPORTED
    DBA_LOGSTDBY_EDS_TABLES
    DBA_LOGSTDBY_EDS_TABLES
    DBA_LOGSTDBY_EVENTS
    DBA_LOGSTDBY_EVENTS
    DBA_LOGSTDBY_HISTORY
    DBA_LOGSTDBY_HISTORY
    DBA_LOGSTDBY_LOG
    DBA_LOGSTDBY_LOG
    DBA_LOGSTDBY_NOT_UNIQUE
    DBA_LOGSTDBY_NOT_UNIQUE
    DBA_LOGSTDBY_PARAMETERS
    DBA_LOGSTDBY_PARAMETERS
    DBA_LOGSTDBY_PROGRESS
    DBA_LOGSTDBY_PROGRESS
    DBA_LOGSTDBY_SKIP
    DBA_LOGSTDBY_SKIP
    DBA_LOGSTDBY_SKIP_TRANSACTION
    DBA_LOGSTDBY_SKIP_TRANSACTION
    DBA_LOGSTDBY_UNSUPPORTED
    DBA_LOGSTDBY_UNSUPPORTED
    DBA_LOGSTDBY_UNSUPPORTED_TABLE
    DBA_LOGSTDBY_UNSUPPORTED_TABLE
    DBA_LOG_GROUPS
    DBA_LOG_GROUPS
    DBA_LOG_GROUP_COLUMNS
    DBA_LOG_GROUP_COLUMNS
    DBA_MEASURE_FOLDERS
    DBA_MEASURE_FOLDERS
    DBA_MEASURE_FOLDER_CONTENTS
    DBA_MEASURE_FOLDER_CONTENTS
    DBA_METHOD_PARAMS
    DBA_METHOD_PARAMS
    DBA_METHOD_RESULTS
    DBA_METHOD_RESULTS
    DBA_MINING_MODELS
    DBA_MINING_MODEL_ATTRIBUTES
    DBA_MINING_MODEL_SETTINGS
    DBA_MINING_MODEL_TABLES
    DBA_MVIEWS
    DBA_MVIEWS
    DBA_MVIEW_AGGREGATES
    DBA_MVIEW_AGGREGATES
    DBA_MVIEW_ANALYSIS
    DBA_MVIEW_ANALYSIS
    DBA_MVIEW_COMMENTS
    DBA_MVIEW_COMMENTS
    DBA_MVIEW_DETAIL_PARTITION
    DBA_MVIEW_DETAIL_PARTITION
    DBA_MVIEW_DETAIL_RELATIONS
    DBA_MVIEW_DETAIL_RELATIONS
    DBA_MVIEW_DETAIL_SUBPARTITION
    DBA_MVIEW_DETAIL_SUBPARTITION
    DBA_MVIEW_JOINS
    DBA_MVIEW_JOINS
    DBA_MVIEW_KEYS
    DBA_MVIEW_KEYS
    DBA_MVIEW_LOGS
    DBA_MVIEW_LOGS
    DBA_MVIEW_LOG_FILTER_COLS
    DBA_MVIEW_LOG_FILTER_COLS
    DBA_MVIEW_REFRESH_TIMES
    DBA_MVIEW_REFRESH_TIMES
    DBA_NESTED_TABLES
    DBA_NESTED_TABLES
    DBA_NESTED_TABLE_COLS
    DBA_NESTED_TABLE_COLS
    DBA_NETWORK_ACLS
    DBA_NETWORK_ACLS
    DBA_NETWORK_ACL_PRIVILEGES
    DBA_NETWORK_ACL_PRIVILEGES
    DBA_OBJECTS
    DBA_OBJECTS
    DBA_OBJECTS_AE
    DBA_OBJECTS_AE
    DBA_OBJECT_SIZE
    DBA_OBJECT_SIZE
    DBA_OBJECT_TABLES
    DBA_OBJECT_TABLES
    DBA_OBJ_AUDIT_OPTS
    DBA_OBJ_AUDIT_OPTS
    DBA_OBJ_COLATTRS
    DBA_OBJ_COLATTRS
    DBA_OLDIMAGE_COLUMNS
    DBA_OLDIMAGE_COLUMNS
    DBA_OPANCILLARY
    DBA_OPANCILLARY
    DBA_OPARGUMENTS
    DBA_OPARGUMENTS
    DBA_OPBINDINGS
    DBA_OPBINDINGS
    DBA_OPERATORS
    DBA_OPERATORS
    DBA_OPERATOR_COMMENTS
    DBA_OPERATOR_COMMENTS
    DBA_OPTSTAT_OPERATIONS
    DBA_OPTSTAT_OPERATIONS
    DBA_OUTLINES
    DBA_OUTLINES
    DBA_OUTLINE_HINTS
    DBA_OUTLINE_HINTS
    DBA_OUTSTANDING_ALERTS
    DBA_OUTSTANDING_ALERTS
    DBA_PARALLEL_EXECUTE_CHUNKS
    DBA_PARALLEL_EXECUTE_CHUNKS
    DBA_PARALLEL_EXECUTE_TASKS
    DBA_PARALLEL_EXECUTE_TASKS
    DBA_PARTIAL_DROP_TABS
    DBA_PARTIAL_DROP_TABS
    DBA_PART_COL_STATISTICS
    DBA_PART_COL_STATISTICS
    DBA_PART_HISTOGRAMS
    DBA_PART_HISTOGRAMS
    DBA_PART_INDEXES
    DBA_PART_INDEXES
    DBA_PART_KEY_COLUMNS
    DBA_PART_KEY_COLUMNS
    DBA_PART_LOBS
    DBA_PART_LOBS
    DBA_PART_TABLES
    DBA_PART_TABLES
    DBA_PENDING_CONV_TABLES
    DBA_PENDING_CONV_TABLES
    DBA_PENDING_TRANSACTIONS
    DBA_PENDING_TRANSACTIONS
    DBA_PLSQL_OBJECT_SETTINGS
    DBA_PLSQL_OBJECT_SETTINGS
    DBA_POLICIES
    DBA_POLICIES
    DBA_POLICY_CONTEXTS
    DBA_POLICY_CONTEXTS
    DBA_POLICY_GROUPS
    DBA_POLICY_GROUPS
    DBA_PRIV_AUDIT_OPTS
    DBA_PRIV_AUDIT_OPTS
    DBA_PROCEDURES
    DBA_PROCEDURES
    DBA_PROFILES
    DBA_PROFILES
    DBA_PROPAGATION
    DBA_PROPAGATION
    DBA_PROXIES
    DBA_PROXIES
    DBA_PUBLISHED_COLUMNS
    DBA_PUBLISHED_COLUMNS
    DBA_QUEUES
    DBA_QUEUES
    DBA_QUEUE_PUBLISHERS
    DBA_QUEUE_PUBLISHERS
    DBA_QUEUE_SCHEDULES
    DBA_QUEUE_SCHEDULES
    DBA_QUEUE_SUBSCRIBERS
    DBA_QUEUE_SUBSCRIBERS
    DBA_QUEUE_TABLES
    DBA_QUEUE_TABLES
    DBA_RCHILD
    DBA_RCHILD
    DBA_RECOVERABLE_SCRIPT
    DBA_RECOVERABLE_SCRIPT
    DBA_RECOVERABLE_SCRIPT_BLOCKS
    DBA_RECOVERABLE_SCRIPT_BLOCKS
    DBA_RECOVERABLE_SCRIPT_ERRORS
    DBA_RECOVERABLE_SCRIPT_ERRORS
    DBA_RECOVERABLE_SCRIPT_HIST
    DBA_RECOVERABLE_SCRIPT_HIST
    DBA_RECOVERABLE_SCRIPT_PARAMS
    DBA_RECOVERABLE_SCRIPT_PARAMS
    DBA_RECYCLEBIN
    DBA_RECYCLEBIN
    DBA_REDEFINITION_ERRORS
    DBA_REDEFINITION_ERRORS
    DBA_REDEFINITION_OBJECTS
    DBA_REDEFINITION_OBJECTS
    DBA_REFRESH
    DBA_REFRESH
    DBA_REFRESH_CHILDREN
    DBA_REFRESH_CHILDREN
    DBA_REFS
    DBA_REFS
    DBA_REGISTERED_ARCHIVED_LOG
    DBA_REGISTERED_ARCHIVED_LOG
    DBA_REGISTERED_MVIEWS
    DBA_REGISTERED_MVIEWS
    DBA_REGISTERED_MVIEW_GROUPS
    DBA_REGISTERED_MVIEW_GROUPS
    DBA_REGISTERED_SNAPSHOTS
    DBA_REGISTERED_SNAPSHOTS
    DBA_REGISTERED_SNAPSHOT_GROUPS
    DBA_REGISTERED_SNAPSHOT_GROUPS
    DBA_REGISTRY
    DBA_REGISTRY
    DBA_REGISTRY_DATABASE
    DBA_REGISTRY_DATABASE
    DBA_REGISTRY_DEPENDENCIES
    DBA_REGISTRY_DEPENDENCIES
    DBA_REGISTRY_HIERARCHY
    DBA_REGISTRY_HIERARCHY
    DBA_REGISTRY_HISTORY
    DBA_REGISTRY_HISTORY
    DBA_REGISTRY_LOG
    DBA_REGISTRY_LOG
    DBA_REGISTRY_PROGRESS
    DBA_REGISTRY_PROGRESS
    DBA_REPAUDIT_ATTRIBUTE
    DBA_REPAUDIT_ATTRIBUTE
    DBA_REPAUDIT_COLUMN
    DBA_REPAUDIT_COLUMN
    DBA_REPCAT
    DBA_REPCAT
    DBA_REPCATLOG
    DBA_REPCATLOG
    DBA_REPCAT_EXCEPTIONS
    DBA_REPCAT_EXCEPTIONS
    DBA_REPCAT_REFRESH_TEMPLATES
    DBA_REPCAT_REFRESH_TEMPLATES
    DBA_REPCAT_TEMPLATE_OBJECTS
    DBA_REPCAT_TEMPLATE_OBJECTS
    DBA_REPCAT_TEMPLATE_PARMS
    DBA_REPCAT_TEMPLATE_PARMS
    DBA_REPCAT_TEMPLATE_SITES
    DBA_REPCAT_TEMPLATE_SITES
    DBA_REPCAT_USER_AUTHORIZATIONS
    DBA_REPCAT_USER_AUTHORIZATIONS
    DBA_REPCAT_USER_PARM_VALUES
    DBA_REPCAT_USER_PARM_VALUES
    DBA_REPCOLUMN
    DBA_REPCOLUMN
    DBA_REPCOLUMN_GROUP
    DBA_REPCOLUMN_GROUP
    DBA_REPCONFLICT
    DBA_REPCONFLICT
    DBA_REPDDL
    DBA_REPDDL
    DBA_REPEXTENSIONS
    DBA_REPEXTENSIONS
    DBA_REPFLAVORS
    DBA_REPFLAVORS
    DBA_REPFLAVOR_COLUMNS
    DBA_REPFLAVOR_COLUMNS
    DBA_REPFLAVOR_OBJECTS
    DBA_REPFLAVOR_OBJECTS
    DBA_REPGENERATED
    DBA_REPGENERATED
    DBA_REPGENOBJECTS
    DBA_REPGENOBJECTS
    DBA_REPGROUP
    DBA_REPGROUP
    DBA_REPGROUPED_COLUMN
    DBA_REPGROUPED_COLUMN
    DBA_REPGROUP_PRIVILEGES
    DBA_REPGROUP_PRIVILEGES
    DBA_REPKEY_COLUMNS
    DBA_REPKEY_COLUMNS
    DBA_REPOBJECT
    DBA_REPOBJECT
    DBA_REPPARAMETER_COLUMN
    DBA_REPPARAMETER_COLUMN
    DBA_REPPRIORITY
    DBA_REPPRIORITY
    DBA_REPPRIORITY_GROUP
    DBA_REPPRIORITY_GROUP
    DBA_REPPROP
    DBA_REPPROP
    DBA_REPRESOLUTION
    DBA_REPRESOLUTION
    DBA_REPRESOLUTION_METHOD
    DBA_REPRESOLUTION_METHOD
    DBA_REPRESOLUTION_STATISTICS
    DBA_REPRESOLUTION_STATISTICS
    DBA_REPRESOL_STATS_CONTROL
    DBA_REPRESOL_STATS_CONTROL
    DBA_REPSCHEMA
    DBA_REPSCHEMA
    DBA_REPSITES
    DBA_REPSITES
    DBA_REPSITES_NEW
    DBA_REPSITES_NEW
    DBA_RESOURCE_INCARNATIONS
    DBA_RESOURCE_INCARNATIONS
    DBA_RESUMABLE
    DBA_RESUMABLE
    DBA_REWRITE_EQUIVALENCES
    DBA_REWRITE_EQUIVALENCES
    DBA_RGROUP
    DBA_RGROUP
    DBA_ROLES
    DBA_ROLES
    DBA_ROLE_PRIVS
    DBA_ROLE_PRIVS
    DBA_ROLLBACK_SEGS
    DBA_ROLLBACK_SEGS
    DBA_RSRC_CAPABILITY
    DBA_RSRC_CAPABILITY
    DBA_RSRC_CATEGORIES
    DBA_RSRC_CATEGORIES
    DBA_RSRC_CONSUMER_GROUPS
    DBA_RSRC_CONSUMER_GROUPS
    DBA_RSRC_CONSUMER_GROUP_PRIVS
    DBA_RSRC_CONSUMER_GROUP_PRIVS
    DBA_RSRC_GROUP_MAPPINGS
    DBA_RSRC_GROUP_MAPPINGS
    DBA_RSRC_INSTANCE_CAPABILITY
    DBA_RSRC_INSTANCE_CAPABILITY
    DBA_RSRC_IO_CALIBRATE
    DBA_RSRC_IO_CALIBRATE
    DBA_RSRC_MANAGER_SYSTEM_PRIVS
    DBA_RSRC_MANAGER_SYSTEM_PRIVS
    DBA_RSRC_MAPPING_PRIORITY
    DBA_RSRC_MAPPING_PRIORITY
    DBA_RSRC_PLANS
    DBA_RSRC_PLANS
    DBA_RSRC_PLAN_DIRECTIVES
    DBA_RSRC_PLAN_DIRECTIVES
    DBA_RSRC_STORAGE_POOL_MAPPING
    DBA_RSRC_STORAGE_POOL_MAPPING
    DBA_RULES
    DBA_RULES
    DBA_RULESETS
    DBA_RULESETS
    DBA_RULE_SETS
    DBA_RULE_SETS
    DBA_RULE_SET_RULES
    DBA_RULE_SET_RULES
    DBA_SCHEDULER_CHAINS
    DBA_SCHEDULER_CHAINS
    DBA_SCHEDULER_CHAIN_RULES
    DBA_SCHEDULER_CHAIN_RULES
    DBA_SCHEDULER_CHAIN_STEPS
    DBA_SCHEDULER_CHAIN_STEPS
    DBA_SCHEDULER_CREDENTIALS
    DBA_SCHEDULER_CREDENTIALS
    DBA_SCHEDULER_DB_DESTS
    DBA_SCHEDULER_DB_DESTS
    DBA_SCHEDULER_DESTS
    DBA_SCHEDULER_DESTS
    DBA_SCHEDULER_EXTERNAL_DESTS
    DBA_SCHEDULER_EXTERNAL_DESTS
    DBA_SCHEDULER_FILE_WATCHERS
    DBA_SCHEDULER_FILE_WATCHERS
    DBA_SCHEDULER_GLOBAL_ATTRIBUTE
    DBA_SCHEDULER_GLOBAL_ATTRIBUTE
    DBA_SCHEDULER_GROUPS
    DBA_SCHEDULER_GROUPS
    DBA_SCHEDULER_GROUP_MEMBERS
    DBA_SCHEDULER_GROUP_MEMBERS
    DBA_SCHEDULER_JOBS
    DBA_SCHEDULER_JOBS
    DBA_SCHEDULER_JOB_ARGS
    DBA_SCHEDULER_JOB_ARGS
    DBA_SCHEDULER_JOB_CLASSES
    DBA_SCHEDULER_JOB_CLASSES
    DBA_SCHEDULER_JOB_DESTS
    DBA_SCHEDULER_JOB_DESTS
    DBA_SCHEDULER_JOB_LOG
    DBA_SCHEDULER_JOB_LOG
    DBA_SCHEDULER_JOB_ROLES
    DBA_SCHEDULER_JOB_ROLES
    DBA_SCHEDULER_JOB_RUN_DETAILS
    DBA_SCHEDULER_JOB_RUN_DETAILS
    DBA_SCHEDULER_NOTIFICATIONS
    DBA_SCHEDULER_NOTIFICATIONS
    DBA_SCHEDULER_PROGRAMS
    DBA_SCHEDULER_PROGRAMS
    DBA_SCHEDULER_PROGRAM_ARGS
    DBA_SCHEDULER_PROGRAM_ARGS
    DBA_SCHEDULER_REMOTE_DATABASES
    DBA_SCHEDULER_REMOTE_DATABASES
    DBA_SCHEDULER_REMOTE_JOBSTATE
    DBA_SCHEDULER_REMOTE_JOBSTATE
    DBA_SCHEDULER_RUNNING_CHAINS
    DBA_SCHEDULER_RUNNING_CHAINS
    DBA_SCHEDULER_RUNNING_JOBS
    DBA_SCHEDULER_RUNNING_JOBS
    DBA_SCHEDULER_SCHEDULES
    DBA_SCHEDULER_SCHEDULES
    DBA_SCHEDULER_WINDOWS
    DBA_SCHEDULER_WINDOWS
    DBA_SCHEDULER_WINDOW_DETAILS
    DBA_SCHEDULER_WINDOW_DETAILS
    DBA_SCHEDULER_WINDOW_GROUPS
    DBA_SCHEDULER_WINDOW_GROUPS
    DBA_SCHEDULER_WINDOW_LOG
    DBA_SCHEDULER_WINDOW_LOG
    DBA_SCHEDULER_WINGROUP_MEMBERS
    DBA_SCHEDULER_WINGROUP_MEMBERS
    DBA_SDO_MAPS
    DBA_SDO_MAPS
    DBA_SDO_STYLES
    DBA_SDO_STYLES
    DBA_SDO_THEMES
    DBA_SDO_THEMES
    DBA_SECONDARY_OBJECTS
    DBA_SECONDARY_OBJECTS
    DBA_SEC_RELEVANT_COLS
    DBA_SEC_RELEVANT_COLS
    DBA_SEGMENTS
    DBA_SEGMENTS
    DBA_SEGMENTS_OLD
    DBA_SEGMENTS_OLD
    DBA_SEQUENCES
    DBA_SEQUENCES
    DBA_SERVER_REGISTRY
    DBA_SERVER_REGISTRY
    DBA_SERVICES
    DBA_SERVICES
    DBA_SNAPSHOTS
    DBA_SNAPSHOTS
    DBA_SNAPSHOT_LOGS
    DBA_SNAPSHOT_LOGS
    DBA_SNAPSHOT_LOG_FILTER_COLS
    DBA_SNAPSHOT_REFRESH_TIMES
    DBA_SOURCE
    DBA_SOURCE
    DBA_SOURCE_AE
    DBA_SOURCE_AE
    DBA_SOURCE_TABLES
    DBA_SOURCE_TABLES
    DBA_SQLJ_TYPES
    DBA_SQLJ_TYPES
    DBA_SQLJ_TYPE_ATTRS
    DBA_SQLJ_TYPE_ATTRS
    DBA_SQLJ_TYPE_METHODS
    DBA_SQLJ_TYPE_METHODS
    DBA_SQLSET
    DBA_SQLSET
    DBA_SQLSET_BINDS
    DBA_SQLSET_BINDS
    DBA_SQLSET_DEFINITIONS
    DBA_SQLSET_PLANS
    DBA_SQLSET_PLANS
    DBA_SQLSET_REFERENCES
    DBA_SQLSET_REFERENCES
    DBA_SQLSET_STATEMENTS
    DBA_SQLSET_STATEMENTS
    DBA_SQLTUNE_BINDS
    DBA_SQLTUNE_BINDS
    DBA_SQLTUNE_PLANS
    DBA_SQLTUNE_PLANS
    DBA_SQLTUNE_RATIONALE_PLAN
    DBA_SQLTUNE_RATIONALE_PLAN
    DBA_SQLTUNE_STATISTICS
    DBA_SQLTUNE_STATISTICS
    DBA_SQL_MANAGEMENT_CONFIG
    DBA_SQL_MANAGEMENT_CONFIG
    DBA_SQL_MONITOR_USAGE
    DBA_SQL_MONITOR_USAGE
    DBA_SQL_PATCHES
    DBA_SQL_PATCHES
    DBA_SQL_PLAN_BASELINES
    DBA_SQL_PLAN_BASELINES
    DBA_SQL_PROFILES
    DBA_SQL_PROFILES
    DBA_SSCR_CAPTURE
    DBA_SSCR_RESTORE
    DBA_STAT_EXTENSIONS
    DBA_STAT_EXTENSIONS
    DBA_STMT_AUDIT_OPTS
    DBA_STMT_AUDIT_OPTS
    DBA_STORED_SETTINGS
    DBA_STORED_SETTINGS
    DBA_STREAMS_ADD_COLUMN
    DBA_STREAMS_ADD_COLUMN
    DBA_STREAMS_ADMINISTRATOR
    DBA_STREAMS_ADMINISTRATOR
    DBA_STREAMS_COLUMNS
    DBA_STREAMS_COLUMNS
    DBA_STREAMS_DELETE_COLUMN
    DBA_STREAMS_DELETE_COLUMN
    DBA_STREAMS_GLOBAL_RULES
    DBA_STREAMS_GLOBAL_RULES
    DBA_STREAMS_KEEP_COLUMNS
    DBA_STREAMS_KEEP_COLUMNS
    DBA_STREAMS_MESSAGE_CONSUMERS
    DBA_STREAMS_MESSAGE_CONSUMERS
    DBA_STREAMS_MESSAGE_RULES
    DBA_STREAMS_MESSAGE_RULES
    DBA_STREAMS_NEWLY_SUPPORTED
    DBA_STREAMS_NEWLY_SUPPORTED
    DBA_STREAMS_RENAME_COLUMN
    DBA_STREAMS_RENAME_COLUMN
    DBA_STREAMS_RENAME_SCHEMA
    DBA_STREAMS_RENAME_SCHEMA
    DBA_STREAMS_RENAME_TABLE
    DBA_STREAMS_RENAME_TABLE
    DBA_STREAMS_RULES
    DBA_STREAMS_RULES
    DBA_STREAMS_SCHEMA_RULES
    DBA_STREAMS_SCHEMA_RULES
    DBA_STREAMS_SPLIT_MERGE
    DBA_STREAMS_SPLIT_MERGE
    DBA_STREAMS_SPLIT_MERGE_HIST
    DBA_STREAMS_SPLIT_MERGE_HIST
    DBA_STREAMS_STMTS
    DBA_STREAMS_STMTS
    DBA_STREAMS_STMT_HANDLERS
    DBA_STREAMS_STMT_HANDLERS
    DBA_STREAMS_TABLE_RULES
    DBA_STREAMS_TABLE_RULES
    DBA_STREAMS_TP_COMPONENT
    DBA_STREAMS_TP_COMPONENT
    DBA_STREAMS_TP_COMPONENT_LINK
    DBA_STREAMS_TP_COMPONENT_LINK
    DBA_STREAMS_TP_COMPONENT_STAT
    DBA_STREAMS_TP_COMPONENT_STAT
    DBA_STREAMS_TP_DATABASE
    DBA_STREAMS_TP_DATABASE
    DBA_STREAMS_TP_PATH_BOTTLENECK
    DBA_STREAMS_TP_PATH_BOTTLENECK
    DBA_STREAMS_TP_PATH_STAT
    DBA_STREAMS_TP_PATH_STAT
    DBA_STREAMS_TRANSFORMATIONS
    DBA_STREAMS_TRANSFORMATIONS
    DBA_STREAMS_TRANSFORM_FUNCTION
    DBA_STREAMS_TRANSFORM_FUNCTION
    DBA_STREAMS_UNSUPPORTED
    DBA_STREAMS_UNSUPPORTED
    DBA_SUBPARTITION_TEMPLATES
    DBA_SUBPARTITION_TEMPLATES
    DBA_SUBPART_COL_STATISTICS
    DBA_SUBPART_COL_STATISTICS
    DBA_SUBPART_HISTOGRAMS
    DBA_SUBPART_HISTOGRAMS
    DBA_SUBPART_KEY_COLUMNS
    DBA_SUBPART_KEY_COLUMNS
    DBA_SUBSCRIBED_COLUMNS
    DBA_SUBSCRIBED_COLUMNS
    DBA_SUBSCRIBED_TABLES
    DBA_SUBSCRIBED_TABLES
    DBA_SUBSCRIPTIONS
    DBA_SUBSCRIPTIONS
    DBA_SUBSCR_REGISTRATIONS
    DBA_SUBSCR_REGISTRATIONS
    DBA_SUMMARIES
    DBA_SUMMARIES
    DBA_SUMMARY_AGGREGATES
    DBA_SUMMARY_AGGREGATES
    DBA_SUMMARY_DETAIL_TABLES
    DBA_SUMMARY_DETAIL_TABLES
    DBA_SUMMARY_JOINS
    DBA_SUMMARY_JOINS
    DBA_SUMMARY_KEYS
    DBA_SUMMARY_KEYS
    DBA_SYNC_CAPTURE
    DBA_SYNC_CAPTURE
    DBA_SYNC_CAPTURE_PREPARED_TABS
    DBA_SYNC_CAPTURE_PREPARED_TABS
    DBA_SYNC_CAPTURE_TABLES
    DBA_SYNC_CAPTURE_TABLES
    DBA_SYNONYMS
    DBA_SYNONYMS
    DBA_SYS_PRIVS
    DBA_SYS_PRIVS
    DBA_TABLES
    DBA_TABLES
    DBA_TABLESPACES
    DBA_TABLESPACES
    DBA_TABLESPACE_GROUPS
    DBA_TABLESPACE_GROUPS
    DBA_TABLESPACE_THRESHOLDS
    DBA_TABLESPACE_THRESHOLDS
    DBA_TABLESPACE_USAGE_METRICS
    DBA_TABLESPACE_USAGE_METRICS
    DBA_TAB_COLS
    DBA_TAB_COLS
    DBA_TAB_COLUMNS
    DBA_TAB_COLUMNS
    DBA_TAB_COL_STATISTICS
    DBA_TAB_COL_STATISTICS
    DBA_TAB_COMMENTS
    DBA_TAB_COMMENTS
    DBA_TAB_HISTGRM_PENDING_STATS
    DBA_TAB_HISTGRM_PENDING_STATS
    DBA_TAB_HISTOGRAMS
    DBA_TAB_HISTOGRAMS
    DBA_TAB_MODIFICATIONS
    DBA_TAB_MODIFICATIONS
    DBA_TAB_PARTITIONS
    DBA_TAB_PARTITIONS
    DBA_TAB_PENDING_STATS
    DBA_TAB_PENDING_STATS
    DBA_TAB_PRIVS
    DBA_TAB_PRIVS
    DBA_TAB_STATISTICS
    DBA_TAB_STATISTICS
    DBA_TAB_STATS_HISTORY
    DBA_TAB_STATS_HISTORY
    DBA_TAB_STAT_PREFS
    DBA_TAB_STAT_PREFS
    DBA_TAB_SUBPARTITIONS
    DBA_TAB_SUBPARTITIONS
    DBA_TEMPLATE_REFGROUPS
    DBA_TEMPLATE_REFGROUPS
    DBA_TEMPLATE_TARGETS
    DBA_TEMPLATE_TARGETS
    DBA_TEMP_FILES
    DBA_TEMP_FILES
    DBA_TEMP_FREE_SPACE
    DBA_TEMP_FREE_SPACE
    DBA_THRESHOLDS
    DBA_THRESHOLDS
    DBA_TRANSFORMATIONS
    DBA_TRIGGERS
    DBA_TRIGGERS
    DBA_TRIGGER_COLS
    DBA_TRIGGER_COLS
    DBA_TRIGGER_ORDERING
    DBA_TRIGGER_ORDERING
    DBA_TSM_DESTINATION
    DBA_TSM_DESTINATION
    DBA_TSM_HISTORY
    DBA_TSM_HISTORY
    DBA_TSM_SOURCE
    DBA_TSM_SOURCE
    DBA_TSTZ_TABLES
    DBA_TSTZ_TABLES
    DBA_TSTZ_TAB_COLS
    DBA_TSTZ_TAB_COLS
    DBA_TS_QUOTAS
    DBA_TS_QUOTAS
    DBA_TUNE_MVIEW
    DBA_TUNE_MVIEW
    DBA_TYPES
    DBA_TYPES
    DBA_TYPE_ATTRS
    DBA_TYPE_ATTRS
    DBA_TYPE_METHODS
    DBA_TYPE_METHODS
    DBA_TYPE_VERSIONS
    DBA_TYPE_VERSIONS
    DBA_UNDO_EXTENTS
    DBA_UNDO_EXTENTS
    DBA_UNUSED_COL_TABS
    DBA_UNUSED_COL_TABS
    DBA_UPDATABLE_COLUMNS
    DBA_UPDATABLE_COLUMNS
    DBA_USERS
    DBA_USERS
    DBA_USERS_WITH_DEFPWD
    DBA_USERS_WITH_DEFPWD
    DBA_USTATS
    DBA_USTATS
    DBA_VARRAYS
    DBA_VARRAYS
    DBA_VIEWS
    DBA_VIEWS
    DBA_VIEWS_AE
    DBA_VIEWS_AE
    DBA_WAITERS
    DBA_WAITERS
    DBA_WALLET_ACLS
    DBA_WALLET_ACLS
    DBA_WARNING_SETTINGS
    DBA_WARNING_SETTINGS
    DBA_WORKLOAD_CAPTURES
    DBA_WORKLOAD_CAPTURES
    DBA_WORKLOAD_CONNECTION_MAP
    DBA_WORKLOAD_CONNECTION_MAP
    DBA_WORKLOAD_FILTERS
    DBA_WORKLOAD_FILTERS
    DBA_WORKLOAD_REPLAYS
    DBA_WORKLOAD_REPLAYS
    DBA_WORKLOAD_REPLAY_DIVERGENCE
    DBA_WORKLOAD_REPLAY_DIVERGENCE
    DBA_WORKLOAD_REPLAY_FILTER_SET
    DBA_WORKLOAD_REPLAY_FILTER_SET
    DBA_XDS_ATTRIBUTE_SECS
    DBA_XDS_ATTRIBUTE_SECS
    DBA_XDS_INSTANCE_SETS
    DBA_XDS_INSTANCE_SETS
    DBA_XDS_OBJECTS
    DBA_XDS_OBJECTS
    DBA_XMLSCHEMA_LEVEL_VIEW
    DBA_XMLSCHEMA_LEVEL_VIEW
    DBA_XMLSCHEMA_LEVEL_VIEW_DUP
    DBA_XML_INDEXES
    DBA_XML_INDEXES
    DBA_XML_SCHEMAS
    DBA_XML_SCHEMAS
    DBA_XML_SCHEMA_DEPENDENCY
    DBA_XML_SCHEMA_DEPENDENCY
    DBA_XML_SCHEMA_IMPORTS
    DBA_XML_SCHEMA_IMPORTS
    DBA_XML_SCHEMA_INCLUDES
    DBA_XML_SCHEMA_INCLUDES
    DBA_XML_TABLES
    DBA_XML_TABLES
    DBA_XML_TAB_COLS
    DBA_XML_TAB_COLS
    DBA_XML_VIEWS
    DBA_XML_VIEWS
    DBA_XML_VIEW_COLS
    DBA_XML_VIEW_COLS
    DBA_XSTREAM_ADMINISTRATOR
    DBA_XSTREAM_ADMINISTRATOR
    DBA_XSTREAM_INBOUND
    DBA_XSTREAM_INBOUND
    DBA_XSTREAM_INBOUND_PROGRESS
    DBA_XSTREAM_INBOUND_PROGRESS
    DBA_XSTREAM_OUTBOUND
    DBA_XSTREAM_OUTBOUND
    DBA_XSTREAM_OUTBOUND_PROGRESS
    DBA_XSTREAM_OUTBOUND_PROGRESS
    DBA_XSTREAM_OUT_SUPPORT_MODE
    DBA_XSTREAM_OUT_SUPPORT_MODE
    DBA_XSTREAM_RULES
    DBA_XSTREAM_RULES
    DBMSHSXP
    DBMSHSXP_SQL_PROFILE_ATTR
    DBMSHSXP_SQL_PROFILE_ATTR
    DBMSOBJGWRAPPER
    DBMSOUTPUT_LINESARRAY
    DBMSZEXP_SYSPKGGRNT
    DBMS_ADDM
    DBMS_ADR
    DBMS_ADVISOR
    DBMS_ALERT
    DBMS_ALERT_INFO
    DBMS_APPLICATION_INFO
    DBMS_APPLY_ADM
    DBMS_APPLY_POSITION
    DBMS_AQ
    DBMS_AQADM
    DBMS_AQADM_SYSCALLS
    DBMS_AQELM
    DBMS_AQIN
    DBMS_AQJMS
    DBMS_AQJMS_INTERNAL
    DBMS_AQ_EXP_CMT_TIME_TABLES
    DBMS_AQ_EXP_DEQUEUELOG_TABLES
    DBMS_AQ_EXP_HISTORY_TABLES
    DBMS_AQ_EXP_INDEX_TABLES
    DBMS_AQ_EXP_QUEUES
    DBMS_AQ_EXP_QUEUE_TABLES
    DBMS_AQ_EXP_SIGNATURE_TABLES
    DBMS_AQ_EXP_SUBSCRIBER_TABLES
    DBMS_AQ_EXP_TIMEMGR_TABLES
    DBMS_AQ_EXP_ZECURITY
    DBMS_AQ_IMP_INTERNAL
    DBMS_AQ_IMP_ZECURITY
    DBMS_AQ_SYS_EXP_ACTIONS
    DBMS_AQ_SYS_EXP_INTERNAL
    DBMS_AQ_SYS_IMP_INTERNAL
    DBMS_ASSERT
    DBMS_AUTO_SQLTUNE
    DBMS_AUTO_TASK
    DBMS_AUTO_TASK_ADMIN
    DBMS_AUTO_TASK_EXPORT
    DBMS_AUTO_TASK_IMMEDIATE
    DBMS_AW
    DBMS_AW$_COLUMNLIST_T
    DBMS_AW$_DIMENSION_SOURCES_T
    DBMS_AW$_DIMENSION_SOURCE_T
    DBMS_AW_EXP
    DBMS_AW_STATS
    DBMS_CACHEUTIL
    DBMS_CAPTURE_ADM
    DBMS_CAPTURE_SWITCH_ADM
    DBMS_CHANGE_NOTIFICATION
    DBMS_COMPARISON
    DBMS_COMPRESSION
    DBMS_CQ_NOTIFICATION
    DBMS_CRYPTO
    DBMS_CRYPTO_TOOLKIT
    DBMS_CSX_ADMIN
    DBMS_CSX_INT
    DBMS_CUBE_LOG
    DBMS_DATAPUMP
    DBMS_DATA_MINING
    DBMS_DATA_MINING_TRANSFORM
    DBMS_DBFS_CONTENT
    DBMS_DBFS_CONTENT_ADMIN
    DBMS_DBFS_CONTENT_CONTEXT_T
    DBMS_DBFS_CONTENT_LIST_ITEMS_T
    DBMS_DBFS_CONTENT_LIST_ITEM_T
    DBMS_DBFS_CONTENT_PROPERTIES_T
    DBMS_DBFS_CONTENT_PROPERTY_T
    DBMS_DBFS_CONTENT_RAW_T
    DBMS_DBFS_HS
    DBMS_DBFS_HS_ITEM_T
    DBMS_DBFS_HS_LITEMS_T
    DBMS_DBFS_SFS
    DBMS_DBFS_SFS_ADMIN
    DBMS_DBLINK
    DBMS_DB_VERSION
    DBMS_DDL
    DBMS_DDL_INTERNAL
    DBMS_DEBUG
    DBMS_DEBUG_JDWP
    DBMS_DEBUG_JDWP_CUSTOM
    DBMS_DEFER
    DBMS_DEFERGEN
    DBMS_DEFER_QUERY
    DBMS_DEFER_SYS
    DBMS_DESCRIBE
    DBMS_DG
    DBMS_DIMENSION
    DBMS_DISTRIBUTED_TRUST_ADMIN
    DBMS_DM_MODEL_IMP
    DBMS_DNFS
    DBMS_DST
    DBMS_EDITIONS_UTILITIES
    DBMS_EPG
    DBMS_ERRLOG
    DBMS_FBT
    DBMS_FEATURE_USAGE_REPORT
    DBMS_FGA
    DBMS_FILE_GROUP
    DBMS_FILE_TRANSFER
    DBMS_FLASHBACK
    DBMS_FLASHBACK_ARCHIVE
    DBMS_FREQUENT_ITEMSET
    DBMS_FUSE
    DBMS_GOLDENGATE_AUTH
    DBMS_HM
    DBMS_HPROF
    DBMS_HS
    DBMS_HS_PARALLEL
    DBMS_INDEX_UTL
    DBMS_INTERNAL_REPCAT
    DBMS_IR
    DBMS_JAVA_DUMP
    DBMS_JAVA_TEST
    DBMS_JOB
    DBMS_LCR
    DBMS_LDAP
    DBMS_LDAP_UTL
    DBMS_LOB
    DBMS_LOBUTIL
    DBMS_LOBUTIL_INODE_T
    DBMS_LOBUTIL_LOBEXTENTS_T
    DBMS_LOBUTIL_LOBEXTENT_T
    DBMS_LOBUTIL_LOBMAP_T
    DBMS_LOCK
    DBMS_LOCK_ALLOCATED
    DBMS_LOCK_ID
    DBMS_LOGMNR
    DBMS_LOGMNR_D
    DBMS_LOGSTDBY
    DBMS_METADATA
    DBMS_METADATA_BUILD
    DBMS_METADATA_DIFF
    DBMS_METADATA_DPBUILD
    DBMS_MONITOR
    DBMS_MVIEW
    DBMS_NETWORK_ACL_ADMIN
    DBMS_NETWORK_ACL_UTILITY
    DBMS_OBFUSCATION_TOOLKIT
    DBMS_ODCI
    DBMS_OFFLINE_OG
    DBMS_OFFLINE_RGT
    DBMS_OFFLINE_SNAPSHOT
    DBMS_OLAP
    DBMS_OUTLN
    DBMS_OUTLN_EDIT
    DBMS_OUTPUT
    DBMS_PARALLEL_EXECUTE
    DBMS_PARALLEL_EXECUTE_CHUNKS$
    DBMS_PARALLEL_EXECUTE_EXTENTS
    DBMS_PARALLEL_EXECUTE_SEQ$
    DBMS_PARALLEL_EXECUTE_TASK$
    DBMS_PCLXUTIL
    DBMS_PICKLER
    DBMS_PIPE
    DBMS_PREDICTIVE_ANALYTICS
    DBMS_PREPROCESSOR
    DBMS_PROFILER
    DBMS_PROPAGATION_ADM
    DBMS_PSP
    DBMS_PSWMG_IMPORT
    DBMS_RANDOM
    DBMS_RECTIFIER_DIFF
    DBMS_REDEFINITION
    DBMS_REFRESH
    DBMS_REGISTRY
    DBMS_REPCAT
    DBMS_REPCAT_ADMIN
    DBMS_REPCAT_AUTH
    DBMS_REPCAT_DECL
    DBMS_REPCAT_INSTANTIATE
    DBMS_REPCAT_INTERNAL
    DBMS_REPCAT_INTERNAL_PACKAGE
    DBMS_REPCAT_MIG
    DBMS_REPCAT_RGT
    DBMS_REPCAT_VALIDATE
    DBMS_REPORT
    DBMS_REPUTIL
    DBMS_REPUTIL2
    DBMS_RESCONFIG
    DBMS_RESOURCE_MANAGER
    DBMS_RESOURCE_MANAGER_PRIVS
    DBMS_RESULT_CACHE
    DBMS_RESULT_CACHE_API
    DBMS_RESUMABLE
    DBMS_RLS
    DBMS_RMGR_GROUP_EXPORT
    DBMS_RMGR_PACT_EXPORT
    DBMS_RMGR_PLAN_EXPORT
    DBMS_RMIN
    DBMS_ROWID
    DBMS_RULE
    DBMS_RULEADM_INTERNAL
    DBMS_RULE_ADM
    DBMS_RULE_COMPATIBLE_90
    DBMS_RULE_EXP_EC_INTERNAL
    DBMS_RULE_EXP_EV_CTXS
    DBMS_RULE_EXP_RL_INTERNAL
    DBMS_RULE_EXP_RS_INTERNAL
    DBMS_RULE_EXP_RULES
    DBMS_RULE_EXP_RULE_SETS
    DBMS_RULE_IMP_OBJ
    DBMS_RULE_INTERNAL
    DBMS_SCHEDULER
    DBMS_SCHED_ATTRIBUTE_EXPORT
    DBMS_SCHED_CHAIN_EXPORT
    DBMS_SCHED_CLASS_EXPORT
    DBMS_SCHED_CREDENTIAL_EXPORT
    DBMS_SCHED_EXPORT_CALLOUTS
    DBMS_SCHED_FILE_WATCHER_EXPORT
    DBMS_SCHED_JOB_EXPORT
    DBMS_SCHED_PROGRAM_EXPORT
    DBMS_SCHED_SCHEDULE_EXPORT
    DBMS_SCHED_WINDOW_EXPORT
    DBMS_SCHED_WINGRP_EXPORT
    DBMS_SERVER_ALERT
    DBMS_SERVER_ALERT_EXPORT
    DBMS_SERVER_TRACE
    DBMS_SERVICE
    DBMS_SESSION
    DBMS_SNAPSHOT
    DBMS_SPACE
    DBMS_SPACE_ADMIN
    DBMS_SPM
    DBMS_SQL
    DBMS_SQLDIAG
    DBMS_SQLHASH
    DBMS_SQLPA
    DBMS_SQLPLUS_SCRIPT
    DBMS_SQLTUNE
    DBMS_STANDARD
    DBMS_STATS
    DBMS_STAT_FUNCS
    DBMS_STAT_FUNCS_AUX
    DBMS_STORAGE_MAP
    DBMS_STREAMS
    DBMS_STREAMS_ADM
    DBMS_STREAMS_ADVISOR_ADM
    DBMS_STREAMS_AUTH
    DBMS_STREAMS_HANDLER_ADM
    DBMS_STREAMS_LCR_INT
    DBMS_STREAMS_MESSAGING
    DBMS_STREAMS_RPC
    DBMS_STREAMS_TABLESPACE_ADM
    DBMS_SUMMARY
    DBMS_SUM_RWEQ_EXPORT
    DBMS_SUM_RWEQ_EXPORT_INTERNAL
    DBMS_TDE_TOOLKIT
    DBMS_TRACE
    DBMS_TRANSACTION
    DBMS_TRANSACTION_INTERNAL_SYS
    DBMS_TRANSFORM
    DBMS_TRANSFORM_EXIMP
    DBMS_TYPES
    DBMS_TYPE_UTILITY
    DBMS_UNDO_ADV
    DBMS_UTILITY
    DBMS_WARNING
    DBMS_WLM
    DBMS_WORKLOAD_CAPTURE
    DBMS_WORKLOAD_REPLAY
    DBMS_WORKLOAD_REPOSITORY
    DBMS_XA
    DBMS_XA_XID
    DBMS_XA_XID_ARRAY
    DBMS_XDB
    DBMS_XDBRESOURCE
    DBMS_XDBZ
    DBMS_XDB_ADMIN
    DBMS_XDB_PRINT
    DBMS_XDB_VERSION
    DBMS_XDS
    DBMS_XDSUTL
    DBMS_XEVENT
    DBMS_XMLDOM
    DBMS_XMLGEN
    DBMS_XMLINDEX
    DBMS_XMLPARSER
    DBMS_XMLSCHEMA
    DBMS_XMLSTORE
    DBMS_XMLTRANSLATIONS
    DBMS_XPLAN
    DBMS_XSLPROCESSOR
    DBMS_XSTREAM_ADM
    DBMS_XSTREAM_AUTH
    DBMS_XSTREAM_GG
    DBMS_XSTREAM_GG_ADM
    DBMS_XS_MTCACHE
    DBMS_XS_ROLELIST
    DBMS_XS_SESSIONS
    DBMS_ZHELP
    DBMS_ZHELP_IR
    DBURITYPE
    DEFCALL
    DEFCALL
    DEFCALLDEST
    DEFCALLDEST
    DEFDEFAULTDEST
    DEFDEFAULTDEST
    DEFERRCOUNT
    DEFERRCOUNT
    DEFERROR
    DEFERROR
    DEFLOB
    DEFLOB
    DEFPROPAGATOR
    DEFPROPAGATOR
    DEFSCHEDULE
    DEFSCHEDULE
    DEFTRAN
    DEFTRAN
    DEFTRANDEST
    DEFTRANDEST
    DEPTH
    DEVELOPMENT_SERVICE_HOME
    DEVELOPMENT_SERVICE_HOME_LOGIN
    DEVELOPMENT_SERVICE_SIGNUP
    DICT
    DICTIONARY
    DICTIONARY
    DICT_COLUMNS
    DICT_COLUMNS
    DIFFERENCE
    DIMENSION
    DISJOINT
    DISTANCE
    DM_CL_BUILD
    DM_SVM_APPLY
    DM_SVM_BUILD
    DR$NUMBER_SEQUENCE
    DR$POLICY_TAB
    DRV$DELETE
    DRV$DELETE2
    DRV$ONLINE_PENDING
    DRV$PENDING
    DRV$UNINDEXED
    DRV$UNINDEXED2
    DRV$WAITING
    DRVODM
    DUAL
    DUAL
    ENDPOINT
    ENVELOPE
    EQUALS
    EQUALS_PATH
    EXPCOMPRESSEDPART
    EXPCOMPRESSEDSUB
    EXPCOMPRESSEDTAB
    EXPEXEMPT
    EXPGETENCCOLNAM
    EXPLAINMVARRAYTYPE
    EXPLAINMVMESSAGE
    EXPTABSUBPART
    EXPTABSUBPARTDATA_VIEW
    EXPTABSUBPARTLOBFRAG
    EXPTABSUBPARTLOB_VIEW
    EXTERIORRING
    EXU10ADEFPSWITCHES
    EXU10AOBJSWITCH
    EXU10DEFPSWITCHES
    EXU10DOSO
    EXU10IND_BASE
    EXU10MVL
    EXU10MVLU
    EXU10OBJSWITCH
    EXU10R2DEFPSWITCHES
    EXU10R2OBJSWITCH
    EXU816MAXSQV
    EXU81ACTIONOBJ
    EXU81ACTIONPKG
    EXU81ASSOC
    EXU81CSC
    EXU81IND
    EXU81INDC
    EXU81INDI
    EXU81INDIC
    EXU81IND_BASE
    EXU81JAV
    EXU81JAVC
    EXU81JAVI
    EXU81JAVT
    EXU81NOS
    EXU81PROCOBJ
    EXU81PROCOBJINSTANCE
    EXU81RLS
    EXU8ANAL
    EXU8BSZ
    EXU8CPO
    EXU8CSET
    EXU8DIM
    EXU8DIMC
    EXU8DIMI
    EXU8DIMU
    EXU8FUL
    EXU8GLOB
    EXU8ICO
    EXU8ICOU
    EXU8ICPLSQL
    EXU8OPT
    EXU8ORD
    EXU8ORDOP
    EXU8ORDU
    EXU8ORFS
    EXU8SPU
    EXU8TNE
    EXU8TNEB
    EXU8USCU
    EXU8VER
    EXU92TSP
    EXU92TSPL
    EXU9ACTIONOBJ
    EXU9BJF
    EXU9BJW
    EXU9DEFPSWITCHES
    EXU9DOSO
    EXU9EIP
    EXU9FGA
    EXU9GSAS
    EXU9IND
    EXU9INDC
    EXU9INDI
    EXU9INDIC
    EXU9IND_BASE
    EXU9INHCOLCONS
    EXU9MVL
    EXU9MVLCDCCC
    EXU9MVLCDCS
    EXU9MVLCDCSC
    EXU9MVLCDCST
    EXU9MVLU
    EXU9NLS
    EXU9NOS
    EXU9OBJSWITCH
    EXU9OTNNULL
    EXU9PCT
    EXU9PGP
    EXU9PTS
    EXU9RLS
    EXU9TNE
    EXU9TNEB
    EXU9XDBUID
    EXU9XMLST
    EXU9XTB
    F
    FET$
    FGA$
    FGACOL$
    FGA_LOG$
    FGR$_FILE_GROUPS
    FGR$_FILE_GROUP_EXPORT_INFO
    FGR$_FILE_GROUP_FILES
    FGR$_FILE_GROUP_VERSIONS
    FGR$_NAMES_S
    FGR$_TABLESPACE_INFO
    FGR$_TABLE_INFO
    FILE$
    FILEXT$
    FINALHIST$
    FIXED_OBJ$
    FLASHBACK_TRANSACTION_QUERY
    FLASHBACK_TRANSACTION_QUERY
    FTPURITYPE
    Folder53_TAB
    ForeignKey206_TAB
    GEODETIC_SRIDS
    GEOMETRY
    GEOMETRYCOLLECTION
    GEOMETRYN
    GEOMETRYTYPE
    GLOBAL_CONTEXT
    GLOBAL_CONTEXT
    GLOBAL_NAME
    GLOBAL_NAME
    GV$ACCESS
    GV$ACTIVE_INSTANCES
    GV$ACTIVE_SERVICES
    GV$ACTIVE_SESSION_HISTORY
    GV$ACTIVE_SESS_POOL_MTH
    GV$ADVISOR_PROGRESS
    GV$ALERT_TYPES
    GV$AQ
    GV$AQ1
    GV$ARCHIVE
    GV$ARCHIVED_LOG
    GV$ARCHIVE_DEST
    GV$ARCHIVE_DEST_STATUS
    GV$ARCHIVE_GAP
    GV$ARCHIVE_PROCESSES
    GV$ASM_ALIAS
    GV$ASM_CLIENT
    GV$ASM_DISK
    GV$ASM_DISKGROUP
    GV$ASM_DISKGROUP_STAT
    GV$ASM_DISK_IOSTAT
    GV$ASM_DISK_STAT
    GV$ASM_FILE
    GV$ASM_FILESYSTEM
    GV$ASM_OPERATION
    GV$ASM_TEMPLATE
    GV$AW_AGGREGATE_OP
    GV$AW_ALLOCATE_OP
    GV$AW_CALC
    GV$AW_LONGOPS
    GV$AW_OLAP
    GV$AW_SESSION_INFO
    GV$BACKUP
    GV$BACKUP_ASYNC_IO
    GV$BACKUP_CORRUPTION
    GV$BACKUP_DATAFILE
    GV$BACKUP_DEVICE
    GV$BACKUP_PIECE
    GV$BACKUP_REDOLOG
    GV$BACKUP_SET
    GV$BACKUP_SPFILE
    GV$BACKUP_SYNC_IO
    GV$BGPROCESS
    GV$BH
    GV$BLOCKING_QUIESCE
    GV$BSP
    GV$BUFFERED_PUBLISHERS
    GV$BUFFERED_QUEUES
    GV$BUFFERED_SUBSCRIBERS
    GV$BUFFER_POOL
    GV$BUFFER_POOL_STATISTICS
    GV$CIRCUIT
    GV$CLASS_CACHE_TRANSFER
    GV$CLASS_PING
    GV$CLIENT_STATS
    GV$CLUSTER_INTERCONNECTS
    GV$CONFIGURED_INTERCONNECTS
    GV$CONTEXT
    GV$CONTROLFILE
    GV$CONTROLFILE_RECORD_SECTION
    GV$COPY_CORRUPTION
    GV$CR_BLOCK_SERVER
    GV$CURRENT_BLOCK_SERVER
    GV$DATABASE
    GV$DATABASE_BLOCK_CORRUPTION
    GV$DATABASE_INCARNATION
    GV$DATABASE_KEY_INFO
    GV$DATAFILE
    GV$DATAFILE_COPY
    GV$DATAFILE_HEADER
    GV$DATAGUARD_CONFIG
    GV$DATAGUARD_STATUS
    GV$DATAPUMP_JOB
    GV$DATAPUMP_SESSION
    GV$DBFILE
    GV$DBLINK
    GV$DB_CACHE_ADVICE
    GV$DB_OBJECT_CACHE
    GV$DB_PIPES
    GV$DB_TRANSPORTABLE_PLATFORM
    GV$DELETED_OBJECT
    GV$DISPATCHER
    GV$DISPATCHER_CONFIG
    GV$DISPATCHER_RATE
    GV$DLM_ALL_LOCKS
    GV$DLM_CONVERT_LOCAL
    GV$DLM_CONVERT_REMOTE
    GV$DLM_LATCH
    GV$DLM_LOCKS
    GV$DLM_MISC
    GV$DLM_RESS
    GV$DLM_TRAFFIC_CONTROLLER
    GV$ENABLEDPRIVS
    GV$ENQUEUE_LOCK
    GV$ENQUEUE_STAT
    GV$ENQUEUE_STATISTICS
    GV$EVENTMETRIC
    GV$EVENT_HISTOGRAM
    GV$EVENT_NAME
    GV$EXECUTION
    GV$FAST_START_SERVERS
    GV$FAST_START_TRANSACTIONS
    GV$FILEMETRIC
    GV$FILEMETRIC_HISTORY
    GV$FILESPACE_USAGE
    GV$FILESTAT
    GV$FILE_CACHE_TRANSFER
    GV$FILE_HISTOGRAM
    GV$FILE_PING
    GV$FIXED_TABLE
    GV$FIXED_VIEW_DEFINITION
    GV$FLASHBACK_DATABASE_LOG
    GV$FLASHBACK_DATABASE_LOGFILE
    GV$FLASHBACK_DATABASE_STAT
    GV$GCSHVMASTER_INFO
    GV$GCSPFMASTER_INFO
    GV$GC_ELEMENT
    GV$GC_ELEMENTS_WITH_COLLISIONS
    GV$GES_BLOCKING_ENQUEUE
    GV$GES_ENQUEUE
    GV$GLOBALCONTEXT
    GV$GLOBAL_BLOCKED_LOCKS
    GV$GLOBAL_TRANSACTION
    GV$HS_AGENT
    GV$HS_PARAMETER
    GV$HS_SESSION
    GV$HVMASTER_INFO
    GV$INDEXED_FIXED_COLUMN
    GV$INSTANCE
    GV$INSTANCE_CACHE_TRANSFER
    GV$INSTANCE_LOG_GROUP
    GV$INSTANCE_RECOVERY
    GV$JAVAPOOL
    GV$JAVA_LIBRARY_CACHE_MEMORY
    GV$JAVA_POOL_ADVICE
    GV$LATCH
    GV$LATCHHOLDER
    GV$LATCHNAME
    GV$LATCH_CHILDREN
    GV$LATCH_MISSES
    GV$LATCH_PARENT
    GV$LIBRARYCACHE
    GV$LIBRARY_CACHE_MEMORY
    GV$LICENSE
    GV$LOADISTAT
    GV$LOADPSTAT
    GV$LOCK
    GV$LOCKED_OBJECT
    GV$LOCKS_WITH_COLLISIONS
    GV$LOCK_ACTIVITY
    GV$LOCK_ELEMENT
    GV$LOCK_TYPE
    GV$LOG
    GV$LOGFILE
    GV$LOGHIST
    GV$LOGMNR_CALLBACK
    GV$LOGMNR_CONTENTS
    GV$LOGMNR_DICTIONARY
    GV$LOGMNR_DICTIONARY_LOAD
    GV$LOGMNR_LATCH
    GV$LOGMNR_LOGFILE
    GV$LOGMNR_LOGS
    GV$LOGMNR_PARAMETERS
    GV$LOGMNR_PROCESS
    GV$LOGMNR_REGION
    GV$LOGMNR_SESSION
    GV$LOGMNR_STATS
    GV$LOGMNR_TRANSACTION
    GV$LOGSTDBY
    GV$LOGSTDBY_PROCESS
    GV$LOGSTDBY_PROGRESS
    GV$LOGSTDBY_STATE
    GV$LOGSTDBY_STATS
    GV$LOGSTDBY_TRANSACTION
    GV$LOG_HISTORY
    GV$MANAGED_STANDBY
    GV$MAP_COMP_LIST
    GV$MAP_ELEMENT
    GV$MAP_EXT_ELEMENT
    GV$MAP_FILE
    GV$MAP_FILE_EXTENT
    GV$MAP_FILE_IO_STACK
    GV$MAP_LIBRARY
    GV$MAP_SUBELEMENT
    GV$MAX_ACTIVE_SESS_TARGET_MTH
    GV$METRIC
    GV$METRICGROUP
    GV$METRICNAME
    GV$METRIC_HISTORY
    GV$MTTR_TARGET_ADVICE
    GV$MUTEX_SLEEP
    GV$MUTEX_SLEEP_HISTORY
    GV$MVREFRESH
    GV$MYSTAT
    GV$NLS_PARAMETERS
    GV$NLS_VALID_VALUES
    GV$OBJECT_DEPENDENCY
    GV$OBSOLETE_PARAMETER
    GV$OFFLINE_RANGE
    GV$OPEN_CURSOR
    GV$OPTION
    GV$OSSTAT
    GV$PARALLEL_DEGREE_LIMIT_MTH
    GV$PARAMETER
    GV$PARAMETER2
    GV$PARAMETER_VALID_VALUES
    GV$PGASTAT
    GV$PGA_TARGET_ADVICE
    GV$PGA_TARGET_ADVICE_HISTOGRAM
    GV$PQ_SESSTAT
    GV$PQ_SLAVE
    GV$PQ_SYSSTAT
    GV$PQ_TQSTAT
    GV$PROCESS
    GV$PROCESS_GROUP
    GV$PROCESS_MEMORY
    GV$PROCESS_MEMORY_DETAIL
    GV$PROCESS_MEMORY_DETAIL_PROG
    GV$PROPAGATION_RECEIVER
    GV$PROPAGATION_SENDER
    GV$PROXY_ARCHIVEDLOG
    GV$PROXY_DATAFILE
    GV$PWFILE_USERS
    GV$PX_BUFFER_ADVICE
    GV$PX_PROCESS
    GV$PX_PROCESS_SYSSTAT
    GV$PX_SESSION
    GV$PX_SESSTAT
    GV$QUEUE
    GV$QUEUEING_MTH
    GV$RECOVERY_FILE_STATUS
    GV$RECOVERY_LOG
    GV$RECOVERY_PROGRESS
    GV$RECOVERY_STATUS
    GV$RECOVER_FILE
    GV$REPLPROP
    GV$REPLQUEUE
    GV$REQDIST
    GV$RESERVED_WORDS
    GV$RESOURCE
    GV$RESOURCE_LIMIT
    GV$RESTORE_POINT
    GV$RESUMABLE
    GV$RFS_THREAD
    GV$RMAN_CONFIGURATION
    GV$RMAN_OUTPUT
    GV$ROLLSTAT
    GV$ROWCACHE
    GV$ROWCACHE_PARENT
    GV$ROWCACHE_SUBORDINATE
    GV$RSRC_CONSUMER_GROUP
    GV$RSRC_CONSUMER_GROUP_CPU_MTH
    GV$RSRC_CONS_GROUP_HISTORY
    GV$RSRC_PLAN
    GV$RSRC_PLAN_CPU_MTH
    GV$RSRC_PLAN_HISTORY
    GV$RSRC_SESSION_INFO
    GV$RULE
    GV$RULE_SET
    GV$RULE_SET_AGGREGATE_STATS
    GV$SCHEDULER_RUNNING_JOBS
    GV$SEGMENT_STATISTICS
    GV$SEGSTAT
    GV$SEGSTAT_NAME
    GV$SERVICEMETRIC
    GV$SERVICEMETRIC_HISTORY
    GV$SERVICES
    GV$SERVICE_EVENT
    GV$SERVICE_STATS
    GV$SERVICE_WAIT_CLASS
    GV$SERV_MOD_ACT_STATS
    GV$SESSION
    GV$SESSION_BLOCKERS
    GV$SESSION_CONNECT_INFO
    GV$SESSION_CURSOR_CACHE
    GV$SESSION_EVENT
    GV$SESSION_FIX_CONTROL
    GV$SESSION_LONGOPS
    GV$SESSION_OBJECT_CACHE
    GV$SESSION_WAIT
    GV$SESSION_WAIT_CLASS
    GV$SESSION_WAIT_HISTORY
    GV$SESSMETRIC
    GV$SESSTAT
    GV$SESS_IO
    GV$SESS_TIME_MODEL
    GV$SES_OPTIMIZER_ENV
    GV$SGA
    GV$SGAINFO
    GV$SGASTAT
    GV$SGA_CURRENT_RESIZE_OPS
    GV$SGA_DYNAMIC_COMPONENTS
    GV$SGA_DYNAMIC_FREE_MEMORY
    GV$SGA_RESIZE_OPS
    GV$SGA_TARGET_ADVICE
    GV$SHARED_POOL_ADVICE
    GV$SHARED_POOL_RESERVED
    GV$SHARED_SERVER
    GV$SHARED_SERVER_MONITOR
    GV$SORT_SEGMENT
    GV$SORT_USAGE
    GV$SPPARAMETER
    GV$SQL
    GV$SQLAREA
    GV$SQLAREA_PLAN_HASH
    GV$SQLCOMMAND
    GV$SQLFN_ARG_METADATA
    GV$SQLFN_METADATA
    GV$SQLPA_METRIC
    GV$SQLSTATS
    GV$SQLSTATS_PLAN_HASH
    GV$SQLTEXT
    GV$SQLTEXT_WITH_NEWLINES
    GV$SQL_BIND_CAPTURE
    GV$SQL_BIND_DATA
    GV$SQL_BIND_METADATA
    GV$SQL_CS_HISTOGRAM
    GV$SQL_CS_SELECTIVITY
    GV$SQL_CS_STATISTICS
    GV$SQL_CURSOR
    GV$SQL_FEATURE
    GV$SQL_FEATURE_DEPENDENCY
    GV$SQL_FEATURE_HIERARCHY
    GV$SQL_HINT
    GV$SQL_JOIN_FILTER
    GV$SQL_MONITOR
    GV$SQL_OPTIMIZER_ENV
    GV$SQL_PLAN
    GV$SQL_PLAN_MONITOR
    GV$SQL_PLAN_STATISTICS
    GV$SQL_PLAN_STATISTICS_ALL
    GV$SQL_REDIRECTION
    GV$SQL_SHARED_CURSOR
    GV$SQL_SHARED_MEMORY
    GV$SQL_WORKAREA
    GV$SQL_WORKAREA_ACTIVE
    GV$SQL_WORKAREA_HISTOGRAM
    GV$STANDBY_LOG
    GV$STATISTICS_LEVEL
    GV$STATNAME
    GV$STREAMS_APPLY_COORDINATOR
    GV$STREAMS_APPLY_READER
    GV$STREAMS_APPLY_SERVER
    GV$STREAMS_CAPTURE
    GV$STREAMS_POOL_ADVICE
    GV$STREAMS_TRANSACTION
    GV$SUBCACHE
    GV$SYSAUX_OCCUPANTS
    GV$SYSMETRIC
    GV$SYSMETRIC_HISTORY
    GV$SYSMETRIC_SUMMARY
    GV$SYSSTAT
    GV$SYSTEM_CURSOR_CACHE
    GV$SYSTEM_EVENT
    GV$SYSTEM_PARAMETER
    GV$SYSTEM_PARAMETER2
    GV$SYSTEM_WAIT_CLASS
    GV$SYS_OPTIMIZER_ENV
    GV$SYS_TIME_MODEL
    GV$TABLESPACE
    GV$TEMPFILE
    GV$TEMPORARY_LOBS
    GV$TEMPSEG_USAGE
    GV$TEMPSTAT
    GV$TEMP_CACHE_TRANSFER
    GV$TEMP_EXTENT_MAP
    GV$TEMP_EXTENT_POOL
    GV$TEMP_PING
    GV$TEMP_SPACE_HEADER
    GV$THREAD
    GV$THRESHOLD_TYPES
    GV$TIMER
    GV$TIMEZONE_FILE
    GV$TIMEZONE_NAMES
    GV$TRANSACTION
    GV$TRANSACTION_ENQUEUE
    GV$TRANSPORTABLE_PLATFORM
    GV$TSM_SESSIONS
    GV$TYPE_SIZE
    GV$UNDOSTAT
    GV$VERSION
    GV$VPD_POLICY
    GV$WAITCLASSMETRIC
    GV$WAITCLASSMETRIC_HISTORY
    GV$WAITSTAT
    GV$WALLET
    GV$XML_AUDIT_TRAIL
    GV$_LOCK
    GV_$ACTIVE_INSTANCES
    GV_$ACTIVE_SESS_POOL_MTH
    GV_$AW_AGGREGATE_OP
    GV_$AW_ALLOCATE_OP
    GV_$AW_CALC
    GV_$AW_LONGOPS
    GV_$AW_OLAP
    GV_$AW_SESSION_INFO
    GV_$BH
    GV_$BLOCKING_QUIESCE
    GV_$LOADISTAT
    GV_$LOADPSTAT
    GV_$MAX_ACTIVE_SESS_TARGET_MTH
    GV_$NLS_PARAMETERS
    GV_$NLS_VALID_VALUES
    GV_$OPTION
    GV_$PARALLEL_DEGREE_LIMIT_MTH
    GV_$PQ_SESSTAT
    GV_$PQ_TQSTAT
    GV_$RESTORE_POINT
    GV_$RSRC_CONSUMER_GROUP
    GV_$RSRC_CONSUME_GROUP_CPU_MTH
    GV_$RSRC_CONS_GROUP_HISTORY
    GV_$RSRC_PLAN
    GV_$RSRC_PLAN_CPU_MTH
    GV_$RSRC_PLAN_HISTORY
    GV_$RSRC_SESSION_INFO
    GV_$TEMPORARY_LOBS
    GV_$TIMEZONE_FILE
    GV_$TIMEZONE_NAMES
    GV_$VERSION
    HELP
    HHAND
    HHBYTELEN
    HHCBIT
    HHCELLBNDRY
    HHCELLSIZE
    HHCLDATE
    HHCOLLAPSE
    HHCOMMONCODE
    HHCOMPARE
    HHCOMPOSE
    HHDECODE
    HHDISTANCE
    HHENCODE
    HHENCODE_BYLEVEL
    HHGBIT
    HHGETCID
    HHGROUP
    HHGTBIT
    HHGTYPE
    HHIDLPART
    HHIDPART
    HHINCRLEV
    HHJLDATE
    HHLENGTH
    HHLEVELS
    HHMATCH
    HHMAXCODE
    HHNCOMPARE
    HHNDIM
    HHOR
    HHORDER
    HHPRECISION
    HHSBIT
    HHSETCID
    HHSTBIT
    HHSTYPE
    HHSUBDIVIDE
    HHSUBSTR
    HHXOR
    HS_ALL_CAPS
    HS_ALL_CAPS
    HS_ALL_DD
    HS_ALL_DD
    HS_ALL_INITS
    HS_ALL_INITS
    HS_BASE_CAPS
    HS_BASE_CAPS
    HS_BASE_DD
    HS_BASE_DD
    HS_CLASS_CAPS
    HS_CLASS_CAPS
    HS_CLASS_DD
    HS_CLASS_DD
    HS_CLASS_INIT
    HS_CLASS_INIT
    HS_FDS_CLASS
    HS_FDS_CLASS
    HS_FDS_CLASS_DATE
    HS_FDS_CLASS_DATE
    HS_FDS_INST
    HS_FDS_INST
    HS_INST_CAPS
    HS_INST_CAPS
    HS_INST_DD
    HS_INST_DD
    HS_INST_INIT
    HS_INST_INIT
    HTF
    HTF
    HTMLDB
    HTMLDB_ACTIVITY_LOG
    HTMLDB_ACTIVITY_LOG
    HTMLDB_ADMIN
    HTMLDB_APPLICATION
    HTMLDB_APPLICATION
    HTMLDB_APPLICATION_FILES
    HTMLDB_APPLICATION_FILES
    HTMLDB_APPLICATION_GLOBAL
    HTMLDB_APPLICATION_GLOBAL
    HTMLDB_COLLECTION
    HTMLDB_COLLECTION
    HTMLDB_COLLECTIONS
    HTMLDB_COLLECTIONS
    HTMLDB_CUSTOM_AUTH
    HTMLDB_ITEM
    HTMLDB_LANG
    HTMLDB_LDAP
    HTMLDB_LDAP
    HTMLDB_LOGIN
    HTMLDB_MAIL
    HTMLDB_MAIL
    HTMLDB_MAIL_LOG
    HTMLDB_MAIL_LOG
    HTMLDB_MAIL_QUEUE
    HTMLDB_MAIL_QUEUE
    HTMLDB_PLSQL_JOB
    HTMLDB_PLSQL_JOB
    HTMLDB_PLSQL_JOBS
    HTMLDB_PLSQL_JOBS
    HTMLDB_SYSTEM
    HTMLDB_UTIL
    HTP
    HTP
    HTTPURITYPE
    IMP8REPCAT
    IMP8UEC
    IMP9COMPAT
    IMP9SYN4
    IMP9TVOID
    IMP9USR
    IMPDP_STATS
    IMP_LOB_INFO
    IMP_LOB_NOTNULL
    IMP_TAB_TRIG
    IND
    IND$
    INDARRAYTYPE$
    INDCOMPART$
    INDCOMPARTV$
    INDEX_HISTOGRAM
    INDEX_HISTOGRAM
    INDEX_STATS
    INDEX_STATS
    INDOP$
    INDPART$
    INDPARTV$
    INDPART_PARAM$
    INDREBUILD$
    INDSUBPART$
    INDSUBPARTV$
    INDTYPES$
    IND_ONLINE$
    IND_STATS$
    INTERIORRINGN
    INTERSECTION
    INTERSECTS
    ISCLOSED
    ISEMPTY
    ISRING
    ISSIMPLE
    KU$NOEXP_TAB
    KU$_10_1_AUDIT_VIEW
    KU$_10_1_COMMENT_VIEW
    KU$_10_1_DBLINK_VIEW
    KU$_10_1_FHTABLE_VIEW
    KU$_10_1_HISTGRM_MAX_VIEW
    KU$_10_1_HISTGRM_MIN_VIEW
    KU$_10_1_HTABLE_VIEW
    KU$_10_1_IND_STATS_VIEW
    KU$_10_1_IOTABLE_VIEW
    KU$_10_1_PFHTABLE_VIEW
    KU$_10_1_PHTABLE_VIEW
    KU$_10_1_PIND_STATS_VIEW
    KU$_10_1_PIOTABLE_VIEW
    KU$_10_1_PROXY_VIEW
    KU$_10_1_PTAB_COL_STATS_VIEW
    KU$_10_1_PTAB_STATS_VIEW
    KU$_10_1_SPIND_STATS_VIEW
    KU$_10_1_SYSGRANT_VIEW
    KU$_10_1_TABLE_DATA_VIEW
    KU$_10_1_TAB_COL_STATS_VIEW
    KU$_10_1_TAB_ONLY_STATS_VIEW
    KU$_10_1_TAB_STATS_VIEW
    KU$_10_2_FHTABLE_VIEW
    KU$_10_2_INDEX_VIEW
    KU$_10_2_IND_STATS_VIEW
    KU$_10_2_STRMCOLTYPE_VIEW
    KU$_10_2_STRMCOL_VIEW
    KU$_10_2_STRMSUBCOLTYPE_VIEW
    KU$_10_2_STRMTABLE_VIEW
    KU$_10_2_TABLE_DATA_VIEW
    KU$_10_2_TAB_COL_VIEW
    KU$_10_2_TAB_STATS_VIEW
    KU$_10_2_TRIGGER_VIEW
    KU$_11_1_OBJGRANT_VIEW
    KU$_2NDTAB_INFO_VIEW
    KU$_ACPTABLE_VIEW
    KU$_ADD_SNAP_VIEW
    KU$_ALL_INDEX_VIEW
    KU$_ALTER_FUNC_VIEW
    KU$_ALTER_PKGBDY_VIEW
    KU$_ALTER_PKGSPC_VIEW
    KU$_ALTER_PROC_VIEW
    KU$_ARGUMENT_VIEW
    KU$_ASSOC_VIEW
    KU$_AUDDEF_T
    KU$_AUDIT_DEFAULT_LIST_T
    KU$_AUDIT_DEFAULT_VIEW
    KU$_AUDIT_LIST_T
    KU$_AUDIT_OBJ_BASE_VIEW
    KU$_AUDIT_OBJ_VIEW
    KU$_AUDIT_VIEW
    KU$_AUDOBJ_T
    KU$_BASE_PROC_VIEW
    KU$_BYTES_ALLOC_VIEW
    KU$_CHUNK_LIST_T
    KU$_CHUNK_T
    KU$_CLUSTER_VIEW
    KU$_CLU_TS_VIEW
    KU$_COLLECTION_VIEW
    KU$_COLTYPE_VIEW
    KU$_COLUMN_VIEW
    KU$_COL_STATS_VIEW
    KU$_COMMENT_VIEW
    KU$_CONSTRAINT0_VIEW
    KU$_CONSTRAINT1_VIEW
    KU$_CONSTRAINT2_VIEW
    KU$_CONSTRAINT_COL_VIEW
    KU$_CONSTRAINT_VIEW
    KU$_CONTEXT_VIEW
    KU$_CUBE_FACT_VIEW
    KU$_CUBE_TAB_VIEW
    KU$_DATAPUMP_MASTER_10_1
    KU$_DATAPUMP_MASTER_11_1
    KU$_DATAPUMP_MASTER_11_1_0_7
    KU$_DATAPUMP_MASTER_11_2
    KU$_DBLINK_VIEW
    KU$_DDL
    KU$_DDLS
    KU$_DEFERRED_STG_VIEW
    KU$_DEFROLE_LIST_VIEW
    KU$_DEFROLE_VIEW
    KU$_DEPTABLE_OBJNUM_VIEW
    KU$_DEPTYPES_BASE_VIEW
    KU$_DEPTYPES_VIEW
    KU$_DEPVIEWS_BASE_VIEW
    KU$_DEPVIEWS_VIEW
    KU$_DIMENSION_VIEW
    KU$_DIRECTORY_VIEW
    KU$_DOMIDX_2NDTAB_VIEW
    KU$_DOMIDX_OBJNUM_VIEW
    KU$_DOMIDX_PLSQL_VIEW
    KU$_DUMMY_COMMAND_RULE_VIEW
    KU$_DUMMY_FACTOR_LINK_VIEW
    KU$_DUMMY_FACTOR_TYPE_VIEW
    KU$_DUMMY_FACTOR_VIEW
    KU$_DUMMY_IDENTITY_MAP_VIEW
    KU$_DUMMY_IDENTITY_VIEW
    KU$_DUMMY_ISRM_VIEW
    KU$_DUMMY_ISR_VIEW
    KU$_DUMMY_REALM_AUTH_VIEW
    KU$_DUMMY_REALM_MEMBER_VIEW
    KU$_DUMMY_REALM_VIEW
    KU$_DUMMY_ROLE_VIEW
    KU$_DUMMY_RULE_SET_MEMBER_VIEW
    KU$_DUMMY_RULE_SET_VIEW
    KU$_DUMMY_RULE_VIEW
    KU$_DUMPFILE
    KU$_DUMPFILE1010
    KU$_DUMPFILE1020
    KU$_DUMPFILESET
    KU$_DUMPFILESET1010
    KU$_DUMPFILESET1020
    KU$_DUMPFILE_INFO
    KU$_DUMPFILE_ITEM
    KU$_EDITION_OBJ_VIEW
    KU$_EDITION_SCHEMAOBJ_VIEW
    KU$_END_PLUGTS_BLK_VIEW
    KU$_EQNTABLE_BYTES_ALLOC_VIEW
    KU$_EQNTABLE_DATA_VIEW
    KU$_ERRORLINE
    KU$_ERRORLINES
    KU$_EXPACT_VIEW
    KU$_EXP_PKG_BODY_VIEW
    KU$_EXP_TYPE_BODY_VIEW
    KU$_EXP_XMLSCHEMA_VIEW
    KU$_EXTTAB_VIEW
    KU$_FBA_VIEW
    KU$_FGA_POLICY_VIEW
    KU$_FHTABLE_VIEW
    KU$_FILE_VIEW
    KU$_FIND_ATTRCOL_VIEW
    KU$_FIND_HIDDEN_CONS_VIEW
    KU$_FIND_NTAB_ATTRCOL_VIEW
    KU$_FIND_SGCOL_VIEW
    KU$_FIND_SGC_COLS_VIEW
    KU$_FIND_SGC_VIEW
    KU$_FIND_SGI_COLS_VIEW
    KU$_FULL_PKG_VIEW
    KU$_FULL_TYPE_VIEW
    KU$_FUNC_VIEW
    KU$_HDEPTABLE_OBJNUM_VIEW
    KU$_HISTGRM_VIEW
    KU$_HNTP_VIEW
    KU$_HNT_VIEW
    KU$_HTABLE_BYTES_ALLOC_VIEW
    KU$_HTABLE_DATA_VIEW
    KU$_HTABLE_OBJNUM_VIEW
    KU$_HTABLE_VIEW
    KU$_HTPART_BYTES_ALLOC_VIEW
    KU$_HTPART_DATA_VIEW
    KU$_HTSPART_BYTES_ALLOC_VIEW
    KU$_HTSPART_DATA_VIEW
    KU$_INC_TYPE_VIEW
    KU$_INDARRAYTYPE_VIEW
    KU$_INDEXOP_VIEW
    KU$_INDEXTYPE_VIEW
    KU$_INDEX_COL_VIEW
    KU$_INDEX_VIEW
    KU$_IND_CACHE_STATS_VIEW
    KU$_IND_COL_VIEW
    KU$_IND_COMPART_VIEW
    KU$_IND_PARTOBJ_VIEW
    KU$_IND_PART_COL_VIEW
    KU$_IND_PART_VIEW
    KU$_IND_STATS_VIEW
    KU$_IND_SUBNAME_VIEW
    KU$_IND_SUBPART_COL_VIEW
    KU$_IND_SUBPART_VIEW
    KU$_IND_TS_VIEW
    KU$_INSERT_TS_VIEW
    KU$_INSTANCE_CALLOUT_VIEW
    KU$_IONT_VIEW
    KU$_IOTABLE_BYTES_ALLOC_VIEW
    KU$_IOTABLE_DATA_VIEW
    KU$_IOTABLE_VIEW
    KU$_IOTPART_BYTES_ALLOC_VIEW
    KU$_IOTPART_DATA_VIEW
    KU$_IOT_PARTOBJ_VIEW
    KU$_JAVA_CLASS_VIEW
    KU$_JAVA_OBJNUM_VIEW
    KU$_JAVA_RESOURCE_VIEW
    KU$_JAVA_SOURCE_VIEW
    KU$_JAVA_T
    KU$_JIJOIN_TABLE_VIEW
    KU$_JIJOIN_VIEW
    KU$_JOBDESC
    KU$_JOBDESC1010
    KU$_JOBDESC1020
    KU$_JOBSTATUS
    KU$_JOBSTATUS1010
    KU$_JOBSTATUS1020
    KU$_JOBSTATUS1120
    KU$_JOB_VIEW
    KU$_LIBRARY_VIEW
    KU$_LIST_FILTER_TEMP
    KU$_LIST_FILTER_TEMP_2
    KU$_LOBCOMPPART_VIEW
    KU$_LOBFRAGINDEX_VIEW
    KU$_LOBFRAG_VIEW
    KU$_LOBINDEX_VIEW
    KU$_LOB_VIEW
    KU$_LOGENTRY
    KU$_LOGENTRY1010
    KU$_LOGENTRY1020
    KU$_LOGLINE
    KU$_LOGLINE1010
    KU$_LOGLINE1020
    KU$_MAP_TABLE_VIEW
    KU$_METHOD_VIEW
    KU$_MONITOR_VIEW
    KU$_MULTI_DDL
    KU$_MULTI_DDLS
    KU$_MVLPROP_VIEW
    KU$_MVL_TS_VIEW
    KU$_MVPROP_VIEW
    KU$_MV_DEPTBL_OBJNUM_VIEW
    KU$_MV_TS_VIEW
    KU$_M_VIEW_FH_VIEW
    KU$_M_VIEW_H_VIEW
    KU$_M_VIEW_IOT_VIEW
    KU$_M_VIEW_LOG_FH_VIEW
    KU$_M_VIEW_LOG_H_VIEW
    KU$_M_VIEW_LOG_PFH_VIEW
    KU$_M_VIEW_LOG_PH_VIEW
    KU$_M_VIEW_LOG_VIEW
    KU$_M_VIEW_PFH_VIEW
    KU$_M_VIEW_PH_VIEW
    KU$_M_VIEW_PIOT_VIEW
    KU$_M_VIEW_VIEW
    KU$_NDEPTABLE_OBJNUM_VIEW
    KU$_NTABLE_BYTES_ALLOC_VIEW
    KU$_NTABLE_DATA_VIEW
    KU$_NTABLE_OBJNUM_VIEW
    KU$_NTPART_PARENT_VIEW
    KU$_NTPART_VIEW
    KU$_NT_PARENT_VIEW
    KU$_OBJGRANT_VIEW
    KU$_OBJNUMNAM
    KU$_OBJNUMNAMSET
    KU$_OBJNUMPAIR
    KU$_OBJNUMPAIRLIST
    KU$_OBJNUMSET
    KU$_OBJPKG_VIEW
    KU$_OIDINDEX_VIEW
    KU$_OPANCILLARY_VIEW
    KU$_OPBINDING_VIEW
    KU$_OPERATOR_VIEW
    KU$_OPQTYPE_VIEW
    KU$_OUTLINE_VIEW
    KU$_OV_TABLE_VIEW
    KU$_OV_TABPART_VIEW
    KU$_PARAMVALUE
    KU$_PARAMVALUE1010
    KU$_PARAMVALUE1020
    KU$_PARAMVALUES
    KU$_PARAMVALUES1010
    KU$_PARAMVALUES1020
    KU$_PARSED_ITEM
    KU$_PARSED_ITEMS
    KU$_PARTITION_EST_VIEW
    KU$_PARTLOB_VIEW
    KU$_PARTOBJ_VIEW
    KU$_PCOLUMN_VIEW
    KU$_PFHTABLE_VIEW
    KU$_PFHTABPROP_VIEW
    KU$_PHTABLE_VIEW
    KU$_PIND_STATS_VIEW
    KU$_PIOTABLE_VIEW
    KU$_PIOTLOBFRAG_VIEW
    KU$_PIOT_PART_VIEW
    KU$_PKGBDY_VIEW
    KU$_PKG_VIEW
    KU$_PKREF_CONSTRAINT_VIEW
    KU$_PLUGTS_BEGIN_VIEW
    KU$_PLUGTS_BLK_VIEW
    KU$_PLUGTS_CHECKPL_VIEW
    KU$_PLUGTS_TSNAME_INDEXP_VIEW
    KU$_PLUGTS_TSNAME_INDEX_VIEW
    KU$_PLUGTS_TSNAME_TABLE_VIEW
    KU$_PLUGTS_TSNAME_VIEW
    KU$_POST_DATA_TABLE_VIEW
    KU$_POST_TABLE_VIEW
    KU$_PREPOST_VIEW
    KU$_PRE_TABLE_VIEW
    KU$_PRIM_COLUMN_VIEW
    KU$_PROCACT_INSTANCE_VIEW
    KU$_PROCACT_SCHEMA_VIEW
    KU$_PROCACT_SYS_VIEW
    KU$_PROCC_VIEW
    KU$_PROCDEPOBJ_AUDIT_VIEW
    KU$_PROCDEPOBJ_GRANT_VIEW
    KU$_PROCDEPOBJ_VIEW
    KU$_PROCINFO_VIEW
    KU$_PROCJAVA_VIEW
    KU$_PROCOBJACT_VIEW
    KU$_PROCOBJ_AUDIT_VIEW
    KU$_PROCOBJ_GRANT_VIEW
    KU$_PROCOBJ_LINE
    KU$_PROCOBJ_LINES
    KU$_PROCOBJ_LOC
    KU$_PROCOBJ_LOCS
    KU$_PROCOBJ_OBJNUM_VIEW
    KU$_PROCOBJ_VIEW
    KU$_PROCPLSQL_VIEW
    KU$_PROC_AUDIT_VIEW
    KU$_PROC_GRANT_VIEW
    KU$_PROC_VIEW
    KU$_PROFILE_ATTR_VIEW
    KU$_PROFILE_VIEW
    KU$_PROXY_ROLE_LIST_VIEW
    KU$_PROXY_VIEW
    KU$_PSW_HIST_LIST_VIEW
    KU$_PSW_HIST_VIEW
    KU$_PTAB_STATS_VIEW
    KU$_PWDVFC_VIEW
    KU$_QTAB_STORAGE_VIEW
    KU$_QTRANS_VIEW
    KU$_QUEUES_VIEW
    KU$_QUEUE_TABLE_VIEW
    KU$_REFGROUP_VIEW
    KU$_REFPARTTABPROP_VIEW
    KU$_REFPAR_LEVEL
    KU$_REF_CONSTRAINT_VIEW
    KU$_REF_PAR_LEVEL_VIEW
    KU$_RESOCOST_LIST_VIEW
    KU$_RESOCOST_VIEW
    KU$_RLS_CONTEXT_VIEW
    KU$_RLS_GROUP_VIEW
    KU$_RLS_POLICY_OBJNUM_VIEW
    KU$_RLS_POLICY_VIEW
    KU$_RMGR_CONSUMER_VIEW
    KU$_RMGR_INIT_CONSUMER_VIEW
    KU$_RMGR_PLAN_DIRECT_VIEW
    KU$_RMGR_PLAN_VIEW
    KU$_ROGRANT_VIEW
    KU$_ROLE_VIEW
    KU$_ROLLBACK_VIEW
    KU$_SCHEMAOBJNUM_VIEW
    KU$_SCHEMAOBJ_VIEW
    KU$_SCHEMA_CALLOUT_VIEW
    KU$_SEQUENCE_VIEW
    KU$_SGR_SGE_VIEW
    KU$_SIMPLE_COL_VIEW
    KU$_SIMPLE_PKREF_COL_VIEW
    KU$_SIMPLE_SETID_COL_VIEW
    KU$_SIMPLE_TYPE_VIEW
    KU$_SOURCE_LIST_T
    KU$_SOURCE_T
    KU$_SPIND_STATS_VIEW
    KU$_STATUS
    KU$_STATUS1010
    KU$_STATUS1020
    KU$_STATUS1120
    KU$_STORAGE_VIEW
    KU$_STRMCOLTYPE_VIEW
    KU$_STRMCOL_VIEW
    KU$_STRMSUBCOLTYPE_VIEW
    KU$_STRMTABLE_VIEW
    KU$_SUBCOLTYPE_VIEW
    KU$_SUBLOBFRAGINDEX_VIEW
    KU$_SUBLOBFRAG_VIEW
    KU$_SUBMITRESULT
    KU$_SUBMITRESULTS
    KU$_SUBPARTITION_EST_VIEW
    KU$_SWITCH_COMPILER_VIEW
    KU$_SYNONYM_VIEW
    KU$_SYSCALLOUT_VIEW
    KU$_SYSGRANT_VIEW
    KU$_TABCLUSTER_COL_VIEW
    KU$_TABCLUSTER_VIEW
    KU$_TABLESPACE_VIEW
    KU$_TABLE_DATA_VIEW
    KU$_TABLE_EST_VIEW
    KU$_TABLE_EXISTS_VIEW
    KU$_TABLE_OBJNUM_VIEW
    KU$_TABLE_TYPES_VIEW
    KU$_TABLE_XMLSCHEMA_VIEW
    KU$_TABPROP_VIEW
    KU$_TAB_CACHE_STATS_VIEW
    KU$_TAB_COL_VIEW
    KU$_TAB_COMPART_VIEW
    KU$_TAB_ONLY_STATS_VIEW
    KU$_TAB_PARTOBJ_VIEW
    KU$_TAB_PART_COL_VIEW
    KU$_TAB_PART_VIEW
    KU$_TAB_STATS_VIEW
    KU$_TAB_SUBNAME_VIEW
    KU$_TAB_SUBPART_COL_VIEW
    KU$_TAB_SUBPART_VIEW
    KU$_TAB_TSUBPART_VIEW
    KU$_TAB_TS_VIEW
    KU$_TACTION_LIST_T
    KU$_TACTION_T
    KU$_TEMP_SUBPARTDATA_VIEW
    KU$_TEMP_SUBPARTLOBFRG_VIEW
    KU$_TEMP_SUBPARTLOB_VIEW
    KU$_TEMP_SUBPART_VIEW
    KU$_TLOB_COMPPART_VIEW
    KU$_TRIGGERCOL_VIEW
    KU$_TRIGGERDEP_VIEW
    KU$_TRIGGER_VIEW
    KU$_TRLINK_VIEW
    KU$_TSQUOTA_VIEW
    KU$_TTSP_IDX_TABLESPACE_VIEW
    KU$_TTSP_INDPARTVIEW
    KU$_TTSP_INDSUBPARTVIEW
    KU$_TTS_IDXVIEW
    KU$_TTS_IDX_TABLESPACE_VIEW
    KU$_TTS_INDPARTVIEW
    KU$_TTS_INDSUBPARTVIEW
    KU$_TTS_IND_VIEW
    KU$_TTS_MVL_VIEW
    KU$_TTS_MV_VIEW
    KU$_TTS_PARTLOBVIEW
    KU$_TTS_SUBPARTLOBVIEW
    KU$_TTS_TABPARTVIEW
    KU$_TTS_TABSUBPARTVIEW
    KU$_TTS_TABVIEW
    KU$_TTS_TAB_TABLESPACE_VIEW
    KU$_TTS_TYPES_VIEW
    KU$_TTS_VIEW
    KU$_TYPE_ATTR_VIEW
    KU$_TYPE_BODY_VIEW
    KU$_TYPE_VIEW
    KU$_UNLOAD_METHOD_VIEW
    KU$_UP_STATS_VIEW
    KU$_USER_PREF_STATS_VIEW
    KU$_USER_VIEW
    KU$_VCNT
    KU$_VIEW_OBJNUM_VIEW
    KU$_VIEW_STATUS_VIEW
    KU$_VIEW_VIEW
    KU$_WORKERSTATUS
    KU$_WORKERSTATUS1010
    KU$_WORKERSTATUS1020
    KU$_WORKERSTATUS1120
    KU$_WORKERSTATUSLIST
    KU$_WORKERSTATUSLIST1010
    KU$_WORKERSTATUSLIST1020
    KU$_WORKERSTATUSLIST1120
    KU$_XDB_NTABLE_OBJNUM_VIEW
    KU$_XMLCOLSET_T
    KU$_XMLSCHEMA_ELMT_VIEW
    KU$_XMLSCHEMA_SPECIAL_VIEW
    KU$_XMLSCHEMA_TYPES_VIEW
    KU$_XMLSCHEMA_VIEW
    KUPCC
    KU_NOEXP_VIEW
    LINESTRING
    LINESTRINGFROMTEXT
    LINESTRINGFROMWKB
    LOADER_COL_FLAGS
    LOADER_COL_FLAGS
    LOADER_COL_INFO
    LOADER_COL_INFO
    LOADER_COL_TYPE
    LOADER_COL_TYPE
    LOADER_CONSTRAINT_INFO
    LOADER_CONSTRAINT_INFO
    LOADER_DIR_OBJS
    LOADER_DIR_OBJS
    LOADER_FILE_TS
    LOADER_FILE_TS
    LOADER_FULL_ATTR_NAME
    LOADER_FULL_ATTR_NAME
    LOADER_INTCOL_INFO
    LOADER_INTCOL_INFO
    LOADER_LOB_FLAGS
    LOADER_LOB_FLAGS
    LOADER_NESTED_VARRAYS
    LOADER_NESTED_VARRAYS
    LOADER_OID_INFO
    LOADER_OID_INFO
    LOADER_PARAM_INFO
    LOADER_PARAM_INFO
    LOADER_PART_INFO
    LOADER_PART_INFO
    LOADER_REF_INFO
    LOADER_REF_INFO
    LOADER_SKIP_UNUSABLE_INDEXES
    LOADER_SKIP_UNUSABLE_INDEXES
    LOADER_TAB_INFO
    LOADER_TAB_INFO
    LOADER_TRIGGER_INFO
    LOADER_TRIGGER_INFO
    LOCATOR_WITHIN_DISTANCE
    MAP_OBJECT
    MAP_OBJECT
    MATCHES
    MATCH_SCORE
    MD
    MD$RELATE
    MD_LRS
    MULTICURVE
    MULTILINESTRING
    MULTILINESTRINGFROMTEXT
    MULTILINESTRINGFROMWKB
    MULTIPOINT
    MULTIPOLYGON
    MULTIPOLYGONFROMTEXT
    MULTIPOLYGONFROMWKB
    MULTISURFACE
    MY_SDO_INDEX_METADATA
    MY_SDO_INDEX_METADATA
    NLS_DATABASE_PARAMETERS
    NLS_DATABASE_PARAMETERS
    NLS_INSTANCE_PARAMETERS
    NLS_INSTANCE_PARAMETERS
    NLS_SESSION_PARAMETERS
    NLS_SESSION_PARAMETERS
    NUMGEOMETRIES
    NUMINTERIORRINGS
    NUMPOINTS
    NV
    OBJ
    OBJ$
    OBJAUTH$
    OBJECT_GRANT
    OBJECT_USAGE
    OBJERROR$
    OBJPRIV$
    ODCICONST
    ODCI_SECOBJ$
    ODCI_WARNINGS$
    ODM_UTIL
    OGC_CONTAINS
    OGC_LENGTH
    OGC_UNION
    OGIS_GEOMETRY_COLUMNS
    OGIS_GEOMETRY_COLUMNS
    OGIS_SPATIAL_REFERENCE_SYSTEMS
    OGIS_SPATIAL_REFERENCE_SYSTEMS
    OL$
    OL$
    OL$
    OL$HINTS
    OL$HINTS
    OL$HINTS
    OL$NODES
    OL$NODES
    OL$NODES
    OLAPRC_TABLE
    OLAP_BOOL_SRF
    OLAP_CONDITION
    OLAP_DATE_SRF
    OLAP_EXPRESSION
    OLAP_EXPRESSION_BOOL
    OLAP_EXPRESSION_DATE
    OLAP_EXPRESSION_TEXT
    OLAP_NUMBER_SRF
    OLAP_SRF_T
    OLAP_TABLE
    OLAP_TEXT_SRF
    ORA_CLIENT_IP_ADDRESS
    ORA_DATABASE_NAME
    ORA_DES_ENCRYPTED_PASSWORD
    ORA_DICT_OBJ_NAME
    ORA_DICT_OBJ_NAME_LIST
    ORA_DICT_OBJ_OWNER
    ORA_DICT_OBJ_OWNER_LIST
    ORA_DICT_OBJ_TYPE
    ORA_DM_TREE_NODES
    ORA_FI_DECISION_TREE_HORIZ
    ORA_GRANTEE
    ORA_INSTANCE_NUM
    ORA_IS_ALTER_COLUMN
    ORA_IS_CREATING_NESTED_TABLE
    ORA_IS_DROP_COLUMN
    ORA_IS_SERVERERROR
    ORA_KGLR7_DB_LINKS
    ORA_KGLR7_DB_LINKS
    ORA_KGLR7_DEPENDENCIES
    ORA_KGLR7_DEPENDENCIES
    ORA_KGLR7_IDL_CHAR
    ORA_KGLR7_IDL_CHAR
    ORA_KGLR7_IDL_SB4
    ORA_KGLR7_IDL_SB4
    ORA_KGLR7_IDL_UB1
    ORA_KGLR7_IDL_UB1
    ORA_KGLR7_IDL_UB2
    ORA_KGLR7_IDL_UB2
    ORA_LOGIN_USER
    ORA_PARTITION_POS
    ORA_PRIVILEGE_LIST
    ORA_REVOKEE
    ORA_SERVER_ERROR
    ORA_SERVER_ERROR_DEPTH
    ORA_SERVER_ERROR_MSG
    ORA_SERVER_ERROR_NUM_PARAMS
    ORA_SERVER_ERROR_PARAM
    ORA_SPACE_ERROR_INFO
    ORA_SQL_TXT
    ORA_SYSEVENT
    ORA_WITH_GRANT_OPTION
    OUTLINE
    OUTLN_PKG
    OVERLAP
    OWA
    OWA_CACHE
    OWA_COOKIE
    OWA_COOKIE
    OWA_CUSTOM
    OWA_GLOBAL
    OWA_IMAGE
    OWA_INIT
    OWA_MATCH
    OWA_OPT_LOCK
    OWA_PATTERN
    OWA_SEC
    OWA_TEXT
    OWA_UTIL
    OWA_UTIL
    P
    PARAMETER$
    PARSED_PIECES
    PARSED_SIZE
    PARTCOL$
    PARTITION_NAME$
    PARTLOB$
    PARTOBJ$
    PATH
    PATH_VIEW
    PATH_VIEW
    PBSDE
    PENDING_SESSIONS$
    PENDING_SUB_SESSIONS$
    PENDING_TRANS$
    PLAN_TABLE
    PLAN_TABLE$
    PLITBLM
    PLSCOPE_ACTION$
    PLSCOPE_IDENTIFIER$
    PLUGGABLE_SET_CHECK
    POINT
    POINTFROMTEXT
    POINTFROMWKB
    POINTN
    POINTONSURFACE
    POLYGON
    POLYGONFROMTEXT
    POLYGONFROMWKB
    PRIVATE_JDBC
    PROCEDURE$
    PROCEDUREC$
    PROCEDUREINFO$
    PROCEDUREJAVA$
    PROCEDUREPLSQL$
    PRODUCT_COMPONENT_VERSION
    PRODUCT_COMPONENT_VERSION
    PRODUCT_PRIVS
    PRODUCT_PROFILE
    PRODUCT_USER_PROFILE
    PRODUCT_USER_PROFILE
    PROFILE$
    PROFNAME$
    PROFNUM$
    PROPS$
    PROXY_DATA$
    PROXY_INFO$
    PROXY_ROLES
    PROXY_ROLES
    PROXY_ROLE_DATA$
    PROXY_ROLE_INFO$
    PROXY_USERS
    PROXY_USERS
    PROXY_USERS_AND_ROLES
    PROXY_USERS_AND_ROLES
    PS$
    PS1$
    PSINDEX_SEQ$
    PSS1$
    PSTUBTBL
    PUBLICSYN
    PUBLICSYN
    PUBLIC_DEPENDENCY
    PUBLIC_DEPENDENCY
    QUEUE_PRIVILEGES
    QUEUE_PRIVILEGES
    RECYCLEBIN
    RECYCLEBIN$
    RELATE
    REPCAT_REPCOLUMN_BASE
    REPCAT_REPCOLUMN_BASE
    RESOURCE_COST
    RESOURCE_COST
    RESOURCE_COST$
    RESOURCE_VIEW
    RESOURCE_VIEW
    REWRITEARRAYTYPE
    REWRITEMESSAGE
    ROLE_ROLE_PRIVS
    ROLE_ROLE_PRIVS
    ROLE_SYS_PRIVS
    ROLE_SYS_PRIVS
    ROLE_TAB_PRIVS
    ROLE_TAB_PRIVS
    RTREEJOINFUNC
    SAMPLE_SEQ
    SCHEMA_EXPORT_OBJECTS
    SCHEMA_EXPORT_OBJECTS
    SCN_TO_TIMESTAMP
    SCORE
    SDO
    SDOAGGRTYPE
    SDORIDTABLE
    SDO_3DTHEMES_TABLE
    SDO_3DTXFMS_TABLE
    SDO_3GL
    SDO_ADDR_ARRAY
    SDO_ADMIN
    SDO_AGGR_CENTROID
    SDO_AGGR_CONCAT_LINES
    SDO_AGGR_CONVEXHULL
    SDO_AGGR_LRS_CONCAT
    SDO_AGGR_LRS_CONCAT_3D
    SDO_AGGR_MBR
    SDO_AGGR_SET_UNION
    SDO_AGGR_UNION
    SDO_ANGLE_UNITS
    SDO_ANGLE_UNITS
    SDO_ANIMATIONS_TABLE
    SDO_ANNOTATION_TEXT_METADATA
    SDO_ANYINTERACT
    SDO_AREA_UNITS
    SDO_AREA_UNITS
    SDO_AVAILABLE_ELEM_OPS
    SDO_AVAILABLE_ELEM_OPS
    SDO_AVAILABLE_NON_ELEM_OPS
    SDO_AVAILABLE_NON_ELEM_OPS
    SDO_AVAILABLE_OPS
    SDO_AVAILABLE_OPS
    SDO_CACHED_MAPS_TABLE
    SDO_CATALOG
    SDO_CONTAINS
    SDO_COORD_AXES
    SDO_COORD_AXES
    SDO_COORD_AXIS_NAMES
    SDO_COORD_AXIS_NAMES
    SDO_COORD_OPS
    SDO_COORD_OPS
    SDO_COORD_OP_METHODS
    SDO_COORD_OP_METHODS
    SDO_COORD_OP_PARAMS
    SDO_COORD_OP_PARAMS
    SDO_COORD_OP_PARAM_USE
    SDO_COORD_OP_PARAM_USE
    SDO_COORD_OP_PARAM_VALS
    SDO_COORD_OP_PARAM_VALS
    SDO_COORD_OP_PATHS
    SDO_COORD_OP_PATHS
    SDO_COORD_REF_SYS
    SDO_COORD_REF_SYS
    SDO_COORD_REF_SYSTEM
    SDO_COORD_REF_SYSTEM
    SDO_COORD_SYS
    SDO_COORD_SYS
    SDO_COVEREDBY
    SDO_COVERS
    SDO_CRS_COMPOUND
    SDO_CRS_COMPOUND
    SDO_CRS_ENGINEERING
    SDO_CRS_ENGINEERING
    SDO_CRS_GEOCENTRIC
    SDO_CRS_GEOCENTRIC
    SDO_CRS_GEOGRAPHIC2D
    SDO_CRS_GEOGRAPHIC2D
    SDO_CRS_GEOGRAPHIC3D
    SDO_CRS_GEOGRAPHIC3D
    SDO_CRS_GEOGRAPHIC_PLUS_HEIGHT
    SDO_CRS_PROJECTED
    SDO_CRS_PROJECTED
    SDO_CRS_VERTICAL
    SDO_CRS_VERTICAL
    SDO_CS
    SDO_CS_CONTEXT_INFORMATION
    SDO_CS_SRS
    SDO_DATUMS
    SDO_DATUMS
    SDO_DATUMS_OLD_FORMAT
    SDO_DATUMS_OLD_FORMAT
    SDO_DATUMS_OLD_SNAPSHOT
    SDO_DATUMS_OLD_SNAPSHOT
    SDO_DATUM_ENGINEERING
    SDO_DATUM_ENGINEERING
    SDO_DATUM_GEODETIC
    SDO_DATUM_GEODETIC
    SDO_DATUM_VERTICAL
    SDO_DATUM_VERTICAL
    SDO_DIM_ARRAY
    SDO_DIM_ELEMENT
    SDO_DIST_UNITS
    SDO_DIST_UNITS
    SDO_EDGE_ARRAY
    SDO_ELEM_INFO_ARRAY
    SDO_ELLIPSOIDS
    SDO_ELLIPSOIDS
    SDO_ELLIPSOIDS_OLD_FORMAT
    SDO_ELLIPSOIDS_OLD_FORMAT
    SDO_ELLIPSOIDS_OLD_SNAPSHOT
    SDO_ELLIPSOIDS_OLD_SNAPSHOT
    SDO_EQUAL
    SDO_FILTER
    SDO_GEOM
    SDO_GEOMETRY
    SDO_GEOMETRY_ARRAY
    SDO_GEOM_METADATA_TABLE
    SDO_GEO_ADDR
    SDO_IDX_TAB_SEQUENCE
    SDO_INDEX_METADATA
    SDO_INDEX_METADATA_TABLE
    SDO_INSIDE
    SDO_JOIN
    SDO_KEYWORDARRAY
    SDO_LIGHTSOURCES_TABLE
    SDO_LIST_TYPE
    SDO_LRS
    SDO_LRS_METADATA_TABLE
    SDO_MAPS_TABLE
    SDO_MBR
    SDO_MIGRATE
    SDO_NN
    SDO_NN_DISTANCE
    SDO_NUMBER_ARRAY
    SDO_ON
    SDO_ORDINATE_ARRAY
    SDO_OVERLAPBDYDISJOINT
    SDO_OVERLAPBDYINTERSECT
    SDO_OVERLAPS
    SDO_POINT_TYPE
    SDO_PQRY
    SDO_PREFERRED_OPS_SYSTEM
    SDO_PREFERRED_OPS_SYSTEM
    SDO_PREFERRED_OPS_USER
    SDO_PREFERRED_OPS_USER
    SDO_PRIDX
    SDO_PRIME_MERIDIANS
    SDO_PRIME_MERIDIANS
    SDO_PROJECTIONS_OLD_FORMAT
    SDO_PROJECTIONS_OLD_FORMAT
    SDO_PROJECTIONS_OLD_SNAPSHOT
    SDO_PROJECTIONS_OLD_SNAPSHOT
    SDO_RANGE
    SDO_RANGE_ARRAY
    SDO_REGAGGR
    SDO_REGAGGRSET
    SDO_REGION
    SDO_REGIONSET
    SDO_RELATE
    SDO_RELATEMASK_TABLE
    SDO_RELATEMASK_TABLE
    SDO_RELATE_MASK
    SDO_ROWIDPAIR
    SDO_ROWIDSET
    SDO_RTREE_ADMIN
    SDO_RTREE_FILTER
    SDO_RTREE_RELATE
    SDO_SCENES_TABLE
    SDO_SRID_CHAIN
    SDO_SRID_LIST
    SDO_STRING2_ARRAY
    SDO_STRING2_ARRAYSET
    SDO_STRING_ARRAY
    SDO_STYLES_TABLE
    SDO_ST_TOLERANCE
    SDO_ST_TOLERANCE
    SDO_TFM_CHAIN
    SDO_TGL_OBJECT
    SDO_TGL_OBJECT_ARRAY
    SDO_THEMES_TABLE
    SDO_TOPO_DATA$
    SDO_TOPO_DATA$
    SDO_TOPO_GEOMETRY
    SDO_TOPO_GEOMETRY_LAYER
    SDO_TOPO_GEOMETRY_LAYER_ARRAY
    SDO_TOPO_MAPS
    SDO_TOPO_METADATA_TABLE
    SDO_TOPO_NSTD_TBL
    SDO_TOPO_OBJECT
    SDO_TOPO_OBJECT_ARRAY
    SDO_TOPO_RELATION_DATA
    SDO_TOPO_TRANSACT_DATA
    SDO_TOPO_TRANSACT_DATA$
    SDO_TOPO_TRANSACT_DATA$
    SDO_TOPO_TRANSACT_SEQ
    SDO_TOPO_TRANSACT_SUBSEQ
    SDO_TOUCH
    SDO_TRANSIENT_RULE
    SDO_TRANSIENT_RULE_SET
    SDO_TUNE
    SDO_TXN_IDX_DELETES
    SDO_TXN_IDX_DELETES
    SDO_TXN_IDX_EXP_UPD_RGN
    SDO_TXN_IDX_EXP_UPD_RGN
    SDO_TXN_IDX_INSERTS
    SDO_TXN_IDX_INSERTS
    SDO_UNITS_OF_MEASURE
    SDO_UNITS_OF_MEASURE
    SDO_UTIL
    SDO_VERSION
    SDO_VIEWFRAMES_TABLE
    SDO_VPOINT_TYPE
    SDO_WITHIN_DISTANCE
    SDO_XML_SCHEMAS
    SDO_XML_SCHEMAS
    SEQ
    SEQ$
    SESSION_CONTEXT
    SESSION_CONTEXT
    SESSION_PRIVS
    SESSION_PRIVS
    SESSION_ROLES
    SESSION_ROLES
    SM$VERSION
    SM_$VERSION
    SPATIAL_INDEX
    SQLPROF_ATTR
    SQLSET
    SQLSET_ROW
    SQL_BIND
    SQL_BINDS
    SQL_BIND_SET
    SQL_OBJECTS
    SQL_PLAN_ROW_TYPE
    SQL_PLAN_STAT_ROW_TYPE
    SQL_PLAN_TABLE_TYPE
    SRID
    STARTPOINT
    STMT_AUDIT_OPTION_MAP
    STMT_AUDIT_OPTION_MAP
    SURFACE
    SYMMETRICDIFFERENCE
    SYN
    SYN$
    SYNONYMS
    SYNOPSIS_NUM_SEQ
    SYSCATALOG
    SYSCATALOG
    SYSCATALOG_
    SYSFILES
    SYSFILES
    SYSSEGOBJ
    SYSTEM_PRIVILEGE_MAP
    SYSTEM_PRIVILEGE_MAP
    SYS_IXQAGG
    SYS_IXQAGGAVG
    SYS_IXQAGGSUM
    SYS_NT_COLLECT
    SYS_XMLAGG
    TFM_PLAN
    TIMESTAMP_TO_SCN
    TMP_COORD_OPS
    TMP_COORD_OPS
    TOUCH
    TRANSPORTABLE_EXPORT_OBJECTS
    TRANSPORTABLE_EXPORT_OBJECTS
    TRUSTED_SERVERS
    TRUSTED_SERVERS
    UNDER_PATH
    URIFACTORY
    URITYPE
    USER_ADDM_FDG_BREAKDOWN
    USER_ADDM_FDG_BREAKDOWN
    USER_ADDM_FINDINGS
    USER_ADDM_FINDINGS
    USER_ADDM_INSTANCES
    USER_ADDM_INSTANCES
    USER_ADDM_TASKS
    USER_ADDM_TASKS
    USER_ADDM_TASK_DIRECTIVES
    USER_ADDM_TASK_DIRECTIVES
    USER_ADVISOR_ACTIONS
    USER_ADVISOR_ACTIONS
    USER_ADVISOR_DIR_TASK_INST
    USER_ADVISOR_DIR_TASK_INST
    USER_ADVISOR_EXECUTIONS
    USER_ADVISOR_EXECUTIONS
    USER_ADVISOR_EXEC_PARAMETERS
    USER_ADVISOR_EXEC_PARAMETERS
    USER_ADVISOR_FDG_BREAKDOWN
    USER_ADVISOR_FDG_BREAKDOWN
    USER_ADVISOR_FINDINGS
    USER_ADVISOR_FINDINGS
    USER_ADVISOR_JOURNAL
    USER_ADVISOR_JOURNAL
    USER_ADVISOR_LOG
    USER_ADVISOR_LOG
    USER_ADVISOR_OBJECTS
    USER_ADVISOR_OBJECTS
    USER_ADVISOR_PARAMETERS
    USER_ADVISOR_PARAMETERS
    USER_ADVISOR_RATIONALE
    USER_ADVISOR_RATIONALE
    USER_ADVISOR_RECOMMENDATIONS
    USER_ADVISOR_RECOMMENDATIONS
    USER_ADVISOR_SQLA_COLVOL
    USER_ADVISOR_SQLA_COLVOL
    USER_ADVISOR_SQLA_REC_SUM
    USER_ADVISOR_SQLA_REC_SUM
    USER_ADVISOR_SQLA_TABLES
    USER_ADVISOR_SQLA_TABLES
    USER_ADVISOR_SQLA_TABVOL
    USER_ADVISOR_SQLA_TABVOL
    USER_ADVISOR_SQLA_WK_MAP
    USER_ADVISOR_SQLA_WK_MAP
    USER_ADVISOR_SQLA_WK_STMTS
    USER_ADVISOR_SQLA_WK_STMTS
    USER_ADVISOR_SQLA_WK_SUM
    USER_ADVISOR_SQLA_WK_SUM
    USER_ADVISOR_SQLPLANS
    USER_ADVISOR_SQLPLANS
    USER_ADVISOR_SQLSTATS
    USER_ADVISOR_SQLSTATS
    USER_ADVISOR_SQLW_COLVOL
    USER_ADVISOR_SQLW_COLVOL
    USER_ADVISOR_SQLW_JOURNAL
    USER_ADVISOR_SQLW_JOURNAL
    USER_ADVISOR_SQLW_PARAMETERS
    USER_ADVISOR_SQLW_PARAMETERS
    USER_ADVISOR_SQLW_STMTS
    USER_ADVISOR_SQLW_STMTS
    USER_ADVISOR_SQLW_SUM
    USER_ADVISOR_SQLW_SUM
    USER_ADVISOR_SQLW_TABLES
    USER_ADVISOR_SQLW_TABLES
    USER_ADVISOR_SQLW_TABVOL
    USER_ADVISOR_SQLW_TABVOL
    USER_ADVISOR_SQLW_TEMPLATES
    USER_ADVISOR_SQLW_TEMPLATES
    USER_ADVISOR_TASKS
    USER_ADVISOR_TASKS
    USER_ADVISOR_TEMPLATES
    USER_ADVISOR_TEMPLATES
    USER_ALL_TABLES
    USER_ALL_TABLES
    USER_ANNOTATION_TEXT_METADATA
    USER_ANNOTATION_TEXT_METADATA
    USER_APPLICATION_ROLES
    USER_APPLICATION_ROLES
    USER_AQ_AGENT_PRIVS
    USER_AQ_AGENT_PRIVS
    USER_ARGUMENTS
    USER_ARGUMENTS
    USER_ASSEMBLIES
    USER_ASSEMBLIES
    USER_ASSOCIATIONS
    USER_ASSOCIATIONS
    USER_ASTATUS_MAP
    USER_ATTRIBUTE_TRANSFORMATIONS
    USER_ATTRIBUTE_TRANSFORMATIONS
    USER_AUDIT_OBJECT
    USER_AUDIT_OBJECT
    USER_AUDIT_POLICIES
    USER_AUDIT_POLICIES
    USER_AUDIT_POLICY_COLUMNS
    USER_AUDIT_POLICY_COLUMNS
    USER_AUDIT_SESSION
    USER_AUDIT_SESSION
    USER_AUDIT_STATEMENT
    USER_AUDIT_STATEMENT
    USER_AUDIT_TRAIL
    USER_AUDIT_TRAIL
    USER_AWS
    USER_AWS
    USER_AW_PS
    USER_AW_PS
    USER_BASE_TABLE_MVIEWS
    USER_BASE_TABLE_MVIEWS
    USER_CATALOG
    USER_CATALOG
    USER_CHANGE_NOTIFICATION_REGS
    USER_CHANGE_NOTIFICATION_REGS
    USER_CLUSTERS
    USER_CLUSTERS
    USER_CLUSTER_HASH_EXPRESSIONS
    USER_CLUSTER_HASH_EXPRESSIONS
    USER_CLU_COLUMNS
    USER_CLU_COLUMNS
    USER_COLL_TYPES
    USER_COLL_TYPES
    USER_COL_COMMENTS
    USER_COL_COMMENTS
    USER_COL_PENDING_STATS
    USER_COL_PENDING_STATS
    USER_COL_PRIVS
    USER_COL_PRIVS
    USER_COL_PRIVS_MADE
    USER_COL_PRIVS_MADE
    USER_COL_PRIVS_RECD
    USER_COL_PRIVS_RECD
    USER_COMPARISON
    USER_COMPARISON
    USER_COMPARISON_COLUMNS
    USER_COMPARISON_COLUMNS
    USER_COMPARISON_ROW_DIF
    USER_COMPARISON_ROW_DIF
    USER_COMPARISON_SCAN
    USER_COMPARISON_SCAN
    USER_COMPARISON_SCAN_SUMMARY
    USER_COMPARISON_SCAN_SUMMARY
    USER_COMPARISON_SCAN_VALUES
    USER_COMPARISON_SCAN_VALUES
    USER_CONSTRAINTS
    USER_CONSTRAINTS
    USER_CONS_COLUMNS
    USER_CONS_COLUMNS
    USER_CONS_OBJ_COLUMNS
    USER_CONS_OBJ_COLUMNS
    USER_CQ_NOTIFICATION_QUERIES
    USER_CQ_NOTIFICATION_QUERIES
    USER_CUBES
    USER_CUBES
    USER_CUBE_ATTRIBUTES
    USER_CUBE_ATTRIBUTES
    USER_CUBE_ATTR_VISIBILITY
    USER_CUBE_ATTR_VISIBILITY
    USER_CUBE_BUILD_PROCESSES
    USER_CUBE_BUILD_PROCESSES
    USER_CUBE_CALCULATED_MEMBERS
    USER_CUBE_CALCULATED_MEMBERS
    USER_CUBE_DIMENSIONALITY
    USER_CUBE_DIMENSIONALITY
    USER_CUBE_DIMENSIONS
    USER_CUBE_DIMENSIONS
    USER_CUBE_DIM_LEVELS
    USER_CUBE_DIM_LEVELS
    USER_CUBE_DIM_MODELS
    USER_CUBE_DIM_MODELS
    USER_CUBE_DIM_VIEWS
    USER_CUBE_DIM_VIEWS
    USER_CUBE_DIM_VIEW_COLUMNS
    USER_CUBE_DIM_VIEW_COLUMNS
    USER_CUBE_HIERARCHIES
    USER_CUBE_HIERARCHIES
    USER_CUBE_HIER_LEVELS
    USER_CUBE_HIER_LEVELS
    USER_CUBE_HIER_VIEWS
    USER_CUBE_HIER_VIEWS
    USER_CUBE_HIER_VIEW_COLUMNS
    USER_CUBE_HIER_VIEW_COLUMNS
    USER_CUBE_MEASURES
    USER_CUBE_MEASURES
    USER_CUBE_VIEWS
    USER_CUBE_VIEWS
    USER_CUBE_VIEW_COLUMNS
    USER_CUBE_VIEW_COLUMNS
    USER_DATAPUMP_JOBS
    USER_DATAPUMP_JOBS
    USER_DBFS_HS
    USER_DBFS_HS
    USER_DBFS_HS_COMMANDS
    USER_DBFS_HS_COMMANDS
    USER_DBFS_HS_FILES
    USER_DBFS_HS_FILES
    USER_DBFS_HS_FIXED_PROPERTIES
    USER_DBFS_HS_FIXED_PROPERTIES
    USER_DBFS_HS_PROPERTIES
    USER_DBFS_HS_PROPERTIES
    USER_DB_LINKS
    USER_DB_LINKS
    USER_DEPENDENCIES
    USER_DEPENDENCIES
    USER_DIMENSIONS
    USER_DIMENSIONS
    USER_DIM_ATTRIBUTES
    USER_DIM_ATTRIBUTES
    USER_DIM_CHILD_OF
    USER_DIM_CHILD_OF
    USER_DIM_HIERARCHIES
    USER_DIM_HIERARCHIES
    USER_DIM_JOIN_KEY
    USER_DIM_JOIN_KEY
    USER_DIM_LEVELS
    USER_DIM_LEVELS
    USER_DIM_LEVEL_KEY
    USER_DIM_LEVEL_KEY
    USER_EDITIONING_VIEWS
    USER_EDITIONING_VIEWS
    USER_EDITIONING_VIEWS_AE
    USER_EDITIONING_VIEWS_AE
    USER_EDITIONING_VIEW_COLS
    USER_EDITIONING_VIEW_COLS
    USER_EDITIONING_VIEW_COLS_AE
    USER_EDITIONING_VIEW_COLS_AE
    USER_ENCRYPTED_COLUMNS
    USER_ENCRYPTED_COLUMNS
    USER_EPG_DAD_AUTHORIZATION
    USER_EPG_DAD_AUTHORIZATION
    USER_ERRORS
    USER_ERRORS
    USER_ERRORS_AE
    USER_ERRORS_AE
    USER_EVALUATION_CONTEXTS
    USER_EVALUATION_CONTEXTS
    USER_EVALUATION_CONTEXT_TABLES
    USER_EVALUATION_CONTEXT_TABLES
    USER_EVALUATION_CONTEXT_VARS
    USER_EVALUATION_CONTEXT_VARS
    USER_EXTENTS
    USER_EXTENTS
    USER_EXTERNAL_LOCATIONS
    USER_EXTERNAL_LOCATIONS
    USER_EXTERNAL_TABLES
    USER_EXTERNAL_TABLES
    USER_FILE_GROUPS
    USER_FILE_GROUPS
    USER_FILE_GROUP_EXPORT_INFO
    USER_FILE_GROUP_EXPORT_INFO
    USER_FILE_GROUP_FILES
    USER_FILE_GROUP_FILES
    USER_FILE_GROUP_TABLES
    USER_FILE_GROUP_TABLES
    USER_FILE_GROUP_TABLESPACES
    USER_FILE_GROUP_TABLESPACES
    USER_FILE_GROUP_VERSIONS
    USER_FILE_GROUP_VERSIONS
    USER_FLASHBACK_ARCHIVE
    USER_FLASHBACK_ARCHIVE
    USER_FLASHBACK_ARCHIVE_TABLES
    USER_FLASHBACK_ARCHIVE_TABLES
    USER_FLASHBACK_TXN_REPORT
    USER_FLASHBACK_TXN_REPORT
    USER_FLASHBACK_TXN_STATE
    USER_FLASHBACK_TXN_STATE
    USER_FREE_SPACE
    USER_FREE_SPACE
    USER_GEOMETRY_COLUMNS
    USER_GEOMETRY_COLUMNS
    USER_GOLDENGATE_PRIVILEGES
    USER_GOLDENGATE_PRIVILEGES
    USER_HISTOGRAMS
    USER_HISTORY$
    USER_IDENTIFIERS
    USER_IDENTIFIERS
    USER_INDEXES
    USER_INDEXES
    USER_INDEXTYPES
    USER_INDEXTYPES
    USER_INDEXTYPE_ARRAYTYPES
    USER_INDEXTYPE_ARRAYTYPES
    USER_INDEXTYPE_COMMENTS
    USER_INDEXTYPE_COMMENTS
    USER_INDEXTYPE_OPERATORS
    USER_INDEXTYPE_OPERATORS
    USER_IND_COLUMNS
    USER_IND_COLUMNS
    USER_IND_EXPRESSIONS
    USER_IND_EXPRESSIONS
    USER_IND_PARTITIONS
    USER_IND_PARTITIONS
    USER_IND_PENDING_STATS
    USER_IND_PENDING_STATS
    USER_IND_STATISTICS
    USER_IND_STATISTICS
    USER_IND_SUBPARTITIONS
    USER_IND_SUBPARTITIONS
    USER_INTERNAL_TRIGGERS
    USER_INTERNAL_TRIGGERS
    USER_JOBS
    USER_JOBS
    USER_JOIN_IND_COLUMNS
    USER_JOIN_IND_COLUMNS
    USER_LIBRARIES
    USER_LIBRARIES
    USER_LOBS
    USER_LOBS
    USER_LOB_PARTITIONS
    USER_LOB_PARTITIONS
    USER_LOB_SUBPARTITIONS
    USER_LOB_SUBPARTITIONS
    USER_LOB_TEMPLATES
    USER_LOB_TEMPLATES
    USER_LOG_GROUPS
    USER_LOG_GROUPS
    USER_LOG_GROUP_COLUMNS
    USER_LOG_GROUP_COLUMNS
    USER_MEASURE_FOLDERS
    USER_MEASURE_FOLDERS
    USER_MEASURE_FOLDER_CONTENTS
    USER_MEASURE_FOLDER_CONTENTS
    USER_METHOD_PARAMS
    USER_METHOD_PARAMS
    USER_METHOD_RESULTS
    USER_METHOD_RESULTS
    USER_MINING_MODELS
    USER_MINING_MODELS
    USER_MINING_MODEL_ATTRIBUTES
    USER_MINING_MODEL_ATTRIBUTES
    USER_MINING_MODEL_SETTINGS
    USER_MINING_MODEL_SETTINGS
    USER_MVIEWS
    USER_MVIEWS
    USER_MVIEW_AGGREGATES
    USER_MVIEW_AGGREGATES
    USER_MVIEW_ANALYSIS
    USER_MVIEW_ANALYSIS
    USER_MVIEW_COMMENTS
    USER_MVIEW_COMMENTS
    USER_MVIEW_DETAIL_PARTITION
    USER_MVIEW_DETAIL_PARTITION
    USER_MVIEW_DETAIL_RELATIONS
    USER_MVIEW_DETAIL_RELATIONS
    USER_MVIEW_DETAIL_SUBPARTITION
    USER_MVIEW_DETAIL_SUBPARTITION
    USER_MVIEW_JOINS
    USER_MVIEW_JOINS
    USER_MVIEW_KEYS
    USER_MVIEW_KEYS
    USER_MVIEW_LOGS
    USER_MVIEW_LOGS
    USER_MVIEW_REFRESH_TIMES
    USER_MVIEW_REFRESH_TIMES
    USER_NESTED_TABLES
    USER_NESTED_TABLES
    USER_NESTED_TABLE_COLS
    USER_NESTED_TABLE_COLS
    USER_NETWORK_ACL_PRIVILEGES
    USER_NETWORK_ACL_PRIVILEGES
    USER_OBJECTS
    USER_OBJECTS
    USER_OBJECTS_AE
    USER_OBJECTS_AE
    USER_OBJECT_SIZE
    USER_OBJECT_SIZE
    USER_OBJECT_TABLES
    USER_OBJECT_TABLES
    USER_OBJ_AUDIT_OPTS
    USER_OBJ_AUDIT_OPTS
    USER_OBJ_COLATTRS
    USER_OBJ_COLATTRS
    USER_OLDIMAGE_COLUMNS
    USER_OLDIMAGE_COLUMNS
    USER_OPANCILLARY
    USER_OPANCILLARY
    USER_OPARGUMENTS
    USER_OPARGUMENTS
    USER_OPBINDINGS
    USER_OPBINDINGS
    USER_OPERATORS
    USER_OPERATORS
    USER_OPERATOR_COMMENTS
    USER_OPERATOR_COMMENTS
    USER_OUTLINES
    USER_OUTLINES
    USER_OUTLINE_HINTS
    USER_OUTLINE_HINTS
    USER_PARALLEL_EXECUTE_CHUNKS
    USER_PARALLEL_EXECUTE_CHUNKS
    USER_PARALLEL_EXECUTE_TASKS
    USER_PARALLEL_EXECUTE_TASKS
    USER_PARTIAL_DROP_TABS
    USER_PARTIAL_DROP_TABS
    USER_PART_COL_STATISTICS
    USER_PART_COL_STATISTICS
    USER_PART_HISTOGRAMS
    USER_PART_HISTOGRAMS
    USER_PART_INDEXES
    USER_PART_INDEXES
    USER_PART_KEY_COLUMNS
    USER_PART_KEY_COLUMNS
    USER_PART_LOBS
    USER_PART_LOBS
    USER_PART_TABLES
    USER_PART_TABLES
    USER_PASSWORD_LIMITS
    USER_PASSWORD_LIMITS
    USER_PENDING_CONV_TABLES
    USER_PENDING_CONV_TABLES
    USER_PLSQL_OBJECT_SETTINGS
    USER_PLSQL_OBJECT_SETTINGS
    USER_POLICIES
    USER_POLICIES
    USER_POLICY_CONTEXTS
    USER_POLICY_CONTEXTS
    USER_POLICY_GROUPS
    USER_POLICY_GROUPS
    USER_PROCEDURES
    USER_PROCEDURES
    USER_PROXIES
    USER_PROXIES
    USER_PUBLISHED_COLUMNS
    USER_PUBLISHED_COLUMNS
    USER_QUEUES
    USER_QUEUES
    USER_QUEUE_PUBLISHERS
    USER_QUEUE_PUBLISHERS
    USER_QUEUE_SCHEDULES
    USER_QUEUE_SCHEDULES
    USER_QUEUE_SUBSCRIBERS
    USER_QUEUE_SUBSCRIBERS
    USER_QUEUE_TABLES
    USER_QUEUE_TABLES
    USER_RECYCLEBIN
    USER_RECYCLEBIN
    USER_REFRESH
    USER_REFRESH
    USER_REFRESH_CHILDREN
    USER_REFRESH_CHILDREN
    USER_REFS
    USER_REFS
    USER_REGISTERED_MVIEWS
    USER_REGISTERED_MVIEWS
    USER_REGISTERED_SNAPSHOTS
    USER_REGISTERED_SNAPSHOTS
    USER_REGISTRY
    USER_REGISTRY
    USER_REPAUDIT_ATTRIBUTE
    USER_REPAUDIT_ATTRIBUTE
    USER_REPAUDIT_COLUMN
    USER_REPAUDIT_COLUMN
    USER_REPCAT
    USER_REPCAT
    USER_REPCATLOG
    USER_REPCATLOG
    USER_REPCAT_REFRESH_TEMPLATES
    USER_REPCAT_REFRESH_TEMPLATES
    USER_REPCAT_TEMPLATE_OBJECTS
    USER_REPCAT_TEMPLATE_OBJECTS
    USER_REPCAT_TEMPLATE_PARMS
    USER_REPCAT_TEMPLATE_PARMS
    USER_REPCAT_TEMPLATE_SITES
    USER_REPCAT_TEMPLATE_SITES
    USER_REPCAT_USER_AUTHORIZATION
    USER_REPCAT_USER_AUTHORIZATION
    USER_REPCAT_USER_PARM_VALUES
    USER_REPCAT_USER_PARM_VALUES
    USER_REPCOLUMN
    USER_REPCOLUMN
    USER_REPCOLUMN_GROUP
    USER_REPCOLUMN_GROUP
    USER_REPCONFLICT
    USER_REPCONFLICT
    USER_REPDDL
    USER_REPDDL
    USER_REPFLAVORS
    USER_REPFLAVORS
    USER_REPFLAVOR_COLUMNS
    USER_REPFLAVOR_COLUMNS
    USER_REPFLAVOR_OBJECTS
    USER_REPFLAVOR_OBJECTS
    USER_REPGENERATED
    USER_REPGENERATED
    USER_REPGENOBJECTS
    USER_REPGENOBJECTS
    USER_REPGROUP
    USER_REPGROUP
    USER_REPGROUPED_COLUMN
    USER_REPGROUPED_COLUMN
    USER_REPGROUP_PRIVILEGES
    USER_REPGROUP_PRIVILEGES
    USER_REPKEY_COLUMNS
    USER_REPKEY_COLUMNS
    USER_REPOBJECT
    USER_REPOBJECT
    USER_REPPARAMETER_COLUMN
    USER_REPPARAMETER_COLUMN
    USER_REPPRIORITY
    USER_REPPRIORITY
    USER_REPPRIORITY_GROUP
    USER_REPPRIORITY_GROUP
    USER_REPPROP
    USER_REPPROP
    USER_REPRESOLUTION
    USER_REPRESOLUTION
    USER_REPRESOLUTION_METHOD
    USER_REPRESOLUTION_METHOD
    USER_REPRESOLUTION_STATISTICS
    USER_REPRESOLUTION_STATISTICS
    USER_REPRESOL_STATS_CONTROL
    USER_REPRESOL_STATS_CONTROL
    USER_REPSCHEMA
    USER_REPSCHEMA
    USER_REPSITES
    USER_REPSITES
    USER_RESOURCE_LIMITS
    USER_RESOURCE_LIMITS
    USER_RESUMABLE
    USER_RESUMABLE
    USER_REWRITE_EQUIVALENCES
    USER_REWRITE_EQUIVALENCES
    USER_ROLE_PRIVS
    USER_ROLE_PRIVS
    USER_RSRC_CONSUMER_GROUP_PRIVS
    USER_RSRC_CONSUMER_GROUP_PRIVS
    USER_RSRC_MANAGER_SYSTEM_PRIVS
    USER_RSRC_MANAGER_SYSTEM_PRIVS
    USER_RULES
    USER_RULES
    USER_RULESETS
    USER_RULESETS
    USER_RULE_SETS
    USER_RULE_SETS
    USER_RULE_SET_RULES
    USER_RULE_SET_RULES
    USER_SCHEDULER_CHAINS
    USER_SCHEDULER_CHAINS
    USER_SCHEDULER_CHAIN_RULES
    USER_SCHEDULER_CHAIN_RULES
    USER_SCHEDULER_CHAIN_STEPS
    USER_SCHEDULER_CHAIN_STEPS
    USER_SCHEDULER_CREDENTIALS
    USER_SCHEDULER_CREDENTIALS
    USER_SCHEDULER_DB_DESTS
    USER_SCHEDULER_DB_DESTS
    USER_SCHEDULER_DESTS
    USER_SCHEDULER_DESTS
    USER_SCHEDULER_FILE_WATCHERS
    USER_SCHEDULER_FILE_WATCHERS
    USER_SCHEDULER_GROUPS
    USER_SCHEDULER_GROUPS
    USER_SCHEDULER_GROUP_MEMBERS
    USER_SCHEDULER_GROUP_MEMBERS
    USER_SCHEDULER_JOBS
    USER_SCHEDULER_JOBS
    USER_SCHEDULER_JOB_ARGS
    USER_SCHEDULER_JOB_ARGS
    USER_SCHEDULER_JOB_DESTS
    USER_SCHEDULER_JOB_DESTS
    USER_SCHEDULER_JOB_LOG
    USER_SCHEDULER_JOB_LOG
    USER_SCHEDULER_JOB_RUN_DETAILS
    USER_SCHEDULER_JOB_RUN_DETAILS
    USER_SCHEDULER_NOTIFICATIONS
    USER_SCHEDULER_NOTIFICATIONS
    USER_SCHEDULER_PROGRAMS
    USER_SCHEDULER_PROGRAMS
    USER_SCHEDULER_PROGRAM_ARGS
    USER_SCHEDULER_PROGRAM_ARGS
    USER_SCHEDULER_REMOTE_JOBSTATE
    USER_SCHEDULER_REMOTE_JOBSTATE
    USER_SCHEDULER_RUNNING_CHAINS
    USER_SCHEDULER_RUNNING_CHAINS
    USER_SCHEDULER_RUNNING_JOBS
    USER_SCHEDULER_RUNNING_JOBS
    USER_SCHEDULER_SCHEDULES
    USER_SCHEDULER_SCHEDULES
    USER_SDO_3DTHEMES
    USER_SDO_3DTHEMES
    USER_SDO_3DTXFMS
    USER_SDO_3DTXFMS
    USER_SDO_ANIMATIONS
    USER_SDO_ANIMATIONS
    USER_SDO_CACHED_MAPS
    USER_SDO_CACHED_MAPS
    USER_SDO_GEOM_METADATA
    USER_SDO_GEOM_METADATA
    USER_SDO_INDEX_INFO
    USER_SDO_INDEX_INFO
    USER_SDO_INDEX_METADATA
    USER_SDO_INDEX_METADATA
    USER_SDO_LIGHTSOURCES
    USER_SDO_LIGHTSOURCES
    USER_SDO_LRS_METADATA
    USER_SDO_LRS_METADATA
    USER_SDO_MAPS
    USER_SDO_MAPS
    USER_SDO_SCENES
    USER_SDO_SCENES
    USER_SDO_STYLES
    USER_SDO_STYLES
    USER_SDO_THEMES
    USER_SDO_THEMES
    USER_SDO_TOPO_INFO
    USER_SDO_TOPO_INFO
    USER_SDO_TOPO_METADATA
    USER_SDO_TOPO_METADATA
    USER_SDO_VIEWFRAMES
    USER_SDO_VIEWFRAMES
    USER_SECONDARY_OBJECTS
    USER_SECONDARY_OBJECTS
    USER_SEC_RELEVANT_COLS
    USER_SEC_RELEVANT_COLS
    USER_SEGMENTS
    USER_SEGMENTS
    USER_SEQUENCES
    USER_SEQUENCES
    USER_SNAPSHOTS
    USER_SNAPSHOTS
    USER_SNAPSHOT_LOGS
    USER_SNAPSHOT_LOGS
    USER_SNAPSHOT_REFRESH_TIMES
    USER_SOURCE
    USER_SOURCE
    USER_SOURCE_AE
    USER_SOURCE_AE
    USER_SOURCE_TABLES
    USER_SOURCE_TABLES
    USER_SQLJ_TYPES
    USER_SQLJ_TYPES
    USER_SQLJ_TYPE_ATTRS
    USER_SQLJ_TYPE_ATTRS
    USER_SQLJ_TYPE_METHODS
    USER_SQLJ_TYPE_METHODS
    USER_SQLSET
    USER_SQLSET
    USER_SQLSET_BINDS
    USER_SQLSET_BINDS
    USER_SQLSET_DEFINITIONS
    USER_SQLSET_PLANS
    USER_SQLSET_PLANS
    USER_SQLSET_REFERENCES
    USER_SQLSET_REFERENCES
    USER_SQLSET_STATEMENTS
    USER_SQLSET_STATEMENTS
    USER_SQLTUNE_BINDS
    USER_SQLTUNE_BINDS
    USER_SQLTUNE_PLANS
    USER_SQLTUNE_PLANS
    USER_SQLTUNE_RATIONALE_PLAN
    USER_SQLTUNE_RATIONALE_PLAN
    USER_SQLTUNE_STATISTICS
    USER_SQLTUNE_STATISTICS
    USER_STAT_EXTENSIONS
    USER_STAT_EXTENSIONS
    USER_STORED_SETTINGS
    USER_STORED_SETTINGS
    USER_SUBPARTITION_TEMPLATES
    USER_SUBPARTITION_TEMPLATES
    USER_SUBPART_COL_STATISTICS
    USER_SUBPART_COL_STATISTICS
    USER_SUBPART_HISTOGRAMS
    USER_SUBPART_HISTOGRAMS
    USER_SUBPART_KEY_COLUMNS
    USER_SUBPART_KEY_COLUMNS
    USER_SUBSCRIBED_COLUMNS
    USER_SUBSCRIBED_COLUMNS
    USER_SUBSCRIBED_TABLES
    USER_SUBSCRIBED_TABLES
    USER_SUBSCRIPTIONS
    USER_SUBSCRIPTIONS
    USER_SUBSCR_REGISTRATIONS
    USER_SUBSCR_REGISTRATIONS
    USER_SUMMARIES
    USER_SUMMARIES
    USER_SUMMARY_AGGREGATES
    USER_SUMMARY_AGGREGATES
    USER_SUMMARY_DETAIL_TABLES
    USER_SUMMARY_DETAIL_TABLES
    USER_SUMMARY_JOINS
    USER_SUMMARY_JOINS
    USER_SUMMARY_KEYS
    USER_SUMMARY_KEYS
    USER_SYNONYMS
    USER_SYNONYMS
    USER_SYS_PRIVS
    USER_SYS_PRIVS
    USER_TABLES
    USER_TABLES
    USER_TABLESPACES
    USER_TABLESPACES
    USER_TAB_COLS
    USER_TAB_COLS
    USER_TAB_COLUMNS
    USER_TAB_COLUMNS
    USER_TAB_COL_STATISTICS
    USER_TAB_COL_STATISTICS
    USER_TAB_COMMENTS
    USER_TAB_COMMENTS
    USER_TAB_HISTGRM_PENDING_STATS
    USER_TAB_HISTGRM_PENDING_STATS
    USER_TAB_HISTOGRAMS
    USER_TAB_HISTOGRAMS
    USER_TAB_MODIFICATIONS
    USER_TAB_MODIFICATIONS
    USER_TAB_PARTITIONS
    USER_TAB_PARTITIONS
    USER_TAB_PENDING_STATS
    USER_TAB_PENDING_STATS
    USER_TAB_PRIVS
    USER_TAB_PRIVS
    USER_TAB_PRIVS_MADE
    USER_TAB_PRIVS_MADE
    USER_TAB_PRIVS_RECD
    USER_TAB_PRIVS_RECD
    USER_TAB_STATISTICS
    USER_TAB_STATISTICS
    USER_TAB_STATS_HISTORY
    USER_TAB_STATS_HISTORY
    USER_TAB_STAT_PREFS
    USER_TAB_STAT_PREFS
    USER_TAB_SUBPARTITIONS
    USER_TAB_SUBPARTITIONS
    USER_TRANSFORMATIONS
    USER_TRANSFORMATIONS
    USER_TRIGGERS
    USER_TRIGGERS
    USER_TRIGGER_COLS
    USER_TRIGGER_COLS
    USER_TRIGGER_ORDERING
    USER_TRIGGER_ORDERING
    USER_TS
    USER_TSTZ_TABLES
    USER_TSTZ_TABLES
    USER_TSTZ_TAB_COLS
    USER_TSTZ_TAB_COLS
    USER_TS_QUOTAS
    USER_TS_QUOTAS
    USER_TUNE_MVIEW
    USER_TUNE_MVIEW
    USER_TYPES
    USER_TYPES
    USER_TYPE_ATTRS
    USER_TYPE_ATTRS
    USER_TYPE_METHODS
    USER_TYPE_METHODS
    USER_TYPE_VERSIONS
    USER_TYPE_VERSIONS
    USER_UNUSED_COL_TABS
    USER_UNUSED_COL_TABS
    USER_UPDATABLE_COLUMNS
    USER_UPDATABLE_COLUMNS
    USER_USERS
    USER_USERS
    USER_USTATS
    USER_USTATS
    USER_VARRAYS
    USER_VARRAYS
    USER_VIEWS
    USER_VIEWS
    USER_VIEWS_AE
    USER_VIEWS_AE
    USER_WARNING_SETTINGS
    USER_WARNING_SETTINGS
    USER_XDS_ATTRIBUTE_SECS
    USER_XDS_ATTRIBUTE_SECS
    USER_XDS_INSTANCE_SETS
    USER_XDS_INSTANCE_SETS
    USER_XDS_OBJECTS
    USER_XDS_OBJECTS
    USER_XML_COLUMN_NAMES
    USER_XML_COLUMN_NAMES
    USER_XML_INDEXES
    USER_XML_INDEXES
    USER_XML_PARTITIONED_TABLE_OK
    USER_XML_SCHEMAS
    USER_XML_SCHEMAS
    USER_XML_TABLES
    USER_XML_TABLES
    USER_XML_TAB_COLS
    USER_XML_TAB_COLS
    USER_XML_VIEWS
    USER_XML_VIEWS
    USER_XML_VIEW_COLS
    USER_XML_VIEW_COLS
    UTL_ALL_IND_COMPS
    UTL_ALL_IND_COMPS
    UTL_BINARYINPUTSTREAM
    UTL_BINARYOUTPUTSTREAM
    UTL_CHARACTERINPUTSTREAM
    UTL_CHARACTEROUTPUTSTREAM
    UTL_COLL
    UTL_COMPRESS
    UTL_ENCODE
    UTL_ENCODE
    UTL_FILE
    UTL_FILE
    UTL_GDK
    UTL_HTTP
    UTL_HTTP
    UTL_I18N
    UTL_IDENT
    UTL_INADDR
    UTL_LMS
    UTL_MATCH
    UTL_NLA
    UTL_NLA_ARRAY_DBL
    UTL_NLA_ARRAY_FLT
    UTL_NLA_ARRAY_INT
    UTL_RAW
    UTL_RAW
    UTL_RECOMP_ALL_OBJECTS
    UTL_RECOMP_COMPILED
    UTL_RECOMP_ERRORS
    UTL_RECOMP_INVALID_ALL
    UTL_RECOMP_INVALID_JAVA_SYN
    UTL_RECOMP_INVALID_PARALLEL
    UTL_RECOMP_INVALID_SEQ
    UTL_RECOMP_SEQ
    UTL_RECOMP_SORTED
    UTL_REF
    UTL_SMTP
    UTL_SMTP
    UTL_TCP
    UTL_URL
    UTL_URL
    V
    V$ACCESS
    V$ACTIVE_INSTANCES
    V$ACTIVE_SERVICES
    V$ACTIVE_SESSION_HISTORY
    V$ACTIVE_SESS_POOL_MTH
    V$ADVISOR_CURRENT_SQLPLAN
    V$ADVISOR_PROGRESS
    V$ALERT_TYPES
    V$AQ
    V$AQ1
    V$ARCHIVE
    V$ARCHIVED_LOG
    V$ARCHIVE_DEST
    V$ARCHIVE_DEST_STATUS
    V$ARCHIVE_GAP
    V$ARCHIVE_PROCESSES
    V$ASH_INFO
    V$ASM_ACFSSNAPSHOTS
    V$ASM_ACFSVOLUMES
    V$ASM_ACFS_ENCRYPTION_INFO
    V$ASM_ACFS_SECURITY_INFO
    V$ASM_ALIAS
    V$ASM_ATTRIBUTE
    V$ASM_CLIENT
    V$ASM_DISK
    V$ASM_DISKGROUP
    V$ASM_DISKGROUP_STAT
    V$ASM_DISK_IOSTAT
    V$ASM_DISK_STAT
    V$ASM_FILE
    V$ASM_FILESYSTEM
    V$ASM_OPERATION
    V$ASM_TEMPLATE
    V$ASM_USER
    V$ASM_USERGROUP
    V$ASM_USERGROUP_MEMBER
    V$ASM_VOLUME
    V$ASM_VOLUME_STAT
    V$AW_AGGREGATE_OP
    V$AW_ALLOCATE_OP
    V$AW_CALC
    V$AW_LONGOPS
    V$AW_OLAP
    V$AW_SESSION_INFO
    V$BACKUP
    V$BACKUP_ARCHIVELOG_DETAILS
    V$BACKUP_ARCHIVELOG_SUMMARY
    V$BACKUP_ASYNC_IO
    V$BACKUP_CONTROLFILE_DETAILS
    V$BACKUP_CONTROLFILE_SUMMARY
    V$BACKUP_COPY_DETAILS
    V$BACKUP_COPY_SUMMARY
    V$BACKUP_CORRUPTION
    V$BACKUP_DATAFILE
    V$BACKUP_DATAFILE_DETAILS
    V$BACKUP_DATAFILE_SUMMARY
    V$BACKUP_DEVICE
    V$BACKUP_FILES
    V$BACKUP_PIECE
    V$BACKUP_PIECE_DETAILS
    V$BACKUP_REDOLOG
    V$BACKUP_SET
    V$BACKUP_SET_DETAILS
    V$BACKUP_SET_SUMMARY
    V$BACKUP_SPFILE
    V$BACKUP_SPFILE_DETAILS
    V$BACKUP_SPFILE_SUMMARY
    V$BACKUP_SYNC_IO
    V$BGPROCESS
    V$BH
    V$BLOCKING_QUIESCE
    V$BLOCK_CHANGE_TRACKING
    V$BSP
    V$BUFFERED_PUBLISHERS
    V$BUFFERED_QUEUES
    V$BUFFERED_SUBSCRIBERS
    V$BUFFER_POOL
    V$BUFFER_POOL_STATISTICS
    V$CALLTAG
    V$CELL
    V$CELL_CONFIG
    V$CELL_REQUEST_TOTALS
    V$CELL_STATE
    V$CELL_THREAD_HISTORY
    V$CIRCUIT
    V$CLASS_CACHE_TRANSFER
    V$CLASS_PING
    V$CLIENT_STATS
    V$CLUSTER_INTERCONNECTS
    V$CONFIGURED_INTERCONNECTS
    V$CONTEXT
    V$CONTROLFILE
    V$CONTROLFILE_RECORD_SECTION
    V$COPY_CORRUPTION
    V$CORRUPT_XID_LIST
    V$CPOOL_CC_INFO
    V$CPOOL_CC_STATS
    V$CPOOL_CONN_INFO
    V$CPOOL_STATS
    V$CR_BLOCK_SERVER
    V$CURRENT_BLOCK_SERVER
    V$DATABASE
    V$DATABASE_BLOCK_CORRUPTION
    V$DATABASE_INCARNATION
    V$DATABASE_KEY_INFO
    V$DATAFILE
    V$DATAFILE_COPY
    V$DATAFILE_HEADER
    V$DATAGUARD_CONFIG
    V$DATAGUARD_STATS
    V$DATAGUARD_STATUS
    V$DATAPUMP_JOB
    V$DATAPUMP_SESSION
    V$DBFILE
    V$DBLINK
    V$DB_CACHE_ADVICE
    V$DB_OBJECT_CACHE
    V$DB_PIPES
    V$DB_TRANSPORTABLE_PLATFORM
    V$DELETED_OBJECT
    V$DETACHED_SESSION
    V$DIAG_ADR_CONTROL
    V$DIAG_ADR_INVALIDATION
    V$DIAG_ALERT_EXT
    V$DIAG_AMS_XACTION
    V$DIAG_CRITICAL_ERROR
    V$DIAG_DDE_USER_ACTION
    V$DIAG_DDE_USER_ACTION_DEF
    V$DIAG_DDE_USR_ACT_PARAM
    V$DIAG_DDE_USR_ACT_PARAM_DEF
    V$DIAG_DDE_USR_INC_ACT_MAP
    V$DIAG_DDE_USR_INC_TYPE
    V$DIAG_DFW_CONFIG_CAPTURE
    V$DIAG_DFW_CONFIG_ITEM
    V$DIAG_DIAGV_INCIDENT
    V$DIAG_DIR_EXT
    V$DIAG_EM_DIAG_JOB
    V$DIAG_EM_TARGET_INFO
    V$DIAG_EM_USER_ACTIVITY
    V$DIAG_HM_FDG_SET
    V$DIAG_HM_FINDING
    V$DIAG_HM_INFO
    V$DIAG_HM_MESSAGE
    V$DIAG_HM_RECOMMENDATION
    V$DIAG_HM_RUN
    V$DIAG_INCCKEY
    V$DIAG_INCIDENT
    V$DIAG_INCIDENT_FILE
    V$DIAG_INC_METER_CONFIG
    V$DIAG_INC_METER_IMPT_DEF
    V$DIAG_INC_METER_INFO
    V$DIAG_INC_METER_PK_IMPTS
    V$DIAG_INC_METER_SUMMARY
    V$DIAG_INFO
    V$DIAG_IPS_CONFIGURATION
    V$DIAG_IPS_FILE_COPY_LOG
    V$DIAG_IPS_FILE_METADATA
    V$DIAG_IPS_PACKAGE
    V$DIAG_IPS_PACKAGE_FILE
    V$DIAG_IPS_PACKAGE_HISTORY
    V$DIAG_IPS_PACKAGE_INCIDENT
    V$DIAG_IPS_PKG_UNPACK_HIST
    V$DIAG_IPS_PROGRESS_LOG
    V$DIAG_IPS_REMOTE_PACKAGE
    V$DIAG_PICKLEERR
    V$DIAG_PROBLEM
    V$DIAG_RELMD_EXT
    V$DIAG_SWEEPERR
    V$DIAG_VEM_USER_ACTLOG
    V$DIAG_VEM_USER_ACTLOG1
    V$DIAG_VHM_RUN
    V$DIAG_VIEW
    V$DIAG_VIEWCOL
    V$DIAG_VINCIDENT
    V$DIAG_VINCIDENT_FILE
    V$DIAG_VINC_METER_INFO
    V$DIAG_VIPS_FILE_COPY_LOG
    V$DIAG_VIPS_FILE_METADATA
    V$DIAG_VIPS_PACKAGE_FILE
    V$DIAG_VIPS_PACKAGE_HISTORY
    V$DIAG_VIPS_PACKAGE_MAIN_INT
    V$DIAG_VIPS_PACKAGE_SIZE
    V$DIAG_VIPS_PKG_FILE
    V$DIAG_VIPS_PKG_INC_CAND
    V$DIAG_VIPS_PKG_INC_DTL
    V$DIAG_VIPS_PKG_INC_DTL1
    V$DIAG_VIPS_PKG_MAIN_PROBLEM
    V$DIAG_VNOT_EXIST_INCIDENT
    V$DIAG_VPROBLEM
    V$DIAG_VPROBLEM1
    V$DIAG_VPROBLEM2
    V$DIAG_VPROBLEM_BUCKET
    V$DIAG_VPROBLEM_BUCKET1
    V$DIAG_VPROBLEM_BUCKET_COUNT
    V$DIAG_VPROBLEM_INT
    V$DIAG_VPROBLEM_LASTINC
    V$DIAG_VSHOWCATVIEW
    V$DIAG_VSHOWINCB
    V$DIAG_VSHOWINCB_I
    V$DIAG_VTEST_EXISTS
    V$DIAG_V_ACTINC
    V$DIAG_V_ACTPROB
    V$DIAG_V_INCCOUNT
    V$DIAG_V_INCFCOUNT
    V$DIAG_V_INC_METER_INFO_PROB
    V$DIAG_V_IPSPRBCNT
    V$DIAG_V_IPSPRBCNT1
    V$DIAG_V_NFCINC
    V$DIAG_V_SWPERRCOUNT
    V$DISPATCHER
    V$DISPATCHER_CONFIG
    V$DISPATCHER_RATE
    V$DLM_ALL_LOCKS
    V$DLM_CONVERT_LOCAL
    V$DLM_CONVERT_REMOTE
    V$DLM_LATCH
    V$DLM_LOCKS
    V$DLM_MISC
    V$DLM_RESS
    V$DLM_TRAFFIC_CONTROLLER
    V$DNFS_CHANNELS
    V$DNFS_FILES
    V$DNFS_SERVERS
    V$DNFS_STATS
    V$DYNAMIC_REMASTER_STATS
    V$EMON
    V$ENABLEDPRIVS
    V$ENCRYPTED_TABLESPACES
    V$ENCRYPTION_WALLET
    V$ENQUEUE_LOCK
    V$ENQUEUE_STAT
    V$ENQUEUE_STATISTICS
    V$EVENTMETRIC
    V$EVENT_HISTOGRAM
    V$EVENT_NAME
    V$EXECUTION
    V$FAST_START_SERVERS
    V$FAST_START_TRANSACTIONS
    V$FILEMETRIC
    V$FILEMETRIC_HISTORY
    V$FILESPACE_USAGE
    V$FILESTAT
    V$FILE_CACHE_TRANSFER
    V$FILE_HISTOGRAM
    V$FILE_OPTIMIZED_HISTOGRAM
    V$FILE_PING
    V$FIXED_TABLE
    V$FIXED_VIEW_DEFINITION
    V$FLASHBACK_DATABASE_LOG
    V$FLASHBACK_DATABASE_LOGFILE
    V$FLASHBACK_DATABASE_STAT
    V$FLASHBACK_TXN_GRAPH
    V$FLASHBACK_TXN_MODS
    V$FLASH_RECOVERY_AREA_USAGE
    V$FOREIGN_ARCHIVED_LOG
    V$FS_FAILOVER_HISTOGRAM
    V$FS_FAILOVER_STATS
    V$GCSHVMASTER_INFO
    V$GCSPFMASTER_INFO
    V$GC_ELEMENT
    V$GC_ELEMENTS_WITH_COLLISIONS
    V$GES_BLOCKING_ENQUEUE
    V$GES_ENQUEUE
    V$GLOBALCONTEXT
    V$GLOBAL_BLOCKED_LOCKS
    V$GLOBAL_TRANSACTION
    V$GOLDENGATE_CAPTURE
    V$GOLDENGATE_MESSAGE_TRACKING
    V$GOLDENGATE_TRANSACTION
    V$HANG_INFO
    V$HANG_SESSION_INFO
    V$HM_CHECK
    V$HM_CHECK_PARAM
    V$HM_FINDING
    V$HM_INFO
    V$HM_RECOMMENDATION
    V$HM_RUN
    V$HS_AGENT
    V$HS_PARAMETER
    V$HS_SESSION
    V$HVMASTER_INFO
    V$INCMETER_CONFIG
    V$INCMETER_INFO
    V$INCMETER_SUMMARY
    V$INDEXED_FIXED_COLUMN
    V$INSTANCE
    V$INSTANCE_CACHE_TRANSFER
    V$INSTANCE_LOG_GROUP
    V$INSTANCE_RECOVERY
    V$IOFUNCMETRIC
    V$IOFUNCMETRIC_HISTORY
    V$IOSTAT_CONSUMER_GROUP
    V$IOSTAT_FILE
    V$IOSTAT_FUNCTION
    V$IOSTAT_FUNCTION_DETAIL
    V$IOSTAT_NETWORK
    V$IO_CALIBRATION_STATUS
    V$IR_FAILURE
    V$IR_FAILURE_SET
    V$IR_MANUAL_CHECKLIST
    V$IR_REPAIR
    V$JAVAPOOL
    V$JAVA_LIBRARY_CACHE_MEMORY
    V$JAVA_POOL_ADVICE
    V$LATCH
    V$LATCHHOLDER
    V$LATCHNAME
    V$LATCH_CHILDREN
    V$LATCH_MISSES
    V$LATCH_PARENT
    V$LIBCACHE_LOCKS
    V$LIBRARYCACHE
    V$LIBRARY_CACHE_MEMORY
    V$LICENSE
    V$LISTENER_NETWORK
    V$LOADISTAT
    V$LOADPSTAT
    V$LOBSTAT
    V$LOCK
    V$LOCKED_OBJECT
    V$LOCKS_WITH_COLLISIONS
    V$LOCK_ACTIVITY
    V$LOCK_ELEMENT
    V$LOCK_TYPE
    V$LOG
    V$LOGFILE
    V$LOGHIST
    V$LOGMNR_CALLBACK
    V$LOGMNR_CONTENTS
    V$LOGMNR_DICTIONARY
    V$LOGMNR_DICTIONARY_LOAD
    V$LOGMNR_LATCH
    V$LOGMNR_LOGFILE
    V$LOGMNR_LOGS
    V$LOGMNR_PARAMETERS
    V$LOGMNR_PROCESS
    V$LOGMNR_REGION
    V$LOGMNR_SESSION
    V$LOGMNR_STATS
    V$LOGMNR_TRANSACTION
    V$LOGSTDBY
    V$LOGSTDBY_PROCESS
    V$LOGSTDBY_PROGRESS
    V$LOGSTDBY_STATE
    V$LOGSTDBY_STATS
    V$LOGSTDBY_TRANSACTION
    V$LOG_HISTORY
    V$MANAGED_STANDBY
    V$MAP_COMP_LIST
    V$MAP_ELEMENT
    V$MAP_EXT_ELEMENT
    V$MAP_FILE
    V$MAP_FILE_EXTENT
    V$MAP_FILE_IO_STACK
    V$MAP_LIBRARY
    V$MAP_SUBELEMENT
    V$MAX_ACTIVE_SESS_TARGET_MTH
    V$MEMORY_CURRENT_RESIZE_OPS
    V$MEMORY_DYNAMIC_COMPONENTS
    V$MEMORY_RESIZE_OPS
    V$MEMORY_TARGET_ADVICE
    V$METRIC
    V$METRICGROUP
    V$METRICNAME
    V$METRIC_HISTORY
    V$MTTR_TARGET_ADVICE
    V$MUTEX_SLEEP
    V$MUTEX_SLEEP_HISTORY
    V$MVREFRESH
    V$MYSTAT
    V$NFS_CLIENTS
    V$NFS_LOCKS
    V$NFS_OPEN_FILES
    V$NLS_PARAMETERS
    V$NLS_VALID_VALUES
    V$OBJECT_DEPENDENCY
    V$OBJECT_DML_FREQUENCIES
    V$OBJECT_PRIVILEGE
    V$OBJECT_USAGE
    V$OBJECT_USAGE
    V$OBSOLETE_PARAMETER
    V$OFFLINE_RANGE
    V$OPEN_CURSOR
    V$OPTION
    V$OSSTAT
    V$PARALLEL_DEGREE_LIMIT_MTH
    V$PARAMETER
    V$PARAMETER2
    V$PARAMETER_VALID_VALUES
    V$PERSISTENT_PUBLISHERS
    V$PERSISTENT_QMN_CACHE
    V$PERSISTENT_QUEUES
    V$PERSISTENT_SUBSCRIBERS
    V$PGASTAT
    V$PGA_TARGET_ADVICE
    V$PGA_TARGET_ADVICE_HISTOGRAM
    V$POLICY_HISTORY
    V$PQ_SESSTAT
    V$PQ_SLAVE
    V$PQ_SYSSTAT
    V$PQ_TQSTAT
    V$PROCESS
    V$PROCESS_GROUP
    V$PROCESS_MEMORY
    V$PROCESS_MEMORY_DETAIL
    V$PROCESS_MEMORY_DETAIL_PROG
    V$PROPAGATION_RECEIVER
    V$PROPAGATION_SENDER
    V$PROXY_ARCHIVEDLOG
    V$PROXY_ARCHIVELOG_DETAILS
    V$PROXY_ARCHIVELOG_SUMMARY
    V$PROXY_COPY_DETAILS
    V$PROXY_COPY_SUMMARY
    V$PROXY_DATAFILE
    V$PWFILE_USERS
    V$PX_BUFFER_ADVICE
    V$PX_INSTANCE_GROUP
    V$PX_PROCESS
    V$PX_PROCESS_SYSSTAT
    V$PX_SESSION
    V$PX_SESSTAT
    V$QMON_COORDINATOR_STATS
    V$QMON_SERVER_STATS
    V$QMON_TASKS
    V$QMON_TASK_STATS
    V$QUEUE
    V$QUEUEING_MTH
    V$RECOVERY_AREA_USAGE
    V$RECOVERY_FILE_DEST
    V$RECOVERY_FILE_STATUS
    V$RECOVERY_LOG
    V$RECOVERY_PROGRESS
    V$RECOVERY_STATUS
    V$RECOVER_FILE
    V$REDO_DEST_RESP_HISTOGRAM
    V$REPLPROP
    V$REPLQUEUE
    V$REQDIST
    V$RESERVED_WORDS
    V$RESOURCE
    V$RESOURCE_LIMIT
    V$RESTORE_POINT
    V$RESULT_CACHE_DEPENDENCY
    V$RESULT_CACHE_MEMORY
    V$RESULT_CACHE_OBJECTS
    V$RESULT_CACHE_STATISTICS
    V$RESUMABLE
    V$RFS_THREAD
    V$RMAN_BACKUP_JOB_DETAILS
    V$RMAN_BACKUP_SUBJOB_DETAILS
    V$RMAN_BACKUP_TYPE
    V$RMAN_COMPRESSION_ALGORITHM
    V$RMAN_CONFIGURATION
    V$RMAN_ENCRYPTION_ALGORITHMS
    V$RMAN_OUTPUT
    V$RMAN_STATUS
    V$ROLLNAME
    V$ROLLSTAT
    V$ROWCACHE
    V$ROWCACHE_PARENT
    V$ROWCACHE_SUBORDINATE
    V$RSRCMGRMETRIC
    V$RSRCMGRMETRIC_HISTORY
    V$RSRC_CONSUMER_GROUP
    V$RSRC_CONSUMER_GROUP_CPU_MTH
    V$RSRC_CONS_GROUP_HISTORY
    V$RSRC_PLAN
    V$RSRC_PLAN_CPU_MTH
    V$RSRC_PLAN_HISTORY
    V$RSRC_SESSION_INFO
    V$RULE
    V$RULE_SET
    V$RULE_SET_AGGREGATE_STATS
    V$SCHEDULER_RUNNING_JOBS
    V$SECUREFILE_TIMER
    V$SEGMENT_STATISTICS
    V$SEGSPACE_USAGE
    V$SEGSTAT
    V$SEGSTAT_NAME
    V$SERVICEMETRIC
    V$SERVICEMETRIC_HISTORY
    V$SERVICES
    V$SERVICE_EVENT
    V$SERVICE_STATS
    V$SERVICE_WAIT_CLASS
    V$SERV_MOD_ACT_STATS
    V$SESSION
    V$SESSION_BLOCKERS
    V$SESSION_CONNECT_INFO
    V$SESSION_CURSOR_CACHE
    V$SESSION_EVENT
    V$SESSION_FIX_CONTROL
    V$SESSION_LONGOPS
    V$SESSION_OBJECT_CACHE
    V$SESSION_WAIT
    V$SESSION_WAIT_CLASS
    V$SESSION_WAIT_HISTORY
    V$SESSMETRIC
    V$SESSTAT
    V$SESS_IO
    V$SESS_TIME_MODEL
    V$SES_OPTIMIZER_ENV
    V$SGA
    V$SGAINFO
    V$SGASTAT
    V$SGA_CURRENT_RESIZE_OPS
    V$SGA_DYNAMIC_COMPONENTS
    V$SGA_DYNAMIC_FREE_MEMORY
    V$SGA_RESIZE_OPS
    V$SGA_TARGET_ADVICE
    V$SHARED_POOL_ADVICE
    V$SHARED_POOL_RESERVED
    V$SHARED_SERVER
    V$SHARED_SERVER_MONITOR
    V$SORT_SEGMENT
    V$SORT_USAGE
    V$SPPARAMETER
    V$SQL
    V$SQLAREA
    V$SQLAREA_PLAN_HASH
    V$SQLCOMMAND
    V$SQLFN_ARG_METADATA
    V$SQLFN_METADATA
    V$SQLPA_METRIC
    V$SQLSTATS
    V$SQLSTATS_PLAN_HASH
    V$SQLTEXT
    V$SQLTEXT_WITH_NEWLINES
    V$SQL_BIND_CAPTURE
    V$SQL_BIND_DATA
    V$SQL_BIND_METADATA
    V$SQL_CS_HISTOGRAM
    V$SQL_CS_SELECTIVITY
    V$SQL_CS_STATISTICS
    V$SQL_CURSOR
    V$SQL_FEATURE
    V$SQL_FEATURE_DEPENDENCY
    V$SQL_FEATURE_HIERARCHY
    V$SQL_HINT
    V$SQL_JOIN_FILTER
    V$SQL_MONITOR
    V$SQL_OPTIMIZER_ENV
    V$SQL_PLAN
    V$SQL_PLAN_MONITOR
    V$SQL_PLAN_STATISTICS
    V$SQL_PLAN_STATISTICS_ALL
    V$SQL_REDIRECTION
    V$SQL_SHARED_CURSOR
    V$SQL_SHARED_MEMORY
    V$SQL_WORKAREA
    V$SQL_WORKAREA_ACTIVE
    V$SQL_WORKAREA_HISTOGRAM
    V$SSCR_SESSIONS
    V$STANDBY_EVENT_HISTOGRAM
    V$STANDBY_LOG
    V$STATISTICS_LEVEL
    V$STATNAME
    V$STREAMS_APPLY_COORDINATOR
    V$STREAMS_APPLY_READER
    V$STREAMS_APPLY_SERVER
    V$STREAMS_CAPTURE
    V$STREAMS_MESSAGE_TRACKING
    V$STREAMS_POOL_ADVICE
    V$STREAMS_POOL_STATISTICS
    V$STREAMS_TRANSACTION
    V$SUBCACHE
    V$SUBSCR_REGISTRATION_STATS
    V$SYSAUX_OCCUPANTS
    V$SYSMETRIC
    V$SYSMETRIC_HISTORY
    V$SYSMETRIC_SUMMARY
    V$SYSSTAT
    V$SYSTEM_CURSOR_CACHE
    V$SYSTEM_EVENT
    V$SYSTEM_FIX_CONTROL
    V$SYSTEM_PARAMETER
    V$SYSTEM_PARAMETER2
    V$SYSTEM_WAIT_CLASS
    V$SYS_OPTIMIZER_ENV
    V$SYS_TIME_MODEL
    V$TABLESPACE
    V$TEMPFILE
    V$TEMPORARY_LOBS
    V$TEMPSEG_USAGE
    V$TEMPSTAT
    V$TEMP_CACHE_TRANSFER
    V$TEMP_EXTENT_MAP
    V$TEMP_EXTENT_POOL
    V$TEMP_PING
    V$TEMP_SPACE_HEADER
    V$THREAD
    V$THRESHOLD_TYPES
    V$TIMER
    V$TIMEZONE_FILE
    V$TIMEZONE_NAMES
    V$TOPLEVELCALL
    V$TRANSACTION
    V$TRANSACTION_ENQUEUE
    V$TRANSPORTABLE_PLATFORM
    V$TSM_SESSIONS
    V$TYPE_SIZE
    V$UNDOSTAT
    V$UNUSABLE_BACKUPFILE_DETAILS
    V$VERSION
    V$VPD_POLICY
    V$WAITCLASSMETRIC
    V$WAITCLASSMETRIC_HISTORY
    V$WAITSTAT
    V$WAIT_CHAINS
    V$WALLET
    V$WLM_PCMETRIC
    V$WLM_PCMETRIC_HISTORY
    V$WLM_PC_STATS
    V$WORKLOAD_REPLAY_THREAD
    V$XML_AUDIT_TRAIL
    V$XSTREAM_CAPTURE
    V$XSTREAM_MESSAGE_TRACKING
    V$XSTREAM_OUTBOUND_SERVER
    V$XSTREAM_TRANSACTION
    V$XS_SESSION
    V$XS_SESSION
    V$XS_SESSION_ATTRIBUTE
    V$XS_SESSION_ATTRIBUTE
    V$XS_SESSION_ROLE
    V$XS_SESSION_ROLE
    V$_LOCK
    VIEW$
    VIEWCON$
    VIEWTRCOL$
    VTABLE$
    V_$ACCESS
    V_$ACTIVE_INSTANCES
    V_$ACTIVE_SERVICES
    V_$ACTIVE_SESSION_HISTORY
    V_$ACTIVE_SESS_POOL_MTH
    V_$ADVISOR_CURRENT_SQLPLAN
    V_$ADVISOR_PROGRESS
    V_$ALERT_TYPES
    V_$AQ
    V_$AQ1
    V_$ARCHIVE
    V_$ARCHIVED_LOG
    V_$ARCHIVE_DEST
    V_$ARCHIVE_DEST_STATUS
    V_$ARCHIVE_GAP
    V_$ARCHIVE_PROCESSES
    V_$ASH_INFO
    V_$ASM_ACFSSNAPSHOTS
    V_$ASM_ACFSVOLUMES
    V_$ASM_ACFS_ENCRYPTION_INFO
    V_$ASM_ACFS_SECURITY_INFO
    V_$ASM_ALIAS
    V_$ASM_ATTRIBUTE
    V_$ASM_CLIENT
    V_$ASM_DISK
    V_$ASM_DISKGROUP
    V_$ASM_DISKGROUP_STAT
    V_$ASM_DISK_IOSTAT
    V_$ASM_DISK_STAT
    V_$ASM_FILE
    V_$ASM_FILESYSTEM
    V_$ASM_OPERATION
    V_$ASM_TEMPLATE
    V_$ASM_USER
    V_$ASM_USERGROUP
    V_$ASM_USERGROUP_MEMBER
    V_$ASM_VOLUME
    V_$ASM_VOLUME_STAT
    V_$AW_AGGREGATE_OP
    V_$AW_ALLOCATE_OP
    V_$AW_CALC
    V_$AW_LONGOPS
    V_$AW_OLAP
    V_$AW_SESSION_INFO
    V_$BACKUP
    V_$BACKUP_ARCHIVELOG_DETAILS
    V_$BACKUP_ARCHIVELOG_SUMMARY
    V_$BACKUP_ASYNC_IO
    V_$BACKUP_CONTROLFILE_DETAILS
    V_$BACKUP_CONTROLFILE_SUMMARY
    V_$BACKUP_COPY_DETAILS
    V_$BACKUP_COPY_SUMMARY
    V_$BACKUP_CORRUPTION
    V_$BACKUP_DATAFILE
    V_$BACKUP_DATAFILE_DETAILS
    V_$BACKUP_DATAFILE_SUMMARY
    V_$BACKUP_DEVICE
    V_$BACKUP_FILES
    V_$BACKUP_PIECE
    V_$BACKUP_PIECE_DETAILS
    V_$BACKUP_REDOLOG
    V_$BACKUP_SET
    V_$BACKUP_SET_DETAILS
    V_$BACKUP_SET_SUMMARY
    V_$BACKUP_SPFILE
    V_$BACKUP_SPFILE_DETAILS
    V_$BACKUP_SPFILE_SUMMARY
    V_$BACKUP_SYNC_IO
    V_$BGPROCESS
    V_$BH
    V_$BLOCKING_QUIESCE
    V_$BLOCK_CHANGE_TRACKING
    V_$BSP
    V_$BUFFERED_PUBLISHERS
    V_$BUFFERED_QUEUES
    V_$BUFFERED_SUBSCRIBERS
    V_$BUFFER_POOL
    V_$BUFFER_POOL_STATISTICS
    V_$CALLTAG
    V_$CELL
    V_$CELL_CONFIG
    V_$CELL_REQUEST_TOTALS
    V_$CELL_STATE
    V_$CELL_THREAD_HISTORY
    V_$CIRCUIT
    V_$CLASS_CACHE_TRANSFER
    V_$CLASS_PING
    V_$CLIENT_STATS
    V_$CLUSTER_INTERCONNECTS
    V_$CONFIGURED_INTERCONNECTS
    V_$CONTEXT
    V_$CONTROLFILE
    V_$CONTROLFILE_RECORD_SECTION
    V_$COPY_CORRUPTION
    V_$CORRUPT_XID_LIST
    V_$CPOOL_CC_INFO
    V_$CPOOL_CC_STATS
    V_$CPOOL_CONN_INFO
    V_$CPOOL_STATS
    V_$CR_BLOCK_SERVER
    V_$CURRENT_BLOCK_SERVER
    V_$DATABASE
    V_$DATABASE_BLOCK_CORRUPTION
    V_$DATABASE_INCARNATION
    V_$DATABASE_KEY_INFO
    V_$DATAFILE
    V_$DATAFILE_COPY
    V_$DATAFILE_HEADER
    V_$DATAGUARD_CONFIG
    V_$DATAGUARD_STATS
    V_$DATAGUARD_STATUS
    V_$DATAPUMP_JOB
    V_$DATAPUMP_SESSION
    V_$DBFILE
    V_$DBLINK
    V_$DB_CACHE_ADVICE
    V_$DB_OBJECT_CACHE
    V_$DB_PIPES
    V_$DB_TRANSPORTABLE_PLATFORM
    V_$DELETED_OBJECT
    V_$DETACHED_SESSION
    V_$DIAG_ADR_CONTROL
    V_$DIAG_ADR_INVALIDATION
    V_$DIAG_ALERT_EXT
    V_$DIAG_AMS_XACTION
    V_$DIAG_CRITICAL_ERROR
    V_$DIAG_DDE_USER_ACTION
    V_$DIAG_DDE_USER_ACTION_DEF
    V_$DIAG_DDE_USR_ACT_PARAM
    V_$DIAG_DDE_USR_ACT_PARAM_DEF
    V_$DIAG_DDE_USR_INC_ACT_MAP
    V_$DIAG_DDE_USR_INC_TYPE
    V_$DIAG_DFW_CONFIG_CAPTURE
    V_$DIAG_DFW_CONFIG_ITEM
    V_$DIAG_DIAGV_INCIDENT
    V_$DIAG_DIR_EXT
    V_$DIAG_EM_DIAG_JOB
    V_$DIAG_EM_TARGET_INFO
    V_$DIAG_EM_USER_ACTIVITY
    V_$DIAG_HM_FDG_SET
    V_$DIAG_HM_FINDING
    V_$DIAG_HM_INFO
    V_$DIAG_HM_MESSAGE
    V_$DIAG_HM_RECOMMENDATION
    V_$DIAG_HM_RUN
    V_$DIAG_INCCKEY
    V_$DIAG_INCIDENT
    V_$DIAG_INCIDENT_FILE
    V_$DIAG_INC_METER_CONFIG
    V_$DIAG_INC_METER_IMPT_DEF
    V_$DIAG_INC_METER_INFO
    V_$DIAG_INC_METER_PK_IMPTS
    V_$DIAG_INC_METER_SUMMARY
    V_$DIAG_INFO
    V_$DIAG_IPS_CONFIGURATION
    V_$DIAG_IPS_FILE_COPY_LOG
    V_$DIAG_IPS_FILE_METADATA
    V_$DIAG_IPS_PACKAGE
    V_$DIAG_IPS_PACKAGE_FILE
    V_$DIAG_IPS_PACKAGE_HISTORY
    V_$DIAG_IPS_PACKAGE_INCIDENT
    V_$DIAG_IPS_PKG_UNPACK_HIST
    V_$DIAG_IPS_PROGRESS_LOG
    V_$DIAG_IPS_REMOTE_PACKAGE
    V_$DIAG_PICKLEERR
    V_$DIAG_PROBLEM
    V_$DIAG_RELMD_EXT
    V_$DIAG_SWEEPERR
    V_$DIAG_VEM_USER_ACTLOG
    V_$DIAG_VEM_USER_ACTLOG1
    V_$DIAG_VHM_RUN
    V_$DIAG_VIEW
    V_$DIAG_VIEWCOL
    V_$DIAG_VINCIDENT
    V_$DIAG_VINCIDENT_FILE
    V_$DIAG_VINC_METER_INFO
    V_$DIAG_VIPS_FILE_COPY_LOG
    V_$DIAG_VIPS_FILE_METADATA
    V_$DIAG_VIPS_PACKAGE_FILE
    V_$DIAG_VIPS_PACKAGE_HISTORY
    V_$DIAG_VIPS_PACKAGE_MAIN_INT
    V_$DIAG_VIPS_PACKAGE_SIZE
    V_$DIAG_VIPS_PKG_FILE
    V_$DIAG_VIPS_PKG_INC_CAND
    V_$DIAG_VIPS_PKG_INC_DTL
    V_$DIAG_VIPS_PKG_INC_DTL1
    V_$DIAG_VIPS_PKG_MAIN_PROBLEM
    V_$DIAG_VNOT_EXIST_INCIDENT
    V_$DIAG_VPROBLEM
    V_$DIAG_VPROBLEM1
    V_$DIAG_VPROBLEM2
    V_$DIAG_VPROBLEM_BUCKET
    V_$DIAG_VPROBLEM_BUCKET1
    V_$DIAG_VPROBLEM_BUCKET_COUNT
    V_$DIAG_VPROBLEM_INT
    V_$DIAG_VPROBLEM_LASTINC
    V_$DIAG_VSHOWCATVIEW
    V_$DIAG_VSHOWINCB
    V_$DIAG_VSHOWINCB_I
    V_$DIAG_VTEST_EXISTS
    V_$DIAG_V_ACTINC
    V_$DIAG_V_ACTPROB
    V_$DIAG_V_INCCOUNT
    V_$DIAG_V_INCFCOUNT
    V_$DIAG_V_INC_METER_INFO_PROB
    V_$DIAG_V_IPSPRBCNT
    V_$DIAG_V_IPSPRBCNT1
    V_$DIAG_V_NFCINC
    V_$DIAG_V_SWPERRCOUNT
    V_$DISPATCHER
    V_$DISPATCHER_CONFIG
    V_$DISPATCHER_RATE
    V_$DLM_ALL_LOCKS
    V_$DLM_CONVERT_LOCAL
    V_$DLM_CONVERT_REMOTE
    V_$DLM_LATCH
    V_$DLM_LOCKS
    V_$DLM_MISC
    V_$DLM_RESS
    V_$DLM_TRAFFIC_CONTROLLER
    V_$DNFS_CHANNELS
    V_$DNFS_FILES
    V_$DNFS_SERVERS
    V_$DNFS_STATS
    V_$DYNAMIC_REMASTER_STATS
    V_$EMON
    V_$ENABLEDPRIVS
    V_$ENCRYPTED_TABLESPACES
    V_$ENCRYPTION_WALLET
    V_$ENQUEUE_LOCK
    V_$ENQUEUE_STAT
    V_$ENQUEUE_STATISTICS
    V_$EVENTMETRIC
    V_$EVENT_HISTOGRAM
    V_$EVENT_NAME
    V_$EXECUTION
    V_$FAST_START_SERVERS
    V_$FAST_START_TRANSACTIONS
    V_$FILEMETRIC
    V_$FILEMETRIC_HISTORY
    V_$FILESPACE_USAGE
    V_$FILESTAT
    V_$FILE_CACHE_TRANSFER
    V_$FILE_HISTOGRAM
    V_$FILE_OPTIMIZED_HISTOGRAM
    V_$FILE_PING
    V_$FIXED_TABLE
    V_$FIXED_VIEW_DEFINITION
    V_$FLASHBACK_DATABASE_LOG
    V_$FLASHBACK_DATABASE_LOGFILE
    V_$FLASHBACK_DATABASE_STAT
    V_$FLASHBACK_TXN_GRAPH
    V_$FLASHBACK_TXN_MODS
    V_$FLASH_RECOVERY_AREA_USAGE
    V_$FOREIGN_ARCHIVED_LOG
    V_$FS_FAILOVER_HISTOGRAM
    V_$FS_FAILOVER_STATS
    V_$GCSHVMASTER_INFO
    V_$GCSPFMASTER_INFO
    V_$GC_ELEMENT
    V_$GC_ELEMENTS_W_COLLISIONS
    V_$GES_BLOCKING_ENQUEUE
    V_$GES_ENQUEUE
    V_$GLOBALCONTEXT
    V_$GLOBAL_BLOCKED_LOCKS
    V_$GLOBAL_TRANSACTION
    V_$GOLDENGATE_CAPTURE
    V_$GOLDENGATE_MESSAGE_TRACKING
    V_$GOLDENGATE_TRANSACTION
    V_$HANG_INFO
    V_$HANG_SESSION_INFO
    V_$HM_CHECK
    V_$HM_CHECK_PARAM
    V_$HM_FINDING
    V_$HM_INFO
    V_$HM_RECOMMENDATION
    V_$HM_RUN
    V_$HS_AGENT
    V_$HS_PARAMETER
    V_$HS_SESSION
    V_$HVMASTER_INFO
    V_$INCMETER_CONFIG
    V_$INCMETER_INFO
    V_$INCMETER_SUMMARY
    V_$INDEXED_FIXED_COLUMN
    V_$INSTANCE
    V_$INSTANCE_CACHE_TRANSFER
    V_$INSTANCE_LOG_GROUP
    V_$INSTANCE_RECOVERY
    V_$IOFUNCMETRIC
    V_$IOFUNCMETRIC_HISTORY
    V_$IOSTAT_CONSUMER_GROUP
    V_$IOSTAT_FILE
    V_$IOSTAT_FUNCTION
    V_$IOSTAT_FUNCTION_DETAIL
    V_$IOSTAT_NETWORK
    V_$IO_CALIBRATION_STATUS
    V_$IR_FAILURE
    V_$IR_FAILURE_SET
    V_$IR_MANUAL_CHECKLIST
    V_$IR_REPAIR
    V_$JAVAPOOL
    V_$JAVA_LIBRARY_CACHE_MEMORY
    V_$JAVA_POOL_ADVICE
    V_$KCCDI
    V_$KCCFE
    V_$LATCH
    V_$LATCHHOLDER
    V_$LATCHNAME
    V_$LATCH_CHILDREN
    V_$LATCH_MISSES
    V_$LATCH_PARENT
    V_$LIBCACHE_LOCKS
    V_$LIBRARYCACHE
    V_$LIBRARY_CACHE_MEMORY
    V_$LICENSE
    V_$LISTENER_NETWORK
    V_$LOADISTAT
    V_$LOADPSTAT
    V_$LOBSTAT
    V_$LOCK
    V_$LOCKED_OBJECT
    V_$LOCKS_WITH_COLLISIONS
    V_$LOCK_ACTIVITY
    V_$LOCK_ELEMENT
    V_$LOCK_TYPE
    V_$LOG
    V_$LOGFILE
    V_$LOGHIST
    V_$LOGMNR_CALLBACK
    V_$LOGMNR_CONTENTS
    V_$LOGMNR_DICTIONARY
    V_$LOGMNR_DICTIONARY_LOAD
    V_$LOGMNR_LATCH
    V_$LOGMNR_LOGFILE
    V_$LOGMNR_LOGS
    V_$LOGMNR_PARAMETERS
    V_$LOGMNR_PROCESS
    V_$LOGMNR_REGION
    V_$LOGMNR_SESSION
    V_$LOGMNR_STATS
    V_$LOGMNR_TRANSACTION
    V_$LOGSTDBY
    V_$LOGSTDBY_PROCESS
    V_$LOGSTDBY_PROGRESS
    V_$LOGSTDBY_STATE
    V_$LOGSTDBY_STATS
    V_$LOGSTDBY_TRANSACTION
    V_$LOG_HISTORY
    V_$MANAGED_STANDBY
    V_$MAP_COMP_LIST
    V_$MAP_ELEMENT
    V_$MAP_EXT_ELEMENT
    V_$MAP_FILE
    V_$MAP_FILE_EXTENT
    V_$MAP_FILE_IO_STACK
    V_$MAP_LIBRARY
    V_$MAP_SUBELEMENT
    V_$MAX_ACTIVE_SESS_TARGET_MTH
    V_$MEMORY_CURRENT_RESIZE_OPS
    V_$MEMORY_DYNAMIC_COMPONENTS
    V_$MEMORY_RESIZE_OPS
    V_$MEMORY_TARGET_ADVICE
    V_$METRIC
    V_$METRICGROUP
    V_$METRICNAME
    V_$METRIC_HISTORY
    V_$MTTR_TARGET_ADVICE
    V_$MUTEX_SLEEP
    V_$MUTEX_SLEEP_HISTORY
    V_$MVREFRESH
    V_$MYSTAT
    V_$NFS_CLIENTS
    V_$NFS_LOCKS
    V_$NFS_OPEN_FILES
    V_$NLS_PARAMETERS
    V_$NLS_VALID_VALUES
    V_$OBJECT_DEPENDENCY
    V_$OBJECT_DML_FREQUENCIES
    V_$OBJECT_PRIVILEGE
    V_$OBSOLETE_PARAMETER
    V_$OFFLINE_RANGE
    V_$OPEN_CURSOR
    V_$OPTION
    V_$OSSTAT
    V_$PARALLEL_DEGREE_LIMIT_MTH
    V_$PARAMETER
    V_$PARAMETER2
    V_$PARAMETER_VALID_VALUES
    V_$PERSISTENT_PUBLISHERS
    V_$PERSISTENT_QMN_CACHE
    V_$PERSISTENT_QUEUES
    V_$PERSISTENT_SUBSCRIBERS
    V_$PGASTAT
    V_$PGA_TARGET_ADVICE
    V_$PGA_TARGET_ADVICE_HISTOGRAM
    V_$POLICY_HISTORY
    V_$PQ_SESSTAT
    V_$PQ_SLAVE
    V_$PQ_SYSSTAT
    V_$PQ_TQSTAT
    V_$PROCESS
    V_$PROCESS_GROUP
    V_$PROCESS_MEMORY
    V_$PROCESS_MEMORY_DETAIL
    V_$PROCESS_MEMORY_DETAIL_PROG
    V_$PROPAGATION_RECEIVER
    V_$PROPAGATION_SENDER
    V_$PROXY_ARCHIVEDLOG
    V_$PROXY_ARCHIVELOG_DETAILS
    V_$PROXY_ARCHIVELOG_SUMMARY
    V_$PROXY_COPY_DETAILS
    V_$PROXY_COPY_SUMMARY
    V_$PROXY_DATAFILE
    V_$PWFILE_USERS
    V_$PX_BUFFER_ADVICE
    V_$PX_INSTANCE_GROUP
    V_$PX_PROCESS
    V_$PX_PROCESS_SYSSTAT
    V_$PX_SESSION
    V_$PX_SESSTAT
    V_$QMON_COORDINATOR_STATS
    V_$QMON_SERVER_STATS
    V_$QMON_TASKS
    V_$QMON_TASK_STATS
    V_$QUEUE
    V_$QUEUEING_MTH
    V_$RECOVERY_AREA_USAGE
    V_$RECOVERY_FILE_DEST
    V_$RECOVERY_FILE_STATUS
    V_$RECOVERY_LOG
    V_$RECOVERY_PROGRESS
    V_$RECOVERY_STATUS
    V_$RECOVER_FILE
    V_$REDO_DEST_RESP_HISTOGRAM
    V_$REPLPROP
    V_$REPLQUEUE
    V_$REQDIST
    V_$RESERVED_WORDS
    V_$RESOURCE
    V_$RESOURCE_LIMIT
    V_$RESTORE_POINT
    V_$RESULT_CACHE_DEPENDENCY
    V_$RESULT_CACHE_MEMORY
    V_$RESULT_CACHE_OBJECTS
    V_$RESULT_CACHE_STATISTICS
    V_$RESUMABLE
    V_$RFS_THREAD
    V_$RMAN_BACKUP_JOB_DETAILS
    V_$RMAN_BACKUP_SUBJOB_DETAILS
    V_$RMAN_BACKUP_TYPE
    V_$RMAN_COMPRESSION_ALGORITHM
    V_$RMAN_CONFIGURATION
    V_$RMAN_ENCRYPTION_ALGORITHMS
    V_$RMAN_OUTPUT
    V_$RMAN_STATUS
    V_$ROLLNAME
    V_$ROLLSTAT
    V_$ROWCACHE
    V_$ROWCACHE_PARENT
    V_$ROWCACHE_SUBORDINATE
    V_$RSRCMGRMETRIC
    V_$RSRCMGRMETRIC_HISTORY
    V_$RSRC_CONSUMER_GROUP
    V_$RSRC_CONSUMER_GROUP_CPU_MTH
    V_$RSRC_CONS_GROUP_HISTORY
    V_$RSRC_PLAN
    V_$RSRC_PLAN_CPU_MTH
    V_$RSRC_PLAN_HISTORY
    V_$RSRC_SESSION_INFO
    V_$RULE
    V_$RULE_SET
    V_$RULE_SET_AGGREGATE_STATS
    V_$SCHEDULER_RUNNING_JOBS
    V_$SECUREFILE_TIMER
    V_$SEGMENT_STATISTICS
    V_$SEGSPACE_USAGE
    V_$SEGSTAT
    V_$SEGSTAT_NAME
    V_$SERVICEMETRIC
    V_$SERVICEMETRIC_HISTORY
    V_$SERVICES
    V_$SERVICE_EVENT
    V_$SERVICE_STATS
    V_$SERVICE_WAIT_CLASS
    V_$SERV_MOD_ACT_STATS
    V_$SESSION
    V_$SESSION_BLOCKERS
    V_$SESSION_CONNECT_INFO
    V_$SESSION_CURSOR_CACHE
    V_$SESSION_EVENT
    V_$SESSION_FIX_CONTROL
    V_$SESSION_LONGOPS
    V_$SESSION_OBJECT_CACHE
    V_$SESSION_WAIT
    V_$SESSION_WAIT_CLASS
    V_$SESSION_WAIT_HISTORY
    V_$SESSMETRIC
    V_$SESSTAT
    V_$SESS_IO
    V_$SESS_TIME_MODEL
    V_$SES_OPTIMIZER_ENV
    V_$SGA
    V_$SGAINFO
    V_$SGASTAT
    V_$SGA_CURRENT_RESIZE_OPS
    V_$SGA_DYNAMIC_COMPONENTS
    V_$SGA_DYNAMIC_FREE_MEMORY
    V_$SGA_RESIZE_OPS
    V_$SGA_TARGET_ADVICE
    V_$SHARED_POOL_ADVICE
    V_$SHARED_POOL_RESERVED
    V_$SHARED_SERVER
    V_$SHARED_SERVER_MONITOR
    V_$SORT_SEGMENT
    V_$SORT_USAGE
    V_$SPPARAMETER
    V_$SQL
    V_$SQLAREA
    V_$SQLAREA_PLAN_HASH
    V_$SQLCOMMAND
    V_$SQLFN_ARG_METADATA
    V_$SQLFN_METADATA
    V_$SQLPA_METRIC
    V_$SQLSTATS
    V_$SQLSTATS_PLAN_HASH
    V_$SQLTEXT
    V_$SQLTEXT_WITH_NEWLINES
    V_$SQL_BIND_CAPTURE
    V_$SQL_BIND_DATA
    V_$SQL_BIND_METADATA
    V_$SQL_CS_HISTOGRAM
    V_$SQL_CS_SELECTIVITY
    V_$SQL_CS_STATISTICS
    V_$SQL_CURSOR
    V_$SQL_FEATURE
    V_$SQL_FEATURE_DEPENDENCY
    V_$SQL_FEATURE_HIERARCHY
    V_$SQL_HINT
    V_$SQL_JOIN_FILTER
    V_$SQL_MONITOR
    V_$SQL_OPTIMIZER_ENV
    V_$SQL_PLAN
    V_$SQL_PLAN_MONITOR
    V_$SQL_PLAN_STATISTICS
    V_$SQL_PLAN_STATISTICS_ALL
    V_$SQL_REDIRECTION
    V_$SQL_SHARED_CURSOR
    V_$SQL_SHARED_MEMORY
    V_$SQL_WORKAREA
    V_$SQL_WORKAREA_ACTIVE
    V_$SQL_WORKAREA_HISTOGRAM
    V_$SSCR_SESSIONS
    V_$STANDBY_EVENT_HISTOGRAM
    V_$STANDBY_LOG
    V_$STATISTICS_LEVEL
    V_$STATNAME
    V_$STREAMS_APPLY_COORDINATOR
    V_$STREAMS_APPLY_READER
    V_$STREAMS_APPLY_SERVER
    V_$STREAMS_CAPTURE
    V_$STREAMS_MESSAGE_TRACKING
    V_$STREAMS_POOL_ADVICE
    V_$STREAMS_POOL_STATISTICS
    V_$STREAMS_TRANSACTION
    V_$SUBCACHE
    V_$SUBSCR_REGISTRATION_STATS
    V_$SYSAUX_OCCUPANTS
    V_$SYSMETRIC
    V_$SYSMETRIC_HISTORY
    V_$SYSMETRIC_SUMMARY
    V_$SYSSTAT
    V_$SYSTEM_CURSOR_CACHE
    V_$SYSTEM_EVENT
    V_$SYSTEM_FIX_CONTROL
    V_$SYSTEM_PARAMETER
    V_$SYSTEM_PARAMETER2
    V_$SYSTEM_WAIT_CLASS
    V_$SYS_OPTIMIZER_ENV
    V_$SYS_TIME_MODEL
    V_$TABLESPACE
    V_$TEMPFILE
    V_$TEMPORARY_LOBS
    V_$TEMPSTAT
    V_$TEMP_CACHE_TRANSFER
    V_$TEMP_EXTENT_MAP
    V_$TEMP_EXTENT_POOL
    V_$TEMP_PING
    V_$TEMP_SPACE_HEADER
    V_$THREAD
    V_$THRESHOLD_TYPES
    V_$TIMER
    V_$TIMEZONE_FILE
    V_$TIMEZONE_NAMES
    V_$TOPLEVELCALL
    V_$TRANSACTION
    V_$TRANSACTION_ENQUEUE
    V_$TRANSPORTABLE_PLATFORM
    V_$TSM_SESSIONS
    V_$TYPE_SIZE
    V_$UNDOSTAT
    V_$UNUSABLE_BACKUPFILE_DETAILS
    V_$VERSION
    V_$VPD_POLICY
    V_$WAITCLASSMETRIC
    V_$WAITCLASSMETRIC_HISTORY
    V_$WAITSTAT
    V_$WAIT_CHAINS
    V_$WALLET
    V_$WLM_PCMETRIC
    V_$WLM_PCMETRIC_HISTORY
    V_$WLM_PC_STATS
    V_$WORKLOAD_REPLAY_THREAD
    V_$XML_AUDIT_TRAIL
    V_$XSTREAM_CAPTURE
    V_$XSTREAM_MESSAGE_TRACKING
    V_$XSTREAM_OUTBOUND_SERVER
    V_$XSTREAM_TRANSACTION
    V_$_LOCK
    ViewFrame3d236_TAB
    ViewPoint3d223_TAB
    Vis3DConfig233_TAB
    WITHIN
    WPG_DOCLOAD
    WRI$_ADV_ASA_RECO_DATA
    WWV_COLUMN_EXCEPTIONS
    WWV_DEMO_DEPT
    WWV_DEMO_EMP
    WWV_FLOW
    WWV_FLOW
    WWV_FLOWS
    WWV_FLOWS_RESERVED
    WWV_FLOW_ACTIVITY_LOG
    WWV_FLOW_ACTIVITY_LOG1$
    WWV_FLOW_ACTIVITY_LOG2$
    WWV_FLOW_ACTIVITY_LOG_NUMBER$
    WWV_FLOW_ADVISOR_CATEGORIES
    WWV_FLOW_ADVISOR_CHECKS
    WWV_FLOW_ADVISOR_CHECK_MSGS
    WWV_FLOW_ADVISOR_RESULT
    WWV_FLOW_ALTERNATE_CONFIG
    WWV_FLOW_ALT_CONFIG_DETAIL
    WWV_FLOW_ALT_CONFIG_PICK
    WWV_FLOW_API
    WWV_FLOW_APPLICATION_GROUPS
    WWV_FLOW_APPLICATION_INSTALL
    WWV_FLOW_APP_BUILD_PREF
    WWV_FLOW_APP_COMMENTS
    WWV_FLOW_AUDIT
    WWV_FLOW_AUTHORIZED
    WWV_FLOW_AUTHORIZED_URLS
    WWV_FLOW_BANNER
    WWV_FLOW_BUGS
    WWV_FLOW_BUG_PRIORITY
    WWV_FLOW_BUG_SEVERITY
    WWV_FLOW_BUG_STATUS_CODES
    WWV_FLOW_BUILDER_AUDIT_TRAIL
    WWV_FLOW_BUILD_OPTIONS
    WWV_FLOW_BUTTON_TEMPLATES
    WWV_FLOW_CALS
    WWV_FLOW_CAL_TEMPLATES
    WWV_FLOW_CHARSETS
    WWV_FLOW_CHART_FORMAT_MASKS
    WWV_FLOW_CLICKTHRU_LOG
    WWV_FLOW_CLICKTHRU_LOG
    WWV_FLOW_CLICKTHRU_LOG$
    WWV_FLOW_CLICKTHRU_LOG2$
    WWV_FLOW_CLICKTHRU_LOG_NUMBER$
    WWV_FLOW_CLICKTHRU_LOG_V
    WWV_FLOW_COLLECTION
    WWV_FLOW_COLLECTIONS
    WWV_FLOW_COLLECTIONS
    WWV_FLOW_COLLECTIONS$
    WWV_FLOW_COLLECTION_MEMBERS$
    WWV_FLOW_COMPANIES
    WWV_FLOW_COMPANY_SCHEMAS
    WWV_FLOW_COMPANY_TYPES
    WWV_FLOW_COMPOUND_CONDITIONS
    WWV_FLOW_COMPUTATIONS
    WWV_FLOW_COUNTRIES
    WWV_FLOW_CSS
    WWV_FLOW_CSS_API
    WWV_FLOW_CSS_REPOSITORY
    WWV_FLOW_CUSTOMIZE
    WWV_FLOW_CUSTOMIZED_TASKS
    WWV_FLOW_CUSTOM_AUTH
    WWV_FLOW_CUSTOM_AUTH_LDAP
    WWV_FLOW_CUSTOM_AUTH_SETUPS
    WWV_FLOW_CUSTOM_AUTH_STD
    WWV_FLOW_DATA
    WWV_FLOW_DATA_LOAD_BAD_LOG
    WWV_FLOW_DATA_LOAD_UNLOAD
    WWV_FLOW_DB_AUTH
    WWV_FLOW_DEBUG
    WWV_FLOW_DEBUG_MESSAGES
    WWV_FLOW_DEBUG_MESSAGES2
    WWV_FLOW_DEVELOPERS
    WWV_FLOW_DEVELOPER_LOG
    WWV_FLOW_DEVELOPER_ROLES
    WWV_FLOW_DICTIONARY_VIEWS
    WWV_FLOW_DUAL100
    WWV_FLOW_DUAL100
    WWV_FLOW_DYNAMIC_TRANSLATIONS$
    WWV_FLOW_EFFECTIVE_USERID_MAP
    WWV_FLOW_ENTRY_POINTS
    WWV_FLOW_ENTRY_POINT_ARGS
    WWV_FLOW_EPG_INCLUDE_MODULES
    WWV_FLOW_EVENTS
    WWV_FLOW_FEATURES
    WWV_FLOW_FEATURE_ACCSTAT
    WWV_FLOW_FEATURE_COLS
    WWV_FLOW_FEATURE_DEF_ST_CODES
    WWV_FLOW_FEATURE_DESIRABILITY
    WWV_FLOW_FEATURE_DOCSTATUS
    WWV_FLOW_FEATURE_GLOBSTAT
    WWV_FLOW_FEATURE_HISTORY
    WWV_FLOW_FEATURE_PRIORITIES
    WWV_FLOW_FEATURE_PROGRESS
    WWV_FLOW_FEATURE_SECSTAT
    WWV_FLOW_FEATURE_TESTSTAT
    WWV_FLOW_FEATURE_UISTAT
    WWV_FLOW_FEEDBACK
    WWV_FLOW_FEEDBACK_FOLLOWUP
    WWV_FLOW_FEEDBACK_STATUS
    WWV_FLOW_FEEDBACK_TYPES
    WWV_FLOW_FIELD_TEMPLATES
    WWV_FLOW_FILES
    WWV_FLOW_FILES
    WWV_FLOW_FILE_API
    WWV_FLOW_FILE_MGR
    WWV_FLOW_FILE_OBJECTS$
    WWV_FLOW_FILE_OBJECTS$
    WWV_FLOW_FILE_OBJECTS$PART
    WWV_FLOW_FILE_OBJECT_ID
    WWV_FLOW_FLASH_CHART5_SERIES
    WWV_FLOW_FLASH_CHARTS
    WWV_FLOW_FLASH_CHARTS_5
    WWV_FLOW_FLASH_CHARTS_5_DASH
    WWV_FLOW_FLASH_CHART_SERIES
    WWV_FLOW_FLASH_MAP_FILES
    WWV_FLOW_FLASH_MAP_FOLDERS
    WWV_FLOW_FLASH_MAP_REGIONS
    WWV_FLOW_FND_GROUP_USERS
    WWV_FLOW_FND_USER
    WWV_FLOW_FND_USER_API
    WWV_FLOW_FND_USER_GROUPS
    WWV_FLOW_FORMAT_MASKS
    WWV_FLOW_GLOBAL
    WWV_FLOW_GROUP_USERS
    WWV_FLOW_GROUP_USERS
    WWV_FLOW_HELP
    WWV_FLOW_HINT
    WWV_FLOW_HNT_ARGUMENT_INFO
    WWV_FLOW_HNT_COLUMN_DICT
    WWV_FLOW_HNT_COLUMN_INFO
    WWV_FLOW_HNT_COL_DICT_SYN
    WWV_FLOW_HNT_GROUPS
    WWV_FLOW_HNT_LOV_DATA
    WWV_FLOW_HNT_PROCEDURE_INFO
    WWV_FLOW_HNT_TABLE_INFO
    WWV_FLOW_HOT_HTTP_LINKS
    WWV_FLOW_HOURS_12
    WWV_FLOW_HOURS_24
    WWV_FLOW_HTML_API
    WWV_FLOW_HTML_REPOSITORY
    WWV_FLOW_ICON_BAR
    WWV_FLOW_ICON_BAR_ATTRIBUTES
    WWV_FLOW_ID
    WWV_FLOW_ID
    WWV_FLOW_IMAGE_API
    WWV_FLOW_IMAGE_REPOSITORY
    WWV_FLOW_IMPORT_EXPORT
    WWV_FLOW_INIT_HTP_BUFFER
    WWV_FLOW_INSTALL
    WWV_FLOW_INSTALL_BUILD_OPT
    WWV_FLOW_INSTALL_CHECKS
    WWV_FLOW_INSTALL_SCRIPTS
    WWV_FLOW_ITEM
    WWV_FLOW_ITEMS
    WWV_FLOW_ITEM_HELP
    WWV_FLOW_JAVASCRIPT
    WWV_FLOW_JAVASCRIPT_EVENTS
    WWV_FLOW_JOBS
    WWV_FLOW_JOB_BIND_VALUES
    WWV_FLOW_LANG
    WWV_FLOW_LANGUAGES
    WWV_FLOW_LANGUAGE_MAP
    WWV_FLOW_LDAP
    WWV_FLOW_LINKS
    WWV_FLOW_LISTS
    WWV_FLOW_LISTS_OF_VALUES$
    WWV_FLOW_LISTS_OF_VALUES$_V
    WWV_FLOW_LISTS_OF_VALUES$_V
    WWV_FLOW_LIST_ITEMS
    WWV_FLOW_LIST_OF_VALUES_DATA
    WWV_FLOW_LIST_OF_VALUES_DATA_V
    WWV_FLOW_LIST_OF_VALUES_DATA_V
    WWV_FLOW_LIST_TEMPLATES
    WWV_FLOW_LOCK_PAGE
    WWV_FLOW_LOCK_PAGE_LOG
    WWV_FLOW_LOG_HISTORY
    WWV_FLOW_LOV_TEMP
    WWV_FLOW_LOV_TEMP
    WWV_FLOW_LOV_VALUES
    WWV_FLOW_MAIL
    WWV_FLOW_MAIL_ATTACHMENTS
    WWV_FLOW_MAIL_LOG
    WWV_FLOW_MAIL_QUEUE
    WWV_FLOW_MENUS
    WWV_FLOW_MENU_OPTIONS
    WWV_FLOW_MENU_TEMPLATES
    WWV_FLOW_MESSAGES$
    WWV_FLOW_MINUTES
    WWV_FLOW_MINUTES_5
    WWV_FLOW_MODELS
    WWV_FLOW_MODEL_PAGES
    WWV_FLOW_MODEL_PAGE_COLS
    WWV_FLOW_MODEL_PAGE_REGIONS
    WWV_FLOW_MONTHS_MON
    WWV_FLOW_MONTHS_MON
    WWV_FLOW_MONTHS_MONTH
    WWV_FLOW_MONTHS_MONTH
    WWV_FLOW_MONTHS_MONTH_TEMP
    WWV_FLOW_MONTHS_MON_TEMP
    WWV_FLOW_NATIVE_PLUGINS
    WWV_FLOW_NEWS
    WWV_FLOW_ONLINE_HELP
    WWV_FLOW_ONLINE_HELP_JA
    WWV_FLOW_PAGES_RESERVED
    WWV_FLOW_PAGE_CACHE
    WWV_FLOW_PAGE_CODE_CACHE
    WWV_FLOW_PAGE_DA_ACTIONS
    WWV_FLOW_PAGE_DA_EVENTS
    WWV_FLOW_PAGE_GENERIC_ATTR
    WWV_FLOW_PAGE_GROUPS
    WWV_FLOW_PAGE_PLUGS
    WWV_FLOW_PAGE_PLUG_TEMPLATES
    WWV_FLOW_PAGE_SUBMISSIONS
    WWV_FLOW_PASSWORD_HISTORY
    WWV_FLOW_PATCHES
    WWV_FLOW_PICK_DATABASE_SIZE
    WWV_FLOW_PICK_END_USERS
    WWV_FLOW_PICK_PAGE_VIEWS
    WWV_FLOW_PLATFORM_PREF
    WWV_FLOW_PLATFORM_PREFS
    WWV_FLOW_PLSQL_JOBS
    WWV_FLOW_PLUGIN
    WWV_FLOW_PLUGINS
    WWV_FLOW_PLUGIN_ATTRIBUTES
    WWV_FLOW_PLUGIN_ATTR_VALUES
    WWV_FLOW_PLUGIN_EVENTS
    WWV_FLOW_PLUGIN_FILES
    WWV_FLOW_PLUGIN_UTIL
    WWV_FLOW_POPUP_LOV_TEMPLATE
    WWV_FLOW_PREFERENCES
    WWV_FLOW_PREFERENCES$
    WWV_FLOW_PROCESSING
    WWV_FLOW_PROVISION_COMPANY
    WWV_FLOW_PROVISION_SERICE_MOD
    WWV_FLOW_PURGED_SESSIONS$
    WWV_FLOW_QB_SAVED_COND
    WWV_FLOW_QB_SAVED_JOIN
    WWV_FLOW_QB_SAVED_QUERY
    WWV_FLOW_QB_SAVED_TABS
    WWV_FLOW_QUERY_COLUMN
    WWV_FLOW_QUERY_CONDITION
    WWV_FLOW_QUERY_DEFINITION
    WWV_FLOW_QUERY_OBJECT
    WWV_FLOW_RANDOM
    WWV_FLOW_RANDOM_IMAGES
    WWV_FLOW_REGION_CHART_SER_ATTR
    WWV_FLOW_REGION_REPORT_COLUMN
    WWV_FLOW_REGION_REPORT_FILTER
    WWV_FLOW_REGION_UPD_RPT_COLS
    WWV_FLOW_RENDER_SHORTCUT
    WWV_FLOW_REPORT_LAYOUTS
    WWV_FLOW_REQUEST_VERIFICATIONS
    WWV_FLOW_REQUIRED_ROLES
    WWV_FLOW_RESTRICTED_SCHEMAS
    WWV_FLOW_ROW_TEMPLATES
    WWV_FLOW_RSCHEMA_EXCEPTIONS
    WWV_FLOW_SC_TRANS
    WWV_FLOW_SEARCH_RESULT
    WWV_FLOW_SECURITY
    WWV_FLOW_SECURITY_SCHEMES
    WWV_FLOW_SESSIONS$
    WWV_FLOW_SESSION_SEQ
    WWV_FLOW_SESSION_SEQ
    WWV_FLOW_SHARED_QRY_SQL_STMTS
    WWV_FLOW_SHARED_QUERIES
    WWV_FLOW_SHARED_WEB_SERVICES
    WWV_FLOW_SHORTCUTS
    WWV_FLOW_SHORTCUT_USAGE_MAP
    WWV_FLOW_STANDARD_CSS
    WWV_FLOW_STANDARD_EVENTS
    WWV_FLOW_STANDARD_ICONS
    WWV_FLOW_STANDARD_ITEM_TYPES
    WWV_FLOW_STANDARD_JS
    WWV_FLOW_STEPS
    WWV_FLOW_STEP_BRANCHES
    WWV_FLOW_STEP_BRANCH_ARGS
    WWV_FLOW_STEP_BUTTONS
    WWV_FLOW_STEP_COMPUTATIONS
    WWV_FLOW_STEP_ITEMS
    WWV_FLOW_STEP_ITEM_HELP
    WWV_FLOW_STEP_PROCESSING
    WWV_FLOW_STEP_VALIDATIONS
    WWV_FLOW_SVG
    WWV_FLOW_SW_BINDS
    WWV_FLOW_SW_CREATE_KEYWORDS
    WWV_FLOW_SW_DETAIL_RESULTS
    WWV_FLOW_SW_MAIN_KEYWORDS
    WWV_FLOW_SW_RESULTS
    WWV_FLOW_SW_SET_KEYWORDS
    WWV_FLOW_SW_SQLPLUS_CMD
    WWV_FLOW_SW_SQL_CMDS
    WWV_FLOW_SW_STMTS
    WWV_FLOW_TABS
    WWV_FLOW_TABSET_VIEW
    WWV_FLOW_TABSET_VIEW2
    WWV_FLOW_TASKS
    WWV_FLOW_TASK_DEFAULTS
    WWV_FLOW_TASK_DEF_STATUS_CODES
    WWV_FLOW_TASK_PROGRESS
    WWV_FLOW_TEAMDEV_TAG_CLOUD
    WWV_FLOW_TEAM_FILES
    WWV_FLOW_TEAM_TAGS
    WWV_FLOW_TEMPLATES
    WWV_FLOW_TEMPLATES$
    WWV_FLOW_TEMPLATES_ALL
    WWV_FLOW_TEMPLATES_USED
    WWV_FLOW_TEMPLATE_PREFERENCES
    WWV_FLOW_TEMPLATE_THEMES$
    WWV_FLOW_TEMP_TABLE
    WWV_FLOW_TEMP_TABLE
    WWV_FLOW_TEMP_TREES
    WWV_FLOW_THEMES
    WWV_FLOW_TOPLEVEL_TABS
    WWV_FLOW_TRANSLATABLE_COLS$
    WWV_FLOW_TRANSLATABLE_TEXT$
    WWV_FLOW_TREES
    WWV_FLOW_TREE_REGIONS
    WWV_FLOW_TREE_STATE
    WWV_FLOW_UPGRADE_PROGRESS
    WWV_FLOW_UPG_COL_NAME_CHANGES
    WWV_FLOW_UPG_TAB_NAME_CHANGES
    WWV_FLOW_UPG_TAB_OBSOLETE
    WWV_FLOW_USERS
    WWV_FLOW_USERS
    WWV_FLOW_USER_ACCESS_LOG
    WWV_FLOW_USER_ACCESS_LOG
    WWV_FLOW_USER_ACCESS_LOG1$
    WWV_FLOW_USER_ACCESS_LOG2$
    WWV_FLOW_USER_ACCESS_LOG_NUM$
    WWV_FLOW_USER_ACCESS_LOG_V
    WWV_FLOW_USER_ACTIVITY_LOG
    WWV_FLOW_USER_ACTIVITY_LOG
    WWV_FLOW_USER_API
    WWV_FLOW_USER_MAIL_ATTACHMENTS
    WWV_FLOW_USER_MAIL_LOG
    WWV_FLOW_USER_MAIL_QUEUE
    WWV_FLOW_UTILITIES
    WWV_FLOW_VALIDATIONS
    WWV_FLOW_VERSION
    WWV_FLOW_VERSION$
    WWV_FLOW_VERSION_SEQ
    WWV_FLOW_WORKSHEETS
    WWV_FLOW_WORKSHEET_CATEGORIES
    WWV_FLOW_WORKSHEET_COLUMNS
    WWV_FLOW_WORKSHEET_COL_GROUPS
    WWV_FLOW_WORKSHEET_COMPUTATION
    WWV_FLOW_WORKSHEET_CONDITIONS
    WWV_FLOW_WORKSHEET_GEOCACHE
    WWV_FLOW_WORKSHEET_GROUP_BY
    WWV_FLOW_WORKSHEET_LOVS
    WWV_FLOW_WORKSHEET_LOV_ENTRIES
    WWV_FLOW_WORKSHEET_NOTIFY
    WWV_FLOW_WORKSHEET_RPTS
    WWV_FLOW_WORKSPACE_REQ_SIZE
    WWV_FLOW_WORKSPACE_SUMMARY
    WWV_FLOW_WS_APPLICATIONS
    WWV_FLOW_WS_APP_SUG_OBJECTS
    WWV_FLOW_WS_COL_VALIDATIONS
    WWV_FLOW_WS_CONSTRAINTS
    WWV_FLOW_WS_CUSTOM_AUTH_SETUPS
    WWV_FLOW_WS_IMPORT_API
    WWV_FLOW_WS_INDEXES
    WWV_FLOW_WS_IND_COLUMNS
    WWV_FLOW_WS_OPERATIONS
    WWV_FLOW_WS_PARAMETERS
    WWV_FLOW_WS_PROCESS_PARMS_MAP
    WWV_FLOW_WS_TABLES
    WWV_FLOW_WS_TAB_COLUMNS
    WWV_FLOW_WS_TRIGGERS
    WWV_FLOW_WS_WEBPAGES
    WWV_FLOW_WS_WEBSHEET_ATTR
    WWV_FLOW_YEARS
    WWV_FLOW_YEARS
    WWV_MIG_ACCESS
    WWV_MIG_ACC_COLUMNS
    WWV_MIG_ACC_FORMS
    WWV_MIG_ACC_FORMS_CONTROLS
    WWV_MIG_ACC_FORMS_MODULES
    WWV_MIG_ACC_FORMS_PERM
    WWV_MIG_ACC_GROUPS
    WWV_MIG_ACC_GRPSMEMBERS
    WWV_MIG_ACC_INDEXES
    WWV_MIG_ACC_INDEXES_COLS
    WWV_MIG_ACC_LOAD
    WWV_MIG_ACC_MODULES
    WWV_MIG_ACC_MODULES_PERM
    WWV_MIG_ACC_PAGES
    WWV_MIG_ACC_QUERIES
    WWV_MIG_ACC_RELATIONS
    WWV_MIG_ACC_RELATION_COLS
    WWV_MIG_ACC_REPORTS
    WWV_MIG_ACC_RPTS_CONTROLS
    WWV_MIG_ACC_RPTS_MODULES
    WWV_MIG_ACC_RPT_PERMS
    WWV_MIG_ACC_TABLES
    WWV_MIG_ACC_TAB_PERM
    WWV_MIG_ACC_USERS
    WWV_MIG_EXPORTER
    WWV_MIG_FORMS
    WWV_MIG_FRM_ALERTS
    WWV_MIG_FRM_ATTACHEDLIBRARY
    WWV_MIG_FRM_BLK_DSA
    WWV_MIG_FRM_BLK_DSC
    WWV_MIG_FRM_BLK_ITEMS
    WWV_MIG_FRM_BLK_ITEM_LIE
    WWV_MIG_FRM_BLK_ITEM_RADIO
    WWV_MIG_FRM_BLK_ITEM_TRIGGERS
    WWV_MIG_FRM_BLK_RELATIONS
    WWV_MIG_FRM_BLK_TRIGGERS
    WWV_MIG_FRM_BLOCKS
    WWV_MIG_FRM_CANVAS
    WWV_MIG_FRM_CNVG_COMPOUNDTEXT
    WWV_MIG_FRM_CNVS_GRAPHICS
    WWV_MIG_FRM_CNVS_TABPAGE
    WWV_MIG_FRM_COORDINATES
    WWV_MIG_FRM_CPDTXT_TEXTSEGMENT
    WWV_MIG_FRM_EDITOR
    WWV_MIG_FRM_FMB_MENU
    WWV_MIG_FRM_FMB_MENUITEM_ROLE
    WWV_MIG_FRM_FMB_MENU_MENUITEM
    WWV_MIG_FRM_FORMMODULES
    WWV_MIG_FRM_LOV
    WWV_MIG_FRM_LOVCOLUMNMAPPING
    WWV_MIG_FRM_MENU
    WWV_MIG_FRM_MENUITEM_ROLE
    WWV_MIG_FRM_MENUS
    WWV_MIG_FRM_MENUSMODULEROLES
    WWV_MIG_FRM_MENUS_MENUMODULES
    WWV_MIG_FRM_MENUS_MODULES
    WWV_MIG_FRM_MENUS_PROGRAMUNIT
    WWV_MIG_FRM_MENU_MENUITEM
    WWV_MIG_FRM_MODULEPARAMETER
    WWV_MIG_FRM_MODULES
    WWV_MIG_FRM_OBJECTGROUP
    WWV_MIG_FRM_OBJECTGROUPCHILD
    WWV_MIG_FRM_OLB_XMLTAGTABLEMAP
    WWV_MIG_FRM_PROGRAMUNIT
    WWV_MIG_FRM_PROPERTYCLASS
    WWV_MIG_FRM_RECORDGROUPCOLUMN
    WWV_MIG_FRM_RECORDGROUPS
    WWV_MIG_FRM_REPORT
    WWV_MIG_FRM_REV_APEX_APP
    WWV_MIG_FRM_REV_BLK_ITEMS
    WWV_MIG_FRM_REV_BLOCKS
    WWV_MIG_FRM_REV_FORMMODULES
    WWV_MIG_FRM_REV_LOV
    WWV_MIG_FRM_REV_LOVCOLMAPS
    WWV_MIG_FRM_TRIGGERS
    WWV_MIG_FRM_VISUALATTRIBUTES
    WWV_MIG_FRM_WINDOWS
    WWV_MIG_FRM_XMLTAGTABLEMAP
    WWV_MIG_GENERATED_APPLICATIONS
    WWV_MIG_MENU_XMLTAGTABLEMAP
    WWV_MIG_OLB
    WWV_MIG_OLB_BLK_DATASOURCECOL
    WWV_MIG_OLB_BLK_ITEM
    WWV_MIG_OLB_BLK_ITEM_LIE
    WWV_MIG_OLB_BLK_ITEM_TRIGGER
    WWV_MIG_OLB_BLK_TRIGGER
    WWV_MIG_OLB_BLOCK
    WWV_MIG_OLB_CANVAS
    WWV_MIG_OLB_CG_COMPOUNDTEXT
    WWV_MIG_OLB_CG_CT_TEXTSEGMENT
    WWV_MIG_OLB_CNVS_GRAPHICS
    WWV_MIG_OLB_MODULES
    WWV_MIG_OLB_OBJECTLIBRARY
    WWV_MIG_OLB_OBJECTLIBRARYTAB
    WWV_MIG_OLB_OLT_ALERT
    WWV_MIG_OLB_OLT_BLK_ITEM
    WWV_MIG_OLB_OLT_BLK_ITEM_TRIGR
    WWV_MIG_OLB_OLT_BLOCK
    WWV_MIG_OLB_OLT_CANVAS
    WWV_MIG_OLB_OLT_CNVS_GRAPHICS
    WWV_MIG_OLB_OLT_GRAPHICS
    WWV_MIG_OLB_OLT_ITEM
    WWV_MIG_OLB_OLT_MENU
    WWV_MIG_OLB_OLT_MENU_MENUITEM
    WWV_MIG_OLB_OLT_OBJECTGROUP
    WWV_MIG_OLB_OLT_OB_OBJGRPCHILD
    WWV_MIG_OLB_OLT_REPORT
    WWV_MIG_OLB_OLT_TABPAGE
    WWV_MIG_OLB_OLT_TABPG_GRAPHICS
    WWV_MIG_OLB_OLT_VISUALATTRBUTE
    WWV_MIG_OLB_OLT_WINDOW
    WWV_MIG_OLB_PROGRAMUNIT
    WWV_MIG_OLB_PROPERTYCLASS
    WWV_MIG_OLB_T_TP_GGGGG_CPDTXT
    WWV_MIG_OLB_T_TP_GGGGG_CT_TXST
    WWV_MIG_OLB_T_TP_GGGG_CPDTXT
    WWV_MIG_OLB_T_TP_GGGG_CT_TXSGT
    WWV_MIG_OLB_T_TP_GGGG_GRAPHICS
    WWV_MIG_OLB_T_TP_GGG_CPDTXT
    WWV_MIG_OLB_T_TP_GGG_CT_TXTSGT
    WWV_MIG_OLB_T_TP_GGG_GRAPHICS
    WWV_MIG_OLB_T_TP_GG_CPDTXT
    WWV_MIG_OLB_T_TP_GG_CT_TXTSGT
    WWV_MIG_OLB_T_TP_GG_GRAPHICS
    WWV_MIG_OLB_T_TP_G_GRAPHICS
    WWV_MIG_OLB_VISUALATTRIBUTE
    WWV_MIG_OLB_WINDOW
    WWV_MIG_PLSQL_LIBS
    WWV_MIG_PROJECTS
    WWV_MIG_PROJECT_COMPONENTS
    WWV_MIG_PROJECT_TRIGGERS
    WWV_MIG_REPORT
    WWV_MIG_RESERVED_WORDS
    WWV_MIG_REV_APEXAPP
    WWV_MIG_REV_FORMS
    WWV_MIG_REV_QUERIES
    WWV_MIG_REV_REPORTS
    WWV_MIG_REV_TABLES
    WWV_MIG_RPTS
    WWV_MIG_RPT_DATA
    WWV_MIG_RPT_DATASRC
    WWV_MIG_RPT_DATASRC_GRP
    WWV_MIG_RPT_DATASRC_SELECT
    WWV_MIG_RPT_DATA_SUMMARY
    WWV_MIG_RPT_GRP_DATAITEM
    WWV_MIG_RPT_GRP_DATAITEM_DESC
    WWV_MIG_RPT_GRP_DATAITEM_PRIV
    WWV_MIG_RPT_GRP_FIELD
    WWV_MIG_RPT_GRP_FILTER
    WWV_MIG_RPT_GRP_FORMULA
    WWV_MIG_RPT_GRP_ROWDELIM
    WWV_MIG_RPT_GRP_SUMMARY
    WWV_MIG_RPT_REPORTPRIVATE
    WWV_MIG_RPT_XMLTAGTABLEMAP
    WWV_MULTI_COMPONENT_EXPORT
    WWV_PURGE_DATAFILES
    WWV_PURGE_EMAILS
    WWV_PURGE_LOG
    WWV_PURGE_SCHEMAS
    WWV_PURGE_WORKSPACES
    WWV_PURGE_WORKSPACE_RESPONSES
    WWV_RENDER_CALENDAR2
    WWV_RENDER_CHART2
    WWV_SEQ
    WWV_SEQ
    X$NM5BJT3IMF39A5CV0G7518CKTJMM
    X$PT5BJT3IMF39A5CV0G7518CKTJMM
    X$QN5BJT3IMF39A5CV0G7518CKTJMM
    XDB$ACL
    XDB$ALL_MODEL
    XDB$ANY
    XDB$ANYATTR
    XDB$ATTRGROUP_DEF
    XDB$ATTRGROUP_REF
    XDB$ATTRIBUTE
    XDB$CHECKOUTS
    XDB$CHOICE_MODEL
    XDB$COLUMN_INFO
    XDB$COMPLEX_TYPE
    XDB$CONFIG
    XDB$DXPTAB
    XDB$D_LINK
    XDB$ELEMENT
    XDB$GROUP_DEF
    XDB$GROUP_REF
    XDB$H_INDEX
    XDB$H_LINK
    XDB$MOUNTS
    XDB$NAMESUFF_SEQ
    XDB$NLOCKS
    XDB$NONCEKEY
    XDB$PATH_INDEX_PARAMS
    XDB$PROPNUM_SEQ
    XDB$RCLIST_V
    XDB$REPOS
    XDB$RESCONFIG
    XDB$RESOURCE
    XDB$ROOT_INFO
    XDB$SCHEMA
    XDB$SEQUENCE_MODEL
    XDB$SIMPLE_TYPE
    XDB$STATS
    XDB$STRING_LIST_T
    XDB$TTSET
    XDB$TYPEID_SEQ
    XDB$WORKSPACE
    XDB$XDB_READY
    XDB$XIDX_IMP_T
    XDB$XIDX_PARAM_T
    XDB$XTAB
    XDB$XTABCOLS
    XDB$XTABNMSP
    XDBACL_PATH_TAB
    XDBURITYPE
    XDB_INSTALLATION_TAB
    XDB_PVTRIG_PKG
    XDB_RVTRIG_PKG
    XDS_ACE
    XDS_ACE
    XDS_ACL
    XDS_ACL
    XIMETADATA_PKG
    XMLAGG
    XMLBINARYINPUTSTREAM
    XMLBINARYOUTPUTSTREAM
    XMLCHARACTERINPUTSTREAM
    XMLCHARACTEROUTPUTSTREAM
    XMLDOM
    XMLDOM
    XMLFORMAT
    XMLPARSER
    XMLPARSER
    XMLSEQUENCE
    XMLSEQUENCETYPE
    XMLTYPE
    XQSEQUENCE
    XQWINDOWSEQUENCE
    XS$CACHE_ACTIONS
    XS$CACHE_ACTIONS
    XS$CACHE_DELETE
    XS$CACHE_DELETE
    XS$DATA_SECURITY
    XS$PARAMETERS
    XS$PRINCIPALS
    XS$ROLESETS
    XS$SECURITYCLASS
    XS$SESSIONS
    XS$SESSION_APPNS
    XS$SESSION_ROLES
    XS$VERIFIERS
    XSLPROCESSOR
    XSLPROCESSOR
    XSPARAM_REG_SEQUENCE$
    XSTREAM$_DDL_CONFLICT_HANDLER
    XSTREAM$_DML_CONFLICT_HANDLER
    XSTREAM$_MAP
    XSTREAM$_PARAMETERS
    XSTREAM$_SERVER
    XSTREAM$_SERVER_CONNECTION
    XSTREAM$_SUBSET_RULES
    XSTREAM$_SYSGEN_OBJS
    XS_SESSION_ROLES
    XS_SESSION_ROLES
    Z
    _ALL_FILE_GROUPS
    _ALL_FILE_GROUP_EXPORT_INFO
    _ALL_FILE_GROUP_FILES
    _ALL_FILE_GROUP_TABLES
    _ALL_FILE_GROUP_TABLESPACES
    _ALL_FILE_GROUP_VERSIONS
    _ALL_INSTANTIATION_DDL
    _ALL_INSTANTIATION_DDL
    _ALL_REPCOLUMN
    _ALL_REPCOLUMN_GROUP
    _ALL_REPCONFLICT
    _ALL_REPEXTENSIONS
    _ALL_REPEXTENSIONS
    _ALL_REPFLAVOR_OBJECTS
    _ALL_REPGROUPED_COLUMN
    _ALL_REPPARAMETER_COLUMN
    _ALL_REPRESOLUTION
    _ALL_REPSITES_NEW
    _ALL_REPSITES_NEW
    _ALL_SQLSET_STATEMENTS_ONLY
    _ALL_SQLSET_STATEMENTS_ONLY
    _ALL_SQLSET_STATEMENTS_PHV
    _ALL_SQLSET_STATEMENTS_PHV
    _ALL_SQLSET_STATISTICS_ONLY
    _ALL_SQLSET_STATISTICS_ONLY
    ACCESS$
    ALERT_QT
    APPLY$_CHANGE_HANDLERS
    APPLY$_CONF_HDLR_COLUMNS
    APPLY$_CONSTRAINT_COLUMNS
    APPLY$_DEST_OBJ
    APPLY$_DEST_OBJ_CMAP
    APPLY$_DEST_OBJ_ID
    APPLY$_DEST_OBJ_OPS
    APPLY$_ERROR
    APPLY$_ERROR_HANDLER
    APPLY$_ERROR_HANDLER_SEQUENCE
    APPLY$_ERROR_TXN
    APPLY$_SOURCE_OBJ
    APPLY$_SOURCE_OBJ_ID
    APPLY$_SOURCE_SCHEMA
    APPLY$_VIRTUAL_OBJ_CONS
    APPROLE$
    APP_ROLE_MEMBERSHIP
    APP_USERS_AND_ROLES
    AQ$ALERT_QT
    AQ$ALERT_QT_R
    AQ$ALERT_QT_S
    AQ$AQ$_MEM_MC
    AQ$AQ$_MEM_MC_S
    AQ$AQ_EVENT_TABLE
    AQ$AQ_PROP_TABLE
    AQ$AQ_PROP_TABLE_R
    AQ$AQ_PROP_TABLE_S
    AQ$DEF$_AQCALL
    AQ$DEF$_AQERROR
    AQ$KUPC$DATAPUMP_QUETAB
    AQ$KUPC$DATAPUMP_QUETAB_S
    AQ$SCHEDULER$_EVENT_QTAB
    AQ$SCHEDULER$_EVENT_QTAB_R
    AQ$SCHEDULER$_EVENT_QTAB_S
    AQ$SCHEDULER$_REMDB_JOBQTAB
    AQ$SCHEDULER$_REMDB_JOBQTAB_R
    AQ$SCHEDULER$_REMDB_JOBQTAB_S
    AQ$SCHEDULER_FILEWATCHER_QT
    AQ$SCHEDULER_FILEWATCHER_QT_R
    AQ$SCHEDULER_FILEWATCHER_QT_S
    AQ$SYS$SERVICE_METRICS_TAB
    AQ$SYS$SERVICE_METRICS_TAB_R
    AQ$SYS$SERVICE_METRICS_TAB_S
    AQ$_ALERT_QT_F
    AQ$_ALERT_QT_G
    AQ$_ALERT_QT_H
    AQ$_ALERT_QT_I
    AQ$_ALERT_QT_L
    AQ$_ALERT_QT_N
    AQ$_ALERT_QT_S
    AQ$_ALERT_QT_T
    AQ$_AQ$_MEM_MC_F
    AQ$_AQ$_MEM_MC_G
    AQ$_AQ$_MEM_MC_H
    AQ$_AQ$_MEM_MC_I
    AQ$_AQ$_MEM_MC_L
    AQ$_AQ$_MEM_MC_N
    AQ$_AQ$_MEM_MC_S
    AQ$_AQ$_MEM_MC_T
    AQ$_AQ_EVENT_TABLE_F
    AQ$_AQ_PROP_TABLE_F
    AQ$_AQ_PROP_TABLE_G
    AQ$_AQ_PROP_TABLE_H
    AQ$_AQ_PROP_TABLE_I
    AQ$_AQ_PROP_TABLE_L
    AQ$_AQ_PROP_TABLE_N
    AQ$_AQ_PROP_TABLE_S
    AQ$_AQ_PROP_TABLE_T
    AQ$_CHAINSEQ
    AQ$_DEF$_AQCALL_F
    AQ$_DEF$_AQERROR_F
    AQ$_INTERNET_AGENTS
    AQ$_INTERNET_AGENT_PRIVS
    AQ$_IOTENQTXID
    AQ$_KUPC$DATAPUMP_QUETAB_F
    AQ$_KUPC$DATAPUMP_QUETAB_G
    AQ$_KUPC$DATAPUMP_QUETAB_H
    AQ$_KUPC$DATAPUMP_QUETAB_I
    AQ$_KUPC$DATAPUMP_QUETAB_L
    AQ$_KUPC$DATAPUMP_QUETAB_N
    AQ$_KUPC$DATAPUMP_QUETAB_S
    AQ$_KUPC$DATAPUMP_QUETAB_T
    AQ$_MEM_MC
    AQ$_MESSAGE_TYPES
    AQ$_NONDURSUB_SEQUENCE
    AQ$_PENDING_MESSAGES
    AQ$_PROPAGATION_SEQUENCE
    AQ$_PROPAGATION_STATUS
    AQ$_PUBLISHER
    AQ$_PUBLISHER_SEQUENCE
    AQ$_QUEUES
    AQ$_QUEUE_STATISTICS
    AQ$_QUEUE_TABLES
    AQ$_QUEUE_TABLE_AFFINITIES
    AQ$_REPLAY_INFO
    AQ$_RULE_SEQUENCE
    AQ$_RULE_SET_SEQUENCE
    AQ$_SCHEDULER$_EVENT_QTAB_F
    AQ$_SCHEDULER$_EVENT_QTAB_G
    AQ$_SCHEDULER$_EVENT_QTAB_H
    AQ$_SCHEDULER$_EVENT_QTAB_I
    AQ$_SCHEDULER$_EVENT_QTAB_L
    AQ$_SCHEDULER$_EVENT_QTAB_N
    AQ$_SCHEDULER$_EVENT_QTAB_S
    AQ$_SCHEDULER$_EVENT_QTAB_T
    AQ$_SCHEDULER$_REMDB_JOBQTAB_F
    AQ$_SCHEDULER$_REMDB_JOBQTAB_G
    AQ$_SCHEDULER$_REMDB_JOBQTAB_H
    AQ$_SCHEDULER$_REMDB_JOBQTAB_I
    AQ$_SCHEDULER$_REMDB_JOBQTAB_L
    AQ$_SCHEDULER$_REMDB_JOBQTAB_N
    AQ$_SCHEDULER$_REMDB_JOBQTAB_S
    AQ$_SCHEDULER$_REMDB_JOBQTAB_T
    AQ$_SCHEDULER_FILEWATCHER_QT_F
    AQ$_SCHEDULER_FILEWATCHER_QT_G
    AQ$_SCHEDULER_FILEWATCHER_QT_H
    AQ$_SCHEDULER_FILEWATCHER_QT_I
    AQ$_SCHEDULER_FILEWATCHER_QT_L
    AQ$_SCHEDULER_FILEWATCHER_QT_N
    AQ$_SCHEDULER_FILEWATCHER_QT_S
    AQ$_SCHEDULER_FILEWATCHER_QT_T
    AQ$_SCHEDULES
    AQ$_SUBSCRIBER_TABLE
    AQ$_SYS$SERVICE_METRICS_TAB_F
    AQ$_SYS$SERVICE_METRICS_TAB_G
    AQ$_SYS$SERVICE_METRICS_TAB_H
    AQ$_SYS$SERVICE_METRICS_TAB_I
    AQ$_SYS$SERVICE_METRICS_TAB_L
    AQ$_SYS$SERVICE_METRICS_TAB_N
    AQ$_SYS$SERVICE_METRICS_TAB_S
    AQ$_SYS$SERVICE_METRICS_TAB_T
    AQ$_TRANS_SEQUENCE
    AQ_EVENT_TABLE
    AQ_PROP_TABLE
    ARGUMENT$
    ASSEMBLY$
    ASSOCIATION$
    ATEMPTAB$
    ATTRCOL$
    ATTRIBUTE$
    ATTRIBUTE_TRANSFORMATIONS$
    AUD$
    AUDIT$
    AUDSES$
    AUX_STATS$
    AW$
    AWLOGSEQ$
    AWRBL_DETAILS_TYPE
    AWRBL_DETAILS_TYPE_TABLE
    AWRBL_METRIC_TYPE
    AWRBL_METRIC_TYPE_TABLE
    AWRRPT_INSTANCE_LIST_TYPE
    AWR_OBJECT_INFO_TABLE_TYPE
    AWR_OBJECT_INFO_TYPE
    AWSEQ$
    AW_OBJ$
    AW_PRG$
    AW_PROP$
    AW_TRACK$
    Animation3d235_TAB
    BLASTN_ALIGN
    BLASTN_COMPRESS
    BLASTN_MATCH
    BLASTP_ALIGN
    BLASTP_MATCH
    BOOTSTRAP$
    CACHE_STATS_0$
    CACHE_STATS_1$
    CACHE_STATS_SEQ_0
    CACHE_STATS_SEQ_1
    CCOL$
    CDC_CHANGE_COLUMNS$
    CDC_CHANGE_SETS$
    CDC_CHANGE_SOURCES$
    CDC_CHANGE_TABLES$
    CDC_PROPAGATED_SETS$
    CDC_PROPAGATIONS$
    CDC_RSID_SEQ$
    CDC_SUBSCRIBED_COLUMNS$
    CDC_SUBSCRIBED_TABLES$
    CDC_SUBSCRIBERS$
    CDC_SUBSCRIBE_SEQ$
    CDC_SYSTEM$
    CDEF$
    CHNF$_CLAUSEID_SEQ
    CHNF$_CLAUSES
    CHNF$_CLAUSE_DEPENDENTS
    CHNF$_GROUP_FILTER_IOT
    CHNF$_QUERIES
    CHNF$_QUERYID_SEQ
    CHNF$_QUERY_BINDS
    CHNF$_QUERY_DELTAS
    CHNF$_QUERY_DEPENDENCIES
    CHNF$_QUERY_OBJECT
    CHNF$_REG_QUERIES
    CHNFDIRECTLOAD$
    CLIENTID_SEQUENCE
    CLIENT_RESULT_CACHE_STATS$
    CODE_PIECES
    CODE_SIZE
    COM$
    COMPARISON$
    COMPARISON_COL$
    COMPARISON_ROW_DIF$
    COMPARISON_SCAN$
    COMPARISON_SCAN_SEQ$
    COMPARISON_SCAN_VAL$
    COMPARISON_SEQ$
    COMPRESSION$
    CON$
    COUNTRIES
    CPOOL$
    CQ_NOTIFICATION$_DESCRIPTOR
    CQ_NOTIFICATION$_QUERY
    CQ_NOTIFICATION$_QUERY_ARRAY
    CQ_NOTIFICATION$_REG_INFO
    CQ_NOTIFICATION$_ROW
    CQ_NOTIFICATION$_ROW_ARRAY
    CQ_NOTIFICATION$_TABLE
    CQ_NOTIFICATION$_TABLE_ARRAY
    CRC$_RESULT_CACHE_STATS
    CRCSTATS_$
    CTX_AUTO_OPTIMIZE_INDEXES
    CTX_AUTO_OPTIMIZE_STATUS
    CTX_CENTROIDS
    CTX_ENTITY
    CTX_EXTRACT_POLICIES
    CTX_EXTRACT_POLICY_VALUES
    CTX_FILTER_BY_COLUMNS
    CTX_INDEXES
    CTX_INDEX_ERRORS
    CTX_INDEX_OBJECTS
    CTX_INDEX_PARTITIONS
    CTX_INDEX_SUB_LEXERS
    CTX_INDEX_SUB_LEXER_VALUES
    CTX_INDEX_VALUES
    CTX_ORDER_BY_COLUMNS
    CTX_PENDING
    CTX_TREE
    CTX_USER_AUTO_OPTIMIZE_INDEXES
    CTX_USER_EXTRACT_POLICIES
    CTX_USER_EXTRACT_POLICY_VALUES
    CTX_USER_EXTRACT_RULES
    CTX_USER_EXTRACT_STOP_ENTITIES
    CTX_USER_FILTER_BY_COLUMNS
    CTX_USER_ORDER_BY_COLUMNS
    CTX_USER_SESSION_SQES
    CTX_VERSION
    CUBE_TABLE
    DAM_CLEANUP_EVENTS$
    DAM_CLEANUP_JOBS$
    DAM_CLEANUP_SEQ$
    DAM_CONFIG_PARAM$
    DAM_LAST_ARCH_TS$
    DAM_PARAM_TAB$
    DATABASE_EXPORT_PATHS
    DATAPUMP_DIR_OBJS
    DBFS$_MOUNTS
    DBFS$_STATS
    DBFS$_STORES
    DBFS_CONTENT
    DBFS_CONTENT_PROPERTIES
    DBFS_HS$_ARCHIVEREFIDSEQ
    DBFS_HS$_BACKUPFILEIDSEQ
    DBFS_HS$_BACKUPFILETABLE
    DBFS_HS$_CONTENTFNMAPTBL
    DBFS_HS$_FS
    DBFS_HS$_POLICYIDSEQ
    DBFS_HS$_PROPERTY
    DBFS_HS$_RSEQ
    DBFS_HS$_SFLOCATORTABLE
    DBFS_HS$_STORECOMMANDS
    DBFS_HS$_STOREID2POLICYCTX
    DBFS_HS$_STOREIDSEQ
    DBFS_HS$_STOREIDTABLE
    DBFS_HS$_STOREPROPERTIES
    DBFS_HS$_TARBALLSEQ
    DBFS_SFS$_FS
    DBFS_SFS$_FSSEQ
    DBFS_SFS$_FST
    DBFS_SFS$_FSTO
    DBFS_SFS$_FSTP
    DBFS_SFS$_SNAP
    DBFS_SFS$_TAB
    DBFS_SFS$_VOL
    DEF$_AQCALL
    DEF$_AQERROR
    DEF$_CALLDEST
    DEF$_DEFAULTDEST
    DEF$_DESTINATION
    DEF$_ERROR
    DEF$_LOB
    DEF$_ORIGIN
    DEF$_PROPAGATOR
    DEF$_PUSHED_TRANSACTIONS
    DEF$_SCHEDULE
    DEFAULT_PWD$
    DEFERRED_STG$
    DEFROLE$
    DEFSUBPART$
    DEFSUBPARTLOB$
    DEPARTMENTS
    DEPARTMENTS_SEQ
    DEPENDENCY$
    DIANA_VERSION$
    DIM$
    DIMATTR$
    DIMJOINKEY$
    DIMLEVEL$
    DIMLEVELKEY$
    DIR$
    DIR$ALERT_HISTORY
    DIR$DATABASE_ATTRIBUTES
    DIR$ESCALATE_OPERATIONS
    DIR$INSTANCE_ACTIONS
    DIR$MIGRATE_OPERATIONS
    DIR$NODE_ATTRIBUTES
    DIR$QUIESCE_OPERATIONS
    DIR$REASON_STRINGS
    DIR$RESONATE_OPERATIONS
    DIR$SERVICE_ATTRIBUTES
    DIR$SERVICE_OPERATIONS
    DIR$VICTIM_POLICY
    DISK_AND_FIXED_OBJECTS
    DM$EXPIMP_ID_SEQ
    DMBGOS
    DMP_SYS
    DM_ABN_DETAIL
    DM_ABN_DETAILS
    DM_CENTROID
    DM_CENTROIDS
    DM_CHILD
    DM_CHILDREN
    DM_CLUSTER
    DM_CLUSTERS
    DM_CL_APPLY
    DM_CONDITIONAL
    DM_CONDITIONALS
    DM_COST_ELEMENT
    DM_COST_MATRIX
    DM_GLM_BUILD
    DM_GLM_COEFF
    DM_GLM_COEFF_SET
    DM_HISTOGRAMS
    DM_HISTOGRAM_BIN
    DM_ITEM
    DM_ITEMS
    DM_ITEMSET
    DM_ITEMSETS
    DM_MODEL_GLOBAL_DETAIL
    DM_MODEL_GLOBAL_DETAILS
    DM_MODEL_SETTING
    DM_MODEL_SETTINGS
    DM_MODEL_SIGNATURE
    DM_MODEL_SIGNATURE_ATTRIBUTE
    DM_MOD_BUILD
    DM_NB_DETAIL
    DM_NB_DETAILS
    DM_NESTED_CATEGORICAL
    DM_NESTED_CATEGORICALS
    DM_NESTED_NUMERICAL
    DM_NESTED_NUMERICALS
    DM_NMF_ATTRIBUTE
    DM_NMF_ATTRIBUTE_SET
    DM_NMF_BUILD
    DM_NMF_FEATURE
    DM_NMF_FEATURE_SET
    DM_PREDICATE
    DM_PREDICATES
    DM_RANKED_ATTRIBUTE
    DM_RANKED_ATTRIBUTES
    DM_RULE
    DM_RULES
    DM_SVM_ATTRIBUTE
    DM_SVM_ATTRIBUTE_SET
    DM_SVM_LINEAR_COEFF
    DM_SVM_LINEAR_COEFF_SET
    DM_TRANSFORM
    DM_TRANSFORMS
    DM_USER_MODELS
    DOCUMENT_LINKS
    DOCUMENT_LINKS2
    DR$ACTIVELOGS
    DR$AUTOOPT
    DR$CLASS
    DR$DBO
    DR$DELETE
    DR$FEATURE_USED
    DR$FREQTOKS
    DR$INDEX
    DR$INDEX_CDI_COLUMN
    DR$INDEX_ERROR
    DR$INDEX_OBJECT
    DR$INDEX_PARTITION
    DR$INDEX_SET
    DR$INDEX_SET_INDEX
    DR$INDEX_VALUE
    DR$NVTAB
    DR$OBJECT
    DR$OBJECT_ATTRIBUTE
    DR$OBJECT_ATTRIBUTE_LOV
    DR$ONLINE_PENDING
    DR$PARALLEL
    DR$PARAMETER
    DR$PENDING
    DR$PREFERENCE
    DR$PREFERENCE_VALUE
    DR$SDATA_UPDATE
    DR$SECTION
    DR$SECTION_GROUP
    DR$SLOWQRYS
    DR$SQE
    DR$STATS
    DR$STOPLIST
    DR$STOPWORD
    DR$SUB_LEXER
    DR$THS
    DR$THS_BT
    DR$THS_FPHRASE
    DR$THS_PHRASE
    DR$TREE
    DR$UNINDEXED
    DR$USER_EXTRACT_ENTDICT
    DR$USER_EXTRACT_RULE
    DR$USER_EXTRACT_STOP_ENTITY
    DR$USER_EXTRACT_TKDICT
    DR$WAITING
    DRV$AUTOOPT
    DRV$SDATA_UPDATE
    DRV$SDATA_UPDATE2
    DRV$TREE
    DRV$USER_EXTRACT_ENTDICT
    DRV$USER_EXTRACT_RULE
    DRV$USER_EXTRACT_STOP_ENTITY
    DRV$USER_EXTRACT_TKDICT
    DR_ID_SEQ
    DST$AFFECTED_TABLES
    DST$ERROR_TABLE
    DST$TRIGGER_TABLE
    DUC$
    DefaultStyle218_TAB
    ECOL$
    EDITION$
    EMPLOYEES
    EMPLOYEES_SEQ
    EMP_DETAILS_VIEW
    ENC$
    EPG$_AUTH
    EPSG_PARAM
    EPSG_PARAMS
    ERROR$
    ERROR_SIZE
    EV$
    EVCOL$
    EXPACT$
    EXPDEPACT$
    EXPDEPOBJ$
    EXPGETMAPOBJ
    EXPIMP_TTS_CT$
    EXPMAPIOT
    EXPPIOTMAP
    EXPPKGACT$
    EXPPKGOBJ$
    EXPXSLDELIM
    EXTERNAL_LOCATION$
    EXTERNAL_TAB$
    EXU102XTYP
    EXU102XTYPU
    EXU10ASC
    EXU10ASCU
    EXU10CCL
    EXU10CCLO
    EXU10CCLU
    EXU10COE
    EXU10COEU
    EXU10LNK
    EXU10LNKU
    EXU10NTA
    EXU10NTAROLE
    EXU10SNAP
    EXU10SNAPI
    EXU10SNAPL
    EXU10SNAPLC
    EXU10SNAPLI
    EXU10SNAPLU
    EXU10SNAPU
    EXU10TAB
    EXU10TABS
    EXU10TABSU
    EXU10TABU
    EXU10USCI
    EXU10USCIU
    EXU112DLOB
    EXU112DLOBU
    EXU11IND
    EXU11IND_BASE
    EXU11SNAP
    EXU11SNAPI
    EXU11SNAPU
    EXU11XML
    EXU816CTX
    EXU816SQV
    EXU816TCTX
    EXU816TGR
    EXU816TGRC
    EXU816TGRI
    EXU816TGRIC
    EXU816TGRU
    EXU81APPROLE
    EXU81CTX
    EXU81DOI
    EXU81DOIU
    EXU81FIL
    EXU81ITY
    EXU81ITYC
    EXU81ITYI
    EXU81ITYU
    EXU81IXCP
    EXU81IXCPU
    EXU81IXSP
    EXU81IXSPU
    EXU81LBCP
    EXU81LBCPU
    EXU81LBP
    EXU81LBPU
    EXU81LBSP
    EXU81LBSPU
    EXU81OBJ
    EXU81OBJECTPKG
    EXU81OPR
    EXU81OPRC
    EXU81OPRI
    EXU81OPRU
    EXU81PLB
    EXU81PLBU
    EXU81PSTC
    EXU81PSTI
    EXU81REFC
    EXU81REFI
    EXU81RGC
    EXU81RGCU
    EXU81RGS
    EXU81RGSU
    EXU81SCM
    EXU81SCMU
    EXU81SLFC
    EXU81SLFCU
    EXU81SNAP
    EXU81SNAPC
    EXU81SNAPI
    EXU81SNAPL
    EXU81SNAPLC
    EXU81SNAPLI
    EXU81SNAPLU
    EXU81SNAPU
    EXU81SPOK
    EXU81SPOKI
    EXU81SPOKIU
    EXU81SPOKU
    EXU81SRT
    EXU81SRTU
    EXU81TAB
    EXU81TABC
    EXU81TABI
    EXU81TABS
    EXU81TABSU
    EXU81TABU
    EXU81TBCP
    EXU81TBCPU
    EXU81TBS
    EXU81TBSP
    EXU81TBSPU
    EXU81TGR
    EXU81TGRC
    EXU81TGRI
    EXU81TGRIC
    EXU81TGRU
    EXU81TNTC
    EXU81TNTI
    EXU81TTS
    EXU81TYP
    EXU81TYPU
    EXU81USCI
    EXU81USCIU
    EXU8ASC
    EXU8ASCU
    EXU8AUD
    EXU8CCL
    EXU8CCLO
    EXU8CCLU
    EXU8CCO
    EXU8CCOU
    EXU8CGR
    EXU8CGRU
    EXU8CLU
    EXU8CLUC
    EXU8CLUI
    EXU8CLUU
    EXU8CMT
    EXU8CMTU
    EXU8COE
    EXU8COEU
    EXU8COL
    EXU8COLNN
    EXU8COLU
    EXU8COL_TEMP
    EXU8COL_TEMP_TTS_UNUSED_COL
    EXU8COL_TTS_UNUSED_COL
    EXU8CON
    EXU8CONU
    EXU8COO
    EXU8COOU
    EXU8CSN
    EXU8CSNU
    EXU8DEL
    EXU8DELSNAP
    EXU8DELSNAPL
    EXU8DFR
    EXU8DIR
    EXU8ERC
    EXU8FIL
    EXU8FPT
    EXU8FPTU
    EXU8GRN
    EXU8GRNU
    EXU8GRS
    EXU8HST
    EXU8HSTU
    EXU8IND
    EXU8INDC
    EXU8INDI
    EXU8INDIC
    EXU8INDU
    EXU8INK
    EXU8INKU
    EXU8IOV
    EXU8IOVU
    EXU8IXP
    EXU8IXPU
    EXU8JBQ
    EXU8JBQU
    EXU8LIB
    EXU8LIBU
    EXU8LNK
    EXU8LNKU
    EXU8LOB
    EXU8LOBU
    EXU8NTB
    EXU8NTBU
    EXU8NXP
    EXU8NXPU
    EXU8OID
    EXU8OIDU
    EXU8PDS
    EXU8PDSU
    EXU8PHS
    EXU8PNT
    EXU8PNTU
    EXU8POK
    EXU8POKI
    EXU8POKIU
    EXU8POKU
    EXU8PRF
    EXU8PRR
    EXU8PST
    EXU8PSTC
    EXU8PSTI
    EXU8PSTIC
    EXU8PSTU
    EXU8PVF
    EXU8REF
    EXU8REFC
    EXU8REFI
    EXU8REFIC
    EXU8REFU
    EXU8RFS
    EXU8RFSU
    EXU8RGC
    EXU8RGCU
    EXU8RGS
    EXU8RGSU
    EXU8RIF
    EXU8RLG
    EXU8ROL
    EXU8RSG
    EXU8SCM
    EXU8SCMU
    EXU8SEQ
    EXU8SEQU
    EXU8SLFC
    EXU8SLFCU
    EXU8SLOG
    EXU8SLOGU
    EXU8SNAP
    EXU8SNAPC
    EXU8SNAPI
    EXU8SNAPL
    EXU8SNAPLC
    EXU8SNAPLI
    EXU8SNAPLU
    EXU8SNAPU
    EXU8SPR
    EXU8SPRC
    EXU8SPRI
    EXU8SPS
    EXU8SPSU
    EXU8SPV
    EXU8SRT
    EXU8SRTU
    EXU8STO
    EXU8STOU
    EXU8SYN
    EXU8SYNC
    EXU8SYNI
    EXU8SYNU
    EXU8TAB
    EXU8TABC
    EXU8TABI
    EXU8TABU
    EXU8TBP
    EXU8TBPU
    EXU8TBS
    EXU8TGR
    EXU8TGRC
    EXU8TGRI
    EXU8TGRIC
    EXU8TGRU
    EXU8TNTC
    EXU8TNTI
    EXU8TNTIC
    EXU8TSL
    EXU8TSN
    EXU8TSQ
    EXU8TYP
    EXU8TYPB
    EXU8TYPBU
    EXU8TYPT
    EXU8TYPTU
    EXU8TYPU
    EXU8USR
    EXU8USRU
    EXU8VDPT
    EXU8VDPTU
    EXU8VEW
    EXU8VEWC
    EXU8VEWI
    EXU8VEWU
    EXU8VINF
    EXU8VINFC
    EXU8VINFI
    EXU8VINFU
    EXU8VNC
    EXU8VNCC
    EXU8VNCI
    EXU8VNCU
    EXU92FPT
    EXU92FPTP
    EXU92FPTPU
    EXU92FPTU
    EXU92ITGR
    EXU92TGR
    EXU92TGRC
    EXU92TGRI
    EXU92TGRIC
    EXU92TGRU
    EXU9CCL
    EXU9CCLO
    EXU9CCLU
    EXU9COE
    EXU9COEU
    EXU9COO
    EXU9COOU
    EXU9COO_TTS_UNUSED_COL
    EXU9DOI
    EXU9DOIU
    EXU9FIL
    EXU9IXCP
    EXU9IXCPU
    EXU9LBCP
    EXU9LBCPU
    EXU9LBP
    EXU9LBPU
    EXU9LNK
    EXU9LNKU
    EXU9LOB
    EXU9LOBU
    EXU9LTTS
    EXU9NTA
    EXU9NTAROLE
    EXU9PDS
    EXU9PDSU
    EXU9PLB
    EXU9PLBU
    EXU9PSTC
    EXU9PSTI
    EXU9REFC
    EXU9REFI
    EXU9SNAP
    EXU9SNAPC
    EXU9SNAPI
    EXU9SNAPL
    EXU9SNAPLC
    EXU9SNAPLI
    EXU9SNAPLU
    EXU9SNAPU
    EXU9STO
    EXU9STOU
    EXU9SYN
    EXU9SYNU
    EXU9TAB
    EXU9TABC
    EXU9TABI
    EXU9TABS
    EXU9TABSU
    EXU9TABU
    EXU9TAB_UNUSED_COLS
    EXU9TBCP
    EXU9TBCPU
    EXU9TBS
    EXU9TGRC
    EXU9TGRI
    EXU9TNTC
    EXU9TNTI
    EXU9TSQ
    EXU9TYP
    EXU9TYPT
    EXU9TYPT2
    EXU9TYPTU
    EXU9TYPTU2
    EXU9TYPU
    EXU9UTS
    EXU9UTSU
    GENERATOR$_S
    GET_OLDVERSION_HASHCODE
    GOLDENGATE$_PRIVILEGES
    GROUP_NUM_SEQ
    GV$ADVISOR_CURRENT_SQLPLAN
    GV$ASH_INFO
    GV$ASM_ACFSSNAPSHOTS
    GV$ASM_ACFSVOLUMES
    GV$ASM_ACFS_ENCRYPTION_INFO
    GV$ASM_ACFS_SECURITY_INFO
    GV$ASM_ATTRIBUTE
    GV$ASM_USER
    GV$ASM_USERGROUP
    GV$ASM_USERGROUP_MEMBER
    GV$ASM_VOLUME
    GV$ASM_VOLUME_STAT
    GV$CALLTAG
    GV$CELL
    GV$CELL_CONFIG
    GV$CELL_REQUEST_TOTALS
    GV$CELL_STATE
    GV$CELL_THREAD_HISTORY
    GV$CORRUPT_XID_LIST
    GV$CPOOL_CC_INFO
    GV$CPOOL_CC_STATS
    GV$CPOOL_CONN_INFO
    GV$CPOOL_STATS
    GV$DATAGUARD_STATS
    GV$DETACHED_SESSION
    GV$DIAG_INFO
    GV$DNFS_CHANNELS
    GV$DNFS_FILES
    GV$DNFS_SERVERS
    GV$DNFS_STATS
    GV$DYNAMIC_REMASTER_STATS
    GV$EMON
    GV$ENCRYPTED_TABLESPACES
    GV$ENCRYPTION_WALLET
    GV$FILE_OPTIMIZED_HISTOGRAM
    GV$FOREIGN_ARCHIVED_LOG
    GV$FS_FAILOVER_HISTOGRAM
    GV$FS_FAILOVER_STATS
    GV$GOLDENGATE_CAPTURE
    GV$GOLDENGATE_MESSAGE_TRACKING
    GV$GOLDENGATE_TRANSACTION
    GV$HM_CHECK
    GV$HM_CHECK_PARAM
    GV$HM_FINDING
    GV$HM_INFO
    GV$HM_RECOMMENDATION
    GV$HM_RUN
    GV$INCMETER_CONFIG
    GV$INCMETER_INFO
    GV$INCMETER_SUMMARY
    GV$IOFUNCMETRIC
    GV$IOFUNCMETRIC_HISTORY
    GV$IOSTAT_CONSUMER_GROUP
    GV$IOSTAT_FILE
    GV$IOSTAT_FUNCTION
    GV$IOSTAT_FUNCTION_DETAIL
    GV$IOSTAT_NETWORK
    GV$IO_CALIBRATION_STATUS
    GV$IR_FAILURE
    GV$IR_FAILURE_SET
    GV$IR_MANUAL_CHECKLIST
    GV$IR_REPAIR
    GV$LIBCACHE_LOCKS
    GV$LISTENER_NETWORK
    GV$LOBSTAT
    GV$MEMORY_CURRENT_RESIZE_OPS
    GV$MEMORY_DYNAMIC_COMPONENTS
    GV$MEMORY_RESIZE_OPS
    GV$MEMORY_TARGET_ADVICE
    GV$NFS_CLIENTS
    GV$NFS_LOCKS
    GV$NFS_OPEN_FILES
    GV$OBJECT_DML_FREQUENCIES
    GV$PERSISTENT_PUBLISHERS
    GV$PERSISTENT_QMN_CACHE
    GV$PERSISTENT_QUEUES
    GV$PERSISTENT_SUBSCRIBERS
    GV$POLICY_HISTORY
    GV$PX_INSTANCE_GROUP
    GV$QMON_COORDINATOR_STATS
    GV$QMON_SERVER_STATS
    GV$QMON_TASKS
    GV$QMON_TASK_STATS
    GV$REDO_DEST_RESP_HISTOGRAM
    GV$RESULT_CACHE_DEPENDENCY
    GV$RESULT_CACHE_MEMORY
    GV$RESULT_CACHE_OBJECTS
    GV$RESULT_CACHE_STATISTICS
    GV$RMAN_COMPRESSION_ALGORITHM
    GV$RSRCMGRMETRIC
    GV$RSRCMGRMETRIC_HISTORY
    GV$SECUREFILE_TIMER
    GV$SEGSPACE_USAGE
    GV$SSCR_SESSIONS
    GV$STREAMS_MESSAGE_TRACKING
    GV$STREAMS_POOL_STATISTICS
    GV$SUBSCR_REGISTRATION_STATS
    GV$SYSTEM_FIX_CONTROL
    GV$TOPLEVELCALL
    GV$WLM_PCMETRIC
    GV$WLM_PCMETRIC_HISTORY
    GV$WLM_PC_STATS
    GV$WORKLOAD_REPLAY_THREAD
    GV$XSTREAM_CAPTURE
    GV$XSTREAM_MESSAGE_TRACKING
    GV$XSTREAM_OUTBOUND_SERVER
    GV$XSTREAM_TRANSACTION
    GV_$ACCESS
    GV_$ACTIVE_SERVICES
    GV_$ACTIVE_SESSION_HISTORY
    GV_$ADVISOR_CURRENT_SQLPLAN
    GV_$ADVISOR_PROGRESS
    GV_$ALERT_TYPES
    GV_$AQ
    GV_$AQ1
    GV_$ARCHIVE
    GV_$ARCHIVED_LOG
    GV_$ARCHIVE_DEST
    GV_$ARCHIVE_DEST_STATUS
    GV_$ARCHIVE_GAP
    GV_$ARCHIVE_PROCESSES
    GV_$ASH_INFO
    GV_$ASM_ACFSSNAPSHOTS
    GV_$ASM_ACFSVOLUMES
    GV_$ASM_ACFS_ENCRYPTION_INFO
    GV_$ASM_ACFS_SECURITY_INFO
    GV_$ASM_ALIAS
    GV_$ASM_ATTRIBUTE
    GV_$ASM_CLIENT
    GV_$ASM_DISK
    GV_$ASM_DISKGROUP
    GV_$ASM_DISKGROUP_STAT
    GV_$ASM_DISK_IOSTAT
    GV_$ASM_DISK_STAT
    GV_$ASM_FILE
    GV_$ASM_FILESYSTEM
    GV_$ASM_OPERATION
    GV_$ASM_TEMPLATE
    GV_$ASM_USER
    GV_$ASM_USERGROUP
    GV_$ASM_USERGROUP_MEMBER
    GV_$ASM_VOLUME
    GV_$ASM_VOLUME_STAT
    GV_$BACKUP
    GV_$BACKUP_ASYNC_IO
    GV_$BACKUP_CORRUPTION
    GV_$BACKUP_DATAFILE
    GV_$BACKUP_DEVICE
    GV_$BACKUP_PIECE
    GV_$BACKUP_REDOLOG
    GV_$BACKUP_SET
    GV_$BACKUP_SPFILE
    GV_$BACKUP_SYNC_IO
    GV_$BGPROCESS
    GV_$BSP
    GV_$BUFFERED_PUBLISHERS
    GV_$BUFFERED_QUEUES
    GV_$BUFFERED_SUBSCRIBERS
    GV_$BUFFER_POOL
    GV_$BUFFER_POOL_STATISTICS
    GV_$CALLTAG
    GV_$CELL
    GV_$CELL_CONFIG
    GV_$CELL_REQUEST_TOTALS
    GV_$CELL_STATE
    GV_$CELL_THREAD_HISTORY
    GV_$CIRCUIT
    GV_$CLASS_CACHE_TRANSFER
    GV_$CLASS_PING
    GV_$CLIENT_STATS
    GV_$CLUSTER_INTERCONNECTS
    GV_$CONFIGURED_INTERCONNECTS
    GV_$CONTEXT
    GV_$CONTROLFILE
    GV_$CONTROLFILE_RECORD_SECTION
    GV_$COPY_CORRUPTION
    GV_$CORRUPT_XID_LIST
    GV_$CPOOL_CC_INFO
    GV_$CPOOL_CC_STATS
    GV_$CPOOL_CONN_INFO
    GV_$CPOOL_STATS
    GV_$CR_BLOCK_SERVER
    GV_$CURRENT_BLOCK_SERVER
    GV_$DATABASE
    GV_$DATABASE_BLOCK_CORRUPTION
    GV_$DATABASE_INCARNATION
    GV_$DATABASE_KEY_INFO
    GV_$DATAFILE
    GV_$DATAFILE_COPY
    GV_$DATAFILE_HEADER
    GV_$DATAGUARD_CONFIG
    GV_$DATAGUARD_STATS
    GV_$DATAGUARD_STATUS
    GV_$DATAPUMP_JOB
    GV_$DATAPUMP_SESSION
    GV_$DBFILE
    GV_$DBLINK
    GV_$DB_CACHE_ADVICE
    GV_$DB_OBJECT_CACHE
    GV_$DB_PIPES
    GV_$DB_TRANSPORTABLE_PLATFORM
    GV_$DELETED_OBJECT
    GV_$DETACHED_SESSION
    GV_$DIAG_INFO
    GV_$DISPATCHER
    GV_$DISPATCHER_CONFIG
    GV_$DISPATCHER_RATE
    GV_$DLM_ALL_LOCKS
    GV_$DLM_CONVERT_LOCAL
    GV_$DLM_CONVERT_REMOTE
    GV_$DLM_LATCH
    GV_$DLM_LOCKS
    GV_$DLM_MISC
    GV_$DLM_RESS
    GV_$DLM_TRAFFIC_CONTROLLER
    GV_$DNFS_CHANNELS
    GV_$DNFS_FILES
    GV_$DNFS_SERVERS
    GV_$DNFS_STATS
    GV_$DYNAMIC_REMASTER_STATS
    GV_$EMON
    GV_$ENABLEDPRIVS
    GV_$ENCRYPTED_TABLESPACES
    GV_$ENCRYPTION_WALLET
    GV_$ENQUEUE_LOCK
    GV_$ENQUEUE_STAT
    GV_$ENQUEUE_STATISTICS
    GV_$EVENTMETRIC
    GV_$EVENT_HISTOGRAM
    GV_$EVENT_NAME
    GV_$EXECUTION
    GV_$FAST_START_SERVERS
    GV_$FAST_START_TRANSACTIONS
    GV_$FILEMETRIC
    GV_$FILEMETRIC_HISTORY
    GV_$FILESPACE_USAGE
    GV_$FILESTAT
    GV_$FILE_CACHE_TRANSFER
    GV_$FILE_HISTOGRAM
    GV_$FILE_OPTIMIZED_HISTOGRAM
    GV_$FILE_PING
    GV_$FIXED_TABLE
    GV_$FIXED_VIEW_DEFINITION
    GV_$FLASHBACK_DATABASE_LOG
    GV_$FLASHBACK_DATABASE_LOGFILE
    GV_$FLASHBACK_DATABASE_STAT
    GV_$FOREIGN_ARCHIVED_LOG
    GV_$FS_FAILOVER_HISTOGRAM
    GV_$FS_FAILOVER_STATS
    GV_$GCSHVMASTER_INFO
    GV_$GCSPFMASTER_INFO
    GV_$GC_ELEMENT
    GV_$GC_ELEMENTS_W_COLLISIONS
    GV_$GES_BLOCKING_ENQUEUE
    GV_$GES_ENQUEUE
    GV_$GLOBALCONTEXT
    GV_$GLOBAL_BLOCKED_LOCKS
    GV_$GLOBAL_TRANSACTION
    GV_$GOLDENGATE_CAPTURE
    GV_$GOLDENGATE_MESSAGETRACKING
    GV_$GOLDENGATE_TRANSACTION
    GV_$HM_CHECK
    GV_$HM_CHECK_PARAM
    GV_$HM_FINDING
    GV_$HM_INFO
    GV_$HM_RECOMMENDATION
    GV_$HM_RUN
    GV_$HS_AGENT
    GV_$HS_PARAMETER
    GV_$HS_SESSION
    GV_$HVMASTER_INFO
    GV_$INCMETER_CONFIG
    GV_$INCMETER_INFO
    GV_$INCMETER_SUMMARY
    GV_$INDEXED_FIXED_COLUMN
    GV_$INSTANCE
    GV_$INSTANCE_CACHE_TRANSFER
    GV_$INSTANCE_LOG_GROUP
    GV_$INSTANCE_RECOVERY
    GV_$IOFUNCMETRIC
    GV_$IOFUNCMETRIC_HISTORY
    GV_$IOSTAT_CONSUMER_GROUP
    GV_$IOSTAT_FILE
    GV_$IOSTAT_FUNCTION
    GV_$IOSTAT_FUNCTION_DETAIL
    GV_$IOSTAT_NETWORK
    GV_$IO_CALIBRATION_STATUS
    GV_$IR_FAILURE
    GV_$IR_FAILURE_SET
    GV_$IR_MANUAL_CHECKLIST
    GV_$IR_REPAIR
    GV_$JAVAPOOL
    GV_$JAVA_LIBRARY_CACHE_MEMORY
    GV_$JAVA_POOL_ADVICE
    GV_$LATCH
    GV_$LATCHHOLDER
    GV_$LATCHNAME
    GV_$LATCH_CHILDREN
    GV_$LATCH_MISSES
    GV_$LATCH_PARENT
    GV_$LIBCACHE_LOCKS
    GV_$LIBRARYCACHE
    GV_$LIBRARY_CACHE_MEMORY
    GV_$LICENSE
    GV_$LISTENER_NETWORK
    GV_$LOBSTAT
    GV_$LOCK
    GV_$LOCKED_OBJECT
    GV_$LOCKS_WITH_COLLISIONS
    GV_$LOCK_ACTIVITY
    GV_$LOCK_ELEMENT
    GV_$LOCK_TYPE
    GV_$LOG
    GV_$LOGFILE
    GV_$LOGHIST
    GV_$LOGMNR_CALLBACK
    GV_$LOGMNR_CONTENTS
    GV_$LOGMNR_DICTIONARY
    GV_$LOGMNR_DICTIONARY_LOAD
    GV_$LOGMNR_LATCH
    GV_$LOGMNR_LOGFILE
    GV_$LOGMNR_LOGS
    GV_$LOGMNR_PARAMETERS
    GV_$LOGMNR_PROCESS
    GV_$LOGMNR_REGION
    GV_$LOGMNR_SESSION
    GV_$LOGMNR_STATS
    GV_$LOGMNR_TRANSACTION
    GV_$LOGSTDBY
    GV_$LOGSTDBY_PROCESS
    GV_$LOGSTDBY_PROGRESS
    GV_$LOGSTDBY_STATE
    GV_$LOGSTDBY_STATS
    GV_$LOGSTDBY_TRANSACTION
    GV_$LOG_HISTORY
    GV_$MANAGED_STANDBY
    GV_$MAP_COMP_LIST
    GV_$MAP_ELEMENT
    GV_$MAP_EXT_ELEMENT
    GV_$MAP_FILE
    GV_$MAP_FILE_EXTENT
    GV_$MAP_FILE_IO_STACK
    GV_$MAP_LIBRARY
    GV_$MAP_SUBELEMENT
    GV_$MEMORY_CURRENT_RESIZE_OPS
    GV_$MEMORY_DYNAMIC_COMPONENTS
    GV_$MEMORY_RESIZE_OPS
    GV_$MEMORY_TARGET_ADVICE
    GV_$METRIC
    GV_$METRICGROUP
    GV_$METRICNAME
    GV_$METRIC_HISTORY
    GV_$MTTR_TARGET_ADVICE
    GV_$MUTEX_SLEEP
    GV_$MUTEX_SLEEP_HISTORY
    GV_$MVREFRESH
    GV_$MYSTAT
    GV_$NFS_CLIENTS
    GV_$NFS_LOCKS
    GV_$NFS_OPEN_FILES
    GV_$OBJECT_DEPENDENCY
    GV_$OBJECT_DML_FREQUENCIES
    GV_$OBSOLETE_PARAMETER
    GV_$OFFLINE_RANGE
    GV_$OPEN_CURSOR
    GV_$OSSTAT
    GV_$PARAMETER
    GV_$PARAMETER2
    GV_$PARAMETER_VALID_VALUES
    GV_$PERSISTENT_PUBLISHERS
    GV_$PERSISTENT_QMN_CACHE
    GV_$PERSISTENT_QUEUES
    GV_$PERSISTENT_SUBSCRIBERS
    GV_$PGASTAT
    GV_$PGATARGET_ADVICE_HISTOGRAM
    GV_$PGA_TARGET_ADVICE
    GV_$POLICY_HISTORY
    GV_$PQ_SLAVE
    GV_$PQ_SYSSTAT
    GV_$PROCESS
    GV_$PROCESS_GROUP
    GV_$PROCESS_MEMORY
    GV_$PROCESS_MEMORY_DETAIL
    GV_$PROCESS_MEMORY_DETAIL_PROG
    GV_$PROPAGATION_RECEIVER
    GV_$PROPAGATION_SENDER
    GV_$PROXY_ARCHIVEDLOG
    GV_$PROXY_DATAFILE
    GV_$PWFILE_USERS
    GV_$PX_BUFFER_ADVICE
    GV_$PX_INSTANCE_GROUP
    GV_$PX_PROCESS
    GV_$PX_PROCESS_SYSSTAT
    GV_$PX_SESSION
    GV_$PX_SESSTAT
    GV_$QMON_COORDINATOR_STATS
    GV_$QMON_SERVER_STATS
    GV_$QMON_TASKS
    GV_$QMON_TASK_STATS
    GV_$QUEUE
    GV_$QUEUEING_MTH
    GV_$RECOVERY_FILE_STATUS
    GV_$RECOVERY_LOG
    GV_$RECOVERY_PROGRESS
    GV_$RECOVERY_STATUS
    GV_$RECOVER_FILE
    GV_$REDO_DEST_RESP_HISTOGRAM
    GV_$REPLPROP
    GV_$REPLQUEUE
    GV_$REQDIST
    GV_$RESERVED_WORDS
    GV_$RESOURCE
    GV_$RESOURCE_LIMIT
    GV_$RESULT_CACHE_DEPENDENCY
    GV_$RESULT_CACHE_MEMORY
    GV_$RESULT_CACHE_OBJECTS
    GV_$RESULT_CACHE_STATISTICS
    GV_$RESUMABLE
    GV_$RFS_THREAD
    GV_$RMAN_COMPRESSION_ALGORITHM
    GV_$RMAN_CONFIGURATION
    GV_$RMAN_OUTPUT
    GV_$ROLLSTAT
    GV_$ROWCACHE
    GV_$ROWCACHE_PARENT
    GV_$ROWCACHE_SUBORDINATE
    GV_$RSRCMGRMETRIC
    GV_$RSRCMGRMETRIC_HISTORY
    GV_$RULE
    GV_$RULE_SET
    GV_$RULE_SET_AGGREGATE_STATS
    GV_$SCHEDULER_RUNNING_JOBS
    GV_$SECUREFILE_TIMER
    GV_$SEGMENT_STATISTICS
    GV_$SEGSPACE_USAGE
    GV_$SEGSTAT
    GV_$SEGSTAT_NAME
    GV_$SERVICEMETRIC
    GV_$SERVICEMETRIC_HISTORY
    GV_$SERVICES
    GV_$SERVICE_EVENT
    GV_$SERVICE_STATS
    GV_$SERVICE_WAIT_CLASS
    GV_$SERV_MOD_ACT_STATS
    GV_$SESSION
    GV_$SESSION_BLOCKERS
    GV_$SESSION_CONNECT_INFO
    GV_$SESSION_CURSOR_CACHE
    GV_$SESSION_EVENT
    GV_$SESSION_FIX_CONTROL
    GV_$SESSION_LONGOPS
    GV_$SESSION_OBJECT_CACHE
    GV_$SESSION_WAIT
    GV_$SESSION_WAIT_CLASS
    GV_$SESSION_WAIT_HISTORY
    GV_$SESSMETRIC
    GV_$SESSTAT
    GV_$SESS_IO
    GV_$SESS_TIME_MODEL
    GV_$SES_OPTIMIZER_ENV
    GV_$SGA
    GV_$SGAINFO
    GV_$SGASTAT
    GV_$SGA_CURRENT_RESIZE_OPS
    GV_$SGA_DYNAMIC_COMPONENTS
    GV_$SGA_DYNAMIC_FREE_MEMORY
    GV_$SGA_RESIZE_OPS
    GV_$SGA_TARGET_ADVICE
    GV_$SHARED_POOL_ADVICE
    GV_$SHARED_POOL_RESERVED
    GV_$SHARED_SERVER
    GV_$SHARED_SERVER_MONITOR
    GV_$SORT_SEGMENT
    GV_$SORT_USAGE
    GV_$SPPARAMETER
    GV_$SQL
    GV_$SQLAREA
    GV_$SQLAREA_PLAN_HASH
    GV_$SQLCOMMAND
    GV_$SQLFN_ARG_METADATA
    GV_$SQLFN_METADATA
    GV_$SQLPA_METRIC
    GV_$SQLSTATS
    GV_$SQLSTATS_PLAN_HASH
    GV_$SQLTEXT
    GV_$SQLTEXT_WITH_NEWLINES
    GV_$SQL_BIND_CAPTURE
    GV_$SQL_BIND_DATA
    GV_$SQL_BIND_METADATA
    GV_$SQL_CS_HISTOGRAM
    GV_$SQL_CS_SELECTIVITY
    GV_$SQL_CS_STATISTICS
    GV_$SQL_CURSOR
    GV_$SQL_FEATURE
    GV_$SQL_FEATURE_DEPENDENCY
    GV_$SQL_FEATURE_HIERARCHY
    GV_$SQL_HINT
    GV_$SQL_JOIN_FILTER
    GV_$SQL_MONITOR
    GV_$SQL_OPTIMIZER_ENV
    GV_$SQL_PLAN
    GV_$SQL_PLAN_MONITOR
    GV_$SQL_PLAN_STATISTICS
    GV_$SQL_PLAN_STATISTICS_ALL
    GV_$SQL_REDIRECTION
    GV_$SQL_SHARED_CURSOR
    GV_$SQL_SHARED_MEMORY
    GV_$SQL_WORKAREA
    GV_$SQL_WORKAREA_ACTIVE
    GV_$SQL_WORKAREA_HISTOGRAM
    GV_$SSCR_SESSIONS
    GV_$STANDBY_LOG
    GV_$STATISTICS_LEVEL
    GV_$STATNAME
    GV_$STREAMS_APPLY_COORDINATOR
    GV_$STREAMS_APPLY_READER
    GV_$STREAMS_APPLY_SERVER
    GV_$STREAMS_CAPTURE
    GV_$STREAMS_MESSAGE_TRACKING
    GV_$STREAMS_POOL_ADVICE
    GV_$STREAMS_POOL_STATISTICS
    GV_$STREAMS_TRANSACTION
    GV_$SUBCACHE
    GV_$SUBSCR_REGISTRATION_STATS
    GV_$SYSAUX_OCCUPANTS
    GV_$SYSMETRIC
    GV_$SYSMETRIC_HISTORY
    GV_$SYSMETRIC_SUMMARY
    GV_$SYSSTAT
    GV_$SYSTEM_CURSOR_CACHE
    GV_$SYSTEM_EVENT
    GV_$SYSTEM_FIX_CONTROL
    GV_$SYSTEM_PARAMETER
    GV_$SYSTEM_PARAMETER2
    GV_$SYSTEM_WAIT_CLASS
    GV_$SYS_OPTIMIZER_ENV
    GV_$SYS_TIME_MODEL
    GV_$TABLESPACE
    GV_$TEMPFILE
    GV_$TEMPSTAT
    GV_$TEMP_CACHE_TRANSFER
    GV_$TEMP_EXTENT_MAP
    GV_$TEMP_EXTENT_POOL
    GV_$TEMP_PING
    GV_$TEMP_SPACE_HEADER
    GV_$THREAD
    GV_$THRESHOLD_TYPES
    GV_$TIMER
    GV_$TOPLEVELCALL
    GV_$TRANSACTION
    GV_$TRANSACTION_ENQUEUE
    GV_$TRANSPORTABLE_PLATFORM
    GV_$TSM_SESSIONS
    GV_$TYPE_SIZE
    GV_$UNDOSTAT
    GV_$VPD_POLICY
    GV_$WAITCLASSMETRIC
    GV_$WAITCLASSMETRIC_HISTORY
    GV_$WAITSTAT
    GV_$WALLET
    GV_$WLM_PCMETRIC
    GV_$WLM_PCMETRIC_HISTORY
    GV_$WLM_PC_STATS
    GV_$WORKLOAD_REPLAY_THREAD
    GV_$XML_AUDIT_TRAIL
    GV_$XSTREAM_CAPTURE
    GV_$XSTREAM_MESSAGE_TRACKING
    GV_$XSTREAM_OUTBOUND_SERVER
    GV_$XSTREAM_TRANSACTION
    GV_$_LOCK
    GridFile182_TAB
    HIER$
    HIERLEVEL$
    HISTGRM$
    HIST_HEAD$
    HS$_BASE_CAPS
    HS$_BASE_DD
    HS$_BASE_DD_S
    HS$_CLASS_CAPS
    HS$_CLASS_CAPS_S
    HS$_CLASS_DD
    HS$_CLASS_DD_S
    HS$_CLASS_INIT
    HS$_CLASS_INIT_S
    HS$_FDS_CLASS
    HS$_FDS_CLASS_DATE
    HS$_FDS_CLASS_S
    HS$_FDS_INST
    HS$_FDS_INST_S
    HS$_INST_CAPS
    HS$_INST_CAPS_S
    HS$_INST_DD
    HS$_INST_DD_S
    HS$_INST_INIT
    HS$_INST_INIT_S
    HS$_PARALLEL_HISTOGRAM_DATA
    HS$_PARALLEL_METADATA
    HS$_PARALLEL_PARTITION_DATA
    HS$_PARALLEL_SAMPLE_DATA
    HS_BULKLOAD_VIEW_OBJ
    HS_BULK_SEQ
    HS_PARALLEL_HISTOGRAM_DATA
    HS_PARALLEL_METADATA
    HS_PARALLEL_PARTITION_DATA
    HS_PARALLEL_SAMPLE_DATA
    ICOL$
    ICOLDEP$
    IDGEN1$
    IDL_CHAR$
    IDL_SB4$
    IDL_UB1$
    IDL_UB2$
    IDX_RB$JOBSEQ
    ID_GENS$
    IMP10TYPIDUSED
    IMP10TYPUSED
    IMP8CDT
    IMP8CDTU
    IMP8CON
    IMP8TTD
    IMP8TTDU
    IMP9CON
    IMP9SYNU
    INCEXP
    INCFIL
    INCVID
    INSERT_TSN_LIST$
    INVALIDATION_REGISTRY$
    INVALIDATION_REG_ID$
    JAVAOBJ$
    JAVASNM$
    JIJOIN$
    JIREFRESHSQL$
    JOB
    JOB$
    JOBARG
    JOBARG_ARRAY
    JOBATTR
    JOBATTR_ARRAY
    JOBS
    JOBSEQ
    JOBSEQLSBY
    JOB_ARRAY
    JOB_DEFINITION
    JOB_DEFINITION_ARRAY
    JOB_HISTORY
    KET$_AUTOTASK_STATUS
    KET$_CLIENT_CONFIG
    KET$_CLIENT_TASKS
    KOPM$
    KOTAD$
    KOTADX$
    KOTMD$
    KOTTB$
    KOTTBX$
    KOTTD$
    KUPC$DATAPUMP_QUETAB
    KU_NOEXP_TAB
    KU_UTLUSE
    LIBRARY$
    LINK$
    LOB$
    LOBCOMPPART$
    LOBCOMPPARTV$
    LOBFRAG$
    LOBFRAGV$
    LOC$
    LOCATIONS
    LOCATIONS_SEQ
    LOG$
    LOG$SEQUENCE
    LOGMNRC_DBNAME_UID_MAP
    LOGMNRC_GSBA
    LOGMNRC_GSII
    LOGMNRC_GTCS
    LOGMNRC_GTLO
    LOGMNRG_ATTRCOL$
    LOGMNRG_ATTRIBUTE$
    LOGMNRG_CCOL$
    LOGMNRG_CDEF$
    LOGMNRG_COL$
    LOGMNRG_COLTYPE$
    LOGMNRG_DICTIONARY$
    LOGMNRG_ENC$
    LOGMNRG_ICOL$
    LOGMNRG_IND$
    LOGMNRG_INDCOMPART$
    LOGMNRG_INDPART$
    LOGMNRG_INDSUBPART$
    LOGMNRG_KOPM$
    LOGMNRG_LOB$
    LOGMNRG_LOBFRAG$
    LOGMNRG_LOGMNR_BUILDLOG
    LOGMNRG_NTAB$
    LOGMNRG_OBJ$
    LOGMNRG_OPQTYPE$
    LOGMNRG_PARTOBJ$
    LOGMNRG_PROPS$
    LOGMNRG_REFCON$
    LOGMNRG_SEED$
    LOGMNRG_SUBCOLTYPE$
    LOGMNRG_TAB$
    LOGMNRG_TABCOMPART$
    LOGMNRG_TABPART$
    LOGMNRG_TABSUBPART$
    LOGMNRG_TS$
    LOGMNRG_TYPE$
    LOGMNRG_USER$
    LOGMNRP_CTAS_PART_MAP
    LOGMNRT_MDDL$
    LOGMNR_AGE_SPILL$
    LOGMNR_ATTRCOL$
    LOGMNR_ATTRIBUTE$
    LOGMNR_BUILDLOG
    LOGMNR_CCOL$
    LOGMNR_CDEF$
    LOGMNR_COL$
    LOGMNR_COLTYPE$
    LOGMNR_DICTIONARY$
    LOGMNR_DICTSTATE$
    LOGMNR_ENC$
    LOGMNR_ERROR$
    LOGMNR_EVOLVE_SEQ$
    LOGMNR_FILTER$
    LOGMNR_GLOBAL$
    LOGMNR_GTCS_CAT_SUPPORT
    LOGMNR_GTCS_SUPPORT
    LOGMNR_GT_TAB_INCLUDE$
    LOGMNR_GT_USER_INCLUDE$
    LOGMNR_GT_XID_INCLUDE$
    LOGMNR_ICOL$
    LOGMNR_IND$
    LOGMNR_INDCOMPART$
    LOGMNR_INDPART$
    LOGMNR_INDSUBPART$
    LOGMNR_INTEGRATED_SPILL$
    LOGMNR_KOPM$
    LOGMNR_LOB$
    LOGMNR_LOBFRAG$
    LOGMNR_LOG$
    LOGMNR_LOGMNR_BUILDLOG
    LOGMNR_NTAB$
    LOGMNR_OBJ$
    LOGMNR_OPQTYPE$
    LOGMNR_PARAMETER$
    LOGMNR_PARTOBJ$
    LOGMNR_PROCESSED_LOG$
    LOGMNR_PROPS$
    LOGMNR_REFCON$
    LOGMNR_RESTART_CKPT$
    LOGMNR_RESTART_CKPT_TXINFO$
    LOGMNR_SEED$
    LOGMNR_SEQ$
    LOGMNR_SESSION$
    LOGMNR_SESSION_ACTIONS$
    LOGMNR_SESSION_EVOLVE$
    LOGMNR_SPILL$
    LOGMNR_SUBCOLTYPE$
    LOGMNR_TAB$
    LOGMNR_TABCOMPART$
    LOGMNR_TABPART$
    LOGMNR_TABSUBPART$
    LOGMNR_TAB_COLS_CAT_SUPPORT
    LOGMNR_TAB_COLS_SUPPORT
    LOGMNR_TS$
    LOGMNR_TYPE$
    LOGMNR_UID$
    LOGMNR_UIDS$
    LOGMNR_USER$
    LOGSTDBY$APPLY_MILESTONE
    LOGSTDBY$APPLY_PROGRESS
    LOGSTDBY$EDS_TABLES
    LOGSTDBY$EVENTS
    LOGSTDBY$FLASHBACK_SCN
    LOGSTDBY$HISTORY
    LOGSTDBY$PARAMETERS
    LOGSTDBY$PLSQL
    LOGSTDBY$SCN
    LOGSTDBY$SKIP
    LOGSTDBY$SKIP_SUPPORT
    LOGSTDBY$SKIP_TRANSACTION
    LOGSTDBY_LOG
    LOGSTDBY_SUPPORT
    LOGSTDBY_SUPPORT_11LOB
    LOGSTDBY_SUPPORT_SEQ
    LOGSTDBY_SUPPORT_TAB_10_1
    LOGSTDBY_SUPPORT_TAB_10_2
    LOGSTDBY_SUPPORT_TAB_11_1
    LOGSTDBY_SUPPORT_TAB_11_2
    LOGSTDBY_SUPPORT_TAB_11_2B
    LOGSTDBY_UNSUPPORTED_TABLES
    LOGSTDBY_UNSUPPORT_TAB_10_1
    LOGSTDBY_UNSUPPORT_TAB_10_2
    LOGSTDBY_UNSUPPORT_TAB_11_1
    LOGSTDBY_UNSUPPORT_TAB_11_2
    LOGSTDBY_UNSUPPORT_TAB_11_2B
    LightSource3d234_TAB
    MAP_COMPLIST$
    MAP_ELEMENT$
    MAP_EXTELEMENT$
    MAP_FILE$
    MAP_FILE_EXTENT$
    MAP_SUBELEMENT$
    MESG_ID_SEQ
    METAFILTER$
    METANAMETRANS$
    METAPATHMAP$
    METASCRIPT$
    METASCRIPTFILTER$
    METASTYLESHEET
    METAVIEW$
    METAXSL$
    METAXSLPARAM$
    METHOD$
    MIGR9202STATUS
    MIGRATE$
    MLOG$
    MLOG_REFCOL$
    MODEL$
    MODELATT$
    MODELSET$
    MODELTAB$
    MON_MODS$
    MON_MODS_ALL$
    MVIEW$_ADVSEQ_GENERIC
    MVIEW$_ADVSEQ_ID
    MVIEW$_ADV_AJG
    MVIEW$_ADV_BASETABLE
    MVIEW$_ADV_CLIQUE
    MVIEW$_ADV_ELIGIBLE
    MVIEW$_ADV_EXCEPTIONS
    MVIEW$_ADV_FILTER
    MVIEW$_ADV_FILTERINSTANCE
    MVIEW$_ADV_FJG
    MVIEW$_ADV_GC
    MVIEW$_ADV_INFO
    MVIEW$_ADV_JOURNAL
    MVIEW$_ADV_LEVEL
    MVIEW$_ADV_LOG
    MVIEW$_ADV_OUTPUT
    MVIEW$_ADV_PARAMETERS
    MVIEW$_ADV_PLAN
    MVIEW$_ADV_PRETTY
    MVIEW$_ADV_ROLLUP
    MVIEW$_ADV_SQLDEPEND
    MVIEW$_ADV_TEMP
    MVIEW$_ADV_WORKLOAD
    MVIEW_EVALUATIONS
    MVIEW_EXCEPTIONS
    MVIEW_FILTER
    MVIEW_FILTERINSTANCE
    MVIEW_LOG
    MVIEW_RECOMMENDATIONS
    MVIEW_WORKLOAD
    MV_RF$JOBSEQ
    NCOMP_DLL$
    NET$_ACL
    NOEXP$
    NTAB$
    NTV2_SEQUENCE
    NTV2_XML_DATA
    ODCI_PMO_ROWIDS$
    ODM_ABN_MODEL
    ODM_ASSOCIATION_RULE_MODEL
    ODM_CLUSTERING_UTIL
    ODM_MODEL_UTIL
    ODM_OC_CLUSTERING_MODEL
    OGC_X
    OGC_Y
    OID$
    OLAP_ATTRIBUTES$
    OLAP_ATTRIBUTE_VISIBILITY$
    OLAP_AW_DEPLOYMENT_CONTROLS$
    OLAP_AW_VIEWS$
    OLAP_AW_VIEW_COLUMNS$
    OLAP_CALCULATED_MEMBERS$
    OLAP_CUBES$
    OLAP_CUBE_BUILD_PROCESSES$
    OLAP_CUBE_DIMENSIONS$
    OLAP_DESCRIPTIONS$
    OLAP_DIMENSIONALITY$
    OLAP_DIM_LEVELS$
    OLAP_HIERARCHIES$
    OLAP_HIER_LEVELS$
    OLAP_IMPL_OPTIONS$
    OLAP_MAPPINGS$
    OLAP_MEASURES$
    OLAP_MEASURE_FOLDERS$
    OLAP_MEAS_FOLDER_CONTENTS$
    OLAP_MODELS$
    OLAP_MODEL_ASSIGNMENTS$
    OLAP_MODEL_PARENTS$
    OLAP_MULTI_OPTIONS$
    OLAP_SYNTAX$
    OLAP_TAB$
    OLAP_TAB_COL$
    OLAP_TAB_HIER$
    OPANCILLARY$
    OPARG$
    OPBINDING$
    OPERATOR$
    OPQTYPE$
    OPTSTAT_HIST_CONTROL$
    OPTSTAT_USER_PREFS$
    ORA_DMSB_NODES
    ORA_FI_SUPERVISED_BINNING
    ORA_KGLR7_OBJECTS
    ORA_MINING_NUMBER_NT
    ORA_MINING_TABLES_NT
    ORA_MINING_TABLE_TYPE
    ORA_MINING_VARCHAR2_NT
    ORA_PLAN_ID_SEQ$
    ORA_TQ_BASE$
    QT12443_BUFFER
    QT12471_BUFFER
    QT12505_BUFFER
    QT12564_BUFFER
    QT12736_BUFFER
    QT12774_BUFFER
    QT12932_BUFFER
    QT13081_BUFFER
    RECENT_RESOURCE_INCARNATIONS$
    RECO_SCRIPT$
    RECO_SCRIPT_BLOCK$
    RECO_SCRIPT_ERROR$
    RECO_SCRIPT_PARAMS$
    REC_TAB$
    REC_VAR$
    REDEF$
    REDEF_DEP_ERROR$
    REDEF_OBJECT$
    REDEF_SEQ$
    REFCON$
    REG$
    REGIONS
    REGISTRY$
    REGISTRY$DATABASE
    REGISTRY$DEPENDENCIES
    REGISTRY$ERROR
    REGISTRY$HISTORY
    REGISTRY$LOG
    REGISTRY$PROGRESS
    REGISTRY$SCHEMAS
    REG_SNAP$
    REPCAT$_AUDIT_ATTRIBUTE
    REPCAT$_AUDIT_COLUMN
    REPCAT$_CDEF
    REPCAT$_COLUMN_GROUP
    REPCAT$_CONFLICT
    REPCAT$_DDL
    REPCAT$_EXCEPTIONS
    REPCAT$_EXCEPTIONS_S
    REPCAT$_EXTENSION
    REPCAT$_FLAVORS
    REPCAT$_FLAVORS_S
    REPCAT$_FLAVOR_NAME_S
    REPCAT$_FLAVOR_OBJECTS
    REPCAT$_GENERATED
    REPCAT$_GROUPED_COLUMN
    REPCAT$_INSTANTIATION_DDL
    REPCAT$_KEY_COLUMNS
    REPCAT$_OBJECT_PARMS
    REPCAT$_OBJECT_TYPES
    REPCAT$_PARAMETER_COLUMN
    REPCAT$_PRIORITY
    REPCAT$_PRIORITY_GROUP
    REPCAT$_REFRESH_TEMPLATES
    REPCAT$_REFRESH_TEMPLATES_S
    REPCAT$_REPCAT
    REPCAT$_REPCATLOG
    REPCAT$_REPCOLUMN
    REPCAT$_REPGROUP_PRIVS
    REPCAT$_REPOBJECT
    REPCAT$_REPPROP
    REPCAT$_REPPROP_KEY
    REPCAT$_REPSCHEMA
    REPCAT$_RESOLUTION
    REPCAT$_RESOLUTION_METHOD
    REPCAT$_RESOLUTION_STATISTICS
    REPCAT$_RESOL_STATS_CONTROL
    REPCAT$_RUNTIME_PARMS
    REPCAT$_RUNTIME_PARMS_S
    REPCAT$_SITES_NEW
    REPCAT$_SITE_OBJECTS
    REPCAT$_SNAPGROUP
    REPCAT$_TEMPLATE_OBJECTS
    REPCAT$_TEMPLATE_OBJECTS_S
    REPCAT$_TEMPLATE_PARMS
    REPCAT$_TEMPLATE_PARMS_S
    REPCAT$_TEMPLATE_REFGROUPS
    REPCAT$_TEMPLATE_REFGROUPS_S
    REPCAT$_TEMPLATE_SITES
    REPCAT$_TEMPLATE_SITES_S
    REPCAT$_TEMPLATE_STATUS
    REPCAT$_TEMPLATE_TARGETS
    REPCAT$_TEMPLATE_TYPES
    REPCAT$_TEMP_OUTPUT_S
    REPCAT$_USER_AUTHORIZATIONS
    REPCAT$_USER_AUTHORIZATIONS_S
    REPCAT$_USER_PARM_VALUES
    REPCAT$_USER_PARM_VALUES_S
    REPCAT_GENERATED
    REPCAT_LOG_SEQUENCE
    REPCAT_REPCAT
    REPCAT_REPCATLOG
    REPCAT_REPFLAVOR_COLUMNS
    REPCAT_REPOBJECT
    REPCAT_REPOBJECT_BASE
    REPCAT_REPPROP
    REPCAT_REPSCHEMA
    REPORT_COMPONENTS
    REPORT_FILES
    REPORT_FORMATS
    RESOURCE_CAPABILITY$
    RESOURCE_CATEGORY$
    RESOURCE_CONSUMER_GROUP$
    RESOURCE_GROUP_MAPPING$
    RESOURCE_INSTANCE_CAPABILITY$
    RESOURCE_IO_CALIBRATE$
    RESOURCE_MAP
    RESOURCE_MAPPING_PRIORITY$
    RESOURCE_PLAN$
    RESOURCE_PLAN_DIRECTIVE$
    RESOURCE_STORAGE_POOL_MAPPING$
    RESULT$
    RGCHILD$
    RGROUP$
    RGROUPSEQ
    RLS$
    RLS_CTX$
    RLS_GRP$
    RLS_SC$
    RULE$
    RULESET$
    RULE_EC$
    RULE_MAP$
    RULE_SET$
    RULE_SET_EE$
    RULE_SET_FOB$
    RULE_SET_IEUAC$
    RULE_SET_IOT$
    RULE_SET_NL$
    RULE_SET_PR$
    RULE_SET_RDEP$
    RULE_SET_RE$
    RULE_SET_ROP$
    RULE_SET_ROR$
    RULE_SET_TE$
    RULE_SET_VE$
    SCHEDULER$_CHAIN
    SCHEDULER$_CLASS
    SCHEDULER$_CREDENTIAL
    SCHEDULER$_DESTINATIONS
    SCHEDULER$_EVENT_LOG
    SCHEDULER$_EVENT_QTAB
    SCHEDULER$_EVTQ_SUB
    SCHEDULER$_EVTSEQ
    SCHEDULER$_FILEWATCHER_HISTORY
    SCHEDULER$_FILEWATCHER_RESEND
    SCHEDULER$_FILE_WATCHER
    SCHEDULER$_GLOBAL_ATTRIBUTE
    SCHEDULER$_INSTANCE_S
    SCHEDULER$_JOB
    SCHEDULER$_JOBSUFFIX_S
    SCHEDULER$_JOB_ARGUMENT
    SCHEDULER$_JOB_DESTINATIONS
    SCHEDULER$_JOB_RUN_DETAILS
    SCHEDULER$_LIGHTWEIGHT_JOB
    SCHEDULER$_LWJOB_OBJ
    SCHEDULER$_LWJOB_OID_SEQ
    SCHEDULER$_NOTIFICATION
    SCHEDULER$_PROGRAM
    SCHEDULER$_PROGRAM_ARGUMENT
    SCHEDULER$_RDB_SEQ
    SCHEDULER$_REMDB_JOBQTAB
    SCHEDULER$_REMOTE_DBS
    SCHEDULER$_REMOTE_JOB_STATE
    SCHEDULER$_RJOB_SRC_DB_INFO
    SCHEDULER$_SAVED_OIDS
    SCHEDULER$_SCHEDULE
    SCHEDULER$_SRCQ_INFO
    SCHEDULER$_SRCQ_MAP
    SCHEDULER$_STEP
    SCHEDULER$_STEP_STATE
    SCHEDULER$_WINDOW
    SCHEDULER$_WINDOW_DETAILS
    SCHEDULER$_WINDOW_GROUP
    SCHEDULER$_WINGRP_MEMBER
    SCHEDULER_BATCH_ERRORS
    SCHEDULER_FILEWATCHER_QT
    SCHEMA_EXPORT_PATHS
    SECOBJ$
    SEG$
    SERVICE$
    SERVLET
    SETTINGS$
    SLOG$
    SM$AUDIT_CONFIG
    SM$INTEGRITY_CONS
    SM$TS_AVAIL
    SM$TS_FREE
    SM$TS_USED
    SMB$CONFIG
    SMON_SCN_TIME
    SNAP$
    SNAPSHOT_ID$
    SNAPSITE_ID$
    SNAP_COLMAP$
    SNAP_LOADERTIME$
    SNAP_LOGDEP$
    SNAP_OBJCOL$
    SNAP_REFOP$
    SNAP_REFTIME$
    SNAP_SITE$
    SNAP_XCMT$
    SNS$EJB$GEN$
    SOURCE$
    SOURCE_SIZE
    SQL$
    SQL$TEXT
    SQLERROR$
    SQLLOG$
    SQLLOG$_SEQ
    SQLOBJ$
    SQLOBJ$AUXDATA
    SQLOBJ$DATA
    SQLPLUS_PRODUCT_PROFILE
    SQL_PLAN_ALLSTAT_ROW_TYPE
    SQL_TK_CHK_ID
    SQL_TK_COLL_CHK$
    SQL_TK_REF_CHK$
    SQL_TK_ROW_CHK$
    SQL_TK_TAB_DESC$
    SQL_VERSION$
    SRSNAMESPACE_TABLE
    SSCR_CAP$
    SSCR_CAP_SEQ$
    SSCR_RES$
    STATEID_RESTART_SEQUENCE
    STATS_TARGET$
    STRADDLING_RS_OBJECTS
    STRADDLING_TS_OBJECTS
    STREAMS$_APPLY_MILESTONE
    STREAMS$_APPLY_PROCESS
    STREAMS$_APPLY_PROGRESS
    STREAMS$_APPLY_SPILL_MESSAGES
    STREAMS$_APPLY_SPILL_MSGS_PART
    STREAMS$_APPLY_SPILL_TXN
    STREAMS$_APPLY_SPILL_TXNKEY_S
    STREAMS$_APPLY_SPILL_TXN_LIST
    STREAMS$_CAPTURE_INST
    STREAMS$_CAPTURE_PROCESS
    STREAMS$_CAPTURE_SERVER
    STREAMS$_CAP_SUB_INST
    STREAMS$_COMPONENT
    STREAMS$_COMPONENT_EVENT_IN
    STREAMS$_COMPONENT_IN
    STREAMS$_COMPONENT_LINK
    STREAMS$_COMPONENT_LINK_IN
    STREAMS$_COMPONENT_PROP
    STREAMS$_COMPONENT_PROP_IN
    STREAMS$_COMPONENT_STAT_IN
    STREAMS$_COMPONENT_STAT_OUT
    STREAMS$_DATABASE
    STREAMS$_DEF_PROC
    STREAMS$_DEST_OBJS
    STREAMS$_DEST_OBJ_COLS
    STREAMS$_EXTRA_ATTRS
    STREAMS$_INTERNAL_TRANSFORM
    STREAMS$_KEY_COLUMNS
    STREAMS$_LOCAL_ACTIONS_IN
    STREAMS$_LOCAL_FINDINGS_IN
    STREAMS$_LOCAL_RECS_IN
    STREAMS$_MESSAGE_CONSUMERS
    STREAMS$_MESSAGE_RULES
    STREAMS$_PATH_BOTTLENECK_OUT
    STREAMS$_PATH_STAT_OUT
    STREAMS$_PREPARE_DDL
    STREAMS$_PREPARE_OBJECT
    STREAMS$_PRIVILEGED_USER
    STREAMS$_PROCESS_PARAMS
    STREAMS$_PROPAGATION_PROCESS
    STREAMS$_PROPAGATION_SEQNUM
    STREAMS$_RULES
    STREAMS$_RULE_NAME_S
    STREAMS$_SM_ID
    STREAMS$_SPLIT_MERGE
    STREAMS$_STMT_HANDLERS
    STREAMS$_STMT_HANDLER_SEQ
    STREAMS$_STMT_HANDLER_STMTS
    ST_ANNOTATIONTEXTELEMENT
    ST_ANNOTATIONTEXTELEMENT_ARRAY
    ST_ANNOTATION_TEXT
    ST_ANNOT_TEXTELEMENT_ARRAY
    ST_CIRCULARSTRING
    ST_COMPOUNDCURVE
    ST_CONTAINS
    ST_COVEREDBY
    ST_COVERS
    ST_CURVE
    ST_CURVEPOLYGON
    ST_CURVE_ARRAY
    ST_EQUAL
    ST_GEOMCOLLECTION
    ST_GEOMETRY
    ST_GEOMETRY_ARRAY
    ST_INSIDE
    ST_INTERSECTS
    ST_LINESTRING
    ST_LINESTRING_ARRAY
    ST_MULTICURVE
    ST_MULTIFURFACE
    ST_MULTILINESTRING
    ST_MULTIPOINT
    ST_MULTIPOLYGON
    ST_OVERLAPBDYDISJOINT
    ST_OVERLAPBDYINTERSECT
    ST_OVERLAPS
    ST_POINT
    ST_POINT_ARRAY
    ST_POLYGON
    ST_POLYGON_ARRAY
    ST_RELATE
    ST_SURFACE
    ST_SURFACE_ARRAY
    ST_TOUCH
    SUBCOLTYPE$
    SUBPARTCOL$
    SUM$
    SUMAGG$
    SUMDELTA$
    SUMDEP$
    SUMDETAIL$
    SUMINLINE$
    SUMJOIN$
    SUMKEY$
    SUMPARTLOG$
    SUMPRED$
    SUMQB$
    SUPEROBJ$
    SYS$SERVICE_METRICS_TAB
    SYSAUTH$
    SYSTEM_GRANT
    SYS_DBA_SEGS
    SYS_FBA_BARRIERSCN
    SYS_FBA_DL
    SYS_FBA_FA
    SYS_FBA_PARTITIONS
    SYS_FBA_TRACKEDTABLES
    SYS_FBA_TSFA
    SYS_FBA_USERS
    SYS_OBJECTS
    SYS_UNCOMPRESSED_SEGS
    SYS_UNCOMPRESSED_SEGS_BASE
    SYS_USER_SEGS
    Scene3d237_TAB
    Style3d239_TAB
    TAB
    TAB$
    TABCOMPART$
    TABCOMPARTV$
    TABLESPACE_EXPORT_OBJECTS
    TABLESPACE_EXPORT_PATHS
    TABLE_EXPORT_OBJECTS
    TABLE_EXPORT_PATHS
    TABLE_PRIVILEGES
    TABLE_PRIVILEGE_MAP
    TABPART$
    TABPARTV$
    TABQUOTAS
    TABS
    TABSUBPART$
    TABSUBPARTV$
    TAB_STATS$
    TBLAST_ALIGN
    TBLAST_MATCH
    TBS_SPACE_USAGE
    TEMPLATE$_TARGETS_S
    THS_SEQ
    TP$
    TRANSACTION_BACKOUT_REPORT$
    TRANSACTION_BACKOUT_STATE$
    TRANSFORMATIONS$
    TRANSIENT_IOT$
    TRANSPORTABLE_EXPORT_PATHS
    TRANSPORT_SET_VIOLATIONS
    TRIGGER$
    TRIGGERCOL$
    TRIGGERDEP$
    TRIGGERJAVAC$
    TRIGGERJAVAF$
    TRIGGERJAVAM$
    TRIGGERJAVAS$
    TRUSTED_LIST$
    TS$
    TSM_DST$
    TSM_MIG_SEQ$
    TSM_SRC$
    TSP$
    TSQ$
    TS_PITR_CHECK
    TS_PITR_INFO
    TS_PITR_OBJECTS_TO_BE_DROPPED
    TS_PLUG_INFO
    TTS_ERROR$
    TTS_OBJ_VIEW
    TTS_TAB_VIEW
    TTS_TBS$
    TTS_USR$
    TYPE$
    TYPED_VIEW$
    TYPEHIERARCHY$
    TYPE_MISC$
    Theme3d238_TAB
    UET$
    UGROUP$
    UGROUP_SEQUENCE
    UNDO$
    UNI_PLUGGABLE_SET_CHECK
    USER$
    USTATS$
    WALLET$_ACL
    WARNING_SETTINGS$
    WLM_CLASSIFIER_PLAN
    WLM_METRICS_STREAM
    WLM_MPA_STREAM
    WLM_VIOLATION_STREAM
    WRH$_ACTIVE_SESSION_HISTORY
    WRH$_ACTIVE_SESSION_HISTORY_BL
    WRH$_BG_EVENT_SUMMARY
    WRH$_BUFFERED_QUEUES
    WRH$_BUFFERED_SUBSCRIBERS
    WRH$_BUFFER_POOL_STATISTICS
    WRH$_CLUSTER_INTERCON
    WRH$_COMP_IOSTAT
    WRH$_CR_BLOCK_SERVER
    WRH$_CURRENT_BLOCK_SERVER
    WRH$_DATAFILE
    WRH$_DB_CACHE_ADVICE
    WRH$_DB_CACHE_ADVICE_BL
    WRH$_DISPATCHER
    WRH$_DLM_MISC
    WRH$_DLM_MISC_BL
    WRH$_DYN_REMASTER_STATS
    WRH$_ENQUEUE_STAT
    WRH$_EVENT_HISTOGRAM
    WRH$_EVENT_HISTOGRAM_BL
    WRH$_EVENT_NAME
    WRH$_FILEMETRIC_HISTORY
    WRH$_FILESTATXS
    WRH$_FILESTATXS_BL
    WRH$_IC_CLIENT_STATS
    WRH$_IC_DEVICE_STATS
    WRH$_INSTANCE_RECOVERY
    WRH$_INST_CACHE_TRANSFER
    WRH$_INST_CACHE_TRANSFER_BL
    WRH$_INTERCONNECT_PINGS
    WRH$_INTERCONNECT_PINGS_BL
    WRH$_IOSTAT_DETAIL
    WRH$_IOSTAT_FILETYPE
    WRH$_IOSTAT_FILETYPE_NAME
    WRH$_IOSTAT_FUNCTION
    WRH$_IOSTAT_FUNCTION_NAME
    WRH$_JAVA_POOL_ADVICE
    WRH$_LATCH
    WRH$_LATCH_BL
    WRH$_LATCH_CHILDREN
    WRH$_LATCH_CHILDREN_BL
    WRH$_LATCH_MISSES_SUMMARY
    WRH$_LATCH_MISSES_SUMMARY_BL
    WRH$_LATCH_NAME
    WRH$_LATCH_PARENT
    WRH$_LATCH_PARENT_BL
    WRH$_LIBRARYCACHE
    WRH$_LOG
    WRH$_MEMORY_RESIZE_OPS
    WRH$_MEMORY_TARGET_ADVICE
    WRH$_MEM_DYNAMIC_COMP
    WRH$_METRIC_NAME
    WRH$_MTTR_TARGET_ADVICE
    WRH$_MUTEX_SLEEP
    WRH$_MVPARAMETER
    WRH$_MVPARAMETER_BL
    WRH$_OPTIMIZER_ENV
    WRH$_OSSTAT
    WRH$_OSSTAT_BL
    WRH$_OSSTAT_NAME
    WRH$_PARAMETER
    WRH$_PARAMETER_BL
    WRH$_PARAMETER_NAME
    WRH$_PERSISTENT_QMN_CACHE
    WRH$_PERSISTENT_QUEUES
    WRH$_PERSISTENT_SUBSCRIBERS
    WRH$_PGASTAT
    WRH$_PGA_TARGET_ADVICE
    WRH$_PLAN_OPERATION_NAME
    WRH$_PLAN_OPTION_NAME
    WRH$_PROCESS_MEMORY_SUMMARY
    WRH$_RESOURCE_LIMIT
    WRH$_ROWCACHE_SUMMARY
    WRH$_ROWCACHE_SUMMARY_BL
    WRH$_RSRC_CONSUMER_GROUP
    WRH$_RSRC_PLAN
    WRH$_RULE_SET
    WRH$_SEG_STAT
    WRH$_SEG_STAT_BL
    WRH$_SEG_STAT_OBJ
    WRH$_SERVICE_NAME
    WRH$_SERVICE_STAT
    WRH$_SERVICE_STAT_BL
    WRH$_SERVICE_WAIT_CLASS
    WRH$_SERVICE_WAIT_CLASS_BL
    WRH$_SESSMETRIC_HISTORY
    WRH$_SESS_TIME_STATS
    WRH$_SGA
    WRH$_SGASTAT
    WRH$_SGASTAT_BL
    WRH$_SGA_TARGET_ADVICE
    WRH$_SHARED_POOL_ADVICE
    WRH$_SHARED_SERVER_SUMMARY
    WRH$_SQLCOMMAND_NAME
    WRH$_SQLSTAT
    WRH$_SQLSTAT_BL
    WRH$_SQLTEXT
    WRH$_SQL_BIND_METADATA
    WRH$_SQL_PLAN
    WRH$_SQL_SUMMARY
    WRH$_SQL_WORKAREA_HISTOGRAM
    WRH$_STAT_NAME
    WRH$_STREAMS_APPLY_SUM
    WRH$_STREAMS_CAPTURE
    WRH$_STREAMS_POOL_ADVICE
    WRH$_SYSMETRIC_HISTORY
    WRH$_SYSMETRIC_SUMMARY
    WRH$_SYSSTAT
    WRH$_SYSSTAT_BL
    WRH$_SYSTEM_EVENT
    WRH$_SYSTEM_EVENT_BL
    WRH$_SYS_TIME_MODEL
    WRH$_SYS_TIME_MODEL_BL
    WRH$_TABLESPACE
    WRH$_TABLESPACE_SPACE_USAGE
    WRH$_TABLESPACE_STAT
    WRH$_TABLESPACE_STAT_BL
    WRH$_TEMPFILE
    WRH$_TEMPSTATXS
    WRH$_THREAD
    WRH$_TOPLEVELCALL_NAME
    WRH$_UNDOSTAT
    WRH$_WAITCLASSMETRIC_HISTORY
    WRH$_WAITSTAT
    WRH$_WAITSTAT_BL
    WRI$_ADV_ACTIONS
    WRI$_ADV_ADDM_FDG
    WRI$_ADV_ADDM_INST
    WRI$_ADV_ADDM_TASKS
    WRI$_ADV_DEFINITIONS
    WRI$_ADV_DEF_EXEC_TYPES
    WRI$_ADV_DEF_PARAMETERS
    WRI$_ADV_DIRECTIVE_DEFS
    WRI$_ADV_DIRECTIVE_INSTANCES
    WRI$_ADV_DIRECTIVE_META
    WRI$_ADV_EXECUTIONS
    WRI$_ADV_EXEC_PARAMETERS
    WRI$_ADV_FINDINGS
    WRI$_ADV_INST_FDG
    WRI$_ADV_JOURNAL
    WRI$_ADV_MESSAGE_GROUPS
    WRI$_ADV_OBJECTS
    WRI$_ADV_PARAMETERS
    WRI$_ADV_RATIONALE
    WRI$_ADV_RECOMMENDATIONS
    WRI$_ADV_REC_ACTIONS
    WRI$_ADV_SEQ_DIR
    WRI$_ADV_SEQ_DIR_INST
    WRI$_ADV_SEQ_EXEC
    WRI$_ADV_SEQ_JOURNAL
    WRI$_ADV_SEQ_MSGGROUP
    WRI$_ADV_SEQ_SQLW_QUERY
    WRI$_ADV_SEQ_TASK
    WRI$_ADV_SQLA_COLVOL
    WRI$_ADV_SQLA_FAKE_REG
    WRI$_ADV_SQLA_MAP
    WRI$_ADV_SQLA_STMTS
    WRI$_ADV_SQLA_SUM
    WRI$_ADV_SQLA_TABLES
    WRI$_ADV_SQLA_TABVOL
    WRI$_ADV_SQLA_TMP
    WRI$_ADV_SQLT_BINDS
    WRI$_ADV_SQLT_PLANS
    WRI$_ADV_SQLT_PLAN_HASH
    WRI$_ADV_SQLT_PLAN_SEQ
    WRI$_ADV_SQLT_PLAN_STATS
    WRI$_ADV_SQLT_RTN_PLAN
    WRI$_ADV_SQLT_STATISTICS
    WRI$_ADV_SQLW_COLVOL
    WRI$_ADV_SQLW_STMTS
    WRI$_ADV_SQLW_SUM
    WRI$_ADV_SQLW_TABLES
    WRI$_ADV_SQLW_TABVOL
    WRI$_ADV_TASKS
    WRI$_ADV_USAGE
    WRI$_AGGREGATION_ENABLED
    WRI$_ALERT_HISTORY
    WRI$_ALERT_OUTSTANDING
    WRI$_ALERT_SEQUENCE
    WRI$_ALERT_THRESHOLD
    WRI$_ALERT_THRESHOLD_LOG
    WRI$_ALERT_THRSLOG_SEQUENCE
    WRI$_DBU_CPU_USAGE
    WRI$_DBU_CPU_USAGE_SAMPLE
    WRI$_DBU_FEATURE_METADATA
    WRI$_DBU_FEATURE_USAGE
    WRI$_DBU_HIGH_WATER_MARK
    WRI$_DBU_HWM_METADATA
    WRI$_DBU_USAGE_SAMPLE
    WRI$_OPTSTAT_AUX_HISTORY
    WRI$_OPTSTAT_HISTGRM_HISTORY
    WRI$_OPTSTAT_HISTHEAD_HISTORY
    WRI$_OPTSTAT_IND_HISTORY
    WRI$_OPTSTAT_OPR
    WRI$_OPTSTAT_SYNOPSIS$
    WRI$_OPTSTAT_SYNOPSIS_HEAD$
    WRI$_OPTSTAT_SYNOPSIS_PARTGRP
    WRI$_OPTSTAT_TAB_HISTORY
    WRI$_REPT_ABSTRACT_T
    WRI$_REPT_COMPONENTS
    WRI$_REPT_COMP_ID_SEQ
    WRI$_REPT_DBREPLAY
    WRI$_REPT_FILES
    WRI$_REPT_FILE_ID_SEQ
    WRI$_REPT_FORMATS
    WRI$_REPT_FORMAT_ID_SEQ
    WRI$_REPT_PLAN_DIFF
    WRI$_REPT_REPORTS
    WRI$_REPT_REPT_ID_SEQ
    WRI$_REPT_SQLMONITOR
    WRI$_REPT_SQLPI
    WRI$_REPT_SQLT
    WRI$_REPT_XPLAN
    WRI$_SCH_CONTROL
    WRI$_SCH_VOTES
    WRI$_SEGADV_CNTRLTAB
    WRI$_SEGADV_OBJLIST
    WRI$_SQLMON_USAGE
    WRI$_SQLSET_BINDS
    WRI$_SQLSET_DEFINITIONS
    WRI$_SQLSET_ID_SEQ
    WRI$_SQLSET_MASK
    WRI$_SQLSET_PLANS
    WRI$_SQLSET_PLANS_TOCAP
    WRI$_SQLSET_PLAN_LINES
    WRI$_SQLSET_REFERENCES
    WRI$_SQLSET_REF_ID_SEQ
    WRI$_SQLSET_STATEMENTS
    WRI$_SQLSET_STATISTICS
    WRI$_SQLSET_STMT_ID_SEQ
    WRI$_SQLSET_STS_TOPACK
    WRI$_SQLSET_WORKSPACE
    WRI$_SQLSET_WORKSPACE_PLANS
    WRI$_SQLSET_WORKSPACE_PLAN_SEQ
    WRI$_SQLTEXT_REFCOUNT
    WRI$_TRACING_ENABLED
    WRM$_BASELINE
    WRM$_BASELINE_DETAILS
    WRM$_BASELINE_TEMPLATE
    WRM$_COLORED_SQL
    WRM$_DATABASE_INSTANCE
    WRM$_SNAPSHOT
    WRM$_SNAPSHOT_DETAILS
    WRM$_SNAP_ERROR
    WRM$_WR_CONTROL
    WRM$_WR_USAGE
    WRR$_CAPTURES
    WRR$_CAPTURE_ID
    WRR$_CAPTURE_STATS
    WRR$_CAPTURE_UC_GRAPH
    WRR$_CONNECTION_MAP
    WRR$_FILTERS
    WRR$_REPLAYS
    WRR$_REPLAY_CALL_FILTER
    WRR$_REPLAY_COMMITS
    WRR$_REPLAY_DATA
    WRR$_REPLAY_DEP_GRAPH
    WRR$_REPLAY_DIVERGENCE
    WRR$_REPLAY_FILTER_SET
    WRR$_REPLAY_ID
    WRR$_REPLAY_REFERENCES
    WRR$_REPLAY_SCN_ORDER
    WRR$_REPLAY_SEQ_DATA
    WRR$_REPLAY_SQL_BINDS
    WRR$_REPLAY_SQL_TEXT
    WRR$_REPLAY_STATS
    WRR$_REPLAY_UC_GRAPH
    WRR$_SEQUENCE_EXCEPTIONS
    WRR$_WORKLOAD_ATTRIBUTES
    WS
    _ACTUAL_EDITION_OBJ
    _ALL_QUEUE_SCHEDULES
    _ALL_REPL_NESTED_TABLE_NAMES
    _ALL_SQLSET_STS_TOPACK
    _ALL_STREAMS_PROCESSES
    _ALL_SYNONYMS_FOR_AUTH_OBJECTS
    _ALL_SYNONYMS_FOR_SYNONYMS
    _ALL_SYNONYMS_TREE
    _BASE_USER
    _CURRENT_EDITION_OBJ
    _DBA_APPLY
    _DBA_APPLY_CHANGE_HANDLERS
    _DBA_APPLY_CONF_HDLR_COLUMNS
    _DBA_APPLY_CONSTRAINT_COLUMNS
    _DBA_APPLY_DML_CONF_HANDLERS
    _DBA_APPLY_ERROR
    _DBA_APPLY_ERROR_HANDLER
    _DBA_APPLY_ERROR_TXN
    _DBA_APPLY_INST_GLOBAL
    _DBA_APPLY_INST_OBJECTS
    _DBA_APPLY_INST_SCHEMAS
    _DBA_APPLY_MILESTONE
    _DBA_APPLY_OBJECTS
    _DBA_APPLY_OBJECT_CONSTRAINTS
    _DBA_APPLY_PROGRESS
    _DBA_APPLY_SOURCE_OBJ
    _DBA_APPLY_SOURCE_SCHEMA
    _DBA_APPLY_SPILL_TXN
    _DBA_APPLY_TABLE_COLUMNS
    _DBA_APPLY_TABLE_COLUMNS_H
    _DBA_CAPTURE
    _DBA_COMPARISON_SCAN
    _DBA_QUEUE_SCHEDULES
    _DBA_QUEUE_SCHEDULES_COMPAT
    _DBA_REPL_NESTED_TABLE_NAMES
    _DBA_STREAMS_ACTIONS
    _DBA_STREAMS_COMPONENT
    _DBA_STREAMS_COMPONENT_EVENT
    _DBA_STREAMS_COMPONENT_LINK
    _DBA_STREAMS_COMPONENT_PROP
    _DBA_STREAMS_COMPONENT_STAT
    _DBA_STREAMS_FINDINGS
    _DBA_STREAMS_MESSAGE_CONSUMERS
    _DBA_STREAMS_MESSAGE_RULES
    _DBA_STREAMS_MSG_NOTIFICATIONS
    _DBA_STREAMS_NEWLY_SUPTED_10_1
    _DBA_STREAMS_NEWLY_SUPTED_10_2
    _DBA_STREAMS_NEWLY_SUPTED_11_1
    _DBA_STREAMS_NEWLY_SUPTED_11_2
    _DBA_STREAMS_PRIVILEGED_USER
    _DBA_STREAMS_PROCESSES
    _DBA_STREAMS_QUEUES
    _DBA_STREAMS_RECOMMENDATIONS
    _DBA_STREAMS_RULES
    _DBA_STREAMS_RULES_H
    _DBA_STREAMS_STMTS
    _DBA_STREAMS_STMT_HANDLERS
    _DBA_STREAMS_TP_COMPONENT_PROP
    _DBA_STREAMS_TRANSFM_FUNCTION
    _DBA_STREAMS_TRANSFORMATIONS
    _DBA_STREAMS_UNSUPPORTED_10_1
    _DBA_STREAMS_UNSUPPORTED_10_2
    _DBA_STREAMS_UNSUPPORTED_11_1
    _DBA_STREAMS_UNSUPPORTED_11_2
    _DBA_STREAMS_UNSUPPORTED_9_2
    _DBA_TRIGGER_ORDERING
    _DBA_XSTREAM_CONNECTION
    _DBA_XSTREAM_OUTBOUND
    _DBA_XSTREAM_PARAMETERS
    _DEFSCHEDULE
    _DEFTRANDEST
    _REPORT_COMPONENT_OBJECTS
    _REPORT_FORMATS
    _USER_COMPARISON_ROW_DIF
    _USER_FILE_GROUPS
    _USER_QUEUE_SCHEDULES
    _USER_QUEUE_SCHEDULES_COMPAT
    _USER_REPL_NESTED_TABLE_NAMES
    _default_auditing_options_
    _utl$_gnp_ind
    _utl$_gp_ind_parts
    _utl$_lc_ind_subs
    _utl$_lnc_ind_parts
    aggregatePrivilege156_TAB
    description142_TAB
    description152_TAB
    fallback59_TAB
    fallback60_TAB
    fallback78_TAB
    fallback79_TAB
    ftp-log38_TAB
    http-log47_TAB
    include64_TAB
    include83_TAB
    privilege155_TAB
    table
    title141_TAB
    title151_TAB
    xdb-log30_TAB
  #;

  @system_tables = map {quotemeta $_} @system_tables;
  push @system_tables, 'BIN';
  my $system_table_re = '^(' . join('|', @system_tables) . ')$';
  
  has exclude_table => sub {
      return $system_table_re;
  };

  has dsn => 'dbi:Oracle:host=localhost;port=1521;sid=XE';
  has user  => 'dbix_custom';
  has password => 'dbix_custom';

  sub create_table1 { "create table $table1 ($key1 varchar2(255), $key2 varchar2(255))" }
  sub create_table1_2 { "create table $table1 ($key1 varchar2(255), $key2 varchar2(255), "
   . "$key3 varchar2(255), $key4 varchar2(255), $key5 varchar2(255))" }
  sub create_table1_type { "create table $table1 ($key1 $date_typename, $key2 $datetime_typename)" }
  sub create_table1_highperformance { "create table $table1 ($key1 varchar2(255), $key2 varchar2(255), "
    . "$key3 varchar2(255), $key4 varchar2(255), $key5 varchar2(255), $key6 varchar2(255), $key7 varchar2(255))" }
  sub create_table2 { "create table $table2 ($key1 varchar2(255), $key3 varchar2(255))" }
  sub create_table2_2 { "create table $table2 ($key1 varchar2(255), $key2 varchar2(255), $key3 varchar2(255))" }
  sub create_table3 { "create table $table3 ($key1 varchar2(255), $key2 varchar2(255), $key3 varchar2(255))" }
  sub create_table_reserved { 'create table "table" ("select" varchar2(255), "update" varchar2(255))' }
}

require "$FindBin::Bin/common.t";
