package Firefox::Marionette::Extension::Stealth;

use strict;
use warnings;

our $VERSION = '1.52';

sub as_string {
    return <<'_BASE64_';
UEsDBBQAAAAIABVRQ1j2/GCpkQAAANAAAAAKABwAY29udGVudC5qc1VUCQAD+XW9ZUJ2vWV1eAsA
AQToAwAABOgDAABNjj0OwyAMhfecgg1YuEDUqerWqVIPgIxbiIKJjJMl6d1Llf5Nfpa+p/ctnlUF
TpOogwoF5owkDhi94GnE12f0Dmjbd3tylaHhELlkdDyTpHbvKNfL2ehEA4K4of4VCo3Fh9a5zQSS
ChmrViUxVceYy4LG9urRd+arELHx2/Zz+oS3lXV+mpDCMaYxmH2m7T0BUEsDBBQAAAAIANFWQ1jp
hxjLTgAAAG8AAAAJABwAaW5qZWN0LmpzVVQJAAO6gL1l5IK9ZXV4CwABBOgDAAAE6AMAAMtJLVHI
SywLKMovyVewVfBPykpNLtFLTy0Bi5RUFqT6p2mUZ+al5JfrAdVlpieW5BdpWnOlpOaklqTCteqV
pyalFGWWpRYhS0FUI8sBAFBLAwQUAAAACACuiENYLJ9dYNwAAACiAQAADQAcAG1hbmlmZXN0Lmpz
b25VVAkAA6jXvWWr171ldXgLAAEE6AMAAAToAwAAhVA9T8MwEN3zKyzPVQWMEWJkY4INVdbFvVCD
Y1d356pS1f/O2UkbNhbL977Oz5fOGLtH9hSOEnKyvbGvgXDM575/A1IIRdC8C0KUg8GzYOIq3FTn
BCmMyOJOSDzbnxqRYMI/Web/qDXBPm4fZuyINAWuMCv+qZCC4CWc8AOGplFAYODbfSmSvqzOuxbi
c9JF4mZqDbq0s5UQf8BG2GeI0RWK/GJ3m5vge+aWoK2OK9fMDoZcxA0R0o9KhQreBVSSA6m19tmX
qb1EgMTeFXXlSPphvHgbca0Fumv3C1BLAQIeAxQAAAAIABVRQ1j2/GCpkQAAANAAAAAKABgAAAAA
AAEAAACkgQAAAABjb250ZW50LmpzVVQFAAP5db1ldXgLAAEE6AMAAAToAwAAUEsBAh4DFAAAAAgA
0VZDWOmHGMtOAAAAbwAAAAkAGAAAAAAAAQAAAKSB1QAAAGluamVjdC5qc1VUBQADuoC9ZXV4CwAB
BOgDAAAE6AMAAFBLAQIeAxQAAAAIAK6IQ1gsn11g3AAAAKIBAAANABgAAAAAAAEAAACkgWYBAABt
YW5pZmVzdC5qc29uVVQFAAOo171ldXgLAAEE6AMAAAToAwAAUEsFBgAAAAADAAMA8gAAAIkCAAAA
AA==
_BASE64_
}

1;    # Magic true value required at end of module
__END__

=head1 NAME

Firefox::Marionette::Extension::Stealth - Contains the Stealth Extension

=head1 VERSION

Version 1.52

=head1 SYNOPSIS

    use Firefox::Marionette();
    use v5.10;

    my $firefox = Firefox::Marionette->new(stealth => 1);
    $firefox->go("https://fastapi.metacpan.org/v1/download_url/Firefox::Marionette");

=head1 DESCRIPTION

This module contains the Stealth extension.  This module should not be used directly.  It is required when the 'stealth' parameter is supplied to the L<new|Firefox::Marionette#new> method in L<Firefox::Marionette|Firefox::Marionette>.

=head1 SUBROUTINES/METHODS

=head2 as_string
 
Returns a base64 encoded copy of the Stealth extension.

=head1 DIAGNOSTICS

None.

=head1 CONFIGURATION AND ENVIRONMENT

Firefox::Marionette::Extension::Stealth requires no configuration files or environment variables.

=head1 DEPENDENCIES

None.

=head1 INCOMPATIBILITIES

None reported.

=head1 BUGS AND LIMITATIONS

To report a bug, or view the current list of bugs, please visit L<https://github.com/david-dick/firefox-marionette/issues>

=head1 AUTHOR

David Dick  C<< <ddick@cpan.org> >>

=head1 LICENSE AND COPYRIGHT

Copyright (c) 2024, David Dick C<< <ddick@cpan.org> >>. All rights reserved.

This module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself. See L<perlartistic/perlartistic>.

=head1 DISCLAIMER OF WARRANTY

BECAUSE THIS SOFTWARE IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE SOFTWARE, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE SOFTWARE "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOFTWARE IS WITH
YOU. SHOULD THE SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL
NECESSARY SERVICING, REPAIR, OR CORRECTION.

IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE SOFTWARE AS PERMITTED BY THE ABOVE LICENCE, BE
LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE
THE SOFTWARE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING
RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
FAILURE OF THE SOFTWARE TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF
SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGES.
