# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20221202211026;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[0568]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15[0-25-9]\\d{8}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"495282", "Schieder\-Schwalenberg",
"496574", "Hasborn",
"495742", "Preussisch\ Oldendorf",
"499282", "Naila",
"496586", "Beuren\ Hochwald",
"499742", "Kalbach\ Rhön",
"496761", "Simmern\ Hunsrück",
"497955", "Wallhausen\ Württemberg",
"4939086", "Jävenitz",
"498637", "Lohkirchen",
"497269", "Sulzfeld\ Baden",
"497446", "Lossburg",
"499484", "Brennberg",
"495476", "Ostercappeln\-Venne",
"493464", "Sangerhausen",
"498628", "Kienberg\ Oberbayern",
"495484", "Lienen\-Kattenvenne",
"496139", "Budenheim",
"497354", "Erolzheim",
"4934920", "Kropstädt",
"497251", "Bruchsal",
"493433", "Borna\ Stadt",
"492166", "Mönchengladbach\-Rheydt",
"4935329", "Dollenchen",
"4939293", "Dreileben",
"4933454", "Wölsickendorf\/Wollenberg",
"4937325", "Niederbobritzsch",
"494238", "Neddenaverbergen",
"4934722", "Preusslitz",
"4939388", "Goldbeck\ Altm",
"492606", "Winningen\ Mosel",
"494393", "Boostedt",
"4935249", "Basslitz",
"4936203", "Vieselbach",
"495906", "Lünne",
"4937462", "Rothenkirchen\ Vogtland",
"499906", "Mariaposching",
"4936948", "Römhild",
"4936693", "Crossen\ an\ der\ Elster",
"498295", "Altenmünster\ Schwaben",
"492874", "Isselburg",
"4936377", "Rastenberg",
"495126", "Algermissen",
"4935792", "Ossling",
"499126", "Eckental",
"496505", "Kordel",
"494178", "Radbruch",
"495707", "Petershagen\ Weser",
"496723", "Oestrich\-Winkel",
"494493", "Friesoythe\-Gehlenberg",
"4939005", "Kusey",
"498584", "Breitenberg\ Niederbayern",
"497564", "Bad\ Wurzach",
"4936965", "Stadtlengsfeld",
"497346", "Illerkirchberg",
"493965", "Burow\ bei\ Altentreptow",
"4939603", "Burg\ Stargard",
"497533", "Allensbach",
"492743", "Daaden",
"497771", "Stockach",
"494337", "Jevenstedt",
"497252", "Bretten",
"4939927", "Nossentiner\ Hütte",
"4939084", "Lindstedt",
"499741", "Bad\ Brückenau",
"492685", "Flammersfeld",
"499281", "Hof\ Saale",
"497220", "Forbach\-Hundsbach",
"4933920", "Walsleben\ bei\ Neuruppin",
"4937431", "Mehltheuer\ Vogtland",
"494328", "Rickling",
"495741", "Lübbecke",
"495281", "Bad\ Pyrmont",
"497454", "Sulz\ am\ Neckar",
"4933456", "Wriezen",
"499376", "Collenberg",
"495384", "Seesen\-Gross\ Rhüden",
"493364", "Eisenhüttenstadt",
"493546", "Lübben\ Spreewald",
"499384", "Schwanfeld",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"496762", "Kastellaun",
"497940", "Künzelsau",
"492409", "Stolberg\-Gressenich",
"4935606", "Briesen\ bei\ Cottbus",
"492501", "Münster\-Hiltrup",
"498057", "Aschau\-Sachrang",
"494121", "Elmshorn",
"494883", "Süderstapel",
"498303", "Waltenhofen",
"499503", "Oberhaid\ Oberfranken",
"494902", "Jemgum\-Ditzum",
"499725", "Poppenhausen\ Unterfranken",
"49611", "Wiesbaden",
"495503", "Nörten\-Hardenberg",
"496527", "Oberweis",
"499867", "Geslau",
"4936701", "Lichte",
"495725", "Lindhorst\ bei\ Stadthagen",
"496047", "Altenstadt\ Hessen",
"494371", "Burg\ auf\ Fehmarn",
"4933932", "Fehrbellin",
"496681", "Hilders",
"4934636", "Schafstädt",
"492547", "Rosendahl\-Osterwick",
"4939748", "Viereck",
"494286", "Gyhum",
"4936020", "Ebeleben",
"494746", "Hagen\ bei\ Bremerhaven",
"497157", "Waldenbuch",
"494274", "Varrel\ bei\ Sulingen",
"4934346", "Narsdorf",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"499094", "Tagmersheim",
"496802", "Völklingen\-Lauterbach",
"494472", "Lastrup",
"4935471", "Birkenhainchen",
"497728", "Niedereschach",
"498671", "Altötting",
"495187", "Delligsen",
"499187", "Altdorf\ bei\ Nürnberg",
"496002", "Ober\-Mörlen",
"492838", "Sonsbeck",
"497936", "Schrozberg\-Bartenstein",
"494947", "Aurich\-Ogenbargen",
"4934344", "Kohren\-Sahlis",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"494471", "Cloppenburg",
"493943", "Wernigerode",
"4939030", "Brunau",
"496682", "Tann\ Rhön",
"4938323", "Prohn",
"494372", "Westfehmarn",
"494134", "Embsen\ Kreis\ Lüneburg",
"493641", "Jena",
"495300", "Salzgitter\-Üfingen",
"494754", "Bülkau",
"492827", "Goch\-Hassum",
"494163", "Horneburg\ Niederelbe",
"495067", "Bockenem",
"498403", "Pförring",
"4935604", "Krieschow",
"4935021", "Königstein\ Sächsische\ Schweiz",
"4934224", "Belgern\ Sachsen",
"492309", "Waltrop",
"494603", "Havetoft",
"494205", "Ottersberg",
"494122", "Uetersen",
"4939058", "Uthmöden",
"492502", "Nottuln",
"498857", "Benediktbeuern",
"4938841", "Neuhaus\ Elbe",
"4936423", "Orlamünde",
"499948", "Eschlkam",
"4935892", "Horka\ OL",
"495948", "Itterbeck",
"4936481", "Neustadt\ an\ der\ Orla",
"494188", "Welle\ Nordheide",
"493831", "Stralsund",
"4933708", "Rangsdorf",
"4937291", "Augustusburg",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"499405", "Bad\ Abbach",
"495271", "Höxter",
"496628", "Oberaula",
"498139", "Röhrmoos",
"4938370", "Kröslin",
"4936459", "Blankenhain\ Thüringen",
"499271", "Thurnau\-Alladorf",
"492675", "Ediger\-Eller",
"495752", "Auetal\-Hattendorf",
"499374", "Eschau",
"499132", "Herzogenaurach",
"497456", "Haiterbach",
"499386", "Prosselsheim",
"495374", "Isenbüttel",
"495132", "Lehrte",
"4935057", "Hermsdorf\ Erzgebirge",
"4937328", "Grossschirma",
"497945", "Wüstenrot",
"493544", "Luckau\ Brandenburg",
"493366", "Beeskow",
"495975", "Rheine\-Mesum",
"497566", "Argenbühl",
"497344", "Blaubeuren",
"4936945", "Henneberg",
"498586", "Hauzenberg",
"499975", "Waldmünchen\-Geigant",
"498574", "Wittibreut",
"4938873", "Carlow",
"496637", "Feldatal",
"494892", "Schenefeld\ Mittelholstein",
"492273", "Kerpen\-Horrem",
"499720", "Üchtelhausen",
"498761", "Moosburg\ an\ der\ Isar",
"494735", "Butjadingen\-Stollhamm",
"493466", "Artern\ Unstrut",
"4935952", "Grossröhrsdorf\ OL",
"495474", "Stemwede\-Dielingen",
"497356", "Schemmerhofen",
"495769", "Steyerberg\-Voigtei",
"499474", "Schmidmühlen",
"492133", "Dormagen",
"497242", "Rheinstetten",
"4938732", "Gallin\ bei\ Lübz",
"498762", "Wartenberg\ Oberbayern",
"494155", "Büchen",
"492753", "Erndtebrück",
"492164", "Jüchen\-Otzenrath",
"495751", "Rinteln",
"4939008", "Kunrau",
"499272", "Fichtelberg",
"496584", "Wellen\ Mosel",
"495272", "Brakel\ Westfalen",
"495131", "Garbsen",
"4938309", "Trent",
"497444", "Alpirsbach",
"499131", "Erlangen",
"497308", "Nersingen",
"4936041", "Bad\ Tennstedt",
"496693", "Neuental",
"495904", "Lengerich\ Emsl",
"4937601", "Mülsen\ Skt\ Jacob",
"4936968", "Rossdorf\ Rhön",
"498505", "Hutthurm",
"499904", "Lalling",
"498723", "Arnstorf",
"497839", "Schapbach",
"499305", "Estenfeld",
"495305", "Sickte",
"496295", "Rosenberg\ Baden",
"492604", "Nassau\ Lahn",
"494382", "Wangels",
"496672", "Eiterfeld",
"492557", "Wettringen\ Kreis\ Steinfurt",
"498802", "Huglfing",
"494136", "Scharnebeck",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"4938234", "Born\ Darss",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"497147", "Sachsenheim\ Württemberg",
"497335", "Wiesensteig",
"494756", "Odisheim",
"4933366", "Chorin",
"499177", "Heideck",
"494708", "Ringstedt",
"497934", "Weikersheim",
"493535", "Herzberg\ Elster",
"497661", "Kirchzarten",
"4936253", "Georgenthal\ Thüringer\ Wald",
"498681", "Waging\ am\ See",
"495177", "Edemissen\-Abbensen",
"494481", "Hatten\-Sandkrug",
"4935436", "Laasow\ bei\ Calau",
"4934364", "Wermsdorf",
"4938720", "Grebbin",
"497963", "Adelmannsfelden",
"492394", "Neuenrade\-Affeln",
"4939951", "Faulenrost",
"497950", "Schnelldorf",
"499338", "Röttingen\ Unterfranken",
"49811", "Hallbergmoos",
"495695", "Twistetal",
"4939745", "Hetzdorf\ bei\ Strasburg",
"492291", "Waldbröl",
"495293", "Paderborn\-Dahl",
"499293", "Berg\ Oberfranken",
"496057", "Flörsbachtal",
"498538", "Pocking\-Hartkirchen",
"495327", "Bad\ Grund\ Harz",
"492268", "Kürten",
"496303", "Enkenbach\-Alsenborn",
"494140", "Estorf\ Kreis\ Stade",
"493877", "Wittenberge",
"497623", "Rheinfelden\ Baden",
"4933830", "Ziesar",
"499438", "Fensterbach",
"496857", "Namborn",
"495438", "Bakum\-Lüsche",
"499427", "Leiblfing",
"495427", "Melle\-Buer",
"496403", "Linden\ Hessen",
"4933333", "Tantow",
"498847", "Obersöchering",
"494873", "Aukrug",
"492292", "Windeck\ Sieg",
"492680", "Mündersbach",
"497225", "Gaggenau",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"498682", "Laufen\ Salzach",
"497435", "Albstadt\-Laufen",
"4933671", "Lieberose",
"4934973", "Osternienburg",
"495237", "Augustdorf",
"494957", "Detern",
"494482", "Hatten",
"499228", "Thurnau",
"4939055", "Hörsingen",
"495228", "Vlotho\-Exter",
"49781", "Offenburg",
"492367", "Henrichenburg",
"498801", "Seeshaupt",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"494381", "Lütjenburg",
"496500", "Waldrach",
"494744", "Loxstedt",
"4935387", "Seyda",
"494284", "Selsingen",
"4935434", "Altdöbern",
"494276", "Borstel\ bei\ Sulingen",
"493531", "Finsterwalde",
"497665", "March\ Breisgau",
"496133", "Oppenheim",
"498685", "Kirchanschöring",
"493773", "Johanngeorgenstadt",
"495156", "Coppenbrügge",
"497432", "Albstadt\-Tailfingen",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"4933702", "Wünsdorf",
"496164", "Reichelsheim\ Odenwald",
"496753", "Meisenheim",
"499736", "Oberthulba",
"494485", "Elsfleth\-Huntorf",
"4935841", "Grossschönau\ Sachsen",
"497234", "Tiefenbronn",
"492584", "Warendorf\-Milte",
"498283", "Neuburg\ an\ der\ Kammel",
"497263", "Waibstadt",
"495108", "Gehrden\ Han",
"494777", "Cadenberge",
"498743", "Geisenhausen",
"497331", "Geislingen\ an\ der\ Steige",
"493844", "Schwaan",
"492693", "Antweiler",
"497250", "Kraichtal",
"494358", "Loose\ bei\ Eckernförde",
"4939264", "Kroppenstedt",
"496084", "Schmitten\ Taunus",
"497424", "Spaichingen",
"4937465", "Tannenbergsthal\ Vogtland",
"492991", "Marsberg\-Bredelar",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"4937322", "Brand\-Erbisdorf",
"4935873", "Herrnhut",
"492295", "Ruppichteroth",
"497222", "Rastatt",
"495691", "Bad\ Arolsen",
"4939921", "Ankershagen",
"4939266", "Förderstedt",
"4935795", "Königsbrück",
"4933979", "Wusterhausen\ Dosse",
"4936840", "Trusetal",
"497324", "Herbrechtingen",
"494499", "Barssel",
"495692", "Wolfhagen",
"499280", "Selbitz\ Oberfranken",
"498074", "Schnaitsee",
"494458", "Wiefelstede\-Spohle",
"497221", "Baden\-Baden",
"4939002", "Oebisfelde",
"497066", "Bad\ Rappenau\-Bonfeld",
"498086", "Buchbach\ Oberbayern",
"494406", "Berne",
"4936259", "Tabarz\ Thüringer\ Wald",
"496648", "Bad\ Salzschlirf",
"4938738", "Karow\ bei\ Lübz",
"4937437", "Bad\ Elster",
"492992", "Marsberg",
"4937384", "Wechselburg",
"496876", "Weiskirchen\ Saar",
"494385", "Hohenfelde\ bei\ Kiel",
"496675", "Breitenbach\ am\ Herzberg",
"4936371", "Schlossvippach",
"498805", "Hohenpeissenberg",
"492628", "Rhens",
"495937", "Geeste\-Gross\ Hesepe",
"494257", "Schweringen",
"497332", "Lauterstein",
"497174", "Mögglingen",
"498166", "Allershausen\ Oberbayern",
"499937", "Oberpöring",
"4936962", "Vacha",
"499144", "Pleinfeld",
"497431", "Albstadt\-Ebingen",
"495144", "Wathlingen",
"499928", "Kirchdorf\ im\ Wald",
"4935930", "Seitschen",
"494976", "Spiekeroog",
"492637", "Weissenthurm",
"4938750", "Malliss",
"495248", "Langenberg\ Kreis\ Gütersloh",
"495509", "Rosdorf\ Kreis\ Göttingen",
"49341", "Leipzig",
"499401", "Neutraubling",
"492857", "Rees\-Mehr",
"498502", "Fürstenzell",
"494724", "Cuxhaven\-Lüdingworth",
"495401", "Georgsmarienhütte",
"492403", "Eschweiler\ Rheinland",
"499302", "Rottendorf\ Unterfranken",
"4935477", "Rietzneuendorf\-Friedrichshof",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"495302", "Vechelde",
"4938303", "Sellin\ Ostseebad",
"496292", "Seckach",
"495447", "Lembruch",
"494732", "Stadland\-Rodenkirchen",
"4933206", "Fichtenwalde",
"499971", "Cham",
"4935263", "Gröditz\ bei\ Riesa",
"499447", "Essing",
"493636", "Greussen",
"495971", "Rheine",
"497245", "Durmersheim",
"499673", "Tiefenbach\ Oberpfalz",
"498765", "Bruckberg\ Niederbayern",
"494152", "Geesthacht",
"4934204", "Schkeuditz",
"49203", "Duisburg",
"495673", "Immenhausen\ Hessen",
"497643", "Herbolzheim\ Breisgau",
"499275", "Speichersdorf",
"492671", "Cochem",
"494120", "Ellerhoop",
"495275", "Höxter\-Ottbergen",
"497941", "Öhringen",
"492973", "Eslohe\ Sauerland",
"497477", "Jungingen\ bei\ Hechingen",
"4933967", "Freyenstein",
"496557", "Hallschlag",
"498038", "Vogtareuth",
"4933204", "Beelitz\ Mark",
"492672", "Treis\-Karden",
"495755", "Kalletal\-Varenholz",
"493949", "Oschersleben\ Bode",
"494169", "Sauensiek",
"499135", "Hessdorf\ Mittelfranken",
"499347", "Wittighausen",
"495135", "Burgwedel\-Fuhrberg",
"4935027", "Weesenstein",
"495347", "Burgdorf\ bei\ Salzgitter",
"497942", "Neuenstein\ Württemberg",
"4934206", "Rötha",
"499972", "Waldmünchen",
"498547", "Osterhofen\-Gergweis",
"4936783", "Gehren\ Thüringen",
"494731", "Nordenham",
"496467", "Hatzfeld\ Eder",
"498027", "Dietramszell",
"494151", "Schwarzenbek",
"495301", "Lehre\-Essenrode",
"4936453", "Mellingen",
"497138", "Schwaigern",
"49331", "Potsdam",
"496394", "Bundenthal",
"499204", "Plankenfels",
"496291", "Adelsheim",
"495204", "Steinhagen\ Westfalen",
"497706", "Oberbaldingen",
"494609", "Eggebek",
"498670", "Reischach\ Kreis\ Altötting",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"498501", "Thyrnau",
"49751", "Ravensburg",
"492303", "Unna",
"496268", "Hüffenhardt",
"499402", "Regenstauf",
"497127", "Neckartenzlingen",
"494348", "Schönkirchen",
"495721", "Stadthagen",
"494404", "Elsfleth",
"499721", "Schweinfurt",
"497240", "Pfinztal",
"496874", "Wadern\-Nunkirchen",
"4939246", "Lindau\ Anh",
"497033", "Weil\ Der\ Stadt",
"497326", "Neresheim",
"4935895", "Klitten",
"494202", "Achim\ bei\ Bremen",
"498076", "Pfaffing",
"494125", "Seestermühe",
"498084", "Taufkirchen\ Vils",
"492723", "Kirchhundem",
"499270", "Creussen",
"492505", "Altenberge\ Westfalen",
"499146", "Markt\ Berolzheim",
"4936334", "Wolkramshausen",
"4937468", "Treuen\ Vogtland",
"495146", "Wietze",
"4938850", "Gammelin",
"494974", "Neuharlingersiel",
"496283", "Hardheim\ Odenwald",
"4936644", "Hirschberg\ Saale",
"4938847", "Boizenburg\ Elbe",
"496743", "Bacharach",
"498133", "Haimhausen\ Oberbayern",
"4938353", "Gützkow\ bei\ Greifswald",
"4939382", "Kamern",
"497176", "Spraitbach",
"492762", "Wenden\ Südsauerland",
"4937297", "Thum\ Sachsen",
"497184", "Kaisersbach",
"498753", "Elsendorf\ Niederbayern",
"492586", "Beelen",
"4936336", "Klettenberg",
"497236", "Keltern",
"492574", "Saerbeck",
"4937607", "Ebersbrunn\ Sachsen",
"4936646", "Tanna\ bei\ Schleiz",
"492761", "Olpe\ Biggesee",
"494247", "Affinghausen",
"498273", "Nordendorf",
"495154", "Aerzen",
"4935955", "Pulsnitz",
"495763", "Uchte",
"499154", "Pommelsbrunn",
"496805", "Kleinblittersdorf",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"494475", "Molbergen",
"496166", "Fischbachtal",
"495734", "Bergkirchen\ Westfalen",
"4938735", "Plau\ am\ See",
"4939324", "Kläden\ bei\ Stendal",
"492759", "Bad\ Berleburg\-Aue",
"4938792", "Lenzen\ \(Elbe\)",
"499734", "Burkardroth",
"4935773", "Schleife",
"495130", "Wedemark",
"497833", "Hornberg\ Schwarzwaldbahn",
"496658", "Poppenhausen\ Wasserkuppe",
"499722", "Werneck",
"4939244", "Steutz",
"495722", "Bückeburg",
"497426", "Gosheim",
"496086", "Grävenwiesbach",
"496074", "Rödermark",
"493962", "Penzlin\ bei\ Waren",
"496838", "Saarwellingen",
"4939776", "Hintersee",
"495457", "Hopsten\-Schale",
"498367", "Rosshaupten\ Forggensee",
"492801", "Xanten",
"497387", "Hohenstein\ Württemberg",
"497255", "Graben\-Neudorf",
"4939957", "Gielow",
"494142", "Steinkirchen\ Kreis\ Stade",
"4938294", "Neubukow",
"4934424", "Reuden\ bei\ Zeitz",
"492682", "Hamm\ Sieg",
"497653", "Lenzkirch",
"499567", "Sesslach\-Gemünda",
"496827", "Eppelborn",
"495803", "Rosche",
"497951", "Crailsheim",
"496765", "Gemünden\ Hunsrück",
"499803", "Colmberg",
"494480", "Ovelgönne\-Strückhausen",
"494938", "Hagermarsch",
"495258", "Salzkotten",
"493923", "Zerbst",
"497704", "Geisingen\ Baden",
"498292", "Dinkelscherben",
"493621", "Gotha\ Thüringen",
"497660", "St\ Peter\ Schwarzwald",
"496396", "Hinterweidenthal",
"496502", "Schweich",
"4939742", "Brüssow\ bei\ Pasewalk",
"499206", "Mistelgau\-Obernsees",
"494927", "Krummhörn\-Loquard",
"4939862", "Schmölln\ bei\ Prenzlau",
"495206", "Bielefeld\-Jöllenbeck",
"496409", "Biebertal",
"4933677", "Glienicke\ bei\ Beeskow",
"4935820", "Zodel",
"498268", "Tussenhausen",
"495594", "Bovenden\-Reyershausen",
"497748", "Grafenhausen\ Hochschwarzwald",
"492538", "Drensteinfurt\-Rinkerode",
"496670", "Ludwigsau\ Hessen",
"496501", "Konz",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"499778", "Fladungen",
"497629", "Tegernau\ Baden",
"492527", "Lippetal\-Lippborg",
"498394", "Lautrach",
"49211", "Düsseldorf",
"494107", "Siek\ Kreis\ Stormarn",
"4935323", "Sonnewalde",
"493622", "Waltershausen\ Thüringen",
"498291", "Zusmarshausen",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"4939052", "Erxleben\ bei\ Haldensleben",
"4939774", "Mönkebude",
"493998", "Demmin",
"495745", "Stemwede\-Levern",
"499285", "Kirchenlamitz",
"492681", "Altenkirchen\ Westerwald",
"494667", "Dagebüll",
"499745", "Wildflecken",
"498467", "Kinding",
"496027", "Stockstadt\ am\ Main",
"497952", "Gerabronn",
"495357", "Grasleben",
"492983", "Winterberg\-Siedlinghausen",
"499357", "Gräfendorf\ Bayern",
"492802", "Alpen",
"498557", "Mauth",
"4939831", "Feldberg",
"4934426", "Kayna",
"4938296", "Rerik\ Ostseebad",
"493961", "Altentreptow",
"4935243", "Weinböhla",
"493634", "Sömmerda",
"494141", "Stade",
"495683", "Wabern\ Hessen",
"499683", "Friedenfels",
"497775", "Mühlingen",
"493663", "Schleiz",
"4936209", "Klettbach",
"499626", "Hohenburg",
"498193", "Geltendorf",
"497504", "Horgenzell",
"4939003", "Jübar",
"494846", "Hattstedt",
"492065", "Duisburg\-Rheinhausen",
"495626", "Bad\ Zwesten",
"497837", "Oberharmersbach",
"4939926", "Grabowhöfe",
"49521", "Bielefeld",
"49921", "Bayreuth",
"493304", "Velten",
"4933457", "Altreetz",
"493448", "Meuselwitz\ Thüringen",
"4936695", "Söllmnitz",
"494243", "Twistringen",
"4935844", "Oybin\ Kurort",
"496455", "Frankenau\ Hessen",
"49212", "Solingen",
"493475", "Lutherstadt\ Eisleben",
"4936376", "Straussfurt",
"498445", "Gerolsbach",
"4936963", "Dorndorf\ Rhön",
"4939605", "Gross\ Nemerow",
"495825", "Wieren",
"496565", "Dudeldorf",
"499825", "Herrieden",
"495767", "Warmsen",
"496287", "Limbach\ Baden",
"4933703", "Sperenberg",
"495545", "Hedemünden",
"494830", "Süderhastedt",
"493375", "Königs\ Wusterhausen",
"496747", "Emmelshausen",
"496639", "Ottrau",
"499545", "Buttenheim",
"4939295", "Zuchau",
"492666", "Freilingen\ Westerwald",
"4936374", "Weissensee",
"495025", "Estorf\ Weser",
"496355", "Albisheim\ Pfrimm",
"495190", "Soltau\-Emmingen",
"4936428", "Stadtroda",
"499190", "Heroldsbach",
"498137", "Petershausen",
"499966", "Wiesenfelden",
"498345", "Stöttwang",
"495966", "Meppen\-Apeldorn",
"497575", "Messkirch",
"4936205", "Gräfenroda",
"492158", "Grefrath\ bei\ Krefeld",
"492738", "Netphen",
"4939924", "Stuer",
"4939087", "Jerchel\ Altmark",
"496701", "Sprendlingen\ Rheinhessen",
"498378", "Buchenberg\ bei\ Kempten",
"494854", "Friedrichskoog",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"4937381", "Penig",
"492865", "Raesfeld",
"4937323", "Lichtenberg\ Erzgebirge",
"494526", "Ascheberg\ Holstein",
"4935872", "Neusalza\-Spremberg",
"496182", "Seligenstadt",
"492452", "Heinsberg\ Rheinland",
"494634", "Husby",
"494961", "Papenburg",
"499353", "Karlstadt",
"496336", "Dellfeld",
"498463", "Greding",
"497483", "Horb\-Mühringen",
"496023", "Alzenau\ in\ Unterfranken",
"495353", "Königslutter\ am\ Elm",
"494663", "Süderlügum",
"4938325", "Rolofshagen",
"496543", "Büchenbeuren",
"498434", "Rennertshofen",
"4933338", "Stolpe\/Oder",
"492369", "Dorsten\-Wulfen",
"494265", "Fintel",
"498171", "Wolfratshausen",
"4938462", "Baumgarten",
"492254", "Weilerswist",
"494959", "Dollart",
"498232", "Schwabmünchen",
"492562", "Gronau\ Westfalen",
"492351", "Lüdenscheid",
"498553", "Spiegelau",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"498422", "Dollnstein",
"496062", "Erbach\ Odenwald",
"495521", "Herzberg\ am\ Harz",
"496861", "Merzig",
"499521", "Hassfurt",
"4933637", "Beerfelde",
"499842", "Uffenheim",
"499429", "Rain\ Niederbayern",
"493726", "Flöha",
"4936452", "Berlstedt",
"495041", "Springe\ Deister",
"496440", "Kölschhausen",
"495842", "Schnega",
"495429", "Melle\-Wellingholzhausen",
"494622", "Taarstedt",
"496898", "Völklingen",
"498224", "Offingen\ Donau",
"497071", "Tübingen",
"492043", "Gladbeck",
"499360", "Thüngen",
"498321", "Sonthofen",
"494103", "Wedel",
"492523", "Wadersloh",
"498450", "Ingolstadt\-Zuchering",
"4934978", "Radegast\ Kreis\ Köthen",
"495329", "Schulenberg\ im\ Oberharz",
"496340", "Wörth\-Schaidt",
"4936258", "Friemar",
"496059", "Jossgrund",
"497072", "Gomaringen",
"4934637", "Frankleben",
"492843", "Rheinberg",
"49661", "Fulda",
"4934347", "Oelzschau\ bei\ Borna",
"498322", "Oberstdorf",
"494923", "Krummhörn\-Pewsum",
"499522", "Eltmann",
"4933978", "Segeletz",
"496226", "Meckesheim",
"4938302", "Sagard",
"495522", "Osterode\ am\ Harz",
"498421", "Eichstätt\ Bayern",
"496061", "Michelstadt",
"495841", "Lüchow\ Wendland",
"494621", "Schleswig",
"499841", "Bad\ Windsheim",
"495042", "Bad\ Münder\ am\ Deister",
"492246", "Lohmar\ Rheinland",
"498334", "Bad\ Grönenbach",
"492774", "Dietzhölztal",
"4935607", "Jänschwalde",
"499179", "Freystadt",
"495453", "Recke",
"498363", "Pfronten",
"496436", "Dornburg\ Hessen",
"497383", "Münsingen\-Buttenhausen",
"492352", "Altena\ Westfalen",
"492561", "Ahaus",
"499453", "Thalmassing",
"498231", "Königsbrunn\ bei\ Augsburg",
"4933201", "Gross\ Glienicke",
"495563", "Kreiensen",
"494962", "Papenburg\-Aschendorf",
"492451", "Geilenkirchen",
"499563", "Rödental",
"496181", "Hanau",
"493583", "Zittau",
"495807", "Altenmedingen",
"495534", "Eschershausen\ an\ der\ Lenne",
"497657", "Eisenbach\ Hochschwarzwald",
"492598", "Senden\-Ottmarsbocholt",
"499534", "Burgpreppach",
"4934691", "Könnern",
"496445", "Schöffengrund",
"4936075", "Dingelstädt\ Eichsfeld",
"499933", "Wallersdorf",
"494532", "Bargteheide",
"495933", "Lathen",
"494253", "Asendorf\ Kreis\ Diepholz",
"493984", "Prenzlau",
"497585", "Ostrach",
"498565", "Dietersburg\-Baumgarten",
"499631", "Tirschenreuth",
"499964", "Stallwang",
"492235", "Erftstadt",
"493976", "Torgelow\ bei\ Ueckermünde",
"4936331", "Ilfeld",
"495964", "Lähden",
"495631", "Korbach",
"492633", "Brohl\-Lützing",
"495365", "Wolfsburg\-Neindorf",
"4938793", "Dergenthin",
"493385", "Rathenow",
"494339", "Christiansholm",
"499365", "Rimpar",
"492664", "Rennerod",
"492931", "Arnsberg",
"494856", "Kronprinzenkoog",
"4935772", "Rietschen",
"4935054", "Lauenstein\ Sachsen",
"492104", "Mettmann",
"497391", "Ehingen\ Donau",
"494524", "Scharbeutz\-Pönitz",
"498702", "Wörth\ an\ der\ Isar",
"493591", "Bautzen",
"492425", "Nideggen\-Embken",
"496478", "Greifenstein\-Ulm",
"4939608", "Staven",
"498388", "Hergensweiler",
"494260", "Visselhövede\-Wittorf",
"492924", "Möhnesee",
"493592", "Kirschau",
"493306", "Gransee",
"4939298", "Barby\ Elbe",
"4935056", "Altenberg\ Sachsen",
"497558", "Illmensee",
"492697", "Blankenheim\-Ahrhütte",
"499624", "Ensdorf\ Oberpfalz",
"495624", "Bad\ Emstal",
"494844", "Pellworm",
"497506", "Wangen\-Leupolz",
"49771", "Donaueschingen",
"497392", "Laupheim",
"4936425", "Isserstedt",
"4939241", "Leitzkau",
"492325", "Wanne\-Eickel",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"499555", "Schlüsselfeld\-Aschbach",
"495555", "Moringen\-Fredelsloh",
"496757", "Becherbach\ bei\ Kirn",
"4936943", "Bettenhausen\ Thüringen",
"4936208", "Ermstedt",
"492932", "Neheim\-Hüsten",
"496345", "Albersweiler",
"492175", "Leichlingen\ Rheinland",
"4939321", "Arneburg",
"496128", "Taunusstein",
"497267", "Gemmingen",
"494531", "Bad\ Oldesloe",
"494773", "Lamstedt",
"498639", "Neumarkt\-Sankt\ Veit",
"499465", "Neukirchen\-Balbini",
"495632", "Willingen\ Upland",
"495465", "Neuenkirchen\ bei\ Bramsche",
"4939383", "Sandau\ Elbe",
"499632", "Waldsassen",
"4938352", "Kemnitz\ bei\ Greifswald",
"4933335", "Pinnow\ Kreis\ Uckermark",
"496224", "Sandhausen\ Baden",
"4938328", "Miltzow",
"495852", "Bleckede",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"495051", "Bergen\ Kreis\ Celle",
"499852", "Feuchtwangen",
"499820", "Lehrberg",
"498861", "Schongau",
"492307", "Kamen",
"494792", "Worpswede",
"497123", "Metzingen\ Württemberg",
"4935322", "Doberlug\-Kirchhain",
"49431", "Kiel",
"492053", "Velbert\-Neviges",
"496422", "Kirchhain",
"497082", "Neuenbürg\ Württemberg",
"496849", "Kirkel",
"495820", "Suhlendorf",
"498062", "Bruckmühl\ Mangfall",
"4935386", "Prettin",
"495069", "Nordstemmen",
"49209", "Gelsenkirchen",
"493573", "Senftenberg",
"496171", "Oberursel\ Taunus",
"493731", "Freiberg\ Sachsen",
"499343", "Lauda\-Königshofen",
"496553", "Schönecken",
"4939053", "Süplingen",
"495536", "Holzminden\-Neuhaus",
"496232", "Speyer",
"4939400", "Wefensleben",
"499536", "Kirchlauter",
"498336", "Erkheim",
"498023", "Bayrischzell",
"4934975", "Görzig\ Kreis\ Köthen",
"492244", "Königswinter\-Oberpleis",
"492776", "Bad\ Endbach\-Hartenrod",
"497162", "Süssen",
"498543", "Aidenbach",
"496434", "Bad\ Camberg",
"497373", "Zwiefalten",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"4935242", "Nossen",
"498823", "Mittenwald",
"495677", "Calden\-Westuffeln",
"497161", "Göppingen",
"492256", "Mechernich\-Satzvey",
"499677", "Oberviechtach\-Pullenried",
"499443", "Abensberg",
"4939771", "Ueckermünde",
"495443", "Lemförde",
"4936255", "Goldbach\ bei\ Gotha",
"492441", "Kall",
"494636", "Langballig",
"497473", "Mössingen",
"492977", "Schmallenberg\-Bödefeld",
"497159", "Renningen",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"496334", "Thaleischweiler\-Fröschen",
"496231", "Hochdorf\-Assenheim",
"497739", "Hilzingen",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"492208", "Niederkassel",
"496363", "Niederkirchen",
"492853", "Schermbeck",
"496421", "Marburg",
"497081", "Bad\ Wildbad",
"498061", "Bad\ Aibling",
"498226", "Bibertal",
"498862", "Steingaden\ Oberbayern",
"496049", "Kefenrod",
"494791", "Osterholz\-Scharmbeck",
"499869", "Wettringen\ Mittelfranken",
"494835", "Albersdorf\ Holstein",
"4933367", "Friedrichswalde\ Brandenburg",
"497570", "Sigmaringen\-Gutenstein",
"494768", "Hipstedt",
"49861", "Traunstein",
"4939743", "Zerrenthin",
"498340", "Baisweil",
"4939863", "Seehausen\ bei\ Prenzlau",
"499195", "Adelsdorf\ Mittelfranken",
"495052", "Hermannsburg",
"499851", "Dinkelsbühl",
"493724", "Burgstädt",
"496322", "Bad\ Dürkheim",
"497903", "Mainhardt",
"495195", "Neuenkirchen\ bei\ Soltau",
"4935384", "Steinsdorf\ bei\ Jessen",
"495851", "Dahlenburg",
"49441", "Oldenburg",
"492407", "Herzogenrath\-Kohlscheid",
"498727", "Falkenberg\ Niederbayern",
"496697", "Willingshausen",
"498106", "Vaterstetten",
"4936692", "Bürgel",
"494832", "Meldorf",
"498158", "Tutzing",
"499192", "Gräfenberg",
"495055", "Fassberg",
"496325", "Lambrecht\ Pfalz",
"4935793", "Elstra",
"495192", "Munster",
"492378", "Fröndenberg\-Langschede",
"4939267", "Schneidlingen",
"495644", "Willebadessen\-Peckelsheim",
"494824", "Krempe",
"499644", "Pressath",
"493868", "Rastow",
"492137", "Neuss\-Norf",
"4939602", "Kleeth",
"494556", "Ahrensbök\-Gnissau",
"492944", "Rietberg\-Mastholte",
"493735", "Marienberg\ Sachsen",
"494249", "Bassum\-Nordwohlde",
"4939749", "Grambow\ bei\ Pasewalk",
"494466", "Wittmund\-Ardorf",
"4933451", "Heckelberg",
"494508", "Krummesse",
"496175", "Friedrichsdorf\ Taunus",
"4937436", "Weischlitz",
"498666", "Teisendorf",
"497674", "Todtmoos",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"492445", "Schleiden\ Eifel",
"499608", "Kohlberg\ Oberpfalz",
"496235", "Schifferstadt",
"495608", "Söhrewald",
"499656", "Moosbach\ bei\ Vohenstrauss",
"497165", "Göppingen\-Hohenstaufen",
"496633", "Homberg\ Ohm",
"495656", "Waldkappel",
"4939292", "Biederitz",
"497806", "Bad\ Peterstal\-Griesbach",
"499088", "Mönchsdeggingen",
"494544", "Berkenthin",
"494366", "Grömitz\-Cismar",
"496664", "Sinntal\-Sterbfritz",
"4937434", "Bobenneukirchen",
"495191", "Soltau",
"495855", "Nahrendorf",
"4934781", "Greifenhagen",
"496104", "Heusenstamm",
"499191", "Forchheim\ Oberfranken",
"4939059", "Wegenstedt",
"499855", "Dentlein\ am\ Forst",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"4936202", "Neudietendorf",
"494795", "Garlstedt",
"4937463", "Bergen\ Vogtland",
"497085", "Enzklösterle",
"496425", "Rauschenberg\ Hessen",
"498065", "Tuntenhausen\-Schönau",
"492193", "Dabringhausen",
"497203", "Walzbachtal",
"495168", "Walsrode\-Stellichte",
"498320", "Missen\-Wilhams",
"499552", "Burghaslach",
"495233", "Steinheim\ Westfalen",
"494953", "Bunde",
"493381", "Brandenburg\ an\ der\ Havel",
"496256", "Lampertheim\-Hüttenfeld",
"499233", "Arzberg\ Oberfranken",
"495361", "Wolfsburg",
"495552", "Katlenburg",
"4933631", "Bad\ Saarow\-Pieskow",
"495264", "Kalletal",
"4936785", "Gräfinau\-Angstedt",
"493744", "Auerbach\ Vogtland",
"499264", "Küps",
"492935", "Sundern\-Hachen",
"496342", "Schweigen\-Rechtenbach",
"4935474", "Schönwalde\ bei\ Lübben",
"492334", "Hagen\-Hohenlimburg",
"498469", "Freystadt\-Burggriesbach",
"498246", "Waal",
"496029", "Mömbris",
"499359", "Karlstadt\-Wiesenfeld",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"499398", "Birkenfeld\ bei\ Würzburg",
"496441", "Wetzlar",
"499462", "Falkenstein\ Oberpfalz",
"492363", "Datteln",
"495635", "Vöhl",
"4933398", "Werneuchen",
"495520", "Braunlage",
"495462", "Ankum",
"4938322", "Richtenberg",
"499635", "Bärnau",
"497581", "Saulgau",
"498561", "Pfarrkirchen\ Niederbayern",
"499836", "Gunzenhausen\-Cronheim",
"4933966", "Dranse",
"4935248", "Schönfeld\ bei\ Grossenhain",
"495836", "Wittingen\-Radenbeck",
"492421", "Düren",
"496853", "Marpingen",
"497627", "Steinen\ Kreis\ Lörrach",
"4933870", "Zollchow\ bei\ Rathenow",
"492529", "Oelde\-Stromberg",
"4936949", "Obermassfeld\-Grimmenthal",
"498170", "Strasslach\-Dingharting",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"494109", "Tangstedt\ Bz\ Hamburg",
"4934207", "Zwochau",
"494877", "Hennstedt\ bei\ Itzehoe",
"495423", "Versmold",
"496407", "Rabenau\ Hessen",
"4939389", "Schollene",
"497395", "Ehingen\-Dächingen",
"499423", "Geiselhöring",
"4936704", "Steinheid",
"4933207", "Gross\ Kreutz",
"4938305", "Gingst",
"4933964", "Fretzdorf",
"498043", "Jachenau",
"494929", "Ihlow\ Kreis\ Aurich",
"492224", "Bad\ Honnef",
"4935601", "Peitz",
"4935024", "Stadt\ Wehlen",
"498705", "Altfraunhofen",
"4934221", "Schildau\ Gneisenaustadt",
"499323", "Iphofen",
"492422", "Kreuzau",
"496053", "Wächtersbach",
"495323", "Clausthal\-Zellerfeld",
"498230", "Gablingen",
"495036", "Neustadt\-Schneeren",
"496307", "Schopp",
"4939200", "Gommern",
"4933094", "Löwenberg",
"495840", "Schnackenburg",
"496442", "Braunfels",
"4934341", "Geithain",
"499569", "Sesslach",
"494535", "Nahe",
"498254", "Altomünster",
"497143", "Besigheim",
"492171", "Leverkusen\-Opladen",
"497582", "Bad\ Buchau",
"498562", "Triftern",
"4933933", "Lindow\ Mark",
"495461", "Bramsche\ Hase",
"492232", "Brühl\ Rheinland",
"499461", "Roding",
"492553", "Ochtrup",
"498452", "Geisenfeld",
"496776", "Dachsenhausen",
"495362", "Wolfsburg\-Fallersleben",
"495551", "Northeim",
"497967", "Jagstzell",
"4935476", "Wittmannsdorf\-Bückchen",
"493382", "Lehnin",
"496244", "Westhofen\ Rheinhessenen",
"496784", "Weierbach",
"499551", "Burgwindheim",
"492463", "Titz",
"499498", "Laaber",
"496341", "Landau\ in\ der\ Pfalz",
"495173", "Uetze",
"498369", "Rückholz",
"497389", "Heroldstatt",
"4935265", "Glaubitz",
"492434", "Wegberg",
"495459", "Hörstel",
"499173", "Thalmässing",
"494333", "Erfde",
"499654", "Pleystein",
"493328", "Teltow",
"4938733", "Karbow\-Vietlübbe",
"492639", "Anhausen\ Kreis\ Neuwied",
"492747", "Molzhain",
"494261", "Rotenburg\ Wümme",
"495654", "Herleshausen",
"494546", "Mustin\ Lauenburg",
"494364", "Dahme\ Kreis\ Ostholstein",
"4935953", "Burkau",
"497804", "Oppenau",
"492355", "Schalksmühle",
"499078", "Mertingen",
"496666", "Freiensteinau",
"495939", "Sustrum",
"492954", "Rüthen\-Oestereiden",
"494298", "Lilienthal",
"4936072", "Weissenborn\-Lüderode",
"494965", "Surwold",
"493337", "Biesenthal\ Brandenburg",
"497528", "Neukirch\ bei\ Tettnang",
"4936337", "Schiedungen",
"4936484", "Knau\ bei\ Pössneck",
"49345", "Halle\ Saale",
"4937606", "Lengenfeld\ Vogtland",
"496158", "Riedstadt",
"4936647", "Saalburg\ Thüringen",
"4938844", "Gülze",
"493493", "Bitterfeld",
"498325", "Oberstaufen\-Thalkirchdorf",
"499525", "Königsberg\ in\ Bayern",
"496865", "Mettlach\-Orscholz",
"494497", "Barssel\-Harkebrügge",
"495525", "Walkenried",
"495703", "Hille",
"496727", "Gensingen",
"4935775", "Pechern",
"4937294", "Grünhainichen",
"495045", "Springe\-Bennigsen",
"496106", "Rodgau",
"4937604", "Mosel",
"492388", "Hamm\-Uentrop",
"49335", "Frankfurt\ \(Oder\)",
"499845", "Oberdachstetten",
"4936422", "Reinstädt\ Thüringen",
"4935893", "Mücka",
"495845", "Bergen\ Dumme",
"494625", "Jübek",
"494223", "Ganderkesee\-Bookholzberg",
"498104", "Sauerlach",
"4937296", "Stollberg\ Erzgebirge",
"49214", "Leverkusen",
"4939327", "Klietz",
"494779", "Freiburg\ Elbe",
"496185", "Hammersbach\ Hessen",
"498633", "Tüssling",
"492455", "Waldfeucht",
"494464", "Wittmund\-Carolinensiel",
"498664", "Chieming",
"497684", "Glottertal",
"4938355", "Züssow",
"497676", "Feldberg\ Schwarzwald",
"494433", "Dötlingen",
"4938872", "Rehna",
"494826", "Hohenlockstedt",
"494262", "Visselhövede",
"495646", "Willebadessen",
"4939247", "Güterglück",
"499646", "Freihung",
"493437", "Grimma",
"492565", "Gronau\-Epe",
"494554", "Wahlstedt",
"49261", "Koblenz\ am\ Rhein",
"494607", "Janneby",
"496843", "Gersheim",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"495034", "Neustadt\-Hagen",
"497129", "Lichtenstein\ Württemberg",
"4939954", "Stavenhagen\ Reuterstadt",
"498407", "Grossmehring",
"495063", "Bad\ Salzdetfurth",
"49991", "Deggendorf",
"4933332", "Gartz\ Oder",
"493901", "Salzwedel",
"4938297", "Moitin",
"492226", "Rheinbach",
"49591", "Lingen\ \(Ems\)",
"492862", "Südlohn",
"4933395", "Zerpenschleuse",
"493603", "Bad\ Langensalza",
"496774", "Kaub",
"495542", "Witzenhausen",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"493372", "Jüterbog",
"494943", "Grossefehn",
"496786", "Kempfeld",
"499542", "Schesslitz",
"496246", "Eich\ Rheinhessen",
"498029", "Kreuth\ bei\ Tegernsee",
"4933676", "Friedland\ bei\ Beeskow",
"499183", "Burgthann",
"498860", "Bernbeuren",
"495022", "Wietzen",
"496561", "Bitburg",
"496352", "Kirchheimbolanden",
"495183", "Lamspringe",
"495821", "Bad\ Bevensen",
"498208", "Eurasburg\ bei\ Augsburg",
"4938231", "Barth",
"494641", "Süderbrarup",
"492436", "Wegberg\-Rödgen",
"4935245", "Burkhardswalde\-Munzig",
"498549", "Vilshofen\-Pleinting",
"499349", "Werbach\-Wenkheim",
"4934361", "Dahlen\ Sachsen",
"492823", "Goch",
"492181", "Grevenbroich",
"494167", "Apensen",
"496451", "Frankenberg\ Eder",
"4936458", "Bad\ Berka",
"498342", "Marktoberdorf",
"493471", "Bernburg\ Saale",
"493947", "Thale",
"496559", "Leidenborn",
"497572", "Mengen\ Württemberg",
"4937329", "Grosshartmannsdorf",
"497153", "Plochingen",
"4939009", "Badel",
"498784", "Hohenthann",
"497764", "Herrischried",
"492336", "Schwelm",
"4933674", "Trebatsch",
"495850", "Neetze",
"496452", "Battenberg\ Eder",
"492182", "Grevenbroich\-Kapellen",
"497571", "Sigmaringen",
"492543", "Billerbeck\ Westfalen",
"497733", "Engen\ Hegau",
"498341", "Kaufbeuren",
"4933972", "Breddin",
"4938308", "Göhren\ Rügen",
"496254", "Lautertal\ Odenwald",
"493371", "Luckenwalde",
"498442", "Wolnzach",
"495541", "Hann\.\ Münden",
"496420", "Lahntal",
"495822", "Ebstorf",
"495266", "Lemgo\-Kirchheide",
"494642", "Kappeln\ Schlei",
"496351", "Eisenberg\ Pfalz",
"496562", "Speicher",
"499266", "Mitwitz",
"499822", "Bechhofen\ an\ der\ Heide",
"4936252", "Tambach\-Dietharz",
"4933361", "Joachimsthal",
"495021", "Nienburg\ Weser",
"498053", "Bad\ Endorf",
"492861", "Borken\ Westfalen",
"493902", "Diesdorf\ Altm",
"4939777", "Borkenfriede",
"494194", "Sievershütten",
"492440", "Nettersheim\-Tondorf",
"4939956", "Neukalen",
"4935268", "Stauchitz",
"496043", "Nidda",
"499834", "Theilenhofen",
"492859", "Wesel\-Bislich",
"495834", "Wittingen\-Knesebeck",
"495507", "Ebergötzen",
"496523", "Holsthum",
"493883", "Hagenow",
"495863", "Zernien",
"4936969", "Merkers",
"4939222", "Möser",
"494456", "Varel\-Altjührden",
"494945", "Grossefehn\-Timmel",
"4936605", "Bad\ Köstritz",
"499185", "Mühlhausen\ Oberpfalz",
"498656", "Anger",
"495185", "Duingen",
"492825", "Uedem",
"494241", "Bassum",
"4937364", "Reitzenhain\ Erzgebirge",
"494408", "Hude\ Oldenburg",
"494344", "Schönberg\ Holstein",
"496646", "Grebenau",
"498168", "Attenkirchen",
"4939934", "Gross\ Plasten",
"4939342", "Gladau",
"4933875", "Rhinow",
"492626", "Selters\ Westferwald",
"495065", "Sibbesse",
"498191", "Landsberg\ am\ Lech",
"4936926", "Creuzburg",
"494207", "Oyten",
"493605", "Leinefelde",
"495926", "Engden",
"49221", "Cologne",
"4938379", "Benz\ Usedom",
"4936450", "Kranichfeld",
"499926", "Frauenau",
"498055", "Halfing",
"4938300", "Insel\ Hiddensee",
"499738", "Rottershausen",
"498192", "Schondorf\ am\ Ammersee",
"495199", "Schneverdingen\-Heber",
"495158", "Hemeringen",
"499199", "Kunreuth",
"499158", "Offenhausen\ Mittelfranken",
"4935723", "Bernsdorf\ OL",
"496045", "Gedern",
"4937755", "Schönheide\ Erzgebirge",
"499106", "Markt\ Erlbach",
"4936924", "Mihla",
"4936087", "Wüstheuterode",
"499865", "Adelshofen\ Mittelfranken",
"496703", "Wöllstein\ Rheinhessen",
"4936622", "Triebes",
"494839", "Wöhrden\ Dithmarschen",
"496630", "Schwalmtal\-Storndorf",
"496525", "Irrel",
"495865", "Gusborn",
"4939205", "Langenweddingen",
"499727", "Schonungen\-Marktsteinach",
"494242", "Syke",
"496078", "Gross\-Umstadt",
"499666", "Illschwang",
"493686", "Eisfeld",
"492545", "Rosendahl\-Darfeld",
"497735", "Öhningen",
"496654", "Gersfeld\ Rhön",
"4939428", "Pabstorf",
"494356", "Gross\ Wittensee",
"49208", "Oberhausen\ Rheinland",
"4937366", "Rübenau",
"4935451", "Dahme\ Brandenburg",
"494444", "Goldenstedt",
"494308", "Schwedeneck",
"497073", "Ammerbuch",
"4935207", "Moritzburg",
"492041", "Bottrop",
"492429", "Hürtgenwald",
"492842", "Kamp\-Lintfort",
"4938729", "Marnitz",
"4933601", "Podelzig",
"492521", "Beckum",
"4934903", "Coswig\ Anhalt",
"498323", "Immenstadt\ im\ Allgäu",
"498036", "Stephanskirchen\ Simssee",
"494950", "Holtland",
"494101", "Pinneberg",
"494922", "Borkum",
"499523", "Hofheim\ in\ Unterfranken",
"495705", "Petershagen\-Windheim",
"492360", "Haltern\-Lippramsdorf",
"496507", "Neumagen\-Dhron",
"4939452", "Ilsenburg",
"495523", "Bad\ Sachsa",
"4938483", "Brüel",
"496834", "Bous",
"4936843", "Benshausen",
"4934291", "Borsdorf",
"495043", "Lauenau",
"4936871", "Bad\ Colberg\-Heldburg",
"4938753", "Wöbbelin",
"4934328", "Hartha\ bei\ Döbeln",
"499369", "Uettingen",
"494335", "Hohn\ bei\ Rendsburg",
"498459", "Manching",
"498551", "Freyung",
"498362", "Füssen",
"4935933", "Neschwitz",
"497382", "Römerstein",
"4939726", "Ducherow",
"495452", "Mettingen\ Westfalen",
"497136", "Bad\ Friedrichshall",
"492353", "Halver",
"499452", "Langquaid",
"493967", "Oertzenhof\ bei\ Strasburg",
"499420", "Feldkirchen\ Niederbayern",
"498461", "Beilngries",
"496021", "Aschaffenburg",
"4936734", "Leutenberg",
"495351", "Helmstedt",
"495562", "Dassel\-Markoldendorf",
"496449", "Ehringshausen\-Katzenfurt",
"496266", "Hassmersheim",
"4933476", "Neuhardenberg",
"494963", "Dörpen",
"499351", "Gemünden\ am\ Main",
"499562", "Sonnefeld",
"496541", "Traben\-Trarbach",
"499254", "Gefrees",
"492687", "Horhausen\ Westerwald",
"497708", "Geisingen\-Leipferdingen",
"495254", "Paderborn\-Schloss\ Neuhaus",
"494934", "Marienhafe",
"494661", "Niebüll",
"492453", "Heinsberg\-Randerath",
"499561", "Coburg",
"499352", "Lohr\ am\ Main",
"496183", "Erlensee",
"496821", "Neunkirchen\ Saar",
"493581", "Görlitz",
"498635", "Pleiskirchen",
"497957", "Kressberg",
"495352", "Schöningen",
"495561", "Einbeck",
"498462", "Berching",
"497482", "Horb\-Dettingen",
"496022", "Obernburg\ am\ Main",
"495246", "Verl",
"494662", "Leck",
"4938392", "Sassnitz",
"499774", "Oberelsbach",
"499246", "Pegnitz\-Trockau",
"499469", "Roding\-Neubäu",
"494435", "Grossenkneten",
"4933237", "Paulinenaue",
"4935341", "Bad\ Liebenwerda",
"4939724", "Klein\ Bünzow",
"496542", "Bullay",
"495774", "Wagenfeld\-Ströhen",
"492534", "Münster\-Roxel",
"497744", "Stühlingen",
"4933474", "Neutrebbin",
"4936736", "Arnsgereuth",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"496050", "Biebergemünd",
"492563", "Stadtlohn",
"499451", "Schierling",
"495320", "Torfhaus",
"498233", "Kissing",
"496349", "Billigheim\-Ingenheim",
"4933839", "Wusterwitz",
"49481", "Heide\ Holstein",
"495451", "Ibbenbüren",
"498361", "Nesselwang",
"498552", "Grafenau\ Niederbayern",
"497381", "Münsingen",
"498423", "Titting",
"496063", "Bad\ König",
"494921", "Emden\ Stadt",
"4933082", "Menz\ Kreis\ Oberhavel",
"493395", "Pritzwalk",
"4934601", "Teutschenthal",
"499843", "Burgbernheim",
"496034", "Wöllstadt",
"495843", "Wustrow\ Wendland",
"494623", "Böklund",
"492841", "Moers",
"499170", "Schwanstetten",
"494102", "Ahrensburg",
"493994", "Malchin",
"492522", "Oelde",
"4935697", "Bagenz",
"4934929", "Straach",
"496855", "Freisen",
"499104", "Emskirchen",
"492588", "Harsewinkel\-Greffen",
"4939397", "Geestgottberg",
"4936608", "Seelingstädt\ bei\ Gera",
"49355", "Cottbus",
"494330", "Emkendorf",
"497227", "Lichtenau\ Baden",
"498845", "Bad\ Kohlgrub",
"4934775", "Wippra",
"4935823", "Ostritz",
"497393", "Munderkingen",
"495425", "Borgholzhausen",
"4937346", "Geyer",
"495235", "Blomberg\ Lippe",
"4933878", "Nennhausen",
"494955", "Westoverledingen",
"4934953", "Gräfenhainichen",
"499235", "Thierstein",
"492964", "Brilon\-Alme",
"492631", "Neuwied",
"494446", "Bakum\ Kreis\ Vechta",
"494269", "Ahausen\-Kirchwalsede",
"4935240", "Tauscha\ bei\ Grossenhain",
"492933", "Sundern\ Sauerland",
"495664", "Morschen",
"495931", "Meppen",
"494251", "Hoya",
"497428", "Rosenfeld",
"494772", "Oberndorf\ Oste",
"499931", "Plattling",
"499664", "Hahnbach",
"496656", "Ebersburg",
"4939402", "Völpke",
"492365", "Marl",
"495633", "Diemelsee",
"494354", "Fleckeby",
"499633", "Mitterteich",
"496888", "Lebach\-Steinbach",
"499932", "Osterhofen",
"493528", "Radeberg",
"494533", "Reinfeld\ Holstein",
"494771", "Hemmoor",
"495932", "Haren\ Ems",
"494252", "Bruchhausen\-Vilsen",
"497337", "Nellingen\ Alb",
"4937344", "Crottendorf\ Sachsen",
"497145", "Markgröningen",
"494346", "Gettorf",
"494564", "Schashagen",
"4934651", "Rossla",
"492555", "Schöppingen",
"496644", "Grebenhain",
"494454", "Jade",
"492632", "Andernach",
"4939208", "Loitsche",
"4938457", "Krakow\ am\ See",
"492465", "Inden",
"493537", "Jessen\ Elster",
"495175", "Lehrte\-Arpke",
"499175", "Spalt",
"497328", "Königsbronn",
"498654", "Freilassing",
"4938787", "Glöwen",
"4939425", "Dingelstedt\ am\ Huy",
"498045", "Lenggries\-Fall",
"495924", "Bad\ Bentheim\-Gildehaus",
"499148", "Ettenstatt",
"4933929", "Gühlen\-Glienicke",
"498703", "Essenbach",
"498630", "Oberneukirchen",
"499924", "Bodenmais",
"495148", "Steinhorst\ Niedersachsen",
"4939971", "Gnoien",
"499325", "Kleinlangheim",
"496192", "Hofheim\ am\ Taunus",
"495325", "Goslar\-Hahnenklee",
"496055", "Freigericht",
"492624", "Höhr\-Grenzhausen",
"4939362", "Grieben\ bei\ Tangerhütte",
"498266", "Kirchheim\ in\ Schwaben",
"498822", "Oberammergau",
"495060", "Bodenburg",
"497746", "Wutöschingen",
"492536", "Münster\-Albachten",
"496461", "Biedenkopf",
"497274", "Germersheim",
"498021", "Waakirchen",
"497371", "Riedlingen\ Württemberg",
"496569", "Bickendorf",
"499442", "Riedenburg",
"499829", "Flachslanden",
"498541", "Vilshofen\ Niederbayern",
"495829", "Wriedel",
"495442", "Barnstorf\ Kreis\ Diepholz",
"494737", "Stadland\-Schwei",
"497472", "Rottenburg\ am\ Neckar",
"499341", "Tauberbischofsheim",
"496173", "Kronberg\ im\ Taunus",
"493571", "Hoyerswerda",
"493733", "Annaberg\-Buchholz",
"495341", "Salzgitter",
"499776", "Mellrichstadt",
"4939824", "Hohenzieritz",
"495244", "Rietberg",
"496362", "Alsenz",
"496551", "Prüm",
"495776", "Preussisch\ Ströhen",
"4935361", "Schlieben",
"499244", "Betzenstein",
"493764", "Meerane",
"4938201", "Gelbensande",
"498507", "Neuburg\ am\ Inn",
"492852", "Hamminkeln",
"499180", "Pyrbaum",
"497121", "Reutlingen",
"492051", "Velbert",
"493996", "Teterow",
"4934325", "Mochau\-Lüttewitz",
"493909", "Klötze\ Altmark",
"496297", "Ravenstein\ Baden",
"4936029", "Menteroda",
"4934462", "Laucha\ Unstrut",
"496323", "Edenkoben",
"495307", "Braunschweig\-Wenden",
"496036", "Wölfersheim",
"495053", "Fassberg\-Müden",
"499307", "Altertheim",
"4938227", "Lüdershagen\ bei\ Barth",
"4934497", "Langenleuba\-Niederhain",
"495853", "Neu\ Darchau",
"496836", "Überherrn",
"497150", "Korntal\-Münchingen",
"499853", "Wilburgstetten",
"4939039", "Bonese",
"4936743", "Teichel",
"492052", "Velbert\-Langenberg",
"494793", "Hambergen",
"499407", "Wenzenbach",
"497122", "St\ Johann\ Württemberg",
"492851", "Rees",
"492195", "Radevormwald",
"497083", "Bad\ Herrenalb",
"496423", "Wetter\ Hessen",
"495407", "Wallenhorst",
"498063", "Feldkirchen\-Westerham",
"498034", "Brannenburg",
"497947", "Forchtenberg",
"499342", "Wertheim",
"492443", "Mechernich",
"497471", "Hechingen",
"496264", "Neudenau",
"499256", "Stammbach",
"496552", "Olzheim",
"496361", "Rockenhausen",
"497579", "Schwenningen\ Baden",
"492677", "Lutzerath",
"494936", "Grossheide",
"498349", "Stötten\ am\ Auerberg",
"496233", "Frankenthal\ Pfalz",
"499549", "Lisberg",
"496462", "Gladenbach",
"498022", "Tegernsee",
"499208", "Bindlach",
"497754", "Görwihl",
"498821", "Garmisch\-Partenkirchen",
"493379", "Mahlow",
"496635", "Kirtorf",
"497163", "Ebersbach\ an\ der\ Fils",
"4938853", "Drönnewitz\ bei\ Hagenow",
"4939882", "Gollin",
"495208", "Leopoldshöhe",
"495441", "Diepholz",
"498542", "Ortenburg",
"499977", "Arnschwang",
"496398", "Vorderweidenthal",
"499441", "Kelheim",
"4939826", "Blankensee\ bei\ Neustrelitz",
"497134", "Weinsberg",
"496359", "Grünstadt",
"495977", "Spelle",
"4933846", "Dippmannsdorf",
"495345", "Baddeckenstedt",
"495137", "Seelze",
"497974", "Bühlerzell",
"4933766", "Teupitz",
"499345", "Külsheim\ Baden",
"49385", "Schwerin",
"492644", "Linz\ am\ Rhein",
"496555", "Bleialf",
"4938320", "Tribsees",
"4939033", "Wallstawe",
"494176", "Marschacht",
"496465", "Breidenbach\ bei\ Biedenkopf",
"4939225", "Altengrabow",
"498025", "Miesbach",
"494184", "Hanstedt\ Nordheide",
"4936602", "Ronneburg\ Thüringen",
"4938823", "Selmsdorf",
"499944", "Miltach",
"495128", "Hohenhameln",
"498545", "Hofkirchen\ Bayern",
"4939856", "Beenz\ bei\ Prenzlau",
"495944", "Hoogstede",
"499128", "Feucht",
"497375", "Obermarchtal",
"4939408", "Hadmersleben",
"497348", "Beimerstetten",
"497404", "Epfendorf",
"494240", "Syke\-Heiligenfelde",
"4938859", "Alt\ Zachun",
"499378", "Eichenbühl\-Riedern",
"497125", "Bad\ Urach",
"492192", "Hückeswagen",
"495378", "Sassenburg\-Platendorf",
"496624", "Heringen\ Werra",
"494326", "Wankendorf",
"497202", "Karlsbad",
"4939994", "Metschow",
"4939345", "Parchen",
"4933872", "Hohennauen",
"492855", "Voerde\ Niederrhein",
"492191", "Remscheid",
"4937752", "Eibenstock",
"497304", "Blaustein\ Württemberg",
"494864", "Oldenswort",
"497448", "Seewald",
"4936625", "Langenwetzendorf",
"49821", "Augsburg",
"4933733", "Stülpe",
"4939202", "Gross\ Ammensleben",
"494833", "Wesselburen",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"496588", "Pluwig",
"494426", "Wangerland\-Horumersiel",
"497905", "Langenburg",
"493504", "Dippoldiswalde",
"499193", "Höchstadt\ an\ der\ Aisch",
"4939996", "Törpin",
"495193", "Schneverdingen",
"4933764", "Mittenwalde\ Mark",
"498825", "Krün",
"496631", "Alsfeld",
"4933844", "Brück\ Brandenburg",
"492608", "Welschneudorf",
"497247", "Linkenheim\-Hochstetten",
"494236", "Kirchlinteln",
"499445", "Neustadt\ an\ der\ Donau",
"495956", "Rastdorf",
"495445", "Drebber",
"499956", "Eichendorf\-Aufhausen",
"497475", "Burladingen",
"495908", "Wietmarschen\-Lohne",
"4936023", "Horsmar",
"499908", "Schöfweg",
"4936081", "Arenshausen",
"4939854", "Kleptow",
"495277", "Höxter\-Fürstenau",
"499277", "Warmensteinach",
"492656", "Virneburg",
"495529", "Rhumspringe",
"498841", "Murnau\ am\ Staffelsee",
"499529", "Oberaurach",
"496869", "Merzig\-Silwingen",
"4939455", "Schierke",
"498042", "Lenggries",
"498460", "Berching\-Holnstein",
"499421", "Straubing",
"496020", "Heigenbrücken",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"497938", "Mulfingen\ Jagst",
"492836", "Wachtendonk",
"494704", "Drangstedt",
"499350", "Eussenheim\-Hundsbach",
"498550", "Philippsreut",
"492423", "Langerwehe",
"496195", "Kelkheim\ Taunus",
"496851", "St\ Wendel",
"495322", "Bad\ Harzburg",
"496052", "Bad\ Orb",
"493871", "Parchim",
"4940", "Hamburg",
"492264", "Marienheide",
"499935", "Stephansposching",
"498534", "Tettenweis",
"496443", "Ehringshausen\ Dill",
"495935", "Twist\-Schöninghsdorf",
"494255", "Martfeld",
"4933607", "Briesen\ Mark",
"497142", "Bietigheim\-Bissingen",
"4933981", "Putlitz",
"492233", "Hürth\ Rheinland",
"497583", "Bad\ Schussenried",
"498563", "Bad\ Birnbach\ Rottal",
"4933923", "Flecken\ Zechlin",
"496677", "Neuenstein\ Hessen",
"492552", "Steinfurt\-Borghorst",
"498807", "Diessen\ am\ Ammersee",
"492361", "Recklinghausen",
"4935201", "Langebrück",
"499231", "Marktredwitz",
"495363", "Wolfsburg\-Vorsfelde",
"492635", "Rheinbrohl",
"492520", "Wadersloh\-Diestedde",
"498453", "Reichertshofen\ Oberbayern",
"499363", "Arnstein\ Unterfranken",
"4938427", "Blowatz",
"495231", "Detmold",
"4934297", "Liebertwolkwitz",
"494951", "Weener",
"492462", "Linnich",
"498179", "Eurasburg\ an\ der\ Loisach",
"492359", "Kierspe",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"495172", "Ilsede",
"4939600", "Zwiedorf",
"499334", "Giebelstadt",
"499172", "Georgensgmünd",
"494487", "Grossenkneten\-Huntlosen",
"499553", "Ebrach\ Oberfranken",
"495232", "Lage\ Lippe",
"4934262", "Falkenhain\ bei\ Wurzen",
"492461", "Jülich",
"494952", "Rhauderfehn",
"496536", "Kleinich",
"4934923", "Cobbelsdorf",
"495553", "Kalefeld",
"499232", "Wunsiedel",
"4934607", "Wettin",
"4969", "Frankfurt\ am\ Main",
"499171", "Roth\ Mittelfranken",
"498239", "Langenneufnach",
"496343", "Bad\ Bergzabern",
"497667", "Breisach\ am\ Rhein",
"498687", "Taching\-Tengling",
"495171", "Peine",
"497141", "Ludwigsburg\ Württemberg",
"4935691", "Bärenklau\ NL",
"492173", "Langenfeld\ Rheinland",
"499434", "Bodenwöhr",
"494775", "Grossenwörden",
"495434", "Essen\ Oldenburg",
"499463", "Wald\ Oberpfalz",
"492551", "Steinfurt\-Burgsteinfurt",
"492362", "Dorsten",
"494920", "Wirdum",
"4935829", "Gersdorf\ bei\ Görlitz",
"4938332", "Gross\ Bisdorf",
"494288", "Horstedt\ Kreis\ Rotenburg",
"496051", "Gelnhausen",
"495321", "Goslar",
"4933231", "Pausin",
"494748", "Stubben\ bei\ Bremerhaven",
"496852", "Nohfelden",
"499321", "Kitzingen",
"4936200", "Elxleben\ bei\ Arnstadt",
"4939888", "Lychen",
"495224", "Enger\ Westfalen",
"498041", "Bad\ Tölz",
"492297", "Wildbergerhütte",
"4934445", "Stössen",
"497726", "Bad\ Dürrheim",
"4933085", "Seilershof",
"499560", "Grub\ am\ Forst",
"495849", "Waddeweitz",
"495422", "Melle",
"499422", "Bogen\ Niederbayern",
"492323", "Herne",
"49371", "Chemnitz\ Sachsen",
"4934772", "Helbra",
"499701", "Sandberg\ Unterfranken",
"4933657", "Steinsdorf\ Brandenburg",
"497358", "Eberhardzell\-Füramoos",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"498624", "Obing",
"492045", "Bottrop\-Kirchhellen",
"494222", "Ganderkesee",
"497306", "Vöhringen\ Iller",
"496578", "Salmtal",
"4939484", "Harzgerode",
"494105", "Seevetal",
"4933833", "Wollin\ bei\ Brandenburg",
"492525", "Beckum\-Neubeckum",
"492630", "Mülheim\-Kärlich",
"493491", "Lutherstadt\ Wittenberg",
"499355", "Frammersbach",
"4939391", "Lückstedt",
"495355", "Frellstedt",
"498465", "Kipfenberg",
"4937204", "Lichtenstein\ Sachsen",
"497485", "Empfingen",
"4939405", "Hötensleben",
"494665", "Emmelsbüll\-Horsbüll",
"499747", "Geroda\ Bayern",
"499639", "Mähring",
"499287", "Selb",
"494432", "Dötlingen\-Brettorf",
"492654", "Polch",
"4939754", "Löcknitz\ Vorpom",
"496545", "Blankenrath",
"494263", "Scheessel",
"4939348", "Klitsche",
"4933744", "Hohenseefeld",
"497777", "Sauldorf",
"494331", "Rendsburg",
"495954", "Lorup",
"4934746", "Giersleben",
"494234", "Dörverden",
"496190", "Hattersheim\ am\ Main",
"499954", "Simbach\ Niederbayern",
"498555", "Perlesreut",
"4939977", "Jördenstorf",
"4938723", "Kladrum",
"494174", "Stelle\ Kreis\ Harburg",
"497257", "Bruchsal\-Untergrombach",
"4937206", "Frankenberg\ Sachsen",
"494332", "Hamdorf\ bei\ Rendsburg",
"4936628", "Zeulenroda",
"4936461", "Bad\ Sulza",
"494186", "Buchholz\-Trelde",
"498365", "Wertach",
"497385", "Gomadingen",
"499946", "Hohenwarth\ bei\ Kötzing",
"495455", "Tecklenburg\-Brochterbeck",
"4938781", "Mellen",
"4934909", "Aken\ Elbe",
"495946", "Georgsdorf",
"497976", "Sulzbach\-Laufen",
"495565", "Einbeck\-Wenzen",
"493585", "Löbau",
"496825", "Illingen\ Saar",
"498631", "Mühldorf\ am\ Inn",
"4933746", "Werbig\ bei\ Jüterbog",
"499565", "Untersiemau",
"494539", "Westerau",
"492646", "Königsfeld\ Eifel",
"4933970", "Neustadt\ Dosse",
"494431", "Wildeshausen",
"4936849", "Kleinschmalkalden",
"494221", "Delmenhorst",
"497458", "Ebhausen",
"492845", "Neukirchen\-Vluyn",
"4938759", "Tewswoos",
"4933054", "Liebenwalde",
"496626", "Wildeck\-Obersuhl",
"4939365", "Bellingen\ bei\ Stendal",
"494324", "Brokstedt",
"4935939", "Hochkirch",
"493391", "Neuruppin",
"494925", "Hinte",
"495702", "Petershagen\-Lahde",
"4939422", "Badersleben",
"494770", "Wischhafen",
"498709", "Eching\ Niederbayern",
"497568", "Bad\ Wurzach\-Hauerz",
"4938451", "Hoppenrade\ bei\ Güstrow",
"49621", "Mannheim",
"493647", "Pössneck",
"499436", "Nittenau",
"494245", "Neuenkirchen\ bei\ Bassum",
"497152", "Leonberg\ Württemberg",
"495436", "Nortrup",
"492183", "Rommerskirchen",
"492821", "Kleve\ Niederrhein",
"496453", "Gemünden\ Wohra",
"497732", "Radolfzell\ am\ Bodensee",
"492542", "Gescher",
"4939458", "Heudeber",
"4938207", "Stäbelow",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"494941", "Aurich",
"4934242", "Hohenpriessnitz",
"496534", "Mülheim\ Mosel",
"498443", "Hohenwart\ Paar",
"494477", "Lastrup\-Hemmelte",
"498677", "Burghausen\ Salzach",
"495823", "Bienenbüttel",
"495181", "Alfeld\ Leine",
"494643", "Gelting\ Angeln",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"499823", "Leutershausen",
"4935975", "Hohnstein",
"496563", "Kyllburg",
"498052", "Aschau\ im\ Chiemgau",
"496550", "Irrhausen",
"497724", "St\ Georgen\ im\ Schwarzwald",
"4934465", "Bad\ Bibra",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"498851", "Kochel\ am\ See",
"49561", "Kassel",
"499340", "Königheim\-Brehmen",
"49961", "Weiden\ in\ der\ Oberpfalz",
"496329", "Weidenthal\ Pfalz",
"4935753", "Grossräschen",
"493601", "Mühlhausen\ Thüringen",
"498869", "Kinsau",
"496042", "Büdingen\ Hessen",
"496841", "Homburg\ Saar",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"4933437", "Reichenberg\ bei\ Strausberg",
"4936652", "Wurzbach",
"496522", "Mettendorf",
"495862", "Hitzacker\ Elbe",
"49291", "Meschede",
"495226", "Bruchmühlen\ Westfalen",
"4934322", "Rosswein",
"498020", "Weyarn",
"496842", "Blieskastel",
"496429", "Schweinsberg\ Hessen",
"496041", "Glauburg",
"494758", "Nordleda",
"495861", "Dannenberg\ Elbe",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"493881", "Grevesmühlen",
"499861", "Rothenburg\ ob\ der\ Tauber",
"495062", "Holle\ bei\ Hildesheim",
"492507", "Havixbeck",
"49451", "Lübeck",
"4934384", "Grossbothen",
"498051", "Prien\ am\ Chiemsee",
"494127", "Westerhorn",
"492863", "Velen",
"494706", "Schiffdorf",
"492834", "Straelen",
"495859", "Thomasburg",
"495543", "Staufenberg\ Niedersachsen",
"494942", "Südbrookmerland",
"4939885", "Jakobshagen",
"499543", "Hirschaid",
"496353", "Freinsheim",
"495336", "Semmenstedt",
"499182", "Velburg",
"496007", "Rosbach\-Rodheim",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"492850", "Rees\-Haldern",
"499336", "Bütthard",
"495182", "Gronau\ Leine",
"4934491", "Schmölln\ Thüringen",
"4938221", "Marlow",
"498536", "Kösslarn",
"492822", "Emmerich",
"492449", "Blankenheim\ Ahr",
"492266", "Lindlar",
"497151", "Waiblingen",
"496239", "Bobenheim\-Roxheim",
"498343", "Aitrang",
"4933088", "Falkenthal",
"4938373", "Katzow",
"497573", "Stetten\ am\ kalten\ Markt",
"4989", "Munich",
"497731", "Singen\ Hohentwiel",
"492541", "Coesfeld",
"499606", "Pfreimd",
"495606", "Zierenberg",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"4939203", "Barleben",
"493925", "Stassfurt",
"497524", "Bad\ Waldsee",
"494294", "Riede\ Kreis\ Verden",
"492958", "Büren\-Harth",
"4939061", "Weferlingen",
"496130", "Schwabenheim\ an\ der\ Selz",
"497044", "Mönsheim",
"497808", "Hohberg\ bei\ Offenburg",
"495074", "Rodewald",
"499086", "Fremdingen",
"4937367", "Lengefeld\ Erzgebirge",
"499074", "Höchstädt\ an\ der\ Donau",
"497260", "Sinsheim\-Hilsbach",
"4939991", "Daberkow",
"495086", "Celle\-Scheuen",
"4935725", "Wittichenau",
"496722", "Rüdesheim\ am\ Rhein",
"499658", "Georgenberg",
"494492", "Saterland",
"495658", "Wehretal",
"492742", "Wissen",
"497532", "Meersburg",
"497253", "Bad\ Schönborn",
"493431", "Döbeln",
"498144", "Grafrath",
"499166", "Münchsteinach",
"495166", "Walsrode\-Kirchboitzen",
"496734", "Flonheim",
"4937421", "Oelsnitz\ Vogtland",
"497655", "Feldberg\-Altglashütten",
"493332", "Schwedt\/Oder",
"495805", "Oetzen",
"492484", "Mechernich\-Eiserfey",
"499805", "Burgoberbach",
"496763", "Kirchberg\ Hunsrück",
"4936022", "Grossengottern",
"496154", "Ober\-Ramstadt",
"495743", "Espelkamp\-Gestringen",
"493331", "Angermünde",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"495283", "Lügde\-Rischenau",
"499283", "Rehau",
"496146", "Hochheim\ am\ Main",
"4935828", "Reichenbach\ OL",
"4933841", "Belzig",
"492985", "Winterberg\-Niedersfeld",
"492384", "Welver",
"4936927", "Unterellen",
"4936084", "Heuthen",
"4939851", "Göritz\ bei\ Prenzlau",
"495685", "Knüllwald",
"497531", "Konstanz",
"494267", "Lauenbrück",
"492741", "Betzdorf",
"4936603", "Weida",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"497773", "Bodman\-Ludwigshafen",
"493866", "Cambs",
"495874", "Soltendieck",
"494558", "Todesfelde",
"499874", "Neuendettelsau",
"497229", "Iffezheim",
"494491", "Friesoythe",
"496721", "Bingen\ am\ Rhein",
"49471", "Bremerhaven",
"494392", "Nortorf\ bei\ Neumünster",
"4933873", "Grosswudicke",
"4939889", "Boitzenburg",
"497056", "Gechingen",
"497844", "Rheinau",
"494468", "Friedeburg\-Reepsholt",
"494506", "Stockelsdorf\-Krumbeck",
"4935204", "Wilsdruff",
"496357", "Standenbühl",
"496003", "Rosbach\ von\ der\ Höhe",
"495027", "Linsburg",
"499547", "Zapfendorf",
"4934263", "Hohburg",
"493377", "Zossen\ Brandenburg",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"496745", "Gondershausen",
"4934922", "Mühlanger",
"496285", "Walldürn\-Altheim",
"497577", "Veringenstadt",
"498347", "Friesenried",
"498135", "Sulzemoos",
"4938333", "Horst\ bei\ Grimmen",
"496683", "Ehrenberg\ Rhön",
"497949", "Pfedelbach\-Untersteinbach",
"4935696", "Briesnig",
"494162", "Jork",
"4938858", "Lassahn",
"498402", "Münchsmünster",
"496594", "Birresborn",
"49351", "Dresden",
"499409", "Pielenhofen",
"494602", "Freienwill",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"4936737", "Drognitz",
"498204", "Mickhausen",
"4939409", "Eilsleben",
"494123", "Barmstedt",
"494881", "Friedrichstadt",
"49731", "Ulm\ Donau",
"492867", "Heiden\ Kreis\ Borken",
"492725", "Lennestadt\-Oedingen",
"4936845", "Gehlberg",
"495309", "Lehre\-Wendhausen",
"497835", "Zell\ am\ Harmersbach",
"4933234", "Wustermark",
"493907", "Gardelegen",
"496258", "Gernsheim",
"4939727", "Spantekow",
"498302", "Görisried",
"4938485", "Dabel",
"494882", "Lunden",
"496206", "Lampertheim",
"499502", "Frensdorf",
"4934905", "Wörlitz",
"494903", "Wymeer",
"4933477", "Trebnitz\ bei\ Müncheberg",
"49741", "Rottweil",
"495502", "Dransfeld",
"498509", "Ruderting",
"498248", "Lamerdingen",
"499396", "Urspringen\ bei\ Lohr",
"4935206", "Kreischa\ bei\ Dresden",
"4933922", "Karwesee",
"493941", "Halberstadt",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"494161", "Buxtehude",
"496457", "Burgwald\ Eder",
"495838", "Gross\ Oesingen",
"493643", "Weimar\ Thüringen",
"499827", "Lichtenau\ Mittelfranken",
"4935935", "Kleinwelka",
"495765", "Raddestorf",
"496567", "Oberkail",
"495827", "Unterlüss",
"499765", "Trappstadt",
"496803", "Mandelbachtal\-Ommersheim",
"4935694", "Gosda\ bei\ Klinge",
"497636", "Münstertal\ Schwarzwald",
"4938755", "Eldena",
"494473", "Emstek",
"494159", "Basthorst",
"498734", "Reisbach\ Niederbayern",
"4939751", "Penkun",
"492132", "Meerbusch\-Büderich",
"492374", "Iserlohn\-Letmathe",
"499675", "Altendorf\ am\ Nabburg",
"492271", "Bergheim\ Erft",
"4938722", "Raduhn",
"497243", "Ettlingen",
"495675", "Trendelburg",
"492752", "Bad\ Laasphe",
"4939394", "Hohenberg\-Krusemark",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"497645", "Freiamt",
"495273", "Beverungen",
"492975", "Schmallenberg\-Oberkirchen",
"4939459", "Hasselfelde",
"4933741", "Niedergörsdorf",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"4935728", "Uhyst\ Spree",
"494837", "Neuenkirchen\ Dithmarschen",
"499729", "Grettstadt",
"496692", "Neustadt\ Hessen",
"497054", "Wildberg\ Württemberg",
"498722", "Gangkofen",
"494504", "Ratekau",
"492948", "Lippstadt\-Rebbeke",
"492405", "Würselen",
"495197", "Soltau\-Frielingen",
"4939481", "Hedersleben\ bei\ Aschersleben",
"499876", "Rohr\ Mittelfranken",
"4938456", "Langhagen\ bei\ Güstrow",
"499197", "Egloffstein",
"494828", "Lägerdorf",
"495648", "Brakel\-Gehrden",
"499648", "Neustadt\ am\ Kulm",
"4939423", "Wegeleben",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"4935825", "Kodersdorf",
"499084", "Bissingen\ Schwaben",
"4933051", "Nassenheide",
"492904", "Bestwig",
"494209", "Schwanewede",
"495084", "Hambühren",
"499076", "Wittislingen",
"496668", "Birstein\-Lichenroth",
"4934773", "Schwittersdorf",
"496691", "Schwalmstadt",
"4938454", "Kritzkow",
"4933832", "Rogäsen",
"499604", "Wernberg\-Köblitz",
"495604", "Grossalmerode",
"497854", "Kehl\-Goldscheuer",
"494296", "Schwanewede\-Aschwarden",
"498721", "Eggenfelden",
"497046", "Zaberfeld",
"492305", "Castrop\-Rauxel",
"499164", "Langenfeld\ Mittelfranken",
"495753", "Auetal\-Bernsen",
"4938784", "Kleinow\ Kreis\ Prignitz",
"496736", "Bechenheim",
"495164", "Hodenhagen",
"4933089", "Himmelpfort",
"499133", "Baiersdorf\ Mittelfranken",
"492474", "Nideggen\-Schmidt",
"4939396", "Neukirchen\ Altmark",
"4936464", "Wormstedt",
"492486", "Nettersheim",
"492131", "Neuss",
"49340", "Dessau\ Anh",
"496108", "Mühlheim\ am\ Main",
"4934741", "Frose",
"492751", "Bad\ Berleburg",
"498146", "Moorenweis",
"4934955", "Gossa",
"492272", "Bedburg\ Erft",
"494893", "Hohenaspe",
"492695", "Insul",
"496204", "Viernheim",
"497622", "Schopfheim",
"492338", "Breckerfeld",
"499394", "Esselbach",
"493629", "Stadtilm",
"496301", "Otterbach\ Pfalz",
"492327", "Bochum\-Wattenscheid",
"499268", "Teuschnitz",
"496402", "Hungen",
"494872", "Hanerau\-Hademarschen",
"492293", "Nümbrecht",
"4939827", "Schwarz\ bei\ Neustrelitz",
"496347", "Hochstadt\ Pfalz",
"4938226", "Dierhagen\ Ostseebad",
"4934496", "Nöbdenitz",
"4939349", "Parey\ Elbe",
"496135", "Bodenheim\ Rhein",
"497663", "Eichstetten",
"498683", "Tittmoning",
"496755", "Odernheim\ am\ Glan",
"497634", "Sulzburg",
"497961", "Ellwangen\ Jagst",
"494483", "Ovelgönne\-Grossenmeer",
"4938855", "Lübtheen",
"495467", "Voltlage",
"4938372", "Usedom",
"499467", "Michelsneukirchen",
"498745", "Bodenkirchen",
"498285", "Burtenbach",
"497265", "Angelbachtal",
"497959", "Frankenhardt",
"496673", "Haunetal",
"498803", "Peissenberg",
"494383", "Grebin",
"4938488", "Demen",
"4938224", "Gresenhorst",
"492237", "Kerpen\ Rheinland\-Türnich",
"4934494", "Ehrenhain",
"497587", "Hosskirch",
"492689", "Dierdorf",
"4936848", "Wernshausen",
"496447", "Langgöns\-Niederkleen",
"493969", "Siedenbollentin",
"4934243", "Bad\ Düben",
"499367", "Unterpleichfeld",
"496275", "Rothenberg\ Odenwald",
"494149", "Fredenbeck",
"495367", "Rühen",
"492228", "Remagen\-Rolandseck",
"497962", "Fichtenau",
"498457", "Vohburg\ an\ der\ Donau",
"496401", "Grünberg\ Hessen",
"498206", "Egling\ an\ der\ Paar",
"4935752", "Ruhland",
"495494", "Holdorf\ Niedersachsen",
"4930", "Berlin",
"496509", "Büdlich",
"496788", "Sien",
"494871", "Hohenwestedt",
"4936653", "Lehesten\ Thüringer\ Wald",
"497621", "Lörrach",
"495292", "Lichtenau\-Atteln",
"4938758", "Dömitz",
"496596", "Üdersdorf",
"499292", "Konradsreuth",
"496302", "Winnweiler",
"4934381", "Colditz",
"4935938", "Grosspostwitz\ OL",
"492427", "Nideggen",
"498258", "Sielenbach",
"498707", "Adlkofen",
"4939931", "Röbel\ Müritz",
"4935722", "Lauta\ bei\ Hoyerswerda",
"495693", "Volkmarsen",
"4936623", "Berga\ Elster",
"495295", "Lichtenau\ Westfalen",
"4938728", "Domsühl",
"492691", "Adenau",
"499295", "Töpen",
"496305", "Hochspeyer",
"492993", "Marsberg\-Canstein",
"497546", "Oberteuringen",
"497364", "Oberkochen",
"492736", "Burbach\ Siegerl",
"498384", "Röthenbach\ Allgäu",
"494804", "Nordhastedt",
"498376", "Sulzberg\ Allgäu",
"496486", "Katzenelnbogen",
"497026", "Lenningen",
"497333", "Laichingen",
"492156", "Willich\-Anrath",
"498281", "Thannhausen\ Schwaben",
"4936025", "Körner",
"496474", "Villmar\-Aumenau",
"494537", "Sülfeld\ Holstein",
"497261", "Sinsheim",
"498741", "Vilsbiburg",
"496131", "Mainz",
"493533", "Elsterwerda",
"494528", "Schönwalde\ am\ Bungsberg",
"493771", "Aue\ Sachsen",
"497259", "Östringen\-Odenheim",
"496272", "Hirschhorn\ Neckar",
"499576", "Lichtenfels\-Isling",
"4939997", "Jarmen",
"495584", "Hattorf\ am\ Harz",
"4935456", "Terpt",
"4937361", "Neuhausen\ Erzgebirge",
"497965", "Ellwangen\-Röhlingen",
"493346", "Seelow",
"493564", "Schwarze\ Pumpe",
"496751", "Bad\ Sobernheim",
"494684", "Langeness\ Hallig",
"493772", "Schneeberg\ Erzgebirge",
"496374", "Weilerbach",
"496132", "Ingelheim\ am\ Rhein",
"492937", "Arnsberg\-Oeventrop",
"496386", "Altenkirchen\ Pfalz",
"497433", "Balingen",
"496752", "Kirn\ Nahe",
"499628", "Ursensollen",
"4939223", "Theessen",
"4938825", "Klütz",
"497464", "Talheim\ Kreis\ Tuttlingen",
"494848", "Rantrum",
"496271", "Eberbach\ Baden",
"4933838", "Päwesin",
"499289", "Schwarzenbach\ am\ Wald",
"499749", "Oberbach\ Unterfranken",
"4939035", "Kuhfelde",
"499637", "Falkenberg\ Oberpfalz",
"497554", "Heiligenberg\ Baden",
"498742", "Velden\ Vils",
"498282", "Krumbach\ Schwaben",
"497262", "Eppingen",
"497826", "Schuttertal",
"492928", "Soest\-Ostönnen",
"4935454", "Uckro",
"492692", "Kelberg",
"4933847", "Görzke",
"4933767", "Friedersdorf\ bei\ Berlin",
"497625", "Zell\ im\ Wiesental",
"4939343", "Jerichow",
"496124", "Bad\ Schwalbach",
"496405", "Laubach\ Hessen",
"494875", "Stafstedt",
"4936921", "Wutha\-Farnroda",
"4939857", "Drense",
"497223", "Bühl\ Baden",
"4938393", "Binz\ Ostseebad",
"496237", "Maxdorf",
"497641", "Emmendingen",
"492673", "Ellenz\-Poltersdorf",
"496096", "Wiesen\ Unterfranken",
"4934779", "Abberode",
"492447", "Dahlem\ bei\ Kall",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"497943", "Schöntal\ Jagst",
"492971", "Schmallenberg\-Dorlar",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"499973", "Furth\ im\ Wald",
"495671", "Hofgeismar",
"496228", "Schönau\ Odenwald",
"4936731", "Unterloquitz",
"4934925", "Bad\ Schmiedeberg",
"499671", "Oberviechtach",
"492275", "Kerpen\-Buir",
"499857", "Schopfloch\ Mittelfranken",
"496438", "Hünfelden",
"4933604", "Lebus",
"495857", "Bleckede\-Brackede",
"492401", "Baesweiler",
"4937320", "Mulda\ Sachsen",
"492248", "Hennef\-Uckerath",
"49375", "Zwickau",
"4934606", "Teicha\ Sachsen\-Anhalt",
"492509", "Nottuln\-Appelhülsen",
"4934443", "Teuchern",
"494129", "Haseldorf",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"4938378", "Heringsdorf\ Seebad",
"4934294", "Rackwitz",
"4938424", "Bobitz",
"492596", "Nordkirchen",
"496427", "Cölbe\-Schönstadt",
"498067", "Tuntenhausen",
"495403", "Bad\ Iburg",
"492302", "Witten",
"499403", "Donaustauf",
"492204", "Bensberg",
"4933606", "Müllrose",
"496695", "Jesberg",
"498867", "Rottenbuch\ Oberbayern",
"492301", "Holzwickede",
"496338", "Hornbach\ Pfalz",
"4934604", "Niemberg",
"498725", "Wurmannsquick",
"497194", "Spiegelberg",
"498503", "Neuhaus\ am\ Inn",
"492402", "Stolberg\ Rheinland",
"4936842", "Oberhof\ Thüringen",
"499303", "Eibelstadt",
"496327", "Neustadt\-Lachen",
"4934296", "Groitzsch\ bei\ Pegau",
"4936762", "Steinach\ Thüringen",
"4938426", "Neuburg\-Steinhausen",
"495303", "Wendeburg",
"4939000", "Beetzendorf",
"496293", "Schefflenz",
"4938482", "Warin",
"4939453", "Derenburg",
"4935932", "Guttau",
"498679", "Burgkirchen\ an\ der\ Alz",
"494733", "Butjadingen\-Burhave",
"496809", "Grossrosseln",
"4939721", "Liepen\ bei\ Anklam",
"4938752", "Zierzow\ bei\ Ludwigslust",
"499672", "Neunburg\ vorm\ Wald",
"494153", "Lauenburg\ Elbe",
"494764", "Gnarrenburg\-Klenkendorf",
"495672", "Bad\ Karlshafen",
"494479", "Molbergen\-Peheim",
"498094", "Steinhöring",
"492755", "Bad\ Berleburg\-Schwarzenau",
"497642", "Endingen\ Kaiserstuhl",
"4933925", "Wustrau\-Altfriesack",
"492972", "Schmallenberg",
"493737", "Rochlitz",
"498131", "Dachau",
"497556", "Uhldingen\-Mühlhofen",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"499279", "Mistelgau",
"497824", "Schwanau",
"498751", "Mainburg",
"4933654", "Fünfeichen",
"498272", "Wertingen",
"496384", "Konken",
"499762", "Saal\ an\ der\ Saale",
"494674", "Ockholm",
"496281", "Buchen\ Odenwald",
"4938725", "Gross\ Godems",
"496741", "St\ Goar",
"4939487", "Friedrichsbrunn",
"497249", "Stutensee",
"497466", "Beuron",
"497031", "Böblingen",
"4939976", "Gross\ Bützin",
"4936028", "Kammerforst\ Thüringen",
"4937207", "Hainichen\ Sachsen",
"497832", "Haslach\ im\ Kinzigtal",
"492721", "Lennestadt",
"4939740", "Nechlin",
"494885", "Bergenhusen",
"499723", "Röthlein",
"499505", "Litzendorf",
"496707", "Windesheim",
"495723", "Bad\ Nenndorf",
"4939363", "Angern",
"495505", "Hardegsen",
"4933747", "Marzahna",
"496126", "Idstein",
"492750", "Diedenshausen",
"4933835", "Golzow\ bei\ Brandenburg",
"4938828", "Schönberg",
"498405", "Stammham\ bei\ Ingolstadt",
"494605", "Medelby",
"4935822", "Hagenwerder",
"497831", "Hausach",
"494203", "Weyhe\ bei\ Bremen",
"497032", "Herrenberg",
"498124", "Forstern\ Oberbayern",
"4939038", "Henningen",
"492722", "Attendorn",
"4934654", "Stolberg\ Harz",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"495761", "Stolzenau",
"499574", "Marktzeuln",
"495586", "Wieda",
"4933656", "Bahro",
"494858", "Sankt\ Margarethen\ Holstein",
"495574", "Oberweser",
"496742", "Boppard",
"496282", "Walldürn",
"493344", "Bad\ Freienwalde",
"4937341", "Ehrenfriedersdorf",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"494806", "Sarzbüttel",
"498386", "Oberstaufen",
"497544", "Markdorf",
"497366", "Abtsgmünd",
"492734", "Freudenberg\ Westfalen",
"498374", "Dietmannsried",
"4939050", "Bartensleben",
"495139", "Burgwedel",
"492154", "Willich",
"492763", "Drolshagen\-Bleche",
"498271", "Meitingen",
"497024", "Wendlingen\ am\ Neckar",
"496484", "Beselich",
"498752", "Au\ in\ der\ Hallertau",
"494165", "Hollenstedt\ Nordheide",
"496476", "Mengerskirchen",
"494627", "Dörpstedt",
"499847", "Ergersheim",
"4936742", "Uhlstädt",
"4938204", "Broderstorf",
"498427", "Wellheim",
"4934928", "Seegrehna",
"493921", "Burg\ bei\ Magdeburg",
"492206", "Overath",
"493623", "Friedrichroda",
"494638", "Tarp",
"497651", "Titisee\-Neustadt",
"4938375", "Koserow",
"49381", "Rostock",
"497953", "Blaufelden",
"496894", "St\ Ingbert",
"496187", "Schöneck",
"492982", "Medebach",
"492803", "Wesel\-Büderich",
"4939821", "Carpin",
"4935364", "Lebusa",
"497669", "St\ Märgen",
"4936940", "Oepfershausen",
"492567", "Ahaus\-Alstätte",
"498237", "Aindling",
"494766", "Basdahl",
"493435", "Oschatz",
"494489", "Apen",
"495682", "Borken\ Hessen",
"4933434", "Herzfelde\ bei\ Strausberg",
"499682", "Erbendorf",
"4938852", "Wittenburg",
"4939883", "Gross\ Dölln",
"492357", "Herscheid\ Westfalen",
"4939209", "Wanzleben",
"493963", "Woldegk",
"4935973", "Stolpen",
"497620", "Schopfheim\-Gersbach",
"499681", "Windischeschenbach",
"493661", "Greiz",
"492745", "Brachbach\ Sieg",
"494143", "Drochtersen",
"498177", "Münsing\ Starnberger\ See",
"495681", "Homberg\ Efze",
"492683", "Asbach\ Westerwald",
"498809", "Wessobrunn",
"497652", "Hinterzarten",
"493335", "Finowfurt",
"496400", "Mücke",
"4933436", "Prötzel",
"495802", "Wrestedt",
"492981", "Winterberg\ Westfalen",
"496094", "Weibersbrunn",
"494967", "Rhauderfehn\-Burlage",
"499802", "Ansbach\-Katterbach",
"498327", "Rettenberg",
"492594", "Dülmen",
"498293", "Welden\ bei\ Augsburg",
"4938206", "Graal\-Müritz\ Seeheilbad",
"4935755", "Ortrand",
"498338", "Böhen",
"49911", "Nuremberg",
"496725", "Gau\-Algesheim",
"496503", "Hermeskeil",
"495527", "Duderstadt",
"494495", "Friesoythe\-Thüle",
"496867", "Perl",
"492778", "Siegbach",
"49511", "Hannover",
"499527", "Knetzgau",
"4933928", "Wildberg\ Brandenburg",
"4934463", "Bad\ Kösen",
"499107", "Trautskirchen",
"496082", "Niederreifenberg",
"497422", "Schramberg",
"4939406", "Harbke",
"496123", "Eltville\ am\ Rhein",
"496881", "Lebach",
"493521", "Meissen",
"494778", "Wingst",
"499726", "Euerbach",
"4933837", "Brielow",
"495726", "Wiedensahl",
"4934745", "Winningen\ Sachsen\-Anhalt",
"497224", "Gernsbach",
"498071", "Wasserburg\ am\ Inn",
"497321", "Heidenheim\ an\ der\ Brenz",
"4933653", "Ziltendorf",
"4937342", "Cranzahl",
"4933239", "Gross\ Behnitz",
"496162", "Reinheim\ Odenwald",
"4933768", "Prieros",
"4939364", "Dolle",
"4933848", "Raben",
"4933055", "Kremmen",
"497463", "Mühlheim\ an\ der\ Donau",
"496373", "Schönenberg\-Kübelberg",
"495141", "Celle",
"494683", "Oldsum",
"497434", "Winterlingen",
"499141", "Weissenburg\ in\ Bayern",
"492389", "Werne",
"494745", "Bad\ Bederkesa",
"494285", "Rhade\ bei\ Zeven",
"497171", "Schwäbisch\ Gmünd",
"497232", "Königsbach\-Stein",
"494357", "Sehestedt\ Eider",
"4939858", "Bietikow",
"492582", "Everswinkel",
"497553", "Salem\ Baden",
"496198", "Eppstein",
"497172", "Lorch\ Württemberg",
"497334", "Deggingen",
"496159", "Messel",
"4939366", "Kehnert",
"496473", "Leun",
"496647", "Herbstein\-Stockhausen",
"494803", "Pahlen",
"498383", "Grünenbach\ Allgäu",
"497363", "Lauchheim",
"492581", "Warendorf",
"497231", "Pforzheim",
"4938727", "Mestlin",
"495583", "Braunlage\-Hohegeiss",
"4939973", "Altkalen",
"4939485", "Gernrode\ Harz",
"496161", "Brensbach",
"493563", "Spremberg",
"4935209", "Mohorn",
"499142", "Treuchtlingen",
"498657", "Ramsau\ bei\ Berchtesgaden",
"495142", "Eschede",
"4933989", "Sadenbeck",
"497935", "Schrozberg",
"495694", "Diemelstadt",
"492638", "Waldbreitbach",
"498072", "Haag\ in\ Oberbayern",
"4939404", "Ausleben",
"493329", "Stahnsdorf",
"492395", "Finnentrop\-Rönkhausen",
"499927", "Kirchberg\ Wald",
"494206", "Stuhr\-Heiligenrode",
"497322", "Giengen\ an\ der\ Brenz",
"493522", "Grossenhain\ Sachsen",
"499938", "Moos\ Niederbayern",
"492994", "Marsberg\-Westheim",
"499480", "Sünching",
"496081", "Usingen",
"4934653", "Rottleberode",
"494258", "Schwarme",
"497529", "Waldburg\ Württemberg",
"492627", "Braubach",
"4933745", "Petkus",
"493841", "Wismar",
"4939998", "Loitz\ bei\ Demmin",
"494763", "Gnarrenburg",
"494154", "Trittau",
"497277", "Wörth\-Büchelberg",
"498093", "Glonn\ Kreis\ Ebersberg",
"492165", "Jüchen",
"494734", "Stadland\-Seefeld",
"495475", "Bohmte\-Hunteburg",
"4934466", "Janisroda",
"492858", "Hünxe",
"497445", "Pfalzgrafenweiler",
"495247", "Harsewinkel",
"496585", "Ralingen",
"4934385", "Mutzschen",
"4938203", "Bad\ Doberan",
"4935363", "Fermerswalde",
"497478", "Hirrlingen",
"495905", "Beesten",
"497193", "Sulzbach\ an\ der\ Murr",
"498504", "Tittling",
"494722", "Cuxhaven\-Altenbruch",
"499905", "Bernried\ Niederbayern",
"49202", "Wuppertal",
"4933433", "Buckow\ Märkische\ Schweiz",
"4939884", "Hassleben\ bei\ Prenzlau",
"492203", "Cologne\-Porz",
"495201", "Halle\ Westfalen",
"496294", "Krautheim\ Jagst",
"499201", "Gesees",
"492605", "Löf",
"499448", "Hausen\ Niederbayern",
"496391", "Dahn",
"495448", "Barver",
"495304", "Meine",
"496468", "Dautphetal\-Mornshausen",
"499202", "Waischenfeld",
"498028", "Fischbachau",
"496506", "Welschbillig",
"495202", "Oerlinghausen",
"4939822", "Kratzeburg",
"498548", "Vilshofen\-Sandbach",
"4938851", "Zarrentin",
"49671", "Bad\ Kreuznach",
"496392", "Hauenstein\ Pfalz",
"4939886", "Milmersdorf",
"495404", "Westerkappeln",
"4935974", "Hinterhermsdorf",
"493578", "Kamenz",
"498296", "Villenbach",
"494721", "Cuxhaven",
"499404", "Nittendorf",
"499348", "Werbach\-Gamburg",
"499090", "Rain\ Lech",
"496558", "Büdesheim\ Eifel",
"496599", "Weidenbach\ bei\ Gerolstein",
"496267", "Fahrenbach\ Baden",
"499375", "Freudenberg\ Baden",
"497128", "Sonnenbühl",
"49906", "Donauwörth",
"492058", "Wülfrath",
"495375", "Müden\ Aller",
"497944", "Kupferzell",
"492686", "Weyerbusch",
"4938377", "Zinnowitz",
"4934464", "Freyburg\ Unstrut",
"492674", "Bad\ Bertrich",
"4936741", "Bad\ Blankenburg",
"494146", "Stade\-Bützfleth",
"497345", "Langenau\ Württemberg",
"493966", "Cölpin",
"499974", "Traitsching",
"499573", "Staffelstein\ Oberfranken",
"494972", "Langeoog",
"4936624", "Teichwolframsdorf",
"495731", "Bad\ Oeynhausen",
"495573", "Uslar\-Volpriehausen",
"4938827", "Kalkhorst",
"4936922", "Gerstungen",
"499151", "Hersbruck",
"495151", "Hameln",
"497023", "Weilheim\ an\ der\ Teck",
"496483", "Selters\ Taunus",
"497336", "Lonsee",
"492764", "Welschen\ Ennest",
"492153", "Nettetal\-Lobberich",
"494755", "Ihlienworth",
"497182", "Welzheim",
"4939346", "Tucheim",
"4938229", "Bad\ Sülze",
"497543", "Kressbronn\ am\ Bodensee",
"492733", "Hilchenbach",
"4939037", "Pretzier",
"492571", "Greven\ Westfalen",
"494347", "Flintbek",
"498373", "Altusried",
"494135", "Kirchgellersen",
"496071", "Dieburg",
"496872", "Losheim\ am\ See",
"4933845", "Borkheide",
"495609", "Ahnatal",
"494402", "Rastede",
"4933765", "Märkisch\ Buchholz",
"498123", "Moosinning",
"496580", "Zemmer",
"495696", "Bad\ Arolsen\-Landau",
"4939855", "Parmen\-Weggun",
"497062", "Beilstein\ Württemberg",
"498082", "Schwindegg",
"497440", "Bad\ Rippoldsau",
"4939226", "Hohenziatz",
"494204", "Thedinghausen",
"499089", "Bissingen\-Unterringingen",
"498081", "Dorfen\ Stadt",
"494302", "Kirchbarkau",
"497226", "Bühl\-Sand",
"4935453", "Drahnsdorf",
"4937362", "Seiffen\ Erzgebirge",
"493869", "Dümmer",
"494509", "Gross\ Grönau",
"494248", "Bassum\-Neubruchhausen",
"49761", "Freiburg\ im\ Breisgau",
"496871", "Wadern",
"492129", "Haan\ Rheinland",
"497340", "Neenstetten",
"4939488", "Güntersberge",
"499724", "Stadtlauringen",
"494401", "Brake\ Unterweser",
"495724", "Obernkirchen",
"4939224", "Büden",
"4936626", "Auma",
"499120", "Leinburg",
"498161", "Freising",
"497181", "Schorndorf\ Württemberg",
"497823", "Seelbach\ Schutter",
"4936027", "Lengenfeld\ Unterm\ Stein",
"494275", "Ehrenburg",
"493677", "Ilmenau\ Thüringen",
"4937208", "Auerswalde",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"496657", "Hofbieber",
"492572", "Emsdetten",
"494447", "Vechta\-Langförden",
"4939995", "Nossendorf",
"4939344", "Güsen",
"4933748", "Treuenbrietzen",
"495732", "Löhne",
"4939932", "Malchow\ bei\ Waren",
"494971", "Esens",
"499732", "Hammelburg",
"492379", "Menden\-Asbeck",
"495152", "Hessisch\ Oldendorf",
"494673", "Joldelund",
"499152", "Hartenstein\ Mittelfranken",
"496383", "Glan\-Münchweiler",
"497436", "Messstetten\-Oberdigisheim",
"498294", "Horgau",
"4938459", "Laage",
"4936370", "Grossenehrich",
"495406", "Belm",
"499568", "Neustadt\ bei\ Coburg",
"493588", "Niesky",
"499406", "Mintraching",
"492593", "Ascheberg\ Westfalen",
"4933472", "Golzow\ bei\ Seelow",
"497702", "Blumberg\ Baden",
"496504", "Thalfang",
"4939722", "Sarnow\ bei\ Anklam",
"4935931", "Königswartha",
"495458", "Hopsten",
"498368", "Halblech",
"497388", "Pfronstetten",
"496837", "Wallerfangen",
"499499", "Painten",
"4938751", "Picher",
"4936873", "Themar",
"494740", "Loxstedt\-Dedesdorf",
"494928", "Ihlow\-Riepe",
"493933", "Genthin",
"4936761", "Heubisch",
"4938423", "Bad\ Kleinen",
"4934293", "Naunhof\ bei\ Grimma",
"494144", "Himmelpforten",
"4936841", "Schleusingen",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"493964", "Bredenfelde\ bei\ Strasburg",
"493631", "Nordhausen\ Thüringen",
"4938481", "Witzin",
"498585", "Grainet",
"495976", "Salzbergen",
"499976", "Rötz",
"4939456", "Altenbrak",
"497455", "Dornhan",
"496093", "Laufach",
"4938789", "Wolfshagen\ bei\ Perleberg",
"497946", "Bretzfeld",
"4934901", "Rosslau\ Elbe",
"499385", "Kolitzheim",
"4933603", "Falkenhagen\ bei\ Seelow",
"4934444", "Lützen",
"495257", "Hövelhof",
"4933084", "Gutengermendorf",
"4933927", "Linum",
"492684", "Puderbach\ Westerwald",
"499257", "Zell\ Oberfranken",
"492676", "Ulmen",
"496893", "Saarbrücken\-Ensheim",
"497954", "Kirchberg\ an\ der\ Jagst",
"495777", "Diepenau\-Essern",
"496575", "Landscheid",
"494108", "Rosengarten\ Kreis\ Harburg",
"4939454", "Elbingerode\ Harz",
"499777", "Ostheim\ von\ der\ Rhön",
"492528", "Ennigerloh\-Enniger",
"494156", "Talkau",
"4934927", "Globig\-Bleddin",
"498267", "Dirlewang",
"497747", "Berau",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"492804", "Xanten\-Marienbaum",
"494736", "Butjadingen\-Tossens",
"495485", "Ladbergen",
"4939399", "Kleinau",
"4934446", "Grosskorbetha",
"497355", "Hochdorf\ Riss",
"493632", "Sondershausen",
"4933086", "Grieben\ Kreis\ Oberhavel",
"495592", "Gleichen\-Bremke",
"496296", "Ahorn\ Baden",
"499306", "Kist",
"498558", "Hohenau\ Niederbayern",
"495306", "Cremlingen",
"4936732", "Könitz",
"497930", "Boxberg\ Baden",
"499358", "Gössenheim",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"493624", "Ohrdruf",
"498468", "Altmannstein\-Pondorf",
"496028", "Sulzbach\ am\ Main",
"498506", "Bad\ Höhenstadt",
"495358", "Bahrdorf\-Mackendorf",
"49871", "Landshut",
"498392", "Markt\ Rettenbach",
"494668", "Klanxbüll",
"496209", "Mörlenbach",
"4934742", "Sylda",
"493836", "Wolgast",
"495873", "Eimke",
"4935827", "Nieder\-Seifersdorf",
"499873", "Abenberg\-Wassermungenau",
"498638", "Waldkraiburg",
"496129", "Schlangenbad",
"492871", "Bocholt",
"4936928", "Neuenhof\ Thüringen",
"497843", "Renchen",
"498395", "Tannheim\ Württemberg",
"4939393", "Werben\ Elbe",
"4934609", "Salzmünde",
"493423", "Eilenburg",
"499381", "Volkach",
"493361", "Fürstenwalde\ Spree",
"495381", "Seesen",
"4933831", "Weseram",
"497451", "Horb\ am\ Neckar",
"495284", "Schwalenberg",
"499276", "Bischofsgrün",
"496572", "Manderscheid\ Eifel",
"495744", "Hüllhorst",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"492657", "Uersfeld",
"499284", "Schwarzenbach\ an\ der\ Saale",
"495276", "Marienmünster",
"499744", "Zeitlofs\-Detter",
"498766", "Gammelsdorf",
"497246", "Malsch\ Kreis\ Karlsruhe",
"4933052", "Leegebruch",
"497774", "Eigeltingen",
"499482", "Wörth\ an\ der\ Donau",
"492383", "Bönen",
"493462", "Bad\ Dürrenberg",
"495482", "Tecklenburg",
"497352", "Ochsenhausen",
"497561", "Leutkirch\ im\ Allgäu",
"493635", "Kölleda",
"494237", "Bendingbostel",
"4934776", "Rothenschirmbach",
"498581", "Waldkirchen\ Niederbayern",
"495957", "Lindern\ Oldenburg",
"499708", "Bad\ Bocklet",
"498143", "Inning\ am\ Ammersee",
"497254", "Waghäusel",
"494177", "Drage\ Elbe",
"4938453", "Mistorf",
"4939482", "Gatersleben",
"497562", "Isny\ im\ Allgäu",
"497351", "Biberach\ an\ der\ Riss",
"498582", "Röhrnbach",
"495481", "Lengerich\ Westfalen",
"493461", "Merseburg\ Saale",
"499481", "Pfatter",
"497420", "Deisslingen",
"4939426", "Hessen",
"497452", "Nagold",
"496479", "Waldbrunn\ Westerwald",
"495382", "Bad\ Gandersheim",
"493362", "Erkner",
"499382", "Gerolzhofen",
"495136", "Burgdorf\ Kreis\ Hannover",
"496764", "Rheinböllen",
"4937368", "Deutschneudorf",
"4934774", "Röblingen\ am\ See",
"498389", "Weissensberg",
"496571", "Wittlich",
"496733", "Gau\-Odernheim",
"494293", "Ottersberg\-Fischerhude",
"4934299", "Gaschwitz",
"4938429", "Glasin",
"492872", "Rhede\ Westfalen",
"497043", "Maulbronn",
"494327", "Grossenaspe",
"4933742", "Oehna\ Brandenburg",
"497705", "Wolterdingen\ Schwarzw",
"494338", "Alt\ Duvenstedt",
"4933609", "Brieskow\-Finkenheerd",
"4938783", "Dallmin",
"4939752", "Blumenhagen\ bei\ Strasburg",
"4936463", "Gebstedt",
"495073", "Neustadt\-Esperke",
"4937202", "Claussnitz\ bei\ Chemnitz",
"4938721", "Ziegendorf",
"499073", "Gundelfingen\ an\ der\ Donau",
"496048", "Büdingen\-Eckartshausen",
"494751", "Otterndorf",
"494272", "Siedenburg",
"493644", "Apolda",
"494131", "Lüneburg",
"499868", "Schillingsfürst",
"4937600", "Neumark\ Sachsen",
"492575", "Greven\-Reckenfeld",
"4939728", "Medow\ bei\ Anklam",
"4934382", "Nerchau",
"494474", "Garrel",
"4935751", "Welzow",
"4933478", "Gross\ Neuendorf",
"494486", "Edewecht\-Friedrichsfehn",
"494769", "Bremervörde\-Iselersheim",
"499735", "Massbach",
"499092", "Wemding",
"495155", "Emmerthal",
"497666", "Denzlingen",
"498686", "Petting",
"499155", "Simmelsdorf",
"496804", "Mandelbachtal",
"492296", "Reichshof\-Brüchermühle",
"497727", "Vöhrenbach",
"494305", "Westensee",
"497158", "Neuhausen\ auf\ den\ Fildern",
"492548", "Dülmen\-Rorup",
"497738", "Steisslingen",
"492828", "Emmerich\-Elten",
"4938371", "Karlshagen",
"496875", "Nonnweiler\-Primstal",
"494405", "Edewecht",
"4934244", "Mockrehna",
"496593", "Hillesheim\ Eifel",
"4934493", "Gössnitz\ Thüringen",
"4938223", "Saal\ Vorpom",
"494124", "Glückstadt",
"494948", "Wiesmoor\-Marcardsmoor",
"4939825", "Wokuhl",
"498085", "Sankt\ Wolfgang",
"492504", "Telgte",
"499188", "Postbauer\-Heng",
"492837", "Weeze",
"498203", "Grossaitingen",
"4934324", "Ostrau\ Sachsen",
"498858", "Kochel\-Walchensee",
"494975", "Westerholt\ Ostfriesland",
"496004", "Lich\-Eberstadt",
"499091", "Monheim\ Schwaben",
"4936738", "Königsee",
"496848", "Homburg\-Einöd",
"494271", "Sulingen",
"494752", "Neuhaus\ Oste",
"498165", "Neufahrn\ bei\ Freising",
"496676", "Hohenroda\ Hessen",
"498806", "Utting\ am\ Ammersee",
"496684", "Hofbieber\-Schwarzbach",
"495068", "Elze\ Leine",
"494132", "Amelinghausen",
"492473", "Simmerath",
"499134", "Neunkirchen\ am\ Brand",
"499372", "Klingenberg\ am\ Main",
"4935020", "Struppen",
"497441", "Freudenstadt",
"492159", "Meerbusch\-Osterath",
"497977", "Oberrot\ bei\ Gaildorf",
"496766", "Kisselbach",
"4937348", "Oberwiesenthal\ Kurort",
"495372", "Meinersen",
"493542", "Lübbenau\ Spreewald",
"4933876", "Buschow",
"499163", "Dachsbach",
"498379", "Waltenhofen\-Oberdorf",
"493821", "Ribnitz\-Damgarten",
"496581", "Saarburg",
"495163", "Fallingbostel\-Dorfmark",
"492739", "Wilnsdorf",
"492647", "Kesseling",
"495754", "Extertal\-Bremke",
"4939204", "Niederndodeleben",
"492161", "Mönchengladbach",
"494187", "Holm\-Seppensen",
"497256", "Philippsburg",
"499471", "Burglengenfeld",
"4937754", "Zwönitz",
"495947", "Laar\ Vechte",
"4936925", "Marksuhl",
"495471", "Bohmte",
"498572", "Tann\ Niederbayern",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"499205", "Vorbach",
"492601", "Nauort",
"4939852", "Schönermark\ bei\ Prenzlau",
"496638", "Schwalmtal\-Renzendorf",
"495205", "Bielefeld\-Sennestadt",
"492903", "Meschede\-Freienohl",
"4938821", "Lüdersdorf",
"499083", "Möttingen",
"499122", "Schwabach",
"495083", "Hohne\ bei\ Celle",
"4936606", "Kraftsdorf",
"496395", "Münchweiler\ an\ der\ Rodalb",
"499901", "Hengersberg\ Bayern",
"49391", "Magdeburg",
"497853", "Kehl\-Bodersweier",
"4939031", "Dähre",
"495901", "Fürstenau\ bei\ Bramsche",
"499603", "Floss",
"495603", "Gudensberg",
"4933762", "Zeuthen",
"496627", "Nentershausen\ Hessen",
"4937422", "Markneukirchen",
"497053", "Bad\ Teinach\-Zavelstein",
"497307", "Senden\ Iller",
"495902", "Freren",
"494725", "Helgoland",
"494503", "Timmendorfer\ Strand",
"4936083", "Uder",
"4936604", "Münchenbernsdorf",
"4936021", "Schlotheim",
"493834", "Greifswald",
"492602", "Montabaur",
"4938209", "Sanitz\ bei\ Rostock",
"493863", "Crivitz",
"4937365", "Sayda",
"495883", "Lemgow",
"4935727", "Burghammer",
"495121", "Hildesheim",
"497244", "Weingarten\ Baden",
"498153", "Wessling",
"498764", "Mauern\ Kreis\ Freising",
"4933874", "Stechow\ Brandenburg",
"4939992", "Görmin",
"492162", "Viersen",
"498571", "Simbach\ am\ Inn",
"495472", "Bad\ Essen",
"498733", "Mengkofen",
"492373", "Menden\ Sauerland",
"4933439", "Fredersdorf\-Vogelsdorf",
"499472", "Hohenfels\ Oberpfalz",
"493541", "Calau",
"4933731", "Trebbin",
"495371", "Gifhorn",
"4939206", "Eichenbarleben",
"497442", "Baiersbronn",
"499371", "Miltenberg",
"495746", "Rödinghausen",
"499274", "Hollfeld",
"4939062", "Bebertal",
"495286", "Ottenstein\ Niedersachsen",
"499746", "Zeitlofs",
"496582", "Freudenburg",
"4937756", "Breitenbrunn\ Erzgebirge",
"499286", "Oberkotzau",
"495274", "Nieheim",
"494126", "Horst\ Holstein",
"498075", "Amerang",
"4938334", "Grammendorf",
"492506", "Münster\-Wolbeck",
"4936847", "Steinbach\-Hallenberg",
"499493", "Beratzhausen",
"494707", "Langen\-Neuenwalde",
"492392", "Werdohl",
"49271", "Siegen",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"497325", "Sontheim\ an\ der\ Brenz",
"499178", "Abenberg\ Mittelfranken",
"4935203", "Tharandt",
"493525", "Riesa",
"497148", "Grossbottwar",
"4933921", "Zechlinerhütte",
"4937430", "Eichigt",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"4934907", "Jeber\-Bergfrieden",
"492599", "Ascheberg\-Herbern",
"4933475", "Letschin",
"492558", "Horstmar",
"497175", "Leinzell",
"494281", "Zeven",
"496058", "Gründau",
"498537", "Bad\ Füssing\-Aigen",
"495328", "Altenau\ Harz",
"494741", "Nordholz\ bei\ Bremerhaven",
"492267", "Wipperfürth",
"494384", "Selent",
"496674", "Friedewald\ Hessen",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"4938757", "Neustadt\-Glewe",
"499145", "Solnhofen",
"4935937", "Prischwitz",
"499337", "Gaukönigshofen",
"495145", "Beedenbostel",
"495337", "Kissenbrück",
"497932", "Niederstetten\ Württemberg",
"497633", "Staufen\ im\ Breisgau",
"496165", "Breuberg",
"494484", "Hude\-Wüsting",
"498684", "Fridolfing",
"495428", "Melle\-Neuenkirchen",
"497664", "Freiburg\-Tiengen",
"497931", "Bad\ Mergentheim",
"499428", "Kirchroth",
"496806", "Heusweiler",
"495437", "Menslage",
"494742", "Dorum",
"494282", "Sittensen",
"4935032", "Langenhennersdorf",
"496858", "Ottweiler\-Fürth",
"497235", "Unterreichenbach\ Kreis\ Calw",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"492585", "Warendorf\-Hoetmar",
"4933233", "Ketzin",
"496085", "Waldsolms",
"497425", "Trossingen",
"499393", "Rothenfels\ Unterfranken",
"496203", "Ladenburg",
"492368", "Oer\-Erkenschwick",
"499227", "Neuenmarkt",
"4935693", "Lauschütz",
"495238", "Nieheim\-Himmighausen",
"494958", "Jemgum",
"492294", "Morsbach\ Sieg",
"499238", "Röslau",
"498593", "Untergriesbach",
"4934921", "Kemberg",
"4936735", "Probstzella",
"492391", "Plettenberg",
"4939421", "Osterwieck",
"492377", "Wickede\ Ruhr",
"4933479", "Küstrin\-Kietz",
"496661", "Schlüchtern",
"494541", "Ratzeburg",
"498649", "Schleching",
"494822", "Kellinghusen",
"494266", "Brockel",
"4939975", "Thürkow",
"495642", "Warburg\-Scherfede",
"498157", "Feldafing",
"499642", "Kemnath\ Stadt",
"4939483", "Ballenstedt",
"4938452", "Lalendorf",
"4933834", "Pritzerbe",
"496698", "Schrecksbach",
"496659", "Eichenzell",
"497672", "St\ Blasien",
"496147", "Trebur",
"492942", "Geseke",
"496335", "Trulben",
"493679", "Neuhaus\ am\ Rennweg",
"498728", "Geratskirchen",
"494834", "Büsum",
"4933743", "Blönsdorf",
"49251", "Münster",
"494863", "Sankt\ Peter\-Ording",
"497303", "Illertissen",
"4938726", "Spornitz",
"4936462", "Ossmannstedt",
"493725", "Zschopau",
"499194", "Ebermannstadt",
"4937203", "Gersdorf\ bei\ Chemnitz",
"496101", "Bad\ Vilbel",
"493867", "Lübstorf",
"495194", "Bispingen",
"4939753", "Strasburg",
"4938782", "Reetz\ bei\ Perleberg",
"492758", "Bad\ Berleburg\-Girkhausen",
"497403", "Dunningen",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"496102", "Neu\-Isenburg",
"499087", "Marktoffingen",
"49491", "Leer\ Ostfriesland",
"4934743", "Ermsleben",
"495607", "Fuldatal",
"496623", "Rotenburg\ an\ der\ Fulda",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"4938724", "Siggelkow",
"499607", "Luhe\-Wildenau",
"4939407", "Seehausen\ Börde",
"495167", "Walsrode\-Westenholz",
"497671", "Todtnau",
"49681", "Saarbrücken",
"4936739", "Rottenbach",
"492643", "Altenahr",
"499167", "Oberscheinfeld",
"494349", "Dänischenhagen",
"497973", "Obersontheim",
"492941", "Lippstadt",
"4933836", "Butzow\ bei\ Brandenburg",
"4934771", "Querfurt",
"496435", "Wallmerod",
"499943", "Lam\ Oberpfalz",
"494542", "Mölln\ Lauenburg",
"495943", "Emlichheim",
"499641", "Grafenwöhr",
"492245", "Much",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"494183", "Jesteburg",
"494821", "Itzehoe",
"495641", "Warburg",
"499223", "Rugendorf",
"492770", "Eschenburg",
"495223", "Bünde",
"498330", "Legau",
"4936929", "Ruhla",
"496207", "Wald\-Michelbach",
"492925", "Warstein\-Allagen",
"499397", "Wertheim\-Dertingen",
"4938376", "Zirchow",
"492324", "Hattingen\ Ruhr",
"496039", "Karben",
"499625", "Kastl\ bei\ Amberg",
"4938222", "Semlow",
"4934492", "Lucka",
"492066", "Duisburg\-Homberg",
"494845", "Ostenfeld\ Husum",
"495625", "Naumburg\ Hessen",
"495262", "Extertal",
"495826", "Suderburg",
"492431", "Erkelenz",
"494646", "Mohrkirch",
"499262", "Wallenfels",
"499826", "Weidenbach\ Mittelfranken",
"496408", "Buseck",
"496566", "Körperich",
"496344", "Schwegenheim",
"499554", "Untersteinbach\ Unterfranken",
"496781", "Idar\-Oberstein",
"496241", "Worms",
"495554", "Moringen",
"498269", "Unteregg\ bei\ Mindelheim",
"498446", "Pörnbach",
"4939887", "Gerswalde",
"499464", "Walderbach",
"497628", "Efringen\-Kirchen",
"495464", "Alfhausen",
"499779", "Nordheim\ von\ der\ Rhön",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"499433", "Nabburg",
"492174", "Burscheid\ Rheinland",
"492332", "Gevelsberg",
"498251", "Aichach",
"4935754", "Klettwitz",
"498772", "Mallersdorf\-Pfaffenberg",
"495433", "Badbergen",
"496456", "Haina\ Kloster",
"498346", "Pforzen",
"498564", "Johanniskirchen",
"497584", "Altshausen",
"499965", "Sankt\ Englmar",
"494939", "Baltrum",
"492234", "Frechen",
"495259", "Bad\ Driburg\-Neuenheerse",
"4937369", "Wolkenstein",
"497576", "Krauchenwies",
"4938205", "Tessin\ bei\ Rostock",
"495965", "Klein\ Berssen",
"4934383", "Trebsen\ Mulde",
"498533", "Rotthalmünster",
"496444", "Bischoffen",
"4936878", "Oberland",
"498771", "Ergoldsbach",
"496308", "Olsbrücken",
"492263", "Engelskirchen",
"4934321", "Leisnig",
"498252", "Schrobenhausen",
"4936651", "Lobenstein",
"492331", "Hagen\ Westfalen",
"496356", "Carlsberg\ Pfalz",
"495333", "Dettum",
"499261", "Kronach",
"493741", "Plauen",
"495026", "Steimbke",
"499333", "Sommerhausen",
"495261", "Lemgo",
"492432", "Wassenberg",
"498454", "Karlshuld",
"495364", "Velpke",
"495546", "Scheden",
"496242", "Osthofen",
"4935756", "Hosena",
"499546", "Burgebrach",
"499364", "Zellingen",
"496782", "Birkenfeld\ Nahe",
"4933608", "Jacobsdorf\ Mark",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"494703", "Loxstedt\-Donnern",
"494630", "Barderup",
"4934241", "Jesewitz",
"494525", "Ahrensbök",
"4934467", "Eckartsberga",
"4938374", "Lassan\ bei\ Wolgast",
"492222", "Bornheim\ Rheinland",
"492866", "Dorsten\-Rhade",
"4933435", "Rehfelde",
"4934298", "Taucha\ bei\ Leipzig",
"4938428", "Hohenkirchen\ bei\ Wismar",
"4935365", "Falkenberg\ Elster",
"492424", "Vettweiss",
"497527", "Wolfegg",
"4938824", "Mallentin",
"494323", "Bornhöved",
"4936026", "Struth\ bei\ Mühlhausen",
"4939978", "Gross\ Roge",
"493338", "Bernau\ Brandenburg",
"49711", "Stuttgart",
"4937423", "Adorf\ Vogtland",
"494297", "Ottersberg\-Posthausen",
"493695", "Bad\ Salzungen",
"4936082", "Ershausen",
"499929", "Ruhmannsfelden",
"499077", "Bachhagel",
"4935455", "Walddrehna",
"493327", "Werder\ Havel",
"4939034", "Fleetmark",
"494362", "Heiligenhafen",
"494551", "Bad\ Segeberg",
"497802", "Oberkirch\ Baden",
"4934658", "Hayn\ Harz",
"499652", "Waidhaus",
"4935600", "Döbern\ NL",
"494173", "Wulfsen",
"498335", "Fellheim",
"496728", "Ober\-Hilbersheim",
"4939993", "Hohenmocker",
"495652", "Bad\ Sooden\-Allendorf",
"494498", "Saterland\-Ramsloh",
"492775", "Driedorf",
"495535", "Polle",
"496737", "Köngernheim",
"499535", "Pfarrweisach",
"497681", "Waldkirch\ Breisgau",
"498661", "Grabenstätt\ Chiemsee",
"494461", "Jever",
"492952", "Rüthen",
"496157", "Pfungstadt",
"4939201", "Wolmirstedt",
"497682", "Elzach",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"498435", "Ehekirchen",
"492653", "Kaisersesch",
"4939829", "Blankenförde",
"494635", "Sörup",
"494462", "Wittmund",
"492951", "Büren",
"494233", "Blender",
"495953", "Börger",
"492387", "Drensteinfurt\-Walstedde",
"49881", "Weilheim\ in\ Oberbayern",
"494552", "Leezen",
"494361", "Oldenburg\ in\ Holstein",
"499953", "Pilsting",
"4933734", "Felgentreu",
"495651", "Eschwege",
"494264", "Sottrum\ Kreis\ Rotenburg",
"492255", "Euskirchen\-Flamersheim",
"499651", "Vohenstrauss",
"4936601", "Hermsdorf\ Thüringen",
"4936024", "Diedorf\ bei\ Mühlhausen",
"499196", "Wiesenttal",
"498623", "Kirchweidach",
"495196", "Wietzendorf",
"4938826", "Dassow",
"494423", "Fedderwarden",
"4939853", "Holzendorf\ bei\ Prenzlau",
"4933843", "Niemegk",
"498102", "Höhenkirchen\-Siegertsbrunn",
"4933763", "Bestensee",
"494836", "Hennstedt\ Dithmarschen",
"4939347", "Kade",
"4939036", "Binde",
"498225", "Jettingen\-Scheppach",
"495109", "Ronnenberg",
"4934605", "Gröbers",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"497139", "Neuenstadt\ am\ Kocher",
"496772", "Nastätten",
"495544", "Reinhardshagen",
"495366", "Jembke",
"498456", "Lenting",
"499366", "Geroldshausen\ Unterfranken",
"499544", "Baunach",
"493386", "Premnitz",
"496251", "Bensheim",
"492236", "Wesseling\ Rheinland",
"497586", "Herbertingen",
"498344", "Westendorf\ bei\ Kaufbeuren",
"4933232", "Brieselang",
"4937349", "Scheibenberg",
"497574", "Gammertingen",
"496446", "Hohenahr",
"496269", "Gundelsheim\ Württemberg",
"497761", "Bad\ Säckingen",
"498781", "Rottenburg\ an\ der\ Laaber",
"494608", "Handewitt",
"498241", "Buchloe",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"496597", "Jünkerath",
"498039", "Rott\ am\ Inn",
"4935692", "Kerkwitz",
"4939080", "Kalbe\ Milde",
"495831", "Wittingen",
"4938331", "Rakow\ Vorpom",
"492426", "Nörvenich",
"499831", "Gunzenhausen",
"495032", "Neustadt\ am\ Rübenberge",
"494168", "Neu\ Wulmstorf\-Elstorf",
"498207", "Affing",
"4934926", "Pretzsch\ Elbe",
"4934261", "Kühren\ bei\ Wurzen",
"492833", "Kerken",
"494191", "Kaltenkirchen\ Holstein",
"494855", "Eddelak",
"492864", "Reken",
"4933087", "Bredereiche",
"4933924", "Rägelin",
"4936875", "Straufhain\-Streufdorf",
"4938208", "Kavelstorf",
"497505", "Fronreute",
"493904", "Haldensleben",
"497723", "Furtwangen\ im\ Schwarzwald",
"4939457", "Benneckenstein\ Harz",
"494192", "Bad\ Bramstedt",
"492064", "Dinslaken",
"4934924", "Zahna",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"4935202", "Klingenberg\ Sachsen",
"499832", "Wassertrüdingen",
"4933926", "Herzberg\ Mark",
"495031", "Wunstorf",
"495832", "Hankensbüttel",
"496430", "Hahnstätten",
"499466", "Stamsried",
"495508", "Gleichen\-Rittmarshausen",
"496220", "Wilhelmsfeld",
"495466", "Merzen",
"497762", "Wehr\ Baden",
"498782", "Pfeffenhausen",
"496454", "Lichtenfels\-Sachsenberg",
"4933605", "Boossen",
"494644", "Karby",
"495824", "Bad\ Bodenteich",
"496346", "Annweiler\ am\ Trifels",
"496564", "Neuerburg\ Eifel",
"499824", "Dietenhofen",
"496252", "Heppenheim\ Bergstrasse",
"499556", "Geiselwind",
"4938425", "Kirchdorf\ Poel",
"4934295", "Krensitz",
"498444", "Schweitenkirchen",
"496533", "Morbach\ Hunsrück",
"4933438", "Altlandsberg",
"495556", "Lindau\ Harz",
"496771", "St\ Goarshausen",
"496653", "Burghaun",
"493971", "Anklam",
"495636", "Lichtenfels\-Goddelsheim",
"499636", "Plössberg",
"493447", "Altenburg\ Thüringen",
"498245", "Türkheim\ Wertach",
"497765", "Rickenbach\ Hotzenwald",
"498785", "Rottenburg\-Oberroning",
"4939361", "Lüderitz",
"496387", "Sankt\ Julian",
"497838", "Nordrach",
"4939972", "Walkendorf",
"496255", "Lindenfels",
"4938455", "Plaaz",
"494443", "Dinklage",
"4936465", "Oberndorf\ bei\ Apolda",
"495768", "Petershagen\-Heimsen",
"49941", "Regensburg",
"4938785", "Berge\ bei\ Perleberg",
"497502", "Wolpertswende",
"4939427", "Ströbeck",
"494195", "Hartenholm",
"49541", "Osnabrück",
"494851", "Marne",
"493302", "Hennigsdorf",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"496704", "Langenlonsheim",
"497309", "Weissenhorn",
"499835", "Ehingen\ Mittelfranken",
"496660", "Steinau\-Marjoss",
"493596", "Neustadt\ in\ Sachsen",
"495835", "Wahrenholz",
"4934652", "Allstedt",
"49531", "Braunschweig",
"4939395", "Wanzer",
"498138", "Schwabhausen\ bei\ Dachau",
"49931", "Würzburg",
"493301", "Oranienburg",
"496629", "Schenklengsfeld",
"495035", "Gross\ Munzel",
"4939401", "Neuwegersleben",
"4933652", "Neuzelle",
"4937343", "Jöhstadt",
"498706", "Vilsheim",
"4934956", "Zörbig",
"494852", "Brunsbüttel",
"49851", "Passau",
"494189", "Undeloh",
"496775", "Strüth\ Taunus",
"4935826", "Königshain\ bei\ Görlitz",
"494343", "Laboe",
"498377", "Unterthingau",
"492737", "Netphen\-Deuz",
"494536", "Steinhorst\ Lauenburg",
"492157", "Nettetal\-Kaldenkirchen",
"496326", "Deidesheim",
"4939881", "Ringenwalde\ bei\ Templin",
"496033", "Butzbach",
"495056", "Winsen\-Meissendorf",
"498250", "Hilgertshausen\-Tandern",
"499844", "Obernzenn",
"494624", "Kropp",
"495844", "Clenze",
"4938856", "Pritzier\ bei\ Hagenow",
"4934495", "Dobitschen",
"4938225", "Trinwillershagen",
"4933238", "Senzke",
"498424", "Nassenfels",
"4939823", "Rechlin",
"4939320", "Schinne",
"498105", "Gilching",
"499229", "Mainleus",
"493691", "Eisenach\ Thüringen",
"498222", "Burgau\ Schwaben",
"49395", "Neubrandenburg",
"497685", "Gutach\-Bleibach",
"499773", "Unsleben",
"498665", "Inzell",
"499531", "Ebern",
"495773", "Stemwede\-Wehdem",
"498432", "Burgheim",
"495531", "Holzminden",
"496184", "Langenselbold",
"4939859", "Fürstenwerder",
"495439", "Bersenbrück",
"494632", "Steinbergkirche",
"492454", "Gangelt",
"499439", "Neunburg\-Kemnath",
"494465", "Friedeburg\ Ostfriesland",
"496897", "Sulzbach\ Saar",
"498234", "Bobingen",
"492564", "Vreden",
"4933769", "Töpchin",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"4933849", "Wiesenburg\ Mark",
"4935698", "Hornow",
"498263", "Breitenbrunn\ Schwaben",
"492771", "Dillenburg",
"497743", "Ühlingen\-Birkendorf",
"492533", "Münster\-Nienberge",
"498331", "Memmingen",
"492252", "Zülpich",
"499339", "Ippesheim",
"494365", "Heringsdorf\ Holstein",
"4934461", "Nebra\ Unstrut",
"497805", "Appenweier",
"4935208", "Radeburg",
"495339", "Gielde",
"492354", "Meinerzhagen",
"499655", "Tännesberg",
"492251", "Euskirchen",
"498332", "Ottobeuren",
"495655", "Wanfried",
"493937", "Osterburg\ Altmark",
"497166", "Adelberg",
"492772", "Herborn\ Hessen",
"495532", "Stadtoldendorf",
"499253", "Weissenstadt",
"498431", "Neuburg\ an\ der\ Donau",
"494933", "Dornum\ Ostfriesland",
"499532", "Maroldsweisach",
"493928", "Schönebeck\ Elbe",
"495253", "Bad\ Driburg",
"496236", "Neuhofen\ Pfalz",
"4938202", "Volkenshagen",
"492955", "Büren\-Wewelsburg",
"4936744", "Remda",
"494964", "Rhede\ Ems",
"494631", "Glücksburg\ Ostsee",
"492446", "Heimbach\ Eifel",
"492269", "Kierspe\-Rönsahl",
"4933432", "Müncheberg",
"4938854", "Redefin",
"4934327", "Waldheim\ Sachsen",
"4936640", "Remptendorf",
"492597", "Senden\ Westfalen",
"498324", "Hindelang",
"4935362", "Schönewalde\ bei\ Herzberg",
"498221", "Günzburg",
"499260", "Wilhelmsthal\ Oberfranken",
"495808", "Gerdau",
"494796", "Teufelsmoor",
"4939999", "Tutow",
"496426", "Fronhausen",
"4936330", "Grossberndten",
"498066", "Bad\ Feilnbach",
"496833", "Rehlingen\-Siersburg",
"495044", "Springe\-Eldagsen",
"499856", "Dürrwangen",
"492330", "Herdecke",
"499524", "Zeil\ am\ Main",
"4935971", "Sebnitz",
"496864", "Mettlach",
"495524", "Bad\ Lauterberg\ im\ Harz",
"49228", "Bonn",
"4937363", "Zöblitz",
"495923", "Schüttorf",
"4935452", "Golssen",
"492102", "Ratingen",
"499923", "Teisnach",
"498704", "Altdorf\-Pfettrach",
"494522", "Plön",
"494841", "Husum\ Nordsee",
"495621", "Bad\ Wildungen",
"4933200", "Bergholz\-Rehbrücke",
"499621", "Amberg\ Oberpfalz",
"492225", "Meckenheim\ Rheinland",
"4938458", "Zehna",
"494329", "Langwedel\ Holstein",
"4939207", "Colbitz",
"492623", "Ransbach\-Baumbach",
"494550", "Bühnsdorf",
"4937757", "Rittersgrün",
"4936085", "Reinholterode",
"492921", "Soest",
"499962", "Schwarzach\ Niederbayern",
"494563", "Scharbeutz\-Haffkrug",
"496643", "Herbstein",
"498387", "Weiler\-Simmerberg",
"49281", "Wesel",
"495962", "Herzlake",
"4938788", "Gross\ Warnow",
"497367", "Aalen\-Ebnat",
"494534", "Steinburg\ Kreis\ Storman",
"496477", "Greifenstein\-Nenderoth",
"4936621", "Elsterberg\ bei\ Plauen",
"492662", "Hachenburg",
"492435", "Erkelenz\-Lövenich",
"494453", "Zetel",
"496245", "Biblis",
"4939933", "Vollrathsruhe",
"496785", "Herrstein",
"494179", "Winsen\-Tönnhausen",
"4935726", "Gross\ Särchen",
"495265", "Dörentrup",
"4936923", "Treffurt",
"499265", "Pressig",
"494239", "Dörverden\-Westen",
"493745", "Falkenstein\ Vogtland",
"492934", "Sundern\-Altenhellefeld",
"492661", "Bad\ Marienberg\ Westerwald",
"497467", "Neuhausen\ ob\ Eck",
"492963", "Brilon\-Messinghausen",
"4939398", "Gross\ Garz",
"4936607", "Niederpöllnitz",
"495634", "Waldeck\-Sachsenhausen",
"495961", "Haselünne",
"497557", "Herdwangen\-Schönach",
"499961", "Mitterfels",
"499634", "Wiesau",
"494353", "Ascheffel",
"49201", "Essen",
"493981", "Neustrelitz",
"4939341", "Redekin",
"495663", "Spangenberg",
"492335", "Wetter\ Ruhr",
"4935724", "Lohsa",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"493683", "Schmalkalden",
"496706", "Wallhausen\ Nahe",
"495650", "Cornberg",
"4933877", "Nitzahn",
"496127", "Niedernhausen\ Taunus",
"492922", "Werl",
"497268", "Bad\ Rappenau\-Obergimpern",
"495103", "Wennigsen\ Deister",
"499103", "Cadolzburg",
"49651", "Trier",
"493594", "Bischofswerda",
"496138", "Mommenheim",
"494521", "Eutin",
"497394", "Schelklingen",
"498629", "Palling",
"4939221", "Möckern\ bei\ Magdeburg",
"499622", "Hirschau\ Oberpfalz",
"496758", "Waldböckelheim",
"494842", "Nordstrand",
"495622", "Fritzlar",
"4938484", "Ventschow",
"4933235", "Friesack",
"496234", "Mutterstadt",
"4934498", "Rositz",
"4938228", "Dettmannsdorf\-Kölzow",
"496331", "Pirmasens",
"4936764", "Neuhaus\-Schierschnitz",
"492308", "Unna\-Hemmerde",
"496263", "Neckargerach",
"4936844", "Rohr\ Thüringen",
"494966", "Neubörger",
"492444", "Schleiden\-Gemünd",
"496432", "Diez",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"4934441", "Hohenmölsen",
"494545", "Seedorf\ Lauenburg",
"496665", "Sinntal\-Altengronau",
"497133", "Lauffen\ am\ Neckar",
"498176", "Egling\ bei\ Wolfratshausen",
"492242", "Hennef\ Sieg",
"497164", "Boll\ Kreis\ Göppingen",
"497753", "Albbruck",
"4934904", "Oranienbaum",
"495854", "Bleckede\-Barskamp",
"492839", "Straelen\-Herongen",
"4936733", "Kaulsdorf",
"496105", "Mörfelden\-Walldorf",
"499854", "Wittelshofen",
"493721", "Meinersdorf",
"496222", "Wiesloch",
"496866", "Perl\-Nennig",
"499526", "Riedbach",
"498326", "Fischen\ im\ Allgäu",
"4938754", "Leussow\ bei\ Ludwigslust",
"498033", "Oberaudorf",
"4935695", "Simmersdorf",
"494794", "Worpswede\-Ostersode",
"4935342", "Mühlberg\ Elbe",
"4935934", "Grossdubrau",
"498064", "Au\ bei\ Bad\ Aibling",
"496424", "Ebsdorfergrund",
"497084", "Schömberg\ bei\ Neuenbürg",
"4938391", "Altenkirchen\ Rügen",
"49421", "Bremen",
"492207", "Kürten\-Dürscheid",
"4933473", "Zechin",
"4935205", "Ottendorf\-Okrilla",
"4939489", "Strassberg\ Harz",
"493722", "Limbach\-Oberfrohna",
"499846", "Ipsheim",
"4938756", "Grabow",
"495054", "Bergen\-Sülze",
"496324", "Hassloch",
"495846", "Gartow\ Niedersachsen",
"494626", "Treia",
"4935936", "Sohland\ Spree",
"497729", "Tennenbronn",
"4939723", "Krien",
"498426", "Walting\ Kreis\ Eichstätt",
"496066", "Michelstadt\-Vielbrunn",
"496221", "Heidelberg",
"492566", "Legden",
"4939451", "Wasserleben",
"498236", "Fischach",
"492408", "Aachen\-Kornelimünster",
"496431", "Limburg\ an\ der\ Lahn",
"4938486", "Gustävel",
"494825", "Burg\ Dithmarschen",
"495645", "Borgentreich\-Borgholz",
"4936846", "Suhl\-Dietzhausen",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"494767", "Bremervörde\-Bevern",
"4938422", "Neukloster",
"4934292", "Brandis\ bei\ Wurzen",
"4936766", "Schalkau",
"492241", "Siegburg",
"497273", "Hagenbach\ Pfalz",
"493763", "Glauchau",
"499243", "Pottenstein",
"4937209", "Einsiedel\ bei\ Chemnitz",
"497675", "Bernau\ Baden",
"492456", "Selfkant",
"496186", "Grosskrotzenburg",
"4934906", "Raguhn",
"492945", "Lippstadt\-Benninghausen",
"496174", "Königstein\ im\ Taunus",
"496332", "Zweibrücken",
"4933602", "Alt\ Zeschdorf",
"49551", "Göttingen",
"497402", "Fluorn\-Winzeln",
"499127", "Rosstal\ Mittelfranken",
"49951", "Bamberg",
"495127", "Harsum",
"4938871", "Mühlen\ Eichsen",
"496103", "Langen\ Hessen",
"493501", "Pirna",
"496650", "Hosenfeld",
"494859", "Windbergen",
"495706", "Porta\ Westfalica",
"4938220", "Wustrow\ Ostseebad",
"493496", "Köthen\ Anhalt",
"496622", "Bebra",
"4939325", "Vinzelberg",
"497204", "Malsch\-Völkersbach",
"498035", "Raubling",
"494861", "Tönning",
"49831", "Kempten\ Allgäu",
"498640", "Reit\ Im\ Winkl",
"495138", "Sehnde",
"4935954", "Grossharthau",
"492642", "Remagen",
"4937293", "Eppendorf\ Sachsen",
"497972", "Gschwend\ bei\ Gaildorf",
"495377", "Ehra\-Lessien",
"496265", "Billigheim\ Baden",
"499377", "Freudenberg\-Boxtal",
"499942", "Viechtach",
"4936483", "Ziegenrück",
"494543", "Nusse",
"495942", "Uelsen",
"497347", "Dietenheim",
"497135", "Brackenheim",
"496663", "Steinau\ an\ der\ Strasse",
"494336", "Owschlag",
"4939245", "Loburg",
"4936421", "Camburg",
"494182", "Tostedt",
"497755", "Weilheim\ Kreis\ Waldshut",
"4938843", "Bennin",
"496634", "Gemünden\ Felda",
"495941", "Neuenhaus\ Dinkel",
"499941", "Kötzting",
"494823", "Wilster",
"494181", "Buchholz\ in\ der\ Nordheide",
"495643", "Borgentreich",
"493838", "Bergen\ auf\ Rügen",
"497275", "Kandel",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"495245", "Herzebrock\-Clarholz",
"496587", "Zerf",
"4937603", "Wildenfels",
"497673", "Schönau\ im\ Schwarzwald",
"499245", "Obertrubach",
"493765", "Reichenbach\ Vogtland",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"4935894", "Hähnichen",
"498636", "Ampfing",
"497447", "Baiersbronn\-Schwarzenberg",
"497971", "Gaildorf",
"4936043", "Kirchheilingen",
"492943", "Erwitte",
"4936645", "Mühltroff",
"499278", "Weidenberg",
"4936071", "Teistungen",
"496621", "Bad\ Hersfeld",
"495278", "Höxter\-Ovenhausen",
"4939268", "Egeln",
"499907", "Zenting",
"4936335", "Grosswechsungen",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"495907", "Geeste",
"494862", "Garding",
"4938736", "Goldberg",
"49841", "Ingolstadt\ Donau",
"492607", "Kobern\-Gondorf",
"49461", "Flensburg",
"497248", "Marxzell",
"494340", "Achterwehr",
"492554", "Laer\ Kreis\ Steinfurt",
"4933208", "Fahrland",
"496645", "Ulrichstein",
"495431", "Quakenbrück",
"492262", "Wiehl",
"492826", "Kranenburg\ Niederrhein",
"498532", "Griesbach\ im\ Rottal",
"499431", "Schwandorf",
"497144", "Marbach\ am\ Neckar",
"498253", "Pöttmes",
"499186", "Lauterhofen\ Oberpfalz",
"495332", "Schöppenstedt",
"495174", "Lahstedt",
"497937", "Dörzbach",
"495186", "Salzhemmendorf\-Wallensen",
"499332", "Marktbreit",
"499174", "Hilpoltstein",
"492433", "Hückelhoven",
"494455", "Jade\-Schweiburg",
"4938450", "Tarnow\ bei\ Bützow",
"492779", "Greifenstein\-Beilstein",
"4936379", "Holzengel",
"494946", "Grossefehn\-Bagband",
"492464", "Aldenhoven\ bei\ Jülich",
"496783", "Baumholder",
"496243", "Monsheim",
"4939953", "Schwinkendorf",
"495925", "Wietmarschen",
"493606", "Heiligenstadt\ Heilbad",
"499925", "Bayerisch\ Eisenstein",
"494702", "Sandstedt",
"4933362", "Liepe\ Kreis\ Barnim",
"498856", "Penzberg",
"492223", "Königswinter",
"4939775", "Ahlbeck\ bei\ Torgelow",
"4938780", "Lanz\ Brandenburg",
"495221", "Herford",
"496678", "Wildeck\-Hönebach",
"498808", "Pähl",
"492625", "Ochtendung",
"499221", "Kulmbach",
"495066", "Sarstedt",
"4939929", "Jabel\ bei\ Waren",
"4934673", "Heldrungen",
"499324", "Dettelbach",
"4933971", "Kyritz\ Brandenburg",
"495324", "Vienenburg",
"496054", "Birstein",
"493886", "Gadebusch",
"496526", "Bollendorf",
"499222", "Presseck",
"4939390", "Iden",
"493874", "Ludwigslust",
"495222", "Bad\ Salzuflen",
"4934362", "Mügeln\ bei\ Oschatz",
"496046", "Ortenberg\ Hessen",
"4935327", "Priessen",
"495105", "Barsinghausen",
"496854", "Oberthal\ Saar",
"499105", "Grosshabersdorf",
"497668", "Ihringen",
"495424", "Bad\ Rothenfelde",
"499424", "Strasskirchen",
"4933673", "Weichensdorf",
"498056", "Eggstätt",
"495250", "Delbrück\ Westfalen",
"4938232", "Zingst\ Ostseebad",
"494488", "Westerstede",
"4934425", "Droyssig",
"4938295", "Satow\ bei\ Bad\ Doberan",
"4933397", "Wandlitz",
"495263", "Barntrup",
"499331", "Ochsenfurt",
"4935247", "Zehren\ Sachsen",
"499263", "Ludwigsstadt",
"495331", "Wolfenbüttel",
"4933331", "Casekow",
"494954", "Moormerland",
"495234", "Horn\-Bad\ Meinberg",
"4934208", "Löbnitz\ bei\ Delitzsch",
"499234", "Neusorg",
"492546", "Coesfeld\-Lette",
"497736", "Tengen",
"492364", "Haltern\ Westfalen",
"494355", "Rieseby",
"497156", "Ditzingen",
"492333", "Ennepetal",
"495665", "Guxhagen",
"494287", "Heeslingen\-Boitzen",
"493685", "Hildburghausen",
"498531", "Pocking",
"498773", "Neufahrn\ in\ Niederbayern",
"495432", "Löningen",
"499665", "Königstein\ Oberpfalz",
"492261", "Gummersbach",
"494747", "Beverstedt",
"494639", "Schafflund",
"497683", "Simonswald",
"499775", "Schönau\ an\ der\ Brend",
"4933230", "Börnicke\ Kreis\ Havelland",
"498663", "Ruhpolding",
"494434", "Colnrade",
"492652", "Mendig",
"495775", "Diepenau",
"4936201", "Walschleben",
"498634", "Garching\ an\ der\ Alz",
"499920", "Bischofsmais",
"494463", "Wangerland",
"497357", "Attenweiler",
"494232", "Langwedel\ Kreis\ Verden",
"495952", "Sögel",
"494553", "Geschendorf",
"499952", "Eichendorf",
"492535", "Sendenhorst\-Albersloh",
"497745", "Jestetten",
"498265", "Pfaffenhausen\ Schwaben",
"492620", "Neuhäusel\ Westerwald",
"4934782", "Mansfeld\ Südharz",
"4939328", "Rochau",
"494171", "Winsen\ Luhe",
"4939291", "Calbe\ Saale",
"496035", "Reichelsheim\ Wetterau",
"4935877", "Cunewalde",
"498622", "Tacherting\-Peterskirchen",
"494849", "Hooge",
"494422", "Sande\ Kreis\ Friesl",
"493394", "Wittstock\ Dosse",
"4935389", "Holzdorf\ Elster",
"49631", "Kaiserslautern",
"494321", "Neumünster",
"4939082", "Mieste",
"499748", "Motten",
"499288", "Bad\ Steben",
"4939248", "Dobritz",
"498650", "Marktschellenberg",
"494224", "Gross\ Ippener",
"493494", "Wolfen",
"49641", "Giessen",
"4933452", "Neulewin",
"494322", "Bordesholm",
"4937433", "Gutenfürst",
"4935200", "Arnsdorf\ bei\ Dresden",
"492196", "Wermelskirchen",
"496835", "Beckingen",
"498621", "Trostberg",
"494529", "Süsel\-Bujendorf",
"499704", "Euerdorf",
"495704", "Petershagen\-Friedewalde",
"4939601", "Friedland",
"497258", "Oberderdingen\-Flehingen",
"494421", "Wilhelmshaven",
"497803", "Gengenbach",
"494363", "Lensahn",
"499951", "Landau\ an\ der\ Isar",
"4936338", "Bleicherode",
"497567", "Leutkirch\-Friesenhofen",
"494231", "Verden\ Aller",
"4937464", "Schöneck\ Vogtland",
"495951", "Werlte",
"4939265", "Löderburg",
"499653", "Eslarn",
"4935796", "Panschwitz\-Kuckau",
"494334", "Bredenbek\ bei\ Rendsburg",
"494172", "Salzhausen",
"496636", "Romrod",
"4936648", "Dittersdorf\ bei\ Schleiz",
"495653", "Sontra",
"499255", "Marktleugast",
"492651", "Mayen",
"494935", "Juist",
"495255", "Altenbeken",
"4936691", "Eisenberg\ Thüringen",
"492953", "Wünnenberg",
"497457", "Rottenburg\-Ergenzingen",
"495426", "Glandorf",
"492831", "Geldern",
"498678", "Marktl",
"499426", "Oberschneiding",
"4935473", "Neu\ Lübbenau",
"4933205", "Michendorf",
"4938307", "Poseritz",
"494478", "Cappeln\ Oldenburg",
"498054", "Breitbrunn\ am\ Chiemsee",
"494193", "Henstedt\-Ulzburg",
"497722", "Triberg\ im\ Schwarzwald",
"498846", "Uffing\ am\ Staffelsee",
"496524", "Rodershausen",
"4934342", "Neukieritzsch",
"495864", "Jameln",
"493876", "Perleberg",
"499833", "Heidenheim\ Mittelfranken",
"497130", "Löwenstein\ Württemberg",
"496044", "Schotten\ Hessen",
"495833", "Brome",
"4934632", "Mücheln\ Geiseltal",
"496856", "St\ Wendel\-Niederkirchen",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"497734", "Gailingen",
"492366", "Herten\ Westfalen",
"496655", "Neuhof\ Kreis\ Fulda",
"497763", "Murg",
"4936703", "Gräfenthal",
"498783", "Rohr\ in\ Niederbayern",
"496339", "Grosssteinhausen",
"498243", "Fuchstal",
"497154", "Kornwestheim",
"493675", "Sonneberg\ Thüringen",
"494277", "Schwaförden",
"4935267", "Diesbar\-Seusslitz",
"499097", "Marxheim",
"495236", "Blomberg\-Grossenmarpe",
"494956", "Uplengen",
"4934222", "Arzberg\ bei\ Torgau",
"496253", "Fürth\ Odenwald",
"499236", "Nagel",
"494445", "Visbek\ Kreis\ Vechta",
"4935602", "Drebkau",
"496532", "Zeltingen\-Rachtig",
"499184", "Deining\ Oberpfalz",
"495176", "Edemissen",
"496439", "Holzappel",
"499176", "Allersberg",
"495184", "Freden\ Leine",
"494128", "Kollmar",
"4933093", "Fürstenberg\ Havel",
"496531", "Bernkastel\-Kues",
"496773", "Kamp\-Bornhofen",
"492508", "Drensteinfurt",
"494944", "Wiesmoor",
"494137", "Barendorf",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"492556", "Metelen",
"494757", "Wanna",
"492824", "Kalkar",
"497146", "Remseck\ am\ Neckar",
"4935023", "Bad\ Gottleuba",
"495064", "Gross\ Düngen",
"4934205", "Markranstädt",
"496844", "Blieskastel\-Altheim",
"499326", "Markt\ Einersheim",
"4938321", "Martensdorf\ bei\ Stralsund",
"496056", "Bad\ Soden\-Salmünster",
"495326", "Langelsheim",
"495033", "Wunstorf\-Grossenheidorn",
"4933632", "Hangelsberg",
"496008", "Echzell",
"492832", "Kevelaer",
"497721", "Villingen\ im\ Schwarzwald",
"496229", "Neckarsteinach",
"498046", "Bad\ Heilbrunn",
"4938794", "Cumlosen",
"494407", "Wardenburg",
"49241", "Aachen",
"4939322", "Tangermünde",
"496196", "Bad\ Soden\ am\ Taunus",
"4938351", "Mesekenhagen",
"4939386", "Seehausen\ Altmark",
"496109", "Frankfurt\-Bergen\-Enkheim",
"4936427", "Dornburg\ Saale",
"4933969", "Stepenitz",
"492835", "Issum",
"4936946", "Erbenhausen\ Thüringen",
"494853", "Sankt\ Michaelisdonn",
"496669", "Neuhof\-Hauswurz",
"497300", "Roggenburg",
"494208", "Grasberg",
"498641", "Grassau\ Kreis\ Traunstein",
"494441", "Vechta",
"492636", "Burgbrohl",
"4939242", "Prödel",
"494977", "Blomberg\ Ostfriesland",
"4939088", "Letzlingen",
"494342", "Preetz\ Kreis\ Plön",
"496651", "Rasdorf",
"493973", "Pasewalk",
"498167", "Zolling",
"499936", "Wallerfing",
"493671", "Saalfeld\ Saale",
"4935053", "Glashütte\ Sachsen",
"495936", "Twist",
"494256", "Hilgermissen",
"499728", "Wülfershausen\ Unterfranken",
"496652", "Hünfeld",
"494244", "Harpstedt",
"4936077", "Grossbodungen",
"493672", "Rudolstadt",
"494776", "Osten\-Altendorf",
"499157", "Alfeld\ Mittelfranken",
"498642", "Übersee",
"495157", "Emmerthal\-Börry",
"499737", "Wartmannsroth",
"494829", "Wewelsfleth",
"494442", "Lohne\ Oldenburg",
"496620", "Philippsthal\ Werra",
"4933458", "Falkenberg\ Mark",
"496535", "Osann\-Monzel",
"4935771", "Bad\ Muskau",
"4938796", "Viesecke",
"49231", "Dortmund",
"4939384", "Arendsee\ Altmark",
"494307", "Raisdorf",
"497725", "Königsfeld\ im\ Schwarzwald",
"497503", "Wilhelmsdorf\ Württemberg",
"498194", "Vilgertshofen",
"4936642", "Harra",
"493303", "Birkenwerder",
"494180", "Königsmoor",
"4936332", "Ellrich",
"4936944", "Rentwertshausen",
"497384", "Schelklingen\-Hütten",
"498546", "Windorf\-Otterskirchen",
"4934638", "Zöschen",
"498364", "Seeg",
"495454", "Hörstel\-Riesenbeck",
"4939746", "Krackow",
"497376", "Langenenslingen",
"499454", "Aufhausen\ Oberpfalz",
"4936257", "Luisenthal\ Thüringen",
"496249", "Guntersblum",
"498333", "Babenhausen\ Schwaben",
"496466", "Dautphetal\-Friedensdorf",
"4934348", "Frohburg",
"498026", "Hausham",
"496508", "Hetzerath\ Mosel",
"496789", "Heimbach\ Nahe",
"494175", "Egestorf\ Nordheide",
"499220", "Kasendorf\-Azendorf",
"498261", "Mindelheim",
"4937439", "Jocketa",
"492773", "Haiger",
"497741", "Tiengen\ Hochrhein",
"495771", "Rahden\ Westfalen",
"496556", "Pronsfeld",
"499252", "Helmbrechts",
"495533", "Bodenwerder",
"4933977", "Gumtow",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"494932", "Norderney",
"499533", "Untermerzbach",
"495252", "Bad\ Lippspringe",
"498259", "Schiltberg",
"493576", "Weisswasser",
"495346", "Liebenburg",
"495564", "Dassel",
"496824", "Ottweiler",
"499346", "Grünsfeld",
"499564", "Bad\ Rodach",
"492688", "Kroppach",
"497707", "Bräunlingen",
"4935608", "Gross\ Ossnig",
"49365", "Gera",
"493991", "Waren\ Müritz",
"497126", "Burladingen\-Melchingen",
"492056", "Heiligenhaus",
"493693", "Meiningen",
"492844", "Rheinberg\-Orsoy",
"496832", "Beckingen\-Reimsbach",
"4935435", "Gollmitz\ bei\ Calau",
"493968", "Schönbeck",
"496031", "Friedberg\ Hessen",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"494924", "Moormerland\-Oldersum",
"494148", "Drochtersen\-Assel",
"4939772", "Rothemühl",
"4939054", "Flechtingen",
"497906", "Braunsbach",
"496032", "Bad\ Nauheim",
"496831", "Saarlouis",
"4933337", "Altkünkendorf",
"494425", "Wangerland\-Hooksiel",
"4935241", "Lommatzsch",
"4938292", "Kröpelin",
"4934422", "Osterfeld",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"494104", "Aumühle\ bei\ Hamburg",
"492524", "Ennigerloh",
"492856", "Hamminkeln\-Brünen",
"497958", "Rot\ Am\ See\-Brettheim",
"4939056", "Klüden",
"498223", "Ichenhausen",
"494664", "Neukirchen\ bei\ Niebüll",
"494931", "Norden",
"495251", "Paderborn",
"499772", "Bischofsheim\ an\ der\ Rhön",
"499251", "Münchberg",
"492655", "Weibern",
"496544", "Rhaunen",
"498433", "Königsmoos",
"495772", "Espelkamp",
"4939744", "Rothenklempenow",
"499354", "Rieneck",
"4935383", "Elster\ Elbe",
"493628", "Arnstadt",
"494633", "Satrup",
"497476", "Bisingen",
"495354", "Jerxheim",
"492339", "Sprockhövel\-Hasslinghausen",
"497484", "Simmersfeld",
"496024", "Schöllkrippen",
"498464", "Dietfurt\ an\ der\ Altmühl",
"4933638", "Rüdersdorf\ bei\ Berlin",
"494235", "Langwedel\-Etelsen",
"499446", "Altmannstein",
"499269", "Tettau\ Kreis\ Kronach",
"495955", "Esterwegen",
"495446", "Rehden",
"499955", "Mamming",
"498554", "Schönberg\ Niederbayern",
"492532", "Ostbevern",
"497742", "Klettgau",
"4934977", "Quellendorf",
"498262", "Mittelneufnach",
"492253", "Bad\ Münstereifel",
"498651", "Bad\ Reichenhall",
"494559", "Wensin",
"4937382", "Geringswalde",
"4934600", "Ostrau\ Saalkreis",
"494320", "Heidmühlen",
"4937326", "Frauenstein\ Sachsen",
"49981", "Ansbach",
"4934785", "Sandersleben",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"496167", "Modautal",
"497228", "Forbach",
"494451", "Varel\ Jadebusen",
"49581", "Uelzen",
"492962", "Olsberg",
"4933679", "Wendisch\ Rietz",
"496641", "Lauterbach\ Hessen",
"4939004", "Köckte\ bei\ Gardelegen",
"492587", "Ennigerloh\-Westkirchen",
"498669", "Traunreut",
"494561", "Neustadt\ in\ Holstein",
"497237", "Neulingen\ Enzkreis",
"494352", "Damp",
"499435", "Schwarzenfeld",
"494469", "Wangerooge",
"494246", "Twistringen\-Heiligenloh",
"495662", "Felsberg\ Hessen",
"493682", "Zella\-Mehlis",
"494774", "Hechthausen",
"495435", "Berge\ bei\ Quakenbrück",
"499662", "Vilseck",
"499225", "Stadtsteinach",
"492621", "Lahnstein",
"4939085", "Zichtau",
"495225", "Spenge",
"493847", "Sternberg",
"4936207", "Plaue\ Thüringen",
"495102", "Laatzen",
"492923", "Lippetal\-Herzfeld",
"4936964", "Dermbach\ Rhön",
"496087", "Waldems",
"499102", "Wilhermsdorf",
"497427", "Schömberg\ bei\ Balingen",
"4935843", "Hirschfelde\ bei\ Zittau",
"499921", "Regen",
"495921", "Nordhorn",
"498196", "Pürgen",
"494843", "Viöl",
"495623", "Edertal",
"492103", "Hilden",
"495922", "Bad\ Bentheim",
"4936870", "Masserberg",
"497327", "Dischingen",
"499922", "Zwiesel",
"494523", "Malente",
"494705", "Wremen",
"4936966", "Kaltennordheim",
"4933704", "Baruth\ Mark",
"492622", "Bendorf\ am\ Rhein",
"4939959", "Dargun",
"499101", "Langenzenn",
"496887", "Schmelz\ Saar",
"4936373", "Buttstädt",
"495101", "Pattensen",
"494230", "Verden\-Walle",
"499963", "Konzell",
"494351", "Eckernförde",
"494562", "Grömitz",
"495963", "Bawinkel",
"496642", "Schlitz",
"492265", "Reichshof\-Eckenhagen",
"499661", "Sulzbach\-Rosenberg",
"493681", "Suhl",
"498535", "Haarbach",
"494254", "Eystrup",
"4937324", "Reinsberg\ Sachsen",
"495934", "Haren\-Rütenbrock",
"495661", "Melsungen",
"495335", "Schladen",
"492663", "Westerburg\ Westerwald",
"495147", "Uetze\-Hänigsen",
"4939607", "Kotelow",
"499335", "Aub\ Kreis\ Würzburg",
"4939006", "Miesterhorst",
"499147", "Nennslingen",
"498652", "Berchtesgaden",
"495659", "Ringgau",
"492634", "Rengsdorf",
"494452", "Zetel\-Neuenburg",
"4939262", "Güsten\ Anh",
"492961", "Brilon",
"499659", "Leuchtenberg",
"4939923", "Priborn",
"498031", "Rosenheim\ Oberbayern",
"494106", "Quickborn\ Kreis\ Pinneberg",
"4934345", "Bad\ Lausick",
"492526", "Sendenhorst",
"495839", "Wittingen\-Ohrdorf",
"4934692", "Alsleben\ Saale",
"4934635", "Bad\ Lauchstädt",
"497305", "Erbach\ Donau",
"494865", "Osterhever",
"497904", "Ilshofen",
"493723", "Hohenstein\-Ernstthal",
"4937609", "Wolkenburg\ Mulde",
"494158", "Roseburg",
"4933202", "Töplitz",
"497131", "Heilbronn\ Neckar",
"499444", "Siegenburg",
"498556", "Haidmühle",
"495308", "Lehre",
"4938301", "Putbus",
"495444", "Wagenfeld",
"498824", "Oberau\ Loisach",
"497751", "Waldshut",
"497272", "Rülzheim",
"496298", "Möckmühl",
"4935605", "Komptendorf",
"495242", "Rheda\-Wiedenbrück",
"494666", "Ladelund",
"496364", "Nussbach\ Pfalz",
"4933368", "Hohensaaten",
"499242", "Gössweinstein",
"493762", "Crimmitschau",
"496261", "Mosbach\ Baden",
"497474", "Haigerloch",
"499356", "Burgsinn",
"498249", "Ettringen\ Wertach",
"498466", "Denkendorf\ Oberbayern",
"496333", "Waldfischbach\-Burgalben",
"496026", "Grossostheim",
"497486", "Horb\-Altheim",
"495356", "Helmstedt\-Barmke",
"492645", "Vettelschoss",
"499241", "Pegnitz",
"493761", "Werdau\ Sachsen",
"497720", "Schwenningen\ am\ Neckar",
"496554", "Waxweiler",
"495241", "Gütersloh",
"4938327", "Elmenhorst\ Vorpom",
"495344", "Lengede",
"497975", "Untergröningen",
"493574", "Lauchhammer",
"499344", "Gerchsheim",
"499566", "Meeder",
"496826", "Bexbach",
"493586", "Neugersdorf\ Sachsen",
"496262", "Aglasterhausen",
"499408", "Altenthann",
"499945", "Arnbruck",
"495456", "Westerkappeln\-Velpe",
"496433", "Hadamar",
"498544", "Eging\ am\ See",
"498366", "Oy\-Mittelberg",
"497386", "Hayingen",
"495945", "Wilsum",
"497132", "Neckarsulm",
"497374", "Uttenweiler",
"492243", "Eitorf",
"497271", "Wörth\ am\ Rhein",
"498024", "Holzkirchen",
"496464", "Angelburg",
"494185", "Marxen\ Auetal",
"4936451", "Buttelstedt",
"496397", "Leimen\ Pfalz",
"4938461", "Bützow",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"495978", "Hörstel\-Dreierwalde",
"499978", "Schönthal\ Oberpfalz",
"494926", "Krummhörn\-Greetsiel",
"496223", "Neckargemünd",
"495207", "Schloss\ Holte\-Stukenbrock",
"4936781", "Grossbreitenbach",
"499207", "Königsfeld\ Oberfranken",
"496625", "Niederaula",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"492678", "Büchel\ bei\ Cochem",
"4934202", "Delitzsch",
"492054", "Essen\-Kettwig",
"497124", "Trochtelfingen\ Hohenz",
"497948", "Öhringen\-Ohrnberg",
"497173", "Heubach",
"497459", "Nagold\-Hochdorf",
"496472", "Weilmünster",
"498756", "Nandlstadt",
"498382", "Lindau\ Bodensee",
"497362", "Bopfingen",
"497551", "Überlingen\ Bodensee",
"494802", "Wrohm",
"498136", "Markt\ Indersdorf",
"4937605", "Hartenstein\ Sachsen",
"493987", "Templin",
"496274", "Waldbrunn\ Odenwald",
"497461", "Tuttlingen",
"4934639", "Wallendorf\ Luppe",
"495582", "Sankt\ Andreasberg",
"4938737", "Ganzlin",
"493562", "Forst\ Lausitz",
"496286", "Walldürn\-Rippberg",
"496746", "Pfalzfeld",
"499143", "Pappenheim\ Mittelfranken",
"498708", "Weihmichl\-Unterneuhausen",
"492667", "Stein\-Neukirch",
"497569", "Isny\-Eisenbach",
"496371", "Landstuhl",
"4937438", "Bad\ Brambach",
"495143", "Winsen\ Aller",
"494681", "Wyk\ auf\ Föhr",
"498073", "Gars\ am\ Inn",
"4938354", "Wusterhusen",
"494527", "Bosau",
"499495", "Breitenbrunn\ Oberpfalz",
"4938791", "Bad\ Wilsnack",
"497323", "Gerstetten",
"495495", "Vörden\ Kreis\ Vechta",
"4936333", "Heringen\ Helme",
"493523", "Coswig\ bei\ Dresden",
"4935609", "Drachhausen",
"4936643", "Thimmendorf",
"496083", "Weilrod",
"497423", "Oberndorf\ am\ Neckar",
"499395", "Triefenstein",
"4938356", "Behrenhoff",
"496122", "Hofheim\-Wallau",
"492927", "Neuengeseke",
"492694", "Wershofen",
"496205", "Hockenheim",
"493843", "Güstrow",
"499638", "Neualbenreuth",
"4939323", "Schönhausen\ Elbe",
"4939820", "Triepkendorf",
"494847", "Oster\-Ohrstedt",
"4936941", "Wasungen",
"499627", "Freudenberg\ Oberpfalz",
"496150", "Weiterstadt",
"497836", "Schiltach",
"492938", "Ense",
"497520", "Bodnegg",
"496754", "Martinstein",
"493561", "Guben",
"497635", "Schliengen",
"496163", "Höchst\ im\ Odenwald",
"4939243", "Nedlitz\ bei\ Zerbst",
"497462", "Immendingen",
"4938845", "Kaarssen",
"493774", "Schwarzenberg",
"494682", "Amrum",
"496134", "Mainz\-Kastel",
"496372", "Bruchmühlbach\-Miesau",
"495766", "Rehburg\-Loccum",
"499766", "Grosswenkheim",
"498744", "Gerzen",
"4937295", "Lugau\ Erzgebirge",
"499070", "Tapfheim",
"497264", "Bad\ Rappenau",
"496471", "Weilburg",
"498284", "Ziemetshausen",
"4935052", "Kipsdorf\ Kurort",
"4935774", "Boxberg\ Sachsen",
"498276", "Baar\ Schwaben",
"492583", "Sassenberg",
"497233", "Niefern\-Öschelbronn",
"498381", "Lindenberg\ im\ Allgäu",
"497552", "Pfullendorf",
"497361", "Aalen",
"499203", "Neudrossenfeld",
"4938293", "Kühlungsborn\ Ostseebad",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"4934423", "Heuckewalde",
"496227", "Walldorf\ Baden",
"495203", "Werther\ Westfalen",
"4935246", "Ziegenhain\ Sachsen",
"4939832", "Wesenberg",
"4935028", "Krippen",
"492905", "Bestwig\-Ramsbeck",
"499085", "Alerheim",
"496393", "Fischbach\ bei\ Dahn",
"4933675", "Tauche",
"495085", "Burgdorf\-Ehlershausen",
"497191", "Backnang",
"492448", "Hellenthal\-Rescheid",
"4939051", "Calvörde",
"492304", "Schwerte",
"499605", "Weiherhammer",
"496238", "Dirmstein",
"495605", "Kaufungen\ Hessen",
"495806", "Barum\ bei\ Bad\ Bevensen",
"496428", "Stadtallendorf",
"499165", "Sugenheim",
"494139", "Hohnstorf\ Elbe",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"497656", "Schluchsee",
"495165", "Rethem\ Aller",
"498091", "Kirchseeon",
"494761", "Bremervörde",
"492247", "Neunkirchen\-Seelscheid",
"495858", "Hitzacker\-Wietzetze",
"4939089", "Bismark\ Altmark",
"4933396", "Klosterfelde",
"499674", "Schönsee",
"495686", "Schwarzenborn\ Knüll",
"494762", "Kutenholz",
"495674", "Grebenstein",
"4939955", "Jürgenstorf",
"498092", "Grafing\ bei\ München",
"496328", "Elmstein",
"498735", "Gangkofen\-Kollbach",
"4939861", "Gramzow\ bei\ Prenzlau",
"492375", "Balve",
"4939741", "Jatznick",
"499099", "Kaisheim",
"4935324", "Crinitz",
"496337", "Grossbundenbach",
"4935478", "Goyatz",
"492974", "Schmallenberg\-Fredeburg",
"496145", "Flörsheim\ am\ Main",
"498868", "Schwabsoien",
"4933394", "Blumberg\ Kreis\ Barnim",
"497644", "Kenzingen",
"4935244", "Krögis",
"497055", "Neuweiler\ Kreis\ Calw",
"494505", "Stockelsdorf\-Curau",
"494723", "Cuxhaven\-Altenwalde",
"497192", "Murrhardt",
"492202", "Bergisch\ Gladbach",
"4939773", "Altwarp",
"492404", "Alsdorf\ Rheinland",
"493865", "Holthusen",
"493727", "Mittweida",
"4937608", "Waldenburg\ Sachsen",
"498121", "Markt\ Schwaben",
"4936961", "Bad\ Liebenstein",
"494303", "Schlesen",
"4935797", "Schwepnitz",
"497834", "Wolfach",
"4937435", "Reuth\ bei\ Plauen",
"496073", "Babenhausen\ Hessen",
"4936372", "Kleinneuhausen",
"495909", "Wettrup",
"4933470", "Lietzen",
"492696", "Nohn\ Eifel",
"493307", "Zehdenick",
"497822", "Ettenheim",
"497449", "Baiersbronn\-Obertal",
"497266", "Kirchardt",
"4935874", "Bernstadt\ an\ der\ Eigen",
"498274", "Buttenwiesen",
"497021", "Kirchheim\ unter\ Teck",
"499080", "Harburg\ Schwaben",
"4933369", "Oderberg",
"492151", "Krefeld",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"496589", "Kell\ am\ See",
"497541", "Friedrichshafen",
"4935439", "Zinnitz",
"492573", "Nordwalde",
"495733", "Vlotho",
"4939263", "Unseburg",
"493341", "Strausberg",
"496756", "Winterbach\ Soonwald",
"495571", "Uslar",
"499733", "Münnerstadt",
"499571", "Lichtenfels\ Bayern",
"4939922", "Dambeck\ bei\ Röbel",
"496136", "Nieder\-Olm",
"495764", "Steyerberg",
"4939001", "Apenburg",
"495153", "Salzhemmendorf",
"499764", "Höchheim",
"496382", "Lauterecken",
"494672", "Langenhorn",
"499153", "Schnaittach",
"499572", "Burgkunstadt",
"494973", "Wittmund\-Burhafe",
"496276", "Hesseneck",
"496744", "Oberwesel",
"495572", "Bodenfelde",
"4935876", "Weissenberg\ Sachsen",
"4937321", "Frankenstein\ Sachsen",
"496284", "Mudau",
"493342", "Neuenhagen\ bei\ Berlin",
"494671", "Bredstedt",
"496381", "Kusel",
"4937383", "Lunzenau",
"492152", "Kempen",
"495379", "Sassenburg\-Grussendorf",
"496482", "Runkel",
"497022", "Nürtingen",
"498754", "Volkenschwand",
"493860", "Raben\ Steinfeld",
"497183", "Rudersberg\ Württemberg",
"497821", "Lahr\ Schwarzwald",
"492732", "Kreuztal",
"497542", "Tettnang",
"493441", "Zeitz",
"498372", "Obergünzburg",
"498134", "Odelzhausen",
"4937467", "Klingenthal\ Sachsen",
"496873", "Nonnweiler",
"494403", "Bad\ Zwischenahn",
"4938848", "Vellahn",
"49791", "Schwäbisch\ Hall",
"496595", "Dockweiler",
"498122", "Erding",
"497063", "Bad\ Wimpfen",
"498083", "Isen",
"494857", "Barlt",
"492724", "Finnentrop\-Serkenrode",
"499129", "Wendelstein",
"4935842", "Oderwitz",
"4936730", "Sitzendorf",
"495129", "Söhlde",
"4937298", "Oelsnitz\ Erzgebirge",
"4933701", "Grossbeeren",
"498205", "Dasing",
"497034", "Ehningen",
"4933678", "Storkow\ Mark",
"4935025", "Liebstadt",
"494637", "Sterup",
"494749", "Schiffdorf\-Geestenseth",
"494289", "Kirchtimke",
"492984", "Hallenberg",
"4933965", "Herzsprung\ bei\ Wittstock",
"497646", "Weisweil\ Breisgau",
"4938304", "Garz\ Rügen",
"492257", "Reckerscheid",
"495684", "Frielendorf",
"499676", "Winklarn",
"496068", "Beerfelden",
"493931", "Stendal",
"495676", "Liebenau\ Hessen",
"499848", "Simmershofen",
"492385", "Hamm\-Rhynern",
"495848", "Trebel",
"4936920", "Grossenlupnitz",
"495593", "Bovenden\-Lenglern",
"492568", "Heek",
"498238", "Gessertshausen",
"492406", "Herzogenrath",
"495875", "Emmendorf",
"499875", "Wolframs\-Eschenbach",
"4938466", "Jürgenshagen",
"4935264", "Strehla",
"496188", "Kahl\ am\ Main",
"498393", "Holzgünz",
"493425", "Wurzen",
"492591", "Lüdinghausen",
"4934203", "Zwenkau",
"494295", "Emtinghausen",
"4936784", "Stützerbach",
"492306", "Lünen",
"494968", "Neulehe",
"497045", "Oberderdingen",
"492592", "Selm",
"4938464", "Bernitt",
"497703", "Bonndorf\ im\ Schwarzwald",
"497525", "Aulendorf",
"498178", "Icking",
"4933203", "Kleinmachnow",
"4935266", "Heyda\ bei\ Riesa",
"49465", "Sylt",
"499075", "Glött",
"4935475", "Straupitz",
"4937360", "Olbernhau",
"492358", "Meinerzhagen\-Valbert",
"496868", "Mettlach\-Tünsdorf",
"492777", "Breitscheid\ Hessen",
"499528", "Donnersdorf",
"498337", "Altenstadt\ Iller",
"498145", "Mammendorf",
"495528", "Gieboldehausen",
"497939", "Schrozberg\-Spielbach",
"4938306", "Samtens",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"496092", "Heimbuchenthal",
"499804", "Aurach",
"492485", "Schleiden\-Dreiborn",
"4936454", "Magdala",
"496155", "Griesheim\ Hessen",
"498328", "Balderschwang",
"496735", "Eppelsheim",
"497654", "Löffingen",
"495657", "Meissner",
"493935", "Tangerhütte",
"497534", "Reichenau\ Baden",
"492744", "Herdorf",
"4938797", "Karstädt\ Kreis\ Prignitz",
"499657", "Waldthurn",
"498142", "Olching",
"4936378", "Ostramondra",
"496120", "Aarbergen",
"495149", "Wienhausen",
"497563", "Kisslegg",
"498583", "Neureichenau",
"499149", "Weissenburg\-Suffersheim",
"497807", "Neuried\ Ortenaukreis",
"492381", "Hamm\ Westfalen",
"494367", "Grossenbrode",
"495383", "Lutter\ am\ Barenberge",
"497453", "Altensteig\ Württemberg",
"496095", "Bessenbach",
"499383", "Wiesentheid",
"4936042", "Tonna",
"492482", "Hellenthal",
"492957", "Wünnenberg\-Haaren",
"4933209", "Caputh",
"4936424", "Kahla\ Thüringen",
"496152", "Gross\-Gerau",
"4937602", "Kirchberg\ Sachsen",
"496732", "Wörrstadt",
"493334", "Eberswalde",
"494292", "Ritterhude",
"492873", "Isselburg\-Werth",
"497841", "Achern",
"497042", "Vaihingen\ an\ der\ Enz",
"493529", "Heidenau\ Sachsen",
"492595", "Olfen",
"4936076", "Niederorschel",
"4939928", "Möllenhagen",
"493421", "Torgau",
"4938874", "Lützow",
"497522", "Wangen\ im\ Allgäu",
"496724", "Stromberg\ Hunsrück",
"493322", "Falkensee",
"4935951", "Neukirch\ Lausitz",
"494494", "Bösel\ Oldenburg",
"495072", "Neustadt\-Mandelsloh",
"499871", "Windsbach",
"497329", "Steinheim\ am\ Albuch",
"499072", "Lauingen\ Donau",
"4938731", "Lübz",
"494268", "Bötersen",
"493321", "Nauen\ Brandenburg",
"498380", "Achberg",
"4938876", "Roggendorf",
"499071", "Dillingen\ an\ der\ Donau",
"495872", "Stoetze",
"495071", "Schwarmstedt",
"4936074", "Worbis",
"499872", "Heilsbronn",
"497041", "Mühlacker",
"497429", "Egesheim",
"497842", "Kappelrodeck",
"498726", "Schönau\ Niederbayern",
"494394", "Bokhorst",
"496696", "Gilserberg",
"4937292", "Oederan",
"494467", "Wittmund\-Funnix",
"496151", "Darmstadt",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"496573", "Gillenfeld",
"496731", "Alzey",
"4939387", "Havelberg",
"498667", "Seeon\-Seebruck",
"498141", "Fürstenfeldbruck",
"4936426", "Ottendorf\ bei\ Stadtroda",
"4935891", "Rothenburg\ OL",
"4938842", "Lüttenmark",
"494557", "Blunk",
"4936482", "Triptis",
"4936947", "Jüchsen",
"492382", "Ahlen\ Westfalen",
"497353", "Schwendi",
"495483", "Lienen",
"4936254", "Friedrichswerth",
"495037", "Bad\ Rehburg",
"496306", "Trippstadt",
"494604", "Grossenwiehe",
"498348", "Bidingen",
"498404", "Oberdolling",
"497578", "Wald\ Hohenz",
"4934363", "Cavertitz",
"496592", "Daun",
"493378", "Ludwigsfelde",
"495209", "Gütersloh\-Friedrichsdorf",
"4933974", "Dessow",
"4938233", "Prerow\ Ostseebad",
"499209", "Emtmannsberg",
"499548", "Mühlhausen\ Mittelfranken",
"496358", "Kriegsfeld",
"495028", "Pennigsehl",
"4934976", "Gröbzig",
"498202", "Althegnenberg",
"4933672", "Pfaffendorfb\ Beeskow",
"499575", "Weismain",
"497966", "Unterschneidheim",
"4933336", "Passow\ Kreis\ Uckermark",
"49760", "Oberried\ Breisgau",
"4935385", "Annaburg",
"496485", "Nentershausen\ Westerwald",
"497025", "Neuffen",
"494164", "Harsefeld",
"494753", "Balje",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"497545", "Immenstaad\ am\ Bodensee",
"492735", "Neunkirchen\ Siegerl",
"493944", "Blankenburg\ Harz",
"494133", "Wittorf\ Kreis\ Lüneburg",
"498375", "Weitnau",
"497825", "Kippenheim",
"498247", "Bad\ Wörishofen",
"494273", "Kirchdorf\ bei\ Sulingen",
"493445", "Naumburg\ Saale",
"4933334", "Greiffenberg",
"496257", "Seeheim\-Jugenheim",
"4939952", "Grammentin",
"499093", "Polsingen",
"496385", "Reichenbach\-Steegen",
"4933363", "Altenhof\ Kreis\ Barnim",
"49234", "Bochum",
"4939747", "Züsedom",
"494876", "Reher\ Holstein",
"498304", "Wildpoldsried",
"4936256", "Wechmar",
"494884", "Schwabstedt",
"49721", "Karlsruhe",
"495828", "Himbergen",
"4935433", "Vetschau",
"499828", "Rügland",
"496406", "Lollar",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"496568", "Wolsfeld",
"495837", "Sprakensehl",
"4934672", "Rossleben",
"499837", "Haundorf",
"4933976", "Wutike",
"496458", "Rosenthal\ Hessen",
"496591", "Gerolstein",
"499504", "Stadelhofen",
"497626", "Kandern",
"495504", "Friedland\ Kreis\ Göttingen",
"495903", "Emsbüren",
"4937432", "Pausa\ Vogtland",
"497052", "Bad\ Liebenzell",
"498724", "Massing",
"494502", "Lübeck\-Travemünde",
"499903", "Schöllnach",
"4936375", "Kindelbrück",
"497851", "Kehl",
"497195", "Winnenden",
"495601", "Schauenburg",
"4939294", "Gross\ Rosenburg",
"492205", "Rösrath",
"496694", "Neukirchen\ Knüll",
"49361", "Erfurt",
"498370", "Wiggensbach",
"4939606", "Glienke",
"492603", "Bad\ Ems",
"4939007", "Tangeln",
"495882", "Gorleben",
"499081", "Nördlingen",
"492150", "Meerbusch\-Lank",
"499647", "Kirchenthumbach",
"498152", "Herrsching\ am\ Ammersee",
"494765", "Ebersdorf\ bei\ Bremervörde",
"492163", "Schwalmtal\ Niederrhein",
"494827", "Wacken",
"492754", "Bad\ Laasphe\-Feudingen",
"4939925", "Wredenhagen",
"495647", "Lichtenau\-Kleinenberg",
"498095", "Aying",
"498732", "Frontenhausen",
"4936967", "Geisa",
"495473", "Ostercappeln",
"499198", "Heiligenstadt\ in\ Oberfranken",
"4936204", "Stotternheim",
"492372", "Hemer",
"499473", "Kallmünz",
"495159", "Coppenbrügge\-Bisperode",
"495198", "Schneverdingen\-Wintermoor",
"496142", "Rüsselsheim",
"492947", "Anröchte",
"4939779", "Eggesin",
"492471", "Roetgen\ Eifel",
"497443", "Dornstetten",
"495161", "Walsrode",
"499161", "Neustadt\ an\ der\ Aisch",
"494838", "Tellingstedt",
"496583", "Palzem",
"492472", "Monschau",
"499373", "Amorbach",
"495373", "Hillerse\ Kreis\ Gifhorn",
"4936206", "Grossfahner",
"499162", "Scheinfeld",
"495162", "Fallingbostel",
"4936694", "Schkölen\ Thüringen",
"4934783", "Gerbstedt",
"498151", "Starnberg",
"492274", "Elsdorf\ Rheinland",
"497343", "Buch\ bei\ Illertissen",
"492371", "Iserlohn",
"496667", "Steinau\-Ulmbach",
"498573", "Ering",
"494547", "Gudow\ Lauenburg",
"4934721", "Nienburg\ Saale",
"498731", "Dingolfing",
"496726", "Lorch\ Rheingau",
"494496", "Friesoythe\-Markhausen",
"4937327", "Rechenberg\-Bienenmühle",
"4935058", "Pretzschendorf",
"492902", "Warstein",
"495123", "Schellerten",
"499082", "Oettingen\ in\ Bayern",
"496107", "Kelsterbach",
"493861", "Plate",
"499123", "Lauf\ an\ der\ Pegnitz",
"495082", "Langlingen",
"4939296", "Welsleben",
"497852", "Willstätt",
"494501", "Kastorf\ Holstein",
"497051", "Calw",
"4939604", "Wildberg\ bei\ Altentreptow",
"499602", "Neustadt\ an\ der\ Waldnaab",
"4939083", "Messdorf",
"495602", "Hessisch\ Lichtenau",
"494409", "Westerstede\-Ocholt",
"497632", "Badenweiler",
"492590", "Dülmen\-Buldern",
"497465", "Emmingen\-Liptingen",
"4939329", "Möringen",
"499267", "Nordhalben",
"496375", "Wallhalben",
"494283", "Tarmstedt",
"494743", "Langen\ bei\ Bremerhaven",
"4935022", "Bad\ Schandau",
"492337", "Hagen\-Dahl",
"4933962", "Heiligengrabe",
"497555", "Deggenhausertal",
"49571", "Minden\ Westfalen",
"499392", "Faulbach\ Unterfranken",
"4938326", "Grimmen",
"49971", "Bad\ Kissingen",
"499468", "Zell\ Oberpfalz",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"496202", "Schwetzingen",
"495506", "Adelebsen",
"495468", "Bramsche\-Engter",
"497624", "Grenzach\-Wyhlen",
"494874", "Todenbüttel",
"498306", "Ronsberg",
"495491", "Damme\ Dümmer",
"4933633", "Spreenhagen",
"498592", "Wegscheid\ Niederbayern",
"496348", "Offenbach\ an\ der\ Queich",
"499491", "Hemau",
"4935388", "Klöden",
"496404", "Lich\ Hessen",
"495368", "Parsau",
"4938324", "Velgast",
"492227", "Bornheim\-Merten",
"498458", "Gaimersheim",
"499492", "Parsberg",
"492393", "Sundern\-Allendorf",
"4935472", "Schlepzig",
"498591", "Obernzell",
"495492", "Steinfeld\ Oldenburg",
"496304", "Wolfstein\ Pfalz",
"499391", "Marktheidenfeld",
"4934633", "Braunsbedra",
"494606", "Wanderup",
"4933931", "Rheinsberg\ Mark",
"498406", "Böhmfeld",
"492238", "Pulheim",
"497709", "Wutach",
"495294", "Hövelhof\-Espeln",
"4934343", "Regis\-Breitingen",
"496201", "Weinheim\ Bergstr",
"499294", "Regnitzlosau",
"492428", "Niederzier",
"4936702", "Lauscha",
"498257", "Inchenhofen",
"496475", "Weilmünster\-Wolfenhausen",
"494166", "Ahlerstedt",
"498385", "Hergatz",
"497365", "Essingen\ Württemberg",
"493946", "Quedlinburg",
"494805", "Schafstedt",
"496787", "Niederbrombach",
"4934223", "Dommitzsch",
"496247", "Worms\-Pfeddersheim",
"495585", "Herzberg\-Sieber",
"497964", "Stödtlen",
"497631", "Müllheim\ Baden",
"4935603", "Burg\ Spreewald",
"497933", "Creglingen",
"4936649", "Gefell\ bei\ Schleiz",};
$areanames{de} = {"496663", "Steinau\ an\ der\ Straße",
"495064", "Groß\ Düngen",
"492339", "Sprockhövel\-Haßlinghausen",
"499242", "Gößweinstein",
"496364", "Nußbach\ Pfalz",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"499141", "Weißenburg\ in\ Bayern",
"492203", "Köln\-Porz",
"494509", "Groß\ Grönau",
"497355", "Hochdorf\ Riß",
"4934901", "Roßlau\ Elbe",
"497351", "Biberach\ an\ der\ Riß",
"4934493", "Gößnitz\ Thüringen",
"496252", "Heppenheim\ Bergstraße",
"499636", "Plößberg",
"4935726", "Groß\ Särchen",
"49221", "Köln",
"4939934", "Groß\ Plasten",
"4935240", "Tauscha\ bei\ Großenhain",
"495053", "Faßberg\-Müden",
"4934445", "Stößen",
"498807", "Dießen\ am\ Ammersee",
"4989", "München",
"498536", "Kößlarn",
"493647", "Pößneck",
"4935753", "Großräschen",
"495827", "Unterlüß",
"4935938", "Großpostwitz\ OL",
"494483", "Ovelgönne\-Großenmeer",
"494684", "Langeneß\ Hallig",
"4939976", "Groß\ Bützin",
"49911", "Nürnberg",
"4939883", "Groß\ Dölln",
"495384", "Seesen\-Groß\ Rhüden",
"4935952", "Großröhrsdorf\ OL",
"4938234", "Born\ Darß",
"4935841", "Großschönau\ Sachsen",
"499567", "Seßlach\-Gemünda",
"498367", "Roßhaupten\ Forggensee",
"496321", "Neustadt\ an\ der\ Weinstraße",
"497162", "Süßen",
"499656", "Moosbach\ bei\ Vohenstrauß",
"498170", "Straßlach\-Dingharting",
"4936949", "Obermaßfeld\-Grimmenthal",
"4935248", "Schönfeld\ bei\ Großenhain",
"498633", "Tüßling",
"4936072", "Weißenborn\-Lüderode",
"494497", "Barßel\-Harkebrügge",
"4936484", "Knau\ bei\ Pößneck",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;