use strict;
use warnings;
use Test::More 0.88;
# This is a relatively nice way to avoid Test::NoWarnings breaking our
# expectations by adding extra tests, without using no_plan.  It also helps
# avoid any other test module that feels introducing random tests, or even
# test plans, is a nice idea.
our $success = 0;
END { $success && done_testing; }

# List our own version used to generate this
my $v = "\nGenerated by Dist::Zilla::Plugin::ReportVersions::Tiny v1.10\n";

eval {                     # no excuses!
    # report our Perl details
    my $want = "any version";
    $v .= "perl: $] (wanted $want) on $^O from $^X\n\n";
};
defined($@) and diag("$@");

# Now, our module version dependencies:
sub pmver {
    my ($module, $wanted) = @_;
    $wanted = " (want $wanted)";
    my $pmver;
    eval "require $module;";
    if ($@) {
        if ($@ =~ m/Can't locate .* in \@INC/) {
            $pmver = 'module not found.';
        } else {
            diag("${module}: $@");
            $pmver = 'died during require.';
        }
    } else {
        my $version;
        eval { $version = $module->VERSION; };
        if ($@) {
            diag("${module}: $@");
            $pmver = 'died during VERSION check.';
        } elsif (defined $version) {
            $pmver = "$version";
        } else {
            $pmver = '<undef>';
        }
    }

    # So, we should be good, right?
    return sprintf('%-45s => %-10s%-15s%s', $module, $pmver, $wanted, "\n");
}

eval { $v .= pmver('Calendar::Simple','any version') };
eval { $v .= pmver('Color::Palette','0.100002') };
eval { $v .= pmver('Color::Palette::Schema','any version') };
eval { $v .= pmver('Config::MVP','2') };
eval { $v .= pmver('Config::MVP::Assembler','any version') };
eval { $v .= pmver('Config::MVP::Reader::INI','any version') };
eval { $v .= pmver('DateTime','any version') };
eval { $v .= pmver('DateTime::Format::W3CDTF','any version') };
eval { $v .= pmver('Digest::MD5','any version') };
eval { $v .= pmver('Email::Address','any version') };
eval { $v .= pmver('Email::Simple','any version') };
eval { $v .= pmver('ExtUtils::MakeMaker','6.30') };
eval { $v .= pmver('File::Basename','any version') };
eval { $v .= pmver('File::Copy','any version') };
eval { $v .= pmver('File::Path','2.07') };
eval { $v .= pmver('File::ShareDir','any version') };
eval { $v .= pmver('File::ShareDir::Install','0.03') };
eval { $v .= pmver('Getopt::Long::Descriptive','0.083') };
eval { $v .= pmver('Gravatar::URL','any version') };
eval { $v .= pmver('HTML::Mason::Interp','any version') };
eval { $v .= pmver('Moose','0.70') };
eval { $v .= pmver('Moose::Util::TypeConstraints','any version') };
eval { $v .= pmver('MooseX::StrictConstructor','any version') };
eval { $v .= pmver('Path::Class','any version') };
eval { $v .= pmver('Pod::Elemental','any version') };
eval { $v .= pmver('Pod::Elemental::Transformer::Codebox','any version') };
eval { $v .= pmver('Pod::Elemental::Transformer::List','any version') };
eval { $v .= pmver('Pod::Elemental::Transformer::PPIHTML','any version') };
eval { $v .= pmver('Pod::Elemental::Transformer::Pod5','any version') };
eval { $v .= pmver('Pod::Elemental::Transformer::SynMux','any version') };
eval { $v .= pmver('Pod::Elemental::Transformer::VimHTML','0.093581') };
eval { $v .= pmver('Pod::Simple::XHTML','3.13') };
eval { $v .= pmver('Test::More','0.96') };
eval { $v .= pmver('XML::Atom::SimpleFeed','any version') };
eval { $v .= pmver('autodie','any version') };
eval { $v .= pmver('lib','any version') };
eval { $v .= pmver('namespace::autoclean','any version') };
eval { $v .= pmver('strict','any version') };
eval { $v .= pmver('warnings','any version') };


# All done.
$v .= <<'EOT';

Thanks for using my code.  I hope it works for you.
If not, please try and include this output in the bug report.
That will help me reproduce the issue and solve your problem.

EOT

diag($v);
ok(1, "we really didn't test anything, just reporting data");
$success = 1;

# Work around another nasty module on CPAN. :/
no warnings 'once';
$Template::Test::NO_FLUSH = 1;
exit 0;
