package Sah::SchemaR::int_range;

our $DATE = '2021-07-17'; # DATE
our $VERSION = '0.003'; # VERSION

our $rschema = ["str",[{examples=>[{data=>"",summary=>"Empty string",valid=>0},{data=>1,valid=>1},{data=>-2,valid=>1},{data=>1.5,summary=>"Float",valid=>0},{data=>"1-1",valid=>1},{data=>"1-2",valid=>1},{data=>"1 - 2",valid=>1},{data=>"0-100",valid=>1},{data=>"-1-2",valid=>1},{data=>"-10--1",valid=>1},{data=>"1-",summary=>"Missing end value",valid=>0},{data=>"1-1.5",sumary=>"Float",valid=>0},{data=>"9-2",summary=>"start value cannot be larger than end value",valid=>0},{data=>"1-2-3",summary=>"Invalid simple int range syntax",valid=>0},{data=>" 1-2 ",summary=>"Leading and trailing whitespace is currently not allowed",valid=>0},{data=>"1,2",valid=>1},{data=>"1 , 2",valid=>1},{data=>"1,2,-3,4",valid=>1},{data=>"1,2,-3,4.5",summary=>"Float",valid=>0},{data=>"1,",summary=>"Dangling comma is currently not allowed",valid=>0},{data=>"1,,2",summary=>"Multiple commas are currently not allowed",valid=>0},{data=>"1,2-5",valid=>1},{data=>"-1,-2-5,7,9-9",valid=>1},{data=>"1,9-2",summary=>"start value cannot be larger than end value",valid=>0}],match=>qr(\A
                (?:(?:-?[0-9]+)(?:\s*-\s*(?:-?[0-9]+))?)
                (
                    \s*,\s*
                    (?:(?:-?[0-9]+)(?:\s*-\s*(?:-?[0-9]+))?)
                )*\z)x,prefilters=>["IntRange::check_int_range"],summary=>"Integer range (sequence of ints/simple ranges), e.g. 1 / -5-7 / 1,10 / 1,5-7,10"}],["str"]];

1;
# ABSTRACT: Integer range (sequence of ints/simple ranges), e.g. 1 / -5-7 / 1,10 / 1,5-7,10

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::int_range - Integer range (sequence of ints/simple ranges), e.g. 1 / -5-7 / 1,10 / 1,5-7,10

=head1 VERSION

This document describes version 0.003 of Sah::SchemaR::int_range (from Perl distribution Sah-Schemas-IntRange), released on 2021-07-17.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-IntRange>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-IntRange>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-IntRange>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
