# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::AT;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20201204215954;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              11|
              [2-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '517',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '5[079]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,5})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '1',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              31|
              4
            )6|
            51|
            6(?:
              5[0-3579]|
              [6-9]
            )|
            7(?:
              20|
              32|
              8
            )|
            [89]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [2-467]|
            5[2-6]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3,9})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'geographic' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'mobile' => '
          6(?:
            5[0-3579]|
            6[013-9]|
            [7-9]\\d
          )\\d{4,10}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          8(?:
            10|
            2[018]
          )\\d{6,10}|
          828\\d{5}
        )|(
          9(?:
            0[01]|
            3[019]
          )\\d{6,10}
        )',
                'toll_free' => '800\\d{6,10}',
                'voip' => '
          5(?:
            0[1-9]|
            17|
            [79]\\d
          )\\d{2,10}|
          7[28]0\\d{6,10}
        '
              };
my %areanames = ();
$areanames{de} = {"432815", "Großschönau",
"435678", "Weißenbach\ am\ Lech",
"436215", "Straßwalchen",
"437224", "Sankt\ Florian",
"432857", "Bad\ Großpertholz",
"433834", "Wald\ am\ Schoberpaß",
"437565", "Sankt\ Pankraz",
"432823", "Großglobnitz",
"432686", "Draßburg",
"437477", "Sankt\ Peter\ in\ der\ Au",
"432987", "Sankt\ Leonhard\ am\ Hornerwald",
"434876", "Kals\ am\ Großglockner",
"432955", "Großweikersdorf",
"433178", "Sankt\ Ruprecht\ an\ der\ Raab",
"432768", "Sankt\ Aegyd\ am\ Neuwalde",
"432268", "Großmugl",
"437566", "Rosenau\ am\ Hengstpaß",
"437219", "Vorderweißenbach",
"432618", "Markt\ Sankt\ Martin",
"434843", "Außervillgraten",
"435245", "Hinterriß",
"437218", "Großtraberg",
"432647", "Krumbach\,\ Niederösterreich",
"436414", "Großarl",
"436565", "Neukirchen\ am\ Großvenediger",
"432812", "Groß\ Gerungs",
"436477", "Sankt\ Michael\ im\ Lungau",
"437954", "Sankt\ Georgen\ am\ Walde",
"4319", "Wien",
"432847", "Groß\-Siegharts",
"434879", "Sankt\ Veit\ in\ Defereggen",
"436247", "Großgmain",
"432715", "Weißenkirchen\ in\ der\ Wachau",
"437945", "Sankt\ Oswald\ bei\ Freistadt",
"435352", "Sankt\ Johann\ in\ Tirol",
"436277", "Sankt\ Pantaleon",
"436412", "Sankt\ Johann\ im\ Pongau",
"432822", "Zwettl\-Niederösterreich",
"433843", "Sankt\ Michael\ in\ Obersteiermark",
"432629", "Warth\,\ Niederösterreich",
"433327", "Sankt\ Michael\ im\ Burgenland",
"433158", "Sankt\ Anna\ am\ Aigen",
"435446", "Sankt\ Anton\ am\ Arlberg",
"437956", "Unterweißenbach",
"434873", "Sankt\ Jakob\ in\ Defereggen",
"433536", "Sankt\ Peter\ am\ Kammersberg",
"437751", "Sankt\ Martin\ im\ Innkreis",
"433575", "Sankt\ Johann\ am\ Tauern",
"435279", "Sankt\ Jodok\ am\ Brenner",
"434239", "Sankt\ Kanzian\ am\ Klopeiner\ See",
"434253", "Sankt\ Jakob\ im\ Rosental",
"433632", "Sankt\ Gallen",
"432763", "Sankt\ Veit\ an\ der\ Gölsen",
"432263", "Großrußbach",
"436241", "Sankt\ Koloman",
"437237", "Sankt\ Georgen\ an\ der\ Gusen",
"435449", "Fließ",
"432719", "Droß",
"434358", "Sankt\ Andrä",
"433477", "Sankt\ Peter\ am\ Ottersbach",
"434357", "Sankt\ Paul\ im\ Lavanttal",
"433537", "Sankt\ Georgen\ ob\ Murau",
"432233", "Preßbaum",
"433869", "Sankt\ Katharein\ an\ der\ Laming",
"434226", "Sankt\ Margareten\ im\ Rosental",
"432680", "Sankt\ Margarethen\ im\ Burgenland",
"433119", "Sankt\ Marein\ bei\ Graz",
"436227", "Sankt\ Gilgen",
"435557", "Sankt\ Gallenkirch",
"4312", "Wien",
"4317", "Wien",
"434783", "Reißeck",
"434283", "Sankt\ Stefan\ im\ Gailtal",
"437254", "Großraming",
"433468", "Sankt\ Oswald\ ob\ Eibiswald",
"432742", "Sankt\ Pölten",
"432242", "Sankt\ Andrä\-Wördern",
"436276", "Nußdorf\ am\ Haunsberg",
"433123", "Sankt\ Oswald\ bei\ Plankenwarth",
"436546", "Fusch\ an\ der\ Großglocknerstraße",
"432756", "Sankt\ Leonhard\ am\ Forst",
"433469", "Sankt\ Oswald\ im\ Freiland",
"437232", "Sankt\ Martin\ im\ Mühlkreis",
"436138", "Sankt\ Wolfgang\ im\ Salzkammergut",
"433362", "Großpetersdorf",
"433868", "Tragöß",
"432249", "Groß\-Enzersdorf",
"436545", "Bruck\ an\ der\ Großglocknerstraße",
"433684", "Sankt\ Martin\ am\ Grimming",
"434266", "Straßburg",
"433183", "Sankt\ Georgen\ an\ der\ Stiefing",
"433331", "Sankt\ Lorenzen\ am\ Wechsel",
"4316", "Wien",
"433386", "Großsteinbach",
"433689", "Sankt\ Nikolai\ im\ Sölktal",
"436476", "Sankt\ Margarethen\ im\ Lungau",
"432556", "Großkrut",
"437667", "Sankt\ Georgen\ im\ Attergau",
"433464", "Groß\ Sankt\ Florian",
"433515", "Sankt\ Lorenzen\ bei\ Knittelfeld",
"437717", "Sankt\ Aegidi",
"437217", "Sankt\ Veit\ im\ Mühlkreis",
"434212", "Sankt\ Veit\ an\ der\ Glan",
"4318", "Wien",
"434825", "Großkirchheim",
"433585", "Sankt\ Lambrecht",
"432617", "Draßmarkt",
"435413", "Sankt\ Leonhard\ im\ Pitztal",
"4315", "Wien",
"4313", "Wien",
"434264", "Klein\ Sankt\ Paul",
"432674", "Weißenbach\ an\ der\ Triesting",
"436242", "Rußbach\ am\ Paß\ Gschütt",
"433140", "Sankt\ Martin\ am\ Wöllmißberg",
"437435", "Sankt\ Valentin",
"434286", "Weißbriach",
"432642", "Aspangberg\-Sankt\ Peter",
"434877", "Prägraten\ am\ Großvenediger",
"4314", "Wien",
"433864", "Sankt\ Marein\ im\ Mürztal",
"434350", "Bad\ Sankt\ Leonhard\ im\ Lavanttal",
"434785", "Außerfragant",};
$areanames{en} = {"435224", "Wattens",
"432848", "Pfaffenschlag\ bei\ Waidhofen",
"435230", "Sellrain",
"437742", "Mattighofen",
"432912", "Geras",
"437242", "Wels",
"437479", "Ardagger",
"433183", "St\.\ Georgen\ an\ der\ Stiefing",
"433364", "Hannersdorf",
"436133", "Ebensee",
"432621", "Sieggraben",
"435414", "Wenns",
"437734", "Hofkirchen\ an\ der\ Trattnach",
"437234", "Ottensheim",
"437432", "Strengberg",
"432555", "Herrnbaumgarten",
"432673", "Altenmarkt\ an\ der\ Triesting",
"437444", "Opponitz",
"436233", "Oberwang",
"435212", "Seefeld\ in\ Tirol",
"435477", "Tösens",
"433619", "Oppenberg",
"433125", "Übelbach",
"432859", "Brand\-Nagelberg",
"434263", "Hüttenberg",
"433516", "Kleinlobming",
"437353", "Gaflenz",
"437675", "Ampflwang\ im\ Hausruckwald",
"435337", "Brixlegg",
"437256", "Ternberg",
"432279", "Kirchberg\ am\ Wagram",
"432144", "Deutsch\ Jahrndorf",
"434826", "Mörtschach",
"433457", "Gleinstätten",
"436476", "St\.\ Margarethen\ im\ Lungau",
"435282", "Zell\ am\ Ziller",
"433689", "St\.\ Nikolai\ im\ Sölktal",
"436245", "Hallein",
"433586", "Mühlen",
"432574", "Gaweinstal",
"433882", "Mariazell",
"433386", "Grosssteinbach",
"436467", "Mühlbach\ am\ Hochkönig",
"437480", "Langau\,\ Gaming",
"434247", "Afritz",
"432982", "Horn",
"432646", "Kirchschlag\ in\ der\ Buckligen\ Welt",
"432732", "Krems\ an\ der\ Donau",
"437261", "Schönau\ im\ Mühlkreis",
"433113", "Pischelsdorf\ in\ der\ Steiermark",
"432232", "Fischamend",
"432845", "Weikertschlag\ an\ der\ Thaya",
"432744", "Kasten\ bei\ Böheimkirchen",
"4316", "Vienna",
"432244", "Langenzersdorf",
"433331", "St\.\ Lorenzen\ am\ Wechsel",
"435577", "Lustenau",
"433624", "Pichl\-Kainisch",
"432648", "Hochneukirchen",
"437472", "Amstetten",
"434782", "Obervellach",
"437249", "Bad\ Schallerbach",
"437217", "St\.\ Veit\ im\ Mühlkreis",
"435522", "Feldkirch",
"434282", "Hermagor",
"432947", "Theras",
"437717", "St\.\ Aegidi",
"432633", "Markt\ Piesting",
"437258", "Bad\ Hall",
"436221", "Koppl",
"433612", "Liezen",
"437758", "Obernberg\ am\ Inn",
"433515", "St\.\ Lorenzen\ bei\ Knittelfeld",
"437274", "Alkoven",
"436478", "Zederhaus",
"437676", "Ottnang\ am\ Hausruck",
"436454", "Mandling",
"432556", "Grosskrut",
"435514", "Bezau",
"433847", "Trofaiach",
"433588", "Katsch\ an\ der\ Mur",
"436543", "Taxenbach",
"433464", "Gross\ St\.\ Florian",
"437667", "St\.\ Georgen\ im\ Attergau",
"432873", "Kottes",
"433126", "Frohnleiten",
"432852", "Gmünd",
"433682", "Stainach",
"435289", "Häusling",
"433585", "St\.\ Lambrecht",
"436246", "Grödig",
"432772", "Neulengbach",
"432753", "Gansbach",
"432272", "Tulln\ an\ der\ Donau",
"433571", "Möderbrugg",
"433385", "Ilz",
"432253", "Oberwaltersdorf",
"434224", "Pischeldorf",
"437255", "Losenstein",
"434825", "Grosskirchheim",
"437755", "Mettmach",
"433141", "Hirschegg",
"436475", "Ramingstein",
"434230", "Globasnitz",
"432645", "Wiesmath",
"4318", "Vienna",
"435263", "Silz",
"433357", "Pinkafeld",
"433150", "Paldau",
"432846", "Raabs\ an\ der\ Thaya",
"432534", "Niedersulz",
"432172", "Frauenkirchen",
"433863", "Turnau",
"433323", "Eberau",
"432239", "Breitenfurt\ bei\ Wien",
"434712", "Greifenburg",
"437287", "Peilstein\ im\ Mühlviertel",
"432739", "Tiefenfucha",
"434212", "St\.\ Veit\ an\ der\ Glan",
"432989", "Brunn\ an\ der\ Wild",
"437259", "Sierning",
"436234", "Zell\ am\ Moos",
"432276", "Reidling",
"437443", "Ybbsitz",
"437759", "Antiesenhofen",
"432957", "Hohenwarth",
"433885", "Greith",
"435550", "Thüringen",
"436242", "Russbach\ am\ Pass\ Gschütt",
"436479", "Muhr",
"433686", "Haus",
"432674", "Weissenbach\ an\ der\ Triesting",
"432767", "Hohenberg",
"432267", "Sierndorf",
"435285", "Mayrhofen",
"434264", "Klein\ St\.\ Paul",
"4315", "Vienna",
"432842", "Waidhofen\ an\ der\ Thaya",
"432167", "Neusiedl\ am\ See",
"4313", "Vienna",
"432235", "Maria\-Lanzendorf",
"432985", "Gars\ am\ Kamp",
"433857", "Neuberg\ an\ der\ Mürz",
"433631", "Unterlaussa",
"435223", "Hall\ in\ Tirol",
"432735", "Hadersdorf\ am\ Kamp",
"437733", "Neumarkt\ im\ Hausruckkreis",
"432649", "Mönichkirchen",
"432617", "Drassmarkt",
"434716", "Lesachtal",
"437233", "Feldkirchen\ an\ der\ Donau",
"437248", "Grieskirchen",
"436432", "Bad\ Hofgastein",
"435413", "St\.\ Leonhard\ im\ Pitztal",
"436134", "Hallstatt",
"433184", "Wolfsberg\ im\ Schwarzautal",
"433363", "Rechnitz",
"432176", "Tadten",
"437748", "Eggelsberg",
"433151", "Gnas",
"437245", "Lambach",
"437745", "Lochen",
"432915", "Drosendorf\-Zissersdorf",
"435526", "Laterns",
"434286", "Weissbriach",
"432743", "Böheimkirchen",
"432687", "Siegendorf",
"432243", "Klosterneuburg",
"437476", "Aschbach\-Markt",
"432238", "Kaltenleutgeben",
"432738", "Fels\ am\ Wagram",
"433114", "Markt\ Hartmannsdorf",
"432988", "Neupölla",
"433177", "Puch\ bei\ Weiz",
"437672", "Vöcklabruck",
"435288", "Fügen",
"432143", "Kittsee",
"433616", "Selzthal",
"432856", "Weitra",
"433140", "St\.\ Martin\ am\ Wöllmissberg",
"434231", "Mittertrixen",
"437435", "St\.\ Valentin",
"432573", "Wilfersdorf",
"432552", "Poysdorf",
"436453", "Filzmoos",
"4314", "Vienna",
"435286", "Ginzling",
"436472", "Mauterndorf",
"436217", "Mattsee",
"434822", "Winklern",
"437752", "Ried\ im\ Innkreis",
"433618", "Hohentauern",
"437273", "Aschach\ an\ der\ Donau",
"437252", "Steyr",
"432858", "Moorbad\ Harbach",
"432275", "Atzenbrugg",
"433463", "Stainz",
"436544", "Rauris",
"433382", "Fürstenfeld",
"435441", "See",
"433886", "Weichselboden",
"432874", "Martinsberg",
"434877", "Prägraten\ am\ Grossvenediger",
"433582", "Scheifling",
"435513", "Hittisau",
"433685", "Gröbming",
"434215", "Liebenfels",
"433623", "Bad\ Mitterndorf",
"434715", "Kötschach\-Mauthen",
"432849", "Schwarzenau",
"432175", "Apetlon",
"432634", "Gutenstein",
"437478", "Oed\-Oehling",
"432236", "Mödling",
"436274", "Lamprechtshausen",
"432736", "Paudorf",
"432642", "Aspangberg\-St\.\ Peter",
"437221", "Hörsching",
"432986", "Irnfritz",
"432620", "Willendorf",
"435525", "Nenzing",
"434285", "Tröpolach",
"432533", "Neusiedl\ an\ der\ Zaya",
"437475", "Hausmening\,\ Neuhofen\ an\ der\ Ybbs",
"434785", "Ausserfragant",
"434271", "Steuerberg",
"435264", "Mieming",
"435677", "Vils",
"434718", "Dellach",
"434350", "Bad\ St\.\ Leonhard\ im\ Lavanttal",
"433137", "Söding",
"437246", "Gunskirchen",
"433324", "Strem",
"437260", "Waldhausen",
"432916", "Riegersburg\,\ Hardegg",
"433864", "St\.\ Marein\ im\ Mürztal",
"437746", "Friedburg",
"432754", "Loosdorf",
"432278", "Absdorf",
"432855", "Waldenstein",
"432254", "Ebreichsdorf",
"434257", "Fürnitz",
"433688", "Tauplitz",
"433512", "Knittelfeld",
"435583", "Lech",
"434223", "Maria\ Saal",
"432711", "Dürnstein",
"433615", "Trieben",
"437941", "Neumarkt\ im\ Mühlkreis",
"433112", "Gleisdorf",
"432233", "Pressbaum",
"437617", "Traunkirchen",
"432733", "Schönberg\ am\ Kamp",
"435225", "Fulpmes",
"432983", "Sigmundsherberg",
"432748", "Kilb",
"436461", "Dienten\ am\ Hochkönig",
"432248", "Markgrafneusiedl",
"433869", "St\.\ Katharein\ an\ der\ Laming",
"433329", "Jennersdorf",
"433365", "Deutsch\ Schützen\-Eisenberg",
"437735", "Gaspoltshofen",
"437235", "Gallneukirchen",
"433537", "St\.\ Georgen\ ob\ Murau",
"432554", "Stützenhofen",
"437267", "Mönchdorf",
"435516", "Doren",
"434357", "St\.\ Paul\ im\ Lavanttal",
"437767", "Eggerding",
"437445", "Hollenstein\ an\ der\ Ybbs",
"433337", "Vorau",
"433466", "Eibiswald",
"433883", "Terz",
"433124", "Gratkorn",
"437276", "Peuerbach",
"432259", "Münchendorf",
"437674", "Attnang\-Puchheim",
"43662", "Salzburg",
"435283", "Kaltenbach",
"436456", "Obertauern",
"433477", "St\.\ Peter\ am\ Ottersbach",
"436549", "Piesendorf",
"432627", "Pitten",
"434226", "St\.\ Margareten\ im\ Rosental",
"432145", "Prellenkirchen",
"434762", "Spittal\ an\ der\ Drau",
"434262", "Treibach",
"432672", "Berndorf",
"436244", "Golling\ an\ der\ Salzach",
"432575", "Ladendorf",
"437433", "Wallsee",
"437448", "Kematen\ an\ der\ Ybbs",
"435213", "Scharnitz",
"436232", "Mondsee",
"433182", "Wildon",
"436132", "Bad\ Ischl",
"436434", "Bad\ Gastein",
"437243", "Marchtrenk",
"435418", "Schönwies",
"432639", "Bad\ Fischau",
"437743", "Maria\ Schmolln",
"432913", "Hötzelsdorf",
"435331", "Brandenberg",
"437238", "Mauthausen",
"43732", "Linz",
"434847", "Obertilliach",
"432844", "Karlstein\ an\ der\ Thaya",
"432745", "Pyhra",
"432536", "Drösing",
"432245", "Wolkersdorf\ im\ Weinviertel",
"433322", "Güssing",
"433862", "Bruck\ an\ der\ Mur",
"433366", "Kohfidisch",
"432173", "Gols",
"434213", "Launsdorf",
"437736", "Pram",
"434713", "Techendorf",
"437236", "Pregarten",
"433147", "Salla",
"433119", "St\.\ Marein\ bei\ Graz",
"435262", "Telfs",
"435226", "Neustift\ im\ Stubaital",
"433577", "Zeltweg",
"433170", "Fischbach",
"432538", "Velm\-Götzendorf",
"434228", "Feistritz\ im\ Rosental",
"433514", "Seckau",
"437281", "Aigen\ im\ Mühlkreis",
"432680", "St\.\ Margarethen\ im\ Burgenland",
"436455", "Untertauern",
"435515", "Au",
"433683", "Donnersbach",
"433465", "Pölfing\-Brunn",
"432252", "Baden",
"432273", "Tulbing",
"432752", "Melk",
"432773", "Eichgraben",
"435518", "Mellau",
"432576", "Ernstbrunn",
"433584", "Neumarkt\ in\ Steiermark",
"434269", "Flattnitz",
"437711", "Suben",
"432853", "Schrems",
"432872", "Ottenschlag",
"433468", "St\.\ Oswald\ ob\ Eibiswald",
"434769", "Möllbrücke",
"432610", "Horitschon",
"437211", "Reichenau\ im\ Mühlkreis",
"436542", "Zell\ am\ See",
"432146", "Nickelsdorf",
"435585", "Dalaas",
"434225", "Grafenstein",
"437254", "Grossraming",
"433613", "Admont",
"437278", "Neukirchen\ am\ Walde",
"437754", "Waldzell",
"432160", "Jois",
"434824", "Heiligenblut",
"432827", "Schönbach",
"436474", "Tamsweg",
"436458", "Hüttau",
"432644", "Grimmenstein",
"4317", "Vienna",
"4312", "Vienna",
"436272", "Oberndorf\ bei\ Salzburg",
"436417", "Hüttschlag",
"435523", "Götzis",
"434283", "St\.\ Stefan\ im\ Gailtal",
"432746", "Wilhelmsburg",
"432632", "Pernitz",
"432246", "Gerasdorf\ bei\ Wien",
"437473", "Blindenmarkt",
"434783", "Reisseck",
"432535", "Hohenau\ an\ der\ March",
"435357", "Kirchberg\ in\ Tirol",
"436227", "St\.\ Gilgen",
"435557", "St\.\ Gallenkirch",
"436546", "Fusch\ an\ der\ Grossglocknerstrasse",
"436235", "Thalgau",
"434229", "Krumpendorf\ am\ Wörther\ See",
"437280", "Schwarzenberg\ am\ Böhmerwald",
"432876", "Els",
"433123", "St\.\ Oswald\ bei\ Plankenwarth",
"433884", "Wegscheid",
"432572", "Mistelbach",
"437673", "Schwanenstadt",
"433157", "Kapfenstein",
"435284", "Gerlos",
"432527", "Wulzeshofen",
"434265", "Weitensfeld\ im\ Gurktal",
"437355", "Weyer",
"432142", "Gattendorf",
"432242", "St\.\ Andrä\-Wördern",
"434237", "Miklauzhof",
"432636", "Puchberg\ am\ Schneeberg",
"432742", "St\.\ Pölten",
"436276", "Nussdorf\ am\ Haunsberg",
"432234", "Gramatneusiedl",
"432984", "Eggenburg",
"432734", "Langenlois",
"433118", "Sinabelkirchen",
"433171", "Gasen",
"433185", "Preding",
"437587", "Wartberg\ an\ der\ Krems",
"436135", "Bad\ Goisern",
"437232", "St\.\ Martin\ im\ Mühlkreis",
"437732", "Haag\ am\ Hausruck",
"437244", "Sattledt",
"435412", "Imst",
"436433", "Dorfgastein",
"433362", "Grosspetersdorf",
"433866", "Breitenau\ am\ Hochlantsch",
"432914", "Japons",
"437744", "Munderfing",
"433326", "Stegersbach",
"436138", "St\.\ Wolfgang\ im\ Salzkammergut",
"432843", "Dobersberg",
"432951", "Guntersdorf",
"433115", "Studenzen",
"435266", "Ötztal\-Bahnhof",
"435519", "Schröcken",
"432611", "Mannersdorf\ an\ der\ Rabnitz",
"434268", "Friesach",
"433469", "St\.\ Oswald\ im\ Freiland",
"434768", "Kleblach\-Lind",
"432756", "St\.\ Leonhard\ am\ Forst",
"437442", "Waidhofen\ an\ der\ Ybbs",
"437279", "Haibach\ ob\ der\ Donau",
"432256", "Leobersdorf",
"435214", "Leutasch",
"433637", "Gams\ bei\ Hieflau",
"437434", "Haag",
"436243", "Abtenau",
"434266", "Strassburg",
"432667", "Schwarzau\ im\ Gebirge",
"433513", "Bischoffeld",
"434766", "Millstatt",
"435582", "Klösterle",
"434240", "Bad\ Kleinkirchheim",
"432274", "Sieghartskirchen",
"432758", "Pöggstall",
"436545", "Bruck\ an\ der\ Grossglocknerstrasse",
"432774", "Innermanzing",
"432875", "Grafenschlag",
"432258", "Alland",
"437487", "Gresten",
"433684", "St\.\ Martin\ am\ Grimming",
"434277", "Glanegg",
"434214", "Brückl",
"434714", "Dellach\ im\ Drautal",
"432749", "Prinzersdorf",
"432717", "Unter\-Meisling",
"437947", "Kefermarkt",
"432249", "Gross\-Enzersdorf",
"433868", "Tragöss",
"432174", "Wallern\ im\ Burgenland",
"433328", "Kukmirn",
"436136", "Gosau",
"432532", "Zistersdorf",
"432635", "Neunkirchen",
"434284", "Kirchbach",
"435524", "Satteins",
"435447", "Flirsch",
"432638", "Winzendorf\-Muthmannsdorf",
"434784", "Mallnitz",
"437474", "Euratsfeld",
"436278", "Ostermiething",
"432643", "Lichtenegg",
"432287", "Strasshof\ an\ der\ Nordbahn",
"437239", "Lichtenberg",
"433116", "Kirchbach\ in\ Steiermark",
"435265", "Nassereith",
"433622", "Bad\ Aussee",
"433325", "Heiligenkreuz\ im\ Lafnitztal",
"433865", "Kindberg",
"432755", "Mank",
"436548", "Niedernsill",
"432854", "Kirchberg\ am\ Walde",
"432255", "Deutsch\ Brodersdorf",
"433462", "Deutschlandsberg",
"433383", "Burgau",
"432878", "Traunstein",
"437227", "Neuhofen\ an\ der\ Krems",
"433583", "Unzmarkt",
"437727", "Ach",
"435512", "Egg",
"436473", "Mariapfarr",
"436452", "Radstadt",
"437253", "Wolfern",
"437272", "Eferding",
"434823", "Tresdorf\,\ Rangersdorf",
"437753", "Eberschwang",
"433614", "Rottenmann",
"434858", "Nikolsdorf",
"434275", "Ebene\ Reichenau",
"437728", "Schwand\ im\ Innkreis",
"433843", "St\.\ Michael\ in\ Obersteiermark",
"437228", "Kematen\ an\ der\ Krems",
"437485", "Gaming",
"434874", "Virgen",
"437663", "Steinbach\ am\ Attersee",
"432877", "Grainbrunn",
"432629", "Warth\,\ Lower\ Austria",
"436547", "Kaprun",
"437471", "Neustadtl\ an\ der\ Donau",
"435243", "Maurach",
"432665", "Prein\ an\ der\ Rax",
"432526", "Stronsdorf",
"436214", "Henndorf\ am\ Wallersee",
"432822", "Zwettl\,\ Lower\ Austria",
"435238", "Zirl",
"432288", "Auersthal",
"436277", "St\.\ Pantaleon",
"436412", "St\.\ Johann\ im\ Pongau",
"434236", "Eberndorf",
"435448", "Pettneu\ am\ Arlberg",
"432943", "Obritz",
"43316", "Graz",
"437713", "Schardenberg",
"432637", "Grünbach\ am\ Schneeberg",
"434736", "Innerkrems",
"437213", "Bad\ Leonfelden",
"435373", "Ebbs",
"437586", "Pettenbach",
"432215", "Probstdorf",
"435352", "St\.\ Johann\ in\ Tirol",
"432814", "Langschlag",
"436240", "Krispl",
"432715", "Weissenkirchen\ in\ der\ Wachau",
"437945", "St\.\ Oswald\ bei\ Freistadt",
"433611", "Johnsbach",
"435573", "Hörbranz",
"435552", "Bludenz",
"433867", "Pernegg\ an\ der\ Mur",
"433327", "St\.\ Michael\ im\ Burgenland",
"437948", "Hirschbach\ im\ Mühlkreis",
"433134", "Heiligenkreuz\ am\ Waasen",
"432718", "Lichtenau\ im\ Waldviertel",
"435276", "Gschnitz",
"437619", "Kirchham",
"435674", "Bichlbach",
"436563", "Uttendorf",
"433142", "Voitsberg",
"437283", "Sarleinsbach",
"432285", "Marchegg",
"433353", "Oberschützen",
"432271", "Ried\ am\ Riederberg",
"433572", "Judenburg",
"435445", "Kappl",
"433339", "Friedberg",
"437415", "Altenmarkt\,\ Yspertal",
"434359", "Reichenfels",
"436589", "Unken",
"432723", "Rabenstein\ an\ der\ Pielach",
"437269", "Baumgartenberg",
"434278", "Gnesau",
"434855", "Assling",
"434254", "Faak\ am\ See",
"433636", "Wildalpen",
"437225", "Hargelsberg",
"437488", "Steinakirchen\ am\ Forst",
"437564", "Hinterstoder",
"432257", "Klausen\-Leopoldsdorf",
"432757", "Pöchlarn",
"437241", "Steinerkirchen\ an\ der\ Traun",
"434767", "Rothenthurn",
"437357", "Kleinreifling",
"432622", "Wiener\ Neustadt",
"434267", "Metnitz",
"432525", "Gnadendorf",
"432666", "Reichenau",
"432264", "Rückersdorf\,\ Harmannsdorf",
"435333", "Söll",
"433155", "Fehring",
"432865", "Litschau",
"432764", "Hainfeld",
"434276", "Feldkirchen\ in\ Kärnten",
"432829", "Schweiggers",
"433638", "Palfau",
"437486", "Lunz\ am\ See",
"432954", "Göllersdorf",
"435473", "Nauders",
"435254", "Sölden",
"432216", "Leopoldsdorf\ im\ Marchfelde",
"437585", "Klaus\ an\ der\ Pyhrnbahn",
"436137", "Strobl",
"437946", "Gutau",
"432716", "Gföhl",
"435278", "Navis",
"437682", "Vöcklamarkt",
"432614", "Kleinwarasdorf",
"433854", "Langenwang",
"437250", "Maria\ Neustift",
"434842", "Sillian",
"435559", "Brand",
"437750", "Andrichsfurt",
"432164", "Rohrau",
"436229", "Hof\ bei\ Salzburg",
"436470", "Atzmannsdorf",
"434235", "Bleiburg",
"435359", "Hochfilzen",
"434735", "Kremsbrücke",
"432286", "Obersiebenbrunn",
"433149", "Geistthal",
"433117", "Eggersdorf\ bei\ Graz",
"434243", "Bodensdorf",
"432786", "Oberwölbling",
"437612", "Gmunden",
"435446", "St\.\ Anton\ am\ Arlberg",
"434238", "Eisenkappel\-Vellach",
"432684", "Schützen\ am\ Gebirge",
"437588", "Ried\ im\ Traunkreis",
"435275", "Trins",
"433579", "Pöls",
"437262", "Perg",
"436582", "Saalfelden\ am\ Steinernen\ Meer",
"432231", "Purkersdorf",
"433532", "Murau",
"437762", "Raab",
"437226", "Wilhering",
"433635", "Radmer",
"434352", "Wolfsberg",
"432731", "Idolsberg",
"436463", "Annaberg\-Lungötz",
"433332", "Hartberg",
"435634", "Elbigenalp",
"437952", "Weitersfelden",
"437416", "Wieselburg",
"433158", "St\.\ Anna\ am\ Aigen",
"435236", "Gries\ im\ Sellrain",
"433453", "Ehrenhausen",
"433472", "Mureck",
"433174", "Birkfeld",
"437714", "Esternberg",
"432944", "Haugsdorf",
"437214", "Reichenthal",
"433575", "St\.\ Johann\ am\ Tauern",
"435279", "St\.\ Jodok\ am\ Brenner",
"435442", "Landeck",
"437616", "Grünau\ im\ Almtal",
"432782", "Herzogenburg",
"436418", "Kleinarl",
"433581", "Oberwölz",
"432282", "Gänserndorf",
"433145", "Edelschrott",
"436471", "Tweng",
"435574", "Bregenz",
"435558", "Gaschurn",
"436228", "Faistenau",
"437251", "Schiedlberg",
"435374", "Walchsee",
"435358", "Ellmau",
"437751", "St\.\ Martin\ im\ Innkreis",
"432813", "Arbesbach",
"433832", "Kraubath\ an\ der\ Mur",
"437664", "Weyregg\ am\ Attersee",
"433336", "Waldbach",
"433467", "Schwanberg",
"434356", "Lavamünd",
"437240", "Sipbachzell",
"432641", "Kirchberg\ am\ Wechsel",
"433844", "Kammern\ im\ Liesingtal",
"437766", "Andorf",
"434873", "St\.\ Jakob\ in\ Defereggen",
"433536", "St\.\ Peter\ am\ Kammersberg",
"437722", "Braunau\ am\ Inn",
"437266", "Bad\ Kreuzen",
"434852", "Lienz",
"435517", "Riezlern",
"436457", "Flachau",
"433476", "Bad\ Radkersburg",
"436213", "Oberhofen\ am\ Irrsee",
"435232", "Kematen\ in\ Tirol",
"432828", "Rappottenstein",
"437277", "Waizenkirchen",
"437412", "Ybbs\ an\ der\ Donau",
"435244", "Jenbach",
"437956", "Unterweissenbach",
"432724", "Schwarzenbach\ an\ der\ Pielach",
"432825", "Göpfritz\ an\ der\ Wild",
"432662", "Gloggnitz",
"432230", "Schwadorf",
"432626", "Mattersburg",
"434227", "Ferlach",
"437563", "Spital\ am\ Pyhrn",
"433159", "Bad\ Gleichenberg",
"437482", "Scheibbs",
"434272", "Pörtschach\ am\ Wörther\ See",
"434253", "St\.\ Jakob\ im\ Rosental",
"435673", "Ehrwald",
"433148", "Kainach\ bei\ Voitsberg",
"437284", "Oberkappel",
"436564", "Krimml",
"434239", "St\.\ Kanzian\ am\ Klopeiner\ See",
"432712", "Aggsbach",
"436225", "Eugendorf",
"437942", "Freistadt",
"432212", "Orth\ an\ der\ Donau",
"433133", "Nestelbach",
"435355", "Jochberg",
"433578", "Obdach",
"435280", "Hochfügen",
"436415", "Schwarzach\ im\ Pongau",
"433354", "Bernstein",
"434846", "Abfaltersbach",
"432289", "Matzen",
"437237", "St\.\ Georgen\ an\ der\ Gusen",
"433146", "Modriach",
"432613", "Deutschkreutz",
"435417", "Roppen",
"435449", "Fliess",
"435272", "Steinach\ am\ Brenner",
"435253", "Längenfeld",
"433576", "Bretstein",
"433853", "Spital\ am\ Semmering",
"437615", "Scharnstein",
"434848", "Kartitsch",
"432163", "Petronell\-Carnuntum",
"436241", "St\.\ Koloman",
"435334", "Westendorf",
"437729", "Neukirchen\ an\ der\ Enknach",
"432263", "Grossrussbach",
"433475", "Hürth",
"437229", "Traun",
"432763", "St\.\ Veit\ an\ der\ Gölsen",
"437955", "Königswiesen",
"432628", "Felixdorf",
"432841", "Vitis",
"432953", "Nappersdorf",
"435474", "Pfunds",
"433335", "Pöllau",
"437765", "Lambrechten",
"433632", "St\.\ Gallen",
"434355", "Gemmersdorf",
"437265", "Pabneukirchen",
"435239", "Kühtai",
"433535", "Krakaudorf",
"433338", "Lafnitz",
"434710", "Oberdrauburg",
"432577", "Asparn\ an\ der\ Zaya",
"434358", "St\.\ Andrä",
"436588", "Lofer",
"437268", "Grein",
"432862", "Heidenreichstein",
"434279", "Sirnitz",
"432826", "Rastenfeld",
"433173", "Ratten",
"433454", "Leutschach",
"437489", "Purgstall\ an\ der\ Erlauf",
"433152", "Feldbach",
"432522", "Laa\ an\ der\ Thaya",
"435633", "Hägerau",
"432147", "Zurndorf",
"432625", "Bad\ Sauerbrunn",
"432247", "Deutsch\-Wagram",
"434732", "Gmünd\ in\ Kärnten",
"437949", "Rainbach\ im\ Mühlkreis",
"432719", "Dross",
"432747", "Ober\-Grafendorf",
"432683", "Purbach\ am\ Neusiedler\ See",
"434232", "Völkermarkt",
"437618", "Neukirchen\,\ Altmünster",
"436416", "Lend",
"434244", "Bad\ Bleiberg",
"435556", "Schruns",
"436226", "Fuschl\ am\ See",
"435356", "Kitzbühel",
"437582", "Kirchdorf\ an\ der\ Krems",
"433680", "Donnersbachwald",
"4346", "Klagenfurt",
"434274", "Velden\ am\ Wörther\ See",
"433687", "Schladming",
"437484", "Göstling\ an\ der\ Ybbs",
"434875", "Matrei\ in\ Osttirol",
"434258", "Gummern",
"432956", "Ziersdorf",
"432277", "Zwentendorf",
"432664", "Semmering",
"433861", "Aflenz",
"432266", "Stockerau",
"436215", "Strasswalchen",
"432722", "Kirchberg\ an\ der\ Pielach",
"432766", "Kleinzell",
"433856", "Veitsch",
"433352", "Oberwart",
"432166", "Parndorf",
"433573", "Fohnsdorf",
"432177", "Podersdorf\ am\ See",
"436483", "Göriach",
"432214", "Kopfstetten",
"435256", "Untergurgl",
"432815", "Grossschönau",
"437944", "Sandl",
"432714", "Rossatz",
"434717", "Steinfeld",
"435678", "Weissenbach\ am\ Lech",
"437282", "Neufelden",
"436562", "Mittersill",
"433143", "Krottendorf",
"432616", "Lockenhaus",
"436223", "Anthering",
"435353", "Waidring",
"433135", "Kalsdorf\ bei\ Graz",
"435372", "Kufstein",
"435675", "Tannheim",
"435553", "Raggal",
"435572", "Dornbirn",
"432284", "Oberweiden",
"436413", "Wagrain",
"432784", "Perschling",
"437477", "St\.\ Peter\ in\ der\ Au",
"437212", "Zwettl\ an\ der\ Rodl",
"435444", "Ischgl",
"436541", "Saalbach",
"432942", "Retz",
"437712", "Schärding",
"432686", "Drassburg",
"433617", "Gaishorn\ am\ See",
"437414", "Weins\-Isperdorf",
"435242", "Schwaz",
"432823", "Grossglobnitz",
"433176", "Stubenberg",
"435234", "Axams",
"435339", "Wildschönau",
"437724", "Mauerkirchen",
"434255", "Arnoldstein",
"437224", "St\.\ Florian",
"433842", "Leoben",
"437565", "St\.\ Pankraz",
"432631", "Pöttsching",
"437230", "Altenberg\ bei\ Linz",
"432857", "Bad\ Grosspertholz",
"433834", "Wald\ am\ Schoberpass",
"437662", "Seewalchen\ am\ Attersee",
"437953", "Liebenau",
"432524", "Kautendorf",
"435287", "Tux",
"433473", "Straden",
"436216", "Neumarkt\ am\ Wallersee",
"432265", "Hausleiten",
"433452", "Leibnitz",
"433178", "St\.\ Ruprecht\ an\ der\ Raab",
"432864", "Kautzen",
"432765", "Kaumberg",
"434353", "Prebl",
"437763", "Kopfing\ im\ Innkreis",
"436583", "Leogang",
"434876", "Kals\ am\ Grossglockner",
"433533", "Turrach",
"437263", "Bad\ Zell",
"432955", "Grossweikersdorf",
"436462", "Bischofshofen",
"433333", "Sebersdorf",
"435255", "Umhausen",
"437584", "Molln",
"432816", "Karlstift",
"433359", "Loipersdorf\-Kitzladen",
"432615", "Lutzmannsburg",
"433855", "Krieglach",
"434220", "Köttmannsdorf",
"437613", "Laakirchen",
"432987", "St\.\ Leonhard\ am\ Hornerwald",
"434242", "Villach",
"432237", "Gaaden",
"437289", "Rohrbach\ in\ Oberösterreich",
"432165", "Hainburg\ a\.d\.\ Donau",
"434234", "Ruden",
"434734", "Rennweg",
"432688", "Steinbrunn",
"435579", "Alberschwende",
"434843", "Ausservillgraten",
"433858", "Mitterdorf\ im\ Mürztal",
"432168", "Mannersdorf\ am\ Leithagebirge",
"432685", "Rust",
"435510", "Damüls",
"437683", "Frankenburg\ am\ Hausruck",
"437719", "Taufkirchen\ an\ der\ Pram",
"437747", "Kirchberg\ bei\ Mattighofen",
"432949", "Niederfladnitz",
"435274", "Gries\ am\ Brenner",
"437219", "Vorderweissenbach",
"437247", "Kematen\ am\ Innbach",
"433136", "Dobl",
"434761", "Stockenboi",
"435676", "Jungholz",
"433460", "Soboth",
"432618", "Markt\ St\.\ Martin",
"434256", "Nötsch\ im\ Gailtal",
"433634", "Hieflau",
"432958", "Maissau",
"437566", "Rosenau\ am\ Hengstpass",
"435472", "Prutz",
"435635", "Elmen",
"432623", "Pottendorf",
"436131", "Obertraun",
"432268", "Grossmugl",
"433849", "Vordernberg",
"435332", "Wörgl",
"432768", "St\.\ Aegyd\ am\ Neuwalde",
"433175", "Anger",
"432945", "Zellerndorf",
"433574", "Pusterwald",
"437215", "Hellmonsödt",
"433358", "Litzelsdorf",
"433144", "Köflach",
"435575", "Langen\ bei\ Bregenz",
"437288", "Ulrichsberg",
"435672", "Reutte",
"436484", "Lessach",
"432213", "Lassee",
"433132", "Kumberg",
"434221", "Gallizien",
"435375", "Kössen",
"432713", "Spitz",
"437943", "Windhaag\ bei\ Freistadt",
"432689", "Hornstein",
"437665", "Unterach\ am\ Attersee",
"435476", "Serfaus",
"437562", "Windischgarsten",
"434252", "Wernberg",
"433845", "Mautern\ in\ Steiermark",
"434273", "Reifnitz",
"433179", "Passail",
"437483", "Oberndorf\ an\ der\ Melk",
"435336", "Alpbach",
"432728", "Wienerbruck",
"435245", "Hinterriss",
"432663", "Schottwien",
"433456", "Fresing",
"436477", "St\.\ Michael\ im\ Lungau",
"432725", "Frankenfels",
"436212", "Seekirchen\ am\ Wallersee",
"432824", "Allentsteig",
"435248", "Steinberg\ am\ Rofan",
"432959", "Sitzendorf\ an\ der\ Schmida",
"437757", "Gurten",
"437257", "Grünburg",
"437413", "Marbach\ an\ der\ Donau",
"433387", "Söchau",
"436466", "Werfenweng",
"433833", "Traboch",
"433848", "Eisenerz",
"437723", "Altheim",
"433587", "Schönberg\-Lachtal",
"432269", "Niederfellabrunn",
"434853", "Ainet",
"434872", "Huben",
"432769", "Türnitz",
"437223", "Enns",
"435578", "Höchst",
"433859", "Mürzsteg",
"437285", "Hofkirchen\ im\ Mühlkreis",
"432169", "Trautmannsdorf\ an\ der\ Leitha",
"435554", "Sonntag",
"436565", "Neukirchen\ am\ Grossvenediger",
"432812", "Gross\ Gerungs",
"436224", "Hintersee",
"435354", "Fieberbrunn",
"433461", "Trahütten",
"435443", "Galtür",
"437718", "Waldkirchen\ am\ Wesen",
"432948", "Weitersfeld",
"437218", "Grosstraberg",
"433355", "Stadtschlaining",
"436414", "Grossarl",
"432283", "Angern\ an\ der\ March",
"434246", "Radenthein",
"432783", "Traismauer",
"432647", "Krumbach\,\ Lower\ Austria",
"432619", "Lackendorf",
"435576", "Hohenems",
"437583", "Kremsmünster",
"435376", "Thiersee",
"432682", "Eisenstadt",
"434233", "Griffen",
"437716", "Münzkirchen",
"432946", "Pulkau",
"434733", "Malta",
"437216", "Helfenberg",
"4319", "Vienna",
"437614", "Vorchdorf",
"434248", "Treffen",
"433153", "Riegersburg",
"435335", "Hopfgarten\ im\ Brixental",
"433172", "Weiz",
"433474", "Deutsch\ Goritz",
"432863", "Eggern",
"435246", "Achenkirch",
"432523", "Kirchstetten\,\ Neudorf\ bei\ Staatz",
"437954", "St\.\ Georgen\ am\ Walde",
"435632", "Stanzach",
"437666", "Attersee",
"433127", "Peggau",
"432741", "Flinsbach",
"436468", "Werfen",
"435475", "Feichten",
"433334", "Kaindorf",
"433846", "Kalwang",
"437764", "Riedau",
"434354", "Preitenegg",
"432557", "Bernhardsthal",
"437264", "Windhaag\ bei\ Perg",
"433534", "Stadl\ an\ der\ Mur",
"436584", "Maria\ Alm\ am\ Steinernen\ Meer",
"432952", "Hollabrunn",
"436247", "Grossgmain",
"436219", "Obertrum\ am\ See",
"433633", "Landl",
"432762", "Lilienfeld",
"435338", "Kundl",
"437231", "Herzogsdorf",
"432630", "Ternitz",
"434879", "St\.\ Veit\ in\ Defereggen",
"432726", "Puchenstuben",
"432262", "Korneuburg",
"433455", "Arnfels",
"432624", "Ebenfurth",
"432847", "Gross\-Siegharts",
"432162", "Bruck\ an\ der\ Leitha",
"433356", "Markt\ Allhau",
"433852", "Mürzzuschlag",
"434245", "Feistritz\ an\ der\ Drau",
"432612", "Oberpullendorf",
"436566", "Bramberg\ am\ Wildkogel",
"437286", "Lembach\ im\ Mühlkreis",
"43512", "Innsbruck",
"437684", "Frankenmarkt",
"435252", "Oetz",
"435273", "Matrei\ am\ Brenner",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+43|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;