## no critic: TestingAndDebugging::RequireStrict
package Sah::SchemaR::share;

our $DATE = '2022-09-22'; # DATE
our $VERSION = '0.012'; # VERSION

our $rschema = do{my$var={base=>"float",clsets_after_base=>[{description=>"\nAccepted in one of these forms:\n\n    0.5      # a normal float between 0 and 1\n    10       # a float between 1 (exclusive) and 100, interpreted as percent\n    10%      # a percentage string, between 0% and 100%\n\nDue to different interpretations, particularly \"1\" (some people might expect it\nto mean \"0.01\" or \"1%\") use of this type is discouraged. Use\n<pm:Sah::Schema::percent> instead.\n\n",examples=>[{valid=>1,validated_value=>0,value=>0},{valid=>1,validated_value=>0.5,value=>0.5},{valid=>1,validated_value=>1,value=>1},{valid=>1,validated_value=>0.012,value=>1.2},{valid=>1,validated_value=>0.012,value=>"1.2%"},{valid=>0,value=>"102%"}],max=>1,min=>0,summary=>"A float between 0 and 1","x.perl.coerce_rules"=>["From_str::share"]}],clsets_after_type=>['$var->{clsets_after_base}[0]'],"clsets_after_type.alt.merge.merged"=>['$var->{clsets_after_base}[0]'],resolve_path=>["float"],type=>"float",v=>2};$var->{clsets_after_type}[0]=$var->{clsets_after_base}[0];$var->{"clsets_after_type.alt.merge.merged"}[0]=$var->{clsets_after_base}[0];$var};

1;
# ABSTRACT: A float between 0 and 1

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::share - A float between 0 and 1

=head1 VERSION

This document describes version 0.012 of Sah::SchemaR::share (from Perl distribution Sah-Schemas-Float), released on 2022-09-22.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Float>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Float>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2022, 2020, 2019, 2018 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Float>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
