package App::Provision::Perlbrew;
$App::Provision::Perlbrew::VERSION = '0.0404';
our $AUTHORITY = 'cpan:GENE';
use strict;
use warnings;
use parent qw( App::Provision::Tiny );


sub deps
{
    return qw( curl );
}


sub meet
{
    my $self = shift;
    $self->recipe(
      [ 'curl -L http://cpanmin.us | perl - App::cpanminus' ],
    );
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Provision::Perlbrew

=head1 VERSION

version 0.0404

=head1 FUNCTIONS

=head2 deps

=head2 deps

=head1 AUTHOR

Gene Boggs <gene@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2022 by Gene Boggs.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
