package Sah::SchemaR::git::refname;

our $DATE = '2020-03-27'; # DATE
our $VERSION = '0.002'; # VERSION

our $rschema = ["str",[{examples=>[{valid=>1,value=>"foo/bar"},{summary=>"A slash-separated component begins with dot (rule 1)",valid=>0,value=>".foo/bar"}],match=>qr(
                     \A(?:

                         # 1. (a) no slash-separated component can begin with a dot
                         (?!\.)
                         (?![^/]+/\.)

                         # 1. (b) ... or end with ".lock"
                         (?![^.]*\.lock(?:\z|/))

                         # 2. must contain at least one /
                         (?=[^/]*/)

                         # 3. cannot contain two consecutive dots anywhere
                         (?![^.]*\.\.)

                         # 4. cannot contain control char (<\040), DEL (\0177), space, tilde, caret, or colon anywhere
                         (?![^\000-\037\177 ~^:]*[\000-\037\177 ~^:])

                         # 5. cannot have question-mark ?, asterisk *, or open bracket [ anywhere
                         (?![^?*\[]*[?*\[])

                         # 6. (a) cannot begin with a slash, or contain multiple slashes
                         (?!/)
                         (?![^/]*//)

                         # 8. cannot contain the sequence: @ followed by {
                         (?![^@]*@\{)

                         # 9. cannot be single character @, implied by rule #2

                         # 10. cannot contain backslash
                         (?![^\\]*\\)

                         .+

                         # 6. (b) cannot end with a slash
                         (?<!/)

                         # 7. cannot end with a dot
                         (?<!\.)
                     )\z
                 )x,summary=>"git reference name"}],["str"]];

1;
# ABSTRACT: git reference name

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::git::refname - git reference name

=head1 VERSION

This document describes version 0.002 of Sah::SchemaR::git::refname (from Perl distribution Sah-Schemas-Git), released on 2020-03-27.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Git>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Git>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Git>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
