#!/usr/bin/perl

use strict;
use warnings;

use Test::More;

use Metrics::Any '$metrics';
use Metrics::Any::Adapter 'Test';

# Force the adapter to exist
$metrics->adapter;

# unlabelled
{
   Metrics::Any::Adapter::Test->clear;

   $metrics->make_counter( abc => name => "the_ABC_counter" );
   $metrics->make_counter( def => name => "the_DEF_counter" );

   $metrics->inc_counter( 'abc' );

   $metrics->inc_counter( 'def' );
   $metrics->inc_counter( 'def' );
   $metrics->inc_counter( 'def' );

   is( Metrics::Any::Adapter::Test->metrics,
      "the_ABC_counter = 1\n" .
      "the_DEF_counter = 3\n",
      'Metrics::Any::Adapter::Test->metrics for basic metrics'
   );
}

# with labels
{
   Metrics::Any::Adapter::Test->clear;

   $metrics->make_counter( ghi =>
      name   => "the_GHI_counter",
      labels => [qw( label )],
   );
   $metrics->make_counter( jkl =>
      name   => "the_JKL_counter",
      labels => [qw( x y )],
   );

   $metrics->inc_counter( ghi => "value" );
   $metrics->inc_counter( jkl => 10, 20 );

   is( Metrics::Any::Adapter::Test->metrics,
      "the_GHI_counter label:value = 1\n" .
      "the_JKL_counter x:10 y:20 = 1\n",
      'Metrics::Any::Adapter::Test->metrics after increment with label'
   );
}

# distributions
{
   Metrics::Any::Adapter::Test->clear;

   $metrics->make_distribution( distribution => name => "the_ABC_distribution" );

   $metrics->inc_distribution_by( distribution => 150 );

   is( Metrics::Any::Adapter::Test->metrics,
      "the_ABC_distribution_count = 1\n" .
      "the_ABC_distribution_total = 150\n",
      'Metrics::Any::Adapter::Test->metrics after ->inc_distribution_by'
   );
}

# gauges
{
   Metrics::Any::Adapter::Test->clear;

   $metrics->make_gauge( gauge => name => "the_ABC_gauge" );

   $metrics->set_gauge_to( gauge => 30 );

   is( Metrics::Any::Adapter::Test->metrics,
      "the_ABC_gauge = 30\n",
      'Metrics::Any::Adapter::Test->metrics after ->set_gauge_to'
   );

   $metrics->inc_gauge_by( gauge => 10 );

   is( Metrics::Any::Adapter::Test->metrics,
      "the_ABC_gauge = 40\n",
      'Metrics::Any::Adapter::Test->metrics after ->inc_gauge_by'
   );
}

# timers
{
   Metrics::Any::Adapter::Test->clear;

   $metrics->make_timer( timer => name => "the_ABC_timer" );

   $metrics->inc_timer_by( timer => 0.02 );

   is( Metrics::Any::Adapter::Test->metrics,
      "the_ABC_timer_count = 1\n" .
      "the_ABC_timer_total = 0.02\n",
      'Metrics::Any::Adapter::Test->metrics after ->inc_timer_by'
   );
}

done_testing;
