use utf8;

package SemanticWeb::Schema::MathSolver;

# ABSTRACT: A math solver which is capable of solving a subset of mathematical problems.

use v5.14;
use Moo;

extends qw/ SemanticWeb::Schema::CreativeWork /;


use MooX::JSON_LD 'MathSolver';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v21.0.0';


has math_expression => (
    is        => 'rw',
    predicate => '_has_math_expression',
    json_ld   => 'mathExpression',
);





1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::MathSolver - A math solver which is capable of solving a subset of mathematical problems.

=head1 VERSION

version v21.0.0

=head1 DESCRIPTION

A math solver which is capable of solving a subset of mathematical
problems.

=head1 ATTRIBUTES

=head2 C<math_expression>

C<mathExpression>

A mathematical expression (e.g. 'x^2-3x=0') that may be solved for a
specific variable, simplified, or transformed. This can take many formats,
e.g. LaTeX, Ascii-Math, or math as you would write with a keyboard.

A math_expression should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::SolveMathAction']>

=item C<Str>

=back

=head2 C<_has_math_expression>

A predicate for the L</math_expression> attribute.

=head1 SEE ALSO

L<SemanticWeb::Schema::CreativeWork>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2022 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
