package API::MailboxOrg::API::Domain;

# ABSTRACT: MailboxOrg::API::Domain

# ---
# This class is auto-generated by bin/get_mailbox_api.pl
# ---

use v5.24;

use strict;
use warnings;

use Moo;
use Types::Standard qw(Enum Str Int InstanceOf ArrayRef);
use API::MailboxOrg::Types qw(HashRefRestricted Boolean);
use Params::ValidationCompiler qw(validation_for);

extends 'API::MailboxOrg::APIBase';

with 'MooX::Singleton';

use feature 'signatures';
no warnings 'experimental::signatures';

our $VERSION = '1.0.1'; # VERSION

my %validators = (
    'add' => validation_for(
        params => {
            account               => { type => Str, optional => 0 },
            domain                => { type => Str, optional => 0 },
            password              => { type => Str, optional => 0 },
            context_id            => { type => Str, optional => 1 },
            create_new_context_id => { type => Boolean, optional => 1 },
            memo                  => { type => Str, optional => 1 },

        },
    ),
    'del' => validation_for(
        params => {
            account => { type => Str, optional => 0 },
            domain  => { type => Str, optional => 0 },

        },
    ),
    'get' => validation_for(
        params => {
            domain => { type => Str, optional => 0 },

        },
    ),
    'list' => validation_for(
        params => {
            account => { type => Str, optional => 0 },
            filter  => { type => Str, optional => 1 },

        },
    ),
    'set' => validation_for(
        params => {
            domain                => { type => Str, optional => 0 },
            password              => { type => Str, optional => 1 },
            context_id            => { type => Str, optional => 1 },
            create_new_context_id => { type => Boolean, optional => 1 },
            memo                  => { type => Str, optional => 1 },

        },
    ),

);


sub add ($self, %params) {
    my $validator = $validators{'add'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'domain.add', \%params, \%opt );
}

sub del ($self, %params) {
    my $validator = $validators{'del'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'domain.del', \%params, \%opt );
}

sub get ($self, %params) {
    my $validator = $validators{'get'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'domain.get', \%params, \%opt );
}

sub list ($self, %params) {
    my $validator = $validators{'list'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'domain.list', \%params, \%opt );
}

sub set ($self, %params) {
    my $validator = $validators{'set'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'domain.set', \%params, \%opt );
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

API::MailboxOrg::API::Domain - MailboxOrg::API::Domain

=head1 VERSION

version 1.0.1

=head1 SYNOPSIS

    use API::MailboxOrg;

    my $user     = '1234abc';
    my $password = '1234abc';

    my $api      = API::MailboxOrg->new(
        user     => $user,
        password => $password,
    );

=head1 METHODS

=head2 add

Adds a domain

Available for admin, reseller, account

Parameters:

=over 4

=item * account

=item * domain

=item * password

=item * context_id

=item * create_new_context_id

=item * memo

=back

returns: array

    $api->domain->add(%params);

=head2 del

Removes a domain from an account

Available for admin, reseller, account

Parameters:

=over 4

=item * account

=item * domain

=back

returns: boolean

    $api->domain->del(%params);

=head2 get

Returns details about a domain

Available for admin, reseller, account, domain

Parameters:

=over 4

=item * domain

=back

returns: array

    $api->domain->get(%params);

=head2 list

Returns a list of all existing domains

Available for admin, reseller, account

Parameters:

=over 4

=item * account

=item * filter

=back

returns: array

    $api->domain->list(%params);

=head2 set

Modifies domain properties

Available for admin, reseller, account, domain, account, account

Parameters:

=over 4

=item * domain

=item * password

=item * context_id

=item * create_new_context_id

=item * memo

=back

returns: array

    $api->domain->set(%params);

=head1 AUTHOR

Renee Baecker <reneeb@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2022 by Renee Baecker.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
