#! perl

# Time-stamp: "2004-12-29 18:48:49 AST"

use 5.006;
use strict;
use warnings;

use Test::More 0.88;
use Lingua::FR::Numbers::Ordinate qw/ ordinate th /;

my @TESTS = (
    [3,     '3e'],
    [-3,    '-3e'],
    [13,    '13e'],
    [33,    '33e'],
    [-513,  '-513e'],
    [1,     '1er'],
    [2,     '2e'],
    [4,     '4e'],
    [5,     '5e'],
    [0,     '0e'],
    ['',    '0e'],
    [undef, '0e'],
    [22,    '22e'],
);

my $ordinal;

plan tests => 2 * @TESTS;

foreach my $test (@TESTS) {
    my ($value, $expected_ordinal) = @$test;

    $ordinal = ordinate($value);
    is($ordinal, $expected_ordinal, 'ordinate('.(defined($value) ? $value : 'undef').')');

    $ordinal = th($value);
    is($ordinal, $expected_ordinal, 'th('.(defined($value) ? $value : 'undef').')');

}
