# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20220601185319;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]|
              636[457-9]
            )|
            9(?:
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                7[015-9]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17|
                3[015-9]
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3[045]|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9(?:
                  [019]|
                  4[1-3]|
                  6(?:
                    [0-47-9]|
                    5[01346-9]
                  )
                )
              )|
              3(?:
                [29]|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[23]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                72|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              6[1-3]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              829(?:
                2|
                66
              )|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{en} = {"817684", "Wajima\,\ Ishikawa",
"8112397", "Kuriyama\,\ Hokkaido",
"812655", "Iida\,\ Nagano",
"81294", "Hitachiota\,\ Ibaraki",
"812832", "Sano\,\ Tochigi",
"812780", "Maebashi\,\ Gunma",
"81987", "Nichinan\,\ Miyazaki",
"818806", "Sukumo\,\ Kochi",
"81582", "Gifu\,\ Gifu",
"811366", "Suttsu\,\ Hokkaido",
"817497", "Nagahama\,\ Shiga",
"81888", "Kochi\,\ Kochi",
"812573", "Kashiwazaki\,\ Niigata",
"812858", "Mooka\,\ Tochigi",
"81743", "Nara\,\ Nara",
"81766", "Takaoka\,\ Toyama",
"81436", "Ichihara\,\ Chiba",
"819575", "Isahaya\,\ Nagasaki",
"818553", "Hamada\,\ Shimane",
"819685", "Tamana\,\ Kumamoto",
"811337", "Ishikari\,\ Hokkaido",
"818675", "Kuse\,\ Okayama",
"818585", "Kurayoshi\,\ Tottori",
"818955", "Uwajima\,\ Ehime",
"81864", "Kurashiki\,\ Okayama",
"815973", "Owase\,\ Mie",
"81554", "Otsuki\,\ Yamanashi",
"818593", "Yonago\,\ Tottori",
"811587", "Nakayubetsu\,\ Hokkaido",
"811957", "Iwate\,\ Iwate",
"812898", "Kanuma\,\ Tochigi",
"812787", "Numata\,\ Gunma",
"811522", "Shari\,\ Hokkaido",
"817457", "Yamatotakada\,\ Nara",
"81587", "Ichinomiya\,\ Aichi",
"814298", "Hanno\,\ Saitama",
"812695", "Nakano\,\ Nagano",
"814755", "Togane\,\ Chiba",
"8199345", "Kagoshima\,\ Kagoshima",
"81125", "Takikawa\,\ Hokkaido",
"812856", "Mooka\,\ Tochigi",
"818808", "Tosashimizu\,\ Kochi",
"81471", "Kashiwa\,\ Chiba",
"811374", "Mori\,\ Hokkaido",
"818546", "Kakeya\,\ Shimane",
"815762", "Gero\,\ Gifu",
"818944", "Yawatahama\,\ Ehime",
"812963", "Shimodate\,\ Ibaraki",
"814284", "Tachikawa\,\ Tokyo",
"817969", "Hamasaka\,\ Hyogo",
"812914", "Hokota\,\ Ibaraki",
"818949", "Uwajima\,\ Ehime",
"812247", "Ogawara\,\ Miyagi",
"811634", "Hamatonbetsu\,\ Hokkaido",
"814289", "Ome\,\ Tokyo",
"812896", "Kanuma\,\ Tochigi",
"817964", "Toyooka\,\ Hyogo",
"8112399", "Kuriyama\,\ Hokkaido",
"812565", "Sanjo\,\ Niigata",
"812649", "Nagano\,\ Nagano",
"811464", "Shizunai\,\ Hokkaido",
"81426", "Hachioji\,\ Tokyo",
"818663", "Soja\,\ Okayama",
"8124196", "Yanaizu\,\ Fukushima",
"812412", "Kitakata\,\ Fukushima",
"81286", "Utsunomiya\,\ Tochigi",
"819965", "Satsumasendai\,\ Kagoshima",
"81798", "Nishinomiya\,\ Hyogo",
"811237", "Kuriyama\,\ Hokkaido",
"814795", "Choshi\,\ Chiba",
"811866", "Takanosu\,\ Akita",
"815753", "Sekigahara\,\ Gifu",
"819977", "Setouchi\,\ Kagoshima",
"8198294", "Nobeoka\,\ Miyazaki",
"811333", "Tobetsu\,\ Hokkaido",
"8182943", "Hiroshima\,\ Hiroshima",
"81563", "Nishio\,\ Aichi",
"81532", "Toyohashi\,\ Aichi",
"812992", "Ishioka\,\ Ibaraki",
"81937", "Kitakyushu\,\ Fukuoka",
"818557", "Kawamoto\,\ Shimane",
"819592", "Oseto\,\ Nagasaki",
"817493", "Hikone\,\ Shiga",
"815982", "Matsusaka\,\ Mie",
"818364", "Ube\,\ Yamaguchi",
"81226", "Kesennuma\,\ Miyagi",
"812577", "Muika\,\ Niigata",
"818692", "Oku\,\ Okayama",
"8186996", "Seto\,\ Okayama",
"81486", "Urawa\,\ Saitama",
"818369", "Ube\,\ Yamaguchi",
"818378", "Shimonoseki\,\ Yamaguchi",
"8186697", "Kurashiki\,\ Okayama",
"81546", "Shizuoka\,\ Shizuoka",
"81721", "Tondabayashi\,\ Osaka",
"812795", "Shibukawa\,\ Gunma",
"812486", "Sukagawa\,\ Fukushima",
"818835", "Mima\,\ Tokushima",
"818972", "Niihama\,\ Ehime",
"81946", "Amagi\,\ Fukuoka",
"817485", "Yokaichi\,\ Shiga",
"818652", "Kurashiki\,\ Okayama",
"812783", "Numata\,\ Gunma",
"817453", "Yamatotakada\,\ Nara",
"819552", "Imari\,\ Saga",
"812938", "Mito\,\ Ibaraki",
"81537", "Kakegawa\,\ Shizuoka",
"81776", "Fukui\,\ Fukui",
"8198291", "Nobeoka\,\ Miyazaki",
"819785", "Bungotakada\,\ Oita",
"818479", "Tojo\,\ Hiroshima",
"81853", "Izumo\,\ Shimane",
"811953", "Ninohe\,\ Iwate",
"811583", "Monbetsu\,\ Hokkaido",
"812582", "Nagaoka\,\ Niigata",
"81963", "Kumamoto\,\ Kumamoto",
"815977", "Kumano\,\ Mie",
"81932", "Kitakyushu\,\ Fukuoka",
"811555", "Obihiro\,\ Hokkaido",
"812672", "Komoro\,\ Nagano",
"8198298", "Hyuga\,\ Miyazaki",
"814240", "Kokubunji\,\ Tokyo",
"818474", "Fuchu\,\ Hiroshima",
"814702", "Tateyama\,\ Chiba",
"819934", "Ibusuki\,\ Kagoshima",
"818376", "Mine\,\ Yamaguchi",
"811544", "Kushiro\,\ Hokkaido",
"819662", "Hitoyoshi\,\ Kumamoto",
"812488", "Sukagawa\,\ Fukushima",
"81845", "Innoshima\,\ Hiroshima",
"811734", "Goshogawara\,\ Aomori",
"811549", "Kushiro\,\ Hokkaido",
"818562", "Masuda\,\ Shimane",
"817732", "Fukuchiyama\,\ Kyoto",
"81930", "Yukuhashi\,\ Fukuoka",
"815746", "Minokamo\,\ Gifu",
"811874", "Kakunodate\,\ Akita",
"818660", "Seto\,\ Okayama",
"8125484", "Murakami\,\ Niigata",
"81922", "Fukuoka\,\ Fukuoka",
"811868", "Takanosu\,\ Akita",
"812744", "Fujioka\,\ Gunma",
"819432", "Yame\,\ Fukuoka",
"812384", "Yonezawa\,\ Yamagata",
"817355", "Shingu\,\ Fukuoka",
"818667", "Ibara\,\ Okayama",
"81494", "Chichibu\,\ Saitama",
"8125488", "Tsugawa\,\ Niigata",
"811233", "Chitose\,\ Hokkaido",
"818206", "Yanai\,\ Yamaguchi",
"81828", "Hiroshima\,\ Hiroshima",
"812232", "Iwanuma\,\ Miyagi",
"81927", "Fukuoka\,\ Fukuoka",
"812389", "Yonezawa\,\ Yamagata",
"812936", "Mito\,\ Ibaraki",
"818466", "Mima\,\ Tokushima",
"81242", "Aizuwakamatsu\,\ Fukushima",
"8125481", "Murakami\,\ Niigata",
"8153979", "Hamamatsu\,\ Shizuoka",
"81236", "Yamagata\,\ Yamagata",
"812243", "Shiroishi\,\ Miyagi",
"819746", "Taketa\,\ Oita",
"815394", "Hamamatsu\,\ Shizuoka",
"81849", "Fukuyama\,\ Hiroshima",
"811946", "Kuji\,\ Iwate",
"8147955", "Yokaichiba\,\ Chiba",
"814772", "Ichikawa\,\ Chiba",
"812967", "Kasama\,\ Ibaraki",
"811973", "Mizusawa\,\ Iwate",
"81535", "Hamamatsu\,\ Shizuoka",
"81939", "Kitakyushu\,\ Fukuoka",
"811653", "Shibetsu\,\ Hokkaido",
"818680", "Okayama\,\ Okayama",
"812652", "Iida\,\ Nagano",
"812835", "Sano\,\ Tochigi",
"812474", "Ishikawa\,\ Fukushima",
"818582", "Kurayoshi\,\ Tottori",
"818398", "Ogori\,\ Yamaguchi",
"818952", "Uwajima\,\ Ehime",
"812550", "Yasuzuka\,\ Niigata",
"819572", "Isahaya\,\ Nagasaki",
"81253", "Niigata\,\ Niigata",
"814281", "Sagamihara\,\ Kanagawa",
"812911", "Hokota\,\ Ibaraki",
"819682", "Yamaga\,\ Kumamoto",
"8161", "Osaka\,\ Osaka",
"8125485", "Tsugawa\,\ Niigata",
"815366", "Shitara\,\ Aichi",
"81182", "Yokote\,\ Akita",
"818296", "Hiroshima\,\ Hiroshima",
"81593", "Yokkaichi\,\ Mie",
"812378", "Sagae\,\ Yamagata",
"819957", "Kajiki\,\ Kagoshima",
"815997", "Ago\,\ Mie",
"812692", "Nakano\,\ Nagano",
"819723", "Saiki\,\ Oita",
"81935", "Kitakyushu\,\ Fukuoka",
"811525", "Abashiri\,\ Hokkaido",
"811757", "Noheji\,\ Aomori",
"818687", "Mimasaka\,\ Okayama",
"81548", "Haibara\,\ Shizuoka",
"81488", "Urawa\,\ Saitama",
"817617", "Kaga\,\ Ishikawa",
"811646", "Haboro\,\ Hokkaido",
"814752", "Mobara\,\ Chiba",
"818384", "Hagi\,\ Yamaguchi",
"81464", "Atsugi\,\ Kanagawa",
"81734", "Wakayama\,\ Wakayama",
"815765", "Gero\,\ Gifu",
"81249", "Koriyama\,\ Fukushima",
"81925", "Fukuoka\,\ Fukuoka",
"818243", "Higashi\-ku\,\ Hiroshima",
"817947", "Miki\,\ Hyogo",
"81929", "Fukuoka\,\ Fukuoka",
"812562", "Sanjo\,\ Niigata",
"811854", "Oga\,\ Akita",
"81245", "Fukushima\,\ Fukushima",
"811563", "Honbetsu\,\ Hokkaido",
"817940", "Kakogawa\,\ Hyogo",
"81778", "Takefu\,\ Fukui",
"817706", "Obama\,\ Fukui",
"812376", "Sagae\,\ Yamagata",
"812415", "Yanaizu\,\ Fukushima",
"815368", "Shitara\,\ Aichi",
"819962", "Satsumasendai\,\ Kagoshima",
"818298", "Hatsukaichi\,\ Hiroshima",
"8178", "Kobe\,\ Hyogo",
"814792", "Choshi\,\ Chiba",
"8198295", "Hyuga\,\ Miyazaki",
"817465", "Yoshino\,\ Nara",
"81948", "Iizuka\,\ Fukuoka",
"817713", "Kameoka\,\ Kyoto",
"819809", "Yaeyama\ District\,\ Okinawa",
"81551", "Nirasaki\,\ Yamanashi",
"817238", "Neyagawa\,\ Osaka",
"817956", "Sanda\,\ Hyogo",
"819804", "Nago\,\ Okinawa",
"8183768", "Shimonoseki\,\ Yamaguchi",
"812995", "Ishioka\,\ Ibaraki",
"817676", "Nanao\,\ Ishikawa",
"81989", "Naha\,\ Okinawa",
"81585", "Ibigawa\,\ Gifu",
"815583", "Shimoda\,\ Shizuoka",
"818695", "Seto\,\ Okayama",
"812792", "Shibukawa\,\ Gunma",
"811977", "Kitakami\,\ Iwate",
"815985", "Matsusaka\,\ Mie",
"819727", "Usuki\,\ Oita",
"81288", "Imabari\,\ Ehime",
"819555", "Karatsu\,\ Saga",
"818683", "Tsuyama\,\ Okayama",
"811753", "Mutsu\,\ Aomori",
"818975", "Niihama\,\ Ehime",
"818832", "Kamojima\,\ Tokushima",
"818655", "Kamogata\,\ Okayama",
"817367", "Iwade\,\ Wakayama",
"817482", "Yokaichi\,\ Shiga",
"819953", "Okuchi\,\ Kagoshima",
"815993", "Toba\,\ Mie",
"8186992", "Bizen\,\ Okayama",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"81985", "Miyazaki\,\ Miyazaki",
"812585", "Nagaoka\,\ Niigata",
"818843", "Anan\,\ Tokushima",
"812675", "Saku\,\ Nagano",
"814705", "Tateyama\,\ Chiba",
"817996", "Tsuna\,\ Hyogo",
"811982", "Hanamaki\,\ Iwate",
"811552", "Obihiro\,\ Hokkaido",
"812878", "Nasukarasuyama\,\ Tochigi",
"812553", "Joetsu\,\ Niigata",
"819948", "Shibushi\,\ Kagoshima",
"811541", "Teshikaga\,\ Hokkaido",
"819782", "Bungotakada\,\ Oita",
"818565", "Masuda\,\ Shimane",
"818896", "Susaki\,\ Kochi",
"817943", "Kakogawa\,\ Hyogo",
"818247", "Shobara\,\ Hiroshima",
"817735", "Fukuchiyama\,\ Kyoto",
"819665", "Hitoyoshi\,\ Kumamoto",
"8126179", "Omachi\,\ Nagano",
"81438", "Kisarazu\,\ Chiba",
"819734", "Hita\,\ Oita",
"811394", "Matsumae\,\ Hokkaido",
"817678", "Nanao\,\ Ishikawa",
"811939", "Miyako\,\ Iwate",
"812614", "Omachi\,\ Nagano",
"81886", "Tokushima\,\ Tokushima",
"819435", "Yame\,\ Fukuoka",
"811934", "Kamaishi\,\ Iwate",
"819544", "Takeo\,\ Saga",
"817613", "Komatsu\,\ Ishikawa",
"812619", "Omachi\,\ Nagano",
"819946", "Kanoya\,\ Kagoshima",
"811536", "Akkeshi\,\ Hokkaido",
"8164", "Osaka\,\ Osaka",
"812235", "Sendai\,\ Miyagi",
"817717", "Sonobe\,\ Kyoto",
"812876", "Kuroiso\,\ Tochigi",
"817352", "Shingu\,\ Fukuoka",
"817998", "Tsuna\,\ Hyogo",
"811354", "Yoichi\,\ Hokkaido",
"815734", "Ena\,\ Gifu",
"818240", "Higashi\-ku\,\ Hiroshima",
"81474", "Funabashi\,\ Chiba",
"812546", "Murakami\,\ Niigata",
"814775", "Funabashi\,\ Chiba",
"819824", "Nobeoka\,\ Miyazaki",
"819233", "Maebaru\,\ Fukuoka",
"812857", "Mooka\,\ Tochigi",
"817498", "Nagahama\,\ Shiga",
"81727", "Ikeda\,\ Osaka",
"815743", "Minokamo\,\ Gifu",
"818373", "Nagato\,\ Yamaguchi",
"818547", "Kakeya\,\ Shimane",
"8198296", "Hyuga\,\ Miyazaki",
"819822", "Nobeoka\,\ Miyazaki",
"812890", "Utsunomiya\,\ Tochigi",
"8169", "Osaka\,\ Osaka",
"815395", "Hamamatsu\,\ Shizuoka",
"8186994", "Seto\,\ Okayama",
"81272", "Maebashi\,\ Gunma",
"817354", "Shingu\,\ Fukuoka",
"812385", "Yonezawa\,\ Yamagata",
"811352", "Yoichi\,\ Hokkaido",
"815732", "Ena\,\ Gifu",
"819732", "Hita\,\ Oita",
"811958", "Iwate\,\ Iwate",
"81277", "Kiryu\,\ Gunma",
"811392", "Kikonai\,\ Hokkaido",
"81460", "Odawara\,\ Kanagawa",
"811588", "Okoppe\,\ Hokkaido",
"812612", "Omachi\,\ Nagano",
"812933", "Takahagi\,\ Ibaraki",
"8188097", "Tosashimizu\,\ Kochi",
"812745", "Fujioka\,\ Gunma",
"818463", "Takehara\,\ Hiroshima",
"81531", "Tahara\,\ Aichi",
"811932", "Kamaishi\,\ Iwate",
"819542", "Takeo\,\ Saga",
"8126173", "Omachi\,\ Nagano",
"811875", "Kakunodate\,\ Akita",
"818203", "Yanai\,\ Yamaguchi",
"811236", "Chitose\,\ Hokkaido",
"8186998", "Seto\,\ Okayama",
"81184", "Yurihonjo\,\ Akita",
"811943", "Iwaizumi\,\ Iwate",
"811735", "Goshogawara\,\ Aomori",
"814701", "Kamogawa\,\ Chiba",
"814297", "Hanno\,\ Saitama",
"81722", "Sakai\,\ Osaka",
"81423", "Kokubunji\,\ Tokyo",
"812246", "Ogawara\,\ Miyagi",
"819743", "Mie\,\ Oita",
"819935", "Kaseda\,\ Kagoshima",
"81875", "Kan\'onji\,\ Kagawa",
"811545", "Kushiro\,\ Hokkaido",
"81157", "Kitami\,\ Hokkaido",
"812788", "Maebashi\,\ Gunma",
"812897", "Kanuma\,\ Tochigi",
"819789", "Kitsuki\,\ Oita",
"818475", "Fuchu\,\ Hiroshima",
"811984", "Hanamaki\,\ Iwate",
"811554", "Obihiro\,\ Hokkaido",
"811863", "Kazuno\,\ Akita",
"8188099", "Tosashimizu\,\ Kochi",
"811336", "Ishikari\,\ Hokkaido",
"811559", "Obihiro\,\ Hokkaido",
"819784", "Bungotakada\,\ Oita",
"81763", "Fukuno\,\ Toyama",
"81433", "Chiba\,\ Chiba",
"81462", "Atsugi\,\ Kanagawa",
"8125486", "Tsugawa\,\ Niigata",
"8175", "Kyoto\,\ Kyoto",
"81196", "Morioka\,\ Iwate",
"812483", "Shirakawa\,\ Fukushima",
"817496", "Nagahama\,\ Shiga",
"811367", "Suttsu\,\ Hokkaido",
"818834", "Kamojima\,\ Tokushima",
"818807", "Sukumo\,\ Kochi",
"817484", "Yokaichi\,\ Shiga",
"81737", "Yuasa\,\ Wakayama",
"81467", "Fujisawa\,\ Kanagawa",
"81270", "Isesaki\,\ Gunma",
"812786", "Numata\,\ Gunma",
"81495", "Honjo\,\ Saitama",
"812794", "Shibukawa\,\ Gunma",
"812248", "Ogawara\,\ Miyagi",
"817456", "Yamatotakada\,\ Nara",
"818365", "Ube\,\ Yamaguchi",
"812799", "Naganohara\,\ Gunma",
"814771", "Ichikawa\,\ Chiba",
"811238", "Kuriyama\,\ Hokkaido",
"8126170", "Omachi\,\ Nagano",
"819802", "Minamidaito\,\ Okinawa",
"811956", "Iwate\,\ Iwate",
"811586", "Nakayubetsu\,\ Hokkaido",
"818558", "Kawamoto\,\ Shimane",
"819964", "Satsumasendai\,\ Kagoshima",
"818873", "Aki\,\ Kochi",
"814794", "Choshi\,\ Chiba",
"815566", "Minobu\,\ Yamanashi",
"812930", "Mito\,\ Ibaraki",
"819978", "Tokunoshima\,\ Kagoshima",
"811465", "Shizunai\,\ Hokkaido",
"81559", "Numazu\,\ Shizuoka",
"811635", "Hamatonbetsu\,\ Hokkaido",
"81998", "Kagoshima\,\ Kagoshima",
"818377", "Shimonoseki\,\ Yamaguchi",
"818543", "Yasugi\,\ Shimane",
"812564", "Sanjo\,\ Niigata",
"811852", "Oga\,\ Akita",
"817965", "Toyooka\,\ Hyogo",
"812578", "Muika\,\ Niigata",
"818945", "Yawatahama\,\ Ehime",
"81178", "Hachinohe\,\ Aomori",
"812853", "Oyama\,\ Tochigi",
"814285", "Sagamihara\,\ Kanagawa",
"811375", "Yakumo\,\ Hokkaido",
"819747", "Taketa\,\ Oita",
"812893", "Utsunomiya\,\ Tochigi",
"81134", "Otaru\,\ Hokkaido",
"811947", "Kuji\,\ Iwate",
"81892", "Kumakogen\,\ Ehime",
"81555", "Fujiyoshida\,\ Yamanashi",
"818666", "Ibara\,\ Okayama",
"81262", "Nagano\,\ Nagano",
"81233", "Shinjo\,\ Yamagata",
"815978", "Kumano\,\ Mie",
"817903", "Fukusaki\,\ Hyogo",
"814754", "Mobara\,\ Chiba",
"8153969", "Hamamatsu\,\ Shizuoka",
"818467", "Mima\,\ Tokushima",
"812937", "Mito\,\ Ibaraki",
"818382", "Hagi\,\ Yamaguchi",
"811363", "Kutchan\,\ Hokkaido",
"81566", "Kariya\,\ Aichi",
"81124", "Ashibetsu\,\ Hokkaido",
"81260", "Anan\,\ Nagano",
"812576", "Tokamachi\,\ Niigata",
"812694", "Nakano\,\ Nagano",
"812487", "Sukagawa\,\ Fukushima",
"819976", "Naze\,\ Kagoshima",
"811867", "Takanosu\,\ Akita",
"8153967", "Hamamatsu\,\ Shizuoka",
"818556", "Gotsu\,\ Shimane",
"81543", "Shizuoka\,\ Shizuoka",
"812472", "Ishikawa\,\ Fukushima",
"818674", "Kuse\,\ Okayama",
"818596", "Yonago\,\ Tottori",
"818584", "Kurayoshi\,\ Tottori",
"818954", "Uwajima\,\ Ehime",
"819574", "Isahaya\,\ Nagasaki",
"818679", "Niimi\,\ Okayama",
"819684", "Yamaga\,\ Kumamoto",
"818668", "Ibara\,\ Okayama",
"812968", "Kasama\,\ Ibaraki",
"812659", "Ina\,\ Nagano",
"812654", "Iida\,\ Nagano",
"817685", "Wajima\,\ Ishikawa",
"81292", "Mito\,\ Ibaraki",
"819825", "Hyuga\,\ Miyazaki",
"815392", "Hamamatsu\,\ Shizuoka",
"815958", "Kameyama\,\ Mie",
"818262", "Kake\,\ Hiroshima",
"81584", "Ogaki\,\ Gifu",
"8153973", "Hamamatsu\,\ Shizuoka",
"818893", "Sakawa\,\ Kochi",
"817946", "Miki\,\ Hyogo",
"812382", "Yonezawa\,\ Yamagata",
"812239", "Sendai\,\ Miyagi",
"817616", "Komatsu\,\ Ishikawa",
"81899", "Matsuyama\,\ Ehime",
"815735", "Ena\,\ Gifu",
"81952", "Saga\,\ Saga",
"81557", "Ito\,\ Shizuoka",
"811647", "Haboro\,\ Hokkaido",
"812234", "Sendai\,\ Miyagi",
"818397", "Ogori\,\ Yamaguchi",
"81568", "Kasugai\,\ Aichi",
"81862", "Okayama\,\ Okayama",
"81833", "Kudamatsu\,\ Yamaguchi",
"8167", "Osaka\,\ Osaka",
"8182920", "Hatsukaichi\,\ Hiroshima",
"811935", "Kamaishi\,\ Iwate",
"811533", "Nemuro\,\ Hokkaido",
"819943", "Kanoya\,\ Kagoshima",
"811395", "Esashi\,\ Hokkaido",
"81552", "Kofu\,\ Yamanashi",
"819735", "Hita\,\ Oita",
"812742", "Fujioka\,\ Gunma",
"812873", "Otawara\,\ Tochigi",
"819434", "Yame\,\ Fukuoka",
"812615", "Omachi\,\ Nagano",
"811542", "Kushiro\,\ Hokkaido",
"819932", "Ibusuki\,\ Kagoshima",
"819664", "Hitoyoshi\,\ Kumamoto",
"818688", "Mimasaka\,\ Okayama",
"81984", "Kobayashi\,\ Miyazaki",
"811732", "Goshogawara\,\ Aomori",
"818564", "Masuda\,\ Shimane",
"8183766", "Shimonoseki\,\ Yamaguchi",
"815998", "Ago\,\ Mie",
"812543", "Shibata\,\ Niigata",
"812377", "Sagae\,\ Yamagata",
"817734", "Fukuchiyama\,\ Kyoto",
"817707", "Obama\,\ Fukui",
"8198292", "Nobeoka\,\ Miyazaki",
"812589", "Nagaoka\,\ Niigata",
"817953", "Nishiwaki\,\ Hyogo",
"812679", "Saku\,\ Nagano",
"814709", "Kamogawa\,\ Chiba",
"817673", "Hakui\,\ Ishikawa",
"81176", "Towada\,\ Aomori",
"818290", "Hiroshima\,\ Hiroshima",
"817618", "Kaga\,\ Ishikawa",
"8152", "Nagoya\,\ Aichi",
"812584", "Nagaoka\,\ Niigata",
"812674", "Komoro\,\ Nagano",
"814704", "Tateyama\,\ Chiba",
"817948", "Miki\,\ Hyogo",
"818974", "Niihama\,\ Ehime",
"818654", "Kamogata\,\ Okayama",
"815586", "Shimoda\,\ Shizuoka",
"8153970", "Hamamatsu\,\ Shizuoka",
"81550", "Gotenba\,\ Shizuoka",
"811453", "Hayakita\,\ Hokkaido",
"819554", "Imari\,\ Saga",
"818362", "Ube\,\ Yamaguchi",
"8186552", "Kurashiki\,\ Okayama",
"815984", "Matsusaka\,\ Mie",
"819676", "Takamori\,\ Kumamoto",
"81950", "Hirado\,\ Nagasaki",
"8125482", "Murakami\,\ Niigata",
"819956", "Kajiki\,\ Kagoshima",
"815996", "Ago\,\ Mie",
"818694", "Okayama\,\ Okayama",
"819599", "Oseto\,\ Nagasaki",
"818686", "Tsuyama\,\ Okayama",
"811756", "Noheji\,\ Aomori",
"81596", "Ise\,\ Mie",
"819805", "Nago\,\ Okinawa",
"812556", "Itoigawa\,\ Niigata",
"812994", "Ishioka\,\ Ibaraki",
"81823", "Kure\,\ Hiroshima",
"818297", "Hatsukaichi\,\ Hiroshima",
"817993", "Sumoto\,\ Hyogo",
"812999", "Itako\,\ Ibaraki",
"815367", "Shitara\,\ Aichi",
"817464", "Yoshino\,\ Nara",
"812419", "Tajima\,\ Fukushima",
"81534", "Hamamatsu\,\ Shizuoka",
"811462", "Urakawa\,\ Hokkaido",
"819940", "Shibushi\,\ Kagoshima",
"812414", "Yanaizu\,\ Fukushima",
"8112393", "Yubari\,\ Hokkaido",
"81877", "Marugame\,\ Kagawa",
"81729", "Yao\,\ Osaka",
"811658", "Kamikawa\,\ Hokkaido",
"818942", "Yawatahama\,\ Ehime",
"811978", "Kitakami\,\ Iwate",
"814282", "Ome\,\ Tokyo",
"818246", "Miyoshi\,\ Hiroshima",
"811632", "Teshio\,\ Hokkaido",
"811855", "Noshiro\,\ Akita",
"817962", "Toyooka\,\ Hyogo",
"8144", "Kawasaki\,\ Kanagawa",
"817368", "Iwade\,\ Wakayama",
"815769", "Shokawa\,\ Gifu",
"817703", "Tsuruga\,\ Fukui",
"812547", "Murakami\,\ Niigata",
"812373", "Murayama\,\ Yamagata",
"811372", "Shikabe\,\ Hokkaido",
"819728", "Usuki\,\ Oita",
"815764", "Gero\,\ Gifu",
"81725", "Izumi\,\ Osaka",
"819947", "Shibushi\,\ Kagoshima",
"811537", "Nakashibetsu\,\ Hokkaido",
"818385", "Hagi\,\ Yamaguchi",
"812877", "Kuroiso\,\ Tochigi",
"817716", "Sonobe\,\ Kyoto",
"81934", "Kitakyushu\,\ Fukuoka",
"8166", "Osaka\,\ Osaka",
"81578", "Kamioka\,\ Akita",
"817230", "Neyagawa\,\ Osaka",
"814220", "Kokubunji\,\ Tokyo",
"811524", "Abashiri\,\ Hokkaido",
"811976", "Kitakami\,\ Iwate",
"818248", "Shobara\,\ Hiroshima",
"811656", "Bifuka\,\ Hokkaido",
"817476", "Shimonoseki\,\ Yamaguchi",
"817723", "Miyazu\,\ Kyoto",
"81465", "Odawara\,\ Kanagawa",
"8112390", "Yubari\,\ Hokkaido",
"81924", "Fukuoka\,\ Fukuoka",
"817677", "Nanao\,\ Ishikawa",
"81793", "Himeji\,\ Hyogo",
"81492", "Kawagoe\,\ Saitama",
"81166", "Asahikawa\,\ Hokkaido",
"815363", "Shinshiro\,\ Aichi",
"817997", "Tsuna\,\ Hyogo",
"8186995", "Seto\,\ Okayama",
"818293", "Hatsukaichi\,\ Hiroshima",
"81739", "Tanabe\,\ Wakayama",
"812475", "Ishikawa\,\ Fukushima",
"817718", "Sonobe\,\ Kyoto",
"817950", "Sanda\,\ Hyogo",
"81244", "Hobara\,\ Fukushima",
"819726", "Usuki\,\ Oita",
"817682", "Wajima\,\ Ishikawa",
"812834", "Utsunomiya\,\ Tochigi",
"81143", "Muroran\,\ Hokkaido",
"812839", "Sano\,\ Tochigi",
"817366", "Iwade\,\ Wakayama",
"818676", "Kuse\,\ Okayama",
"818594", "Yonago\,\ Tottori",
"815979", "Kumano\,\ Mie",
"818586", "Kurayoshi\,\ Tottori",
"818956", "Uwajima\,\ Ehime",
"8183767", "Shimonoseki\,\ Yamaguchi",
"8199347", "Kagoshima\,\ Kagoshima",
"814758", "Togane\,\ Chiba",
"819576", "Shimabara\,\ Nagasaki",
"817722", "Miyazu\,\ Kyoto",
"819686", "Tamana\,\ Kumamoto",
"818477", "Tojo\,\ Hiroshima",
"815974", "Owase\,\ Mie",
"811365", "Kutchan\,\ Hokkaido",
"8126174", "Omachi\,\ Nagano",
"818360", "Ogori\,\ Yamaguchi",
"812656", "Ina\,\ Nagano",
"81923", "Fukuoka\,\ Fukuoka",
"8126171", "Omachi\,\ Nagano",
"818367", "Ube\,\ Yamaguchi",
"812574", "Kashiwazaki\,\ Niigata",
"812696", "Iiyama\,\ Nagano",
"817683", "Wajima\,\ Ishikawa",
"8126178", "Omachi\,\ Nagano",
"81896", "Iyomishima\,\ Ehime",
"81243", "Nihonmatsu\,\ Fukushima",
"8186993", "Bizen\,\ Okayama",
"819974", "Yakushima\,\ Kagoshima",
"81266", "Suwa\,\ Nagano",
"818559", "Kawamoto\,\ Shimane",
"814798", "Yokaichiba\,\ Chiba",
"819979", "Tokunoshima\,\ Kagoshima",
"81144", "Tomakomai\,\ Hokkaido",
"818554", "Hamada\,\ Shimane",
"819968", "Izumi\,\ Kagoshima",
"815362", "Shinshiro\,\ Aichi",
"818292", "Hiroshima\,\ Hiroshima",
"818545", "Kisuki\,\ Shimane",
"81533", "Toyohashi\,\ Aichi",
"8112395", "Kuriyama\,\ Hokkaido",
"812658", "Ina\,\ Nagano",
"81857", "Tottori\,\ Tottori",
"817963", "Toyooka\,\ Hyogo",
"817914", "Aioi\,\ Hyogo",
"81958", "Nagasaki\,\ Nagasaki",
"812855", "Oyama\,\ Tochigi",
"818943", "Yawatahama\,\ Ehime",
"812964", "Shimodate\,\ Ibaraki",
"814283", "Ome\,\ Tokyo",
"812913", "Hokota\,\ Ibaraki",
"8111", "Sapporo\,\ Hokkaido",
"819688", "Tamana\,\ Kumamoto",
"818664", "Takahashi\,\ Okayama",
"81281", "Utsunomiya\,\ Tochigi",
"812387", "Nagai\,\ Yamagata",
"819578", "Shimabara\,\ Nagasaki",
"818588", "Koge\,\ Tottori",
"818958", "Misho\,\ Ehime",
"818669", "Soja\,\ Okayama",
"814756", "Togane\,\ Chiba",
"81298", "Tsuchiura\,\ Ibaraki",
"818678", "Niimi\,\ Okayama",
"811463", "Urakawa\,\ Hokkaido",
"819966", "Izumi\,\ Kagoshima",
"811877", "Omagari\,\ Akita",
"81259", "Sado\,\ Niigata",
"814796", "Yokaichiba\,\ Chiba",
"817905", "Fukusaki\,\ Hyogo",
"812747", "Tomioka\,\ Gunma",
"819937", "Kaseda\,\ Kagoshima",
"81567", "Tsushima\,\ Aichi",
"811547", "Shiranuka\,\ Hokkaido",
"81476", "Narita\,\ Chiba",
"81852", "Matsue\,\ Shimane",
"812566", "Sanjo\,\ Niigata",
"812895", "Utsunomiya\,\ Tochigi",
"812698", "Iiyama\,\ Nagano",
"81962", "Kumamoto\,\ Kumamoto",
"81933", "Kitakyushu\,\ Fukuoka",
"817702", "Tsuruga\,\ Fukui",
"812372", "Murayama\,\ Yamagata",
"81179", "Sannohe\,\ Aomori",
"812784", "Numata\,\ Gunma",
"811452", "Hayakita\,\ Hokkaido",
"812796", "Shibukawa\,\ Gunma",
"812485", "Shirakawa\,\ Fukushima",
"817454", "Yamatotakada\,\ Nara",
"812789", "Maebashi\,\ Gunma",
"81276", "Ota\,\ Gunma",
"811589", "Okoppe\,\ Hokkaido",
"811865", "Odate\,\ Akita",
"817952", "Nishiwaki\,\ Hyogo",
"811954", "Ninohe\,\ Iwate",
"811584", "Engaru\,\ Hokkaido",
"817672", "Hakui\,\ Ishikawa",
"817992", "Sumoto\,\ Hyogo",
"811986", "Tono\,\ Iwate",
"811556", "Obihiro\,\ Hokkaido",
"815754", "Sekigahara\,\ Gifu",
"819786", "Kitsuki\,\ Oita",
"817687", "Noto\,\ Ishikawa",
"81726", "Ibaraki\,\ Osaka",
"817494", "Hikone\,\ Shiga",
"818363", "Ube\,\ Yamaguchi",
"8147957", "Yokaichiba\,\ Chiba",
"818836", "Mima\,\ Tokushima",
"81740", "Imazu\,\ Shiga",
"817486", "Minakuchi\,\ Shiga",
"8153975", "Hamamatsu\,\ Shizuoka",
"81583", "Gifu\,\ Gifu",
"812383", "Yonezawa\,\ Yamagata",
"811234", "Chitose\,\ Hokkaido",
"812647", "Nagano\,\ Nagano",
"81742", "Nara\,\ Nara",
"81577", "Takayama\,\ Gifu",
"818947", "Uwajima\,\ Ehime",
"81466", "Fujisawa\,\ Kanagawa",
"818892", "Sakawa\,\ Kochi",
"812917", "Mito\,\ Ibaraki",
"814287", "Ome\,\ Tokyo",
"815745", "Minokamo\,\ Gifu",
"81192", "Ofunato\,\ Iwate",
"8165", "Osaka\,\ Osaka",
"812798", "Naganohara\,\ Gunma",
"812244", "Shiroishi\,\ Miyagi",
"818375", "Mine\,\ Yamaguchi",
"815393", "Hamamatsu\,\ Shizuoka",
"81834", "Tokuyama\,\ Yamaguchi",
"818263", "Kake\,\ Hiroshima",
"811733", "Goshogawara\,\ Aomori",
"81572", "Tajimi\,\ Gifu",
"814280", "Tachikawa\,\ Tokyo",
"818512", "Nishigo\,\ Fukushima",
"817488", "Minakuchi\,\ Shiga",
"81878", "Takamatsu\,\ Kagawa",
"811945", "Kuji\,\ Iwate",
"812542", "Shibata\,\ Niigata",
"819933", "Ibusuki\,\ Kagoshima",
"811543", "Kushiro\,\ Hokkaido",
"811377", "Yakumo\,\ Hokkaido",
"81977", "Beppu\,\ Oita",
"812551", "Joetsu\,\ Niigata",
"811532", "Nemuro\,\ Hokkaido",
"819788", "Kunisaki\,\ Oita",
"812743", "Fujioka\,\ Gunma",
"812872", "Otawara\,\ Tochigi",
"81983", "Takanabe\,\ Miyazaki",
"812935", "Mito\,\ Ibaraki",
"812640", "Nagano\,\ Nagano",
"811873", "Kakunodate\,\ Akita",
"817356", "Kushimoto\,\ Wakayama",
"811558", "Hiroo\,\ Hokkaido",
"818205", "Yanai\,\ Yamaguchi",
"8125489", "Tsugawa\,\ Niigata",
"8153971", "Hamamatsu\,\ Shizuoka",
"8182942", "Hiroshima\,\ Hiroshima",
"817725", "Miyazu\,\ Kyoto",
"8153978", "Hamamatsu\,\ Shizuoka",
"81468", "Yokosuka\,\ Kanagawa",
"81738", "Gobo\,\ Wakayama",
"819724", "Saiki\,\ Oita",
"815768", "Gero\,\ Gifu",
"812836", "Sano\,\ Tochigi",
"8186698", "Kurashiki\,\ Okayama",
"8188096", "Tosashimizu\,\ Kochi",
"811362", "Kutchan\,\ Hokkaido",
"81484", "Kawaguchi\,\ Saitama",
"81544", "Fujinomiya\,\ Shizuoka",
"8186691", "Kurashiki\,\ Okayama",
"818493", "Onomichi\,\ Hiroshima",
"811526", "Abashiri\,\ Hokkaido",
"81944", "Setaka\,\ Fukuoka",
"814998", "Ogasawara\,\ Tokyo",
"811974", "Mizusawa\,\ Iwate",
"818796", "Tonosho\,\ Kagawa",
"811654", "Nayoro\,\ Hokkaido",
"81774", "Uji\,\ Kyoto",
"8198297", "Hyuga\,\ Miyazaki",
"818295", "Hatsukaichi\,\ Hiroshima",
"812473", "Ishikawa\,\ Fukushima",
"817468", "Kamikitayama\,\ Nara",
"811564", "Kamishihoro\,\ Hokkaido",
"812852", "Oyama\,\ Tochigi",
"812838", "Sano\,\ Tochigi",
"819827", "Takachiho\,\ Miyazaki",
"818542", "Yasugi\,\ Shimane",
"811853", "Oga\,\ Akita",
"815766", "Gero\,\ Gifu",
"811645", "Rumoi\,\ Hokkaido",
"81167", "Furano\,\ Hokkaido",
"817714", "Kameoka\,\ Kyoto",
"81975", "Oita\,\ Oita",
"812571", "Muika\,\ Niigata",
"818872", "Muroto\,\ Kochi",
"8198299", "Hyuga\,\ Miyazaki",
"815737", "Nakatsugawa\,\ Gifu",
"811357", "Iwanai\,\ Hokkaido",
"817466", "Totsukawa\,\ Nara",
"811397", "Okushiri\,\ Hokkaido",
"819737", "Kusu\,\ Oita",
"81162", "Wakkanai\,\ Hokkaido",
"81979", "Nakatsu\,\ Oita",
"818383", "Hagi\,\ Yamaguchi",
"81728", "Neyagawa\,\ Osaka",
"819547", "Kashima\,\ Saga",
"811937", "Miyako\,\ Iwate",
"812416", "Tajima\,\ Fukushima",
"8125487", "Tsugawa\,\ Niigata",
"81199", "Morioka\,\ Iwate",
"817902", "Fukusaki\,\ Hyogo",
"81234", "Sakata\,\ Yamagata",
"817705", "Obama\,\ Fukui",
"812375", "Murayama\,\ Yamagata",
"818244", "Miyoshi\,\ Hiroshima",
"818798", "Tonosho\,\ Kagawa",
"812892", "Utsunomiya\,\ Tochigi",
"818249", "Higashi\-ku\,\ Hiroshima",
"811528", "Bihoro\,\ Hokkaido",
"819596", "Fukue\,\ Nagasaki",
"8112391", "Yubari\,\ Hokkaido",
"815986", "Matsusaka\,\ Mie",
"817738", "Maizuru\,\ Kyoto",
"818689", "Okayama\,\ Okayama",
"818568", "Tsuwano\,\ Shimane",
"815994", "Ago\,\ Mie",
"819954", "Kajiki\,\ Kagoshima",
"818696", "Bizen\,\ Okayama",
"819679", "Takamori\,\ Kumamoto",
"811455", "Mukawa\,\ Hokkaido",
"8112398", "Kuriyama\,\ Hokkaido",
"815999", "Tsu\,\ Mie",
"818684", "Tsuyama\,\ Okayama",
"819668", "Minamata\,\ Kumamoto",
"812482", "Shirakawa\,\ Fukushima",
"811754", "Mutsu\,\ Aomori",
"811862", "Kazuno\,\ Akita",
"819438", "Tanushimaru\,\ Fukuoka",
"81764", "Toyama\,\ Toyama",
"817955", "Sanda\,\ Hyogo",
"81434", "Chiba\,\ Chiba",
"812554", "Joetsu\,\ Niigata",
"812996", "Itako\,\ Ibaraki",
"817675", "Nanao\,\ Ishikawa",
"81956", "Sasebo\,\ Nagasaki",
"812559", "Yasuzuka\,\ Niigata",
"818844", "Anan\,\ Tokushima",
"813", "Tokyo",
"819803", "Nago\,\ Okinawa",
"812477", "Miharu\,\ Fukushima",
"812238", "Sendai\,\ Miyagi",
"81250", "Niitsu\,\ Niigata",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"812586", "Nagaoka\,\ Niigata",
"81478", "Sawara\,\ Chiba",
"812676", "Saku\,\ Nagano",
"817995", "Sumoto\,\ Hyogo",
"8199331", "Kagoshima\,\ Kagoshima",
"818490", "Onomichi\,\ Hiroshima",
"818976", "Niihama\,\ Ehime",
"815959", "Kameyama\,\ Mie",
"818656", "Kasaoka\,\ Okayama",
"8112394", "Yubari\,\ Hokkaido",
"815584", "Shimoda\,\ Shizuoka",
"819556", "Karatsu\,\ Saga",
"81969", "Amakusa\,\ Kumamoto",
"811353", "Yoichi\,\ Hokkaido",
"81565", "Toyota\,\ Aichi",
"81172", "Hirosaki\,\ Aomori",
"815733", "Ena\,\ Gifu",
"812998", "Itako\,\ Ibaraki",
"81992", "Kagoshima\,\ Kagoshima",
"818372", "Nagato\,\ Yamaguchi",
"819823", "Nobeoka\,\ Miyazaki",
"819666", "Minamata\,\ Kumamoto",
"818698", "Bizen\,\ Okayama",
"811857", "Noshiro\,\ Akita",
"818895", "Susaki\,\ Kochi",
"81252", "Niigata\,\ Niigata",
"819598", "Fukue\,\ Nagasaki",
"817736", "Maizuru\,\ Kyoto",
"815742", "Minokamo\,\ Gifu",
"819742", "Mie\,\ Oita",
"819558", "Karatsu\,\ Saga",
"8126175", "Omachi\,\ Nagano",
"817949", "Kakogawa\,\ Hyogo",
"811942", "Iwaizumi\,\ Iwate",
"817944", "Kakogawa\,\ Hyogo",
"814776", "Funabashi\,\ Chiba",
"818978", "Hakata\,\ Ehime",
"812545", "Murakami\,\ Niigata",
"81268", "Ueda\,\ Nagano",
"8153966", "Hamamatsu\,\ Shizuoka",
"81183", "Yuzawa\,\ Akita",
"819543", "Takeo\,\ Saga",
"81592", "Tsu\,\ Mie",
"811933", "Kamaishi\,\ Iwate",
"812678", "Saku\,\ Nagano",
"81898", "Imabari\,\ Ehime",
"817614", "Komatsu\,\ Ishikawa",
"818202", "Yanai\,\ Yamaguchi",
"81177", "Aomori\,\ Aomori",
"812588", "Nagaoka\,\ Niigata",
"812236", "Sendai\,\ Miyagi",
"819733", "Hita\,\ Oita",
"81965", "Yatsushiro\,\ Kumamoto",
"819945", "Kanoya\,\ Kagoshima",
"811535", "Akkeshi\,\ Hokkaido",
"81569", "Handa\,\ Aichi",
"811393", "Matsumae\,\ Hokkaido",
"81284", "Ashikaga\,\ Tochigi",
"818387", "Tamagawa\,\ Yamaguchi",
"812613", "Omachi\,\ Nagano",
"812932", "Takahagi\,\ Ibaraki",
"818462", "Takehara\,\ Hiroshima",
"812875", "Otawara\,\ Tochigi",
"812386", "Nagai\,\ Yamagata",
"818478", "Tojo\,\ Hiroshima",
"818204", "Yanai\,\ Yamaguchi",
"817612", "Komatsu\,\ Ishikawa",
"812939", "Mito\,\ Ibaraki",
"814757", "Togane\,\ Chiba",
"8112392", "Yubari\,\ Hokkaido",
"812934", "Takahagi\,\ Ibaraki",
"818464", "Takehara\,\ Hiroshima",
"819744", "Mie\,\ Oita",
"81947", "Tagawa\,\ Fukuoka",
"812560", "Itoigawa\,\ Niigata",
"81222", "Sendai\,\ Miyagi",
"811944", "Iwaizumi\,\ Iwate",
"81482", "Kawaguchi\,\ Saitama",
"817942", "Kakogawa\,\ Hyogo",
"81542", "Shizuoka\,\ Shizuoka",
"81848", "Onomichi\,\ Hiroshima",
"818374", "Nagato\,\ Yamaguchi",
"819936", "Kaseda\,\ Kagoshima",
"811546", "Kushiro\,\ Hokkaido",
"81942", "Kurume\,\ Fukuoka",
"812245", "Ogawara\,\ Miyagi",
"819232", "Maebaru\,\ Fukuoka",
"81227", "Sendai\,\ Miyagi",
"811736", "Goshogawara\,\ Aomori",
"81487", "Urawa\,\ Saitama",
"81547", "Shimada\,\ Shizuoka",
"818368", "Ube\,\ Yamaguchi",
"815744", "Minokamo\,\ Gifu",
"811876", "Omagari\,\ Akita",
"817353", "Shingu\,\ Fukuoka",
"819967", "Izumi\,\ Kagoshima",
"81473", "Ichikawa\,\ Chiba",
"814797", "Yokaichiba\,\ Chiba",
"811235", "Yubari\,\ Hokkaido",
"812746", "Tomioka\,\ Gunma",
"81936", "Kitakyushu\,\ Fukuoka",
"81825", "Hiroshima\,\ Hiroshima",
"817495", "Nagahama\,\ Shiga",
"8128798", "Otawara\,\ Tochigi",
"815582", "Shimoda\,\ Shizuoka",
"815398", "Hamamatsu\,\ Shizuoka",
"812657", "Ina\,\ Nagano",
"812793", "Shibukawa\,\ Gunma",
"81940", "Munakata\,\ Fukuoka",
"815755", "Sekigahara\,\ Gifu",
"818677", "Niimi\,\ Okayama",
"818957", "Misho\,\ Ehime",
"818587", "Koge\,\ Tottori",
"81835", "Hofu\,\ Yamaguchi",
"819577", "Shimabara\,\ Nagasaki",
"81926", "Fukuoka\,\ Fukuoka",
"812388", "Nagai\,\ Yamagata",
"819687", "Tamana\,\ Kumamoto",
"818476", "Fuchu\,\ Hiroshima",
"811864", "Odate\,\ Akita",
"812748", "Tomioka\,\ Gunma",
"812552", "Joetsu\,\ Niigata",
"811955", "Ninohe\,\ Iwate",
"811585", "Engaru\,\ Hokkaido",
"819783", "Bungotakada\,\ Oita",
"8188095", "Tosashimizu\,\ Kochi",
"81839", "Yamaguchi\,\ Yamaguchi",
"81480", "Kuki\,\ Saitama",
"811869", "Odate\,\ Akita",
"818842", "Anan\,\ Tokushima",
"81893", "Ozu\,\ Ehime",
"811878", "Omagari\,\ Akita",
"811983", "Hanamaki\,\ Iwate",
"811553", "Obihiro\,\ Hokkaido",
"81246", "Iwaki\,\ Fukushima",
"81263", "Matsumoto\,\ Nagano",
"81188", "Akita\,\ Akita",
"818366", "Ube\,\ Yamaguchi",
"818833", "Kamojima\,\ Tokushima",
"812697", "Iiyama\,\ Nagano",
"812489", "Sukagawa\,\ Fukushima",
"817483", "Yokaichi\,\ Shiga",
"819952", "Okuchi\,\ Kagoshima",
"815992", "Toba\,\ Mie",
"812785", "Numata\,\ Gunma",
"819938", "Kaseda\,\ Kagoshima",
"817455", "Yamatotakada\,\ Nara",
"811548", "Teshikaga\,\ Hokkaido",
"81191", "Ichinoseki\,\ Iwate",
"818682", "Tsuyama\,\ Okayama",
"811752", "Mutsu\,\ Aomori",
"812484", "Shirakawa\,\ Fukushima",
"818946", "Uwajima\,\ Ehime",
"81420", "Tokorozawa\,\ Saitama",
"818242", "Higashi\-ku\,\ Hiroshima",
"814286", "Sagamihara\,\ Kanagawa",
"812899", "Kanuma\,\ Tochigi",
"81280", "Koga\,\ Ibaraki",
"8182941", "Hiroshima\,\ Hiroshima",
"81586", "Ichinomiya\,\ Aichi",
"8153972", "Hamamatsu\,\ Shizuoka",
"812894", "Utsunomiya\,\ Tochigi",
"81463", "Hiratsuka\,\ Kanagawa",
"81762", "Kanazawa\,\ Ishikawa",
"81432", "Chiba\,\ Chiba",
"8153965", "Hamamatsu\,\ Shizuoka",
"814753", "Mobara\,\ Chiba",
"8145", "Yokohama\,\ Kanagawa",
"811466", "Erimo\,\ Hokkaido",
"8126176", "Omachi\,\ Nagano",
"812646", "Nagano\,\ Nagano",
"817904", "Fukusaki\,\ Hyogo",
"818879", "Muroto\,\ Kochi",
"817712", "Kameoka\,\ Kyoto",
"819963", "Satsumasendai\,\ Kagoshima",
"818874", "Aki\,\ Kochi",
"818665", "Takahashi\,\ Okayama",
"817357", "Kushimoto\,\ Wakayama",
"814793", "Choshi\,\ Chiba",
"811562", "Honbetsu\,\ Hokkaido",
"812854", "Oyama\,\ Tochigi",
"812965", "Shimodate\,\ Ibaraki",
"8125480", "Murakami\,\ Niigata",
"81986", "Miyakonojo\,\ Miyazaki",
"812859", "Oyama\,\ Tochigi",
"818544", "Kisuki\,\ Shimane",
"811376", "Yakumo\,\ Hokkaido",
"817915", "Aioi\,\ Hyogo",
"817688", "Noto\,\ Ishikawa",
"812563", "Sanjo\,\ Niigata",
"8198293", "Nobeoka\,\ Miyazaki",
"819573", "Isahaya\,\ Nagasaki",
"812648", "Nagano\,\ Nagano",
"819683", "Yamaga\,\ Kumamoto",
"818555", "Gotsu\,\ Shimane",
"81174", "Kanita\,\ Aomori",
"81427", "Sagamihara\,\ Kanagawa",
"819975", "Naze\,\ Kagoshima",
"818583", "Kurayoshi\,\ Tottori",
"818953", "Uwajima\,\ Ehime",
"812653", "Iida\,\ Nagano",
"817968", "Hamasaka\,\ Hyogo",
"81273", "Takasaki\,\ Gunma",
"81885", "Komatsushima\,\ Tokushima",
"818391", "Ogori\,\ Yamaguchi",
"812797", "Shibukawa\,\ Gunma",
"811972", "Mizusawa\,\ Iwate",
"814288", "Ome\,\ Tokyo",
"811652", "Shibetsu\,\ Hokkaido",
"812575", "Tokamachi\,\ Niigata",
"818948", "Uwajima\,\ Ehime",
"819722", "Saiki\,\ Oita",
"8186553", "Kurashiki\,\ Okayama",
"817686", "Noto\,\ Ishikawa",
"8125483", "Murakami\,\ Niigata",
"811378", "Imakane\,\ Hokkaido",
"81561", "Seto\,\ Aichi",
"811364", "Kutchan\,\ Hokkaido",
"817487", "Minakuchi\,\ Shiga",
"8198290", "Nobeoka\,\ Miyazaki",
"812693", "Nakano\,\ Nagano",
"81594", "Kuwana\,\ Mie",
"811987", "Tono\,\ Iwate",
"81723", "Sakai\,\ Osaka",
"818595", "Yonago\,\ Tottori",
"81138", "Hakodate\,\ Hokkaido",
"81282", "Tochigi\,\ Tochigi",
"819787", "Kunisaki\,\ Oita",
"811534", "Nakashibetsu\,\ Hokkaido",
"819944", "Kanoya\,\ Kagoshima",
"819433", "Yame\,\ Fukuoka",
"812874", "Otawara\,\ Tochigi",
"811356", "Iwanai\,\ Hokkaido",
"815736", "Nakatsugawa\,\ Gifu",
"817615", "Komatsu\,\ Ishikawa",
"812879", "Nasukarasuyama\,\ Tochigi",
"818514", "Ama\,\ Shimane",
"818563", "Masuda\,\ Shimane",
"81797", "Nishinomiya\,\ Hyogo",
"812544", "Shibata\,\ Niigata",
"817733", "Fukuchiyama\,\ Kyoto",
"817945", "Kakogawa\,\ Hyogo",
"81765", "Uozu\,\ Toyama",
"819826", "Hyuga\,\ Miyazaki",
"8162", "Osaka\,\ Osaka",
"819663", "Hitoyoshi\,\ Kumamoto",
"815767", "Gero\,\ Gifu",
"812549", "Tsugawa\,\ Niigata",
"818894", "Susaki\,\ Kochi",
"81493", "Higashimatsuyama\,\ Saitama",
"81792", "Himeji\,\ Hyogo",
"81439", "Kisarazu\,\ Chiba",
"812242", "Shiroishi\,\ Miyagi",
"812233", "Iwanuma\,\ Miyagi",
"817239", "Neyagawa\,\ Osaka",
"811396", "Esashi\,\ Hokkaido",
"812616", "Omachi\,\ Nagano",
"819808", "Yaeyama\ District\,\ Okinawa",
"811936", "Miyako\,\ Iwate",
"819546", "Kashima\,\ Saga",
"81142", "Date\,\ Hokkaido",
"8112396", "Kuriyama\,\ Hokkaido",
"811232", "Chitose\,\ Hokkaido",
"818693", "Oku\,\ Okayama",
"81126", "Iwamizawa\,\ Hokkaido",
"815585", "Shimoda\,\ Shizuoka",
"81564", "Okazaki\,\ Aichi",
"819828", "Takachiho\,\ Miyazaki",
"812837", "Sano\,\ Tochigi",
"8124197", "Yanaizu\,\ Fukushima",
"819593", "Oseto\,\ Nagasaki",
"817492", "Hikone\,\ Shiga",
"815983", "Matsusaka\,\ Mie",
"81429", "Tokorozawa\,\ Saitama",
"815738", "Nakatsugawa\,\ Gifu",
"817994", "Sumoto\,\ Hyogo",
"815752", "Sekigahara\,\ Gifu",
"8153968", "Hamamatsu\,\ Shizuoka",
"81591", "Tsu\,\ Mie",
"811332", "Tobetsu\,\ Hokkaido",
"812993", "Ishioka\,\ Ibaraki",
"8147950", "Yokaichiba\,\ Chiba",
"817959", "Sanda\,\ Hyogo",
"812583", "Nagaoka\,\ Niigata",
"811938", "Miyako\,\ Iwate",
"8153964", "Hamamatsu\,\ Shizuoka",
"812673", "Komoro\,\ Nagano",
"814703", "Tateyama\,\ Chiba",
"812618", "Omachi\,\ Nagano",
"812555", "Itoigawa\,\ Niigata",
"81988", "Naha\,\ Okinawa",
"817954", "Nishiwaki\,\ Hyogo",
"819738", "Kusu\,\ Oita",
"811952", "Ninohe\,\ Iwate",
"811398", "Kumaishi\,\ Hokkaido",
"817674", "Hakui\,\ Ishikawa",
"811582", "Monbetsu\,\ Hokkaido",
"81425", "Tachikawa\,\ Tokyo",
"811527", "Bihoro\,\ Hokkaido",
"812830", "Utsunomiya\,\ Tochigi",
"811454", "Mukawa\,\ Hokkaido",
"812782", "Numata\,\ Gunma",
"818685", "Tsuyama\,\ Okayama",
"819553", "Imari\,\ Saga",
"817452", "Yamatotakada\,\ Nara",
"818797", "Tonosho\,\ Kagawa",
"818973", "Niihama\,\ Ehime",
"8163", "Osaka\,\ Osaka",
"815995", "Ago\,\ Mie",
"819955", "Kajiki\,\ Kagoshima",
"819667", "Minamata\,\ Kumamoto",
"81928", "Fukuoka\,\ Fukuoka",
"815763", "Gero\,\ Gifu",
"811856", "Noshiro\,\ Akita",
"81827", "Iwakuni\,\ Yamaguchi",
"818567", "Tsuwano\,\ Shimane",
"814770", "Ichikawa\,\ Chiba",
"81779", "Ono\,\ Gifu",
"818245", "Miyoshi\,\ Hiroshima",
"8199343", "Kagoshima\,\ Kagoshima",
"817737", "Maizuru\,\ Kyoto",
"817704", "Tsuruga\,\ Fukui",
"812374", "Murayama\,\ Yamagata",
"81225", "Ishinomaki\,\ Miyagi",
"81949", "Nogata\,\ Fukuoka",
"81545", "Fuji\,\ Shizuoka",
"81485", "Kumagaya\,\ Saitama",
"819437", "Tanushimaru\,\ Fukuoka",
"812230", "Sendai\,\ Miyagi",
"818662", "Takahashi\,\ Okayama",
"812413", "Kitakata\,\ Fukushima",
"81489", "Soka\,\ Saitama",
"8186997", "Seto\,\ Okayama",
"81549", "Shizuoka\,\ Shizuoka",
"817463", "Yoshino\,\ Nara",
"811644", "Rumoi\,\ Hokkaido",
"812237", "Sendai\,\ Miyagi",
"8126172", "Omachi\,\ Nagano",
"812478", "Miharu\,\ Fukushima",
"817715", "Kameoka\,\ Kyoto",
"8188098", "Tosashimizu\,\ Kochi",
"81775", "Otsu\,\ Shiga",
"817912", "Aioi\,\ Hyogo",
"81822", "Hiroshima\,\ Hiroshima",
"812962", "Shimodate\,\ Ibaraki",
"8153976", "Hamamatsu\,\ Shizuoka",
"814777", "Funabashi\,\ Chiba",
"818299", "Hiroshima\,\ Hiroshima",
"812997", "Itako\,\ Ibaraki",
"814700", "Kamogawa\,\ Chiba",
"817475", "Shimonoseki\,\ Yamaguchi",
"8186999", "Seto\,\ Okayama",
"818552", "Hamada\,\ Shimane",
"812580", "Tokamachi\,\ Niigata",
"81744", "Yamatotakada\,\ Nara",
"818294", "Hatsukaichi\,\ Hiroshima",
"811975", "Mizusawa\,\ Iwate",
"819597", "Fukue\,\ Nagasaki",
"812572", "Kashiwazaki\,\ Niigata",
"811655", "Nayoro\,\ Hokkaido",
"811858", "Noshiro\,\ Akita",
"818697", "Bizen\,\ Okayama",
"81538", "Iwata\,\ Shizuoka",
"812833", "Utsunomiya\,\ Tochigi",
"81832", "Shimonoseki\,\ Yamaguchi",
"81863", "Tamano\,\ Okayama",
"818977", "Hakata\,\ Ehime",
"81938", "Kitakyushu\,\ Fukuoka",
"818657", "Kasaoka\,\ Okayama",
"811523", "Shari\,\ Hokkaido",
"81553", "Yamanashi\,\ Yamanashi",
"819725", "Saiki\,\ Oita",
"819557", "Karatsu\,\ Saga",
"818690", "Okayama\,\ Okayama",
"812476", "Miharu\,\ Fukushima",
"818592", "Yonago\,\ Tottori",
"818388", "Tamagawa\,\ Yamaguchi",
"81235", "Tsuruoka\,\ Yamagata",
"8168", "Osaka\,\ Osaka",
"812587", "Nagaoka\,\ Niigata",
"812957", "Daigo\,\ Ibaraki",
"817724", "Miyazu\,\ Kyoto",
"814291", "Hanno\,\ Saitama",
"812677", "Saku\,\ Nagano",
"815972", "Owase\,\ Mie",};
$areanames{ja} = {"815987", "三瀬谷",
"811975", "水沢",
"812572", "柏崎",
"811858", "能代",
"818697", "備前",
"819208", "対馬佐賀",
"81863", "玉野",
"81832", "下関",
"818299", "広島",
"812997", "潮来",
"812580", "十日町",
"818294", "廿日市",
"812476", "三春",
"812957", "大子",
"817724", "宮津",
"814707", "大原",
"814291", "飯能",
"818793", "三本松",
"817365", "和歌山橋本",
"818657", "笠岡",
"81225", "石巻",
"8188094", "窪川",
"819667", "水俣",
"81928", "福岡",
"815763", "下呂",
"811856", "能代",
"814770", "市川",
"812374", "村山",
"812962", "下館",
"818662", "高梁",
"817463", "吉野",
"811644", "留萌",
"812237", "仙台",
"812478", "三春",
"81229", "古川",
"8188098", "土佐清水",
"8153961", "天竜",
"817994", "洲本",
"815585", "下田",
"81126", "岩見沢",
"81564", "岡崎",
"812837", "佐野",
"819593", "大瀬戸",
"811527", "美幌",
"819553", "伊万里",
"819675", "熊本一の宮",
"818973", "新居浜",
"8163", "大阪",
"81964", "松橋",
"817959", "三田",
"812583", "長岡",
"811938", "宮古",
"812673", "小諸",
"81988", "那覇",
"812555", "糸魚川",
"819806", "沖縄宮古",
"817954", "西脇",
"811952", "二戸",
"818514", "海士",
"818563", "益田",
"817733", "福知山",
"81765", "魚津",
"819944", "鹿屋",
"819433", "八女",
"819949", "大根占",
"817615", "小松",
"814229", "武蔵野三鷹",
"817239", "寝屋川",
"819808", "八重山",
"814224", "武蔵野三鷹",
"812417", "会津山口",
"811936", "宮古",
"81142", "伊達",
"811232", "千歳",
"8112396", "栗山",
"818894", "須崎",
"81439", "木更津",
"812242", "白石",
"812653", "飯田",
"81273", "高崎",
"812797", "渋川",
"811972", "水沢",
"814288", "青梅",
"812575", "十日町",
"819573", "諫早",
"819683", "山鹿",
"81174", "蟹田",
"818953", "宇和島",
"811557", "十勝池田",
"81282", "栃木",
"81138", "函館",
"819787", "国東",
"81561", "瀬戸",
"811364", "倶知安",
"8198290", "延岡",
"817487", "水口",
"817362", "和歌山橋本",
"812693", "中野",
"81463", "平塚",
"81432", "千葉",
"81762", "金沢",
"814753", "茂原",
"8145", "横浜",
"811466", "えりも",
"81420", "所沢",
"814286", "相模原",
"8182941", "広島",
"818549", "石見大田",
"811562", "本別",
"8125480", "村上",
"812965", "下館",
"818544", "木次",
"818879", "室戸",
"819963", "川内",
"817357", "串本",
"818665", "高梁",
"818874", "安芸",
"814793", "銚子",
"81940", "宗像",
"818677", "新見",
"818587", "郡家",
"81835", "防府",
"812388", "長井",
"8128798", "大田原",
"815582", "下田",
"815398", "浜松",
"812977", "竜ケ崎",
"818366", "宇部",
"818833", "鴨島",
"819672", "熊本一の宮",
"811738", "鰺ケ沢",
"812489", "須賀川",
"811548", "弟子屈",
"81191", "一関",
"812484", "白河",
"811752", "むつ",
"812748", "富岡",
"812552", "上越",
"811955", "二戸",
"81839", "山口",
"81480", "久喜",
"811878", "大曲",
"811983", "花巻",
"81246", "いわき",
"819744", "三重",
"815396", "浜松",
"81222", "仙台",
"81848", "尾道",
"812386", "長井",
"817612", "小松",
"818464", "竹原",
"811876", "大曲",
"811235", "夕張",
"812746", "富岡",
"81936", "北九州",
"811546", "釧路",
"812245", "大河原",
"812567", "巻",
"81227", "仙台",
"811736", "五所川原",
"818368", "宇部",
"815744", "美濃加茂",
"818372", "長門",
"819823", "延岡",
"819666", "水俣",
"818698", "備前",
"811857", "能代",
"81252", "新潟",
"815988", "三瀬谷",
"81565", "豊田",
"811353", "余市",
"81969", "天草",
"81172", "弘前",
"815733", "恵那",
"812998", "潮来",
"819543", "武雄",
"81898", "今治",
"814708", "大原",
"818202", "柳井",
"81177", "青森",
"819733", "日田",
"812236", "仙台",
"811535", "厚岸",
"811393", "松前",
"81569", "半田",
"81965", "八代",
"81284", "足利",
"812613", "大町",
"812932", "高萩",
"812875", "大田原",
"817949", "加古川",
"811942", "岩泉",
"817944", "加古川",
"812545", "村上",
"81268", "上田",
"81183", "湯沢",
"811862", "鹿角",
"81434", "千葉",
"81764", "富山",
"812996", "潮来",
"817675", "七尾",
"818844", "阿南",
"815986", "松阪",
"818689", "岡山",
"815994", "阿児",
"819954", "加治木",
"818696", "備前",
"811455", "鵡川",
"8112398", "栗山",
"815999", "津",
"819668", "水俣",
"818684", "津山",
"818490", "尾道",
"815959", "亀山",
"818656", "笠岡",
"8112394", "夕張",
"815954", "上野",
"813", "東京",
"812477", "三春",
"812238", "仙台",
"812956", "常陸大宮",
"81478", "佐原",
"8199331", "鹿児島",
"814706", "大原",
"817714", "亀岡",
"8198299", "日向",
"812852", "小山",
"812838", "佐野",
"817705", "小浜",
"818244", "三次",
"812892", "宇都宮",
"818249", "東広島",
"811528", "美幌",
"818383", "萩",
"81728", "寝屋川",
"812416", "田島",
"811937", "宮古",
"8125487", "津川",
"81199", "盛岡",
"817902", "福崎",
"819724", "佐伯",
"812836", "佐野",
"8186698", "倉敷",
"818802", "窪川",
"8188096", "土佐清水",
"818493", "尾道",
"8125489", "津川",
"8182942", "広島",
"817474", "五条",
"8198297", "日向",
"812418", "会津山口",
"819807", "沖縄宮古",
"811526", "網走",
"811654", "名寄",
"81466", "藤沢",
"812917", "水戸",
"814287", "青梅",
"81192", "大船渡",
"8153962", "天竜",
"812798", "長野原",
"818375", "美祢",
"81834", "徳山",
"818263", "加計",
"811532", "根室",
"819788", "国東",
"812872", "大田原",
"812935", "水戸",
"812640", "長野",
"817356", "串本",
"811558", "広尾",
"818205", "柳井",
"817488", "水口",
"81878", "高松",
"811945", "久慈",
"812542", "新発田",
"819933", "指宿",
"817960", "八鹿",
"81276", "太田",
"811589", "興部",
"818473", "甲山",
"811865", "大館",
"817672", "羽咋",
"811584", "遠軽",
"812784", "沼田",
"811452", "早来",
"812796", "渋川",
"817454", "大和高田",
"812789", "前橋",
"817459", "大和榛原",
"817494", "彦根",
"81740", "今津",
"817486", "水口",
"811556", "帯広",
"815754", "関",
"819786", "杵築",
"8111", "札幌",
"81281", "宇都宮",
"812387", "長井",
"812643", "木曾福島",
"818588", "郡家",
"818678", "新見",
"812978", "竜ケ崎",
"81533", "豊橋",
"81562", "尾張横須賀",
"817963", "豊岡",
"817914", "相生",
"815397", "浜松",
"81958", "長崎",
"812855", "小山",
"818943", "八幡浜",
"81567", "津島",
"811547", "白糠",
"812566", "三条",
"812895", "宇都宮",
"811737", "鰺ケ沢",
"81962", "熊本",
"81933", "北九州",
"817702", "敦賀",
"81179", "三戸",
"811877", "大曲",
"81259", "佐渡",
"817905", "福崎",
"815564", "鰍沢青柳",
"812747", "富岡",
"818805", "土佐中村",
"812976", "竜ケ崎",
"818676", "久世",
"818594", "米子",
"818586", "倉吉",
"815979", "熊野",
"8199347", "鹿児島",
"8183767", "下関",
"815974", "尾鷲",
"819974", "屋久島",
"818559", "川本",
"819979", "徳之島",
"81144", "苫小牧",
"818554", "浜田",
"815362", "新城",
"818367", "宇部",
"817683", "輪島",
"812568", "巻",
"8186993", "備前",
"81243", "二本松",
"817476", "下市",
"817957", "丹波柏原",
"8112390", "夕張",
"81924", "福岡",
"811524", "網走",
"818248", "庄原",
"811656", "美深",
"819726", "臼杵",
"817682", "輪島",
"812834", "宇都宮",
"812839", "佐野",
"81793", "姫路",
"81492", "川越",
"81166", "旭川",
"815363", "新城",
"817997", "津名",
"8186995", "岡山瀬戸",
"817718", "園部",
"811658", "上川",
"818942", "八幡浜",
"818246", "三次",
"811632", "天塩",
"817962", "豊岡",
"812419", "田島",
"812414", "柳津",
"814227", "武蔵野三鷹",
"81877", "丸亀",
"812642", "木曾福島",
"81729", "八尾",
"81725", "和泉",
"819947", "志布志",
"818385", "萩",
"817716", "園部",
"817703", "敦賀",
"811372", "鹿部",
"819728", "臼杵",
"817948", "三木",
"818654", "鴨方",
"815956", "上野",
"811453", "早来",
"814709", "鴨川",
"817673", "羽咋",
"814704", "館山",
"818472", "甲山",
"817727", "峰山",
"81596", "伊勢",
"812994", "石岡",
"81823", "呉",
"818846", "丹生谷",
"818297", "廿日市",
"812999", "潮来",
"815984", "松阪",
"819956", "加治木",
"815996", "阿児",
"818694", "岡山",
"818686", "津山",
"812239", "仙台",
"81899", "松山",
"815735", "恵那",
"81952", "佐賀",
"81557", "伊東",
"812234", "仙台",
"811647", "羽幌",
"81568", "春日井",
"8167", "大阪",
"819825", "日向",
"815958", "亀山",
"818262", "加計",
"81584", "大垣",
"817946", "三木",
"819932", "指宿",
"818688", "美作",
"819664", "人吉",
"81984", "小林",
"8183766", "下関",
"815998", "阿児",
"811551", "十勝池田",
"812543", "新発田",
"812377", "寒河江",
"8182920", "廿日市",
"818848", "牟岐",
"811395", "江差",
"81552", "甲府",
"811533", "根室",
"819735", "日田",
"812873", "大田原",
"812615", "大町",
"819976", "名瀬",
"818556", "江津",
"81543", "静岡",
"818803", "土佐中村",
"812487", "須賀川",
"812979", "竜ケ崎",
"817685", "輪島",
"812974", "水海道",
"818674", "久世",
"818596", "米子",
"818584", "倉吉",
"818679", "新見",
"81559", "沼津",
"811635", "浜頓別",
"812564", "三条",
"817965", "豊岡",
"818945", "八幡浜",
"81178", "八戸",
"812853", "小山",
"815747", "美濃白川",
"812569", "巻",
"818558", "川本",
"812645", "木曾福島",
"815566", "身延",
"812930", "水戸",
"819978", "徳之島",
"81262", "長野",
"81233", "新庄",
"815978", "熊野",
"817903", "福崎",
"818467", "木江",
"818598", "根雨",
"818382", "萩",
"811375", "八雲",
"81581", "高富",
"819747", "竹田",
"812893", "宇都宮",
"81134", "小樽",
"817916", "竜野",
"81892", "久万",
"81555", "吉田",
"8125486", "津川",
"817496", "長浜",
"811367", "寿都",
"817484", "八日市",
"819789", "杵築",
"818475", "府中",
"811554", "帯広",
"815756", "郡上八幡",
"811863", "鹿角",
"8188099", "土佐清水",
"811336", "石狩",
"811559", "帯広",
"819784", "豊後高田",
"811586", "中湧別",
"81270", "伊勢崎",
"812786", "沼田",
"81495", "本庄",
"812794", "渋川",
"817456", "大和高田",
"812799", "長野原",
"815758", "郡上八幡",
"817354", "新宮",
"818877", "嶺北",
"811352", "余市",
"815732", "恵那",
"817498", "長浜",
"81727", "池田",
"818373", "長門",
"818547", "掛合",
"8198296", "日向",
"819822", "延岡",
"812890", "宇都宮",
"818265", "安芸吉田",
"8169", "大阪",
"811943", "岩泉",
"814297", "飯能",
"814701", "鴨川",
"81423", "国分寺",
"81722", "堺",
"817458", "大和榛原",
"81875", "観音寺",
"819935", "加世田",
"812788", "前橋",
"819732", "日田",
"811392", "木古内",
"81460", "小田原",
"811588", "興部",
"812612", "大町",
"812933", "高萩",
"8188097", "土佐清水",
"819542", "武雄",
"818203", "柳井",
"811939", "宮古",
"81886", "徳島",
"817958", "丹波柏原",
"819435", "八女",
"814226", "武蔵野三鷹",
"811934", "釜石",
"817613", "小松",
"818565", "益田",
"818896", "須崎",
"818247", "庄原",
"817735", "福知山",
"81438", "木更津",
"81474", "船橋",
"814775", "船橋",
"8188090", "窪川",
"819946", "鹿屋",
"8164", "大阪",
"817717", "園部",
"817998", "津名",
"815583", "下田",
"819595", "有川",
"819809", "八重山",
"81551", "韮崎",
"817238", "寝屋川",
"814228", "武蔵野三鷹",
"817956", "三田",
"819804", "名護",
"8183768", "下関",
"81989", "那覇",
"81585", "揖斐川",
"812585", "長岡",
"81985", "宮崎",
"812675", "佐久",
"817996", "津名",
"811982", "花巻",
"812553", "上越",
"819948", "志布志",
"811541", "弟子屈",
"8126177", "長野",
"819727", "臼杵",
"819555", "唐津",
"81288", "今市",
"811753", "むつ",
"818975", "新居浜",
"818832", "鴨島",
"819673", "熊本一の宮",
"8186992", "備前",
"815765", "下呂",
"8153963", "天竜",
"81925", "福岡",
"817947", "三木",
"817728", "峰山",
"81228", "築館",
"811646", "羽幌",
"814752", "茂原",
"819962", "川内",
"818298", "廿日市",
"814792", "銚子",
"817465", "吉野",
"81929", "福岡",
"811854", "男鹿",
"819204", "郷ノ浦",
"811563", "本別",
"812376", "寒河江",
"812474", "石川",
"812550", "安塚",
"818952", "宇和島",
"811648", "焼尻",
"819572", "諫早",
"814281", "相模原",
"812911", "鉾田",
"819682", "山鹿",
"817726", "峰山",
"811973", "水沢",
"812652", "飯田",
"815957", "上野",
"818795", "三本松",
"81593", "四日市",
"812378", "寒河江",
"815997", "阿児",
"819957", "加治木",
"81724", "岸和田貝塚",
"817363", "和歌山橋本",
"812692", "中野",
"818687", "美作",
"818847", "牟岐",
"818296", "広島",
"811874", "角館",
"818660", "岡山瀬戸",
"8125484", "村上",
"81922", "福岡",
"812744", "藤岡",
"819432", "八女",
"811544", "釧路",
"812488", "須賀川",
"81845", "因島",
"811734", "五所川原",
"811549", "釧路",
"818562", "益田",
"817732", "福知山",
"81930", "行橋",
"815746", "美濃加茂",
"81236", "山形",
"812243", "白石",
"819746", "竹田",
"815394", "浜松",
"817917", "竜野",
"81849", "福山",
"8147955", "八日市場",
"814772", "市川",
"815399", "天竜",
"812384", "米沢",
"81494", "秩父",
"8125488", "津川",
"811233", "千歳",
"81927", "福岡",
"812389", "米沢",
"818466", "木江",
"819592", "大瀬戸",
"818364", "宇部",
"815748", "美濃白川",
"81486", "浦和",
"818369", "宇部",
"81546", "静岡",
"81721", "富田林",
"8186697", "倉敷",
"81240", "磐城富岡",
"812486", "須賀川",
"8182943", "広島",
"819977", "瀬戸内",
"8198294", "延岡",
"818557", "川本",
"818597", "根雨",
"81776", "福井",
"81853", "出雲",
"811953", "二戸",
"812582", "長岡",
"815977", "熊野",
"812672", "小諸",
"8198298", "日向",
"818835", "脇町",
"81946", "甘木",
"812570", "小出",
"818972", "新居浜",
"819552", "伊万里",
"81471", "柏",
"818546", "掛合",
"815762", "下呂",
"814755", "東金",
"818876", "土佐山田",
"811464", "静内",
"81426", "八王子",
"818663", "総社",
"819965", "川内",
"814795", "銚子",
"814992", "伊豆大島",
"812963", "下館",
"814284", "立川",
"812914", "鉾田",
"814289", "青梅",
"8112399", "栗山",
"819575", "諫早",
"819685", "玉名",
"818878", "嶺北",
"811337", "石狩",
"815757", "郡上八幡",
"818955", "宇和島",
"8112397", "栗山",
"812655", "飯田",
"81987", "日南",
"818548", "石見大田",
"81582", "岐阜",
"811366", "寿都",
"817497", "長浜",
"812573", "柏崎",
"81743", "奈良",
"812787", "沼田",
"817457", "大和高田",
"81587", "一宮",
"818792", "三本松",
"814298", "飯能",
"812695", "中野",
"81554", "大月",
"811587", "中湧別",
"819597", "福江",
"811655", "名寄",
"81538", "磐田",
"812833", "宇都宮",
"819972", "種子島",
"814700", "鴨川",
"8186999", "岡山瀬戸",
"817475", "下市",
"818552", "浜田",
"81744", "大和高田",
"818592", "米子",
"818388", "田万川",
"81235", "鶴岡",
"8168", "大阪",
"812587", "長岡",
"812677", "佐久",
"815972", "尾鷲",
"818977", "伯方",
"81938", "北九州",
"81553", "山梨",
"811523", "斜里",
"819725", "佐伯",
"819557", "唐津",
"818690", "岡山",
"815562", "鰍沢青柳",
"81545", "富士",
"81949", "直方",
"81485", "熊谷",
"819437", "田主丸",
"812230", "仙台",
"81827", "岩国",
"818567", "津和野",
"81779", "大野",
"818245", "三次",
"8199343", "鹿児島",
"817704", "敦賀",
"817737", "舞鶴",
"81775", "大津",
"817912", "相生",
"81822", "広島",
"814777", "船橋",
"812413", "喜多方",
"81489", "草加",
"81549", "静岡",
"8188091", "窪川",
"8186997", "岡山瀬戸",
"817715", "亀岡",
"815738", "中津川",
"815752", "関",
"81591", "津",
"811332", "当別",
"812993", "石岡",
"818693", "邑久",
"815955", "上野",
"819828", "高千穂",
"8124197", "柳津",
"817492", "彦根",
"815983", "松阪",
"81429", "所沢",
"81425", "立川",
"812830", "宇都宮",
"812782", "沼田",
"811454", "鵡川",
"818685", "津山",
"817452", "大和高田",
"818797", "土庄",
"819955", "加治木",
"815995", "阿児",
"818845", "丹生谷",
"8147950", "八日市場",
"814703", "館山",
"812618", "大町",
"819738", "玖珠",
"811398", "熊石",
"811582", "紋別",
"817674", "羽咋",
"81797", "西宮",
"812544", "新発田",
"817945", "加古川",
"819826", "日向",
"819663", "人吉",
"8162", "大阪",
"815767", "下呂",
"812549", "津川",
"811534", "中標津",
"812874", "大田原",
"811539", "根室標津",
"811356", "岩内",
"812879", "烏山",
"815736", "中津川",
"812233", "岩沼",
"811396", "江差",
"812616", "大町",
"819546", "鹿島",
"81792", "姫路",
"81493", "東松山",
"817968", "浜坂",
"81885", "小松島",
"818391", "小郡",
"812973", "水海道",
"811638", "利尻礼文",
"811652", "士別",
"818948", "宇和",
"817472", "五条",
"812648", "長野",
"818555", "江津",
"81427", "相模原",
"818673", "福渡",
"819975", "名瀬",
"818583", "倉吉",
"81594", "桑名",
"811987", "遠野",
"81723", "堺",
"818595", "米子",
"819722", "佐伯",
"8186553", "倉敷",
"817686", "能都",
"8125483", "村上",
"811378", "今金",
"818804", "土佐中村",
"818837", "阿波池田",
"815565", "鰍沢青柳",
"812646", "長野",
"817904", "福崎",
"818946", "宇和",
"818242", "東広島",
"812899", "鹿沼",
"81280", "古河",
"81586", "一宮",
"811636", "北見枝幸",
"812894", "宇都宮",
"817966", "八鹿",
"812854", "小山",
"81986", "都城",
"812859", "小山",
"811376", "八雲",
"817688", "能都",
"817915", "相生",
"812563", "三条",
"8198293", "延岡",
"817712", "亀岡",
"815755", "関",
"818957", "御荘",
"819577", "島原",
"81926", "福岡",
"818476", "府中",
"819687", "玉名",
"817495", "長浜",
"815952", "上野",
"812657", "伊那",
"818268", "千代田",
"812793", "渋川",
"81188", "秋田",
"81263", "松本",
"812697", "飯山",
"817483", "八日市",
"819952", "大口",
"815992", "鳥羽",
"812785", "沼田",
"819938", "加世田",
"817455", "大和高田",
"818682", "津山",
"811864", "大館",
"81220", "迫",
"811585", "遠軽",
"819783", "豊後高田",
"8188095", "土佐清水",
"818842", "阿南",
"811869", "大館",
"81893", "大洲",
"811553", "帯広",
"81947", "田川",
"812560", "糸魚川",
"818266", "千代田",
"811944", "岩泉",
"81482", "川口",
"817942", "加古川",
"81542", "静岡",
"818478", "東城",
"818204", "柳井",
"812939", "水戸",
"814757", "東金",
"8112392", "夕張",
"812934", "高萩",
"817353", "新宮",
"819967", "出水",
"81473", "市川",
"814797", "八日市場",
"81825", "広島",
"819936", "加世田",
"818374", "長門",
"81942", "久留米",
"819232", "前原",
"81487", "浦和",
"81547", "島田",
"818895", "須崎",
"819598", "福江",
"817736", "舞鶴",
"815742", "美濃加茂",
"814225", "武蔵野三鷹",
"81992", "鹿児島",
"811933", "釜石",
"81592", "津",
"812678", "佐久",
"817614", "小松",
"812588", "長岡",
"81424", "武蔵野三鷹",
"819945", "鹿屋",
"818387", "田万川",
"818462", "竹原",
"819742", "三重",
"819558", "唐津",
"814776", "船橋",
"818978", "伯方",
"817955", "三田",
"819438", "田主丸",
"812554", "上越",
"81956", "佐世保",
"812559", "安塚",
"819596", "福江",
"8112391", "夕張",
"817738", "舞鶴",
"819674", "熊本一の宮",
"818568", "津和野",
"819679", "高森",
"811754", "むつ",
"812482", "白河",
"818976", "新居浜",
"815589", "修善寺大仁",
"815584", "下田",
"819556", "唐津",
"819803", "名護",
"81250", "新津",
"812586", "長岡",
"812676", "佐久",
"817995", "洲本",
"811645", "留萌",
"81167", "富良野",
"81975", "大分",
"812571", "六日町",
"818872", "室戸",
"819912", "中之島",
"815737", "中津川",
"811357", "岩内",
"811564", "上士幌",
"819827", "高千穂",
"818542", "安来",
"811853", "男鹿",
"815766", "下呂",
"81234", "酒田",
"814996", "八丈島",
"812375", "村山",
"818798", "土庄",
"817466", "十津川",
"811397", "奥尻",
"819737", "玖珠",
"81162", "稚内",
"81979", "中津",
"812617", "大町",
"819547", "鹿島",
"815768", "下呂",
"811362", "倶知安",
"81484", "川口",
"81544", "富士宮",
"8186691", "倉敷",
"817364", "和歌山橋本",
"817725", "宮津",
"81738", "御坊",
"81468", "横須賀",
"81774", "宇治",
"818295", "廿日市",
"8153974", "天竜",
"812473", "石川",
"817468", "上北山",
"81944", "瀬高",
"814998", "小笠原",
"811974", "水沢",
"818796", "土庄",
"81577", "高山",
"818947", "宇和",
"818892", "佐川",
"815745", "美濃加茂",
"8165", "大阪",
"812244", "白石",
"811637", "北見枝幸",
"815393", "浜松",
"817967", "八鹿",
"814222", "武蔵野三鷹",
"81583", "岐阜",
"812383", "米沢",
"811234", "千歳",
"812647", "長野",
"81742", "奈良",
"819942", "大根占",
"812743", "藤岡",
"81983", "高鍋",
"811873", "角館",
"814280", "立川",
"81572", "多治見",
"811733", "五所川原",
"818512", "西郷",
"818838", "阿波池田",
"811377", "八雲",
"811543", "釧路",
"81977", "別府",
"812551", "上越",
"817952", "西脇",
"811954", "二戸",
"812485", "白河",
"817687", "能都",
"81726", "茨木",
"8147957", "八日市場",
"818363", "宇部",
"818836", "脇町",
"817992", "洲本",
"811986", "遠野",
"819688", "玉名",
"818875", "土佐山田",
"818664", "高梁",
"819578", "島原",
"818958", "御荘",
"818669", "総社",
"811642", "石狩深川",
"814756", "東金",
"81298", "土浦",
"811463", "浦河",
"818545", "木次",
"8112395", "栗山",
"818267", "千代田",
"812658", "伊那",
"81857", "鳥取",
"812964", "下館",
"814283", "青梅",
"812913", "鉾田",
"819937", "加世田",
"81476", "成田",
"81852", "松江",
"812698", "飯山",
"812372", "村山",
"819966", "出水",
"814796", "八日市場",
"811365", "倶知安",
"818360", "小郡",
"812656", "伊那",
"81923", "福岡",
"818956", "宇和島",
"814758", "東金",
"819576", "島原",
"819686", "玉名",
"817722", "宮津",
"818477", "東城",
"81266", "諏訪",
"814798", "八日市場",
"819968", "出水",
"818292", "広島",
"812574", "柏崎",
"812696", "飯山",
"81896", "伊予三島",
"8188092", "窪川",
"812579", "小出",
"817723", "宮津",
"81465", "小田原",
"817677", "七尾",
"811457", "門別富川",
"811976", "北上",
"818794", "三本松",
"81143", "室蘭",
"817366", "岩出",
"818293", "廿日市",
"81739", "田辺",
"812475", "石川",
"817950", "三田",
"81244", "原町",
"814994", "三宅",
"811978", "北上",
"814282", "青梅",
"811855", "能代",
"819205", "厳原",
"817464", "吉野",
"81534", "浜松",
"811643", "石狩深川",
"811462", "浦河",
"819940", "志布志",
"8112393", "夕張",
"811537", "中標津",
"812877", "黒磯",
"81934", "北九州",
"8166", "大阪",
"817230", "寝屋川",
"81578", "神岡",
"814220", "国分寺",
"8144", "川崎",
"811566", "十勝清水",
"817368", "岩出",
"815769", "荘川",
"812547", "村上",
"812373", "村山",
"815764", "下呂",
"818974", "新居浜",
"815586", "下田",
"81550", "御殿場",
"819554", "伊万里",
"812589", "長岡",
"817953", "西脇",
"812679", "佐久",
"81176", "十和田",
"818290", "広島",
"817618", "加賀",
"8152", "名古屋",
"812584", "長岡",
"812674", "小諸",
"819805", "名護",
"812556", "糸魚川",
"817993", "洲本",
"815367", "設楽",
"819594", "有川",
"8186552", "倉敷",
"818362", "宇部",
"819676", "高森",
"81950", "平戸",
"8125482", "村上",
"819599", "大瀬戸",
"811756", "野辺地",
"812382", "米沢",
"814223", "武蔵野三鷹",
"817616", "小松",
"818397", "小郡",
"81862", "岡山",
"81833", "下松",
"81292", "水戸",
"815588", "修善寺大仁",
"815392", "浜松",
"818893", "佐川",
"811542", "釧路",
"811732", "五所川原",
"818564", "益田",
"817707", "小浜",
"817734", "福知山",
"8198292", "延岡",
"819678", "矢部",
"811935", "釜石",
"819943", "鹿屋",
"812742", "藤岡",
"819434", "八女",
"812558", "新井",
"811867", "鷹巣",
"811363", "倶知安",
"81566", "刈谷",
"81260", "阿南町",
"81124", "芦別",
"812576", "十日町",
"812694", "中野",
"812968", "笠間",
"812659", "伊那",
"812654", "飯田",
"812472", "石川",
"818954", "宇和島",
"819574", "諫早",
"818668", "井原",
"819684", "山鹿",
"81998", "鹿児島",
"818543", "安来",
"818377", "下関",
"811852", "男鹿",
"812578", "六日町",
"814285", "相模原",
"819964", "川内",
"818873", "安芸",
"819913", "硫黄島",
"814794", "銚子",
"819969", "中甑",
"811465", "静内",
"818666", "井原",
"818207", "久賀",
"814754", "茂原",
"812937", "水戸",
"811947", "久慈",
"81763", "福野",
"81433", "千葉",
"81462", "厚木",
"8175", "京都",
"81196", "盛岡",
"812483", "白河",
"818807", "宿毛",
"818834", "鴨島",
"811984", "花巻",
"814771", "市川",
"811238", "栗山",
"819802", "南大東",
"811956", "岩手",
"81467", "藤沢",
"81737", "湯浅",
"812248", "大河原",
"818365", "宇部",
"8186994", "岡山瀬戸",
"81272", "前橋",
"812385", "米沢",
"812857", "真岡",
"815743", "美濃加茂",
"815395", "浜松",
"811735", "五所川原",
"812246", "大河原",
"819743", "三重",
"811545", "釧路",
"81157", "北見",
"812897", "鹿沼",
"811958", "岩手",
"81277", "桐生",
"812745", "藤岡",
"818463", "竹原",
"81531", "田原",
"811932", "釜石",
"811875", "角館",
"817907", "播磨山崎",
"811236", "千歳",
"8186998", "岡山瀬戸",
"81184", "本荘",
"819734", "日田",
"811394", "松前",
"817678", "七尾",
"812614", "大町",
"819544", "武雄",
"812619", "大町",
"817943", "加古川",
"819665", "人吉",
"818240", "東広島",
"811567", "十勝清水",
"812546", "村上",
"819824", "延岡",
"819233", "前原",
"811536", "厚岸",
"812235", "仙台",
"812876", "黒磯",
"817352", "新宮",
"811354", "余市",
"815734", "恵那",
"815953", "上野",
"818695", "岡山瀬戸",
"811456", "門別富川",
"812792", "渋川",
"811977", "北上",
"815985", "松阪",
"812995", "石岡",
"817676", "七尾",
"812955", "常陸大宮",
"818843", "阿南",
"814705", "館山",
"811552", "帯広",
"812878", "烏山",
"811538", "根室標津",
"819782", "豊後高田",
"818683", "津山",
"818655", "鴨方",
"817367", "岩出",
"817482", "八日市",
"815993", "鳥羽",
"819953", "大口",
"8188093", "窪川",
"81734", "和歌山",
"81464", "厚木",
"81249", "郡山",
"818243", "東広島",
"81548", "榛原",
"81488", "浦和",
"817617", "加賀",
"818384", "萩",
"812415", "柳津",
"815368", "設楽",
"8178", "神戸",
"8198295", "日向",
"81948", "飯塚",
"817713", "亀岡",
"812562", "三条",
"81245", "福島",
"817940", "加古川",
"81778", "武生",
"817706", "小浜",
"818672", "福渡",
"818582", "倉吉",
"818398", "小郡",
"817473", "五条",
"81253", "新潟",
"81939", "北九州",
"811653", "士別",
"81535", "浜松",
"818680", "岡山",
"815587", "修善寺大仁",
"8153960", "天竜",
"812972", "水海道",
"812835", "佐野",
"819677", "矢部",
"819723", "佐伯",
"811525", "網走",
"81935", "北九州",
"811757", "野辺地",
"812557", "新井",
"8161", "大阪",
"8125485", "津川",
"815366", "設楽",
"81182", "横手",
"811868", "鷹巣",
"819934", "指宿",
"818376", "美祢",
"819662", "人吉",
"818264", "安芸吉田",
"811946", "久慈",
"812967", "笠間",
"818667", "井原",
"817355", "新宮",
"818206", "柳井",
"81828", "広島",
"812232", "岩沼",
"812936", "水戸",
"8125481", "村上",
"81242", "会津若松",
"817493", "彦根",
"815982", "松阪",
"81226", "気仙沼",
"812577", "六日町",
"818692", "邑久",
"8186996", "岡山瀬戸",
"818378", "下関",
"812795", "渋川",
"8153977", "天竜",
"815753", "関",
"811866", "鷹巣",
"811333", "当別",
"81563", "西尾",
"81532", "豊橋",
"812992", "石岡",
"81937", "北九州",
"812938", "水戸",
"81537", "掛川",
"8198291", "延岡",
"819785", "豊後高田",
"818479", "東城",
"811583", "紋別",
"818208", "久賀",
"81963", "熊本",
"811555", "帯広",
"81932", "北九州",
"814702", "館山",
"818474", "府中",
"814240", "国分寺",
"817485", "八日市",
"818652", "倉敷",
"812783", "沼田",
"817453", "大和高田",
"812856", "真岡",
"818808", "土佐清水",
"811374", "森",
"8199345", "鹿児島",
"81125", "滝川",
"815563", "鰍沢青柳",
"812649", "長野",
"81286", "宇都宮",
"812412", "喜多方",
"8124196", "柳津",
"81798", "西宮",
"812644", "木曾福島",
"811237", "栗山",
"817906", "播磨山崎",
"811639", "利尻礼文",
"818944", "八幡浜",
"817969", "浜坂",
"818949", "宇和",
"812247", "大河原",
"811634", "浜頓別",
"812896", "鹿沼",
"817964", "豊岡",
"812565", "三条",
"81436", "市原",
"81766", "高岡",
"818553", "浜田",
"819973", "種子島",
"818675", "久世",
"818585", "倉吉",
"81864", "倉敷",
"817684", "輪島",
"81294", "常陸太田",
"812832", "佐野",
"812780", "前橋",
"812975", "水海道",
"818806", "宿毛",
"81888", "高知",
"812858", "真岡",
"812898", "鹿沼",
"811522", "斜里",
"817908", "播磨山崎",
"815973", "尾鷲",
"818593", "米子",
"811957", "岩手",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;