# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::IN;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210921211832;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '575',
                  'pattern' => '(\\d{7})'
                },
                {
                  'format' => '$1',
                  'leading_digits' => '
            5(?:
              0|
              2(?:
                21|
                3
              )|
              3(?:
                0|
                3[23]
              )|
              616|
              717|
              8888
            )
          ',
                  'pattern' => '(\\d{8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1800',
                  'pattern' => '(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '140',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            11|
            2[02]|
            33|
            4[04]|
            79(?:
              [124-6]|
              3(?:
                [02-9]|
                1[0-24-9]
              )|
              7(?:
                1|
                9[1-6]
              )
            )|
            80(?:
              [2-4]|
              6[0-589]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              2[0-24]|
              3[0-25]|
              4[145]|
              [59][14]|
              6[1-9]|
              7[1257]|
              8[1-57-9]
            )|
            2(?:
              1[257]|
              3[013]|
              4[01]|
              5[0137]|
              6[058]|
              78|
              8[1568]|
              9[14]
            )|
            3(?:
              26|
              4[1-3]|
              5[34]|
              6[01489]|
              7[02-46]|
              8[159]
            )|
            4(?:
              1[36]|
              2[1-47]|
              3[15]|
              5[12]|
              6[0-26-9]|
              7[0-24-9]|
              8[013-57]|
              9[014-7]
            )|
            5(?:
              1[025]|
              22|
              [36][25]|
              4[28]|
              [578]1|
              9[15]
            )|
            6(?:
              12(?:
                [2-6]|
                7[0-8]
              )|
              74[2-7]
            )|
            7(?:
              (?:
                2[14]|
                5[15]
              )[2-6]|
              3171|
              61[346]|
              88(?:
                [2-7]|
                82
              )
            )|
            8(?:
              70[2-6]|
              84(?:
                [2356]|
                7[19]
              )|
              91(?:
                [3-6]|
                7[19]
              )
            )|
            73[134][2-6]|
            (?:
              74[47]|
              8(?:
                16|
                2[014]|
                3[126]|
                6[136]|
                7[78]|
                83
              )
            )(?:
              [2-6]|
              7[19]
            )|
            (?:
              1(?:
                29|
                60|
                8[06]
              )|
              261|
              552|
              6(?:
                [2-4]1|
                5[17]|
                6[13]|
                7(?:
                  1|
                  4[0189]
                )|
                80
              )|
              7(?:
                12|
                88[01]
              )
            )[2-7]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              [2-479]|
              5(?:
                [0236-9]|
                5[013-9]
              )
            )|
            [2-5]|
            6(?:
              2(?:
                84|
                95
              )|
              355|
              83
            )|
            73179|
            807(?:
              1|
              9[1-3]
            )|
            (?:
              1552|
              6(?:
                1[1358]|
                2[2457]|
                3[2-4]|
                4[235-7]|
                5[2-689]|
                6[24578]|
                7[235689]|
                8[124-6]
              )\\d|
              7(?:
                1(?:
                  [013-8]\\d|
                  9[6-9]
                )|
                28[6-8]|
                3(?:
                  2[0-49]|
                  9[2-57]
                )|
                4(?:
                  1[2-4]|
                  [29][0-7]|
                  3[0-8]|
                  [56]\\d|
                  8[0-24-7]
                )|
                5(?:
                  2[1-3]|
                  9[0-6]
                )|
                6(?:
                  0[5689]|
                  2[5-9]|
                  3[02-8]|
                  4\\d|
                  5[0-367]
                )|
                70[13-7]
              )
            )[2-7]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '[6-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{5})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6|
              8[06]0
            )
          ',
                  'pattern' => '(\\d{4})(\\d{2,4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '18',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          2717(?:
            [2-7]\\d|
            95
          )\\d{4}|
          (?:
            271[0-689]|
            782[0-6]
          )[2-7]\\d{5}|
          (?:
            170[24]|
            2(?:
              (?:
                [02][2-79]|
                90
              )\\d|
              80[13468]
            )|
            (?:
              3(?:
                23|
                80
              )|
              683|
              79[1-7]
            )\\d|
            4(?:
              20[24]|
              72[2-8]
            )|
            552[1-7]
          )\\d{6}|
          (?:
            11|
            33|
            4[04]|
            80
          )[2-7]\\d{7}|
          (?:
            342|
            674|
            788
          )(?:
            [0189][2-7]|
            [2-7]\\d
          )\\d{5}|
          (?:
            1(?:
              2[0-249]|
              3[0-25]|
              4[145]|
              [59][14]|
              6[014]|
              7[1257]|
              8[01346]
            )|
            2(?:
              1[257]|
              3[013]|
              4[01]|
              5[0137]|
              6[0158]|
              78|
              8[1568]|
              9[14]
            )|
            3(?:
              26|
              4[13]|
              5[34]|
              6[01489]|
              7[02-46]|
              8[159]
            )|
            4(?:
              1[36]|
              2[1-47]|
              3[15]|
              5[12]|
              6[0-26-9]|
              7[014-9]|
              8[013-57]|
              9[014-7]
            )|
            5(?:
              1[025]|
              22|
              [36][25]|
              4[28]|
              [578]1|
              9[15]
            )|
            6(?:
              12|
              [2-47]1|
              5[17]|
              6[13]|
              80
            )|
            7(?:
              12|
              2[14]|
              3[134]|
              4[47]|
              5[15]|
              [67]1
            )|
            8(?:
              16|
              2[014]|
              3[126]|
              6[136]|
              7[078]|
              8[34]|
              91
            )
          )[2-7]\\d{6}|
          (?:
            1(?:
              2[35-8]|
              3[346-9]|
              4[236-9]|
              [59][0235-9]|
              6[235-9]|
              7[34689]|
              8[257-9]
            )|
            2(?:
              1[134689]|
              3[24-8]|
              4[2-8]|
              5[25689]|
              6[2-4679]|
              7[3-79]|
              8[2-479]|
              9[235-9]
            )|
            3(?:
              01|
              1[79]|
              2[1245]|
              4[5-8]|
              5[125689]|
              6[235-7]|
              7[157-9]|
              8[2-46-8]
            )|
            4(?:
              1[14578]|
              2[5689]|
              3[2-467]|
              5[4-7]|
              6[35]|
              73|
              8[2689]|
              9[2389]
            )|
            5(?:
              [16][146-9]|
              2[14-8]|
              3[1346]|
              4[14-69]|
              5[46]|
              7[2-4]|
              8[2-8]|
              9[246]
            )|
            6(?:
              1[1358]|
              2[2457]|
              3[2-4]|
              4[235-7]|
              5[2-689]|
              6[24578]|
              7[235689]|
              8[124-6]
            )|
            7(?:
              1[013-9]|
              2[0235-9]|
              3[2679]|
              4[1-35689]|
              5[2-46-9]|
              [67][02-9]|
              8[013-7]|
              9[089]
            )|
            8(?:
              1[1357-9]|
              2[235-8]|
              3[03-57-9]|
              4[0-24-9]|
              5\\d|
              6[2457-9]|
              7[1-6]|
              8[1256]|
              9[2-4]
            )
          )\\d[2-7]\\d{5}
        ',
                'geographic' => '
          2717(?:
            [2-7]\\d|
            95
          )\\d{4}|
          (?:
            271[0-689]|
            782[0-6]
          )[2-7]\\d{5}|
          (?:
            170[24]|
            2(?:
              (?:
                [02][2-79]|
                90
              )\\d|
              80[13468]
            )|
            (?:
              3(?:
                23|
                80
              )|
              683|
              79[1-7]
            )\\d|
            4(?:
              20[24]|
              72[2-8]
            )|
            552[1-7]
          )\\d{6}|
          (?:
            11|
            33|
            4[04]|
            80
          )[2-7]\\d{7}|
          (?:
            342|
            674|
            788
          )(?:
            [0189][2-7]|
            [2-7]\\d
          )\\d{5}|
          (?:
            1(?:
              2[0-249]|
              3[0-25]|
              4[145]|
              [59][14]|
              6[014]|
              7[1257]|
              8[01346]
            )|
            2(?:
              1[257]|
              3[013]|
              4[01]|
              5[0137]|
              6[0158]|
              78|
              8[1568]|
              9[14]
            )|
            3(?:
              26|
              4[13]|
              5[34]|
              6[01489]|
              7[02-46]|
              8[159]
            )|
            4(?:
              1[36]|
              2[1-47]|
              3[15]|
              5[12]|
              6[0-26-9]|
              7[014-9]|
              8[013-57]|
              9[014-7]
            )|
            5(?:
              1[025]|
              22|
              [36][25]|
              4[28]|
              [578]1|
              9[15]
            )|
            6(?:
              12|
              [2-47]1|
              5[17]|
              6[13]|
              80
            )|
            7(?:
              12|
              2[14]|
              3[134]|
              4[47]|
              5[15]|
              [67]1
            )|
            8(?:
              16|
              2[014]|
              3[126]|
              6[136]|
              7[078]|
              8[34]|
              91
            )
          )[2-7]\\d{6}|
          (?:
            1(?:
              2[35-8]|
              3[346-9]|
              4[236-9]|
              [59][0235-9]|
              6[235-9]|
              7[34689]|
              8[257-9]
            )|
            2(?:
              1[134689]|
              3[24-8]|
              4[2-8]|
              5[25689]|
              6[2-4679]|
              7[3-79]|
              8[2-479]|
              9[235-9]
            )|
            3(?:
              01|
              1[79]|
              2[1245]|
              4[5-8]|
              5[125689]|
              6[235-7]|
              7[157-9]|
              8[2-46-8]
            )|
            4(?:
              1[14578]|
              2[5689]|
              3[2-467]|
              5[4-7]|
              6[35]|
              73|
              8[2689]|
              9[2389]
            )|
            5(?:
              [16][146-9]|
              2[14-8]|
              3[1346]|
              4[14-69]|
              5[46]|
              7[2-4]|
              8[2-8]|
              9[246]
            )|
            6(?:
              1[1358]|
              2[2457]|
              3[2-4]|
              4[235-7]|
              5[2-689]|
              6[24578]|
              7[235689]|
              8[124-6]
            )|
            7(?:
              1[013-9]|
              2[0235-9]|
              3[2679]|
              4[1-35689]|
              5[2-46-9]|
              [67][02-9]|
              8[013-7]|
              9[089]
            )|
            8(?:
              1[1357-9]|
              2[235-8]|
              3[03-57-9]|
              4[0-24-9]|
              5\\d|
              6[2457-9]|
              7[1-6]|
              8[1256]|
              9[2-4]
            )
          )\\d[2-7]\\d{5}
        ',
                'mobile' => '
          (?:
            61279|
            7(?:
              887[02-9]|
              9(?:
                313|
                79[07-9]
              )
            )|
            8(?:
              079[04-9]|
              (?:
                84|
                91
              )7[02-8]
            )
          )\\d{5}|
          (?:
            6(?:
              12|
              [2-47]1|
              5[17]|
              6[13]|
              80
            )[0189]|
            7(?:
              1(?:
                2[0189]|
                9[0-5]
              )|
              2(?:
                [14][017-9]|
                8[0-59]
              )|
              3(?:
                2[5-8]|
                [34][017-9]|
                9[016-9]
              )|
              4(?:
                1[015-9]|
                [29][89]|
                39|
                8[389]
              )|
              5(?:
                [15][017-9]|
                2[04-9]|
                9[7-9]
              )|
              6(?:
                0[0-47]|
                1[0-257-9]|
                2[0-4]|
                3[19]|
                5[4589]
              )|
              70[0289]|
              88[089]|
              97[02-8]
            )|
            8(?:
              0(?:
                6[67]|
                7[02-8]
              )|
              70[017-9]|
              84[01489]|
              91[0-289]
            )
          )\\d{6}|
          (?:
            7(?:
              31|
              4[47]
            )|
            8(?:
              16|
              2[014]|
              3[126]|
              6[136]|
              7[78]|
              83
            )
          )(?:
            [0189]\\d|
            7[02-8]
          )\\d{5}|
          (?:
            6(?:
              [09]\\d|
              1[04679]|
              2[03689]|
              3[05-9]|
              4[0489]|
              50|
              6[069]|
              7[07]|
              8[7-9]
            )|
            7(?:
              0\\d|
              2[0235-79]|
              3[05-8]|
              40|
              5[0346-8]|
              6[6-9]|
              7[1-9]|
              8[0-79]|
              9[089]
            )|
            8(?:
              0[01589]|
              1[0-57-9]|
              2[235-9]|
              3[03-57-9]|
              [45]\\d|
              6[02457-9]|
              7[1-69]|
              8[0-25-9]|
              9[02-9]
            )|
            9\\d\\d
          )\\d{7}|
          (?:
            6(?:
              (?:
                1[1358]|
                2[2457]|
                3[2-4]|
                4[235-7]|
                5[2-689]|
                6[24578]|
                8[124-6]
              )\\d|
              7(?:
                [235689]\\d|
                4[0189]
              )
            )|
            7(?:
              1(?:
                [013-8]\\d|
                9[6-9]
              )|
              28[6-8]|
              3(?:
                2[0-49]|
                9[2-5]
              )|
              4(?:
                1[2-4]|
                [29][0-7]|
                3[0-8]|
                [56]\\d|
                8[0-24-7]
              )|
              5(?:
                2[1-3]|
                9[0-6]
              )|
              6(?:
                0[5689]|
                2[5-9]|
                3[02-8]|
                4\\d|
                5[0-367]
              )|
              70[13-7]|
              881
            )
          )[0189]\\d{5}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(1860\\d{7})|(186[12]\\d{9})|(140\\d{7})',
                'toll_free' => '
          000800\\d{7}|
          1(?:
            600\\d{6}|
            80(?:
              0\\d{4,9}|
              3\\d{9}
            )
          )
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"9166526", "Balangir\,\ Odisha",
"9168462", "Baliguda\,\ Odisha",
"912363", "Sawantwadi\,\ Maharashtra",
"9164202", "Amarpur\,\ Bihar",
"9166837", "Padmapur\,\ Odisha",
"918683", "Hazurnagar\,\ Andhra\ Pradesh",
"918113", "Channapatna\,\ Karnataka",
"9167975", "Jashipur\,\ Odisha",
"9163225", "Wazirganj\,\ Bihar",
"9164275", "Kathikund\,\ Bihar",
"9166752", "T\.Rampur\,\ Odisha",
"9181738", "Sakleshpur\,\ Karnataka",
"913218", "Canning\,\ West\ Bengal",
"9172886", "Bhikangaon\,\ Madhya\ Pradesh",
"913623", "Barama\,\ Assam",
"91423", "Udhagamandalam\,\ Tamil\ Nadu",
"9161552", "Ekma\,\ Bihar",
"9181737", "Sakleshpur\,\ Karnataka",
"9174664", "Bonli\,\ Rajasthan",
"9166427", "Kuchinda\,\ Odisha",
"9171744", "Mul\,\ Maharashtra",
"918642", "Guntur\ Palnad\/Macherala\,\ Andhra\ Pradesh",
"914149", "Ulundurpet\,\ Tamil\ Nadu",
"914368", "Karaikal\,\ Tamil\ Nadu",
"912808", "Sumrasar\,\ Gujarat",
"917122", "Nagpur\,\ Maharashtra",
"9176516", "Jaisinghnagar\,\ Madhya\ Pradesh",
"9166482", "Patnagarh\,\ Odisha",
"9167284", "Jajapur\ Town\,\ Odisha",
"9167572", "Daspalla\,\ Odisha",
"91512", "Kanpur\,\ Uttar\ Pradesh",
"9171874", "Goregaon\,\ Maharashtra",
"9173215", "Sanwer\,\ Madhya\ Pradesh",
"9167637", "Athmallik\,\ Odisha",
"9176418", "Niwas\,\ Madhya\ Pradesh",
"9164762", "Madhepura\,\ Bihar",
"9171716", "Gond\ Pipri\,\ Maharashtra",
"913671", "Diphu\,\ Assam",
"9176417", "Niwas\,\ Madhya\ Pradesh",
"917585", "Rehli\,\ Madhya\ Pradesh",
"9181520", "Kolar\,\ Karnatak",
"9176241", "Sihora\,\ Madhya\ Pradesh",
"9162235", "Motipur\,\ Bihar",
"917235", "Pandharkawada\,\ Maharashtra",
"9161885", "Rohtas\,\ Bihar",
"9176404", "Shahpur\,\ Madhya\ Pradesh",
"9174902", "Pohari\,\ Madhya\ Pradesh",
"9174142", "Jaora\,\ Madhya\ Pradesh",
"9173925", "Jhabua\,\ Madhya\ Pradesh",
"9171696", "Batkakhapa\,\ Madhya\ Pradesh",
"913669", "Abhayapuri\,\ Assam",
"912624", "Fortsongadh\,\ Gujarat",
"9174975", "Khaniadhana\,\ Madhya\ Pradesh",
"913863", "Kiphire\,\ Nagaland",
"9176369", "Baihar\,\ Madhya\ Pradesh",
"9166783", "Nowparatan\,\ Odisha",
"9164362", "Sahibganj\,\ Bihar",
"9171316", "Sironcha\,\ Maharashtra",
"9161583", "Sonepur\,\ Bihar",
"9171004", "Kuhi\,\ Maharashtra",
"912329", "Shahuwadi\/Malakapur\,\ Maharashtra",
"9175950", "Nateran\,\ Madhya\ Pradesh",
"914290", "Omalur\,\ Tamil\ Nadu",
"9167664", "Keonjhar\,\ Odisha",
"914554", "Cumbum\,\ Tamil\ Nadu",
"914326", "Musiri\,\ Tamil\ Nadu",
"9168165", "Mohana\,\ Odisha",
"911396", "Jansath\/Khatauli\,\ Uttar\ Pradesh",
"9166453", "Jharsuguda\,\ Odisha",
"9162715", "Benipatti\,\ Bihar",
"9165513", "Barkagaon\,\ Bihar",
"9174505", "Sangod\,\ Rajasthan",
"9175386", "Ambah\,\ Madhya\ Pradesh",
"9167297", "Pattamundai\,\ Odisha",
"918729", "Manthani\,\ Andhra\ Pradesh",
"9174572", "Mangrol\,\ Rajasthan",
"918499", "Podili\,\ Andhra\ Pradesh",
"911276", "Bahadurgarh\,\ Haryana",
"9178081", "\`",
"914565", "Karaikudi\,\ Tamil\ Nadu",
"913789", "Huri\,\ Arunachal\ Pradesh",
"9174359", "Gangdhar\,\ Rajasthan",
"911586", "Nawa\/Kuchamancity\,\ Rajasthan",
"91427", "Salem\,\ Tamil\ Nadu",
"914257", "Kangeyam\,\ Tamil\ Nadu",
"9181764", "Cannarayapatna\,\ Karnataka",
"9161326", "Barh\,\ Bihar",
"9174637", "Gangapur\,\ Rajasthan",
"9171344", "Bhamregadh\,\ Maharashtra",
"91132", "Saharanpur\,\ Uttar\ Pradesh",
"9174803", "Goharganj\,\ Madhya\ Pradesh",
"9174638", "Gangapur\,\ Rajasthan",
"9165815", "Bhandaria\,\ Bihar",
"9164277", "Kathikund\,\ Bihar",
"912983", "Barmer\/Gudda\,\ Rajasthan",
"9163227", "Wazirganj\,\ Bihar",
"9161894", "Bhabhua\,\ Bihar",
"918322", "Goa",
"9167977", "Jashipur\,\ Odisha",
"9174140", "Jaora\,\ Madhya\ Pradesh",
"91206", "Pune\,\ Maharashtra",
"9166835", "Padmapur\,\ Odisha",
"9174900", "Pohari\,\ Madhya\ Pradesh",
"913592", "Gangtok\,\ West\ Bengal",
"918231", "Malavalli\,\ Karnataka",
"917746", "Manpur\,\ Madhya\ Pradesh",
"91341", "Asansol\,\ West\ Bengal",
"9174514", "Atru\,\ Rajasthan",
"9174656", "Sapotra\,\ Rajasthan",
"9175952", "Nateran\,\ Madhya\ Pradesh",
"915872", "Kheri\,\ Uttar\ Pradesh",
"9165283", "Khunti\,\ Bihar",
"912433", "Gangapur\,\ Maharashtra",
"9166425", "Kuchinda\,\ Odisha",
"9181735", "Sakleshpur\,\ Karnataka",
"911259", "Kosli\,\ Haryana",
"9168593", "Motu\,\ Odisha",
"912350", "Madangad\,\ Maharashtra",
"9166533", "Dunguripali\,\ Odisha",
"913844", "Hailakandi\,\ Assam",
"912587", "Amalner\,\ Maharashtra",
"9174570", "Mangrol\,\ Rajasthan",
"9162264", "Sitamarhi\,\ Bihar",
"9173217", "Sanwer\,\ Madhya\ Pradesh",
"917857", "Bacheli\,\ Madhya\ Pradesh",
"915442", "Mirzapur\,\ Uttar\ Pradesh",
"913474", "Bethuadahari\,\ West\ Bengal",
"9173218", "Sanwer\,\ Madhya\ Pradesh",
"9164524", "Katihar\,\ Bihar",
"91799", "Ahmedabad\ Local\,\ Gujarat",
"9176415", "Niwas\,\ Madhya\ Pradesh",
"9167406", "Bhubaneshwar\,\ Odisha",
"918195", "Challakere\,\ Karnataka",
"91251", "Kalyan\,\ Maharashtra",
"91225", "Mumbai",
"9174546", "Chhipaborad\,\ Rajasthan",
"9173953", "Sondhwa\,\ Madhya\ Pradesh",
"9167635", "Athmallik\,\ Odisha",
"9163282", "Daudnagar\,\ Bihar",
"912843", "Gariadhar\,\ Gujarat",
"9164592", "Thakurganj\,\ Bihar",
"9174977", "Khaniadhana\,\ Madhya\ Pradesh",
"911745", "Nilokheri\,\ Haryana",
"9173927", "Jhabua\,\ Madhya\ Pradesh",
"912649", "Dediapada\,\ Gujarat",
"913242", "Bankura\,\ West\ Bengal",
"918924", "Anakapalle\,\ Andhra\ Pradesh",
"9174978", "Khaniadhana\,\ Madhya\ Pradesh",
"915274", "Tanda\/Baskhari\,\ Uttar\ Pradesh",
"9173928", "Jhabua\,\ Madhya\ Pradesh",
"9161887", "Rohtas\,\ Bihar",
"918223", "K\.R\.Nagar\,\ Karnataka",
"9162237", "Motipur\,\ Bihar",
"918188", "Honnali\,\ Karnataka",
"918618", "Nellore\,\ Andhra\ Pradesh",
"912421", "Jamkhed\,\ Maharashtra",
"912344", "Jath\,\ Maharashtra",
"917203", "Babhulgaon\,\ Maharashtra",
"9165252", "Simdega\,\ Bihar",
"9171812", "Lakhandur\,\ Maharashtra",
"9167656", "Palla\ Hara\,\ Odisha",
"9176286", "Karpa\,\ Madhya\ Pradesh",
"912791", "Babra\,\ Gujarat",
"9173204", "Pandhana\,\ Madhya\ Pradesh",
"9133", "Kolkata\,\ West\ Bengal",
"918744", "Kothagudem\,\ Andhra\ Pradesh",
"9174508", "Sangod\,\ Rajasthan",
"918391", "Kudligi\,\ Karnataka",
"91164", "Bhatinda\,\ Punjab",
"915921", "Bilari\,\ Uttar\ Pradesh",
"9167295", "Pattamundai\,\ Odisha",
"9174507", "Sangod\,\ Rajasthan",
"911607", "Kharar\,\ Punjab",
"9162717", "Benipatti\,\ Bihar",
"913521", "Gangarampur\,\ West\ Bengal",
"9166856", "Sohela\,\ Odisha",
"9161156", "Danapur\,\ Bihar",
"918816", "Bhimavaram\,\ Andhra\ Pradesh",
"9174129", "Ratlam\,\ Madhya\ Pradesh",
"9165663", "Japla\,\ Bihar",
"9168167", "Mohana\,\ Odisha",
"9165817", "Bhandaria\,\ Bihar",
"918581", "Punganur\,\ Andhra\ Pradesh",
"9175269", "Ghatigaon\,\ Madhya\ Pradesh",
"915832", "Badaun\,\ Uttar\ Pradesh",
"912473", "Kallam\,\ Maharashtra",
"9161822", "Arrah\,\ Bihar",
"9174635", "Gangapur\,\ Rajasthan",
"9181756", "Holenarasipur\,\ Karnataka",
"9163253", "Pakribarwan\,\ Bihar",
"911805", "Panipat\,\ Haryana",
"918830", "Rajahmundri\,\ Andhra\ Pradesh",
"915546", "Harraiya\,\ Uttar\ Pradesh",
"917291", "Manawar\,\ Madhya\ Pradesh",
"9166515", "Birmaharajpur\,\ Odisha",
"917371", "Sarangpur\,\ Madhya\ Pradesh",
"912712", "Gandhi\ Nagar\,\ Gujarat",
"912951", "Bhim\,\ Rajasthan",
"918666", "Vijayawada\,\ Andhra\ Pradesh",
"9165455", "Mandu\,\ Bihar",
"912596", "Pachora\,\ Maharashtra",
"9165564", "Tisri\,\ Bihar",
"9166813", "Jujumura\,\ Odisha",
"9161113", "Hilsa\,\ Bihar",
"9168622", "Gudari\,\ Odisha",
"917916", "Ahmedabad\ Local\,\ Gujarat",
"911464", "Rajgarh\,\ Rajasthan",
"918454", "Gajwel\,\ Andhra\ Pradesh",
"9164547", "Purnea\,\ Bihar",
"911858", "Ajnala\,\ Punjab",
"9173226", "Depalpur\,\ Madhya\ Pradesh",
"9176433", "Bijadandi\,\ Madhya\ Pradesh",
"9162583", "Areraj\,\ Bihar",
"9174276", "Bhanpura\,\ Madhya\ Pradesh",
"9176525", "Shahdol\,\ Madhya\ Pradesh",
"914114", "Chengalpattu\,\ Tamil\ Nadu",
"9167613", "Chhendipada\,\ Odisha",
"911529", "Lunkaransar\/Kanholi\,\ Rajasthan",
"9176332", "Waraseoni\,\ Madhya\ Pradesh",
"918868", "Yeleswaram\,\ Andhra\ Pradesh",
"9163244", "Nawada\,\ Bihar",
"9168687", "Nandapur\,\ Odisha",
"91342", "Burdwan\,\ West\ Bengal",
"9171123", "Katol\,\ Maharashtra",
"9174919", "Narwar\,\ Madhya\ Pradesh",
"912162", "Satara\,\ Maharashtra",
"918465", "Yellareddy\,\ Andhra\ Pradesh",
"9167867", "Chandbali\,\ Odisha",
"918786", "Karimnagar\,\ Andhra\ Pradesh",
"9171033", "Butibori\,\ Maharashtra",
"918312", "Belgaum\,\ Karnataka",
"9167492", "Bhubaneshwar\,\ Odisha",
"9174240", "Malhargarh\,\ Madhya\ Pradesh",
"915451", "Mariyahu\,\ Uttar\ Pradesh",
"918417", "Chevella\,\ Andhra\ Pradesh",
"9182204", "Gundlupet\,\ Karnataka",
"9171725", "Chandrapur\,\ Maharashtra",
"917824", "Bemetara\,\ Madhya\ Pradesh",
"9165385", "Torpa\,\ Bihar",
"9171677", "Amarwada\,\ Madhya\ Pradesh",
"9166222", "Sundargarh\,\ Odisha",
"9171157", "Mouda\,\ Maharashtra",
"917541", "Isagarh\,\ Madhya\ Pradesh",
"917655", "Birsinghpur\,\ Madhya\ Pradesh",
"9164623", "Dhamdaha\,\ Bihar",
"917806", "Chitrangi\,\ Madhya\ Pradesh",
"9172874", "Gogaon\,\ Madhya\ Pradesh",
"91522", "Lucknow\,\ Uttar\ Pradesh",
"9174229", "Mandsaur\,\ Madhya\ Pradesh",
"918440", "Nimburga\,\ Karnataka",
"913511", "Bubulchandi\,\ West\ Bengal",
"917784", "Parasgaon\,\ Madhya\ Pradesh",
"9171532", "Hinganghat\,\ Maharashtra",
"913251", "Adra\,\ West\ Bengal",
"9171325", "Gadchiroli\,\ Maharashtra",
"9167276", "Kendrapara\,\ Odisha",
"917664", "Hanumana\,\ Madhya\ Pradesh",
"9162552", "Raxaul\,\ Bihar",
"9163485", "Mallehpur\,\ Bihar",
"9168694", "Papadhandi\,\ Odisha",
"9165436", "Barhi\,\ Bihar",
"9165672", "Barwadih\,\ Bihar",
"917222", "Chandurrly\,\ Maharashtra",
"917777", "Pratappur\,\ Madhya\ Pradesh",
"9162726", "Darbhanga\,\ Bihar",
"917608", "Bijawar\,\ Madhya\ Pradesh",
"9174613", "Mahuwa\,\ Rajasthan",
"9173944", "Alirajpur\,\ Madhya\ Pradesh",
"91413", "Pondicherry\,\ Tamil\ Nadu",
"9165605", "Patan\,\ Bihar",
"9174867", "Bareli\,\ Madhya\ Pradesh",
"911563", "Sardarshahar\/Jaitsisar\,\ Rajasthan",
"918213", "Mysore\,\ Karnataka",
"918628", "Chejerla\,\ Andhra\ Pradesh",
"917369", "Tarana\,\ Madhya\ Pradesh",
"9165826", "Chaibasa\,\ Bihar",
"914637", "Valliyoor\,\ Tamil\ Nadu",
"9174868", "Bareli\,\ Madhya\ Pradesh",
"918202", "Udupi\,\ Karnataka",
"918914", "Visakhapatnam\,\ Andhra\ Pradesh",
"9165537", "Ramgarh\,\ Bihar",
"911334", "Roorkee\/Haridwar\,\ Uttarakhand",
"9165457", "Mandu\,\ Bihar",
"918545", "Amangallu\,\ Andhra\ Pradesh",
"917479", "Bundi\,\ Rajasthan",
"912966", "Sagwara\,\ Rajasthan",
"9165394", "Bolwa\,\ Bihar",
"91120", "Ghaziabad\/Dadri\,\ Uttar\ Pradesh",
"9166517", "Birmaharajpur\,\ Odisha",
"9164296", "Kahalgaon\,\ Bihar",
"9168473", "G\.Udayagiri\,\ Odisha",
"9171782", "Sinderwahi\,\ Maharashtra",
"912735", "Deodar\,\ Gujarat",
"9164545", "Purnea\,\ Bihar",
"911639", "Faridakot\,\ Punjab",
"9176274", "Manpur\,\ Madhya\ Pradesh",
"9165614", "Garhwa\,\ Bihar",
"917762", "Raigarh\,\ Madhya\ Pradesh",
"9171964", "Arjuni\ Morgaon\,\ Maharashtra",
"9162432", "Begusarai\,\ Bihar",
"9166416", "Deodgarh\,\ Odisha",
"9167563", "Balugaon\,\ Odisha",
"9168685", "Nandapur\,\ Odisha",
"917682", "Chhatarpur\,\ Madhya\ Pradesh",
"912137", "Nahavara\,\ Maharashtra",
"918335", "Ramdurg\,\ Karnataka",
"914931", "Nilambur\,\ Kerala",
"911972", "Hamirpur\,\ Himachal\ Pradesh",
"9171452", "Chicholi\,\ Madhya\ Pradesh",
"9163494", "Jhajha\,\ Bihar",
"9171026", "Parseoni\,\ Maharashtra",
"9176527", "Shahdol\,\ Madhya\ Pradesh",
"9171353", "Chamorshi\,\ Maharashtra",
"913228", "Tamluk\,\ West\ Bengal",
"9176528", "Shahdol\,\ Madhya\ Pradesh",
"9171136", "Saoner\,\ Maharashtra",
"918578", "Srikalahasthi\,\ Andhra\ Pradesh",
"915174", "Jhansi\,\ Uttar\ Pradesh",
"9171727", "Chandrapur\,\ Maharashtra",
"9166444", "Rairakhol\,\ Odisha",
"915466", "Sagri\,\ Uttar\ Pradesh",
"9167242", "Jagatsinghpur\,\ Odisha",
"911781", "Rohru\,\ Himachal\ Pradesh",
"918288", "Bailhongal\,\ Karnataka",
"9165646", "Nagarutari\,\ Bihar",
"911892", "Kangra\/Dharamsala\,\ Himachal\ Pradesh",
"917849", "Baderajpur\,\ Madhya\ Pradesh",
"914822", "Palai\,\ Kerala",
"9167865", "Chandbali\,\ Odisha",
"9173233", "Punasa\,\ Madhya\ Pradesh",
"9176426", "Mandla\,\ Madhya\ Pradesh",
"9164773", "Triveniganj\,\ Bihar",
"91215", "Navi\ Mumbai\/Turbhe\,\ Maharashtra",
"911932", "Anantnag\,\ Jammu\ And\ Kashmir",
"918375", "Haveri\,\ Karnataka",
"9171155", "Mouda\,\ Maharashtra",
"9171602", "Jamai\,\ Madhya\ Pradesh",
"91131", "Muzaffarnagar\,\ Uttar\ Pradesh",
"9176479", "Ghughari\,\ Madhya\ Pradesh",
"9171753", "Bhadrawati\,\ Maharashtra",
"9171675", "Amarwada\,\ Madhya\ Pradesh",
"918538", "Manvi\,\ Karnataka",
"9165387", "Torpa\,\ Bihar",
"9165932", "Manoharpur\,\ Bihar",
"9171327", "Gadchiroli\,\ Maharashtra",
"916315", "Gaya\,\ Bihar",
"915825", "Nawabganj\,\ Uttar\ Pradesh",
"911482", "Bhilwara\,\ Rajasthan",
"918719", "Mahabubbad\,\ Andhra\ Pradesh",
"914891", "Amini\,\ Lakshadweep",
"911821", "Nakodar\,\ Punjab",
"9163422", "H\.Kharagpur\,\ Bihar",
"9163323", "Nabinagar\,\ Bihar",
"9164373", "Mahagama\,\ Bihar",
"912748", "Dhanera\,\ Gujarat",
"9165607", "Patan\,\ Bihar",
"9168103", "Khalikote\,\ Odisha",
"911374", "Bhatwari\/Uttarkashi\,\ Uttarakhand",
"918560", "Jammalamadugu\,\ Andhra\ Pradesh",
"9176330", "Waraseoni\,\ Madhya\ Pradesh",
"9177059", "Kurud\,\ Madhya\ Pradesh",
"9171483", "Prabha\ Pattan\,\ Madhya\ Pradesh",
"914923", "Koduvayur\,\ Kerala",
"9174563", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"9165833", "Kharsawa\,\ Bihar",
"915640", "Kaman\,\ Rajasthan",
"9171382", "Dhanora\,\ Maharashtra",
"9163487", "Mallehpur\,\ Bihar",
"9165535", "Ramgarh\,\ Bihar",
"918131", "Gubbi\,\ Karnataka",
"912184", "Barsi\,\ Maharashtra",
"912775", "Khedbrahma\,\ Gujarat",
"9162733", "Jhajharpur\,\ Bihar",
"9165322", "Giridih\,\ Bihar",
"9174242", "Malhargarh\,\ Madhya\ Pradesh",
"911679", "Barnala\,\ Punjab",
"912928", "Shergarh\/Deechu\,\ Rajasthan",
"9165423", "Bokaro\,\ Bihar",
"9174865", "Bareli\,\ Madhya\ Pradesh",
"912690", "Balasinor\,\ Gujarat",
"917124", "Nagpur\,\ Maharashtra",
"9174350", "Gangdhar\,\ Rajasthan",
"912929", "Shergarh\/Balesar\,\ Rajasthan",
"917835", "Bharathpur\,\ Madhya\ Pradesh",
"9171724", "Chandrapur\,\ Maharashtra",
"918644", "Tenali\,\ Andhra\ Pradesh",
"9182205", "Gundlupet\,\ Karnataka",
"9166447", "Rairakhol\,\ Odisha",
"9165962", "Noamundi\,\ Bihar",
"9164666", "Kishanganj\,\ Bihar",
"9171612", "Parasia\,\ Madhya\ Pradesh",
"915564", "Padrauna\,\ Uttar\ Pradesh",
"9163497", "Jhajha\,\ Bihar",
"9176524", "Shahdol\,\ Madhya\ Pradesh",
"9163245", "Nawada\,\ Bihar",
"9171392", "Kurkheda\,\ Maharashtra",
"916745", "Bhubaneshwar\,\ Odisha",
"914890", "Bitra\,\ Lakshadweep",
"9171493", "Tamia\,\ Madhya\ Pradesh",
"9166546", "Sonapur\,\ Odisha",
"9176277", "Manpur\,\ Madhya\ Pradesh",
"912749", "Danta\,\ Gujarat",
"915641", "Deeg\,\ Rajasthan",
"9165565", "Tisri\,\ Bihar",
"9176278", "Manpur\,\ Madhya\ Pradesh",
"9175959", "Nateran\,\ Madhya\ Pradesh",
"918718", "Narasampet\,\ Andhra\ Pradesh",
"9162763", "Madhubani\,\ Bihar",
"9171967", "Arjuni\ Morgaon\,\ Maharashtra",
"9168113", "Chhatrapur\,\ Odisha",
"9165617", "Garhwa\,\ Bihar",
"918561", "Rayachoti\,\ Andhra\ Pradesh",
"912691", "Kapad\ Wanj\,\ Gujarat",
"91487", "Thrissur\,\ Kerala",
"9166514", "Birmaharajpur\,\ Odisha",
"9165863", "Chainpur\,\ Bihar",
"918539", "Koppal\,\ Karnataka",
"9165397", "Bolwa\,\ Bihar",
"9165454", "Mandu\,\ Bihar",
"9161876", "Mohania\,\ Bihar",
"9176360", "Baihar\,\ Madhya\ Pradesh",
"911996", "Doda\,\ Jammu\ And\ Kashmir",
"914926", "Shoranur\,\ Kerala",
"9174533", "Baran\,\ Rajasthan",
"914552", "Usilampatti\,\ Tamil\ Nadu",
"9162462", "Jainagar\,\ Bihar",
"9175262", "Ghatigaon\,\ Madhya\ Pradesh",
"9181529", "Kolar\,\ Karnatak",
"917848", "Keskal\,\ Madhya\ Pradesh",
"9174856", "Udaipura\,\ Madhya\ Pradesh",
"917445", "Ladpura\/Kota\,\ Rajasthan",
"91483", "Manjeri\,\ Kerala",
"912622", "Bardoli\,\ Gujarat",
"913229", "Dantan\,\ West\ Bengal",
"918579", "Palmaneru\,\ Andhra\ Pradesh",
"9166406", "Bagdihi\,\ Odisha",
"9174122", "Ratlam\,\ Madhya\ Pradesh",
"9165604", "Patan\,\ Bihar",
"9173945", "Alirajpur\,\ Madhya\ Pradesh",
"9163484", "Mallehpur\,\ Bihar",
"9168695", "Papadhandi\,\ Odisha",
"912963", "Gerhi\/Partapur\,\ Rajasthan",
"9171324", "Gadchiroli\,\ Maharashtra",
"9172875", "Gogaon\,\ Madhya\ Pradesh",
"915463", "Lalganj\,\ Uttar\ Pradesh",
"911638", "Fazilka\,\ Punjab",
"9164286", "Nala\,\ Bihar",
"9171166", "Umrer\,\ Maharashtra",
"9171792", "Nagbhir\,\ Maharashtra",
"9167533", "Nayagarh\,\ Odisha",
"9165384", "Torpa\,\ Bihar",
"912567", "Taloda\,\ Maharashtra",
"917478", "Bundi\,\ Rajasthan",
"9167864", "Chandbali\,\ Odisha",
"9164516", "Barsoi\,\ Bihar",
"913842", "Silchar\,\ Assam",
"9171562", "Talegaokarangal\,\ Maharashtra",
"917540", "Bamori\,\ Madhya\ Pradesh",
"9175260", "Ghatigaon\,\ Madhya\ Pradesh",
"9166445", "Rairakhol\,\ Odisha",
"9167352", "Telkoi\,\ Odisha",
"917368", "Ghatia\,\ Madhya\ Pradesh",
"9182207", "Gundlupet\,\ Karnataka",
"918823", "Chintalapudi\,\ Andhra\ Pradesh",
"918629", "Vinjamuru\,\ Andhra\ Pradesh",
"9174383", "Keshoraipatan\/Patan\,\ Rajasthan",
"915874", "Nighasan\/Dhaurehra\,\ Uttar\ Pradesh",
"9189461", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"917609", "Buxwaha\,\ Madhya\ Pradesh",
"9171896", "Amagaon\,\ Maharashtra",
"917803", "Majholi\,\ Madhya\ Pradesh",
"918324", "Goa",
"9163247", "Nawada\,\ Bihar",
"9168684", "Nandapur\,\ Odisha",
"9174120", "Ratlam\,\ Madhya\ Pradesh",
"918441", "Sedam\,\ Karnataka",
"912837", "Bhachav\,\ Gujarat",
"917812", "Damoh\,\ Madhya\ Pradesh",
"9163366", "Rajauli\,\ Bihar",
"9163495", "Jhajha\,\ Bihar",
"9174603", "Sahabad\,\ Rajasthan",
"9174526", "Chhabra\,\ Rajasthan",
"9165615", "Garhwa\,\ Bihar",
"9171965", "Arjuni\ Morgaon\,\ Maharashtra",
"918556", "Hindupur\,\ Andhra\ Pradesh",
"9165567", "Tisri\,\ Bihar",
"91581", "Bareilly\,\ Uttar\ Pradesh",
"9185868", "Vayalpad\,\ Andhra\ Pradesh",
"918216", "Mysore\,\ Karnataka",
"911566", "Sri\ Dungargarh\/Sudsar\,\ Rajasthan",
"9164544", "Purnea\,\ Bihar",
"9176275", "Manpur\,\ Madhya\ Pradesh",
"913472", "Krishna\ Nagar\,\ West\ Bengal",
"915444", "Robertsganj\,\ Uttar\ Pradesh",
"9165395", "Bolwa\,\ Bihar",
"9165466", "Hazaribagh\,\ Bihar",
"912950", "Dhariawad\,\ Rajasthan",
"917370", "Khilchipur\,\ Madhya\ Pradesh",
"9174864", "Bareli\,\ Madhya\ Pradesh",
"9167482", "Bhubaneshwar\,\ Odisha",
"912593", "Surgena\,\ Maharashtra",
"9165534", "Ramgarh\,\ Bihar",
"917290", "Badwani\,\ Madhya\ Pradesh",
"912447", "Gevrai\,\ Maharashtra",
"917913", "Ahmedabad\ Local\,\ Gujarat",
"9181703", "Alur\,\ Karnataka",
"912342", "Islampur\,\ Maharashtra",
"9166572", "Kantabhanji\,\ Odisha",
"9174352", "Gangdhar\,\ Rajasthan",
"9173948", "Alirajpur\,\ Madhya\ Pradesh",
"913771", "Mariani\,\ Assam",
"918869", "Pithapuram\,\ Andhra\ Pradesh",
"9168697", "Papadhandi\,\ Odisha",
"9174579", "Mangrol\,\ Rajasthan",
"911528", "Lunkaransar\,\ Rajasthan",
"918663", "Vijayawada\,\ Andhra\ Pradesh",
"9182893", "Athani\,\ Karnataka",
"9173947", "Alirajpur\,\ Madhya\ Pradesh",
"918922", "Vizayanagaram\,\ Andhra\ Pradesh",
"913244", "Bishnupur\,\ West\ Bengal",
"915497", "Zamania\,\ Uttar\ Pradesh",
"912383", "Ausa\,\ Maharashtra",
"911859", "Goindwal\,\ Punjab",
"9162593", "Pakridayal\,\ Bihar",
"915543", "Naugarh\/Barhani\,\ Uttar\ Pradesh",
"9171063", "Bhiwapur\,\ Maharashtra",
"917257", "Balapur\,\ Maharashtra",
"917565", "Berasia\,\ Madhya\ Pradesh",
"9172877", "Gogaon\,\ Madhya\ Pradesh",
"9167526", "Puri\,\ Odisha",
"9167603", "Talcher\,\ Odisha",
"9161842", "Sasaram\,\ Bihar",
"912997", "Jaisalmer\/Mohargarh\,\ Rajasthan",
"917517", "Gwalior\,\ Madhya\ Pradesh",
"915834", "Bisauli\,\ Uttar\ Pradesh",
"9172878", "Gogaon\,\ Madhya\ Pradesh",
"918783", "Karimnagar\,\ Andhra\ Pradesh",
"9174149", "Jaora\,\ Madhya\ Pradesh",
"9176362", "Baihar\,\ Madhya\ Pradesh",
"915450", "Kerakat\,\ Uttar\ Pradesh",
"917326", "Baldi\,\ Madhya\ Pradesh",
"9171674", "Amarwada\,\ Madhya\ Pradesh",
"9176463", "Nainpur\,\ Madhya\ Pradesh",
"915333", "Karchhana\/Shankergarh\,\ Uttar\ Pradesh",
"9171154", "Mouda\,\ Maharashtra",
"9174909", "Pohari\,\ Madhya\ Pradesh",
"915947", "Kashipur\,\ Uttar\ Pradesh",
"918742", "Khammam\,\ Andhra\ Pradesh",
"91285", "Junagarh\,\ Gujarat",
"912877", "Talala\,\ Gujarat",
"918357", "Badami\,\ Karnataka",
"915311", "Salon\,\ Uttar\ Pradesh",
"9164527", "Katihar\,\ Bihar",
"918452", "Medak\,\ Andhra\ Pradesh",
"9168642", "Mathili\,\ Odisha",
"9184536", "Medak\,\ Andhra\ Pradesh",
"9171573", "Arvi\,\ Maharashtra",
"911462", "Beawar\,\ Rajasthan",
"915740", "Aliganj\/Ganjdundwara\,\ Uttar\ Pradesh",
"9171875", "Goregaon\,\ Maharashtra",
"9173214", "Sanwer\,\ Madhya\ Pradesh",
"912714", "Dholka\,\ Gujarat",
"918226", "Chamrajnagar\,\ Karnataka",
"9162267", "Sitamarhi\,\ Bihar",
"912675", "Santrampur\,\ Gujarat",
"912846", "Sihor\,\ Gujarat",
"9163476", "Chakai\,\ Bihar",
"9167285", "Jajapur\ Town\,\ Odisha",
"9171802", "Salekasa\,\ Maharashtra",
"9174665", "Bonli\,\ Rajasthan",
"9171745", "Mul\,\ Maharashtra",
"917822", "Sidhi\,\ Madhya\ Pradesh",
"918314", "Belgaum\,\ Karnataka",
"9174220", "Mandsaur\,\ Madhya\ Pradesh",
"9174517", "Atru\,\ Rajasthan",
"9168552", "Laxmipur\,\ Odisha",
"9176296", "Pushprajgarh\,\ Madhya\ Pradesh",
"9171143", "Ramtek\,\ Maharashtra",
"912164", "Karad\,\ Maharashtra",
"9174518", "Atru\,\ Rajasthan",
"9167974", "Jashipur\,\ Odisha",
"912757", "Dasada\,\ Gujarat",
"9163224", "Wazirganj\,\ Bihar",
"9161897", "Bhabhua\,\ Bihar",
"918619", "Nellore\,\ Andhra\ Pradesh",
"918189", "Channagiri\,\ Karnataka",
"914112", "Kancheepuram\,\ Tamil\ Nadu",
"9164274", "Kathikund\,\ Bihar",
"918813", "Eluru\ Kovvur\/Nidadavolu\,\ Andhra\ Pradesh",
"9165633", "Bhawanathpur\,\ Bihar",
"9173246", "Mhow\,\ Madhya\ Pradesh",
"9171345", "Bhamregadh\,\ Maharashtra",
"918230", "Krishnarajapet\,\ Karnataka",
"9165814", "Bhandaria\,\ Bihar",
"9174910", "Narwar\,\ Madhya\ Pradesh",
"917782", "Jagdalpur\,\ Madhya\ Pradesh",
"913713", "Mangaldoi\,\ Assam",
"912436", "Vijapur\,\ Maharashtra",
"9174249", "Malhargarh\,\ Madhya\ Pradesh",
"9181765", "Cannarayapatna\,\ Karnataka",
"917527", "Mehgaon\,\ Madhya\ Pradesh",
"912351", "Langa\,\ Maharashtra",
"911681", "Jind\,\ Haryana",
"9166242", "Rajgangpur\,\ Odisha",
"917743", "Chuikhadan\,\ Madhya\ Pradesh",
"915115", "Ghatampur\,\ Uttar\ Pradesh",
"9177052", "Kurud\,\ Madhya\ Pradesh",
"9168164", "Mohana\,\ Odisha",
"912986", "Barmer\/Dhorimanna\,\ Rajasthan",
"9162714", "Benipatti\,\ Bihar",
"9174504", "Sangod\,\ Rajasthan",
"918751", "Boath\/Echoda\,\ Andhra\ Pradesh",
"9171005", "Kuhi\,\ Maharashtra",
"9173208", "Pandhana\,\ Madhya\ Pradesh",
"918204", "Udupi\,\ Karnataka",
"911258", "Kalanaur\,\ Haryana",
"918912", "Visakhapatnam\,\ Andhra\ Pradesh",
"9167665", "Keonjhar\,\ Odisha",
"9168583", "Nowrangapur\,\ Odisha",
"9173207", "Pandhana\,\ Madhya\ Pradesh",
"9165846", "Bishrampur\,\ Bihar",
"9165293", "Itki\,\ Bihar",
"9162746", "Samastipur\,\ Bihar",
"9176472", "Ghughari\,\ Madhya\ Pradesh",
"9173924", "Jhabua\,\ Madhya\ Pradesh",
"9174974", "Khaniadhana\,\ Madhya\ Pradesh",
"9161884", "Rohtas\,\ Bihar",
"9162234", "Motipur\,\ Bihar",
"9167416", "Bhubaneshwar\,\ Odisha",
"917224", "Daryapur\,\ Maharashtra",
"9176405", "Shahpur\,\ Madhya\ Pradesh",
"9164553", "Forbesganj\,\ Bihar",
"9176373", "Birsa\,\ Madhya\ Pradesh",
"917662", "Rewa\,\ Madhya\ Pradesh",
"9165973", "Saraikela\/Adstyapur\,\ Bihar",
"917764", "Kunkuri\,\ Madhya\ Pradesh",
"9167634", "Athmallik\,\ Odisha",
"9164525", "Katihar\,\ Bihar",
"9174912", "Narwar\,\ Madhya\ Pradesh",
"9176414", "Niwas\,\ Madhya\ Pradesh",
"9164332", "Jamtara\,\ Bihar",
"913788", "Kolaring\,\ Arunachal\ Pradesh",
"9168213", "Bhanjanagar\,\ Odisha",
"918498", "Nallacheruvu\/Tanakallu\,\ Andhra\ Pradesh",
"9167287", "Jajapur\ Town\,\ Odisha",
"918728", "Peddapalli\,\ Andhra\ Pradesh",
"9177050", "Kurud\,\ Madhya\ Pradesh",
"9176339", "Waraseoni\,\ Madhya\ Pradesh",
"9162265", "Sitamarhi\,\ Bihar",
"91191", "Jammu\,\ Jammu\ And\ Kashmir",
"911437", "Malpura\,\ Rajasthan",
"914371", "Arantangi\,\ Tamil\ Nadu",
"911332", "Roorkee\,\ Uttarakhand",
"9171877", "Goregaon\,\ Maharashtra",
"9176446", "Dindori\,\ Madhya\ Pradesh",
"9162772", "Phulparas\,\ Bihar",
"9161593", "Masrakh\,\ Bihar",
"9174668", "Bonli\,\ Rajasthan",
"912328", "Panhala\,\ Maharashtra",
"9165503", "Hunterganj\,\ Bihar",
"9174515", "Atru\,\ Rajasthan",
"9165626", "Daltonganj\,\ Bihar",
"917755", "Mungeli\,\ Madhya\ Pradesh",
"911894", "Palampur\,\ Himachal\ Pradesh",
"911583", "Jayal\,\ Rajasthan",
"9166424", "Kuchinda\,\ Odisha",
"9171747", "Mul\,\ Maharashtra",
"915172", "Mehraun\,\ Uttar\ Pradesh",
"9181734", "Sakleshpur\,\ Karnataka",
"9167222", "Pardip\,\ Odisha",
"9174667", "Bonli\,\ Rajasthan",
"9174813", "Gairatganj\,\ Madhya\ Pradesh",
"9166793", "Komana\,\ Odisha",
"9171686", "Harrai\,\ Madhya\ Pradesh",
"913668", "Bijni\,\ Assam",
"914323", "Kulithalai\,\ Tamil\ Nadu",
"9165872", "Chakardharpur\,\ Bihar",
"9171046", "Hingua\,\ Maharashtra",
"917684", "Baldeogarh\,\ Madhya\ Pradesh",
"9176470", "Ghughari\,\ Madhya\ Pradesh",
"9161895", "Bhabhua\,\ Bihar",
"9166834", "Padmapur\,\ Odisha",
"9181767", "Cannarayapatna\,\ Karnataka",
"9174634", "Gangapur\,\ Rajasthan",
"9164212", "Naugachia\,\ Bihar",
"911484", "Shahapura\,\ Rajasthan",
"9181768", "Cannarayapatna\,\ Karnataka",
"9163442", "Monghyr\,\ Bihar",
"912525", "Palghar\,\ Maharashtra",
"9171347", "Bhamregadh\,\ Maharashtra",
"9162473", "Singhwara\,\ Bihar",
"9167912", "Bangiriposi\,\ Odisha",
"914175", "Tiruvannamalai\,\ Tamil\ Nadu",
"91369", "Mokokchung\,\ Nagaland",
"9168156", "Parlakhemundi\,\ Odisha",
"916805", "Berhampur\,\ Odisha",
"911233", "Mawana\,\ Uttar\ Pradesh",
"9168432", "Puruna\ Katak\,\ Odisha",
"912366", "Vengurla\,\ Maharashtra",
"9168676", "Jharigan\,\ Odisha",
"9166492", "Jamankira\,\ Odisha",
"9167294", "Pattamundai\,\ Odisha",
"914369", "Thiruthuraipoondi\,\ Tamil\ Nadu",
"9173205", "Pandhana\,\ Madhya\ Pradesh",
"9165443", "Gomia\,\ Bihar",
"9167667", "Keonjhar\,\ Odisha",
"9174222", "Mandsaur\,\ Madhya\ Pradesh",
"9165342", "Jhumaritalaiya\,\ Bihar",
"918485", "Aurad\,\ Karnataka",
"9164732", "Supaul\,\ Bihar",
"912182", "Karmala\,\ Maharashtra",
"9176506", "Beohari\,\ Madhya\ Pradesh",
"9171007", "Kuhi\,\ Maharashtra",
"9176407", "Shahpur\,\ Madhya\ Pradesh",
"913795", "Basar\,\ Arunachal\ Pradesh",
"9167813", "Basta\,\ Odisha",
"911477", "Nimbahera\,\ Rajasthan",
"9171706", "Chumur\,\ Maharashtra",
"91145", "Ajmer\,\ Rajasthan",
"913670", "Maibong\,\ Assam",
"911900", "Lahul\/Keylong\,\ Himachal\ Pradesh",
"911372", "Chamoli\,\ Uttarakhand",
"9176408", "Shahpur\,\ Madhya\ Pradesh",
"918935", "Paderu\,\ Andhra\ Pradesh",
"914331", "Jayamkondan\,\ Tamil\ Nadu",
"91475", "Punalur\,\ Kerala",
"912143", "Pen\,\ Maharashtra",
"9176340", "Lamta\,\ Madhya\ Pradesh",
"912142", "Pali\,\ Maharashtra",
"911373", "Purola\,\ Uttarakhand",
"914924", "Mannarkad\,\ Kerala",
"9168586", "Nowrangapur\,\ Odisha",
"9167692", "Kamakhyanagar\,\ Odisha",
"9165843", "Bishrampur\,\ Bihar",
"914188", "Chengam\,\ Tamil\ Nadu",
"9165296", "Itki\,\ Bihar",
"9162743", "Samastipur\,\ Bihar",
"911874", "Gurdaspur\,\ Punjab",
"9165545", "Rajdhanwar\,\ Bihar",
"912183", "Madha\,\ Maharashtra",
"9167312", "Anandapur\,\ Odisha",
"915192", "Banda\,\ Uttar\ Pradesh",
"9174232", "Neemuch\,\ Madhya\ Pradesh",
"9167413", "Bhubaneshwar\,\ Odisha",
"9176376", "Birsa\,\ Madhya\ Pradesh",
"9164556", "Forbesganj\,\ Bihar",
"9168487", "Kotagarh\,\ Odisha",
"918848", "Kakinada\,\ Andhra\ Pradesh",
"9164614", "Raniganj\,\ Bihar",
"917289", "Zhirnia\,\ Madhya\ Pradesh",
"911887", "Nangal\,\ Punjab",
"9168422", "Phulbani\,\ Odisha",
"9164787", "Saharsa\,\ Bihar",
"918478", "Kamalapur\,\ Karnataka",
"911232", "Modinagar\,\ Uttar\ Pradesh",
"9163265", "Sherghati\,\ Bihar",
"9162502", "Dhaka\,\ Bihar",
"9165942", "Baharagora\,\ Bihar",
"915566", "Salempur\,\ Uttar\ Pradesh",
"9127172", "Sanand\,\ Gujarat",
"91181", "Jallandhar\,\ Punjab",
"9162575", "Barachakia\,\ Bihar",
"917126", "Nagpur\,\ Maharashtra",
"918646", "Vinukonda\,\ Andhra\ Pradesh",
"9165655", "Latehar\,\ Bihar",
"9166467", "Bargarh\,\ Odisha",
"9174624", "Sawaimadhopur\,\ Rajasthan",
"9161124", "Biharsharif\,\ Bihar",
"9166824", "Attabira\,\ Odisha",
"911497", "Kishangarh\,\ Rajasthan",
"911392", "Budhana\,\ Uttar\ Pradesh",
"914322", "Pudukkottai\,\ Tamil\ Nadu",
"9176293", "Pushprajgarh\,\ Madhya\ Pradesh",
"9164387", "Madhupur\,\ Bihar",
"913775", "Majuli\,\ Assam",
"9171146", "Ramtek\,\ Maharashtra",
"912909", "Bhim\/Dawer\,\ Rajasthan",
"9174692", "Hindaun\,\ Rajasthan",
"9167232", "Athgarh\,\ Odisha",
"9181724", "Hassan\,\ Karnataka",
"918835", "Rajahmundri\,\ Andhra\ Pradesh",
"9174312", "Aklera\,\ Rajasthan",
"9166434", "Barkot\,\ Odisha",
"911582", "Nagaur\,\ Rajasthan",
"9165472", "Chavparan\,\ Bihar",
"9168494", "Daringbadi\,\ Odisha",
"9165636", "Bhawanathpur\,\ Bihar",
"9165405", "Govindpur\,\ Bihar",
"9173243", "Mhow\,\ Madhya\ Pradesh",
"9176814", "Jatara\,\ Madhya\ Pradesh",
"9164794", "Udakishanganj\,\ Bihar",
"917539", "Gohad\,\ Madhya\ Pradesh",
"9184533", "Medak\,\ Andhra\ Pradesh",
"9176329", "Balaghat\,\ Madhya\ Pradesh",
"9171576", "Arvi\,\ Maharashtra",
"913657", "Mairang\,\ Meghalaya",
"9171477", "Multai\,\ Madhya\ Pradesh",
"9164322", "Deoghar\,\ Bihar",
"9163372", "Arwal\,\ Bihar",
"9164535", "Araria\,\ Bihar",
"917561", "Ichhawar\,\ Madhya\ Pradesh",
"9167624", "Dhenkanal\,\ Odisha",
"9163473", "Chakai\,\ Bihar",
"9162442", "Khagaria\,\ Bihar",
"917663", "Mauganj\,\ Madhya\ Pradesh",
"915446", "Dudhi\/Pipri\,\ Uttar\ Pradesh",
"9174690", "Hindaun\,\ Rajasthan",
"9162224", "Sheohar\,\ Bihar",
"9165446", "Gomia\,\ Bihar",
"9163314", "Imamganj\,\ Bihar",
"9173934", "Jobat\,\ Madhya\ Pradesh",
"9176503", "Beohari\,\ Madhya\ Pradesh",
"918370", "Kalghatagi\,\ Karnataka",
"918214", "Mysore\,\ Karnataka",
"911564", "Sardarshahar\,\ Rajasthan",
"9168485", "Kotagarh\,\ Odisha",
"9167816", "Basta\,\ Odisha",
"9171652", "Saunsar\,\ Madhya\ Pradesh",
"917831", "Balrampur\,\ Madhya\ Pradesh",
"9171703", "Chumur\,\ Maharashtra",
"9175111", "Gwalior\,\ Madhya\ Pradesh",
"918913", "Visakhapatnam\,\ Andhra\ Pradesh",
"9174310", "Aklera\,\ Rajasthan",
"918554", "Anantapur\,\ Andhra\ Pradesh",
"911508", "Suratgarh\/Goluwala\,\ Rajasthan",
"9165547", "Rajdhanwar\,\ Bihar",
"918326", "Goa",
"912770", "Prantij\,\ Gujarat",
"9163267", "Sherghati\,\ Bihar",
"9164785", "Saharsa\,\ Bihar",
"911799", "Rajgarh\,\ Himachal\ Pradesh",
"916577", "Jamshedpur\,\ Bihar",
"9165414", "Chatra\,\ Bihar",
"9174374", "Nainwa\,\ Rajasthan",
"9166554", "Titlagarh\,\ Odisha",
"911429", "Bassi\,\ Rajasthan",
"9162476", "Singhwara\,\ Bihar",
"9177009", "Nagri\,\ Madhya\ Pradesh",
"918565", "Rajampeta\,\ Andhra\ Pradesh",
"9166465", "Bargarh\,\ Odisha",
"9165657", "Latehar\,\ Bihar",
"9168153", "Parlakhemundi\,\ Odisha",
"9175919", "Sironj\,\ Madhya\ Pradesh",
"915876", "Mohammadi\,\ Uttar\ Pradesh",
"9162577", "Barachakia\,\ Bihar",
"913712", "Tezpur\,\ Assam",
"918257", "Sullia\,\ Karnataka",
"917783", "Padamkot\,\ Madhya\ Pradesh",
"9168673", "Jharigan\,\ Odisha",
"9167844", "Bhadrak\,\ Odisha",
"915645", "Rupbas\,\ Rajasthan",
"918517", "Atmakur\,\ Andhra\ Pradesh",
"911267", "Nuh\,\ Haryana",
"911555", "Nohar\,\ Rajasthan",
"9176443", "Dindori\,\ Madhya\ Pradesh",
"9161596", "Masrakh\,\ Bihar",
"9164385", "Madhupur\,\ Bihar",
"9165623", "Daltonganj\,\ Bihar",
"918812", "Eluru\,\ Andhra\ Pradesh",
"9165506", "Hunterganj\,\ Bihar",
"9163234", "Dumraon\,\ Bihar",
"9176342", "Lamta\,\ Madhya\ Pradesh",
"9174816", "Gairatganj\,\ Madhya\ Pradesh",
"918304", "Kundgol\,\ Karnataka",
"9166796", "Komana\,\ Odisha",
"918540", "Nagarkurnool\,\ Andhra\ Pradesh",
"9161862", "Aurangabad\,\ Bihar",
"9165407", "Govindpur\,\ Bihar",
"912118", "Walchandnagar\,\ Maharashtra",
"915836", "Gunnaur\,\ Uttar\ Pradesh",
"9175229", "Datia\,\ Madhya\ Pradesh",
"9171683", "Harrai\,\ Madhya\ Pradesh",
"9174230", "Neemuch\,\ Madhya\ Pradesh",
"9171043", "Hingua\,\ Maharashtra",
"9161354", "Bikram\,\ Bihar",
"917823", "Dongargarh\,\ Madhya\ Pradesh",
"918368", "Hubli\,\ Karnataka",
"9165976", "Saraikela\/Adstyapur\,\ Bihar",
"9164672", "Banmankhi\,\ Bihar",
"918330", "Saundatti\,\ Karnataka",
"9168216", "Bhanjanagar\,\ Odisha",
"9168182", "Buguda\,\ Odisha",
"911463", "Kishangarh\,\ Rajasthan",
"9162292", "Bidupur\,\ Bihar",
"9164537", "Araria\,\ Bihar",
"9174844", "Silwani\,\ Madhya\ Pradesh",
"9171475", "Multai\,\ Madhya\ Pradesh",
"918743", "Bhadrachalam\,\ Andhra\ Pradesh",
"915332", "Phoolpur\,\ Uttar\ Pradesh",
"91591", "Moradabad\,\ Uttar\ Pradesh",
"9165277", "Kolebira\,\ Bihar",
"9174689", "Khandar\,\ Rajasthan",
"9171054", "Narkhed\,\ Maharashtra",
"9177010", "Pingeshwar\,\ Madhya\ Pradesh",
"914295", "Sathiyamangalam\,\ Tamil\ Nadu",
"9176565", "Kannodi\,\ Madhya\ Pradesh",
"9175900", "Lateri\,\ Madhya\ Pradesh",
"918782", "Karimnagar\,\ Andhra\ Pradesh",
"9167827", "Balasore\,\ Odisha",
"9176454", "Karanjia\,\ Madhya\ Pradesh",
"917230", "Ghatanji\,\ Maharashtra",
"9174952", "Badarwas\,\ Madhya\ Pradesh",
"912166", "Phaltan\,\ Maharashtra",
"9164283", "Nala\,\ Bihar",
"9171163", "Umrer\,\ Maharashtra",
"9171765", "Warora\,\ Maharashtra",
"9167536", "Nayagarh\,\ Odisha",
"9174645", "Karauli\,\ Rajasthan",
"918316", "Belgaum\,\ Karnataka",
"915542", "Basti\,\ Uttar\ Pradesh",
"912844", "Mahuva\,\ Gujarat",
"912382", "Latur\,\ Maharashtra",
"911652", "Mansa\,\ Punjab",
"912487", "Shrigonda\,\ Maharashtra",
"9175295", "Laher\,\ Madhya\ Pradesh",
"9174309", "Khanpur\,\ Rajasthan",
"9171584", "Deoli\,\ Maharashtra",
"918662", "Vijayawada\,\ Andhra\ Pradesh",
"915273", "Tandai\/Tanda\,\ Uttar\ Pradesh",
"9167882", "Soro\,\ Odisha",
"912716", "Dehgam\,\ Gujarat",
"918224", "Kollegal\,\ Karnataka",
"9162247", "Hajipur\,\ Bihar",
"9174853", "Udaipura\,\ Madhya\ Pradesh",
"914348", "Palakkodu\,\ Tamil\ Nadu",
"91241", "Ahmednagar\,\ Maharashtra",
"912343", "Atpadi\,\ Maharashtra",
"912937", "Raipur\,\ Rajasthan",
"917912", "Ahmedabad\ Local\,\ Gujarat",
"9166403", "Bagdihi\,\ Odisha",
"9168662", "Umerkote\,\ Odisha",
"9174555", "Digod\/Sultanpur\,\ Rajasthan",
"91733", "Khandwa\,\ Madhya\ Pradesh",
"917751", "Pendra\,\ Madhya\ Pradesh",
"912592", "Kalwan\,\ Maharashtra",
"9177074", "Bagbahera\,\ Madhya\ Pradesh",
"917268", "Mekhar\,\ Maharashtra",
"917226", "Dharani\,\ Maharashtra",
"9161575", "Mairwa\,\ Bihar",
"914545", "Palani\,\ Tamil\ Nadu",
"9168574", "Gunupur\,\ Odisha",
"914651", "Kuzhithurai\,\ Tamil\ Nadu",
"912897", "Dhrol\,\ Gujarat",
"9174709", "Bundi\,\ Rajasthan",
"9165592", "Simaria\,\ Bihar",
"913473", "Ranaghat\,\ West\ Bengal",
"9162766", "Madhubani\,\ Bihar",
"9161502", "Hathua\,\ Bihar",
"9168116", "Chhatrapur\,\ Odisha",
"9176259", "Umariapan\,\ Madhya\ Pradesh",
"9165866", "Chainpur\,\ Bihar",
"912977", "Jalore\/Sayla\,\ Rajasthan",
"9167952", "Udala\,\ Odisha",
"914171", "Gudiyatham\,\ Tamil\ Nadu",
"9166775", "Narlaroad\,\ Odisha",
"9164252", "Katoria\,\ Bihar",
"9174827", "Raisen\,\ Madhya\ Pradesh",
"912521", "Talasari\,\ Maharashtra",
"9161873", "Mohania\,\ Bihar",
"918206", "Udupi\,\ Karnataka",
"9166702", "Bhawanipatna\,\ Odisha",
"9167645", "Anugul\,\ Odisha",
"9176384", "Damoh\,\ Madhya\ Pradesh",
"9174536", "Baran\,\ Rajasthan",
"9174828", "Raisen\,\ Madhya\ Pradesh",
"912984", "Barmer\/Sindari\,\ Rajasthan",
"918931", "Yelamanchili\,\ Andhra\ Pradesh",
"917813", "Barpalli\,\ Madhya\ Pradesh",
"9168144", "Digapahandi\,\ Odisha",
"9174130", "Sailana\,\ Madhya\ Pradesh",
"9166845", "Paikamal\,\ Odisha",
"9161145", "Jahanabad\,\ Bihar",
"917802", "Churhat\,\ Madhya\ Pradesh",
"917580", "Bina\,\ Madhya\ Pradesh",
"9164663", "Kishanganj\,\ Bihar",
"913791", "Taliha\,\ Arunachal\ Pradesh",
"9166262", "Banaigarh\,\ Odisha",
"917270", "Sonkatch\,\ Madhya\ Pradesh",
"9167555", "Khurda\,\ Odisha",
"9174269", "Sitamau\,\ Madhya\ Pradesh",
"9168227", "Aska\,\ Odisha",
"9181745", "Arsikere\,\ Karnataka",
"914288", "Tiruchengode\,\ Tamil\ Nadu",
"918481", "Basavakalyan\,\ Karnataka",
"9171496", "Tamia\,\ Madhya\ Pradesh",
"9171365", "Etapalli\,\ Maharashtra",
"9166543", "Sonapur\,\ Odisha",
"917390", "Thandla\,\ Madhya\ Pradesh",
"913843", "Karimganj\,\ Assam",
"9176567", "Kannodi\,\ Madhya\ Pradesh",
"9171066", "Bhiwapur\,\ Maharashtra",
"911976", "Amb\,\ Himachal\ Pradesh",
"917686", "Khajuraho\,\ Madhya\ Pradesh",
"9167606", "Talcher\,\ Odisha",
"9167523", "Puri\,\ Odisha",
"9165275", "Kolebira\,\ Bihar",
"9176568", "Kannodi\,\ Madhya\ Pradesh",
"911896", "Churah\/Tissa\,\ Himachal\ Pradesh",
"915462", "Azamgarh\,\ Uttar\ Pradesh",
"9174647", "Karauli\,\ Rajasthan",
"9171767", "Warora\,\ Maharashtra",
"9171334", "Aheri\,\ Maharashtra",
"915315", "Dalmau\/Lalganj\,\ Uttar\ Pradesh",
"9176466", "Nainpur\,\ Madhya\ Pradesh",
"9174648", "Karauli\,\ Rajasthan",
"9167825", "Balasore\,\ Odisha",
"91497", "Kannur\,\ Kerala",
"9175298", "Laher\,\ Madhya\ Pradesh",
"913808", "Changlang\,\ Arunachal\ Pradesh",
"9162245", "Hajipur\,\ Bihar",
"912962", "Banswara\,\ Rajasthan",
"912558", "Peint\,\ Maharashtra",
"918249", "Mangalore\,\ Karnataka",
"9175297", "Laher\,\ Madhya\ Pradesh",
"912829", "Maliya\ Miyana\,\ Gujarat",
"9174132", "Sailana\,\ Madhya\ Pradesh",
"912623", "Mandvi\,\ Gujarat",
"9181706", "Alur\,\ Karnataka",
"911698", "Ellenabad\,\ Haryana",
"9174558", "Digod\/Sultanpur\,\ Rajasthan",
"91204", "Pune\,\ Maharashtra",
"9182896", "Athani\,\ Karnataka",
"914202", "Mulanur\,\ Tamil\ Nadu",
"918637", "Guntur\,\ Andhra\ Pradesh",
"9174557", "Digod\/Sultanpur\,\ Rajasthan",
"914553", "Oddanchatram\,\ Tamil\ Nadu",
"917766", "Dharamjaigarh\,\ Madhya\ Pradesh",
"9162596", "Pakridayal\,\ Bihar",
"9174523", "Chhabra\,\ Rajasthan",
"9162754", "Rosera\,\ Bihar",
"9175902", "Lateri\,\ Madhya\ Pradesh",
"9174606", "Sahabad\,\ Rajasthan",
"917728", "Kasdol\,\ Madhya\ Pradesh",
"9177012", "Pingeshwar\,\ Madhya\ Pradesh",
"911685", "Guruharsahai\,\ Punjab",
"915111", "Akbarpur\,\ Uttar\ Pradesh",
"915681", "Bidhuna\,\ Uttar\ Pradesh",
"916617", "Rourkela\,\ Odisha",
"918157", "Srinivasapur\,\ Karnataka",
"9171992", "Deori\,\ Maharashtra",
"9161577", "Mairwa\,\ Bihar",
"912355", "Chiplun\,\ Maharashtra",
"9167647", "Anugul\,\ Odisha",
"9165362", "Palkot\,\ Bihar",
"9174825", "Raisen\,\ Madhya\ Pradesh",
"9174950", "Badarwas\,\ Madhya\ Pradesh",
"9166777", "Narlaroad\,\ Odisha",
"918677", "Kaikaluru\,\ Andhra\ Pradesh",
"9165854", "Ghatsila\,\ Bihar",
"9165463", "Hazaribagh\,\ Bihar",
"918708", "Warangal\,\ Andhra\ Pradesh",
"9164513", "Barsoi\,\ Bihar",
"912364", "Deogad\,\ Maharashtra",
"911936", "Pahalgam\,\ Jammu\ And\ Kashmir",
"918190", "Tallak\,\ Karnataka",
"918599", "Ulvapadu\,\ Andhra\ Pradesh",
"9161147", "Jahanabad\,\ Bihar",
"9166847", "Paikamal\,\ Odisha",
"912631", "Ahwa\,\ Gujarat",
"918684", "Suryapet\,\ Andhra\ Pradesh",
"914868", "Nedumkandam\,\ Kerala",
"9174386", "Keshoraipatan\/Patan\,\ Rajasthan",
"9176534", "Bandhavgarh\,\ Madhya\ Pradesh",
"9163462", "Lakhisarai\,\ Bihar",
"911765", "Nabha\,\ Punjab",
"913624", "Nalbari\,\ Assam",
"911486", "Mandal\,\ Rajasthan",
"9181748", "Arsikere\,\ Karnataka",
"9171893", "Amagaon\,\ Maharashtra",
"9171367", "Etapalli\,\ Maharashtra",
"912669", "Chhota\ Udaipur\,\ Gujarat",
"9171734", "Rajura\,\ Maharashtra",
"9181747", "Arsikere\,\ Karnataka",
"9168225", "Aska\,\ Odisha",
"9167557", "Khurda\,\ Odisha",
"918389", "Siddapur\,\ Karnataka",
"9163363", "Rajauli\,\ Bihar",
"918388", "Ankola\,\ Karnataka",
"9167273", "Kendrapara\,\ Odisha",
"9177075", "Bagbahera\,\ Madhya\ Pradesh",
"9165433", "Barhi\,\ Bihar",
"915680", "Bharthana\,\ Uttar\ Pradesh",
"915194", "Karvi\/Manikpur\,\ Uttar\ Pradesh",
"912668", "Waghodia\,\ Gujarat",
"9165332", "Basia\,\ Bihar",
"9177002", "Nagri\,\ Madhya\ Pradesh",
"911872", "Quadian\,\ Punjab",
"9174554", "Digod\/Sultanpur\,\ Rajasthan",
"9162723", "Darbhanga\,\ Bihar",
"9175912", "Sironj\,\ Madhya\ Pradesh",
"9174616", "Mahuwa\,\ Rajasthan",
"914869", "Peermedu\,\ Kerala",
"9171585", "Deoli\,\ Maharashtra",
"915738", "Khurja\,\ Uttar\ Pradesh",
"918598", "Kandukuru\,\ Andhra\ Pradesh",
"9165823", "Chaibasa\,\ Bihar",
"914922", "Alathur\,\ Kerala",
"911992", "Udhampur\,\ Jammu\ And\ Kashmir",
"912144", "Murud\,\ Maharashtra",
"9176320", "Balaghat\,\ Madhya\ Pradesh",
"9175294", "Laher\,\ Madhya\ Pradesh",
"911537", "Nohar\/Rawatsar\,\ Rajasthan",
"9171764", "Warora\,\ Maharashtra",
"9174644", "Karauli\,\ Rajasthan",
"918709", "Warangal\,\ Andhra\ Pradesh",
"912630", "Bansada\,\ Gujarat",
"9176455", "Karanjia\,\ Madhya\ Pradesh",
"911483", "Hurda\/Gulabpura\,\ Rajasthan",
"918191", "Holalkere\,\ Karnataka",
"9171337", "Aheri\,\ Maharashtra",
"9164626", "Dhamdaha\,\ Bihar",
"91130", "Sonipat\,\ Haryana",
"9171982", "Tirora\,\ Maharashtra",
"9171055", "Narkhed\,\ Maharashtra",
"911234", "Baghpat\/Baraut\,\ Uttar\ Pradesh",
"9176564", "Kannodi\,\ Madhya\ Pradesh",
"9168442", "Kantamal\,\ Odisha",
"911933", "Pulwama\,\ Jammu\ And\ Kashmir",
"917729", "Bhilaigarh\,\ Madhya\ Pradesh",
"9171364", "Etapalli\,\ Maharashtra",
"9173223", "Depalpur\,\ Madhya\ Pradesh",
"9176436", "Bijadandi\,\ Madhya\ Pradesh",
"9162586", "Areraj\,\ Bihar",
"912670", "Shehra\,\ Gujarat",
"9174273", "Bhanpura\,\ Madhya\ Pradesh",
"9167616", "Chhendipada\,\ Odisha",
"9171852", "Pauni\,\ Maharashtra",
"911893", "Nurpur\,\ Himachal\ Pradesh",
"9167554", "Khurda\,\ Odisha",
"912795", "Kodinar\,\ Gujarat",
"9181744", "Arsikere\,\ Karnataka",
"912425", "Sangamner\,\ Maharashtra",
"911584", "Nagaur\/Mundwa\ Marwar\,\ Rajasthan",
"9171737", "Rajura\,\ Maharashtra",
"9171126", "Katol\,\ Maharashtra",
"9176538", "Bandhavgarh\,\ Madhya\ Pradesh",
"911274", "Rewari\,\ Haryana",
"912828", "Wankaner\,\ Gujarat",
"9176537", "Bandhavgarh\,\ Madhya\ Pradesh",
"918248", "Mangalore\,\ Karnataka",
"9171036", "Butibori\,\ Maharashtra",
"914324", "Karur\,\ Tamil\ Nadu",
"9168145", "Digapahandi\,\ Odisha",
"913809", "Sagalee\,\ Arunachal\ Pradesh",
"9166844", "Paikamal\,\ Odisha",
"9161144", "Jahanabad\,\ Bihar",
"915745", "Jalesar\,\ Uttar\ Pradesh",
"917683", "Tikamgarh\,\ Madhya\ Pradesh",
"912559", "Yeola\,\ Maharashtra",
"911741", "Pehowa\,\ Haryana",
"9162422", "Benipur\,\ Bihar",
"9167644", "Anugul\,\ Odisha",
"917763", "Jashpurnagar\,\ Madhya\ Pradesh",
"9176385", "Damoh\,\ Madhya\ Pradesh",
"916215", "Muzaffarpur\,\ Bihar",
"918585", "Pakala\,\ Andhra\ Pradesh",
"9166774", "Narlaroad\,\ Odisha",
"9165857", "Ghatsila\,\ Bihar",
"9175222", "Datia\,\ Madhya\ Pradesh",
"9164342", "Dumka\,\ Bihar",
"9166816", "Jujumura\,\ Odisha",
"9161116", "Hilsa\,\ Bihar",
"91121", "Meerut\,\ Uttar\ Pradesh",
"9168502", "Kalimela\,\ Odisha",
"9176349", "Lamta\,\ Madhya\ Pradesh",
"9162757", "Rosera\,\ Bihar",
"913525", "Dalkhola\,\ West\ Bengal",
"912626", "Vyara\,\ Gujarat",
"911921", "Basholi\,\ Jammu\ And\ Kashmir",
"918395", "Sandur\,\ Karnataka",
"9161574", "Mairwa\,\ Bihar",
"9168575", "Gunupur\,\ Odisha",
"911577", "Dantaramgarh\,\ Rajasthan",
"9168106", "Khalikote\,\ Odisha",
"918552", "Gooty\/Guntakal\,\ Andhra\ Pradesh",
"9177078", "Bagbahera\,\ Madhya\ Pradesh",
"918203", "Udupi\,\ Karnataka",
"9171486", "Prabha\ Pattan\,\ Madhya\ Pradesh",
"9161512", "Sidhawalia\,\ Bihar",
"9174566", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"9165836", "Kharsawa\,\ Bihar",
"911958", "Karnah\,\ Jammu\ And\ Kashmir",
"918212", "Mysore\,\ Karnataka",
"9177077", "Bagbahera\,\ Madhya\ Pradesh",
"911562", "Churu\,\ Rajasthan",
"9166712", "Rajkhariar\,\ Odisha",
"9162736", "Jhajharpur\,\ Bihar",
"912520", "Jawahar\,\ Maharashtra",
"917223", "Achalpur\,\ Maharashtra",
"9165426", "Bokaro\,\ Bihar",
"9162244", "Hajipur\,\ Bihar",
"9171587", "Deoli\,\ Maharashtra",
"9175220", "Datia\,\ Madhya\ Pradesh",
"916125", "Patna\,\ Bihar",
"9171335", "Aheri\,\ Maharashtra",
"913790", "Tali\,\ Arunachal\ Pradesh",
"9171522", "Wardha\,\ Maharashtra",
"917581", "Khurai\,\ Madhya\ Pradesh",
"9167824", "Balasore\,\ Odisha",
"9176457", "Karanjia\,\ Madhya\ Pradesh",
"913675", "Bokajan\,\ Assam",
"9171756", "Bhadrawati\,\ Maharashtra",
"913714", "Rangapara\,\ Assam",
"9174239", "Neemuch\,\ Madhya\ Pradesh",
"9176458", "Karanjia\,\ Madhya\ Pradesh",
"911905", "Mandi\,\ Himachal\ Pradesh",
"9165274", "Kolebira\,\ Bihar",
"917391", "Petlawad\,\ Madhya\ Pradesh",
"917744", "Rajandgaon\,\ Madhya\ Pradesh",
"9163326", "Nabinagar\,\ Bihar",
"917816", "Pali\,\ Madhya\ Pradesh",
"9165582", "Dumri\(Isribazar\)\,\ Bihar",
"9171057", "Narkhed\,\ Maharashtra",
"917271", "Bagli\,\ Madhya\ Pradesh",
"9164376", "Mahagama\,\ Bihar",
"9171735", "Rajura\,\ Maharashtra",
"9175910", "Sironj\,\ Madhya\ Pradesh",
"9167566", "Balugaon\,\ Odisha",
"917269", "Sindkhedaraja\,\ Maharashtra",
"9168224", "Aska\,\ Odisha",
"9177000", "Nagri\,\ Madhya\ Pradesh",
"918313", "Belgaum\,\ Karnataka",
"9171023", "Parseoni\,\ Maharashtra",
"918407", "Darsi\,\ Andhra\ Pradesh",
"9171356", "Chamorshi\,\ Maharashtra",
"912163", "Koregaon\,\ Maharashtra",
"9171133", "Saoner\,\ Maharashtra",
"9187592", "Outsarangapalle\,\ Andhra\ Pradesh",
"9176322", "Balaghat\,\ Madhya\ Pradesh",
"918814", "Eluru\ Narsapur\/Palakole\,\ Andhra\ Pradesh",
"9168147", "Digapahandi\,\ Odisha",
"9165643", "Nagarutari\,\ Bihar",
"9176535", "Bandhavgarh\,\ Madhya\ Pradesh",
"918746", "Bhooragamphad\/Manuguru\,\ Andhra\ Pradesh",
"917231", "Umarkhed\,\ Maharashtra",
"9164776", "Triveniganj\,\ Bihar",
"9173236", "Punasa\,\ Madhya\ Pradesh",
"9176423", "Mandla\,\ Madhya\ Pradesh",
"9174824", "Raisen\,\ Madhya\ Pradesh",
"9176388", "Damoh\,\ Madhya\ Pradesh",
"9165855", "Ghatsila\,\ Bihar",
"91532", "Allahabad\,\ Uttar\ Pradesh",
"9176387", "Damoh\,\ Madhya\ Pradesh",
"912346", "Tasgaon\,\ Maharashtra",
"9168476", "G\.Udayagiri\,\ Odisha",
"9164293", "Kahalgaon\,\ Bihar",
"9174319", "Aklera\,\ Rajasthan",
"9168632", "Bisam\ Cuttack\,\ Odisha",
"91373", "Dibrugarh\,\ Assam",
"914561", "Devakottai\,\ Tamil\ Nadu",
"9168577", "Gunupur\,\ Odisha",
"918857", "Ramachandrapuram\,\ Andhra\ Pradesh",
"9174699", "Hindaun\,\ Rajasthan",
"912713", "Dhandhuka\,\ Gujarat",
"9162755", "Rosera\,\ Bihar",
"917750", "Marwahi\,\ Madhya\ Pradesh",
"9166413", "Deodgarh\,\ Odisha",
"9162574", "Barachakia\,\ Bihar",
"9166456", "Jharsuguda\,\ Odisha",
"9174260", "Sitamau\,\ Madhya\ Pradesh",
"917440", "Ladpura\/Kota\,\ Rajasthan",
"917826", "Patan\,\ Madhya\ Pradesh",
"9165654", "Latehar\,\ Bihar",
"9174625", "Sawaimadhopur\,\ Rajasthan",
"9165516", "Barkagaon\,\ Bihar",
"9175383", "Ambah\,\ Madhya\ Pradesh",
"91797", "Ahmedabad\ Local\,\ Gujarat",
"9161832", "Buxar\,\ Bihar",
"9162282", "Pupri\,\ Bihar",
"912472", "Osmanabad\,\ Maharashtra",
"915833", "Sahaswan\,\ Uttar\ Pradesh",
"9167847", "Bhadrak\,\ Odisha",
"918784", "Karimnagar\,\ Andhra\ Pradesh",
"9168192", "Surada\,\ Odisha",
"9174139", "Sailana\,\ Madhya\ Pradesh",
"914116", "Tiruvallur\,\ Tamil\ Nadu",
"9174378", "Nainwa\,\ Rajasthan",
"915661", "Sadabad\,\ Uttar\ Pradesh",
"9163264", "Sherghati\,\ Bihar",
"9161323", "Barh\,\ Bihar",
"9174377", "Nainwa\,\ Rajasthan",
"9166557", "Titlagarh\,\ Odisha",
"918541", "Achampet\,\ Andhra\ Pradesh",
"9165417", "Chatra\,\ Bihar",
"915334", "Meja\/Sirsa\,\ Uttar\ Pradesh",
"9174806", "Goharganj\,\ Madhya\ Pradesh",
"918456", "Narayankhed\,\ Andhra\ Pradesh",
"918369", "Hubli\,\ Karnataka",
"913837", "Kolasib\,\ Mizoram",
"9164615", "Raniganj\,\ Bihar",
"912119", "Kedgaon\,\ Maharashtra",
"9171693", "Batkakhapa\,\ Madhya\ Pradesh",
"912594", "Trimbak\,\ Maharashtra",
"9165544", "Rajdhanwar\,\ Bihar",
"917202", "Ralegaon\,\ Maharashtra",
"911466", "Kekri\,\ Rajasthan",
"917914", "Ahmedabad\ Local\,\ Gujarat",
"916717", "Cuttack\,\ Odisha",
"9166786", "Nowparatan\,\ Odisha",
"911785", "Pooh\,\ Himachal\ Pradesh",
"9162227", "Sheohar\,\ Bihar",
"918222", "Hunsur\,\ Karnataka",
"9173938", "Jobat\,\ Madhya\ Pradesh",
"9174700", "Bundi\,\ Rajasthan",
"918664", "Vijayawada\,\ Andhra\ Pradesh",
"9171313", "Sironcha\,\ Maharashtra",
"9171412", "Betul\,\ Madhya\ Pradesh",
"9161586", "Sonepur\,\ Bihar",
"913243", "Khatra\,\ West\ Bengal",
"9176250", "Umariapan\,\ Madhya\ Pradesh",
"9173937", "Jobat\,\ Madhya\ Pradesh",
"918777", "Tirupathi\,\ Andhra\ Pradesh",
"915544", "Naugarh\/Tetribazar\,\ Uttar\ Pradesh",
"9163317", "Imamganj\,\ Bihar",
"918331", "Raibag\/Kudchi\,\ Karnataka",
"912842", "Talaja\,\ Gujarat",
"912384", "Nilanga\,\ Maharashtra",
"914935", "Mananthavady\,\ Kerala",
"9167625", "Dhenkanal\,\ Odisha",
"91250", "Bassein\,\ Maharashtra",
"9176513", "Jaisinghnagar\,\ Madhya\ Pradesh",
"918916", "Visakhapatnam\,\ Andhra\ Pradesh",
"913877", "Tamenglong\,\ Manipur",
"9174848", "Silwani\,\ Madhya\ Pradesh",
"91385", "Imphal\,\ Manipur",
"915821", "Pitamberpur\,\ Uttar\ Pradesh",
"9174847", "Silwani\,\ Madhya\ Pradesh",
"914895", "Kalpeni\,\ Lakshadweep",
"9164534", "Araria\,\ Bihar",
"911428", "Dudu\,\ Rajasthan",
"9174300", "Khanpur\,\ Rajasthan",
"9171713", "Gond\ Pipri\,\ Maharashtra",
"914728", "Nedumangad\,\ Kerala",
"9176815", "Jatara\,\ Madhya\ Pradesh",
"915443", "Chunur\,\ Uttar\ Pradesh",
"9164795", "Udakishanganj\,\ Bihar",
"918737", "Chinnor\,\ Andhra\ Pradesh",
"918371", "Mundargi\,\ Karnataka",
"911509", "Suratgarh\,\ Rajasthan",
"917786", "Kondagaon\,\ Madhya\ Pradesh",
"9166523", "Balangir\,\ Odisha",
"9165404", "Govindpur\,\ Bihar",
"9181725", "Hassan\,\ Karnataka",
"912432", "Aurangabad\,\ Maharashtra",
"9166435", "Barkot\,\ Odisha",
"91793", "Ahmedabad\ Local\,\ Gujarat",
"9161357", "Bikram\,\ Bihar",
"912771", "Bhiloda\,\ Gujarat",
"915873", "Nighasan\/Tikunia\,\ Uttar\ Pradesh",
"918135", "Sira\,\ Karnataka",
"9168495", "Daringbadi\,\ Odisha",
"9172883", "Bhikangaon\,\ Madhya\ Pradesh",
"917804", "Kusmi\,\ Madhya\ Pradesh",
"9166825", "Attabira\,\ Odisha",
"9161125", "Biharsharif\,\ Bihar",
"917868", "Kanker\,\ Madhya\ Pradesh",
"9175909", "Lateri\,\ Madhya\ Pradesh",
"918323", "Goa",
"9163237", "Dumraon\,\ Bihar",
"912982", "Barmer\,\ Rajasthan",
"9174680", "Khandar\,\ Rajasthan",
"9177019", "Pingeshwar\,\ Madhya\ Pradesh",
"9174628", "Sawaimadhopur\,\ Rajasthan",
"9167845", "Bhadrak\,\ Odisha",
"9167262", "Jajapur\ Road\,\ Odisha",
"9174627", "Sawaimadhopur\,\ Rajasthan",
"915464", "Maunathbhanjan\,\ Uttar\ Pradesh",
"915176", "Lalitpur\,\ Uttar\ Pradesh",
"9166464", "Bargarh\,\ Odisha",
"9161153", "Danapur\,\ Bihar",
"9166853", "Sohela\,\ Odisha",
"9165666", "Japla\,\ Bihar",
"912955", "Malvi\/Fatehnagar\,\ Rajasthan",
"9165415", "Chatra\,\ Bihar",
"917375", "Narsingharh\,\ Madhya\ Pradesh",
"9174375", "Nainwa\,\ Rajasthan",
"9166555", "Titlagarh\,\ Odisha",
"917295", "Badnawar\,\ Madhya\ Pradesh",
"9174302", "Khanpur\,\ Rajasthan",
"9181753", "Holenarasipur\,\ Karnataka",
"9163256", "Pakribarwan\,\ Bihar",
"9164784", "Saharsa\,\ Bihar",
"914204", "Kodumudi\,\ Tamil\ Nadu",
"914268", "Velur\,\ Tamil\ Nadu",
"9164617", "Raniganj\,\ Bihar",
"918461", "Dichpalli\,\ Andhra\ Pradesh",
"9168484", "Kotagarh\,\ Odisha",
"9181938", "Hiriyur\,\ Karnataka",
"9174959", "Badarwas\,\ Madhya\ Pradesh",
"913862", "Dimapur\,\ Nagaland",
"9163315", "Imamganj\,\ Bihar",
"912908", "Amet\,\ Rajasthan",
"9174682", "Khandar\,\ Rajasthan",
"9176283", "Karpa\,\ Madhya\ Pradesh",
"9167653", "Palla\ Hara\,\ Odisha",
"9173935", "Jobat\,\ Madhya\ Pradesh",
"917560", "Ashta\,\ Madhya\ Pradesh",
"911336", "Deoband\,\ Uttar\ Pradesh",
"912964", "Dungarpur\,\ Rajasthan",
"9162225", "Sheohar\,\ Bihar",
"9174845", "Silwani\,\ Madhya\ Pradesh",
"9171474", "Multai\,\ Madhya\ Pradesh",
"912186", "Pandharpur\,\ Maharashtra",
"915967", "Dharchula\,\ Uttar\ Pradesh",
"9167627", "Dhenkanal\,\ Odisha",
"9174262", "Sitamau\,\ Madhya\ Pradesh",
"91122", "Hapur\,\ Uttar\ Pradesh",
"9167403", "Bhubaneshwar\,\ Odisha",
"9164797", "Udakishanganj\,\ Bihar",
"918479", "Shahapur\,\ Karnataka",
"917545", "Arone\,\ Madhya\ Pradesh",
"9176817", "Jatara\,\ Madhya\ Pradesh",
"911376", "Tehri\,\ Uttarakhand",
"9174543", "Chhipaborad\,\ Rajasthan",
"9176818", "Jatara\,\ Madhya\ Pradesh",
"9173956", "Sondhwa\,\ Madhya\ Pradesh",
"9168497", "Daringbadi\,\ Odisha",
"918849", "Kakinada\,\ Andhra\ Pradesh",
"917123", "Nagpur\,\ Maharashtra",
"9161355", "Bikram\,\ Bihar",
"918643", "Bapatla\,\ Andhra\ Pradesh",
"9166437", "Barkot\,\ Odisha",
"9181727", "Hassan\,\ Karnataka",
"915563", "Captanganj\/Khadda\,\ Uttar\ Pradesh",
"9181728", "Hassan\,\ Karnataka",
"9165286", "Khunti\,\ Bihar",
"913017", "Pokhran\/Madasar\,\ Rajasthan",
"9174653", "Sapotra\,\ Rajasthan",
"9163235", "Dumraon\,\ Bihar",
"9176252", "Umariapan\,\ Madhya\ Pradesh",
"9167682", "Parajang\,\ Odisha",
"918682", "Nalgonda\,\ Andhra\ Pradesh",
"9166827", "Attabira\,\ Odisha",
"9161127", "Biharsharif\,\ Bihar",
"912467", "Bhokar\,\ Maharashtra",
"917578", "Pachmarhi\,\ Madhya\ Pradesh",
"9168596", "Motu\,\ Odisha",
"912362", "Kudal\,\ Maharashtra",
"9174702", "Bundi\,\ Rajasthan",
"9162512", "Bagaha\,\ Bihar",
"9166536", "Dunguripali\,\ Odisha",
"9164384", "Madhupur\,\ Bihar",
"9166763", "M\.Rampur\,\ Odisha",
"9176389", "Damoh\,\ Madhya\ Pradesh",
"9174317", "Aklera\,\ Rajasthan",
"918723", "Sircilla\,\ Andhra\ Pradesh",
"9167237", "Athgarh\,\ Odisha",
"918493", "Madakasira\,\ Andhra\ Pradesh",
"9165477", "Chavparan\,\ Bihar",
"9174318", "Aklera\,\ Rajasthan",
"915241", "Ramsanehi\ Ghat\,\ Uttar\ Pradesh",
"9161865", "Aurangabad\,\ Bihar",
"9168453", "Phiringia\,\ Odisha",
"9176254", "Umariapan\,\ Madhya\ Pradesh",
"9167684", "Parajang\,\ Odisha",
"9176345", "Lamta\,\ Madhya\ Pradesh",
"912371", "Wathar\,\ Maharashtra",
"9174698", "Hindaun\,\ Rajasthan",
"912737", "Tharad\,\ Gujarat",
"9161563", "Gopalganj\,\ Bihar",
"9174704", "Bundi\,\ Rajasthan",
"913783", "Along\,\ Arunachal\ Pradesh",
"9164382", "Madhupur\,\ Bihar",
"9162514", "Bagaha\,\ Bihar",
"9174697", "Hindaun\,\ Rajasthan",
"9165576", "Bagodar\,\ Bihar",
"913663", "Goalpara\,\ Assam",
"915522", "Pharenda\/Compierganj\,\ Uttar\ Pradesh",
"91571", "Aligarh\,\ Uttar\ Pradesh",
"9164327", "Deoghar\,\ Bihar",
"912824", "Dhoraji\,\ Gujarat",
"9171472", "Multai\,\ Madhya\ Pradesh",
"918337", "Murugod\,\ Karnataka",
"9163377", "Arwal\,\ Bihar",
"913869", "Mon\,\ Nagaland",
"912135", "Rajgurunagar\,\ Maharashtra",
"9174264", "Sitamau\,\ Madhya\ Pradesh",
"9162295", "Bidupur\,\ Bihar",
"9171373", "Desaiganj\,\ Maharashtra",
"918244", "Mangalore\,\ Karnataka",
"9162447", "Khagaria\,\ Bihar",
"911398", "Kairana\/Shamli\,\ Uttar\ Pradesh",
"914328", "Perambalur\,\ Tamil\ Nadu",
"9168185", "Buguda\,\ Odisha",
"912323", "Ajara\,\ Maharashtra",
"9162546", "Bettiah\,\ Bihar",
"913831", "Champa\,\ Mizoram",
"9164753", "S\.Bakhtiarpur\,\ Bihar",
"911588", "Parbatsar\/Makrana\,\ Rajasthan",
"9164675", "Banmankhi\,\ Bihar",
"918472", "Gulbarga\,\ Karnataka",
"911595", "Jhunjhunu\/Bissau\,\ Rajasthan",
"9174237", "Neemuch\,\ Madhya\ Pradesh",
"918377", "Nargund\,\ Karnataka",
"9167317", "Anandapur\,\ Odisha",
"918731", "Utnor\,\ Andhra\ Pradesh",
"9171655", "Saunsar\,\ Madhya\ Pradesh",
"9171773", "Brahmapuri\,\ Maharashtra",
"9174238", "Neemuch\,\ Madhya\ Pradesh",
"9176459", "Karanjia\,\ Madhya\ Pradesh",
"9168482", "Kotagarh\,\ Odisha",
"916412", "Bhagalpur\,\ Bihar",
"912806", "Gogodar\,\ Gujarat",
"914366", "Tiruvarur\,\ Tamil\ Nadu",
"916317", "Gaya\,\ Bihar",
"9174684", "Khandar\,\ Rajasthan",
"913871", "Mao\/Korang\,\ Manipur",
"9176573", "Jaitpur\,\ Madhya\ Pradesh",
"9164353", "Pakur\,\ Bihar",
"9167697", "Kamakhyanagar\,\ Odisha",
"9172866", "Khetia\,\ Madhya\ Pradesh",
"913216", "Habra\,\ West\ Bengal",
"918594", "Chirala\,\ Andhra\ Pradesh",
"9165947", "Baharagora\,\ Bihar",
"918119", "Doddaballapur\,\ Karnataka",
"918689", "Miryalguda\,\ Andhra\ Pradesh",
"9162507", "Dhaka\,\ Bihar",
"914182", "Tiruvettipuram\,\ Tamil\ Nadu",
"9177079", "Bagbahera\,\ Madhya\ Pradesh",
"915734", "Debai\,\ Uttar\ Pradesh",
"9127177", "Sanand\,\ Gujarat",
"912148", "Karjat\,\ Maharashtra",
"912456", "Hingoli\,\ Maharashtra",
"9167264", "Jajapur\ Road\,\ Odisha",
"918510", "Koilkuntla\,\ Andhra\ Pradesh",
"9166462", "Bargarh\,\ Odisha",
"9168526", "Koraput\,\ Odisha",
"9168603", "Boriguma\,\ Odisha",
"9168427", "Phulbani\,\ Odisha",
"918384", "Sirsi\,\ Karnataka",
"918842", "Kakinada\,\ Andhra\ Pradesh",
"914143", "Virudhachalam\,\ Tamil\ Nadu",
"9174304", "Khanpur\,\ Rajasthan",
"9164782", "Saharsa\,\ Bihar",
"913823", "Belonia\,\ Tripura",
"9171843", "Bhandara\,\ Maharashtra",
"912664", "Pavijetpur\,\ Gujarat",
"915198", "Karvi\,\ Uttar\ Pradesh",
"918186", "Kargal\,\ Karnataka",
"918616", "Nellore\,\ Andhra\ Pradesh",
"9165402", "Govindpur\,\ Bihar",
"9161867", "Aurangabad\,\ Bihar",
"912762", "Mehsana\,\ Gujarat",
"911807", "Panipat\,\ Haryana",
"9165475", "Chavparan\,\ Bihar",
"91184", "Karnal\,\ Haryana",
"9167235", "Athgarh\,\ Odisha",
"9174315", "Aklera\,\ Rajasthan",
"9165303", "Bundu\,\ Bihar",
"9177033", "Manpur\,\ Madhya\ Pradesh",
"9174695", "Hindaun\,\ Rajasthan",
"9176348", "Lamta\,\ Madhya\ Pradesh",
"9171976", "Mohadi\,\ Maharashtra",
"9176266", "Vijayraghogarh\,\ Madhya\ Pradesh",
"9176347", "Lamta\,\ Madhya\ Pradesh",
"9175963", "Gyraspur\,\ Madhya\ Pradesh",
"9168187", "Buguda\,\ Odisha",
"9165683", "Balumath\,\ Bihar",
"918818", "Tadepalligudem\,\ Andhra\ Pradesh",
"9174256", "Garoth\,\ Madhya\ Pradesh",
"9162445", "Khagaria\,\ Bihar",
"9162297", "Bidupur\,\ Bihar",
"918229", "Gundlupet\,\ Karnataka",
"9163375", "Arwal\,\ Bihar",
"9164532", "Araria\,\ Bihar",
"912849", "Botad\,\ Gujarat",
"9164325", "Deoghar\,\ Bihar",
"912643", "Valia\,\ Gujarat",
"9176539", "Bandhavgarh\,\ Madhya\ Pradesh",
"918467", "Bodhan\,\ Andhra\ Pradesh",
"9164677", "Banmankhi\,\ Bihar",
"91202", "Pune\,\ Maharashtra",
"918362", "Hubli\,\ Karnataka",
"91477", "Alappuzha\,\ Kerala",
"918415", "Hyderabad\ East\/Ghatkeswar\,\ Andhra\ Pradesh",
"912112", "Baramati\,\ Maharashtra",
"9171623", "Chhindwara\,\ Madhya\ Pradesh",
"913650", "Dadengiri\/Phulbari\,\ Meghalaya",
"917748", "Dallirajhara\,\ Madhya\ Pradesh",
"9171657", "Saunsar\,\ Madhya\ Pradesh",
"9176306", "Katangi\,\ Madhya\ Pradesh",
"9167315", "Anandapur\,\ Odisha",
"9174235", "Neemuch\,\ Madhya\ Pradesh",
"9165542", "Rajdhanwar\,\ Bihar",
"9167695", "Kamakhyanagar\,\ Odisha",
"915961", "Munsiari\,\ Uttar\ Pradesh",
"911965", "Poonch\,\ Jammu\ And\ Kashmir",
"913561", "Jalpaiguri\,\ West\ Bengal",
"9165263", "Lohardaga\,\ Bihar",
"9171414", "Betul\,\ Madhya\ Pradesh",
"9165652", "Latehar\,\ Bihar",
"912461", "Mukhed\,\ Maharashtra",
"917690", "Lakhnadon\,\ Madhya\ Pradesh",
"9162572", "Barachakia\,\ Bihar",
"9167256", "Dhanmandal\,\ Odisha",
"912989", "Chohtan\,\ Rajasthan",
"913011", "Jaisalmer\/Pasewar\,\ Rajasthan",
"9127175", "Sanand\,\ Gujarat",
"9168194", "Surada\,\ Odisha",
"9162505", "Dhaka\,\ Bihar",
"917775", "Surajpur\,\ Madhya\ Pradesh",
"9165945", "Baharagora\,\ Bihar",
"9162284", "Pupri\,\ Bihar",
"9161834", "Buxar\,\ Bihar",
"9163262", "Sherghati\,\ Bihar",
"9168533", "Sunabeda\,\ Odisha",
"916636", "Sambalpur\,\ Odisha",
"9171446", "Atner\,\ Madhya\ Pradesh",
"911253", "Tohsham\,\ Haryana",
"911502", "Nohar\/Jedasar\,\ Rajasthan",
"918964", "Saluru\,\ Andhra\ Pradesh",
"911954", "Sopore\,\ Jammu\ And\ Kashmir",
"9168425", "Phulbani\,\ Odisha",
"915672", "Mainpuri\,\ Uttar\ Pradesh",
"918263", "Mudigere\,\ Karnataka",
"912439", "Golegaon\,\ Maharashtra",
"914635", "Nanguneri\,\ Tamil\ Nadu",
"9167957", "Udala\,\ Odisha",
"911531", "Nokha\,\ Rajasthan",
"9174822", "Raisen\,\ Madhya\ Pradesh",
"9164257", "Katoria\,\ Bihar",
"918425", "Biligi\,\ Karnataka",
"9174640", "Karauli\,\ Rajasthan",
"917864", "Sukma\,\ Madhya\ Pradesh",
"9168634", "Bisam\ Cuttack\,\ Odisha",
"9165496", "Bermo\,\ Bihar",
"9166707", "Bhawanipatna\,\ Odisha",
"9181729", "Hassan\,\ Karnataka",
"9165365", "Palkot\,\ Bihar",
"9171995", "Deori\,\ Maharashtra",
"9165597", "Simaria\,\ Bihar",
"9174676", "Bamanwas\,\ Rajasthan",
"918559", "Dharmavaram\,\ Andhra\ Pradesh",
"9174333", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"9161507", "Hathua\,\ Bihar",
"918150", "Bagepalli\,\ Karnataka",
"9177015", "Pingeshwar\,\ Madhya\ Pradesh",
"918219", "Mysore\,\ Karnataka",
"911569", "Sujangarh\/Lalgarh\,\ Rajasthan",
"9167213", "Narsinghpur\,\ Odisha",
"913485", "Dhuliyan\,\ West\ Bengal",
"9176560", "Kannodi\,\ Madhya\ Pradesh",
"9175905", "Lateri\,\ Madhya\ Pradesh",
"914282", "Attur\,\ Tamil\ Nadu",
"917363", "Berchha\,\ Madhya\ Pradesh",
"917606", "Jabera\,\ Madhya\ Pradesh",
"917855", "Chingmut\,\ Madhya\ Pradesh",
"911424", "Phulera\/Renwal\,\ Rajasthan",
"9171866", "Sakoli\,\ Maharashtra",
"9174550", "Digod\/Sultanpur\,\ Rajasthan",
"912585", "Yawal\,\ Maharashtra",
"9168222", "Aska\,\ Odisha",
"911341", "Najibabad\,\ Uttar\ Pradesh",
"9163465", "Lakhisarai\,\ Bihar",
"9175290", "Laher\,\ Madhya\ Pradesh",
"9187594", "Outsarangapalle\,\ Andhra\ Pradesh",
"9176324", "Balaghat\,\ Madhya\ Pradesh",
"918626", "Kavali\,\ Andhra\ Pradesh",
"9174923", "Shivpuri\,\ Madhya\ Pradesh",
"9166267", "Banaigarh\,\ Odisha",
"9176819", "Jatara\,\ Madhya\ Pradesh",
"918668", "Vijayawada\,\ Andhra\ Pradesh",
"9171524", "Wardha\,\ Maharashtra",
"911523", "Bikaner\/Poogal\,\ Rajasthan",
"9167822", "Balasore\,\ Odisha",
"914884", "Vadakkanchery\,\ Kerala",
"9174957", "Badarwas\,\ Madhya\ Pradesh",
"914342", "Dharmapuri\,\ Tamil\ Nadu",
"915548", "Khalilabad\/Mehdawal\,\ Uttar\ Pradesh",
"9176493", "Kakaiya\,\ Madhya\ Pradesh",
"9181939", "Hiriyur\,\ Karnataka",
"9161546", "Siwan\,\ Bihar",
"9174958", "Badarwas\,\ Madhya\ Pradesh",
"917624", "Sihora\,\ Madhya\ Pradesh",
"9171093", "Kamptee\,\ Maharashtra",
"9167676", "Barbil\,\ Odisha",
"9165272", "Kolebira\,\ Bihar",
"917262", "Buldhana\,\ Maharashtra",
"9174213", "Manasa\,\ Madhya\ Pradesh",
"9165584", "Dumri\(Isribazar\)\,\ Bihar",
"912598", "Umrane\,\ Maharashtra",
"9167333", "Ghatgaon\,\ Odisha",
"9174629", "Sawaimadhopur\,\ Rajasthan",
"9168667", "Umerkote\,\ Odisha",
"9161514", "Sidhawalia\,\ Bihar",
"912191", "Poladpur\,\ Maharashtra",
"914997", "Kanhangad\,\ Kerala",
"911571", "Fatehpur\,\ Rajasthan",
"9181740", "Arsikere\,\ Karnataka",
"9162563", "Ramnagar\,\ Bihar",
"911605", "Kharar\,\ Punjab",
"918630", "Guntur\,\ Andhra\ Pradesh",
"91485", "Muvattupuzha\,\ Kerala",
"9174135", "Sailana\,\ Madhya\ Pradesh",
"9166714", "Rajkhariar\,\ Odisha",
"918788", "Karimnagar\,\ Andhra\ Pradesh",
"9163273", "Rafiganj\,\ Bihar",
"9167887", "Soro\,\ Odisha",
"9167923", "Baripada\,\ Odisha",
"9164223", "Godda\,\ Bihar",
"911281", "Jatusana\,\ Haryana",
"9162242", "Hajipur\,\ Bihar",
"9166705", "Bhawanipatna\,\ Odisha",
"9165367", "Palkot\,\ Bihar",
"9167642", "Anugul\,\ Odisha",
"918536", "Kustagi\,\ Karnataka",
"9165893", "Jhinkpani\,\ Bihar",
"914862", "Thodupuzha\,\ Kerala",
"912970", "Sanchore\/Hadecha\,\ Rajasthan",
"9162424", "Benipur\,\ Bihar",
"9174326", "Jhalawar\,\ Rajasthan",
"9165246", "Gumla\,\ Bihar",
"9166772", "Narlaroad\,\ Odisha",
"9164255", "Katoria\,\ Bihar",
"9164344", "Dumka\,\ Bihar",
"9175224", "Datia\,\ Madhya\ Pradesh",
"917574", "Hoshangabad\,\ Madhya\ Pradesh",
"911999", "Mahore\,\ Jammu\ And\ Kashmir",
"9161803", "Adhaura\,\ Bihar",
"9167955", "Udala\,\ Odisha",
"915252", "Bahraich\/Bahrailh\,\ Uttar\ Pradesh",
"912746", "Radhanpur\,\ Gujarat",
"9168504", "Kalimela\,\ Odisha",
"9175907", "Lateri\,\ Madhya\ Pradesh",
"9177017", "Pingeshwar\,\ Madhya\ Pradesh",
"917284", "Rajpur\,\ Madhya\ Pradesh",
"913751", "Digboi\,\ Assam",
"9161505", "Hathua\,\ Bihar",
"9162793", "Barauni\,\ Bihar",
"9165595", "Simaria\,\ Bihar",
"9175908", "Lateri\,\ Madhya\ Pradesh",
"9171997", "Deori\,\ Maharashtra",
"9161572", "Mairwa\,\ Bihar",
"9177018", "Pingeshwar\,\ Madhya\ Pradesh",
"9174936", "Karera\,\ Madhya\ Pradesh",
"9174849", "Silwani\,\ Madhya\ Pradesh",
"9163467", "Lakhisarai\,\ Bihar",
"9171362", "Etapalli\,\ Maharashtra",
"9164316", "Jharmundi\,\ Bihar",
"9174583", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"9181742", "Arsikere\,\ Karnataka",
"917722", "Dhamtari\,\ Madhya\ Pradesh",
"9171463", "Ghorandogri\,\ Madhya\ Pradesh",
"9162276", "Mahua\,\ Bihar",
"9171854", "Pauni\,\ Maharashtra",
"9167552", "Khurda\,\ Odisha",
"9166265", "Banaigarh\,\ Odisha",
"912926", "Osian\/Mathania\,\ Rajasthan",
"918702", "Warangal\,\ Andhra\ Pradesh",
"91354", "Darjeeling\,\ West\ Bengal",
"9166842", "Paikamal\,\ Odisha",
"9161142", "Jahanabad\,\ Bihar",
"918713", "Parkal\,\ Andhra\ Pradesh",
"9167326", "Hindol\,\ Odisha",
"9171762", "Warora\,\ Maharashtra",
"9174642", "Karauli\,\ Rajasthan",
"9175946", "Ganjbasoda\,\ Madhya\ Pradesh",
"9164716", "Birpur\,\ Bihar",
"917237", "Marigaon\,\ Maharashtra",
"912904", "Deogarh\,\ Rajasthan",
"913802", "Roing\/Arda\,\ Arunachal\ Pradesh",
"9174955", "Badarwas\,\ Madhya\ Pradesh",
"915854", "Sandila\,\ Uttar\ Pradesh",
"912552", "Nandgaon\,\ Maharashtra",
"9174820", "Raisen\,\ Madhya\ Pradesh",
"917791", "Gadarwara\,\ Madhya\ Pradesh",
"912968", "Bagidora\,\ Rajasthan",
"918520", "Pattikonda\,\ Andhra\ Pradesh",
"9173939", "Jobat\,\ Madhya\ Pradesh",
"9176562", "Kannodi\,\ Madhya\ Pradesh",
"9171984", "Tirora\,\ Maharashtra",
"9173293", "Khakner\,\ Madhya\ Pradesh",
"911692", "Tohana\,\ Haryana",
"917843", "Durgakondal\,\ Madhya\ Pradesh",
"9168444", "Kantamal\,\ Odisha",
"918576", "Satyavedu\,\ Andhra\ Pradesh",
"9164236", "Maheshpur\ Raj\,\ Bihar",
"912930", "Bilara\/Piparcity\,\ Rajasthan",
"9167936", "Betanati\,\ Odisha",
"9166473", "Naktideul\,\ Odisha",
"915865", "Misrikh\,\ Uttar\ Pradesh",
"9174552", "Digod\/Sultanpur\,\ Rajasthan",
"917473", "Bundi\,\ Rajasthan",
"9175914", "Sironj\,\ Madhya\ Pradesh",
"917534", "Bhind\,\ Madhya\ Pradesh",
"9165334", "Basia\,\ Bihar",
"9177004", "Nagri\,\ Madhya\ Pradesh",
"9168665", "Umerkote\,\ Odisha",
"9167583", "Nimapara\,\ Odisha",
"913452", "Guskara\,\ West\ Bengal",
"916516", "Ranchi\,\ Bihar",
"9174138", "Sailana\,\ Madhya\ Pradesh",
"9174379", "Nainwa\,\ Rajasthan",
"9168416", "Boudh\,\ Odisha",
"914255", "Palladam\,\ Tamil\ Nadu",
"914567", "Ramanathpuram\,\ Tamil\ Nadu",
"9167885", "Soro\,\ Odisha",
"9174137", "Sailana\,\ Madhya\ Pradesh",
"9175292", "Laher\,\ Madhya\ Pradesh",
"911633", "Muktasar\,\ Punjab",
"9166256", "Lahunipara\,\ Odisha",
"917790", "Babaichichli\,\ Madhya\ Pradesh",
"917846", "Garpa\,\ Madhya\ Pradesh",
"913581", "Dinhata\,\ West\ Bengal",
"911985", "Kargil\,\ Jammu\ And\ Kashmir",
"917675", "Amarpatan\,\ Madhya\ Pradesh",
"9176532", "Bandhavgarh\,\ Madhya\ Pradesh",
"9177046", "Deobhog\,\ Madhya\ Pradesh",
"9187595", "Outsarangapalle\,\ Andhra\ Pradesh",
"9176325", "Balaghat\,\ Madhya\ Pradesh",
"9177070", "Bagbahera\,\ Madhya\ Pradesh",
"9163464", "Lakhisarai\,\ Bihar",
"914735", "Ranni\,\ Kerala",
"9171857", "Pauni\,\ Maharashtra",
"9171732", "Rajura\,\ Maharashtra",
"911435", "Tonk\/Piploo\,\ Rajasthan",
"9177014", "Pingeshwar\,\ Madhya\ Pradesh",
"918283", "Salkani\,\ Karnataka",
"911636", "Moga\,\ Punjab",
"9175904", "Lateri\,\ Madhya\ Pradesh",
"9162752", "Rosera\,\ Bihar",
"9168507", "Kalimela\,\ Odisha",
"9171994", "Deori\,\ Maharashtra",
"916513", "Ranchi\,\ Bihar",
"912931", "Jodhpur\/Jhanwar\,\ Rajasthan",
"9162526", "Motihari\,\ Bihar",
"917757", "Shakti\,\ Madhya\ Pradesh",
"9162427", "Benipur\,\ Bihar",
"917476", "Bundi\,\ Rajasthan",
"918242", "Mangalore\,\ Karnataka",
"9175228", "Datia\,\ Madhya\ Pradesh",
"9165364", "Palkot\,\ Bihar",
"912969", "Bhinmal\,\ Rajasthan",
"9168635", "Bisam\ Cuttack\,\ Odisha",
"918573", "Bangarupalem\,\ Andhra\ Pradesh",
"9171186", "Kalmeshwar\,\ Maharashtra",
"913223", "Nayagarh\/Kultikri\,\ West\ Bengal",
"9176450", "Karanjia\,\ Madhya\ Pradesh",
"9164266", "Rajmahal\,\ Bihar",
"9164347", "Dumka\,\ Bihar",
"9175227", "Datia\,\ Madhya\ Pradesh",
"915524", "Pharenda\/Anand\ Nagar\,\ Uttar\ Pradesh",
"9167966", "Karanjia\,\ Odisha",
"912481", "Ner\,\ Maharashtra",
"9168406", "Tumudibandha\,\ Odisha",
"9165852", "Ghatsila\,\ Bihar",
"912822", "Morvi\,\ Gujarat",
"9161813", "Piro\,\ Bihar",
"911676", "Sunam\,\ Punjab",
"914177", "Arkonam\,\ Tamil\ Nadu",
"915841", "Tilhar\,\ Uttar\ Pradesh",
"912971", "Pindwara\,\ Rajasthan",
"9162453", "Gogri\,\ Bihar",
"916414", "Bhagalpur\,\ Bihar",
"912527", "Shahapur\,\ Maharashtra",
"9174134", "Sailana\,\ Madhya\ Pradesh",
"9166715", "Rajkhariar\,\ Odisha",
"9177008", "Nagri\,\ Madhya\ Pradesh",
"916807", "Berhampur\,\ Odisha",
"9174593", "Ramganj\ Mandi\,\ Rajasthan",
"9168176", "R\.Udayigiri\,\ Odisha",
"9175918", "Sironj\,\ Madhya\ Pradesh",
"9165337", "Basia\,\ Bihar",
"9177007", "Nagri\,\ Madhya\ Pradesh",
"9161515", "Sidhawalia\,\ Bihar",
"918533", "Gangavathi\,\ Karnataka",
"9175917", "Sironj\,\ Madhya\ Pradesh",
"918474", "Chittapur\,\ Karnataka",
"9168656", "Kashipur\,\ Odisha",
"912891", "Jamkalyanpur\,\ Gujarat",
"9171823", "Gondia\,\ Maharashtra",
"912662", "Padra\,\ Gujarat",
"9171987", "Tirora\,\ Maharashtra",
"9162783", "Dalsinghsarai\,\ Bihar",
"918716", "Jangaon\,\ Andhra\ Pradesh",
"9165585", "Dumri\(Isribazar\)\,\ Bihar",
"918844", "Kakinada\,\ Andhra\ Pradesh",
"918382", "Karwar\,\ Karnataka",
"9168447", "Kantamal\,\ Odisha",
"918487", "Shirahatti\,\ Karnataka",
"912923", "Phalodi\/Lohawat\,\ Rajasthan",
"913797", "Pangin\,\ Arunachal\ Pradesh",
"911998", "Ramban\,\ Jammu\ And\ Kashmir",
"9171433", "Bhainsdehi\,\ Madhya\ Pradesh",
"9168546", "Jeypore\,\ Odisha",
"9176380", "Damoh\,\ Madhya\ Pradesh",
"9171525", "Wardha\,\ Maharashtra",
"9174966", "Pichhore\,\ Madhya\ Pradesh",
"915732", "Bulandshahr\,\ Uttar\ Pradesh",
"918937", "Chintapalle\,\ Andhra\ Pradesh",
"918592", "Ongole\,\ Andhra\ Pradesh",
"9171332", "Aheri\,\ Maharashtra",
"9165883", "Jagarnathpur\,\ Bihar",
"911475", "Begun\/Rawatbhata\,\ Rajasthan",
"9176327", "Balaghat\,\ Madhya\ Pradesh",
"91452", "Madurai\,\ Tamil\ Nadu",
"9187597", "Outsarangapalle\,\ Andhra\ Pradesh",
"918789", "Karimnagar\,\ Andhra\ Pradesh",
"918355", "Bableshwar\,\ Karnataka",
"9168142", "Digapahandi\,\ Odisha",
"91217", "Sholapur\,\ Maharashtra",
"9176328", "Balaghat\,\ Madhya\ Pradesh",
"915361", "Musafirkhana\,\ Uttar\ Pradesh",
"9166264", "Banaigarh\,\ Odisha",
"9171553", "Seloo\,\ Maharashtra",
"91265", "Vadodara\,\ Gujarat",
"912677", "Limkheda\,\ Gujarat",
"9174203", "Jawad\,\ Madhya\ Pradesh",
"9171855", "Pauni\,\ Maharashtra",
"912764", "Kalol\,\ Gujarat",
"911526", "Lunkaransar\/Mahajan\,\ Rajasthan",
"9163456", "Jamui\,\ Bihar",
"9168572", "Gunupur\,\ Odisha",
"912114", "Lonavala\,\ Maharashtra",
"9165594", "Simaria\,\ Bihar",
"9171643", "Pandhurna\,\ Madhya\ Pradesh",
"912599", "Bhudargad\/Gargoti\,\ Maharashtra",
"9168505", "Kalimela\,\ Odisha",
"911570", "Laxmangarh\/Nechwa\,\ Rajasthan",
"918364", "Hubli\,\ Karnataka",
"9161504", "Hathua\,\ Bihar",
"911659", "Sardulgarh\,\ Punjab",
"9164254", "Katoria\,\ Bihar",
"9175225", "Datia\,\ Madhya\ Pradesh",
"9164345", "Dumka\,\ Bihar",
"9176483", "Mawai\,\ Madhya\ Pradesh",
"9162533", "Narkatiaganj\,\ Bihar",
"911853", "Rayya\,\ Punjab",
"9167954", "Udala\,\ Odisha",
"912755", "Sayla\,\ Gujarat",
"9168637", "Bisam\ Cuttack\,\ Odisha",
"9166704", "Bhawanipatna\,\ Odisha",
"918863", "Chavitidibbalu\,\ Andhra\ Pradesh",
"917328", "Khalwa\,\ Madhya\ Pradesh",
"9176382", "Damoh\,\ Madhya\ Pradesh",
"918669", "Vijayawada\,\ Andhra\ Pradesh",
"9165356", "Chainpur\,\ Bihar",
"9162425", "Benipur\,\ Bihar",
"918671", "Divi\/Challapalli\,\ Andhra\ Pradesh",
"9174363", "Hindoli\,\ Rajasthan",
"9166717", "Rajkhariar\,\ Odisha",
"9176530", "Bandhavgarh\,\ Madhya\ Pradesh",
"917366", "Khachrod\,\ Madhya\ Pradesh",
"918505", "Kodangal\,\ Andhra\ Pradesh",
"9171582", "Deoli\,\ Maharashtra",
"9167884", "Soro\,\ Odisha",
"91124", "Gurgaon\,\ Haryana",
"9175915", "Sironj\,\ Madhya\ Pradesh",
"917525", "Bhitarwar\,\ Madhya\ Pradesh",
"9168664", "Umerkote\,\ Odisha",
"9161517", "Sidhawalia\,\ Bihar",
"9165335", "Basia\,\ Bihar",
"918151", "Malur\,\ Karnataka",
"9177005", "Nagri\,\ Madhya\ Pradesh",
"915165", "Konch\,\ Uttar\ Pradesh",
"9177072", "Bagbahera\,\ Madhya\ Pradesh",
"918829", "Bhimadole\,\ Andhra\ Pradesh",
"918623", "Sullurpet\,\ Andhra\ Pradesh",
"918218", "Mysore\,\ Karnataka",
"911568", "Sujangarh\,\ Rajasthan",
"911952", "Baramulla\,\ Jammu\ And\ Kashmir",
"9168445", "Kantamal\,\ Odisha",
"9165587", "Dumri\(Isribazar\)\,\ Bihar",
"911504", "Bhadra\,\ Rajasthan",
"918558", "Tadipatri\,\ Andhra\ Pradesh",
"9171426", "Bhimpur\,\ Madhya\ Pradesh",
"9171985", "Tirora\,\ Maharashtra",
"9171052", "Narkhed\,\ Maharashtra",
"912637", "Navsari\,\ Gujarat",
"9174954", "Badarwas\,\ Madhya\ Pradesh",
"9165486", "Ichak\,\ Bihar",
"9176452", "Karanjia\,\ Madhya\ Pradesh",
"9171527", "Wardha\,\ Maharashtra",
"917603", "Tendukheda\,\ Madhya\ Pradesh",
"9164573", "Korha\,\ Bihar",
"9176353", "Lanji\,\ Madhya\ Pradesh",
"9171836", "Tumsar\,\ Maharashtra",
"912438", "Soyegaon\,\ Maharashtra",
"9165233", "Ghaghra\,\ Bihar",
"9164674", "Banmankhi\,\ Bihar",
"917862", "Bastanar\,\ Madhya\ Pradesh",
"9181749", "Arsikere\,\ Karnataka",
"9162294", "Bidupur\,\ Bihar",
"9174265", "Sitamau\,\ Madhya\ Pradesh",
"9174620", "Sawaimadhopur\,\ Rajasthan",
"912988", "Pachpadra\/Balotra\,\ Rajasthan",
"9168184", "Buguda\,\ Odisha",
"9174842", "Silwani\,\ Madhya\ Pradesh",
"914574", "Manamadurai\,\ Tamil\ Nadu",
"912835", "Nakhatrana\,\ Gujarat",
"911733", "Kalka\,\ Haryana",
"915960", "Shahabad\,\ Uttar\ Pradesh",
"9174943", "Kolaras\,\ Madhya\ Pradesh",
"9174705", "Bundi\,\ Rajasthan",
"9162515", "Bagaha\,\ Bihar",
"918266", "Narsimharajapur\,\ Karnataka",
"913010", "Jaisalmer\/Shahgarh\,\ Rajasthan",
"9168563", "Rayagada\,\ Odisha",
"9176255", "Umariapan\,\ Madhya\ Pradesh",
"9163232", "Dumraon\,\ Bihar",
"9167685", "Parajang\,\ Odisha",
"916633", "Sambalpur\,\ Odisha",
"9176344", "Lamta\,\ Madhya\ Pradesh",
"917691", "Chhapara\,\ Madhya\ Pradesh",
"912460", "Delhi\ Tanda\,\ Maharashtra",
"9161864", "Aurangabad\,\ Bihar",
"911422", "Viratnagar\/Shahpura\,\ Rajasthan",
"911881", "Ropar\,\ Punjab",
"911792", "Solan\,\ Himachal\ Pradesh",
"91451", "Dindigul\,\ Tamil\ Nadu",
"917749", "Balod\,\ Madhya\ Pradesh",
"9181930", "Hiriyur\,\ Karnataka",
"9161352", "Bikram\,\ Bihar",
"9174305", "Khanpur\,\ Rajasthan",
"9175299", "Laher\,\ Madhya\ Pradesh",
"9165313", "Mandar\,\ Bihar",
"9175933", "Kurwai\,\ Madhya\ Pradesh",
"9166726", "Dharamgarh\,\ Odisha",
"917264", "Chikhali\,\ Maharashtra",
"9166552", "Titlagarh\,\ Odisha",
"9174372", "Nainwa\,\ Rajasthan",
"9176810", "Jatara\,\ Madhya\ Pradesh",
"917622", "Katni\,\ Madhya\ Pradesh",
"912445", "Kaij\,\ Maharashtra",
"9165412", "Chatra\,\ Bihar",
"9161526", "Chapra\,\ Bihar",
"9174559", "Digod\/Sultanpur\,\ Rajasthan",
"9167265", "Jajapur\ Road\,\ Odisha",
"912848", "Palitana\,\ Gujarat",
"9177063", "Gariaband\,\ Madhya\ Pradesh",
"918613", "Nellore\,\ Andhra\ Pradesh",
"918183", "Sagar\,\ Karnataka",
"9162287", "Pupri\,\ Bihar",
"918228", "H\.D\.Kote\,\ Karnataka",
"911491", "Nasirabad\,\ Rajasthan",
"9161837", "Buxar\,\ Bihar",
"914344", "Hosur\,\ Tamil\ Nadu",
"915495", "Saidpur\,\ Uttar\ Pradesh",
"9168197", "Surada\,\ Odisha",
"9165693", "Garu\,\ Bihar",
"918819", "Tanuku\,\ Andhra\ Pradesh",
"9167842", "Bhadrak\,\ Odisha",
"9164243", "Banka\,\ Bihar",
"9163413", "Seikhpura\,\ Bihar",
"9162222", "Sheohar\,\ Bihar",
"912478", "Bhoom\,\ Maharashtra",
"917255", "Barshi\ Takli\,\ Maharashtra",
"9167943", "Rairangpur\,\ Odisha",
"9176569", "Kannodi\,\ Madhya\ Pradesh",
"9173932", "Jobat\,\ Madhya\ Pradesh",
"917515", "Gwalior\,\ Madhya\ Pradesh",
"9171417", "Betul\,\ Madhya\ Pradesh",
"912995", "Pokhran\/Nachna\,\ Rajasthan",
"9189463", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"9163312", "Imamganj\,\ Bihar",
"9174685", "Khandar\,\ Rajasthan",
"9171516", "Samudrapur\,\ Maharashtra",
"913651", "Tura\,\ Meghalaya",
"9171654", "Saunsar\,\ Madhya\ Pradesh",
"912646", "Ankleshwar\,\ Gujarat",
"912875", "Una\/Diu\,\ Gujarat",
"9181720", "Hassan\,\ Karnataka",
"915945", "Haldwani\/Chorgalian\,\ Uttar\ Pradesh",
"91562", "Agra\,\ Uttar\ Pradesh",
"9174649", "Karauli\,\ Rajasthan",
"9176812", "Jatara\,\ Madhya\ Pradesh",
"913213", "Dhaniakhali\,\ West\ Bengal",
"9174370", "Nainwa\,\ Rajasthan",
"9164792", "Udakishanganj\,\ Bihar",
"918730", "Khanapur\,\ Andhra\ Pradesh",
"912803", "Khavda\,\ Gujarat",
"917282", "Khargone\,\ Madhya\ Pradesh",
"915254", "Nanparah\/Mihinpurwa\,\ Uttar\ Pradesh",
"917572", "Itarsi\,\ Madhya\ Pradesh",
"916747", "Bhubaneshwar\,\ Odisha",
"9163374", "Arwal\,\ Bihar",
"912149", "Mahasala\,\ Maharashtra",
"9174268", "Sitamau\,\ Madhya\ Pradesh",
"9164324", "Deoghar\,\ Bihar",
"913870", "Ukhrursouth\/Kassemkhulen\,\ Manipur",
"914864", "Adimaly\,\ Kerala",
"9165226", "Muri\,\ Bihar",
"9162444", "Khagaria\,\ Bihar",
"9174346", "Pirawa\/Raipur\,\ Rajasthan",
"9167622", "Dhenkanal\,\ Odisha",
"9174267", "Sitamau\,\ Madhya\ Pradesh",
"91223", "Mumbai",
"918118", "Nelamangala\,\ Karnataka",
"9168613", "Malkangiri\,\ Odisha",
"915265", "Utraula\,\ Uttar\ Pradesh",
"9166822", "Attabira\,\ Odisha",
"9161122", "Biharsharif\,\ Bihar",
"913826", "Ambasa\,\ Tripura",
"9174708", "Bundi\,\ Rajasthan",
"9176257", "Umariapan\,\ Madhya\ Pradesh",
"9167687", "Parajang\,\ Odisha",
"9173930", "Jobat\,\ Madhya\ Pradesh",
"918704", "Warangal\,\ Andhra\ Pradesh",
"9174694", "Hindaun\,\ Rajasthan",
"918251", "Puttur\,\ Karnataka",
"9162517", "Bagaha\,\ Bihar",
"9176258", "Umariapan\,\ Madhya\ Pradesh",
"9174707", "Bundi\,\ Rajasthan",
"914146", "Villupuram\,\ Tamil\ Nadu",
"9165474", "Chavparan\,\ Bihar",
"912453", "Gangakhed\,\ Maharashtra",
"9168492", "Daringbadi\,\ Odisha",
"9181722", "Hassan\,\ Karnataka",
"9167234", "Athgarh\,\ Odisha",
"9166432", "Barkot\,\ Odisha",
"9174314", "Aklera\,\ Rajasthan",
"917724", "Basana\,\ Madhya\ Pradesh",
"9175216", "Seondha\,\ Madhya\ Pradesh",
"9161856", "Bikramganj\,\ Bihar",
"9174829", "Raisen\,\ Madhya\ Pradesh",
"91389", "Aizawal\,\ Mizoram",
"917410", "Alot\,\ Madhya\ Pradesh",
"914262", "Gudalur\,\ Tamil\ Nadu",
"913786", "Khonsa\,\ Arunachal\ Pradesh",
"9168424", "Phulbani\,\ Odisha",
"913465", "Nalhati\,\ West\ Bengal",
"915240", "Fatehpur\,\ Uttar\ Pradesh",
"9174308", "Khanpur\,\ Rajasthan",
"911589", "Parbatsar\,\ Rajasthan",
"9174876", "Begamganj\,\ Madhya\ Pradesh",
"9174307", "Khanpur\,\ Rajasthan",
"9161533", "Maharajganj\,\ Bihar",
"9127174", "Sanand\,\ Gujarat",
"914329", "Ariyalur\,\ Tamil\ Nadu",
"9168195", "Surada\,\ Odisha",
"915852", "Hardoi\,\ Uttar\ Pradesh",
"9162504", "Dhaka\,\ Bihar",
"913804", "Tezu\,\ Arunachal\ Pradesh",
"912554", "Malegaon\,\ Maharashtra",
"9174840", "Silwani\,\ Madhya\ Pradesh",
"9161835", "Buxar\,\ Bihar",
"917447", "Ladpura\/Kota\,\ Rajasthan",
"9162285", "Pupri\,\ Bihar",
"9165944", "Baharagora\,\ Bihar",
"9166733", "Jayapatna\,\ Odisha",
"912902", "Barmer\/Kanot\,\ Rajasthan",
"9175926", "Vidisha\,\ Madhya\ Pradesh",
"9174622", "Sawaimadhopur\,\ Rajasthan",
"9167267", "Jajapur\ Road\,\ Odisha",
"918496", "Uravakonda\,\ Andhra\ Pradesh",
"9174687", "Khandar\,\ Rajasthan",
"9171415", "Betul\,\ Madhya\ Pradesh",
"915413", "Chakia\,\ Uttar\ Pradesh",
"918770", "Tirupathi\,\ Andhra\ Pradesh",
"912326", "Gaganbavada\,\ Maharashtra",
"9174688", "Khandar\,\ Rajasthan",
"9167694", "Kamakhyanagar\,\ Odisha",
"913454", "Kalna\,\ West\ Bengal",
"9167314", "Anandapur\,\ Odisha",
"917532", "Morena\,\ Madhya\ Pradesh",
"9174234", "Neemuch\,\ Madhya\ Pradesh",
"913830", "Champai\/Chiapui\,\ Mizoram",
"9171666", "Chaurai\,\ Madhya\ Pradesh",
"913666", "Barpeta\ Road\,\ Assam",
"912565", "Shahada\,\ Maharashtra",
"9164612", "Raniganj\,\ Bihar",
"9165916", "Chandil\,\ Bihar",
"9166213", "Hemgiri\,\ Odisha",
"91227", "Mumbai",
"9164246", "Banka\,\ Bihar",
"9163416", "Seikhpura\,\ Bihar",
"9164367", "Sahibganj\,\ Bihar",
"9167946", "Rairangpur\,\ Odisha",
"9171815", "Lakhandur\,\ Maharashtra",
"9164734", "Supaul\,\ Bihar",
"917474", "Bundi\,\ Rajasthan",
"9165344", "Jhumaritalaiya\,\ Bihar",
"9189466", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"9174224", "Mandsaur\,\ Madhya\ Pradesh",
"9172879", "Gogaon\,\ Madhya\ Pradesh",
"917533", "Karhal\,\ Madhya\ Pradesh",
"9165255", "Simdega\,\ Bihar",
"9171513", "Samudrapur\,\ Maharashtra",
"9174148", "Jaora\,\ Madhya\ Pradesh",
"9174907", "Pohari\,\ Madhya\ Pradesh",
"918351", "Hungund\,\ Karnataka",
"915412", "Chandauli\/Mugalsarai\,\ Uttar\ Pradesh",
"9174147", "Jaora\,\ Madhya\ Pradesh",
"9164595", "Thakurganj\,\ Bihar",
"9174908", "Pohari\,\ Madhya\ Pradesh",
"915317", "Dalmau\,\ Uttar\ Pradesh",
"911634", "Abohar\,\ Punjab",
"9165316", "Mandar\,\ Bihar",
"9174632", "Gangapur\,\ Rajasthan",
"9175936", "Kurwai\,\ Madhya\ Pradesh",
"912903", "Chohtan\/Gangasar\,\ Rajasthan",
"9166723", "Dharamgarh\,\ Odisha",
"91233", "Sangli\,\ Maharashtra",
"9161825", "Arrah\,\ Bihar",
"912751", "Chotila\,\ Gujarat",
"9167914", "Bangiriposi\,\ Odisha",
"915853", "Shahabad\,\ Uttar\ Pradesh",
"9164214", "Naugachia\,\ Bihar",
"915280", "Rath\,\ Uttar\ Pradesh",
"9163444", "Monghyr\,\ Bihar",
"9173949", "Alirajpur\,\ Madhya\ Pradesh",
"9161523", "Chapra\,\ Bihar",
"9174578", "Mangrol\,\ Rajasthan",
"9177066", "Gariaband\,\ Madhya\ Pradesh",
"9166494", "Jamankira\,\ Odisha",
"9173210", "Sanwer\,\ Madhya\ Pradesh",
"9167292", "Pattamundai\,\ Odisha",
"918635", "Guntur\,\ Andhra\ Pradesh",
"9168434", "Puruna\ Katak\,\ Odisha",
"9174577", "Mangrol\,\ Rajasthan",
"9165696", "Garu\,\ Bihar",
"917844", "Pakhanjur\,\ Madhya\ Pradesh",
"9174946", "Kolaras\,\ Madhya\ Pradesh",
"9162774", "Phulparas\,\ Bihar",
"9185869", "Vayalpad\,\ Andhra\ Pradesh",
"912357", "Malgund\,\ Maharashtra",
"9166422", "Kuchinda\,\ Odisha",
"9168566", "Rayagada\,\ Odisha",
"9167224", "Pardip\,\ Odisha",
"918155", "Gowribidanur\,\ Karnataka",
"9161557", "Ekma\,\ Bihar",
"9181732", "Sakleshpur\,\ Karnataka",
"91795", "Ahmedabad\ Local\,\ Gujarat",
"912452", "Parbhani\,\ Maharashtra",
"916615", "Rourkela\,\ Odisha",
"9175955", "Nateran\,\ Madhya\ Pradesh",
"918846", "Kakinada\,\ Andhra\ Pradesh",
"9168467", "Baliguda\,\ Odisha",
"9164207", "Amarpur\,\ Bihar",
"918501", "Kollapur\,\ Andhra\ Pradesh",
"9173920", "Jhabua\,\ Madhya\ Pradesh",
"91161", "Ludhiana\,\ Punjab",
"9166832", "Padmapur\,\ Odisha",
"9174970", "Khaniadhana\,\ Madhya\ Pradesh",
"9166757", "T\.Rampur\,\ Odisha",
"9165874", "Chakardharpur\,\ Bihar",
"9167632", "Athmallik\,\ Odisha",
"9163285", "Daudnagar\,\ Bihar",
"9165236", "Ghaghra\,\ Bihar",
"918476", "Wadi\,\ Karnataka",
"9164767", "Madhepura\,\ Bihar",
"9164334", "Jamtara\,\ Bihar",
"911379", "Pratapnagar\,\ Uttarakhand",
"9176412", "Niwas\,\ Madhya\ Pradesh",
"9174914", "Narwar\,\ Madhya\ Pradesh",
"917573", "Timarani\,\ Madhya\ Pradesh",
"917850", "Bhanupratappur\,\ Madhya\ Pradesh",
"9166487", "Patnagarh\,\ Odisha",
"918648", "Repalle\,\ Andhra\ Pradesh",
"914362", "Thanjavur\,\ Tamil\ Nadu",
"917283", "Maheshwar\,\ Madhya\ Pradesh",
"912580", "Jamner\,\ Maharashtra",
"9174500", "Sangod\,\ Rajasthan",
"913552", "Kalimpong\,\ West\ Bengal",
"916416", "Bhagalpur\,\ Bihar",
"912189", "Mohol\,\ Maharashtra",
"9167577", "Daspalla\,\ Odisha",
"913212", "Champadanga\,\ West\ Bengal",
"915568", "Deoria\,\ Uttar\ Pradesh",
"9165257", "Simdega\,\ Bihar",
"918525", "Gudur\/Kodumur\,\ Andhra\ Pradesh",
"911431", "Lalsot\,\ Rajasthan",
"9181730", "Sakleshpur\,\ Karnataka",
"9171817", "Lakhandur\,\ Maharashtra",
"91435", "Kumbakonam\,\ Tamil\ Nadu",
"9164365", "Sahibganj\,\ Bihar",
"918366", "Hubli\,\ Karnataka",
"9164597", "Thakurganj\,\ Bihar",
"9174972", "Khaniadhana\,\ Madhya\ Pradesh",
"9174145", "Jaora\,\ Madhya\ Pradesh",
"911981", "Nyoma\,\ Jammu\ And\ Kashmir",
"9173922", "Jhabua\,\ Madhya\ Pradesh",
"917671", "Jaitwara\,\ Madhya\ Pradesh",
"9176474", "Ghughari\,\ Madhya\ Pradesh",
"9171663", "Chaurai\,\ Madhya\ Pradesh",
"9165913", "Chandil\,\ Bihar",
"9174905", "Pohari\,\ Madhya\ Pradesh",
"9162232", "Motipur\,\ Bihar",
"9161882", "Rohtas\,\ Bihar",
"9166216", "Hemgiri\,\ Odisha",
"911469", "Tijara\,\ Rajasthan",
"912485", "Bhokardan\,\ Maharashtra",
"914119", "Ponneri\,\ Tamil\ Nadu",
"912766", "Patan\,\ Gujarat",
"9165812", "Bhandaria\,\ Bihar",
"9161827", "Arrah\,\ Bihar",
"918612", "Nellore\,\ Andhra\ Pradesh",
"918182", "Shimoga\,\ Karnataka",
"9176410", "Niwas\,\ Madhya\ Pradesh",
"9181528", "Kolar\,\ Karnatak",
"9174873", "Begamganj\,\ Madhya\ Pradesh",
"9161536", "Maharajganj\,\ Bihar",
"9166244", "Rajgangpur\,\ Odisha",
"9174575", "Mangrol\,\ Rajasthan",
"917623", "Kundam\,\ Madhya\ Pradesh",
"912935", "Marwar\ Junction\,\ Rajasthan",
"9162712", "Benipatti\,\ Bihar",
"9166736", "Jayapatna\,\ Odisha",
"9175923", "Vidisha\,\ Madhya\ Pradesh",
"9174502", "Sangod\,\ Rajasthan",
"9168162", "Mohana\,\ Odisha",
"9177054", "Kurud\,\ Madhya\ Pradesh",
"9168616", "Malkangiri\,\ Odisha",
"9175957", "Nateran\,\ Madhya\ Pradesh",
"9168554", "Laxmipur\,\ Odisha",
"912895", "Lalpur\,\ Gujarat",
"9161555", "Ekma\,\ Bihar",
"911423", "Amber\/Chomu\,\ Rajasthan",
"9175958", "Nateran\,\ Madhya\ Pradesh",
"9176279", "Manpur\,\ Madhya\ Pradesh",
"911506", "Anupgarh\/Gharsana\,\ Rajasthan",
"9164272", "Kathikund\,\ Bihar",
"917789", "Bhairongarh\,\ Madhya\ Pradesh",
"9166755", "T\.Rampur\,\ Odisha",
"9167972", "Jashipur\,\ Odisha",
"912975", "Reodar\,\ Rajasthan",
"916632", "Sambalpur\,\ Odisha",
"9163222", "Wazirganj\,\ Bihar",
"9164205", "Amarpur\,\ Bihar",
"915676", "Shikohabad\,\ Uttar\ Pradesh",
"9175213", "Seondha\,\ Madhya\ Pradesh",
"9168465", "Baliguda\,\ Odisha",
"9161853", "Bikramganj\,\ Bihar",
"911471", "Rashmi\,\ Rajasthan",
"911732", "Jagadhari\,\ Haryana",
"9164765", "Madhepura\,\ Bihar",
"9174630", "Gangapur\,\ Rajasthan",
"9168644", "Mathili\,\ Odisha",
"9163287", "Daudnagar\,\ Bihar",
"918328", "Goa",
"917863", "Chingamut\,\ Madhya\ Pradesh",
"918919", "Visakhapatnam\,\ Andhra\ Pradesh",
"914982", "Taliparamba\,\ Kerala",
"9167575", "Daspalla\,\ Odisha",
"9173212", "Sanwer\,\ Madhya\ Pradesh",
"9174343", "Pirawa\/Raipur\,\ Rajasthan",
"9165223", "Muri\,\ Bihar",
"917364", "Shajapur\,\ Madhya\ Pradesh",
"9166485", "Patnagarh\,\ Odisha",
"9171804", "Salekasa\,\ Maharashtra",
"9171826", "Gondia\,\ Maharashtra",
"9162786", "Dalsinghsarai\,\ Bihar",
"9171537", "Hinganghat\,\ Maharashtra",
"917819", "Pandishankar\,\ Madhya\ Pradesh",
"9163425", "H\.Kharagpur\,\ Bihar",
"9165935", "Manoharpur\,\ Bihar",
"9161844", "Sasaram\,\ Bihar",
"917228", "Morshi\,\ Maharashtra",
"9171672", "Amarwada\,\ Madhya\ Pradesh",
"911590", "Merta\,\ Rajasthan",
"9176364", "Baihar\,\ Madhya\ Pradesh",
"9168543", "Jeypore\,\ Odisha",
"9171436", "Bhainsdehi\,\ Madhya\ Pradesh",
"911254", "Bawanikhera\,\ Haryana",
"918208", "Udupi\,\ Karnataka",
"918963", "Parvathipuram\,\ Andhra\ Pradesh",
"9171152", "Mouda\,\ Maharashtra",
"9171605", "Jamai\,\ Madhya\ Pradesh",
"9166227", "Sundargarh\,\ Odisha",
"918622", "Kovvur\,\ Andhra\ Pradesh",
"9174963", "Pichhore\,\ Madhya\ Pradesh",
"9176409", "Shahpur\,\ Madhya\ Pradesh",
"9165886", "Jagarnathpur\,\ Bihar",
"9161816", "Piro\,\ Bihar",
"9174862", "Bareli\,\ Madhya\ Pradesh",
"9167484", "Bhubaneshwar\,\ Odisha",
"914576", "Mudukulathur\,\ Tamil\ Nadu",
"9165325", "Giridih\,\ Bihar",
"9181769", "Cannarayapatna\,\ Karnataka",
"9174245", "Malhargarh\,\ Madhya\ Pradesh",
"9162456", "Gogri\,\ Bihar",
"9166574", "Kantabhanji\,\ Odisha",
"9174354", "Gangdhar\,\ Rajasthan",
"912697", "Retlad\,\ Gujarat",
"9165532", "Ramgarh\,\ Bihar",
"916575", "Jamshedpur\,\ Bihar",
"9162557", "Raxaul\,\ Bihar",
"918255", "Bantwal\,\ Karnataka",
"918567", "Lakkireddipalli\,\ Andhra\ Pradesh",
"9168173", "R\.Udayigiri\,\ Odisha",
"9165677", "Barwadih\,\ Bihar",
"9174596", "Ramganj\ Mandi\,\ Rajasthan",
"9171385", "Dhanora\,\ Maharashtra",
"914286", "Namakkal\,\ Tamil\ Nadu",
"9176520", "Shahdol\,\ Madhya\ Pradesh",
"915647", "Bari\,\ Rajasthan",
"9168653", "Kashipur\,\ Odisha",
"918515", "Banaganapalle\,\ Andhra\ Pradesh",
"915261", "Tarabganj\/Colonelganj\,\ Uttar\ Pradesh",
"9162435", "Begusarai\,\ Bihar",
"918862", "Razole\,\ Andhra\ Pradesh",
"9168627", "Gudari\,\ Odisha",
"9174669", "Bonli\,\ Rajasthan",
"9164542", "Purnea\,\ Bihar",
"911852", "Taran\,\ Punjab",
"9162523", "Motihari\,\ Bihar",
"912644", "Jambusar\,\ Gujarat",
"918318", "Belgaum\,\ Karnataka",
"915180", "Fatehpur\,\ Uttar\ Pradesh",
"9171785", "Sinderwahi\,\ Maharashtra",
"9171183", "Kalmeshwar\,\ Maharashtra",
"9164263", "Rajmahal\,\ Bihar",
"915694", "Kannauj\,\ Uttar\ Pradesh",
"912168", "Mahabaleswar\,\ Maharashtra",
"9168403", "Tumudibandha\,\ Odisha",
"9167963", "Karanjia\,\ Odisha",
"913461", "Rampur\ Hat\,\ West\ Bengal",
"914346", "Harur\,\ Tamil\ Nadu",
"9166253", "Lahunipara\,\ Odisha",
"912718", "Bareja\,\ Gujarat",
"9167862", "Chandbali\,\ Odisha",
"912561", "Pimpalner\,\ Maharashtra",
"9171564", "Talegaokarangal\,\ Maharashtra",
"9167497", "Bhubaneshwar\,\ Odisha",
"918749", "Madhira\,\ Andhra\ Pradesh",
"9177043", "Deobhog\,\ Madhya\ Pradesh",
"9167354", "Telkoi\,\ Odisha",
"9167245", "Jagatsinghpur\,\ Odisha",
"917266", "Jalgaonjamod\,\ Maharashtra",
"912130", "Velhe\,\ Maharashtra",
"9176338", "Waraseoni\,\ Madhya\ Pradesh",
"9171455", "Chicholi\,\ Madhya\ Pradesh",
"918691", "Devarakonda\,\ Andhra\ Pradesh",
"9168682", "Nandapur\,\ Odisha",
"9176337", "Waraseoni\,\ Madhya\ Pradesh",
"9173209", "Pandhana\,\ Madhya\ Pradesh",
"918593", "Medarmetla\,\ Andhra\ Pradesh",
"9171322", "Gadchiroli\,\ Maharashtra",
"9165937", "Manoharpur\,\ Bihar",
"9163427", "H\.Kharagpur\,\ Bihar",
"915733", "Pahasu\,\ Uttar\ Pradesh",
"912831", "Nalia\,\ Gujarat",
"911960", "Nowshera\,\ Jammu\ And\ Kashmir",
"9171535", "Hinganghat\,\ Maharashtra",
"917726", "Bhatapara\,\ Madhya\ Pradesh",
"9171423", "Bhimpur\,\ Madhya\ Pradesh",
"912922", "Osian\,\ Rajasthan",
"918706", "Warangal\,\ Andhra\ Pradesh",
"9171794", "Nagbhir\,\ Maharashtra",
"9165483", "Ichak\,\ Bihar",
"914144", "Chidambaram\,\ Tamil\ Nadu",
"9166225", "Sundargarh\,\ Odisha",
"9171607", "Jamai\,\ Madhya\ Pradesh",
"918383", "Joida\,\ Karnataka",
"9164576", "Korha\,\ Bihar",
"9176356", "Lanji\,\ Madhya\ Pradesh",
"9165382", "Torpa\,\ Bihar",
"912663", "Dabhoi\,\ Gujarat",
"9171833", "Tumsar\,\ Maharashtra",
"913824", "Kailsahar\,\ Tripura",
"9162464", "Jainagar\,\ Bihar",
"9174366", "Hindoli\,\ Rajasthan",
"9174411", "Ladpura\/Kota\,\ Rajasthan",
"915881", "Bisalpur\,\ Uttar\ Pradesh",
"9174247", "Malhargarh\,\ Madhya\ Pradesh",
"918532", "Raichur\,\ Karnataka",
"911885", "Balachaur\,\ Punjab",
"9165327", "Giridih\,\ Bihar",
"9175264", "Ghatigaon\,\ Madhya\ Pradesh",
"914630", "Srivaikundam\,\ Tamil\ Nadu",
"9174248", "Malhargarh\,\ Madhya\ Pradesh",
"917695", "Gopalganj\,\ Madhya\ Pradesh",
"9174124", "Ratlam\,\ Madhya\ Pradesh",
"9165602", "Patan\,\ Bihar",
"912742", "Palanpur\,\ Gujarat",
"91186", "Pathankot\,\ Punjab",
"9171387", "Dhanora\,\ Maharashtra",
"9165675", "Barwadih\,\ Bihar",
"911488", "Kotri\,\ Rajasthan",
"917770", "Kathdol\,\ Madhya\ Pradesh",
"9163482", "Mallehpur\,\ Bihar",
"9162555", "Raxaul\,\ Bihar",
"912823", "Jetpur\,\ Gujarat",
"915721", "Sikandra\ Rao\,\ Uttar\ Pradesh",
"913664", "Hajo\,\ Assam",
"9171646", "Pandhurna\,\ Madhya\ Pradesh",
"911495", "Mandawar\,\ Rajasthan",
"912629", "M\.M\.Mangrol\,\ Gujarat",
"913222", "Kharagpur\,\ West\ Bengal",
"915491", "Rasara\,\ Uttar\ Pradesh",
"918572", "Chittoor\,\ Andhra\ Pradesh",
"918944", "Bobbili\,\ Andhra\ Pradesh",
"9168625", "Gudari\,\ Odisha",
"917688", "Gourihar\,\ Madhya\ Pradesh",
"913777", "Yangkiyang\,\ Arunachal\ Pradesh",
"911978", "Bilaspur\,\ Himachal\ Pradesh",
"918243", "Mangalore\,\ Karnataka",
"9174519", "Atru\,\ Rajasthan",
"9162437", "Begusarai\,\ Bihar",
"912441", "Ashti\,\ Maharashtra",
"912324", "Hatkangale\/Ichalkaranji\,\ Maharashtra",
"9165452", "Mandu\,\ Bihar",
"9166512", "Birmaharajpur\,\ Odisha",
"918837", "Rajahmundri\,\ Andhra\ Pradesh",
"9176486", "Mawai\,\ Madhya\ Pradesh",
"9162536", "Narkatiaganj\,\ Bihar",
"916512", "Ranchi\,\ Bihar",
"9171787", "Sinderwahi\,\ Maharashtra",
"918282", "Bhadravati\,\ Karnataka",
"9165353", "Chainpur\,\ Bihar",
"917730", "Ajaigarh\,\ Madhya\ Pradesh",
"914828", "Kanjirapally\,\ Kerala",
"918724", "Jagtial\,\ Andhra\ Pradesh",
"9167247", "Jagatsinghpur\,\ Odisha",
"9171722", "Chandrapur\,\ Maharashtra",
"91469", "Tiruvalla\,\ Kerala",
"912871", "Keshod\,\ Gujarat",
"918494", "Kadiri\,\ Andhra\ Pradesh",
"9167495", "Bhubaneshwar\,\ Odisha",
"9174860", "Bareli\,\ Madhya\ Pradesh",
"912556", "Chanwad\,\ Maharashtra",
"9171556", "Seloo\,\ Maharashtra",
"913655", "Khliehriat\,\ Meghalaya",
"9165964", "Noamundi\,\ Bihar",
"9171614", "Parasia\,\ Madhya\ Pradesh",
"913806", "Chowkhem\,\ Arunachal\ Pradesh",
"9176335", "Waraseoni\,\ Madhya\ Pradesh",
"917768", "Saranggarh\,\ Madhya\ Pradesh",
"912991", "Jaisalmer\/Ramgarh\,\ Rajasthan",
"9174206", "Jawad\,\ Madhya\ Pradesh",
"9171394", "Kurkheda\,\ Maharashtra",
"9176522", "Shahdol\,\ Madhya\ Pradesh",
"9171457", "Chicholi\,\ Madhya\ Pradesh",
"913784", "Nefra\,\ Arunachal\ Pradesh",
"917251", "Risod\,\ Maharashtra",
"911696", "Kalanwali\,\ Haryana",
"9163453", "Jamui\,\ Bihar",
"9174509", "Sangod\,\ Rajasthan",
"911632", "Ferozepur\,\ Punjab",
"9174127", "Ratlam\,\ Madhya\ Pradesh",
"915414", "Bhadohi\,\ Uttar\ Pradesh",
"9162566", "Ramnagar\,\ Bihar",
"917769", "Bagicha\,\ Madhya\ Pradesh",
"9174128", "Ratlam\,\ Madhya\ Pradesh",
"9171384", "Dhanora\,\ Maharashtra",
"913453", "Katwa\,\ West\ Bengal",
"917731", "Gunnore\,\ Madhya\ Pradesh",
"9174244", "Malhargarh\,\ Madhya\ Pradesh",
"9165324", "Giridih\,\ Bihar",
"9175268", "Ghatigaon\,\ Madhya\ Pradesh",
"9166575", "Kantabhanji\,\ Odisha",
"9174355", "Gangdhar\,\ Rajasthan",
"914151", "Kallakurichi\,\ Tamil\ Nadu",
"917472", "Bundi\,\ Rajasthan",
"912957", "Vallabhnagar\,\ Rajasthan",
"918246", "Mangalore\,\ Karnataka",
"9162467", "Jainagar\,\ Bihar",
"912826", "Upleta\,\ Gujarat",
"9163276", "Rafiganj\,\ Bihar",
"9167926", "Baripada\,\ Odisha",
"9175267", "Ghatigaon\,\ Madhya\ Pradesh",
"9167485", "Bhubaneshwar\,\ Odisha",
"917297", "Kukshi\,\ Madhya\ Pradesh",
"9164226", "Godda\,\ Bihar",
"9171604", "Jamai\,\ Madhya\ Pradesh",
"911899", "Chamba\,\ Himachal\ Pradesh",
"914829", "Vaikom\,\ Kerala",
"9171797", "Nagbhir\,\ Maharashtra",
"918411", "Tanduru\,\ Andhra\ Pradesh",
"911693", "Barwala\,\ Haryana",
"9176365", "Baihar\,\ Madhya\ Pradesh",
"9176496", "Kakaiya\,\ Madhya\ Pradesh",
"9174979", "Khaniadhana\,\ Madhya\ Pradesh",
"912870", "Malia\ Hatina\,\ Gujarat",
"9161543", "Siwan\,\ Bihar",
"9173929", "Jhabua\,\ Madhya\ Pradesh",
"9163424", "H\.Kharagpur\,\ Bihar",
"9167673", "Barbil\,\ Odisha",
"9171096", "Kamptee\,\ Maharashtra",
"912553", "Igatpuri\,\ Maharashtra",
"9161845", "Sasaram\,\ Bihar",
"917689", "Badamalhera\,\ Madhya\ Pradesh",
"9165934", "Manoharpur\,\ Bihar",
"913803", "Roing\,\ Arunachal\ Pradesh",
"912628", "Nizar\,\ Gujarat",
"917510", "Gwalior\,\ Madhya\ Pradesh",
"9174216", "Manasa\,\ Madhya\ Pradesh",
"9185860", "Vayalpad\,\ Andhra\ Pradesh",
"9167336", "Ghatgaon\,\ Odisha",
"912990", "Bhinmal\/Jasawantpura\,\ Rajasthan",
"9171454", "Chicholi\,\ Madhya\ Pradesh",
"911489", "Mandalgarh\,\ Rajasthan",
"9163492", "Jhajha\,\ Bihar",
"913565", "Nagarakata\,\ West\ Bengal",
"9173940", "Alirajpur\,\ Madhya\ Pradesh",
"9171397", "Kurkheda\,\ Maharashtra",
"912666", "Miyagam\,\ Gujarat",
"9171863", "Sakoli\,\ Maharashtra",
"918703", "Warangal\,\ Andhra\ Pradesh",
"915965", "Champawat\,\ Uttar\ Pradesh",
"912830", "Rahpar\,\ Gujarat",
"9173219", "Sanwer\,\ Madhya\ Pradesh",
"918386", "Kumta\,\ Karnataka",
"912454", "Basmatnagar\,\ Maharashtra",
"917547", "Chanderi\,\ Madhya\ Pradesh",
"9166442", "Rairakhol\,\ Odisha",
"9167355", "Telkoi\,\ Odisha",
"917723", "Mahasamund\,\ Madhya\ Pradesh",
"9167244", "Jagatsinghpur\,\ Odisha",
"9171617", "Parasia\,\ Madhya\ Pradesh",
"918596", "Markapur\,\ Andhra\ Pradesh",
"9165967", "Noamundi\,\ Bihar",
"915736", "Siyana\,\ Uttar\ Pradesh",
"9174926", "Shivpuri\,\ Madhya\ Pradesh",
"9171565", "Talegaokarangal\,\ Maharashtra",
"9165392", "Bolwa\,\ Bihar",
"911672", "Sangrur\,\ Punjab",
"913214", "Jagatballavpur\,\ West\ Bengal",
"912804", "Kutiyana\,\ Gujarat",
"914364", "Mayiladuthurai\,\ Tamil\ Nadu",
"915880", "Puranpur\,\ Uttar\ Pradesh",
"9171784", "Sinderwahi\,\ Maharashtra",
"9165493", "Bermo\,\ Bihar",
"915253", "Nanpara\,\ Uttar\ Pradesh",
"917771", "Manendragarh\,\ Madhya\ Pradesh",
"9176272", "Manpur\,\ Madhya\ Pradesh",
"913015", "Jaisalmer\/Myajlar\,\ Rajasthan",
"9174673", "Bamanwas\,\ Rajasthan",
"9162434", "Begusarai\,\ Bihar",
"9174336", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"9167216", "Narsinghpur\,\ Odisha",
"9172870", "Gogaon\,\ Madhya\ Pradesh",
"9165612", "Garhwa\,\ Bihar",
"9171962", "Arjuni\ Morgaon\,\ Maharashtra",
"912465", "Billoli\,\ Maharashtra",
"9168692", "Papadhandi\,\ Odisha",
"9164233", "Maheshpur\ Raj\,\ Bihar",
"9165674", "Barwadih\,\ Bihar",
"9167933", "Betanati\,\ Odisha",
"9166476", "Naktideul\,\ Odisha",
"9162554", "Raxaul\,\ Bihar",
"9174125", "Ratlam\,\ Madhya\ Pradesh",
"912375", "Pusegaon\,\ Maharashtra",
"918177", "Belur\,\ Karnataka",
"9173942", "Alirajpur\,\ Madhya\ Pradesh",
"9167586", "Nimapara\,\ Odisha",
"911667", "Fatehabad\,\ Haryana",
"9168413", "Boudh\,\ Odisha",
"9167487", "Bhubaneshwar\,\ Odisha",
"918748", "V\.R\.Puram\,\ Andhra\ Pradesh",
"9175265", "Ghatigaon\,\ Madhya\ Pradesh",
"9174358", "Gangdhar\,\ Rajasthan",
"9162465", "Jainagar\,\ Bihar",
"915181", "Bindki\,\ Uttar\ Pradesh",
"9174357", "Gangdhar\,\ Rajasthan",
"9166577", "Kantabhanji\,\ Odisha",
"9174639", "Gangapur\,\ Rajasthan",
"9167323", "Hindol\,\ Odisha",
"913835", "Saiha\,\ Mizoram",
"9164713", "Birpur\,\ Bihar",
"9176367", "Baihar\,\ Madhya\ Pradesh",
"9175943", "Ganjbasoda\,\ Madhya\ Pradesh",
"912169", "Shirwal\,\ Maharashtra",
"917263", "Khamgaon\,\ Maharashtra",
"9171795", "Nagbhir\,\ Maharashtra",
"916715", "Cuttack\,\ Odisha",
"912560", "Kusumba\,\ Maharashtra",
"9166224", "Sundargarh\,\ Odisha",
"918319", "Belgaum\,\ Karnataka",
"9176368", "Baihar\,\ Madhya\ Pradesh",
"9172872", "Gogaon\,\ Madhya\ Pradesh",
"9173296", "Khakner\,\ Madhya\ Pradesh",
"914343", "Krishnagiri\,\ Tamil\ Nadu",
"918184", "Sorab\,\ Karnataka",
"918614", "Nellore\,\ Andhra\ Pradesh",
"918775", "Tirupathi\,\ Andhra\ Pradesh",
"9161847", "Sasaram\,\ Bihar",
"9176270", "Manpur\,\ Madhya\ Pradesh",
"915278", "Faizabad\,\ Uttar\ Pradesh",
"911522", "Bikaner\/Jamsar\,\ Rajasthan",
"9171534", "Hinganghat\,\ Maharashtra",
"91171", "Ambala\,\ Haryana",
"911956", "Uri\,\ Jammu\ And\ Kashmir",
"9174933", "Karera\,\ Madhya\ Pradesh",
"9164313", "Jharmundi\,\ Bihar",
"9174586", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"9176334", "Waraseoni\,\ Madhya\ Pradesh",
"911381", "Joshimath\/Badrinath\,\ Uttarakhand",
"9163242", "Nawada\,\ Bihar",
"9171395", "Kurkheda\,\ Maharashtra",
"9171466", "Ghorandogri\,\ Madhya\ Pradesh",
"916634", "Sambalpur\,\ Odisha",
"9162273", "Mahua\,\ Bihar",
"914897", "Kadamath\,\ Lakshadweep",
"918966", "Srungavarapukota\/Kothavalasa\,\ Andhra\ Pradesh",
"9171567", "Talegaokarangal\,\ Maharashtra",
"9176419", "Niwas\,\ Madhya\ Pradesh",
"9165965", "Noamundi\,\ Bihar",
"9171615", "Parasia\,\ Madhya\ Pradesh",
"91495", "Kozhikode\,\ Kerala",
"9182202", "Gundlupet\,\ Karnataka",
"918735", "Bellampalli\,\ Andhra\ Pradesh",
"9167357", "Telkoi\,\ Odisha",
"9167494", "Bhubaneshwar\,\ Odisha",
"911591", "Merta\/Gotan\,\ Rajasthan",
"914283", "Sankagiri\,\ Tamil\ Nadu",
"917362", "Agar\,\ Madhya\ Pradesh",
"9165896", "Jhinkpani\,\ Bihar",
"9165243", "Gumla\,\ Bihar",
"9174323", "Jhalawar\,\ Rajasthan",
"913848", "Thonbal\,\ Manipur",
"918137", "Madugiri\,\ Karnataka",
"918209", "Udupi\,\ Karnataka",
"9161806", "Adhaura\,\ Bihar",
"915260", "Tarabganj\,\ Uttar\ Pradesh",
"9181739", "Sakleshpur\,\ Karnataka",
"9168624", "Gudari\,\ Odisha",
"917229", "Warlydwarud\,\ Maharashtra",
"9165562", "Tisri\,\ Bihar",
"917818", "Chandipara\,\ Madhya\ Pradesh",
"9175381", "Ambah\,\ Madhya\ Pradesh",
"9162796", "Barauni\,\ Bihar",
"911734", "Naraingarh\,\ Haryana",
"914573", "Rameshwaram\,\ Tamil\ Nadu",
"9166495", "Jamankira\,\ Odisha",
"9177058", "Kurud\,\ Madhya\ Pradesh",
"918262", "Chikmagalur\,\ Karnataka",
"91479", "Mavelikkara\,\ Kerala",
"915673", "Bhogaon\,\ Uttar\ Pradesh",
"91172", "Chandigarh\,\ Punjab",
"9168435", "Puruna\ Katak\,\ Odisha",
"918624", "Gudur\,\ Andhra\ Pradesh",
"9166247", "Rajgangpur\,\ Odisha",
"911503", "Sadulshahar\,\ Rajasthan",
"9177057", "Kurud\,\ Madhya\ Pradesh",
"918918", "Visakhapatnam\,\ Andhra\ Pradesh",
"911252", "Loharu\,\ Haryana",
"9168606", "Boriguma\,\ Odisha",
"9168523", "Koraput\,\ Odisha",
"9161824", "Arrah\,\ Bihar",
"918329", "Goa",
"9167915", "Bangiriposi\,\ Odisha",
"9164215", "Naugachia\,\ Bihar",
"9163445", "Monghyr\,\ Bihar",
"911796", "Arki\,\ Himachal\ Pradesh",
"917604", "Hatta\,\ Madhya\ Pradesh",
"9171846", "Bhandara\,\ Maharashtra",
"911426", "Jamwa\ Ramgarh\/Achrol\,\ Rajasthan",
"9176477", "Ghughari\,\ Madhya\ Pradesh",
"9164594", "Thakurganj\,\ Bihar",
"91194", "Srinagar\,\ Jammu\ And\ Kashmir",
"916127", "Patna\,\ Bihar",
"9176478", "Ghughari\,\ Madhya\ Pradesh",
"911907", "Sundernagar\,\ Himachal\ Pradesh",
"9171776", "Brahmapuri\,\ Maharashtra",
"913677", "Baithalangshu\,\ Assam",
"911470", "Dungla\,\ Rajasthan",
"917788", "Luckwada\,\ Madhya\ Pradesh",
"9171814", "Lakhandur\,\ Maharashtra",
"9164735", "Supaul\,\ Bihar",
"9174660", "Bonli\,\ Rajasthan",
"9174225", "Mandsaur\,\ Madhya\ Pradesh",
"9165345", "Jhumaritalaiya\,\ Bihar",
"9165254", "Simdega\,\ Bihar",
"917866", "Konta\,\ Madhya\ Pradesh",
"9173202", "Pandhana\,\ Madhya\ Pradesh",
"9176576", "Jaitpur\,\ Madhya\ Pradesh",
"9164356", "Pakur\,\ Bihar",
"9172863", "Khetia\,\ Madhya\ Pradesh",
"912113", "Bhor\,\ Maharashtra",
"9162262", "Sitamarhi\,\ Bihar",
"915692", "Farrukhabad\/Fategarh\,\ Uttar\ Pradesh",
"9171807", "Salekasa\,\ Maharashtra",
"918363", "Hubli\,\ Karnataka",
"911430", "Phagi\,\ Rajasthan",
"9171376", "Desaiganj\,\ Maharashtra",
"913637", "Cherrapunjee\,\ Meghalaya",
"918405", "Giddalur\,\ Andhra\ Pradesh",
"9176529", "Shahdol\,\ Madhya\ Pradesh",
"9164335", "Jamtara\,\ Bihar",
"912642", "Bharuch\,\ Gujarat",
"9174915", "Narwar\,\ Madhya\ Pradesh",
"9164522", "Katihar\,\ Bihar",
"9162543", "Bettiah\,\ Bihar",
"917670", "Majhagwan\,\ Madhya\ Pradesh",
"9168647", "Mathili\,\ Odisha",
"9163284", "Daudnagar\,\ Bihar",
"9164756", "S\.Bakhtiarpur\,\ Bihar",
"911980", "Nobra\,\ Jammu\ And\ Kashmir",
"918864", "Rampachodavaram\,\ Andhra\ Pradesh",
"914118", "Tiruttani\,\ Tamil\ Nadu",
"9181760", "Cannarayapatna\,\ Karnataka",
"9166766", "M\.Rampur\,\ Odisha",
"9161892", "Bhabhua\,\ Bihar",
"911468", "Ramgarh\,\ Rajasthan",
"9165875", "Chakardharpur\,\ Bihar",
"9176400", "Shahpur\,\ Madhya\ Pradesh",
"9168456", "Phiringia\,\ Odisha",
"918458", "Narsapur\,\ Andhra\ Pradesh",
"9167225", "Pardip\,\ Odisha",
"9168557", "Laxmipur\,\ Odisha",
"918855", "Mandapeta\/Ravulapalem\,\ Andhra\ Pradesh",
"9174512", "Atru\,\ Rajasthan",
"9161566", "Gopalganj\,\ Bihar",
"9175954", "Nateran\,\ Madhya\ Pradesh",
"915861", "Misrikh\/Aurangabad\,\ Uttar\ Pradesh",
"912763", "Vijapur\,\ Gujarat",
"9165573", "Bagodar\,\ Bihar",
"9162775", "Phulparas\,\ Bihar",
"913481", "Islampur\,\ West\ Bengal",
"913822", "Dharam\ Nagar\,\ Tripura",
"9177055", "Kurud\,\ Madhya\ Pradesh",
"912188", "Mangalwedha\,\ Maharashtra",
"9167253", "Dhanmandal\,\ Odisha",
"914142", "Cuddalore\,\ Tamil\ Nadu",
"9166245", "Rajgangpur\,\ Odisha",
"918843", "Kakinada\,\ Andhra\ Pradesh",
"9168437", "Puruna\ Katak\,\ Odisha",
"9174574", "Mangrol\,\ Rajasthan",
"912924", "Phalodi\/Baroo\,\ Rajasthan",
"9166497", "Jamankira\,\ Odisha",
"918649", "Piduguralla\,\ Andhra\ Pradesh",
"9171443", "Atner\,\ Madhya\ Pradesh",
"9168536", "Sunabeda\,\ Odisha",
"9181762", "Cannarayapatna\,\ Karnataka",
"911378", "Devprayag\,\ Uttarakhand",
"9174869", "Bareli\,\ Madhya\ Pradesh",
"9163447", "Monghyr\,\ Bihar",
"911535", "Kolayat\/Bajju\,\ Rajasthan",
"914183", "Vandavasi\,\ Tamil\ Nadu",
"9164217", "Naugachia\,\ Bihar",
"9167917", "Bangiriposi\,\ Odisha",
"9171342", "Bhamregadh\,\ Maharashtra",
"9174904", "Pohari\,\ Madhya\ Pradesh",
"9176402", "Shahpur\,\ Madhya\ Pradesh",
"9176303", "Katangi\,\ Madhya\ Pradesh",
"912744", "Deesa\,\ Gujarat",
"9174144", "Jaora\,\ Madhya\ Pradesh",
"9172691", "Deolgaonraja\,\ Maharashtra",
"9176475", "Ghughari\,\ Madhya\ Pradesh",
"916413", "Bhagalpur\,\ Bihar",
"9164364", "Sahibganj\,\ Bihar",
"9174228", "Mandsaur\,\ Madhya\ Pradesh",
"917576", "Piparia\,\ Madhya\ Pradesh",
"915341", "Kunda\,\ Uttar\ Pradesh",
"9165347", "Jhumaritalaiya\,\ Bihar",
"911345", "Bijnor\/Chandpur\,\ Uttar\ Pradesh",
"9167662", "Keonjhar\,\ Odisha",
"9174227", "Mandsaur\,\ Madhya\ Pradesh",
"9174510", "Atru\,\ Rajasthan",
"918534", "Yelburga\,\ Karnataka",
"9171002", "Kuhi\,\ Maharashtra",
"9165266", "Lohardaga\,\ Bihar",
"918473", "Yadgiri\,\ Karnataka",
"917851", "Bhopalpatnam\,\ Madhya\ Pradesh",
"9164737", "Supaul\,\ Bihar",
"9174253", "Garoth\,\ Madhya\ Pradesh",
"9165686", "Balumath\,\ Bihar",
"918284", "Haliyal\,\ Karnataka",
"9166484", "Patnagarh\,\ Odisha",
"915178", "Mauranipur\,\ Uttar\ Pradesh",
"9167282", "Jajapur\ Town\,\ Odisha",
"9171805", "Salekasa\,\ Maharashtra",
"916514", "Ranchi\,\ Bihar",
"912427", "Newasa\,\ Maharashtra",
"9167574", "Daspalla\,\ Odisha",
"912797", "Dhari\,\ Gujarat",
"9171872", "Goregaon\,\ Maharashtra",
"912322", "Shirol\/Jalsingpur\,\ Maharashtra",
"9164764", "Madhepura\,\ Bihar",
"9174918", "Narwar\,\ Madhya\ Pradesh",
"9168645", "Mathili\,\ Odisha",
"917536", "Sabalgarh\,\ Madhya\ Pradesh",
"918350", "Mudhol\,\ Karnataka",
"9174917", "Narwar\,\ Madhya\ Pradesh",
"911360", "Dehradun\ Chakrata\/Dakpattar\,\ Uttarakhand",
"918942", "Srikakulam\,\ Andhra\ Pradesh",
"913224", "Haldia\,\ West\ Bengal",
"9164337", "Jamtara\,\ Bihar",
"9171626", "Chhindwara\,\ Madhya\ Pradesh",
"913662", "Dhubri\,\ Assam",
"915523", "Maharajganj\,\ Uttar\ Pradesh",
"915281", "Mahoba\,\ Uttar\ Pradesh",
"916217", "Muzaffarpur\,\ Bihar",
"9164204", "Amarpur\,\ Bihar",
"911285", "Mohindergarh\,\ Haryana",
"9168464", "Baliguda\,\ Odisha",
"914266", "Kotagiri\,\ Tamil\ Nadu",
"913782", "Kalaktung\/Bomdila\,\ Arunachal\ Pradesh",
"9166754", "T\.Rampur\,\ Odisha",
"918587", "Venkatgirikota\,\ Andhra\ Pradesh",
"9165877", "Chakardharpur\,\ Bihar",
"9177036", "Manpur\,\ Madhya\ Pradesh",
"9165306", "Bundu\,\ Bihar",
"9162777", "Phulparas\,\ Bihar",
"9173200", "Pandhana\,\ Madhya\ Pradesh",
"9171973", "Mohadi\,\ Maharashtra",
"911575", "Srimadhopur\,\ Rajasthan",
"918492", "Kambadur\,\ Andhra\ Pradesh",
"9176263", "Vijayraghogarh\,\ Madhya\ Pradesh",
"9168555", "Laxmipur\,\ Odisha",
"9175966", "Gyraspur\,\ Madhya\ Pradesh",
"9174662", "Bonli\,\ Rajasthan",
"9167227", "Pardip\,\ Odisha",
"9161554", "Ekma\,\ Bihar",
"912906", "Salumber\,\ Rajasthan",
"9171742", "Mul\,\ Maharashtra",
"918397", "H\.B\.Halli\,\ Karnataka",
"915863", "Biswan\,\ Uttar\ Pradesh",
"912761", "Kheralu\,\ Gujarat",
"9165862", "Chainpur\,\ Bihar",
"9167956", "Udala\,\ Odisha",
"9164256", "Katoria\,\ Bihar",
"9176460", "Nainpur\,\ Madhya\ Pradesh",
"9165354", "Chainpur\,\ Bihar",
"9165245", "Gumla\,\ Bihar",
"9174325", "Jhalawar\,\ Rajasthan",
"9165497", "Bermo\,\ Bihar",
"9166706", "Bhawanipatna\,\ Odisha",
"918549", "Kalwakurthy\,\ Andhra\ Pradesh",
"917475", "Bundi\,\ Rajasthan",
"9174532", "Baran\,\ Rajasthan",
"915364", "Kadipur\,\ Uttar\ Pradesh",
"914253", "Anamalai\,\ Tamil\ Nadu",
"9165596", "Simaria\,\ Bihar",
"9174677", "Bamanwas\,\ Rajasthan",
"9162762", "Madhubani\,\ Bihar",
"9161506", "Hathua\,\ Bihar",
"911635", "Kotkapura\,\ Punjab",
"912739", "Vadgam\,\ Gujarat",
"9168112", "Chhatrapur\,\ Odisha",
"9174678", "Bamanwas\,\ Rajasthan",
"911436", "Uniayara\,\ Rajasthan",
"917448", "Ladpura\/Kota\,\ Rajasthan",
"9162275", "Mahua\,\ Bihar",
"9171867", "Sakoli\,\ Maharashtra",
"9171393", "Kurkheda\,\ Maharashtra",
"9182890", "Athani\,\ Karnataka",
"9171492", "Tamia\,\ Madhya\ Pradesh",
"9163454", "Jamui\,\ Bihar",
"9164315", "Jharmundi\,\ Bihar",
"918339", "Ainapur\,\ Karnataka",
"913867", "Zuenheboto\,\ Nagaland",
"9174935", "Karera\,\ Madhya\ Pradesh",
"9181700", "Alur\,\ Karnataka",
"9173959", "Sondhwa\,\ Madhya\ Pradesh",
"9165963", "Noamundi\,\ Bihar",
"912111", "Indapur\,\ Maharashtra",
"918634", "Guntur\,\ Andhra\ Pradesh",
"9171613", "Parasia\,\ Madhya\ Pradesh",
"9181931", "Hiriyur\,\ Karnataka",
"9166266", "Banaigarh\,\ Odisha",
"911476", "Kapasan\,\ Rajasthan",
"9174956", "Badarwas\,\ Madhya\ Pradesh",
"9165484", "Ichak\,\ Bihar",
"9171793", "Nagbhir\,\ Maharashtra",
"9167532", "Nayagarh\,\ Odisha",
"916614", "Rourkela\,\ Odisha",
"9171834", "Tumsar\,\ Maharashtra",
"9164715", "Birpur\,\ Bihar",
"9175945", "Ganjbasoda\,\ Madhya\ Pradesh",
"9167325", "Hindol\,\ Odisha",
"9161547", "Siwan\,\ Bihar",
"918154", "Chintamani\,\ Karnataka",
"918379", "Hangal\,\ Karnataka",
"915962", "Almora\,\ Uttar\ Pradesh",
"9167677", "Barbil\,\ Odisha",
"9171424", "Bhimpur\,\ Madhya\ Pradesh",
"918674", "Gudivada\,\ Andhra\ Pradesh",
"918715", "Mulug\,\ Andhra\ Pradesh",
"913562", "Mal\ Bazar\,\ West\ Bengal",
"91177", "Shimla\,\ Himachal\ Pradesh",
"9174600", "Sahabad\,\ Rajasthan",
"9168666", "Umerkote\,\ Odisha",
"912367", "Kankavali\,\ Maharashtra",
"9174123", "Ratlam\,\ Madhya\ Pradesh",
"912462", "Nanded\,\ Maharashtra",
"91796", "Ahmedabad\ Local\,\ Gujarat",
"9167935", "Betanati\,\ Odisha",
"918117", "Kanakapura\,\ Karnataka",
"913012", "Jaisalmer\/Mehsana\,\ Rajasthan",
"9164235", "Maheshpur\ Raj\,\ Bihar",
"91484", "Ernakulam\,\ Kerala",
"9174380", "Keshoraipatan\/Patan\,\ Rajasthan",
"911501", "Srikaranpur\,\ Rajasthan",
"911420", "Baswa\/Bandikui\,\ Rajasthan",
"9162463", "Jainagar\,\ Bihar",
"915671", "Jasrana\,\ Uttar\ Pradesh",
"9175263", "Ghatigaon\,\ Madhya\ Pradesh",
"911675", "Malerkotla\,\ Punjab",
"9167886", "Soro\,\ Odisha",
"912779", "Bayad\,\ Gujarat",
"9168415", "Boudh\,\ Odisha",
"9165366", "Palkot\,\ Bihar",
"9165495", "Bermo\,\ Bihar",
"918524", "Srisailam\,\ Andhra\ Pradesh",
"9174327", "Jhalawar\,\ Rajasthan",
"9165247", "Gumla\,\ Bihar",
"912756", "Muli\,\ Gujarat",
"9167964", "Karanjia\,\ Odisha",
"911603", "Kharar\,\ Punjab",
"9168404", "Tumudibandha\,\ Odisha",
"9171184", "Kalmeshwar\,\ Maharashtra",
"9174328", "Jhalawar\,\ Rajasthan",
"9164264", "Rajmahal\,\ Bihar",
"9174602", "Sahabad\,\ Rajasthan",
"9175906", "Lateri\,\ Madhya\ Pradesh",
"912900", "Siwana\/Samdari\,\ Rajasthan",
"912372", "Patan\,\ Maharashtra",
"9177016", "Pingeshwar\,\ Madhya\ Pradesh",
"912477", "Paranda\,\ Maharashtra",
"9174675", "Bamanwas\,\ Rajasthan",
"915283", "Charkhari\,\ Uttar\ Pradesh",
"9171996", "Deori\,\ Maharashtra",
"913584", "Mekhliganj\,\ West\ Bengal",
"9162524", "Motihari\,\ Bihar",
"915850", "Hardoi\/Baghavli\,\ Uttar\ Pradesh",
"9174937", "Karera\,\ Madhya\ Pradesh",
"9163466", "Lakhisarai\,\ Bihar",
"912847", "Gadhada\,\ Gujarat",
"91595", "Rampur\,\ Uttar\ Pradesh",
"918772", "Tirupathi\,\ Andhra\ Pradesh",
"9164317", "Jharmundi\,\ Bihar",
"915521", "Bansgaon\/Barhal\ Ganj\,\ Uttar\ Pradesh",
"912484", "Partur\,\ Maharashtra",
"9174938", "Karera\,\ Madhya\ Pradesh",
"9171865", "Sakoli\,\ Maharashtra",
"9162277", "Mahua\,\ Bihar",
"918227", "T\.Narsipur\,\ Karnataka",
"9171563", "Talegaokarangal\,\ Maharashtra",
"912934", "Desuri\/Rani\,\ Rajasthan",
"916712", "Cuttack\,\ Odisha",
"9166254", "Lahunipara\,\ Odisha",
"9167353", "Telkoi\,\ Odisha",
"9177044", "Deobhog\,\ Madhya\ Pradesh",
"917530", "Sheopurkalan\,\ Madhya\ Pradesh",
"918356", "Muddebihal\,\ Karnataka",
"9174382", "Keshoraipatan\/Patan\,\ Rajasthan",
"91724", "Akola\,\ Maharashtra",
"917280", "Barwaha\,\ Madhya\ Pradesh",
"917659", "Jaithari\,\ Madhya\ Pradesh",
"9161545", "Siwan\,\ Bihar",
"912583", "Edalabad\,\ Maharashtra",
"9174530", "Baran\,\ Rajasthan",
"918732", "Adilabad\,\ Andhra\ Pradesh",
"9111", "New\ Delhi",
"9167327", "Hindol\,\ Odisha",
"915343", "Patti\,\ Uttar\ Pradesh",
"918471", "Mashal\,\ Karnataka",
"9176363", "Baihar\,\ Madhya\ Pradesh",
"9175947", "Ganjbasoda\,\ Madhya\ Pradesh",
"917853", "Bijapur\,\ Madhya\ Pradesh",
"9164717", "Birpur\,\ Bihar",
"912894", "Kalawad\,\ Gujarat",
"9168544", "Jeypore\,\ Odisha",
"9176462", "Nainpur\,\ Madhya\ Pradesh",
"9175948", "Ganjbasoda\,\ Madhya\ Pradesh",
"9174964", "Pichhore\,\ Madhya\ Pradesh",
"9171062", "Bhiwapur\,\ Maharashtra",
"915844", "Powayan\,\ Uttar\ Pradesh",
"912974", "Abu\ Road\,\ Rajasthan",
"9167602", "Talcher\,\ Odisha",
"9161843", "Sasaram\,\ Bihar",
"917570", "Seonimalwa\,\ Madhya\ Pradesh",
"913872", "Chandel\,\ Manipur",
"9167675", "Barbil\,\ Odisha",
"914181", "Polur\,\ Tamil\ Nadu",
"9168174", "R\.Udayigiri\,\ Odisha",
"9164237", "Maheshpur\ Raj\,\ Bihar",
"912987", "Sheo\,\ Rajasthan",
"9167937", "Betanati\,\ Odisha",
"9182892", "Athani\,\ Karnataka",
"9168654", "Kashipur\,\ Odisha",
"9162592", "Pakridayal\,\ Bihar",
"9168417", "Boudh\,\ Odisha",
"918506", "Narayanpet\,\ Andhra\ Pradesh",
"912437", "Khultabad\,\ Maharashtra",
"9174809", "Goharganj\,\ Madhya\ Pradesh",
"91291", "Jodhpur\,\ Rajasthan",
"9167483", "Bhubaneshwar\,\ Odisha",
"917365", "Mahidpurcity\,\ Madhya\ Pradesh",
"913483", "Murshidabad\/Jiaganj\,\ West\ Bengal",
"9174136", "Sailana\,\ Madhya\ Pradesh",
"9166573", "Kantabhanji\,\ Odisha",
"9174353", "Gangdhar\,\ Rajasthan",
"9181702", "Alur\,\ Karnataka",
"9167236", "Athgarh\,\ Odisha",
"9174316", "Aklera\,\ Rajasthan",
"9165476", "Chavparan\,\ Bihar",
"9165632", "Bhawanathpur\,\ Bihar",
"9161854", "Bikramganj\,\ Bihar",
"917773", "Odgi\,\ Madhya\ Pradesh",
"9175214", "Seondha\,\ Madhya\ Pradesh",
"913752", "Lakhimpur\,\ Assam",
"918217", "Mysore\,\ Karnataka",
"911567", "Ratangarh\,\ Rajasthan",
"915251", "Kaisarganj\/Kaiserganj\,\ Uttar\ Pradesh",
"911255", "Siwani\,\ Haryana",
"9176265", "Vijayraghogarh\,\ Madhya\ Pradesh",
"9168553", "Laxmipur\,\ Odisha",
"914633", "Tenkasi\,\ Tamil\ Nadu",
"918265", "Koppa\,\ Karnataka",
"9171975", "Mohadi\,\ Maharashtra",
"9171142", "Ramtek\,\ Maharashtra",
"9174696", "Hindaun\,\ Rajasthan",
"9165577", "Bagodar\,\ Bihar",
"918557", "Penukonda\,\ Andhra\ Pradesh",
"918380", "Navalgund\,\ Karnataka",
"9164326", "Deoghar\,\ Bihar",
"9163376", "Arwal\,\ Bihar",
"915688", "Etawah\,\ Uttar\ Pradesh",
"912836", "Anjar\/Gandhidham\,\ Gujarat",
"916574", "Jamshedpur\,\ Bihar",
"9171803", "Salekasa\,\ Maharashtra",
"9174255", "Garoth\,\ Madhya\ Pradesh",
"9165224", "Muri\,\ Bihar",
"9162446", "Khagaria\,\ Bihar",
"9174344", "Pirawa\/Raipur\,\ Rajasthan",
"917721", "Neora\,\ Madhya\ Pradesh",
"918254", "Kundapur\,\ Karnataka",
"9162547", "Bettiah\,\ Bihar",
"9173239", "Punasa\,\ Madhya\ Pradesh",
"918514", "Nandyal\,\ Andhra\ Pradesh",
"9168643", "Mathili\,\ Odisha",
"918199", "Hosadurga\,\ Karnataka",
"9171572", "Arvi\,\ Maharashtra",
"9176473", "Ghughari\,\ Madhya\ Pradesh",
"9176305", "Katangi\,\ Madhya\ Pradesh",
"915946", "Haldwani\,\ Uttar\ Pradesh",
"9167316", "Anandapur\,\ Odisha",
"912876", "Veraval\,\ Gujarat",
"9174236", "Neemuch\,\ Madhya\ Pradesh",
"912645", "Jhagadia\,\ Gujarat",
"917327", "Harsud\,\ Madhya\ Pradesh",
"9171664", "Chaurai\,\ Madhya\ Pradesh",
"913801", "Anini\,\ Arunachal\ Pradesh",
"9176372", "Birsa\,\ Madhya\ Pradesh",
"9164552", "Forbesganj\,\ Bihar",
"912551", "Sinnar\,\ Maharashtra",
"9174810", "Gairatganj\,\ Madhya\ Pradesh",
"911749", "Assandh\,\ Haryana",
"917792", "Narsinghpur\,\ Madhya\ Pradesh",
"9165914", "Chandil\,\ Bihar",
"912996", "Pokhran\/Loharki\,\ Rajasthan",
"917516", "Gwalior\,\ Madhya\ Pradesh",
"918402", "Kanigiri\,\ Andhra\ Pradesh",
"9172868", "Khetia\,\ Madhya\ Pradesh",
"9168582", "Nowrangapur\,\ Odisha",
"917256", "Murtizapur\,\ Maharashtra",
"9167696", "Kamakhyanagar\,\ Odisha",
"918413", "Hyderabad\ West\/Shamshabad\,\ Andhra\ Pradesh",
"9172867", "Khetia\,\ Madhya\ Pradesh",
"9165292", "Itki\,\ Bihar",
"9162506", "Dhaka\,\ Bihar",
"9165946", "Baharagora\,\ Bihar",
"9166243", "Rajgangpur\,\ Odisha",
"9127176", "Sanand\,\ Gujarat",
"915496", "Ballia\/Raniganj\,\ Uttar\ Pradesh",
"912678", "Devgadhbaria\,\ Gujarat",
"9177053", "Kurud\,\ Madhya\ Pradesh",
"917733", "Pawai\,\ Madhya\ Pradesh",
"9167255", "Dhanmandal\,\ Odisha",
"9174569", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"9168527", "Koraput\,\ Odisha",
"918852", "Peddapuram\,\ Andhra\ Pradesh",
"9175924", "Vidisha\,\ Madhya\ Pradesh",
"914153", "Arakandanallur\,\ Tamil\ Nadu",
"912446", "Ambejogai\,\ Maharashtra",
"912820", "Paddhari\,\ Gujarat",
"913451", "Seharabazar\,\ West\ Bengal",
"9168426", "Phulbani\,\ Odisha",
"918240", "Mangalore\,\ Karnataka",
"9171445", "Atner\,\ Madhya\ Pradesh",
"9174874", "Begamganj\,\ Madhya\ Pradesh",
"91542", "Varansi\,\ Uttar\ Pradesh",
"9174812", "Gairatganj\,\ Madhya\ Pradesh",
"911532", "Nokha\/Nathusar\,\ Rajasthan",
"9176370", "Birsa\,\ Madhya\ Pradesh",
"9166792", "Komana\,\ Odisha",
"9161866", "Aurangabad\,\ Bihar",
"913798", "Mariyang\,\ Arunachal\ Pradesh",
"911997", "Bedarwah\,\ Jammu\ And\ Kashmir",
"9180", "Bangalore\,\ Karnataka",
"9165873", "Chakardharpur\,\ Bihar",
"918938", "Sileru\,\ Andhra\ Pradesh",
"914145", "Gingee\,\ Tamil\ Nadu",
"9165575", "Bagodar\,\ Bihar",
"9176268", "Vijayraghogarh\,\ Madhya\ Pradesh",
"9162773", "Phulparas\,\ Bihar",
"9161592", "Masrakh\,\ Bihar",
"9171977", "Mohadi\,\ Maharashtra",
"9176267", "Vijayraghogarh\,\ Madhya\ Pradesh",
"9165502", "Hunterganj\,\ Bihar",
"918488", "Sindagi\,\ Karnataka",
"913825", "Khowai\,\ Tripura",
"914281", "Yercaud\,\ Tamil\ Nadu",
"9167223", "Pardip\,\ Odisha",
"9176346", "Lamta\,\ Madhya\ Pradesh",
"911884", "Garhashanker\,\ Punjab",
"911342", "Bijnor\,\ Uttar\ Pradesh",
"9168212", "Bhanjanagar\,\ Odisha",
"9168186", "Buguda\,\ Odisha",
"9174257", "Garoth\,\ Madhya\ Pradesh",
"911593", "Khetri\,\ Rajasthan",
"9162296", "Bidupur\,\ Bihar",
"9176439", "Bijadandi\,\ Madhya\ Pradesh",
"9174258", "Garoth\,\ Madhya\ Pradesh",
"91470", "Attingal\,\ Kerala",
"917279", "Nandnva\,\ Maharashtra",
"9165972", "Saraikela\/Adstyapur\,\ Bihar",
"9164676", "Banmankhi\,\ Bihar",
"917694", "Keolari\,\ Madhya\ Pradesh",
"9174913", "Narwar\,\ Madhya\ Pradesh",
"9162545", "Bettiah\,\ Bihar",
"912528", "Dahanu\,\ Maharashtra",
"9164333", "Jamtara\,\ Bihar",
"912133", "Manchar\,\ Maharashtra",
"911494", "Behror\,\ Rajasthan",
"914341", "Uthangarai\,\ Tamil\ Nadu",
"918945", "Tekkali\/Palasa\,\ Andhra\ Pradesh",
"9176308", "Katangi\,\ Madhya\ Pradesh",
"9171514", "Samudrapur\,\ Maharashtra",
"9167812", "Basta\,\ Odisha",
"913665", "Tarabarihat\,\ Assam",
"9171656", "Saunsar\,\ Madhya\ Pradesh",
"912566", "Sindkheda\,\ Maharashtra",
"9176307", "Katangi\,\ Madhya\ Pradesh",
"917239", "Wani\,\ Maharashtra",
"917261", "Deolgaonraja\,\ Maharashtra",
"9172865", "Khetia\,\ Madhya\ Pradesh",
"9165442", "Gomia\,\ Bihar",
"912325", "Kagal\/Murgud\,\ Maharashtra",
"9174223", "Mandsaur\,\ Madhya\ Pradesh",
"91368", "Passighat\,\ Arunachal\ Pradesh",
"9165343", "Jhumaritalaiya\,\ Bihar",
"917758", "Dabhara\,\ Madhya\ Pradesh",
"9164733", "Supaul\,\ Bihar",
"91376", "Jorhat\,\ Assam",
"911572", "Sikar\,\ Rajasthan",
"915183", "Fatehpur\/Gazipur\,\ Uttar\ Pradesh",
"915613", "Achhnera\,\ Uttar\ Pradesh",
"918495", "Rayadurg\,\ Andhra\ Pradesh",
"9168525", "Koraput\,\ Odisha",
"9167257", "Dhanmandal\,\ Odisha",
"912192", "Khopoli\,\ Maharashtra",
"9161524", "Chapra\,\ Bihar",
"9174619", "Mahuwa\,\ Rajasthan",
"918725", "Metpalli\,\ Andhra\ Pradesh",
"9168433", "Puruna\ Katak\,\ Odisha",
"913654", "Nongstoin\,\ Meghalaya",
"9166493", "Jamankira\,\ Odisha",
"9166724", "Dharamgarh\,\ Odisha",
"915142", "Purwa\/Bighapur\,\ Uttar\ Pradesh",
"9171447", "Atner\,\ Madhya\ Pradesh",
"9164213", "Naugachia\,\ Bihar",
"9163443", "Monghyr\,\ Bihar",
"911282", "Narnaul\,\ Haryana",
"9162472", "Singhwara\,\ Bihar",
"913174", "Diamond\ Harbour\,\ West\ Bengal",
"9167913", "Bangiriposi\,\ Odisha",
"913785", "Bameng\,\ Arunachal\ Pradesh",
"918693", "Thungaturthy\,\ Andhra\ Pradesh",
"9164763", "Madhepura\,\ Bihar",
"9174389", "Keshoraipatan\/Patan\,\ Rajasthan",
"915362", "Sultanpur\,\ Uttar\ Pradesh",
"9166483", "Patnagarh\,\ Odisha",
"9174254", "Garoth\,\ Madhya\ Pradesh",
"9174345", "Pirawa\/Raipur\,\ Rajasthan",
"9165225", "Muri\,\ Bihar",
"912136", "Urlikanchan\,\ Maharashtra",
"9167573", "Daspalla\,\ Odisha",
"917260", "Lonar\,\ Maharashtra",
"912563", "Shirpur\,\ Maharashtra",
"9171974", "Mohadi\,\ Maharashtra",
"913463", "Bolpur\,\ West\ Bengal",
"918632", "Guntur\,\ Andhra\ Pradesh",
"917759", "Korba\,\ Madhya\ Pradesh",
"9161553", "Ekma\,\ Bihar",
"91424", "Erode\,\ Tamil\ Nadu",
"9174609", "Sahabad\,\ Rajasthan",
"9176264", "Vijayraghogarh\,\ Madhya\ Pradesh",
"9168463", "Baliguda\,\ Odisha",
"9161855", "Bikramganj\,\ Bihar",
"917238", "Darwaha\,\ Maharashtra",
"9164203", "Amarpur\,\ Bihar",
"9175215", "Seondha\,\ Madhya\ Pradesh",
"912967", "Aspur\,\ Rajasthan",
"9166753", "T\.Rampur\,\ Odisha",
"913564", "Alipurduar\,\ West\ Bengal",
"9173950", "Sondhwa\,\ Madhya\ Pradesh",
"914179", "Tirupattur\,\ Tamil\ Nadu",
"9166727", "Dharamgarh\,\ Odisha",
"915263", "Balarampur\/Balrampur\,\ Uttar\ Pradesh",
"9181709", "Alur\,\ Karnataka",
"918672", "Bandar\/Machilipatnam\,\ Andhra\ Pradesh",
"9171444", "Atner\,\ Madhya\ Pradesh",
"912529", "Mokhada\,\ Maharashtra",
"9174875", "Begamganj\,\ Madhya\ Pradesh",
"915964", "Pithoragarh\,\ Uttar\ Pradesh",
"9174802", "Goharganj\,\ Madhya\ Pradesh",
"9166452", "Jharsuguda\,\ Odisha",
"9167254", "Dhanmandal\,\ Odisha",
"918152", "Kolar\,\ Karnataka",
"9161527", "Chapra\,\ Bihar",
"9182899", "Athani\,\ Karnataka",
"912455", "Kalamnuri\,\ Maharashtra",
"916612", "Rourkela\,\ Odisha",
"9175925", "Vidisha\,\ Madhya\ Pradesh",
"9165512", "Barkagaon\,\ Bihar",
"9162286", "Pupri\,\ Bihar",
"9161836", "Buxar\,\ Bihar",
"9168196", "Surada\,\ Odisha",
"9174573", "Mangrol\,\ Rajasthan",
"911951", "Badgam\,\ Jammu\ And\ Kashmir",
"913215", "Bongoan\,\ West\ Bengal",
"9164363", "Sahibganj\,\ Bihar",
"911386", "Lansdowne\,\ Uttarakhand",
"9161582", "Sonepur\,\ Bihar",
"9171416", "Betul\,\ Madhya\ Pradesh",
"914365", "Nagapattinam\,\ Tamil\ Nadu",
"9176469", "Nainpur\,\ Madhya\ Pradesh",
"913014", "Jaisalmer\/Khuri\,\ Rajasthan",
"9171517", "Samudrapur\,\ Maharashtra",
"9171665", "Chaurai\,\ Madhya\ Pradesh",
"9165915", "Chandil\,\ Bihar",
"9174903", "Pohari\,\ Madhya\ Pradesh",
"9174143", "Jaora\,\ Madhya\ Pradesh",
"913799", "Tuting\,\ Arunachal\ Pradesh",
"9176304", "Katangi\,\ Madhya\ Pradesh",
"911596", "Chirawa\,\ Rajasthan",
"9166782", "Nowparatan\,\ Odisha",
"9174800", "Goharganj\,\ Madhya\ Pradesh",
"912550", "Niphad\,\ Maharashtra",
"917253", "Mangrulpur\,\ Maharashtra",
"913582", "Coochbehar\,\ West\ Bengal",
"913800", "Jairampur\,\ Arunachal\ Pradesh",
"9162544", "Bettiah\,\ Bihar",
"918416", "Vikrabad\,\ Andhra\ Pradesh",
"912993", "Jaisalmer\/Devikot\,\ Rajasthan",
"917513", "Gwalior\,\ Madhya\ Pradesh",
"918787", "Karimnagar\,\ Andhra\ Pradesh",
"9173952", "Sondhwa\,\ Madhya\ Pradesh",
"9163283", "Daudnagar\,\ Bihar",
"9174348", "Pirawa\/Raipur\,\ Rajasthan",
"914998", "Uppala\,\ Kerala",
"915244", "Haidergarh\,\ Uttar\ Pradesh",
"9165227", "Muri\,\ Bihar",
"918522", "Peapalle\,\ Andhra\ Pradesh",
"9174347", "Pirawa\/Raipur\,\ Rajasthan",
"912679", "Jhalod\,\ Gujarat",
"915943", "Khatima\,\ Uttar\ Pradesh",
"912873", "Visavadar\,\ Gujarat",
"9174266", "Sitamau\,\ Madhya\ Pradesh",
"913834", "Demagiri\,\ Mizoram",
"91816", "Tumkur\,\ Karnataka",
"9175953", "Nateran\,\ Madhya\ Pradesh",
"9165282", "Khunti\,\ Bihar",
"9176256", "Umariapan\,\ Madhya\ Pradesh",
"9167686", "Parajang\,\ Odisha",
"9165574", "Bagodar\,\ Bihar",
"912597", "Parola\,\ Maharashtra",
"912443", "Manjalegaon\,\ Maharashtra",
"91231", "Kolhapur\,\ Maharashtra",
"9168592", "Motu\,\ Odisha",
"9174706", "Bundi\,\ Rajasthan",
"9166532", "Dunguripali\,\ Odisha",
"916714", "Cuttack\,\ Odisha",
"917917", "Ahmedabad\ Local\,\ Gujarat",
"912932", "Pali\,\ Rajasthan",
"9162516", "Bagaha\,\ Bihar",
"9175218", "Seondha\,\ Madhya\ Pradesh",
"911748", "Gharaunda\,\ Haryana",
"9174539", "Baran\,\ Rajasthan",
"918667", "Vijayawada\,\ Andhra\ Pradesh",
"9175217", "Seondha\,\ Madhya\ Pradesh",
"912482", "Jalna\,\ Maharashtra",
"91798", "Ahmedabad\ Local\,\ Gujarat",
"912821", "Jasdan\,\ Gujarat",
"915723", "Atrauli\,\ Uttar\ Pradesh",
"915493", "Mohamdabad\,\ Uttar\ Pradesh",
"915547", "Khalilabad\,\ Uttar\ Pradesh",
"918774", "Tirupathi\,\ Andhra\ Pradesh",
"9161857", "Bikramganj\,\ Bihar",
"918185", "Hosanagara\,\ Karnataka",
"918615", "Nellore\,\ Andhra\ Pradesh",
"9174878", "Begamganj\,\ Madhya\ Pradesh",
"914636", "Sankarankovil\,\ Tamil\ Nadu",
"913874", "Churchandpur\,\ Manipur",
"9161823", "Arrah\,\ Bihar",
"918198", "Molkalmuru\,\ Karnataka",
"9174877", "Begamganj\,\ Madhya\ Pradesh",
"9166725", "Dharamgarh\,\ Odisha",
"915842", "Shahjahanpur\,\ Uttar\ Pradesh",
"9174306", "Khanpur\,\ Rajasthan",
"912972", "Sirohi\,\ Rajasthan",
"916635", "Sambalpur\,\ Odisha",
"9163252", "Pakribarwan\,\ Bihar",
"9175928", "Vidisha\,\ Madhya\ Pradesh",
"917776", "Premnagar\,\ Madhya\ Pradesh",
"9167266", "Jajapur\ Road\,\ Odisha",
"9175927", "Vidisha\,\ Madhya\ Pradesh",
"9168524", "Koraput\,\ Odisha",
"912892", "Okha\,\ Gujarat",
"915250", "Bahraich\/Bhinga\,\ Uttar\ Pradesh",
"9161525", "Chapra\,\ Bihar",
"918734", "Nirmal\,\ Andhra\ Pradesh",
"9165662", "Japla\,\ Bihar",
"917720", "Arang\,\ Madhya\ Pradesh",
"9174686", "Khandar\,\ Rajasthan",
"9165253", "Simdega\,\ Bihar",
"9171813", "Lakhandur\,\ Maharashtra",
"91381", "Agartala\,\ Tripura",
"912661", "Naswadi\,\ Gujarat",
"9172864", "Khetia\,\ Madhya\ Pradesh",
"914985", "Payyanur\,\ Kerala",
"918381", "Ron\,\ Karnataka",
"9164593", "Thakurganj\,\ Bihar",
"91496", "Vatakara\,\ Kerala",
"9165917", "Chandil\,\ Bihar",
"9171667", "Chaurai\,\ Madhya\ Pradesh",
"9171515", "Samudrapur\,\ Maharashtra",
"918700", "Warangal\,\ Andhra\ Pradesh",
"911735", "Chaaharauli\,\ Haryana",
"91535", "Raibareli\,\ Uttar\ Pradesh",
"915731", "Garhmukteshwar\,\ Uttar\ Pradesh",
"912833", "Khambhalia\,\ Gujarat",
"9171122", "Katol\,\ Maharashtra",
"9166257", "Lahunipara\,\ Odisha",
"918625", "Venkatgiri\,\ Andhra\ Pradesh",
"9177048", "Deobhog\,\ Madhya\ Pradesh",
"9171032", "Butibori\,\ Maharashtra",
"918470", "Afzalpur\,\ Karnataka",
"9167493", "Bhubaneshwar\,\ Odisha",
"9177047", "Deobhog\,\ Madhya\ Pradesh",
"917281", "Sendhwa\,\ Madhya\ Pradesh",
"913754", "Moranhat\,\ Assam",
"9164314", "Jharmundi\,\ Bihar",
"9176432", "Bijadandi\,\ Madhya\ Pradesh",
"9162582", "Areraj\,\ Bihar",
"9163455", "Jamui\,\ Bihar",
"917571", "Khirkiya\,\ Madhya\ Pradesh",
"9174934", "Karera\,\ Madhya\ Pradesh",
"9162274", "Mahua\,\ Bihar",
"9171856", "Pauni\,\ Maharashtra",
"9167612", "Chhendipada\,\ Odisha",
"912586", "Chopda\,\ Maharashtra",
"9174560", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"9176333", "Waraseoni\,\ Madhya\ Pradesh",
"917856", "Dantewada\,\ Madhya\ Pradesh",
"917605", "Patera\,\ Madhya\ Pradesh",
"9161112", "Hilsa\,\ Bihar",
"911624", "Jagraon\,\ Punjab",
"9166812", "Jujumura\,\ Odisha",
"9168623", "Gudari\,\ Odisha",
"9168506", "Kalimela\,\ Odisha",
"911262", "Rohtak\,\ Haryana",
"918512", "Adoni\,\ Andhra\ Pradesh",
"9162527", "Motihari\,\ Bihar",
"918503", "Makthal\,\ Andhra\ Pradesh",
"9165355", "Chainpur\,\ Bihar",
"917523", "Bhander\,\ Madhya\ Pradesh",
"9162426", "Benipur\,\ Bihar",
"9174324", "Jhalawar\,\ Rajasthan",
"9165244", "Gumla\,\ Bihar",
"917747", "Mohla\,\ Madhya\ Pradesh",
"916572", "Jamshedpur\,\ Bihar",
"918426", "Telgi\,\ Karnataka",
"9164267", "Rajmahal\,\ Bihar",
"9171187", "Kalmeshwar\,\ Maharashtra",
"9174819", "Gairatganj\,\ Madhya\ Pradesh",
"917658", "Kotma\,\ Madhya\ Pradesh",
"9164346", "Dumka\,\ Bihar",
"918840", "Kakinada\,\ Andhra\ Pradesh",
"9175226", "Datia\,\ Madhya\ Pradesh",
"9167967", "Karanjia\,\ Odisha",
"9168407", "Tumudibandha\,\ Odisha",
"9173230", "Punasa\,\ Madhya\ Pradesh",
"918468", "Kamareddy\,\ Andhra\ Pradesh",
"9168414", "Boudh\,\ Odisha",
"918404", "Marturu\,\ Andhra\ Pradesh",
"91460", "Taliparamba\,\ Kerala",
"912753", "Limbdi\,\ Gujarat",
"915851", "Bilgam\/Madhoganj\,\ Uttar\ Pradesh",
"911606", "Kharar\,\ Punjab",
"9167934", "Betanati\,\ Odisha",
"9162553", "Raxaul\,\ Bihar",
"917794", "Gotegaon\,\ Madhya\ Pradesh",
"9168177", "R\.Udayigiri\,\ Odisha",
"9165673", "Barwadih\,\ Bihar",
"9164234", "Maheshpur\ Raj\,\ Bihar",
"9165336", "Basia\,\ Bihar",
"9177006", "Nagri\,\ Madhya\ Pradesh",
"9175916", "Sironj\,\ Madhya\ Pradesh",
"9174612", "Mahuwa\,\ Rajasthan",
"918865", "Yelavaram\,\ Andhra\ Pradesh",
"9168657", "Kashipur\,\ Odisha",
"912901", "Siwana\,\ Rajasthan",
"9171986", "Tirora\,\ Maharashtra",
"9171425", "Bhimpur\,\ Madhya\ Pradesh",
"918353", "Jamkhandi\,\ Karnataka",
"9171533", "Hinganghat\,\ Maharashtra",
"9168446", "Kantamal\,\ Odisha",
"911363", "Karnaprayag\,\ Uttarakhand",
"918854", "Tuni\,\ Andhra\ Pradesh",
"9174968", "Pichhore\,\ Madhya\ Pradesh",
"9168547", "Jeypore\,\ Odisha",
"9175944", "Ganjbasoda\,\ Madhya\ Pradesh",
"9171835", "Tumsar\,\ Maharashtra",
"9164714", "Birpur\,\ Bihar",
"917531", "Baroda\,\ Madhya\ Pradesh",
"9167324", "Hindol\,\ Odisha",
"9174967", "Pichhore\,\ Madhya\ Pradesh",
"9166223", "Sundargarh\,\ Odisha",
"9164622", "Dhamdaha\,\ Bihar",
"9165485", "Ichak\,\ Bihar",
"9187596", "Outsarangapalle\,\ Andhra\ Pradesh",
"9177045", "Deobhog\,\ Madhya\ Pradesh",
"912778", "Idar\,\ Gujarat",
"9167243", "Jagatsinghpur\,\ Odisha",
"9176326", "Balaghat\,\ Madhya\ Pradesh",
"912925", "Phalodi\,\ Rajasthan",
"9164772", "Triveniganj\,\ Bihar",
"9166255", "Lahunipara\,\ Odisha",
"9173232", "Punasa\,\ Madhya\ Pradesh",
"9174610", "Mahuwa\,\ Rajasthan",
"9167562", "Balugaon\,\ Odisha",
"9171864", "Sakoli\,\ Maharashtra",
"917861", "Netanar\,\ Madhya\ Pradesh",
"9171453", "Chicholi\,\ Madhya\ Pradesh",
"911473", "Barisadri\,\ Rajasthan",
"9171352", "Chamorshi\,\ Maharashtra",
"911534", "Kolayat\,\ Rajasthan",
"9163457", "Jamui\,\ Bihar",
"912147", "Shrivardhan\,\ Maharashtra",
"9174674", "Bamanwas\,\ Rajasthan",
"913193", "Andaman\ \&\ Nicobar\,\ Nicobar\ Islands",
"9162525", "Motihari\,\ Bihar",
"917692", "Seoni\,\ Madhya\ Pradesh",
"9162433", "Begusarai\,\ Bihar",
"9167965", "Karanjia\,\ Odisha",
"9168405", "Tumudibandha\,\ Odisha",
"918378", "Savanur\,\ Karnataka",
"9171185", "Kalmeshwar\,\ Maharashtra",
"9164265", "Rajmahal\,\ Bihar",
"911237", "Sardhana\,\ Uttar\ Pradesh",
"9168472", "G\.Udayagiri\,\ Odisha",
"9168636", "Bisam\ Cuttack\,\ Odisha",
"9165494", "Bermo\,\ Bihar",
"9171783", "Sinderwahi\,\ Maharashtra",
"911421", "Kotputli\,\ Rajasthan",
"918535", "Sindhanur\,\ Karnataka",
"9165357", "Chainpur\,\ Bihar",
"911882", "Hoshiarpur\,\ Punjab",
"911344", "Dhampur\,\ Uttar\ Pradesh",
"9162732", "Jhajharpur\,\ Bihar",
"9166716", "Rajkhariar\,\ Odisha",
"9165323", "Giridih\,\ Bihar",
"9174243", "Malhargarh\,\ Madhya\ Pradesh",
"917621", "Patan\,\ Madhya\ Pradesh",
"9165422", "Bokaro\,\ Bihar",
"914256", "Bhavani\,\ Tamil\ Nadu",
"911587", "Degana\,\ Rajasthan",
"916515", "Ranchi\,\ Bihar",
"9168655", "Kashipur\,\ Odisha",
"9168102", "Khalikote\,\ Odisha",
"918338", "Chikkodi\,\ Karnataka",
"9161516", "Sidhawalia\,\ Bihar",
"9171482", "Prabha\ Pattan\,\ Madhya\ Pradesh",
"9174562", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"9165832", "Kharsawa\,\ Bihar",
"9168175", "R\.Udayigiri\,\ Odisha",
"914327", "Thuraiyur\,\ Tamil\ Nadu",
"9171383", "Dhanora\,\ Maharashtra",
"91151", "Bikaner\,\ Rajasthan",
"917449", "Ladpura\/Kota\,\ Rajasthan",
"911492", "Laxmangarh\/Kherli\,\ Rajasthan",
"9176430", "Bijadandi\,\ Madhya\ Pradesh",
"913225", "Ghatal\,\ West\ Bengal",
"9165933", "Manoharpur\,\ Bihar",
"912738", "Santalpur\,\ Gujarat",
"911284", "Bawal\,\ Haryana",
"9163423", "H\.Kharagpur\,\ Bihar",
"9167674", "Barbil\,\ Odisha",
"9163322", "Nabinagar\,\ Bihar",
"9165586", "Dumri\(Isribazar\)\,\ Bihar",
"9164372", "Mahagama\,\ Bihar",
"917673", "Nagod\,\ Madhya\ Pradesh",
"9171427", "Bhimpur\,\ Madhya\ Pradesh",
"915144", "Safipur\,\ Uttar\ Pradesh",
"911983", "Zanaskar\,\ Jammu\ And\ Kashmir",
"9165487", "Ichak\,\ Bihar",
"918548", "Shadnagar\,\ Andhra\ Pradesh",
"9171526", "Wardha\,\ Maharashtra",
"913652", "Jowai\,\ Meghalaya",
"9171603", "Jamai\,\ Madhya\ Pradesh",
"9176379", "Birsa\,\ Madhya\ Pradesh",
"9174965", "Pichhore\,\ Madhya\ Pradesh",
"911433", "Todaraisingh\,\ Rajasthan",
"9161544", "Siwan\,\ Bihar",
"912194", "Roha\,\ Maharashtra",
"9171752", "Bhadrawati\,\ Maharashtra",
"9171837", "Tumsar\,\ Maharashtra",
"918360", "Hubli\,\ Karnataka",
"911574", "Neem\ Ka\ Thana\,\ Rajasthan",
"9168545", "Jeypore\,\ Odisha",
"914733", "Pathanamthitta\,\ Kerala",
"9171983", "Tirora\,\ Maharashtra",
"9171827", "Gondia\,\ Maharashtra",
"915614", "Jarar\,\ Uttar\ Pradesh",
"9173294", "Khakner\,\ Madhya\ Pradesh",
"9176509", "Beohari\,\ Madhya\ Pradesh",
"9162787", "Dalsinghsarai\,\ Bihar",
"911432", "Tonk\,\ Rajasthan",
"918398", "Harapanahalli\,\ Karnataka",
"9168443", "Kantamal\,\ Odisha",
"9171536", "Hinganghat\,\ Maharashtra",
"913653", "Amlarem\/Dawki\,\ Meghalaya",
"915690", "Kaimganj\,\ Uttar\ Pradesh",
"911982", "Leh\,\ Jammu\ And\ Kashmir",
"9171437", "Bhainsdehi\,\ Madhya\ Pradesh",
"917672", "Satna\,\ Madhya\ Pradesh",
"9176355", "Lanji\,\ Madhya\ Pradesh",
"9164575", "Korha\,\ Bihar",
"9166226", "Sundargarh\,\ Odisha",
"912640", "Rajpipla\,\ Gujarat",
"918588", "Vaimpalli\,\ Andhra\ Pradesh",
"9165887", "Jagarnathpur\,\ Bihar",
"918181", "Thirthahalli\,\ Karnataka",
"9176420", "Mandla\,\ Madhya\ Pradesh",
"9161817", "Piro\,\ Bihar",
"911493", "Tijara\,\ Rajasthan",
"9165822", "Chaibasa\,\ Bihar",
"912825", "Gondal\,\ Gujarat",
"9162457", "Gogri\,\ Bihar",
"918245", "Mangalore\,\ Karnataka",
"9174365", "Hindoli\,\ Rajasthan",
"9167272", "Kendrapara\,\ Odisha",
"9166474", "Naktideul\,\ Odisha",
"91515", "Unnao\,\ Uttar\ Pradesh",
"9162556", "Raxaul\,\ Bihar",
"9165432", "Barhi\,\ Bihar",
"9165676", "Barwadih\,\ Bihar",
"9174597", "Ramganj\ Mandi\,\ Rajasthan",
"9167584", "Nimapara\,\ Odisha",
"9177003", "Nagri\,\ Madhya\ Pradesh",
"9165333", "Basia\,\ Bihar",
"9162722", "Darbhanga\,\ Bihar",
"912428", "Pathardi\,\ Maharashtra",
"9174598", "Ramganj\ Mandi\,\ Rajasthan",
"9175913", "Sironj\,\ Madhya\ Pradesh",
"911883", "Dasua\,\ Punjab",
"912466", "Kandhar\,\ Maharashtra",
"912359", "Guhagar\,\ Maharashtra",
"9168503", "Kalimela\,\ Odisha",
"911250", "Charkhidadri\,\ Haryana",
"9168626", "Gudari\,\ Odisha",
"911594", "Udaipurwati\,\ Rajasthan",
"9176449", "Dindori\,\ Madhya\ Pradesh",
"913016", "Jaisalmer\/Jheenjaniyali\,\ Rajasthan",
"9162794", "Barauni\,\ Bihar",
"9171645", "Pandhurna\,\ Madhya\ Pradesh",
"9162423", "Benipur\,\ Bihar",
"917693", "Ghansour\,\ Madhya\ Pradesh",
"9165894", "Jhinkpani\,\ Bihar",
"9162535", "Narkatiaganj\,\ Bihar",
"9176485", "Mawai\,\ Madhya\ Pradesh",
"913192", "Andaman\ \&\ Nicobar\,\ Andaman\ Islands",
"9161804", "Adhaura\,\ Bihar",
"9175223", "Datia\,\ Madhya\ Pradesh",
"9164343", "Dumka\,\ Bihar",
"911731", "Barara\,\ Haryana",
"9171555", "Seloo\,\ Maharashtra",
"911377", "Bhatwari\/Gangotri\,\ Uttarakhand",
"915735", "Sikandrabad\,\ Uttar\ Pradesh",
"91135", "Dehradun\,\ Uttarakhand",
"91268", "Nadiad\,\ Gujarat",
"911472", "Chittorgarh\,\ Rajasthan",
"9167496", "Bhubaneshwar\,\ Odisha",
"918385", "Bhatkal\,\ Karnataka",
"9173222", "Depalpur\,\ Madhya\ Pradesh",
"912187", "Sangola\,\ Maharashtra",
"9174272", "Bhanpura\,\ Madhya\ Pradesh",
"915966", "Ranikhet\,\ Uttar\ Pradesh",
"9171853", "Pauni\,\ Maharashtra",
"913566", "Kalchini\,\ West\ Bengal",
"912665", "Sankheda\,\ Gujarat",
"9174584", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"9176336", "Waraseoni\,\ Madhya\ Pradesh",
"9171464", "Ghorandogri\,\ Madhya\ Pradesh",
"9174205", "Jawad\,\ Madhya\ Pradesh",
"9165936", "Manoharpur\,\ Bihar",
"912320", "Chandgad\,\ Maharashtra",
"918776", "Tirupathi\,\ Andhra\ Pradesh",
"9163426", "H\.Kharagpur\,\ Bihar",
"9171094", "Kamptee\,\ Maharashtra",
"9174214", "Manasa\,\ Madhya\ Pradesh",
"917734", "Shahnagar\,\ Madhya\ Pradesh",
"9162785", "Dalsinghsarai\,\ Bihar",
"9167334", "Ghatgaon\,\ Odisha",
"9165583", "Dumri\(Isribazar\)\,\ Bihar",
"9171825", "Gondia\,\ Maharashtra",
"9176358", "Lanji\,\ Madhya\ Pradesh",
"9165885", "Jagarnathpur\,\ Bihar",
"916716", "Cuttack\,\ Odisha",
"9171606", "Jamai\,\ Madhya\ Pradesh",
"9171523", "Wardha\,\ Maharashtra",
"911467", "Kekri\,\ Rajasthan",
"9176357", "Lanji\,\ Madhya\ Pradesh",
"9164577", "Korha\,\ Bihar",
"918457", "Siddipet\,\ Andhra\ Pradesh",
"913836", "Saiha\/Tuipang\,\ Mizoram",
"918352", "Bijapur\,\ Karnataka",
"9176494", "Kakaiya\,\ Madhya\ Pradesh",
"9171435", "Bhainsdehi\,\ Madhya\ Pradesh",
"9166713", "Rajkhariar\,\ Odisha",
"91222", "Mumbai",
"9174367", "Hindoli\,\ Rajasthan",
"9174246", "Malhargarh\,\ Madhya\ Pradesh",
"9165326", "Giridih\,\ Bihar",
"9162455", "Gogri\,\ Bihar",
"9164224", "Godda\,\ Bihar",
"9174368", "Hindoli\,\ Rajasthan",
"913780", "Dirang\,\ Arunachal\ Pradesh",
"9163274", "Rafiganj\,\ Bihar",
"9161815", "Piro\,\ Bihar",
"9167924", "Baripada\,\ Odisha",
"912752", "Surendranagar\,\ Gujarat",
"918490", "Pamuru\,\ Andhra\ Pradesh",
"9161513", "Sidhawalia\,\ Bihar",
"918720", "Mahadevapur\,\ Andhra\ Pradesh",
"9174270", "Bhanpura\,\ Madhya\ Pradesh",
"9174595", "Ramganj\ Mandi\,\ Rajasthan",
"9162564", "Ramnagar\,\ Bihar",
"9171386", "Dhanora\,\ Maharashtra",
"913638", "Nongpoh\,\ Meghalaya",
"91461", "Thoothukudi\,\ Tamil\ Nadu",
"9173220", "Depalpur\,\ Madhya\ Pradesh",
"918414", "Ibrahimpatnam\,\ Andhra\ Pradesh",
"915162", "Orai\,\ Uttar\ Pradesh",
"9171647", "Pandhurna\,\ Madhya\ Pradesh",
"9176299", "Pushprajgarh\,\ Madhya\ Pradesh",
"912451", "Pathari\,\ Maharashtra",
"916573", "Jamshedpur\,\ Bihar",
"9166412", "Deodgarh\,\ Odisha",
"9162436", "Begusarai\,\ Bihar",
"9174334", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"91771", "Raipur\,\ Madhya\ Pradesh",
"9167214", "Narsinghpur\,\ Odisha",
"914549", "Thirumanglam\,\ Tamil\ Nadu",
"91374", "Tinsukhia\,\ Assam",
"911964", "Kalakot\,\ Jammu\ And\ Kashmir",
"918502", "Alampur\,\ Andhra\ Pradesh",
"9173249", "Mhow\,\ Madhya\ Pradesh",
"918253", "Hebri\,\ Karnataka",
"9162537", "Narkatiaganj\,\ Bihar",
"9176487", "Mawai\,\ Madhya\ Pradesh",
"917787", "Jarwa\,\ Madhya\ Pradesh",
"9164292", "Kahalgaon\,\ Bihar",
"911263", "Gohana\,\ Haryana",
"918513", "Nandikotkur\,\ Andhra\ Pradesh",
"9171786", "Sinderwahi\,\ Maharashtra",
"913678", "Morigaon\,\ Assam",
"9168633", "Bisam\ Cuttack\,\ Odisha",
"9176488", "Mawai\,\ Madhya\ Pradesh",
"911908", "Jogindernagar\,\ Himachal\ Pradesh",
"9187593", "Outsarangapalle\,\ Andhra\ Pradesh",
"9176323", "Balaghat\,\ Madhya\ Pradesh",
"9167246", "Jagatsinghpur\,\ Odisha",
"918736", "Mancherial\,\ Andhra\ Pradesh",
"9165642", "Nagarutari\,\ Bihar",
"9174924", "Shivpuri\,\ Madhya\ Pradesh",
"917774", "Ambikapur\,\ Madhya\ Pradesh",
"9176422", "Mandla\,\ Madhya\ Pradesh",
"914339", "Keeranur\,\ Tamil\ Nadu",
"9171557", "Seloo\,\ Maharashtra",
"912801", "Ranavav\,\ Gujarat",
"9174207", "Jawad\,\ Madhya\ Pradesh",
"918965", "Gajapathinagaram\,\ Andhra\ Pradesh",
"9171456", "Chicholi\,\ Madhya\ Pradesh",
"9171022", "Parseoni\,\ Maharashtra",
"918917", "Visakhapatnam\,\ Andhra\ Pradesh",
"9174208", "Jawad\,\ Madhya\ Pradesh",
"914634", "Ambasamudram\,\ Tamil\ Nadu",
"913876", "Jiribam\,\ Manipur",
"911955", "Kupwara\,\ Jammu\ And\ Kashmir",
"9171132", "Saoner\,\ Maharashtra",
"913211", "Arambag\,\ West\ Bengal",
"91462", "Tirunelvelli\,\ Tamil\ Nadu",
"917817", "Janjgir\,\ Madhya\ Pradesh",
"912832", "Bhuj\,\ Gujarat",
"9163417", "Seikhpura\,\ Bihar",
"918424", "Devarahippargi\,\ Karnataka",
"9164247", "Banka\,\ Bihar",
"9164366", "Sahibganj\,\ Bihar",
"9167947", "Rairangpur\,\ Odisha",
"9171312", "Sironcha\,\ Maharashtra",
"9171413", "Betul\,\ Madhya\ Pradesh",
"917865", "Gogunda\,\ Madhya\ Pradesh",
"9165264", "Lohardaga\,\ Bihar",
"918710", "Cherial\,\ Andhra\ Pradesh",
"9174650", "Sapotra\,\ Rajasthan",
"9189467", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"9166215", "Hemgiri\,\ Odisha",
"912921", "Phalodi\/Bap\,\ Rajasthan",
"91788", "Durg\,\ Madhya\ Pradesh",
"9174906", "Pohari\,\ Madhya\ Pradesh",
"9174146", "Jaora\,\ Madhya\ Pradesh",
"913484", "Kandi\,\ West\ Bengal",
"9171692", "Batkakhapa\,\ Madhya\ Pradesh",
"918138", "Koratageri\,\ Karnataka",
"911425", "Phulera\/Sambhar\,\ Rajasthan",
"915882", "Pilibhit\,\ Uttar\ Pradesh",
"912699", "Thasra\,\ Gujarat",
"9165317", "Mandar\,\ Bihar",
"9161535", "Maharajganj\,\ Bihar",
"918531", "Deodurga\,\ Karnataka",
"9174540", "Chhipaborad\,\ Rajasthan",
"912584", "Raver\,\ Maharashtra",
"912893", "Jodia\,\ Gujarat",
"9168534", "Sunabeda\,\ Odisha",
"9175937", "Kurwai\,\ Madhya\ Pradesh",
"911795", "Nalagarh\,\ Himachal\ Pradesh",
"9161322", "Barh\,\ Bihar",
"917854", "Ilamidi\,\ Madhya\ Pradesh",
"9175938", "Kurwai\,\ Madhya\ Pradesh",
"912973", "Jalore\,\ Rajasthan",
"911559", "Rajgarh\,\ Rajasthan",
"915843", "Jalalabad\,\ Uttar\ Pradesh",
"9177067", "Gariaband\,\ Madhya\ Pradesh",
"9166735", "Jayapatna\,\ Odisha",
"913756", "Sadiya\,\ Assam",
"9175382", "Ambah\,\ Madhya\ Pradesh",
"9161833", "Buxar\,\ Bihar",
"911828", "Sultanpur\ Lodhi\,\ Punjab",
"9162283", "Pupri\,\ Bihar",
"914898", "Kiltan\,\ Lakshadweep",
"9185861", "Vayalpad\,\ Andhra\ Pradesh",
"9177068", "Gariaband\,\ Madhya\ Pradesh",
"918569", "Badvel\,\ Andhra\ Pradesh",
"9174576", "Mangrol\,\ Rajasthan",
"9168193", "Surada\,\ Odisha",
"9165697", "Garu\,\ Bihar",
"914885", "Kunnamkulam\,\ Kerala",
"918571", "Madanapalli\,\ Andhra\ Pradesh",
"9174947", "Kolaras\,\ Madhya\ Pradesh",
"9172882", "Bhikangaon\,\ Madhya\ Pradesh",
"913221", "Jhargram\,\ West\ Bengal",
"915722", "Hathras\,\ Uttar\ Pradesh",
"91551", "Gorakhpur\,\ Uttar\ Pradesh",
"912483", "Ambad\,\ Maharashtra",
"9175964", "Gyraspur\,\ Madhya\ Pradesh",
"9161556", "Ekma\,\ Bihar",
"918856", "Amalapuram\,\ Andhra\ Pradesh",
"9140", "Hyderabad\ Local\,\ Andhra\ Pradesh",
"9176280", "Karpa\,\ Madhya\ Pradesh",
"9168567", "Rayagada\,\ Odisha",
"9174529", "Chhabra\,\ Rajasthan",
"9174948", "Kolaras\,\ Madhya\ Pradesh",
"9168615", "Malkangiri\,\ Odisha",
"912933", "Bali\/Sumerpur\,\ Rajasthan",
"9166522", "Balangir\,\ Odisha",
"9168466", "Baliguda\,\ Odisha",
"912347", "Vita\,\ Maharashtra",
"91794", "Ahmedabad\ Local\,\ Gujarat",
"912442", "Bhir\,\ Maharashtra",
"9164206", "Amarpur\,\ Bihar",
"9177034", "Manpur\,\ Madhya\ Pradesh",
"9165304", "Bundu\,\ Bihar",
"91230", "Khadakwasala\,\ Maharashtra",
"9166756", "T\.Rampur\,\ Odisha",
"912872", "Vanthali\,\ Gujarat",
"9181750", "Holenarasipur\,\ Karnataka",
"918747", "Nuguru\/Cherla\,\ Andhra\ Pradesh",
"915942", "Nainital\,\ Uttar\ Pradesh",
"9164766", "Madhepura\,\ Bihar",
"9171712", "Gond\ Pipri\,\ Maharashtra",
"918523", "Alur\,\ Andhra\ Pradesh",
"911668", "Dabwali\,\ Haryana",
"9165237", "Ghaghra\,\ Bihar",
"917840", "Koyelibeda\,\ Madhya\ Pradesh",
"9171624", "Chhindwara\,\ Madhya\ Pradesh",
"911604", "Kharar\,\ Punjab",
"9166486", "Patnagarh\,\ Odisha",
"9176512", "Jaisinghnagar\,\ Madhya\ Pradesh",
"917512", "Gwalior\,\ Madhya\ Pradesh",
"918406", "Cumbum\,\ Andhra\ Pradesh",
"912992", "Jaisalmer\,\ Rajasthan",
"9165684", "Balumath\,\ Bihar",
"9167576", "Daspalla\,\ Odisha",
"915284", "Maudaha\,\ Uttar\ Pradesh",
"913583", "Mathabhanga\,\ West\ Bengal",
"917252", "Washim\,\ Maharashtra",
"9189465", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"9165256", "Simdega\,\ Bihar",
"9174683", "Khandar\,\ Rajasthan",
"917601", "Patharia\,\ Madhya\ Pradesh",
"9171816", "Lakhandur\,\ Maharashtra",
"9167652", "Palla\ Hara\,\ Odisha",
"9176282", "Karpa\,\ Madhya\ Pradesh",
"911346", "Pauri\/Bubakhal\,\ Uttarakhand",
"917575", "Sohagpur\,\ Madhya\ Pradesh",
"9167945", "Rairangpur\,\ Odisha",
"9164245", "Banka\,\ Bihar",
"9172880", "Bhikangaon\,\ Madhya\ Pradesh",
"9163415", "Seikhpura\,\ Bihar",
"9176574", "Jaitpur\,\ Madhya\ Pradesh",
"9164354", "Pakur\,\ Bihar",
"9164596", "Thakurganj\,\ Bihar",
"911702", "Nahan\,\ Himachal\ Pradesh",
"917285", "Kasrawad\,\ Madhya\ Pradesh",
"9171774", "Brahmapuri\,\ Maharashtra",
"918621", "Rapur\/Podalakur\,\ Andhra\ Pradesh",
"9166217", "Hemgiri\,\ Odisha",
"9161826", "Arrah\,\ Bihar",
"911536", "Kolayat\/Daitra\,\ Rajasthan",
"9174859", "Udaipura\,\ Madhya\ Pradesh",
"917548", "Mungaoli\,\ Madhya\ Pradesh",
"9171844", "Bhandara\,\ Maharashtra",
"9175935", "Kurwai\,\ Madhya\ Pradesh",
"917360", "Shujalpur\,\ Madhya\ Pradesh",
"916613", "Rourkela\,\ Odisha",
"9161537", "Maharajganj\,\ Bihar",
"9181752", "Holenarasipur\,\ Karnataka",
"9174303", "Khanpur\,\ Rajasthan",
"9165315", "Mandar\,\ Bihar",
"918153", "Bangarpet\,\ Karnataka",
"9165695", "Garu\,\ Bihar",
"9167263", "Jajapur\ Road\,\ Odisha",
"918673", "Tirivuru\,\ Andhra\ Pradesh",
"9168604", "Boriguma\,\ Odisha",
"9177065", "Gariaband\,\ Madhya\ Pradesh",
"915262", "Gonda\,\ Uttar\ Pradesh",
"9166737", "Jayapatna\,\ Odisha",
"9161152", "Danapur\,\ Bihar",
"9166852", "Sohela\,\ Odisha",
"9176510", "Jaisinghnagar\,\ Madhya\ Pradesh",
"913779", "Roing\/Mariso\,\ Arunachal\ Pradesh",
"9168617", "Malkangiri\,\ Odisha",
"9161564", "Gopalganj\,\ Bihar",
"912905", "Sarada\/Chawand\,\ Rajasthan",
"9175956", "Nateran\,\ Madhya\ Pradesh",
"9174652", "Sapotra\,\ Rajasthan",
"9167683", "Parajang\,\ Odisha",
"9176253", "Umariapan\,\ Madhya\ Pradesh",
"9168565", "Rayagada\,\ Odisha",
"911576", "Dantaramgarh\/Shyamji\,\ Rajasthan",
"915855", "Bilgram\/Sandi\,\ Uttar\ Pradesh",
"9174945", "Kolaras\,\ Madhya\ Pradesh",
"9162513", "Bagaha\,\ Bihar",
"911851", "Patti\,\ Punjab",
"9166764", "M\.Rampur\,\ Odisha",
"91212", "Chinchwad\,\ Maharashtra",
"9168454", "Phiringia\,\ Odisha",
"913462", "Suri\,\ West\ Bengal",
"918633", "Guntur\,\ Andhra\ Pradesh",
"918839", "Rajahmundri\,\ Andhra\ Pradesh",
"912958", "Kotra\,\ Rajasthan",
"912562", "Dhule\,\ Maharashtra",
"915864", "Sidhauli\/Mahmodabad\,\ Uttar\ Pradesh",
"9167402", "Bhubaneshwar\,\ Odisha",
"9165235", "Ghaghra\,\ Bihar",
"917535", "Raghunathpur\,\ Madhya\ Pradesh",
"9174542", "Chhipaborad\,\ Rajasthan",
"9164754", "S\.Bakhtiarpur\,\ Bihar",
"9163286", "Daudnagar\,\ Bihar",
"911520", "Bikaner\/Chhatargarh\,\ Rajasthan",
"914254", "Mettupalayam\,\ Tamil\ Nadu",
"9171374", "Desaiganj\,\ Maharashtra",
"918692", "Nampalle\,\ Andhra\ Pradesh",
"9174263", "Sitamau\,\ Madhya\ Pradesh",
"9162503", "Dhaka\,\ Bihar",
"9165943", "Baharagora\,\ Bihar",
"918636", "Guntur\,\ Andhra\ Pradesh",
"9127173", "Sanand\,\ Gujarat",
"9166246", "Rajgangpur\,\ Odisha",
"917767", "Gharghoda\,\ Madhya\ Pradesh",
"9177056", "Kurud\,\ Madhya\ Pradesh",
"9175390", "Ambah\,\ Madhya\ Pradesh",
"915143", "Hasanganj\,\ Uttar\ Pradesh",
"9168607", "Boriguma\,\ Odisha",
"9166734", "Jayapatna\,\ Odisha",
"917674", "Maihar\,\ Madhya\ Pradesh",
"9168423", "Phulbani\,\ Odisha",
"9161534", "Maharajganj\,\ Bihar",
"911434", "Deoli\,\ Rajasthan",
"912959", "Jhadol\,\ Rajasthan",
"9168535", "Sunabeda\,\ Odisha",
"914734", "Adoor\,\ Kerala",
"915612", "Ferozabad\,\ Uttar\ Pradesh",
"915182", "Khaga\,\ Uttar\ Pradesh",
"9171847", "Bhandara\,\ Maharashtra",
"911573", "Laxmangarh\,\ Rajasthan",
"9162742", "Samastipur\,\ Bihar",
"918838", "Rajahmundri\,\ Andhra\ Pradesh",
"9176476", "Ghughari\,\ Madhya\ Pradesh",
"9167313", "Anandapur\,\ Odisha",
"9174233", "Neemuch\,\ Madhya\ Pradesh",
"911897", "Pangi\/Killar\,\ Himachal\ Pradesh",
"9166214", "Hemgiri\,\ Odisha",
"91761", "Jabalpur\,\ Madhya\ Pradesh",
"9167412", "Bhubaneshwar\,\ Odisha",
"9171777", "Brahmapuri\,\ Maharashtra",
"9176578", "Jaitpur\,\ Madhya\ Pradesh",
"9165265", "Lohardaga\,\ Bihar",
"91364", "Shillong\,\ Meghalaya",
"915525", "Bansgaon\,\ Uttar\ Pradesh",
"9167693", "Kamakhyanagar\,\ Odisha",
"9176577", "Jaitpur\,\ Madhya\ Pradesh",
"9164357", "Pakur\,\ Bihar",
"9165842", "Bishrampur\,\ Bihar",
"911521", "Bikaner\/Jaimalsar\,\ Rajasthan",
"913778", "Pakkekesang\,\ Arunachal\ Pradesh",
"912132", "Junnar\,\ Maharashtra",
"9176440", "Dindori\,\ Madhya\ Pradesh",
"917687", "Laundi\,\ Madhya\ Pradesh",
"9164323", "Deoghar\,\ Bihar",
"9163373", "Arwal\,\ Bihar",
"916415", "Bhagalpur\,\ Bihar",
"9163472", "Chakai\,\ Bihar",
"9171806", "Salekasa\,\ Maharashtra",
"911487", "Banera\,\ Rajasthan",
"9165685", "Balumath\,\ Bihar",
"9162443", "Khagaria\,\ Bihar",
"911382", "Lansdowne\/Kotdwara\,\ Uttarakhand",
"9171377", "Desaiganj\,\ Maharashtra",
"918620", "Udaygiri\,\ Andhra\ Pradesh",
"9171625", "Chhindwara\,\ Madhya\ Pradesh",
"9176429", "Mandla\,\ Madhya\ Pradesh",
"9168646", "Mathili\,\ Odisha",
"9164757", "S\.Bakhtiarpur\,\ Bihar",
"9184532", "Medak\,\ Andhra\ Pradesh",
"918475", "Chincholi\,\ Karnataka",
"911592", "Jhunjhunu\,\ Rajasthan",
"91471", "Thiruvananthapuram\,\ Kerala",
"91141", "Jaipur\,\ Rajasthan",
"911343", "Nagina\,\ Uttar\ Pradesh",
"9167233", "Athgarh\,\ Odisha",
"918676", "Vuyyuru\,\ Andhra\ Pradesh",
"91416", "Vellore\,\ Tamil\ Nadu",
"9174313", "Aklera\,\ Rajasthan",
"9177035", "Manpur\,\ Madhya\ Pradesh",
"9165305", "Bundu\,\ Bihar",
"9166767", "M\.Rampur\,\ Odisha",
"917361", "Susner\,\ Madhya\ Pradesh",
"9165473", "Chavparan\,\ Bihar",
"9168457", "Phiringia\,\ Odisha",
"918845", "Kakinada\,\ Andhra\ Pradesh",
"9173242", "Mhow\,\ Madhya\ Pradesh",
"9175965", "Gyraspur\,\ Madhya\ Pradesh",
"9176500", "Beohari\,\ Madhya\ Pradesh",
"916616", "Rourkela\,\ Odisha",
"9161567", "Gopalganj\,\ Bihar",
"9168614", "Malkangiri\,\ Odisha",
"918156", "Chikkaballapur\,\ Karnataka",
"9168556", "Laxmipur\,\ Odisha",
"9176292", "Pushprajgarh\,\ Madhya\ Pradesh",
"911474", "Begun\,\ Rajasthan",
"911533", "Kolayat\/Goddo\,\ Rajasthan",
"9174693", "Hindaun\,\ Rajasthan",
"918354", "Bagalkot\,\ Karnataka",
"9177064", "Gariaband\,\ Madhya\ Pradesh",
"9168152", "Parlakhemundi\,\ Odisha",
"9168605", "Boriguma\,\ Odisha",
"91278", "Bhavnagar\,\ Gujarat",
"912936", "Pali\/Rohat\,\ Rajasthan",
"9168436", "Puruna\ Katak\,\ Odisha",
"9165694", "Garu\,\ Bihar",
"9168672", "Jharigan\,\ Odisha",
"911364", "Ukhimath\/Guptkashi\,\ Uttarakhand",
"918570", "Kuppam\,\ Andhra\ Pradesh",
"9166496", "Jamankira\,\ Odisha",
"913220", "Contai\,\ West\ Bengal",
"9175934", "Kurwai\,\ Madhya\ Pradesh",
"9171845", "Bhandara\,\ Maharashtra",
"9168537", "Sunabeda\,\ Odisha",
"9165314", "Mandar\,\ Bihar",
"917732", "Panna\,\ Madhya\ Pradesh",
"918659", "Mylavaram\,\ Andhra\ Pradesh",
"9164216", "Naugachia\,\ Bihar",
"9163446", "Monghyr\,\ Bihar",
"911669", "Adampur\ Mandi\,\ Haryana",
"912765", "Visnagar\,\ Gujarat",
"9167916", "Bangiriposi\,\ Odisha",
"9171775", "Brahmapuri\,\ Maharashtra",
"9173240", "Mhow\,\ Madhya\ Pradesh",
"918412", "Pargi\,\ Andhra\ Pradesh",
"912115", "Saswad\,\ Maharashtra",
"9171653", "Saunsar\,\ Madhya\ Pradesh",
"918317", "Belgaum\,\ Karnataka",
"917841", "Sarona\,\ Madhya\ Pradesh",
"9171702", "Chumur\,\ Maharashtra",
"918403", "Yerragondapalem\,\ Andhra\ Pradesh",
"912167", "Wai\,\ Maharashtra",
"918365", "Hubli\,\ Karnataka",
"917793", "Kareli\,\ Madhya\ Pradesh",
"912754", "Dhrangadhra\,\ Gujarat",
"9167944", "Rairangpur\,\ Odisha",
"9164244", "Banka\,\ Bihar",
"9164355", "Pakur\,\ Bihar",
"9176290", "Pushprajgarh\,\ Madhya\ Pradesh",
"9176575", "Jaitpur\,\ Madhya\ Pradesh",
"9163414", "Seikhpura\,\ Bihar",
"9165346", "Jhumaritalaiya\,\ Bihar",
"9189464", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"9174226", "Mandsaur\,\ Madhya\ Pradesh",
"9164736", "Supaul\,\ Bihar",
"9176502", "Beohari\,\ Madhya\ Pradesh",
"9165267", "Lohardaga\,\ Bihar",
"9171375", "Desaiganj\,\ Maharashtra",
"918952", "Chepurupalli\/Garividi\,\ Andhra\ Pradesh",
"918568", "Pulivendla\,\ Andhra\ Pradesh",
"9168183", "Buguda\,\ Odisha",
"9165687", "Balumath\,\ Bihar",
"918711", "Wardhannapet\/Ghanapur\,\ Andhra\ Pradesh",
"914899", "Chetlat\,\ Lakshadweep",
"9162293", "Bidupur\,\ Bihar",
"9173229", "Depalpur\,\ Madhya\ Pradesh",
"915648", "Bayana\,\ Rajasthan",
"9174279", "Bhanpura\,\ Madhya\ Pradesh",
"911962", "Rajouri\,\ Jammu\ And\ Kashmir",
"918504", "Atmakur\,\ Andhra\ Pradesh",
"9164673", "Banmankhi\,\ Bihar",
"9165234", "Ghaghra\,\ Bihar",
"917524", "Dabra\,\ Madhya\ Pradesh",
"9164755", "S\.Bakhtiarpur\,\ Bihar",
"9174916", "Narwar\,\ Madhya\ Pradesh",
"912920", "Bilara\/Bhopalgarh\,\ Rajasthan",
"9164336", "Jamtara\,\ Bihar",
"915164", "Kalpi\,\ Uttar\ Pradesh",
"9171627", "Chhindwara\,\ Madhya\ Pradesh",
"912698", "Khambat\,\ Gujarat",
"918139", "Turuvekere\,\ Karnataka",
"9161863", "Aurangabad\,\ Bihar",
"9168455", "Phiringia\,\ Odisha",
"9177038", "Manpur\,\ Madhya\ Pradesh",
"918207", "Udupi\,\ Karnataka",
"914632", "Kovilpatti\,\ Tamil\ Nadu",
"9171682", "Harrai\,\ Madhya\ Pradesh",
"9165876", "Chakardharpur\,\ Bihar",
"912976", "Sheoganj\/Posaliyan\,\ Rajasthan",
"9171042", "Hingua\,\ Maharashtra",
"9177037", "Manpur\,\ Madhya\ Pradesh",
"911505", "Padampur\,\ Rajasthan",
"9165307", "Bundu\,\ Bihar",
"9166765", "M\.Rampur\,\ Odisha",
"913753", "Dhemaji\,\ Assam",
"9176442", "Dindori\,\ Madhya\ Pradesh",
"9162776", "Phulparas\,\ Bihar",
"9174944", "Kolaras\,\ Madhya\ Pradesh",
"917772", "Wadrainagar\,\ Madhya\ Pradesh",
"9175968", "Gyraspur\,\ Madhya\ Pradesh",
"917227", "Chandurbazar\,\ Maharashtra",
"9165622", "Daltonganj\,\ Bihar",
"9161565", "Gopalganj\,\ Bihar",
"912896", "Bhanvad\,\ Gujarat",
"912740", "Vav\,\ Gujarat",
"9168564", "Rayagada\,\ Odisha",
"9175967", "Gyraspur\,\ Madhya\ Pradesh",
"9167226", "Pardip\,\ Odisha",
"9176343", "Lamta\,\ Madhya\ Pradesh",
"918516", "Dronachalam\,\ Andhra\ Pradesh",
"9166402", "Bagdihi\,\ Odisha",
"9167585", "Nimapara\,\ Odisha",
"9168663", "Umerkote\,\ Odisha",
"9174126", "Ratlam\,\ Madhya\ Pradesh",
"913482", "Berhampur\,\ West\ Bengal",
"914285", "Gobichettipalayam\,\ Tamil\ Nadu",
"913821", "R\.K\.Pur\,\ Tripura",
"91734", "Ujjain\,\ Madhya\ Pradesh",
"9166475", "Naktideul\,\ Odisha",
"918256", "Belthangady\,\ Karnataka",
"9162567", "Ramnagar\,\ Bihar",
"916576", "Jamshedpur\,\ Bihar",
"9162466", "Jainagar\,\ Bihar",
"9174364", "Hindoli\,\ Rajasthan",
"9181759", "Holenarasipur\,\ Karnataka",
"9167927", "Baripada\,\ Odisha",
"9175266", "Ghatigaon\,\ Madhya\ Pradesh",
"9167883", "Soro\,\ Odisha",
"9163277", "Rafiganj\,\ Bihar",
"918327", "Goa",
"9174852", "Udaipura\,\ Madhya\ Pradesh",
"914575", "Sivaganga\,\ Tamil\ Nadu",
"912834", "Kutchmandvi\,\ Gujarat",
"9164227", "Godda\,\ Bihar",
"918422", "Chadchan\,\ Karnataka",
"9176498", "Kakaiya\,\ Madhya\ Pradesh",
"913873", "Thinghat\,\ Manipur",
"911909", "Udaipur\,\ Himachal\ Pradesh",
"9174953", "Badarwas\,\ Madhya\ Pradesh",
"9164282", "Nala\,\ Bihar",
"9171796", "Nagbhir\,\ Maharashtra",
"9171162", "Umrer\,\ Maharashtra",
"9176497", "Kakaiya\,\ Madhya\ Pradesh",
"9164574", "Korha\,\ Bihar",
"9176354", "Lanji\,\ Madhya\ Pradesh",
"9171097", "Kamptee\,\ Maharashtra",
"913210", "Kakdwip\,\ West\ Bengal",
"9174218", "Manasa\,\ Madhya\ Pradesh",
"915447", "Dudhi\,\ Uttar\ Pradesh",
"917852", "Toynar\,\ Madhya\ Pradesh",
"9173295", "Khakner\,\ Madhya\ Pradesh",
"9167337", "Ghatgaon\,\ Odisha",
"915342", "Pratapgarh\,\ Uttar\ Pradesh",
"918733", "Asifabad\,\ Andhra\ Pradesh",
"9174217", "Manasa\,\ Madhya\ Pradesh",
"912582", "Bhusawal\,\ Maharashtra",
"9174520", "Chhabra\,\ Rajasthan",
"9176289", "Karpa\,\ Madhya\ Pradesh",
"9174585", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"9171465", "Ghorandogri\,\ Madhya\ Pradesh",
"9174204", "Jawad\,\ Madhya\ Pradesh",
"913639", "Baghmara\,\ Meghalaya",
"9171396", "Kurkheda\,\ Maharashtra",
"912444", "Patoda\,\ Maharashtra",
"912321", "Radhanagar\,\ Maharashtra",
"916713", "Cuttack\,\ Odisha",
"9166542", "Sonapur\,\ Odisha",
"917265", "Nandura\,\ Maharashtra",
"9174928", "Shivpuri\,\ Madhya\ Pradesh",
"9174549", "Chhipaborad\,\ Rajasthan",
"9171554", "Seloo\,\ Maharashtra",
"9164662", "Kishanganj\,\ Bihar",
"9165966", "Noamundi\,\ Bihar",
"915724", "Khair\,\ Uttar\ Pradesh",
"9171616", "Parasia\,\ Madhya\ Pradesh",
"913661", "Kokrajhar\,\ Assam",
"91281", "Rajkot\,\ Gujarat",
"918773", "Tirupathi\,\ Andhra\ Pradesh",
"9166263", "Banaigarh\,\ Odisha",
"915494", "Bansdeeh\,\ Uttar\ Pradesh",
"9174927", "Shivpuri\,\ Madhya\ Pradesh",
"918941", "Palakonda\/Rajam\,\ Andhra\ Pradesh",
"9162534", "Narkatiaganj\,\ Bihar",
"9176484", "Mawai\,\ Madhya\ Pradesh",
"9161805", "Adhaura\,\ Bihar",
"917254", "Malgaon\,\ Maharashtra",
"9167953", "Udala\,\ Odisha",
"9164253", "Katoria\,\ Bihar",
"915282", "Hamirpur\,\ Uttar\ Pradesh",
"912994", "Pokhran\,\ Rajasthan",
"9161872", "Mohania\,\ Bihar",
"9166703", "Bhawanipatna\,\ Odisha",
"912373", "Mahaswad\,\ Maharashtra",
"9165895", "Jhinkpani\,\ Bihar",
"917514", "Gwalior\,\ Madhya\ Pradesh",
"9174338", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"9162795", "Barauni\,\ Bihar",
"9171644", "Pandhurna\,\ Madhya\ Pradesh",
"911602", "Kharar\,\ Punjab",
"9165593", "Simaria\,\ Bihar",
"9174659", "Sapotra\,\ Rajasthan",
"918721", "Husnabad\,\ Andhra\ Pradesh",
"9167217", "Narsinghpur\,\ Odisha",
"9161503", "Hathua\,\ Bihar",
"9174337", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"912874", "Manavadar\,\ Gujarat",
"918491", "Kanaganapalle\,\ Andhra\ Pradesh",
"915944", "Kichha\/Rudrapur\,\ Uttar\ Pradesh",
"914298", "Metturdam\,\ Tamil\ Nadu",
"9162565", "Ramnagar\,\ Bihar",
"9174594", "Ramganj\ Mandi\,\ Rajasthan",
"917127", "Nagpur\,\ Maharashtra",
"9166477", "Naktideul\,\ Odisha",
"918647", "Narsaraopet\,\ Andhra\ Pradesh",
"918261", "Tarikere\,\ Karnataka",
"915255", "Kaisarganh\/Mahasi\,\ Uttar\ Pradesh",
"911251", "Jhajjar\,\ Haryana",
"91203", "Pune\,\ Maharashtra",
"9167587", "Nimapara\,\ Odisha",
"915567", "Captanganj\,\ Uttar\ Pradesh",
"911704", "Paonta\,\ Himachal\ Pradesh",
"9164225", "Godda\,\ Bihar",
"913013", "Jaisalmer\/Dhanaua\,\ Rajasthan",
"9161814", "Piro\,\ Bihar",
"9163275", "Rafiganj\,\ Bihar",
"9167486", "Bhubaneshwar\,\ Odisha",
"9167925", "Baripada\,\ Odisha",
"911886", "Tanda\ Urmar\,\ Punjab",
"912463", "Degloor\,\ Maharashtra",
"9174133", "Sailana\,\ Madhya\ Pradesh",
"914865", "Munnar\,\ Kerala",
"9162454", "Gogri\,\ Bihar",
"9166576", "Kantabhanji\,\ Odisha",
"9174356", "Gangdhar\,\ Rajasthan",
"913563", "Birpara\,\ West\ Bengal",
"9176495", "Kakaiya\,\ Madhya\ Pradesh",
"9176366", "Baihar\,\ Madhya\ Pradesh",
"915264", "Balarampur\/Tulsipur\,\ Uttar\ Pradesh",
"9171434", "Bhainsdehi\,\ Madhya\ Pradesh",
"9165884", "Jagarnathpur\,\ Bihar",
"9176248", "Sihora\,\ Madhya\ Pradesh",
"918705", "Warangal\,\ Andhra\ Pradesh",
"915963", "Bageshwar\,\ Uttar\ Pradesh",
"9162784", "Dalsinghsarai\,\ Bihar",
"9174215", "Manasa\,\ Madhya\ Pradesh",
"917725", "Saraipali\,\ Madhya\ Pradesh",
"9167335", "Ghatgaon\,\ Odisha",
"9171824", "Gondia\,\ Maharashtra",
"9173297", "Khakner\,\ Madhya\ Pradesh",
"9167522", "Puri\,\ Odisha",
"9161846", "Sasaram\,\ Bihar",
"9173298", "Khakner\,\ Madhya\ Pradesh",
"912358", "Dapoli\,\ Maharashtra",
"9171095", "Kamptee\,\ Maharashtra",
"9163463", "Lakhisarai\,\ Bihar",
"91494", "Tirur\,\ Kerala",
"912429", "Shevgaon\,\ Maharashtra",
"9174588", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"915691", "Chhibramau\,\ Uttar\ Pradesh",
"9171892", "Amagaon\,\ Maharashtra",
"9171467", "Ghorandogri\,\ Madhya\ Pradesh",
"9174587", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"9163362", "Rajauli\,\ Bihar",
"9164512", "Barsoi\,\ Bihar",
"9174925", "Shivpuri\,\ Madhya\ Pradesh",
"913805", "Hayuliang\,\ Arunachal\ Pradesh",
"912555", "Satana\,\ Maharashtra",
"9174850", "Udaipura\,\ Madhya\ Pradesh",
"9171566", "Talegaokarangal\,\ Maharashtra",
"913656", "Mawkyrwat\,\ Meghalaya",
"912641", "Amod\,\ Gujarat",
"9167356", "Telkoi\,\ Odisha",
"918589", "Siddavattam\,\ Andhra\ Pradesh",
"9165897", "Jhinkpani\,\ Bihar",
"918694", "Ramannapet\,\ Andhra\ Pradesh",
"9165363", "Palkot\,\ Bihar",
"91207", "Pune\,\ Maharashtra",
"914252", "Udumalpet\,\ Tamil\ Nadu",
"9165462", "Hazaribagh\,\ Bihar",
"918610", "Nellore\,\ Andhra\ Pradesh",
"918180", "Basavapatna\,\ Karnataka",
"9161807", "Adhaura\,\ Bihar",
"9174522", "Chhabra\,\ Rajasthan",
"9175903", "Lateri\,\ Madhya\ Pradesh",
"9174335", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"9177013", "Pingeshwar\,\ Madhya\ Pradesh",
"918399", "Huvinahadagali\,\ Karnataka",
"9167215", "Narsinghpur\,\ Odisha",
"9172889", "Bhikangaon\,\ Madhya\ Pradesh",
"9162797", "Barauni\,\ Bihar",
"9178088", "\`",
"911496", "Sarwar\,\ Rajasthan",
"912564", "Nandurbar\,\ Maharashtra",
"9171993", "Deori\,\ Maharashtra",
"915862", "Sitapur\,\ Uttar\ Pradesh",
"911995", "Kishtwar\,\ Jammu\ And\ Kashmir",
"918444", "Hunsagi\,\ Karnataka",
"9177039", "Manpur\,\ Madhya\ Pradesh",
"9176350", "Lanji\,\ Madhya\ Pradesh",
"9164295", "Kahalgaon\,\ Bihar",
"9165464", "Hazaribagh\,\ Bihar",
"9165853", "Ghatsila\,\ Bihar",
"911478", "Pratapgarh\,\ Rajasthan",
"918232", "Mandya\,\ Karnataka",
"9166415", "Deodgarh\,\ Odisha",
"911875", "Dinanagar\,\ Punjab",
"9162753", "Rosera\,\ Bihar",
"9174524", "Chhabra\,\ Rajasthan",
"9175969", "Gyraspur\,\ Madhya\ Pradesh",
"912773", "Malpur\,\ Gujarat",
"914147", "Tindivanam\,\ Tamil\ Nadu",
"915871", "Nighasan\/Palia\ Kalan\,\ Uttar\ Pradesh",
"9164546", "Purnea\,\ Bihar",
"9171894", "Amagaon\,\ Maharashtra",
"9173227", "Depalpur\,\ Madhya\ Pradesh",
"9171135", "Saoner\,\ Maharashtra",
"918373", "Ranebennur\,\ Karnataka",
"9174277", "Bhanpura\,\ Madhya\ Pradesh",
"916746", "Bhubaneshwar\,\ Odisha",
"9173228", "Depalpur\,\ Madhya\ Pradesh",
"9163364", "Rajauli\,\ Bihar",
"9171025", "Parseoni\,\ Maharashtra",
"9174278", "Bhanpura\,\ Madhya\ Pradesh",
"9171733", "Rajura\,\ Maharashtra",
"918910", "Visakhapatnam\,\ Andhra\ Pradesh",
"9168686", "Nandapur\,\ Odisha",
"9176425", "Mandla\,\ Madhya\ Pradesh",
"915823", "Aonla\,\ Uttar\ Pradesh",
"9167866", "Chandbali\,\ Odisha",
"916313", "Gaya\,\ Bihar",
"917660", "Sirmour\,\ Madhya\ Pradesh",
"9164514", "Barsoi\,\ Bihar",
"9165645", "Nagarutari\,\ Bihar",
"917836", "Baikunthpur\,\ Madhya\ Pradesh",
"9176533", "Bandhavgarh\,\ Madhya\ Pradesh",
"9174360", "Hindoli\,\ Rajasthan",
"911460", "Kishangarhbas\/Khairthal\,\ Rajasthan",
"9171676", "Amarwada\,\ Madhya\ Pradesh",
"913667", "Bilasipara\,\ Assam",
"9171432", "Bhainsdehi\,\ Madhya\ Pradesh",
"913241", "Gangajalghati\,\ West\ Bengal",
"918947", "Sompeta\,\ Andhra\ Pradesh",
"915742", "Etah\,\ Uttar\ Pradesh",
"918333", "Hukkeri\/Sankeshwar\,\ Karnataka",
"9171156", "Mouda\,\ Maharashtra",
"913774", "Golaghat\,\ Assam",
"9176480", "Mawai\,\ Madhya\ Pradesh",
"918450", "Andole\/Jogipet\,\ Andhra\ Pradesh",
"9171333", "Aheri\,\ Maharashtra",
"9165882", "Jagarnathpur\,\ Bihar",
"9171822", "Gondia\,\ Maharashtra",
"912327", "Gadhinglaj\,\ Maharashtra",
"9167524", "Puri\,\ Odisha",
"912792", "Amreli\,\ Gujarat",
"91792", "Ahmedabad\ Local\,\ Gujarat",
"912422", "Shri\ Rampur\,\ Maharashtra",
"9162782", "Dalsinghsarai\,\ Bihar",
"918834", "Rajahmundri\,\ Andhra\ Pradesh",
"918392", "Bellary\,\ Karnataka",
"9167277", "Kendrapara\,\ Odisha",
"918727", "Huzurabad\,\ Andhra\ Pradesh",
"915922", "Amroha\,\ Uttar\ Pradesh",
"9174592", "Ramganj\ Mandi\,\ Rajasthan",
"918497", "Kalyandurg\,\ Andhra\ Pradesh",
"918543", "Wanaparthy\,\ Andhra\ Pradesh",
"9165437", "Barhi\,\ Bihar",
"917820", "Khairagarh\,\ Madhya\ Pradesh",
"9174200", "Jawad\,\ Madhya\ Pradesh",
"913522", "Balurghat\,\ West\ Bengal",
"9162727", "Darbhanga\,\ Bihar",
"917446", "Ladpura\/Kota\,\ Rajasthan",
"918272", "Madikeri\,\ Karnataka",
"911438", "Newai\,\ Rajasthan",
"9161812", "Piro\,\ Bihar",
"9174866", "Bareli\,\ Madhya\ Pradesh",
"918582", "B\.Kothakota\,\ Andhra\ Pradesh",
"9165827", "Chaibasa\,\ Bihar",
"915831", "Dataganj\,\ Uttar\ Pradesh",
"912733", "Harij\,\ Gujarat",
"913787", "Seppa\,\ Arunachal\ Pradesh",
"9162452", "Gogri\,\ Bihar",
"9165536", "Ramgarh\,\ Bihar",
"916212", "Muzaffarpur\,\ Bihar",
"914259", "Pollachi\,\ Tamil\ Nadu",
"9165456", "Mandu\,\ Bihar",
"9162532", "Narkatiaganj\,\ Bihar",
"9176482", "Mawai\,\ Madhya\ Pradesh",
"9166516", "Birmaharajpur\,\ Odisha",
"9164297", "Kahalgaon\,\ Bihar",
"9176383", "Damoh\,\ Madhya\ Pradesh",
"9161874", "Mohania\,\ Bihar",
"911257", "Meham\,\ Haryana",
"9168573", "Gunupur\,\ Odisha",
"9171642", "Pandhurna\,\ Madhya\ Pradesh",
"911565", "Sri\ Dungargarh\,\ Rajasthan",
"918215", "Mysore\,\ Karnataka",
"915561", "Salempur\/Barhaj\,\ Uttar\ Pradesh",
"918267", "Kadur\,\ Karnataka",
"918641", "Sattenapalli\,\ Andhra\ Pradesh",
"9166417", "Deodgarh\,\ Odisha",
"9174202", "Jawad\,\ Madhya\ Pradesh",
"9171027", "Parseoni\,\ Maharashtra",
"9176526", "Shahdol\,\ Madhya\ Pradesh",
"917528", "Bijaypur\,\ Madhya\ Pradesh",
"915168", "Jalaun\,\ Uttar\ Pradesh",
"912694", "Kheda\,\ Gujarat",
"9166544", "Sonapur\,\ Odisha",
"912589", "Chalisgaon\,\ Maharashtra",
"9174590", "Ramganj\ Mandi\,\ Rajasthan",
"9174275", "Bhanpura\,\ Madhya\ Pradesh",
"9171137", "Saoner\,\ Maharashtra",
"917859", "Lohadigundah\,\ Madhya\ Pradesh",
"9173225", "Depalpur\,\ Madhya\ Pradesh",
"9171726", "Chandrapur\,\ Maharashtra",
"913672", "Nagaon\,\ Assam",
"9176428", "Mandla\,\ Madhya\ Pradesh",
"9165647", "Nagarutari\,\ Bihar",
"9168143", "Digapahandi\,\ Odisha",
"918564", "Proddatur\,\ Andhra\ Pradesh",
"911370", "Devprayag\/Jakholi\,\ Uttarakhand",
"911902", "Kullu\,\ Himachal\ Pradesh",
"916122", "Patna\,\ Bihar",
"9164664", "Kishanganj\,\ Bihar",
"9171552", "Seloo\,\ Maharashtra",
"915644", "Bharatpur\,\ Rajasthan",
"9176427", "Mandla\,\ Madhya\ Pradesh",
"9164284", "Nala\,\ Bihar",
"91260", "Vapi\,\ Gujarat",
"9171164", "Umrer\,\ Maharashtra",
"9176453", "Karanjia\,\ Madhya\ Pradesh",
"912758", "Halvad\,\ Gujarat",
"917325", "Burhanpur\,\ Madhya\ Pradesh",
"9176352", "Lanji\,\ Madhya\ Pradesh",
"9164572", "Korha\,\ Bihar",
"9165386", "Torpa\,\ Bihar",
"9176579", "Jaitpur\,\ Madhya\ Pradesh",
"918463", "Armoor\,\ Andhra\ Pradesh",
"9171326", "Gadchiroli\,\ Maharashtra",
"9171053", "Narkhed\,\ Maharashtra",
"9162725", "Darbhanga\,\ Bihar",
"9165606", "Patan\,\ Bihar",
"915170", "Chirgaon\/Moth\,\ Uttar\ Pradesh",
"9166404", "Bagdihi\,\ Odisha",
"911803", "Panipat\,\ Haryana",
"9165435", "Barhi\,\ Bihar",
"9167275", "Kendrapara\,\ Odisha",
"9177073", "Bagbahera\,\ Madhya\ Pradesh",
"9163486", "Mallehpur\,\ Bihar",
"9174362", "Hindoli\,\ Rajasthan",
"918358", "Basavanabagewadi\,\ Karnataka",
"9174854", "Udaipura\,\ Madhya\ Pradesh",
"911368", "Pauri\,\ Uttarakhand",
"9165825", "Chaibasa\,\ Bihar",
"9171583", "Deoli\,\ Maharashtra",
"911923", "Samba\,\ Jammu\ And\ Kashmir",
"9166527", "Balangir\,\ Odisha",
"9171684", "Harrai\,\ Madhya\ Pradesh",
"914374", "Papanasam\,\ Tamil\ Nadu",
"912878", "Mangrol\,\ Gujarat",
"914294", "Perundurai\,\ Tamil\ Nadu",
"9166836", "Padmapur\,\ Odisha",
"915948", "Khatima\/Sitarganj\,\ Uttar\ Pradesh",
"911662", "Hissar\,\ Haryana",
"9161353", "Bikram\,\ Bihar",
"9171044", "Hingua\,\ Maharashtra",
"9172887", "Bhikangaon\,\ Madhya\ Pradesh",
"9174942", "Kolaras\,\ Madhya\ Pradesh",
"912475", "Omerga\,\ Maharashtra",
"9176444", "Dindori\,\ Madhya\ Pradesh",
"917258", "Akot\,\ Maharashtra",
"9163233", "Dumraon\,\ Bihar",
"9168562", "Rayagada\,\ Odisha",
"9166426", "Kuchinda\,\ Odisha",
"9172888", "Bhikangaon\,\ Madhya\ Pradesh",
"9181736", "Sakleshpur\,\ Karnataka",
"917518", "Gwalior\,\ Madhya\ Pradesh",
"9178089", "\`",
"917761", "Tapkara\,\ Madhya\ Pradesh",
"912998", "Jaisalmer\/Khuiyals\,\ Rajasthan",
"9165624", "Daltonganj\,\ Bihar",
"9174655", "Sapotra\,\ Rajasthan",
"911527", "Lunkaransar\/Rajasarb\,\ Rajasthan",
"91431", "Tiruchchirappalli\,\ Tamil\ Nadu",
"9176517", "Jaisinghnagar\,\ Madhya\ Pradesh",
"9174589", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"911743", "Cheeka\,\ Haryana",
"912845", "Savarkundla\,\ Gujarat",
"912676", "Halol\,\ Gujarat",
"9174843", "Silwani\,\ Madhya\ Pradesh",
"918225", "Cowdahalli\,\ Karnataka",
"915498", "Ballia\,\ Uttar\ Pradesh",
"91326", "Dhanbad\,\ Bihar",
"9174545", "Chhipaborad\,\ Rajasthan",
"9167636", "Athmallik\,\ Odisha",
"9165232", "Ghaghra\,\ Bihar",
"9171717", "Gond\ Pipri\,\ Maharashtra",
"918419", "Yellapur\,\ Karnataka",
"911782", "Rampur\ Bushahar\,\ Himachal\ Pradesh",
"9176416", "Niwas\,\ Madhya\ Pradesh",
"9167405", "Bhubaneshwar\,\ Odisha",
"914544", "Natham\,\ Tamil\ Nadu",
"911931", "Kulgam\,\ Jammu\ And\ Kashmir",
"9171697", "Batkakhapa\,\ Madhya\ Pradesh",
"9176249", "Sihora\,\ Madhya\ Pradesh",
"9171704", "Chumur\,\ Maharashtra",
"9164242", "Banka\,\ Bihar",
"911481", "Raipur\,\ Rajasthan",
"918193", "Hiriyur\,\ Karnataka",
"911822", "Kapurthala\,\ Punjab",
"9163412", "Seikhpura\,\ Bihar",
"914892", "Minicoy\,\ Lakshadweep",
"9162223", "Sheohar\,\ Bihar",
"9171317", "Sironcha\,\ Maharashtra",
"9167942", "Rairangpur\,\ Odisha",
"9167655", "Palla\ Hara\,\ Odisha",
"9176285", "Karpa\,\ Madhya\ Pradesh",
"9173933", "Jobat\,\ Madhya\ Pradesh",
"9176504", "Beohari\,\ Madhya\ Pradesh",
"9163313", "Imamganj\,\ Bihar",
"9189462", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"9173299", "Khakner\,\ Madhya\ Pradesh",
"917779", "Ramchandrapur\,\ Madhya\ Pradesh",
"9166855", "Sohela\,\ Odisha",
"9161155", "Danapur\,\ Bihar",
"9175388", "Ambah\,\ Madhya\ Pradesh",
"912985", "Barmer\/Ramsar\,\ Rajasthan",
"9168154", "Parlakhemundi\,\ Odisha",
"9177062", "Gariaband\,\ Madhya\ Pradesh",
"912838", "Mundra\,\ Gujarat",
"9175387", "Ambah\,\ Madhya\ Pradesh",
"9167296", "Pattamundai\,\ Odisha",
"9165692", "Garu\,\ Bihar",
"9168674", "Jharigan\,\ Odisha",
"9167843", "Bhadrak\,\ Odisha",
"9181755", "Holenarasipur\,\ Karnataka",
"9165312", "Mandar\,\ Bihar",
"912435", "Kannad\,\ Maharashtra",
"914639", "Tiruchendur\,\ Tamil\ Nadu",
"9144", "Chennai\,\ Tamil\ Nadu",
"9161327", "Barh\,\ Bihar",
"9175932", "Kurwai\,\ Madhya\ Pradesh",
"9174636", "Gangapur\,\ Rajasthan",
"918132", "Kunigal\,\ Karnataka",
"9174373", "Nainwa\,\ Rajasthan",
"9166553", "Titlagarh\,\ Odisha",
"9165413", "Chatra\,\ Bihar",
"917367", "Badnagar\,\ Madhya\ Pradesh",
"9164276", "Kathikund\,\ Bihar",
"917292", "Dhar\,\ Madhya\ Pradesh",
"9168493", "Daringbadi\,\ Odisha",
"9167976", "Jashipur\,\ Odisha",
"9181723", "Hassan\,\ Karnataka",
"9163226", "Wazirganj\,\ Bihar",
"9166433", "Barkot\,\ Odisha",
"912568", "Sakri\,\ Maharashtra",
"917477", "Bundi\,\ Rajasthan",
"912952", "Rajsamand\/Kankorli\,\ Rajasthan",
"9173244", "Mhow\,\ Madhya\ Pradesh",
"917372", "Rajgarh\,\ Madhya\ Pradesh",
"9166525", "Balangir\,\ Odisha",
"912711", "Barwala\,\ Gujarat",
"9174657", "Sapotra\,\ Rajasthan",
"9168612", "Malkangiri\,\ Odisha",
"9189460", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"9174339", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"9166823", "Attabira\,\ Odisha",
"9161123", "Biharsharif\,\ Bihar",
"917756", "Lormi\,\ Madhya\ Pradesh",
"914563", "Rajapalayam\,\ Tamil\ Nadu",
"9174658", "Sapotra\,\ Rajasthan",
"915270", "Bikapur\,\ Uttar\ Pradesh",
"9176294", "Pushprajgarh\,\ Madhya\ Pradesh",
"911637", "Malaut\,\ Punjab",
"9172885", "Bhikangaon\,\ Madhya\ Pradesh",
"91224", "Mumbai",
"917233", "Pusad\,\ Maharashtra",
"9173216", "Sanwer\,\ Madhya\ Pradesh",
"9177060", "Gariaband\,\ Madhya\ Pradesh",
"913865", "Phek\,\ Nagaland",
"912139", "Pirangut\,\ Maharashtra",
"9163474", "Chakai\,\ Bihar",
"9167623", "Dhenkanal\,\ Odisha",
"9176515", "Jaisinghnagar\,\ Madhya\ Pradesh",
"9176813", "Jatara\,\ Madhya\ Pradesh",
"918740", "Aswaraopet\,\ Andhra\ Pradesh",
"912161", "Vaduj\,\ Maharashtra",
"9174548", "Chhipaborad\,\ Rajasthan",
"9174929", "Shivpuri\,\ Madhya\ Pradesh",
"9164793", "Udakishanganj\,\ Bihar",
"9167407", "Bhubaneshwar\,\ Odisha",
"9171715", "Gond\ Pipri\,\ Maharashtra",
"9175930", "Kurwai\,\ Madhya\ Pradesh",
"917847", "Antagarh\,\ Madhya\ Pradesh",
"9184534", "Medak\,\ Andhra\ Pradesh",
"9174547", "Chhipaborad\,\ Rajasthan",
"915452", "Jaunpur\,\ Uttar\ Pradesh",
"918936", "Araku\,\ Andhra\ Pradesh",
"9176499", "Kakaiya\,\ Madhya\ Pradesh",
"9174976", "Khaniadhana\,\ Madhya\ Pradesh",
"9162744", "Samastipur\,\ Bihar",
"9171695", "Batkakhapa\,\ Madhya\ Pradesh",
"917273", "Kannod\,\ Madhya\ Pradesh",
"9173926", "Jhabua\,\ Madhya\ Pradesh",
"912354", "Sanganeshwar\/Deorukh\,\ Maharashtra",
"9164613", "Raniganj\,\ Bihar",
"9161886", "Rohtas\,\ Bihar",
"911684", "Narwana\,\ Haryana",
"9166212", "Hemgiri\,\ Odisha",
"9162236", "Motipur\,\ Bihar",
"917542", "Guna\,\ Madhya\ Pradesh",
"9167414", "Bhubaneshwar\,\ Odisha",
"913512", "Malda\,\ West\ Bengal",
"91372", "Lungleh\,\ Mizoram",
"917810", "Uproda\,\ Madhya\ Pradesh",
"9174219", "Manasa\,\ Madhya\ Pradesh",
"9167657", "Palla\ Hara\,\ Odisha",
"9176287", "Karpa\,\ Madhya\ Pradesh",
"911389", "Joshimath\,\ Uttarakhand",
"9171315", "Sironcha\,\ Maharashtra",
"917583", "Banda\,\ Madhya\ Pradesh",
"913252", "Purulia\,\ West\ Bengal",
"9176288", "Karpa\,\ Madhya\ Pradesh",
"9165844", "Bishrampur\,\ Bihar",
"918717", "Eturnagaram\,\ Andhra\ Pradesh",
"9174940", "Kolaras\,\ Madhya\ Pradesh",
"917221", "Nandgaon\,\ Maharashtra",
"912365", "Malwan\,\ Maharashtra",
"9175385", "Ambah\,\ Madhya\ Pradesh",
"9166732", "Jayapatna\,\ Odisha",
"9162716", "Benipatti\,\ Bihar",
"9174506", "Sangod\,\ Rajasthan",
"916806", "Berhampur\,\ Odisha",
"9174623", "Sawaimadhopur\,\ Rajasthan",
"9168166", "Mohana\,\ Odisha",
"918685", "Bhongir\,\ Andhra\ Pradesh",
"9161157", "Danapur\,\ Bihar",
"9166857", "Sohela\,\ Odisha",
"9165816", "Bhandaria\,\ Bihar",
"911764", "Samana\,\ Punjab",
"912526", "Wada\,\ Maharashtra",
"9181758", "Holenarasipur\,\ Karnataka",
"9161325", "Barh\,\ Bihar",
"9181757", "Holenarasipur\,\ Karnataka",
"9161532", "Maharajganj\,\ Bihar",
"9167404", "Bhubaneshwar\,\ Odisha",
"9164526", "Katihar\,\ Bihar",
"917586", "Deori\,\ Madhya\ Pradesh",
"913841", "Vdarbondh\,\ Assam",
"9174544", "Chhipaborad\,\ Rajasthan",
"9184537", "Medak\,\ Andhra\ Pradesh",
"9164752", "S\.Bakhtiarpur\,\ Bihar",
"918483", "Humnabad\,\ Karnataka",
"912927", "Osian\/Dhanwara\,\ Rajasthan",
"915195", "Mau\/Rajapur\,\ Uttar\ Pradesh",
"913793", "Mechuka\,\ Arunachal\ Pradesh",
"918234", "Nagamangala\,\ Karnataka",
"9171473", "Multai\,\ Madhya\ Pradesh",
"9162266", "Sitamarhi\,\ Bihar",
"912145", "Mahad\,\ Maharashtra",
"9174209", "Jawad\,\ Madhya\ Pradesh",
"918933", "Bheemunipatnam\,\ Andhra\ Pradesh",
"9163477", "Chakai\,\ Bihar",
"917811", "Pasan\,\ Madhya\ Pradesh",
"9171372", "Desaiganj\,\ Maharashtra",
"918442", "Jewargi\,\ Karnataka",
"9176298", "Pushprajgarh\,\ Madhya\ Pradesh",
"9174516", "Atru\,\ Rajasthan",
"9165625", "Daltonganj\,\ Bihar",
"9174654", "Sapotra\,\ Rajasthan",
"9161562", "Gopalganj\,\ Bihar",
"914173", "Arni\,\ Tamil\ Nadu",
"912747", "Thara\,\ Gujarat",
"9164383", "Madhupur\,\ Bihar",
"9176297", "Pushprajgarh\,\ Madhya\ Pradesh",
"9176445", "Dindori\,\ Madhya\ Pradesh",
"917220", "Chhikaldara\,\ Maharashtra",
"9166762", "M\.Rampur\,\ Odisha",
"918200", "Udupi\,\ Karnataka",
"9161896", "Bhabhua\,\ Bihar",
"916803", "Berhampur\,\ Odisha",
"913471", "Karimpur\,\ West\ Bengal",
"9173248", "Mhow\,\ Madhya\ Pradesh",
"9171045", "Hingua\,\ Maharashtra",
"918537", "Lingsugur\,\ Karnataka",
"9171685", "Harrai\,\ Madhya\ Pradesh",
"9173247", "Mhow\,\ Madhya\ Pradesh",
"9168452", "Phiringia\,\ Odisha",
"9176489", "Mawai\,\ Madhya\ Pradesh",
"912424", "Akole\,\ Maharashtra",
"9181754", "Holenarasipur\,\ Karnataka",
"916517", "Ranchi\,\ Bihar",
"912341", "Kavathemankal\,\ Maharashtra",
"918832", "Rajahmundri\,\ Andhra\ Pradesh",
"9164783", "Saharsa\,\ Bihar",
"9174369", "Hindoli\,\ Rajasthan",
"911585", "Nagaur\/Khinwsar\,\ Rajasthan",
"917753", "Kota\,\ Madhya\ Pradesh",
"9171842", "Bhandara\,\ Maharashtra",
"912794", "Rajula\,\ Gujarat",
"914566", "Aruppukottai\,\ Tamil\ Nadu",
"911275", "Palwal\,\ Haryana",
"915271", "Akbarpur\,\ Uttar\ Pradesh",
"913772", "Sibsagar\,\ Assam",
"9168675", "Jharigan\,\ Odisha",
"912138", "Shirur\,\ Maharashtra",
"913227", "Amlagora\,\ West\ Bengal",
"918577", "Putturu\,\ Andhra\ Pradesh",
"9161154", "Danapur\,\ Bihar",
"915744", "Kasganj\,\ Uttar\ Pradesh",
"9166854", "Sohela\,\ Odisha",
"9166463", "Bargarh\,\ Odisha",
"9168155", "Parlakhemundi\,\ Odisha",
"9168602", "Boriguma\,\ Odisha",
"9167654", "Palla\ Hara\,\ Odisha",
"9176284", "Karpa\,\ Madhya\ Pradesh",
"916214", "Muzaffarpur\,\ Bihar",
"9175960", "Gyraspur\,\ Madhya\ Pradesh",
"9176505", "Beohari\,\ Madhya\ Pradesh",
"9173206", "Pandhana\,\ Madhya\ Pradesh",
"9165847", "Bishrampur\,\ Bihar",
"918584", "Piler\,\ Andhra\ Pradesh",
"9164352", "Pakur\,\ Bihar",
"9176572", "Jaitpur\,\ Madhya\ Pradesh",
"9176359", "Lanji\,\ Madhya\ Pradesh",
"9177030", "Manpur\,\ Madhya\ Pradesh",
"918310", "Belgaum\,\ Karnataka",
"918274", "Virajpet\,\ Karnataka",
"9162747", "Samastipur\,\ Bihar",
"913524", "Harirampur\,\ West\ Bengal",
"9171705", "Chumur\,\ Maharashtra",
"912569", "Navapur\,\ Maharashtra",
"912160", "Sakarwadi\,\ Maharashtra",
"918741", "Sudhimalla\/Tekulapalli\,\ Andhra\ Pradesh",
"9167417", "Bhubaneshwar\,\ Odisha",
"918394", "Hospet\,\ Karnataka",
"9171772", "Brahmapuri\,\ Maharashtra",
"917236", "Maregaon\,\ Maharashtra",
"915924", "Hasanpur\,\ Uttar\ Pradesh",
"9168483", "Kotagarh\,\ Odisha",
"9171714", "Gond\ Pipri\,\ Maharashtra",
"9184535", "Medak\,\ Andhra\ Pradesh",
"918627", "Atmakur\,\ Andhra\ Pradesh",
"918196", "Jagalur\,\ Karnataka",
"91361", "Guwahati\,\ Assam",
"9171622", "Chhindwara\,\ Madhya\ Pradesh",
"914638", "Vilathikulam\,\ Tamil\ Nadu",
"9165682", "Balumath\,\ Bihar",
"912633", "Dharampur\,\ Gujarat",
"9176514", "Jaisinghnagar\,\ Madhya\ Pradesh",
"912839", "Lakhpat\,\ Gujarat",
"9163475", "Chakai\,\ Bihar",
"9167286", "Jajapur\ Town\,\ Odisha",
"9164533", "Araria\,\ Bihar",
"917778", "Semaria\,\ Madhya\ Pradesh",
"911480", "Asind\,\ Rajasthan",
"9175398", "Ambah\,\ Madhya\ Pradesh",
"9171876", "Goregaon\,\ Maharashtra",
"915642", "Dholpur\,\ Rajasthan",
"9176447", "Dindori\,\ Madhya\ Pradesh",
"9176295", "Pushprajgarh\,\ Madhya\ Pradesh",
"9176570", "Jaitpur\,\ Madhya\ Pradesh",
"916124", "Patna\,\ Bihar",
"9172884", "Bhikangaon\,\ Madhya\ Pradesh",
"911552", "Hanumangarh\,\ Rajasthan",
"918562", "Kadapa\,\ Andhra\ Pradesh",
"911904", "Nirmand\,\ Himachal\ Pradesh",
"9176448", "Dindori\,\ Madhya\ Pradesh",
"9165627", "Daltonganj\,\ Bihar",
"9175962", "Gyraspur\,\ Madhya\ Pradesh",
"9174666", "Bonli\,\ Rajasthan",
"913715", "Gohpur\,\ Assam",
"913674", "Hojai\,\ Assam",
"9171746", "Mul\,\ Maharashtra",
"915683", "Auraiya\,\ Uttar\ Pradesh",
"915113", "Bhognipur\/Pakhrayan\,\ Uttar\ Pradesh",
"9165403", "Govindpur\,\ Bihar",
"917745", "Chhuriakala\,\ Madhya\ Pradesh",
"9173245", "Mhow\,\ Madhya\ Pradesh",
"91183", "Amritsar\,\ Punjab",
"9166524", "Balangir\,\ Odisha",
"9171687", "Harrai\,\ Madhya\ Pradesh",
"912692", "Anand\,\ Gujarat",
"9171047", "Hingua\,\ Maharashtra",
"9177032", "Manpur\,\ Madhya\ Pradesh",
"9165302", "Bundu\,\ Bihar",
"9163263", "Sherghati\,\ Bihar",
"9168532", "Sunabeda\,\ Odisha",
"9161324", "Barh\,\ Bihar",
"9181766", "Cannarayapatna\,\ Karnataka",
"914551", "Vedasandur\,\ Tamil\ Nadu",
"918418", "Medchal\,\ Andhra\ Pradesh",
"9171346", "Bhamregadh\,\ Maharashtra",
"9168157", "Parlakhemundi\,\ Odisha",
"9165653", "Latehar\,\ Bihar",
"912621", "Sayan\,\ Gujarat",
"9162573", "Barachakia\,\ Bihar",
"9168677", "Jharigan\,\ Odisha",
"9175384", "Ambah\,\ Madhya\ Pradesh",
"9174599", "Ramganj\ Mandi\,\ Rajasthan",
"912999", "Jaisalmer\/Nehdai\,\ Rajasthan",
"91144", "Alwar\,\ Rajasthan",
"9171314", "Sironcha\,\ Maharashtra",
"9176508", "Beohari\,\ Madhya\ Pradesh",
"917519", "Gwalior\,\ Madhya\ Pradesh",
"91474", "Kollam\,\ Kerala",
"9165845", "Bishrampur\,\ Bihar",
"911970", "Dehra\ Gopipur\,\ Himachal\ Pradesh",
"9167666", "Keonjhar\,\ Odisha",
"917680", "Niwari\,\ Madhya\ Pradesh",
"9176507", "Beohari\,\ Madhya\ Pradesh",
"9165262", "Lohardaga\,\ Bihar",
"9171006", "Kuhi\,\ Maharashtra",
"912673", "Dahod\,\ Gujarat",
"9167415", "Bhubaneshwar\,\ Odisha",
"9176406", "Shahpur\,\ Madhya\ Pradesh",
"915949", "Kichha\/Bazpur\,\ Uttar\ Pradesh",
"9171707", "Chumur\,\ Maharashtra",
"9162745", "Samastipur\,\ Bihar",
"911746", "Kaithal\,\ Haryana",
"9165543", "Rajdhanwar\,\ Bihar",
"9171694", "Batkakhapa\,\ Madhya\ Pradesh",
"9165644", "Nagarutari\,\ Bihar",
"917563", "Nasrullaganj\,\ Madhya\ Pradesh",
"9166446", "Rairakhol\,\ Odisha",
"918785", "Karimnagar\,\ Andhra\ Pradesh",
"9176424", "Mandla\,\ Madhya\ Pradesh",
"918359", "Indi\,\ Karnataka",
"9164667", "Kishanganj\,\ Bihar",
"918466", "Banswada\,\ Andhra\ Pradesh",
"9174922", "Shivpuri\,\ Madhya\ Pradesh",
"9164515", "Barsoi\,\ Bihar",
"9163496", "Jhajha\,\ Bihar",
"911664", "Bhiwani\,\ Haryana",
"9171024", "Parseoni\,\ Maharashtra",
"9163365", "Rajauli\,\ Bihar",
"914292", "Valapady\,\ Tamil\ Nadu",
"9168223", "Aska\,\ Odisha",
"9171895", "Amagaon\,\ Maharashtra",
"911331", "Nakur\/Gangoh\,\ Uttar\ Pradesh",
"914372", "Orathanad\,\ Tamil\ Nadu",
"91175", "Patiala\,\ Punjab",
"915335", "Soraon\,\ Uttar\ Pradesh",
"9171134", "Saoner\,\ Maharashtra",
"918654", "Jaggayyapet\,\ Andhra\ Pradesh",
"9166547", "Sonapur\,\ Odisha",
"9176276", "Manpur\,\ Madhya\ Pradesh",
"91480", "Irinjalakuda\,\ Kerala",
"915171", "Garauth\,\ Uttar\ Pradesh",
"9173290", "Khakner\,\ Madhya\ Pradesh",
"9174332", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"9166414", "Deodgarh\,\ Odisha",
"917915", "Ahmedabad\ Local\,\ Gujarat",
"9167212", "Narsinghpur\,\ Odisha",
"9174525", "Chhabra\,\ Rajasthan",
"9165616", "Garhwa\,\ Bihar",
"9171966", "Arjuni\ Morgaon\,\ Maharashtra",
"912595", "Dhadgaon\,\ Maharashtra",
"918665", "Vijayawada\,\ Andhra\ Pradesh",
"9165465", "Hazaribagh\,\ Bihar",
"9165396", "Bolwa\,\ Bihar",
"9174823", "Raisen\,\ Madhya\ Pradesh",
"9161877", "Mohania\,\ Bihar",
"915545", "Bansi\,\ Uttar\ Pradesh",
"918617", "Nellore\,\ Andhra\ Pradesh",
"918187", "Shikaripura\,\ Karnataka",
"912385", "Udgir\,\ Maharashtra",
"912759", "Lakhtar\,\ Gujarat",
"911655", "Raman\,\ Punjab",
"9164294", "Kahalgaon\,\ Bihar",
"9181521", "Kolar\,\ Karnatak",
"9176240", "Sihora\,\ Madhya\ Pradesh",
"911806", "Panipat\,\ Haryana",
"9174858", "Udaipura\,\ Madhya\ Pradesh",
"916637", "Sambalpur\,\ Odisha",
"9163272", "Rafiganj\,\ Bihar",
"9167922", "Baripada\,\ Odisha",
"9164222", "Godda\,\ Bihar",
"9174857", "Udaipura\,\ Madhya\ Pradesh",
"914894", "Agathy\,\ Lakshadweep",
"9162243", "Hajipur\,\ Bihar",
"911824", "Phagwara\,\ Punjab",
"918640", "Krosuru\,\ Andhra\ Pradesh",
"9166407", "Bagdihi\,\ Odisha",
"917858", "Kuakunda\,\ Madhya\ Pradesh",
"9174580", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"912588", "Erandul\,\ Maharashtra",
"914542", "Kodaikanal\,\ Tamil\ Nadu",
"9162562", "Ramnagar\,\ Bihar",
"9171092", "Kamptee\,\ Maharashtra",
"9165273", "Kolebira\,\ Bihar",
"918134", "Tiptur\,\ Karnataka",
"912181", "Akkalkot\,\ Maharashtra",
"9167525", "Puri\,\ Odisha",
"9174212", "Manasa\,\ Madhya\ Pradesh",
"9178080", "\`",
"9167332", "Ghatgaon\,\ Odisha",
"917805", "Singrauli\,\ Madhya\ Pradesh",
"9167823", "Balasore\,\ Odisha",
"9171167", "Umrer\,\ Maharashtra",
"9164287", "Nala\,\ Bihar",
"9176492", "Kakaiya\,\ Madhya\ Pradesh",
"914332", "Manaparai\,\ Tamil\ Nadu",
"911371", "Dunda\,\ Uttarakhand",
"91491", "Palakkad\,\ Kerala",
"918451", "Zahirabad\,\ Andhra\ Pradesh",
"914258", "Dharampuram\,\ Tamil\ Nadu",
"9164517", "Barsoi\,\ Bihar",
"9164665", "Kishanganj\,\ Bihar",
"91353", "Siliguri\,\ West\ Bengal",
"9161143", "Jahanabad\,\ Bihar",
"9166843", "Paikamal\,\ Odisha",
"9182206", "Gundlupet\,\ Karnataka",
"915465", "Phulpur\/Atrawlia\,\ Uttar\ Pradesh",
"911461", "Bansur\,\ Rajasthan",
"9166545", "Sonapur\,\ Odisha",
"917374", "Biaora\,\ Madhya\ Pradesh",
"91548", "Ghazipur\,\ Uttar\ Pradesh",
"9174274", "Bhanpura\,\ Madhya\ Pradesh",
"9171363", "Etapalli\,\ Maharashtra",
"912954", "Kumbalgarh\/Charbhujaji\,\ Rajasthan",
"9171897", "Amagaon\,\ Maharashtra",
"9173224", "Depalpur\,\ Madhya\ Pradesh",
"9174582", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"9181743", "Arsikere\,\ Karnataka",
"9171462", "Ghorandogri\,\ Madhya\ Pradesh",
"9163246", "Nawada\,\ Bihar",
"9163367", "Rajauli\,\ Bihar",
"918336", "Khanapur\,\ Karnataka",
"9167553", "Khurda\,\ Odisha",
"917294", "Dharampuri\,\ Madhya\ Pradesh",
"9174210", "Manasa\,\ Madhya\ Pradesh",
"915454", "Machlishahar\,\ Uttar\ Pradesh",
"9174527", "Chhabra\,\ Rajasthan",
"9165566", "Tisri\,\ Bihar",
"917821", "Dhamda\,\ Madhya\ Pradesh",
"9162792", "Barauni\,\ Bihar",
"9174528", "Chhabra\,\ Rajasthan",
"9174949", "Kolaras\,\ Madhya\ Pradesh",
"9161573", "Mairwa\,\ Bihar",
"914111", "Sriperumbudur\,\ Tamil\ Nadu",
"9167643", "Anugul\,\ Odisha",
"9165892", "Jhinkpani\,\ Bihar",
"9176490", "Kakaiya\,\ Madhya\ Pradesh",
"91731", "Indore\,\ Madhya\ Pradesh",
"9161875", "Mohania\,\ Bihar",
"917443", "Ladpura\/Kota\,\ Rajasthan",
"9166773", "Narlaroad\,\ Odisha",
"912965", "Kushalgarh\,\ Rajasthan",
"9161802", "Adhaura\,\ Bihar",
"918546", "Gadwal\,\ Andhra\ Pradesh",
"9165467", "Hazaribagh\,\ Bihar",
"9174855", "Udaipura\,\ Madhya\ Pradesh",
"9174920", "Shivpuri\,\ Madhya\ Pradesh",
"917781", "Narainpur\,\ Madhya\ Pradesh",
"913254", "Jhalda\,\ West\ Bengal",
"9165824", "Chaibasa\,\ Bihar",
"9175293", "Laher\,\ Madhya\ Pradesh",
"9175939", "Kurwai\,\ Madhya\ Pradesh",
"918320", "Goa",
"9168696", "Papadhandi\,\ Odisha",
"911682", "Zira\,\ Punjab",
"9165434", "Barhi\,\ Bihar",
"917544", "Raghogarh\,\ Madhya\ Pradesh",
"912457", "Jintdor\,\ Maharashtra",
"9167274", "Kendrapara\,\ Odisha",
"9166472", "Naktideul\,\ Odisha",
"912352", "Ratnagiri\,\ Maharashtra",
"9174553", "Digod\/Sultanpur\,\ Rajasthan",
"9162724", "Darbhanga\,\ Bihar",
"915870", "Bhira\,\ Uttar\ Pradesh",
"9173946", "Alirajpur\,\ Madhya\ Pradesh",
"9177069", "Gariaband\,\ Madhya\ Pradesh",
"9166405", "Bagdihi\,\ Odisha",
"9167582", "Nimapara\,\ Odisha",
"917833", "Udaipur\,\ Madhya\ Pradesh",
"9176563", "Kannodi\,\ Madhya\ Pradesh",
"9172876", "Gogaon\,\ Madhya\ Pradesh",
"913217", "Basirhat\,\ West\ Bengal",
"9167527", "Puri\,\ Odisha",
"918752", "Bhainsa\,\ Andhra\ Pradesh",
"9174330", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"9173292", "Khakner\,\ Madhya\ Pradesh",
"911762", "Rajpura\,\ Punjab",
"914367", "Mannargudi\,\ Tamil\ Nadu",
"916316", "Gaya\,\ Bihar",
"915440", "Mirzapur\/Hallia\,\ Uttar\ Pradesh",
"916743", "Bhubaneshwar\,\ Odisha",
"911479", "Pratapgarh\/Arnod\,\ Rajasthan",
"9171763", "Warora\,\ Maharashtra",
"9174643", "Karauli\,\ Rajasthan",
"9164285", "Nala\,\ Bihar",
"9171165", "Umrer\,\ Maharashtra",
"917661", "Teonthar\,\ Madhya\ Pradesh",
"918376", "Hirekerur\,\ Karnataka",
"9167672", "Barbil\,\ Odisha",
"91721", "Amravati\,\ Maharashtra",
"9165276", "Kolebira\,\ Bihar",
"913018", "Jaisalmer\/Sadhna\,\ Rajasthan",
"9164374", "Mahagama\,\ Bihar",
"9167605", "Talcher\,\ Odisha",
"91288", "Jamnagar\,\ Gujarat",
"9171065", "Bhiwapur\,\ Maharashtra",
"9163324", "Nabinagar\,\ Bihar",
"912468", "Hadgaon\,\ Maharashtra",
"917577", "Harda\,\ Madhya\ Pradesh",
"91755", "Bhopal\,\ Madhya\ Pradesh",
"916742", "Bhubaneshwar\,\ Odisha",
"9167826", "Balasore\,\ Odisha",
"911763", "Sarhind\,\ Punjab",
"9176465", "Nainpur\,\ Madhya\ Pradesh",
"9174320", "Jhalawar\,\ Rajasthan",
"918753", "Outsarangapalle\,\ Andhra\ Pradesh",
"9167537", "Nayagarh\,\ Odisha",
"917832", "Rajpur\,\ Madhya\ Pradesh",
"9161542", "Siwan\,\ Bihar",
"9171754", "Bhadrawati\,\ Maharashtra",
"9174879", "Begamganj\,\ Madhya\ Pradesh",
"912430", "Sillod\,\ Maharashtra",
"9181705", "Alur\,\ Karnataka",
"917274", "Khategaon\,\ Madhya\ Pradesh",
"9162734", "Jhajharpur\,\ Bihar",
"912353", "Rajapur\,\ Maharashtra",
"918236", "Pandavpura\,\ Karnataka",
"911683", "Julana\,\ Haryana",
"9165424", "Bokaro\,\ Bihar",
"9162246", "Hajipur\,\ Bihar",
"917741", "Kawardha\,\ Madhya\ Pradesh",
"9171484", "Prabha\ Pattan\,\ Madhya\ Pradesh",
"9175929", "Vidisha\,\ Madhya\ Pradesh",
"9174701", "Bundi\,\ Rajasthan",
"9174564", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"9162595", "Pakridayal\,\ Bihar",
"913711", "Udalguri\,\ Assam",
"9182895", "Athani\,\ Karnataka",
"915212", "Malihabad\,\ Uttar\ Pradesh",
"9168104", "Khalikote\,\ Odisha",
"912980", "Pachpadra\/Korna\,\ Rajasthan",
"9165834", "Kharsawa\,\ Bihar",
"9174930", "Karera\,\ Madhya\ Pradesh",
"917584", "Rahatgarh\,\ Madhya\ Pradesh",
"9176273", "Manpur\,\ Madhya\ Pradesh",
"912907", "Kherwara\,\ Rajasthan",
"917234", "Digras\,\ Maharashtra",
"9174672", "Bamanwas\,\ Rajasthan",
"918396", "Siruguppa\,\ Karnataka",
"917442", "Ladpura\/Kota\,\ Rajasthan",
"911499", "Sangaria\,\ Rajasthan",
"918276", "Somwarpet\,\ Karnataka",
"9162767", "Madhubani\,\ Bihar",
"913526", "Islampur\,\ West\ Bengal",
"91294", "Udaipur\ Girwa\/Udaipur\,\ Rajasthan",
"912625", "Valod\,\ Gujarat",
"9174605", "Sahabad\,\ Rajasthan",
"918811", "Polavaram\,\ Andhra\ Pradesh",
"9165613", "Garhwa\,\ Bihar",
"9168117", "Chhatrapur\,\ Odisha",
"9171963", "Arjuni\ Morgaon\,\ Maharashtra",
"9175219", "Seondha\,\ Madhya\ Pradesh",
"9165393", "Bolwa\,\ Bihar",
"9165867", "Chainpur\,\ Bihar",
"918586", "Vayalpad\,\ Andhra\ Pradesh",
"9174826", "Raisen\,\ Madhya\ Pradesh",
"9174538", "Baran\,\ Rajasthan",
"916216", "Muzaffarpur\,\ Bihar",
"9175940", "Ganjbasoda\,\ Madhya\ Pradesh",
"9174537", "Baran\,\ Rajasthan",
"9168474", "G\.Udayagiri\,\ Odisha",
"9165492", "Bermo\,\ Bihar",
"913659", "Resubelpara\/Mendipathar\,\ Meghalaya",
"9174385", "Keshoraipatan\/Patan\,\ Rajasthan",
"9166443", "Rairakhol\,\ Odisha",
"9164774", "Triveniganj\,\ Bihar",
"9173234", "Punasa\,\ Madhya\ Pradesh",
"917537", "Jora\,\ Madhya\ Pradesh",
"9174349", "Pirawa\/Raipur\,\ Rajasthan",
"912426", "Rahuri\,\ Maharashtra",
"9163493", "Jhajha\,\ Bihar",
"912796", "Kunkawav\,\ Gujarat",
"914564", "Paramakudi\,\ Tamil\ Nadu",
"9167564", "Balugaon\,\ Odisha",
"9168226", "Aska\,\ Odisha",
"9171862", "Sakoli\,\ Maharashtra",
"9171497", "Tamia\,\ Madhya\ Pradesh",
"915313", "Salon\/Jais\,\ Uttar\ Pradesh",
"9171354", "Chamorshi\,\ Maharashtra",
"9176566", "Kannodi\,\ Madhya\ Pradesh",
"9171067", "Bhiwapur\,\ Maharashtra",
"9167607", "Talcher\,\ Odisha",
"912141", "Alibagh\,\ Maharashtra",
"9172873", "Gogaon\,\ Madhya\ Pradesh",
"917815", "Kathghora\,\ Madhya\ Pradesh",
"914333", "Ponnamaravathi\,\ Tamil\ Nadu",
"91490", "Tellicherry\,\ Kerala",
"9174670", "Bamanwas\,\ Rajasthan",
"917867", "Bokaband\,\ Madhya\ Pradesh",
"911906", "Spiti\/Kaza\,\ Himachal\ Pradesh",
"9167322", "Hindol\,\ Odisha",
"9176468", "Nainpur\,\ Madhya\ Pradesh",
"91226", "Mumbai",
"915191", "Naraini\/Attarra\,\ Uttar\ Pradesh",
"9167535", "Nayagarh\,\ Odisha",
"9171766", "Warora\,\ Maharashtra",
"913676", "Howraghat\,\ Assam",
"9164712", "Birpur\,\ Bihar",
"9175942", "Ganjbasoda\,\ Madhya\ Pradesh",
"9174646", "Karauli\,\ Rajasthan",
"9176467", "Nainpur\,\ Madhya\ Pradesh",
"913845", "Ukhrul\ Central\,\ Manipur",
"9164624", "Dhamdaha\,\ Bihar",
"916126", "Patna\,\ Bihar",
"9168412", "Boudh\,\ Odisha",
"914543", "Batlagundu\,\ Tamil\ Nadu",
"9181708", "Alur\,\ Karnataka",
"911427", "Dausa\,\ Rajasthan",
"918738", "Sirpurkagaznagar\,\ Andhra\ Pradesh",
"9175296", "Laher\,\ Madhya\ Pradesh",
"91205", "Pune\,\ Maharashtra",
"9181707", "Alur\,\ Karnataka",
"9168693", "Papadhandi\,\ Odisha",
"918519", "Allagadda\,\ Andhra\ Pradesh",
"9182898", "Athani\,\ Karnataka",
"9164232", "Maheshpur\ Raj\,\ Bihar",
"918194", "Chitradurga\,\ Karnataka",
"9167932", "Betanati\,\ Odisha",
"913878", "Chakpikarong\,\ Manipur",
"9174556", "Digod\/Sultanpur\,\ Rajasthan",
"9173943", "Alirajpur\,\ Madhya\ Pradesh",
"9174614", "Mahuwa\,\ Rajasthan",
"9182897", "Athani\,\ Karnataka",
"9162597", "Pakridayal\,\ Bihar",
"918259", "Shankarnarayana\,\ Karnataka",
"918110", "Anekal\,\ Karnataka",
"918680", "Nidamanur\/Hillcolony\,\ Andhra\ Pradesh",
"9168115", "Chhatrapur\,\ Odisha",
"9174607", "Sahabad\,\ Rajasthan",
"9161114", "Hilsa\,\ Bihar",
"9165563", "Tisri\,\ Bihar",
"9166814", "Jujumura\,\ Odisha",
"9162765", "Madhubani\,\ Bihar",
"911744", "Kurukshetra\,\ Haryana",
"9174608", "Sahabad\,\ Rajasthan",
"918778", "Tirupathi\,\ Andhra\ Pradesh",
"915275", "Akbarpur\/Jalalpur\,\ Uttar\ Pradesh",
"9161576", "Mairwa\,\ Bihar",
"9167646", "Anugul\,\ Odisha",
"91481", "Kottayam\,\ Kerala",
"9174535", "Baran\,\ Rajasthan",
"913838", "Aizwal\/Serchip\,\ Mizoram",
"911581", "Ladnun\,\ Rajasthan",
"9165242", "Gumla\,\ Bihar",
"912345", "Shirala\,\ Maharashtra",
"9174322", "Jhalawar\,\ Rajasthan",
"9166776", "Narlaroad\,\ Odisha",
"9165865", "Chainpur\,\ Bihar",
"911924", "Akhnoor\,\ Jammu\ And\ Kashmir",
"915248", "Barabanki\,\ Uttar\ Pradesh",
"914994", "Kasaragod\,\ Kerala",
"9171124", "Katol\,\ Maharashtra",
"9174388", "Keshoraipatan\/Patan\,\ Rajasthan",
"918745", "Yellandu\,\ Andhra\ Pradesh",
"914373", "Pattukottai\,\ Tamil\ Nadu",
"9161146", "Jahanabad\,\ Bihar",
"9166846", "Paikamal\,\ Odisha",
"9182203", "Gundlupet\,\ Karnataka",
"9174387", "Keshoraipatan\/Patan\,\ Rajasthan",
"9171034", "Butibori\,\ Maharashtra",
"9174932", "Karera\,\ Madhya\ Pradesh",
"9171366", "Etapalli\,\ Maharashtra",
"9171495", "Tamia\,\ Madhya\ Pradesh",
"9176434", "Bijadandi\,\ Madhya\ Pradesh",
"9162584", "Areraj\,\ Bihar",
"9164312", "Jharmundi\,\ Bihar",
"9181746", "Arsikere\,\ Karnataka",
"912378", "Medha\,\ Maharashtra",
"913860", "Wokha\,\ Nagaland",
"9163243", "Nawada\,\ Bihar",
"9167614", "Chhendipada\,\ Odisha",
"917562", "Sehore\,\ Madhya\ Pradesh",
"9162272", "Mahua\,\ Bihar",
"9167556", "Khurda\,\ Odisha",
"914936", "Kalpetta\,\ Kerala",
"9168587", "Nowrangapur\,\ Odisha",
"9176260", "Vijayraghogarh\,\ Madhya\ Pradesh",
"911804", "Panipat\,\ Haryana",
"9173203", "Pandhana\,\ Madhya\ Pradesh",
"9165445", "Gomia\,\ Bihar",
"91478", "Cherthala\,\ Kerala",
"9172862", "Khetia\,\ Madhya\ Pradesh",
"9165297", "Itki\,\ Bihar",
"912672", "Godhra\,\ Gujarat",
"915461", "Ghosi\,\ Uttar\ Pradesh",
"911786", "Kalpa\,\ Himachal\ Pradesh",
"911465", "Thanaghazi\,\ Rajasthan",
"9176378", "Birsa\,\ Madhya\ Pradesh",
"9167815", "Basta\,\ Odisha",
"9164557", "Forbesganj\,\ Bihar",
"9176377", "Birsa\,\ Madhya\ Pradesh",
"9168486", "Kotagarh\,\ Odisha",
"918455", "Sangareddy\,\ Andhra\ Pradesh",
"9162475", "Singhwara\,\ Bihar",
"918656", "Nuzvidu\,\ Andhra\ Pradesh",
"912961", "Ghatol\,\ Rajasthan",
"911666", "Sirsa\,\ Haryana",
"9164786", "Saharsa\,\ Bihar",
"9163254", "Pakribarwan\,\ Bihar",
"912489", "Karjat\,\ Maharashtra",
"914115", "Madurantakam\,\ Tamil\ Nadu",
"918464", "Madnur\,\ Andhra\ Pradesh",
"9165664", "Japla\,\ Bihar",
"917825", "Berla\,\ Madhya\ Pradesh",
"912939", "Jaitaran\,\ Rajasthan",
"918408", "Donakonda\,\ Andhra\ Pradesh",
"9174250", "Garoth\,\ Madhya\ Pradesh",
"9168522", "Koraput\,\ Odisha",
"9166466", "Bargarh\,\ Odisha",
"9165505", "Hunterganj\,\ Bihar",
"9174513", "Atru\,\ Rajasthan",
"9165284", "Khunti\,\ Bihar",
"911870", "Jugial\,\ Punjab",
"9161595", "Masrakh\,\ Bihar",
"9166534", "Dunguripali\,\ Odisha",
"9164386", "Madhupur\,\ Bihar",
"9165572", "Bagodar\,\ Bihar",
"9168594", "Motu\,\ Odisha",
"915112", "Bilhaur\,\ Uttar\ Pradesh",
"9171147", "Ramtek\,\ Maharashtra",
"9161893", "Bhabhua\,\ Bihar",
"911990", "Ramnagar\,\ Jammu\ And\ Kashmir",
"918136", "Pavagada\,\ Karnataka",
"911628", "Samrala\,\ Punjab",
"9165637", "Bhawanathpur\,\ Bihar",
"918563", "Kamalapuram\/Yerraguntala\,\ Andhra\ Pradesh",
"9176300", "Katangi\,\ Madhya\ Pradesh",
"912979", "Sanchore\,\ Rajasthan",
"9174815", "Gairatganj\,\ Madhya\ Pradesh",
"915643", "Nadbai\,\ Rajasthan",
"9166795", "Komana\,\ Odisha",
"917785", "Makodi\,\ Madhya\ Pradesh",
"9164523", "Katihar\,\ Bihar",
"9162542", "Bettiah\,\ Bihar",
"9171577", "Arvi\,\ Maharashtra",
"9173954", "Sondhwa\,\ Madhya\ Pradesh",
"9165975", "Saraikela\/Adstyapur\,\ Bihar",
"912632", "Valsad\,\ Gujarat",
"9171476", "Multai\,\ Madhya\ Pradesh",
"914896", "Kavaratti\,\ Lakshadweep",
"9162263", "Sitamarhi\,\ Bihar",
"911826", "Phillaur\,\ Punjab",
"913758", "Dhakuakhana\,\ Assam",
"911957", "Bandipur\,\ Jammu\ And\ Kashmir",
"9168215", "Bhanjanagar\,\ Odisha",
"918915", "Visakhapatnam\,\ Andhra\ Pradesh",
"91360", "Itanagar\/Ziro\,\ Arunachal\ Pradesh",
"9165295", "Itki\,\ Bihar",
"9165447", "Gomia\,\ Bihar",
"915331", "Bharwari\,\ Uttar\ Pradesh",
"9168585", "Nowrangapur\,\ Odisha",
"9167663", "Keonjhar\,\ Odisha",
"915664", "Mant\/Vrindavan\,\ Uttar\ Pradesh",
"9171003", "Kuhi\,\ Maharashtra",
"9161584", "Sonepur\,\ Bihar",
"9174969", "Pichhore\,\ Madhya\ Pradesh",
"9176375", "Birsa\,\ Madhya\ Pradesh",
"9164555", "Forbesganj\,\ Bihar",
"9167817", "Basta\,\ Odisha",
"912734", "Chanasma\,\ Gujarat",
"9176403", "Shahpur\,\ Madhya\ Pradesh",
"9176302", "Katangi\,\ Madhya\ Pradesh",
"9166784", "Nowparatan\,\ Odisha",
"9165546", "Rajdhanwar\,\ Bihar",
"9171442", "Atner\,\ Madhya\ Pradesh",
"9163266", "Sherghati\,\ Bihar",
"911651", "Phulmandi\,\ Punjab",
"912827", "Kotdasanghani\,\ Gujarat",
"9181763", "Cannarayapatna\,\ Karnataka",
"915541", "Domariyaganj\,\ Uttar\ Pradesh",
"917296", "Sardarpur\,\ Madhya\ Pradesh",
"912381", "Ahmedpur\,\ Maharashtra",
"918334", "Mudalgi\,\ Karnataka",
"9174804", "Goharganj\,\ Madhya\ Pradesh",
"9162477", "Singhwara\,\ Bihar",
"9171343", "Bhamregadh\,\ Maharashtra",
"918247", "Mangalore\,\ Karnataka",
"912956", "Gogunda\,\ Rajasthan",
"918639", "Guntur\,\ Andhra\ Pradesh",
"9165656", "Latehar\,\ Bihar",
"917752", "Bilaspur\,\ Madhya\ Pradesh",
"912591", "Manmad\,\ Maharashtra",
"9165514", "Barkagaon\,\ Bihar",
"9162576", "Barachakia\,\ Bihar",
"9166454", "Jharsuguda\,\ Odisha",
"915175", "Lalitpur\/Talbehat\,\ Uttar\ Pradesh",
"918833", "Rajahmundri\,\ Andhra\ Pradesh",
"9167252", "Dhanmandal\,\ Odisha",
"9171145", "Ramtek\,\ Maharashtra",
"914652", "Nagercoil\,\ Tamil\ Nadu",
"9172860", "Khetia\,\ Madhya\ Pradesh",
"911560", "Sujangarh\/Bidasar\,\ Rajasthan",
"918210", "Mysore\,\ Karnataka",
"918159", "Mulbagal\,\ Karnataka",
"9161597", "Masrakh\,\ Bihar",
"9171972", "Mohadi\,\ Maharashtra",
"918550", "Yellanuru\,\ Andhra\ Pradesh",
"911348", "Lansdowne\/Syunsi\,\ Uttarakhand",
"9176262", "Vijayraghogarh\,\ Madhya\ Pradesh",
"9165507", "Hunterganj\,\ Bihar",
"9174663", "Bonli\,\ Rajasthan",
"916802", "Berhampur\,\ Odisha",
"9171743", "Mul\,\ Maharashtra",
"9166797", "Komana\,\ Odisha",
"9165406", "Govindpur\,\ Bihar",
"915824", "Aonla\/Ramnagar\,\ Uttar\ Pradesh",
"9174817", "Gairatganj\,\ Madhya\ Pradesh",
"912522", "Bhiwandi\,\ Maharashtra",
"916314", "Gaya\,\ Bihar",
"914172", "Ranipet\,\ Tamil\ Nadu",
"9174818", "Gairatganj\,\ Madhya\ Pradesh",
"9165635", "Bhawanathpur\,\ Bihar",
"918443", "Shorapur\,\ Karnataka",
"9165977", "Saraikela\/Adstyapur\,\ Bihar",
"911375", "Rajgarhi\,\ Uttarakhand",
"918932", "Narsipatnam\,\ Andhra\ Pradesh",
"9177049", "Deobhog\,\ Madhya\ Pradesh",
"9171575", "Arvi\,\ Maharashtra",
"917546", "Chachaura\,\ Madhya\ Pradesh",
"917801", "Deosar\,\ Madhya\ Pradesh",
"913792", "Daporizo\,\ Arunachal\ Pradesh",
"9174252", "Garoth\,\ Madhya\ Pradesh",
"918821", "Jangareddygudem\,\ Andhra\ Pradesh",
"9168217", "Bhanjanagar\,\ Odisha",
"918482", "Bidar\,\ Karnataka",
"912774", "Modasa\,\ Gujarat",
"912185", "Malsuras\,\ Maharashtra",
"918387", "Honnavar\,\ Karnataka",
"9167283", "Jajapur\ Town\,\ Odisha",
"9164536", "Araria\,\ Bihar",
"912667", "Savli\,\ Gujarat",
"9171873", "Goregaon\,\ Maharashtra",
"9161522", "Chapra\,\ Bihar",
"917834", "Sitapur\,\ Madhya\ Pradesh",
"9166457", "Jharsuguda\,\ Odisha",
"918645", "Mangalagiri\,\ Andhra\ Pradesh",
"9165665", "Japla\,\ Bihar",
"9174340", "Pirawa\/Raipur\,\ Rajasthan",
"918551", "Garladinne\,\ Andhra\ Pradesh",
"9165517", "Barkagaon\,\ Bihar",
"917125", "Nagpur\,\ Maharashtra",
"911561", "Taranagar\,\ Rajasthan",
"9167293", "Pattamundai\,\ Odisha",
"91343", "Durgapur\,\ West\ Bengal",
"9167846", "Bhadrak\,\ Odisha",
"916744", "Bhubaneshwar\,\ Odisha",
"9163255", "Pakribarwan\,\ Bihar",
"9174808", "Goharganj\,\ Madhya\ Pradesh",
"9174633", "Gangapur\,\ Rajasthan",
"911539", "Tibbi\,\ Rajasthan",
"9166722", "Dharamgarh\,\ Odisha",
"9166556", "Titlagarh\,\ Odisha",
"9174376", "Nainwa\,\ Rajasthan",
"9162474", "Singhwara\,\ Bihar",
"9174807", "Goharganj\,\ Madhya\ Pradesh",
"91790", "Ahmedabad\ Local\,\ Gujarat",
"9165416", "Chatra\,\ Bihar",
"9171512", "Samudrapur\,\ Maharashtra",
"913253", "Manbazar\,\ West\ Bengal",
"9167814", "Basta\,\ Odisha",
"917582", "Sagar\,\ Madhya\ Pradesh",
"913880", "Sadarhills\/Kangpokai\,\ Manipur",
"9175210", "Seondha\,\ Madhya\ Pradesh",
"918707", "Warangal\,\ Andhra\ Pradesh",
"9175949", "Ganjbasoda\,\ Madhya\ Pradesh",
"9166787", "Nowparatan\,\ Odisha",
"913513", "Harishchandrapur\,\ West\ Bengal",
"918678", "Nandigama\,\ Andhra\ Pradesh",
"917543", "Ashoknagar\,\ Madhya\ Pradesh",
"9162226", "Sheohar\,\ Bihar",
"9165444", "Gomia\,\ Bihar",
"917727", "Balodabazar\,\ Madhya\ Pradesh",
"91253", "Nasik\ City\,\ Maharashtra",
"917272", "Dewas\,\ Madhya\ Pradesh",
"9173936", "Jobat\,\ Madhya\ Pradesh",
"918158", "Sidlaghatta\,\ Karnataka",
"9161587", "Sonepur\,\ Bihar",
"9163316", "Imamganj\,\ Bihar",
"915453", "Shahganj\,\ Uttar\ Pradesh",
"9175920", "Vidisha\,\ Madhya\ Pradesh",
"911697", "Ratia\,\ Haryana",
"9168214", "Bhanjanagar\,\ Odisha",
"9174939", "Karera\,\ Madhya\ Pradesh",
"9174846", "Silwani\,\ Madhya\ Pradesh",
"918301", "Mundagod\,\ Karnataka",
"918638", "Guntur\,\ Andhra\ Pradesh",
"9173955", "Sondhwa\,\ Madhya\ Pradesh",
"9167633", "Athmallik\,\ Odisha",
"9165974", "Saraikela\/Adstyapur\,\ Bihar",
"91257", "Jalgaon\,\ Maharashtra",
"917444", "Ladpura\/Kota\,\ Rajasthan",
"9174870", "Begamganj\,\ Madhya\ Pradesh",
"912557", "Dindori\,\ Maharashtra",
"913807", "Miao\,\ Arunachal\ Pradesh",
"917232", "Yeotmal\,\ Maharashtra",
"9176413", "Niwas\,\ Madhya\ Pradesh",
"918780", "Karimnagar\,\ Andhra\ Pradesh",
"918660", "Vijayawada\,\ Andhra\ Pradesh",
"9174814", "Gairatganj\,\ Madhya\ Pradesh",
"9166794", "Komana\,\ Odisha",
"915368", "Amethi\,\ Uttar\ Pradesh",
"914562", "Virudhunagar\,\ Tamil\ Nadu",
"9166833", "Padmapur\,\ Odisha",
"9174329", "Jhalawar\,\ Rajasthan",
"918836", "Rajahmundri\,\ Andhra\ Pradesh",
"9161356", "Bikram\,\ Bihar",
"9161594", "Masrakh\,\ Bihar",
"9166535", "Dunguripali\,\ Odisha",
"913776", "Bokakhat\,\ Assam",
"912953", "Nathdwara\,\ Rajasthan",
"9168595", "Motu\,\ Odisha",
"9163236", "Dumraon\,\ Bihar",
"9166423", "Kuchinda\,\ Odisha",
"9181733", "Sakleshpur\,\ Karnataka",
"9165504", "Hunterganj\,\ Bihar",
"9165285", "Khunti\,\ Bihar",
"914287", "Rasipuram\,\ Tamil\ Nadu",
"915646", "Baseri\,\ Rajasthan",
"913759", "Bihupuria\,\ Assam",
"9162713", "Benipatti\,\ Bihar",
"911871", "Batala\,\ Punjab",
"9175922", "Vidisha\,\ Madhya\ Pradesh",
"9174626", "Sawaimadhopur\,\ Rajasthan",
"9165515", "Barkagaon\,\ Bihar",
"918133", "Chikkanayakanahalli\,\ Karnataka",
"915875", "Mohammadi\/Maigalganj\,\ Uttar\ Pradesh",
"9174503", "Sangod\,\ Rajasthan",
"9168163", "Mohana\,\ Odisha",
"9165667", "Japla\,\ Bihar",
"918566", "Koduru\,\ Andhra\ Pradesh",
"9166455", "Jharsuguda\,\ Odisha",
"913595", "Gauzing\/Nayabazar\,\ West\ Bengal",
"912696", "Borsad\,\ Gujarat",
"9174805", "Goharganj\,\ Madhya\ Pradesh",
"9165813", "Bhandaria\,\ Bihar",
"91421", "Tirupur\,\ Tamil\ Nadu",
"914577", "Tirupathur\,\ Tamil\ Nadu",
"9174872", "Begamganj\,\ Madhya\ Pradesh",
"911991", "Reasi\,\ Jammu\ And\ Kashmir",
"9163257", "Pakribarwan\,\ Bihar",
"918325", "Goa",
"9174973", "Khaniadhana\,\ Madhya\ Pradesh",
"9166785", "Nowparatan\,\ Odisha",
"9173923", "Jhabua\,\ Madhya\ Pradesh",
"912978", "Ahore\,\ Rajasthan",
"9164554", "Forbesganj\,\ Bihar",
"9176374", "Birsa\,\ Madhya\ Pradesh",
"9171662", "Chaurai\,\ Madhya\ Pradesh",
"9165912", "Chandil\,\ Bihar",
"9164616", "Raniganj\,\ Bihar",
"914893", "Androth\,\ Lakshadweep",
"9162233", "Motipur\,\ Bihar",
"911823", "Nawanshahar\,\ Punjab",
"9161883", "Rohtas\,\ Bihar",
"918192", "Davangere\,\ Karnataka",
"9168584", "Nowrangapur\,\ Odisha",
"912898", "Jamjodhpur\,\ Gujarat",
"9161585", "Sonepur\,\ Bihar",
"9165294", "Itki\,\ Bihar",
"915445", "Robertsganj\/Obra\,\ Uttar\ Pradesh",
"912938", "Bali\,\ Rajasthan",
"9173213", "Sanwer\,\ Madhya\ Pradesh",
"911783", "Theog\,\ Himachal\ Pradesh",
"9174342", "Pirawa\/Raipur\,\ Rajasthan",
"917267", "Malkapur\,\ Maharashtra",
"9165222", "Muri\,\ Bihar",
"9167626", "Dhenkanal\,\ Odisha",
"912488", "Parner\,\ Maharashtra",
"9173958", "Sondhwa\,\ Madhya\ Pradesh",
"9176816", "Jatara\,\ Madhya\ Pradesh",
"91286", "Porbander\,\ Gujarat",
"9164796", "Udakishanganj\,\ Bihar",
"914933", "Perinthalmanna\,\ Kerala",
"914347", "Denkanikota\,\ Tamil\ Nadu",
"9173957", "Sondhwa\,\ Madhya\ Pradesh",
"9171574", "Arvi\,\ Maharashtra",
"915460", "Phulpur\,\ Uttar\ Pradesh",
"917564", "Budhni\,\ Madhya\ Pradesh",
"9168496", "Daringbadi\,\ Odisha",
"9165634", "Bhawanathpur\,\ Bihar",
"9164273", "Kathikund\,\ Bihar",
"9167973", "Jashipur\,\ Odisha",
"9181726", "Hassan\,\ Karnataka",
"9166436", "Barkot\,\ Odisha",
"9163223", "Wazirganj\,\ Bihar",
"912960", "Sojat\,\ Rajasthan",
"9175212", "Seondha\,\ Madhya\ Pradesh",
"9161852", "Bikramganj\,\ Bihar",
"9165287", "Khunti\,\ Bihar",
"911663", "Hansi\,\ Haryana",
"9161126", "Biharsharif\,\ Bihar",
"9166826", "Attabira\,\ Odisha",
"9168597", "Motu\,\ Odisha",
"9171144", "Ramtek\,\ Maharashtra",
"911922", "Kathua\,\ Jammu\ And\ Kashmir",
"9166537", "Dunguripali\,\ Odisha",
"9174679", "Bamanwas\,\ Rajasthan",
"9174618", "Mahuwa\,\ Rajasthan",
"9168172", "R\.Udayigiri\,\ Odisha",
"9165835", "Kharsawa\,\ Bihar",
"9171485", "Prabha\ Pattan\,\ Madhya\ Pradesh",
"9162594", "Pakridayal\,\ Bihar",
"9174565", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"9168652", "Kashipur\,\ Odisha",
"9168105", "Khalikote\,\ Odisha",
"914320", "Aravakurichi\,\ Tamil\ Nadu",
"9174617", "Mahuwa\,\ Rajasthan",
"9182894", "Athani\,\ Karnataka",
"912674", "Lunavada\,\ Gujarat",
"9174863", "Bareli\,\ Madhya\ Pradesh",
"912715", "Viramgam\,\ Gujarat",
"9165425", "Bokaro\,\ Bihar",
"911580", "Deedwana\,\ Rajasthan",
"911802", "Panipat\,\ Haryana",
"912767", "Sidhpur\,\ Gujarat",
"9181704", "Alur\,\ Karnataka",
"9165533", "Ramgarh\,\ Bihar",
"9162735", "Jhajharpur\,\ Bihar",
"9171673", "Amarwada\,\ Madhya\ Pradesh",
"918315", "Belgaum\,\ Karnataka",
"912117", "Daund\,\ Maharashtra",
"9168542", "Jeypore\,\ Odisha",
"9176309", "Katangi\,\ Madhya\ Pradesh",
"9171755", "Bhadrawati\,\ Maharashtra",
"918367", "Hubli\,\ Karnataka",
"913839", "Jalukie\,\ Nagaland",
"9171153", "Mouda\,\ Maharashtra",
"91422", "Coimbatore\,\ Tamil\ Nadu",
"9174962", "Pichhore\,\ Madhya\ Pradesh",
"912165", "Dhiwadi\,\ Maharashtra",
"91129", "Faridabad\,\ Haryana",
"918462", "Nizamabad\,\ Andhra\ Pradesh",
"9171336", "Aheri\,\ Maharashtra",
"9164627", "Dhamdaha\,\ Bihar",
"9176464", "Nainpur\,\ Madhya\ Pradesh",
"914296", "Avanashi\,\ Tamil\ Nadu",
"9164375", "Mahagama\,\ Bihar",
"9167604", "Talcher\,\ Odisha",
"91261", "Surat\,\ Gujarat",
"913861", "Tuengsang\,\ Nagaland",
"9163325", "Nabinagar\,\ Bihar",
"9171064", "Bhiwapur\,\ Maharashtra",
"918779", "Tirupathi\,\ Andhra\ Pradesh",
"9162587", "Areraj\,\ Bihar",
"9176437", "Bijadandi\,\ Madhya\ Pradesh",
"918258", "Karkala\,\ Karnataka",
"9171355", "Chamorshi\,\ Maharashtra",
"916123", "Patna\,\ Bihar",
"911903", "Banjar\,\ Himachal\ Pradesh",
"913879", "Bishenpur\,\ Manipur",
"9176438", "Bijadandi\,\ Madhya\ Pradesh",
"9167617", "Chhendipada\,\ Odisha",
"9174259", "Garoth\,\ Madhya\ Pradesh",
"912140", "Mangaon\,\ Maharashtra",
"918761", "Sathupalli\,\ Andhra\ Pradesh",
"9168683", "Nandapur\,\ Odisha",
"9167565", "Balugaon\,\ Odisha",
"913673", "Haflong\,\ Assam",
"9171736", "Rajura\,\ Maharashtra",
"911268", "Ferojpur\,\ Haryana",
"918518", "Kurnool\,\ Andhra\ Pradesh",
"9164775", "Triveniganj\,\ Bihar",
"9166252", "Lahunipara\,\ Odisha",
"9173235", "Punasa\,\ Madhya\ Pradesh",
"915114", "Derapur\/Jhinjak\,\ Uttar\ Pradesh",
"9171127", "Katol\,\ Maharashtra",
"9167863", "Chandbali\,\ Odisha",
"918739", "Jannaram\/Luxittipet\,\ Andhra\ Pradesh",
"9174384", "Keshoraipatan\/Patan\,\ Rajasthan",
"9176536", "Bandhavgarh\,\ Madhya\ Pradesh",
"9171037", "Butibori\,\ Maharashtra",
"915190", "Baberu\,\ Uttar\ Pradesh",
"9177042", "Deobhog\,\ Madhya\ Pradesh",
"915677", "Karhal\,\ Uttar\ Pradesh",
"918205", "Udupi\,\ Karnataka",
"91565", "Mathura\,\ Uttar\ Pradesh",
"9168475", "G\.Udayagiri\,\ Odisha",
"91154", "Sriganganagar\,\ Rajasthan",
"913621", "Boko\,\ Assam",
"9171182", "Kalmeshwar\,\ Maharashtra",
"9164262", "Rajmahal\,\ Bihar",
"911507", "Raisinghnagar\,\ Rajasthan",
"9167962", "Karanjia\,\ Odisha",
"9168402", "Tumudibandha\,\ Odisha",
"9165856", "Ghatsila\,\ Bihar",
"9176269", "Vijayraghogarh\,\ Madhya\ Pradesh",
"9166817", "Jujumura\,\ Odisha",
"9161117", "Hilsa\,\ Bihar",
"918681", "Chandoor\,\ Andhra\ Pradesh",
"918111", "Hosakote\,\ Karnataka",
"912634", "Billimora\,\ Gujarat",
"9162756", "Rosera\,\ Bihar",
"9174604", "Sahabad\,\ Rajasthan",
"9164543", "Purnea\,\ Bihar",
"9162522", "Motihari\,\ Bihar",
"914546", "Theni\,\ Tamil\ Nadu",
"917225", "Tiwasa\,\ Maharashtra",
"916213", "Muzaffarpur\,\ Bihar",
"917765", "Pathalgaon\,\ Madhya\ Pradesh",
"9174615", "Mahuwa\,\ Rajasthan",
"9168107", "Khalikote\,\ Odisha",
"9165603", "Patan\,\ Bihar",
"9174567", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"9171487", "Prabha\ Pattan\,\ Madhya\ Pradesh",
"9165837", "Kharsawa\,\ Bihar",
"918583", "Sodam\,\ Andhra\ Pradesh",
"9174568", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"912471", "Tuljapur\,\ Maharashtra",
"9163483", "Mallehpur\,\ Bihar",
"9177076", "Bagbahera\,\ Madhya\ Pradesh",
"913523", "Raiganj\,\ West\ Bengal",
"9162737", "Jhajharpur\,\ Bihar",
"915662", "Chhata\/Kosikalan\,\ Uttar\ Pradesh",
"9177040", "Deobhog\,\ Madhya\ Pradesh",
"9165427", "Bokaro\,\ Bihar",
"918542", "Mahabubnagar\,\ Andhra\ Pradesh",
"91370", "Kohima\,\ Nagaland",
"9171586", "Deoli\,\ Maharashtra",
"913658", "Williamnagar\,\ Meghalaya",
"915923", "Sambhal\,\ Uttar\ Pradesh",
"918393", "Kurugodu\,\ Karnataka",
"9164625", "Dhamdaha\,\ Bihar",
"9165482", "Ichak\,\ Bihar",
"9176456", "Karanjia\,\ Madhya\ Pradesh",
"9171757", "Bhadrawati\,\ Maharashtra",
"917201", "Kalamb\,\ Maharashtra",
"912423", "Koparagon\,\ Maharashtra",
"912793", "Damnagar\,\ Gujarat",
"9165383", "Torpa\,\ Bihar",
"9167534", "Nayagarh\,\ Odisha",
"911895", "Bharmour\,\ Himachal\ Pradesh",
"917754", "Pandaria\,\ Madhya\ Pradesh",
"9171832", "Tumsar\,\ Maharashtra",
"9171323", "Gadchiroli\,\ Maharashtra",
"911498", "Anupgarh\,\ Rajasthan",
"918221", "Nanjangud\,\ Karnataka",
"9172869", "Khetia\,\ Madhya\ Pradesh",
"917685", "Nowgaon\,\ Madhya\ Pradesh",
"918332", "Gokak\,\ Karnataka",
"912841", "Vallabhipur\,\ Gujarat",
"911975", "Una\,\ Himachal\ Pradesh",
"9163327", "Nabinagar\,\ Bihar",
"9171422", "Bhimpur\,\ Madhya\ Pradesh",
"9171056", "Narkhed\,\ Maharashtra",
"9164377", "Mahagama\,\ Bihar",
"9167567", "Balugaon\,\ Odisha",
"9176523", "Shahdol\,\ Madhya\ Pradesh",
"9167615", "Chhendipada\,\ Odisha",
"9171357", "Chamorshi\,\ Maharashtra",
"916312", "Gaya\,\ Bihar",
"914174", "Vaniyambadi\,\ Tamil\ Nadu",
"9171494", "Tamia\,\ Madhya\ Pradesh",
"915822", "Baheri\,\ Uttar\ Pradesh",
"911485", "Jahazpur\,\ Rajasthan",
"912524", "Murbad\,\ Maharashtra",
"9162585", "Areraj\,\ Bihar",
"9163452", "Jamui\,\ Bihar",
"916417", "Bhagalpur\,\ Bihar",
"9176435", "Bijadandi\,\ Madhya\ Pradesh",
"916804", "Berhampur\,\ Odisha",
"9171723", "Chandrapur\,\ Maharashtra",
"9171035", "Butibori\,\ Maharashtra",
"91476", "Karunagapally\,\ Kerala",
"9168146", "Digapahandi\,\ Odisha",
"9173238", "Punasa\,\ Madhya\ Pradesh",
"918372", "Gadag\,\ Karnataka",
"9171125", "Katol\,\ Maharashtra",
"9164777", "Triveniganj\,\ Bihar",
"9173237", "Punasa\,\ Madhya\ Pradesh",
"918477", "Aland\,\ Karnataka",
"917740", "Bodla\,\ Madhya\ Pradesh",
"9165453", "Mandu\,\ Bihar",
"9165864", "Chainpur\,\ Bihar",
"9166513", "Birmaharajpur\,\ Odisha",
"9174960", "Pichhore\,\ Madhya\ Pradesh",
"912772", "Himatnagar\,\ Gujarat",
"9176386", "Damoh\,\ Madhya\ Pradesh",
"9168477", "G\.Udayagiri\,\ Odisha",
"9174534", "Baran\,\ Rajasthan",
"918847", "Kakinada\,\ Andhra\ Pradesh",
"9165352", "Chainpur\,\ Bihar",
"912431", "Paithan\,\ Maharashtra",
"918484", "Bhalki\,\ Karnataka",
"9168576", "Gunupur\,\ Odisha",
"912356", "Khed\,\ Maharashtra",
"912469", "Kinwat\,\ Maharashtra",
"913794", "Tawang\,\ Arunachal\ Pradesh",
"911686", "Safidon\,\ Haryana",
"918934", "Chodavaram\,\ Andhra\ Pradesh",
"913019", "Pokhran\/Phalsoond\,\ Rajasthan",
"912981", "Sheo\/Harsani\,\ Rajasthan",
"9168114", "Chhatrapur\,\ Odisha",
"9174711", "Bundi\,\ Rajasthan",
"9161115", "Hilsa\,\ Bihar",
"9166815", "Jujumura\,\ Odisha",
"9162764", "Madhubani\,\ Bihar",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+91|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;