# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210919194240;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[0568]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[3-6]\\d{10}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[3-6]\\d{10}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15[0-25-9]\\d{8}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{de} = {"4939883", "Groß\ Dölln",
"496663", "Steinau\ an\ der\ Straße",
"4934493", "Gößnitz\ Thüringen",
"494497", "Barßel\-Harkebrügge",
"495064", "Groß\ Düngen",
"497351", "Biberach\ an\ der\ Riß",
"498367", "Roßhaupten\ Forggensee",
"493647", "Pößneck",
"4935248", "Schönfeld\ bei\ Großenhain",
"492339", "Sprockhövel\-Haßlinghausen",
"4935240", "Tauscha\ bei\ Großenhain",
"4935841", "Großschönau\ Sachsen",
"4936949", "Obermaßfeld\-Grimmenthal",
"494509", "Groß\ Grönau",
"4939976", "Groß\ Bützin",
"499656", "Moosbach\ bei\ Vohenstrauß",
"496321", "Neustadt\ an\ der\ Weinstraße",
"497355", "Hochdorf\ Riß",
"495053", "Faßberg\-Müden",
"4939934", "Groß\ Plasten",
"498807", "Dießen\ am\ Ammersee",
"4938234", "Born\ Darß",
"4935938", "Großpostwitz\ OL",
"499567", "Seßlach\-Gemünda",
"49911", "Nürnberg",
"4989", "München",
"4935952", "Großröhrsdorf\ OL",
"4936484", "Knau\ bei\ Pößneck",
"495827", "Unterlüß",
"492203", "Köln\-Porz",
"494684", "Langeneß\ Hallig",
"498633", "Tüßling",
"496364", "Nußbach\ Pfalz",
"499242", "Gößweinstein",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"4935726", "Groß\ Särchen",
"494483", "Ovelgönne\-Großenmeer",
"498170", "Straßlach\-Dingharting",
"498536", "Kößlarn",
"499636", "Plößberg",
"499141", "Weißenburg\ in\ Bayern",
"4936072", "Weißenborn\-Lüderode",
"49221", "Köln",
"496252", "Heppenheim\ Bergstraße",
"497162", "Süßen",
"4934901", "Roßlau\ Elbe",
"4935753", "Großräschen",
"4934445", "Stößen",
"495384", "Seesen\-Groß\ Rhüden",};
$areanames{en} = {"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"4933967", "Freyenstein",
"492455", "Waldfeucht",
"492482", "Hellenthal",
"497335", "Wiesensteig",
"4936653", "Lehesten\ Thüringer\ Wald",
"495176", "Edemissen",
"4933231", "Pausin",
"494323", "Bornhöved",
"496664", "Sinntal\-Sterbfritz",
"498656", "Anger",
"497483", "Horb\-Mühringen",
"496296", "Ahorn\ Baden",
"4939003", "Jübar",
"496146", "Hochheim\ am\ Main",
"495524", "Bad\ Lauterberg\ im\ Harz",
"497821", "Lahr\ Schwarzwald",
"494381", "Lütjenburg",
"492855", "Voerde\ Niederrhein",
"4936704", "Steinheid",
"499681", "Windischeschenbach",
"4936072", "Weissenborn\-Lüderode",
"492132", "Meerbusch\-Büderich",
"4939975", "Thürkow",
"499827", "Lichtenau\ Mittelfranken",
"495746", "Rödinghausen",
"494223", "Ganderkesee\-Bookholzberg",
"497235", "Unterreichenbach\ Kreis\ Calw",
"496551", "Prüm",
"497133", "Lauffen\ am\ Neckar",
"496407", "Rabenau\ Hessen",
"496776", "Dachsenhausen",
"499427", "Leiblfing",
"496396", "Hinterweidenthal",
"494125", "Seestermühe",
"494281", "Zeven",
"4936647", "Saalburg\ Thüringen",
"495943", "Emlichheim",
"498268", "Tussenhausen",
"49221", "Cologne",
"494755", "Ihlienworth",
"494284", "Selsingen",
"498333", "Babenhausen\ Schwaben",
"4935471", "Birkenhainchen",
"493847", "Sternberg",
"4939772", "Rothemühl",
"494547", "Gudow\ Lauenburg",
"493695", "Bad\ Salzungen",
"4935823", "Ostritz",
"493643", "Weimar\ Thüringen",
"496554", "Waxweiler",
"4933742", "Oehna\ Brandenburg",
"492686", "Weyerbusch",
"493447", "Altenburg\ Thüringen",
"495068", "Elze\ Leine",
"499935", "Stephansposching",
"498452", "Geisenfeld",
"494384", "Selent",
"4936258", "Friemar",
"4933841", "Belzig",
"498233", "Kissing",
"495521", "Herzberg\ am\ Harz",
"497824", "Schwanau",
"498368", "Halblech",
"4939423", "Wegeleben",
"498380", "Achberg",
"4937368", "Deutschneudorf",
"49231", "Dortmund",
"4935876", "Weissenberg\ Sachsen",
"4935028", "Krippen",
"4933922", "Karwesee",
"4939004", "Köckte\ bei\ Gardelegen",
"4933830", "Ziesar",
"495033", "Wunstorf\-Grossenheidorn",
"496661", "Schlüchtern",
"495583", "Braunlage\-Hohegeiss",
"499093", "Polsingen",
"4936703", "Gräfenthal",
"497424", "Spaichingen",
"498135", "Sulzemoos",
"496132", "Ingelheim\ am\ Rhein",
"498347", "Friesenried",
"494672", "Langenhorn",
"495308", "Lehre",
"495937", "Geeste\-Gross\ Hesepe",
"4933929", "Gühlen\-Glienicke",
"497525", "Aulendorf",
"492551", "Steinfurt\-Burgsteinfurt",
"493385", "Rathenow",
"494533", "Reinfeld\ Holstein",
"4938827", "Kalkhorst",
"4939364", "Dolle",
"493433", "Borna\ Stadt",
"492603", "Bad\ Ems",
"492407", "Herzogenrath\-Kohlscheid",
"492776", "Bad\ Endbach\-Hartenrod",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"499272", "Fichtelberg",
"4939401", "Neuwegersleben",
"499394", "Esselbach",
"494366", "Grömitz\-Cismar",
"497958", "Rot\ Am\ See\-Brettheim",
"499774", "Oberelsbach",
"499666", "Illschwang",
"496455", "Frankenau\ Hessen",
"492598", "Senden\-Ottmarsbocholt",
"497309", "Weissenhorn",
"496482", "Runkel",
"495208", "Leopoldshöhe",
"4936941", "Wasungen",
"498247", "Bad\ Wörishofen",
"498584", "Breitenberg\ Niederbayern",
"492664", "Rennerod",
"498034", "Brannenburg",
"493868", "Rastow",
"4936450", "Kranichfeld",
"495506", "Adelebsen",
"492296", "Reichshof\-Brüchermühle",
"494266", "Brockel",
"495732", "Löhne",
"4939779", "Eggesin",
"499372", "Klingenberg\ am\ Main",
"495234", "Horn\-Bad\ Meinberg",
"499294", "Regnitzlosau",
"496855", "Freisen",
"499144", "Pleinfeld",
"49631", "Kaiserslautern",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"499141", "Weissenburg\ in\ Bayern",
"495231", "Detmold",
"499358", "Gössenheim",
"497806", "Bad\ Peterstal\-Griesbach",
"494876", "Reher\ Holstein",
"493576", "Weisswasser",
"498031", "Rosenheim\ Oberbayern",
"492661", "Bad\ Marienberg\ Westerwald",
"494707", "Langen\-Neuenwalde",
"498581", "Waldkirchen\ Niederbayern",
"4935200", "Arnsdorf\ bei\ Dresden",
"497777", "Sauldorf",
"495320", "Torfhaus",
"499391", "Marktheidenfeld",
"495331", "Wolfenbüttel",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"498020", "Weyarn",
"49621", "Mannheim",
"4934691", "Könnern",
"494469", "Wangerooge",
"497972", "Gschwend\ bei\ Gaildorf",
"494902", "Jemgum\-Ditzum",
"495425", "Borgholzhausen",
"492554", "Laer\ Kreis\ Steinfurt",
"4936256", "Wechmar",
"499462", "Falkenstein\ Oberpfalz",
"495825", "Wieren",
"4937366", "Rübenau",
"497147", "Sachsenheim\ Württemberg",
"4939363", "Angern",
"499556", "Geiselwind",
"492973", "Eslohe\ Sauerland",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"493378", "Ludwigsfelde",
"4936845", "Gehlberg",
"495471", "Bohmte",
"493838", "Bergen\ auf\ Rügen",
"492739", "Wilnsdorf",
"496841", "Homburg\ Saar",
"492952", "Rüthen",
"498064", "Au\ bei\ Bad\ Aibling",
"496056", "Bad\ Soden\-Salmünster",
"492634", "Rengsdorf",
"492985", "Winterberg\-Niedersfeld",
"499725", "Poppenhausen\ Unterfranken",
"495303", "Wendeburg",
"495696", "Bad\ Arolsen\-Landau",
"497126", "Burladingen\-Melchingen",
"499636", "Plössberg",
"495264", "Kalletal",
"4939386", "Seehausen\ Altmark",
"497953", "Blaufelden",
"4938209", "Sanitz\ bei\ Rostock",
"4937383", "Lunzenau",
"494236", "Kirchlinteln",
"496441", "Wetzlar",
"494504", "Ratekau",
"492608", "Welschneudorf",
"4938454", "Kritzkow",
"497574", "Gammertingen",
"493996", "Teterow",
"493863", "Crivitz",
"494563", "Scharbeutz\-Haffkrug",
"495203", "Werther\ Westfalen",
"492593", "Ascheberg\ Westfalen",
"496162", "Reinheim\ Odenwald",
"494336", "Owschlag",
"492545", "Rosendahl\-Darfeld",
"4933361", "Joachimsthal",
"4939268", "Egeln",
"495364", "Velpke",
"495105", "Barsinghausen",
"4936425", "Isserstedt",
"499832", "Wassertrüdingen",
"4936926", "Creuzburg",
"499353", "Karlstadt",
"492620", "Neuhäusel\ Westerwald",
"495026", "Steimbke",
"495361", "Wolfsburg",
"4938391", "Altenkirchen\ Rügen",
"494839", "Wöhrden\ Dithmarschen",
"495492", "Steinfeld\ Oldenburg",
"498226", "Bibertal",
"494501", "Kastorf\ Holstein",
"494857", "Barlt",
"496444", "Bischoffen",
"499253", "Weissenstadt",
"494189", "Undeloh",
"497571", "Sigmaringen",
"495874", "Soltendieck",
"498542", "Ortenburg",
"493745", "Falkenstein\ Vogtland",
"495261", "Lemgo",
"4939320", "Schinne",
"4934465", "Bad\ Bibra",
"4937384", "Wechselburg",
"498326", "Fischen\ im\ Allgäu",
"495474", "Stemwede\-Dielingen",
"4938453", "Mistorf",
"492631", "Neuwied",
"498061", "Bad\ Aibling",
"499182", "Velburg",
"496844", "Blieskastel\-Altheim",
"499155", "Simmelsdorf",
"497265", "Angelbachtal",
"494328", "Rickling",
"494744", "Loxstedt",
"4939388", "Goldbeck\ Altm",
"494242", "Syke",
"494192", "Bad\ Bramstedt",
"4936087", "Wüstheuterode",
"496593", "Hillesheim\ Eifel",
"492162", "Viersen",
"4939857", "Drense",
"496545", "Blankenrath",
"4937430", "Eichigt",
"497163", "Ebersbach\ an\ der\ Fils",
"496757", "Becherbach\ bei\ Kirn",
"499199", "Kunreuth",
"499642", "Kemnath\ Stadt",
"495139", "Burgwedel",
"498677", "Burghausen\ Salzach",
"492841", "Moers",
"495650", "Cornberg",
"4939266", "Förderstedt",
"494342", "Preetz\ Kreis\ Plön",
"494174", "Stelle\ Kreis\ Harburg",
"492056", "Heiligenhaus",
"496634", "Gemünden\ Felda",
"498170", "Strasslach\-Dingharting",
"495157", "Emmerthal\-Börry",
"497365", "Essingen\ Württemberg",
"494526", "Ascheberg\ Holstein",
"4934342", "Neukieritzsch",
"4935937", "Prischwitz",
"499349", "Werbach\-Wenkheim",
"4933873", "Grosswudicke",
"492441", "Kall",
"499628", "Ursensollen",
"497138", "Schwaigern",
"492444", "Schleiden\-Gemünd",
"498338", "Böhen",
"499446", "Altmannstein",
"498263", "Breitenbrunn\ Schwaben",
"495948", "Itterbeck",
"4936928", "Neuenhof\ Thüringen",
"498304", "Wildpoldsried",
"498165", "Neufahrn\ bei\ Freising",
"499846", "Ipsheim",
"496631", "Alsfeld",
"495063", "Bad\ Salzdetfurth",
"494171", "Winsen\ Luhe",
"493329", "Stahnsdorf",
"492844", "Rheinberg\-Orsoy",
"4936207", "Plaue\ Thüringen",
"4933874", "Stechow\ Brandenburg",
"4938325", "Rolofshagen",
"4938202", "Volkenshagen",
"496127", "Niedernhausen\ Taunus",
"498363", "Pfronten",
"497475", "Burladingen",
"49391", "Magdeburg",
"498238", "Gessertshausen",
"494405", "Edewecht",
"496620", "Philippsthal\ Werra",
"495286", "Ottenstein\ Niedersachsen",
"495922", "Bad\ Bentheim",
"497949", "Pfedelbach\-Untersteinbach",
"499107", "Trautskirchen",
"494805", "Schafstedt",
"498702", "Wörth\ an\ der\ Isar",
"499965", "Sankt\ Englmar",
"498204", "Mickhausen",
"4935775", "Pechern",
"49561", "Kassel",
"498536", "Kösslarn",
"494741", "Nordholz\ bei\ Bremerhaven",
"4934202", "Delitzsch",
"49203", "Duisburg",
"498086", "Buchbach\ Oberbayern",
"493622", "Waltershausen\ Thüringen",
"4934325", "Mochau\-Lüttewitz",
"497432", "Albstadt\-Tailfingen",
"495903", "Emsbüren",
"492833", "Kerken",
"4938755", "Eldena",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"497577", "Veringenstadt",
"492385", "Hamm\-Rhynern",
"494851", "Marne",
"492352", "Altena\ Westfalen",
"498781", "Rottenburg\ an\ der\ Laaber",
"4936944", "Rentwertshausen",
"498067", "Tuntenhausen",
"494451", "Varel\ Jadebusen",
"492637", "Weissenthurm",
"492433", "Hückelhoven",
"493603", "Bad\ Langensalza",
"498723", "Arnstorf",
"497353", "Schwendi",
"497832", "Haslach\ im\ Kinzigtal",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"497182", "Welzheim",
"495367", "Rühen",
"4935895", "Klitten",
"49881", "Weilheim\ in\ Oberbayern",
"492252", "Zülpich",
"492754", "Bad\ Laasphe\-Feudingen",
"4939404", "Ausleben",
"492183", "Rommerskirchen",
"49841", "Ingolstadt\ Donau",
"494498", "Saterland\-Ramsloh",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"4939361", "Lüderitz",
"499571", "Lichtenfels\ Bayern",
"494936", "Grossheide",
"495964", "Lähden",
"497253", "Bad\ Schönborn",
"499574", "Marktzeuln",
"495961", "Haselünne",
"4938379", "Benz\ Usedom",
"499953", "Pilsting",
"4934298", "Taucha\ bei\ Leipzig",
"494733", "Butjadingen\-Burhave",
"499126", "Eckental",
"497636", "Münstertal\ Schwarzwald",
"492751", "Bad\ Berleburg",
"498382", "Lindau\ Bodensee",
"496106", "Rodgau",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"493661", "Greiz",
"497725", "Königsfeld\ im\ Schwarzwald",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"4934605", "Gröbers",
"495532", "Stadtoldendorf",
"495082", "Langlingen",
"495055", "Fassberg",
"495673", "Immenhausen\ Hessen",
"4936943", "Bettenhausen\ Thüringen",
"494454", "Jade",
"4938736", "Goldberg",
"498450", "Ingolstadt\-Zuchering",
"495706", "Porta\ Westfalica",
"496695", "Jesberg",
"498153", "Wessling",
"4939996", "Törpin",
"498282", "Krumbach\ Schwaben",
"496643", "Herbstein",
"494768", "Hipstedt",
"496447", "Langgöns\-Niederkleen",
"498784", "Hohenthann",
"494854", "Friedrichskoog",
"492378", "Fröndenberg\-Langschede",
"493973", "Pasewalk",
"499101", "Langenzenn",
"4936377", "Rastenberg",
"4935473", "Neu\ Lübbenau",
"496754", "Martinstein",
"494928", "Ihlow\-Riepe",
"498766", "Gammelsdorf",
"497051", "Calw",
"4939826", "Blankensee\ bei\ Neustrelitz",
"496252", "Heppenheim\ Bergstrasse",
"496285", "Walldürn\-Altheim",
"496659", "Eichenzell",
"496868", "Mettlach\-Tünsdorf",
"496183", "Erlensee",
"496468", "Dautphetal\-Mornshausen",
"497446", "Lossburg",
"494747", "Beverstedt",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"4933234", "Wustermark",
"4936332", "Ellrich",
"4939421", "Osterwieck",
"496385", "Reichenbach\-Steegen",
"496352", "Kirchheimbolanden",
"494942", "Südbrookmerland",
"499875", "Wolframs\-Eschenbach",
"499270", "Creussen",
"4933638", "Rüdersdorf\ bei\ Berlin",
"4935722", "Lauta\ bei\ Hoyerswerda",
"4933843", "Niemegk",
"496833", "Rehlingen\-Siersburg",
"497965", "Ellwangen\-Röhlingen",
"496433", "Hadamar",
"496130", "Schwabenheim\ an\ der\ Selz",
"4936701", "Lichte",
"495154", "Aerzen",
"494177", "Drage\ Elbe",
"496637", "Feldatal",
"495721", "Stadthagen",
"4938372", "Usedom",
"495222", "Bad\ Salzuflen",
"499163", "Dachsbach",
"497249", "Stutensee",
"4938296", "Rerik\ Ostseebad",
"497642", "Endingen\ Kaiserstuhl",
"4933233", "Ketzin",
"4936651", "Lobenstein",
"49234", "Bochum",
"494665", "Emmelsbüll\-Horsbüll",
"495724", "Obernkirchen",
"495151", "Hameln",
"492695", "Insul",
"4933844", "Brück\ Brandenburg",
"498671", "Altötting",
"492447", "Dahlem\ bei\ Kall",
"493686", "Eisfeld",
"496569", "Bickendorf",
"492643", "Altenahr",
"498022", "Tegernsee",
"499265", "Pressig",
"4939001", "Apenburg",
"4934296", "Groitzsch\ bei\ Pegau",
"49331", "Potsdam",
"495248", "Langenberg\ Kreis\ Gütersloh",
"498207", "Affing",
"495198", "Schneverdingen\-Wintermoor",
"4935474", "Schönwalde\ bei\ Lübben",
"497628", "Efringen\-Kirchen",
"495322", "Bad\ Harzburg",
"4935697", "Bagenz",
"496751", "Bad\ Sobernheim",
"4939600", "Zwiedorf",
"495546", "Scheden",
"497054", "Wildberg\ Württemberg",
"499365", "Rimpar",
"4938738", "Karow\ bei\ Lübz",
"499104", "Emskirchen",
"4939998", "Loitz\ bei\ Demmin",
"496124", "Bad\ Schwalbach",
"4938858", "Lassahn",
"497684", "Glottertal",
"497935", "Schrozberg",
"494923", "Krummhörn\-Pewsum",
"4933338", "Stolpe\/Oder",
"495527", "Duderstadt",
"4934672", "Rossleben",
"499076", "Wittislingen",
"496667", "Steinau\-Ulmbach",
"494156", "Talkau",
"4935264", "Strehla",
"496188", "Kahl\ am\ Main",
"499424", "Strasskirchen",
"4938229", "Bad\ Sülze",
"496838", "Saarwellingen",
"496404", "Lich\ Hessen",
"494541", "Ratzeburg",
"493841", "Wismar",
"492426", "Nörvenich",
"4934637", "Frankleben",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"4969", "Frankfurt\ am\ Main",
"498502", "Fürstenzell",
"4936042", "Tonna",
"492826", "Kranenburg\ Niederrhein",
"497045", "Oberderdingen",
"496804", "Mandelbachtal",
"493441", "Zeitz",
"499824", "Dietenhofen",
"496438", "Hünfelden",
"496557", "Hallschlag",
"496745", "Gondershausen",
"499180", "Pyrbaum",
"4933476", "Neuhardenberg",
"495775", "Diepenau",
"496373", "Schönenberg\-Kübelberg",
"494287", "Heeslingen\-Boitzen",
"499335", "Aub\ Kreis\ Würzburg",
"499421", "Straubing",
"494544", "Berkenthin",
"4939742", "Brüssow\ bei\ Pasewalk",
"493844", "Schwaan",
"496401", "Grünberg\ Hessen",
"498095", "Aying",
"497427", "Schömberg\ bei\ Balingen",
"496175", "Friedrichsdorf\ Taunus",
"494635", "Sörup",
"49291", "Meschede",
"499133", "Baiersdorf\ Mittelfranken",
"497623", "Rheinfelden\ Baden",
"495193", "Schneverdingen",
"499235", "Thierstein",
"495295", "Lichtenau\ Westfalen",
"495145", "Beedenbostel",
"492505", "Altenberge\ Westfalen",
"4938788", "Gross\ Warnow",
"4936025", "Körner",
"497681", "Waldkirch\ Breisgau",
"498043", "Jachenau",
"492622", "Bendorf\ am\ Rhein",
"4939922", "Dambeck\ bei\ Röbel",
"4935263", "Gröditz\ bei\ Riesa",
"492404", "Alsdorf\ Rheinland",
"493634", "Sömmerda",
"492838", "Sonsbeck",
"499406", "Mintraching",
"495908", "Wietmarschen\-Lohne",
"499777", "Ostheim\ von\ der\ Rhön",
"499397", "Wertheim\-Dertingen",
"4939929", "Jabel\ bei\ Waren",
"496426", "Fronhausen",
"495337", "Kissenbrück",
"495259", "Bad\ Driburg\-Neuenheerse",
"4938856", "Pritzier\ bei\ Hagenow",
"494340", "Achterwehr",
"495652", "Bad\ Sooden\-Allendorf",
"496826", "Bexbach",
"495934", "Haren\-Rütenbrock",
"495685", "Knüllwald",
"498344", "Westendorf\ bei\ Kaufbeuren",
"4933336", "Passow\ Kreis\ Uckermark",
"497358", "Eberhardzell\-Füramoos",
"4938393", "Binz\ Ostseebad",
"494966", "Neubörger",
"498728", "Geratskirchen",
"497141", "Ludwigsburg\ Württemberg",
"4938720", "Grebbin",
"496092", "Heimbuchenthal",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"492804", "Xanten\-Marienbaum",
"497556", "Uhldingen\-Mühlhofen",
"492863", "Velen",
"495044", "Springe\-Eldagsen",
"499147", "Nennslingen",
"4935384", "Steinsdorf\ bei\ Jessen",
"494445", "Visbek\ Kreis\ Vechta",
"494893", "Hohenaspe",
"4939749", "Grambow\ bei\ Pasewalk",
"495237", "Augustdorf",
"497462", "Immendingen",
"498194", "Vilgertshofen",
"497258", "Oberderdingen\-Flehingen",
"4938451", "Hoppenrade\ bei\ Güstrow",
"498742", "Velden\ Vils",
"499972", "Waldmünchen",
"494493", "Friesoythe\-Gehlenberg",
"494240", "Syke\-Heiligenfelde",
"494845", "Ostenfeld\ Husum",
"497771", "Stockach",
"492463", "Titz",
"497391", "Ehingen\ Donau",
"492667", "Stein\-Neukirch",
"496074", "Rödermark",
"4935796", "Panschwitz\-Kuckau",
"494609", "Eggebek",
"494202", "Achim\ bei\ Bremen",
"495456", "Westerkappeln\-Velpe",
"497774", "Eigeltingen",
"4933478", "Gross\ Neuendorf",
"494704", "Drangstedt",
"497272", "Rülzheim",
"496071", "Dieburg",
"497394", "Schelklingen",
"495562", "Dassel\-Markoldendorf",
"4934222", "Arzberg\ bei\ Torgau",
"498241", "Buchloe",
"498191", "Landsberg\ am\ Lech",
"4935383", "Elster\ Elbe",
"492175", "Leichlingen\ Rheinland",
"4938305", "Gingst",
"492273", "Kerpen\-Horrem",
"496505", "Kordel",
"4938222", "Semlow",
"499525", "Königsberg\ in\ Bayern",
"499602", "Neustadt\ an\ der\ Waldnaab",
"499209", "Emtmannsberg",
"496229", "Neckarsteinach",
"495041", "Springe\ Deister",
"4937381", "Penig",
"496622", "Bebra",
"498158", "Tutzing",
"497144", "Marbach\ am\ Neckar",
"4935057", "Hermsdorf\ Erzgebirge",
"492557", "Wettringen\ Kreis\ Steinfurt",
"492801", "Xanten",
"494302", "Kirchbarkau",
"495931", "Meppen",
"4936875", "Straufhain\-Streufdorf",
"492745", "Brachbach\ Sieg",
"498341", "Kaufbeuren",
"4938482", "Warin",
"492373", "Menden\ Sauerland",
"496329", "Weidenthal\ Pfalz",
"493631", "Nordhausen\ Thüringen",
"492401", "Baesweiler",
"4933363", "Altenhof\ Kreis\ Barnim",
"494763", "Gnarrenburg",
"497666", "Denzlingen",
"496648", "Bad\ Salzschlirf",
"496756", "Winterbach\ Soonwald",
"4939223", "Theessen",
"498764", "Mauern\ Kreis\ Freising",
"498262", "Mittelneufnach",
"4936458", "Bad\ Berka",
"498858", "Kochel\-Walchensee",
"4935754", "Klettwitz",
"498669", "Traunreut",
"495541", "Hann\.\ Münden",
"497844", "Rheinau",
"4937601", "Mülsen\ Skt\ Jacob",
"497444", "Alpirsbach",
"498458", "Gaimersheim",
"4939059", "Wegenstedt",
"4934978", "Radegast\ Kreis\ Köthen",
"496571", "Wittlich",
"495062", "Holle\ bei\ Hildesheim",
"4935603", "Burg\ Spreewald",
"494527", "Bosau",
"498362", "Füssen",
"4939483", "Ballenstedt",
"493681", "Suhl",
"495923", "Schüttorf",
"498703", "Essenbach",
"495156", "Coppenbrügge",
"4936375", "Kindelbrück",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"493623", "Friedrichroda",
"4938356", "Behrenhoff",
"495635", "Vöhl",
"4933836", "Butzow\ bei\ Brandenburg",
"499847", "Ergersheim",
"4934901", "Rosslau\ Elbe",
"494193", "Henstedt\-Ulzburg",
"495726", "Wiedensahl",
"494243", "Twistringen",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"492163", "Schwalmtal\ Niederrhein",
"496592", "Daun",
"4939484", "Harzgerode",
"493935", "Tangerhütte",
"492265", "Reichshof\-Eckenhagen",
"499447", "Essing",
"4935695", "Simmersdorf",
"494295", "Emtinghausen",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"497162", "Süssen",
"494343", "Laboe",
"4935753", "Grossräschen",
"497441", "Freudenstadt",
"496574", "Hasborn",
"4939224", "Büden",
"498537", "Bad\ Füssing\-Aigen",
"498761", "Moosburg\ an\ der\ Isar",
"492365", "Marl",
"492104", "Mettmann",
"495544", "Reinhardshagen",
"497841", "Achern",
"497056", "Gechingen",
"4935208", "Radeburg",
"4935604", "Krieschow",
"499106", "Markt\ Erlbach",
"494775", "Grossenwörden",
"497705", "Wolterdingen\ Schwarzw",
"496126", "Idstein",
"499833", "Heidenheim\ Mittelfranken",
"495445", "Drebber",
"494237", "Bendingbostel",
"499385", "Kolitzheim",
"4934976", "Gröbzig",
"499352", "Lohr\ am\ Main",
"496875", "Nonnweiler\-Primstal",
"4936964", "Dermbach\ Rhön",
"493774", "Schwarzenberg",
"496057", "Flörsbachtal",
"493679", "Neuhaus\ am\ Rennweg",
"493394", "Wittstock\ Dosse",
"497127", "Neckartenzlingen",
"499637", "Falkenberg\ Oberpfalz",
"496475", "Weilmünster\-Wolfenhausen",
"499433", "Nabburg",
"497620", "Schopfheim\-Gersbach",
"495190", "Soltau\-Emmingen",
"495845", "Bergen\ Dumme",
"4934743", "Ermsleben",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"499252", "Helmbrechts",
"499285", "Kirchenlamitz",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"499659", "Leuchtenberg",
"499868", "Schillingsfürst",
"494337", "Jevenstedt",
"497631", "Müllheim\ Baden",
"496589", "Kell\ am\ See",
"498543", "Aidenbach",
"496039", "Karben",
"496101", "Bad\ Vilbel",
"492571", "Greven\ Westfalen",
"493372", "Jüterbog",
"4938757", "Neustadt\-Glewe",
"4934923", "Cobbelsdorf",
"4939341", "Redekin",
"494934", "Marienhafe",
"499480", "Sünching",
"499183", "Burgthann",
"4939399", "Kleinau",
"499468", "Zell\ Oberpfalz",
"495966", "Meppen\-Apeldorn",
"494931", "Norden",
"499576", "Lichtenfels\-Isling",
"4937360", "Olbernhau",
"492953", "Wünnenberg",
"492574", "Saerbeck",
"4933989", "Sadenbeck",
"4935020", "Struppen",
"4936781", "Grossbreitenbach",
"496138", "Mommenheim",
"495302", "Vechelde",
"497952", "Gerabronn",
"497634", "Sulzburg",
"496104", "Heusenstamm",
"499278", "Weidenberg",
"495763", "Uchte",
"4933838", "Päwesin",
"497739", "Hilzingen",
"4934607", "Wettin",
"495027", "Linsburg",
"4934924", "Zahna",
"494562", "Grömitz",
"4939052", "Erxleben\ bei\ Haldensleben",
"4933657", "Steinsdorf\ Brandenburg",
"497545", "Immenstaad\ am\ Bodensee",
"4935206", "Kreischa\ bei\ Dresden",
"4936963", "Dorndorf\ Rhön",
"495609", "Ahnatal",
"495202", "Oerlinghausen",
"494456", "Varel\-Altjührden",
"493771", "Aue\ Sachsen",
"496163", "Höchst\ im\ Odenwald",
"495704", "Petershagen\-Friedewalde",
"498327", "Rettenberg",
"492592", "Selm",
"493391", "Neuruppin",
"496265", "Billigheim\ Baden",
"499378", "Eichenbühl\-Riedern",
"496888", "Lebach\-Steinbach",
"494920", "Wirdum",
"494856", "Kronprinzenkoog",
"4939201", "Wolmirstedt",
"499569", "Sesslach",
"4936602", "Ronneburg\ Thüringen",
"493909", "Klötze\ Altmark",
"493462", "Bad\ Dürrenberg",
"493636", "Greussen",
"492406", "Herzogenrath",
"4933084", "Gutengermendorf",
"492777", "Breitscheid\ Hessen",
"497661", "Kirchzarten",
"493725", "Zschopau",
"499404", "Nittendorf",
"4933671", "Lieberose",
"494367", "Grossenbrode",
"496424", "Ebsdorfergrund",
"499438", "Fensterbach",
"495936", "Twist",
"496824", "Ottweiler",
"498346", "Pforzen",
"499804", "Aurach",
"494964", "Rhede\ Ems",
"492994", "Marsberg\-Westheim",
"4937292", "Oederan",
"492297", "Wildbergerhütte",
"497554", "Heiligenberg\ Baden",
"495507", "Ebergötzen",
"495851", "Dahlenburg",
"498548", "Vilshofen\-Sandbach",
"497973", "Obersontheim",
"4939031", "Dähre",
"494267", "Lauenbrück",
"494903", "Wymeer",
"498196", "Pürgen",
"499463", "Wald\ Oberpfalz",
"498246", "Waal",
"499188", "Postbauer\-Heng",
"4933203", "Kleinmachnow",
"4937438", "Bad\ Brambach",
"4937324", "Reinsberg\ Sachsen",
"495451", "Ibbenbüren",
"492972", "Schmallenberg",
"496430", "Hahnstätten",
"494673", "Joldelund",
"496133", "Oppenheim",
"4936731", "Unterloquitz",
"495454", "Hörstel\-Riesenbeck",
"494706", "Schiffdorf",
"494477", "Lastrup\-Hemmelte",
"499175", "Spalt",
"4934771", "Querfurt",
"492958", "Büren\-Harth",
"494532", "Bargteheide",
"492602", "Montabaur",
"4933204", "Beelitz\ Mark",
"499089", "Bissingen\-Unterringingen",
"49365", "Gera",
"494877", "Hennstedt\ bei\ Itzehoe",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"495768", "Petershagen\-Heimsen",
"4933608", "Jacobsdorf\ Mark",
"492525", "Beckum\-Neubeckum",
"496235", "Schifferstadt",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"497551", "Überlingen\ Bodensee",
"497807", "Neuried\ Ortenaukreis",
"4937323", "Lichtenberg\ Erzgebirge",
"495854", "Bleckede\-Barskamp",
"496483", "Selters\ Taunus",
"4934658", "Hayn\ Harz",
"497146", "Remseck\ am\ Neckar",
"492991", "Marsberg\-Bredelar",
"499745", "Wildflecken",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"496821", "Neunkirchen\ Saar",
"4938307", "Poseritz",
"494961", "Papenburg",
"4938872", "Rehna",
"499401", "Neutraubling",
"4936920", "Grossenlupnitz",
"496421", "Marburg",
"492309", "Waltrop",
"495733", "Vlotho",
"496335", "Trulben",
"497664", "Freiburg\-Tiengen",
"499373", "Amorbach",
"495942", "Uelsen",
"496297", "Ravenstein\ Baden",
"496147", "Trebur",
"498332", "Ottobeuren",
"4933977", "Gumtow",
"4934635", "Bad\ Lauchstädt",
"499074", "Höchstädt\ an\ der\ Donau",
"494721", "Cuxhaven",
"49721", "Karlsruhe",
"498657", "Ramsau\ bei\ Berchtesgaden",
"494154", "Trittau",
"4935244", "Krögis",
"498453", "Reichertshofen\ Oberbayern",
"495177", "Edemissen\-Abbensen",
"498232", "Schwabmünchen",
"496397", "Leimen\ Pfalz",
"498639", "Neumarkt\-Sankt\ Veit",
"499426", "Oberschneiding",
"496406", "Lollar",
"4937436", "Weischlitz",
"498734", "Reisbach\ Niederbayern",
"4937464", "Schöneck\ Vogtland",
"4939727", "Spantekow",
"492424", "Vettweiss",
"4933452", "Neulewin",
"493628", "Arnstadt",
"4933932", "Fehrbellin",
"49731", "Ulm\ Donau",
"4934385", "Mutzschen",
"495555", "Moringen\-Fredelsloh",
"495582", "Sankt\ Andreasberg",
"499092", "Wemding",
"495032", "Neustadt\ am\ Rübenberge",
"492824", "Kalkar",
"4939953", "Schwinkendorf",
"496806", "Heusweiler",
"498708", "Weihmichl\-Unterneuhausen",
"499826", "Weidenbach\ Mittelfranken",
"492687", "Horhausen\ Westerwald",
"49811", "Hallbergmoos",
"4936027", "Lengenfeld\ Unterm\ Stein",
"494248", "Bassum\-Neubruchhausen",
"4933606", "Müllrose",
"492821", "Kleve\ Niederrhein",
"494322", "Bordesholm",
"4937463", "Bergen\ Vogtland",
"4939328", "Rochau",
"497250", "Kraichtal",
"492421", "Düren",
"497455", "Dornhan",
"499648", "Neustadt\ am\ Kulm",
"497482", "Horb\-Dettingen",
"494546", "Mustin\ Lauenburg",
"492335", "Wetter\ Ruhr",
"498731", "Dingolfing",
"4939954", "Stavenhagen\ Reuterstadt",
"494151", "Schwarzenbek",
"49991", "Deggendorf",
"492133", "Dormagen",
"494222", "Ganderkesee",
"4939861", "Gramzow\ bei\ Prenzlau",
"499071", "Dillingen\ an\ der\ Donau",
"494348", "Schönkirchen",
"495665", "Guxhagen",
"494724", "Cuxhaven\-Lüdingworth",
"499229", "Mainleus",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"497132", "Neckarsulm",
"499622", "Hirschau\ Oberpfalz",
"496209", "Mörlenbach",
"496525", "Irrel",
"492235", "Erftstadt",
"4935243", "Weinböhla",
"493965", "Burow\ bei\ Altentreptow",
"499505", "Litzendorf",
"494967", "Rhauderfehn\-Burlage",
"494203", "Weyhe\ bei\ Bremen",
"4936783", "Gehren\ Thüringen",
"499551", "Burgwindheim",
"496827", "Eppelborn",
"497273", "Hagenbach\ Pfalz",
"496681", "Hilders",
"4939084", "Lindstedt",
"495563", "Kreiensen",
"4939344", "Güsen",
"492272", "Bedburg\ Erft",
"492394", "Neuenrade\-Affeln",
"4938232", "Zingst\ Ostseebad",
"492774", "Dietzhölztal",
"496427", "Cölbe\-Schönstadt",
"495336", "Semmenstedt",
"498388", "Hergensweiler",
"497175", "Leinzell",
"499603", "Floss",
"499396", "Urspringen\ bei\ Lohr",
"494364", "Dahme\ Kreis\ Ostholstein",
"496623", "Rotenburg\ an\ der\ Fulda",
"494105", "Seevetal",
"499407", "Wenzenbach",
"499776", "Mellrichstadt",
"4933769", "Töpchin",
"499664", "Hahnbach",
"4934498", "Rositz",
"498465", "Kipfenberg",
"497373", "Zwiefalten",
"494303", "Schlesen",
"4936961", "Bad\ Liebenstein",
"494471", "Cloppenburg",
"498586", "Hauzenberg",
"495060", "Bodenburg",
"492666", "Freilingen\ Westerwald",
"498036", "Stephanskirchen\ Simssee",
"49208", "Oberhausen\ Rheinland",
"497557", "Herdwangen\-Schönach",
"495504", "Friedland\ Kreis\ Göttingen",
"4938825", "Klütz",
"492372", "Hemer",
"493571", "Hoyerswerda",
"494871", "Hohenwestedt",
"492294", "Morsbach\ Sieg",
"494264", "Sottrum\ Kreis\ Rotenburg",
"4939203", "Barleben",
"4937206", "Frankenberg\ Sachsen",
"497745", "Jestetten",
"495236", "Blomberg\-Grossenmarpe",
"494762", "Kutenholz",
"499146", "Markt\ Berolzheim",
"492358", "Meinerzhagen\-Valbert",
"4936847", "Steinbach\-Hallenberg",
"494261", "Rotenburg\ Wümme",
"496045", "Gedern",
"497804", "Oppenau",
"495857", "Bleckede\-Brackede",
"492291", "Waldbröl",
"494874", "Todenbüttel",
"493574", "Lauchhammer",
"495653", "Sontra",
"4939608", "Staven",
"4934741", "Frose",
"497838", "Nordrach",
"4939459", "Hasselfelde",
"494474", "Garrel",
"4939888", "Lychen",
"495457", "Hopsten\-Schale",
"497404", "Epfendorf",
"499661", "Sulzbach\-Rosenberg",
"496093", "Laufach",
"4939204", "Niederndodeleben",
"4936784", "Stützerbach",
"494361", "Oldenburg\ in\ Holstein",
"492862", "Südlohn",
"492391", "Plettenberg",
"497667", "Breisach\ am\ Rhein",
"494892", "Schenefeld\ Mittelholstein",
"493592", "Kirschau",
"4939083", "Messdorf",
"499499", "Painten",
"492771", "Dillenburg",
"498375", "Weitnau",
"497463", "Mühlheim\ an\ der\ Donau",
"495439", "Bersenbrück",
"492556", "Metelen",
"495839", "Wittingen\-Ohrdorf",
"496684", "Hofbieber\-Schwarzbach",
"499973", "Furth\ im\ Wald",
"494492", "Saterland",
"498743", "Geisenhausen",
"4937346", "Geyer",
"4934921", "Kemberg",
"496789", "Heimbach\ Nahe",
"4939343", "Jerichow",
"499554", "Untersteinbach\ Unterfranken",
"4938842", "Lüttenmark",
"492462", "Linnich",
"4939295", "Zuchau",
"4936645", "Mühltroff",
"499077", "Bachhagel",
"497329", "Steinheim\ am\ Albuch",
"495174", "Lahstedt",
"4934903", "Coswig\ Anhalt",
"495228", "Vlotho\-Exter",
"496666", "Freiensteinau",
"499482", "Wörth\ an\ der\ Donau",
"498654", "Freilassing",
"496372", "Bruchmühlbach\-Miesau",
"496294", "Krautheim\ Jagst",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"499855", "Dentlein\ am\ Forst",
"494489", "Apen",
"498028", "Fischbachau",
"4939977", "Jördenstorf",
"492827", "Goch\-Hassum",
"497505", "Fronreute",
"4939452", "Ilsenburg",
"4937604", "Mosel",
"4935751", "Welzow",
"495328", "Altenau\ Harz",
"4937208", "Auerswalde",
"495744", "Hüllhorst",
"497229", "Iffezheim",
"492681", "Altenkirchen\ Westerwald",
"495242", "Rheda\-Wiedenbrück",
"495192", "Munster",
"498561", "Pfarrkirchen\ Niederbayern",
"499132", "Herzogenaurach",
"4933433", "Buckow\ Märkische\ Schweiz",
"497622", "Schopfheim",
"4934496", "Nöbdenitz",
"496774", "Kaub",
"496272", "Hirschhorn\ Neckar",
"497071", "Tübingen",
"494139", "Hohnstorf\ Elbe",
"499350", "Eussenheim\-Hundsbach",
"496394", "Bundenthal",
"4939932", "Malchow\ bei\ Waren",
"49791", "Schwäbisch\ Hall",
"493475", "Lutherstadt\ Eisleben",
"492623", "Ransbach\-Baumbach",
"498042", "Lenggries",
"4933965", "Herzsprung\ bei\ Wittstock",
"4939820", "Triepkendorf",
"492427", "Nideggen",
"493949", "Oschersleben\ Bode",
"4938792", "Lenzen\ \(Elbe\)",
"4939886", "Milmersdorf",
"496258", "Gernsheim",
"4937603", "Wildenfels",
"4939606", "Glienke",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"4939221", "Möckern\ bei\ Magdeburg",
"494286", "Gyhum",
"494922", "Borkum",
"496771", "St\ Goarshausen",
"4936622", "Triebes",
"4933434", "Herzfelde\ bei\ Strausberg",
"49921", "Bayreuth",
"496391", "Dahn",
"4937754", "Zwönitz",
"49461", "Flensburg",
"4935601", "Peitz",
"495741", "Lübbecke",
"493860", "Raben\ Steinfeld",
"496556", "Pronsfeld",
"498564", "Johanniskirchen",
"492684", "Puderbach\ Westerwald",
"4933762", "Zeuthen",
"492935", "Sundern\-Hachen",
"495805", "Oetzen",
"492590", "Dülmen\-Buldern",
"49906", "Donauwörth",
"499929", "Ruhmannsfelden",
"496462", "Gladenbach",
"497950", "Schnelldorf",
"492045", "Bottrop\-Kirchhellen",
"497826", "Schuttertal",
"4939481", "Hedersleben\ bei\ Aschersleben",
"496358", "Kriegsfeld",
"494948", "Wiesmoor\-Marcardsmoor",
"4937348", "Oberwiesenthal\ Kurort",
"496291", "Adelsheim",
"4934904", "Oranienbaum",
"498503", "Neuhaus\ am\ Inn",
"49931", "Würzburg",
"495171", "Peine",
"498651", "Bad\ Reichenhall",
"495300", "Salzgitter\-Üfingen",
"497426", "Gosheim",
"498081", "Dorfen\ Stadt",
"497643", "Herbolzheim\ Breisgau",
"494746", "Hagen\ bei\ Bremerhaven",
"499162", "Scheinfeld",
"495223", "Bünde",
"498531", "Pocking",
"497447", "Baiersbronn\-Schwarzenberg",
"4935935", "Kleinwelka",
"498023", "Bayrischzell",
"495281", "Bad\ Pyrmont",
"492642", "Remagen",
"4935455", "Walddrehna",
"494169", "Sauensiek",
"4939246", "Lindau\ Anh",
"494176", "Marschacht",
"496636", "Romrod",
"492054", "Essen\-Kettwig",
"496725", "Gau\-Algesheim",
"495323", "Clausthal\-Zellerfeld",
"4939863", "Seehausen\ bei\ Prenzlau",
"499841", "Bad\ Windsheim",
"4939855", "Parmen\-Weggun",
"494524", "Scharbeutz\-Pönitz",
"4935241", "Lommatzsch",
"495381", "Seesen",
"4936085", "Reinholterode",
"4934362", "Mügeln\ bei\ Oschatz",
"499441", "Kelheim",
"492628", "Rhens",
"498809", "Wessobrunn",
"4938728", "Domsühl",
"4934327", "Waldheim\ Sachsen",
"492446", "Heimbach\ Eifel",
"495384", "Seesen\-Gross\ Rhüden",
"493821", "Ribnitz\-Damgarten",
"494521", "Eutin",
"4938429", "Glasin",
"499444", "Siegenburg",
"496253", "Fürth\ Odenwald",
"496182", "Seligenstadt",
"498306", "Ronsberg",
"499844", "Obernzenn",
"496155", "Griesheim\ Hessen",
"493421", "Torgau",
"492051", "Velbert",
"497025", "Neuffen",
"493335", "Finowfurt",
"493883", "Hagenow",
"4938327", "Elmenhorst\ Vorpom",
"4933470", "Lietzen",
"4936205", "Gräfenroda",
"494943", "Grossefehn",
"496353", "Freinsheim",
"495755", "Kalletal\-Varenholz",
"495284", "Schwalenberg",
"496832", "Beckingen\-Reimsbach",
"496432", "Diez",
"4939951", "Faulenrost",
"498206", "Egling\ an\ der\ Paar",
"4935436", "Laasow\ bei\ Calau",
"498534", "Tettenweis",
"498084", "Taufkirchen\ Vils",
"4935323", "Sonnewalde",
"497751", "Waldshut",
"492725", "Lennestadt\-Oedingen",
"4936427", "Dornburg\ Saale",
"498321", "Sonthofen",
"4939034", "Fleetmark",
"499090", "Rain\ Lech",
"498066", "Bad\ Feilnbach",
"492636", "Burgbrohl",
"496054", "Birstein",
"4934773", "Schwittersdorf",
"495694", "Diemelstadt",
"495379", "Sassenburg\-Grussendorf",
"4936733", "Kaulsdorf",
"498435", "Ehekirchen",
"499952", "Eichendorf",
"494208", "Grasberg",
"497124", "Trochtelfingen\ Hohenz",
"499634", "Wiesau",
"495266", "Lemgo\-Kirchheide",
"4937321", "Frankenstein\ Sachsen",
"496628", "Oberaula",
"498230", "Gablingen",
"494732", "Stadland\-Rodenkirchen",
"499608", "Kohlberg\ Oberpfalz",
"496349", "Billigheim\-Ingenheim",
"494234", "Dörverden",
"494959", "Dollart",
"498383", "Grünenbach\ Allgäu",
"494506", "Stockelsdorf\-Krumbeck",
"497576", "Krauchenwies",
"493994", "Malchin",
"4933674", "Trebatsch",
"4938850", "Gammelin",
"497569", "Isny\-Eisenbach",
"4934422", "Osterfeld",
"495083", "Hohne\ bei\ Celle",
"498221", "Günzburg",
"495533", "Bodenwerder",
"4938726", "Spornitz",
"494308", "Schwedeneck",
"495672", "Bad\ Karlshafen",
"498152", "Herrsching\ am\ Ammersee",
"496249", "Guntersblum",
"494334", "Bredenbek\ bei\ Rendsburg",
"495021", "Nienburg\ Weser",
"4939248", "Dobritz",
"496642", "Schlitz",
"498283", "Neuburg\ an\ der\ Kammel",
"495366", "Jembke",
"498330", "Legau",
"4938422", "Neukloster",
"499545", "Buttenheim",
"497433", "Balingen",
"497130", "Löwenstein\ Württemberg",
"496107", "Kelsterbach",
"495902", "Freren",
"499127", "Rosstal\ Mittelfranken",
"494425", "Wangerland\-Hooksiel",
"4933673", "Weichensdorf",
"492832", "Kevelaer",
"494331", "Rendsburg",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"492353", "Halver",
"4934467", "Eckartsberga",
"4938780", "Lanz\ Brandenburg",
"492432", "Wassenberg",
"497385", "Gomadingen",
"497352", "Ochsenhausen",
"498722", "Gangkofen",
"494825", "Burg\ Dithmarschen",
"498178", "Icking",
"493525", "Riesa",
"498224", "Offingen\ Donau",
"497833", "Hornberg\ Schwarzwaldbahn",
"495658", "Wehretal",
"497183", "Rudersberg\ Württemberg",
"496446", "Hohenahr",
"4939033", "Wallstawe",
"493991", "Waren\ Müritz",
"4936766", "Schalkau",
"4935324", "Crinitz",
"4933052", "Leegebruch",
"492253", "Bad\ Münstereifel",
"4936734", "Leutenberg",
"4934445", "Stössen",
"4934774", "Röblingen\ am\ See",
"494231", "Verden\ Aller",
"499631", "Tirschenreuth",
"497121", "Reutlingen",
"4936462", "Ossmannstedt",
"492182", "Grevenbroich\-Kapellen",
"495691", "Bad\ Arolsen",
"498324", "Hindelang",
"497754", "Görwihl",
"495707", "Petershagen\ Weser",
"495476", "Ostercappeln\-Venne",
"499978", "Schönthal\ Oberpfalz",
"4933201", "Gross\ Glienicke",
"497252", "Bretten",
"496051", "Gelnhausen",
"494320", "Heidmühlen",
"492738", "Netphen",
"494539", "Westerau",
"497203", "Walzbachtal",
"497967", "Jagstzell",
"494273", "Kirchdorf\ bei\ Sulingen",
"496387", "Sankt\ Julian",
"4936083", "Uder",
"496635", "Kirtorf",
"494175", "Egestorf\ Nordheide",
"4939396", "Neukirchen\ Altmark",
"4939853", "Holzendorf\ bei\ Prenzlau",
"496726", "Lorch\ Rheingau",
"497364", "Oberkochen",
"499673", "Tiefenbach\ Oberpfalz",
"499082", "Oettingen\ in\ Bayern",
"495592", "Gleichen\-Bremke",
"498161", "Freising",
"499532", "Maroldsweisach",
"4938352", "Kemnitz\ bei\ Greifswald",
"4933920", "Walsleben\ bei\ Neuruppin",
"492202", "Bergisch\ Gladbach",
"4933832", "Rogäsen",
"492763", "Drolshagen\-Bleche",
"4935453", "Drahnsdorf",
"497471", "Hechingen",
"494401", "Brake\ Unterweser",
"496544", "Rhaunen",
"496287", "Limbach\ Baden",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"4933731", "Trebbin",
"4939058", "Uthmöden",
"494793", "Hambergen",
"498442", "Wolnzach",
"495126", "Algermissen",
"497303", "Illertissen",
"49335", "Frankfurt\ \(Oder\)",
"4936459", "Blankenhain\ Thüringen",
"494745", "Bad\ Bederkesa",
"495953", "Börger",
"4936608", "Seelingstädt\ bei\ Gera",
"497264", "Bad\ Rappenau",
"497762", "Wehr\ Baden",
"492302", "Witten",
"494557", "Blunk",
"493501", "Pirna",
"499961", "Mitterfels",
"4933877", "Nitzahn",
"4936204", "Stotternheim",
"495574", "Oberweser",
"49760", "Oberried\ Breisgau",
"4935933", "Neschwitz",
"499964", "Stallwang",
"493504", "Dippoldiswalde",
"494804", "Nordhastedt",
"498205", "Dasing",
"4935454", "Uckro",
"495571", "Uslar",
"4934381", "Colditz",
"497261", "Sinsheim",
"496062", "Erbach\ Odenwald",
"4935209", "Mohorn",
"497474", "Haigerloch",
"4935934", "Grossdubrau",
"494838", "Tellingstedt",
"4936203", "Vieselbach",
"499367", "Unterpleichfeld",
"496541", "Traben\-Trarbach",
"494404", "Elsfleth",
"494667", "Dagebüll",
"494188", "Welle\ Nordheide",
"494463", "Wangerland",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"4936084", "Heuthen",
"497026", "Lenningen",
"492845", "Neukirchen\-Vluyn",
"497361", "Aalen",
"492697", "Blankenheim\-Ahrhütte",
"4939854", "Kleptow",
"492445", "Schleiden\ Eifel",
"499903", "Schöllnach",
"499267", "Nordhalben",
"493563", "Spremberg",
"494863", "Sankt\ Peter\-Ording",
"4939398", "Gross\ Garz",
"494329", "Langwedel\ Holstein",
"495365", "Wolfsburg\-Neindorf",
"497157", "Waldenbuch",
"496763", "Kirchberg\ Hunsrück",
"4936481", "Neustadt\ an\ der\ Orla",
"499546", "Burgebrach",
"496027", "Stockstadt\ am\ Main",
"496302", "Winnweiler",
"495138", "Sehnde",
"499198", "Heiligenstadt\ in\ Oberfranken",
"493741", "Plauen",
"4936606", "Kraftsdorf",
"495265", "Dörentrup",
"494622", "Taarstedt",
"492387", "Drensteinfurt\-Walstedde",
"494505", "Stockelsdorf\-Curau",
"497575", "Messkirch",
"4934775", "Wippra",
"4934444", "Lützen",
"49491", "Leer\ Ostfriesland",
"492635", "Rheinbrohl",
"492984", "Hallenberg",
"498065", "Tuntenhausen\-Schönau",
"499151", "Hersbruck",
"4936735", "Probstzella",
"4939056", "Klüden",
"499724", "Stadtlauringen",
"496202", "Schwetzingen",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"499348", "Werbach\-Gamburg",
"497139", "Neuenstadt\ am\ Kocher",
"495163", "Fallingbostel\-Dorfmark",
"499222", "Presseck",
"496704", "Langenlonsheim",
"4935202", "Klingenberg\ Sachsen",
"499721", "Schweinfurt",
"492156", "Willich\-Anrath",
"496701", "Sprendlingen\ Rheinhessen",
"4936452", "Berlstedt",
"495475", "Bohmte\-Hunteburg",
"496697", "Willingshausen",
"499154", "Pommelsbrunn",
"496190", "Hattersheim\ am\ Main",
"492981", "Winterberg\ Westfalen",
"496893", "Saarbrücken\-Ensheim",
"496445", "Schöffengrund",
"498257", "Inchenhofen",
"4934443", "Teuchern",
"495875", "Emmendorf",
"4939035", "Kuhfelde",
"493328", "Teltow",
"493744", "Auerbach\ Vogtland",
"492923", "Lippetal\-Herzfeld",
"49761", "Freiburg\ im\ Breisgau",
"498573", "Ering",
"494826", "Hohenlockstedt",
"4933839", "Wusterwitz",
"496340", "Wörth\-Schaidt",
"494950", "Holtland",
"497386", "Hayingen",
"497948", "Öhringen\-Ohrnberg",
"498239", "Langenneufnach",
"4935342", "Mühlberg\ Elbe",
"497727", "Vöhrenbach",
"494426", "Wangerland\-Horumersiel",
"4934261", "Kühren\ bei\ Wurzen",
"492541", "Coesfeld",
"493342", "Neuenhagen\ bei\ Berlin",
"499099", "Kaisheim",
"497063", "Bad\ Wimpfen",
"4933675", "Tauche",
"4938457", "Krakow\ am\ See",
"495101", "Pattensen",
"4939205", "Langenweddingen",
"496599", "Weidenbach\ bei\ Gerolstein",
"4939322", "Tangermünde",
"497746", "Wutöschingen",
"4938823", "Selmsdorf",
"494643", "Gelting\ Angeln",
"4937439", "Jocketa",
"499145", "Solnhofen",
"496854", "Oberthal\ Saar",
"499295", "Töpen",
"495235", "Blomberg\ Lippe",
"494447", "Vechta\-Langförden",
"499243", "Pottenstein",
"498466", "Denkendorf\ Oberbayern",
"496454", "Lichtenfels\-Sachsenberg",
"499193", "Höchstadt\ an\ der\ Aisch",
"494847", "Oster\-Ohrstedt",
"498035", "Raubling",
"498552", "Grafenau\ Niederbayern",
"498585", "Grainet",
"4939294", "Gross\ Rosenburg",
"493987", "Templin",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"499395", "Triefenstein",
"497176", "Spraitbach",
"495335", "Schladen",
"496733", "Gau\-Odernheim",
"499775", "Schönau\ an\ der\ Brend",
"494106", "Quickborn\ Kreis\ Pinneberg",
"495883", "Lemgow",
"495168", "Walsrode\-Stellichte",
"495483", "Lienen",
"4938876", "Roggendorf",
"499343", "Lauda\-Königshofen",
"4936785", "Gräfinau\-Angstedt",
"497524", "Bad\ Waldsee",
"495821", "Bad\ Bevensen",
"495824", "Bad\ Bodenteich",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"492582", "Everswinkel",
"498269", "Unteregg\ bei\ Mindelheim",
"493381", "Brandenburg\ an\ der\ Havel",
"492555", "Schöppingen",
"4939293", "Dreileben",
"4937296", "Stollberg\ Erzgebirge",
"492747", "Molzhain",
"4939345", "Parchen",
"495069", "Nordstemmen",
"497583", "Bad\ Schussenried",
"492928", "Soest\-Ostönnen",
"497033", "Weil\ Der\ Stadt",
"4939085", "Zichtau",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"495424", "Bad\ Rothenfelde",
"496898", "Völklingen",
"498376", "Sulzberg\ Allgäu",
"497943", "Schöntal\ Jagst",
"4933609", "Brieskow\-Finkenheerd",
"4935032", "Langenhennersdorf",
"4933458", "Falkenberg\ Mark",
"498369", "Rückholz",
"496451", "Frankenberg\ Eder",
"4938824", "Mallentin",
"499527", "Knetzgau",
"496046", "Ortenberg\ Hessen",
"492942", "Geseke",
"496507", "Neumagen\-Dhron",
"496851", "St\ Wendel",
"498276", "Baar\ Schwaben",
"495309", "Lehre\-Wendhausen",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"498423", "Titting",
"494124", "Glückstadt",
"493691", "Eisenach\ Thüringen",
"494751", "Otterndorf",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"4937755", "Schönheide\ Erzgebirge",
"492733", "Hilchenbach",
"497506", "Wangen\-Leupolz",
"4933602", "Alt\ Zeschdorf",
"4933435", "Rehfelde",
"4939007", "Tangeln",
"493876", "Perleberg",
"499931", "Plattling",
"497732", "Radolfzell\ am\ Bodensee",
"497959", "Frankenhardt",
"497234", "Tiefenbronn",
"498823", "Mittenwald",
"499856", "Dürrwangen",
"497308", "Nersingen",
"492599", "Ascheberg\-Herbern",
"499920", "Bischofsmais",
"495209", "Gütersloh\-Friedrichsdorf",
"497937", "Dörzbach",
"495602", "Hessisch\ Lichtenau",
"4934652", "Allstedt",
"495525", "Walkenried",
"4935691", "Bärenklau\ NL",
"49871", "Landshut",
"493869", "Dümmer",
"4934905", "Wörlitz",
"493902", "Diesdorf\ Altm",
"492454", "Gangelt",
"498131", "Dachau",
"499562", "Sonnefeld",
"4936643", "Thimmendorf",
"497334", "Deggingen",
"496665", "Sinntal\-Altengronau",
"497331", "Geislingen\ an\ der\ Steige",
"493366", "Beeskow",
"499359", "Karlstadt\-Wiesenfeld",
"494433", "Dötlingen",
"496670", "Ludwigsau\ Hessen",
"498134", "Odelzhausen",
"4936371", "Schlossvippach",
"497425", "Trossingen",
"494637", "Sterup",
"492451", "Geilenkirchen",
"497220", "Forbach\-Hundsbach",
"497825", "Kippenheim",
"494352", "Damp",
"492507", "Havixbeck",
"492851", "Rees",
"494385", "Hohenfelde\ bei\ Kiel",
"4938331", "Rakow\ Vorpom",
"4937298", "Oelsnitz\ Erzgebirge",
"493533", "Elsterwerda",
"495147", "Uetze\-Hänigsen",
"494833", "Wesselburen",
"4935827", "Nieder\-Seifersdorf",
"493672", "Rudolstadt",
"4936644", "Hirschberg\ Saale",
"4939427", "Ströbeck",
"496032", "Bad\ Nauheim",
"497231", "Pforzheim",
"496582", "Freudenburg",
"4933964", "Fretzdorf",
"496555", "Bleialf",
"494468", "Friedeburg\-Reepsholt",
"495806", "Barum\ bei\ Bad\ Bevensen",
"494183", "Jesteburg",
"494480", "Ovelgönne\-Strückhausen",
"499652", "Waidhaus",
"496747", "Emmelshausen",
"499337", "Gaukönigshofen",
"494754", "Bülkau",
"4939329", "Möringen",
"4933456", "Wriezen",
"494285", "Rhade\ bei\ Zeven",
"495777", "Diepenau\-Essern",
"495406", "Belm",
"499908", "Schöfweg",
"494252", "Bruchhausen\-Vilsen",
"4937605", "Hartenstein\ Sachsen",
"493379", "Mahlow",
"4937432", "Pausa\ Vogtland",
"494121", "Elmshorn",
"4936628", "Zeulenroda",
"498245", "Türkheim\ Wertach",
"496653", "Burghaun",
"4935054", "Lauenstein\ Sachsen",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"493544", "Luckau\ Brandenburg",
"494844", "Pellworm",
"492171", "Leverkusen\-Opladen",
"496457", "Burgwald\ Eder",
"4933205", "Michendorf",
"495045", "Springe\-Bennigsen",
"494444", "Goldenstedt",
"496501", "Konz",
"496857", "Namborn",
"4934441", "Hohenmölsen",
"499521", "Hassfurt",
"498143", "Inning\ am\ Ammersee",
"498293", "Welden\ bei\ Augsburg",
"4933768", "Prieros",
"495684", "Frielendorf",
"495935", "Twist\-Schöninghsdorf",
"492741", "Betzdorf",
"498345", "Stöttwang",
"499080", "Harburg\ Schwaben",
"497527", "Wolfegg",
"4936484", "Knau\ bei\ Pössneck",
"4937342", "Cranzahl",
"492405", "Würselen",
"493984", "Prenzlau",
"493635", "Kölleda",
"493726", "Flöha",
"4934263", "Hohburg",
"498393", "Holzgünz",
"496439", "Holzappel",
"499943", "Lam\ Oberpfalz",
"498773", "Neufahrn\ in\ Niederbayern",
"493981", "Neustrelitz",
"4936483", "Ziegenrück",
"495427", "Melle\-Buer",
"496336", "Dellfeld",
"4935387", "Seyda",
"497243", "Ettlingen",
"497193", "Sulzbach\ an\ der\ Murr",
"495623", "Edertal",
"497145", "Markgröningen",
"494162", "Jork",
"499746", "Zeitlofs",
"495827", "Unterlüss",
"496563", "Kyllburg",
"492192", "Hückeswagen",
"495681", "Homberg\ Efze",
"492242", "Hennef\ Sieg",
"4933085", "Seilershof",
"492744", "Herdorf",
"493923", "Zerbst",
"496504", "Thalfang",
"4937202", "Claussnitz\ bei\ Chemnitz",
"494441", "Vechta",
"4937325", "Niederbobritzsch",
"4935053", "Glashütte\ Sachsen",
"499524", "Zeil\ am\ Main",
"497343", "Buch\ bei\ Illertissen",
"498402", "Münchsmünster",
"4939889", "Boitzenburg",
"4939458", "Heudeber",
"496236", "Neuhofen\ Pfalz",
"492526", "Sendenhorst",
"497775", "Mühlingen",
"497395", "Ehingen\-Dächingen",
"499176", "Allersberg",
"498802", "Huglfing",
"494705", "Wremen",
"4933367", "Friedrichswalde\ Brandenburg",
"492228", "Remagen\-Rolandseck",
"492174", "Burscheid\ Rheinland",
"494841", "Husum\ Nordsee",
"493541", "Calau",
"496741", "St\ Goar",
"4933734", "Felgentreu",
"4939955", "Jürgenstorf",
"497044", "Mönsheim",
"492839", "Straelen\-Herongen",
"495556", "Lindau\ Harz",
"497237", "Neulingen\ Enzkreis",
"4934383", "Trebsen\ Mulde",
"496805", "Kleinblittersdorf",
"495909", "Wettrup",
"499825", "Herrieden",
"499220", "Kasendorf\-Azendorf",
"4933766", "Teupitz",
"495462", "Ankum",
"495862", "Hitzacker\ Elbe",
"498624", "Obing",
"4936626", "Auma",
"494127", "Westerhorn",
"495258", "Salzkotten",
"4936201", "Walschleben",
"4937209", "Einsiedel\ bei\ Chemnitz",
"496405", "Laubach\ Hessen",
"4939602", "Kleeth",
"4939882", "Gollin",
"495771", "Rahden\ Westfalen",
"499331", "Ochsenfurt",
"496171", "Oberursel\ Taunus",
"494631", "Glücksburg\ Ostsee",
"493763", "Glauchau",
"492653", "Kaisersesch",
"4934633", "Braunsbedra",
"498091", "Kirchseeon",
"497337", "Nellingen\ Alb",
"497934", "Weikersheim",
"497685", "Gutach\-Bleibach",
"4938848", "Vellahn",
"497652", "Hinterzarten",
"497259", "Östringen\-Odenheim",
"495358", "Bahrdorf\-Mackendorf",
"499231", "Marktredwitz",
"495141", "Celle",
"492501", "Münster\-Hiltrup",
"492857", "Rees\-Mehr",
"493302", "Hennigsdorf",
"495144", "Wathlingen",
"495294", "Hövelhof\-Espeln",
"4936081", "Arenshausen",
"499234", "Neusorg",
"495372", "Meinersen",
"494608", "Handewitt",
"499732", "Hammelburg",
"492504", "Telgte",
"4935245", "Burkhardswalde\-Munzig",
"492236", "Wesseling\ Rheinland",
"496526", "Bollendorf",
"497931", "Bad\ Mergentheim",
"4936330", "Grossberndten",
"493966", "Cölpin",
"4938370", "Kröslin",
"498094", "Steinhöring",
"494634", "Husby",
"496174", "Königstein\ im\ Taunus",
"499208", "Bindlach",
"494952", "Rhauderfehn",
"4937349", "Scheibenberg",
"4939851", "Göritz\ bei\ Prenzlau",
"498137", "Petershausen",
"496342", "Schweigen\-Rechtenbach",
"492538", "Drensteinfurt\-Rinkerode",
"498630", "Oberneukirchen",
"496228", "Schönau\ Odenwald",
"495774", "Wagenfeld\-Ströhen",
"497456", "Haiterbach",
"4933733", "Stülpe",
"4938796", "Viesecke",
"495272", "Brakel\ Westfalen",
"494757", "Wanna",
"499334", "Giebelstadt",
"4934492", "Lucka",
"497562", "Isny\ im\ Allgäu",
"498621", "Trostberg",
"4935451", "Dahme\ Brandenburg",
"4934384", "Grossbothen",
"493493", "Bitterfeld",
"492336", "Schwelm",
"494545", "Seedorf\ Lauenburg",
"4939752", "Blumenhagen\ bei\ Strasburg",
"4935931", "Königswartha",
"498072", "Haag\ in\ Oberbayern",
"493445", "Naumburg\ Saale",
"4937465", "Tannenbergsthal\ Vogtland",
"496744", "Oberwesel",
"4935267", "Diesbar\-Seusslitz",
"499937", "Oberpöring",
"496328", "Elmstein",
"492563", "Stadtlohn",
"496192", "Hofheim\ am\ Taunus",
"498683", "Tittmoning",
"4939456", "Altenbrak",
"496242", "Osthofen",
"497041", "Mühlacker",
"492691", "Adenau",
"497367", "Aalen\-Ebnat",
"4935477", "Rietzneuendorf\-Friedrichshof",
"495155", "Emmerthal",
"495182", "Gronau\ Leine",
"4936373", "Buttstädt",
"499474", "Schmidmühlen",
"4938729", "Marnitz",
"4935694", "Gosda\ bei\ Klinge",
"493733", "Annaberg\-Buchholz",
"498053", "Bad\ Endorf",
"494661", "Niebüll",
"4939485", "Gernrode\ Harz",
"4939832", "Wesenberg",
"499261", "Kronach",
"4933396", "Klosterfelde",
"499874", "Neuendettelsau",
"4938333", "Horst\ bei\ Grimmen",
"496384", "Konken",
"495253", "Bad\ Driburg",
"497964", "Stödtlen",
"495432", "Löningen",
"494973", "Wittmund\-Burhafe",
"499492", "Parsberg",
"4935605", "Komptendorf",
"497903", "Mainhardt",
"497267", "Gemmingen",
"498550", "Philippsreut",
"4933847", "Görzke",
"494554", "Wahlstedt",
"4939225", "Altengrabow",
"492902", "Warstein",
"4939740", "Nechlin",
"496782", "Birkenfeld\ Nahe",
"495353", "Königslutter\ am\ Elm",
"496755", "Odernheim\ am\ Glan",
"494499", "Barssel",
"49395", "Neubrandenburg",
"495832", "Hankensbüttel",
"4935952", "Grossröhrsdorf\ OL",
"496284", "Mudau",
"492366", "Herten\ Westfalen",
"497055", "Neuweiler\ Kreis\ Calw",
"4933237", "Paulinenaue",
"496281", "Buchen\ Odenwald",
"497082", "Neuenbürg\ Württemberg",
"497532", "Meersburg",
"494776", "Osten\-Altendorf",
"494407", "Wardenburg",
"499364", "Zellingen",
"499105", "Grosshabersdorf",
"497673", "Schönau\ im\ Schwarzwald",
"494603", "Havetoft",
"497477", "Jungingen\ bei\ Hechingen",
"497706", "Oberbaldingen",
"496223", "Neckargemünd",
"492533", "Münster\-Nienberge",
"4935755", "Ortrand",
"494551", "Bad\ Segeberg",
"499203", "Neudrossenfeld",
"492672", "Treis\-Karden",
"496381", "Kusel",
"499871", "Windsbach",
"4935693", "Lauschütz",
"4936374", "Weissensee",
"497961", "Ellwangen\ Jagst",
"492266", "Lindlar",
"494146", "Stade\-Bützfleth",
"499762", "Saal\ an\ der\ Saale",
"494296", "Schwanewede\-Aschwarden",
"499264", "Küps",
"495636", "Lichtenfels\-Goddelsheim",
"49851", "Passau",
"4938428", "Hohenkirchen\ bei\ Wismar",
"494769", "Bremervörde\-Iselersheim",
"492568", "Heek",
"499303", "Eibelstadt",
"494664", "Neukirchen\ bei\ Niebüll",
"496323", "Edenkoben",
"495725", "Lindhorst\ bei\ Stadthagen",
"498167", "Zolling",
"4939242", "Prödel",
"492379", "Menden\-Asbeck",
"492694", "Wershofen",
"4938334", "Grammendorf",
"499471", "Burglengenfeld",
"4934925", "Bad\ Schmiedeberg",
"499560", "Grub\ am\ Forst",
"4936692", "Bürgel",
"49961", "Weiden\ in\ der\ Oberpfalz",
"49209", "Gelsenkirchen",
"494929", "Ihlow\ Kreis\ Aurich",
"4939291", "Calbe\ Saale",
"4933398", "Werneuchen",
"496869", "Merzig\-Silwingen",
"495965", "Klein\ Berssen",
"496658", "Poppenhausen\ Wasserkuppe",
"497154", "Kornwestheim",
"499922", "Zwiesel",
"499286", "Oberkotzau",
"492547", "Rosendahl\-Osterwick",
"496024", "Schöllkrippen",
"49421", "Bremen",
"492755", "Bad\ Berleburg\-Schwarzenau",
"497721", "Villingen\ im\ Schwarzwald",
"4934745", "Winningen\ Sachsen\-Anhalt",
"496691", "Schwalmstadt",
"496476", "Mengerskirchen",
"496707", "Windesheim",
"495846", "Gartow\ Niedersachsen",
"499727", "Schonungen\-Marktsteinach",
"495051", "Bergen\ Kreis\ Celle",
"498122", "Erding",
"499948", "Eschlkam",
"495446", "Rehden",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"496876", "Weiskirchen\ Saar",
"499386", "Prosselsheim",
"49431", "Kiel",
"498251", "Aichach",
"4938220", "Wustrow\ Ostseebad",
"492384", "Welver",
"4936762", "Steinach\ Thüringen",
"498254", "Altomünster",
"496266", "Hassmersheim",
"497248", "Marxzell",
"494855", "Eddelak",
"498752", "Au\ in\ der\ Hallertau",
"492381", "Hamm\ Westfalen",
"494882", "Lunden",
"498785", "Rottenburg\-Oberroning",
"497322", "Giengen\ an\ der\ Brenz",
"4938821", "Lüdersdorf",
"4939062", "Bebertal",
"492323", "Herne",
"493928", "Schönebeck\ Elbe",
"4936965", "Stadtlengsfeld",
"4939407", "Seehausen\ Börde",
"495054", "Bergen\-Sülze",
"4935439", "Zinnitz",
"496580", "Zemmer",
"497546", "Oberteuringen",
"496568", "Wolsfeld",
"494482", "Hatten",
"494455", "Jade\-Schweiburg",
"499157", "Alfeld\ Mittelfranken",
"496694", "Neukirchen\ Knüll",
"497629", "Tegernau\ Baden",
"495642", "Warburg\-Scherfede",
"495199", "Schneverdingen\-Heber",
"496021", "Aschaffenburg",
"497222", "Rastatt",
"4938426", "Neuburg\-Steinhausen",
"497724", "St\ Georgen\ im\ Schwarzwald",
"497348", "Beimerstetten",
"497151", "Waiblingen",
"4936947", "Jüchsen",
"4934722", "Preusslitz",
"4938722", "Raduhn",
"499575", "Weismain",
"492223", "Königswinter",
"496533", "Morbach\ Hunsrück",
"496083", "Weilrod",
"496672", "Eiterfeld",
"494132", "Amelinghausen",
"4934426", "Kayna",
"49465", "Sylt",
"493877", "Wittenberge",
"4935771", "Bad\ Muskau",
"4933094", "Löwenberg",
"497046", "Zaberfeld",
"496068", "Beerfelden",
"492825", "Uedem",
"495554", "Moringen",
"497851", "Kehl",
"494432", "Dötlingen\-Brettorf",
"4934321", "Leisnig",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"4933746", "Werbig\ bei\ Jüterbog",
"499439", "Neunburg\-Kemnath",
"494353", "Ascheffel",
"4939776", "Hintersee",
"492331", "Hagen\ Westfalen",
"498735", "Gangkofen\-Kollbach",
"494832", "Meldorf",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"4938321", "Martensdorf\ bei\ Stralsund",
"492425", "Nideggen\-Embken",
"497451", "Horb\ am\ Neckar",
"499075", "Glött",
"4939390", "Iden",
"4936024", "Diedorf\ bei\ Mühlhausen",
"496583", "Palzem",
"498549", "Vilshofen\-Pleinting",
"495661", "Melsungen",
"496033", "Butzbach",
"494155", "Büchen",
"494182", "Tostedt",
"4933926", "Herzberg\ Mark",
"4939723", "Krien",
"499653", "Eslarn",
"497936", "Schrozberg\-Bartenstein",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"494253", "Asendorf\ Kreis\ Diepholz",
"493961", "Altentreptow",
"499857", "Schopfloch\ Mittelfranken",
"4935872", "Neusalza\-Spremberg",
"4939957", "Gielow",
"4937422", "Markneukirchen",
"495146", "Wietze",
"498422", "Dollnstein",
"499236", "Nagel",
"4936023", "Horsmar",
"492506", "Münster\-Wolbeck",
"4935265", "Glaubitz",
"4937467", "Klingenthal\ Sachsen",
"492234", "Frechen",
"496524", "Rodershausen",
"4939724", "Klein\ Bünzow",
"492732", "Kreuztal",
"499504", "Stadelhofen",
"493964", "Bredenfelde\ bei\ Strasburg",
"492208", "Niederkassel",
"499088", "Mönchsdeggingen",
"494636", "Langballig",
"495769", "Steyerberg\-Voigtei",
"4937369", "Wolkenstein",
"497733", "Engen\ Hegau",
"4936259", "Tabarz\ Thüringer\ Wald",
"494725", "Helgoland",
"498822", "Oberammergau",
"495664", "Morschen",
"495776", "Preussisch\ Ströhen",
"495407", "Wallenhorst",
"497454", "Sulz\ am\ Neckar",
"4933093", "Fürstenberg\ Havel",
"495603", "Gudensberg",
"499336", "Bütthard",
"492334", "Hagen\-Hohenlimburg",
"4933974", "Dessow",
"492937", "Arnsberg\-Oeventrop",
"499563", "Rödental",
"492308", "Unna\-Hemmerde",
"496746", "Pfalzfeld",
"4935247", "Zehren\ Sachsen",
"495807", "Altenmedingen",
"497854", "Kehl\-Goldscheuer",
"495551", "Northeim",
"4936076", "Niederorschel",
"492583", "Sassenberg",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"498663", "Ruhpolding",
"493546", "Lübben\ Spreewald",
"494846", "Hattstedt",
"4938461", "Bützow",
"498467", "Kinding",
"4939050", "Bartensleben",
"4938304", "Garz\ Rügen",
"499171", "Roth\ Mittelfranken",
"49531", "Braunschweig",
"492521", "Beckum",
"493322", "Falkensee",
"497032", "Herrenberg",
"496231", "Hochdorf\-Assenheim",
"497582", "Bad\ Buchau",
"497555", "Deggenhausertal",
"494446", "Bakum\ Kreis\ Vechta",
"498867", "Rottenbuch\ Oberbayern",
"4934461", "Nebra\ Unstrut",
"497747", "Berau",
"4933748", "Treuenbrietzen",
"495686", "Schwarzenborn\ Knüll",
"496825", "Illingen\ Saar",
"496220", "Wilhelmsfeld",
"497942", "Neuenstein\ Württemberg",
"498638", "Waldkraiburg",
"494965", "Surwold",
"4935022", "Bad\ Schandau",
"499805", "Burgoberbach",
"4936252", "Tambach\-Dietharz",
"499741", "Bad\ Brückenau",
"4937362", "Seiffen\ Erzgebirge",
"496331", "Pirmasens",
"493629", "Stadtilm",
"4933207", "Gross\ Kreutz",
"49521", "Bielefeld",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"493724", "Burgstädt",
"492943", "Erwitte",
"494107", "Siek\ Kreis\ Stormarn",
"4933928", "Wildberg\ Brandenburg",
"4934243", "Bad\ Düben",
"499405", "Bad\ Abbach",
"496425", "Rauschenberg\ Hessen",
"498709", "Eching\ Niederbayern",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"498377", "Unterthingau",
"494642", "Kappeln\ Schlei",
"496334", "Thaleischweiler\-Fröschen",
"494249", "Bassum\-Nordwohlde",
"4936421", "Camburg",
"493721", "Meinersdorf",
"497665", "March\ Breisgau",
"496308", "Olsbrücken",
"495132", "Lehrte",
"499192", "Gräfenberg",
"4936873", "Themar",
"499242", "Gössweinstein",
"499744", "Zeitlofs\-Detter",
"498553", "Spiegelau",
"4937327", "Rechenberg\-Bienenmühle",
"4934244", "Mockrehna",
"496506", "Welschbillig",
"4933087", "Bredereiche",
"496047", "Altenstadt\ Hessen",
"499526", "Riedbach",
"496732", "Wörrstadt",
"4938303", "Sellin\ Ostseebad",
"495250", "Delbrück\ Westfalen",
"495855", "Nahrendorf",
"495882", "Gorleben",
"494349", "Dänischenhagen",
"496234", "Mutterstadt",
"492524", "Ennigerloh",
"495482", "Tecklenburg",
"495455", "Tecklenburg\-Brochterbeck",
"499228", "Thurnau",
"499174", "Hilpoltstein",
"499342", "Wertheim",
"4935385", "Annaburg",
"4933654", "Fünfeichen",
"494684", "Langeness\ Hallig",
"494935", "Juist",
"4936841", "Schleusingen",
"492588", "Harsewinkel\-Greffen",
"49261", "Koblenz\ am\ Rhein",
"497156", "Ditzingen",
"498459", "Manching",
"499284", "Schwarzenbach\ an\ der\ Saale",
"4933703", "Sperenberg",
"496026", "Grossostheim",
"4936922", "Gerstungen",
"492922", "Werl",
"496361", "Rockenhausen",
"499547", "Zapfendorf",
"4935893", "Mücka",
"498572", "Tann\ Niederbayern",
"493395", "Pritzwalk",
"496474", "Villmar\-Aumenau",
"497541", "Friedrichshafen",
"495844", "Clenze",
"498633", "Tüssling",
"4938208", "Kavelstorf",
"4938753", "Wöbbelin",
"495444", "Wagenfeld",
"4934208", "Löbnitz\ bei\ Delitzsch",
"496874", "Wadern\-Nunkirchen",
"499384", "Schwanfeld",
"497062", "Beilstein\ Württemberg",
"496261", "Mosbach\ Baden",
"492948", "Lippstadt\-Rebbeke",
"4934604", "Niemberg",
"4934927", "Globig\-Bleddin",
"4936742", "Uhlstädt",
"496264", "Neudenau",
"496762", "Kastellaun",
"495441", "Diepholz",
"4939382", "Kamern",
"499381", "Volkach",
"496871", "Wadern",
"492157", "Nettetal\-Kaldenkirchen",
"4936945", "Henneberg",
"496471", "Weilburg",
"495056", "Winsen\-Meissendorf",
"4938754", "Leussow\ bei\ Ludwigslust",
"498558", "Hohenau\ Niederbayern",
"497544", "Markdorf",
"495841", "Lüchow\ Wendland",
"499323", "Iphofen",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"496696", "Gilserberg",
"496303", "Enkenbach\-Alsenborn",
"495705", "Petershagen\-Windheim",
"497635", "Schliengen",
"4933653", "Ziltendorf",
"497726", "Bad\ Dürrheim",
"494623", "Böklund",
"496364", "Nussbach\ Pfalz",
"496105", "Mörfelden\-Walldorf",
"499281", "Hof\ Saale",
"4939405", "Hötensleben",
"4936967", "Geisa",
"4933704", "Baruth\ Mark",
"494681", "Wyk\ auf\ Föhr",
"4935894", "Hähnichen",
"496203", "Ladenburg",
"492575", "Greven\-Reckenfeld",
"4934348", "Frohburg",
"499223", "Rugendorf",
"495162", "Fallingbostel",
"497387", "Hohenstein\ Württemberg",
"494827", "Wacken",
"498591", "Obernzell",
"496727", "Gensingen",
"495978", "Hörstel\-Dreierwalde",
"496063", "Bad\ König",
"495631", "Korbach",
"492474", "Nideggen\-Schmidt",
"492874", "Isselburg",
"494141", "Stade",
"4933845", "Borkheide",
"493931", "Stendal",
"499876", "Rohr\ Mittelfranken",
"497340", "Neenstetten",
"4935607", "Jänschwalde",
"498102", "Höhenkirchen\-Siegertsbrunn",
"496386", "Altenkirchen\ Pfalz",
"492261", "Gummersbach",
"497966", "Unterschneidheim",
"494358", "Loose\ bei\ Eckernförde",
"499869", "Wettringen\ Mittelfranken",
"4934206", "Rötha",
"499658", "Georgenberg",
"497445", "Pfalzgrafenweiler",
"494462", "Wittmund",
"496588", "Pluwig",
"49661", "Fulda",
"4939487", "Friedrichsbrunn",
"494556", "Ahrensbök\-Gnissau",
"496004", "Lich\-Eberstadt",
"494771", "Hemmoor",
"494862", "Garding",
"498765", "Bruckberg\ Niederbayern",
"493562", "Forst\ Lausitz",
"492361", "Recklinghausen",
"495127", "Harsum",
"494258", "Schwarme",
"497240", "Pfinztal",
"4938206", "Graal\-Müritz\ Seeheilbad",
"499469", "Roding\-Neubäu",
"4939389", "Schollene",
"4935475", "Straupitz",
"496286", "Walldürn\-Rippberg",
"492364", "Haltern\ Westfalen",
"495545", "Hedemünden",
"494774", "Hechthausen",
"497202", "Karlsbad",
"499366", "Geroldshausen\ Unterfranken",
"494394", "Bokhorst",
"496139", "Budenheim",
"494272", "Siedenburg",
"497704", "Geisingen\ Baden",
"4939971", "Gnoien",
"499672", "Neunburg\ vorm\ Wald",
"497738", "Steisslingen",
"499279", "Mistelgau",
"499533", "Untermerzbach",
"495593", "Bovenden\-Lenglern",
"499083", "Möttingen",
"492203", "Cologne\-Porz",
"496575", "Landscheid",
"492762", "Wenden\ Südsauerland",
"493685", "Hildburghausen",
"492264", "Marienheide",
"494144", "Himmelpforten",
"494294", "Riede\ Kreis\ Verden",
"492871", "Bocholt",
"494372", "Westfehmarn",
"495608", "Söhrewald",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"4936929", "Ruhla",
"494792", "Worpswede",
"499266", "Mitwitz",
"498443", "Hohenwart\ Paar",
"4934346", "Narsdorf",
"495634", "Waldeck\-Sachsenhausen",
"495952", "Sögel",
"496650", "Hosenfeld",
"494666", "Ladelund",
"496157", "Pfungstadt",
"497763", "Murg",
"492471", "Roetgen\ Eifel",
"4933235", "Friesack",
"4939262", "Güsten\ Anh",
"499568", "Neustadt\ bei\ Coburg",
"492696", "Nohn\ Eifel",
"492303", "Unna",
"493337", "Biesenthal\ Brandenburg",
"494335", "Hohn\ bei\ Rendsburg",
"492546", "Coesfeld\-Lette",
"499287", "Selb",
"4936423", "Orlamünde",
"497323", "Gerstetten",
"494883", "Süderstapel",
"493583", "Zittau",
"4935327", "Priessen",
"498753", "Elsendorf\ Niederbayern",
"4936737", "Drognitz",
"499544", "Baunach",
"494421", "Wilhelmshaven",
"497381", "Münsingen",
"494821", "Itzehoe",
"493521", "Meissen",
"492248", "Hennef\-Uckerath",
"494168", "Neu\ Wulmstorf\-Elstorf",
"494180", "Königsmoor",
"494483", "Ovelgönne\-Grossenmeer",
"4936871", "Bad\ Colberg\-Heldburg",
"4934956", "Zörbig",
"497223", "Bühl\ Baden",
"4939829", "Blankenförde",
"495643", "Borgentreich",
"4938301", "Putbus",
"494830", "Süderhastedt",
"494235", "Langwedel\-Etelsen",
"495447", "Lembruch",
"4938464", "Bernitt",
"4938732", "Gallin\ bei\ Lübz",
"492724", "Finnentrop\-Serkenrode",
"493943", "Wernigerode",
"4934464", "Freyburg\ Unstrut",
"4939992", "Görmin",
"496055", "Freigericht",
"496082", "Niederreifenberg",
"496532", "Zeltingen\-Rachtig",
"492222", "Bornheim\ Rheinland",
"499726", "Euerbach",
"494133", "Wittorf\ Kreis\ Lüneburg",
"498808", "Pähl",
"496673", "Haunetal",
"499635", "Bärnau",
"497125", "Bad\ Urach",
"498434", "Rennertshofen",
"496477", "Greifenstein\-Nenderoth",
"495695", "Twistetal",
"496706", "Wallhausen\ Nahe",
"492151", "Krefeld",
"4938455", "Plaaz",
"4933677", "Glienicke\ bei\ Beeskow",
"492154", "Willich",
"498431", "Neuburg\ an\ der\ Donau",
"497755", "Weilheim\ Kreis\ Waldshut",
"492721", "Lennestadt",
"498325", "Oberstaufen\-Thalkirchdorf",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"499923", "Teisnach",
"496267", "Fahrenbach\ Baden",
"4934463", "Bad\ Kösen",
"498509", "Ruderting",
"4935728", "Uhyst\ Spree",
"4936424", "Kahla\ Thüringen",
"4933632", "Hangelsberg",
"4939037", "Pretzier",
"494824", "Krempe",
"497384", "Schelklingen\-Hütten",
"498225", "Jettingen\-Scheppach",
"4936338", "Bleicherode",
"4934299", "Gaschwitz",
"4935362", "Schönewalde\ bei\ Herzberg",
"498123", "Moosinning",
"4934241", "Jesewitz",
"4938378", "Heringsdorf\ Seebad",
"495025", "Estorf\ Weser",
"4933875", "Rhinow",
"494525", "Ahrensbök",
"497533", "Allensbach",
"4934292", "Brandis\ bei\ Wurzen",
"497083", "Bad\ Herrenalb",
"498641", "Grassau\ Kreis\ Traunstein",
"497672", "St\ Blasien",
"499738", "Rottershausen",
"4936021", "Schlotheim",
"494209", "Schwanewede",
"494602", "Freienwill",
"495378", "Sassenburg\-Platendorf",
"496629", "Schenklengsfeld",
"492532", "Ostbevern",
"497940", "Künzelsau",
"497021", "Kirchheim\ unter\ Teck",
"499704", "Euerdorf",
"496222", "Wiesloch",
"493331", "Angermünde",
"496724", "Stromberg\ Hunsrück",
"499202", "Waischenfeld",
"494958", "Jemgum",
"497366", "Abtsgmünd",
"496348", "Offenbach\ an\ der\ Queich",
"496151", "Darmstadt",
"4938292", "Kröpelin",
"493425", "Wurzen",
"492673", "Ellenz\-Poltersdorf",
"495751", "Rinteln",
"4934324", "Ostrau\ Sachsen",
"496007", "Rosbach\-Rodheim",
"497568", "Bad\ Wurzach\-Hauerz",
"495278", "Höxter\-Ovenhausen",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"4935774", "Boxberg\ Sachsen",
"499302", "Rottendorf\ Unterfranken",
"496198", "Eppstein",
"492961", "Brilon",
"497266", "Kirchardt",
"496322", "Bad\ Dürkheim",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"4938324", "Velgast",
"495468", "Bramsche\-Engter",
"499966", "Wiesenfelden",
"494806", "Sarzbüttel",
"4939999", "Tutow",
"495183", "Lamspringe",
"499340", "Königheim\-Brehmen",
"498085", "Sankt\ Wolfgang",
"492964", "Brilon\-Alme",
"498052", "Aschau\ im\ Chiemgau",
"498535", "Haarbach",
"4935773", "Schleife",
"492367", "Henrichenburg",
"4939822", "Kratzeburg",
"495121", "Hildesheim",
"498179", "Eurasburg\ an\ der\ Loisach",
"4933971", "Kyritz\ Brandenburg",
"497476", "Bisingen",
"497707", "Bräunlingen",
"4938323", "Prohn",
"495754", "Extertal\-Bremke",
"495659", "Ringgau",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"494777", "Cadenberge",
"495252", "Bad\ Lippspringe",
"494406", "Berne",
"499845", "Oberdachstetten",
"494972", "Langeoog",
"499493", "Beratzhausen",
"496154", "Ober\-Ramstadt",
"499190", "Heroldsbach",
"498166", "Allershausen\ Oberbayern",
"495130", "Wedemark",
"4939721", "Liepen\ bei\ Anklam",
"495433", "Badbergen",
"4938376", "Zirchow",
"499701", "Sandberg\ Unterfranken",
"497024", "Wendlingen\ am\ Neckar",
"493334", "Eberswalde",
"496721", "Bingen\ am\ Rhein",
"492903", "Meschede\-Freienohl",
"492267", "Wipperfürth",
"4935726", "Gross\ Särchen",
"493937", "Osterburg\ Altmark",
"495352", "Schöningen",
"496783", "Baumholder",
"4936336", "Klettenberg",
"499445", "Neustadt\ an\ der\ Donau",
"495833", "Brome",
"494297", "Ottersberg\-Posthausen",
"496775", "Strüth\ Taunus",
"495373", "Hillerse\ Kreis\ Gifhorn",
"496395", "Münchweiler\ an\ der\ Rodalb",
"494126", "Horst\ Holstein",
"499733", "Münnerstadt",
"4939746", "Krackow",
"4933472", "Golzow\ bei\ Seelow",
"495401", "Georgsmarienhütte",
"4934907", "Jeber\-Bergfrieden",
"492678", "Büchel\ bei\ Cochem",
"497504", "Horgenzell",
"493874", "Ludwigslust",
"496343", "Bad\ Bergzabern",
"495745", "Stemwede\-Levern",
"498389", "Weissensberg",
"494953", "Bunde",
"4938228", "Dettmannsdorf\-Kölzow",
"4939973", "Altkalen",
"497236", "Keltern",
"492931", "Arnsberg",
"4939926", "Grabowhöfe",
"499854", "Wittelshofen",
"496145", "Flörsheim\ am\ Main",
"496295", "Rosenberg\ Baden",
"4935842", "Oderwitz",
"495273", "Beverungen",
"497563", "Kisslegg",
"492856", "Hamminkeln\-Brünen",
"4933437", "Reichenberg\ bei\ Strausberg",
"4939005", "Kusey",
"492041", "Bottrop",
"4937757", "Rittersgrün",
"498073", "Gars\ am\ Inn",
"492456", "Selfkant",
"495175", "Lehrte\-Arpke",
"497336", "Lonsee",
"496243", "Monsheim",
"4938859", "Alt\ Zachun",
"4938488", "Demen",
"499454", "Aufhausen\ Oberpfalz",
"498682", "Laufen\ Salzach",
"493361", "Fürstenwalde\ Spree",
"492562", "Gronau\ Westfalen",
"492359", "Kierspe",
"493364", "Eisenhüttenstadt",
"499451", "Schierling",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"4937607", "Ebersbrunn\ Sachsen",
"4938789", "Wolfshagen\ bei\ Perleberg",
"498136", "Markt\ Indersdorf",
"497839", "Schapbach",
"495863", "Zernien",
"493967", "Oertzenhof\ bei\ Strasburg",
"499851", "Dinkelsbühl",
"492237", "Kerpen\ Rheinland\-Türnich",
"496527", "Oberweis",
"4939425", "Dingelstedt\ am\ Huy",
"492934", "Sundern\-Altenhellefeld",
"492685", "Flammersfeld",
"492652", "Mendig",
"493762", "Crimmitschau",
"498565", "Dietersburg\-Baumgarten",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"4935825", "Kodersdorf",
"499936", "Wallerfing",
"495438", "Bakum\-Lüsche",
"493871", "Parchim",
"499498", "Laaber",
"493471", "Bernburg\ Saale",
"494756", "Odisheim",
"495838", "Gross\ Oesingen",
"497653", "Lenzkirch",
"496788", "Sien",
"495404", "Westerkappeln",
"497457", "Rottenburg\-Ergenzingen",
"492337", "Hagen\-Dahl",
"493303", "Birkenwerder",
"498271", "Meitingen",
"495505", "Hardegsen",
"492295", "Ruppichteroth",
"49361", "Erfurt",
"497744", "Stühlingen",
"493588", "Niesky",
"497328", "Königsbronn",
"494265", "Fintel",
"496856", "St\ Wendel\-Niederkirchen",
"495622", "Fritzlar",
"497192", "Murrhardt",
"497242", "Rheinstetten",
"4938226", "Dierhagen\ Ostseebad",
"496041", "Glauburg",
"498464", "Dietfurt\ an\ der\ Altmühl",
"496456", "Haina\ Kloster",
"499665", "Königstein\ Oberpfalz",
"4939748", "Viereck",
"4934601", "Teutschenthal",
"494488", "Westerstede",
"495071", "Schwarmstedt",
"494163", "Horneburg\ Niederelbe",
"492243", "Eitorf",
"492193", "Dabringhausen",
"498029", "Kreuth\ bei\ Tegernsee",
"49591", "Lingen\ \(Ems\)",
"496562", "Speicher",
"492395", "Finnentrop\-Rönkhausen",
"493727", "Mittweida",
"4936844", "Rohr\ Thüringen",
"4934782", "Mansfeld\ Südharz",
"492775", "Driedorf",
"498403", "Pförring",
"497174", "Mögglingen",
"495329", "Schulenberg\ im\ Oberharz",
"495648", "Brakel\-Gehrden",
"494104", "Aumühle\ bei\ Hamburg",
"494365", "Heringsdorf\ Holstein",
"497228", "Forbach",
"4938486", "Gustävel",
"4939928", "Möllenhagen",
"496678", "Wildeck\-Hönebach",
"498803", "Peissenberg",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"493386", "Premnitz",
"4938782", "Reetz\ bei\ Perleberg",
"4939207", "Colbitz",
"495826", "Suderburg",
"496652", "Hünfeld",
"499747", "Geroda\ Bayern",
"4936843", "Benshausen",
"4938852", "Wittenburg",
"499555", "Schlüsselfeld\-Aschbach",
"4939365", "Bellingen\ bei\ Stendal",
"4933332", "Gartz\ Oder",
"4935891", "Rothenburg\ OL",
"497171", "Schwäbisch\ Gmünd",
"494101", "Pinneberg",
"4933701", "Grossbeeren",
"498292", "Dinkelscherben",
"499928", "Kirchdorf\ im\ Wald",
"498142", "Olching",
"496337", "Grossbundenbach",
"495426", "Glandorf",
"498374", "Dietmannsried",
"497300", "Roggenburg",
"494475", "Molbergen",
"499177", "Heideck",
"4935792", "Ossling",
"496359", "Grünstadt",
"4939087", "Jerchel\ Altmark",
"498461", "Beilngries",
"495074", "Rodewald",
"4939347", "Kade",
"497741", "Tiengen\ Hochrhein",
"496044", "Schotten\ Hessen",
"498861", "Schongau",
"496237", "Maxdorf",
"492527", "Lippetal\-Lippborg",
"498392", "Markt\ Rettenbach",
"497805", "Appenweier",
"498274", "Buttenwiesen",
"499942", "Viechtach",
"494875", "Stafstedt",
"498772", "Mallersdorf\-Pfaffenberg",
"4933479", "Küstrin\-Kietz",
"4938751", "Picher",
"4936848", "Wernshausen",
"497852", "Willstätt",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"497268", "Bad\ Rappenau\-Obergimpern",
"4934673", "Heldrungen",
"496246", "Eich\ Rheinhessen",
"496196", "Bad\ Soden\ am\ Taunus",
"497333", "Laichingen",
"4933369", "Oderberg",
"492150", "Meerbusch\-Lank",
"492453", "Heinsberg\-Randerath",
"498076", "Pfaffing",
"494431", "Wildeshausen",
"492657", "Uersfeld",
"4939887", "Gerswalde",
"4939924", "Stuer",
"492332", "Gevelsberg",
"4939607", "Kotelow",
"493531", "Finsterwalde",
"497566", "Argenbühl",
"492853", "Schermbeck",
"495276", "Marienmünster",
"497452", "Nagold",
"497485", "Empfingen",
"497233", "Niefern\-Öschelbronn",
"498824", "Oberau\ Loisach",
"495662", "Felsberg\ Hessen",
"494956", "Uplengen",
"4938201", "Gelbensande",
"496346", "Annweiler\ am\ Trifels",
"494509", "Gross\ Grönau",
"497579", "Schwenningen\ Baden",
"494181", "Buchholz\ in\ der\ Nordheide",
"499502", "Frensdorf",
"492734", "Freudenberg\ Westfalen",
"493962", "Penzlin\ bei\ Waren",
"492639", "Anhausen\ Kreis\ Neuwied",
"496522", "Mettendorf",
"4935389", "Holzdorf\ Elster",
"4939744", "Rothenklempenow",
"492232", "Brühl\ Rheinland",
"499736", "Oberthulba",
"494123", "Barmstedt",
"497135", "Brackenheim",
"499625", "Kastl\ bei\ Amberg",
"498424", "Nassenfels",
"4936043", "Kirchheilingen",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"493693", "Meiningen",
"493306", "Gransee",
"498421", "Eichstätt\ Bayern",
"498335", "Fellheim",
"4939976", "Gross\ Bützin",
"495945", "Wilsum",
"497656", "Schluchsee",
"496849", "Kirkel",
"494753", "Balje",
"496449", "Ehringshausen\-Katzenfurt",
"498168", "Attenkirchen",
"4939743", "Zerrenthin",
"499933", "Wallersdorf",
"49211", "Düsseldorf",
"492567", "Ahaus\-Alstätte",
"494184", "Hanstedt\ Nordheide",
"498687", "Taching\-Tengling",
"4935971", "Sebnitz",
"498821", "Garmisch\-Partenkirchen",
"4934497", "Langenleuba\-Niederhain",
"4936370", "Grossenehrich",
"494834", "Büsum",
"497478", "Hirrlingen",
"494408", "Hude\ Oldenburg",
"495466", "Merzen",
"498133", "Haimhausen\ Oberbayern",
"494434", "Colnrade",
"4939923", "Priborn",
"4934341", "Geithain",
"495035", "Gross\ Munzel",
"495552", "Katlenburg",
"495585", "Herzberg\-Sieber",
"494535", "Nahe",
"499728", "Wülfershausen\ Unterfranken",
"499172", "Georgensgmünd",
"498806", "Utting\ am\ Ammersee",
"499344", "Gerchsheim",
"495484", "Lienen\-Kattenvenne",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"497581", "Saulgau",
"494179", "Winsen\-Tönnhausen",
"4935025", "Liebstadt",
"496639", "Ottrau",
"492522", "Oelde",
"4936846", "Suhl\-Dietzhausen",
"497031", "Böblingen",
"496232", "Speyer",
"493321", "Nauen\ Brandenburg",
"496734", "Flonheim",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"498406", "Böhmfeld",
"4937365", "Sayda",
"4938392", "Sassnitz",
"4936255", "Goldbach\ bei\ Gotha",
"493435", "Oschatz",
"4938484", "Ventschow",
"492605", "Löf",
"4934224", "Belgern\ Sachsen",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"492246", "Lohmar\ Rheinland",
"497941", "Öhringen",
"492196", "Wermelskirchen",
"499742", "Kalbach\ Rhön",
"494166", "Ahlerstedt",
"496657", "Hofbieber",
"496150", "Weiterstadt",
"499244", "Betzenstein",
"496453", "Gemünden\ Wohra",
"499194", "Ebermannstadt",
"494749", "Schiffdorf\-Geestenseth",
"496853", "Marpingen",
"498640", "Reit\ Im\ Winkl",
"492548", "Dülmen\-Rorup",
"494644", "Karby",
"496332", "Zweibrücken",
"495108", "Gehrden\ Han",
"4938224", "Gresenhorst",
"497347", "Dietenheim",
"4934223", "Dommitzsch",
"493722", "Limbach\-Oberfrohna",
"49571", "Minden\ Westfalen",
"494641", "Süderbrarup",
"499191", "Forchheim\ Oberfranken",
"499241", "Pegnitz",
"495131", "Garbsen",
"4939978", "Gross\ Roge",
"4938223", "Saal\ Vorpom",
"497944", "Kupferzell",
"495423", "Versmold",
"497247", "Linkenheim\-Hochstetten",
"497034", "Ehningen",
"4937207", "Hainichen\ Sachsen",
"497584", "Altshausen",
"496731", "Alzey",
"496567", "Oberkail",
"499341", "Tauberbischofsheim",
"4933362", "Liepe\ Kreis\ Barnim",
"492975", "Schmallenberg\-Oberkirchen",
"492449", "Blankenheim\ Ahr",
"495481", "Lengerich\ Westfalen",
"49611", "Wiesbaden",
"4938483", "Brüel",
"499158", "Offenhausen\ Mittelfranken",
"495823", "Bienenbüttel",
"496703", "Wöllstein\ Rheinhessen",
"495164", "Hodenhagen",
"495305", "Sickte",
"4934328", "Hartha\ bei\ Döbeln",
"4934466", "Janisroda",
"494136", "Scharnebeck",
"496676", "Hohenroda\ Hessen",
"499723", "Röthlein",
"497528", "Neukirch\ bei\ Tettnang",
"492983", "Winterberg\-Siedlinghausen",
"493946", "Quedlinburg",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"496362", "Alsenz",
"497955", "Wallhausen\ Württemberg",
"495646", "Willebadessen",
"4938328", "Miltzow",
"497226", "Bühl\-Sand",
"4938466", "Jürgenshagen",
"492921", "Soest",
"496458", "Rosenthal\ Hessen",
"492595", "Olfen",
"495205", "Bielefeld\-Sennestadt",
"498571", "Simbach\ am\ Inn",
"494486", "Edewecht\-Friedrichsfehn",
"49941", "Regensburg",
"497542", "Tettnang",
"495529", "Rhumspringe",
"4934692", "Alsleben\ Saale",
"4936925", "Marksuhl",
"493865", "Holthusen",
"49981", "Ansbach",
"495103", "Wennigsen\ Deister",
"496764", "Rheinböllen",
"493586", "Neugersdorf\ Sachsen",
"4933239", "Gross\ Behnitz",
"498756", "Nandlstadt",
"497326", "Neresheim",
"496669", "Neuhof\-Hauswurz",
"492543", "Billerbeck\ Westfalen",
"496858", "Ottweiler\-Fürth",
"496262", "Aglasterhausen",
"496761", "Simmern\ Hunsrück",
"496872", "Losheim\ am\ See",
"499382", "Gerolzhofen",
"499355", "Frammersbach",
"495442", "Barnstorf\ Kreis\ Diepholz",
"497429", "Egesheim",
"495842", "Schnega",
"4936426", "Ottendorf\ bei\ Stadtroda",
"496472", "Weilmünster",
"4933849", "Wiesenburg\ Mark",
"4939402", "Völpke",
"492227", "Bornheim\-Merten",
"496087", "Waldems",
"498574", "Wittibreut",
"492924", "Möhnesee",
"496559", "Leidenborn",
"499926", "Frauenau",
"495428", "Melle\-Neuenkirchen",
"499255", "Marktleugast",
"496894", "St\ Ingbert",
"499282", "Naila",
"495828", "Himbergen",
"499153", "Schnaittach",
"494682", "Amrum",
"4934953", "Gräfenhainichen",
"494289", "Kirchtimke",
"498592", "Wegscheid\ Niederbayern",
"4938727", "Mestlin",
"492327", "Bochum\-Wattenscheid",
"495161", "Walsrode",
"493375", "Königs\ Wusterhausen",
"495573", "Uslar\-Volpriehausen",
"496595", "Dockweiler",
"4939771", "Ueckermünde",
"494977", "Blomberg\ Ostfriesland",
"4935472", "Schlepzig",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"495954", "Lorup",
"497263", "Waibstadt",
"499149", "Weissenburg\-Suffersheim",
"495632", "Willingen\ Upland",
"4938326", "Grimmen",
"498370", "Wiggensbach",
"497165", "Göppingen\-Hohenstaufen",
"497304", "Blaustein\ Württemberg",
"495357", "Grasleben",
"494794", "Worpswede\-Ostersode",
"4936949", "Obermassfeld\-Grimmenthal",
"4933741", "Niedergörsdorf",
"499766", "Grosswenkheim",
"494292", "Ritterhude",
"494142", "Steinkirchen\ Kreis\ Stade",
"492858", "Hünxe",
"498039", "Rott\ am\ Inn",
"496543", "Büchenbeuren",
"492262", "Wiehl",
"492764", "Welschen\ Ennest",
"493737", "Rochlitz",
"492676", "Ulmen",
"498057", "Aschau\-Sachrang",
"494461", "Jever",
"4935723", "Bernsdorf\ OL",
"497363", "Lauchheim",
"499674", "Schönsee",
"4936333", "Heringen\ Helme",
"495339", "Gielde",
"499779", "Nordheim\ von\ der\ Rhön",
"4939409", "Eilsleben",
"494392", "Nortorf\ bei\ Neumünster",
"497702", "Blumberg\ Baden",
"4938373", "Katzow",
"494274", "Varrel\ bei\ Sulingen",
"4933921", "Zechlinerhütte",
"495257", "Hövelhof",
"497204", "Malsch\-Völkersbach",
"494128", "Kollmar",
"494772", "Oberndorf\ Oste",
"499901", "Hengersberg\ Bayern",
"493561", "Guben",
"494861", "Tönning",
"492362", "Dorsten",
"495836", "Wittingen\-Radenbeck",
"4935724", "Lohsa",
"494758", "Nordleda",
"4936428", "Stadtroda",
"498265", "Pfaffenhausen\ Schwaben",
"498860", "Bernbeuren",
"493564", "Schwarze\ Pumpe",
"496786", "Kempfeld",
"494864", "Oldenswort",
"499904", "Lalling",
"494271", "Sulingen",
"4939265", "Löderburg",
"4936334", "Wolkramshausen",
"4933232", "Brieselang",
"496002", "Ober\-Mörlen",
"499671", "Oberviechtach",
"4938374", "Lassan\ bei\ Wolgast",
"495065", "Sibbesse",
"494464", "Wittmund\-Carolinensiel",
"499307", "Altertheim",
"499938", "Moos\ Niederbayern",
"495436", "Nortrup",
"496327", "Neustadt\-Lachen",
"498460", "Berching\-Holnstein",
"494403", "Bad\ Zwischenahn",
"494607", "Janneby",
"498104", "Sauerlach",
"498365", "Wertach",
"4936071", "Teistungen",
"497473", "Mössingen",
"492761", "Olpe\ Biggesee",
"494791", "Osterholz\-Scharmbeck",
"492872", "Rhede\ Westfalen",
"494371", "Burg\ auf\ Fehmarn",
"4939247", "Güterglück",
"492472", "Monschau",
"495951", "Werlte",
"496227", "Walldorf\ Baden",
"494803", "Pahlen",
"495186", "Salzhemmendorf\-Wallensen",
"498138", "Schwabhausen\ bei\ Dachau",
"499207", "Königsfeld\ Oberfranken",
"499963", "Konzell",
"492383", "Bönen",
"4939995", "Nossendorf",
"493346", "Seelow",
"492835", "Issum",
"4938735", "Plau\ am\ See",
"494422", "Sande\ Kreis\ Friesl",
"495905", "Beesten",
"4934221", "Schildau\ Gneisenaustadt",
"496809", "Grossrosseln",
"4934606", "Teicha\ Sachsen\-Anhalt",
"499829", "Flachslanden",
"4940", "Hamburg",
"49551", "Göttingen",
"499429", "Rain\ Niederbayern",
"498636", "Ampfing",
"492066", "Duisburg\-Homberg",
"494822", "Kellinghusen",
"498725", "Wurmannsquick",
"493522", "Grossenhain\ Sachsen",
"497382", "Römerstein",
"496409", "Biebertal",
"4938221", "Marlow",
"497355", "Hochdorf\ Riss",
"495167", "Walsrode\-Westenholz",
"493605", "Leinefelde",
"492435", "Erkelenz\-Lövenich",
"4937382", "Geringswalde",
"492330", "Herdecke",
"496023", "Alzenau\ in\ Unterfranken",
"497153", "Plochingen",
"496531", "Bernkastel\-Kues",
"497255", "Graben\-Neudorf",
"496081", "Usingen",
"4933656", "Bahro",
"4935207", "Moritzburg",
"494848", "Rantrum",
"4938481", "Witzin",
"492152", "Kempen",
"498432", "Burgheim",
"499955", "Mamming",
"496206", "Lampertheim",
"4935365", "Falkenberg\ Elster",
"496084", "Schmitten\ Taunus",
"492224", "Bad\ Honnef",
"496534", "Mülheim\ Mosel",
"492722", "Attendorn",
"496508", "Hetzerath\ Mosel",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"4934977", "Quellendorf",
"499528", "Donnersdorf",
"494626", "Treia",
"497723", "Furtwangen\ im\ Schwarzwald",
"494735", "Butjadingen\-Stollhamm",
"496306", "Trippstadt",
"496693", "Neuental",
"495675", "Trendelburg",
"499326", "Markt\ Einersheim",
"4938756", "Grabow",
"495053", "Fassberg\-Müden",
"49781", "Offenburg",
"492324", "Hattingen\ Ruhr",
"492927", "Neuengeseke",
"49741", "Rottweil",
"499542", "Schesslitz",
"4938452", "Lalendorf",
"496897", "Sulzbach\ Saar",
"496645", "Ulrichstein",
"498253", "Pöttmes",
"496283", "Hardheim\ Odenwald",
"4938459", "Laage",
"498642", "Übersee",
"497938", "Mulfingen\ Jagst",
"498249", "Ettringen\ Wertach",
"495354", "Jerxheim",
"497307", "Senden\ Iller",
"4938204", "Broderstorf",
"497671", "Todtnau",
"4934204", "Schkeuditz",
"494553", "Geschendorf",
"499201", "Gesees",
"4933837", "Brielow",
"497022", "Nürtingen",
"493332", "Schwedt\/Oder",
"496221", "Heidelberg",
"4935973", "Stolpen",
"495957", "Lindern\ Oldenburg",
"497904", "Ilshofen",
"496185", "Hammersbach\ Hessen",
"496152", "Gross\-Gerau",
"494974", "Neuharlingersiel",
"4939741", "Jatznick",
"496835", "Beckingen",
"492520", "Wadersloh\-Diestedde",
"498628", "Kienberg\ Oberbayern",
"495939", "Sustrum",
"495254", "Paderborn\-Schloss\ Neuhaus",
"497963", "Adelmannsfelden",
"495752", "Auetal\-Hattendorf",
"494277", "Schwaförden",
"496383", "Glan\-Münchweiler",
"498349", "Stötten\ am\ Auerberg",
"499873", "Abenberg\-Wassermungenau",
"4938295", "Satow\ bei\ Bad\ Doberan",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"4934295", "Krensitz",
"492409", "Stolberg\-Gressenich",
"498054", "Breitbrunn\ am\ Chiemsee",
"492962", "Olsberg",
"496066", "Michelstadt\-Vielbrunn",
"4933872", "Hohennauen",
"4939921", "Ankershagen",
"4934343", "Regis\-Breitingen",
"499473", "Kallmünz",
"499170", "Schwanstetten",
"496435", "Wallmerod",
"499677", "Oberviechtach\-Pullenried",
"492693", "Antweiler",
"492306", "Lünen",
"494663", "Süderlügum",
"496324", "Hassloch",
"498846", "Uffing\ am\ Staffelsee",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"493731", "Freiberg\ Sachsen",
"499165", "Sugenheim",
"494467", "Wittmund\-Funnix",
"498051", "Prien\ am\ Chiemsee",
"499907", "Zenting",
"499263", "Ludwigsstadt",
"4933708", "Rangsdorf",
"498446", "Pörnbach",
"499338", "Röttingen\ Unterfranken",
"492645", "Vettelschoss",
"495251", "Paderborn",
"4934344", "Kohren\-Sahlis",
"4936640", "Remptendorf",
"492206", "Overath",
"4939825", "Wokuhl",
"499086", "Fremdingen",
"494971", "Esens",
"499536", "Kirchlauter",
"496722", "Rüdesheim\ am\ Rhein",
"499204", "Plankenfels",
"494638", "Tarp",
"4938203", "Bad\ Doberan",
"496224", "Sandhausen\ Baden",
"492534", "Münster\-Roxel",
"4936041", "Bad\ Tennstedt",
"49214", "Leverkusen",
"4935974", "Hinterhermsdorf",
"495148", "Steinhorst\ Niedersachsen",
"494604", "Grossenwiehe",
"499238", "Röslau",
"499363", "Arnstein\ Unterfranken",
"4938758", "Dömitz",
"492508", "Drensteinfurt",
"497674", "Todtmoos",
"4934203", "Zwenkau",
"495351", "Helmstedt",
"4936652", "Wurzbach",
"494925", "Hinte",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"494256", "Hilgermissen",
"496865", "Mettlach\-Orscholz",
"497933", "Creglingen",
"499656", "Moosbach\ bei\ Vohenstrauss",
"496465", "Breidenbach\ bei\ Biedenkopf",
"4936026", "Struth\ bei\ Mühlhausen",
"4936878", "Oberland",
"495802", "Wrestedt",
"492654", "Polch",
"496036", "Wölfersheim",
"4933607", "Briesen\ Mark",
"492932", "Neheim\-Hüsten",
"4933924", "Rägelin",
"493764", "Meerane",
"496586", "Beuren\ Hochwald",
"492759", "Bad\ Berleburg\-Aue",
"494558", "Todesfelde",
"4939002", "Oebisfelde",
"4939774", "Mönkebude",
"492737", "Netphen\-Deuz",
"493491", "Lutherstadt\ Wittenberg",
"498427", "Wellheim",
"498623", "Kirchweidach",
"494356", "Gross\ Wittensee",
"4938308", "Göhren\ Rügen",
"495976", "Salzbergen",
"493362", "Erkner",
"492561", "Ahaus",
"497043", "Maulbronn",
"498681", "Waging\ am\ See",
"4936200", "Elxleben\ bei\ Arnstadt",
"4933744", "Hohenseefeld",
"4933475", "Letschin",
"499452", "Langquaid",
"498684", "Fridolfing",
"4933976", "Wutike",
"494187", "Holm\-Seppensen",
"492564", "Vreden",
"494668", "Klanxbüll",
"494859", "Windbergen",
"495345", "Baddeckenstedt",
"496743", "Bacharach",
"4939773", "Altwarp",
"499566", "Meeder",
"4936074", "Worbis",
"493494", "Wolfen",
"4935930", "Seitschen",
"499333", "Sommerhausen",
"495606", "Zierenberg",
"4933743", "Blönsdorf",
"499280", "Selbitz\ Oberfranken",
"4935822", "Hagenwerder",
"499852", "Feuchtwangen",
"496375", "Wallhalben",
"499268", "Teuschnitz",
"495773", "Stemwede\-Wehdem",
"499135", "Hessdorf\ Mittelfranken",
"497625", "Zell\ im\ Wiesental",
"493761", "Werdau\ Sachsen",
"495840", "Schnackenburg",
"495245", "Herzebrock\-Clarholz",
"495195", "Neuenkirchen\ bei\ Soltau",
"492651", "Mayen",
"4936331", "Ilfeld",
"497736", "Tengen",
"494633", "Satrup",
"496173", "Kronberg\ im\ Taunus",
"492129", "Haan\ Rheinland",
"498093", "Glonn\ Kreis\ Ebersberg",
"4939422", "Badersleben",
"497502", "Wolpertswende",
"4936702", "Lauscha",
"498045", "Lenggries\-Fall",
"4937437", "Bad\ Elster",
"4939726", "Ducherow",
"496275", "Rothenberg\ Odenwald",
"499233", "Arzberg\ Oberfranken",
"4938371", "Karlshagen",
"4933923", "Flecken\ Zechlin",
"495143", "Winsen\ Aller",
"493537", "Jessen\ Elster",
"494837", "Neuenkirchen\ Dithmarschen",
"495293", "Paderborn\-Dahl",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"499944", "Miltach",
"495159", "Coppenbrügge\-Bisperode",
"496737", "Köngernheim",
"498394", "Lautrach",
"498679", "Burgkirchen\ an\ der\ Alz",
"494770", "Wischhafen",
"498272", "Wertingen",
"4936028", "Kammerforst\ Thüringen",
"4938785", "Berge\ bei\ Perleberg",
"497191", "Backnang",
"496042", "Büdingen\ Hessen",
"495621", "Bad\ Wildungen",
"4939327", "Klietz",
"492360", "Haltern\-Lippramsdorf",
"492388", "Hamm\-Uentrop",
"495072", "Neustadt\-Mandelsloh",
"4934785", "Sandersleben",
"493921", "Burg\ bei\ Magdeburg",
"496561", "Bitburg",
"499347", "Wittighausen",
"495683", "Wabern\ Hessen",
"498144", "Grafrath",
"498294", "Horgau",
"497158", "Neuhausen\ auf\ den\ Fildern",
"498372", "Obergünzburg",
"494140", "Estorf\ Kreis\ Stade",
"494443", "Dinklage",
"496028", "Sulzbach\ am\ Main",
"492865", "Raesfeld",
"4935829", "Gersdorf\ bei\ Görlitz",
"492465", "Inden",
"499197", "Egloffstein",
"495137", "Seelze",
"494843", "Viöl",
"494495", "Friesoythe\-Thüle",
"496654", "Gersfeld\ Rhön",
"4938306", "Samtens",
"498666", "Teisendorf",
"492586", "Beelen",
"492173", "Langenfeld\ Rheinland",
"496651", "Rasdorf",
"497947", "Forchtenberg",
"496129", "Schlangenbad",
"4935795", "Königsbrück",
"494102", "Ahrensburg",
"4933978", "Segeletz",
"497172", "Lorch\ Württemberg",
"497728", "Niedereschach",
"497344", "Blaubeuren",
"499523", "Hofheim\ in\ Unterfranken",
"498291", "Zusmarshausen",
"498141", "Fürstenfeldbruck",
"496503", "Hermeskeil",
"492275", "Kerpen\-Buir",
"492743", "Daaden",
"496564", "Neuerburg\ Eifel",
"498556", "Haidmühle",
"4939009", "Badel",
"4939728", "Medow\ bei\ Anklam",
"498462", "Berching",
"496698", "Schrecksbach",
"495624", "Bad\ Emstal",
"498862", "Steingaden\ Oberbayern",
"494765", "Ebersdorf\ bei\ Bremervörde",
"497244", "Weingarten\ Baden",
"498258", "Sielenbach",
"497194", "Spiegelberg",
"497742", "Klettgau",
"4933335", "Pinnow\ Kreis\ Uckermark",
"492375", "Balve",
"4939362", "Grieben\ bei\ Tangerhütte",
"499941", "Kötzting",
"498771", "Ergoldsbach",
"4938855", "Lübtheen",
"497587", "Hosskirch",
"493327", "Werder\ Havel",
"495356", "Helmstedt\-Barmke",
"496003", "Rosbach\ von\ der\ Höhe",
"4934297", "Liebertwolkwitz",
"4938297", "Moitin",
"4939039", "Bonese",
"497906", "Braunsbach",
"499531", "Ebern",
"494976", "Spiekeroog",
"499081", "Nördlingen",
"495925", "Wietmarschen",
"494402", "Rastede",
"497472", "Rottenburg\ am\ Neckar",
"4933394", "Blumberg\ Kreis\ Barnim",
"4933835", "Golzow\ bei\ Brandenburg",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"4939862", "Schmölln\ bei\ Prenzlau",
"4938355", "Züssow",
"492873", "Isselburg\-Werth",
"496500", "Waldrach",
"492473", "Simmerath",
"497761", "Bad\ Säckingen",
"498056", "Eggstätt",
"4935696", "Briesnig",
"492677", "Lutzerath",
"498841", "Murnau\ am\ Staffelsee",
"4934363", "Cavertitz",
"499409", "Pielenhofen",
"496429", "Schweinsberg\ Hessen",
"499962", "Schwarzach\ Niederbayern",
"4933679", "Wendisch\ Rietz",
"492301", "Holzwickede",
"498705", "Altfraunhofen",
"494802", "Wrohm",
"495572", "Bodenfelde",
"492304", "Schwerte",
"492165", "Jüchen",
"497764", "Herrischried",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"494245", "Neuenkirchen\ bei\ Bassum",
"495437", "Menslage",
"496326", "Deidesheim",
"494195", "Hartenholm",
"497669", "St\ Märgen",
"499306", "Kist",
"497262", "Eppingen",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"496061", "Michelstadt",
"495633", "Diemelsee",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"497458", "Ebhausen",
"498444", "Schweitenkirchen",
"496787", "Niederbrombach",
"4936376", "Straussfurt",
"494143", "Drochtersen",
"495837", "Sprakensehl",
"494293", "Ottersberg\-Fischerhude",
"492263", "Engelskirchen",
"496542", "Bullay",
"4939827", "Schwarz\ bei\ Neustrelitz",
"493933", "Genthin",
"492338", "Breckerfeld",
"4934364", "Wermsdorf",
"492204", "Bensberg",
"495594", "Bovenden\-Reyershausen",
"499084", "Bissingen\ Schwaben",
"499534", "Burgpreppach",
"499206", "Mistelgau\-Obernsees",
"495187", "Delligsen",
"497362", "Bopfingen",
"495859", "Thomasburg",
"4933451", "Heckelberg",
"49375", "Zwickau",
"496226", "Meckesheim",
"492536", "Münster\-Albachten",
"4933931", "Rheinsberg\ Mark",
"495459", "Hörstel",
"497703", "Bonndorf\ im\ Schwarzwald",
"494393", "Boostedt",
"494606", "Wanderup",
"4934779", "Abberode",
"497676", "Feldberg\ Schwarzwald",
"494773", "Lamstedt",
"4936739", "Rottenbach",
"4935329", "Dollenchen",
"492238", "Pulheim",
"492363", "Datteln",
"493968", "Schönbeck",
"4936732", "Könitz",
"4933054", "Liebenwalde",
"4934772", "Helbra",
"493344", "Bad\ Freienwalde",
"497227", "Lichtenau\ Baden",
"499383", "Wiesentheid",
"4935205", "Ottendorf\-Okrilla",
"495647", "Lichtenau\-Kleinenberg",
"496873", "Nonnweiler",
"4935322", "Doberlug\-Kirchhain",
"499835", "Ehingen\ Mittelfranken",
"495443", "Lemförde",
"498634", "Garching\ an\ der\ Alz",
"499435", "Schwarzenfeld",
"492064", "Dinslaken",
"495843", "Wustrow\ Wendland",
"495495", "Vörden\ Kreis\ Vechta",
"494137", "Barendorf",
"496677", "Neuenstein\ Hessen",
"496473", "Leun",
"494630", "Barderup",
"492429", "Hürtgenwald",
"493947", "Thale",
"496301", "Otterbach\ Pfalz",
"499321", "Kitzingen",
"4936464", "Wormstedt",
"4936840", "Trusetal",
"494621", "Schleswig",
"4935698", "Hornow",
"498545", "Hofkirchen\ Bayern",
"4934423", "Heuckewalde",
"494159", "Basthorst",
"499283", "Rehau",
"4938871", "Mühlen\ Eichsen",
"497327", "Dischingen",
"499185", "Mühlhausen\ Oberpfalz",
"499152", "Hartenstein\ Mittelfranken",
"494487", "Grossenkneten\-Huntlosen",
"4938423", "Bad\ Kleinen",
"494683", "Oldsum",
"499221", "Kulmbach",
"498593", "Untergriesbach",
"4938737", "Ganzlin",
"4939997", "Jarmen",
"496201", "Weinheim\ Bergstr",
"499722", "Werneck",
"496204", "Viernheim",
"499178", "Abenberg\ Mittelfranken",
"4936378", "Ostramondra",
"492955", "Büren\-Wewelsburg",
"496086", "Grävenwiesbach",
"492982", "Medebach",
"492226", "Rheinbach",
"4933672", "Pfaffendorfb\ Beeskow",
"496536", "Kleinich",
"4934424", "Reuden\ bei\ Zeitz",
"4938424", "Bobitz",
"495765", "Raddestorf",
"496363", "Niederkirchen",
"494624", "Kropp",
"492528", "Ennigerloh\-Enniger",
"4937291", "Augustusburg",
"496238", "Dirmstein",
"496304", "Wolfstein\ Pfalz",
"496165", "Breuberg",
"499748", "Motten",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"499324", "Dettelbach",
"4934975", "Görzig\ Kreis\ Köthen",
"497543", "Kressbronn\ am\ Bodensee",
"4933637", "Beerfelde",
"498631", "Mühldorf\ am\ Inn",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"4936463", "Gebstedt",
"496338", "Hornbach\ Pfalz",
"499927", "Kirchberg\ Wald",
"495102", "Laatzen",
"496263", "Neckargerach",
"492542", "Gescher",
"497930", "Boxberg\ Baden",
"493341", "Strausberg",
"499946", "Hohenwarth\ bei\ Kötzing",
"495448", "Barver",
"498407", "Grossmehring",
"499360", "Thüngen",
"493723", "Hohenstein\-Ernstthal",
"492944", "Rietberg\-Mastholte",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"4938844", "Gülze",
"496478", "Greifenstein\-Ulm",
"4938233", "Prerow\ Ostseebad",
"498807", "Diessen\ am\ Ammersee",
"498551", "Freyung",
"495848", "Trebel",
"4939051", "Calvörde",
"498146", "Moorenweis",
"497449", "Baiersbronn\-Obertal",
"495422", "Melle",
"499260", "Wilhelmsthal\ Oberfranken",
"499865", "Adelshofen\ Mittelfranken",
"498296", "Villenbach",
"499288", "Bad\ Steben",
"49341", "Leipzig",
"497975", "Untergröningen",
"492247", "Neunkirchen\-Seelscheid",
"4939325", "Vinzelberg",
"4935056", "Altenberg\ Sachsen",
"4939202", "Gross\ Ammensleben",
"4938787", "Glöwen",
"49451", "Lübeck",
"49381", "Rostock",
"4936601", "Hermsdorf\ Thüringen",
"4937609", "Wolkenburg\ Mulde",
"496656", "Ebersburg",
"499465", "Neukirchen\-Balbini",
"495822", "Ebstorf",
"498664", "Chieming",
"494167", "Apensen",
"492584", "Warendorf\-Milte",
"492581", "Warendorf",
"4933337", "Altkünkendorf",
"493382", "Lehnin",
"497522", "Wangen\ im\ Allgäu",
"498661", "Grabenstätt\ Chiemsee",
"499173", "Thalmässing",
"496135", "Bodenheim\ Rhein",
"496233", "Frankenthal\ Pfalz",
"492523", "Wadersloh",
"4933439", "Fredersdorf\-Vogelsdorf",
"499275", "Speichersdorf",
"497346", "Illerkirchberg",
"4939082", "Mieste",
"494550", "Bühnsdorf",
"496566", "Körperich",
"498554", "Schönberg\ Niederbayern",
"496452", "Battenberg\ Eder",
"496485", "Nentershausen\ Westerwald",
"4935797", "Schwepnitz",
"4934638", "Zöschen",
"4934909", "Aken\ Elbe",
"495626", "Bad\ Zwesten",
"496852", "Nohfelden",
"497246", "Malsch\ Kreis\ Karlsruhe",
"499375", "Freudenberg\ Baden",
"496268", "Hüffenhardt",
"492941", "Lippstadt",
"4938843", "Bennin",
"496333", "Waldfischbach\-Burgalben",
"4939342", "Gladau",
"4938234", "Born\ Darss",
"4933477", "Trebnitz\ bei\ Müncheberg",
"497567", "Leutkirch\-Friesenhofen",
"496008", "Echzell",
"49711", "Stuttgart",
"494939", "Baltrum",
"494254", "Eystrup",
"4939391", "Lückstedt",
"494752", "Neuhaus\ Oste",
"498250", "Hilgertshausen\-Tandern",
"4939349", "Parey\ Elbe",
"495277", "Höxter\-Fürstenau",
"499654", "Pleystein",
"499932", "Osterhofen",
"496247", "Worms\-Pfeddersheim",
"4939089", "Bismark\ Altmark",
"496034", "Wöllstadt",
"492656", "Virneburg",
"496584", "Wellen\ Mosel",
"497731", "Singen\ Hohentwiel",
"4935058", "Pretzschendorf",
"495601", "Schauenburg",
"4936624", "Teichwolframsdorf",
"4933432", "Müncheberg",
"4933605", "Boossen",
"495377", "Ehra\-Lessien",
"4939453", "Derenburg",
"497720", "Schwenningen\ am\ Neckar",
"494354", "Fleckeby",
"499737", "Wartmannsroth",
"4938793", "Dergenthin",
"496347", "Hochstadt\ Pfalz",
"499561", "Coburg",
"493901", "Salzwedel",
"494957", "Detern",
"4939933", "Vollrathsruhe",
"495553", "Kalefeld",
"4937752", "Eibenstock",
"4933764", "Mittenwalde\ Mark",
"4938320", "Tribsees",
"49340", "Dessau\ Anh",
"498686", "Petting",
"4939209", "Wanzleben",
"497853", "Kehl\-Bodersweier",
"492566", "Legden",
"4936623", "Berga\ Elster",
"497332", "Lauterstein",
"492452", "Heinsberg\ Rheinland",
"493904", "Haldensleben",
"492485", "Schleiden\-Dreiborn",
"499564", "Bad\ Rodach",
"4937435", "Reuth\ bei\ Plauen",
"4937602", "Kirchberg\ Sachsen",
"495971", "Rheine",
"4939454", "Elbingerode\ Harz",
"493496", "Köthen\ Anhalt",
"492333", "Ennepetal",
"4939934", "Gross\ Plasten",
"493307", "Zehdenick",
"494351", "Eckernförde",
"49821", "Augsburg",
"492852", "Hamminkeln",
"492268", "Kürten",
"496020", "Heigenbrücken",
"4938794", "Cumlosen",
"494298", "Lilienthal",
"494148", "Drochtersen\-Assel",
"497657", "Eisenbach\ Hochschwarzwald",
"4933763", "Bestensee",
"495604", "Grossalmerode",
"493671", "Saalfeld\ Saale",
"497150", "Korntal\-Münchingen",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"497453", "Altensteig\ Württemberg",
"496581", "Saarburg",
"499129", "Wendelstein",
"497232", "Königsbach\-Stein",
"495663", "Spangenberg",
"496031", "Friedberg\ Hessen",
"497734", "Gailingen",
"495467", "Voltlage",
"496109", "Frankfurt\-Bergen\-Enkheim",
"499651", "Vohenstrauss",
"493963", "Woldegk",
"49831", "Kempten\ Allgäu",
"494251", "Hoya",
"499503", "Oberhaid\ Oberfranken",
"492368", "Oer\-Erkenschwick",
"492233", "Hürth\ Rheinland",
"496523", "Holsthum",
"494778", "Wingst",
"494122", "Uetersen",
"4934636", "Schafstädt",
"497708", "Geisingen\-Leipferdingen",
"4933981", "Putlitz",
"494529", "Süsel\-Bujendorf",
"4938874", "Lützow",
"495565", "Einbeck\-Wenzen",
"4935249", "Basslitz",
"497275", "Kandel",
"499346", "Grünsfeld",
"494205", "Ottersberg",
"496625", "Niederaula",
"494103", "Wedel",
"4937293", "Eppendorf\ Sachsen",
"4939296", "Welsleben",
"496736", "Bechenheim",
"499605", "Weiherhammer",
"498404", "Oberdolling",
"497173", "Heubach",
"499522", "Eltmann",
"496502", "Schweich",
"492947", "Anröchte",
"4989", "Munich",
"492742", "Wissen",
"4936257", "Luisenthal\ Thüringen",
"4937367", "Lengefeld\ Erzgebirge",
"492244", "Königswinter\-Oberpleis",
"494305", "Westensee",
"494164", "Harsefeld",
"492587", "Ennigerloh\-Westkirchen",
"4933051", "Nassenheide",
"498667", "Seeon\-Seebruck",
"495136", "Burgdorf\ Kreis\ Hannover",
"4935027", "Weesenstein",
"499246", "Pegnitz\-Trockau",
"498463", "Greding",
"497375", "Obermarchtal",
"499196", "Wiesenttal",
"494646", "Mohrkirch",
"4936461", "Bad\ Sulza",
"497743", "Ühlingen\-Birkendorf",
"499548", "Mühlhausen\ Mittelfranken",
"4934600", "Ostrau\ Saalkreis",
"4933202", "Töplitz",
"4939959", "Dargun",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"498273", "Nordendorf",
"496043", "Nidda",
"494161", "Buxtehude",
"4937322", "Brand\-Erbisdorf",
"495073", "Neustadt\-Esperke",
"4938750", "Malliss",
"496095", "Bessenbach",
"493528", "Radeberg",
"494828", "Lägerdorf",
"497388", "Pfronstetten",
"497946", "Bretzfeld",
"492191", "Remscheid",
"495655", "Wanfried",
"492241", "Siegburg",
"495682", "Borken\ Hessen",
"4938826", "Dassow",
"497465", "Emmingen\-Liptingen",
"498373", "Altusried",
"4938873", "Carlow",
"494442", "Lohne\ Oldenburg",
"4933082", "Menz\ Kreis\ Oberhavel",
"497586", "Herbertingen",
"498557", "Mauth",
"498801", "Seeshaupt",
"492158", "Grefrath\ bei\ Krefeld",
"4937294", "Grünhainichen",
"494842", "Nordstrand",
"499975", "Waldmünchen\-Geigant",
"498745", "Bodenkirchen",
"493542", "Lübbenau\ Spreewald",
"4936648", "Dittersdorf\ bei\ Schleiz",
"497260", "Sinsheim\-Hilsbach",
"4939298", "Barby\ Elbe",
"496244", "Westhofen\ Rheinhessenen",
"494339", "Christiansholm",
"499453", "Thalmassing",
"496742", "Boppard",
"499657", "Waldthurn",
"495461", "Bramsche\ Hase",
"498074", "Schnaitsee",
"496587", "Zerf",
"497564", "Bad\ Wurzach",
"495861", "Dannenberg\ Elbe",
"499332", "Marktbreit",
"495274", "Nieheim",
"49212", "Solingen",
"494257", "Schweringen",
"4933089", "Himmelpfort",
"495128", "Hohenhameln",
"495772", "Espelkamp",
"499853", "Wilburgstetten",
"499708", "Bad\ Bocklet",
"495977", "Spelle",
"496728", "Ober\-Hilbersheim",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"4937329", "Grosshartmannsdorf",
"494954", "Moormerland",
"494632", "Steinbergkirche",
"494239", "Dörverden\-Westen",
"496344", "Schwegenheim",
"498092", "Grafing\ bei\ München",
"4939885", "Jakobshagen",
"497503", "Wilhelmsdorf\ Württemberg",
"4939605", "Gross\ Nemerow",
"493677", "Ilmenau\ Thüringen",
"49355", "Cottbus",
"492736", "Burbach\ Siegerl",
"492625", "Ochtendung",
"496059", "Jossgrund",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"4939952", "Grammentin",
"497651", "Titisee\-Neustadt",
"492502", "Nottuln",
"493301", "Oranienburg",
"499734", "Burkardroth",
"494357", "Sehestedt\ Eider",
"4935877", "Cunewalde",
"495292", "Lichtenau\-Atteln",
"498426", "Walting\ Kreis\ Eichstätt",
"499639", "Mähring",
"497129", "Lichtenstein\ Württemberg",
"495142", "Eschede",
"4933933", "Lindow\ Mark",
"495374", "Isenbüttel",
"499232", "Wunsiedel",
"493304", "Velten",
"4937462", "Rothenkirchen\ Vogtland",
"4933454", "Wölsickendorf\/Wollenberg",
"495371", "Gifhorn",
"4933209", "Caputh",
"495403", "Bad\ Iburg",
"497654", "Löffingen",
"4938828", "Schönberg",
"495607", "Fuldatal",
"497932", "Niederstetten\ Württemberg",
"496158", "Riedstadt",
"494186", "Buchholz\-Trelde",
"495803", "Rosche",
"4933966", "Dranse",
"493338", "Bernau\ Brandenburg",
"492933", "Sundern\ Sauerland",
"49911", "Nuremberg",
"4934495", "Dobitschen",
"499567", "Sesslach\-Gemünda",
"496341", "Landau\ in\ der\ Pfalz",
"493907", "Gardelegen",
"494951", "Weener",
"495271", "Höxter",
"498505", "Hutthurm",
"494836", "Hennstedt\ Dithmarschen",
"497561", "Leutkirch\ im\ Allgäu",
"498622", "Tacherting\-Peterskirchen",
"495864", "Jameln",
"492043", "Gladbeck",
"4936646", "Tanna\ bei\ Schleiz",
"495464", "Alfhausen",
"4935242", "Nossen",
"498071", "Wasserburg\ am\ Inn",
"4934361", "Dahlen\ Sachsen",
"499720", "Üchtelhausen",
"496241", "Worms",
"497042", "Vaihingen\ an\ der\ Enz",
"495509", "Rosdorf\ Kreis\ Göttingen",
"492692", "Kelberg",
"49641", "Giessen",
"4939222", "Möser",
"495181", "Alfeld\ Leine",
"494662", "Leck",
"4935955", "Pulsnitz",
"4936621", "Elsterberg\ bei\ Plauen",
"494269", "Ahausen\-Kirchwalsede",
"497645", "Freiamt",
"495956", "Rastdorf",
"4936206", "Grossfahner",
"495820", "Suhlendorf",
"495225", "Spenge",
"497306", "Vöhringen\ Iller",
"499262", "Wallenfels",
"495123", "Schellerten",
"4935602", "Drebkau",
"494796", "Teufelsmoor",
"4936969", "Merkers",
"499764", "Höchheim",
"4935435", "Gollmitz\ bei\ Calau",
"498025", "Miesbach",
"49681", "Saarbrücken",
"492674", "Bad\ Bertrich",
"4939394", "Hohenberg\-Krusemark",
"499491", "Hemau",
"4936020", "Ebeleben",
"492779", "Greifenstein\-Beilstein",
"495431", "Quakenbrück",
"4939482", "Gatersleben",
"499676", "Winklarn",
"495325", "Goslar\-Hahnenklee",
"496723", "Oestrich\-Winkel",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"494276", "Borstel\ bei\ Sulingen",
"497084", "Schömberg\ bei\ Neuenbürg",
"497534", "Reichenau\ Baden",
"495831", "Wittingen",
"496781", "Idar\-Oberstein",
"497531", "Konstanz",
"495834", "Wittingen\-Knesebeck",
"4939856", "Beenz\ bei\ Prenzlau",
"496255", "Lindenfels",
"496282", "Walldürn",
"497081", "Bad\ Wildbad",
"4934929", "Straach",
"4939393", "Werben\ Elbe",
"496784", "Weierbach",
"499906", "Mariaposching",
"4939245", "Loburg",
"492904", "Bestwig",
"494552", "Leezen",
"492307", "Kamen",
"492938", "Ense",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"497023", "Weilheim\ an\ der\ Teck",
"494466", "Wittmund\-Ardorf",
"498847", "Obersöchering",
"492671", "Cochem",
"495808", "Gerdau",
"495434", "Essen\ Oldenburg",
"497962", "Fichtenau",
"494479", "Molbergen\-Peheim",
"499872", "Heilsbronn",
"494945", "Grossefehn\-Timmel",
"4935752", "Ruhland",
"498106", "Vaterstetten",
"4939451", "Wasserleben",
"496382", "Lauterecken",
"496355", "Albisheim\ Pfrimm",
"495753", "Auetal\-Bernsen",
"4935936", "Sohland\ Spree",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"4933970", "Neustadt\ Dosse",
"4939267", "Schneidlingen",
"499087", "Marktoffingen",
"497520", "Bodnegg",
"4935456", "Terpt",
"492207", "Kürten\-Dürscheid",
"492963", "Brilon\-Messinghausen",
"499472", "Hohenfels\ Oberpfalz",
"4939931", "Röbel\ Müritz",
"495184", "Freden\ Leine",
"4938791", "Bad\ Wilsnack",
"495166", "Walsrode\-Kirchboitzen",
"4934446", "Grosskorbetha",
"498433", "Königsmoos",
"494134", "Embsen\ Kreis\ Lüneburg",
"496674", "Friedewald\ Hessen",
"498637", "Lohkirchen",
"4939054", "Flechtingen",
"4938300", "Insel\ Hiddensee",
"493944", "Blankenburg\ Harz",
"492723", "Kirchhundem",
"4936604", "Münchenbernsdorf",
"4934742", "Sylda",
"4936927", "Unterellen",
"499921", "Regen",
"497722", "Triberg\ im\ Schwarzwald",
"498385", "Hergatz",
"495644", "Willebadessen\-Peckelsheim",
"497224", "Gernsbach",
"494108", "Rosengarten\ Kreis\ Harburg",
"4936208", "Ermstedt",
"498468", "Altmannstein\-Pondorf",
"49241", "Aachen",
"496692", "Neustadt\ Hessen",
"494484", "Hude\-Wüsting",
"495085", "Burgdorf\-Ehlershausen",
"495052", "Hermannsburg",
"495535", "Polle",
"4936695", "Söllmnitz",
"4936870", "Masserberg",
"4934922", "Mühlanger",
"499543", "Hirschaid",
"498121", "Markt\ Schwaben",
"494884", "Schwabstedt",
"497748", "Grafenhausen\ Hochschwarzwald",
"496766", "Kisselbach",
"498754", "Volkenschwand",
"4938841", "Neuhaus\ Elbe",
"497324", "Herbrechtingen",
"498868", "Schwabsoien",
"498285", "Burtenbach",
"49281", "Wesel",
"498252", "Schrobenhausen",
"497321", "Heidenheim\ an\ der\ Brenz",
"4939387", "Havelberg",
"492382", "Ahlen\ Westfalen",
"498751", "Mainburg",
"492355", "Schalksmühle",
"494881", "Friedrichstadt",
"493581", "Görlitz",
"4938725", "Gross\ Godems",
"497066", "Bad\ Rappenau\-Bonfeld",
"496048", "Büdingen\-Eckartshausen",
"494120", "Ellerhoop",
"494423", "Fedderwarden",
"498124", "Forstern\ Oberbayern",
"497435", "Albstadt\-Laufen",
"494627", "Dörpstedt",
"497835", "Zell\ am\ Harmersbach",
"4939858", "Bietikow",
"4939489", "Strassberg\ Harz",
"496207", "Wald\-Michelbach",
"499227", "Neuenmarkt",
"4938231", "Barth",
"497383", "Münsingen\-Buttenhausen",
"494823", "Wilster",
"493523", "Coswig\ bei\ Dresden",
"494481", "Hatten\-Sandkrug",
"4935609", "Drachhausen",
"497221", "Baden\-Baden",
"492689", "Dierdorf",
"496022", "Obernburg\ am\ Main",
"4936962", "Vacha",
"49471", "Bremerhaven",
"492850", "Rees\-Haldern",
"492255", "Euskirchen\-Flamersheim",
"495641", "Warburg",
"499924", "Bodenmais",
"497152", "Leonberg\ Württemberg",
"4939053", "Süplingen",
"498378", "Buchenberg\ bei\ Kempten",
"493941", "Halberstadt",
"4936603", "Weida",
"496307", "Schopp",
"492153", "Nettetal\-Lobberich",
"4935938", "Grosspostwitz\ OL",
"494131", "Lüneburg",
"494275", "Ehrenburg",
"4933678", "Storkow\ Mark",
"496837", "Wallerfangen",
"495542", "Witzenhausen",
"497529", "Waldburg\ Württemberg",
"498261", "Mindelheim",
"492102", "Ratingen",
"4936372", "Kleinneuhausen",
"4939244", "Steutz",
"496572", "Manderscheid\ Eifel",
"4938332", "Gross\ Bisdorf",
"495326", "Langelsheim",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"499675", "Altendorf\ am\ Nabburg",
"494173", "Wulfsen",
"496633", "Homberg\ Ohm",
"4935727", "Burghammer",
"494795", "Garlstedt",
"497164", "Boll\ Kreis\ Göppingen",
"497305", "Erbach\ Donau",
"4939038", "Henningen",
"495528", "Gieboldehausen",
"498026", "Hausham",
"4936337", "Schiedungen",
"493682", "Zella\-Mehlis",
"4935433", "Vetschau",
"498361", "Nesselwang",
"4935953", "Burkau",
"4938377", "Zinnowitz",
"496594", "Birresborn",
"496187", "Schöneck",
"494743", "Langen\ bei\ Bremerhaven",
"495226", "Bruchmühlen\ Westfalen",
"4937431", "Mehltheuer\ Vogtland",
"497646", "Weisweil\ Breisgau",
"495955", "Esterwegen",
"496668", "Birstein\-Lichenroth",
"4936738", "Königsee",
"498203", "Grossaitingen",
"4935434", "Altdöbern",
"496591", "Gerolstein",
"497428", "Rosenfeld",
"4933601", "Podelzig",
"4935954", "Grossharthau",
"496356", "Carlsberg\ Pfalz",
"498364", "Seeg",
"498105", "Gilching",
"494946", "Grossefehn\-Bagband",
"492770", "Eschenburg",
"497161", "Göppingen",
"493886", "Gadebusch",
"492843", "Rheinberg",
"496558", "Büdesheim\ Eifel",
"495064", "Gross\ Düngen",
"499167", "Oberscheinfeld",
"4934651", "Rossla",
"494465", "Friedeburg\ Ostfriesland",
"498303", "Waltenhofen",
"4935692", "Kerkwitz",
"49951", "Bamberg",
"497442", "Baiersbronn",
"495429", "Melle\-Wellingholzhausen",
"496256", "Lampertheim\-Hüttenfeld",
"497842", "Kappelrodeck",
"495829", "Wriedel",
"494288", "Horstedt\ Kreis\ Rotenburg",
"499905", "Bernried\ Niederbayern",
"498762", "Wartenberg\ Oberbayern",
"494260", "Visselhövede\-Wittorf",
"494865", "Osterhever",
"4939243", "Nedlitz\ bei\ Zerbst",
"492443", "Mechernich",
"492647", "Kesseling",
"4939395", "Wanzer",
"493464", "Sangerhausen",
"499351", "Gemünden\ am\ Main",
"496765", "Gemünden\ Hunsrück",
"4936693", "Crossen\ an\ der\ Elster",
"495363", "Wolfsburg\-Vorsfelde",
"495238", "Nieheim\-Himmighausen",
"499148", "Ettenstatt",
"4933676", "Friedland\ bei\ Beeskow",
"495702", "Petershagen\-Lahde",
"492594", "Dülmen",
"495204", "Steinhagen\ Westfalen",
"497257", "Bruchsal\-Untergrombach",
"4938724", "Siggelkow",
"49861", "Traunstein",
"495536", "Holzminden\-Neuhaus",
"492680", "Mündersbach",
"492859", "Wesel\-Bislich",
"498038", "Vogtareuth",
"495086", "Celle\-Scheuen",
"494564", "Schashagen",
"492837", "Weeze",
"497573", "Stetten\ am\ kalten\ Markt",
"494503", "Timmendorfer\ Strand",
"499251", "Münchberg",
"498386", "Oberstaufen",
"496102", "Neu\-Isenburg",
"499398", "Birkenfeld\ bei\ Würzburg",
"499778", "Fladungen",
"499122", "Schwabach",
"495263", "Barntrup",
"497632", "Badenweiler",
"495907", "Geeste",
"497954", "Kirchberg\ an\ der\ Jagst",
"498727", "Falkenberg\ Niederbayern",
"497357", "Attenweiler",
"495304", "Meine",
"495165", "Rethem\ Aller",
"492572", "Emsdetten",
"4939036", "Binde",
"493371", "Luckenwalde",
"494129", "Haseldorf",
"498063", "Feldkirchen\-Westerham",
"492633", "Brohl\-Lützing",
"495677", "Calden\-Westuffeln",
"498650", "Marktschellenberg",
"492558", "Horstmar",
"496843", "Gersheim",
"4939321", "Arneburg",
"498157", "Feldafing",
"495473", "Ostercappeln",
"494932", "Norderney",
"495301", "Lehre\-Essenrode",
"4936605", "Bad\ Köstritz",
"497951", "Crailsheim",
"492256", "Mechernich\-Satzvey",
"4939055", "Hörsingen",
"4936764", "Neuhaus\-Schierschnitz",
"492925", "Warstein\-Allagen",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"495873", "Eimke",
"496647", "Herbstein\-Stockhausen",
"4936736", "Arnsgereuth",
"496443", "Ehringshausen\ Dill",
"499254", "Gefrees",
"4934776", "Rothenschirmbach",
"497836", "Schiltach",
"493861", "Plate",
"494561", "Neustadt\ in\ Holstein",
"492591", "Lüdinghausen",
"4936694", "Schkölen\ Thüringen",
"495201", "Halle\ Westfalen",
"493772", "Schneeberg\ Erzgebirge",
"494737", "Stadland\-Schwei",
"499354", "Rieneck",
"4936379", "Holzengel",
"493461", "Merseburg\ Saale",
"497436", "Messstetten\-Oberdigisheim",
"498139", "Röhrmoos",
"4938723", "Kladrum",
"499293", "Berg\ Oberfranken",
"499143", "Pappenheim\ Mittelfranken",
"497269", "Sulzfeld\ Baden",
"495233", "Steinheim\ Westfalen",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"495368", "Parsau",
"4937608", "Waldenburg\ Sachsen",
"4936451", "Buttelstedt",
"4937204", "Lichtenstein\ Sachsen",
"492867", "Heiden\ Kreis\ Borken",
"4936940", "Oepfershausen",
"492663", "Westerburg\ Westerwald",
"498033", "Oberaudorf",
"498583", "Neureichenau",
"499195", "Adelsdorf\ Mittelfranken",
"497376", "Langenenslingen",
"499245", "Obertrubach",
"494497", "Barssel\-Harkebrügge",
"495135", "Burgwedel\-Fuhrberg",
"499773", "Unsleben",
"4939346", "Tucheim",
"4937343", "Jöhstadt",
"495852", "Bleckede",
"496626", "Wildeck\-Obersuhl",
"499606", "Pfreimd",
"499393", "Rothenfels\ Unterfranken",
"496735", "Eppelsheim",
"495333", "Dettum",
"494508", "Krummesse",
"4937295", "Lugau\ Erzgebirge",
"497578", "Wald\ Hohenz",
"492604", "Nassau\ Lahn",
"494534", "Steinburg\ Kreis\ Storman",
"493834", "Greifswald",
"4935341", "Bad\ Liebenwerda",
"4939400", "Wefensleben",
"49201", "Essen",
"4934262", "Falkenhain\ bei\ Wurzen",
"492638", "Waldbreitbach",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"499345", "Külsheim\ Baden",
"492971", "Schmallenberg\-Dorlar",
"4939086", "Jävenitz",
"495485", "Ladbergen",
"495452", "Mettingen\ Westfalen",
"494206", "Stuhr\-Heiligenrode",
"492974", "Schmallenberg\-Fredeburg",
"4936482", "Triptis",
"4937344", "Crottendorf\ Sachsen",
"499976", "Rötz",
"494531", "Bad\ Oldesloe",
"493831", "Stralsund",
"496848", "Homburg\-Einöd",
"492553", "Ochtrup",
"4934639", "Wallendorf\ Luppe",
"497466", "Beuron",
"494767", "Bremervörde\-Bevern",
"493431", "Döbeln",
"492601", "Nauort",
"497585", "Ostrach",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"497552", "Pfullendorf",
"492377", "Wickede\ Ruhr",
"4938227", "Lüdershagen\ bei\ Barth",
"496096", "Wiesen\ Unterfranken",
"492992", "Marsberg",
"4935052", "Kipsdorf\ Kurort",
"499802", "Ansbach\-Katterbach",
"498176", "Egling\ bei\ Wolfratshausen",
"4933438", "Altlandsberg",
"494962", "Papenburg\-Aschendorf",
"4937203", "Gersdorf\ bei\ Chemnitz",
"494409", "Westerstede\-Ocholt",
"4939206", "Eichenbarleben",
"497945", "Wüstenrot",
"495656", "Waldkappel",
"496422", "Kirchhain",
"499402", "Regenstauf",
"4935201", "Langebrück",
"4934494", "Ehrenhain",
"492735", "Neunkirchen\ Siegerl",
"498331", "Memmingen",
"495941", "Neuenhaus\ Dinkel",
"4934382", "Nerchau",
"4939754", "Löcknitz\ Vorpom",
"492626", "Selters\ Westferwald",
"499729", "Grettstadt",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"499624", "Ensdorf\ Oberpfalz",
"497134", "Weinsberg",
"496638", "Schwalmtal\-Renzendorf",
"498825", "Krün",
"494178", "Radbruch",
"494722", "Cuxhaven\-Altenbruch",
"4939603", "Burg\ Stargard",
"494224", "Gross\ Ippener",
"4939883", "Gross\ Dölln",
"493641", "Jena",
"4937606", "Lengenfeld\ Vogtland",
"4933230", "Börnicke\ Kreis\ Havelland",
"498231", "Königsbrunn\ bei\ Augsburg",
"495523", "Bad\ Sachsa",
"4934632", "Mücheln\ Geiseltal",
"496867", "Perl",
"4939088", "Letzlingen",
"494927", "Krummhörn\-Loquard",
"497484", "Simmersfeld",
"494324", "Brokstedt",
"496663", "Steinau\ an\ der\ Strasse",
"495031", "Wunstorf",
"4939348", "Klitsche",
"494748", "Stubben\ bei\ Bremerhaven",
"499091", "Monheim\ Schwaben",
"495109", "Ronnenberg",
"496467", "Hatzfeld\ Eder",
"498320", "Missen\-Wilhams",
"497423", "Oberndorf\ am\ Neckar",
"497627", "Steinen\ Kreis\ Lörrach",
"498208", "Eurasburg\ bei\ Augsburg",
"495197", "Soltau\-Frielingen",
"494435", "Grossenkneten",
"495247", "Harsewinkel",
"499094", "Tagmersheim",
"495584", "Hattorf\ am\ Harz",
"496050", "Biebergemünd",
"492822", "Emmerich",
"495034", "Neustadt\-Hagen",
"494321", "Neumünster",
"498506", "Bad\ Höhenstadt",
"492422", "Kreuzau",
"4939747", "Züsedom",
"4938351", "Mesekenhagen",
"494835", "Albersdorf\ Holstein",
"498732", "Frontenhausen",
"494230", "Verden\-Walle",
"493535", "Herzberg\ Elster",
"4933831", "Weseram",
"498234", "Bobingen",
"497823", "Seelbach\ Schutter",
"4934906", "Raguhn",
"494383", "Grebin",
"4937756", "Breitenbrunn\ Erzgebirge",
"499683", "Friedenfels",
"495347", "Burgdorf\ bei\ Salzgitter",
"4939753", "Strasburg",
"494152", "Geesthacht",
"494185", "Marxen\ Auetal",
"4934493", "Gössnitz\ Thüringen",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"496553", "Schönecken",
"493644", "Apolda",
"49771", "Donaueschingen",
"494221", "Delmenhorst",
"499072", "Lauingen\ Donau",
"4939927", "Nossentiner\ Hütte",
"4939884", "Hassleben\ bei\ Prenzlau",
"4939604", "Wildberg\ bei\ Altentreptow",
"497131", "Heilbronn\ Neckar",
"499621", "Amberg\ Oberpfalz",
"492448", "Hellenthal\-Rescheid",
"4933436", "Prötzel",
"498334", "Bad\ Grönenbach",
"494283", "Tarmstedt",
"4939208", "Loitsche",
"494330", "Emkendorf",
"495944", "Hoogstede",
"496073", "Babenhausen\ Hessen",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"499552", "Burghaslach",
"492464", "Aldenhoven\ bei\ Jülich",
"4937326", "Frauenstein\ Sachsen",
"494494", "Bösel\ Oldenburg",
"4939323", "Schönhausen\ Elbe",
"4937468", "Treuen\ Vogtland",
"498193", "Geltendorf",
"496682", "Tann\ Rhön",
"499466", "Stamsried",
"496655", "Neuhof\ Kreis\ Fulda",
"498243", "Fuchstal",
"498295", "Altenmünster\ Schwaben",
"4939061", "Weferlingen",
"498145", "Mammendorf",
"493594", "Bischofswerda",
"497976", "Sulzbach\-Laufen",
"492271", "Bergheim\ Erft",
"495043", "Lauenau",
"492864", "Reken",
"4938450", "Tarnow\ bei\ Bützow",
"494559", "Wensin",
"492758", "Bad\ Berleburg\-Girkhausen",
"492803", "Wesel\-Büderich",
"494537", "Sülfeld\ Holstein",
"497402", "Fluorn\-Winzeln",
"498343", "Aitrang",
"4934721", "Nienburg\ Saale",
"495933", "Lathen",
"494472", "Lastrup",
"4938721", "Ziegendorf",
"4933086", "Grieben\ Kreis\ Oberhavel",
"492371", "Iserlohn",
"494872", "Hanerau\-Hademarschen",
"499945", "Arnbruck",
"497802", "Oberkirch\ Baden",
"498395", "Tannheim\ Württemberg",
"494761", "Bremervörde",
"4935248", "Schönfeld\ bei\ Grossenhain",
"492607", "Kobern\-Gondorf",
"493437", "Grimma",
"492403", "Eschweiler\ Rheinland",
"497195", "Winnenden",
"499376", "Collenberg",
"497245", "Durmersheim",
"4936649", "Gefell\ bei\ Schleiz",
"494764", "Gnarrenburg\-Klenkendorf",
"495625", "Naumburg\ Hessen",
"494262", "Visselhövede",
"4936691", "Eisenberg\ Thüringen",
"494858", "Sankt\ Margarethen\ Holstein",
"4939292", "Biederitz",
"492374", "Iserlohn\-Letmathe",
"492292", "Windeck\ Sieg",
"495502", "Dransfeld",
"4938845", "Kaarssen",
"493925", "Stassfurt",
"492977", "Schmallenberg\-Bödefeld",
"496565", "Dudeldorf",
"494458", "Wiefelstede\-Spohle",
"497440", "Bad\ Rippoldsau",
"497143", "Besigheim",
"499269", "Tettau\ Kreis\ Kronach",
"496486", "Katzenelnbogen",
"499662", "Vilseck",
"494362", "Heiligenhafen",
"492861", "Borken\ Westfalen",
"4933206", "Fichtenwalde",
"499276", "Bischofsgrün",
"497345", "Langenau\ Württemberg",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"492772", "Herborn\ Hessen",
"492274", "Elsdorf\ Rheinland",
"4939324", "Kläden\ bei\ Stendal",
"492392", "Werdohl",
"493591", "Bautzen",
"494491", "Friesoythe",
"499369", "Uettingen",
"497393", "Munderkingen",
"494703", "Loxstedt\-Donnern",
"4933969", "Stepenitz",
"4936761", "Heubisch",
"492461", "Jülich",
"497773", "Bodman\-Ludwigshafen",
"496136", "Nieder\-Olm",
"499823", "Leutershausen",
"495158", "Hemeringen",
"498678", "Marktl",
"496803", "Mandelbachtal\-Ommersheim",
"499481", "Pfatter",
"4933962", "Heiligengrabe",
"492389", "Werne",
"495341", "Salzgitter",
"4939455", "Schierke",
"496371", "Landstuhl",
"4937434", "Bobenneukirchen",
"499627", "Freudenberg\ Oberpfalz",
"496403", "Linden\ Hessen",
"4937328", "Grossschirma",
"499423", "Geiselhöring",
"499120", "Leinburg",
"4933603", "Falkenhagen\ bei\ Seelow",
"4933088", "Falkenthal",
"498456", "Lenting",
"497159", "Renningen",
"496464", "Angelburg",
"494327", "Grossenaspe",
"4934653", "Rottleberode",
"499131", "Erlangen",
"497621", "Lörrach",
"498562", "Triftern",
"493765", "Reichenbach\ Vogtland",
"496029", "Mömbris",
"495241", "Gütersloh",
"4935246", "Ziegenhain\ Sachsen",
"492682", "Hamm\ Sieg",
"492655", "Weibern",
"495191", "Soltau",
"4936077", "Grossbodungen",
"49971", "Bad\ Kissingen",
"496271", "Eberbach\ Baden",
"497072", "Gomaringen",
"4936642", "Harra",
"4939241", "Leitzkau",
"496758", "Waldböckelheim",
"494924", "Moormerland\-Oldersum",
"498041", "Bad\ Tölz",
"497683", "Simonswald",
"496864", "Mettlach",
"498856", "Penzberg",
"494921", "Emden\ Stadt",
"4934654", "Stolberg\ Harz",
"4939777", "Borkenfriede",
"496861", "Merzig",
"496274", "Waldbrunn\ Odenwald",
"496392", "Hauenstein\ Pfalz",
"498237", "Aindling",
"496128", "Taunusstein",
"496772", "Nastätten",
"495194", "Bispingen",
"495244", "Rietberg",
"499134", "Neunkirchen\ am\ Brand",
"497624", "Grenzach\-Wyhlen",
"497729", "Tennenbronn",
"495742", "Preussisch\ Oldendorf",
"4939831", "Feldberg",
"496461", "Biedenkopf",
"4933870", "Zollchow\ bei\ Rathenow",
"4933747", "Marzahna",
"495037", "Bad\ Rehburg",
"499097", "Marxheim",
"4933765", "Märkisch\ Buchholz",
"493843", "Güstrow",
"494543", "Nusse",
"495947", "Laar\ Vechte",
"496374", "Weilerbach",
"498337", "Altenstadt\ Iller",
"4939956", "Neukalen",
"496142", "Rüsselsheim",
"496292", "Seckach",
"498259", "Schiltberg",
"4937433", "Gutenfürst",
"492565", "Gronau\-Epe",
"499484", "Brennberg",
"498652", "Berchtesgaden",
"498685", "Kirchanschöring",
"495344", "Lengede",
"495172", "Ilsede",
"4933208", "Fahrland",
"4933604", "Lebus",
"493647", "Pössneck",
"492486", "Nettersheim",
"4933927", "Linum",
"4935951", "Neukirch\ Lausitz",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"4936625", "Langenwetzendorf",
"4936082", "Ershausen",
"499161", "Neustadt\ an\ der\ Aisch",
"498532", "Griesbach\ im\ Rottal",
"493735", "Marienberg\ Sachsen",
"498082", "Schwindegg",
"498055", "Halfing",
"498706", "Vilsheim",
"495153", "Salzhemmendorf",
"499828", "Rügland",
"496434", "Bad\ Camberg",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"495282", "Schieder\-Schwalenberg",
"495255", "Altenbeken",
"495850", "Neetze",
"4933833", "Wollin\ bei\ Brandenburg",
"495926", "Engden",
"499428", "Kirchroth",
"496834", "Bous",
"496408", "Buseck",
"4938353", "Gützkow\ bei\ Greifswald",
"4939852", "Schönermark\ bei\ Prenzlau",
"496597", "Jünkerath",
"497905", "Langenburg",
"4934491", "Schmölln\ Thüringen",
"4939751", "Penkun",
"4936968", "Rossdorf\ Rhön",
"4935452", "Golssen",
"499842", "Uffenheim",
"494975", "Westerholt\ Ostfriesland",
"496184", "Langenselbold",
"497660", "St\ Peter\ Schwarzwald",
"4935932", "Guttau",
"499442", "Riedenburg",
"49751", "Ravensburg",
"496753", "Meisenheim",
"495355", "Frellstedt",
"495382", "Bad\ Gandersheim",
"494849", "Hooge",
"4935820", "Zodel",
"4935756", "Hosena",
"4934347", "Oelzschau\ bei\ Borna",
"496420", "Lahntal",
"496123", "Eltville\ am\ Rhein",
"494605", "Medelby",
"498367", "Rosshaupten\ Forggensee",
"497675", "Bernau\ Baden",
"499103", "Cadolzburg",
"49581", "Uelzen",
"4935606", "Briesen\ bei\ Cottbus",
"497053", "Bad\ Teinach\-Zavelstein",
"494522", "Plön",
"496509", "Büdlich",
"496181", "Hanau",
"499529", "Oberaurach",
"49541", "Osnabrück",
"4930", "Berlin",
"4936202", "Neudietendorf",
"4939881", "Ringenwalde\ bei\ Templin",
"4939601", "Friedland",
"499205", "Vorbach",
"4939226", "Hohenziatz",
"494346", "Gettorf",
"492535", "Sendenhorst\-Albersloh",
"492052", "Velbert\-Langenberg",
"499646", "Freihung",
"498267", "Dirlewang",
"496831", "Saarlouis",
"492644", "Linz\ am\ Rhein",
"4938207", "Stäbelow",
"4938354", "Wusterhusen",
"495067", "Bockenem",
"493448", "Meuselwitz\ Thüringen",
"4934207", "Zwochau",
"496431", "Limburg\ an\ der\ Lahn",
"4933395", "Zerpenschleuse",
"4939000", "Beetzendorf",
"4933834", "Pritzerbe",
"492166", "Mönchengladbach\-Rheydt",
"496325", "Lambrecht\ Pfalz",
"495723", "Bad\ Nenndorf",
"494246", "Twistringen\-Heiligenloh",
"4934928", "Seegrehna",
"499164", "Langenfeld\ Mittelfranken",
"499305", "Estenfeld",
"495963", "Bawinkel",
"498248", "Lamerdingen",
"497254", "Waghäusel",
"495207", "Schloss\ Holte\-Stukenbrock",
"497939", "Schrozberg\-Spielbach",
"499186", "Lauterhofen\ Oberpfalz",
"498322", "Oberstdorf",
"492597", "Senden\ Westfalen",
"499951", "Landau\ an\ der\ Isar",
"493867", "Lübstorf",
"4938425", "Kirchdorf\ Poel",
"496078", "Gross\-Umstadt",
"492753", "Erndtebrück",
"4934425", "Droyssig",
"493663", "Schleiz",
"498546", "Windorf\-Otterskirchen",
"494731", "Nordenham",
"498222", "Burgau\ Schwaben",
"4936209", "Klettbach",
"498629", "Palling",
"499436", "Nittenau",
"495307", "Braunschweig\-Wenden",
"497354", "Erolzheim",
"498348", "Bidingen",
"498724", "Massing",
"498151", "Starnberg",
"492434", "Wegberg",
"4936454", "Magdala",
"495671", "Hofgeismar",
"492408", "Aachen\-Kornelimünster",
"4935203", "Tharandt",
"496641", "Lauterbach\ Hessen",
"495022", "Wietzen",
"492834", "Straelen",
"497957", "Kressberg",
"495904", "Lengerich\ Emsl",
"493971", "Anklam",
"4936966", "Kaltennordheim",
"499836", "Gunzenhausen\-Cronheim",
"495901", "Fürstenau\ bei\ Bramsche",
"4936465", "Oberndorf\ bei\ Apolda",
"4935939", "Hochkirch",
"498783", "Rohr\ in\ Niederbayern",
"494853", "Sankt\ Michaelisdonn",
"4934746", "Giersleben",
"499257", "Zell\ Oberfranken",
"4936453", "Mellingen",
"492831", "Geldern",
"494332", "Hamdorf\ bei\ Rendsburg",
"496644", "Grebenhain",
"492431", "Erkelenz",
"493601", "Mühlhausen\ Thüringen",
"496166", "Fischbachtal",
"497148", "Grossbottwar",
"4934973", "Osternienburg",
"494453", "Zetel",
"499339", "Ippesheim",
"4935204", "Wilsdruff",
"495674", "Grebenstein",
"493377", "Zossen\ Brandenburg",
"4935608", "Gross\ Ossnig",
"492325", "Wanne\-Eickel",
"499070", "Tapfheim",
"498721", "Eggenfelden",
"4933055", "Kremmen",
"497351", "Biberach\ an\ der\ Riss",
"494232", "Langwedel\ Kreis\ Verden",
"494639", "Schafflund",
"495766", "Rehburg\-Loccum",
"4937341", "Ehrenfriedersdorf",
"494734", "Stadland\-Seefeld",
"499357", "Gräfendorf\ Bayern",
"4934926", "Pretzsch\ Elbe",
"4939488", "Güntersberge",
"4939859", "Fürstenwerder",
"492181", "Grevenbroich",
"495692", "Wolfhagen",
"499632", "Waldsassen",
"497122", "St\ Johann\ Württemberg",
"495149", "Wienhausen",
"499954", "Simbach\ Niederbayern",
"494708", "Ringstedt",
"492509", "Nottuln\-Appelhülsen",
"496535", "Osann\-Monzel",
"492225", "Meckenheim\ Rheinland",
"497251", "Bruchsal",
"496052", "Bad\ Orb",
"496085", "Waldsolms",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"499573", "Staffelstein\ Oberfranken",
"497422", "Schramberg",
"495975", "Rheine\-Mesum",
"4933473", "Zechin",
"4935388", "Klöden",
"492823", "Goch",
"4939972", "Walkendorf",
"492627", "Braubach",
"4936075", "Dingelstädt\ Eichsfeld",
"492423", "Langerwehe",
"493675", "Sonneberg\ Thüringen",
"498733", "Mengkofen",
"496479", "Waldbrunn\ Westerwald",
"494355", "Rieseby",
"494382", "Wangels",
"495849", "Waddeweitz",
"497822", "Ettenheim",
"499289", "Schwarzenbach\ am\ Wald",
"492131", "Neuss",
"498454", "Karlshuld",
"499682", "Erbendorf",
"499655", "Tännesberg",
"496466", "Dautphetal\-Friedensdorf",
"497448", "Seewald",
"494153", "Lauenburg\ Elbe",
"496585", "Ralingen",
"496552", "Olzheim",
"4935266", "Heyda\ bei\ Riesa",
"496035", "Reichelsheim\ Wetterau",
"499073", "Gundelfingen\ an\ der\ Donau",
"4935843", "Hirschfelde\ bei\ Zittau",
"4939457", "Benneckenstein\ Harz",
"4938797", "Karstädt\ Kreis\ Prignitz",
"494282", "Sittensen",
"4933368", "Hohensaaten",
"494255", "Martfeld",
"49271", "Siegen",
"494926", "Krummhörn\-Greetsiel",
"496866", "Perl\-Nennig",
"4936849", "Kleinschmalkalden",
"498851", "Kochel\ am\ See",
"498507", "Neuburg\ am\ Inn",
"4933925", "Wustrau\-Altfriesack",
"498046", "Bad\ Heilbrunn",
"496276", "Hesseneck",
"4935844", "Oybin\ Kurort",
"495196", "Wietzendorf",
"494723", "Cuxhaven\-Altenwalde",
"495246", "Verl",
"497626", "Kandern",
"497735", "Öhningen",
"496578", "Salmtal",
"4933767", "Friedersdorf\ bei\ Berlin",
"49481", "Heide\ Holstein",
"49351", "Dresden",
"492750", "Diedenshausen",
"4933745", "Petkus",
"4933474", "Neutrebbin",
"495522", "Osterode\ am\ Harz",
"495605", "Kaufungen\ Hessen",
"496269", "Gundelsheim\ Württemberg",
"495346", "Liebenburg",
"499565", "Untersiemau",
"492484", "Mechernich\-Eiserfey",
"4939775", "Ahlbeck\ bei\ Torgelow",
"49441", "Oldenburg",
"496131", "Mainz",
"4939030", "Brunau",
"494671", "Bredstedt",
"494496", "Friesoythe\-Markhausen",
"494938", "Hagermarsch",
"494307", "Raisdorf",
"492585", "Warendorf\-Hoetmar",
"492552", "Steinfurt\-Borghorst",
"498665", "Inzell",
"499464", "Walderbach",
"493596", "Neustadt\ in\ Sachsen",
"497974", "Bühlerzell",
"492866", "Dorsten\-Rhade",
"497553", "Salem\ Baden",
"4935386", "Prettin",
"49671", "Bad\ Kreuznach",
"499271", "Thurnau\-Alladorf",
"4938854", "Redefin",
"49511", "Hannover",
"4933334", "Greiffenberg",
"492993", "Marsberg\-Canstein",
"494963", "Dörpen",
"494207", "Oyten",
"4933366", "Chorin",
"499803", "Colmberg",
"497277", "Wörth\-Büchelberg",
"4934783", "Gerbstedt",
"496423", "Wetter\ Hessen",
"496120", "Aarbergen",
"4938783", "Dallmin",
"499607", "Luhe\-Wildenau",
"496627", "Nentershausen\ Hessen",
"499403", "Donaustauf",
"496881", "Lebach",
"4935268", "Stauchitz",
"499371", "Miltenberg",
"492945", "Lippstadt\-Benninghausen",
"495731", "Bad\ Oeynhausen",
"497663", "Eichstetten",
"495232", "Lage\ Lippe",
"499374", "Eschau",
"4933333", "Tantow",
"499142", "Treuchtlingen",
"499292", "Konradsreuth",
"494766", "Basdahl",
"497467", "Neuhausen\ ob\ Eck",
"495734", "Bergkirchen\ Westfalen",
"4938853", "Drönnewitz\ bei\ Hagenow",
"4936842", "Oberhof\ Thüringen",
"4938784", "Kleinow\ Kreis\ Prignitz",
"498555", "Perlesreut",
"492269", "Kierspe\-Rönsahl",
"498582", "Röhrnbach",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"492662", "Hachenburg",
"494149", "Fredenbeck",
"4936921", "Wutha\-Farnroda",
"499977", "Arnschwang",
"496484", "Beselich",
"495853", "Neu\ Darchau",
"499772", "Bischofsheim\ an\ der\ Rhön",
"499128", "Feucht",
"496108", "Mühlheim\ am\ Main",
"499274", "Hollfeld",
"495332", "Schöppenstedt",
"499392", "Faulbach\ Unterfranken",
"4935793", "Elstra",
"499861", "Rothenburg\ ob\ der\ Tauber",
"4936730", "Sitzendorf",
"497971", "Gaildorf",
"492369", "Dorsten\-Wulfen",
"4938847", "Boizenburg\ Elbe",
"499461", "Roding",
"498670", "Reischach\ Kreis\ Altötting",
"495657", "Meissner",
"494779", "Freiburg\ Elbe",
"498177", "Münsing\ Starnberger\ See",
"4936741", "Bad\ Blankenburg",
"495453", "Recke",
"497709", "Wutach",
"494674", "Ockholm",
"496134", "Mainz\-Kastel",
"492951", "Büren",
"497256", "Philippsburg",
"496842", "Blieskastel",
"4939406", "Harbke",
"499184", "Deining\ Oberpfalz",
"494933", "Dornum\ Ostfriesland",
"495472", "Bad\ Essen",
"4933238", "Senzke",
"4936422", "Reinstädt\ Thüringen",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"4939080", "Kalbe\ Milde",
"495761", "Stolzenau",
"498544", "Eging\ am\ See",
"497558", "Illmensee",
"4935364", "Lebusa",
"495872", "Stoetze",
"496442", "Braunfels",
"495494", "Holdorf\ Niedersachsen",
"499434", "Bodenwöhr",
"492065", "Duisburg\-Rheinhausen",
"498635", "Pleiskirchen",
"497356", "Schemmerhofen",
"498726", "Schönau\ Niederbayern",
"494968", "Neulehe",
"496161", "Brensbach",
"492436", "Wegberg\-Rödgen",
"493606", "Heiligenstadt\ Heilbad",
"493773", "Johanngeorgenstadt",
"4938427", "Blowatz",
"492836", "Wachtendonk",
"4939993", "Hohenmocker",
"499408", "Altenthann",
"495906", "Lünne",
"4938733", "Karbow\-Vietlübbe",
"498387", "Weiler\-Simmerberg",
"4936946", "Erbenhausen\ Thüringen",
"499834", "Theilenhofen",
"496428", "Stadtallendorf",
"4935478", "Goyatz",
"492257", "Reckerscheid",
"499831", "Gunzenhausen",
"4938462", "Baumgarten",
"493976", "Torgelow\ bei\ Ueckermünde",
"495362", "Wolfsburg\-Fallersleben",
"497668", "Ihringen",
"496646", "Grebenau",
"496305", "Hochspeyer",
"496164", "Reichelsheim\ Odenwald",
"495703", "Hille",
"497459", "Nagold\-Hochdorf",
"499325", "Kleinlangheim",
"495676", "Liebenau\ Hessen",
"4934462", "Laucha\ Unstrut",
"499431", "Schwandorf",
"495491", "Damme\ Dümmer",
"492339", "Sprockhövel\-Hasslinghausen",
"4939994", "Metschow",
"4939200", "Gommern",
"497572", "Mengen\ Württemberg",
"4935021", "Königstein\ Sächsische\ Schweiz",
"492357", "Herscheid\ Westfalen",
"494502", "Lübeck\-Travemünde",
"4933848", "Raben",
"496400", "Mücke",
"494625", "Jübek",
"496103", "Langen\ Hessen",
"495764", "Steyerberg",
"499420", "Feldkirchen\ Niederbayern",
"4937361", "Neuhausen\ Erzgebirge",
"499123", "Lauf\ an\ der\ Pegnitz",
"497633", "Staufen\ im\ Breisgau",
"495262", "Extertal",
"495858", "Hitzacker\-Wietzetze",
"494736", "Butjadingen\-Tossens",
"4933633", "Spreenhagen",
"498541", "Vilshofen\ Niederbayern",
"499820", "Lehrberg",
"499225", "Stadtsteinach",
"499956", "Eichendorf\-Aufhausen",
"495458", "Hopsten",
"497837", "Oberharmersbach",
"496205", "Hockenheim",
"492573", "Nordwalde",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"492632", "Andernach",
"492954", "Rüthen\-Oestereiden",
"498062", "Bruckmühl\ Mangfall",
"493969", "Siedenbollentin",
"4935363", "Fermerswalde",
"493624", "Ohrdruf",
"494241", "Bassum",
"4934345", "Bad\ Lausick",
"494191", "Kaltenkirchen\ Holstein",
"492828", "Emmerich\-Elten",
"498202", "Althegnenberg",
"4934293", "Naunhof\ bei\ Grimma",
"498704", "Altdorf\-Pfettrach",
"492161", "Mönchengladbach",
"496436", "Dornburg\ Hessen",
"495327", "Bad\ Grund\ Harz",
"4939408", "Hadmersleben",
"495924", "Bad\ Bentheim\-Gildehaus",
"496836", "Überherrn",
"4938293", "Kühlungsborn\ Ostseebad",
"499641", "Grafenwöhr",
"492428", "Niederzier",
"499078", "Mertingen",
"492842", "Kamp\-Lintfort",
"4937600", "Neumark\ Sachsen",
"494158", "Roseburg",
"497443", "Dornstetten",
"4936948", "Römhild",
"4935975", "Hohnstein",
"496186", "Grosskrotzenburg",
"498302", "Görisried",
"497843", "Renchen",
"498027", "Dietramszell",
"4939824", "Hohenzieritz",
"494947", "Aurich\-Ogenbargen",
"4935772", "Rietschen",
"496357", "Standenbühl",
"499179", "Freystadt",
"4933397", "Wandlitz",
"4934322", "Rosswein",
"495543", "Staufenberg\ Niedersachsen",
"4934205", "Markranstädt",
"492103", "Hilden",
"4935476", "Wittmannsdorf\-Bückchen",
"4938205", "Tessin\ bei\ Rostock",
"492205", "Rösrath",
"496573", "Gillenfeld",
"499535", "Pfarrweisach",
"4938322", "Richtenberg",
"499085", "Alerheim",
"4939823", "Rechlin",
"498340", "Baisweil",
"496239", "Bobenheim\-Roxheim",
"494344", "Schönberg\ Holstein",
"492529", "Oelde\-Stromberg",
"494172", "Salzhausen",
"498445", "Gerolsbach",
"499644", "Pressath",
"499749", "Oberbach\ Unterfranken",
"496257", "Seeheim\-Jugenheim",
"495921", "Nordhorn",
"492646", "Königsfeld\ Eifel",
"4934294", "Rackwitz",
"493683", "Schmalkalden",
"4938294", "Neubukow",
"492305", "Castrop\-Rauxel",
"492164", "Jüchen\-Otzenrath",
"494194", "Sievershütten",
"494244", "Harpstedt",
"496339", "Grosssteinhausen",
"4933846", "Dippmannsdorf",
"497765", "Rickenbach\ Hotzenwald",
"493621", "Gotha\ Thüringen",
"4937421", "Oelsnitz\ Vogtland",
"499166", "Münchsteinach",
"494742", "Dorum",
"498845", "Bad\ Kohlgrub",
"493466", "Artern\ Unstrut",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"498547", "Osterhofen\-Gergweis",
"495508", "Gleichen\-Rittmarshausen",
"497431", "Albstadt\-Ebingen",
"497325", "Sontheim\ an\ der\ Brenz",
"494268", "Bötersen",
"4938851", "Zarrentin",
"494852", "Brunsbüttel",
"492351", "Lüdenscheid",
"498782", "Pfeffenhausen",
"494885", "Bergenhusen",
"493585", "Löbau",
"4933331", "Casekow",
"498284", "Ziemetshausen",
"494333", "Erfde",
"492596", "Nordkirchen",
"4935892", "Horka\ OL",
"4936923", "Treffurt",
"499187", "Altdorf\ bei\ Nürnberg",
"494485", "Elsfleth\-Huntorf",
"495206", "Bielefeld\-Jöllenbeck",
"494452", "Zetel\-Neuenburg",
"495534", "Eschershausen\ an\ der\ Lenne",
"497831", "Hausach",
"4933702", "Wünsdorf",
"496550", "Irrhausen",
"495084", "Hambühren",
"493866", "Cambs",
"4939384", "Arendsee\ Altmark",
"497181", "Schorndorf\ Württemberg",
"492778", "Siegbach",
"498384", "Röthenbach\ Allgäu",
"499837", "Haundorf",
"494233", "Blender",
"4938456", "Langhagen\ bei\ Güstrow",
"497225", "Gaggenau",
"492251", "Euskirchen",
"495645", "Borgentreich\-Borgholz",
"497420", "Deisslingen",
"497123", "Metzingen\ Württemberg",
"499633", "Mitterteich",
"495693", "Volkmarsen",
"4936743", "Teichel",
"495306", "Cremlingen",
"496675", "Breitenbach\ am\ Herzberg",
"494135", "Kirchgellersen",
"4937320", "Mulda\ Sachsen",
"496053", "Wächtersbach",
"499572", "Burgkunstadt",
"4938752", "Zierzow\ bei\ Ludwigslust",
"496660", "Steinau\-Marjoss",
"49651", "Trier",
"495962", "Herzlake",
"497753", "Albbruck",
"496167", "Modautal",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"498323", "Immenstadt\ im\ Allgäu",
"4939383", "Sandau\ Elbe",
"4934955", "Gossa",
"492752", "Bad\ Laasphe",
"498381", "Lindenberg\ im\ Allgäu",
"4933200", "Bergholz\-Rehbrücke",
"4936744", "Remda",
"492254", "Weilerswist",
"495520", "Braunlage",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"499256", "Stammbach",
"497184", "Kaisersbach",
"499925", "Bayerisch\ Eisenstein",
"4934781", "Greifenhagen",
"494478", "Cappeln\ Oldenburg",
"495531", "Holzminden",
"498223", "Ichenhausen",
"497834", "Wolfach",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"492957", "Wünnenberg\-Haaren",
"4933652", "Neuzelle",
"492354", "Meinerzhagen",
"4936607", "Niederpöllnitz",
"4936924", "Mihla",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"498281", "Thannhausen\ Schwaben",
"499356", "Burgsinn",
"497808", "Hohberg\ bei\ Offenburg",
"4938781", "Mellen",
"495767", "Warmsen",
"497434", "Winterlingen",
"493578", "Kamenz",
"4933878", "Nennhausen",
"496122", "Hofheim\-Wallau",
"499102", "Wilhermsdorf",
"496398", "Vorderweidenthal",
"4938375", "Koserow",
"497052", "Bad\ Liebenzell",
"496251", "Bensheim",
"497085", "Enzklösterle",
"494523", "Malente",
"4939264", "Kroppenstedt",
"4936335", "Grosswechsungen",
"492675", "Ediger\-Eller",
"493423", "Eilenburg",
"495324", "Vienenburg",
"4935240", "Tauscha\ bei\ Grossenhain",
"498707", "Adlkofen",
"493881", "Grevesmühlen",
"4935725", "Wittichenau",
"494109", "Tangstedt\ Bz\ Hamburg",
"492053", "Velbert\-Neviges",
"4934609", "Salzmünde",
"497166", "Adelberg",
"498469", "Freystadt\-Burggriesbach",
"496298", "Möckmühl",
"499765", "Trappstadt",
"498024", "Holzkirchen",
"494941", "Aurich",
"496351", "Eisenberg\ Pfalz",
"496596", "Üdersdorf",
"495722", "Bückeburg",
"495224", "Enger\ Westfalen",
"4938458", "Zehna",
"49371", "Chemnitz\ Sachsen",
"497644", "Kenzingen",
"498869", "Kinsau",
"4939397", "Geestgottberg",
"497641", "Emmendingen",
"498083", "Isen",
"498533", "Rotthalmünster",
"495221", "Herford",
"496049", "Kefenrod",
"4938759", "Tewswoos",
"494347", "Flintbek",
"495152", "Hessisch\ Oldendorf",
"495185", "Duingen",
"498021", "Waakirchen",
"495283", "Lügde\-Rischenau",
"498366", "Oy\-Mittelberg",
"494944", "Wiesmoor",
"4935841", "Grossschönau\ Sachsen",
"495321", "Goslar",
"492688", "Kroppach",
"495066", "Sarstedt",
"49251", "Münster",
"4933876", "Buschow",
"498379", "Waltenhofen\-Oberdorf",
"499843", "Burgbernheim",
"499495", "Breitenbrunn\ Oberpfalz",
"495435", "Berge\ bei\ Quakenbrück",
"494247", "Affinghausen",
"498266", "Kirchheim\ in\ Schwaben",
"499443", "Abensberg",
"496254", "Lautertal\ Odenwald",
"495835", "Wahrenholz",
"499647", "Kirchenthumbach",
"495383", "Lutter\ am\ Barenberge",
"496785", "Herrstein",
"4939263", "Unseburg",
"496752", "Kirn\ Nahe",
"492905", "Bestwig\-Ramsbeck",
"494528", "Schönwalde\ am\ Bungsberg",
"4935826", "Königshain\ bei\ Görlitz",
"492624", "Höhr\-Grenzhausen",
"496393", "Fischbach\ bei\ Dahn",
"499735", "Massbach",
"496773", "Kamp\-Bornhofen",
"495375", "Müden\ Aller",
"497136", "Bad\ Friedrichshall",
"499626", "Hohenburg",
"4938309", "Trent",
"492058", "Wülfrath",
"4939821", "Carpin",
"496345", "Albersweiler",
"495743", "Espelkamp\-Gestringen",
"494955", "Westoverledingen",
"4933972", "Breddin",
"494542", "Mölln\ Lauenburg",
"4939722", "Sarnow\ bei\ Anklam",
"4933457", "Altreetz",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"495275", "Höxter\-Ottbergen",
"498501", "Thyrnau",
"498857", "Benediktbeuern",
"496440", "Kölschhausen",
"496293", "Schefflenz",
"497486", "Horb\-Altheim",
"496195", "Kelkheim\ Taunus",
"4939426", "Hessen",
"494326", "Wankendorf",
"496245", "Biblis",
"4937423", "Adorf\ Vogtland",
"495173", "Uetze",
"498457", "Vohburg\ an\ der\ Donau",
"499549", "Lisberg",
"4935873", "Herrnhut",
"498075", "Amerang",
"499822", "Bechhofen\ an\ der\ Heide",
"495465", "Neuenkirchen\ bei\ Bramsche",
"496802", "Völklingen\-Lauterbach",
"4939006", "Miesterhorst",
"4934291", "Borsdorf",
"495586", "Wieda",
"498538", "Pocking\-Hartkirchen",
"492630", "Mülheim\-Kärlich",
"495036", "Neustadt\-Schneeren",
"492137", "Neuss\-Norf",
"4939925", "Wredenhagen",
"4936022", "Grossengottern",
"498504", "Tittling",
"497570", "Sigmaringen\-Gutenstein",
"497389", "Heroldstatt",
"496402", "Hungen",
"493529", "Heidenau\ Sachsen",
"494829", "Wewelsfleth",
"4935874", "Bernstadt\ an\ der\ Eigen",
"498236", "Fischach",
"49228", "Bonn",
"495865", "Gusborn",
"499422", "Bogen\ Niederbayern",
"499848", "Simmershofen",
"492683", "Asbach\ Westerwald",
"4939745", "Hetzdorf\ bei\ Strasburg",
"498563", "Bad\ Birnbach\ Rottal",
"497073", "Ammerbuch",
"492159", "Meerbusch\-Osterath",
"498336", "Erkheim",
"4935600", "Döbern\ NL",
"492621", "Lahnstein",
"497682", "Elzach",
"495946", "Georgsdorf",
"499448", "Hausen\ Niederbayern",
"497655", "Feldberg\-Altglashütten",
"497977", "Oberrot\ bei\ Gaildorf",
"494338", "Alt\ Duvenstedt",
"499867", "Geslau",
"494263", "Scheessel",
"492440", "Nettersheim\-Tondorf",
"492293", "Nümbrecht",
"495503", "Nörten\-Hardenberg",
"498171", "Wolfratshausen",
"4935828", "Reichenbach\ OL",
"495651", "Eschwege",
"492195", "Radevormwald",
"492245", "Much",
"4937297", "Thum\ Sachsen",
"499467", "Michelsneukirchen",
"494165", "Hollenstedt\ Nordheide",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"497374", "Uttenweiler",
"495129", "Söhlde",
"497142", "Bietigheim\-Bissingen",
"4939366", "Kehnert",
"4933631", "Bad\ Saarow\-Pieskow",
"4937363", "Zöblitz",
"496624", "Heringen\ Werra",
"494363", "Lensahn",
"4939428", "Pabstorf",
"498405", "Stammham\ bei\ Ingolstadt",
"494238", "Neddenaverbergen",
"499604", "Wernberg\-Köblitz",
"4936253", "Georgenthal\ Thüringer\ Wald",
"497461", "Tuttlingen",
"492773", "Haiger",
"4935023", "Bad\ Gottleuba",
"492606", "Winningen\ Mosel",
"492393", "Sundern\-Allendorf",
"493998", "Demmin",
"494536", "Steinhorst\ Lauenburg",
"493836", "Wolgast",
"499971", "Cham",
"498741", "Vilsbiburg",
"4935361", "Schlieben",
"4934242", "Hohenpriessnitz",
"495564", "Dassel",
"496058", "Gründau",
"4936029", "Menteroda",
"497274", "Germersheim",
"494702", "Sandstedt",
"498805", "Hohenpeissenberg",
"497392", "Laupheim",
"497128", "Sonnenbühl",
"499638", "Neualbenreuth",
"494204", "Thedinghausen",
"4936254", "Friedrichswerth",
"4938485", "Dabel",
"497271", "Wörth\ am\ Rhein",
"4937364", "Reitzenhain\ Erzgebirge",
"499553", "Ebrach\ Oberfranken",
"498328", "Balderschwang",
"499974", "Traitsching",
"498744", "Gerzen",
"494740", "Loxstedt\-Dedesdorf",
"4935024", "Stadt\ Wehlen",
"496683", "Ehrenberg\ Rhön",
"498192", "Schondorf\ am\ Ammersee",
"498649", "Schleching",
"495561", "Einbeck",
"496159", "Messel",
"497464", "Talheim\ Kreis\ Tuttlingen",
"496887", "Schmelz\ Saar",
"4939008", "Kunrau",
"499377", "Freudenberg\-Boxtal",
"496621", "Bad\ Hersfeld",
"495042", "Bad\ Münder\ am\ Deister",
"4934920", "Kropstädt",
"492802", "Alpen",
"4938225", "Trinwillershagen",
"496094", "Weibersbrunn",
"497371", "Riedlingen\ Württemberg",
"4938302", "Sagard",
"49385", "Schwerin",
"498342", "Marktoberdorf",
"497403", "Dunningen",
"4933979", "Wusterhausen\ Dosse",
"496630", "Schwalmtal\-Storndorf",
"494473", "Emstek",
"495932", "Haren\ Ems",
"495654", "Herleshausen",
"494873", "Aukrug",
"493573", "Senftenberg",
"4938731", "Lübz",
"499277", "Warmensteinach",
"49345", "Halle\ Saale",
"497803", "Gengenbach",
"4939991", "Daberkow",
"495028", "Pennigsehl",
"49202", "Wuppertal",
"492402", "Stolberg\ Rheinland",
"493632", "Sondershausen",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;