# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210204173826;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]|
              636[457-9]
            )|
            9(?:
              496|
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                7[015-9]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17|
                3[015-9]
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3[045]|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9(?:
                  [019]|
                  4[1-3]|
                  6(?:
                    [0-47-9]|
                    5[01346-9]
                  )
                )
              )|
              3(?:
                [29]|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[23]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                72|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              6[1-3]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              829(?:
                2|
                66
              )|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '007',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20[1-9]\\d{7}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00(?:
            (?:
              37|
              66
            )\\d{6,13}|
            (?:
              777(?:
                [01]|
                (?:
                  5|
                  8\\d
                )\\d
              )|
              882[1245]\\d\\d
            )\\d\\d
          )|
          (?:
            120|
            800\\d
          )\\d{6}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{en} = {"818683", "Tsuyama\,\ Okayama",
"819963", "Satsumasendai\,\ Kagoshima",
"812553", "Joetsu\,\ Niigata",
"811654", "Nayoro\,\ Hokkaido",
"815583", "Shimoda\,\ Shizuoka",
"8112391", "Yubari\,\ Hokkaido",
"8125488", "Tsugawa\,\ Niigata",
"812788", "Maebashi\,\ Gunma",
"818490", "Onomichi\,\ Hiroshima",
"81585", "Ibigawa\,\ Gifu",
"81288", "Imabari\,\ Ehime",
"818554", "Hamada\,\ Shimane",
"81125", "Takikawa\,\ Hokkaido",
"8164", "Osaka\,\ Osaka",
"811942", "Iwaizumi\,\ Iwate",
"818557", "Kawamoto\,\ Shimane",
"817737", "Maizuru\,\ Kyoto",
"812938", "Mito\,\ Ibaraki",
"811583", "Monbetsu\,\ Hokkaido",
"81537", "Kakegawa\,\ Shizuoka",
"8126176", "Omachi\,\ Nagano",
"817734", "Fukuchiyama\,\ Kyoto",
"818958", "Misho\,\ Ehime",
"811464", "Shizunai\,\ Hokkaido",
"812574", "Kashiwazaki\,\ Niigata",
"812696", "Iiyama\,\ Nagano",
"81196", "Morioka\,\ Iwate",
"819956", "Kajiki\,\ Kagoshima",
"814705", "Tateyama\,\ Chiba",
"811943", "Iwaizumi\,\ Iwate",
"812577", "Muika\,\ Niigata",
"812695", "Nakano\,\ Nagano",
"81473", "Ichikawa\,\ Chiba",
"819955", "Kajiki\,\ Kagoshima",
"818689", "Okayama\,\ Okayama",
"811632", "Teshio\,\ Hokkaido",
"8112397", "Kuriyama\,\ Hokkaido",
"812565", "Sanjo\,\ Niigata",
"812648", "Nagano\,\ Nagano",
"811582", "Monbetsu\,\ Hokkaido",
"8182943", "Hiroshima\,\ Hiroshima",
"812559", "Yasuzuka\,\ Niigata",
"81533", "Toyohashi\,\ Aichi",
"812566", "Sanjo\,\ Niigata",
"81439", "Kisarazu\,\ Chiba",
"81596", "Ise\,\ Mie",
"818682", "Tsuyama\,\ Okayama",
"81963", "Kumamoto\,\ Kumamoto",
"817996", "Tsuna\,\ Hyogo",
"81899", "Matsuyama\,\ Ehime",
"817995", "Sumoto\,\ Hyogo",
"8144", "Kawasaki\,\ Kanagawa",
"819962", "Satsumasendai\,\ Kagoshima",
"81179", "Sannohe\,\ Aomori",
"817948", "Miki\,\ Hyogo",
"8153979", "Hamamatsu\,\ Shizuoka",
"812747", "Tomioka\,\ Gunma",
"812618", "Omachi\,\ Nagano",
"815582", "Shimoda\,\ Shizuoka",
"812552", "Joetsu\,\ Niigata",
"817678", "Nanao\,\ Ishikawa",
"812744", "Fujioka\,\ Gunma",
"811589", "Okoppe\,\ Hokkaido",
"81958", "Nagasaki\,\ Nagasaki",
"8198296", "Hyuga\,\ Miyazaki",
"818203", "Yanai\,\ Yamaguchi",
"812473", "Ishikawa\,\ Fukushima",
"8183767", "Shimonoseki\,\ Yamaguchi",
"818656", "Kasaoka\,\ Okayama",
"818669", "Soja\,\ Okayama",
"81260", "Anan\,\ Nagano",
"818655", "Kamogata\,\ Okayama",
"81765", "Uozu\,\ Toyama",
"819732", "Hita\,\ Oita",
"81878", "Takamatsu\,\ Kagawa",
"817366", "Iwade\,\ Wakayama",
"81433", "Chiba\,\ Chiba",
"812586", "Nagaoka\,\ Niigata",
"814298", "Hanno\,\ Saitama",
"812585", "Nagaoka\,\ Niigata",
"811562", "Honbetsu\,\ Hokkaido",
"81893", "Ozu\,\ Ehime",
"812242", "Shiroishi\,\ Miyagi",
"818662", "Takahashi\,\ Okayama",
"818466", "Mima\,\ Tokushima",
"81969", "Amakusa\,\ Kumamoto",
"81956", "Sasebo\,\ Nagasaki",
"811556", "Obihiro\,\ Hokkaido",
"81252", "Niigata\,\ Niigata",
"818592", "Yonago\,\ Tottori",
"818474", "Fuchu\,\ Hiroshima",
"819543", "Takeo\,\ Saga",
"818391", "Ogori\,\ Yamaguchi",
"817352", "Shingu\,\ Fukuoka",
"811238", "Kuriyama\,\ Hokkaido",
"811555", "Obihiro\,\ Hokkaido",
"8112399", "Kuriyama\,\ Hokkaido",
"818477", "Tojo\,\ Hiroshima",
"81864", "Kurashiki\,\ Okayama",
"812388", "Nagai\,\ Yamagata",
"812243", "Shiroishi\,\ Miyagi",
"81922", "Fukuoka\,\ Fukuoka",
"817239", "Neyagawa\,\ Osaka",
"811878", "Omagari\,\ Akita",
"818663", "Soja\,\ Okayama",
"81425", "Tachikawa\,\ Tokyo",
"81226", "Kesennuma\,\ Miyagi",
"81177", "Aomori\,\ Aomori",
"814758", "Togane\,\ Chiba",
"818593", "Yonago\,\ Tottori",
"81554", "Otsuki\,\ Yamanashi",
"8186998", "Seto\,\ Okayama",
"819728", "Usuki\,\ Oita",
"81485", "Kumagaya\,\ Saitama",
"81286", "Utsunomiya\,\ Tochigi",
"817353", "Shingu\,\ Fukuoka",
"817964", "Toyooka\,\ Hyogo",
"819542", "Takeo\,\ Saga",
"8153971", "Hamamatsu\,\ Shizuoka",
"817615", "Komatsu\,\ Ishikawa",
"812472", "Ishikawa\,\ Fukushima",
"812676", "Saku\,\ Nagano",
"818202", "Yanai\,\ Yamaguchi",
"817616", "Komatsu\,\ Ishikawa",
"812675", "Saku\,\ Nagano",
"818844", "Anan\,\ Tokushima",
"81577", "Takayama\,\ Gifu",
"819733", "Hita\,\ Oita",
"81551", "Nirasaki\,\ Yamanashi",
"818244", "Miyoshi\,\ Hiroshima",
"818247", "Shobara\,\ Hiroshima",
"811563", "Honbetsu\,\ Hokkaido",
"812998", "Itako\,\ Ibaraki",
"818240", "Higashi\-ku\,\ Hiroshima",
"815742", "Minokamo\,\ Gifu",
"818679", "Niimi\,\ Okayama",
"817367", "Iwade\,\ Wakayama",
"812580", "Tokamachi\,\ Niigata",
"812587", "Nagaoka\,\ Niigata",
"818949", "Uwajima\,\ Ehime",
"817953", "Nishiwaki\,\ Hyogo",
"8153967", "Hamamatsu\,\ Shizuoka",
"81244", "Hobara\,\ Fukushima",
"812584", "Nagaoka\,\ Niigata",
"818657", "Kasaoka\,\ Okayama",
"815958", "Kameyama\,\ Mie",
"811533", "Nemuro\,\ Hokkaido",
"8198293", "Nobeoka\,\ Miyazaki",
"8147957", "Yokaichiba\,\ Chiba",
"818654", "Kamogata\,\ Okayama",
"814240", "Kokubunji\,\ Tokyo",
"818475", "Fuchu\,\ Hiroshima",
"81464", "Atsugi\,\ Kanagawa",
"814771", "Ichikawa\,\ Chiba",
"818942", "Yawatahama\,\ Ehime",
"81825", "Hiroshima\,\ Hiroshima",
"818476", "Fuchu\,\ Hiroshima",
"811528", "Bihoro\,\ Hokkaido",
"811554", "Obihiro\,\ Hokkaido",
"812653", "Iida\,\ Nagano",
"811958", "Iwate\,\ Iwate",
"818464", "Takehara\,\ Hiroshima",
"81885", "Komatsushima\,\ Tokushima",
"817688", "Noto\,\ Ishikawa",
"818583", "Kurayoshi\,\ Tottori",
"819438", "Tanushimaru\,\ Fukuoka",
"818467", "Mima\,\ Tokushima",
"81721", "Tondabayashi\,\ Osaka",
"81493", "Higashimatsuyama\,\ Saitama",
"817959", "Sanda\,\ Hyogo",
"818943", "Yawatahama\,\ Ehime",
"81176", "Towada\,\ Aomori",
"81227", "Sendai\,\ Miyagi",
"817965", "Toyooka\,\ Hyogo",
"811868", "Takanosu\,\ Akita",
"812652", "Iida\,\ Nagano",
"81743", "Nara\,\ Nara",
"81142", "Date\,\ Hokkaido",
"81896", "Iyomishima\,\ Ehime",
"8126173", "Omachi\,\ Nagano",
"812914", "Hokota\,\ Ibaraki",
"81138", "Hakodate\,\ Hokkaido",
"818582", "Kurayoshi\,\ Tottori",
"812917", "Mito\,\ Ibaraki",
"817718", "Sonobe\,\ Kyoto",
"812659", "Ina\,\ Nagano",
"818245", "Miyoshi\,\ Hiroshima",
"815743", "Minokamo\,\ Gifu",
"81199", "Morioka\,\ Iwate",
"817952", "Nishiwaki\,\ Hyogo",
"818246", "Miyoshi\,\ Hiroshima",
"81478", "Sawara\,\ Chiba",
"8199345", "Kagoshima\,\ Kagoshima",
"81542", "Shizuoka\,\ Shizuoka",
"812677", "Saku\,\ Nagano",
"817614", "Komatsu\,\ Ishikawa",
"814288", "Ome\,\ Tokyo",
"81833", "Kudamatsu\,\ Yamaguchi",
"811532", "Nemuro\,\ Hokkaido",
"812674", "Komoro\,\ Nagano",
"81235", "Tsuruoka\,\ Yamagata",
"81436", "Ichihara\,\ Chiba",
"81538", "Iwata\,\ Shizuoka",
"817617", "Kaga\,\ Ishikawa",
"818298", "Hatsukaichi\,\ Hiroshima",
"812489", "Sukagawa\,\ Fukushima",
"81178", "Hachinohe\,\ Aomori",
"819789", "Kitsuki\,\ Oita",
"819932", "Ibusuki\,\ Kagoshima",
"81898", "Imabari\,\ Ehime",
"8124196", "Yanaizu\,\ Fukushima",
"811655", "Nayoro\,\ Hokkaido",
"81593", "Yokkaichi\,\ Mie",
"818692", "Oku\,\ Okayama",
"811656", "Bifuka\,\ Hokkaido",
"81262", "Nagano\,\ Nagano",
"812378", "Sagae\,\ Yamagata",
"811452", "Hayakita\,\ Hokkaido",
"818562", "Masuda\,\ Shimane",
"81578", "Kamioka\,\ Akita",
"8188098", "Tosashimizu\,\ Kochi",
"817736", "Maizuru\,\ Kyoto",
"81476", "Narita\,\ Chiba",
"8126174", "Omachi\,\ Nagano",
"812858", "Mooka\,\ Tochigi",
"811466", "Erimo\,\ Hokkaido",
"81792", "Himeji\,\ Hyogo",
"817735", "Fukuchiyama\,\ Kyoto",
"811465", "Shizunai\,\ Hokkaido",
"812482", "Shirakawa\,\ Fukushima",
"819782", "Bungotakada\,\ Oita",
"81438", "Kisarazu\,\ Chiba",
"818555", "Gotsu\,\ Shimane",
"818556", "Gotsu\,\ Shimane",
"81839", "Yamaguchi\,\ Yamaguchi",
"81250", "Niitsu\,\ Niigata",
"819558", "Karatsu\,\ Saga",
"81877", "Marugame\,\ Kagawa",
"819979", "Tokunoshima\,\ Kagoshima",
"812564", "Sanjo\,\ Niigata",
"812560", "Itoigawa\,\ Niigata",
"81561", "Seto\,\ Aichi",
"819783", "Bungotakada\,\ Oita",
"812483", "Shirakawa\,\ Fukushima",
"812697", "Iiyama\,\ Nagano",
"812575", "Tokamachi\,\ Niigata",
"81934", "Kitakyushu\,\ Fukuoka",
"819957", "Kajiki\,\ Kagoshima",
"814700", "Kamogawa\,\ Chiba",
"812694", "Nakano\,\ Nagano",
"812968", "Kasama\,\ Ibaraki",
"812576", "Tokamachi\,\ Niigata",
"814704", "Tateyama\,\ Chiba",
"819954", "Kajiki\,\ Kagoshima",
"8153969", "Hamamatsu\,\ Shizuoka",
"812746", "Tomioka\,\ Gunma",
"819933", "Ibusuki\,\ Kagoshima",
"8198294", "Nobeoka\,\ Miyazaki",
"812745", "Fujioka\,\ Gunma",
"811453", "Hayakita\,\ Hokkaido",
"81564", "Okazaki\,\ Aichi",
"818693", "Oku\,\ Okayama",
"8186698", "Kurashiki\,\ Okayama",
"818563", "Masuda\,\ Shimane",
"812798", "Naganohara\,\ Gunma",
"817997", "Tsuna\,\ Hyogo",
"811541", "Teshikaga\,\ Hokkaido",
"817994", "Sumoto\,\ Hyogo",
"817613", "Komatsu\,\ Ishikawa",
"819808", "Yaeyama\ District\,\ Okinawa",
"818652", "Kurashiki\,\ Okayama",
"81495", "Honjo\,\ Saitama",
"812673", "Komoro\,\ Nagano",
"81992", "Kagoshima\,\ Kagoshima",
"819735", "Hita\,\ Oita",
"81827", "Iwakuni\,\ Yamaguchi",
"815744", "Minokamo\,\ Gifu",
"811559", "Obihiro\,\ Hokkaido",
"811978", "Kitakami\,\ Iwate",
"8124197", "Yanaizu\,\ Fukushima",
"812582", "Nagaoka\,\ Niigata",
"812898", "Kanuma\,\ Tochigi",
"818462", "Takehara\,\ Hiroshima",
"818666", "Ibara\,\ Okayama",
"81460", "Odawara\,\ Kanagawa",
"812245", "Ogawara\,\ Miyagi",
"812913", "Hokota\,\ Ibaraki",
"81949", "Nogata\,\ Fukuoka",
"818665", "Takahashi\,\ Okayama",
"812246", "Ogawara\,\ Miyagi",
"81766", "Takaoka\,\ Toyama",
"81233", "Shinjo\,\ Yamagata",
"817356", "Kushimoto\,\ Wakayama",
"812589", "Nagaoka\,\ Niigata",
"818595", "Yonago\,\ Tottori",
"818677", "Niimi\,\ Okayama",
"815566", "Minobu\,\ Yamanashi",
"818944", "Yawatahama\,\ Ehime",
"815978", "Kumano\,\ Mie",
"817355", "Shingu\,\ Fukuoka",
"818596", "Yonago\,\ Tottori",
"818674", "Kuse\,\ Okayama",
"81835", "Hofu\,\ Yamaguchi",
"818947", "Uwajima\,\ Ehime",
"811552", "Obihiro\,\ Hokkaido",
"818463", "Takehara\,\ Hiroshima",
"818587", "Koge\,\ Tottori",
"812679", "Saku\,\ Nagano",
"819598", "Fukue\,\ Nagasaki",
"814291", "Hanno\,\ Saitama",
"818584", "Kurayoshi\,\ Tottori",
"819546", "Kashima\,\ Saga",
"817498", "Nagahama\,\ Shiga",
"812657", "Ina\,\ Nagano",
"81188", "Akita\,\ Akita",
"8112394", "Yubari\,\ Hokkaido",
"819668", "Minamata\,\ Kumamoto",
"8186995", "Seto\,\ Okayama",
"812654", "Iida\,\ Nagano",
"811553", "Obihiro\,\ Hokkaido",
"814998", "Ogasawara\,\ Tokyo",
"812475", "Ishikawa\,\ Fukushima",
"815368", "Shitara\,\ Aichi",
"818205", "Yanai\,\ Yamaguchi",
"817612", "Komatsu\,\ Ishikawa",
"81823", "Kure\,\ Hiroshima",
"811534", "Nakashibetsu\,\ Hokkaido",
"8153973", "Hamamatsu\,\ Shizuoka",
"818206", "Yanai\,\ Yamaguchi",
"812672", "Komoro\,\ Nagano",
"812476", "Miharu\,\ Fukushima",
"818398", "Ogori\,\ Yamaguchi",
"81426", "Hachioji\,\ Tokyo",
"811537", "Nakashibetsu\,\ Hokkaido",
"81225", "Ishinomaki\,\ Miyagi",
"818806", "Sukumo\,\ Kochi",
"81734", "Wakayama\,\ Wakayama",
"817950", "Sanda\,\ Hyogo",
"81486", "Urawa\,\ Saitama",
"811938", "Miyako\,\ Iwate",
"817954", "Nishiwaki\,\ Hyogo",
"812583", "Nagaoka\,\ Niigata",
"812878", "Nasukarasuyama\,\ Tochigi",
"818564", "Masuda\,\ Shimane",
"81277", "Kiryu\,\ Gunma",
"81947", "Tagawa\,\ Fukuoka",
"81126", "Iwamizawa\,\ Hokkaido",
"818567", "Tsuwano\,\ Shimane",
"817993", "Sumoto\,\ Hyogo",
"818690", "Okayama\,\ Okayama",
"819688", "Tamana\,\ Kumamoto",
"818697", "Bizen\,\ Okayama",
"819934", "Ibusuki\,\ Kagoshima",
"815998", "Ago\,\ Mie",
"8125485", "Tsugawa\,\ Niigata",
"8153966", "Hamamatsu\,\ Shizuoka",
"818694", "Okayama\,\ Okayama",
"819937", "Kaseda\,\ Kagoshima",
"811454", "Mukawa\,\ Hokkaido",
"811946", "Kuji\,\ Iwate",
"811945", "Kuji\,\ Iwate",
"81774", "Uji\,\ Kyoto",
"814703", "Tateyama\,\ Chiba",
"8112393", "Yubari\,\ Hokkaido",
"812693", "Nakano\,\ Nagano",
"8166", "Osaka\,\ Osaka",
"819953", "Okuchi\,\ Kagoshima",
"818798", "Tonosho\,\ Kagawa",
"812563", "Sanjo\,\ Niigata",
"812487", "Sukagawa\,\ Fukushima",
"819787", "Kunisaki\,\ Oita",
"815768", "Gero\,\ Gifu",
"8178", "Kobe\,\ Hyogo",
"81586", "Ichinomiya\,\ Aichi",
"812484", "Shirakawa\,\ Fukushima",
"819784", "Bungotakada\,\ Oita",
"81488", "Urawa\,\ Saitama",
"81924", "Fukuoka\,\ Fukuoka",
"81298", "Tsuchiura\,\ Ibaraki",
"812692", "Nakano\,\ Nagano",
"814702", "Tateyama\,\ Chiba",
"81862", "Okayama\,\ Okayama",
"818378", "Shimonoseki\,\ Yamaguchi",
"819952", "Okuchi\,\ Kagoshima",
"811635", "Hamatonbetsu\,\ Hokkaido",
"81930", "Yukuhashi\,\ Fukuoka",
"811585", "Engaru\,\ Hokkaido",
"812562", "Sanjo\,\ Niigata",
"81984", "Kobayashi\,\ Miyazaki",
"811586", "Nakayubetsu\,\ Hokkaido",
"81552", "Kofu\,\ Yamanashi",
"818685", "Tsuyama\,\ Okayama",
"819966", "Izumi\,\ Kagoshima",
"819578", "Shimabara\,\ Nagasaki",
"814709", "Kamogawa\,\ Chiba",
"81875", "Kan\'onji\,\ Kagawa",
"818686", "Tsuyama\,\ Okayama",
"81273", "Takasaki\,\ Gunma",
"8182941", "Hiroshima\,\ Hiroshima",
"817992", "Sumoto\,\ Hyogo",
"812838", "Sano\,\ Tochigi",
"819965", "Satsumasendai\,\ Kagoshima",
"819977", "Setouchi\,\ Kagoshima",
"812555", "Itoigawa\,\ Niigata",
"812238", "Sendai\,\ Miyagi",
"815585", "Shimoda\,\ Shizuoka",
"8186552", "Kurashiki\,\ Okayama",
"819974", "Yakushima\,\ Kagoshima",
"812556", "Itoigawa\,\ Niigata",
"815586", "Shimoda\,\ Shizuoka",
"8198299", "Hyuga\,\ Miyazaki",
"81946", "Amagi\,\ Fukuoka",
"81276", "Ota\,\ Gunma",
"819828", "Takachiho\,\ Miyazaki",
"81242", "Aizuwakamatsu\,\ Fukushima",
"819935", "Kaseda\,\ Kagoshima",
"811652", "Shibetsu\,\ Hokkaido",
"818696", "Bizen\,\ Okayama",
"8153964", "Hamamatsu\,\ Shizuoka",
"812743", "Fujioka\,\ Gunma",
"819936", "Kaseda\,\ Kagoshima",
"811455", "Mukawa\,\ Hokkaido",
"818695", "Seto\,\ Okayama",
"8153976", "Hamamatsu\,\ Shizuoka",
"818565", "Masuda\,\ Shimane",
"8125482", "Murakami\,\ Niigata",
"814220", "Kokubunji\,\ Tokyo",
"81535", "Hamamatsu\,\ Shizuoka",
"8183766", "Shimonoseki\,\ Yamaguchi",
"818978", "Hakata\,\ Ehime",
"818559", "Kawamoto\,\ Shimane",
"819233", "Maebaru\,\ Fukuoka",
"819786", "Kitsuki\,\ Oita",
"811548", "Teshikaga\,\ Hokkaido",
"812486", "Sukagawa\,\ Fukushima",
"817732", "Fukuchiyama\,\ Kyoto",
"81965", "Yatsushiro\,\ Kumamoto",
"812485", "Shirakawa\,\ Fukushima",
"819785", "Bungotakada\,\ Oita",
"8188095", "Tosashimizu\,\ Kochi",
"811462", "Urakawa\,\ Hokkaido",
"81462", "Atsugi\,\ Kanagawa",
"812573", "Kashiwazaki\,\ Niigata",
"811947", "Kuji\,\ Iwate",
"818552", "Hamada\,\ Shimane",
"81587", "Ichinomiya\,\ Aichi",
"811944", "Iwaizumi\,\ Iwate",
"81828", "Hiroshima\,\ Hiroshima",
"819232", "Maebaru\,\ Fukuoka",
"815398", "Hamamatsu\,\ Shizuoka",
"8126179", "Omachi\,\ Nagano",
"811584", "Engaru\,\ Hokkaido",
"81144", "Tomakomai\,\ Hokkaido",
"817733", "Fukuchiyama\,\ Kyoto",
"81429", "Tokorozawa\,\ Saitama",
"811463", "Urakawa\,\ Hokkaido",
"818368", "Ube\,\ Yamaguchi",
"811587", "Nakayubetsu\,\ Hokkaido",
"818553", "Hamada\,\ Shimane",
"812572", "Kashiwazaki\,\ Niigata",
"815738", "Nakatsugawa\,\ Gifu",
"81489", "Soka\,\ Saitama",
"81583", "Gifu\,\ Gifu",
"814798", "Yokaichiba\,\ Chiba",
"81888", "Kochi\,\ Kochi",
"811634", "Hamatonbetsu\,\ Hokkaido",
"819976", "Naze\,\ Kagoshima",
"81544", "Fujinomiya\,\ Shizuoka",
"818493", "Onomichi\,\ Hiroshima",
"815584", "Shimoda\,\ Shizuoka",
"812554", "Joetsu\,\ Niigata",
"811653", "Shibetsu\,\ Hokkaido",
"811398", "Kumaishi\,\ Hokkaido",
"819975", "Naze\,\ Kagoshima",
"812742", "Fujioka\,\ Gunma",
"812550", "Yasuzuka\,\ Niigata",
"81722", "Sakai\,\ Osaka",
"818684", "Tsuyama\,\ Okayama",
"817468", "Kamikitayama\,\ Nara",
"81183", "Yuzawa\,\ Akita",
"819967", "Izumi\,\ Kagoshima",
"818687", "Mimasaka\,\ Okayama",
"818680", "Okayama\,\ Okayama",
"819964", "Satsumasendai\,\ Kagoshima",
"818243", "Higashi\-ku\,\ Hiroshima",
"815745", "Minokamo\,\ Gifu",
"81423", "Kokubunji\,\ Tokyo",
"818388", "Tamagawa\,\ Yamaguchi",
"818479", "Tojo\,\ Hiroshima",
"815746", "Minokamo\,\ Gifu",
"811564", "Kamishihoro\,\ Hokkaido",
"81886", "Tokushima\,\ Tokushima",
"819737", "Kusu\,\ Oita",
"8165", "Osaka\,\ Osaka",
"818843", "Anan\,\ Tokushima",
"819734", "Hita\,\ Oita",
"817357", "Kushimoto\,\ Wakayama",
"818945", "Yawatahama\,\ Ehime",
"818676", "Kuse\,\ Okayama",
"814281", "Sagamihara\,\ Kanagawa",
"818594", "Yonago\,\ Tottori",
"8198291", "Nobeoka\,\ Miyazaki",
"817963", "Toyooka\,\ Hyogo",
"817354", "Shingu\,\ Fukuoka",
"818946", "Uwajima\,\ Ehime",
"818675", "Kuse\,\ Okayama",
"818667", "Ibara\,\ Okayama",
"818660", "Seto\,\ Okayama",
"812244", "Shiroishi\,\ Miyagi",
"818664", "Takahashi\,\ Okayama",
"817488", "Minakuchi\,\ Shiga",
"812247", "Ogawara\,\ Miyagi",
"8125480", "Murakami\,\ Niigata",
"819547", "Kashima\,\ Saga",
"8112396", "Kuriyama\,\ Hokkaido",
"81162", "Wakkanai\,\ Hokkaido",
"81763", "Fukuno\,\ Toyama",
"811378", "Imakane\,\ Hokkaido",
"812656", "Ina\,\ Nagano",
"817962", "Toyooka\,\ Hyogo",
"819544", "Takeo\,\ Saga",
"81948", "Iizuka\,\ Fukuoka",
"818249", "Higashi\-ku\,\ Hiroshima",
"812655", "Iida\,\ Nagano",
"818586", "Kurayoshi\,\ Tottori",
"819948", "Shibushi\,\ Kagoshima",
"81550", "Gotenba\,\ Shizuoka",
"81236", "Yamagata\,\ Yamagata",
"818585", "Kurayoshi\,\ Tottori",
"8186992", "Bizen\,\ Okayama",
"8145", "Yokohama\,\ Kanagawa",
"81932", "Kitakyushu\,\ Fukuoka",
"818807", "Sukumo\,\ Kochi",
"818242", "Higashi\-ku\,\ Hiroshima",
"817956", "Sanda\,\ Hyogo",
"817969", "Hamasaka\,\ Hyogo",
"81427", "Sagamihara\,\ Kanagawa",
"817955", "Sanda\,\ Hyogo",
"8126171", "Omachi\,\ Nagano",
"811858", "Noshiro\,\ Akita",
"8198297", "Hyuga\,\ Miyazaki",
"81852", "Matsue\,\ Shimane",
"812474", "Ishikawa\,\ Fukushima",
"81487", "Urawa\,\ Saitama",
"818204", "Yanai\,\ Yamaguchi",
"811535", "Akkeshi\,\ Hokkaido",
"817230", "Neyagawa\,\ Osaka",
"812477", "Miharu\,\ Fukushima",
"818842", "Anan\,\ Tokushima",
"811536", "Akkeshi\,\ Hokkaido",
"819978", "Tokunoshima\,\ Kagoshima",
"8125481", "Murakami\,\ Niigata",
"812230", "Sendai\,\ Miyagi",
"812414", "Yanaizu\,\ Fukushima",
"818879", "Muroto\,\ Kochi",
"811396", "Esashi\,\ Hokkaido",
"812373", "Murayama\,\ Yamagata",
"812237", "Sendai\,\ Miyagi",
"8112398", "Kuriyama\,\ Hokkaido",
"812234", "Sendai\,\ Miyagi",
"811395", "Esashi\,\ Hokkaido",
"81549", "Shizuoka\,\ Shizuoka",
"811736", "Goshogawara\,\ Aomori",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"815985", "Matsusaka\,\ Mie",
"8198290", "Nobeoka\,\ Miyazaki",
"812834", "Utsunomiya\,\ Tochigi",
"819577", "Shimabara\,\ Nagasaki",
"817466", "Totsukawa\,\ Nara",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"81793", "Himeji\,\ Hyogo",
"81192", "Ofunato\,\ Iwate",
"811735", "Goshogawara\,\ Aomori",
"817725", "Miyazu\,\ Kyoto",
"815986", "Matsusaka\,\ Mie",
"812830", "Utsunomiya\,\ Tochigi",
"817905", "Fukusaki\,\ Hyogo",
"817465", "Yoshino\,\ Nara",
"812837", "Sano\,\ Tochigi",
"812792", "Shibukawa\,\ Gunma",
"819574", "Isahaya\,\ Nagasaki",
"818833", "Kamojima\,\ Tokushima",
"81555", "Fujiyoshida\,\ Yamanashi",
"818365", "Ube\,\ Yamaguchi",
"819744", "Mie\,\ Oita",
"81484", "Kawaguchi\,\ Saitama",
"819552", "Imari\,\ Saga",
"815395", "Hamamatsu\,\ Shizuoka",
"812853", "Oyama\,\ Tochigi",
"819747", "Taketa\,\ Oita",
"818366", "Ube\,\ Yamaguchi",
"818872", "Muroto\,\ Kochi",
"81778", "Takefu\,\ Fukui",
"818374", "Nagato\,\ Yamaguchi",
"812962", "Shimodate\,\ Ibaraki",
"812799", "Naganohara\,\ Gunma",
"815736", "Nakatsugawa\,\ Gifu",
"814796", "Yokaichiba\,\ Chiba",
"818377", "Shimonoseki\,\ Yamaguchi",
"811986", "Tono\,\ Iwate",
"815735", "Ena\,\ Gifu",
"81592", "Tsu\,\ Mie",
"81263", "Matsumoto\,\ Nagano",
"814795", "Choshi\,\ Chiba",
"817452", "Yamatotakada\,\ Nara",
"815764", "Gero\,\ Gifu",
"81988", "Naha\,\ Okinawa",
"818797", "Tonosho\,\ Kagawa",
"818832", "Kamojima\,\ Tokushima",
"8125487", "Tsugawa\,\ Niigata",
"812488", "Sukagawa\,\ Fukushima",
"811546", "Kushiro\,\ Hokkaido",
"819788", "Kunisaki\,\ Oita",
"819553", "Imari\,\ Saga",
"815767", "Gero\,\ Gifu",
"818873", "Aki\,\ Kochi",
"811545", "Kushiro\,\ Hokkaido",
"812852", "Oyama\,\ Tochigi",
"812963", "Shimodate\,\ Ibaraki",
"8126170", "Omachi\,\ Nagano",
"81928", "Fukuoka\,\ Fukuoka",
"81294", "Hitachiota\,\ Ibaraki",
"817453", "Yamatotakada\,\ Nara",
"819687", "Tamana\,\ Kumamoto",
"812859", "Oyama\,\ Tochigi",
"819826", "Hyuga\,\ Miyazaki",
"812372", "Murayama\,\ Yamagata",
"8186999", "Seto\,\ Okayama",
"815997", "Ago\,\ Mie",
"818698", "Bizen\,\ Okayama",
"819684", "Yamaga\,\ Kumamoto",
"819825", "Hyuga\,\ Miyazaki",
"812571", "Muika\,\ Niigata",
"819938", "Kaseda\,\ Kagoshima",
"815994", "Ago\,\ Mie",
"818975", "Niihama\,\ Ehime",
"812877", "Kuroiso\,\ Tochigi",
"81797", "Nishinomiya\,\ Hyogo",
"818568", "Tsuwano\,\ Shimane",
"818976", "Niihama\,\ Ehime",
"812874", "Otawara\,\ Tochigi",
"8167", "Osaka\,\ Osaka",
"812793", "Shibukawa\,\ Gunma",
"81764", "Toyama\,\ Toyama",
"817704", "Tsuruga\,\ Fukui",
"811934", "Kamaishi\,\ Iwate",
"811855", "Noshiro\,\ Akita",
"812542", "Shibata\,\ Niigata",
"817707", "Obama\,\ Fukui",
"8199331", "Kagoshima\,\ Kagoshima",
"8186997", "Seto\,\ Okayama",
"811869", "Odate\,\ Akita",
"81986", "Miyakonojo\,\ Miyazaki",
"811937", "Miyako\,\ Iwate",
"811856", "Noshiro\,\ Akita",
"81282", "Tochigi\,\ Tochigi",
"818892", "Sakawa\,\ Kochi",
"815367", "Shitara\,\ Aichi",
"81926", "Fukuoka\,\ Fukuoka",
"814776", "Funabashi\,\ Chiba",
"81222", "Sendai\,\ Miyagi",
"818292", "Hiroshima\,\ Hiroshima",
"818397", "Ogori\,\ Yamaguchi",
"814775", "Funabashi\,\ Chiba",
"814282", "Ome\,\ Tokyo",
"819664", "Hitoyoshi\,\ Kumamoto",
"8163", "Osaka\,\ Osaka",
"817497", "Nagahama\,\ Shiga",
"811523", "Shari\,\ Hokkaido",
"812658", "Ina\,\ Nagano",
"811862", "Kazuno\,\ Akita",
"811376", "Yakumo\,\ Hokkaido",
"8125489", "Tsugawa\,\ Niigata",
"819667", "Minamata\,\ Kumamoto",
"817494", "Hikone\,\ Shiga",
"812549", "Tsugawa\,\ Niigata",
"811375", "Yakumo\,\ Hokkaido",
"81547", "Shimada\,\ Shizuoka",
"819433", "Yame\,\ Fukuoka",
"811367", "Suttsu\,\ Hokkaido",
"818588", "Koge\,\ Tottori",
"814289", "Ome\,\ Tokyo",
"817712", "Kameoka\,\ Kyoto",
"819946", "Kanoya\,\ Kagoshima",
"819597", "Fukue\,\ Nagasaki",
"8198292", "Nobeoka\,\ Miyazaki",
"811364", "Kutchan\,\ Hokkaido",
"811953", "Ninohe\,\ Iwate",
"818299", "Hiroshima\,\ Hiroshima",
"817683", "Wajima\,\ Ishikawa",
"819945", "Kanoya\,\ Kagoshima",
"819676", "Takamori\,\ Kumamoto",
"8153978", "Hamamatsu\,\ Shizuoka",
"811863", "Kazuno\,\ Akita",
"815977", "Kumano\,\ Mie",
"811522", "Shari\,\ Hokkaido",
"818678", "Niimi\,\ Okayama",
"81832", "Shimonoseki\,\ Yamaguchi",
"811336", "Ishikari\,\ Hokkaido",
"818948", "Uwajima\,\ Ehime",
"815974", "Owase\,\ Mie",
"81184", "Yurihonjo\,\ Akita",
"812897", "Kanuma\,\ Tochigi",
"818544", "Kisuki\,\ Shimane",
"819432", "Yame\,\ Fukuoka",
"81848", "Onomichi\,\ Hiroshima",
"815959", "Kameyama\,\ Mie",
"81124", "Ashibetsu\,\ Hokkaido",
"812890", "Utsunomiya\,\ Tochigi",
"817713", "Kameoka\,\ Kyoto",
"817485", "Yokaichi\,\ Shiga",
"812894", "Utsunomiya\,\ Tochigi",
"811952", "Ninohe\,\ Iwate",
"818547", "Kakeya\,\ Shimane",
"81543", "Shizuoka\,\ Shizuoka",
"817486", "Minakuchi\,\ Shiga",
"8183768", "Shimonoseki\,\ Yamaguchi",
"817682", "Wajima\,\ Ishikawa",
"811644", "Rumoi\,\ Hokkaido",
"812543", "Shibata\,\ Niigata",
"811977", "Kitakami\,\ Iwate",
"81952", "Saga\,\ Saga",
"81738", "Gobo\,\ Wakayama",
"818893", "Sakawa\,\ Kochi",
"81584", "Ogaki\,\ Gifu",
"811647", "Haboro\,\ Hokkaido",
"811974", "Mizusawa\,\ Iwate",
"818385", "Hagi\,\ Yamaguchi",
"81492", "Kawagoe\,\ Saitama",
"819804", "Nago\,\ Okinawa",
"818293", "Hatsukaichi\,\ Hiroshima",
"818514", "Ama\,\ Shimane",
"81776", "Fukui\,\ Fukui",
"8126172", "Omachi\,\ Nagano",
"814283", "Ome\,\ Tokyo",
"81143", "Muroran\,\ Hokkaido",
"81742", "Nara\,\ Nara",
"815366", "Shitara\,\ Aichi",
"814770", "Ichikawa\,\ Chiba",
"812389", "Yonezawa\,\ Yamagata",
"81253", "Niigata\,\ Niigata",
"814777", "Funabashi\,\ Chiba",
"81739", "Tanabe\,\ Wakayama",
"812478", "Miharu\,\ Fukushima",
"811352", "Yoichi\,\ Hokkaido",
"8161", "Osaka\,\ Osaka",
"817238", "Neyagawa\,\ Osaka",
"81987", "Nichinan\,\ Miyazaki",
"818808", "Tosashimizu\,\ Kochi",
"811935", "Kamaishi\,\ Iwate",
"81172", "Hirosaki\,\ Aomori",
"8188099", "Tosashimizu\,\ Kochi",
"817705", "Obama\,\ Fukui",
"81892", "Kumakogen\,\ Ehime",
"81927", "Fukuoka\,\ Fukuoka",
"812992", "Ishioka\,\ Ibaraki",
"811854", "Oga\,\ Akita",
"811936", "Miyako\,\ Iwate",
"817706", "Obama\,\ Fukui",
"81268", "Ueda\,\ Nagano",
"81565", "Toyota\,\ Aichi",
"811857", "Noshiro\,\ Akita",
"819940", "Shibushi\,\ Kagoshima",
"81432", "Chiba\,\ Chiba",
"811366", "Suttsu\,\ Hokkaido",
"819596", "Fukue\,\ Nagasaki",
"81935", "Kitakyushu\,\ Fukuoka",
"819947", "Shibushi\,\ Kagoshima",
"812382", "Yonezawa\,\ Yamagata",
"811365", "Kutchan\,\ Hokkaido",
"819944", "Kanoya\,\ Kagoshima",
"819665", "Hitoyoshi\,\ Kumamoto",
"81572", "Tajimi\,\ Gifu",
"817496", "Nagahama\,\ Shiga",
"811233", "Chitose\,\ Hokkaido",
"81546", "Shizuoka\,\ Shizuoka",
"811377", "Yakumo\,\ Hokkaido",
"81798", "Nishinomiya\,\ Hyogo",
"817495", "Nagahama\,\ Shiga",
"819666", "Minamata\,\ Kumamoto",
"812999", "Itako\,\ Ibaraki",
"814752", "Mobara\,\ Chiba",
"819722", "Saiki\,\ Oita",
"811374", "Mori\,\ Hokkaido",
"8198295", "Hyuga\,\ Miyazaki",
"81849", "Fukuyama\,\ Hiroshima",
"811873", "Kakunodate\,\ Akita",
"812896", "Kanuma\,\ Tochigi",
"818545", "Kisuki\,\ Shimane",
"818668", "Ibara\,\ Okayama",
"817484", "Yokaichi\,\ Shiga",
"8199343", "Kagoshima\,\ Kagoshima",
"812895", "Utsunomiya\,\ Tochigi",
"818546", "Kakeya\,\ Shimane",
"812383", "Yonezawa\,\ Yamagata",
"812248", "Ogawara\,\ Miyagi",
"817487", "Minakuchi\,\ Shiga",
"8153968", "Hamamatsu\,\ Shizuoka",
"81944", "Setaka\,\ Fukuoka",
"811232", "Chitose\,\ Hokkaido",
"814753", "Mobara\,\ Chiba",
"811337", "Ishikari\,\ Hokkaido",
"819723", "Saiki\,\ Oita",
"819805", "Nago\,\ Okinawa",
"81983", "Takanabe\,\ Miyazaki",
"819738", "Kusu\,\ Oita",
"811353", "Yoichi\,\ Hokkaido",
"8169", "Osaka\,\ Osaka",
"812993", "Ishioka\,\ Ibaraki",
"818387", "Tamagawa\,\ Yamaguchi",
"811976", "Kitakami\,\ Iwate",
"811645", "Rumoi\,\ Hokkaido",
"8126175", "Omachi\,\ Nagano",
"81923", "Fukuoka\,\ Fukuoka",
"811975", "Mizusawa\,\ Iwate",
"818384", "Hagi\,\ Yamaguchi",
"811646", "Haboro\,\ Hokkaido",
"812911", "Hokota\,\ Ibaraki",
"815984", "Matsusaka\,\ Mie",
"819576", "Shimabara\,\ Nagasaki",
"812835", "Sano\,\ Tochigi",
"819968", "Izumi\,\ Kagoshima",
"81280", "Koga\,\ Ibaraki",
"81234", "Sakata\,\ Yamagata",
"817904", "Fukusaki\,\ Hyogo",
"812957", "Daigo\,\ Ibaraki",
"818688", "Mimasaka\,\ Okayama",
"817724", "Miyazu\,\ Kyoto",
"811734", "Goshogawara\,\ Aomori",
"817464", "Yoshino\,\ Nara",
"812836", "Sano\,\ Tochigi",
"819575", "Isahaya\,\ Nagasaki",
"812649", "Nagano\,\ Nagano",
"812783", "Numata\,\ Gunma",
"812415", "Yanaizu\,\ Fukushima",
"817476", "Shimonoseki\,\ Yamaguchi",
"815753", "Sekigahara\,\ Gifu",
"817672", "Hakui\,\ Ishikawa",
"812236", "Sendai\,\ Miyagi",
"81725", "Izumi\,\ Osaka",
"811397", "Okushiri\,\ Hokkaido",
"812416", "Tajima\,\ Fukushima",
"817942", "Kakogawa\,\ Hyogo",
"812612", "Omachi\,\ Nagano",
"817475", "Shimonoseki\,\ Yamaguchi",
"812235", "Sendai\,\ Miyagi",
"811394", "Matsumae\,\ Hokkaido",
"815737", "Nakatsugawa\,\ Gifu",
"811984", "Hanamaki\,\ Iwate",
"818375", "Mine\,\ Yamaguchi",
"81737", "Yuasa\,\ Wakayama",
"814797", "Yokaichiba\,\ Chiba",
"815734", "Ena\,\ Gifu",
"811987", "Tono\,\ Iwate",
"818376", "Mine\,\ Yamaguchi",
"8186697", "Kurashiki\,\ Okayama",
"8111", "Sapporo\,\ Hokkaido",
"814794", "Choshi\,\ Chiba",
"81989", "Naha\,\ Okinawa",
"811753", "Mutsu\,\ Aomori",
"818262", "Kake\,\ Hiroshima",
"817949", "Kakogawa\,\ Hyogo",
"818364", "Ube\,\ Yamaguchi",
"818953", "Uwajima\,\ Ehime",
"812619", "Omachi\,\ Nagano",
"81929", "Fukuoka\,\ Fukuoka",
"812933", "Takahagi\,\ Ibaraki",
"818360", "Ogori\,\ Yamaguchi",
"819746", "Taketa\,\ Oita",
"818367", "Ube\,\ Yamaguchi",
"811588", "Okoppe\,\ Hokkaido",
"817912", "Aioi\,\ Hyogo",
"815394", "Hamamatsu\,\ Shizuoka",
"81259", "Sado\,\ Niigata",
"818796", "Tonosho\,\ Kagawa",
"818263", "Kake\,\ Hiroshima",
"81962", "Kumamoto\,\ Kumamoto",
"811752", "Mutsu\,\ Aomori",
"815765", "Gero\,\ Gifu",
"81266", "Suwa\,\ Nagano",
"81465", "Odawara\,\ Kanagawa",
"818952", "Uwajima\,\ Ehime",
"811547", "Shiranuka\,\ Hokkaido",
"815766", "Gero\,\ Gifu",
"812932", "Takahagi\,\ Ibaraki",
"81779", "Ono\,\ Gifu",
"812789", "Maebashi\,\ Gunma",
"811544", "Kushiro\,\ Hokkaido",
"812876", "Kuroiso\,\ Tochigi",
"81950", "Hirado\,\ Nagasaki",
"818974", "Niihama\,\ Ehime",
"812875", "Otawara\,\ Tochigi",
"81532", "Toyohashi\,\ Aichi",
"8186691", "Kurashiki\,\ Okayama",
"818977", "Hakata\,\ Ehime",
"815752", "Sekigahara\,\ Gifu",
"817673", "Hakui\,\ Ishikawa",
"819827", "Takachiho\,\ Miyazaki",
"812782", "Numata\,\ Gunma",
"819686", "Tamana\,\ Kumamoto",
"814701", "Kamogawa\,\ Chiba",
"81740", "Imazu\,\ Shiga",
"815996", "Ago\,\ Mie",
"812939", "Mito\,\ Ibaraki",
"819824", "Nobeoka\,\ Miyazaki",
"812613", "Omachi\,\ Nagano",
"819685", "Tamana\,\ Kumamoto",
"817943", "Kakogawa\,\ Hyogo",
"8182942", "Hiroshima\,\ Hiroshima",
"81548", "Haibara\,\ Shizuoka",
"8188097", "Tosashimizu\,\ Kochi",
"81245", "Fukushima\,\ Fukushima",
"815995", "Ago\,\ Mie",
"81975", "Oita\,\ Oita",
"81937", "Kitakyushu\,\ Fukuoka",
"812545", "Murakami\,\ Niigata",
"818896", "Susaki\,\ Kochi",
"812994", "Ishioka\,\ Ibaraki",
"811852", "Oga\,\ Akita",
"818248", "Shobara\,\ Hiroshima",
"818895", "Susaki\,\ Kochi",
"812546", "Murakami\,\ Niigata",
"818383", "Hagi\,\ Yamaguchi",
"812997", "Itako\,\ Ibaraki",
"81729", "Yao\,\ Osaka",
"811357", "Iwanai\,\ Hokkaido",
"81591", "Tsu\,\ Mie",
"818295", "Hatsukaichi\,\ Hiroshima",
"814286", "Sagamihara\,\ Kanagawa",
"811354", "Yoichi\,\ Hokkaido",
"819679", "Takamori\,\ Kumamoto",
"81167", "Furano\,\ Hokkaido",
"814285", "Sagamihara\,\ Kanagawa",
"818296", "Hiroshima\,\ Hiroshima",
"814772", "Ichikawa\,\ Chiba",
"811333", "Tobetsu\,\ Hokkaido",
"817968", "Hamasaka\,\ Hyogo",
"814757", "Togane\,\ Chiba",
"811865", "Odate\,\ Akita",
"819727", "Usuki\,\ Oita",
"81985", "Miyazaki\,\ Miyazaki",
"814754", "Mobara\,\ Chiba",
"811866", "Takanosu\,\ Akita",
"819724", "Saiki\,\ Oita",
"81482", "Kawaguchi\,\ Saitama",
"811372", "Shikabe\,\ Hokkaido",
"81857", "Tottori\,\ Tottori",
"812387", "Nagai\,\ Yamagata",
"81594", "Kuwana\,\ Mie",
"8128798", "Otawara\,\ Tochigi",
"81925", "Fukuoka\,\ Fukuoka",
"811874", "Kakunodate\,\ Akita",
"817715", "Kameoka\,\ Kyoto",
"817483", "Yokaichi\,\ Shiga",
"81191", "Ichinoseki\,\ Iwate",
"812384", "Yonezawa\,\ Yamagata",
"81567", "Tsushima\,\ Aichi",
"811877", "Omagari\,\ Akita",
"817716", "Sonobe\,\ Kyoto",
"811332", "Tobetsu\,\ Hokkaido",
"81853", "Izumo\,\ Shimane",
"8182920", "Hatsukaichi\,\ Hiroshima",
"811234", "Chitose\,\ Hokkaido",
"811525", "Abashiri\,\ Hokkaido",
"818478", "Tojo\,\ Hiroshima",
"8153975", "Hamamatsu\,\ Shizuoka",
"811237", "Kuriyama\,\ Hokkaido",
"8125484", "Murakami\,\ Niigata",
"811526", "Abashiri\,\ Hokkaido",
"819435", "Yame\,\ Fukuoka",
"81292", "Mito\,\ Ibaraki",
"811956", "Iwate\,\ Iwate",
"81940", "Munakata\,\ Fukuoka",
"81270", "Isesaki\,\ Gunma",
"817686", "Noto\,\ Ishikawa",
"817482", "Yokaichi\,\ Shiga",
"81563", "Nishio\,\ Aichi",
"811955", "Ninohe\,\ Iwate",
"81775", "Otsu\,\ Shiga",
"817685", "Wajima\,\ Ishikawa",
"819943", "Kanoya\,\ Kagoshima",
"811853", "Oga\,\ Akita",
"814297", "Hanno\,\ Saitama",
"81933", "Kitakyushu\,\ Fukuoka",
"818382", "Hagi\,\ Yamaguchi",
"8188096", "Tosashimizu\,\ Kochi",
"8186993", "Bizen\,\ Okayama",
"81762", "Kanazawa\,\ Ishikawa",
"81249", "Koriyama\,\ Fukushima",
"81979", "Nakatsu\,\ Oita",
"812748", "Tomioka\,\ Gunma",
"817947", "Miki\,\ Hyogo",
"8112395", "Kuriyama\,\ Hokkaido",
"817674", "Hakui\,\ Ishikawa",
"8186994", "Seto\,\ Okayama",
"8175", "Kyoto\,\ Kyoto",
"817940", "Kakogawa\,\ Hyogo",
"81284", "Ashikaga\,\ Tochigi",
"817944", "Kakogawa\,\ Hyogo",
"818369", "Ube\,\ Yamaguchi",
"812614", "Omachi\,\ Nagano",
"819823", "Nobeoka\,\ Miyazaki",
"817677", "Nanao\,\ Ishikawa",
"811392", "Kikonai\,\ Hokkaido",
"815982", "Matsusaka\,\ Mie",
"818973", "Niihama\,\ Ehime",
"812796", "Shibukawa\,\ Gunma",
"817902", "Fukusaki\,\ Hyogo",
"81569", "Handa\,\ Aichi",
"817722", "Miyazu\,\ Kyoto",
"811732", "Goshogawara\,\ Aomori",
"812795", "Shibukawa\,\ Gunma",
"81463", "Hiratsuka\,\ Kanagawa",
"81998", "Kagoshima\,\ Kagoshima",
"819556", "Karatsu\,\ Saga",
"812640", "Nagano\,\ Nagano",
"81939", "Kitakyushu\,\ Fukuoka",
"81281", "Utsunomiya\,\ Tochigi",
"818362", "Ube\,\ Yamaguchi",
"812647", "Nagano\,\ Nagano",
"819555", "Karatsu\,\ Saga",
"811543", "Kushiro\,\ Hokkaido",
"817914", "Aioi\,\ Hyogo",
"815392", "Hamamatsu\,\ Shizuoka",
"81727", "Ikeda\,\ Osaka",
"812965", "Shimodate\,\ Ibaraki",
"811982", "Hanamaki\,\ Iwate",
"817456", "Yamatotakada\,\ Nara",
"81243", "Nihonmatsu\,\ Fukushima",
"815732", "Ena\,\ Gifu",
"812578", "Muika\,\ Niigata",
"81845", "Innoshima\,\ Hiroshima",
"8125483", "Murakami\,\ Niigata",
"814792", "Choshi\,\ Chiba",
"817455", "Yamatotakada\,\ Nara",
"818835", "Mima\,\ Tokushima",
"817738", "Maizuru\,\ Kyoto",
"812937", "Mito\,\ Ibaraki",
"811754", "Mutsu\,\ Aomori",
"812856", "Mooka\,\ Tochigi",
"81182", "Yokote\,\ Akita",
"818954", "Uwajima\,\ Ehime",
"812930", "Mito\,\ Ibaraki",
"818363", "Ube\,\ Yamaguchi",
"818836", "Mima\,\ Tokushima",
"812934", "Takahagi\,\ Ibaraki",
"811757", "Noheji\,\ Aomori",
"812855", "Oyama\,\ Tochigi",
"81834", "Tokuyama\,\ Yamaguchi",
"815393", "Hamamatsu\,\ Shizuoka",
"818957", "Misho\,\ Ehime",
"811542", "Kushiro\,\ Hokkaido",
"811983", "Hanamaki\,\ Iwate",
"818558", "Kawamoto\,\ Shimane",
"815733", "Ena\,\ Gifu",
"81977", "Beppu\,\ Oita",
"814793", "Choshi\,\ Chiba",
"81723", "Sakai\,\ Osaka",
"815754", "Sekigahara\,\ Gifu",
"812784", "Numata\,\ Gunma",
"811549", "Kushiro\,\ Hokkaido",
"812375", "Murayama\,\ Yamagata",
"81582", "Gifu\,\ Gifu",
"819822", "Nobeoka\,\ Miyazaki",
"812787", "Numata\,\ Gunma",
"8147950", "Yokaichiba\,\ Chiba",
"811393", "Matsumae\,\ Hokkaido",
"811658", "Kamikawa\,\ Hokkaido",
"812780", "Maebashi\,\ Gunma",
"812376", "Sagae\,\ Yamagata",
"81467", "Fujisawa\,\ Kanagawa",
"815983", "Matsusaka\,\ Mie",
"818972", "Niihama\,\ Ehime",
"81744", "Yamatotakada\,\ Nara",
"817723", "Miyazu\,\ Kyoto",
"811733", "Goshogawara\,\ Aomori",
"81494", "Chichibu\,\ Saitama",
"817903", "Fukusaki\,\ Hyogo",
"817463", "Yoshino\,\ Nara",
"81557", "Ito\,\ Shizuoka",
"817998", "Tsuna\,\ Hyogo",
"812797", "Shibukawa\,\ Gunma",
"812832", "Sano\,\ Tochigi",
"8112392", "Yubari\,\ Hokkaido",
"812873", "Otawara\,\ Tochigi",
"812794", "Shibukawa\,\ Gunma",
"819572", "Isahaya\,\ Nagasaki",
"817675", "Nanao\,\ Ishikawa",
"812616", "Omachi\,\ Nagano",
"817946", "Miki\,\ Hyogo",
"812412", "Kitakata\,\ Fukushima",
"817676", "Nanao\,\ Ishikawa",
"8186996", "Seto\,\ Okayama",
"819683", "Yamaga\,\ Kumamoto",
"817945", "Kakogawa\,\ Hyogo",
"812615", "Omachi\,\ Nagano",
"81174", "Kanita\,\ Aomori",
"815993", "Toba\,\ Mie",
"812232", "Iwanuma\,\ Miyagi",
"818372", "Nagato\,\ Yamaguchi",
"812964", "Shimodate\,\ Ibaraki",
"812698", "Iiyama\,\ Nagano",
"81157", "Kitami\,\ Hokkaido",
"817457", "Yamatotakada\,\ Nara",
"81480", "Kuki\,\ Saitama",
"81434", "Chiba\,\ Chiba",
"812839", "Sano\,\ Tochigi",
"812967", "Kasama\,\ Ibaraki",
"817454", "Yamatotakada\,\ Nara",
"813", "Tokyo",
"815763", "Gero\,\ Gifu",
"812239", "Sendai\,\ Miyagi",
"819557", "Karatsu\,\ Saga",
"8152", "Nagoya\,\ Aichi",
"81726", "Ibaraki\,\ Osaka",
"819742", "Mie\,\ Oita",
"812646", "Nagano\,\ Nagano",
"819554", "Imari\,\ Saga",
"818874", "Aki\,\ Kochi",
"817915", "Aioi\,\ Hyogo",
"81420", "Tokorozawa\,\ Saitama",
"812419", "Tajima\,\ Fukushima",
"818373", "Nagato\,\ Yamaguchi",
"812879", "Nasukarasuyama\,\ Tochigi",
"81938", "Kitakyushu\,\ Fukuoka",
"812551", "Joetsu\,\ Niigata",
"812936", "Mito\,\ Ibaraki",
"815999", "Tsu\,\ Mie",
"815762", "Gero\,\ Gifu",
"818834", "Kamojima\,\ Tokushima",
"819743", "Mie\,\ Oita",
"818955", "Uwajima\,\ Ehime",
"812857", "Mooka\,\ Tochigi",
"811756", "Noheji\,\ Aomori",
"81272", "Maebashi\,\ Gunma",
"81942", "Kurume\,\ Fukuoka",
"812935", "Mito\,\ Ibaraki",
"8186553", "Kurashiki\,\ Okayama",
"818956", "Uwajima\,\ Ehime",
"812854", "Oyama\,\ Tochigi",
"81246", "Iwaki\,\ Fukushima",
"8153970", "Hamamatsu\,\ Shizuoka",
"812833", "Utsunomiya\,\ Tochigi",
"812872", "Otawara\,\ Tochigi",
"819573", "Isahaya\,\ Nagasaki",
"81553", "Yamanashi\,\ Yamanashi",
"812413", "Kitakata\,\ Fukushima",
"812785", "Numata\,\ Gunma",
"815755", "Sekigahara\,\ Gifu",
"81466", "Fujisawa\,\ Kanagawa",
"812374", "Murayama\,\ Yamagata",
"81568", "Kasugai\,\ Aichi",
"812786", "Numata\,\ Gunma",
"819682", "Yamaga\,\ Kumamoto",
"81863", "Tamano\,\ Okayama",
"812377", "Sagae\,\ Yamagata",
"812233", "Iwanuma\,\ Miyagi",
"815769", "Shokawa\,\ Gifu",
"815992", "Toba\,\ Mie",
"819803", "Nago\,\ Okinawa",
"811356", "Iwanai\,\ Hokkaido",
"812678", "Saku\,\ Nagano",
"814280", "Tachikawa\,\ Tokyo",
"819599", "Oseto\,\ Nagasaki",
"81936", "Kitakyushu\,\ Fukuoka",
"818294", "Hatsukaichi\,\ Hiroshima",
"814287", "Ome\,\ Tokyo",
"817618", "Kaga\,\ Ishikawa",
"815362", "Shinshiro\,\ Aichi",
"818290", "Hiroshima\,\ Hiroshima",
"814284", "Tachikawa\,\ Tokyo",
"818297", "Hatsukaichi\,\ Hiroshima",
"817702", "Tsuruga\,\ Fukui",
"811932", "Kamaishi\,\ Iwate",
"81545", "Fuji\,\ Shizuoka",
"812995", "Ishioka\,\ Ibaraki",
"812544", "Shibata\,\ Niigata",
"812996", "Itako\,\ Ibaraki",
"81166", "Asahikawa\,\ Hokkaido",
"811973", "Mizusawa\,\ Iwate",
"812547", "Murakami\,\ Niigata",
"818894", "Susaki\,\ Kochi",
"81559", "Numazu\,\ Shizuoka",
"818543", "Yasugi\,\ Shimane",
"811875", "Kakunodate\,\ Akita",
"812386", "Nagai\,\ Yamagata",
"817714", "Kameoka\,\ Kyoto",
"811362", "Kutchan\,\ Hokkaido",
"811876", "Omagari\,\ Akita",
"812893", "Utsunomiya\,\ Tochigi",
"8112390", "Yubari\,\ Hokkaido",
"812385", "Yonezawa\,\ Yamagata",
"817717", "Sonobe\,\ Kyoto",
"819592", "Oseto\,\ Nagasaki",
"8168", "Osaka\,\ Osaka",
"814756", "Togane\,\ Chiba",
"819662", "Hitoyoshi\,\ Kumamoto",
"8198298", "Hyuga\,\ Miyazaki",
"8162", "Osaka\,\ Osaka",
"819726", "Usuki\,\ Oita",
"811864", "Odate\,\ Akita",
"814755", "Togane\,\ Chiba",
"817492", "Hikone\,\ Shiga",
"81468", "Yokosuka\,\ Kanagawa",
"815973", "Owase\,\ Mie",
"8199347", "Kagoshima\,\ Kagoshima",
"811867", "Takanosu\,\ Akita",
"811939", "Miyako\,\ Iwate",
"819725", "Saiki\,\ Oita",
"81566", "Kariya\,\ Aichi",
"81134", "Otaru\,\ Hokkaido",
"811957", "Iwate\,\ Iwate",
"819434", "Yame\,\ Fukuoka",
"818542", "Yasugi\,\ Shimane",
"8147955", "Yokaichiba\,\ Chiba",
"81531", "Tahara\,\ Aichi",
"817687", "Noto\,\ Ishikawa",
"812892", "Utsunomiya\,\ Tochigi",
"811954", "Ninohe\,\ Iwate",
"811363", "Kutchan\,\ Hokkaido",
"819437", "Tanushimaru\,\ Fukuoka",
"8153972", "Hamamatsu\,\ Shizuoka",
"819593", "Oseto\,\ Nagasaki",
"819809", "Yaeyama\ District\,\ Okinawa",
"817684", "Wajima\,\ Ishikawa",
"81822", "Hiroshima\,\ Hiroshima",
"819663", "Hitoyoshi\,\ Kumamoto",
"811235", "Yubari\,\ Hokkaido",
"811524", "Abashiri\,\ Hokkaido",
"811558", "Hiroo\,\ Hokkaido",
"8125486", "Tsugawa\,\ Niigata",
"81471", "Kashiwa\,\ Chiba",
"817493", "Hikone\,\ Shiga",
"815972", "Owase\,\ Mie",
"811236", "Chitose\,\ Hokkaido",
"811527", "Bihoro\,\ Hokkaido",
"8153965", "Hamamatsu\,\ Shizuoka",
"81534", "Hamamatsu\,\ Shizuoka",
"819802", "Minamidaito\,\ Okinawa",
"818512", "Nishigo\,\ Fukushima",
"812899", "Kanuma\,\ Tochigi",
"815363", "Shinshiro\,\ Aichi",
"817368", "Iwade\,\ Wakayama",
"815979", "Kumano\,\ Mie",
"811933", "Kamaishi\,\ Iwate",
"817703", "Tsuruga\,\ Fukui",
"81474", "Funabashi\,\ Chiba",
"812588", "Nagaoka\,\ Niigata",
"8126178", "Omachi\,\ Nagano",
"81728", "Neyagawa\,\ Osaka",
"811972", "Mizusawa\,\ Iwate",};
$areanames{ja} = {"811936", "宮古",
"817706", "小浜",
"811857", "能代",
"81565", "豊田",
"811935", "釜石",
"818808", "土佐清水",
"8188099", "土佐清水",
"817705", "小浜",
"81892", "久万",
"812992", "石岡",
"81927", "福岡",
"811352", "余市",
"818208", "久賀",
"81987", "日南",
"812389", "米沢",
"81253", "新潟",
"819666", "水俣",
"814752", "茂原",
"812999", "潮来",
"811374", "森",
"819722", "佐伯",
"81849", "福山",
"819665", "人吉",
"81572", "多治見",
"812382", "米沢",
"811365", "倶知安",
"819940", "志布志",
"811366", "寿都",
"819674", "熊本一の宮",
"819947", "志布志",
"814753", "茂原",
"819723", "佐伯",
"818546", "掛合",
"812383", "米沢",
"812248", "大河原",
"817487", "水口",
"818545", "木次",
"818668", "井原",
"819205", "厳原",
"81923", "福岡",
"818384", "萩",
"811975", "水沢",
"811976", "北上",
"812993", "石岡",
"819806", "沖縄宮古",
"811353", "余市",
"819805", "名護",
"81983", "高鍋",
"812416", "田島",
"812979", "竜ケ崎",
"811394", "松前",
"815588", "修善寺大仁",
"812415", "柳津",
"817672", "羽咋",
"815753", "関",
"81725", "和泉",
"815987", "三瀬谷",
"81234", "酒田",
"818688", "美作",
"817724", "宮津",
"817907", "播磨山崎",
"811737", "鰺ケ沢",
"819968", "出水",
"812933", "高萩",
"819746", "竹田",
"818953", "宇和島",
"818364", "宇部",
"812972", "水海道",
"815397", "浜松",
"81929", "福岡",
"815734", "恵那",
"818376", "美祢",
"8186697", "倉敷",
"81989", "那覇",
"814794", "銚子",
"818375", "美祢",
"811984", "花巻",
"811638", "利尻礼文",
"812932", "高萩",
"815766", "下呂",
"81779", "大野",
"811544", "釧路",
"815765", "下呂",
"81962", "熊本",
"81465", "小田原",
"812973", "水海道",
"818952", "宇和島",
"81259", "佐渡",
"819824", "延岡",
"819685", "玉名",
"81975", "大分",
"81245", "福島",
"8188097", "土佐清水",
"815752", "関",
"817673", "羽咋",
"819686", "玉名",
"812939", "水戸",
"818974", "新居浜",
"817725", "宮津",
"812956", "常陸大宮",
"81192", "大船渡",
"812830", "宇都宮",
"812837", "佐野",
"812955", "常陸大宮",
"817726", "峰山",
"819577", "島原",
"8198290", "延岡",
"811395", "江差",
"8112398", "栗山",
"819978", "徳之島",
"812414", "柳津",
"812230", "仙台",
"812373", "村山",
"812237", "仙台",
"811396", "江差",
"811986", "遠野",
"815735", "恵那",
"814795", "銚子",
"81424", "武蔵野三鷹",
"81778", "武生",
"818374", "長門",
"815736", "中津川",
"812962", "下館",
"814796", "八日市場",
"818366", "宇部",
"81484", "川口",
"819744", "三重",
"818365", "宇部",
"81294", "常陸太田",
"81928", "福岡",
"812963", "下館",
"811545", "釧路",
"815764", "下呂",
"81988", "那覇",
"818797", "土庄",
"8125487", "津川",
"811546", "釧路",
"818976", "新居浜",
"8167", "大阪",
"81764", "富山",
"818975", "新居浜",
"812877", "黒磯",
"819684", "山鹿",
"819825", "日向",
"819938", "加世田",
"819826", "日向",
"815997", "阿児",
"8186999", "岡山瀬戸",
"812372", "村山",
"818698", "備前",
"814775", "船橋",
"814282", "青梅",
"815367", "設楽",
"81926", "福岡",
"814776", "船橋",
"8186997", "岡山瀬戸",
"81986", "都城",
"817704", "敦賀",
"811934", "釜石",
"817958", "丹波柏原",
"812542", "新発田",
"811953", "二戸",
"811364", "倶知安",
"8198292", "延岡",
"817683", "輪島",
"819676", "高森",
"814289", "青梅",
"817712", "亀岡",
"819675", "熊本一の宮",
"819597", "福江",
"8125489", "津川",
"812549", "津川",
"811375", "八雲",
"817497", "長浜",
"819664", "人吉",
"812658", "伊那",
"811523", "斜里",
"811376", "八雲",
"811952", "二戸",
"817682", "輪島",
"818544", "木次",
"81848", "尾道",
"812897", "鹿沼",
"812890", "宇都宮",
"817713", "亀岡",
"81581", "高富",
"811336", "石狩",
"815977", "熊野",
"811522", "斜里",
"818678", "新見",
"81832", "下関",
"81776", "福井",
"814283", "青梅",
"81143", "室蘭",
"819804", "名護",
"818514", "海士",
"819204", "郷ノ浦",
"811647", "羽幌",
"81584", "大垣",
"818385", "萩",
"811974", "水沢",
"812543", "新発田",
"817676", "七尾",
"819683", "山鹿",
"817675", "七尾",
"812412", "喜多方",
"817998", "津名",
"812797", "渋川",
"812976", "竜ケ崎",
"81420", "所沢",
"812419", "田島",
"819557", "唐津",
"815763", "下呂",
"81726", "茨木",
"812975", "水海道",
"819742", "三重",
"818877", "嶺北",
"813", "東京",
"818372", "長門",
"81157", "北見",
"812964", "下館",
"812698", "飯山",
"817457", "大和高田",
"81480", "久喜",
"812935", "水戸",
"818837", "阿波池田",
"818956", "宇和島",
"81246", "いわき",
"815762", "下呂",
"812936", "水戸",
"819743", "三重",
"818955", "宇和島",
"812857", "真岡",
"818373", "長門",
"819682", "山鹿",
"815756", "郡上八幡",
"815769", "荘川",
"812413", "喜多方",
"815755", "関",
"81466", "藤沢",
"812374", "村山",
"81568", "春日井",
"811973", "水沢",
"812996", "潮来",
"817702", "敦賀",
"811932", "釜石",
"812995", "石岡",
"812544", "新発田",
"818290", "広島",
"814284", "立川",
"818297", "廿日市",
"819803", "名護",
"812678", "佐久",
"811356", "岩内",
"814755", "東金",
"81468", "横須賀",
"81566", "刈谷",
"819725", "佐伯",
"811867", "鷹巣",
"8199347", "鹿児島",
"811939", "宮古",
"814756", "東金",
"819662", "人吉",
"819726", "臼杵",
"8162", "大阪",
"811362", "倶知安",
"812385", "米沢",
"8168", "大阪",
"818543", "安来",
"812386", "長井",
"817714", "亀岡",
"81964", "松橋",
"819663", "人吉",
"811524", "網走",
"81471", "柏",
"819437", "田主丸",
"811363", "倶知安",
"811954", "二戸",
"817684", "輪島",
"819809", "八重山",
"81134", "小樽",
"818542", "安来",
"81728", "寝屋川",
"811972", "水沢",
"811933", "釜石",
"817368", "岩出",
"81474", "船橋",
"817703", "敦賀",
"8188094", "窪川",
"818549", "石見大田",
"815957", "上野",
"819802", "南大東",
"818512", "西郷",
"819679", "高森",
"811354", "余市",
"814285", "相模原",
"814772", "市川",
"818848", "牟岐",
"81729", "八尾",
"814286", "相模原",
"818248", "庄原",
"812546", "村上",
"818383", "萩",
"812545", "村上",
"812994", "石岡",
"812384", "米沢",
"811877", "大曲",
"81567", "津島",
"817716", "園部",
"8128798", "大田原",
"81925", "福岡",
"819672", "熊本一の宮",
"81191", "一関",
"817715", "亀岡",
"81985", "宮崎",
"814754", "茂原",
"819724", "佐伯",
"81482", "川口",
"811372", "鹿部",
"81857", "鳥取",
"817968", "浜坂",
"811333", "当別",
"81775", "大津",
"811955", "二戸",
"817685", "輪島",
"811956", "岩手",
"81292", "水戸",
"817686", "能都",
"819673", "熊本一の宮",
"81563", "西尾",
"811237", "栗山",
"811526", "網走",
"8125484", "村上",
"811332", "当別",
"81853", "出雲",
"811525", "網走",
"81979", "中津",
"81249", "郡山",
"81762", "金沢",
"818382", "萩",
"817722", "宮津",
"81569", "半田",
"81463", "平塚",
"818973", "新居浜",
"818369", "宇部",
"819823", "延岡",
"811392", "木古内",
"812617", "大町",
"8112395", "栗山",
"812748", "富岡",
"817947", "三木",
"8186994", "岡山瀬戸",
"817674", "羽咋",
"8175", "京都",
"817940", "加古川",
"815732", "恵那",
"81845", "因島",
"814792", "銚子",
"81727", "池田",
"812965", "下館",
"811982", "花巻",
"81243", "二本松",
"818267", "千代田",
"811543", "釧路",
"812640", "長野",
"817917", "竜野",
"812647", "長野",
"818362", "宇部",
"812974", "水海道",
"815733", "恵那",
"81977", "別府",
"814793", "銚子",
"81723", "堺",
"811983", "花巻",
"812934", "高萩",
"811757", "野辺地",
"81834", "徳山",
"811542", "釧路",
"818363", "宇部",
"818954", "宇和島",
"817723", "宮津",
"81467", "藤沢",
"818972", "新居浜",
"819822", "延岡",
"812787", "沼田",
"811658", "上川",
"812780", "前橋",
"812376", "寒河江",
"811393", "松前",
"8147950", "八日市場",
"815754", "関",
"811549", "釧路",
"812375", "村山",
"81582", "岐阜",
"818657", "笠岡",
"815958", "亀山",
"811533", "根室",
"8198293", "延岡",
"818949", "宇和",
"81244", "原町",
"812584", "長岡",
"815742", "美濃加茂",
"817367", "岩出",
"819438", "田主丸",
"818583", "倉吉",
"818464", "竹原",
"818476", "府中",
"811554", "帯広",
"81464", "厚木",
"818475", "府中",
"818942", "八幡浜",
"81138", "函館",
"818582", "倉吉",
"811539", "根室標津",
"812914", "鉾田",
"81142", "伊達",
"811868", "鷹巣",
"81896", "伊予三島",
"81721", "富田林",
"818943", "八幡浜",
"81235", "鶴岡",
"818298", "廿日市",
"812677", "佐久",
"817614", "小松",
"81833", "下松",
"811532", "根室",
"81478", "佐原",
"8199345", "鹿児島",
"815743", "美濃加茂",
"81724", "岸和田貝塚",
"81199", "盛岡",
"818562", "益田",
"811452", "早来",
"819789", "杵築",
"812489", "須賀川",
"8124196", "柳津",
"81898", "今治",
"81839", "山口",
"818556", "江津",
"81250", "新津",
"818555", "江津",
"818838", "阿波池田",
"817735", "福知山",
"811465", "静内",
"819782", "豊後高田",
"812482", "白河",
"81578", "神岡",
"8188098", "土佐清水",
"817736", "舞鶴",
"81476", "成田",
"811466", "えりも",
"812858", "真岡",
"812576", "十日町",
"814704", "館山",
"812575", "十日町",
"812697", "飯山",
"817458", "大和榛原",
"819957", "加治木",
"81561", "瀬戸",
"812483", "白河",
"819783", "豊後高田",
"819558", "唐津",
"818878", "嶺北",
"812564", "三条",
"818563", "益田",
"8186698", "倉敷",
"817997", "津名",
"812798", "長野原",
"811453", "早来",
"81564", "岡崎",
"8125488", "津川",
"812788", "前橋",
"81585", "揖斐川",
"812553", "上越",
"814222", "武蔵野三鷹",
"817734", "福知山",
"811464", "静内",
"811583", "紋別",
"811942", "岩泉",
"814229", "武蔵野三鷹",
"818554", "浜田",
"818268", "千代田",
"812559", "安塚",
"812566", "三条",
"8112397", "栗山",
"812565", "三条",
"811582", "紋別",
"812648", "長野",
"811943", "岩泉",
"814705", "館山",
"81473", "市川",
"814706", "大原",
"81196", "盛岡",
"812574", "柏崎",
"811589", "興部",
"8198296", "日向",
"812618", "大町",
"817948", "三木",
"812747", "富岡",
"812552", "上越",
"81899", "松山",
"814223", "武蔵野三鷹",
"8144", "川崎",
"81963", "熊本",
"812585", "長岡",
"811562", "本別",
"812586", "長岡",
"819732", "日田",
"81765", "魚津",
"812473", "石川",
"811555", "帯広",
"811238", "栗山",
"8112399", "栗山",
"81252", "新潟",
"811556", "帯広",
"818474", "府中",
"818592", "米子",
"818466", "木江",
"81969", "天草",
"81893", "大洲",
"817967", "八鹿",
"8186998", "岡山瀬戸",
"817960", "八鹿",
"818593", "米子",
"81485", "熊谷",
"811878", "大曲",
"81922", "福岡",
"817239", "寝屋川",
"81425", "立川",
"818247", "庄原",
"811563", "本別",
"818240", "東広島",
"817616", "小松",
"81577", "高山",
"819733", "日田",
"817615", "小松",
"818847", "牟岐",
"812472", "石川",
"814224", "武蔵野三鷹",
"818559", "川本",
"818565", "益田",
"8183766", "下関",
"811455", "鵡川",
"811456", "門別富川",
"81242", "会津若松",
"81587", "一宮",
"811944", "岩泉",
"812573", "柏崎",
"818552", "浜田",
"817732", "福知山",
"81965", "八代",
"8188095", "土佐清水",
"819785", "豊後高田",
"812485", "白河",
"81462", "厚木",
"811462", "浦河",
"819233", "前原",
"812486", "須賀川",
"819786", "杵築",
"818553", "浜田",
"81489", "草加",
"812572", "柏崎",
"811637", "北見枝幸",
"81583", "岐阜",
"81429", "所沢",
"817733", "福知山",
"811463", "浦河",
"819232", "前原",
"815398", "浜松",
"81144", "苫小牧",
"811584", "遠軽",
"818687", "美作",
"815988", "三瀬谷",
"818680", "岡山",
"812579", "小出",
"811738", "鰺ケ沢",
"817908", "播磨山崎",
"819967", "出水",
"817468", "上北山",
"815587", "修善寺大仁",
"81722", "堺",
"818493", "尾道",
"812554", "上越",
"819734", "日田",
"818479", "東城",
"815746", "美濃加茂",
"811564", "上士幌",
"815745", "美濃加茂",
"81423", "国分寺",
"817488", "水口",
"812247", "大河原",
"818667", "井原",
"818660", "岡山瀬戸",
"8198291", "延岡",
"818946", "宇和",
"817357", "串本",
"818945", "八幡浜",
"818594", "米子",
"818472", "甲山",
"818585", "倉吉",
"81236", "山形",
"8145", "横浜",
"818586", "倉吉",
"819948", "志布志",
"819547", "鹿島",
"818473", "甲山",
"81763", "福野",
"818207", "久賀",
"811536", "厚岸",
"81852", "松江",
"81487", "浦和",
"812474", "石川",
"811535", "厚岸",
"81427", "相模原",
"811858", "能代",
"818807", "宿毛",
"81562", "尾張横須賀",
"811648", "焼尻",
"812582", "長岡",
"815744", "美濃加茂",
"811559", "帯広",
"811566", "十勝清水",
"819735", "日田",
"81240", "磐城富岡",
"817613", "小松",
"81835", "防府",
"818596", "米子",
"811552", "帯広",
"81233", "新庄",
"812589", "長岡",
"818677", "新見",
"818595", "米子",
"815978", "熊野",
"818944", "八幡浜",
"81766", "高岡",
"812898", "鹿沼",
"818462", "竹原",
"812913", "鉾田",
"81460", "小田原",
"8112394", "夕張",
"8186995", "岡山瀬戸",
"811553", "帯広",
"814998", "小笠原",
"817498", "長浜",
"812657", "伊那",
"818584", "倉吉",
"818463", "竹原",
"819598", "福江",
"812583", "長岡",
"817957", "丹波柏原",
"817950", "三田",
"81486", "浦和",
"812476", "三春",
"81426", "八王子",
"815368", "設楽",
"812475", "石川",
"817612", "小松",
"811534", "中標津",
"811454", "鵡川",
"819937", "加世田",
"818690", "岡山",
"818697", "備前",
"815998", "阿児",
"8125485", "津川",
"814225", "武蔵野三鷹",
"812878", "烏山",
"818564", "益田",
"814226", "武蔵野三鷹",
"81586", "一宮",
"81488", "浦和",
"819784", "豊後高田",
"812484", "白河",
"818798", "土庄",
"812563", "三条",
"81774", "宇治",
"814703", "館山",
"811945", "久慈",
"8166", "大阪",
"811946", "久慈",
"81984", "小林",
"811586", "中湧別",
"811585", "遠軽",
"812562", "三条",
"814702", "館山",
"81298", "土浦",
"81924", "福岡",
"812569", "巻",
"812556", "糸魚川",
"819977", "瀬戸内",
"812238", "仙台",
"812555", "糸魚川",
"812838", "佐野",
"819578", "島原",
"814709", "鴨川",
"81268", "上田",
"81172", "弘前",
"811854", "男鹿",
"812478", "三春",
"8161", "大阪",
"817238", "寝屋川",
"815366", "設楽",
"814770", "市川",
"81739", "田辺",
"814777", "船橋",
"811551", "十勝池田",
"81798", "西宮",
"817495", "長浜",
"814996", "八丈島",
"8198295", "日向",
"817496", "長浜",
"81546", "静岡",
"811233", "千歳",
"811377", "八雲",
"819595", "有川",
"819677", "矢部",
"819944", "鹿屋",
"81432", "千葉",
"81935", "北九州",
"819596", "福江",
"811337", "石狩",
"818598", "根雨",
"81944", "瀬高",
"811232", "千歳",
"812895", "宇都宮",
"812896", "鹿沼",
"811873", "角館",
"817484", "八日市",
"8199343", "鹿児島",
"812911", "鉾田",
"811646", "羽幌",
"8169", "大阪",
"818387", "田万川",
"811645", "留萌",
"819738", "玖珠",
"812612", "大町",
"817942", "加古川",
"817475", "下市",
"812235", "仙台",
"812558", "新井",
"81220", "迫",
"812783", "沼田",
"812649", "長野",
"817476", "下市",
"811397", "奥尻",
"812236", "仙台",
"817904", "福崎",
"812957", "大子",
"811734", "五所川原",
"819575", "諫早",
"812836", "佐野",
"817464", "吉野",
"815984", "松阪",
"817727", "峰山",
"812835", "佐野",
"819576", "島原",
"81280", "古河",
"818360", "小郡",
"8188091", "窪川",
"811588", "興部",
"817912", "相生",
"818367", "宇部",
"812642", "木曾福島",
"815394", "浜松",
"811753", "むつ",
"818262", "加計",
"812619", "大町",
"817949", "加古川",
"811987", "遠野",
"8111", "札幌",
"815737", "中津川",
"81737", "湯浅",
"814797", "八日市場",
"818795", "三本松",
"812643", "木曾福島",
"812789", "前橋",
"818796", "土庄",
"818263", "加計",
"811752", "むつ",
"81266", "諏訪",
"811547", "白糠",
"8182942", "広島",
"817943", "加古川",
"812613", "大町",
"81548", "榛原",
"815995", "阿児",
"819827", "高千穂",
"814701", "鴨川",
"812782", "沼田",
"81740", "今津",
"815996", "阿児",
"8186691", "倉敷",
"812875", "大田原",
"81532", "豊橋",
"818977", "伯方",
"812876", "黒磯",
"81950", "平戸",
"814228", "武蔵野三鷹",
"811735", "五所川原",
"81793", "姫路",
"817905", "福崎",
"815986", "松阪",
"819574", "諫早",
"817465", "吉野",
"812792", "渋川",
"817459", "大和榛原",
"811736", "五所川原",
"81549", "静岡",
"815985", "松阪",
"817906", "播磨山崎",
"817466", "十津川",
"812834", "宇都宮",
"817474", "五条",
"812417", "会津山口",
"812234", "仙台",
"8125481", "村上",
"818879", "室戸",
"818377", "下関",
"81592", "津",
"817452", "大和高田",
"81263", "松本",
"812799", "長野原",
"819552", "伊万里",
"812853", "小山",
"815395", "浜松",
"818872", "室戸",
"819747", "竹田",
"818833", "鴨島",
"815396", "浜松",
"81555", "吉田",
"817453", "大和高田",
"815767", "下呂",
"819553", "伊万里",
"818794", "三本松",
"818873", "安芸",
"812852", "小山",
"818832", "鴨島",
"819788", "国東",
"812488", "須賀川",
"818568", "津和野",
"812874", "大田原",
"812793", "渋川",
"81797", "西宮",
"812571", "六日町",
"815994", "阿児",
"819687", "玉名",
"812859", "小山",
"818397", "小郡",
"815953", "上野",
"811538", "根室標津",
"81222", "仙台",
"818292", "広島",
"817707", "小浜",
"8199331", "鹿児島",
"811937", "宮古",
"811869", "大館",
"81282", "栃木",
"811856", "能代",
"818892", "佐川",
"811855", "能代",
"818299", "広島",
"819945", "鹿屋",
"819594", "有川",
"818588", "郡家",
"811367", "寿都",
"81547", "島田",
"819433", "八女",
"819946", "鹿屋",
"817494", "彦根",
"819667", "水俣",
"8163", "大阪",
"814994", "三宅",
"811862", "鹿角",
"818547", "掛合",
"812894", "宇都宮",
"81543", "静岡",
"8183768", "下関",
"817486", "水口",
"819432", "八女",
"815959", "亀山",
"817485", "八日市",
"81124", "芦別",
"815974", "尾鷲",
"818948", "宇和",
"81184", "本荘",
"811863", "鹿角",
"815952", "上野",
"819807", "沖縄宮古",
"81742", "奈良",
"81492", "川越",
"818293", "廿日市",
"81952", "佐賀",
"81738", "御坊",
"815748", "美濃白川",
"818893", "佐川",
"811644", "留萌",
"811977", "北上",
"817472", "五条",
"8186996", "岡山瀬戸",
"812615", "大町",
"81174", "蟹田",
"817945", "加古川",
"812232", "岩沼",
"815993", "鳥羽",
"817946", "三木",
"812616", "大町",
"812873", "大田原",
"819572", "諫早",
"812794", "渋川",
"81557", "伊東",
"8188093", "窪川",
"8112392", "夕張",
"812832", "佐野",
"818793", "三本松",
"818266", "千代田",
"819554", "伊万里",
"812568", "巻",
"818874", "安芸",
"817915", "相生",
"812645", "木曾福島",
"818265", "安芸吉田",
"812239", "仙台",
"8152", "名古屋",
"812646", "長野",
"817916", "竜野",
"81434", "千葉",
"812839", "佐野",
"812967", "笠間",
"817454", "大和高田",
"814708", "大原",
"81942", "久留米",
"81272", "前橋",
"811756", "野辺地",
"818792", "三本松",
"8186553", "倉敷",
"812854", "小山",
"815999", "津",
"818834", "鴨島",
"81938", "北九州",
"812551", "上越",
"812879", "烏山",
"812786", "沼田",
"81863", "玉野",
"817473", "五条",
"815992", "鳥羽",
"812233", "岩沼",
"812377", "寒河江",
"812785", "沼田",
"812872", "大田原",
"81553", "山梨",
"819573", "諫早",
"812833", "宇都宮",
"81166", "旭川",
"818894", "須崎",
"812547", "村上",
"81545", "富士",
"811643", "石狩深川",
"817618", "加賀",
"815362", "新城",
"814280", "立川",
"819599", "大瀬戸",
"81936", "北九州",
"818294", "廿日市",
"814287", "青梅",
"817492", "彦根",
"815973", "尾鷲",
"8198298", "日向",
"811864", "大館",
"814992", "伊豆大島",
"812893", "宇都宮",
"8112390", "夕張",
"811876", "大曲",
"817717", "園部",
"819592", "大瀬戸",
"811875", "角館",
"81559", "沼津",
"817493", "彦根",
"811527", "美幌",
"815972", "尾鷲",
"811236", "千歳",
"81822", "広島",
"8125486", "津川",
"811558", "広尾",
"811235", "夕張",
"812892", "宇都宮",
"819593", "大瀬戸",
"819434", "八女",
"811957", "岩手",
"81531", "田原",
"817687", "能都",
"8147955", "八日市場",
"815979", "熊野",
"811642", "石狩深川",
"812588", "長岡",
"815954", "上野",
"815363", "新城",
"81534", "浜松",
"812899", "鹿沼",
"81167", "富良野",
"819912", "中之島",
"818296", "広島",
"811357", "岩内",
"819949", "大根占",
"818295", "廿日市",
"81591", "津",
"818895", "須崎",
"812997", "潮来",
"81937", "北九州",
"818896", "須崎",
"811852", "男鹿",
"819942", "大根占",
"81594", "桑名",
"812387", "長井",
"811874", "角館",
"817483", "八日市",
"811866", "鷹巣",
"814757", "東金",
"819727", "臼杵",
"811865", "大館",
"8153962", "天竜",
"819943", "鹿屋",
"819435", "八女",
"81270", "伊勢崎",
"81940", "宗像",
"817482", "八日市",
"818478", "東城",
"8182920", "廿日市",
"811234", "千歳",
"819913", "硫黄島",
"815955", "上野",
"8186993", "備前",
"815956", "上野",
"814297", "飯能",
"81933", "北九州",
"8188096", "土佐清水",
"811853", "男鹿",
"817902", "福崎",
"811732", "五所川原",
"812795", "渋川",
"81998", "鹿児島",
"815982", "松阪",
"812796", "渋川",
"812614", "大町",
"817944", "加古川",
"817677", "七尾",
"815399", "天竜",
"81284", "足利",
"812578", "六日町",
"8125483", "村上",
"817455", "大和高田",
"817456", "大和高田",
"819555", "唐津",
"817914", "相生",
"818875", "土佐山田",
"812644", "木曾福島",
"812977", "竜ケ崎",
"815392", "浜松",
"81939", "北九州",
"819556", "唐津",
"818264", "安芸吉田",
"81281", "宇都宮",
"818876", "土佐山田",
"818558", "川本",
"818836", "脇町",
"815393", "浜松",
"812855", "小山",
"818957", "御荘",
"818835", "脇町",
"812937", "水戸",
"817738", "舞鶴",
"811754", "むつ",
"812856", "真岡",
"81182", "横手",
"812930", "水戸",
"811733", "五所川原",
"817903", "福崎",
"81494", "秩父",
"817463", "吉野",
"815983", "松阪",
"81744", "大和高田",
"8153960", "天竜",
"815757", "郡上八幡",
"812784", "沼田",
"818654", "鴨方",
"814240", "国分寺",
"8147957", "八日市場",
"817953", "西脇",
"817364", "和歌山橋本",
"818679", "新見",
"812580", "十日町",
"812587", "長岡",
"818467", "木江",
"811958", "岩手",
"81885", "小松島",
"817688", "能都",
"81825", "広島",
"818672", "福渡",
"812653", "飯田",
"811528", "美幌",
"811557", "十勝池田",
"814771", "市川",
"812917", "水戸",
"817718", "園部",
"8153961", "天竜",
"817965", "豊岡",
"81227", "仙台",
"81176", "十和田",
"81743", "奈良",
"812652", "飯田",
"818673", "福渡",
"81493", "東松山",
"817966", "八鹿",
"817959", "三田",
"818845", "丹生谷",
"812674", "小諸",
"81436", "市原",
"817617", "加賀",
"81538", "磐田",
"818846", "丹生谷",
"814288", "青梅",
"818246", "三次",
"817952", "西脇",
"81542", "静岡",
"818245", "三次",
"812659", "伊那",
"81593", "四日市",
"819973", "種子島",
"818692", "邑久",
"811656", "美深",
"812378", "寒河江",
"81262", "長野",
"81178", "八戸",
"811655", "名寄",
"819932", "指宿",
"81438", "木更津",
"81792", "姫路",
"812968", "笠間",
"812694", "中野",
"819954", "加治木",
"814707", "大原",
"81934", "北九州",
"814700", "鴨川",
"812560", "糸魚川",
"812567", "巻",
"81877", "丸亀",
"819979", "徳之島",
"817994", "洲本",
"811541", "弟子屈",
"812745", "藤岡",
"81229", "古川",
"819972", "種子島",
"818693", "邑久",
"812746", "富岡",
"819933", "指宿",
"8198294", "延岡",
"818490", "尾道",
"815758", "郡上八幡",
"81288", "今市",
"811654", "名寄",
"815583", "下田",
"8112391", "夕張",
"819963", "川内",
"818683", "津山",
"81228", "築館",
"818958", "御荘",
"817737", "舞鶴",
"812938", "水戸",
"81537", "掛川",
"818557", "川本",
"8164", "大阪",
"81125", "滝川",
"815589", "修善寺大仁",
"81533", "豊橋",
"81439", "木更津",
"812978", "竜ケ崎",
"8182943", "広島",
"812577", "六日町",
"812695", "中野",
"811632", "天塩",
"818689", "岡山",
"819955", "加治木",
"812570", "小出",
"819969", "中甑",
"812696", "飯山",
"819956", "加治木",
"817678", "七尾",
"81958", "長崎",
"812744", "藤岡",
"815582", "下田",
"81179", "三戸",
"819962", "川内",
"817995", "洲本",
"811639", "利尻礼文",
"818682", "津山",
"81596", "伊勢",
"817996", "津名",
"818803", "土佐中村",
"814298", "飯能",
"817365", "和歌山橋本",
"8153977", "天竜",
"817366", "岩出",
"81433", "千葉",
"818655", "鴨方",
"81878", "高松",
"818203", "柳井",
"8183767", "下関",
"818656", "笠岡",
"81260", "阿南町",
"818669", "総社",
"819543", "武雄",
"818391", "小郡",
"817352", "新宮",
"815562", "鰍沢青柳",
"818477", "東城",
"81956", "佐世保",
"818662", "高梁",
"812242", "白石",
"817964", "豊岡",
"817353", "新宮",
"819542", "武雄",
"815563", "鰍沢青柳",
"814758", "東金",
"81554", "大月",
"819728", "臼杵",
"81286", "宇都宮",
"818663", "総社",
"81177", "青森",
"81226", "気仙沼",
"81864", "倉敷",
"812388", "長井",
"812243", "白石",
"818802", "窪川",
"812998", "潮来",
"81551", "韮崎",
"818244", "三次",
"818844", "阿南",
"812675", "佐久",
"818202", "柳井",
"812676", "佐久",
"818978", "伯方",
"814220", "国分寺",
"8125482", "村上",
"81535", "浜松",
"814227", "武蔵野三鷹",
"812743", "藤岡",
"819936", "加世田",
"818695", "岡山瀬戸",
"8198299", "日向",
"819828", "高千穂",
"81276", "太田",
"81946", "甘木",
"811652", "士別",
"819935", "加世田",
"818696", "備前",
"811947", "久慈",
"811548", "弟子屈",
"81888", "高知",
"811634", "浜頓別",
"815738", "中津川",
"814798", "八日市場",
"811587", "中湧別",
"818368", "宇部",
"81828", "広島",
"819964", "川内",
"818684", "津山",
"817728", "峰山",
"81183", "湯沢",
"819975", "名瀬",
"812550", "安塚",
"812742", "藤岡",
"812557", "新井",
"819976", "名瀬",
"815584", "下田",
"81544", "富士宮",
"811398", "熊石",
"811653", "士別",
"818843", "阿南",
"81886", "徳島",
"8165", "大阪",
"819737", "玖珠",
"818243", "東広島",
"818388", "田万川",
"811567", "十勝清水",
"818664", "高梁",
"8125480", "村上",
"812244", "白石",
"8126177", "長野",
"817354", "新宮",
"817963", "豊岡",
"815564", "鰍沢青柳",
"818597", "根雨",
"818675", "久世",
"814281", "相模原",
"818676", "久世",
"8186992", "備前",
"81932", "北九州",
"819678", "矢部",
"81550", "御殿場",
"817962", "豊岡",
"819544", "武雄",
"81948", "飯塚",
"818249", "東広島",
"812655", "飯田",
"8112396", "栗山",
"811378", "今金",
"812656", "伊那",
"81162", "稚内",
"817230", "寝屋川",
"818842", "阿南",
"812477", "三春",
"818204", "柳井",
"8153963", "天竜",
"818804", "土佐中村",
"817955", "三田",
"8198297", "日向",
"817956", "三田",
"818242", "東広島",
"817969", "浜坂",
"815747", "美濃白川",
"817362", "和歌山橋本",
"819208", "対馬佐賀",
"811978", "北上",
"8124197", "柳津",
"818652", "倉敷",
"819808", "八重山",
"812673", "小諸",
"81495", "本庄",
"81992", "鹿児島",
"81827", "岩国",
"8188090", "窪川",
"817355", "新宮",
"818674", "久世",
"815565", "鰍沢青柳",
"818947", "宇和",
"817356", "串本",
"815566", "身延",
"818548", "石見大田",
"818665", "高梁",
"812246", "大河原",
"818666", "井原",
"812245", "大河原",
"81949", "直方",
"819668", "水俣",
"812654", "飯田",
"819546", "鹿島",
"81188", "秋田",
"814291", "飯能",
"818587", "郡家",
"812679", "佐久",
"817363", "和歌山橋本",
"817954", "西脇",
"811938", "宮古",
"818805", "土佐中村",
"818806", "宿毛",
"81734", "和歌山",
"818206", "柳井",
"812672", "小諸",
"818398", "小郡",
"81225", "石巻",
"811537", "中標津",
"818205", "柳井",
"81823", "呉",
"818694", "岡山",
"819688", "玉名",
"8153974", "天竜",
"811457", "門別富川",
"819934", "指宿",
"818567", "津和野",
"817993", "洲本",
"81126", "岩見沢",
"81947", "田川",
"81277", "桐生",
"815768", "下呂",
"8178", "神戸",
"819787", "国東",
"812487", "須賀川",
"812693", "中野",
"8112393", "夕張",
"8188092", "窪川",
"819953", "大口",
"81552", "甲府",
"81930", "行橋",
"812692", "中野",
"818378", "下関",
"81862", "岡山",
"811635", "浜頓別",
"819952", "大口",
"811636", "北見枝幸",
"812418", "会津山口",
"819974", "屋久島",
"815586", "下田",
"815585", "下田",
"8186552", "倉敷",
"8182941", "広島",
"81273", "高崎",
"818686", "津山",
"819965", "川内",
"817992", "洲本",
"818685", "津山",
"819966", "出水",
"81875", "観音寺",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;