package Firewall::Policy::FindIp;

#------------------------------------------------------------------------------
# 加载扩展模块
#------------------------------------------------------------------------------
use Moose;
use namespace::autoclean;
use Encode;
use Time::HiRes;
use Storable;

#------------------------------------------------------------------------------
# 加载项目模块
#------------------------------------------------------------------------------
use Firewall::Utils::Ip;
use Firewall::Utils::Set;
use Firewall::Config::Dao::Parser;

#------------------------------------------------------------------------------
# 模块方法属性
#------------------------------------------------------------------------------
has dbi => (is => 'ro', does => 'Firewall::DBI::Role', required => 1,);

sub search {
  my ($self, $ipaddr, $srvMap) = @_;
  $ipaddr =~ s/$/\/32/ if not $ipaddr =~ /\//;
  my $fwInfos         = $self->getFwInfo();
  my $protectedZone   = 1;
  my $unprotectedZone = 0;
  my $hitFw           = $self->searchFw($ipaddr, $fwInfos->{"$protectedZone"});
  my $ipMap           = {origin => $ipaddr};
  my $result;
  my $foundAddress = 0;

  for my $fwInfo (@{$hitFw}) {
    my $parser = Firewall::Config::Dao::Parser->new(dbi => $self->dbi)->loadParser($fwInfo->{fwId});
    my $searcher;
    my $class = ref($parser);
    eval("use $class;\$searcher = Firewall::Policy::Searcher::$fwInfo->new{fw_type};");
    confess $@ if $@;
    if ($fwInfo->{zoneType} eq 'private') {
      $ipMap->{realIp}{$ipaddr} = {zone => $fwInfo->{zone}, zoneType => 'private'};
      my $natZone = $self->getNatZone($fwInfos, $fwInfo, $parser);
      my $mainIp  = $searcher->createMainAddr($ipaddr, $natZone, $parser, {'0.0.0.0/0' => {main => '0.0.0.0/0'}}, 'src');
      $ipMap->{natIp}{$mainIp} = {zone => $natZone} if defined $mainIp;
      my $addressName = $searcher->getAnAddressName($parser, $fwInfo->{zone}, $ipaddr);
      $ipMap->{realIp}{$ipaddr}{name} = $addressName->[0] if defined $addressName;
      my $addGroup  = $self->searchAddressGroup($parser, $ipaddr, $fwInfo->{zone});
      my $addGroup1 = $self->searchAddressGroup($parser, $mainIp, $natZone) if defined $mainIp;
      $ipMap->{realIp}{$ipaddr}{addressGroup} = $addGroup  if defined $addGroup;
      $ipMap->{natIp}{$mainIp}{addressGroup}  = $addGroup1 if defined $addGroup1;
      $foundAddress                           = 1          if defined $addGroup or defined $addGroup1 or defined $addressName;
    }
    else {
      if ($fwInfo->{is_nat} eq '1' or $fwInfo->{is_nat} eq '2') {
        my ($privateIp, $realZone) = $searcher->createPrivateIp($ipaddr, $parser);
        $ipMap->{realIp}{$privateIp}{zone} = $realZone;
        $ipMap->{natIp}{$ipaddr}{zone}     = $fwInfo->{zone};
        my $addressName = $searcher->getAnAddressName($parser, $realZone, $privateIp);
        $ipMap->{realIp}{$privateIp}{name} = $addressName->[0] if defined $addressName;
        my $addGroup  = $self->searchAddressGroup($parser, $privateIp, $realZone);
        my $addGroup1 = $self->searchAddressGroup($parser, $ipaddr,    $fwInfo->{zone});
        $ipMap->{realIp}{$privateIp}{addressGroup} = $addGroup  if defined $addGroup;
        $ipMap->{natIp}{$ipaddr}{addressGroup}     = $addGroup1 if defined $addGroup1;
        $foundAddress                              = 1 if defined $addGroup or defined $addGroup1 or defined $addressName;
      }
      else {
        $ipMap->{realIp}{$ipaddr}{zone} = $fwInfo->{zone};
        my $addressName = $searcher->getAnAddressName($parser, $fwInfo->{zone}, $ipaddr);
        $ipMap->{realIp}{$ipaddr}{name} = $addressName->[0] if defined $addressName;
        my $addGroup = $self->searchAddressGroup($parser, $ipaddr, $fwInfo->{zone});
        $ipMap->{realIp}{$ipaddr}{addressGroup} = $addGroup if defined $addGroup;
        $foundAddress                           = 1         if defined $addGroup or defined $addressName;
      }
    }

    my $policys = $self->searchPolicy($ipMap, $parser, $srvMap);
    if (defined $srvMap) {
      if (@{$policys} > 0) {
        $result->{$fwInfo->{fwId}}{rule}    = $policys;
        $result->{$fwInfo->{fwId}}{address} = $ipMap if $foundAddress;
        $result->{$fwInfo->{fwId}}{fwName}  = $fwInfo->{fw_name};
        $result->{$fwInfo->{fwId}}{fwType}  = $fwInfo->{fw_type};
      }
    }
    else {
      $result->{$fwInfo->{fwId}}{address} = $ipMap             if $foundAddress;
      $result->{$fwInfo->{fwId}}{rule}    = $policys           if @{$policys} > 0;
      $result->{$fwInfo->{fwId}}{fwName}  = $fwInfo->{fw_name} if $foundAddress or @{$policys} > 0;
      $result->{$fwInfo->{fwId}}{fwType}  = $fwInfo->{fw_type} if $foundAddress or @{$policys} > 0;
    }
    delete $fwInfos->{"$unprotectedZone"}{$fwInfo->{fwId}};
  }

  #查找其它设备上的策略
  my $otherFwInfo = $fwInfos->{"$unprotectedZone"};
  my $ipaddress;
  if (defined $ipMap->{natIp}) {
    $ipaddress = (keys %{$ipMap->{natIp}})[0];
  }
  elsif (defined $ipMap->{realIp}) {
    $ipaddress = (keys %{$ipMap->{realIp}})[0];
    if (defined $ipMap->{realIp}{$ipaddress}{zoneType} and $ipMap->{realIp}{$ipaddress}{zoneType} eq 'private') {
      $ipaddress = undef;
    }
  }
  else {
    $ipaddress = $ipMap->{origin};
  }
  if (defined $ipaddress) {
    for my $fwId (keys %{$otherFwInfo}) {
      my $foundAddress = 0;
      my $fwInfo       = $otherFwInfo->{$fwId};
      my $parser       = Firewall::Config::Dao::Parser->new(dbi => $self->dbi)->loadParser($fwId);
      my $class        = ref($parser);
      my $searcher;
      eval("use $class;\$searcher = Firewall::Policy::Searcher::$fwInfo->new{fw_type};");
      confess $@ if $@;
      my $newIpMap;
      my @zones = keys %{$otherFwInfo->{$fwId}{zone}};
      my $zone;

      if (@zones == 1) {
        $zone = $zones[0];
      }
      elsif (@zones > 1) {
        $zone = $self->getZoneFromRoute($ipaddress, $parser, \@zones);
      }

      $newIpMap->{realIp}{$ipaddress}{zone} = $zone;
      my $addressName = $searcher->getAnAddressName($parser, $zone, $ipaddress);
      $newIpMap->{realIp}{$ipaddress}{name} = $addressName->[0] if defined $addressName;
      my $addGroup = $self->searchAddressGroup($parser, $ipaddress, $zone);
      $newIpMap->{realIp}{$ipaddress}{addressGroup} = $addGroup if defined $addGroup;
      $foundAddress                                 = 1         if defined $addressName or defined $addGroup;

      if ($fwInfo->{is_nat} eq '2' and $fwInfo->{fw_type} ne 'Srx') {
        my $zoneIndex = $fwInfos->{"$protectedZone"}{$fwId};
        for my $zone (keys %{$zoneIndex->{zone}}) {
          my $natIp = $searcher->createMainAddr($ipaddress, $zone, $parser, {'0.0.0.0/0' => undef}, 'dst');
          if (defined $natIp) {
            $newIpMap->{natIp}{$natIp}{zone} = $zone;
            my $addressName;
            $addressName = $searcher->getAnAddressName($parser, $zone, $natIp);
            my $addGroup;
            my $interface;
            $addGroup = $self->searchAddressGroup($parser, $natIp, $zone);
            if (not defined $addressName and $fwInfo->{fw_type} eq 'Netscreen') {
              $addressName = $searcher->getAnAddressName($parser, 'Global', $natIp);
              $addGroup    = $self->searchAddressGroup($parser, $natIp, 'Global');
              $interface   = (keys %{$parser->getZone($zone)->interfaces})[0];
            }
            $newIpMap->{natIp}{$natIp}{name}         = $addressName->[0] if defined $addressName;
            $newIpMap->{natIp}{$natIp}{addressGroup} = $addGroup         if defined $addGroup;
            $newIpMap->{natIp}{$natIp}{interface}    = $interface        if defined $interface;
            $foundAddress                            = 1                 if defined $addressName or defined $addGroup;
          }
        }
      }
      my $policys = $self->searchPolicy($newIpMap, $parser, $srvMap);
      if (defined $srvMap) {
        if (@{$policys} > 0) {
          $result->{$fwId}{rule}    = $policys;
          $result->{$fwId}{address} = $newIpMap if $foundAddress;
          $result->{$fwId}{fwName}  = $otherFwInfo->{$fwId}{fw_name};
          $result->{$fwId}{fwType}  = $otherFwInfo->{$fwId}{fw_type};
        }
      }
      else {
        $result->{$fwId}{address} = $newIpMap if $foundAddress;
        $result->{$fwId}{rule}    = $policys  if @{$policys} > 0;
        if ($foundAddress or @{$policys} > 0) {
          $result->{$fwId}{fwName} = $otherFwInfo->{$fwId}{fw_name};
          $result->{$fwId}{fwType} = $otherFwInfo->{$fwId}{fw_type};
        }
      }
    }
  }
  return $result;
}

sub searchAddressGroup {
  my ($self, $parser, $ipaddr, $zone) = @_;
  my ($ip, $mask) = split('/', $ipaddr);
  my $maskStr = Firewall::Utils::Ip->new->changeMaskToIpForm($mask);
  my $result;
  my $addressGroupIndex = $parser->elements->addressGroup;
  for my $addressGroup (values %{$addressGroupIndex}) {
    next if defined $addressGroup->{"zone"} and $addressGroup->{"zone"} ne $zone;
    my $addressMembers = $addressGroup->{addrGroupMembers};
    for my $address (values %{$addressMembers}) {
      if (defined $address->{ip}) {
        if ($address->{ip} eq $ip and ($address->{mask} eq $mask or $address->{mask} eq $maskStr)) {
          my $groupName = $addressGroup->{"addrGroupName"};
          $result->{$groupName} = {groupName => $addressGroup->{"addrGroupName"}, zone => $zone};
          last;
        }
      }
    }
  }
  return $result;
}

sub getNatZone {
  my ($self, $fwInfos, $fwInfo, $parser) = @_;
  my @zones = keys %{$fwInfos->{0}{$fwInfo->{fwId}}{zone}};
  if (@zones == 1) {
    return $zones[0];
  }
  else {
    return $self->getZoneFromRoute('10.0.0.0/8', $parser, \@zones);
  }
}

sub getZoneFromRoute {
  my ($self, $addr, $parser, $zoneArray) = @_;
  my ($ip, $mask) = split('/', $addr);
  my $addrSet = Firewall::Utils::Ip->new->getRangeFromIpMask($ip, $mask);
  my %zoneHash;
  for (@{$zoneArray}) {
    $zoneHash{$_} = undef;
  }
  for my $route (sort { $b->mask <=> $a->mask }
    grep { defined $_->zoneName and exists $zoneHash{$_->zoneName} } values %{$parser->elements->route})
  {
    if ($route->range->isContain($addrSet)) {
      return $route->zoneName;
    }
  }
}

sub searchFw {
  my ($self, $ipaddr, $fwInfos) = @_;
  my ($ip, $mask) = split('/', $ipaddr);
  $mask = 32 if not defined $mask;
  my $ipSet = Firewall::Utils::Ip->new->getRangeFromIpMask($ip, $mask);
  my @hitResult;
  for my $fwId (keys %{$fwInfos}) {
    my ($fwName, $isNat, $fwType) = @{$fwInfos->{$fwId}}{qw/ fw_name is_nat fw_type /};
    for my $zone (keys %{$fwInfos->{$fwId}{zone}}) {
      for my $zoneType (keys %{$fwInfos->{$fwId}{zone}{$zone}}) {
        if ($fwInfos->{$fwId}{zone}{$zone}{$zoneType}{range}->isContain($ipSet)) {
          push @hitResult,
            {fwId => $fwId, fw_name => $fwName, is_nat => $isNat, fw_type => $fwType, zone => $zone, zoneType => $zoneType};
        }
      }
    }
  }
  return \@hitResult;
}

sub getFwInfo {
  my $self   = shift;
  my $sql    = "select * from v_fw_network";
  my $result = $self->dbi->execute($sql)->all;
  my $fwInfo;
  for my $row (@{$result}) {
    my ($is_protected_zone, $fw_id, $zone, $zone_type, $addr_min, $addr_max, $fw_name, $is_nat, $fw_type, $manageIp)
      = @{$row}{qw/ is_protected_zone fw_id zone zone_type addr_min addr_max fw_name is_nat fw_type manage_ip /};
    if (not defined $fwInfo->{$is_protected_zone}{$fw_id}) {
      $fwInfo->{$is_protected_zone}{$fw_id}
        = {fw_name => "$fw_name($manageIp)", is_nat => $is_nat, fw_type => ucfirst lc $fw_type};
    }
    if (not defined $fwInfo->{$is_protected_zone}{$fw_id}{zone}{$zone}{$zone_type}) {
      $fwInfo->{$is_protected_zone}{$fw_id}{zone}{$zone}{$zone_type} = {range => Firewall::Utils::Set->new($addr_min, $addr_max)};
    }
    else {
      $fwInfo->{$is_protected_zone}{$fw_id}{zone}{$zone}{$zone_type}{range}->mergeToSet($addr_min, $addr_max);
    }
  }
  return $fwInfo;
}

sub searchPolicy {
  my ($self, $ipMap, $parser, $svrMap) = @_;
  my @rules;
  if (defined $ipMap->{realIp}) {
    for my $ip (keys %{$ipMap->{realIp}}) {
      if (not defined $svrMap) {
        @rules = (@rules, @{$self->_searchPolicy($ip, $parser)});
        if (defined $ipMap->{realIp}{$ip}{addressGroup}) {
          my $addressGroup = $ipMap->{realIp}{$ip}{addressGroup};
          for my $addGroupName (keys %{$addressGroup}) {
            @rules = (@rules, @{$self->searchGroupPolicy($addGroupName, $addressGroup->{$addGroupName}{zone}, $parser)});
          }
        }
      }
      else {
        @rules = (@rules, @{$self->_searchPolicy2($ip, $parser, $svrMap)});
      }
    }
  }
  if (defined $ipMap->{natIp}) {
    for my $ip (keys %{$ipMap->{natIp}}) {
      if (not defined $svrMap) {
        @rules = (@rules, @{$self->_searchPolicy($ip, $parser)});
        if (defined $ipMap->{natIp}{$ip}{addressGroup}) {
          my $addressGroup = $ipMap->{natIp}{$ip}{addressGroup};
          for my $addGroupName (keys %{$addressGroup}) {
            @rules = (@rules, @{$self->searchGroupPolicy($addGroupName, $addressGroup->{$addGroupName}{zone}, $parser)});
          }
        }
      }
      else {
        @rules = (@rules, @{$self->_searchPolicy2($ip, $parser, $svrMap)});
      }
    }
  }
  return \@rules;
}

sub searchGroupPolicy {
  my ($self, $addGroupName, $zone, $parser) = @_;
  my $rules = $parser->{elements}->{rule};
  my @result;
  for my $rule (values %{$rules}) {
    my $found = 0;
    for my $addMembers ($rule->{srcAddressGroup}{addrGroupMembers}, $rule->{dstAddressGroup}{addrGroupMembers}) {
      last if $found;
      for my $addressOrGroup (values %{$addMembers}) {
        if (defined $addressOrGroup->{addrGroupName}) {
          if ($addGroupName eq $addressOrGroup->{addrGroupName}
            and (defined $addressOrGroup->{zone} ? $addressOrGroup->{zone} eq $zone : 1))
          {
            $found = 1;
            my %ruleReport;
            $ruleReport{content}  = $rule->{content};
            $ruleReport{fromZone} = $rule->{fromZone};
            $ruleReport{toZone}   = $rule->{toZone};
            $ruleReport{ruleName} = $rule->{ruleName};
            $ruleReport{zone}     = $addressOrGroup->{zone};
            $ruleReport{addrName} = $addressOrGroup->{addrName};
            $ruleReport{policyId} = $rule->{policyId};
            push @result, \%ruleReport;
            last;
          }
        }
        else {
          next;
        }
      }
    }
  }
  return \@result;
}

sub _searchPolicy {
  my ($self, $ipaddr, $parser) = @_;
  my ($ip, $mask) = split('/', $ipaddr);
  my $maskStr = Firewall::Utils::Ip->new->changeMaskToIpForm($mask);
  my $rules   = $parser->{elements}->{rule};
  my @result;
  for my $rule (values %{$rules}) {
    my $found = 0;
    for my $addMembers ($rule->{srcAddressGroup}{addrGroupMembers}, $rule->{dstAddressGroup}{addrGroupMembers}) {
      last if $found;
      for my $addressOrGroup (values %{$addMembers}) {
        if (defined $addressOrGroup->{ip}) {
          if ($addressOrGroup->{ip} eq $ip and ($addressOrGroup->{mask} eq $maskStr or $addressOrGroup->{mask} eq $mask)) {
            $found = 1;
            my %ruleReport;
            my $memberCounter = (keys %{$addMembers});
            $ruleReport{content}       = $rule->{content};
            $ruleReport{fromZone}      = $rule->{fromZone};
            $ruleReport{toZone}        = $rule->{toZone};
            $ruleReport{ruleName}      = $rule->{ruleName};
            $ruleReport{zone}          = $addressOrGroup->{zone};
            $ruleReport{addrName}      = $addressOrGroup->{addrName};
            $ruleReport{policyId}      = $rule->{policyId};
            $ruleReport{memberCounter} = $memberCounter;
            push @result, \%ruleReport;
            last;
          }
        }
        else {
          next;
        }
      }
    }
  }
  return \@result;
}

sub _searchPolicy2 {
  my ($self, $ipaddr, $parser, $srvs) = @_;
  my ($ip, $mask) = split('/', $ipaddr);
  my $maskStr = Firewall::Utils::Ip->new->changeMaskToIpForm($mask);
  my $srvMap  = {map { $_ => undef } split(',', lc $srvs)};
  my %srvPortRange;

  for my $aSrv (keys %{$srvMap}) {
    my ($protocol, $port) = split('/', $aSrv);
    $protocol = lc $protocol;
    my $needCheckPort = ($protocol =~ /^(tcp|udp)$/io) ? 1 : 0;
    $srvPortRange{$protocol}{needCheckPort} = $needCheckPort;
    if ($needCheckPort) {
      $srvPortRange{portRange}{$protocol} = Firewall::Utils::Set->new if not defined $srvPortRange{portRange}{$protocol};
      my ($portMin, $portMax) = (defined $port and $port =~ /\-/) ? split(/\-/, $port, 2) : ($port, $port);
      $srvPortRange{portRange}{$protocol}->mergeToSet($portMin, $portMax);
      $srvPortRange{srvMember}{$aSrv}{$protocol}{portRange} = Firewall::Utils::Set->new($portMin, $portMax);
      $srvPortRange{srvMember}{$aSrv}{protocol}             = $protocol;
      $srvPortRange{srvMember}{$aSrv}{dstPort}              = "$portMin-$portMax";
    }
  }
  my $rules = $parser->{elements}->{rule};
  my @result;
  for my $rule (values %{$rules}) {
    my $found = 0;
    for my $addMembers ($rule->{dstAddressGroup}{addrGroupMembers}) {
      last if $found;
      for my $addressOrGroup (values %{$addMembers}) {
        if (defined $addressOrGroup->{ip}) {
          if ($addressOrGroup->{ip} eq $ip and ($addressOrGroup->{mask} eq $maskStr or $addressOrGroup->{mask} eq $mask)) {
            $found = 1;
            my $hitSrvReport = $self->findSrv(\%srvPortRange, $rule->{serviceGroup});
            my %ruleReport;
            if ($hitSrvReport->{srvContain} or defined $hitSrvReport->{hitSrv}) {
              my $memberCounter = (keys %{$addMembers});
              $ruleReport{content}       = $rule->{content};
              $ruleReport{fromZone}      = $rule->{fromZone};
              $ruleReport{toZone}        = $rule->{toZone};
              $ruleReport{ruleName}      = $rule->{ruleName};
              $ruleReport{zone}          = $addressOrGroup->{zone};
              $ruleReport{addrName}      = $addressOrGroup->{addrName};
              $ruleReport{policyId}      = $rule->{policyId};
              $ruleReport{memberCounter} = $memberCounter;
              $ruleReport{srvContain}    = $hitSrvReport->{srvContain};
              $ruleReport{hitSrv}        = $hitSrvReport->{hitSrv} if defined $hitSrvReport->{hitSrv};
              push @result, \%ruleReport;
            }
            last;
          }
        }
        else {
          next;
        }
      }
    }
  }
  return \@result;
}

sub findSrv {
  my ($self, $srvPort, $rulePort) = @_;
  my %srvreport;
  for my $protocol (keys %{$srvPort->{portRange}}) {
    if (defined $rulePort->{dstPortRangeMap}{$protocol}
      and $srvPort->{portRange}{$protocol}->isContain($rulePort->{dstPortRangeMap}{$protocol}))
    {
      $srvreport{srvContain} = 1;
    }
    else {
      $srvreport{srvContain} = 0;
      last;
    }
  }

  if (not $srvreport{srvContain}) {
    my $srvGroup = $rulePort->{srvGroupMembers};
    for my $ruleSrv (values %{$srvGroup}) {
      for my $protocol (keys %{$srvPort->{portRange}}) {
        if (defined $ruleSrv->{dstPortRangeMap}{$protocol}
          and $srvPort->{portRange}{$protocol}->isContain($ruleSrv->{dstPortRangeMap}{$protocol}))
        {
          push @{$srvreport{hitSrv}}, $ruleSrv->{srvName};

        }
      }
    }
  }
  return \%srvreport;
}

__PACKAGE__->meta->make_immutable;
1;
