## no critic: TestingAndDebugging::RequireStrict
package Sah::SchemaR::str_or_re;

our $DATE = '2022-06-08'; # DATE
our $VERSION = '0.005'; # VERSION

our $rschema = do{my$var={base=>"any",clsets_after_base=>[{description=>"\nIf string is of the form of `/.../`, then it will be parsed as a regex.\nCurrently modifiers `i`, `m`, and `s` after the second `/` are allowed.\n\nOtherwise, it's accepted as a plain string.\n\n",examples=>[{valid=>1,value=>""},{valid=>1,value=>"a"},{summary=>"Not a string",valid=>0,value=>{}},{valid=>1,validated_value=>qr(),value=>"//"},{summary=>"Becomes a string",valid=>1,value=>"/foo"},{valid=>1,validated_value=>qr(foo.*),value=>"/foo.*/"},{valid=>1,validated_value=>qr(foo)si,value=>"/foo/is"},{summary=>"Invalid regex",valid=>0,value=>"/foo[/"}],of=>[["str"],["re"]],prefilters=>["Str::maybe_convert_to_re"],summary=>"String or regex (if string is of the form `/.../`)"}],clsets_after_type=>['$var->{clsets_after_base}[0]'],"clsets_after_type.alt.merge.merged"=>['$var->{clsets_after_base}[0]'],resolve_path=>["any"],type=>"any",v=>2};$var->{clsets_after_type}[0]=$var->{clsets_after_base}[0];$var->{"clsets_after_type.alt.merge.merged"}[0]=$var->{clsets_after_base}[0];$var};

1;
# ABSTRACT: String or regex (if string is of the form `/.../`)

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::str_or_re - String or regex (if string is of the form `/.../`)

=head1 VERSION

This document describes version 0.005 of Sah::SchemaR::str_or_re (from Perl distribution Sah-Schemas-Str), released on 2022-06-08.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Str>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Str>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla plugin and/or Pod::Weaver::Plugin. Any additional steps required
beyond that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2022, 2020 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Str>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
