package App::ExifUtils;

our $DATE = '2018-06-21'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our %SPEC;

$SPEC{exifshow} = {
    v => 1.1,
    summary => 'Show EXIF information in a file',
    args => {
        filename => {
            schema => 'filename*', # XXX filename*?
            pos => 0,
            req => 1,
        },
    },
};
sub exifshow {
    require Image::ExifTool;

    my %args = @_;
    my $filename = $args{filename};

    return [404, "No such file '$filename'"] unless -f $filename;
    my $info = Image::ExifTool::ImageInfo($filename);
    [200, "OK", $info];
}

1;
# ABSTRACT: Utilities related to EXIF

__END__

=pod

=encoding UTF-8

=head1 NAME

App::ExifUtils - Utilities related to EXIF

=head1 VERSION

This document describes version 0.001 of App::ExifUtils (from Perl distribution App-ExifUtils), released on 2018-06-21.

=head1 DESCRIPTION

This distributions provides the following command-line utilities:

=over

=item * L<exifshow>

=back

=head1 FUNCTIONS


=head2 exifshow

Usage:

 exifshow(%args) -> [status, msg, result, meta]

Show EXIF information in a file.

This function is not exported.

Arguments ('*' denotes required arguments):

=over 4

=item * B<filename>* => I<filename>

=back

Returns an enveloped result (an array).

First element (status) is an integer containing HTTP status code
(200 means OK, 4xx caller error, 5xx function error). Second element
(msg) is a string containing error message, or 'OK' if status is
200. Third element (result) is optional, the actual result. Fourth
element (meta) is called result metadata and is optional, a hash
that contains extra information.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-ExifUtils>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-ExifUtils>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-ExifUtils>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
