package Acme::CPANAuthors::CPAN::Streaks::MonthlyDistributions::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-12-11'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20231211.0'; # VERSION

use Acme::CPANAuthors::Register (
    'PERLANCAR' => '',
    'SKIM' => '',
    'TIMLEGGE' => '',
    'LEONT' => '',
    'DART' => '',
    'JJATRIA' => '',
    'PRBRENAN' => '',
    'SANKO' => '',
    'JGOMEZ' => '',
    'KIMOTO' => '',
    'MIKKOI' => '',
    'BIGFOOT' => '',
    'CARELINE' => '',
    'DAVIDRAAB' => '',
    'DCHURCH' => '',
    'DERF' => '',
    'DTUCKWELL' => '',
    'EINHVERFR' => '',
    'GENE' => '',
    'HMBRAND' => '',
    'ISHIGAKI' => '',
    'JOYREX' => '',
    'LANCEW' => '',
    'LEEJO' => '',
    'LICHTKIND' => '',
    'RAWLEYFOW' => '',
    'RBAIRWELL' => '',
    'RRWO' => '',
    'SIMCOP' => '',
    'SVW' => '',
    'TROTH' => '',
    'VVELOX' => '',
    'WHOM' => '',
    'YANICK' => '',
    'ZMUGHAL' => '',
    'AAHAZRED' => '',
    'ABALAMA' => '',
    'ABH' => '',
    'CGPAN' => '',
    'DJERIUS' => '',
    'EMUNDALL' => '',
    'ETHER' => '',
    'GBROWN' => '',
    'KRAIH' => '',
    'MAUKE' => '',
    'PACMAN' => '',
    'TEODESIAN' => '',
);


1;
# ABSTRACT: Authors with ongoing monthly distributions streak (release a new [for them] distribution every month)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::MonthlyDistributions::Current - Authors with ongoing monthly distributions streak (release a new [for them] distribution every month)

=head1 VERSION

This document describes version 20231211.0 of Acme::CPANAuthors::CPAN::Streaks::MonthlyDistributions::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2023-12-11.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2023-12-11, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | PERLANCAR | 113 | 2014-08    | ongoing     |
  | SKIM      |  10 | 2023-03    | ongoing     |
  | TIMLEGGE  |   6 | 2023-06    | might-break |
  | LEONT     |   5 | 2023-07    | might-break |
  | DART      |   3 | 2023-09    | might-break |
  | JJATRIA   |   3 | 2023-10    | ongoing     |
  | PRBRENAN  |   2 | 2023-10    | might-break |
  | SANKO     |   2 | 2023-10    | might-break |
  | JGOMEZ    |   2 | 2023-11    | ongoing     |
  | KIMOTO    |   2 | 2023-11    | ongoing     |
  | MIKKOI    |   2 | 2023-11    | ongoing     |
  | BIGFOOT   |   1 | 2023-11    | might-break |
  | CARELINE  |   1 | 2023-11    | might-break |
  | DAVIDRAAB |   1 | 2023-11    | might-break |
  | DCHURCH   |   1 | 2023-11    | might-break |
  | DERF      |   1 | 2023-11    | might-break |
  | DTUCKWELL |   1 | 2023-11    | might-break |
  | EINHVERFR |   1 | 2023-11    | might-break |
  | GENE      |   1 | 2023-11    | might-break |
  | HMBRAND   |   1 | 2023-11    | might-break |
  | ISHIGAKI  |   1 | 2023-11    | might-break |
  | JOYREX    |   1 | 2023-11    | might-break |
  | LANCEW    |   1 | 2023-11    | might-break |
  | LEEJO     |   1 | 2023-11    | might-break |
  | LICHTKIND |   1 | 2023-11    | might-break |
  | RAWLEYFOW |   1 | 2023-11    | might-break |
  | RBAIRWELL |   1 | 2023-11    | might-break |
  | RRWO      |   1 | 2023-11    | might-break |
  | SIMCOP    |   1 | 2023-11    | might-break |
  | SVW       |   1 | 2023-11    | might-break |
  | TROTH     |   1 | 2023-11    | might-break |
  | VVELOX    |   1 | 2023-11    | might-break |
  | WHOM      |   1 | 2023-11    | might-break |
  | YANICK    |   1 | 2023-11    | might-break |
  | ZMUGHAL   |   1 | 2023-11    | might-break |
  | AAHAZRED  |   1 | 2023-12    | ongoing     |
  | ABALAMA   |   1 | 2023-12    | ongoing     |
  | ABH       |   1 | 2023-12    | ongoing     |
  | CGPAN     |   1 | 2023-12    | ongoing     |
  | DJERIUS   |   1 | 2023-12    | ongoing     |
  | EMUNDALL  |   1 | 2023-12    | ongoing     |
  | ETHER     |   1 | 2023-12    | ongoing     |
  | GBROWN    |   1 | 2023-12    | ongoing     |
  | KRAIH     |   1 | 2023-12    | ongoing     |
  | MAUKE     |   1 | 2023-12    | ongoing     |
  | PACMAN    |   1 | 2023-12    | ongoing     |
  | TEODESIAN |   1 | 2023-12    | ongoing     |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
