package Sah::SchemaR::date::month::en;

our $DATE = '2021-08-04'; # DATE
our $VERSION = '0.016'; # VERSION

our $rschema = do{my$var={base=>"cistr",clsets_after_base=>[{description=>"\nNote that name is not coerced to number; use\n<pm:Sah::Schema::date::month_num::id> for that.\n\nSee also related schemas for other locales, e.g.\n<pm:Sah::Schema::date::month::id> (Indonesian),\n<pm:Sah::Schema::date::month::en_or_id> (English/Indonesian), etc.\n\n",examples=>[{summary=>"Empty string",valid=>0,value=>""},{valid=>1,value=>1},{valid=>1,value=>"jan"},{valid=>1,value=>"FeB"},{valid=>1,value=>"March"},{summary=>"Not a month name/number",valid=>0,value=>"foo"},{summary=>"Number not in 1-12",valid=>0,value=>13}],in=>[1,2,3,4,5,6,7,8,9,10,11,12,"jan","feb","mar","apr","may","jun","jul","aug","sep","oct","nov","dec","january","february","march","april","june","july","august","september","october","november","december"],summary=>"Month number/name (abbreviated or full, in English)"}],clsets_after_type=>['$var->{clsets_after_base}[0]'],"clsets_after_type.alt.merge.merged"=>['$var->{clsets_after_base}[0]'],resolve_path=>["cistr"],type=>"cistr",v=>2};$var->{clsets_after_type}[0]=$var->{clsets_after_base}[0];$var->{"clsets_after_type.alt.merge.merged"}[0]=$var->{clsets_after_base}[0];$var};

1;
# ABSTRACT: Month number/name (abbreviated or full, in English)

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::date::month::en - Month number/name (abbreviated or full, in English)

=head1 VERSION

This document describes version 0.016 of Sah::SchemaR::date::month::en (from Perl distribution Sah-Schemas-Date), released on 2021-08-04.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Date>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Date>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Date>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021, 2020, 2019 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
