package Sah::Manual::Reference::Schema::PropertyAttributeIndex; # just to make podweaver happy

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2021-07-28'; # DATE
our $DIST = 'Sah-Manual'; # DIST
our $VERSION = '0.001'; # VERSION

1;
# ABSTRACT: Alphabetical list of properties/attributes used in a Sah schema's clause set.

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::Manual::Reference::Schema::PropertyAttributeIndex - Alphabetical list of properties/attributes used in a Sah schema's clause set.

=head1 VERSION

This document describes version 0.001 of Sah::Manual::Reference::Schema::PropertyAttributeIndex (from Perl distribution Sah-Manual), released on 2021-07-28.

=head1 DESCRIPTION

A Sah schema's clause set is a L<DefHash>. A Sah clause is written as a DefHash
property. This index does not include most of the clauses; see L<Sah::Types> for
that.

=head1 INDEX

=head2 default

L<Sah> standard.

=head2 description

From L<DefHash>.

=head2 examples

Array. List of examples, where each example is either a non-hash data or a
defhash containing example specification. Observed by
L<Pod::Weaver::Plugin::Sah::Schemas>.

See also: L<Sah::Manual::Reference::Schema::Examples::PropertyAttributeIndex>.

=head2 summary

From L<DefHash>.

=head2 tags

From L<DefHash>.

=head2 x.completion

str | [str => hash].

Specify which C<Perinci::Sub::XCompletion::*> module (without the prefix)
should handle the completion for this schema. Observed by
L<Perinci::Sub::Complete>.

=head2 x.data.sah.inline

2021-07-28.

Bool. Default false. Observed by L<Data::Sah>. When generating validator code,
whether this schema should be "inlined". Short schemas e.g.
L<uint|Sah::Schema::uint> are usually appropriate to enable this.

=head2 x.element_completion

Like L</x.completion>, but applies to element of this array schema.

Observed by L<Perinci::Sub::Complete>.

=head2 x.perl.coerce_rules

Specify the coercion rules. Observed by L<Data::Sah::Coerce>.

=head1 INDEX (DEPRECATED)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Manual>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Manual>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Manual>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

Other C<Sah::Manual::Reference::**::PropertyAttributeIndex> pages.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
