package App::BPOMUtils::Table::FoodIngredient;

use 5.010001;
use strict 'subs', 'vars';
use utf8;
use warnings;
use Log::ger;

use Exporter 'import';
use Perinci::Sub::Gen::AccessTable qw(gen_read_table_func);

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-02-13'; # DATE
our $DIST = 'App-BPOMUtils-Table-FoodIngredient'; # DIST
our $VERSION = '0.017'; # VERSION

our @EXPORT_OK = qw(
                       bpom_list_food_ingredients
               );

our %SPEC;

# BEGIN FRAGMENT id=meta-idn_bpom_bahan_baku_pangan varname=meta_idn_bpom_bahan_baku_pangan
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_bahan_baku_pangan/meta.yaml
# src-revision: ee31160a5cacaff81583d27f8c688d7a6ea681c0 (Mon Oct 31 18:06:17 2022 +0700)
# generate-date: Fri Jan 20 09:03:11 2023 UTC
# generated-by: update-fragments-in-perl-module
our $meta_idn_bpom_bahan_baku_pangan = {
  "fields" => {
    country_of_origin => {
      "filterable_regex" => "Yes",
      "pos" => 4,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Country of origin",
      "summary.alt.lang.id" => "Negara asal",
      "unique" => "No",
    },
    id => {
      "pos" => 0,
      "schema" => "uint*",
      "sortable" => "Yes",
      "summary" => "ID",
      "summary.alt.lang.id" => "ID",
      "unique" => "Yes",
    },
    is_herbal => {
      "filterable_regex" => "No",
      "pos" => 5,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Herbal?",
      "summary.alt.lang.id" => "Herbal?",
      "unique" => "No",
    },
    name => {
      "filterable_regex" => "Yes",
      "pos" => 1,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Name of ingredient",
      "summary.alt.lang.id" => "Nama bahan",
      "unique" => "No",
    },
    origin => {
      "filterable_regex" => "Yes",
      "pos" => 3,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Origin",
      "summary.alt.lang.id" => "Asal bahan",
      "unique" => "No",
    },
    status => {
      "filterable_regex" => "No",
      "pos" => 6,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Status",
      "summary.alt.lang.id" => "Status",
      "unique" => "No",
    },
    type => {
      "filterable_regex" => "Yes",
      "pos" => 2,
      "schema" => "str*",
      "sortable" => "Yes",
      "summary" => "Type of ingredient",
      "summary.alt.lang.id" => "Jenis bahan",
      "unique" => "No",
    },
  },
  "pk" => "id",
  "summary" => "Ingredients in BPOM processed food division",
  "summary.alt.lang.id_ID" => "Bahan baku di BPOM pangan olahan",
};
# END FRAGMENT id=meta-idn_bpom_bahan_baku_pangan

# BEGIN FRAGMENT id=data-idn_bpom_bahan_baku_pangan varname=data_idn_bpom_bahan_baku_pangan
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_bahan_baku_pangan/data.csv
# src-revision: ee31160a5cacaff81583d27f8c688d7a6ea681c0 (Mon Oct 31 18:06:17 2022 +0700)
# generate-date: Fri Jan 20 09:03:11 2023 UTC
# generated-by: update-fragments-in-perl-module
our $data_idn_bpom_bahan_baku_pangan = [
  [
    1,
    "Bubuk Sayuran (tomat, wortel, sawi, kentang, paprika hijau, bawang putih, seledri)",
    "",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [2, "Bubuk Teh Hijau", "", "NO", "NO", "NO", "NO"],
  [
    3,
    "Bubuk Ayam (maltodextrin, garam, bubuk kaldu ayam)",
    "",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [4, "Bubuk Buih", "", "NO", "NO", "NO", "NO"],
  [
    5,
    "Bubuk Custard (Susu Bubuk, Gula, Lemak Nabati, Pati Tapioka, Maltodekstrin)",
    "",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [6, "Bubuk Ekstrak Pizza ", "", "NO", "NO", "NO", "NO"],
  [
    7,
    "Bubuk Ekstrak Tulang Sapi (Ekstrack tulang sapi, Garam)",
    "",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [8, "Bubuk jahe", "", "NO", "NO", "NO", "NO"],
  [
    9,
    "Bubuk kecap (kedelai, garam, tepung)",
    "",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [10, "Bubuk Kelapa", "", "NO", "NO", "NO", "NO"],
  [11, "Bubuk lada putih ", "", "NO", "NO", "NO", "NO"],
  [12, "Bumbu Rasa Kacang Polong", "", "NO", "NO", "NO", "NO"],
  [13, "Bumbu Rasa Salmon Teriyaki", "", "NO", "NO", "NO", "NO"],
  [14, "Cabe Merah ", "", "NO", "NO", "NO", "NO"],
  [15, "CO2", "", "NO", "NO", "NO", "NO"],
  [
    16,
    "Dinatrium 5 Inosinat (disodium 5 Inosinate)",
    "",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    17,
    "Dinatrium 5 ribonukleotida (Disodium 5 ribonucleotides)",
    "",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [18, "Ekstrak Cumi-cumi", "", "NO", "NO", "NO", "NO"],
  [19, "Iodium ( Kalium Iodat- Kio3 )", "", "NO", "NO", "NO", "NO"],
  [20, "ekstrak vanillin", "", "NO", "NO", "NO", "NO"],
  [21, "bunga jagung", "", "NO", "NO", "NO", "NO"],
  [22, "Butiran Coklat", "", "NO", "NO", "NO", "NO"],
  [23, "Cabe Chilli Hijau ", "", "NO", "NO", "NO", "NO"],
  [24, "Cabe Hijau ", "", "NO", "NO", "NO", "NO"],
  [25, "Cabe Jalapeno ", "", "NO", "NO", "NO", "NO"],
  [26, "Dextrosa", "", "NO", "NO", "NO", "NO"],
  [27, "Kalium Fosfat ", "", "NO", "NO", "NO", "NO"],
  [
    28,
    "Ekstrak Bumbu (bawang bombay,bawang putih, paprika dan annato)",
    "",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [29, "Dekstrosa monohidrat", "", "NO", "NO", "NO", "NO"],
  [30, "Karagenan", "", "NO", "NO", "NO", "NO"],
  [31, "Karamel ", "", "NO", "NO", "NO", "NO"],
  [
    32,
    "Keju Ricotta (susu sapi, susu domba)",
    "",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [33, "Konsentrat Jus Apel", "", "NO", "NO", "NO", "NO"],
  [34, "Kayu Manis Bubuk", "", "NO", "NO", "NO", "NO"],
  [35, "Keju Bubuk ", "", "NO", "NO", "NO", "NO"],
  [36, "Konsentrat Buah Apel", "", "NO", "NO", "NO", "NO"],
  [37, "KARBONDIOKSIDA (CARBONDIOXIDE)", "", "NO", "NO", "NO", "NO"],
  [38, "Konyaku Bubuk", "", "NO", "NO", "NO", "NO"],
  [39, "Kopi Putih Bubuk", "", "NO", "NO", "NO", "NO"],
  [40, "Krim Nabati Bubuk", "", "NO", "NO", "NO", "NO"],
  [41, "Krimer", "", "NO", "NO", "NO", "NO"],
  [42, "Krimer Nabati", "", "NO", "NO", "NO", "NO"],
  [43, "Kubis ", "", "NO", "NO", "NO", "NO"],
  [
    44,
    "Lemak Nabati tidak hidrogenasi (Unhydrogenated Vegetable Fat)",
    "",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [45, "Mentega ", "", "NO", "NO", "NO", "NO"],
  [46, "Krispi ", "", "NO", "NO", "NO", "NO"],
  [47, "Keju ", "", "NO", "NO", "NO", "NO"],
  [48, "Lada Hitam", "", "NO", "NO", "NO", "NO"],
  [49, "Laktosa", "", "NO", "NO", "NO", "NO"],
  [50, "Maltodekstrin", "", "NO", "NO", "NO", "NO"],
  [51, "Lada Jalapeno", "", "NO", "NO", "NO", "NO"],
  [52, "Lemak Kakao ", "", "NO", "NO", "NO", "NO"],
  [
    53,
    "LEMAK NABATI (MARGARIN DAN LEMAK REROTI)",
    "",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [54, "Massa Kakao", "", "NO", "NO", "NO", "NO"],
  [55, "Minyak Nabati ", "", "NO", "NO", "NO", "NO"],
  [56, "Minyak Kedelai", "", "NO", "NO", "NO", "NO"],
  [57, "Minyak Sawit Olein", "", "NO", "NO", "NO", "NO"],
  [
    58,
    "Mono Dan Digliserida (mono- And Di-glycerides)",
    "",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [59, "Monogliserida (monoglycerides)", "", "NO", "NO", "NO", "NO"],
  [
    60,
    "NATRIUM TRIPOLIFOSFAT (SODIUM TRIPOLYPHOSPHATE)",
    "",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [61, "minyak vanila", "", "NO", "NO", "NO", "NO"],
  [
    62,
    "NATRIUM KARBOKSIMETIL SELULOSA (SODIUM CARBOXYMETHYL CELLULOSE)",
    "",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    63,
    "NATRIUM KARBONAT (SODIUM CARBONATE)",
    "",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [64, "Parutan Kelapa Kering", "", "NO", "NO", "NO", "NO"],
  [65, "Pasta Kopi", "", "NO", "NO", "NO", "NO"],
  [66, "pektin", "", "NO", "NO", "NO", "NO"],
  [67, "Pizza Bubuk Ekstrak", "", "NO", "NO", "NO", "NO"],
  [68, "Protein Nabati Terhidrolisa", "", "NO", "NO", "NO", "NO"],
  [69, "protein nabati terhirolisa", "", "NO", "NO", "NO", "NO"],
  [70, "Protein nabati tertekstur", "", "NO", "NO", "NO", "NO"],
  [71, "Riboflavin (vitamin B2)", "", "NO", "NO", "NO", "NO"],
  [
    72,
    "Sayuran kering (Kubis, protein nabati tertekstur, bawang putih goreng, wortel)",
    "",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [73, "Ragi Roti", "", "NO", "NO", "NO", "NO"],
  [74, "minyak mentega", "", "NO", "NO", "NO", "NO"],
  [75, "Pati terModifikasi", "", "NO", "NO", "NO", "NO"],
  [76, "Seng", "", "NO", "NO", "NO", "NO"],
  [77, "PATI TAPIOKA ", "", "NO", "NO", "NO", "YES"],
  [78, "Serat Pangan", "", "NO", "NO", "NO", "NO"],
  [79, "Sirup Glukosa", "", "NO", "NO", "NO", "NO"],
  [80, "Serbu Sari Buah Raspberi", "", "NO", "NO", "NO", "NO"],
  [81, "Teh Bubuk", "", "NO", "NO", "NO", "NO"],
  [82, "Telur", "", "NO", "NO", "NO", "NO"],
  [83, "Tepung Beras", "", "NO", "NO", "NO", "NO"],
  [84, "Tepung Gandum Semolina ", "", "NO", "NO", "NO", "NO"],
  [85, "Thixogums", "", "NO", "NO", "NO", "NO"],
  [86, "Tartazine (cl.19140)", "", "NO", "NO", "NO", "NO"],
  [87, "tapioka ", "", "NO", "NO", "NO", "NO"],
  [88, "Tepung Maizena", "", "NO", "NO", "NO", "NO"],
  [89, "Tepung mazena", "", "NO", "NO", "NO", "NO"],
  [90, "Tepung Rumput laut", "", "NO", "NO", "NO", "NO"],
  [
    91,
    "Tepung Rye (Rye Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    92,
    "Tepung Sagu (Sago Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    93,
    "Tepung Semolina (Semolina Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    94,
    "Tepung Singkong (Cassava Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    95,
    "Tepung Sorgum (Sorghum Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    96,
    "Tepung Spelt (Spelt flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    97,
    "Tepung Talas (Taro Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [98, "TEPUNG TAPIOKA", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [99, "TEPUNG TELUR", "Bahan Baku", "NO", "YES", "NO", "YES"],
  [
    100,
    "Tepung Tempura (Tempura Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    101,
    "TEPUNG TERIGU (WHEAT FLOUR)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    102,
    "Tepung Terigu Diperkaya (Enriched Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    103,
    "Tepung Terigu Protein Rendah (Low Protein Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    104,
    "Tepung Terigu Protein Sedang (Cake Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    105,
    "Tepung Terigu Protein Tinggi (High Protein Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    106,
    "TEPUNG TERIGU SEMOLINA (SEMOLINA FLOUR)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    107,
    "Tepung Terigu Terfermentasi (Fermented Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    108,
    "TEPUNG UBI (CASSAVA FLOUR)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    109,
    "Tepung Ubi Jalar (Sweet Potato Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    110,
    "Tepung Ubi Jalar Ungu (Violet Sweet Potato Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [111, "Tequila (Tequilla)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    112,
    "Terasi - Belacan (Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    113,
    "Terasi - Belacan Udang (Shrimp Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    114,
    "Terasi Bubuk (Shrimp Paste Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    115,
    "TERIPANG LAUT (SEA CUCUMBERS - HOLOTHUROIDEA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [116, "Terong (Eggplant)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    117,
    "TETES TEBU (MOLASES, TREACLE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [118, "THIAMIN MONONITRAT", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    119,
    "Tepung Muffin (Muffin Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    120,
    "Tepung Olahan / Pati Olahan / Protein Olahan",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    121,
    "Tepung Panir (Panir Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    122,
    "Tepung Premiks (Premix Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    123,
    "Tepung Premiks Es Krim (Ice Cream Base)",
    "Bahan Baku",
    "YES",
    "YES",
    "NO",
    "YES",
  ],
  [
    124,
    "Tepung Quinoa (Quinoa Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    125,
    "Tepung Roti (Bread Crumb)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    126,
    "Tepung Roti (Bread Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    127,
    "Tepung Malt (Malt Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    128,
    "Tarako Bubuk (Tarako Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [129, "TAUCO (TAUCO)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [130, "TAURIN (TAURINE)", "Bahan Baku", "NO", "NO", "YES", "YES"],
  [131, "Tebu", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [132, "Tebu (Cane)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [133, "TEH (TEA)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    134,
    "TIAMIN MONONITRAT (VIT B1)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    135,
    "TIMI (THYME - THYMUS VULGARIS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    136,
    "TIMI BUBUK (THYME - THYMUS VULGARIS POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    137,
    "Tinta Cumi (Squid Ink)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [138, "Tiram (Oyster)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [139, "Tiramisu (Tiramisu)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [140, "Tirosin (Thyrosin)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [141, "TOFFEE", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [142, "Tomat (Tomato)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    143,
    "Tomat Bubuk (Tomato Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    144,
    "Tomat Cincang (Chopped Tomato)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    145,
    "Tomat Hijau (Green Tomato)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    146,
    "Tomat Kering (Dried Tomato)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    147,
    "Tomat Kupas (Peeled Tomato)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    148,
    "TONGKAT ALI BUBUK (EURYCOMA LONGIFOLIA POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [149, "TOPPING", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    150,
    "Torbangun (Mexican mint)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    151,
    "TREHALOSA (TREHALOSE DIHYDRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [152, "TREONIN (THREONINE)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [153, "TRIBULUS", "Bahan Baku", "NO", "NO", "YES", "NO"],
  [
    154,
    "Trikalium fosfat (Tripotassium orthophosphate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    155,
    "trikalium sitrat (tripotassium citrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    156,
    "Trikalium Sitrat Monohidrat (Tripotassium Citrate Monohydrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    157,
    "Trikalsium Fosfat (Tricalcium Phosphate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    158,
    "trikalsium sitrat (Tricalcium citrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    159,
    "Trimagnesium sitrat anhidrat (Trimagnesium Citrate Anhydrous)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    160,
    "TRINATRIUM FOSFAT (TRISODIUM ORTHOPHOSPHATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    161,
    "TRINATRIUM FOSFAT (TRISODIUM OTRHOPHOSPHATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    162,
    "TRINATRIUM SITRAT (TRISODIUM CITRATE) (KECUALI MP ASI)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    163,
    "Triptofan (Triptophan)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [164, "Triticale", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [165, "Truffle (Truffle)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    166,
    "Tulang Ayam (Chicken Bone)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    167,
    "Tulang Babi (Pig Bone)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    168,
    "Tulang Ikan Salmon (Salmon Bone)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    169,
    "Tulang Muda Ikan Hiu Bubuk (Cartilage Shark Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    170,
    "Tulang Sapi (Cow's Bone)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    171,
    "Tuna Bubuk (Tuna Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    172,
    "TVP (Texturized Vegetable Protein)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    173,
    "UBI JALAR (SWEET POTATO)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    174,
    "Ubi Jepang (Japanese Yam)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [175, "UBI KAYU (CASSAVA)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    176,
    "UBI MADU (SWEET HONEY POTATO)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [177, "Ubi Merah ", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [178, "UBI RAMBAT (YAM)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    179,
    "UBI UNGU (PURPLE SWEET POTATO)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    180,
    "Ubur-Ubur (Jellyfish)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    181,
    "Udang Bubuk (Shrimp Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [182, "UDANG (FRESH PRAWN)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [183, "Udang (Shrimp)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    184,
    "Udang Kering - Ebi (Dried Shrimp)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    185,
    "Udang Rebon (Shrimp Rebon)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    186,
    "UMBI KONNYAKU (KONJAC)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [187, "Usus Ayam", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [188, "Usus Babi", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [189, "Usus Kambing", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    190,
    "Usus Sapi (Cow Intestines)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    191,
    "UVA URSI POWDER (ARCTISTAPHYLOS UVA URSI)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "NO",
  ],
  [192, "Valin", "Bahan Baku", "YES", "YES", "NO", "YES"],
  [193, "VANILA", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [194, "VANILIN", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [195, "Vitamin A (Retinal)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [196, "VITAMIN A ASETAT", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [197, "Vitamin A Palmitat", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [198, "VITAMIN B", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    199,
    "Vitamin B1 (Thiamine)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [200, "VITAMIN B10", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    201,
    "Vitamin B12 (Cyanocobalamin)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    202,
    "Vitamin B2 (Riboflavin)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    203,
    "VITAMIN B3 (NIACINAMIDE)(NICOTINAMIDE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    204,
    "Vitamin B5 (Pantothenic Acid)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    205,
    "Vitamin B6 (Pyridoxine Hydrochloride)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [206, "Vitamin B7 (Biotin)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    207,
    "VITAMIN B8 (INOSITOL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    208,
    "Vitamin B9 (Folic Acid)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    209,
    "Vitamin C (Ascorbic Acid)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [210, "VITAMIN D ", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [211, "VITAMIN D1", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    212,
    "Vitamin D2 (Ergocalciferol)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    213,
    "Vitamin D3 (Cholecalciferol)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    214,
    "Vitamin E (Tocopherol)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [215, "VITAMIN E ASETAT", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [216, "VITAMIN H (BIOTIN)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [217, "VITAMIN K", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    218,
    "Vitamin K1 (Phytomenadione)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    219,
    "VITAMIN K2 (MENAQUINONE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [220, "Vodka (Vodka)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [221, "WAFER", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [222, "WAFER CONE", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [223, "Wakame (Wakame)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [224, "WALNUT (WALNUT)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [225, "Wasabi (Wasabi)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    226,
    "Wasabi Bubuk (Wasabi Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [227, "WATER CHESNUT", "Bahan Baku", "YES", "YES", "NO", "YES"],
  [228, "WAX (WAX)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [229, "Waxberry (Waxberry)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    230,
    "Wheat grass (Triticum aestirum)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [231, "Whey (Whey)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    232,
    "Whey Bubuk (Whey Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    233,
    "Whey Demineralisasi (Whey Demineralization)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    234,
    "Whey Protein (Whey Protein)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    235,
    "Whey Protein Demineralisasi (Whey Protein Demineralization)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    236,
    "Whey Protein Konsentrat (Whey Protein Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    237,
    "Whipping Cream (Whipping Cream)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [238, "Wijen (Sesame)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    239,
    "Wijen Bubuk (Sesame Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    240,
    "Wijen Hitam (Black Sesame)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    241,
    "Wijen Putih (White Sesame)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [242, "WISKI (WHISKY)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [243, "Wortel (Carrot)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    244,
    "Wortel Bubuk (Carrot Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    245,
    "Wortel Kering (Dried Carrot)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    246,
    "Yerbamate Ekstrak (Ilex paraguariensis)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [247, "Yoghurt (Yoghurt)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    248,
    "Yoghurt Bubuk (Yoghurt Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [249, "ZAT BESI (IRON)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [250, "ZEASANTIN", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    251,
    "Zink Glukonat (Zinc Gluconate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    252,
    "Zink Laktat Dihidrat (Zink Lactate Dihydrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    253,
    "Zink Oksida (Zinc Oxide)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    254,
    "Zink Pikolinat (Zinc Picolinate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    255,
    "zink Sitrat Dihidrat (Zink Citrate Dihydrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    256,
    "Zink Sulfat (Zinc Sulphate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    257,
    "Tepung Gandum Semolina (Semolina Wheat Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    258,
    "Tepung Gandum Utuh (Whole Wheat Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    259,
    "Tepung Gaplek (Cassava Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    260,
    "Tepung Gluten (Gluten Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [261, "Tepung Iles-Iles", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    262,
    "Tepung Jagung (Corn Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    263,
    "Tepung Jagung Modifikasi (Modified Corn Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    264,
    "Tepung Jagung Ungu (Purple Corn Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    265,
    "Tepung Jamur (Mushroom Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    266,
    "Tepung Kacang (Peanut Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    267,
    "TEPUNG KACANG ARAB - TEPUNG GARBANZO (CHICKPEA - GARBANZO FLOUR)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    268,
    "Tepung Kacang Chena (Chena Bean Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    269,
    "Tepung Kacang Hijau (Mungbean Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    270,
    "Tepung Kacang Kedelai (Soybean Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    271,
    "Tepung Kacang Koro (Broad Bean Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    272,
    "Tepung Kacang Merah (Red Bean Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    273,
    "Tepung Kacang Mete (Cashew Nut Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    274,
    "Tepung Kacang Polong (Pea Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [275, "TEPUNG KAMUT", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    276,
    "Tepung Kanji (Starch)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    277,
    "TEPUNG KEDELAI (SOY FLOUR)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    278,
    "Tepung Kelapa (Coconut Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    279,
    "Tepung Kencur (Kaempferia galanga Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    280,
    "Tepung Kentang (Potato Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    281,
    "Tepung Kerang (Shell Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    282,
    "TEPUNG KETAN (GLUTINOUS RICE FLOUR)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    283,
    "Tepung Ketan Hitam (Black Glutinous Rice Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    284,
    "Tepung Ketan Putih (White Glutinous Rice Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [285, "TEPUNG KONJAC", "Bahan Baku", "YES", "NO", "NO", "NO"],
  [
    286,
    "TEPUNG KONNYAKU (KONJAC FLOUR)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    287,
    "TEPUNG KONYAKU (KONYAKU FLOUR)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    288,
    "Tepung Kue (Cake Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    289,
    "Tepung Lobak (Rapeseed Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    290,
    "Tepung Beras (Rice Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    291,
    "Tepung Beras Cokelat (Brown Rice Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [292, "Tepung Beras Hitam", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    293,
    "Tepung Beras Ketan (Glutinous Rice Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    294,
    "Tepung Beras Merah (Brown Rice Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    295,
    "Tepung Biji Rami (Flaxseed Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    296,
    "Tepung Bran Gandum (Wheat Bran Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [297, "Tepung Breader", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    298,
    "Tepung Buckwheat (Buckwheat Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    299,
    "Tepung Bumbu (Seasoning Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    300,
    "Tepung Bumbu Ayam Goreng (Fried Chicken Seasoning Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    301,
    "TEPUNG DHAL (HUSKED DEW GRAM FLOUR)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [302, "TEPUNG DURUM ", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    303,
    "Tepung Gandum (Wheat Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    304,
    "Tepung Gandum Hitam (Rye Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    305,
    "Tepung Gandum Hitam Terfermentasi (Fermented Rye Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [306, "TELUR (EGG)", "Bahan Baku", "NO", "YES", "NO", "YES"],
  [
    307,
    "TELUR ASIN (SALTED EGG)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    308,
    "TELUR AYAM (CHICKEN EGG)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    309,
    "TELUR AYAM NEGERI UTUH",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    310,
    "TELUR BEBEK (DUCK EGG)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    311,
    "Telur Bubuk (Whole Egg Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    312,
    "Telur Ikan (Fish Egg)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    313,
    "Telur Puyuh (Quail Egg)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    314,
    "TEMBAGA GLUKONAT (COPPER GLUCONAT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    315,
    "Tembaga Sulfat (Copper Sulfate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [316, "Tempe", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    317,
    "Tempe Goreng (Fried Tempe)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [318, "TEMPE MATANG", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [319, "Tempura (Tempura)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    320,
    "TEMU KUNCI (CURCUMA ROTUNDA, BOESENBERGIA ROTUNDA (L) MANSF)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    321,
    "TEMULAWAK (CURCUMA XANTHORRHIZA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    322,
    "TEPUNG AGAR-AGAR (AGAR-AGAR POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [323, "Tepung Amaranth", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    324,
    "TEPUNG ARARUT/TEPUNG GARUT (ARROWROOT FLOUR)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    325,
    "Tepung Aren (Sugar Palm Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    326,
    "Tepung Barley (Barley Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    327,
    "Tepung Barley Malt (Barley Malt Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [328, "TEPUNG BATTER", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    329,
    "Teh Bubuk (Tea Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    330,
    "Teh Earl Grey (Earl Grey Tea)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    331,
    "Teh Hijau (Green Tea)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    332,
    "Teh Hijau Bubuk (Green Tea Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    333,
    "Teh Hijau Melati (Green Tea Jasmine)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    334,
    "Teh Hijau Panggang (Roasted Green Tea)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    335,
    "Teh Hitam (Black Tea Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    336,
    "Teh Hitam Ceylon (Black Tea Ceylon)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    337,
    "Teh Hitam Melati (Jasmine Black Tea)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    338,
    "Teh Instan (Instant Tea)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    339,
    "TEH JAWA (ORTHOSIPHON STAMINEUS; ORTHOSIPHON ARISTATUS; ORTHOSIPHON SPICATUS; ORTHOSIPHONBLAETTER; JAVATEE, INDISCHER NIERENTEE, FEUILLES DE BARBIFLORE; DE JAVA)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "NO",
  ],
  [
    340,
    "TEH KERING (DRIED TEA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    341,
    "Teh Melati (Jasmine Tea)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    342,
    "Teh Oolong (Oolong Tea)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    343,
    "Teh Putih (White Tea)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    344,
    "TEH ROOIBOSA (ASPHALATUS LINEARIS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    345,
    "Serbuk Kale (Brassica Oleracea L.var. acephala)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [346, "Serbuk Minuman", "Bahan Baku", "NO", "NO", "YES", "YES"],
  [347, "Serbuk Sari (Pollen)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [348, "Sereal (Cereal)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    349,
    "Sereal Beras (Rice Cereal)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    350,
    "Sereal Gandum (Wheat Cereal)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    351,
    "Sereal Gandum Utuh (Whole Wheat Cereal)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    352,
    "Sereal Jagung (Corn Cereal)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [353, "Serealia (Cerealia)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    354,
    "SEREH (LEMON GRASS-CYMBOPOGON NARDUS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    355,
    "Sereh Bubuk (Lemongrass Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    356,
    "SERPIHAN KENTANG (POTATO FLAKES)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    357,
    "Serundeng Ikan (Fish Serundeng)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    358,
    "Silver Needle-yingzhen (white tea)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    359,
    "SINGKONG - UBI KAYU (CASSAVA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    360,
    "Singkong Bubuk (Cassava Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [361, "SIOMAY", "Bahan Baku", "YES", "NO", "NO", "NO"],
  [362, "SIRIH (BETEL)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    363,
    "SIRIH EKSTRAK (PIPER BETLE L.)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    364,
    "Sirip Ikan Hiu (Shark Fins)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [365, "Sirsak (Soursop)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [366, "Sirup (Syrup)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    367,
    "Sirup Agave (Agave Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    368,
    "Sirup Anggur (Grape Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    369,
    "Sirup Barley Malt (Barley Malt Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    370,
    "Sirup Beras (Rice Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    371,
    "Sirup Beras Merah (Brown Rice Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    372,
    "Sirup Cokelat Malt (Chocolate Malt Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    373,
    "Sirup Fruktosa (Fructose Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    374,
    "SIRUP FRUKTOSA JAGUNG (FRUCTOSE CORN SYRUP)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    375,
    "Streptococcus cremoris",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [376, "Streptococcus lactis", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    377,
    "Streptococcus thermophilus",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [378, "SUCCUS LIQUIRITIAE", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [379, "succus liquirities", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    380,
    "SUJI (DRACAENA ANGUSTIFOLIA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [381, "Sukade (Sukade)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    382,
    "Sukade Pepaya (Papaya Sukade)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    383,
    "Sukromalt (Sucromalt)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [384, "Sukrosa (Sucrose)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [385, "Sultana (Sultana)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [386, "Sup (Soup)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    387,
    "Sup Apel (Apple Soup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    388,
    "Sup Daging (Meat Soup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [389, "Surimi (Surimi)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [390, "SUSU (MILK)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    391,
    "SUSU BUBUK (MILK POWDER)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    392,
    "SUSU BUBUK FULL CREAM (FULL CREAM MILK POWDER)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    393,
    "Susu Bubuk Lemak/Minyak Nabati",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    394,
    "SUSU BUBUK RENDAH LEMAK (LOW FAT MILK POWDER)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    395,
    "SUSU BUBUK TANPA LEMAK ATAU SUSU SKIM BUBUK (SKIMMED MILK POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    396,
    "SUSU CAIR (LIQUID MILK)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    397,
    "SUSU COKLAT (CHOCOLATE MILK)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    398,
    "SUSU COKLAT BUBUK (CHOCOLATE MILK POWDER)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    399,
    "SUSU EVAPORASI (EVAPORATED MILK)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    400,
    "SUSU FERMENTASI (FERMENTED MILK)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    401,
    "Susu Full Cream (Full Cream Milk)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    402,
    "Susu Kambing (Goat's Milk)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    403,
    "Susu Kambing Bubuk (Goat's Milk Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    404,
    "SUSU KAMBING FULL CREAM BUBUK (FULL CREAM GOAT'S MILK POWDER)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    405,
    "SUSU KAMBING SKIM BUBUK (SKIM GOAT'S MILK POWDER)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    406,
    "SUSU KENTAL (CONDENSED MILK)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    407,
    "SUSU KENTAL MANIS (SWEETENED CONDENSED MILK)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    408,
    "SUSU KENTAL TIDAK MANIS (UNSWEETENED CONDENSED MILK)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    409,
    "SUSU KERBAU (BUFFALO MILK)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    410,
    "SUSU KUDA (HORSE MILK)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    411,
    "Susu Lemak Nabati-Susu Minyak Nabati (Filled Milk)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    412,
    "SUSU PASTEURISASI (PASTEURIZED MILK)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    413,
    "SUSU RENDAH LEMAK (LOW FAT MILK)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    414,
    "Susu Sapi (Cow's Milk)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    415,
    "SUSU SEGAR (FRESH MILK)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    416,
    "SUSU SKIM (SKIM MILK)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    417,
    "SUSU SKIM BUBUK (SKIMMED MILK POWDER)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "NO",
  ],
  [
    418,
    "SUSU SKIM COKLAT (SKIM MILK CHOCOLATE)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    419,
    "SUSU SKIM KENTAL MANIS (SWEETENED CONDENSED SKIMMED MILK)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    420,
    "SUSU TANPA LEMAK ATAU SUSU SKIM (SKIMMED MILK)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [421, "SUSU UHT (UHT MILK)", "Bahan Baku", "NO", "YES", "NO", "YES"],
  [422, "Tahini (Tahini)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [423, "Tahu (Tofu)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    424,
    "Tahu Goreng (Fried Tofu)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    425,
    "TAHU KERING (DRIED TOFU)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [426, "TAHU MATANG", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [427, "TALAS (TARO)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    428,
    "TANGKAI TERATAI (LOTUS STEM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [429, "TAOGE (BEAN SPROUTS)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    430,
    "TAPAI BERAS (FERMENTED RICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    431,
    "TAPAI KETAN (FERMENTED STILKY RICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    432,
    "SIRUP GLUKOSA - FRUKTOSA (GLUCOSE - FRUCTOSE SYRUP)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    433,
    "Sirup Glukosa (Glucose Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    434,
    "SIRUP GLUKOSA BUBUK (GLUCOSE POWDER SYRUP)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    435,
    "Sirup Grenadine (Grenadine Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    436,
    "Sirup Gula (Sugar Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    437,
    "Sirup Gula Invert (Invert Sugar Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    438,
    "SIRUP GULA JAGUNG (CORN SUGAR SYRUP)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    439,
    "Sirup Gula Merah (Brown Sugar Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    440,
    "SIRUP GULA TERKARAMELISASI (CARAMELIZED SUGAR SYRUP)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    441,
    "Sirup Jagung (Corn Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    442,
    "Sirup Jagung Fruktosa (Fructose Corn Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    443,
    "Sirup Jagung Padat (Corn Syrup Solid)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    444,
    "Sirup Jagung Tinggi Fruktosa (High Fructose Corn Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    445,
    "Sirup Jagung Tinggi Maltosa (High Maltose Corn Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    446,
    "Sirup Jahe (Ginger Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    447,
    "Sirup Karamel (Caramel Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    448,
    "Sirup Kelengkeng (Longan Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    449,
    "Sirup Kiwi (Kiwi Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    450,
    "Sirup Kurma (Dates Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    451,
    "Sirup Malt (Malt Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    452,
    "SIRUP MAPEL (MAPLE SYRUP)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    453,
    "Sirup Melon (Melon Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    454,
    "Sirup Semangka (Watermelon Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    455,
    "Sirup Stroberi (Strawberry Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    456,
    "Sirup Sukrosa (Sucrose Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    457,
    "SIRUP TAPIOKA (TAPIOCA SYRUP)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    458,
    "Sirup Tinggi Fruktosa (High Fructose Syrup)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [459, "Sistein (Cysteine)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [460, "Sistin (Cystine)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    461,
    "SITIDIN 5'-MONOFOSFAT (CYTIDINE 5'-MONOPHOSPHATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [462, "Sitrulin Malat", "Bahan Baku", "NO", "NO", "YES", "YES"],
  [463, "SIWALAN (SIWALAN)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [464, "SOBA (BUCKWHEAT)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [465, "Soda (Soda)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    466,
    "SODA BUBUK (SODA POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    467,
    "Soda Krim (Cream Soda)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    468,
    "Sohun-Soun (Vermicelli)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [469, "Sorgum (Sorghum)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    470,
    "Sosis Ayam (Chicken Sausage)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    471,
    "Sosis Babi (Pork Sausage)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    472,
    "Sosis Ikan (Fish Sausage)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    473,
    "Sosis Sapi (Beef Sausage)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [474, "Sotong (Cuttlefish)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    475,
    "Sotong Bubuk (Cuttlefish Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [476, "Spagheti (Spaghetti)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    477,
    "Spearmint (Spearmint)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    478,
    "Spelt (Triticum spelta)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    479,
    "SPINGOMIELIN (SPHINGOMYELIN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [480, "Spirit (Spirit)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    481,
    "Spirit Air Nira (Sap Water Spirit)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    482,
    "Spirit Anggur (Grape Spirit)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    483,
    "Spirit Beras (Rice Spirit)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    484,
    "Spirit Beras Ketan (Glutinous Rice Spirit)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    485,
    "Spirit Buah Nanas (Pineapple Spirit)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    486,
    "Spirit Buah Pepaya (Papaya Spirit)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    487,
    "Spirit Buah Tomat (Tomato Spirit)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    488,
    "Spirit Gula (Sugar Spirit)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    489,
    "Spirit Gula Merah (Brown Sugar Spirit)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    490,
    "SPIRIT HASIL FERMENTASI MOLASES (FERMENTED MOLASES SPIRIT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    491,
    "Spirit Jeruk (Orange Spirit)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    492,
    "Spirit Lontar (Palmyra Spirit)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    493,
    "Spirulina (Spirulina)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    494,
    "Spirulina Bubuk (Spirulina Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    495,
    "SQUASH BERPERISA ANGGUR (GRAPE FLAVOUR SQUASH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    496,
    "SQUASH BERPERISA JERUK (ORANGE FLAVOUR SQUASH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    497,
    "Squash Berperisa Kelapa ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    498,
    "SQUASH BERPERISA LECI (LYCHEE FLAVOUR SQUASH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    499,
    "SQUASH BERPERISA STROBERI (STRAWBERRY FLAVOUR SQUASH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    500,
    "SRIKAYA (ANNONA SQUAMOSA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    501,
    "STARTER YOGHURT (YOGHURT STARTER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [502, "Stearin (Stearine)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    503,
    "Stearin Inti Buah Rafinasi (Refined Kernel Stearine)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    504,
    "Stearin Inti Kelapa Sawit Hidrogenasi (Hydrogenated Palm Kernel Stearine)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    505,
    "Serat Pangan (Dietary Fiber)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    506,
    "Serat Sayuran (Vegetable Fiber)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    507,
    "PATI TAPIOKA TERMODIFIKASI (MODIFIED TAPIOCA STARCH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    508,
    "Seng Laktat (Zinc Lactate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    509,
    "Seng Oksida (Zinc Oxide)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    510,
    "Seng Sulfat (Zinc Sulphate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    511,
    "SERAT GANDUM (WHEAT FIBER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    512,
    "SERAT LARUT (SOLUBLE FIBER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    513,
    "Serat Larut dari Jagung (Soluble Corn Fiber atau Gluco Fibre)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    514,
    "Pati Ubi (Cassava Starch)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    515,
    "PATI UBI JALAR (SWEET POTATO STARCH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    516,
    "PECAHAN JAGUNG (CORN GRITS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    517,
    "Pedada (Sonneratia caseolaris)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    518,
    "Pekak (Bunga Lawang-Kembang Lawang-Star Anise) (Star Anise)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    519,
    "Pekak Bubuk (Star Anise Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    520,
    "Minyak Mentega (Butter Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [521, "MINYAK MUSTARD", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    522,
    "NATRIUM SELENAT (SODIUM SELENATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    523,
    "NATRIUM SELENIT (SODIUM SELENITE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    524,
    "RAGI ROTI (BAKER YEAST)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [525, "Ragi Tape", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [526, "Rajungan", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [527, "Rambutan (Rambutan)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    528,
    "REBUNG (BAMBOO SPROUTS-BAMBOO SHOOTS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    529,
    "Rebung Kelapa Sawit (Palm Heart)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    530,
    "red currant leaves (ribes rubrum)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    531,
    "REHMANNIA GLUTINOSA (REHMANNIA GLUTINOSE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [532, "REMAHAN BAWANG HIJAU", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    533,
    "REMAHAN BISKUIT (BISCUIT CRUMB)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    534,
    "REMAHAN HOKEY POKEY (HOKEY POKEY CRUMB)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [535, "REMAHAN TELUR", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [536, "Remahan wafer", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    537,
    "Remis Bubuk (Mussel Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    538,
    "Remis Kering (Dried Mussel)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [539, "Rempah (Spices)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [540, "Rennet (Rennet)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    541,
    "Resin Gum (Gum Resin)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    542,
    "Retinil Asetat (Retinyl Acetate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    543,
    "Retinil Palmitat (Retinyl Palmitate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    544,
    "Rhodopseudomonas palustris",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    545,
    "rhubarb batang (rheum rhabarbarum)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "NO",
  ],
  [
    546,
    "Sayuran Okra (Abelmoschus esculentus)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    547,
    "SCUTELLARIA BAICALENSIS (ASIAN SKULLCAP, BAIKAL SKULLCAP, GOLDEN ROOT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    548,
    "Seabuckthorn (Hippophae Rhamnoides L)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    549,
    "SEAFOOD KERING (DRY SEAFOOD)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [550, "Selada (Lettuce)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    551,
    "SELADA AIR (WATERCRESS) (FOLIUM NOSTURTIUM OFFICINALE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [552, "SELAI (JAM)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    553,
    "Selai Anggur (Grape Jam)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    554,
    "Selai Apel (Apple Jam)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    555,
    "Selai Aprikot (Apricot Jam)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    556,
    "Selai Belimbing (Starfruit Jam)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    557,
    "SELAI BLUBERI (BLUEBERRY JAM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    558,
    "Selai Buah-Buahan (Fruits Jam)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    559,
    "Selai Ceri (Cherry Jam)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    560,
    "SELAI COKELAT (CHOCOLATE JAM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    561,
    "Selai Durian (Durian Jam)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    562,
    "Selai Jeruk (Orange Jam)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    563,
    "Selai Kacang (Peanut Jam)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    564,
    "Selai Kelapa (Coconut Jam)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    565,
    "Selai Kiwi (Kiwi Jam)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    566,
    "Selai Kurma (Dates Jam)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    567,
    "Selai Nanas (Pineapple Jam)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    568,
    "Selai Nangka (Jackfruit Jam)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    569,
    "Selai Pisang (Banana Jam)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    570,
    "Selai Rasberi (Raspberry Jam)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    571,
    "SELAI SRIKAYA (SWEETSOP JAM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    572,
    "Selai Stroberi (Strawberry Jam)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [573, "Selasih (Basil)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [574, "Seledri (Celery)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    575,
    "Seledri Bubuk (Celery Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [576, "Selenium (Selenium)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    577,
    "SELONGSONG SOSIS (SAUSAGE SLEEVE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [578, "Selulosa (Cellulose)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    579,
    "Semangka Merah (Red Watermelon)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [580, "SEMOLINA", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    581,
    "RIMPANG TERATAI (LOTUS ROOT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [582, "Rolled Oats", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    583,
    "rooibos-rooibush-rooibosh (asphalatus linearis)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    584,
    "Roombutter (Roombutter)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [585, "ROOT BEER BASE", "Bahan Baku", "YES", "YES", "NO", "YES"],
  [
    586,
    "ROSEHIP PEELS (ROSA CANINA)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    587,
    "ROSELA (HIBISCUS SABDARIFFA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [588, "ROSEMARI (ROSEMARY)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [589, "Roti (Bread)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    590,
    "Roti Kering (Crusty Bread)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    591,
    "ROYAL JELLY (KHUSUS MADU)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [592, "Rum (Rum)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    593,
    "Rumput Laut (Seaweed)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    594,
    "Rumput Laut Bubuk (Seaweed Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    595,
    "Rumput Laut Kering (Dried Seaweed)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [596, "SAFRON (SAFFRON)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    597,
    "SAGE (SALVIA OFFICINALIS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [598, "Sagu (Sago)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [599, "Sake (Sake)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [600, "Salak", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    601,
    "Salicornia herbacea L (Salicornia europaea L)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [602, "SAMBAL (SAUCE)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    603,
    "Sambal Seafood (Seafood Sauce)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    604,
    "SAMBILOTO (ANDROGRAPHIS PANICULATA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [605, "SAMBUCUS NIGRA", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    606,
    "Santan Kelapa (Coconut Milk)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    607,
    "Santan Kelapa Bubuk (Coconut Milk Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    608,
    "SANTAN KELAPA MURNI (PURE COCONUT MILK)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    609,
    "Sarang Burung Walet (Swallow's Nest)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    610,
    "Sari Asam (Tamarind Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    611,
    "Sari Asam Jawa (Tamarind Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    612,
    "SARI AYAM (CHICKEN ESSENCE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    613,
    "Sari Bawang Bombay (Onion Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    614,
    "Sari Beras (Grains of Rice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    615,
    "SARI BERAS MERAH (BROWN RICE JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    616,
    "Sari Buah ...... Rekonstitusi",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    617,
    "Sari Buah Anggur (Grape Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    618,
    "SARI BUAH ANGGUR BUBUK",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    619,
    "Sari Buah Anggur Hijau (Green Grape Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    620,
    "Sari Buah Anggur Merah (Red Grape Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    621,
    "Sari Buah Anggur Muscat (Muscat Grape Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    622,
    "Sari Buah Anggur Putih (White Grape Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    623,
    "SARI BUAH ANGGUR REKONSTITUSI (GRAPE JUICE RECONSTITUTION)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    624,
    "Sari Buah Apel (Apple Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    625,
    "SARI BUAH APEL REKONSTITUSI (APPLE JUICE RECONSTITUTION)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    626,
    "Sari Buah Apricot (Apricot Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    627,
    "SARI BUAH ARBEI (ARBEI JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [628, "Sari Buah Aren", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    629,
    "Sari Buah Aronia (Aronia Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    630,
    "SARI BUAH ASAM JAWA (TAMARIND JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    631,
    "Sari Buah Belimbing (Starfruit Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    632,
    "Sari Buah Bilberry (Bilberry Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    633,
    "Sari Buah Blackberry (Blackberry Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    634,
    "Sari Buah Blackcurant (Blackcurrant Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    635,
    "Sari Buah Blackcurrant Bubuk (blackcurrant juice powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    636,
    "Sari Buah Blewah (Cantaloupe Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    637,
    "Sari Buah Blueberry (Blueberry Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    638,
    "Sari Buah Ceri (Cherry Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    639,
    "Sari Buah Chokeberry (Chokeberry Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    640,
    "Sari Buah Cranberry (Cranberry Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    641,
    "SARI BUAH CRANBERRY REKONSTITUSI (CRANBERRY JUICE RECONSTITUTION) ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    642,
    "Sari Buah Delima (Pomegranate Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    643,
    "SARI BUAH FRAMBOZEN (FRAMBOZEN JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    644,
    "SARI BUAH GOJIBERRY (GOJIBERRY JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    645,
    "Sari Buah Gooseberry (Gooseberry Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [646, "Sari Buah Jambu", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    647,
    "Sari Buah Jambu Biji (Guava Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [648, "SARI BUAH JAMBU MERAH", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    649,
    "Sari Buah Jeruk (Orange Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    650,
    "SARI BUAH JERUK BUBUK (ORANGE JUICE POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    651,
    "Sari Buah Jeruk Florida-Jeruk .....",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    652,
    "Sari Buah Jeruk Kalamansi",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    653,
    "Sari Buah Jeruk Lemon (Lemon Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    654,
    "SARI BUAH JERUK LIMAU (LIMAU JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    655,
    "Sari Buah Jeruk Mandarin",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    656,
    "Sari Buah Jeruk Nipis",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    657,
    "SARI BUAH JERUK REKONSTITUSI (ORANGE JUICE RECONSTITUTION) ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    658,
    "SARI BUAH KELAPA (COCONUT JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    659,
    "Sari Buah Kiwi (Kiwi Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    660,
    "Sari Buah Kranberi (Cranberry Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    661,
    "SARI BUAH KUNDUR (BENINCASA HISPIDA JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    662,
    "SARI BUAH KURMA (DATES JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    663,
    "Sari Buah Labu (Pumpkin Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    664,
    "Sari Buah Leci (Lychee Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    665,
    "Sari Buah Mangga (Mango Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    666,
    "SARI BUAH MANGGA BUBUK (MANGO JUICE POWDER)",
    "Bahan Baku",
    "YES",
    "YES",
    "NO",
    "YES",
  ],
  [
    667,
    "Sari Buah Manggis (Mangosteen Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    668,
    "Sari Buah Markisa (Passion Fruit Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    669,
    "SARI BUAH MARKISA REKONSTITUSI (PASSION FRUIT JUICE RECONSTITUTION)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    670,
    "SARI BUAH MELON (MELON JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    671,
    "Sari Buah Nanas (Pineapple Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    672,
    "SARI BUAH NANAS REKONSTITUSI (PINEAPPLE JUICE RECONSTITUTION)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    673,
    "Sari Buah Nangka (Jackfruit Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    674,
    "Sari Buah Pala (Nutmeg Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    675,
    "SARI BUAH PEAR REKONSTITUSI (PEAR JUICE RECONSTITUTION)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    676,
    "Sari Buah Pepaya (Papaya Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    677,
    "Sari Buah Persik (Peach Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    678,
    "Sari Buah Pir (Pear Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    679,
    "Sari Buah Pisang (Banana Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    680,
    "Sari Buah Plum (Plum Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    681,
    "Sari Buah Prune (Prune Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    682,
    "Sari Buah Raspberi (Raspberry Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    683,
    "SARI BUAH RASPBERI REKONSTITUSI (RASPBERRY JUICE RECONSTITUTION)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    684,
    "Sari Buah Redcurrant (Redcurrant Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    685,
    "Sari Buah Semangka (Watermelon Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    686,
    "Sari Buah Sirsak (Soursop Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    687,
    "SARI BUAH SIWALAN (PALMYRA FRUIT JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    688,
    "Sari Buah Stroberi (Strawberry Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    689,
    "SARI BUAH STROBERI REKONSTITUSI (STRAWBERRY JUICE RECONSTITUTION)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    690,
    "Sari Buah Terong (Eggplant Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    691,
    "SARI BUAH TERONG BELANDA (TAMARILLO JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    692,
    "Sari Buah Tomat (Tomato Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    693,
    "SARI BUNGA MAWAR (ROSE JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "NO",
  ],
  [694, "SARI DAGING AYAM", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [695, "SARI DAGING SAPI", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    696,
    "SARI DAUN CINCAU (GRASS JELLY JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    697,
    "SARI DAUN KATUK (KATUK JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    698,
    "SARI DAUN PANDAN (PANDAN JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    699,
    "Sari Jagung (Corn Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    700,
    "Sari Jahe (Ginger Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    701,
    "SARI JAHE MERAH (RED GINGER JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    702,
    "Sari Kacang Almond (Almond Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    703,
    "Sari Kacang Kedelai (Soy Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    704,
    "SARI KACANG KEDELAI BUBUK (SOY JUICE POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    705,
    "SARI KACANG KEDELAI HITAM (BLACK SOYBEAN JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    706,
    "Sari Kelapa (Coconut Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    707,
    "SARI KERANG ABALONE (ABALONE JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    708,
    "Sari Kopi (Coffee Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    709,
    "Sari Kunyit (Turmeric Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    710,
    "Sari Lidah Buaya (Aloe Vera Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    711,
    "Sari Malt (Malt Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    712,
    "Sari Rosella (Rosella Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    713,
    "Sari Rumput Laut (Seaweed Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    714,
    "Sari Sayuran (Vegetable Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    715,
    "Sari Seledri (Celery Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    716,
    "SARI TAPE (TAPAI JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    717,
    "Sari Tebu (Sugar Cane Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    718,
    "Sari Tiram (Oyster Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    719,
    "Sari Wortel (Carrot Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [720, "SAUS (SAUCE)", "Bahan Baku", "YES", "NO", "NO", "YES"],
  [
    721,
    "SAUS BARBEKUE (BARBEQUE SAUCE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    722,
    "SAUS BUAH (FRUIT SAUCE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    723,
    "Saus Buah Blueberry (Blueberry Sauce)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    724,
    "Saus Buah Jambu (Guava Sauce)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    725,
    "Saus Buah Markisa (Passion Fruit Sauce)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    726,
    "Saus Buah Pepaya (Papaya Sauce)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    727,
    "Saus Buah Pisang (Banana Sauce)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    728,
    "SAUS BUAH STROBERI (STRAWBERRY SAUCE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    729,
    "Saus Buffalo Style (Buffalo Style Sauce)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    730,
    "Saus Cabe (Chili Sauce)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    731,
    "Saus Coklat (Chocolate Sauce)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    732,
    "Saus Durian (Durian Sauce)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    733,
    "Saus Ikan (Fish Sauce)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    734,
    "Saus Ikan Teri (Anchovy Sauce)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    735,
    "Saus Kacang (Peanut Sauce)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    736,
    "SAUS KACANG KEDELAI (SOYBEAN SAUCE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    737,
    "SAUS KAPUCINO (CAPPUCINNO SAUCE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    738,
    "SAUS KEJU (CHEESE SAUCE)",
    "Bahan Baku",
    "YES",
    "YES",
    "NO",
    "YES",
  ],
  [
    739,
    "SAUS KOPI (COFFEE SAUCE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    740,
    "SAUS TAR TAR (TAR TAR SAUCE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    741,
    "Saus Teriyaki (Teriyaki Sauce)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    742,
    "Saus Tiram (Oyster Sauce)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    743,
    "Saus Tomat (Tomato Sauce)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    744,
    "Saus/ Topping/ Olesan/ Pasta Manis",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    745,
    "Sawi (Mustard Greens)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    746,
    "SAWI PUTIH (CHINESE CABBAGE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [747, "Sawo (Sapodilla)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    748,
    "Sayap Ayam (Chicken Wing)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    749,
    "SAYUR BUBUK (VEGETABLE POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    750,
    "Sayuran Beku (Frozen Vegetable)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    751,
    "SAYURAN KERING (DRY VEGETABLE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    752,
    "Protein Susu (Milk Protein)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    753,
    "Protein Susu Fermentasi (Fermented Milk Protein)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [754, "PRUNELLA VULGARIS", "Bahan Baku", "NO", "NO", "YES", "NO"],
  [755, "PSYLLIUM HUSK", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    756,
    "Puff Gandum (Wheat Puffed)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    757,
    "Puree Apel (Apple Puree)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    758,
    "PUREE BAWANG PUTIH (GARLIC PUREE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    759,
    "PUREE BLACKBERRY (BLACKBERRY PUREE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    760,
    "Puree Blackcurrant (Blackcurrant Puree)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    761,
    "PUREE BLUBERI (BLUEBERRY PUREE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    762,
    "PUREE BUAH LAINNYA (FRUIT PUREE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    763,
    "Puree Ceri (Cherry Puree)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    764,
    "Puree Jambu Biji (Guava Puree)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [765, "PUREE JAMBU MERAH", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [766, "Puree Kurma", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    767,
    "Puree Leci (Lyche Puree)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    768,
    "Puree Mangga (Mango Puree)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    769,
    "PUREE MIX BERRY (MIX BERRY PUREE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    770,
    "Puree Persik (Peach Puree)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    771,
    "PUREE PIR (PEAR PUREE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    772,
    "Puree Sirsak (Soursop Puree)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    773,
    "Puree Stroberi (Strawberry Puree)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    774,
    "Puree Tomat (Tomato Puree)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    775,
    "PUTIH TELUR (EGG WHITE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    776,
    "PUTIH TELUR BUBUK (EGG WHITE POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    777,
    "PUTIH TELUR PADAT (EGG WHITE SOLID)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    778,
    "QUERCETIN (BERUPA ISOLAT DARI BANYAK TANAMAN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [779, "Rafinosa (Raffinose)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [780, "Ragi (Yeast)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    781,
    "Ragi Bubuk (Yeast Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    782,
    "Ragi Instan (Instant Yeast)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    783,
    "Ragi Kering (Dried Yeast)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    784,
    "Ragi Padat (Solid Yeast)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    785,
    "PLANT STANOL ESTER-FITOSTANOL (PHYTOSTANOL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    786,
    "Polidekstrosa (Polydextrose)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    787,
    "Polifruktosa (Polyfructose)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    788,
    "Polisakarida (Polysaccharides)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    789,
    "POTONGAN BUAH APEL (APPLE SLICES)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    790,
    "POTONGAN KENTANG (POTATO SLICES)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [791, "Pottasium Aspartate", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [792, "Praline (Praline)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [793, "PREM (PLUM)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    794,
    "PREM ASIN (SALTED PLUM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    795,
    "PREMIKS MINERAL (MINERAL PREMIX)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    796,
    "Premiks Vitamin (Vitamin Premix)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    797,
    "PREMIKS VITAMIN DAN MINERAL (VITAMIN AND MINERAL PREMIX)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    798,
    "Preparat Perisa (Flavoring Preparation)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [799, "PROPOLIS (PROPOLLIS)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    800,
    "Protein Gandum (Wheat Protein)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    801,
    "Protein Jagung Terhidrolisa (Hydrolized Corn Protein)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    802,
    "Protein Kedelai (Soy Protein)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    803,
    "PROTEIN KEDELAI TERHIDROLISA (HYDROLIZED SOY PROTEIN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    804,
    "PROTEIN NABATI (VEGETABLE PROTEIN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [805, "Pektin (Pectin)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    806,
    "Pelapis Gula (Sugar Coating)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [807, "Pelet (Pellet)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    808,
    "Pengganti Lemak Kakao (Cacao Butter Substitute)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [809, "PENGGANTI MENTEGA", "Bahan Baku", "YES", "NO", "NO", "NO"],
  [
    810,
    "PENGGANTI MINYAK MENTEGA (BUTTER OIL SUBSTITUTE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    811,
    "Penicillium camemberti",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [812, "Penicillium candidum", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    813,
    "PENICILLIUM CASEICOLUM",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    814,
    "Penicillium roqueforti",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    815,
    "penyangga bunga teratai",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [816, "Pepaya Gunung/Karika", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    817,
    "Pepermint (Peppermint)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    818,
    "Pepermint Bubuk (Peppermint Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    819,
    "Peptida Kolagen (Collagen Peptide)",
    "Bahan Baku",
    "YES",
    "NO",
    "NO",
    "YES",
  ],
  [
    820,
    "Perasan Air Jeruk (Lemon Juice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [821, "PETAI (BITTER BEAN)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    822,
    "PETAI CINA (WHITE LEADTREE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [823, "Peterseli (Parsley)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    824,
    "Peterseli Bubuk (Parsley Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [825, "Pimenta (Pimenta)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [826, "Pimento (Allspice)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    827,
    "Pimento Bubuk (Allspice Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [828, "PINANG (ARECA NUT)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    829,
    "Pinto Beans (Kacang Pinto)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [830, "PIR (PEAR)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    831,
    "PIRIDOKSIN HIDROKLORIDA (VITAMIN B6)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [832, "Pisang (Banana)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    833,
    "Pisang Bubuk (Banana Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    834,
    "Pasta Kurma (Datess Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    835,
    "PASTA LADA MERAH (RED PEPPER PASTE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    836,
    "Pasta Leci (Lychee Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    837,
    "Pasta Mangga (Mango Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    838,
    "Pasta Nanas (Pineapple Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    839,
    "Pasta Pear (Pear Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    840,
    "Pasta Pepaya (Papaya Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    841,
    "Pasta Persik (Peach Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    842,
    "Pasta Pisang (Banana Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    843,
    "Pasta Plum (Plum Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    844,
    "PASTA RASPBERI (RASPBERRY PASTE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    845,
    "PASTA SARIKAYA (SARIKAYA PASTE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    846,
    "Pasta Srikaya (Soursop Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    847,
    "Pasta Stroberi (Strawberry Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    848,
    "Pasta Tomat (Tomato Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    849,
    "Pasta Udang (Shrimp Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    850,
    "Pasta Wijen (Sesame Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    851,
    "Pastri Samosa (Samosa Pastry)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [852, "Pati (Starch)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    853,
    "Pati Beras (Rice Starch)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    854,
    "Pati Gandum (Wheat Starch)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    855,
    "Pati Jagung (Corn Starch)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    856,
    "Pati Jagung Terhidrolisa (Hydrolized Corn Starch)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    857,
    "PATI JAGUNG TERMODIFIKASI (MODIFIED CORN STARCH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    858,
    "Pati Kacang Hijau (Mungbean Starch)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    859,
    "PATI KACANG POLONG (PEAS STARCH)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    860,
    "Pati Kedelai Terhidrolisa ((Hydrolized Soy Starch)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    861,
    "Pati Kentang (Potato Starch)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    862,
    "PATI KENTANG TERMODIFIKASI (MODIFIED POTATO STARCH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    863,
    "PATI MODIFIKASI (MODIFIED STARCH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    864,
    "Pati Sagu (Sago Starch)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    865,
    "PATI SINGKONG (TAPIOCA STARCH) ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    866,
    "PASAK BUMI (EURYCOMA LONGIFOLIA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    867,
    "Pasta (Fettucini, Lasagna, Macaroni, Spaghetti, dll)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    868,
    "Pasta Almond (Almond Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    869,
    "Pasta Apel (Apple Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    870,
    "Pasta Ayam (Chicken Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    871,
    "Pasta Bawang Bombay (Onion Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    872,
    "Pasta Bawang Putih (Garlic Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    873,
    "Pasta Biji Wijen (Sesame Seed Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    874,
    "Pasta Bluberi (Blueberry Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    875,
    "PASTA BUAH, DLL (FRUITS PASTE, ETC)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    876,
    "Pasta Bumbu Kari (Curry Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    877,
    "Pasta Cabe (Chili Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    878,
    "Pasta Cokelat Malt (Chocolate Malt Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    879,
    "Pasta Coklat (Chocolate Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    880,
    "Pasta Durian (Durian Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    881,
    "Pasta Ikan (Fish Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    882,
    "Pasta Ikan Anchovy (Anchovy Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    883,
    "Pasta Jagung Manis (Sweet Corn Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    884,
    "Pasta Jeruk (Orange Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    885,
    "Pasta Jeruk Lemon (Lemon Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    886,
    "Pasta Kacang (Nut Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    887,
    "Pasta Kacang Hazel (Hazelnut Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    888,
    "Pasta Kacang Hijau (Mungbean Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    889,
    "Pasta Kacang Kedelai (Soybean Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    890,
    "PASTA KACANG MERAH (RED BEAN PASTE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    891,
    "Pasta Keju (Cheese Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    892,
    "Pasta Kelapa (Coconut Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    893,
    "PASTA KETAN HITAM (BLACK STICKY RICE PASTE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    894,
    "Pasta Kismis (Raisin Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    895,
    "Natrium Kaseinat (Sodium Caseinate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    896,
    "natrium klorida (sodium chloride)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    897,
    "NATRIUM MOLIBDAT (SODIUM MOLYBDATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    898,
    "Natrium dihidrogen fosfat (Sodium dihydrogen phosphate) ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    899,
    "Natrium fluorida (Sodium fluoride)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    900,
    "NATRIUM HIDROGEN KARBONAT (SODIUM BICARBONATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    901,
    "Natrium Hidroksida (Sodium Hydroxide) (Kecuali MP ASI)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    902,
    "NATRIUM IODIDA (SODIUM IODIDE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    903,
    "Minyak Wijen (Sesame Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    904,
    "MINYAK ZAITUN (REFINED BLEACHED DEODORIZED OLIVE OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    905,
    "MINYAK ZAITUN EXTRA VIRGIN (EXTRA VIRGIN OLIVE OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    906,
    "Minyak Zaitun Pomace (Pomace Olive Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    907,
    "Minyak Zaitun Virgin (Virgin Olive Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [908, "Mirin", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [909, "Miso", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    910,
    "MISO BUBUK (MISO POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    911,
    "Mocaf (Tepung Singkong Fermentasi)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [912, "Molibdenum", "Bahan Baku", "NO", "NO", "YES", "YES"],
  [
    913,
    "Nektar Agave (Agave Nectar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [914, "Nektar Lontar", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    915,
    "NETTLE LEAF POWDER (URTICA DIOCA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [916, "NIASIN (NIACIN)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    917,
    "NIKOTINAMIDA (NICOTINAMIDE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    918,
    "NIRA KELAPA (COCONUT SAP)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    919,
    "Nira Lontar (Siwalan)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    920,
    "Non-Dairy Toppings, Fillings, Frostings",
    "Bahan Baku",
    "YES",
    "NO",
    "NO",
    "YES",
  ],
  [
    921,
    "Nori Goreng (Fried Seawed)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [922, "Nougat (Nougat)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    923,
    "Nukleotida (Nucleotide)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    924,
    "NUKLEOTIDA PREMIKS (PREMIX NUCLEOTIDE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [925, "Oat (Oat)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    926,
    "OAT BUBUK (OAT POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    927,
    "OAT SERPIHAN (OAT FLAKES)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [928, "OATMEAL (OATMEAL)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [929, "OKSIGEN (OXYGEN)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    930,
    "OLIGOFRUKTOSA (OLIGOFRUCTOSE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    931,
    "OLIGOSAKARIDA (OLIGOSACCHARIDES)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [932, "Omega 3 (Omega 3)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [933, "Oregano (Oregano)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    934,
    "Oregano Bubuk (Oregano Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    935,
    "PADATAN SUSU (MILK SOLIDS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    936,
    "PADATAN SUSU TANPA LEMAK (NON FAT MILK SOLIDS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    937,
    "PAHA AYAM (CHICKEN THIGHS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    938,
    "Pakcoy atau Pokcoy (Brassica Rapa L)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [939, "Pala (Nutmeg)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    940,
    "Pala Bubuk (Nutmeg Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [941, "Pandan (Pandan)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [942, "PANGSIT (DUMPLINGS)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [943, "PAPRIKA (PAPRIKA)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    944,
    "PAPRIKA BUBUK (PAPRIKA POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    945,
    "PAPRIKA HIJAU (GREEN PAPRIKA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    946,
    "PAPRIKA HIJAU MANIS (SWEET GREEN PAPRIKA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    947,
    "PAPRIKA KUNING (YELLOW PAPRIKA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    948,
    "PAPRIKA MERAH (RED PAPRIKA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    949,
    "PAPRIKA MERAH MANIS (SWEET RED PAPRIKA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    950,
    "PAPRIKA OLEORESIN (PAPRIKA OLEORESIN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [951, "PARE (PARE)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    952,
    "PARE KERING (DRY PARE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [953, "PARSLEY", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    954,
    "PARSNIP (PASTINACA SATIVA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    955,
    "PARU SAPI (PULMONARY COW)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    956,
    "PARUTAN KELAPA (GRATED COCONUT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    957,
    "Monokalium fosfat (Potassium phosphate, monobasic) ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [958, "MULUKHIYAH", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    959,
    "MUNG DHAL (MOONG DAL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [960, "Muscat (Muscat)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [961, "Mustard (Mustard)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    962,
    "Mustard Bubuk (Mustard Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    963,
    "Mustard Kuning (Yellow Mustard)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    964,
    "Mustard Pasta (Mustard Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [965, "Myo-Inositol", "Bahan Baku", "NO", "NO", "YES", "YES"],
  [966, "Naget (Nugget)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [967, "Nanas (Pineapple)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    968,
    "NANAS BUBUK (PINEAPPLE POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [969, "Nangka (Jackfruit)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [970, "Nasi (Rice)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    971,
    "Nata De Coco (Nata De Coco)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    972,
    "NATRIUM ASKORBAT (SODIUM ASCORBATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    973,
    "MINYAK SAYUR (COOKING OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    974,
    "MINYAK SAYUR PADAT (COOKING FAT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    975,
    "Minyak Sekam Oat (Oat Bran Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    976,
    "Minyak Spearmint (Spearmint Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    977,
    "Minyak Spinkenard (Spinkenard Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    978,
    "Minyak Stearin Inti Kelapa Sawit Terhidrogenasi (Hydrogenated Palm Kernel Stearin Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    979,
    "MINYAK STEARIN KELAPA SAWIT (REFINED BLEACHED DEODORIZED PALM STEARIN OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    980,
    "MINYAK TRIGLISERIDA RANTAI SEDANG (MCT) (MEDIUM CHAIN TRIGLYCERIDES OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [981, "Minyak Truffle", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    982,
    "MINYAK KEDELAI (REFINED BLEACHED DEODORIZED SOYBEAN OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    983,
    "Minyak Kedelai Terhidrogenasi Parsial (Partially Hydrogenated Soybean Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    984,
    "MINYAK KELAPA (REFINED BLEACHED DEODORIZED COCONUT OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    985,
    "Minyak Kelapa Bubuk (Coconut Oil Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    986,
    "Minyak Kelapa Mentah (Unrefined Coconut Oil-Crude Coconut Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    987,
    "Minyak Kelapa Murni (Virgin Coconut Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    988,
    "MINYAK KELAPA SAWIT (REFINED BLEACHED DEODORIZED PALM OIL-RBDPO) ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    989,
    "Minyak Kelapa Sawit Terhidrogenasi (Refined Hydrogenated Palm Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    990,
    "Minyak Kelapa Terhidrogenasi (Hydogenated Coconut Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    991,
    "Minyak Kulit Ari Beras (Rice Husk Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    992,
    "Minyak LC-PUFA (Oil Mix LC-PUFA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    993,
    "Minyak Melon (Melon Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    994,
    "Minyak Nabati (Vegetable Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    995,
    "Minyak Nabati Terhidrogenasi (Hydrogenated Vegetable Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    996,
    "Minyak Nanas (Pineapple Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    997,
    "Minyak Nangka (Jackfruit Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    998,
    "MINYAK OLEIN KELAPA SAWIT (REFINED BLEACHED DEODORIZED PALM OLEIN OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    999,
    "Minyak Pandan (Pandan Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1000,
    "Minyak Peppermint (Peppermint Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1001,
    "MINYAK PERILLA (PERILLA OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1002,
    "Minyak Primrose (Evening Primrose Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1003,
    "MINYAK RAPESEED (RAPESEED OIL-TURNIP RAPE OIL-COLZA OIL-RAVISON OIL-SARSON OIL-TORIA OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1004,
    "Minyak Raspberry (Raspberry Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1005,
    "Minyak Reroti (Shortening Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1006,
    "MINYAK ROS ESENSIAL (ROSE ESSENTIAL OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1007,
    "Minyak Sacha Inchi (Plukenetiva Volubilis L)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1008,
    "MINYAK SAFFLOWER (REFINED BLEACHED DEODORIZED SAFFLOWER OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1009,
    "Minyak Salad (Salad Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1010,
    "MINYAK SAMIN ATAU VANASPATI (VEGETABLE GHEE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1011,
    "Minyak Sapi (Beef Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1012,
    "Minyak Sarsaparila (Sarsaparilla Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1013,
    "mate green (illex paraguarienis)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1014,
    "Mate Green (Illex Paraguariensis)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    1015,
    "MAXIMOWICZIA (SCHISANDRA CHINENSIS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1016,
    "Mayonais (Mayonnaise)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1017, "Melati (Jasmine)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1018,
    "MELINJO (GNETUM GNEMON L.)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1019,
    "MELISASA OFFICINALIS (HERBA LEMON BALM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [1020, "Melon (Melon)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1021,
    "Melon Bubuk ( Melon Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1022,
    "Mengkudu (Morinda citrifolia)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1023,
    "Lemak Nabati (Vegetable Fat)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1024,
    "Lemak Nabati Terhidrogenasi (Hydrogenated Vegetable Fat)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1025,
    "Lemak Kakao (Cocoa Butter)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1026,
    "LEMAK MENTEGA (BUTTER FAT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1027,
    "LADA MERAH (RED PEPPER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1028,
    "Lada Putih (White Pepper)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1029,
    "LADA PUTIH BUBUK (WHITE PEPPER POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1030,
    "LAKTOFERIN (LACTOFERRIN)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    1031,
    "Maltodekstrin (Maltodextrine)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1032,
    "Maltodekstrin Resisten",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1033, "Maltosa (Maltose)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1034,
    "Maltotriose (Maltotriose)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1035,
    "MANGAN (II) GLUKONAT (MANGANESE (II) GLUCONATE) ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1036,
    "Mangan (II) Klorida (Manganese (II) Chloride)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1037,
    "MANGAN SITRAT (MANGANESE CITRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1038,
    "Mangan Sulfat (Manganese Sulphate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1039, "Mangga (Manggo)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1040,
    "Mangga Bubuk (Mango Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1041,
    "Mangga Kering (Dried Mango)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1042,
    "Manggis (Mangosteen)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1043,
    "MANISAN CRANBERRY (CANDIED CRANBERRY)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1044,
    "Manisan Jeruk (Candied Orange)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1045,
    "Manisan Kulit Jeruk (Candied Orange Peel)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1046,
    "Manisan Mangga (Candied Mango)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1047,
    "Manisan Nanas (Candied Pineapple)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1048,
    "Manisan Pepaya (Candied Papaya)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1049,
    "MAQUI BERRY (ARISTOTELIA CHILENSIS) ",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "NO",
  ],
  [
    1050,
    "Margarin (Margarine)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1051,
    "MARGARIN OLES (MARGARINE SPREAD)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1052, "Marjoram", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1053,
    "Markisa (Passion Fruit)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1054,
    "Marmalad (Marmalade)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1055,
    "MARSHMALLOW (MARSHMALLOW)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1056, "MARSMALLOW", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [1057, "MARZIPAN (MARZIPAN)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1058, "LAKTOSA (LACTOSE)", "Bahan Baku", "NO", "YES", "NO", "YES"],
  [
    1059,
    "LAKTOSA BUBUK (LACTOSE POWDER)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    1060,
    "LAKTULOSA (LACTULOSE)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    1061,
    "LAPACHO (TABEBULA IMPETIGINOSA ATAU HANDROANTHUS IMPETIGINOSUS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1062,
    "LARUTAN GULA (SUGAR SOLUTION)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1063,
    "lavender (lavandula angustifolia)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1064,
    "Lemak Ayam (Chicken Fat)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1065, "Lemak Babi (Lard)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1066,
    "LEMAK COKLAT (CHOCOLATE FAT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1067,
    "Lemak Hewani (Tallow)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1068,
    "Lemak Inti Sawit Terhidrogenasi (Refined Hydrogenated Palm Kernel Fat)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1069,
    "Lada Hitam (Black Pepper)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1070,
    "Lada Hitam Bubuk (Black Pepper Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1071, "Keju (Cheese)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1072,
    "Keju Biru (Blue Cheese)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1073,
    "Krispi Beras (Rice Crispy)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1074,
    "Krispi Kedelai (Soy Crispy)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1075,
    "KROMIUM KLORIDA (CHROMIUM CHLORIDE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1076,
    "Kromium Pikolinat (Chromium Picolinate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1077,
    "KROMIUM POLINIKOTINAT (CHROMIUM POLYNICOTINATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1078,
    "Kuaci (Sunflower Seed)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1079, "Mentega (Butter)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1080,
    "MENTEGA ASIN (SALTED BUTTER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1081,
    "Mentega Bubuk (Butter Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1082,
    "Mentega Kacang (Peanut Butter)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1083,
    "Mentega Tawar (Unsalted Butter)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1084,
    "Mentimun - Ketimun (Cucumber)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1085,
    "Mentimun Hijau (Green Cucumber)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1086, "MENTOL (MENTHOL)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    1087,
    "Merica Sichuan (Zanthoxylum peperitum - Szechuan pepper)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1088,
    "MESES (CHOCOLATE SPRINKLES-CHOCOLATE VERMICELLI-STREUSEL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1089, "MESHIMAKOBU", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [1090, "Mesoyi", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1091,
    "Metionin (Methionine)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1092, "Mi (Noodle)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1093,
    "Mi Telur (Egg Noodles)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1094, "MICROCOS PANICULATA", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    1095,
    "MIKOPROTEIN (MYCOPROTEIN) DARI FUSARIUM VENENATUM",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1096, "Millet (Millet)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1097,
    "Millet Serpih (Millet Flakes)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1098, "MINUMAN BERALKOHOL", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    1099,
    "Minuman Sari Buah ....",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1100,
    "Minyak Almond (Almond Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1101,
    "Minyak Adas Manis (Anise Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1102,
    "Minyak Alpukat (Avocado Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1103,
    "MINYAK ANGGUR (GRAPE OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1104,
    "MINYAK ANIS (ANISE OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1105,
    "Minyak Atsiri Adas Manis (Anise Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1106,
    "MINYAK ATSIRI BAWANG BOMBAY (ONION ESSENTIAL OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1107,
    "Minyak Atsiri Bunga Matahari (Sunflower Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1108,
    "Minyak Atsiri Cabai (Chili Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1109,
    "Minyak Atsiri Cengkeh (Clove Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1110,
    "Minyak Atsiri Chamomile (Chammomile Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1111,
    "Minyak Atsiri Durian (Durian Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1112,
    "MINYAK ATSIRI JAHE (GINGER OLEORESIN-GINGER ESSENTIAL OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1113,
    "Minyak Atsiri Jeruk (Orange Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1114,
    "MINYAK ATSIRI JERUK BALI (GRAPEFRUIT ESSENTIAL OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1115,
    "Minyak Atsiri Jeruk Bergamot (Bergamot Orange Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1116,
    "Minyak Atsiri Jeruk Lemon (Lemon Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1117,
    "Minyak Atsiri Jeruk Nipis (Lime Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1118,
    "MINYAK ATSIRI JERUK PURUT (KAFFIR LIME ESSENTIAL OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1119,
    "Minyak Atsiri Jintan Hitam (Black Cumin Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1120,
    "MINYAK ATSIRI JUNIPER BERRY (JUNIPER BERRY ESSENTIAL OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1121,
    "Minyak Atsiri Kayu Manis (Cinnamon Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1122,
    "Minyak Atsiri Kemukus (Cubeb Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1123,
    "Minyak Atsiri Kunyit (Turmeric Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1124,
    "Minyak Atsiri Lada (Pepper Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1125,
    "Minyak Atsiri Leci (Lychee Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1126,
    "MINYAK ATSIRI LEMON (LEMON ESSENTIAL OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1127,
    "MINYAK ATSIRI LOBAK (RADISH ESSENTIAL OIL-TURNIP ESSENTIAL OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1128,
    "Minyak Atsiri Mangga (Mango Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1129,
    "Minyak Atsiri Mint (Mint Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1130,
    "MINYAK ATSIRI MUSTARD (MUSTARDSEED ESSENTIAL OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1131,
    "MINYAK ATSIRI NANAS (PINEAPPLE ESSENTIAL OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1132,
    "Minyak Atsiri Nangka (Jackfruit Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1133,
    "Minyak Atsiri Pala (Nutmeg Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1134,
    "Minyak Atsiri Pandan (Pandan Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1135,
    "MINYAK ATSIRI PAPRIKA (PAPRIKA OLEORESIN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1136,
    "Minyak Atsiri Peppermint (Peppermint Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1137,
    "MINYAK ATSIRI PERILLA (PERILLA ESSENTIAL OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1138,
    "Minyak Atsiri Pisang (Banana Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1139,
    "MINYAK ATSIRI ROSEMARY (ROSEMARY OLEORESIN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1140,
    "Minyak Atsiri Sereh (Lemongrass Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1141,
    "Minyak Atsiri Spearmint (Spearmint Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1142,
    "Minyak Atsiri Stroberi (Strawberry Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1143,
    "Minyak Atsiri Tarragon (Tarragon Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1144,
    "Minyak Atsiri Wortel (Carrot Essential Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1145,
    "Minyak Ayam (Chicken Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1146,
    "Minyak Babi (Pork Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1147,
    "Minyak Barley (Barley Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1148,
    "Minyak Bawang Merah (Shallot Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1149,
    "MINYAK BAWANG PUTIH (GARLIC OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1150,
    "MINYAK BERAS (RICE BRAN OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1151,
    "Minyak Biji Anggur (Grapeseed Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1152,
    "MINYAK BIJI APRIKOT (APRICOT KERNEL OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1153,
    "MINYAK BIJI BUNGA MATAHARI (REFINED BLEACHED DEODORIZED SUNFLOWER OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1154,
    "MINYAK BIJI KAPAS (REFINED BLEACHED DEODORIZED COTTONSEED OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1155,
    "Minyak Biji Rami (Flaxseed Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1156,
    "MINYAK BIJI SAWI (MUSTARDSEED OIL - REFINED BLEACHED DEODORIZED MUSTARDSEED OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1157,
    "MINYAK BUNGA MATAHARI (SUNFLOWER OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1158,
    "MINYAK CABAI (CAPSICUM OLEORESIN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1159,
    "MINYAK DAUN JERUK PURUT (KAFFIR LIME LEAF OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1160,
    "Minyak Durian (Durian Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1161,
    "MINYAK FRAMBOZEN (FRAMBOZEN OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1162,
    "MINYAK GORENG (FRYING OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1163,
    "MINYAK GORENG KEDELAI (SOYBEAN FRYING OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1164,
    "Minyak Goreng Kelapa Sawit (Palm Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1165,
    "MINYAK IKAN (FISH OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1166,
    "Minyak Inti Kelapa Sawit Terhidrogenasi (Refined Hydrogenated Palm Kernel Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1167,
    "MINYAK JAGUNG (REFINED BLEACHED DEODORIZED CORN OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1168,
    "MINYAK JERUK (CITRUS OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1169,
    "MINYAK KACANG (PEANUT OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1170,
    "Minyak Kacang Macadamia (Macadamia Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1171,
    "MINYAK KACANG TANAH (REFINED BLEACHED DEODORIZED PEANUT OIL - REFINED BLEACHED DEODORIZED GROUNDNUT OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1172,
    "MINYAK KACANG WALNUT (WALNUT OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1173,
    "Minyak Kanola (Canola Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1174,
    "Minyak Kari (Curry Oil)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1175,
    "MINYAK KAYU MANIS (CINNAMON OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1176,
    "MINYAK KAYU PUTIH (EUCALYPTUS OIL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1177,
    "Lemak Reroti (Shortening)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1178,
    "Lemak Sapi (Beef Fat)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1179,
    "Lemak Susu (Fat Milk)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1180,
    "Lemak Susu Anhidrat (Anhydrous Milk Fat)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1181,
    "Lemak Susu Sapi (Cow's Milk Fat)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1182,
    "Lemak Trigliserida Rantai Sedang (MCT) (Medium Chain Triglyceride Fat)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1183,
    "Lembaga Gandum (Wheat Germ)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1184,
    "Lemon Verbena (Lippia citriodora)",
    "Bahan Baku",
    "YES",
    "NO",
    "NO",
    "YES",
  ],
  [1185, "Lempuyang", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1186, "Lempuyang Wangi ", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1187,
    "Lengkuas - Laos (Galangal)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1188,
    "Lengkuas Bubuk (Galangal Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1189,
    "Lentil (Lens Culinaris)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1190,
    "LEPTOSPERPUM CITRATEM",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [1191, "Leuconostoc citreum", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1192,
    "Leuconostoc cremoris",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1193, "Leusin (Leusin)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1194,
    "L-Glutamin (L-Glutamine)",
    "Bahan Baku",
    "YES",
    "YES",
    "NO",
    "YES",
  ],
  [
    1195,
    "LICORICE - LIQUORICE (GLYCYRRHIZA GLABRA)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    1196,
    "Licorice Root-Akar Licorice (Glycyrrhiza Uralensis)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    1197,
    "Lidah Buaya (Aloe Vera)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1198,
    "Lidah Buaya Bubuk (Aloe Vera Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1199,
    "Lidah Buaya Gel (Aloe Vera Gel)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1200,
    "LIDAH SAPI (BEEF ATAU COW ATAU OX TONGUE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1201, "Likopen (Lycopene)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1202,
    "LINGZHI (GANODERMA LUCIDUM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [1203, "LIQUEUR", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1204, "LIQUIORICE", "Bahan Baku", "NO", "NO", "YES", "NO"],
  [1205, "Lisin (Lysine)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1206,
    "Lisin Monohidrat (Lysine Monohydrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1207,
    "L-KARNITIN (L-CARNITINE)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    1208,
    "LO HAN GUO (LO HAN GUO)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [1209, "Lobak (Radish)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1210,
    "Lobak Bubuk (Radish Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1211,
    "Lobak Hijau (Turnip Greens)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1212,
    "Lobak Hijau Kering (Dried Turnip Greens)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1213,
    "Lobak Merah (Red Radish)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1214,
    "LOBI - LOBI (BATOKO PLUM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1215, "Lobster", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1216,
    "LOKIO KERING (DRIED CHIVES)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1217,
    "LOKIO-BAWANG BATAK (CHIVES)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1218, "LONICERA JAPONICA", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    1219,
    "LONTAR (LONTAR PALM ATAU BORASSUS FLABELLIFER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1220,
    "L-ORNITIN (L-ORNITHINE) (KATEGORI PANGAN 13)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1221, "L-Prolin", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1222, "L-Serin", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1223, "L-Theanine", "Bahan Baku", "NO", "NO", "YES", "YES"],
  [
    1224,
    "Lucuma (Pouteria lucuma)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1225, "LUTEIN", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [1226, "Madu (Honey)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1227,
    "Madu Agave (Agave Honey)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1228,
    "Madu Akasia (Acacia Honey)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1229,
    "Madu Bubuk (Honey Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1230,
    "MADU HUTAN (FOREST HONEY)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1231,
    "Madu Kelengkeng (Longan Honey)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1232,
    "MADU RANDU (KAPOK HONEY)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1233,
    "Madu Sarang (Comb Honey) (Khusus Madu)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1234,
    "MAGNESIUM ASETAT (MAGNESIUM ACETATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1235,
    "Magnesium hidrogen fosfat (Magnesium hydrogen phosphate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1236,
    "Magnesium hidroksida (Magnesium hydroxide)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1237,
    "MAGNESIUM KARBONAT (MAGNESIUM CARBONATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1238, "Magnesium Kaseinat", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1239,
    "magnesium klorida (magnesium chloride)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1240,
    "Magnesium laktat (Magnesium lactate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1241,
    "Magnesium L-Aspartat (Magnesium L-Aspartate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1242,
    "MAGNESIUM OKSIDA (MAGNESIUM OXIDE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1243, "Magnesium Sulfat", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1244, "MAIZENA (CORNSTARCH)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [1245, "Makaroni (Macaroni)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1246, "MALT (BARLEY MALT)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [1247, "Malt (Malt)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1248,
    "Malt Barley (Barley Malt)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1249,
    "Malt Bubuk (Malt Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1250,
    "Malto Oligosakarida (Malto Oligosaccharide)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1251,
    "Kubis Brussel (Brussels Sprouts)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1252,
    "KUCAI (GARLIC CHIVES)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1253,
    "KUCAI KERING (DRIED GARLIC CHIVES)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1254,
    "KUE BROWNIES (BROWNIE CAKE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1255, "KUE BUSA (MERINGUE)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1256,
    "Kue Ikan (Fish Cake)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1257, "KUKIS (COOKIES)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1258,
    "Kulit Ayam (Chicken Skin)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1259,
    "Kulit Babi (Pork Rind)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1260,
    "Kulit Bergamot (Bergamot Peels)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1261,
    "KULIT BIJI PALA (NUTMEG MACE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1262, "Kulit Buah Manggis", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    1263,
    "Kulit Domba (Sheepskin)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1264,
    "Kulit Gandum (Wheat Bran)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1265,
    "KULIT IKAN PATIN (PANGASIUS SKIN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1266,
    "Kulit Ikan Salmon (Salmon Skin)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1267,
    "Kulit Ikan Tenggiri (Mackerel Skin)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1268,
    "Kulit Jagung (Corn Bran)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1269,
    "Kulit Jeruk (Orange Peel)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1270, "KULIT JERUK ........", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    1271,
    "Kulit Jeruk Bubuk (Orange Peel Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1272,
    "Kulit Jeruk Lemon (Orange Peels)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1273,
    "KULIT JERUK MANDARIN (MANDARIN ORANGE PEELS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1274,
    "KULIT JERUK NIPIS (LIME PEELS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1275,
    "Kulit Kebab/Tortilla",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1276,
    "Kulit Lumpia (Spring Roll Skin)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1277,
    "Kulit Oats Bubuk (Oats Bran Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1278,
    "Kulit Pangsit (Dumpling Skin)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1279,
    "KULIT POHON PINUS EKSTRAK (PINE BARK EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [1280, "Kulit Sapi", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1281,
    "KULIT SIOMAY (DUMPLING WRAPPER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1282,
    "KULIT TAHU (GOHYONG, BEAN CURD SHEET, BEAN CURD ROBES, BEAN CURD SKIN, TOFU SKIN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1283,
    "KULIT TELUR (EGGSHELL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1284,
    "KULTUR BAKTERI (BACTERIAL CULTURE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1285,
    "KULTUR BAKTERI ASAM LAKTAT (LACTIC ACID BACTERIAL CULTURE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1286,
    "KULTUR STARTER (STARTER CULTURE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1287,
    "KUNING TELUR (EGG YOLK)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    1288,
    "KUNING TELUR ASIN (SALTED EGG YOLK)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    1289,
    "KUNING TELUR BUBUK (EGG YOLK POWDER)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [1290, "KUNYIT (TURMERIC)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    1291,
    "KUNYIT (TURMERIC-CURCUMA LONGA RHIZOME)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1292,
    "KUNYIT ASAM (TURMERIC AND TAMARIND)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    1293,
    "Kunyit Bubuk (Turmeric Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1294,
    "KUPANG KERING (DRY GREENSHELL MUSSELS",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1295, "Kurma (Dates)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1296,
    "Kurma Bubuk (Dates Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1297,
    "Kurma Merah (Red Dates)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1298,
    "L - GLUTATION (L - GLUTATHIONE)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [1299, "Labu (Pumpkin)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1300,
    "Labu Bubuk (Pumpkin Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1301, "LABU KUNING", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [1302, "LABU SIAM (CHAYOTE)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1303,
    "LACTOBACILLUS ACIDOPHILUS",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1304,
    "Lactobacillus bulgaricus",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1305, "Lactobacillus casei", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1306,
    "Lactobacillus Fermentum",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1307,
    "Lactobacillus helveticus ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1308,
    "Lactobacillus kefiri ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1309,
    "Lactobacillus lactis subsp. cremoris",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1310,
    "LACTOBACILLUS LACTIS SUBSP. LACTIS",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1311,
    "LACTOBACILLUS PARACASEI",
    "Bahan Baku",
    "YES",
    "YES",
    "NO",
    "YES",
  ],
  [
    1312,
    "Lactobacillus Plantarum",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1313,
    "Lactobacillus Reuteri",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1314,
    "LACTOBACILLUS RHAMNOSUS LGG (L+)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1315,
    "Lactobacillus rhamnosus NCC 4007",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1316, "Lactococcus lactis", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1317, "LADA (PEPPER)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1318,
    "LADA HIJAU (GREEN PEPPERCORN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1319,
    "KRIMER NABATI (NON DAIRY CREAMER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1320,
    "KRISANTEMUM (CHRYSANTHEMUM)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "NO",
  ],
  [
    1321,
    "KRISANTEMUM BUBUK (CHRYSANTEMUM POWDER) ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [1322, "KRIMER (CREAMER)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    1323,
    "Krimer Kental Manis (Sweetened Condensed Creamer)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1324,
    "KRIMER MINUMAN (NON DAIRY CREAMER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1325,
    "Krim Nabati Bubuk (Vegetable Cream Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1326,
    "Krim Pasteurisasi (Pasteurized Cream)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1327,
    "KRIM RASA VANILA (VANILLA CREAM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1328,
    "KRIM SAYUR (VEGETABLE CREAM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1329,
    "Krim Stroberi (Strawberry Cream)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1330,
    "KRIM SUSU (MILK CREAM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1331,
    "Krim Susu Bubuk (Milk Cream Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1332,
    "Krim Tiramisu (Tiramisu Cream)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1333,
    "Kopi Robusta (Robusta Coffee)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1334, "Kopra (Copra)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1335,
    "KORIANDER BUBUK (CORIANDER POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1336,
    "Koro Pedang (Jack Bean)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1337,
    "Kranberi (Cranberry)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1338,
    "Kranberi Kering (Dried Cranberry)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1339,
    "Kratom (Mitragyna speciosa)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1340,
    "KREATIN MONOHIDRAT (CREATINE MONOHYDRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [1341, "KRECEK (KRECHEK)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1342,
    "Krekers Beras (Rice Crackers)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1343,
    "Krill Oil (Eupausia Superba)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1344, "Krim (Cream)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1345,
    "Krim Asam (Sour Cream)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1346,
    "Krim Bubuk (Cream Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1347,
    "Krim Kacang Hazel (Hazelnut Cream)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1348,
    "KRIM KAPUCINO (CAPPUCCINO CREAM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1349,
    "Krim Karamel (Caramel Cream)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1350,
    "Krim Kelapa (Coconut Cream)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1351,
    "Krim Kopi (Coffee Cream)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1352,
    "Krim Nabati (Vegetable Cream) ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1353, "Kopi (Coffee)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1354,
    "KOPI ARABIKA (ARABICA COFFEE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1355,
    "Kopi Bubuk (Coffee Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1356,
    "Kopi Bubuk Instan (Instant Coffee Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1357,
    "Kopi Pasta (Coffee Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1358,
    "Kari Bubuk (Curry Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1359, "Kasein (Casein)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1360,
    "Kayu Manis (Cinnamon)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1361,
    "Konsentrat Buah Blueberry (Blueberry Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1362,
    "KONSENTRAT BUAH ELDERBERRY (ELDERBERRY CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1363,
    "KONSENTRAT BUNGA ELDERBERI (ELDERFLOWER CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1364,
    "KONSENTRAT CAMPURAN SARI BUAH (MIXTURE OF FRUIT JUICE CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1365,
    "KONSENTRAT COCOPANDAN (COCOPANDAN CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1366,
    "KONSENTRAT COKELAT SUSU (MILK CHOCOLATE CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1367,
    "KONSENTRAT COLA (COLA CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1368,
    "KONSENTRAT DAUN ASAM MUDA (TAMARIND LEAVES CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1369,
    "Konsentrat Daun Mint (Mint Leaves Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1370,
    "KONSENTRAT DAUN PANDAN (PANDAN LEAVES CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1371,
    "KONSENTRAT DAUN TEH (TEA LEAVES CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1372,
    "Konsentrat Gula Tebu (Sugar Cane Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1373,
    "Konsentrat Jahe (Ginger Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1374,
    "Konsentrat Jeruk (Orange Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1375,
    "Keju Bubuk (Cheese Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1376,
    "Keju Cheddar (Cheddar Cheese)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1377,
    "Keju Edam (Edam Cheese)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1378,
    "Keju Feta (Feta Cheese)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1379,
    "Keju Gouda (Gouda Cheese)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1380,
    "Keju Grana Padano (Grana Padano Cheese)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1381,
    "Keju Krim (Cream Cheese)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1382,
    "Keju Mascarpone (Mascarpone Cheese)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1383,
    "Keju Mozzarella (Mozzarella Cheese)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1384,
    "Keju Myzithra (Mizithra Cheese)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1385,
    "Keju Parmesan (Parmesan Cheese)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1386,
    "Keju Pecorino (Pecorino Cheese)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1387,
    "Keju Pecorino Romano (Pecorino Romano Cheese)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1388,
    "Keju Ricota (Richotta Cheese)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1389,
    "KAYU SECANG (SAPPAN WOOD - CAESALPINIAE SAPPANIS LIGNUM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1390,
    "Kayumanis-Keningar Bubuk (Cinnamon Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1391, "Kecap (Soy Sauce)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1392,
    "KECAP ASIN (SALTY SOY SAUCE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1393,
    "Kecap Bubuk (Soy Sauce Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1394,
    "Kecap Ikan (Fish Sauce)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1395,
    "Kecap Inggris (Worcestershire Sauce)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1396,
    "KECAP KEDELAI MANIS (SWEET SOY SAUCE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1397, "Kedelai", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    1398,
    "KEDONDONG (AMBARELLA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1399, "Kefir (Keffir)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1400,
    "Konsentrat Kacang Kedelai (Soybean Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1401,
    "Konsentrat Kacang Merah (Red Beans Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1402,
    "KONSENTRAT KELAPA KOPYOR (KOPYOR CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1403,
    "Konsentrat Kepiting (Crab Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1404,
    "Konsentrat Kopi (Coffee Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1405,
    "KONSENTRAT LECI (LYCHEES CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1406,
    "Konsentrat Lemon (Lemon Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1407,
    "Konsentrat Lidah Buaya (Aloe Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1408,
    "Konsentrat Lobak Merah (Red Radish Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1409,
    "Konsentrat Loofah (Loofah Concentrate) (Kecuali Pangan Untuk Keperluan Gizi Khusus)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1410,
    "Konsentrat Madu (Honey Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1411,
    "Konsentrat Mangga (Mango Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1412,
    "Konsentrat Mentimun (Cucumber Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1413,
    "Konsentrat Nanas (Pineapple Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1414,
    "Konsentrat Peppermint (Peppermint Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1415,
    "Konsentrat Pir (Pears Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1416,
    "Konsentrat Protein Kedelai (Soy Protein Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1417,
    "Konsentrat Protein Susu (Milk Protein Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1418,
    "KONSENTRAT PROTEIN WHEY (WHEY PROTEIN CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1419,
    "Konsentrat Santan (Coconut Milk Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1420,
    "Konsentrat Sari Buah Acai Berry (Acai Berry Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1421,
    "Konsentrat Sari Buah Anggur (Grape Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1422,
    "Konsentrat Sari Buah Anggur Merah (Red Grape Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1423,
    "Konsentrat Sari Buah Apel (Apple Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1424,
    "Konsentrat Sari Buah Aprikot (Apricots Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1425,
    "KONSENTRAT SARI BUAH ARONIA BERRY (ARONIABERRY JUICE CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1426,
    "Konsentrat Sari Buah Bit (Bit Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1427,
    "Konsentrat Sari Buah Bit Merah (Red Bit Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1428,
    "Konsentrat Sari Buah Blackberry (Blackberry Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1429,
    "Konsentrat Sari Buah Blackcurrant (Blackcurrant Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1430,
    "Konsentrat Sari Buah Blueberry (Blueberry Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1431,
    "KONSENTRAT SARI BUAH CAMPURAN (MIXED FRUIT JUICE CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1432,
    "Konsentrat Sari Buah Ceri (Cherry Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1433,
    "Konsentrat Sari Buah Delima (Pomegranate Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1434,
    "Konsentrat Sari Buah Durian (Durian Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1435,
    "KONSENTRAT SARI BUAH ELDERBERRY (ELDERBERRY JUICE CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1436,
    "KONSENTRAT SARI BUAH GOJI BERRY (GOJI BERRY JUICE CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1437,
    "KONSENTRAT SARI BUAH JAMBU MERAH (GUAVA JUICE CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1438,
    "KONSENTRAT SARI BUAH JERUK (ORANGE JUICE CONCENTRATE)",
    "Bahan Baku",
    "YES",
    "NO",
    "NO",
    "YES",
  ],
  [
    1439,
    "Konsentrat Sari Buah Jeruk Bali Merah (grapefruit juice concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1440,
    "Konsentrat Sari Buah Jeruk Florida (Florida Orange Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1441,
    "KONSENTRAT SARI BUAH JERUK NIPIS (LIME JUICE CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1442,
    "Konsentrat Sari Buah Kawista (Kawista Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1443,
    "Konsentrat Sari Buah Kiwi (Kiwi Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1444,
    "KONSENTRAT SARI BUAH KRANBERI (CRANBERRY JUICE CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1445,
    "KONSENTRAT SARI BUAH KURMA (DATES JUICE CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1446,
    "KONSENTRAT SARI BUAH LABU AIR (CALABASH JUICE CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1447,
    "KONSENTRAT SARI BUAH LECI (LYCHEE JUICE CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1448,
    "Konsentrat Sari Buah Leci (Lychees Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1449,
    "Konsentrat Sari Buah Lemon (Lemon Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1450,
    "Konsentrat Sari Buah Mangga (Mango Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1451,
    "Konsentrat Sari Buah Markisa (Passion Fruit Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1452,
    "Konsentrat Sari Buah Melon (Honeydew Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1453,
    "Konsentrat Sari Buah Merah (Red Fruit Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1454,
    "Konsentrat Sari Buah Nanas (Pineapple Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1455,
    "Konsentrat Sari Buah Nangka (Jackfruit Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1456,
    "Konsentrat Sari Buah Pepaya (Papaya Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1457,
    "KONSENTRAT SARI BUAH PERSIK (PEACH JUICE CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1458,
    "KONSENTRAT SARI BUAH PIR (PEAR JUICE CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1459,
    "Konsentrat Sari Buah Pisang (Banana Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1460,
    "Konsentrat Sari Buah Plum (Plum Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1461,
    "Konsentrat Sari Buah Prune (Prune Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1462,
    "Konsentrat Sari Buah Quince (Quince Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1463,
    "Konsentrat Sari Buah Raspberry (Raspberry Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1464,
    "Konsentrat Sari Buah Redcurrant (Redcurrant Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1465,
    "KONSENTRAT SARI BUAH SALAK (SNAKE FRUIT JUICE CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1466,
    "Konsentrat Sari Buah Semangka (Watermelon Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1467,
    "Konsentrat Sari Buah Sirsak (Soursop Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1468,
    "KONSENTRAT SARI BUAH STROBERI (STRAWBERRY JUICE CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1469,
    "KONSENTRAT SARI BUAH TOMAT (TOMATO JUICE CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1470,
    "Konsentrat Sari Kelapa (Coconut Juice Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1471,
    "konsentrat sayur .....",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1472,
    "Konsentrat Spirulina (Spirulina Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1473,
    "KONSENTRAT SUSU (MILK CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1474,
    "Konsentrat Talas (Taro Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1475,
    "KONSENTRAT VANILA (VANILLA CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1476,
    "KONSENTRAT WHEY PROTEIN (WHEY PROTEIN CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1477,
    "Konsentrat Wortel (Carrot Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1478,
    "KONSENTRAT WORTEL UNGU/WORTEL HITAM (PURPLE/BLACK CARROT CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1479,
    "Keju Romano (Romano Cheese)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1480, "KEJU WHEY", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    1481,
    "KELABAT (FENUGREEK)(HALBA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1482,
    "Kelabat Bubuk (Fenugreek Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1483,
    "Keladi - Talas (Taro-Caladium)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1484, "Kelapa (Coconut)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1485,
    "Kelapa Bubuk (Coconut Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1486,
    "Kelapa Kering (Dried Coconut)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1487,
    "Kelapa Muda (Young Coconut)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1488,
    "Kelapa Parut (Desiccated Coconut)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1489,
    "Kelapa Parut Kering (Dried Desiccated Coconut)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1490, "Kelapa Sawit (Palm)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1491, "Kelengkeng (Longan)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1492,
    "Kelp Bubuk (Kelp Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1493, "Kemangi (Basil)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1494,
    "Kembang Kol (Cauliflower)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1495,
    "KEMBANG PALA (MYRISTICA FRAGRAN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1496,
    "KEMBANG SEPATU (HIBISCUS ROSA SINENSIS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1497,
    "Kembang Tahu (Beancurd)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1498, "KEMIRI (CANDLENUT)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1499,
    "KEMIRI BUBUK (CANDLENUT POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1500,
    "KENCUR ( KAEMPFERIA GALANGA )",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1501, "Kenikir (Marigolds)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1502, "KENTANG", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [1503, "Kentang (Potato)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1504,
    "Kentang Bubuk (Potato Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1505,
    "Kentang Kering (Dried Potatoes)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1506,
    "Kentang Merah (Red Potato)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1507,
    "Kentang Panggang Bubuk (Roasted Potato Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1508, "Keong (Snail)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1509, "Kepah (Mussel)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1510, "Kepiting (Crab)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1511, "Kerang (Scallops)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1512,
    "Kerang Bubuk (Scallops Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1513,
    "Keripik Pisang (Banana Chips)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1514,
    "Keripik Singkong (Cassava Chips)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1515, "KERTAS BERAS", "Bahan Baku", "YES", "YES", "NO", "YES"],
  [1516, "Kerupuk", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1517,
    "Kerupuk Beras (Rice Crackers)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1518, "Kerupuk Ikan", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1519,
    "KERUPUK KEPITING ( CRAB CHIPS )",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1520,
    "Kerupuk Udang (Prawn Crackers)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1521, "Ketam (Crab)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1522,
    "Ketan Hitam (Black Sticky Rice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1523,
    "KETUMBAR (CORIANDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1524,
    "Ketumbar Bubuk (Coriander Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1525, "Kimchi (Kimchi)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1526,
    "Kimchi Kering (Kimchi Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1527, "KININ (KININE)", "Bahan Baku", "NO", "NO", "YES", "YES"],
  [1528, "Kismis (Raisin)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1529,
    "Kismis Merah (Red Raisin)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1530, "Kitosan (Chitosan)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1531, "Kiwi (Kiwi)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1532,
    "KLEMBAK (RHEUM OFFICINALE)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    1533,
    "KLOROFIL (CHLOROPHYL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [1534, "Kluwek-Keluwek", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1535, "KOJI", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1536,
    "KOJI (SWEET POTATO KOJI)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "NO",
  ],
  [
    1537,
    "KOJI BERAS (RICE KOJI)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "NO",
  ],
  [
    1538,
    "Kol - Kubis (Cabbage)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1539,
    "Kol - Kubis Kering (Dried Cabbage)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1540, "Kolagen (Collagen)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1541,
    "KOLANG KALING ( BUAH ATAP, SUGAR PALM FRUIT )",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1542,
    "KOLEKALSIFEROL (VIT D3)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1543, "Kolin (Choline)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1544,
    "Kolin Bitartrat (Choline Bitartrat)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1545,
    "Kolin Klorida (Choline Chloride)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1546,
    "Kolostrum Bubuk (Colostrum Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1547,
    "KONDROITIN (CHONDROITIN)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    1548,
    "KONDROITIN SULFAT (CHONDROITIN SULFATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [1549, "Konsentrat acerola", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1550,
    "Konsentrat Agave (Agave Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1551,
    "Konsentrat Air Kelapa (Coconut Water Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1552,
    "Konsentrat Akar Bunga Balon (Balloon Flower Root Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    1553,
    "KONSENTRAT ANGGUR MERAH (RED GRAPE CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1554,
    "KONSENTRAT APEL (APPLE CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1555,
    "KONSENTRAT ARONIA BERRY (CHOKEBERRY CONCENTRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1556,
    "Konsentrat Asam Jawa (Tamarind Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1557,
    "Konsentrat Bawang Putih (Garlic Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1558,
    "Konsentrat Blewah (Cantaloupe Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1559,
    "KONSENTRAT BUAH ......",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1560,
    "Konsentrat Buah Anggur (Grape Concentrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1561, "Karamel (Caramel)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1562,
    "Karamel Bubuk (Caramel Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1563,
    "KARAMEL CAIR (LIQUID CARAMEL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1564,
    "Karagenan (Caragenan)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1565,
    "DEKSTROSA MONOHIDRAT (DEXTROSE MONOHYDRATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1566,
    "EKSTRAK BUNGA CHAMOMILE (CHAMOMILE FLOS EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1567,
    "EKSTRAK BUNGA ELDER (ELDER FLOS EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1568,
    "Ekstrak Bunga Jeruk (Orange Flos Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1569,
    "EKSTRAK BUNGA KRISAN (CHRYSANTHEMUM EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1570,
    "EKSTRAK BUNGA MAWAR (ROSE FLOS EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1571,
    "EKSTRAK BUNGA SAFFLOWER (CARTHAMUS TINCTORIUS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1572,
    "Ekstrak Cabe (Chili Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1573,
    "Ekstrak Campuran Buah Beri (Mixberry Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1574,
    "Ekstrak Chicory (Chicory Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1575,
    "Ekstrak Cincau (Grass Jelly Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1576, "EKSTRAK COCOPANDAN", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [1577, "Kalium Hidroksida", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1578,
    "KALIUM IODIDA (POTASSIUM IODIDA-KIO3)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1579,
    "Kalium Karbonat (Potassium carbonate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1580,
    "Kalium Kaseinat (Potassium Caseinate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1581,
    "KALIUM KLORIDA (POTASSIUM CHLORIDE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1582, "Kalium Sitrat", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1583,
    "KALSIUM DARI GANGGANG LAUT (CALCAREOUS MARINE ALGAE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1584,
    "Kalsium Gliserofosfat (Calcium Glycerophosphate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1585,
    "Kalsium Hidrogen Fosfat Anhidrat (Calsium Hydrogen Phosphate Anhydrous)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1586, "Kalsium hidroksida", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1587, "KALSIUM KARBONAT", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1588,
    "Kalsium Kaseinat (Calcium caseinate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1589, "Kalsium Klorida", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1590,
    "Kalsium L-5-metil tetrahidrofolat (Calcium L-5- methyl tetrahydrofolate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1591,
    "Kalsium Laktat (Calcium Laktate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1592,
    "Kalsium Natrium Kaseinat (Calcium Sodium Caseinate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1593,
    "KALSIUM PANTOTENAT (CALCIUM PANTOTHENATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1594,
    "KALSIUM PANTOTENAT (VIT B5)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1595,
    "Kalsium Pidolat (Calcium Pidolate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1596,
    "Kalsium Susu (Milk Calcium)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1597, "Kalsium Tulang Ikan", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1598,
    "KALSIUM-D-PANTOTENAT (CALCIUM-D-PANTOTHENATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [1599, "Kamaboko", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1600, "Kangkung", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1601, "Kapulaga (Cardamon)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1602,
    "Kapulaga Bubuk (Cardamon Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1603,
    "DHA (dari Minyak Ikan)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1604,
    "DHA (dari Minyak Sel Tunggal)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1605,
    "DHA (DOCOSAHEXAENOIC ACID )",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1606,
    "DIKALIUM FOSFAT (DIPOTASSIUM PHOSPHATE-DIPOTASSIUM ORTHOPHOSPHATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1607,
    "DI-KALIUM HIDROGEN FOSFAT (DI-POTASSIUM HYDOGEN PHOSPAT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1608,
    "DIKALSIUM FOSFAT (KALSIUM HIDROGEN FOSFAT, KALSIUM MONOHIDROGEN FOSFAT, KALSIUM HIDROGEN ORTOFOSFAT))",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1609,
    "Cabe Jalapeno (Jalapeno Chili)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1610,
    "CABE JALAPENO BUBUK (JALAPENO POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1611,
    "CABE JAWA (JAVANESE LONG PEPPER, PIPER RETROFRACTUM VAHL.)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1612,
    "Cabe Kering (Dried Chili)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1613,
    "Cabe Kuning (Yellow Chili)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1614,
    "Cabe Hijau (Green Chili)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1615,
    "Cabe Hijau Bubuk (Green Chili Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1616,
    "Cabe Habanero (Habanero Chili)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1617,
    "Buttermilk (Buttermilk)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1618,
    "Buttermilk Bubuk (Buttermilk Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1619, "Cabe (Chili)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1620,
    "Cabe Bubuk (Chili Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1621,
    "BUNGA JAGUNG (CORN FLOWER - CENTAURA CYANUS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1622,
    "BUNGA JERUK CITRUS AURANTIUM (FLOWERS ORANGE CITRUS AURANTIUM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1623,
    "BUNGA JERUK CITRUS AURANTIUM-JERUK NIPIS (ORANGE BLOSSOMS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1624,
    "Bunga Lavender (Lavandula angustifolia)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1625, "BUNGA MATAHARI", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    1626,
    "Bunga Matahari (Sunflower)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1627,
    "BUNGA MAWAR ROSA CHINENSIS (ROSE BLOSSOMS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1628,
    "BUNGA MAWAR-ROSE BLOSSOM (ROSA CHINENSIS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1629,
    "Bunga Osmanthus Kering (Dried Osmanthus Flower) (Kecuali Pangan Untuk Keperluan Gizi Khusus)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1630, "Bunga Pala", "Bahan Baku", "NO", "YES", "NO", "YES"],
  [1631, "BUNGA SAFFLOWER", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [1632, "BUNGA SAKURA", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    1633,
    "Bunga Scarlet Bee Balm (Monarda didyma L)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1634,
    "Bunga Sedap Malam (Lily Flower)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1635,
    "Bunga Telang (Clitoria Ternatea)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1636, "bunga teratai", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    1637,
    "Buntut Sapi (Oxtail)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1638, "BURDOCK ROOT", "Bahan Baku", "NO", "NO", "YES", "NO"],
  [
    1639,
    "Ekstrak Wasabi (Wasabi Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1640,
    "Ekstrak Wildberry (Wildberry Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1641,
    "EKSTRAK WOLFBERRY (WOLFBERRY EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1642,
    "Ekstrak Wortel (Carrot Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1643,
    "EKSTRAK WORTEL UNGU/WORTEL HITAM (PURPLE/BLACK CARROTS EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1644,
    "Ekstrak Zizania latifolia (Kecuali Pangan Untuk Keperluan Gizi Khusus)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    1645,
    "ELDERBERRY (SAMBUCUS EBULUS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1646,
    "ELDERBERRY (SAMBUCUS NIGRA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1647, "EMPING BARLEY ", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1648,
    "EMPING JAGUNG (CORN FLAKES)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1649,
    "EMPING MELINJO - GNETUM GNEMON ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1650,
    "ENZIM AMILASE (AMILASE ENZYME)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1651,
    "Enzim Beta - Fruktofuranosidase ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1652,
    "ENZIM BROMELAIN (BROMELAINE ENZYME)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1653,
    "Enzim Glucoamylase dari Aspergillus niger (Glucoamylase from Aspergillus niger)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1654,
    "ENZIM LAKTASE (LACTASE ENZYME)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1655,
    "Enzim Laktoperoksidase (Lactoperoxidase Enzyme)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1656,
    "ENZIM LIPASE (LIPASE ENZYME)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1657,
    "ENZIM PAPAIN (PAPAIN ENZYME)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1658,
    "ENZIM PROTEASE (PROTEASE ENZYME)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1659,
    "Enzim Transglutaminase",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1660,
    "EPA (EICOSAPENTAENOIC ACID)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1661, "Es (Ice)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1662, "Es Batu (Ice Cube)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1663, "Es Susu (Milk Ice)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1664, "Ester Sterol", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1665, "EUCOMMIA ULMOIDES", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    1666,
    "Feijoa / Pineapple Guava (Acca sellowiana)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1667,
    "Fenilalanin (Phenilalanin)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1668,
    "FITOMENADION (VIT K1)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1669,
    "FITOSTANOL (PHYTOSTANOL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1670,
    "Fitosterol (Phytosterol)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1671, "FONDAN (FONDANT)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1672,
    "Fosfolipid (Phospholipids)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1673,
    "FRUKTO OLIGOSAKARIDA (FOS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1674, "Fruktosa (Fructose)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1675,
    "GABAH PADI (RICE GRAIN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1676,
    "Galakto Oligosakarida (GOS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1677, "GAMA KAROTEN", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1678,
    "Gambir (Uncaria gambir)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1679,
    "Gamma Aminobutyric Acid (GABA) (Untuk Minuman Teh)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [1680, "Gandum (Wheat)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1681,
    "GANDUM DURUM SEMOLINA (DURUM SEMOLINA WHEAT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1682, "GANDUM HITAM (RYE)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1683,
    "GANDUM MALT (WHEAT MALT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1684,
    "Gandum Merah (Red Wheat)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1685,
    "Gandum Panggang (Roasted Wheat)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1686,
    "Gandum Semolina (Semolina Wheat)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1687,
    "Gandum Serpihan (Wheat Flakes)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1688,
    "Gandum Utuh (Whole Wheat)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1689,
    "Ganggang Laut (Sea Algae)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1690,
    "GANGLIOSIDA (GANGLIOSIDE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [1691, "Garam (Salt)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1692,
    "GARAM BERIODIUM (IODIZED SALT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1693,
    "Garam Halus (Refined Salt)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1694,
    "Garam Hitam (Black Salt)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1695,
    "Garam Inggris (Epsom Salt)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1696,
    "Garam Laut (Sea Salt)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1697,
    "GARAM RAFINASI (REFINED SALT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [1698, "GARCINIA CAMBOGIA", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [1699, "GARDENIA BLUE", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [1700, "GELATIN (GELATINE)", "Bahan Baku", "YES", "NO", "NO", "YES"],
  [1701, "Gembili", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1702,
    "GENMAICHA (ROASTED RICE TEA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1703, "GIN (GIN)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1704, "GINKGO BILOBA", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [1705, "GLISERIN", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    1706,
    "Iodium (Kalium Iodat - KIO3)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1707,
    "Isian berbasis susu",
    "Bahan Baku",
    "YES",
    "YES",
    "NO",
    "YES",
  ],
  [
    1708,
    "Isolat Protein Kedelai (Soy Protein Isolate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1709,
    "ISOLAT PROTEIN NABATI (VEGETABLE PROTEIN ISOLATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1710, "Isolat Protein Pea", "Bahan Baku", "NO", "NO", "YES", "YES"],
  [
    1711,
    "Isolat Protein Pea (Pea Protein Isolate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1712,
    "ISOLAT PROTEIN SUSU (MILK PROTEIN ISOLATE)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    1713,
    "ISOLAT PROTEIN WHEY (WHEY PROTEIN ISOLATE)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    1714,
    "Isoleusin (Isoleucine)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1715,
    "ISOMALTO OLIGOSAKARIDA (ISOMALTOOLIGOSACCHARIDE)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    1716,
    "Isomaltodekstrin (IMD)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1717,
    "Isomaltulosa (Isomaltulose)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1718, "Jagung", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [1719, "Jagung (Corn)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1720,
    "JAGUNG BAKAR (ROASTED CORN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1721,
    "Jagung Bakar Bubuk (Roasted Corn Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1722,
    "Jagung Berondong (Pop Corn)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1723,
    "Jagung Butiran (Corn Grain)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1724,
    "Jagung Kering (Dried Corn)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1725,
    "Jagung Kernel Utuh (Whole Kernel Corn)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1726,
    "Jagung Manis (Sweet Corn)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1727,
    "Jagung Manis Bubuk (Sweet Corn Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1728,
    "Jagung Muda (Baby Corn)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1729,
    "JAGUNG SEMOLINA (MAIZE SEMOLINA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1730,
    "Jagung Serpihan (Corn Flakes)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1731, "Jahe (Ginger)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1732,
    "Jahe Bubuk (Ginger Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1733,
    "Jahe Giling (Milled Ginger)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1734,
    "Jahe Kering (Dried Ginger)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1735,
    "JAHE MERAH- ZINGIBER OFFICINALE VAR RUBRU (RED GINGER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1736,
    "JALI (COIX LACRYMA-JOBI)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1737,
    "JAMBU AIR (ROSE APPLE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1738, "Jambu Biji (Guava)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1739,
    "Jambu Biji Bubuk (Guava Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1740, "Jambu Mete (Cashew)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1741, "Jamur (Mushroom)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1742,
    "Jamur Boletes Kuning",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1743,
    "Jamur Bubuk (Mushroom Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1744,
    "Jamur Geotrichum candidum",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1745,
    "Jamur Kancing (Champignon)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1746,
    "Jamur Kering (Dried Mushroom)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1747,
    "Jamur Kuping (Auricularia auricula)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1748,
    "JAMUR KUPING HITAM (AURICULARIA POLYTRICHA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1749,
    "JAMUR MADU (ARMILLARIA OSTOYAE, HONEY MUSHROOM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1750,
    "JAMUR MERAH BUBUK (RED MUSHROOM POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1751,
    "Jamur Merang (Volvariella volvacea)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1752,
    "JAMUR MESHAMA- JAMUR SANGHWANG, MESHIMAKOBU; SONG GEN (PHELLINUS LINTEUS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1753,
    "JAMUR SALJU - ENOKITAKE (FLAMMULINA VELUTIPES)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1754,
    "JAMUR SANGHWANG (PHELLINUS LINTEUS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1755,
    "JAMUR SHIITAKE (LENTINULA EDODES)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1756,
    "Jamur Shiitake Bubuk (Shiitake Mushroom Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1757, "Jamur Tempe", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1758,
    "JAMUR TEROMPET - JAMUR SARANG BURUNG",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1759,
    "Jamur Tiram (Pleurotus ostreatus)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1760,
    "Jantung Pisang (Banana Heart)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1761,
    "Jantung Sapi (Beef Heart)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1762, "Jeli (Jelly)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1763,
    "Jeli Bubuk (Jelly Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1764, "JENGKOL (DJENKOL)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1765, "Jeruk (Orange)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1766,
    "Jeruk Asam-Pahit (Seville Orange)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1767,
    "Jeruk Bali (Grapefruit- Pomelo)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1768,
    "JERUK BALI MERAH (GRAPEFRUIT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1769,
    "JERUK BERGAMOT (CITRUS BERGAMIA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1770,
    "Jeruk Besar (Grapefruit- Pomelo)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1771,
    "Jeruk Bubuk (orange powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1772,
    "Jeruk Citron-Jeruk Sukade (Citrus medica)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1773,
    "JERUK KEPROK (CITRUS RETICULATA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1774,
    "Jeruk Kunci (Key Lime)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1775,
    "JERUK LEMON (CITRUS LIMON)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1776,
    "Jeruk Lemon Bubuk (Lemon Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1777,
    "JERUK LIMAU (CITRUS AMBLYCARPA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1778,
    "Jeruk Mandarin (Mandarin Orange)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1779,
    "JERUK NIPIS (CITRUS AURANTIFOLIA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1780,
    "Jeruk Nipis Bubuk (Lime Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1781,
    "JERUK PURUT (KAFFIR LIME - CITRUS HYSTRIX)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1782,
    "JERUK TANGERINE (CITRUS TANGERINA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1783,
    "JINTAN HITAM (NIGELLA SATIVA)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    1784,
    "JINTAN-JINTEN (CARAWAY)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1785,
    "JINTAN-JINTEN BUBUK (CARAWAY POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1786,
    "JINTAN-JINTEN HITAM (HABBATUSSAUDA)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    1787,
    "JINTAN-JINTEN MANIS (ANISE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1788,
    "JINTAN-JINTEN PUTIH-CUNICUM CYMINUM (CUMIN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1789, "JUNIPER BERRIES", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1790,
    "Kacang Alas/ Biji Sengon",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1791,
    "KACANG ALMOND (ALMOND)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1792,
    "KACANG ARAB - GARBANZO (CHICKPEA - CICER ARIETINUM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1793, "Kacang Atom ", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1794,
    "KACANG AZUKI - KACANG MERAH KECIL - KACANG TOLO MERAH (AZUKI BEANS) ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1795,
    "Kacang Blackeye (Blackeye Beans)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1796,
    "KACANG BOGOR (BAMBARA GROUNDNUTS - VIGNA SUBTERRANEA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1797,
    "Kacang Brazil (Brazil Nut)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1798,
    "KACANG BUNCIS (COMMON BEAN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1799,
    "KACANG DAL (DHAL PEANUTS) ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1800,
    "KACANG DAL URAD (DHAL URAD PEANUTS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1801,
    "Kacang Flageolet (Flageolet Bean)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1802,
    "KACANG GARBANZO (GARBANZO BEANS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1803,
    "KACANG GINKGO (GINKGO NUTS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1804,
    "Kacang Gude (Pigeon Pea)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1805,
    "Kacang Hazel (Hazelnut)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1806,
    "Kacang Hazel Panggang (Roasted Hazelnut)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1807,
    "KACANG HIJAU (MUNG BEAN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1808,
    "KACANG HIJAU BUBUK (MUNG BEAN POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1809,
    "KACANG HIJAU TANPA KULIT (SPLIT MUNG BEANS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1810, "KACANG HITAM", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1811, "KACANG KAPRI (PEAS)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1812,
    "KACANG KASTANYE (CHESTNUTS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1813,
    "Kacang Kedelai (Soybean)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1814,
    "Kacang Kedelai Bubuk (Soybean Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1815,
    "KACANG KEDELAI HITAM (BLACK SOYBEAN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1816,
    "Kacang Kedelai Hitam Bubuk (Black Soybean Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1817,
    "Kacang Kedelai Muda (Edamame)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1818,
    "KACANG KENARI (WALNUTS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1819,
    "Kacang Koro (Broad Bean) ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1820,
    "KACANG KRANBERI (BORLOTTI BEANS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1821,
    "Kacang Kuning (Yellow Beans)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1822,
    "KACANG LENTIL (LENTILS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1823,
    "KACANG LENTIL COKLAT (BROWN LENTILS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1824,
    "KACANG LENTIL MERAH (RED LENTILS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1825,
    "KACANG LIMA (LIMA BEANS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1826,
    "Kacang Macadamia (Macadamia Nut)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1827,
    "Kacang Mede (Cashewnut)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1828,
    "Kacang Merah (Red Bean-Kidney Bean)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1829,
    "KACANG NAVY - KACANG PUTIH (NAVY BEANS - WHITE PEA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1830,
    "KACANG PANJANG (YARDLONG BEAN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1831,
    "KACANG PARANG (JACK BEAN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1832,
    "KACANG PIKAN (PECAN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1833,
    "KACANG PINUS (PINE NUTS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1834,
    "KACANG PISTACHIO (PISTACHIO NUTS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1835,
    "KACANG PISTACHIO PANGGANG (ROASTED PISTACHIO)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1836,
    "KACANG POLONG HIJAU (GREEN SPLIT PEAS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1837,
    "Kacang Polong Kering (Dried Greenpeas)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1838,
    "KACANG POLONG KUNING (YELLOW GREENPEAS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1839,
    "Kacang Polong-Ercis (Greenpeas)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1840, "KACANG PUTIH ", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    1841,
    "Kacang Tanah (Peanut)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1842,
    "Kacang Tanah Kupas (Shelled Peanuts)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1843,
    "Kacang Tanah Panggang (Roasted Peanut)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1844,
    "KACANG TOLO-KACANG TUNGGAK-KACANG DADAP",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1845,
    "KACANG WALNUT (WALNUT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [1846, "KAFEIN (CAFFEIN)", "Bahan Baku", "NO", "NO", "YES", "YES"],
  [
    1847,
    "Kailan (Kai-lan-Chinese Broccoli)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1848, "KAKAO (COCOA)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1849,
    "KAKAO BUBUK (COCOA POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1850, "KAKAO LIQUOR", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    1851,
    "KAKAO MASSA (COCOA MASS - COCOA LIQUOR)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1852,
    "KAKAO PASTA (COCOA PASTE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1853,
    "Kaki Babi (Pigs Feet)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1854,
    "Kalamansi (Calamansi)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1855,
    "Kaldu Ayam (Chicken Broth)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1856,
    "Kaldu Babi (Pork Broth)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1857,
    "Kaldu Ikan (Fish Broth)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1858,
    "Kaldu Kalkun (Turkey Broth)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1859,
    "Kaldu Kerang (Scallop Broth)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1860,
    "Kaldu Sapi (Beef Broth)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1861,
    "Kaldu Sayuran (Vegetable Broth)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1862, "Kaldu Udang", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [1863, "Kalium Bikarbonat", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1864,
    "KALIUM DIHIDROGEN FOSFAT (POTASSIUM DIHYDROGEN PHOSPHATE) KEC. MPASI",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    1865,
    "Kalium fluorida (Potassium fluoride)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1866,
    "Ekstrak Daging Ayam (Chicken Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1867,
    "Ekstrak Daging Babi (Pork Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1868,
    "Ekstrak Daging Sapi (Beef Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1869,
    "Ekstrak Daun Katuk (Sauropus androgynus Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1870,
    "EKSTRAK DAUN MESONA (MESONA LEAF EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1871,
    "EKSTRAK DAUN PANDAN (PANDANUS LEAF EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1872,
    "Ekstrak Daun Salam (Bay Leaf Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1873,
    "EKSTRAK DAUN SIRIH (PIPER BETLE EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1874,
    "Ekstrak Daun Wasabi (Wasabi Leaf Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1875,
    "EKSTRAK DEDAK (RICE BRAN EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1876,
    "EKSTRAK FRAMBOZEN (FRAMBOZEN EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1877,
    "Ekstrak Gandum (Wheat Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1878,
    "Ekstrak Ginseng (Panax Ginseng C.A Meyer)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    1879,
    "Ekstrak Ginseng (Panax Quinquefolius-American Ginseng)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    1880,
    "EKSTRAK GUARANA - PAULLINIA CUPANA(GUARANA EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    1881,
    "EKSTRAK GUARANA BUBUK (GUARANA POWDER EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    1882,
    "Ekstrak Gula Tebu (Cane Sugar Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1883,
    "Ekstrak Gurita Bubuk (Octopus Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1884,
    "EKSTRAK HOP (HOP EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1885,
    "Ekstrak Ikan (Fish Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1886,
    "Ekstrak Ikan Bonito (Bonito Fish Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1887,
    "Ekstrak Ikan Sardin (Sardines Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1888,
    "Ekstrak Ikan Teri (Anchovy Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1889,
    "Ekstrak Jagung (Corn Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1890,
    "Ekstrak Jahe (Ginger Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1891,
    "Ekstrak Jambu Biji (Guava Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1892,
    "Ekstrak Jamur (Mushroom Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1893,
    "EKSTRAK JAMUR BUBUK (MUSHROOM EXTRACT POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1894,
    "Ekstrak Jamur Shitake (Shitake Mushroom Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1895,
    "Ekstrak Jeruk (Orange Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1896,
    "EKSTRAK JERUK ........",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1897,
    "Ekstrak Jeruk Lemon (Lemon Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1898,
    "Ekstrak Jeruk Limau (Citrus Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1899,
    "EKSTRAK JERUK LIMAU BUBUK (LIME EXTRACT POWDER)",
    "Bahan Baku",
    "YES",
    "YES",
    "NO",
    "YES",
  ],
  [
    1900,
    "Ekstrak Jeruk Nipis (Lime Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1901,
    "Ekstrak Kacang Hazel (Hazelnut Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1902,
    "Ekstrak Kacang Hijau (Mungben Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1903,
    "Ekstrak Kacang Kedelai (Soybean Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1904,
    "EKSTRAK KACANG TANAH (PEANUT EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1905,
    "Ekstrak Kawis (Kawis Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1906,
    "Ekstrak Kayu Manis (Cinnamon Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1907,
    "Ekstrak Kecambah (Sprouts Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1908,
    "EKSTRAK KEDELAI (SOY EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1909,
    "Ekstrak Kelapa (Coconut Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1910,
    "EKSTRAK KELAPA MUDA (YOUNG COCONUT EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1911,
    "Ekstrak Kelp (Kelp Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1912,
    "EKSTRAK KENCUR (GALANGAL EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1913,
    "Ekstrak Kepiting (Crab Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1914,
    "Ekstrak Kerang (Clam Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1915,
    "Ekstrak Kimchi (Kimchi Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1916,
    "Ekstrak Kola (Coke Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1917,
    "Ekstrak Kolesom (Kolesom Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1918,
    "Ekstrak Kopi (Coffee Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1919,
    "Ekstrak Kopi Hijau (Green Coffee Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1920,
    "Ekstrak Krisantemum (Chrysantemum Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1921,
    "Ekstrak Kubis Merah (Red Cabbage Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1922,
    "EKSTRAK KUNING TELUR (YOLK EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1923,
    "Ekstrak Kunyit (Turmeric Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1924,
    "Ekstrak Lada (Pepper Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1925,
    "EKSTRAK LICORICE-LIQUORICE- SUCCUS LIQUIRITIAE (GLYCYRRHIZA GLABRA)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    1926,
    "Ekstrak Lidah Buaya (Aloe Vera Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1927,
    "Ekstrak Lobak (Radish Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1928,
    "Ekstrak Madu (Honey Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1929,
    "Ekstrak Malt (Malt Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1930,
    "Ekstrak Mangga (Mango Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1931,
    "Ekstrak Manggis (Mangosteen Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1932,
    "Ekstrak Melati (Jasmine Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1933,
    "Ekstrak Melon (Melon Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1934,
    "Ekstrak Mint (Mint Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1935,
    "Ekstrak Minyak Ikan (Fish Oil Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1936,
    "Ekstrak Muscat (Muscat Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1937,
    "Ekstrak Mustard (Mustard Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1938,
    "Ekstrak Nanas (Pineapple Extact)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1939,
    "Ekstrak Nangka (Jackfruit Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1940,
    "Ekstrak Pala (Nutmeg Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1941, "EKSTRAK PANDAN", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    1942,
    "Ekstrak Paprika (Paprika Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1943,
    "EKSTRAK PEGAGAN (PENNYWORTH EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1944,
    "EKSTRAK PEPAYA (PAPAYA EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1945, "ekstrak perilla seed", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    1946,
    "Ekstrak Pir (Pear Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1947,
    "Ekstrak Protein.... (Asal Bahan...)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1948, "EKSTRAK QUILLAILA", "Bahan Baku", "NO", "NO", "YES", "NO"],
  [
    1949,
    "Ekstrak Ragi (Yeast Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1950,
    "Ekstrak Remis (Mussels Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1951,
    "Ekstrak Ricola (Ricola Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1952,
    "EKSTRAK ROSELLA (HIBISCUS SABDARIFFA EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1953,
    "EKSTRAK ROSEMARY (ROSMARINUS OFFICINALIS EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1954,
    "Ekstrak Rum (Rhum Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1955,
    "Ekstrak Rumput Laut (Seaweed Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1956,
    "EKSTRAK SARSAPARILA - SARSI (SARSAPARILLA EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1957,
    "Ekstrak Sayuran (Vegetable Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1958,
    "Ekstrak Seafood (Seafood Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1959,
    "EKSTRAK SEREALIA (CEREALS EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1960,
    "Ekstrak Sereh (Lemongrass Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1961,
    "EKSTRAK STEVIA (STEVIA EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1962,
    "Ekstrak Tebu (Cane Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1963,
    "Ekstrak Teh (Tea Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1964,
    "Ekstrak Teh Hijau (Green Tea Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1965,
    "Ekstrak Teh Hitam (Black Tea Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1966,
    "EKSTRAK TEMU HITAM (CURCUMA AERUGINOSA EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1967,
    "Ekstrak Temulawak (Curcuma xanthorrhiza Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1968,
    "Ekstrak Tiram (Oyster Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1969,
    "Ekstrak Tulang Babi (Pig Bone Extract)",
    "Bahan Baku",
    "YES",
    "YES",
    "NO",
    "YES",
  ],
  [
    1970,
    "Ekstrak Tulang Sapi (Beef Bone Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1971,
    "Ekstrak Udang (Shrimp Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1972,
    "DInatrium 5-Monofosfat",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1973,
    "Dinatrium fosfat (Disodium Orthophosphate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1974,
    "Dinatrium Fosfat Anhidrat (Disodium Phosphate Anhydrous)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1975,
    "Dinatrium Guanosin 5-Monofosfat",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1976,
    "DINATRIUM SUKSINAT (DISODIUM SUCCINATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1977,
    "Dinatrium Uridin 5-Monofosfat",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1978,
    "Duckweed / water lentils (Lemna gibba / Lemna minor complex dan Wolffia globosa)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    1979,
    "Dulse (Palmaria palmata)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1980,
    "DURIAN BUBUK (DURIAN POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [1981, "D-XILOSA (D-XYLOSE)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1982,
    "ECHINACEAE; CONEFLOWERS; PURPLE CONEFLOWER",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1983,
    "EGCG (EPIGALLOCATECHIN GALLATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1984,
    "EKSTRA VIRGIN OLIVE OIL (VIRGIN OLIVE OIL EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [1985, "EKSTRAK .....", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    1986,
    "EKSTRAK AIR KELAPA (COCONUT WATER EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1987,
    "Ekstrak Akar Kolesom (Talinum triangulare Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1988,
    "EKSTRAK ANGGUR (GRAPE EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    1989,
    "EKSTRAK ASAM JAWA (TAMARIND EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1990,
    "Ekstrak Ayam (Chicken Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1991,
    "Ekstrak Barley (Barley Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1992,
    "Ekstrak Barley Malt (Barley Malt Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1993,
    "Ekstrak Basil (Basil Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1994,
    "EKSTRAK BAWANG BOMBAY (ONION EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1995,
    "Ekstrak Bawang Goreng (Dried Onion Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1996,
    "Ekstrak Bawang Putih (Garlic Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1997,
    "Ekstrak Bengkuang (Yambean Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1998,
    "Ekstrak Beras (Rice Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    1999,
    "EKSTRAK BERAS KENCUR (BERAS KENCUR EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2000,
    "EKSTRAK BERAS MERAH (BROWN RICE EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2001,
    "EKSTRAK BIJI ANGGUR (GRAPE SEED EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2002,
    "EKSTRAK BIJI BUNGA MATAHARI (SUNFLOWER SEED EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2003,
    "EKSTRAK BILBERRY (BILBERY EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2004,
    "Ekstrak Blewah (Cantaloupe Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2005,
    "Ekstrak Bonito (Bonito Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2006,
    "EKSTRAK BROKOLI (BROCCOLI EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2007,
    "EKSTRAK BUAH ACAI BERRY (ACAI BERRY EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2008,
    "EKSTRAK BUAH ALPUKAT (AVOCADO EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2009,
    "Ekstrak Buah Anggur (Grape Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2010,
    "EKSTRAK BUAH APEL (APPLE EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2011,
    "EKSTRAK BUAH APEL HIJAU (GREEN APPLE EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2012,
    "Ekstrak Buah Belimbing (Starfruit Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2013,
    "EKSTRAK BUAH BIT (BEETROOT EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2014,
    "Ekstrak Buah Blackberry (Blackberry Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2015,
    "Ekstrak Buah Blackcurrant (Blackcurrant Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2016,
    "Ekstrak Buah Blueberry (Blueberry Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2017,
    "Ekstrak Buah Ceri (Cherry Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2018,
    "Ekstrak Buah Delima (Pomegranate Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2019,
    "Ekstrak Buah Durian (Durian Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2020,
    "EKSTRAK BUAH KELENGKENG (LONGAN EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2021,
    "Ekstrak Buah Kesemek (Persimmon Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2022,
    "EKSTRAK BUAH KIWI (KIWI EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2023,
    "Ekstrak Buah Kundur (Benincasa hispida Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2024,
    "Ekstrak Buah Leci (Lychee Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2025,
    "Ekstrak Buah Lemon (Lemon Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2026,
    "Ekstrak Buah Mangga (Mango Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2027,
    "Ekstrak Buah Mangga Manalagi (Manalagi Mango Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2028,
    "Ekstrak Buah Markisa (Passionfruit Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2029,
    "Ekstrak Buah Melon (Melon Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2030,
    "EKSTRAK BUAH MURBEI (MULBERRY EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2031,
    "Ekstrak Buah Nangka (Jackfruit Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2032,
    "Ekstrak Buah Persik (Peach Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2033,
    "Ekstrak Buah Pisang (Banana Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2034,
    "Ekstrak Buah Plum (Plum Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2035,
    "Ekstrak Buah Prune (Prune Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2036,
    "Ekstrak Buah Raspberry (Raspberry Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2037,
    "Ekstrak Buah Semangka (Watermelon Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2038,
    "Ekstrak Buah Sirsak (Soursop Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2039,
    "Ekstrak Buah Stroberi (Strawberry Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2040,
    "Ekstrak Buah Tangkwa (Tangkwa Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2041,
    "EKSTRAK BUAH TIN ATAU BUAH ARA (FIG EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2042,
    "Ekstrak Buah Ume (Japanesse Plum Extract)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2043, "GLISIN (GLYCINE)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2044, "Glukosa (Glucose)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2045,
    "Glukosa Anhidrat (Glucose Anhydrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2046,
    "Glukosa Bubuk (Glucose Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2047,
    "GLUKOSAMIN (GLUCOSAMINE)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    2048,
    "GLUKOSAMIN HIDROKLORIDA (GLUCOSAMINE HYDROCHLORIDE)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    2049,
    "GLUKOSAMIN SULFAT (GLUCOSAMINE SULPHATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [2050, "GLUTEN (GLUTEN)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2051,
    "GLYCYRRHIZA GLABRA (LICORICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [2052, "GOBO", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2053,
    "GOBO BUBUK (GOBO POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2054,
    "GOJI (LYCIUM BARBARUM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2055,
    "GOJI BERRY - WOLBERRY",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2056,
    "GOJI BERRY (LYCIUM BARBARUM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2057,
    "Great Northern Beans",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2058,
    "GUARANA (PAULLINIA CUPANA)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    2059,
    "GULA AREN (PALM SUGAR)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2060,
    "Gula Batu (Rock Sugar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2061,
    "Gula Bit (Sugar Beet)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2062,
    "Gula Cair (Liquid Sugar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2063,
    "Gula Cokelat (Brown Sugar-Demerara)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2064,
    "Gula Halus (Refined Sugar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2065,
    "Gula Hitam (Raw Cane Sugar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2066,
    "Gula Icing (Icing Sugar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2067,
    "Gula Invert (Invert Sugar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2068,
    "Gula Jawa (Palm Sugar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2069,
    "GULA KASTOR (CASTOR SUGAR ATAU CASTER SUGAR)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2070,
    "GULA KELAPA (COCONUT SUGAR)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2071,
    "Gula Kristal (Sugar Crystals)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2072,
    "Gula Merah (Brown Sugar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2073,
    "Gula Palem (Palm Sugar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2074,
    "Gula Pasir (Granulated Sugar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2075,
    "GULA SIWALAN (PALM SUGAR)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2076,
    "Gula Sorgum (Shorgum Sugar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2077,
    "Gula Tebu (Cane Sugar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2078,
    "Gula Terfermentasi (Fermented Sugar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2079, "GUM BASE", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2080, "Gurita (Octopus)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2081, "HALBA (HALBA)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [2082, "Halia (Halia)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2083,
    "Hancuran Permen/ Butiran Permen (Crushed candy)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2084,
    "Hasil Destilasi Minyak Peppermint (Peppermint Oil Distillation)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2085,
    "HASIL DISTILASI FERMENTASI ANGGUR (DISTILLED FERMENTED GRAPE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2086,
    "HASIL DISTILASI FERMENTASI ANGGUR HIJAU (DISTILLED FERMENTED GREEN GRAPE) ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2087,
    "Hasil Distilasi Fermentasi Beras (Distilled Fermented Rice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2088,
    "Hasil Distilasi Fermentasi Jambu Mente (Distilled Fermented Cashew)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2089,
    "Hasil Distilasi Fermentasi Malt-Gandum-....... (Distilled Fermented Malt-Wheat-.....)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2090,
    "HASIL FERMENTASI .....(SEREALIA, BUAH, ....)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2091,
    "Hasil Fermentasi Apel (Fermented Apple)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2092,
    "Hasil Fermentasi Arbei (Fermented Berries)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2093,
    "Hasil Fermentasi Beras (Fermented Rice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2094,
    "Hasil Fermentasi Beras Ketan Hitam (Fermented Black Glutinous Rice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2095,
    "Hasil Fermentasi Beras Ketan Putih (Fermented White Glutinous Rice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2096,
    "Hasil Fermentasi Buah Agave (Fermented Agave)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2097,
    "Hasil Fermentasi Buah Anggur Hijau (Fermented Green Grape)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2098,
    "Hasil Fermentasi Buah Anggur Merah (Fermented Red Grape)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2099,
    "Hasil Fermentasi Buah Lontar (Fermented Palmyra) ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2100,
    "Hasil Fermentasi Gandum (Fermented Wheat)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2101,
    "Hasil Fermentasi Gula Merah (Fermented Brown Sugar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2102,
    "Hasil Fermentasi Jagung (Fermented Corn)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2103,
    "Hasil Fermentasi Jeruk (Fermented Orange)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2104,
    "HASIL FERMENTASI KEDELAI (FERMENTED SOYBEAN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2105,
    "Hasil Fermentasi Kedelai Hitam (Fermented Black Soybeans)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2106,
    "HASIL FERMENTASI KETAN HITAM (FERMENTED BLACK GLUTINOUS RICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2107,
    "Hasil Fermentasi Malt (Fermented Malt)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2108,
    "Hasil Fermentasi Markisa (Fermented Passion Fruit)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2109,
    "Hasil Fermentasi Molases (Fermented Molases)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2110,
    "Hasil Fermentasi Nanas (Fermented Pineapple)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2111,
    "Hasil Fermentasi Nira (Fermented Sap)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2112,
    "Hasil Fermentasi Pepaya (Fermented Papaya)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2113,
    "Hasil Fermentasi Salak (Fermented Salak)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2114,
    "Hasil Fermentasi Sawo (Fermented Sapodilla)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2115,
    "Hasil Fermentasi Singkong (Fermented Cassava)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2116,
    "Hasil Fermentasi Tepung Rye (Fermented Rye Flour)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2117,
    "Hasil Fermentasi Tomat (Fermented Tomato)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2118,
    "Hati Ayam (Chicken Liver)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2119,
    "Hati Ayam Bubuk (Chicken Liver Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2120,
    "Hati Babi (Pig Liver)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2121,
    "Hati Sapi (Cow Liver)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2122,
    "HEATHER (ERICA VULGARIS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2123,
    "Hemiselulase (Hemicellulase)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2124,
    "Hidrolisat Kasein Protein (Hydrolysed Casein Protein)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2125,
    "Hidrolisat Protein (Hydrolyzed Protein)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2126,
    "Hidrolisat Protein Ikan (Hydrolyzed Fish Protein)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2127,
    "Hidrolisat Protein Kedelai (Hydrolyzed Soy Protein)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2128,
    "Hidrolisat Protein Nabati (Hydrolyzed Vegetable Protein)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2129,
    "HIDROLISAT PROTEIN WHEY (HYDROLIZED WHEY PROTEIN)",
    "Bahan Baku",
    "NO",
    "YES",
    "NO",
    "YES",
  ],
  [
    2130,
    "Histidin (Histidine)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2131,
    "Hojicha Bubuk (Hojicha Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2132,
    "honeybush (cyclopia maculate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2133,
    "Honeybush (Cyclopia maculate, Cyclopia genistoides, Cyclopia sessiliflora (\"Heidelbergtee\")",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [2134, "HONEYSUCKLE", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [2135, "HOPS", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2136,
    "HUPERSZINE (HUPERZINE SERRATA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [2137, "HYDRATED DEXTRATES", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2138,
    "ICE STRUCTURING PROTEIN",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2139,
    "Iga Babi (Pork Ribs)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2140,
    "IGA SAPI (BEEF RIBS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2141, "Ikan (Fish)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2142,
    "Ikan Asap Bubuk (Smoked Fish Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2143,
    "Ikan Asin (Salted Fish)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2144,
    "Ikan Bandeng (Milkfish)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2145,
    "IKAN BELIDA (BELIDA FISH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2146, "IKAN BILIS", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2147,
    "IKAN BONITO (BONITO FISH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2148,
    "IKAN BONITO BUBUK (BONITO FISH POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2149,
    "Ikan Bubuk (Fish Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2150,
    "IKAN CAKALANG (SKIPJACK TUNA FISH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2151,
    "IKAN DACE (DACE FISH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2152,
    "Ikan Fillet (FISH FILLET)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2153, "Ikan Gindara", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2154,
    "IKAN HARING (HERRING FISH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2155,
    "IKAN HARING FILLET (HERRING FISH FILLET)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2156,
    "IKAN KAKAP (SNAPPER FISH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2157,
    "IKAN KISU (KISU FISH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2158, "Ikan Kod (Cod Fish)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2159,
    "Ikan Kod Bubuk (Cod Fish Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2160,
    "IKAN KORVINA KUNING (YELLOW CORVINA FISH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2161,
    "Ikan Layar (Sailfish)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2162,
    "IKAN LAYUR (LAYUR FISH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2163, "Ikan Lele (Catfish)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2164,
    "Ikan Lemuru (Sardine)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2165,
    "IKAN MAKAREL (MACKEREL FISH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2166,
    "IKAN MARLIN (MARLIN FISH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2167,
    "Ikan Nila (Tilapia Fish)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2168, "Ikan Patin", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2169,
    "IKAN POLLOCK (POLLOCK FISH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2170,
    "IKAN SALMON (SALMON FISH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2171,
    "IKAN SARDIN (SARDINES FISH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2172,
    "IKAN SARDIN BUBUK (SARDINES FISH POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2173,
    "IKAN SLENGSENG (MACKEREL FISH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2174,
    "IKAN TEMBANG (SARDINELLA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2175,
    "Ikan Tenggiri (Mackerel)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2176, "Ikan Teri (Anchovy)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2177,
    "IKAN TUNA (TUNA FISH)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2178, "INOSITOL (INOSITOL)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [2179, "Inulin (Inulin)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2180,
    "COCOA BUTTER EQUIVALENT (CBE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2181,
    "Cocoa Butter Replacer (CBR)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2182,
    "Cocoa Butter Substitute (CBS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2183, "Cognac (Cognac)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2184, "Cokelat (Chocolate)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2185,
    "Cokelat Batang (Chocolate Bar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2186,
    "COKELAT BUBUK (CHOCOLATE POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2187,
    "Cokelat Butir (Chocolate Granules)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2188,
    "COKELAT CAIR (MELTED CHOCOLATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2189,
    "Cokelat Chip (Chocolate Chip)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2190,
    "COKELAT COMPOUND BUTIR (CHOCOLATE COMPOUND GRANULE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2191,
    "COKELAT COMPOUND PUTIH (WHITE CHOCOLATE COMPOUND)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2192,
    "Cokelat Compound Susu (Milk Chocolate Compound)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2193,
    "COKELAT HITAM (DARK CHOCOLATE, BITTERSWEET CHOCOLATE))",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2194,
    "COKELAT HITAM CHIP (DARK CHOCOLATE CHIP)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2195,
    "COKELAT HITAM COMPOUND (DARK CHOCOLATE COMPOUND)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2196,
    "Cokelat Hitam Kovertur (Dark Chocolate Couverture)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2197,
    "Cokelat Imitasi/Hasil Olah Gula (Imitation Chocolate/Processed Sugar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2198,
    "COKELAT LIQUOR (COCOA LIQUOR)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2199,
    "COKELAT MASSA (CHOCOLATE MASS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2200,
    "Cokelat Paduan (Compound Chocolate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2201,
    "COKELAT PADUAN-COMPOUND",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2202,
    "COKELAT PAHIT (BITTER CHOCOLATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2203,
    "Cokelat Pasta (Chocolate Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2204,
    "Cokelat Pelapis (Chocolate Coating)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2205,
    "Cokelat Putih (White Chocolate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2206,
    "COKELAT RENDAH LEMAK (LOW FAT COCOA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2207,
    "Cokelat Susu (Milk Chocolate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2208,
    "COKELAT SUSU KOVERTUR (MILK CHOCOLATE COUVERTURE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2209, "COKLAT MASSA", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2210,
    "Combrang - Kecombrang (Etlingera elatior)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2211,
    "COMPOUND PUTIH (WHITE COMPOUND)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2212,
    "CORNFLOWER (CENTAURA CYANUS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2213,
    "CORNFLOWER (CENTAUREA CYANUS)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "NO",
  ],
  [2214, "Couscous", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2215,
    "CRANBERRY BUBUK (CRANBERRY POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2216,
    "Cuka Anggur (Grape Vinegar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2217,
    "Cuka Anggur Putih (White Wine Vinegar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2218,
    "Cuka Apel (Apple Vinegar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2219,
    "Cuka Balsamic (Balsamic Vinegar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2220,
    "Cuka Beras (Rice Vinegar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2221,
    "Cuka Bubuk (Vinegar Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2222,
    "CUKA FERMENTASI (VINEGAR)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2223,
    "Cuka Lemon (Lemon Vinegar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2224,
    "Cuka Makan (Vinegar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2225,
    "Cuka Plum (Plum Vinegar)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2226, "Cumi-Cumi (Squid)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2227,
    "CUMI-CUMI BUBUK (SQUID POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2228,
    "cupuacu (theobroma grandiflorum)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [2229, "Custard (Custard)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2230,
    "Custard Bubuk (Custard Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2231,
    "Dada Ayam (Chicken Breast)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2232, "Dadih", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2233,
    "Dadih Bubuk (Buttermilk Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2234,
    "DAGING AYAM (CHICKEN MEAT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2235,
    "DAGING AYAM ASAP (SMOKE CHICKEN MEAT)",
    "Bahan Baku",
    "YES",
    "YES",
    "NO",
    "YES",
  ],
  [
    2236,
    "Daging Ayam Bubuk (Chicken Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2237,
    "Daging Ayam Cincang (Minced Chiken)",
    "Bahan Baku",
    "YES",
    "YES",
    "NO",
    "YES",
  ],
  [
    2238,
    "Daging Ayam Fillet (Chicken Fillet)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2239,
    "Daging Ayam Irisan (Chicken Strips)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2240,
    "DAGING AYAM SERPIHAN (CHICKEN FLAKES)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2241, "Daging Babi (Pork)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2242,
    "DAGING BABI ASAP (SMOKE PORK)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2243,
    "Daging Babi Bubuk (Pork Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2244,
    "Daging Bebek (Duck Meat)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2245,
    "Daging Burung Puyuh/Dara/.....",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2246, "Daging Domba (Lamb)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2247,
    "Daging Kalkun (Turkey Meat)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2248,
    "Daging Kambing (Mutton)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2249,
    "Daging Kelinci (Rabbit Meat)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2250,
    "DAGING KERBAU (BUFFALO MEAT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2251,
    "Daging Paha Babi (Ham)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2252,
    "Daging Rusa (Deer Meat)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2253, "Daging Sapi (Beef)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2254,
    "DAGING SAPI ASAP (SMOKE BEEF)",
    "Bahan Baku",
    "YES",
    "YES",
    "NO",
    "YES",
  ],
  [
    2255,
    "Daging Sapi Bubuk (Beef Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2256,
    "Daging Sapi Cincang (Minced Beef)",
    "Bahan Baku",
    "YES",
    "YES",
    "NO",
    "YES",
  ],
  [
    2257,
    "Dandelion Root Powder (Taraxacum officinale)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2258,
    "DAUN ANGGUR (GRAPE LEAF)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2259,
    "Daun Apple Mint (Mentha suaveolens Ehrh)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2260,
    "Daun Asam Jawa (Tamarindus indica)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2261,
    "Daun Basil (Basil Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2262,
    "Daun Basil Bubuk (Basil Leaf Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2263,
    "Daun Basil Kering (Dried Basil Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2264,
    "DAUN BAWANG (SCALLION)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2265,
    "DAUN BAWANG BUBUK (LEEK POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2266,
    "DAUN BAWANG KERING (DRIED SCALLION)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2267,
    "Daun Beluntas (Pluchea Folium)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2268,
    "Daun Bergamot (Monarda didyma)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2269,
    "Daun Blackberry (Blackberry Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2270, "Daun Blackcurrant", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2271,
    "Daun Cengkeh (Clove Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2272,
    "Daun Citrus Thyme (Thymus citriodorus)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2273,
    "DAUN GANDUM (WHEATGRASS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2274,
    "Daun Gedi (Abelmoschus manihot (L.) Medik)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2275,
    "DAUN JAMBU BIJI (GUAVA LEAF)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2276,
    "DAUN JATI BELANDA (GUAZUMA ULMIFOLIA)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "NO",
  ],
  [
    2277,
    "DAUN JERUK (CITRUS LEAF ATAU LIME LEAF)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2278,
    "Daun Jeruk Purut (Kaffir Lime Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2279,
    "Daun Kari (Curry Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2280, "Daun Katuk", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2281,
    "Daun Kelor (Moringa oleifera L.)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2282,
    "DAUN KEMANGI (LEMON BASIL LEAF)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2283,
    "DAUN KETUMBAR (CILANTRO- CORIANDER LEAF)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2284,
    "DAUN KOPI (COFFEE LEAF)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2285,
    "DAUN KUCAI (GARLIC LEAF CHIVES)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2286,
    "Daun Kunyit (Turmeric Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2287,
    "DAUN LAKSA (LAKSA LEAF)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2288,
    "Daun Lobak (Radish Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2289,
    "Daun Marjoram (Marjoram Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2290,
    "DAUN MELINJO (MELINJO LEAF)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2291,
    "Daun Mint (Mint Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2292,
    "DAUN MOLOKHIA (MOLOKHIA LEAF)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2293,
    "DAUN MULBERRY (MULBERRY LEAF)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2294,
    "Daun Oregano (Oregano Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2295,
    "Daun Oregano Kering (Dried Oregano Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2296,
    "Daun Pakis / Paku Sayur (Vegetable Fern)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2297,
    "Daun Pandan (Pandan Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2298,
    "Daun Pepaya (Papaya Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2299,
    "Daun Peppermint (Peppermint Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2300,
    "DAUN PERILLA (PERILLA LEAF)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2301,
    "DAUN PERILLA BUBUK (PERILLA LEAF POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2302,
    "DAUN PETERSELI (PETROSELINUM CRISPUM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2303,
    "Daun Raspberry (Raspberry Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2304,
    "DAUN RHUBARB (RHEUM RHABARBARUM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2305,
    "Daun Rosemarry (Rosemarry Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2306,
    "DAUN SAGA (JEQUIRITY LEAF)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2307,
    "Daun Salam (Bay Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2308,
    "Daun Salam Bubuk (Bay Leaf Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2309,
    "Daun Seledri (Celery Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2310,
    "Daun Seledri Kering (Dried Celery Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2311,
    "DAUN SEMBUNG (SAMBONG LEAF)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2312,
    "DAUN SERUNI (CHRYSANTHEMUM LEAF)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2313,
    "DAUN SINGKONG (CASSAVA LEAF)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2314,
    "DAUN SIRIH (BETEL LEAF)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2315,
    "DAUN SIRSAK (SOURSOP LEAF)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2316,
    "DAUN STEVIA (STEVIA LEAF)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2317,
    "Daun Stroberi (Strawberry Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2318,
    "DAUN SWISS CHARD (FOLIUM BETA VULGARIS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2319,
    "DAUN TARRAGON (TARRAGON LEAF)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2320, "daun teratai ", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2321,
    "Daun Teratai (Lotus Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2322,
    "Daun Ubi Merah (Red Sweet Potato Leaf)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2323, "Dekstrin (Dextrin)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2324,
    "Dekstrosa (Dextrose)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2325,
    "Dekstrosa Anhidrat (Anhydrous Dextrose)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2326,
    "Dekstrosa Bubuk (Dextrose Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2327,
    "Cabe Merah (Red Chili)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2328, "CABE MERAH BESAR", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2329,
    "Cabe Merah Bubuk (Red Chili Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2330,
    "Cabe Rawit (Cayenne Pepper)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2331,
    "Cabe Rawit Bubuk (Cayenne Pepper Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2332,
    "Cabe Rawit Hijau (Green Cayenne Pepper)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2333,
    "Cabe Rawit Merah (Red Cayenne Pepper)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2334,
    "Calcium Beta Hydroxy Beta Methylbutyrate (CaHMB)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2335,
    "Campuran Buah Tropical Bubuk (Mixed Tropical Fruit Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2336,
    "Campuran Citrus Bubuk (Mixed Citrus Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2337,
    "Campuran Margarin dan Mentega (Blends of butter and margarine)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2338,
    "camu-camu (Myrciaria dubia)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2339,
    "Cangkang Rajungan (Crab Shells)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2340, "Capers (Capers)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2341, "CARAWAY (CARAWAY)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [2342, "Carob (Carob)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2343, "CASSIA OBTUSIFOLIA", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [2344, "CASSIA TORA", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [2345, "Ceker Ayam", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2346,
    "Cempedak (Artocarpus integer)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2347, "Cendol", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2348, "Cengkeh (Clove)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2349,
    "CENGKEH BUBUK (CLOVE POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2350,
    "CEPOKAK (COKOWANA, TERONG PIPIT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2351,
    "Ceremai (Phyllanthus acidus (L.) Skeells)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2352,
    "Ceri Bubuk (Cherry Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2353, "CHAMOMILE", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2354,
    "Chicory (Cichorium intybus)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2355,
    "Chlorella (Chlorella)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2356, "Chutney (Chutney)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2357, "CILANTRO", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2358,
    "CINCAU (JELLY GRASS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2359,
    "CINCAU HITAM (BLACK JELLY GRASS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2360, "CITRUS BIOFLAVONOID", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [2361, "Citrus Fiber", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2362,
    "BUMBU RASA SAPI (SEASONING BEEF FLAVOR)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2363,
    "BUMBU RASA SAPI PANGGANG ( ROASTED BEEF FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2364,
    "Bumbu Rasa Stroberi (Strawberry Flavored Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2365,
    "Bumbu Rasa Tomat (Tomato Flavored Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2366,
    "BUMBU RASA UDANG (SHRIMP FLAVORED SEASONING)",
    "Bahan Baku",
    "YES",
    "YES",
    "NO",
    "YES",
  ],
  [
    2367,
    "BUMBU RAWON (RAWON SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2368,
    "BUMBU RENDANG (RENDANG SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2369,
    "BUMBU RICA- RICA (RICA-RICA SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2370,
    "Bumbu Rumput Laut (Seaweed Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2371,
    "BUMBU SAMBAL LIMAU (SAMBAL LIMAU SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2372,
    "BUMBU SAPI PANGGANG (ROAST BEEF MARINADE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2373,
    "Bumbu Sate (Satay Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2374,
    "Bumbu Sate Pedas (Spicy Satay Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2375,
    "Bumbu Sayuran (Vegetable Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2376,
    "Bumbu Seafood (Seafood Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2377,
    "Bumbu Sosis (Sausage Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2378,
    "Bumbu Soto (Soto Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2379,
    "Bumbu Sup (Soup Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2380,
    "BUMBU TOM YAM (TOM YAM SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2381,
    "Bumbu Tomat (Tomato Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2382,
    "Bumbu Tomat Pedas (Spicy Tomato Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2383,
    "BUMBU... (SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2384,
    "BUNCIS BUBUK (GREEN BEAN POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2385,
    "BUNCIS HIJAU (GREEN BEAN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2386,
    "BUNGA CAMOMILE (CHAMOMILE FLOWER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2387,
    "BUNGA CORNFLOWER (CENTAUREA CYANUS LYNN)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    2388,
    "Bunga Elder (Sambucus nigra)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2389,
    "BUMBU RASA KALDU AYAM (CHICKEN BROTH FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2390,
    "BUMBU RASA KARAMEL (CARAMEL FLAVOURED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2391,
    "BUMBU RASA KARAMEL BAWANG (CARAMELIZED ONION FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2392,
    "BUMBU RASA KARI AYAM (CHICKEN CURRY FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2393,
    "BUMBU RASA KEJU (CHEESE FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2394,
    "BUMBU RASA KENTANG GORENG (FRENCH FRIES FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2395,
    "BUMBU RASA LEMON (LEMON FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2396,
    "BUMBU RASA MANIS PEDAS (SWEET AND SPICY FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2397,
    "BUMBU RASA MUSTARD (MUSTARD FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2398,
    "BUMBU RASA PEDAS (SPICY FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2399,
    "BUMBU RASA PEDAS MANIS ASIN (SWEET, SPICY AND SALTY FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2400,
    "BUMBU RASA PEPPERONI PIZZA (PEPPERONI PIZZA FLAVOR)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2401,
    "BUMBU RASA PIZZA (PIZZA FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2402,
    "BUMBU RASA RUMPUT LAUT (SEAWEED FLAVORED SEASONING )",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2403, "BUBUK LECI ", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2404,
    "Bubuk Mutiara (Pearl Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    2405,
    "Bubuk Salmon (Salmon Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2406,
    "Bubur Beras (Rice Porridge)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2407,
    "Bubur Beras Merah (Brown Rice Porridge)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2408,
    "Bubur Buah Apel (Apple Pulp)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2409,
    "Bubur Buah Aprikot (Apricot Pulp)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2410,
    "Bubur Buah Arbei (Arbei Pulp)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2411,
    "Bubur Buah Jambu (Guava Pulp)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2412,
    "Bubur Buah Jambu Merah",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2413,
    "Bubur Buah Jeruk (Orange Pulp)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2414,
    "Bubur Buah Lemon (Lemon Pulp)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2415,
    "Bubur Buah Mangga (Mango Pulp)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2416,
    "Bubur Buah Mulberry (Mulberry Pulp)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2417,
    "Bubur Buah Nanas (Pineapple Pulp)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2418,
    "Bubur Buah Persik (Peach Pulp)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2419,
    "Bubur Buah Sirsak (Soursop Pulp)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2420,
    "Bubur Buah Stroberi (Strawberry Pulp)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2421,
    "Bubur Buah Tomat (Tomato Pulp)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2422,
    "BUBUR GANDUM (WHEAT PORRIDGE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2423,
    "BUBUR KACANG (PEANUT PORRIDGE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2424,
    "BUBUR KACANG HIJAU (MUNGBEAN PORRIDGE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2425,
    "Bubur Kacang Merah (Red Bean Porridge)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2426,
    "Bubur Kentang (Potato Pulp)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2427,
    "BUBUR KULIT JERUK (ORANGE PEEL PULP)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2428,
    "Bubur Labu Kuning (Pumpkin Porridge)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2429,
    "Bubur Susu (Milk Porridge)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2430,
    "BUCKWHEAT (BUCKWHEAT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2431,
    "BUCKWHEAT (BUCKWHEAT-FAGOPYRUM ESCULENTUM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2432,
    "Bulir Jeruk (Orange Pulp)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2433,
    "Bulir Jeruk Valencia (Valencia Orange Pulp)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2434,
    "BUMBU RASA KEJU (CHEESE FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2435,
    "BUMBU ABON AYAM (CHICKEN FLOSS SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2436,
    "Bumbu Abon Sapi (Beef Floss Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2437,
    "BUMBU ASAM MANIS (SWEET AND SOUR SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2438,
    "Bumbu Ayam (Chicken Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2439,
    "Bumbu Ayam Bawang (Garlic Chicken Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2440,
    "Bumbu Ayam Goreng (Fried Chicken Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2441,
    "Bumbu Ayam Pedas (Spicy Chicken Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2442,
    "Bumbu Balado (Balado Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2443,
    "Bumbu Barbekiu (Barbeque Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2444,
    "BUMBU BAWANG PEDAS (SPICY GARLIC SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2445,
    "BUMBU CUMI BAKAR (GRILLED SQUID SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2446,
    "Bumbu Daging Sapi (Beef Flavor)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2447,
    "Bumbu Ekstrak Daging Ayam (Chicken Extract Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    2448,
    "Bumbu Frankfurter (Frankfurter Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2449,
    "BUMBU GULAI (GULAI SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2450,
    "BUMBU IGA SAPI (SPICES OR SEASONING FOR BEEF RIBS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2451,
    "BUMBU IKAN TERI (ANCHOVY SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2452,
    "BUMBU JAGUNG (CORN SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2453,
    "BUMBU JAGUNG BAKAR (ROASTED CORN SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2454,
    "BUMBU KACANG MERAH (RED BEAN SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2455,
    "BUMBU KARI (CURRY SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2456,
    "BUMBU KARI DAGING (MEAT CURRY SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2457,
    "BUMBU KARI IKAN (FISH CURRY SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2458,
    "BUMBU KEJU BURGER (CHEESEBURGER SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2459,
    "Bumbu Kentang Barbekiu (Barbeque Potato Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2460,
    "BUMBU KIMCHI (KIMCHI SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2461,
    "BUMBU KRIM ASAM (SOUR CREAM SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2462,
    "BUMBU KRIM MENTEGA (BUTTERCREAM SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2463,
    "BUMBU MI GORENG (FRIED NOODLE SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2464,
    "BUMBU MINYAK UDANG (OIL SEASONING SHRIMP)",
    "Bahan Baku",
    "YES",
    "YES",
    "NO",
    "YES",
  ],
  [
    2465,
    "BUMBU NGOHIONG (NGOHIONG SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2466,
    "BUMBU OPOR (OPOR SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2467,
    "BUMBU OTAK-OTAK (OTAK-OTAK SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2468,
    "Bumbu Pasta (Paste Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2469,
    "Bumbu Pedas (Spicy Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2470,
    "BUMBU PERENDAM (MARINADE SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2471, "Bumbu Petis Bubuk", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2472,
    "Bumbu Pizza (Pizza Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2473,
    "BUMBU RASA (FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2474,
    "BUMBU RASA ASAM PEDAS (SOUR SPICY FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2475,
    "Bumbu Rasa Ayam (Chicken Flavored Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2476,
    "Bumbu Rasa Ayam Bakar (Grilled Chicken Flavor Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2477,
    "Bumbu Rasa Ayam Panggang (Roasted Chicken Flavor Seasoning)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2478,
    "BUMBU RASA BABI (PORK OR BACON FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2479,
    "BUMBU RASA BALADO (BALADO FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2480,
    "BUMBU RASA BAWANG (ONION FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2481,
    "BUMBU RASA BAWANG PUTIH (GARLIC FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2482,
    "BUMBU RASA COKELAT (CHOCOLATE FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2483,
    "BUMBU RASA DAGING SAPI (BEEF FLAVORED SEASONING )",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2484,
    "BUMBU RASA DENDENG (JERKY FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2485,
    "BUMBU RASA IKAN (FISH FLAVORED SEASONING)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2486,
    "ADAS PEDAS BUBUK-ADAS BUBUK-FENNEL POWDER (FOENICULUM VULGARE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2487, "Abalon (Abalone)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2488,
    "Abon Ayam (Chicken Floss)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2489,
    "Abon Babi (Pork Floss)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2490,
    "ABON CAKALANG (SKIPJACK TUNA FLOSS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2491,
    "Abon Sapi (Beef Floss)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2492,
    "Abon Sapi Pedas (Hot Beef Floss)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2493, "Acar (Pickles)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2494,
    "Acar Bawang Putih (Garlic Pickles)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2495,
    "Acar Cabe (Chili Pickles)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2496,
    "Acar Jahe (Ginger Pickles)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2497,
    "Acar Mentimun-Ketimun (Cucumber Pickles)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2498, "ACEROLA (ACEROLA)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2499,
    "ACEROLA (MALPIGHIA GLABRA)- BARBADOS CHERRY-WEST INDIAN CHERRY-CEREZA-CERESIER-SEMERUCO-WILD CRAPEMYRTLE",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2500,
    "ACEROLA BUBUK (ACEROLA POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2501,
    "ACEROLA EKSTRAK (ACEROLA EXTRACT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [2502, "ADAS (FENNEL)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2503,
    "ADAS MANIS BUBUK-ANIS POWDER (PIMPINELLA ANISUM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2504,
    "Adas Manis-Anis (Pimpinella anisum)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2505,
    "ADAS PEDAS - ADAS - FENNEL (FOENICULUM VULGARE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2506,
    "ADAS SOWA-DILL (ANETHUM GRAVEOLENS L.)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2507,
    "ADENOSIN 5-MONOFOSFAT (ADENOSINE 5-MONOPHOSPHATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2508, "Adonan (Dough)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2509, "AGAR-AGAR (AGAR)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2510,
    "AGAR-AGAR BUBUK (AGAR POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2511, "Air (Water)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2512,
    "Air Berkarbonat (Carbonated Water)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2513, "Air Dadih (Whey)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2514,
    "Air Deionisasi (Deionized Water)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2515,
    "AIR DEMINERALISASI (DEMINERALIZED WATER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2516, "Air Es (Cold Water)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2517, "Air Kaldu (Broth)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2518,
    "AIR KELAPA (COCONUT WATER-COCONUT JUICE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2519,
    "Air Mineral (Mineral Water)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2520,
    "Air Soda (Soda Water)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2521,
    "Air Suling (Distilled Water)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2522,
    "AKAR BUNGA TERATAI (LOTUS ROOT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2523,
    "Akar Chicory (Chicory Root)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2524,
    "Akar Ginseng (Panax Ginseng C.A Meyer)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    2525,
    "Akar Ginseng (Panax Quinquefolius-American Ginseng)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    2526,
    "Akar Ketumbar (Coriander Root)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2527,
    "AKAR TERATAI BUBUK -LOTUS ROOT POWDER(NELUMBIUM NELUMBO DRUCE; NELUMBIUM NUCIFERUM) ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2528, "Alanin (Alanine)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2529, "Albumin (Albumine)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2530, "ALFA KAROTEN", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2531,
    "Alfa Laktalbumin (Alpha-Lactalbumin)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2532,
    "Alfa Tokoferol (Alpha-Tocopherol)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2533,
    "ALFA-AMILASE (ALPHA-AMYLASE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2534, "ALFALFA (ALFALFA)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2535,
    "Alga Merah (Red Algae)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2536,
    "Alga Merah Lithothamnion (Lithothamnion Red Algae) (Kecuali Pangan Untuk Keperluan Gizi Khusus)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2537, "ALGINAT (ALGINATE)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2538, "Alkohol (Alcohol)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2539, "Allulosa (Allulose)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2540,
    "Almond Bubuk (Almond Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2541,
    "Almond Butiran (Almond Granules)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2542,
    "Almond Panggang (Roasted Almond)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2543, "Alpukat (Avocado)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2544,
    "Alpukat Bubuk (Avocado Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2545,
    "Alpukat Pasta (Avocado Paste)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2546, "AMONIAK (AMMONIA)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2547,
    "AMONIAK CAIR (LIQUID AMMONIA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [2548, "Ampela (Gizzard)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2549,
    "ANDALIMAN (ZANTHOXYLUM ACANTHOPODIUM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2550,
    "ANDALIMAN BUBUK - ANDALIMAN POWDER (ZANTHOXYLUM ACANTHOPODIUM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2551,
    "ANEKA BUAH BERI (MIX BERRIES)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2552, "Anggur (Wine)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2553,
    "Anggur Beras (Rice Wine)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2554,
    "Anggur Merah (Red Wine)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2555,
    "Anggur Putih (White Wine)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2556, "ANGGUR PUTIH BUBUK", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2557,
    "Apel Bubuk (Apple Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2558,
    "Apel Kering (Dried Apple)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2559, "Aprikot (Apricot)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2560, "AQUAMIN F", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2561,
    "Arak Beras (Rice Wine)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2562,
    "ARAK BERAS KETAN (GLUTINOUS RICE WINE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2563,
    "ARANG AKTIF (ACTIVATED CARBON)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [2564, "ARGININ (ARGININE)", "Bahan Baku", "NO", "NO", "YES", "YES"],
  [
    2565,
    "Artichoke (Artichoke)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2566,
    "Arugula (Eruca Sativa)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2567, "Asafoetida", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2568,
    "Asam Amino Premiks (Amino Acid Premix)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2569,
    "ASAM ARAKHIDONAT -ARA-AA (DARI MINYAK LAIN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2570,
    "ASAM ARAKHIDONAT-ARA-AA (DARI MINYAK SEL TUNGGAL)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2571,
    "ASAM ASETAT GLASIAL (GLACIAL ACETIC ACID)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2572,
    "Asam Folat (Folic Acid)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2573,
    "Asam Fosfat (Acid Phosphoric)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2574,
    "ASAM GELUGUR (GARCINIA ATROVIRIDIS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2575,
    "ASAM JAWA BUBUK-TAMARIND POWDER (TAMARINDUS INDICA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2576,
    "ASAM JAWA-TAMARIND (TAMARINDUS INDICA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2577,
    "ASAM KANDIS (GARCINIA XANTHOCHYMUS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2578,
    "Asam Linoleat (Linoleic Acid)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2579,
    "Asam Linoleat Terkonjugasi (Conjugated Linoleic Acid)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2580,
    "Asam Nukleat (Nucleic Acid)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2581,
    "Asam Oktanoat (Octanoate Acid)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2582,
    "ASAM OLEAT (OLEIC ACID)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2583,
    "Asam Palmitat (Palmitic Acid)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2584,
    "Asam Stearat (Stearic Acid)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2585,
    "Asam Sulfat (Sulfic Acid)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2586,
    "ASKORBIL PALMITAT (ASCORBYL PALMITATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2587,
    "ASPARAGUS (ASPARAGUS OFFICINALIS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2588,
    "Asparagus Laut (Sea Asparagus)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2589,
    "Asparagus Putih (White Asparagus)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2590, "ASPERGILLUS ORYZAE", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2591, "ASTRAGALI", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [2592, "ASTRAGALUS", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2593,
    "Ayam Bubuk (Chicken Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2594, "Ayam Suwir", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2595, "Babat Sapi", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2596,
    "BACILLUS COAGULANS GBI-30 6086 (GANEDEN BC30)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    2597,
    "BACILLUS COAGULANS MTCC 5856",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [2598, "BAHAN HERBAL LAINNYA", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2599,
    "Bahan Perisa (Flavoring Substances)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2600,
    "Bakso Ayam (Chicken Meatball)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2601,
    "Bakso Ikan (Fish Meatball)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2602,
    "Bakso Sapi (Beef Meatball)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2603,
    "BALM (MELISSA OFFICINALIS L)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [2604, "Barley (Barley)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2605, "BARLEY (KOJI)", "Bahan Baku", "NO", "YES", "NO", "NO"],
  [
    2606,
    "Barley grass ( Hordeum vulgare L)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    2607,
    "Barley Malt (Barley Malt)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2608,
    "Barley Panggang (Roasted Barley)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2609,
    "Barley Serpihan (Barley Flakes)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2610, "BASIL (BASIL)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2611,
    "BASIL BUBUK-BASIL POWDER (OCIMUM BASILICUM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2612,
    "Bawang Bombay (Onion)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2613,
    "Bawang Bombay Bubuk (Onion Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2614,
    "Bawang Bombay Kering (Dried Onion)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2615, "BAWANG DAUN (CHIVES)", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2616,
    "BAWANG MERAH (RED ONION-SHALLOT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2617,
    "BAWANG MERAH BUBUK (RED ONION POWDER - SHALLOT POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2618,
    "BAWANG MERAH GORENG (FRIED RED ONION - FRIED SHALLOT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2619,
    "Bawang Putih (Garlic)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2620,
    "Bawang Putih Bubuk (Garlic Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2621,
    "BAWANG PUTIH GILING (GRINDED GARLIC)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2622,
    "Bawang Putih Goreng (Fried Garlic)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2623,
    "Bawang Putih Kering (Dried Garlic)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2624,
    "Bawang Putih Serpihan (Garlic Flakes)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2625, "Bayam (Spinach)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2626,
    "Bayam Bubuk (Spinach Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2627,
    "BEE POLLEN (KHUSUS MADU)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2628,
    "Bekatul Beras (Rice Bran)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2629, "BEKICOT (SNAIL)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2630,
    "BELIMBING WULUH (AVERRHOA BILIMBI)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2631, "Belut (Eel)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2632, "benang sari teratai", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2633,
    "Bengkuang - Sengkuang (Yam Bean)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2634,
    "BERANGAN (MALAYAN CHESTNUT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2635, "Beras (Rice)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2636,
    "Beras Butiran (Rice Grains)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2637,
    "Beras Cokelat (Brown Rice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2638,
    "Beras Hitam (Black Rice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2639,
    "Beras Instan (Instant Rice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2640, "BERAS KEPALA", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2641,
    "Beras Ketan (Glutinous Rice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2642,
    "Beras Ketan Hitam (Black Glutinous Rice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2643,
    "Beras Ketan Putih (White Glutinous Rice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2644,
    "Beras Merah (Brown Rice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2645,
    "Beras Merah Krispi (Brown Rice Crispy)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2646,
    "Beras Merah Utuh (Whole Brown Rice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2647, "Beras Pandan Wangi", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2648,
    "Beras Panggang (Roasted Rice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2649,
    "Beras Utuh (Whole Rice)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2650,
    "Besi Bisglisinat (Ferrous bisglycinate) ",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2651,
    "BESI FOSFAT (FERROUS PHOSPHATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2652,
    "BESI FUMARAT (FERROUS FUMARATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2653, "Besi Glukonat", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2654,
    "BESI LAKTAT (FERROUS LACTATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2655,
    "BESI ORTOFOSFAT (FERROUS ORTHOPHOSPHATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2656,
    "BESI PIROFOSFAT (FERROUS PYROPHOSPHATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2657,
    "Besi Sitrat (Ferrous Citrate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2658,
    "BESI SULFAT (FERROUS SULPHATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2659,
    "BESI SULFATE (FERROUS SULPHATE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2660,
    "BESI TRIOKSIDA (FERROUS TRIOXIDE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2661,
    "BETA GLUKAN DARI SACCHAROMYCES CEREVISIAE",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    2662,
    "BETA KAROTEN (BETA-CAROTENE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2663,
    "Bifidobacterium Animalis",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2664,
    "Bifidobacterium longum NCC 3001",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2665,
    "Bifidobakterium Breve",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2666,
    "Bifidobakterium Laktis",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2667,
    "Bifidobakterium Longum",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2668, "Bihun (Vermicelli)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2669,
    "Bihun Kentang (Potato Vermicelli)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2670,
    "Biji Amaranthus hypochondriacus",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2671,
    "BIJI ANGGUR (GRAPE SEED)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2672,
    "Biji Aprikot (Apricot Seed)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2673,
    "Biji Blond Grain Husk (Semen Triticum aestivum)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2674,
    "BIJI BUNCIS (BAKED BEAN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2675,
    "Biji Bunga Matahari (Sunflower Seed)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2676,
    "BIJI BUNGA TERATAI-LOTUS SEED (NELUMBIUM NELUMBO DRUCE; NELUMBIUM NUCIFERUM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2677,
    "Biji Cabe (Chili Seed)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2678,
    "BIJI CARAWAY (CARAWAY SEED)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2679,
    "BIJI CHIA (SALVIA HISPANICA)",
    "Bahan Baku",
    "NO",
    "NO",
    "YES",
    "YES",
  ],
  [
    2680,
    "BIJI COKELAT-BIJI KAKAO (COCOA BEAN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2681,
    "Biji Delima (Pomegranate Seed)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2682,
    "Biji Kopi (Coffee Bean)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2683,
    "Biji Kopi Arabika (Arabica Coffee Bean)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2684,
    "Biji Kopi Hijau (Green Coffee Bean)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2685,
    "Biji Kopi Panggang (Roasted Coffee Bean)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2686,
    "Biji Kopi Robusta (Robusta Coffee Bean)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2687,
    "Biji Labu (Pumpkin Seed)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2688, "Biji Labu Putih", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2689,
    "Biji Leci (Lychee Seed)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2690, "Biji Lin (Lin Seed)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2691,
    "BIJI LUPIN (LUPIN BEAN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2692,
    "Biji Melinjo - Belinjo (Gnetum gnemon)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2693,
    "Biji Melon (Melon Seeds)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2694,
    "Biji Mustard (Mustard Seed)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2695, "Biji Pala (Nutmeg)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2696,
    "BIJI PERILLA - PERILLA SEED",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2697,
    "Biji Pinus (Pinecone)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2698, "BIJI PLANTAGO", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2699,
    "BIJI POPPY (PAPAVER SOMNIFERUM)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2700,
    "BIJI QUINOA (CHENOPODIUM QUINOA WILLDENOW)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2701,
    "Biji Rami (Flaxseed)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2702,
    "Biji Rami Bubuk (Flaxseed Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2703, "BIJI SAFFLOWER", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2704,
    "Biji Salak Bubuk (Salak Seed Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2705,
    "Biji Sawi (Mustard Green Seed)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2706,
    "Biji Selasih (Basil Seed)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2707,
    "Biji Seledri (Celery Seed)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2708,
    "Biji Semangka (Watermelon Seed)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2709,
    "Biji Teff (Teff Grain)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2710,
    "BIJI VANILA (VANILA BEAN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2711, "BIOTIN", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [2712, "Bir (Beer)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2713, "BISKUIT (BISCUIT)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2714, "Bit (Beetroot)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2715,
    "Bit Bubuk (Beetroot Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2716,
    "Bit Merah (Red Beetroot)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2717,
    "Bit Merah Bubuk (Red Beetroot Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2718,
    "BLACKCURRANT BUBUK (BLACKCURRANT POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2719, "Blondo / Galendo", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2720,
    "BLUEBERRY KERING (DRIED BLUEBERRY)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2721,
    "BLUEBERRY PASTA (BLUEBERRY PASTE)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2722, "Bonggol Pisang", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2723, "Brandy (Brandy)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2724, "Brem", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2725, "Brokoli (Brocoli)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2726,
    "BROKOLI BUBUK (BROCCOLI POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2727,
    "BUAH ACAI BERRY (EUTERPE OLERACEA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2728, "Buah Anggur (Grape)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2729,
    "Buah Anggur Bubuk (Grape Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2730,
    "BUAH ANGGUR KERING (DRIED GRAPES)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2731,
    "Buah Anggur Merah Bubuk (Red Grape Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2732, "Buah Apel (Apple)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2733,
    "Buah Apel Hijau (Green Apple)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2734,
    "Buah Apel Merah (Red Apple)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2735,
    "BUAH ARA (BUAH FIG, BUAH TIN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2736,
    "BUAH ARONIA BUBUK - ARONIA BERRY POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2737, "BUAH ATAP", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [2738, "BUAH BAKU", "Bahan Baku", "NO", "NO", "NO", "NO"],
  [
    2739,
    "Buah Belimbing (Starfruit)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2740, "Buah Beri (Berry)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2741,
    "Buah Beri Hitam (Blackberry)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2742,
    "Buah Beri Merah (Redberry)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2743,
    "BUAH BILBERRY (BILBERRY)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2744,
    "Buah Blackcurrant (Blackcurrant)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2745,
    "BUAH BLUEBERRY (BLUEBERRY)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2746,
    "Buah Boysenberry (Boysenberry)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2747,
    "BUAH BUBUK (FRUIT POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2748, "Buah Ceri (Cherry)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2749,
    "Buah Ceri Hitam (Black Cherry)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2750,
    "Buah Ceri Merah (Red Cherry)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2751,
    "BUAH CRANBERRY (CRANBERRY)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2752,
    "Buah Delima (Pomegranate)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2753,
    "BUAH DHAL BUBUK (DHAL POWDER)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2754,
    "Buah Durian (Durian)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2755,
    "BUAH DURIAN MONTHONG (DURIAN MONTHONG)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2756,
    "BUAH ELDERBERRY (ELDERBERRY)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2757,
    "BUAH FRAMBOZEN (FRAMBOZEN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2758,
    "BUAH GAC (MOMORDICA COCHINCHINENSIS)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2759,
    "BUAH GOJI BERRY - BARBARY WOLFBERRY",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2760,
    "BUAH HAW (HAWTHORN BERRY)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2761,
    "BUAH KERING (DRIED FRUIT)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2762, "Buah Kesemek", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2763, "Buah Kundur", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2764, "Buah Leci (Lychee)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2765,
    "Buah Leci Bubuk (Lychee Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2766,
    "Buah Mulberry (Mulberry)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2767,
    "Buah Naga (Dragonfruit)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2768,
    "Buah Pala (Myristica Fragran)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2769,
    "BUAH PAW PAW (ASIMINA TRILOBA)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2770,
    "Buah Pepaya (Papaya)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2771,
    "Buah Pepaya Kuning (Golden Papaya)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2772,
    "Buah Pepaya Merah (Red Papaya)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2773, "Buah Persik (Peach)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [2774, "Buah Prune (Prune)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2775,
    "Buah Prune Kering (Dried Prune)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2776,
    "BUAH RASPBERRY (FRAMBOZEN)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2777,
    "Buah Redcurrant (Redcurrant)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2778,
    "Buah Stroberi (Strawberry)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2779,
    "Buah Stroberi Bubuk (Strawberry Powder)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2780,
    "Buah Sukun (Breadfruit)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [2781, "Buah Zaitun (Olive)", "Bahan Baku", "NO", "NO", "NO", "YES"],
  [
    2782,
    "Buah Zaitun Hijau (Green Olive)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2783,
    "Buah Zaitun Hijau Tanpa Biji (Seedless Green Olive)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2784,
    "Buah Zaitun Hitam (Black Olive)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2785,
    "Buah Zaitun Hitam Tanpa Biji (Seedless Black Olive)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2786,
    "Buah Zaitun Kalamata (Kalamata Olive)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2787,
    "Buah Zukini (Zucchini atau Courgette)",
    "Bahan Baku",
    "NO",
    "NO",
    "NO",
    "YES",
  ],
  [
    2788,
    "GLISEROL (GLYCEROL)",
    "Bahan Tambahan Pangan",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2789,
    "NATRIUM BENZOAT (SODIUM BENZOATE)",
    "Bahan Tambahan Pangan",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2790,
    "NATRIUM POLIFOSFAT (SODIUM POLYPHOSPHATE)",
    "Bahan Tambahan Pangan",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
  [
    2791,
    "STEVIA (STEVIA)",
    "Bahan Tambahan Pangan",
    "NO",
    "NO",
    "NO",
    "NO",
  ],
];
# END FRAGMENT id=data-idn_bpom_bahan_baku_pangan

my $res = gen_read_table_func(
    name => 'bpom_list_food_ingredients',
    summary => 'List ingredients in BPOM processed food division',
    table_data => $data_idn_bpom_bahan_baku_pangan,
    table_spec => $meta_idn_bpom_bahan_baku_pangan,
    description => <<'_',
_
    extra_props => {
        examples => [
        ],
    },
);
die "Can't generate function: $res->[0] - $res->[1]" unless $res->[0] == 200;

1;
# ABSTRACT: List ingredients in BPOM processed food division

__END__

=pod

=encoding UTF-8

=head1 NAME

App::BPOMUtils::Table::FoodIngredient - List ingredients in BPOM processed food division

=head1 VERSION

This document describes version 0.017 of App::BPOMUtils::Table::FoodIngredient (from Perl distribution App-BPOMUtils-Table-FoodIngredient), released on 2023-02-13.

=head1 DESCRIPTION

This distribution contains the following CLIs:

=over

=item * L<bpom-daftar-bahan-baku-pangan>

=item * L<bpom-list-food-ingredients>

=back

=head1 FUNCTIONS


=head2 bpom_list_food_ingredients

Usage:

 bpom_list_food_ingredients(%args) -> [$status_code, $reason, $payload, \%result_meta]

List ingredients in BPOM processed food division.

This function is not exported by default, but exportable.

Arguments ('*' denotes required arguments):

=over 4

=item * B<country_of_origin> => I<str>

Only return records where the 'country_of_origin' field equals specified value.

=item * B<country_of_origin.contains> => I<str>

Only return records where the 'country_of_origin' field contains specified text.

=item * B<country_of_origin.in> => I<array[str]>

Only return records where the 'country_of_origin' field is in the specified values.

=item * B<country_of_origin.is> => I<str>

Only return records where the 'country_of_origin' field equals specified value.

=item * B<country_of_origin.isnt> => I<str>

Only return records where the 'country_of_origin' field does not equal specified value.

=item * B<country_of_origin.matches> => I<str>

Only return records where the 'country_of_origin' field matches specified regular expression pattern.

=item * B<country_of_origin.max> => I<str>

Only return records where the 'country_of_origin' field is less than or equal to specified value.

=item * B<country_of_origin.min> => I<str>

Only return records where the 'country_of_origin' field is greater than or equal to specified value.

=item * B<country_of_origin.not_contains> => I<str>

Only return records where the 'country_of_origin' field does not contain specified text.

=item * B<country_of_origin.not_in> => I<array[str]>

Only return records where the 'country_of_origin' field is not in the specified values.

=item * B<country_of_origin.not_matches> => I<str>

Only return records where the 'country_of_origin' field does not match specified regular expression.

=item * B<country_of_origin.xmax> => I<str>

Only return records where the 'country_of_origin' field is less than specified value.

=item * B<country_of_origin.xmin> => I<str>

Only return records where the 'country_of_origin' field is greater than specified value.

=item * B<detail> => I<bool> (default: 0)

Return array of full records instead of just ID fields.

By default, only the key (ID) field is returned per result entry.

=item * B<exclude_fields> => I<array[str]>

Select fields to return.

=item * B<fields> => I<array[str]>

Select fields to return.

=item * B<id> => I<int>

Only return records where the 'id' field equals specified value.

=item * B<id.in> => I<array[int]>

Only return records where the 'id' field is in the specified values.

=item * B<id.is> => I<int>

Only return records where the 'id' field equals specified value.

=item * B<id.isnt> => I<int>

Only return records where the 'id' field does not equal specified value.

=item * B<id.max> => I<int>

Only return records where the 'id' field is less than or equal to specified value.

=item * B<id.min> => I<int>

Only return records where the 'id' field is greater than or equal to specified value.

=item * B<id.not_in> => I<array[int]>

Only return records where the 'id' field is not in the specified values.

=item * B<id.xmax> => I<int>

Only return records where the 'id' field is less than specified value.

=item * B<id.xmin> => I<int>

Only return records where the 'id' field is greater than specified value.

=item * B<is_herbal> => I<str>

Only return records where the 'is_herbal' field equals specified value.

=item * B<is_herbal.contains> => I<str>

Only return records where the 'is_herbal' field contains specified text.

=item * B<is_herbal.in> => I<array[str]>

Only return records where the 'is_herbal' field is in the specified values.

=item * B<is_herbal.is> => I<str>

Only return records where the 'is_herbal' field equals specified value.

=item * B<is_herbal.isnt> => I<str>

Only return records where the 'is_herbal' field does not equal specified value.

=item * B<is_herbal.matches> => I<str>

Only return records where the 'is_herbal' field matches specified regular expression pattern.

=item * B<is_herbal.max> => I<str>

Only return records where the 'is_herbal' field is less than or equal to specified value.

=item * B<is_herbal.min> => I<str>

Only return records where the 'is_herbal' field is greater than or equal to specified value.

=item * B<is_herbal.not_contains> => I<str>

Only return records where the 'is_herbal' field does not contain specified text.

=item * B<is_herbal.not_in> => I<array[str]>

Only return records where the 'is_herbal' field is not in the specified values.

=item * B<is_herbal.not_matches> => I<str>

Only return records where the 'is_herbal' field does not match specified regular expression.

=item * B<is_herbal.xmax> => I<str>

Only return records where the 'is_herbal' field is less than specified value.

=item * B<is_herbal.xmin> => I<str>

Only return records where the 'is_herbal' field is greater than specified value.

=item * B<name> => I<str>

Only return records where the 'name' field equals specified value.

=item * B<name.contains> => I<str>

Only return records where the 'name' field contains specified text.

=item * B<name.in> => I<array[str]>

Only return records where the 'name' field is in the specified values.

=item * B<name.is> => I<str>

Only return records where the 'name' field equals specified value.

=item * B<name.isnt> => I<str>

Only return records where the 'name' field does not equal specified value.

=item * B<name.matches> => I<str>

Only return records where the 'name' field matches specified regular expression pattern.

=item * B<name.max> => I<str>

Only return records where the 'name' field is less than or equal to specified value.

=item * B<name.min> => I<str>

Only return records where the 'name' field is greater than or equal to specified value.

=item * B<name.not_contains> => I<str>

Only return records where the 'name' field does not contain specified text.

=item * B<name.not_in> => I<array[str]>

Only return records where the 'name' field is not in the specified values.

=item * B<name.not_matches> => I<str>

Only return records where the 'name' field does not match specified regular expression.

=item * B<name.xmax> => I<str>

Only return records where the 'name' field is less than specified value.

=item * B<name.xmin> => I<str>

Only return records where the 'name' field is greater than specified value.

=item * B<origin> => I<str>

Only return records where the 'origin' field equals specified value.

=item * B<origin.contains> => I<str>

Only return records where the 'origin' field contains specified text.

=item * B<origin.in> => I<array[str]>

Only return records where the 'origin' field is in the specified values.

=item * B<origin.is> => I<str>

Only return records where the 'origin' field equals specified value.

=item * B<origin.isnt> => I<str>

Only return records where the 'origin' field does not equal specified value.

=item * B<origin.matches> => I<str>

Only return records where the 'origin' field matches specified regular expression pattern.

=item * B<origin.max> => I<str>

Only return records where the 'origin' field is less than or equal to specified value.

=item * B<origin.min> => I<str>

Only return records where the 'origin' field is greater than or equal to specified value.

=item * B<origin.not_contains> => I<str>

Only return records where the 'origin' field does not contain specified text.

=item * B<origin.not_in> => I<array[str]>

Only return records where the 'origin' field is not in the specified values.

=item * B<origin.not_matches> => I<str>

Only return records where the 'origin' field does not match specified regular expression.

=item * B<origin.xmax> => I<str>

Only return records where the 'origin' field is less than specified value.

=item * B<origin.xmin> => I<str>

Only return records where the 'origin' field is greater than specified value.

=item * B<queries> => I<array[str]>

Search.

This will search all searchable fields with one or more specified queries. Each
query can be in the form of C<-FOO> (dash prefix notation) to require that the
fields do not contain specified string, or C</FOO/> to use regular expression.
All queries must match if the C<query_boolean> option is set to C<and>; only one
query should match if the C<query_boolean> option is set to C<or>.

=item * B<query_boolean> => I<str> (default: "and")

Whether records must match all search queries ('and') or just one ('or').

If set to C<and>, all queries must match; if set to C<or>, only one query should
match. See the C<queries> option for more details on searching.

=item * B<random> => I<bool> (default: 0)

Return records in random order.

=item * B<result_limit> => I<int>

Only return a certain number of records.

=item * B<result_start> => I<int> (default: 1)

Only return starting from the n'th record.

=item * B<sort> => I<array[str]>

Order records according to certain field(s).

A list of field names separated by comma. Each field can be prefixed with '-' to
specify descending order instead of the default ascending.

=item * B<status> => I<str>

Only return records where the 'status' field equals specified value.

=item * B<status.contains> => I<str>

Only return records where the 'status' field contains specified text.

=item * B<status.in> => I<array[str]>

Only return records where the 'status' field is in the specified values.

=item * B<status.is> => I<str>

Only return records where the 'status' field equals specified value.

=item * B<status.isnt> => I<str>

Only return records where the 'status' field does not equal specified value.

=item * B<status.matches> => I<str>

Only return records where the 'status' field matches specified regular expression pattern.

=item * B<status.max> => I<str>

Only return records where the 'status' field is less than or equal to specified value.

=item * B<status.min> => I<str>

Only return records where the 'status' field is greater than or equal to specified value.

=item * B<status.not_contains> => I<str>

Only return records where the 'status' field does not contain specified text.

=item * B<status.not_in> => I<array[str]>

Only return records where the 'status' field is not in the specified values.

=item * B<status.not_matches> => I<str>

Only return records where the 'status' field does not match specified regular expression.

=item * B<status.xmax> => I<str>

Only return records where the 'status' field is less than specified value.

=item * B<status.xmin> => I<str>

Only return records where the 'status' field is greater than specified value.

=item * B<type> => I<str>

Only return records where the 'type' field equals specified value.

=item * B<type.contains> => I<str>

Only return records where the 'type' field contains specified text.

=item * B<type.in> => I<array[str]>

Only return records where the 'type' field is in the specified values.

=item * B<type.is> => I<str>

Only return records where the 'type' field equals specified value.

=item * B<type.isnt> => I<str>

Only return records where the 'type' field does not equal specified value.

=item * B<type.matches> => I<str>

Only return records where the 'type' field matches specified regular expression pattern.

=item * B<type.max> => I<str>

Only return records where the 'type' field is less than or equal to specified value.

=item * B<type.min> => I<str>

Only return records where the 'type' field is greater than or equal to specified value.

=item * B<type.not_contains> => I<str>

Only return records where the 'type' field does not contain specified text.

=item * B<type.not_in> => I<array[str]>

Only return records where the 'type' field is not in the specified values.

=item * B<type.not_matches> => I<str>

Only return records where the 'type' field does not match specified regular expression.

=item * B<type.xmax> => I<str>

Only return records where the 'type' field is less than specified value.

=item * B<type.xmin> => I<str>

Only return records where the 'type' field is greater than specified value.

=item * B<with_field_names> => I<bool>

Return field names in each record (as hashE<sol>associative array).

When enabled, function will return each record as hash/associative array
(field name => value pairs). Otherwise, function will return each record
as list/array (field value, field value, ...).


=back

Returns an enveloped result (an array).

First element ($status_code) is an integer containing HTTP-like status code
(200 means OK, 4xx caller error, 5xx function error). Second element
($reason) is a string containing error message, or something like "OK" if status is
200. Third element ($payload) is the actual result, but usually not present when enveloped result is an error response ($status_code is not 2xx). Fourth
element (%result_meta) is called result metadata and is optional, a hash
that contains extra information, much like how HTTP response headers provide additional metadata.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-BPOMUtils-Table-FoodIngredient>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-BPOMUtils-Table-FoodIngredient>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-BPOMUtils-Table-FoodIngredient>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
