{
          "lang": "curl",
          "version": null,
          "apiSections": [{"title":"Topics","anchor":"topics","gate":false,"expanded":true,"sections":[{"title":"Introduction","anchor":"intro","path":"/","gate":false,"subsections":[]},{"title":"Authentication","anchor":"authentication","path":"/authentication","gate":false,"subsections":[]},{"title":"Errors","anchor":"errors","path":"/errors","gate":false,"subsections":[{"title":"Handling errors","anchor":"error_handling","path":"/errors/handling","gate":false}]},{"title":"Expanding Objects","anchor":"expanding_objects","path":"/expanding_objects","gate":false,"subsections":[]},{"title":"Idempotent Requests","anchor":"idempotent_requests","path":"/idempotent_requests","gate":false,"subsections":[]},{"title":"Metadata","anchor":"metadata","path":"/metadata","gate":false,"subsections":[]},{"title":"Pagination","anchor":"pagination","path":"/pagination","gate":false,"subsections":[{"title":"Auto-pagination","anchor":"auto_pagination","path":"/pagination/auto","gate":false}]},{"title":"Request IDs","anchor":"request_ids","path":"/request_ids","gate":false,"subsections":[]},{"title":"Versioning","anchor":"versioning","path":"/versioning","gate":false,"subsections":[]}]},{"title":"Core Resources","anchor":"core_resources","gate":false,"expanded":true,"sections":[{"title":"Balance","anchor":"balance","path":"/balance","gate":false,"subsections":[{"title":"The balance object","anchor":"balance_object","path":"/balance/balance_object","gate":false},{"title":"Retrieve balance","anchor":"retrieve_balance","path":"/balance/balance_retrieve","gate":false}]},{"title":"Balance Transactions","anchor":"balance_transactions","path":"/balance_transactions","gate":false,"subsections":[{"title":"The balance transaction object","anchor":"balance_transaction_object","path":"/balance_transactions/object","gate":false},{"title":"Retrieve a balance transaction","anchor":"balance_transaction_retrieve","path":"/balance_transactions/retrieve","gate":false},{"title":"List all balance transactions","anchor":"balance_transaction_list","path":"/balance_transactions/list","gate":false}]},{"title":"Charges","anchor":"charges","path":"/charges","gate":false,"subsections":[{"title":"The charge object","anchor":"charge_object","path":"/charges/object","gate":false},{"title":"Create a charge","anchor":"create_charge","path":"/charges/create","gate":false},{"title":"Retrieve a charge","anchor":"retrieve_charge","path":"/charges/retrieve","gate":false},{"title":"Update a charge","anchor":"update_charge","path":"/charges/update","gate":false},{"title":"Capture a charge","anchor":"capture_charge","path":"/charges/capture","gate":false},{"title":"List all charges","anchor":"list_charges","path":"/charges/list","gate":false}]},{"title":"Customers","anchor":"customers","path":"/customers","gate":false,"subsections":[{"title":"The customer object","anchor":"customer_object","path":"/customers/object","gate":false},{"title":"Create a customer","anchor":"create_customer","path":"/customers/create","gate":false},{"title":"Retrieve a customer","anchor":"retrieve_customer","path":"/customers/retrieve","gate":false},{"title":"Update a customer","anchor":"update_customer","path":"/customers/update","gate":false},{"title":"Delete a customer","anchor":"delete_customer","path":"/customers/delete","gate":false},{"title":"List all customers","anchor":"list_customers","path":"/customers/list","gate":false}]},{"title":"Disputes","anchor":"disputes","path":"/disputes","gate":false,"subsections":[{"title":"The dispute object","anchor":"dispute_object","path":"/disputes/object","gate":false},{"title":"The dispute evidence object","anchor":"dispute_evidence_object","path":"/disputes/evidence_object","gate":false},{"title":"Retrieve a dispute","anchor":"retrieve_dispute","path":"/disputes/retrieve","gate":false},{"title":"Update a dispute","anchor":"update_dispute","path":"/disputes/update","gate":false},{"title":"Close a dispute","anchor":"close_dispute","path":"/disputes/close","gate":false},{"title":"List all disputes","anchor":"list_disputes","path":"/disputes/list","gate":false}]},{"title":"Events","anchor":"events","path":"/events","gate":false,"subsections":[{"title":"The event object","anchor":"event_object","path":"/events/object","gate":false},{"title":"Retrieve an event","anchor":"retrieve_event","path":"/events/retrieve","gate":false},{"title":"List all events","anchor":"list_events","path":"/events/list","gate":false},{"title":"Types of events","anchor":"event_types","path":"/events/types","gate":false}]},{"title":"Files","anchor":"files","path":"/files","gate":false,"subsections":[{"title":"The file object","anchor":"file_object","path":"/files/object","gate":false},{"title":"Create a file","anchor":"create_file","path":"/files/create","gate":false},{"title":"Retrieve a file","anchor":"retrieve_file","path":"/files/retrieve","gate":false},{"title":"List all files","anchor":"list_files","path":"/files/list","gate":false}]},{"title":"File Links","anchor":"file_links","path":"/file_links","gate":false,"subsections":[{"title":"The file link object","anchor":"file_link_object","path":"/file_links/object","gate":false},{"title":"Create a file link","anchor":"create_file_link","path":"/file_links/create","gate":false},{"title":"Retrieve a file link","anchor":"retrieve_file_link","path":"/file_links/retrieve","gate":false},{"title":"Update a file link","anchor":"update_file_link","path":"/file_links/update","gate":false},{"title":"List all file links","anchor":"list_file_links","path":"/file_links/list","gate":false}]},{"title":"Mandates","anchor":"mandates","path":"/mandates","gate":false,"subsections":[{"title":"The Mandates object","anchor":"mandate_object","path":"/mandates/object","gate":false},{"title":"Retrieve a Mandate","anchor":"retrieve_mandate","path":"/mandates/retrieve","gate":false}]},{"title":"PaymentIntents","anchor":"payment_intents","path":"/payment_intents","gate":false,"subsections":[{"title":"The PaymentIntent object","anchor":"payment_intent_object","path":"/payment_intents/object","gate":false},{"title":"Create a PaymentIntent","anchor":"create_payment_intent","path":"/payment_intents/create","gate":false},{"title":"Retrieve a PaymentIntent","anchor":"retrieve_payment_intent","path":"/payment_intents/retrieve","gate":false},{"title":"Update a PaymentIntent","anchor":"update_payment_intent","path":"/payment_intents/update","gate":false},{"title":"Confirm a PaymentIntent","anchor":"confirm_payment_intent","path":"/payment_intents/confirm","gate":false},{"title":"Capture a PaymentIntent","anchor":"capture_payment_intent","path":"/payment_intents/capture","gate":false},{"title":"Cancel a PaymentIntent","anchor":"cancel_payment_intent","path":"/payment_intents/cancel","gate":false},{"title":"List all PaymentIntents","anchor":"list_payment_intents","path":"/payment_intents/list","gate":false}]},{"title":"SetupIntents","anchor":"setup_intents","path":"/setup_intents","gate":false,"subsections":[{"title":"The SetupIntent object","anchor":"setup_intent_object","path":"/setup_intents/object","gate":false},{"title":"Create a SetupIntent","anchor":"create_setup_intent","path":"/setup_intents/create","gate":false},{"title":"Retrieve a SetupIntent","anchor":"retrieve_setup_intent","path":"/setup_intents/retrieve","gate":false},{"title":"Update a SetupIntent","anchor":"update_setup_intent","path":"/setup_intents/update","gate":false},{"title":"Confirm a SetupIntent","anchor":"confirm_setup_intent","path":"/setup_intents/confirm","gate":false},{"title":"Cancel a SetupIntent","anchor":"cancel_setup_intent","path":"/setup_intents/cancel","gate":false},{"title":"List all SetupIntents","anchor":"list_setup_intents","path":"/setup_intents/list","gate":false}]},{"title":"Payouts","anchor":"payouts","path":"/payouts","gate":false,"subsections":[{"title":"The payout object","anchor":"payout_object","path":"/payouts/object","gate":false},{"title":"Create a payout","anchor":"create_payout","path":"/payouts/create","gate":false},{"title":"Retrieve a payout","anchor":"retrieve_payout","path":"/payouts/retrieve","gate":false},{"title":"Update a payout","anchor":"update_payout","path":"/payouts/update","gate":false},{"title":"List all payouts","anchor":"list_payouts","path":"/payouts/list","gate":false},{"title":"Cancel a payout","anchor":"cancel_payout","path":"/payouts/cancel","gate":false},{"title":"Types of payout failures","anchor":"payout_failures","path":"/payouts/failures","gate":false}]},{"title":"Products","anchor":"products","path":"/products","gate":false,"subsections":[{"title":"The product object","anchor":"product_object","path":"/products/object","gate":false},{"title":"Create a product","anchor":"create_product","path":"/products/create","gate":false},{"title":"Retrieve a product","anchor":"retrieve_product","path":"/products/retrieve","gate":false},{"title":"Update a product","anchor":"update_product","path":"/products/update","gate":false},{"title":"List all products","anchor":"list_products","path":"/products/list","gate":false},{"title":"Delete a product","anchor":"delete_product","path":"/products/delete","gate":false}]},{"title":"Refunds","anchor":"refunds","path":"/refunds","gate":false,"subsections":[{"title":"The refund object","anchor":"refund_object","path":"/refunds/object","gate":false},{"title":"Create a refund","anchor":"create_refund","path":"/refunds/create","gate":false},{"title":"Retrieve a refund","anchor":"retrieve_refund","path":"/refunds/retrieve","gate":false},{"title":"Update a refund","anchor":"update_refund","path":"/refunds/update","gate":false},{"title":"List all refunds","anchor":"list_refunds","path":"/refunds/list","gate":false}]},{"title":"Tokens","anchor":"tokens","path":"/tokens","gate":false,"subsections":[{"title":"The token object","anchor":"token_object","path":"/tokens/object","gate":false},{"title":"Create a card token","anchor":"create_card_token","path":"/tokens/create_card","gate":false},{"title":"Create a bank account token","anchor":"create_bank_account_token","path":"/tokens/create_bank_account","gate":false},{"title":"Create a PII token","anchor":"create_pii_token","path":"/tokens/create_pii","gate":false},{"title":"Create an account token","anchor":"create_account_token","path":"/tokens/create_account","gate":false},{"title":"Create a person token","anchor":"create_person_token","path":"/tokens/create_person","gate":false},{"title":"Retrieve a token","anchor":"retrieve_token","path":"/tokens/retrieve","gate":false}]}]},{"title":"Payment Methods","anchor":"payment_methods_heading","gate":false,"expanded":true,"sections":[{"title":"PaymentMethods","anchor":"payment_methods","path":"/payment_methods","gate":false,"subsections":[{"title":"The PaymentMethod object","anchor":"payment_method_object","path":"/payment_methods/object","gate":false},{"title":"Create a PaymentMethod","anchor":"create_payment_method","path":"/payment_methods/create","gate":false},{"title":"Retrieve a PaymentMethod","anchor":"retrieve_payment_method","path":"/payment_methods/retrieve","gate":false},{"title":"Update a PaymentMethod","anchor":"update_payment_method","path":"/payment_methods/update","gate":false},{"title":"List a Customer's PaymentMethods","anchor":"list_payment_methods","path":"/payment_methods/list","gate":false},{"title":"Attach a PaymentMethod to a Customer","anchor":"customer_attach_payment_method","path":"/payment_methods/attach","gate":false},{"title":"Detach a PaymentMethod from a Customer","anchor":"customer_detach_payment_method","path":"/payment_methods/detach","gate":false}]},{"title":"Bank Accounts","anchor":"bank_accounts","path":"/customer_bank_accounts","gate":false,"subsections":[{"title":"The bank account object","anchor":"customer_bank_account_object","path":"/customer_bank_accounts/object","gate":false},{"title":"Create a bank account","anchor":"customer_create_bank_account","path":"/customer_bank_accounts/create","gate":false},{"title":"Retrieve a bank account","anchor":"customer_retrieve_bank_account","path":"/customer_bank_accounts/retrieve","gate":false},{"title":"Update a bank account","anchor":"customer_update_bank_account","path":"/customer_bank_accounts/update","gate":false},{"title":"Verify a bank account","anchor":"customer_verify_bank_account","path":"/customer_bank_accounts/verify","gate":false},{"title":"Delete a bank account","anchor":"customer_delete_bank_account","path":"/customer_bank_accounts/delete","gate":false},{"title":"List all bank accounts","anchor":"customer_list_bank_accounts","path":"/customer_bank_accounts/list","gate":false}]},{"title":"Cards","anchor":"cards","path":"/cards","gate":false,"subsections":[{"title":"The card object","anchor":"card_object","path":"/cards/object","gate":false},{"title":"Create a card","anchor":"create_card","path":"/cards/create","gate":false},{"title":"Retrieve a card","anchor":"retrieve_card","path":"/cards/retrieve","gate":false},{"title":"Update a card","anchor":"update_card","path":"/cards/update","gate":false},{"title":"Delete a card","anchor":"delete_card","path":"/cards/delete","gate":false},{"title":"List all cards","anchor":"list_cards","path":"/cards/list","gate":false}]},{"title":"Sources","anchor":"sources","path":"/sources","gate":false,"subsections":[{"title":"The source object","anchor":"source_object","path":"/sources/object","gate":false},{"title":"Create a source","anchor":"create_source","path":"/sources/create","gate":false},{"title":"Retrieve a source","anchor":"retrieve_source","path":"/sources/retrieve","gate":false},{"title":"Update a source","anchor":"update_source","path":"/sources/update","gate":false},{"title":"Attach a source","anchor":"attach_source","path":"/sources/attach","gate":false},{"title":"Detach a source","anchor":"detach_source","path":"/sources/detach","gate":false}]}]},{"title":"Checkout","anchor":"checkout","gate":false,"expanded":true,"sections":[{"title":"Sessions","anchor":"checkout_sessions","path":"/checkout/sessions","gate":false,"subsections":[{"title":"The Session object","anchor":"checkout_session_object","path":"/checkout/sessions/object","gate":false},{"title":"Create a Session","anchor":"create_checkout_session","path":"/checkout/sessions/create","gate":false},{"title":"Retrieve a Session","anchor":"retrieve_checkout_session","path":"/checkout/sessions/retrieve","gate":false}]}]},{"title":"Billing","anchor":"billing","gate":false,"expanded":true,"sections":[{"title":"Coupons","anchor":"coupons","path":"/coupons","gate":false,"subsections":[{"title":"The coupon object","anchor":"coupon_object","path":"/coupons/object","gate":false},{"title":"Create a coupon","anchor":"create_coupon","path":"/coupons/create","gate":false},{"title":"Retrieve a coupon","anchor":"retrieve_coupon","path":"/coupons/retrieve","gate":false},{"title":"Update a coupon","anchor":"update_coupon","path":"/coupons/update","gate":false},{"title":"Delete a coupon","anchor":"delete_coupon","path":"/coupons/delete","gate":false},{"title":"List all coupons","anchor":"list_coupons","path":"/coupons/list","gate":false}]},{"title":"Credit Notes","anchor":"credit_notes","path":"/credit_notes","gate":false,"subsections":[{"title":"The credit note object","anchor":"credit_note_object","path":"/credit_notes/object","gate":false},{"title":"Preview a credit note","anchor":"preview_credit_note","path":"/credit_notes/preview","gate":false},{"title":"Create a credit note","anchor":"create_credit_note","path":"/credit_notes/create","gate":false},{"title":"Retrieve a credit note","anchor":"retrieve_credit_note","path":"/credit_notes/retrieve","gate":false},{"title":"Update a credit note","anchor":"update_credit_note","path":"/credit_notes/update","gate":false},{"title":"Void a credit note","anchor":"void_credit_note","path":"/credit_notes/void","gate":false},{"title":"List all credit notes","anchor":"list_credit_notes","path":"/credit_notes/list","gate":false}]},{"title":"Customer Balance Transactions","anchor":"customer_balance_transactions","path":"/customer_balance_transactions","gate":false,"subsections":[{"title":"The customer balance transaction object","anchor":"customer_balance_transaction_object","path":"/customer_balance_transactions/object","gate":false},{"title":"Create a customer balance transaction","anchor":"create_customer_balance_transaction","path":"/customer_balance_transactions/create","gate":false},{"title":"Retrieve a customer balance transaction","anchor":"retrieve_customer_balance_transaction","path":"/customer_balance_transactions/retrieve","gate":false},{"title":"Update a customer balance transaction","anchor":"update_customer_balance_transaction","path":"/customer_balance_transactions/update","gate":false},{"title":"List customer balance transactions","anchor":"list_customer_balance_transactions","path":"/customer_balance_transactions/list","gate":false}]},{"title":"Customer Tax IDs","anchor":"customer_tax_ids","path":"/customer_tax_ids","gate":false,"subsections":[{"title":"The tax ID object","anchor":"tax_id_object","path":"/customer_tax_ids/object","gate":false},{"title":"Create a tax ID","anchor":"create_tax_id","path":"/customer_tax_ids/create","gate":false},{"title":"Retrieve a tax ID","anchor":"retrieve_tax_id","path":"/customer_tax_ids/retrieve","gate":false},{"title":"Delete a tax ID","anchor":"delete_tax_id","path":"/customer_tax_ids/delete","gate":false},{"title":"List all tax IDs","anchor":"list_tax_ids","path":"/customer_tax_ids/list","gate":false}]},{"title":"Discounts","anchor":"discounts","path":"/discounts","gate":false,"subsections":[{"title":"The discount object","anchor":"discount_object","path":"/discounts/object","gate":false},{"title":"Delete a customer discount","anchor":"delete_discount","path":"/discounts/delete","gate":false},{"title":"Delete a subscription discount","anchor":"delete_subscription_discount","path":"/discounts/subscription_delete","gate":false}]},{"title":"Invoices","anchor":"invoices","path":"/invoices","gate":false,"subsections":[{"title":"The Invoice object","anchor":"invoice_object","path":"/invoices/object","gate":false},{"title":"The (Invoice) Line Item object","anchor":"invoice_line_item_object","path":"/invoices/line_item","gate":false},{"title":"Create an invoice","anchor":"create_invoice","path":"/invoices/create","gate":false},{"title":"Retrieve an invoice","anchor":"retrieve_invoice","path":"/invoices/retrieve","gate":false},{"title":"Update an invoice","anchor":"update_invoice","path":"/invoices/update","gate":false},{"title":"Delete a draft invoice","anchor":"delete_invoice","path":"/invoices/delete","gate":false},{"title":"Finalize an invoice","anchor":"finalize_invoice","path":"/invoices/finalize","gate":false},{"title":"Pay an invoice","anchor":"pay_invoice","path":"/invoices/pay","gate":false},{"title":"Send an invoice for manual payment","anchor":"send_invoice","path":"/invoices/send","gate":false},{"title":"Void an invoice","anchor":"void_invoice","path":"/invoices/void","gate":false},{"title":"Mark an invoice as uncollectible","anchor":"mark_uncollectible_invoice","path":"/invoices/mark_uncollectible","gate":false},{"title":"Retrieve an invoice's line items","anchor":"invoice_lines","path":"/invoices/invoice_lines","gate":false},{"title":"Retrieve an upcoming invoice","anchor":"upcoming_invoice","path":"/invoices/upcoming","gate":false},{"title":"Retrieve an upcoming invoice's line items","anchor":"upcoming_invoice_lines","path":"/invoices/upcoming_invoice_lines","gate":false},{"title":"List all invoices","anchor":"list_invoices","path":"/invoices/list","gate":false}]},{"title":"Invoice Items","anchor":"invoiceitems","path":"/invoiceitems","gate":false,"subsections":[{"title":"The invoiceitem object","anchor":"invoiceitem_object","path":"/invoiceitems/object","gate":false},{"title":"Create an invoice item","anchor":"create_invoiceitem","path":"/invoiceitems/create","gate":false},{"title":"Retrieve an invoice item","anchor":"retrieve_invoiceitem","path":"/invoiceitems/retrieve","gate":false},{"title":"Update an invoice item","anchor":"update_invoiceitem","path":"/invoiceitems/update","gate":false},{"title":"Delete an invoice item","anchor":"delete_invoiceitem","path":"/invoiceitems/delete","gate":false},{"title":"List all invoice items","anchor":"list_invoiceitems","path":"/invoiceitems/list","gate":false}]},{"title":"Plans","anchor":"plans","path":"/plans","gate":false,"subsections":[{"title":"The plan object","anchor":"plan_object","path":"/plans/object","gate":false},{"title":"Create a plan","anchor":"create_plan","path":"/plans/create","gate":false},{"title":"Retrieve a plan","anchor":"retrieve_plan","path":"/plans/retrieve","gate":false},{"title":"Update a plan","anchor":"update_plan","path":"/plans/update","gate":false},{"title":"Delete a plan","anchor":"delete_plan","path":"/plans/delete","gate":false},{"title":"List all plans","anchor":"list_plans","path":"/plans/list","gate":false}]},{"title":"Products","anchor":"service_products","path":"/service_products","gate":false,"subsections":[{"title":"The product object","anchor":"service_product_object","path":"/service_products/object","gate":false},{"title":"Create a product","anchor":"create_service_product","path":"/service_products/create","gate":false},{"title":"Retrieve a product","anchor":"retrieve_service_product","path":"/service_products/retrieve","gate":false},{"title":"Update a product","anchor":"update_service_product","path":"/service_products/update","gate":false},{"title":"List all products","anchor":"list_service_products","path":"/service_products/list","gate":false},{"title":"Delete a product","anchor":"delete_service_product","path":"/service_products/delete","gate":false}]},{"title":"Subscriptions","anchor":"subscriptions","path":"/subscriptions","gate":false,"subsections":[{"title":"The subscription object","anchor":"subscription_object","path":"/subscriptions/object","gate":false},{"title":"Create a subscription","anchor":"create_subscription","path":"/subscriptions/create","gate":false},{"title":"Retrieve a subscription","anchor":"retrieve_subscription","path":"/subscriptions/retrieve","gate":false},{"title":"Update a subscription","anchor":"update_subscription","path":"/subscriptions/update","gate":false},{"title":"Cancel a subscription","anchor":"cancel_subscription","path":"/subscriptions/cancel","gate":false},{"title":"List subscriptions","anchor":"list_subscriptions","path":"/subscriptions/list","gate":false}]},{"title":"Subscription Items","anchor":"subscription_items","path":"/subscription_items","gate":false,"subsections":[{"title":"The subscription item object","anchor":"subscription_item_object","path":"/subscription_items/object","gate":false},{"title":"Create a subscription item","anchor":"create_subscription_item","path":"/subscription_items/create","gate":false},{"title":"Retrieve a subscription item","anchor":"retrieve_subscription_item","path":"/subscription_items/retrieve","gate":false},{"title":"Update a subscription item","anchor":"update_subscription_item","path":"/subscription_items/update","gate":false},{"title":"Delete a subscription item","anchor":"delete_subscription_item","path":"/subscription_items/delete","gate":false},{"title":"List all subscription items","anchor":"list_subscription_items","path":"/subscription_items/list","gate":false}]},{"title":"Subscription Schedules","anchor":"subscription_schedules","path":"/subscription_schedules","gate":false,"subsections":[{"title":"The schedule object","anchor":"subscription_schedule_object","path":"/subscription_schedules/object","gate":false},{"title":"Create a schedule","anchor":"create_subscription_schedule","path":"/subscription_schedules/create","gate":false},{"title":"Retrieve a schedule","anchor":"retrieve_subscription_schedule","path":"/subscription_schedules/retrieve","gate":false},{"title":"Update a schedule","anchor":"update_subscription_schedule","path":"/subscription_schedules/update","gate":false},{"title":"Cancel a schedule","anchor":"cancel_subscription_schedule","path":"/subscription_schedules/cancel","gate":false},{"title":"Release a schedule","anchor":"release_subscription_schedule","path":"/subscription_schedules/release","gate":false},{"title":"List all schedules","anchor":"list_subscription_schedules","path":"/subscription_schedules/list","gate":false}]},{"title":"Tax Rates","anchor":"tax_rates","path":"/tax_rates","gate":false,"subsections":[{"title":"The tax rate object","anchor":"tax_rate_object","path":"/tax_rates/object","gate":false},{"title":"Create a tax rate","anchor":"create_tax_rate","path":"/tax_rates/create","gate":false},{"title":"Retrieves a tax rate","anchor":"retrieve_tax_rate","path":"/tax_rates/retrieve","gate":false},{"title":"Update a tax rate","anchor":"update_tax_rate","path":"/tax_rates/update","gate":false},{"title":"List all tax rates","anchor":"list_tax_rates","path":"/tax_rates/list","gate":false}]},{"title":"Usage Records","anchor":"usage_records","path":"/usage_records","gate":false,"subsections":[{"title":"The usage record object","anchor":"usage_record_object","path":"/usage_records/object","gate":false},{"title":"Create a usage record","anchor":"usage_record_create","path":"/usage_records/create","gate":false},{"title":"List all subscription item period summaries","anchor":"usage_record_summary_all","path":"/usage_records/subscription_item_summary_list","gate":false}]}]},{"title":"Connect","anchor":"connect","gate":false,"expanded":true,"sections":[{"title":"Accounts","anchor":"accounts","path":"/accounts","gate":false,"subsections":[{"title":"The account object","anchor":"account_object","path":"/accounts/object","gate":false},{"title":"Create an account","anchor":"create_account","path":"/accounts/create","gate":false},{"title":"Retrieve account","anchor":"retrieve_account","path":"/accounts/retrieve","gate":false},{"title":"Update an account","anchor":"update_account","path":"/accounts/update","gate":false},{"title":"Delete an account","anchor":"delete_account","path":"/accounts/delete","gate":false},{"title":"Reject an account","anchor":"reject_account","path":"/account/reject","gate":false},{"title":"List all connected accounts","anchor":"list_accounts","path":"/accounts/list","gate":false},{"title":"The login link object","anchor":"login_link_object","path":"/account/login_link","gate":false},{"title":"Create a login link","anchor":"create_login_link","path":"/account/create_login_link","gate":false}]},{"title":"Account Links","anchor":"account_links","path":"/account_links","gate":false,"subsections":[{"title":"The account link object","anchor":"account_link_object","path":"/account_links/object","gate":false},{"title":"Create an account link","anchor":"create_account_link","path":"/account_links/create","gate":false}]},{"title":"Application Fees","anchor":"application_fees","path":"/application_fees","gate":false,"subsections":[{"title":"The application fee object","anchor":"application_fee_object","path":"/application_fees/object","gate":false},{"title":"Retrieve an application fee","anchor":"retrieve_application_fee","path":"/application_fees/retrieve","gate":false},{"title":"List all application fees","anchor":"list_application_fees","path":"/application_fees/list","gate":false}]},{"title":"Application Fee Refunds","anchor":"fee_refunds","path":"/fee_refunds","gate":false,"subsections":[{"title":"The application fee refund object","anchor":"fee_refund_object","path":"/fee_refunds/object","gate":false},{"title":"Create an application fee refund","anchor":"create_fee_refund","path":"/fee_refunds/create","gate":false},{"title":"Retrieve an application fee refund","anchor":"retrieve_fee_refund","path":"/fee_refunds/retrieve","gate":false},{"title":"Update an application fee refund","anchor":"update_fee_refund","path":"/fee_refunds/update","gate":false},{"title":"List all application fee refunds","anchor":"list_fee_refunds","path":"/fee_refunds/list","gate":false}]},{"title":"Capabilities","anchor":"capabilities","path":"/capabilities","gate":false,"subsections":[{"title":"The capability object","anchor":"capability_object","path":"/capabilities/object","gate":false},{"title":"Retrieve an Account Capability","anchor":"retrieve_capability","path":"/capabilities/retrieve","gate":false},{"title":"Update an Account Capability","anchor":"update_capability","path":"/capabilities/update","gate":false},{"title":"List all account capabilities","anchor":"list_capability","path":"/capabilities/list","gate":false}]},{"title":"Country Specs","anchor":"country_specs","path":"/country_specs","gate":false,"subsections":[{"title":"The country spec object","anchor":"country_spec_object","path":"/country_specs/object","gate":false},{"title":"List Country Specs","anchor":"list_country_specs","path":"/country_specs/list","gate":false},{"title":"Retrieve a Country Spec","anchor":"retrieve_country_spec","path":"/country_specs/retrieve","gate":false}]},{"title":"External Accounts","anchor":"external_accounts","path":"/external_accounts","gate":false,"subsections":[{"title":"The (account) bank account object","anchor":"account_bank_account_object","path":"/external_account_bank_accounts/object","gate":false},{"title":"Create a bank account","anchor":"account_create_bank_account","path":"/external_account_bank_accounts/create","gate":false},{"title":"Retrieve a bank account","anchor":"account_retrieve_bank_account","path":"/external_account_bank_accounts/retrieve","gate":false},{"title":"Update a bank account","anchor":"account_update_bank_account","path":"/external_account_bank_accounts/update","gate":false},{"title":"Delete a bank account","anchor":"account_delete_bank_account","path":"/external_account_bank_accounts/delete","gate":false},{"title":"List all bank accounts","anchor":"account_list_bank_accounts","path":"/external_account_bank_accounts/list","gate":false},{"title":"The (account) card object","anchor":"account_card_object","path":"/external_account_cards/object","gate":false},{"title":"Create a card","anchor":"account_create_card","path":"/external_account_cards/create","gate":false},{"title":"Retrieve a card","anchor":"account_retrieve_card","path":"/external_account_cards/retrieve","gate":false},{"title":"Update a card","anchor":"account_update_card","path":"/external_account_cards/update","gate":false},{"title":"Delete a card","anchor":"account_delete_card","path":"/external_account_cards/delete","gate":false},{"title":"List all cards","anchor":"account_list_cards","path":"/external_account_cards/list","gate":false}]},{"title":"Persons","anchor":"persons","path":"/persons","gate":false,"subsections":[{"title":"The person object","anchor":"person_object","path":"/persons/object","gate":false},{"title":"Create a person","anchor":"create_person","path":"/persons/create","gate":false},{"title":"Retrieve a person","anchor":"retrieve_person","path":"/persons/retrieve","gate":false},{"title":"Update a person","anchor":"update_person","path":"/persons/update","gate":false},{"title":"Delete a person","anchor":"delete_person","path":"/persons/delete","gate":false},{"title":"List all persons","anchor":"list_person","path":"/persons/list","gate":false}]},{"title":"Top-ups","anchor":"topups","path":"/topups","gate":false,"subsections":[{"title":"The top-up object","anchor":"topup_object","path":"/topups/object","gate":false},{"title":"Create a top-up","anchor":"create_topup","path":"/topups/create","gate":false},{"title":"Retrieve a top-up","anchor":"retrieve_topup","path":"/topups/retrieve","gate":false},{"title":"Update a top-up","anchor":"update_topup","path":"/topups/update","gate":false},{"title":"List all top-ups","anchor":"list_topups","path":"/topups/list","gate":false},{"title":"Cancel a top-up","anchor":"cancel_topup","path":"/topups/cancel","gate":false}]},{"title":"Transfers","anchor":"transfers","path":"/transfers","gate":false,"subsections":[{"title":"The transfer object","anchor":"transfer_object","path":"/transfers/object","gate":false},{"title":"Create a transfer","anchor":"create_transfer","path":"/transfers/create","gate":false},{"title":"Retrieve a transfer","anchor":"retrieve_transfer","path":"/transfers/retrieve","gate":false},{"title":"Update a transfer","anchor":"update_transfer","path":"/transfers/update","gate":false},{"title":"List all transfers","anchor":"list_transfers","path":"/transfers/list","gate":false}]},{"title":"Transfer Reversals","anchor":"transfer_reversals","path":"/transfer_reversals","gate":false,"subsections":[{"title":"The transfer reversal object","anchor":"transfer_reversal_object","path":"/transfer_reversals/object","gate":false},{"title":"Create a transfer reversal","anchor":"create_transfer_reversal","path":"/transfer_reversals/create","gate":false},{"title":"Retrieve a reversal","anchor":"retrieve_transfer_reversal","path":"/transfer_reversals/retrieve","gate":false},{"title":"Update a reversal","anchor":"update_transfer_reversal","path":"/transfer_reversals/update","gate":false},{"title":"List all reversals","anchor":"list_transfer_reversals","path":"/transfer_reversals/list","gate":false}]}]},{"title":"Fraud","anchor":"fraud","gate":false,"expanded":false,"sections":[{"title":"Early Fraud Warnings","anchor":"early_fraud_warnings","path":"/radar/early_fraud_warnings","gate":false,"subsections":[{"title":"The early fraud warning object","anchor":"early_fraud_warning_object","path":"/radar/early_fraud_warnings/object","gate":false},{"title":"Retrieve an early fraud warning","anchor":"retrieve_early_fraud_warning","path":"/radar/early_fraud_warnings/retrieve","gate":false},{"title":"List all early fraud warnings","anchor":"list_early_fraud_warnings","path":"/radar/early_fraud_warnings/list","gate":false}]},{"title":"Reviews","anchor":"reviews","path":"/radar/reviews","gate":false,"subsections":[{"title":"The review object","anchor":"review_object","path":"/radar/reviews/object","gate":false},{"title":"Approve a review","anchor":"approve_review","path":"/radar/reviews/approve","gate":false},{"title":"Retrieve a review","anchor":"retrieve_review","path":"/radar/reviews/retrieve","gate":false},{"title":"List all open reviews","anchor":"list_reviews","path":"/radar/reviews/list","gate":false}]},{"title":"Value Lists","anchor":"value_lists","path":"/radar/value_lists","gate":false,"subsections":[{"title":"The value list object","anchor":"radar_value_list_object","path":"/radar/value_lists/object","gate":false},{"title":"Create a value list","anchor":"create_value_list","path":"/radar/value_lists/create","gate":false},{"title":"Retrieve a value list","anchor":"retrieve_value_list","path":"/radar/value_lists/retrieve","gate":false},{"title":"Update a value list","anchor":"update_value_list","path":"/radar/value_lists/update","gate":false},{"title":"Delete a value list","anchor":"delete_value_list","path":"/radar/value_lists/delete","gate":false},{"title":"List all value lists","anchor":"list_value_lists","path":"/radar/value_lists/list","gate":false}]},{"title":"Value List Items","anchor":"value_list_items","path":"/radar/value_list_items","gate":false,"subsections":[{"title":"The value list item object","anchor":"radar_value_list_item_object","path":"/radar/value_list_items/object","gate":false},{"title":"Create a value list item","anchor":"create_value_list_item","path":"/radar/value_list_items/create","gate":false},{"title":"Retrieve a value list item","anchor":"retrieve_value_list_item","path":"/radar/value_list_items/retrieve","gate":false},{"title":"Delete a value list item","anchor":"delete_value_list_item","path":"/radar/value_list_items/delete","gate":false},{"title":"List all value list items","anchor":"list_value_list_items","path":"/radar/value_list_items/list","gate":false}]}]},{"title":"Issuing","anchor":"issuing","gate":false,"expanded":false,"sections":[{"title":"Authorizations","anchor":"issuing_authorizations","path":"/issuing/authorizations","gate":false,"subsections":[{"title":"The Authorization object","anchor":"issuing_authorization_object","path":"/issuing/authorizations/object","gate":false},{"title":"Retrieve an authorization","anchor":"retrieve_issuing_authorization","path":"/issuing/authorizations/retrieve","gate":false},{"title":"Update an authorization","anchor":"update_issuing_authorization","path":"/issuing/authorizations/update","gate":false},{"title":"Approve an authorization","anchor":"approve_issuing_authorization","path":"/issuing/authorizations/approve","gate":false},{"title":"Decline an authorization","anchor":"decline_issuing_authorization","path":"/issuing/authorizations/decline","gate":false},{"title":"List all authorizations","anchor":"list_issuing_authorizations","path":"/issuing/authorizations/list","gate":false}]},{"title":"Cardholders","anchor":"issuing_cardholders","path":"/issuing/cardholders","gate":false,"subsections":[{"title":"The Cardholder object","anchor":"issuing_cardholder_object","path":"/issuing/cardholders/object","gate":false},{"title":"Create a cardholder","anchor":"create_issuing_cardholder","path":"/issuing/cardholders/create","gate":false},{"title":"Retrieve a cardholder","anchor":"retrieve_issuing_cardholder","path":"/issuing/cardholders/retrieve","gate":false},{"title":"Update a cardholder","anchor":"update_issuing_cardholder","path":"/issuing/cardholders/update","gate":false},{"title":"List all cardholders","anchor":"list_issuing_cardholders","path":"/issuing/cardholders/list","gate":false}]},{"title":"Cards","anchor":"issuing_cards","path":"/issuing/cards","gate":false,"subsections":[{"title":"The Card object","anchor":"issuing_card_object","path":"/issuing/cards/object","gate":false},{"title":"Create a card","anchor":"create_issuing_card","path":"/issuing/cards/create","gate":false},{"title":"Retrieve a card","anchor":"retrieve_issuing_card","path":"/issuing/cards/retrieve","gate":false},{"title":"Retrieve card details","anchor":"retrieve_issuing_card_details","path":"/issuing/cards/retrieve_details","gate":false},{"title":"Update a card","anchor":"update_issuing_card","path":"/issuing/cards/update","gate":false},{"title":"List all cards","anchor":"list_issuing_cards","path":"/issuing/cards/list","gate":false}]},{"title":"Disputes","anchor":"issuing_disputes","path":"/issuing/disputes","gate":false,"subsections":[{"title":"The Dispute object","anchor":"issuing_dispute_object","path":"/issuing/disputes/object","gate":false},{"title":"Create a dispute","anchor":"create_issuing_dispute","path":"/issuing/disputes/create","gate":false},{"title":"Retrieve a dispute","anchor":"retrieve_issuing_dispute","path":"/issuing/disputes/retrieve","gate":false},{"title":"Update a dispute","anchor":"update_issuing_dispute","path":"/issuing/disputes/update","gate":false},{"title":"List all disputes","anchor":"list_issuing_disputes","path":"/issuing/disputes/list","gate":false}]},{"title":"Transactions","anchor":"issuing_transactions","path":"/issuing/transactions","gate":false,"subsections":[{"title":"The Transaction object","anchor":"issuing_transaction_object","path":"/issuing/transactions/object","gate":false},{"title":"Retrieve a transaction","anchor":"retrieve_issuing_transaction","path":"/issuing/transactions/retrieve","gate":false},{"title":"Update a transaction","anchor":"update_issuing_transaction","path":"/issuing/transactions/update","gate":false},{"title":"List all transactions","anchor":"list_issuing_transactions","path":"/issuing/transactions/list","gate":false}]}]},{"title":"Terminal","anchor":"terminal","gate":false,"expanded":false,"sections":[{"title":"Connection Tokens","anchor":"terminal_connection_tokens","path":"/terminal/connection_tokens","gate":false,"subsections":[{"title":"The connection token object","anchor":"terminal_connection_token_object","path":"/terminal/connection_tokens/object","gate":false},{"title":"Create a Connection Token","anchor":"create_terminal_connection_token","path":"/terminal/connection_tokens/create","gate":false}]},{"title":"Locations","anchor":"terminal_locations","path":"/terminal/locations","gate":false,"subsections":[{"title":"The location object","anchor":"terminal_location_object","path":"/terminal/locations/object","gate":false},{"title":"Create a Location","anchor":"create_terminal_location","path":"/terminal/locations/create","gate":false},{"title":"Retrieve a Location","anchor":"retrieve_terminal_location","path":"/terminal/locations/retrieve","gate":false},{"title":"Update a Location","anchor":"update_terminal_location","path":"/terminal/locations/update","gate":false},{"title":"Delete a Location","anchor":"delete_terminal_location","path":"/terminal/locations/delete","gate":false},{"title":"List all Locations","anchor":"list_terminal_locations","path":"/terminal/locations/list","gate":false}]},{"title":"Readers","anchor":"terminal_readers","path":"/terminal/readers","gate":false,"subsections":[{"title":"The reader object","anchor":"terminal_reader_object","path":"/terminal/readers/object","gate":false},{"title":"Create a Reader","anchor":"create_terminal_reader","path":"/terminal/readers/create","gate":false},{"title":"Retrieve a Reader","anchor":"retrieve_terminal_reader","path":"/terminal/readers/retrieve","gate":false},{"title":"Update a Reader","anchor":"update_terminal_reader","path":"/terminal/readers/update","gate":false},{"title":"Delete a Reader","anchor":"delete_terminal_reader","path":"/terminal/readers/delete","gate":false},{"title":"List all Readers","anchor":"list_terminal_reader","path":"/terminal/readers/list","gate":false}]}]},{"title":"Orders","anchor":"orders_api","gate":false,"expanded":false,"sections":[{"title":"Orders","anchor":"orders","path":"/orders","gate":false,"subsections":[{"title":"The order object","anchor":"order_object","path":"/orders/object","gate":false},{"title":"Create an order","anchor":"create_order","path":"/orders/create","gate":false},{"title":"Retrieve an order","anchor":"retrieve_order","path":"/orders/retrieve","gate":false},{"title":"Update an order","anchor":"update_order","path":"/orders/update","gate":false},{"title":"Pay an order","anchor":"pay_order","path":"/orders/pay","gate":false},{"title":"List all orders","anchor":"list_orders","path":"/orders/list","gate":false},{"title":"Return an order","anchor":"return_order","path":"/orders/return","gate":false}]},{"title":"Order Items","anchor":"order_items","path":"/order_items","gate":false,"subsections":[{"title":"The order item object","anchor":"order_item_object","path":"/order_items/object","gate":false}]},{"title":"Returns","anchor":"order_returns","path":"/order_returns","gate":false,"subsections":[{"title":"The return object","anchor":"order_return_object","path":"/order_returns/object","gate":false},{"title":"Retrieve an order return","anchor":"retrieve_order_return","path":"/order_returns/retrieve","gate":false},{"title":"List all order returns","anchor":"list_order_returns","path":"/order_returns/list","gate":false}]},{"title":"SKUs","anchor":"skus","path":"/skus","gate":false,"subsections":[{"title":"The SKU object","anchor":"sku_object","path":"/skus/object","gate":false},{"title":"Create a SKU","anchor":"create_sku","path":"/skus/create","gate":false},{"title":"Retrieve a SKU","anchor":"retrieve_sku","path":"/skus/retrieve","gate":false},{"title":"Update a SKU","anchor":"update_sku","path":"/skus/update","gate":false},{"title":"List all SKUs","anchor":"list_skus","path":"/skus/list","gate":false},{"title":"Delete a SKU","anchor":"delete_sku","path":"/skus/delete","gate":false}]}]},{"title":"Sigma","anchor":"sigma","gate":false,"expanded":false,"sections":[{"title":"Scheduled Queries","anchor":"scheduled_queries","path":"/sigma/scheduled_queries","gate":false,"subsections":[{"title":"The scheduled query run object","anchor":"scheduled_query_run_object","path":"/sigma/scheduled_queries/object","gate":false},{"title":"Retrieve a scheduled query run","anchor":"retrieve_scheduled_query_run","path":"/sigma/scheduled_queries/retrieve","gate":false},{"title":"List all scheduled query runs","anchor":"list_scheduled_query_run","path":"/sigma/scheduled_queries/list","gate":false}]}]},{"title":"Reporting","anchor":"reporting","gate":true,"expanded":true,"sections":[{"title":"Report Runs","anchor":"reporting_report_run","path":"/reporting/report_run","gate":false,"subsections":[{"title":"The Report Run object","anchor":"reporting_report_run_object","path":"/reporting/report_run/object","gate":false},{"title":"Create a Report Run","anchor":"create_reporting_report_run","path":"/reporting/report_run/create","gate":false},{"title":"Retrieve a Report Run","anchor":"retrieve_reporting_report_run","path":"/reporting/report_run/retrieve","gate":false},{"title":"List all Report Runs","anchor":"list_reporting_report_run","path":"/reporting/report_run/list","gate":false}]},{"title":"Report Types","anchor":"reporting_report_type","path":"/reporting/report_type","gate":false,"subsections":[{"title":"The Report Type object","anchor":"reporting_report_type_object","path":"/reporting/report_type/object","gate":false},{"title":"Retrieve a Report Type","anchor":"retrieve_reporting_report_type","path":"/reporting/report_type/retrieve","gate":false},{"title":"List all Report Types","anchor":"list_reporting_report_type","path":"/reporting/report_type/list","gate":false}]}]},{"title":"Webhooks","anchor":"webhooks","gate":false,"expanded":true,"sections":[{"title":"Webhook Endpoints","anchor":"webhook_endpoints","path":"/webhook_endpoints","gate":false,"subsections":[{"title":"The webhook endpoint object","anchor":"webhook_endpoint_object","path":"/webhook_endpoints/object","gate":false},{"title":"Create a webhook endpoint","anchor":"create_webhook_endpoint","path":"/webhook_endpoints/create","gate":false},{"title":"Retrieve a webhook endpoint","anchor":"retrieve_webhook_endpoint","path":"/webhook_endpoints/retrieve","gate":false},{"title":"Update a webhook endpoint","anchor":"update_webhook_endpoint","path":"/webhook_endpoints/update","gate":false},{"title":"List all webhook endpoints","anchor":"list_webhook_endpoints","path":"/webhook_endpoints/list","gate":false},{"title":"Delete a webhook endpoint","anchor":"delete_webhook_endpoints","path":"/webhook_endpoints/delete","gate":false}]}]}],
          "flattenedAPISections": {"intro":{"title":"Introduction","group_title":"Topics","group_anchor":"topics","anchor":"intro","section_anchor":"intro","subsection_anchors":[],"path":"/","gate":false,"display_on_load":true,"data":{"merchant":false,"test_key":"sk_test_4eC39HqLyjWDarjtT1zdp7dc","user_email":null,"login_as":null,"section_type":"override","section_tag":"intro","version":null}},"authentication":{"title":"Authentication","group_title":"Topics","group_anchor":"topics","anchor":"authentication","section_anchor":"authentication","subsection_anchors":[],"path":"/authentication","gate":false,"display_on_load":true,"data":{"example_explicit_api_key":"","merchant":false,"request":"curl https://api.stripe.com/v1/charges \\\n  -u sk_test_4eC39HqLyjWDarjtT1zdp7dc:\n# The colon prevents curl from asking for a password.","test_key":"sk_test_4eC39HqLyjWDarjtT1zdp7dc","section_type":"override","section_tag":"authentication","version":null}},"errors":{"title":"Errors","group_title":"Topics","group_anchor":"topics","anchor":"errors","section_anchor":"errors","subsection_anchors":["error_handling"],"path":"/errors","gate":false,"display_on_load":true,"data":{"changes":{},"specs":{"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"The type of error returned. One of `api_connection_error`, `api_error`, `authentication_error`, `card_error`, `idempotency_error`, `invalid_request_error`, or `rate_limit_error`","html":"The type of error returned. One of \u003Ccode\u003Eapi_connection_error\u003C/code\u003E, \u003Ccode\u003Eapi_error\u003C/code\u003E, \u003Ccode\u003Eauthentication_error\u003C/code\u003E, \u003Ccode\u003Ecard_error\u003C/code\u003E, \u003Ccode\u003Eidempotency_error\u003C/code\u003E, \u003Ccode\u003Einvalid_request_error\u003C/code\u003E, or \u003Ccode\u003Erate_limit_error\u003C/code\u003E"},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"type"},"charge":{"name":"charge","check":"string","validation":"string","documentation":{"markdown":"For card errors, the ID of the failed charge.","html":"For card errors, the ID of the failed charge."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"charge"},"code":{"name":"code","check":"string","validation":"string","documentation":{"markdown":"For some errors that could be handled programmatically, a short string indicating the [error code](/docs/error-codes) reported.","html":"For some errors that could be handled programmatically, a short string indicating the \u003Ca href=\"/docs/error-codes\"\u003Eerror code\u003C/a\u003E reported."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"code"},"decline_code":{"name":"decline_code","check":"string","validation":"string","documentation":{"markdown":"For card errors resulting from a card issuer decline, a short string indicating the [card issuer's reason for the decline](/docs/declines#issuer-declines) if they provide one.","html":"For card errors resulting from a card issuer decline, a short string indicating the \u003Ca href=\"/docs/declines#issuer-declines\"\u003Ecard issuer’s reason for the decline\u003C/a\u003E if they provide one."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"decline_code"},"doc_url":{"name":"doc_url","check":"string","validation":"string","documentation":{"markdown":"A URL to more information about the [error code](/docs/error-codes) reported.","html":"A URL to more information about the \u003Ca href=\"/docs/error-codes\"\u003Eerror code\u003C/a\u003E reported."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"doc_url"},"message":{"name":"message","check":"string","validation":"string","documentation":{"markdown":"A human-readable message providing more details about the error. For card errors, these messages can be shown to your users.","html":"A human-readable message providing more details about the error. For card errors, these messages can be shown to your users."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"message"},"param":{"name":"param","check":"string","validation":"string","documentation":{"markdown":"If the error is parameter-specific, the parameter related to the error. For example, you can use this to display a message near the correct form field.","html":"If the error is parameter-specific, the parameter related to the error. For example, you can use this to display a message near the correct form field."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"param"},"payment_intent":{"name":"payment_intent","check":"hash","validation":"hash","documentation":{"markdown":"The PaymentIntent object for errors returned on a request involving a PaymentIntent.","html":"The PaymentIntent object for errors returned on a request involving a PaymentIntent."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"payment_intent","subspec":{"id":{"name":"id","check":"string","validation":"string","documentation":{"markdown":"Unique identifier for the object.","html":"Unique identifier for the object."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"id"},"object":{"name":"object","check":"string","validation":"string","documentation":{"markdown":"String representing the object's type. Objects of the same type share the same value.","html":"String representing the object’s type. Objects of the same type share the same value."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"object"},"amount":{"name":"amount","check":"integer","validation":"integer","documentation":{"markdown":"Amount intended to be collected by this PaymentIntent. A positive integer representing how much to charge in the [smallest currency unit](/docs/currencies#zero-decimal) (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The minimum amount is $0.50 US or [equivalent in charge currency](/docs/currencies#minimum-and-maximum-charge-amounts). The amount value supports up to eight digits (e.g., a value of 99999999 for a USD charge of $999,999.99).","html":"Amount intended to be collected by this PaymentIntent. A positive integer representing how much to charge in the \u003Ca href=\"/docs/currencies#zero-decimal\"\u003Esmallest currency unit\u003C/a\u003E (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The minimum amount is $0.50 US or \u003Ca href=\"/docs/currencies#minimum-and-maximum-charge-amounts\"\u003Eequivalent in charge currency\u003C/a\u003E. The amount value supports up to eight digits (e.g., a value of 99999999 for a USD charge of $999,999.99)."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"amount"},"amount_capturable":{"name":"amount_capturable","check":"integer","validation":"integer","documentation":{"markdown":"Amount that can be captured from this PaymentIntent.","html":"Amount that can be captured from this PaymentIntent."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"amount_capturable"},"amount_received":{"name":"amount_received","check":"integer","validation":"integer","documentation":{"markdown":"Amount that was collected by this PaymentIntent.","html":"Amount that was collected by this PaymentIntent."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"amount_received"},"application":{"name":"application","check":"string","validation":"string","documentation":{"markdown":"ID of the Connect application that created the PaymentIntent.","html":"ID of the Connect application that created the PaymentIntent."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"user_expandable":["application"],"object_type":"application"},"application_fee_amount":{"name":"application_fee_amount","check":"integer","validation":"integer","documentation":{"markdown":"The amount of the application fee (if any) for the resulting payment. See the PaymentIntents [use case for connected accounts](/docs/payments/connected-accounts) for details.","html":"The amount of the application fee (if any) for the resulting payment. See the PaymentIntents \u003Ca href=\"/docs/payments/connected-accounts\"\u003Euse case for connected accounts\u003C/a\u003E for details."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"application_fee_amount"},"canceled_at":{"name":"canceled_at","check":"timestamp","validation":"timestamp","documentation":{"markdown":"Populated when `status` is `canceled`, this is the time at which the PaymentIntent was canceled. Measured in seconds since the Unix epoch.","html":"Populated when \u003Ccode\u003Estatus\u003C/code\u003E is \u003Ccode\u003Ecanceled\u003C/code\u003E, this is the time at which the PaymentIntent was canceled. Measured in seconds since the Unix epoch."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"canceled_at"},"cancellation_reason":{"name":"cancellation_reason","check":"string","validation":"string","documentation":{"markdown":"Reason for cancellation of this PaymentIntent, either user-provided (`duplicate`, `fraudulent`, `requested_by_customer`, or `abandoned`) or generated by Stripe internally (`failed_invoice`, `void_invoice`, or `automatic`).","html":"Reason for cancellation of this PaymentIntent, either user-provided (\u003Ccode\u003Eduplicate\u003C/code\u003E, \u003Ccode\u003Efraudulent\u003C/code\u003E, \u003Ccode\u003Erequested_by_customer\u003C/code\u003E, or \u003Ccode\u003Eabandoned\u003C/code\u003E) or generated by Stripe internally (\u003Ccode\u003Efailed_invoice\u003C/code\u003E, \u003Ccode\u003Evoid_invoice\u003C/code\u003E, or \u003Ccode\u003Eautomatic\u003C/code\u003E)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"cancellation_reason"},"capture_method":{"name":"capture_method","check":"string","validation":"string","documentation":{"markdown":"Controls when the funds will be captured from the customer's account.\n","html":"Controls when the funds will be captured from the customer’s account."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"enum_values":{"automatic":{"documentation":{"markdown":"(Default) Stripe automatically captures funds when the customer authorizes the payment.","html":"(Default) Stripe automatically captures funds when the customer authorizes the payment."}},"manual":{"documentation":{"markdown":"Place a hold on the funds when the customer authorizes the payment, but [don't capture the funds until later](/docs/payments/capture-later). (Not all payment methods support this.)","html":"Place a hold on the funds when the customer authorizes the payment, but \u003Ca href=\"/docs/payments/capture-later\"\u003Edon’t capture the funds until later\u003C/a\u003E. (Not all payment methods support this.)"}}},"object_type":"capture_method"},"charges":{"name":"charges","check":"hash","validation":"hash","documentation":{"markdown":"Charges that were created by this PaymentIntent, if any.","html":"Charges that were created by this PaymentIntent, if any."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"object":{"name":"object","check":"string","validation":"string","documentation":{"markdown":"String representing the object's type. Objects of the same type share the same value. Always has the value `list`.","html":"String representing the object’s type. Objects of the same type share the same value. Always has the value \u003Ccode\u003Elist\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"object"},"data":{"name":"data","check":"array","validation":"array","documentation":{"markdown":"This list only contains the latest charge, even if there were previously multiple unsuccessful charges. To view all previous charges for a PaymentIntent, you can filter the charges list using the `payment_intent` [parameter](/docs/api/charges/list#list_charges-payment_intent).","html":"This list only contains the latest charge, even if there were previously multiple unsuccessful charges. To view all previous charges for a PaymentIntent, you can filter the charges list using the \u003Ccode\u003Epayment_intent\u003C/code\u003E \u003Ca href=\"/docs/api/charges/list#list_charges-payment_intent\"\u003Eparameter\u003C/a\u003E."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"resource_type":"charge","object_type":"charge"},"has_more":{"name":"has_more","check":"boolean","validation":"boolean","documentation":{"markdown":"True if this list has another page of items after this one that can be fetched.","html":"True if this list has another page of items after this one that can be fetched."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"has_more"},"url":{"name":"url","check":"string","validation":"string","documentation":{"markdown":"The URL where this list can be accessed.","html":"The URL where this list can be accessed."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"url"}},"object_type":"list"},"client_secret":{"name":"client_secret","check":"string","validation":"string","documentation":{"markdown":"The client secret of this PaymentIntent. Used for client-side retrieval using a publishable key. \n\nThe client secret can be used to complete a payment from your frontend. It should not be stored, logged, embedded in URLs, or exposed to anyone other than the customer. Make sure that you have TLS enabled on any page that includes the client secret.\n\nRefer to our docs to [accept a payment](/docs/payments/accept-a-payment) and learn about how `client_secret` should be handled.","html":"The client secret of this PaymentIntent. Used for client-side retrieval using a publishable key. \u003C/p\u003E\n\n\u003Cp\u003EThe client secret can be used to complete a payment from your frontend. It should not be stored, logged, embedded in URLs, or exposed to anyone other than the customer. Make sure that you have TLS enabled on any page that includes the client secret.\u003C/p\u003E\n\n\u003Cp\u003ERefer to our docs to \u003Ca href=\"/docs/payments/accept-a-payment\"\u003Eaccept a payment\u003C/a\u003E and learn about how \u003Ccode\u003Eclient_secret\u003C/code\u003E should be handled."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"client_secret"},"confirmation_method":{"name":"confirmation_method","check":"string","validation":"string","documentation":{"markdown":"","html":""},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"enum_values":{"manual":{"documentation":{"markdown":"All payment attempts must be made using a secret key. The PaymentIntent returns to the `requires_confirmation` state after handling `next_action`s, and requires your server to initiate each payment attempt with an explicit confirmation.","html":"All payment attempts must be made using a secret key. The PaymentIntent returns to the \u003Ccode\u003Erequires_confirmation\u003C/code\u003E state after handling \u003Ccode\u003Enext_action\u003C/code\u003Es, and requires your server to initiate each payment attempt with an explicit confirmation."}},"automatic":{"documentation":{"markdown":"(Default) PaymentIntent can be confirmed using a publishable key. After `next_action`s are handled, no additional confirmation is required to complete the payment.","html":"(Default) PaymentIntent can be confirmed using a publishable key. After \u003Ccode\u003Enext_action\u003C/code\u003Es are handled, no additional confirmation is required to complete the payment."}}},"object_type":"confirmation_method"},"created":{"name":"created","check":"timestamp","validation":"timestamp","documentation":{"markdown":"Time at which the object was created. Measured in seconds since the Unix epoch.","html":"Time at which the object was created. Measured in seconds since the Unix epoch."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"created"},"currency":{"name":"currency","check":"currency","validation":"currency","documentation":{"markdown":"Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).","html":"Three-letter \u003Ca href=\"https://www.iso.org/iso-4217-currency-codes.html\"\u003EISO currency code\u003C/a\u003E, in lowercase. Must be a \u003Ca href=\"https://stripe.com/docs/currencies\"\u003Esupported currency\u003C/a\u003E."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"currency"},"customer":{"name":"customer","check":"string","validation":"string","documentation":{"markdown":"ID of the Customer this PaymentIntent belongs to, if one exists.\n\nIf present, payment methods used with this PaymentIntent can only be attached to this Customer, and payment methods attached to other Customers cannot be used with this PaymentIntent.\n","html":"ID of the Customer this PaymentIntent belongs to, if one exists.\u003C/p\u003E\n\n\u003Cp\u003EIf present, payment methods used with this PaymentIntent can only be attached to this Customer, and payment methods attached to other Customers cannot be used with this PaymentIntent."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"user_expandable":["customer"],"object_type":"customer"},"description":{"name":"description","check":"string","validation":"string","documentation":{"markdown":"An arbitrary string attached to the object. Often useful for displaying to users.","html":"An arbitrary string attached to the object. Often useful for displaying to users."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"description"},"invoice":{"name":"invoice","check":"string","validation":"string","documentation":{"markdown":"ID of the invoice that created this PaymentIntent, if it exists.","html":"ID of the invoice that created this PaymentIntent, if it exists."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"user_expandable":["invoice"],"object_type":"invoice"},"last_payment_error":{"name":"last_payment_error","check":"hash","validation":"hash","documentation":{"markdown":"The payment error encountered in the previous PaymentIntent confirmation. It will be cleared if the PaymentIntent is later updated for any reason.","html":"The payment error encountered in the previous PaymentIntent confirmation. It will be cleared if the PaymentIntent is later updated for any reason."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"charge":{"name":"charge","check":"string","validation":"string","documentation":{"markdown":"For card errors, the ID of the failed charge.","html":"For card errors, the ID of the failed charge."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"charge"},"code":{"name":"code","check":"string","validation":"string","documentation":{"markdown":"For some errors that could be handled programmatically, a short string indicating the [error code](/docs/error-codes) reported.","html":"For some errors that could be handled programmatically, a short string indicating the \u003Ca href=\"/docs/error-codes\"\u003Eerror code\u003C/a\u003E reported."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"code"},"decline_code":{"name":"decline_code","check":"string","validation":"string","documentation":{"markdown":"For card errors resulting from a card issuer decline, a short string indicating the [card issuer's reason for the decline](/docs/declines#issuer-declines) if they provide one.","html":"For card errors resulting from a card issuer decline, a short string indicating the \u003Ca href=\"/docs/declines#issuer-declines\"\u003Ecard issuer’s reason for the decline\u003C/a\u003E if they provide one."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"decline_code"},"doc_url":{"name":"doc_url","check":"string","validation":"string","documentation":{"markdown":"A URL to more information about the [error code](/docs/error-codes) reported.","html":"A URL to more information about the \u003Ca href=\"/docs/error-codes\"\u003Eerror code\u003C/a\u003E reported."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"doc_url"},"message":{"name":"message","check":"string","validation":"string","documentation":{"markdown":"A human-readable message providing more details about the error. For card errors, these messages can be shown to your users.","html":"A human-readable message providing more details about the error. For card errors, these messages can be shown to your users."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"message"},"param":{"name":"param","check":"string","validation":"string","documentation":{"markdown":"If the error is parameter-specific, the parameter related to the error. For example, you can use this to display a message near the correct form field.","html":"If the error is parameter-specific, the parameter related to the error. For example, you can use this to display a message near the correct form field."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"param"},"payment_method":{"name":"payment_method","check":"hash","validation":"hash","documentation":{"markdown":"The PaymentMethod object for errors returned on a request involving a PaymentMethod.","html":"The PaymentMethod object for errors returned on a request involving a PaymentMethod."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"id":{"name":"id","check":"string","validation":"string","documentation":{"markdown":"Unique identifier for the object.","html":"Unique identifier for the object."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"id"},"object":{"name":"object","check":"string","validation":"string","documentation":{"markdown":"String representing the object's type. Objects of the same type share the same value.","html":"String representing the object’s type. Objects of the same type share the same value."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"object"},"billing_details":{"name":"billing_details","check":"hash","validation":"hash","documentation":{"markdown":"Billing information associated with the PaymentMethod that may be used or required by particular types of payment methods.","html":"Billing information associated with the PaymentMethod that may be used or required by particular types of payment methods."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"address":{"name":"address","check":"hash","validation":"hash","documentation":{"markdown":"Billing address.","html":"Billing address."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"address"},"email":{"name":"email","check":"string","validation":"string","documentation":{"markdown":"Email address.","html":"Email address."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"email"},"name":{"name":"name","check":"string","validation":"string","documentation":{"markdown":"Full name.","html":"Full name."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"name"},"phone":{"name":"phone","check":"string","validation":"string","documentation":{"markdown":"Billing phone number (including extension).","html":"Billing phone number (including extension)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"phone"}},"object_type":"billing_details"},"card":{"name":"card","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `card` PaymentMethod, this hash contains details about the card.","html":"If this is a \u003Ccode\u003Ecard\u003C/code\u003E PaymentMethod, this hash contains details about the card."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"brand":{"name":"brand","check":"string","validation":"string","documentation":{"markdown":"Card brand. Can be `amex`, `diners`, `discover`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.","html":"Card brand. Can be \u003Ccode\u003Eamex\u003C/code\u003E, \u003Ccode\u003Ediners\u003C/code\u003E, \u003Ccode\u003Ediscover\u003C/code\u003E, \u003Ccode\u003Ejcb\u003C/code\u003E, \u003Ccode\u003Emastercard\u003C/code\u003E, \u003Ccode\u003Eunionpay\u003C/code\u003E, \u003Ccode\u003Evisa\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"brand"},"checks":{"name":"checks","check":"hash","validation":"hash","documentation":{"markdown":"Checks on Card address and CVC if provided.","html":"Checks on Card address and CVC if provided."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"address_line1_check":{"name":"address_line1_check","check":"string","validation":"string","documentation":{"markdown":"If a address line1 was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.","html":"If a address line1 was provided, results of the check, one of \u003Ccode\u003Epass\u003C/code\u003E, \u003Ccode\u003Efail\u003C/code\u003E, \u003Ccode\u003Eunavailable\u003C/code\u003E, or \u003Ccode\u003Eunchecked\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"address_line1_check"},"address_postal_code_check":{"name":"address_postal_code_check","check":"string","validation":"string","documentation":{"markdown":"If a address postal code was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.","html":"If a address postal code was provided, results of the check, one of \u003Ccode\u003Epass\u003C/code\u003E, \u003Ccode\u003Efail\u003C/code\u003E, \u003Ccode\u003Eunavailable\u003C/code\u003E, or \u003Ccode\u003Eunchecked\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"address_postal_code_check"},"cvc_check":{"name":"cvc_check","check":"string","validation":"string","documentation":{"markdown":"If a CVC was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.","html":"If a CVC was provided, results of the check, one of \u003Ccode\u003Epass\u003C/code\u003E, \u003Ccode\u003Efail\u003C/code\u003E, \u003Ccode\u003Eunavailable\u003C/code\u003E, or \u003Ccode\u003Eunchecked\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"cvc_check"}},"object_type":"checks"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.","html":"Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you’ve collected."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"exp_month":{"name":"exp_month","check":"integer","validation":"integer","documentation":{"markdown":"Two-digit number representing the card's expiration month.","html":"Two-digit number representing the card’s expiration month."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"exp_month"},"exp_year":{"name":"exp_year","check":"integer","validation":"integer","documentation":{"markdown":"Four-digit number representing the card's expiration year.","html":"Four-digit number representing the card’s expiration year."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"exp_year"},"fingerprint":{"name":"fingerprint","check":"string","validation":"string","documentation":{"markdown":"Uniquely identifies this particular card number. You can use this attribute to check whether two customers who've signed up with you are using the same card number, for example.","html":"Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":"card_fingerprint_read","hide_nil":null,"is_country_specific":false,"object_type":"fingerprint"},"funding":{"name":"funding","check":"string","validation":"string","documentation":{"markdown":"Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.","html":"Card funding type. Can be \u003Ccode\u003Ecredit\u003C/code\u003E, \u003Ccode\u003Edebit\u003C/code\u003E, \u003Ccode\u003Eprepaid\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"funding"},"generated_from":{"name":"generated_from","check":"hash","validation":"hash","documentation":{"markdown":"Details of the original PaymentMethod that created this object.","html":"Details of the original PaymentMethod that created this object.","gate_specific":{"sdk_client_public":{"undocumented":true}}},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"charge":{"name":"charge","check":"string","validation":"string","documentation":{"markdown":"The charge that created this object.","html":"The charge that created this object."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"charge"},"payment_method_details":{"name":"payment_method_details","check":"hash","validation":"hash","documentation":{"markdown":"Transaction-specific details of the payment method used in the payment.","html":"Transaction-specific details of the payment method used in the payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"ach_credit_transfer":{"name":"ach_credit_transfer","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `ach_credit_transfer` payment, this hash contains a snapshot of the transaction specific details of the `ach_credit_transfer` payment method.","html":"If this is a \u003Ccode\u003Each_credit_transfer\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Each_credit_transfer\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"account_number":{"name":"account_number","check":"string","validation":"string","documentation":{"markdown":"Account number to transfer funds to.","html":"Account number to transfer funds to."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"account_number"},"bank_name":{"name":"bank_name","check":"string","validation":"string","documentation":{"markdown":"Name of the bank associated with the routing number.","html":"Name of the bank associated with the routing number."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_name"},"routing_number":{"name":"routing_number","check":"string","validation":"string","documentation":{"markdown":"Routing transit number for the bank account to transfer funds to.","html":"Routing transit number for the bank account to transfer funds to."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"routing_number"},"swift_code":{"name":"swift_code","check":"string","validation":"string","documentation":{"markdown":"SWIFT code of the bank associated with the routing number.","html":"SWIFT code of the bank associated with the routing number."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"swift_code"}},"object_type":"ach_credit_transfer"},"ach_debit":{"name":"ach_debit","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `ach_debit` payment, this hash contains a snapshot of the transaction specific details of the `ach_debit` payment method.","html":"If this is a \u003Ccode\u003Each_debit\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Each_debit\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"account_holder_type":{"name":"account_holder_type","check":"string","validation":"string","documentation":{"markdown":"Type of entity that holds the account. This can be either `individual` or `company`.","html":"Type of entity that holds the account. This can be either \u003Ccode\u003Eindividual\u003C/code\u003E or \u003Ccode\u003Ecompany\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"account_holder_type"},"bank_name":{"name":"bank_name","check":"string","validation":"string","documentation":{"markdown":"Name of the bank associated with the bank account.","html":"Name of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_name"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country the bank account is located in.","html":"Two-letter ISO code representing the country the bank account is located in."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"fingerprint":{"name":"fingerprint","check":"string","validation":"string","documentation":{"markdown":"Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.","html":"Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"fingerprint"},"last4":{"name":"last4","check":"string","validation":"string","documentation":{"markdown":"Last four digits of the bank account number.","html":"Last four digits of the bank account number."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"last4"},"routing_number":{"name":"routing_number","check":"string","validation":"string","documentation":{"markdown":"Routing transit number of the bank account.","html":"Routing transit number of the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"routing_number"}},"object_type":"ach_debit"},"alipay":{"name":"alipay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `alipay` payment, this hash contains a snapshot of the transaction specific details of the `alipay` payment method.","html":"If this is a \u003Ccode\u003Ealipay\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Ealipay\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"alipay"},"bancontact":{"name":"bancontact","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `bancontact` payment, this hash contains a snapshot of the transaction specific details of the `bancontact` payment method.","html":"If this is a \u003Ccode\u003Ebancontact\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Ebancontact\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank_code":{"name":"bank_code","check":"string","validation":"string","documentation":{"markdown":"Bank code of bank associated with the bank account.","html":"Bank code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_code"},"bank_name":{"name":"bank_name","check":"string","validation":"string","documentation":{"markdown":"Name of the bank associated with the bank account.","html":"Name of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_name"},"bic":{"name":"bic","check":"string","validation":"string","documentation":{"markdown":"Bank Identifier Code of the bank associated with the bank account.","html":"Bank Identifier Code of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bic"},"iban_last4":{"name":"iban_last4","check":"string","validation":"string","documentation":{"markdown":"Last four characters of the IBAN.","html":"Last four characters of the IBAN."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"iban_last4"},"preferred_language":{"name":"preferred_language","check":"string","validation":"string","documentation":{"markdown":"Preferred language of the Bancontact authorization page that the customer is redirected to.\nCan be one of `en`, `de`, `fr`, or `nl`\n","html":"Preferred language of the Bancontact authorization page that the customer is redirected to.\nCan be one of \u003Ccode\u003Een\u003C/code\u003E, \u003Ccode\u003Ede\u003C/code\u003E, \u003Ccode\u003Efr\u003C/code\u003E, or \u003Ccode\u003Enl\u003C/code\u003E"},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"preferred_language"},"verified_name":{"name":"verified_name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by Bancontact directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated.\n","html":"Owner’s verified full name. Values are verified or provided by Bancontact directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"verified_name"}},"object_type":"bancontact"},"card":{"name":"card","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `card` payment, this hash contains a snapshot of the transaction specific details of the `card` payment method.","html":"If this is a \u003Ccode\u003Ecard\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Ecard\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"brand":{"name":"brand","check":"string","validation":"string","documentation":{"markdown":"Card brand. Can be `amex`, `diners`, `discover`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.","html":"Card brand. Can be \u003Ccode\u003Eamex\u003C/code\u003E, \u003Ccode\u003Ediners\u003C/code\u003E, \u003Ccode\u003Ediscover\u003C/code\u003E, \u003Ccode\u003Ejcb\u003C/code\u003E, \u003Ccode\u003Emastercard\u003C/code\u003E, \u003Ccode\u003Eunionpay\u003C/code\u003E, \u003Ccode\u003Evisa\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"brand"},"checks":{"name":"checks","check":"hash","validation":"hash","documentation":{"markdown":"Check results by Card networks on Card address and CVC at time of payment.","html":"Check results by Card networks on Card address and CVC at time of payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"address_line1_check":{"name":"address_line1_check","check":"string","validation":"string","documentation":{"markdown":"If a address line1 was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.","html":"If a address line1 was provided, results of the check, one of \u003Ccode\u003Epass\u003C/code\u003E, \u003Ccode\u003Efail\u003C/code\u003E, \u003Ccode\u003Eunavailable\u003C/code\u003E, or \u003Ccode\u003Eunchecked\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"address_line1_check"},"address_postal_code_check":{"name":"address_postal_code_check","check":"string","validation":"string","documentation":{"markdown":"If a address postal code was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.","html":"If a address postal code was provided, results of the check, one of \u003Ccode\u003Epass\u003C/code\u003E, \u003Ccode\u003Efail\u003C/code\u003E, \u003Ccode\u003Eunavailable\u003C/code\u003E, or \u003Ccode\u003Eunchecked\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"address_postal_code_check"},"cvc_check":{"name":"cvc_check","check":"string","validation":"string","documentation":{"markdown":"If a CVC was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.","html":"If a CVC was provided, results of the check, one of \u003Ccode\u003Epass\u003C/code\u003E, \u003Ccode\u003Efail\u003C/code\u003E, \u003Ccode\u003Eunavailable\u003C/code\u003E, or \u003Ccode\u003Eunchecked\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"cvc_check"}},"object_type":"checks"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.","html":"Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you’ve collected."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"exp_month":{"name":"exp_month","check":"integer","validation":"integer","documentation":{"markdown":"Two-digit number representing the card's expiration month.","html":"Two-digit number representing the card’s expiration month."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"exp_month"},"exp_year":{"name":"exp_year","check":"integer","validation":"integer","documentation":{"markdown":"Four-digit number representing the card's expiration year.","html":"Four-digit number representing the card’s expiration year."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"exp_year"},"fingerprint":{"name":"fingerprint","check":"string","validation":"string","documentation":{"markdown":"Uniquely identifies this particular card number. You can use this attribute to check whether two customers who've signed up with you are using the same card number, for example.","html":"Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":"card_fingerprint_read","hide_nil":null,"is_country_specific":false,"object_type":"fingerprint"},"funding":{"name":"funding","check":"string","validation":"string","documentation":{"markdown":"Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.","html":"Card funding type. Can be \u003Ccode\u003Ecredit\u003C/code\u003E, \u003Ccode\u003Edebit\u003C/code\u003E, \u003Ccode\u003Eprepaid\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"funding"},"installments":{"name":"installments","check":"hash","validation":"hash","documentation":{"markdown":"Installment details for this payment (Mexico only).\n\nFor more information, see the [installments integration guide](/docs/payments/installments).\n","html":"Installment details for this payment (Mexico only).\u003C/p\u003E\n\n\u003Cp\u003EFor more information, see the \u003Ca href=\"/docs/payments/installments\"\u003Einstallments integration guide\u003C/a\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"plan":{"name":"plan","check":"hash","validation":"hash","documentation":{"markdown":"Installment plan selected for the payment.","html":"Installment plan selected for the payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"count":{"name":"count","check":"integer","validation":"integer","documentation":{"markdown":"For `fixed_count` installment plans, this is the number of installment payments your customer will make to their credit card.","html":"For \u003Ccode\u003Efixed_count\u003C/code\u003E installment plans, this is the number of installment payments your customer will make to their credit card."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"count"},"interval":{"name":"interval","check":"string","validation":"string","documentation":{"markdown":"For `fixed_count` installment plans, this is the interval between installment payments your customer will make to their credit card.\nOne of `month`.\n","html":"For \u003Ccode\u003Efixed_count\u003C/code\u003E installment plans, this is the interval between installment payments your customer will make to their credit card.\nOne of \u003Ccode\u003Emonth\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"interval"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"Type of installment plan, one of `fixed_count`.","html":"Type of installment plan, one of \u003Ccode\u003Efixed_count\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"type"}},"object_type":"plan"}},"object_type":"installments"},"last4":{"name":"last4","check":"string","validation":"string","documentation":{"markdown":"The last four digits of the card.","html":"The last four digits of the card."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"last4"},"network":{"name":"network","check":"string","validation":"string","documentation":{"markdown":"Identifies which network this charge was processed on. Can be `amex`, `diners`, `discover`, `interac`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.","html":"Identifies which network this charge was processed on. Can be \u003Ccode\u003Eamex\u003C/code\u003E, \u003Ccode\u003Ediners\u003C/code\u003E, \u003Ccode\u003Ediscover\u003C/code\u003E, \u003Ccode\u003Einterac\u003C/code\u003E, \u003Ccode\u003Ejcb\u003C/code\u003E, \u003Ccode\u003Emastercard\u003C/code\u003E, \u003Ccode\u003Eunionpay\u003C/code\u003E, \u003Ccode\u003Evisa\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"network"},"three_d_secure":{"name":"three_d_secure","check":"hash","validation":"hash","documentation":{"markdown":"Populated if this transaction used 3D Secure authentication.","html":"Populated if this transaction used 3D Secure authentication."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"authenticated":{"name":"authenticated","check":"boolean","validation":"boolean","documentation":{"markdown":"Whether or not authentication was performed. 3D Secure will succeed without authentication when the card is not enrolled.","html":"Whether or not authentication was performed. 3D Secure will succeed without authentication when the card is not enrolled."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"authenticated"},"succeeded":{"name":"succeeded","check":"boolean","validation":"boolean","documentation":{"markdown":"Whether or not 3D Secure succeeded.","html":"Whether or not 3D Secure succeeded."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"succeeded"},"version":{"name":"version","check":"string","validation":"string","documentation":{"markdown":"The version of 3D Secure that was used for this payment.","html":"The version of 3D Secure that was used for this payment."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"version"}},"object_type":"three_d_secure"},"wallet":{"name":"wallet","check":"hash","validation":"hash","documentation":{"markdown":"If this Card is part of a card wallet, this contains the details of the card wallet.","html":"If this Card is part of a card wallet, this contains the details of the card wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"amex_express_checkout":{"name":"amex_express_checkout","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `amex_express_checkout` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Eamex_express_checkout\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"amex_express_checkout"},"apple_pay":{"name":"apple_pay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `apple_pay` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Eapple_pay\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"apple_pay"},"dynamic_last4":{"name":"dynamic_last4","check":"string","validation":"string","documentation":{"markdown":"(For tokenized numbers only.) The last four digits of the device account number.","html":"(For tokenized numbers only.) The last four digits of the device account number."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"dynamic_last4"},"google_pay":{"name":"google_pay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `google_pay` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Egoogle_pay\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"google_pay"},"masterpass":{"name":"masterpass","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `masterpass` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Emasterpass\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"billing_address":{"name":"billing_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"billing_address"},"email":{"name":"email","check":"string","validation":"string","documentation":{"markdown":"Owner's verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"email"},"name":{"name":"name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"name"},"shipping_address":{"name":"shipping_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"shipping_address"}},"object_type":"masterpass"},"samsung_pay":{"name":"samsung_pay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `samsung_pay` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Esamsung_pay\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"samsung_pay"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"The type of the card wallet, one of `amex_express_checkout`, `apple_pay`, `google_pay`, `masterpass`, `samsung_pay`, or `visa_checkout`. An additional hash is included on the Wallet subhash with a name matching this value. It contains additional information specific to the card wallet type.","html":"The type of the card wallet, one of \u003Ccode\u003Eamex_express_checkout\u003C/code\u003E, \u003Ccode\u003Eapple_pay\u003C/code\u003E, \u003Ccode\u003Egoogle_pay\u003C/code\u003E, \u003Ccode\u003Emasterpass\u003C/code\u003E, \u003Ccode\u003Esamsung_pay\u003C/code\u003E, or \u003Ccode\u003Evisa_checkout\u003C/code\u003E. An additional hash is included on the Wallet subhash with a name matching this value. It contains additional information specific to the card wallet type."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"type"},"visa_checkout":{"name":"visa_checkout","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `visa_checkout` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Evisa_checkout\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"billing_address":{"name":"billing_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"billing_address"},"email":{"name":"email","check":"string","validation":"string","documentation":{"markdown":"Owner's verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"email"},"name":{"name":"name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"name"},"shipping_address":{"name":"shipping_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"shipping_address"}},"object_type":"visa_checkout"}},"object_type":"wallet"}},"object_type":"card"},"card_present":{"name":"card_present","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `card_present` payment, this hash contains a snapshot of the transaction specific details of the `card_present` payment method.","html":"If this is a \u003Ccode\u003Ecard_present\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Ecard_present\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"brand":{"name":"brand","check":"string","validation":"string","documentation":{"markdown":"Card brand. Can be `amex`, `diners`, `discover`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.","html":"Card brand. Can be \u003Ccode\u003Eamex\u003C/code\u003E, \u003Ccode\u003Ediners\u003C/code\u003E, \u003Ccode\u003Ediscover\u003C/code\u003E, \u003Ccode\u003Ejcb\u003C/code\u003E, \u003Ccode\u003Emastercard\u003C/code\u003E, \u003Ccode\u003Eunionpay\u003C/code\u003E, \u003Ccode\u003Evisa\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"brand"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.","html":"Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you’ve collected."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"emv_auth_data":{"name":"emv_auth_data","check":"string","validation":"string","documentation":{"markdown":"Authorization response cryptogram.","html":"Authorization response cryptogram."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"emv_auth_data"},"exp_month":{"name":"exp_month","check":"integer","validation":"integer","documentation":{"markdown":"Two-digit number representing the card's expiration month.","html":"Two-digit number representing the card’s expiration month."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"exp_month"},"exp_year":{"name":"exp_year","check":"integer","validation":"integer","documentation":{"markdown":"Four-digit number representing the card's expiration year.","html":"Four-digit number representing the card’s expiration year."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"exp_year"},"fingerprint":{"name":"fingerprint","check":"string","validation":"string","documentation":{"markdown":"Uniquely identifies this particular card number. You can use this attribute to check whether two customers who've signed up with you are using the same card number, for example.","html":"Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"fingerprint"},"funding":{"name":"funding","check":"string","validation":"string","documentation":{"markdown":"Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.","html":"Card funding type. Can be \u003Ccode\u003Ecredit\u003C/code\u003E, \u003Ccode\u003Edebit\u003C/code\u003E, \u003Ccode\u003Eprepaid\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"funding"},"generated_card":{"name":"generated_card","check":"string","validation":"string","documentation":{"markdown":"ID of a card PaymentMethod generated from the card_present PaymentMethod that may be attached to a Customer for future transactions. Only present if it was possible to generate a card PaymentMethod.","html":"ID of a card PaymentMethod generated from the card_present PaymentMethod that may be attached to a Customer for future transactions. Only present if it was possible to generate a card PaymentMethod."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"generated_card"},"last4":{"name":"last4","check":"string","validation":"string","documentation":{"markdown":"The last four digits of the card.","html":"The last four digits of the card."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"last4"},"network":{"name":"network","check":"string","validation":"string","documentation":{"markdown":"Identifies which network this charge was processed on. Can be `amex`, `diners`, `discover`, `interac`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.","html":"Identifies which network this charge was processed on. Can be \u003Ccode\u003Eamex\u003C/code\u003E, \u003Ccode\u003Ediners\u003C/code\u003E, \u003Ccode\u003Ediscover\u003C/code\u003E, \u003Ccode\u003Einterac\u003C/code\u003E, \u003Ccode\u003Ejcb\u003C/code\u003E, \u003Ccode\u003Emastercard\u003C/code\u003E, \u003Ccode\u003Eunionpay\u003C/code\u003E, \u003Ccode\u003Evisa\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"network"},"read_method":{"name":"read_method","check":"string","validation":"string","documentation":{"markdown":"How were card details read in this transaction. Can be contact_emv, contactless_emv, magnetic_stripe_fallback, magnetic_stripe_track2, or contactless_magstripe_mode","html":"How were card details read in this transaction. Can be contact_emv, contactless_emv, magnetic_stripe_fallback, magnetic_stripe_track2, or contactless_magstripe_mode"},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"read_method"},"receipt":{"name":"receipt","check":"hash","validation":"hash","documentation":{"markdown":"A collection of fields required to be displayed on receipts. Only required for EMV transactions.","html":"A collection of fields required to be displayed on receipts. Only required for EMV transactions."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"application_cryptogram":{"name":"application_cryptogram","check":"string","validation":"string","documentation":{"markdown":"EMV tag 9F26, cryptogram generated by the integrated circuit chip.","html":"EMV tag 9F26, cryptogram generated by the integrated circuit chip."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"application_cryptogram"},"application_preferred_name":{"name":"application_preferred_name","check":"string","validation":"string","documentation":{"markdown":"Mnenomic of the Application Identifier.","html":"Mnenomic of the Application Identifier."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"application_preferred_name"},"authorization_code":{"name":"authorization_code","check":"string","validation":"string","documentation":{"markdown":"Identifier for this transaction.","html":"Identifier for this transaction."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"authorization_code"},"authorization_response_code":{"name":"authorization_response_code","check":"string","validation":"string","documentation":{"markdown":"EMV tag 8A. A code returned by the card issuer.","html":"EMV tag 8A. A code returned by the card issuer."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"authorization_response_code"},"cardholder_verification_method":{"name":"cardholder_verification_method","check":"string","validation":"string","documentation":{"markdown":"How the cardholder verified ownership of the card.","html":"How the cardholder verified ownership of the card."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"cardholder_verification_method"},"dedicated_file_name":{"name":"dedicated_file_name","check":"string","validation":"string","documentation":{"markdown":"EMV tag 84. Similar to the application identifier stored on the integrated circuit chip.","html":"EMV tag 84. Similar to the application identifier stored on the integrated circuit chip."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"dedicated_file_name"},"terminal_verification_results":{"name":"terminal_verification_results","check":"string","validation":"string","documentation":{"markdown":"The outcome of a series of EMV functions performed by the card reader.","html":"The outcome of a series of EMV functions performed by the card reader."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"terminal_verification_results"},"transaction_status_information":{"name":"transaction_status_information","check":"string","validation":"string","documentation":{"markdown":"An indication of various EMV functions performed during the transaction.","html":"An indication of various EMV functions performed during the transaction."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"transaction_status_information"}},"object_type":"receipt"}},"object_type":"card_present"},"eps":{"name":"eps","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `eps` payment, this hash contains a snapshot of the transaction specific details of the `eps` payment method.","html":"If this is a \u003Ccode\u003Eeps\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Eeps\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"verified_name":{"name":"verified_name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by EPS directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated.\n","html":"Owner’s verified full name. Values are verified or provided by EPS directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"verified_name"}},"object_type":"eps"},"giropay":{"name":"giropay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `giropay` payment, this hash contains a snapshot of the transaction specific details of the `giropay` payment method.","html":"If this is a \u003Ccode\u003Egiropay\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Egiropay\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank_code":{"name":"bank_code","check":"string","validation":"string","documentation":{"markdown":"Bank code of bank associated with the bank account.","html":"Bank code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_code"},"bank_name":{"name":"bank_name","check":"string","validation":"string","documentation":{"markdown":"Name of the bank associated with the bank account.","html":"Name of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_name"},"bic":{"name":"bic","check":"string","validation":"string","documentation":{"markdown":"Bank Identifier Code of the bank associated with the bank account.","html":"Bank Identifier Code of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bic"},"verified_name":{"name":"verified_name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by Giropay directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated.\n","html":"Owner’s verified full name. Values are verified or provided by Giropay directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"verified_name"}},"object_type":"giropay"},"ideal":{"name":"ideal","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `ideal` payment, this hash contains a snapshot of the transaction specific details of the `ideal` payment method.","html":"If this is a \u003Ccode\u003Eideal\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Eideal\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank":{"name":"bank","check":"string","validation":"string","documentation":{"markdown":"The customer's bank. Can be one of `abn_amro`, `asn_bank`, `bunq`, `handelsbanken`, `ing`, `knab`, `moneyou`, `rabobank`, `regiobank`, `sns_bank`, `triodos_bank`, or `van_lanschot`.","html":"The customer’s bank. Can be one of \u003Ccode\u003Eabn_amro\u003C/code\u003E, \u003Ccode\u003Easn_bank\u003C/code\u003E, \u003Ccode\u003Ebunq\u003C/code\u003E, \u003Ccode\u003Ehandelsbanken\u003C/code\u003E, \u003Ccode\u003Eing\u003C/code\u003E, \u003Ccode\u003Eknab\u003C/code\u003E, \u003Ccode\u003Emoneyou\u003C/code\u003E, \u003Ccode\u003Erabobank\u003C/code\u003E, \u003Ccode\u003Eregiobank\u003C/code\u003E, \u003Ccode\u003Esns_bank\u003C/code\u003E, \u003Ccode\u003Etriodos_bank\u003C/code\u003E, or \u003Ccode\u003Evan_lanschot\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank"},"bic":{"name":"bic","check":"string","validation":"string","documentation":{"markdown":"The Bank Identifier Code of the customer's bank.","html":"The Bank Identifier Code of the customer’s bank."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bic"},"iban_last4":{"name":"iban_last4","check":"string","validation":"string","documentation":{"markdown":"Last four characters of the IBAN.","html":"Last four characters of the IBAN."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"iban_last4"},"verified_name":{"name":"verified_name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by iDEAL directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated.\n","html":"Owner’s verified full name. Values are verified or provided by iDEAL directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"verified_name"}},"object_type":"ideal"},"klarna":{"name":"klarna","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `klarna` payment, this hash contains a snapshot of the transaction specific details of the `klarna` payment method.","html":"If this is a \u003Ccode\u003Eklarna\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Eklarna\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"klarna"},"multibanco":{"name":"multibanco","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `multibanco` payment, this hash contains a snapshot of the transaction specific details of the `multibanco` payment method.","html":"If this is a \u003Ccode\u003Emultibanco\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Emultibanco\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"entity":{"name":"entity","check":"string","validation":"string","documentation":{"markdown":"Entity number associated with this Multibanco payment.","html":"Entity number associated with this Multibanco payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"entity"},"reference":{"name":"reference","check":"string","validation":"string","documentation":{"markdown":"Reference number associated with this Multibanco payment.","html":"Reference number associated with this Multibanco payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"reference"}},"object_type":"multibanco"},"p24":{"name":"p24","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `p24` payment, this hash contains a snapshot of the transaction specific details of the `p24` payment method.","html":"If this is a \u003Ccode\u003Ep24\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Ep24\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"reference":{"name":"reference","check":"string","validation":"string","documentation":{"markdown":"Unique reference for this Przelewy24 payment.","html":"Unique reference for this Przelewy24 payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"reference"},"verified_name":{"name":"verified_name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by Przelewy24 directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated.\n","html":"Owner’s verified full name. Values are verified or provided by Przelewy24 directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"verified_name"}},"object_type":"p24"},"sepa_debit":{"name":"sepa_debit","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `sepa_debit` payment, this hash contains a snapshot of the transaction specific details of the `sepa_debit` payment method.","html":"If this is a \u003Ccode\u003Esepa_debit\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Esepa_debit\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank_code":{"name":"bank_code","check":"string","validation":"string","documentation":{"markdown":"Bank code of bank associated with the bank account.","html":"Bank code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_code"},"branch_code":{"name":"branch_code","check":"string","validation":"string","documentation":{"markdown":"Branch code of bank associated with the bank account.","html":"Branch code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"branch_code"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country the bank account is located in.","html":"Two-letter ISO code representing the country the bank account is located in."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"fingerprint":{"name":"fingerprint","check":"string","validation":"string","documentation":{"markdown":"Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.","html":"Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"fingerprint"},"last4":{"name":"last4","check":"string","validation":"string","documentation":{"markdown":"Last four characters of the IBAN.","html":"Last four characters of the IBAN."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"last4"},"mandate":{"name":"mandate","check":"string","validation":"string","documentation":{"markdown":"ID of the mandate used to make this payment.","html":"ID of the mandate used to make this payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"mandate"}},"object_type":"sepa_debit"},"sofort":{"name":"sofort","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `sofort` payment, this hash contains a snapshot of the transaction specific details of the `sofort` payment method.","html":"If this is a \u003Ccode\u003Esofort\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Esofort\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank_code":{"name":"bank_code","check":"string","validation":"string","documentation":{"markdown":"Bank code of bank associated with the bank account.","html":"Bank code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_code"},"bank_name":{"name":"bank_name","check":"string","validation":"string","documentation":{"markdown":"Name of the bank associated with the bank account.","html":"Name of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_name"},"bic":{"name":"bic","check":"string","validation":"string","documentation":{"markdown":"Bank Identifier Code of the bank associated with the bank account.","html":"Bank Identifier Code of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bic"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country the bank account is located in.","html":"Two-letter ISO code representing the country the bank account is located in."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"iban_last4":{"name":"iban_last4","check":"string","validation":"string","documentation":{"markdown":"Last four characters of the IBAN.","html":"Last four characters of the IBAN."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"iban_last4"},"verified_name":{"name":"verified_name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by SOFORT directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated.\n","html":"Owner’s verified full name. Values are verified or provided by SOFORT directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"verified_name"}},"object_type":"sofort"},"stripe_account":{"name":"stripe_account","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `stripe_account` payment, this hash contains a snapshot of the transaction specific details of the `stripe_account` payment method.","html":"If this is a \u003Ccode\u003Estripe_account\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Estripe_account\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"stripe_account"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"The type of transaction-specific details of the payment method used in the payment, one of `ach_credit_transfer`, `ach_debit`, `alipay`, `bancontact`, `card`, `card_present`, `eps`, `giropay`, `ideal`, `klarna`, `multibanco`, `p24`, `sepa_debit`, `sofort`, `stripe_account`, or `wechat`.\nAn additional hash is included on `payment_method_details` with a name matching this value.\nIt contains information specific to the payment method.\n","html":"The type of transaction-specific details of the payment method used in the payment, one of \u003Ccode\u003Each_credit_transfer\u003C/code\u003E, \u003Ccode\u003Each_debit\u003C/code\u003E, \u003Ccode\u003Ealipay\u003C/code\u003E, \u003Ccode\u003Ebancontact\u003C/code\u003E, \u003Ccode\u003Ecard\u003C/code\u003E, \u003Ccode\u003Ecard_present\u003C/code\u003E, \u003Ccode\u003Eeps\u003C/code\u003E, \u003Ccode\u003Egiropay\u003C/code\u003E, \u003Ccode\u003Eideal\u003C/code\u003E, \u003Ccode\u003Eklarna\u003C/code\u003E, \u003Ccode\u003Emultibanco\u003C/code\u003E, \u003Ccode\u003Ep24\u003C/code\u003E, \u003Ccode\u003Esepa_debit\u003C/code\u003E, \u003Ccode\u003Esofort\u003C/code\u003E, \u003Ccode\u003Estripe_account\u003C/code\u003E, or \u003Ccode\u003Ewechat\u003C/code\u003E.\nAn additional hash is included on \u003Ccode\u003Epayment_method_details\u003C/code\u003E with a name matching this value.\nIt contains information specific to the payment method."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"type"},"wechat":{"name":"wechat","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `wechat` payment, this hash contains a snapshot of the transaction specific details of the `wechat` payment method.","html":"If this is a \u003Ccode\u003Ewechat\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Ewechat\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"wechat"}},"object_type":"payment_method_details"}},"object_type":"generated_from"},"last4":{"name":"last4","check":"string","validation":"string","documentation":{"markdown":"The last four digits of the card.","html":"The last four digits of the card."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"last4"},"three_d_secure_usage":{"name":"three_d_secure_usage","check":"hash","validation":"hash","documentation":{"markdown":"Contains details on how this Card maybe be used for 3D Secure authentication.","html":"Contains details on how this Card maybe be used for 3D Secure authentication."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"supported":{"name":"supported","check":"boolean","validation":"boolean","documentation":{"markdown":"Whether 3D Secure is supported on this card.","html":"Whether 3D Secure is supported on this card."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"supported"}},"object_type":"three_d_secure_usage"},"wallet":{"name":"wallet","check":"hash","validation":"hash","documentation":{"markdown":"If this Card is part of a card wallet, this contains the details of the card wallet.","html":"If this Card is part of a card wallet, this contains the details of the card wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"amex_express_checkout":{"name":"amex_express_checkout","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `amex_express_checkout` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Eamex_express_checkout\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"amex_express_checkout"},"apple_pay":{"name":"apple_pay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `apple_pay` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Eapple_pay\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"apple_pay"},"dynamic_last4":{"name":"dynamic_last4","check":"string","validation":"string","documentation":{"markdown":"(For tokenized numbers only.) The last four digits of the device account number.","html":"(For tokenized numbers only.) The last four digits of the device account number."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"dynamic_last4"},"google_pay":{"name":"google_pay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `google_pay` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Egoogle_pay\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"google_pay"},"masterpass":{"name":"masterpass","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `masterpass` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Emasterpass\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"billing_address":{"name":"billing_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"billing_address"},"email":{"name":"email","check":"string","validation":"string","documentation":{"markdown":"Owner's verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"email"},"name":{"name":"name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"name"},"shipping_address":{"name":"shipping_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"shipping_address"}},"object_type":"masterpass"},"samsung_pay":{"name":"samsung_pay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `samsung_pay` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Esamsung_pay\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"samsung_pay"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"The type of the card wallet, one of `amex_express_checkout`, `apple_pay`, `google_pay`, `masterpass`, `samsung_pay`, or `visa_checkout`. An additional hash is included on the Wallet subhash with a name matching this value. It contains additional information specific to the card wallet type.","html":"The type of the card wallet, one of \u003Ccode\u003Eamex_express_checkout\u003C/code\u003E, \u003Ccode\u003Eapple_pay\u003C/code\u003E, \u003Ccode\u003Egoogle_pay\u003C/code\u003E, \u003Ccode\u003Emasterpass\u003C/code\u003E, \u003Ccode\u003Esamsung_pay\u003C/code\u003E, or \u003Ccode\u003Evisa_checkout\u003C/code\u003E. An additional hash is included on the Wallet subhash with a name matching this value. It contains additional information specific to the card wallet type."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"type"},"visa_checkout":{"name":"visa_checkout","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `visa_checkout` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Evisa_checkout\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"billing_address":{"name":"billing_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"billing_address"},"email":{"name":"email","check":"string","validation":"string","documentation":{"markdown":"Owner's verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"email"},"name":{"name":"name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"name"},"shipping_address":{"name":"shipping_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"shipping_address"}},"object_type":"visa_checkout"}},"object_type":"wallet"}},"object_type":"card"},"card_present":{"name":"card_present","check":"hash","validation":"hash","documentation":{"markdown":"If this is an `card_present` PaymentMethod, this hash contains details about the Card Present payment method.","html":"If this is an \u003Ccode\u003Ecard_present\u003C/code\u003E PaymentMethod, this hash contains details about the Card Present payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"card_present"},"created":{"name":"created","check":"timestamp","validation":"timestamp","documentation":{"markdown":"Time at which the object was created. Measured in seconds since the Unix epoch.","html":"Time at which the object was created. Measured in seconds since the Unix epoch."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"created"},"customer":{"name":"customer","check":"string","validation":"string","documentation":{"markdown":"The ID of the Customer to which this PaymentMethod is saved. This will not be set when the PaymentMethod has not been saved to a Customer.","html":"The ID of the Customer to which this PaymentMethod is saved. This will not be set when the PaymentMethod has not been saved to a Customer."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"user_expandable":["customer"],"object_type":"customer"},"ideal":{"name":"ideal","check":"hash","validation":"hash","documentation":{"markdown":"If this is an `ideal` PaymentMethod, this hash contains details about the iDEAL payment method.","html":"If this is an \u003Ccode\u003Eideal\u003C/code\u003E PaymentMethod, this hash contains details about the iDEAL payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank":{"name":"bank","check":"string","validation":"string","documentation":{"markdown":"The customer's bank, if provided. Can be one of `abn_amro`, `asn_bank`, `bunq`, `handelsbanken`, `ing`, `knab`, `moneyou`, `rabobank`, `regiobank`, `sns_bank`, `triodos_bank`, or `van_lanschot`.","html":"The customer’s bank, if provided. Can be one of \u003Ccode\u003Eabn_amro\u003C/code\u003E, \u003Ccode\u003Easn_bank\u003C/code\u003E, \u003Ccode\u003Ebunq\u003C/code\u003E, \u003Ccode\u003Ehandelsbanken\u003C/code\u003E, \u003Ccode\u003Eing\u003C/code\u003E, \u003Ccode\u003Eknab\u003C/code\u003E, \u003Ccode\u003Emoneyou\u003C/code\u003E, \u003Ccode\u003Erabobank\u003C/code\u003E, \u003Ccode\u003Eregiobank\u003C/code\u003E, \u003Ccode\u003Esns_bank\u003C/code\u003E, \u003Ccode\u003Etriodos_bank\u003C/code\u003E, or \u003Ccode\u003Evan_lanschot\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank"},"bic":{"name":"bic","check":"string","validation":"string","documentation":{"markdown":"The Bank Identifier Code of the customer's bank, if the bank was provided.","html":"The Bank Identifier Code of the customer’s bank, if the bank was provided."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bic"}},"object_type":"ideal"},"livemode":{"name":"livemode","check":"boolean","validation":"boolean","documentation":{"markdown":"Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.","html":"Has the value \u003Ccode\u003Etrue\u003C/code\u003E if the object exists in live mode or the value \u003Ccode\u003Efalse\u003C/code\u003E if the object exists in test mode."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"livemode"},"metadata":{"name":"metadata","check":"hash","validation":"hash","documentation":{"markdown":"Set of key-value pairs that you can attach to an object. This can be useful for storing additional information about the object in a structured format.","html":"Set of key-value pairs that you can attach to an object. This can be useful for storing additional information about the object in a structured format."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"metadata"},"sepa_debit":{"name":"sepa_debit","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `sepa_debit` PaymentMethod, this hash contains details about the SEPA debit bank account.","html":"If this is a \u003Ccode\u003Esepa_debit\u003C/code\u003E PaymentMethod, this hash contains details about the SEPA debit bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank_code":{"name":"bank_code","check":"string","validation":"string","documentation":{"markdown":"Bank code of bank associated with the bank account.","html":"Bank code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_code"},"branch_code":{"name":"branch_code","check":"string","validation":"string","documentation":{"markdown":"Branch code of bank associated with the bank account.","html":"Branch code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"branch_code"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country the bank account is located in.","html":"Two-letter ISO code representing the country the bank account is located in."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"fingerprint":{"name":"fingerprint","check":"string","validation":"string","documentation":{"markdown":"Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.","html":"Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"fingerprint"},"last4":{"name":"last4","check":"string","validation":"string","documentation":{"markdown":"Last four characters of the IBAN.","html":"Last four characters of the IBAN."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"last4"}},"object_type":"sepa_debit"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"The type of the PaymentMethod. An additional hash is included on the PaymentMethod with a name matching this value. It contains additional information specific to the PaymentMethod type.","html":"The type of the PaymentMethod. An additional hash is included on the PaymentMethod with a name matching this value. It contains additional information specific to the PaymentMethod type."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"enum_values":{"card":{"documentation":null},"ideal":{"documentation":null},"sepa_debit":{"documentation":null}},"object_type":"type"}},"object_type":"payment_method"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"The type of error returned. One of `api_connection_error`, `api_error`, `authentication_error`, `card_error`, `idempotency_error`, `invalid_request_error`, or `rate_limit_error`","html":"The type of error returned. One of \u003Ccode\u003Eapi_connection_error\u003C/code\u003E, \u003Ccode\u003Eapi_error\u003C/code\u003E, \u003Ccode\u003Eauthentication_error\u003C/code\u003E, \u003Ccode\u003Ecard_error\u003C/code\u003E, \u003Ccode\u003Eidempotency_error\u003C/code\u003E, \u003Ccode\u003Einvalid_request_error\u003C/code\u003E, or \u003Ccode\u003Erate_limit_error\u003C/code\u003E"},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"type"}},"object_type":"last_payment_error"},"livemode":{"name":"livemode","check":"boolean","validation":"boolean","documentation":{"markdown":"Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.","html":"Has the value \u003Ccode\u003Etrue\u003C/code\u003E if the object exists in live mode or the value \u003Ccode\u003Efalse\u003C/code\u003E if the object exists in test mode."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"livemode"},"metadata":{"name":"metadata","check":"hash","validation":"hash","documentation":{"markdown":"Set of key-value pairs that you can attach to an object. This can be useful for storing additional information about the object in a structured format. For more information, see the [documentation](/docs/payments/payment-intents/creating-payment-intents#storing-information-in-metadata).","html":"Set of key-value pairs that you can attach to an object. This can be useful for storing additional information about the object in a structured format. For more information, see the \u003Ca href=\"/docs/payments/payment-intents/creating-payment-intents#storing-information-in-metadata\"\u003Edocumentation\u003C/a\u003E."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"metadata"},"next_action":{"name":"next_action","check":"hash","validation":"hash","documentation":{"markdown":"If present, this property tells you what actions you need to take in order for your customer to fulfill a payment using the provided source.","html":"If present, this property tells you what actions you need to take in order for your customer to fulfill a payment using the provided source."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"redirect_to_url":{"name":"redirect_to_url","check":"hash","validation":"hash","documentation":{"markdown":"Contains instructions for authenticating a payment by redirecting your customer to another page or application.","html":"Contains instructions for authenticating a payment by redirecting your customer to another page or application."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"return_url":{"name":"return_url","check":"string","validation":"string","documentation":{"markdown":"If the customer does not exit their browser while authenticating, they will be redirected to this specified URL after completion.","html":"If the customer does not exit their browser while authenticating, they will be redirected to this specified URL after completion."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"return_url"},"url":{"name":"url","check":"string","validation":"string","documentation":{"markdown":"The URL you must redirect your customer to in order to authenticate the payment.","html":"The URL you must redirect your customer to in order to authenticate the payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"url"}},"object_type":"redirect_to_url"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"Type of the next action to perform, one of `redirect_to_url` or `use_stripe_sdk`.","html":"Type of the next action to perform, one of \u003Ccode\u003Eredirect_to_url\u003C/code\u003E or \u003Ccode\u003Euse_stripe_sdk\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"type"},"use_stripe_sdk":{"name":"use_stripe_sdk","check":"hash","validation":"hash","documentation":{"markdown":"When confirming a PaymentIntent with Stripe.js, Stripe.js depends on the contents of this \u003Ctranslate\u003Edictionary\u003C/translate\u003E to invoke authentication flows. The shape of the contents is subject to change and is only intended to be used by Stripe.js.","html":"When confirming a PaymentIntent with Stripe.js, Stripe.js depends on the contents of this \u003Ctranslate\u003Edictionary\u003C/translate\u003E to invoke authentication flows. The shape of the contents is subject to change and is only intended to be used by Stripe.js."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"use_stripe_sdk"}},"object_type":"next_action"},"on_behalf_of":{"name":"on_behalf_of","check":"string","validation":"string","documentation":{"markdown":"The account (if any) for which the funds of the PaymentIntent are intended. See the PaymentIntents [use case for connected accounts](/docs/payments/connected-accounts) for details.","html":"The account (if any) for which the funds of the PaymentIntent are intended. See the PaymentIntents \u003Ca href=\"/docs/payments/connected-accounts\"\u003Euse case for connected accounts\u003C/a\u003E for details."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"user_expandable":["account"],"object_type":"on_behalf_of"},"payment_method":{"name":"payment_method","check":"string","validation":"string","documentation":{"markdown":"ID of the payment method used in this PaymentIntent.","html":"ID of the payment method used in this PaymentIntent."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"user_expandable":["payment_method"],"object_type":"payment_method"},"payment_method_options":{"name":"payment_method_options","check":"hash","validation":"hash","documentation":{"markdown":"Payment-method-specific configuration for this PaymentIntent.","html":"Payment-method-specific configuration for this PaymentIntent."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"card":{"name":"card","check":"hash","validation":"hash","documentation":{"markdown":"If the PaymentIntent's payment_method_types includes `card`, this hash contains the configurations that will be applied to each payment attempt of that type.\n","html":"If the PaymentIntent’s payment_method_types includes \u003Ccode\u003Ecard\u003C/code\u003E, this hash contains the configurations that will be applied to each payment attempt of that type."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"installments":{"name":"installments","check":"hash","validation":"hash","documentation":{"markdown":"Installment details for this payment (Mexico only).\n\nFor more information, see the [installments integration guide](/docs/payments/installments).\n","html":"Installment details for this payment (Mexico only).\u003C/p\u003E\n\n\u003Cp\u003EFor more information, see the \u003Ca href=\"/docs/payments/installments\"\u003Einstallments integration guide\u003C/a\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"available_plans":{"name":"available_plans","check":"array","validation":"array","documentation":{"markdown":"Installment plans that may be selected for this PaymentIntent.","html":"Installment plans that may be selected for this PaymentIntent."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"count":{"name":"count","check":"integer","validation":"integer","documentation":{"markdown":"For `fixed_count` installment plans, this is the number of installment payments your customer will make to their credit card.","html":"For \u003Ccode\u003Efixed_count\u003C/code\u003E installment plans, this is the number of installment payments your customer will make to their credit card."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"count"},"interval":{"name":"interval","check":"string","validation":"string","documentation":{"markdown":"For `fixed_count` installment plans, this is the interval between installment payments your customer will make to their credit card.\nOne of `month`.\n","html":"For \u003Ccode\u003Efixed_count\u003C/code\u003E installment plans, this is the interval between installment payments your customer will make to their credit card.\nOne of \u003Ccode\u003Emonth\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"interval"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"Type of installment plan, one of `fixed_count`.","html":"Type of installment plan, one of \u003Ccode\u003Efixed_count\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"type"}},"object_type":"available_plans"},"enabled":{"name":"enabled","check":"boolean","validation":"boolean","documentation":{"markdown":"Whether Installments are enabled for this PaymentIntent.","html":"Whether Installments are enabled for this PaymentIntent."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"enabled"},"plan":{"name":"plan","check":"hash","validation":"hash","documentation":{"markdown":"Installment plan selected for this PaymentIntent.","html":"Installment plan selected for this PaymentIntent."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"count":{"name":"count","check":"integer","validation":"integer","documentation":{"markdown":"For `fixed_count` installment plans, this is the number of installment payments your customer will make to their credit card.","html":"For \u003Ccode\u003Efixed_count\u003C/code\u003E installment plans, this is the number of installment payments your customer will make to their credit card."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"count"},"interval":{"name":"interval","check":"string","validation":"string","documentation":{"markdown":"For `fixed_count` installment plans, this is the interval between installment payments your customer will make to their credit card.\nOne of `month`.\n","html":"For \u003Ccode\u003Efixed_count\u003C/code\u003E installment plans, this is the interval between installment payments your customer will make to their credit card.\nOne of \u003Ccode\u003Emonth\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"interval"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"Type of installment plan, one of `fixed_count`.","html":"Type of installment plan, one of \u003Ccode\u003Efixed_count\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"type"}},"object_type":"plan"}},"object_type":"installments"},"request_three_d_secure":{"name":"request_three_d_secure","check":"string","validation":"string","documentation":{"markdown":"We strongly recommend that you rely on our SCA Engine to automatically prompt your customers for authentication based on risk level and [other requirements](/docs/strong-customer-authentication). However, if you wish to request 3D Secure based on logic from your own fraud engine, provide this option. Permitted values include: `automatic` or `any`. If not provided, defaults to `automatic`. Read our guide on [manually requesting 3D Secure](/docs/payments/3d-secure#manual-three-ds) for more information on how this configuration interacts with Radar and our SCA Engine.","html":"We strongly recommend that you rely on our SCA Engine to automatically prompt your customers for authentication based on risk level and \u003Ca href=\"/docs/strong-customer-authentication\"\u003Eother requirements\u003C/a\u003E. However, if you wish to request 3D Secure based on logic from your own fraud engine, provide this option. Permitted values include: \u003Ccode\u003Eautomatic\u003C/code\u003E or \u003Ccode\u003Eany\u003C/code\u003E. If not provided, defaults to \u003Ccode\u003Eautomatic\u003C/code\u003E. Read our guide on \u003Ca href=\"/docs/payments/3d-secure#manual-three-ds\"\u003Emanually requesting 3D Secure\u003C/a\u003E for more information on how this configuration interacts with Radar and our SCA Engine."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":"advanced","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"request_three_d_secure"}},"object_type":"card"}},"object_type":"payment_method_options"},"payment_method_types":{"name":"payment_method_types","check":"string_array","validation":"array containing strings","documentation":{"markdown":"The list of payment method types (e.g. card) that this PaymentIntent is allowed to use.","html":"The list of payment method types (e.g. card) that this PaymentIntent is allowed to use."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"payment_method_types"},"receipt_email":{"name":"receipt_email","check":"string","validation":"string","documentation":{"markdown":"Email address that the receipt for the resulting payment will be sent to.","html":"Email address that the receipt for the resulting payment will be sent to."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"receipt_email"},"review":{"name":"review","check":"string","validation":"string","documentation":{"markdown":"ID of the review associated with this PaymentIntent, if any.","html":"ID of the review associated with this PaymentIntent, if any."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"user_expandable":["review"],"object_type":"review"},"setup_future_usage":{"name":"setup_future_usage","check":"string","validation":"string","documentation":{"markdown":"Indicates that you intend to make future payments with this PaymentIntent's payment method.\n\nIf present, the payment method used with this PaymentIntent can be [attached](/docs/api/payment_methods/attach) to a Customer, even after the transaction completes.\n\nFor more, learn to [save card details after a payment](/docs/payments/save-after-payment).\n\nStripe uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules. For example, if your customer is impacted by [SCA](/docs/strong-customer-authentication), using `off_session` will ensure that they are authenticated while processing this PaymentIntent. You will then be able to collect [off-session payments](/docs/payments/cards/charging-saved-cards#off-session-payments-with-saved-cards) for this customer.\n","html":"Indicates that you intend to make future payments with this PaymentIntent’s payment method.\u003C/p\u003E\n\n\u003Cp\u003EIf present, the payment method used with this PaymentIntent can be \u003Ca href=\"/docs/api/payment_methods/attach\"\u003Eattached\u003C/a\u003E to a Customer, even after the transaction completes.\u003C/p\u003E\n\n\u003Cp\u003EFor more, learn to \u003Ca href=\"/docs/payments/save-after-payment\"\u003Esave card details after a payment\u003C/a\u003E.\u003C/p\u003E\n\n\u003Cp\u003EStripe uses \u003Ccode\u003Esetup_future_usage\u003C/code\u003E to dynamically optimize your payment flow and comply with regional legislation and network rules. For example, if your customer is impacted by \u003Ca href=\"/docs/strong-customer-authentication\"\u003ESCA\u003C/a\u003E, using \u003Ccode\u003Eoff_session\u003C/code\u003E will ensure that they are authenticated while processing this PaymentIntent. You will then be able to collect \u003Ca href=\"/docs/payments/cards/charging-saved-cards#off-session-payments-with-saved-cards\"\u003Eoff-session payments\u003C/a\u003E for this customer."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"enum_values":{"on_session":{"documentation":{"markdown":"Use `on_session` if you intend to only reuse the payment method when your customer is present in your checkout flow.","html":"Use \u003Ccode\u003Eon_session\u003C/code\u003E if you intend to only reuse the payment method when your customer is present in your checkout flow."}},"off_session":{"documentation":{"markdown":"Use `off_session` if your customer may or may not be in your checkout flow. ","html":"Use \u003Ccode\u003Eoff_session\u003C/code\u003E if your customer may or may not be in your checkout flow. "}}},"object_type":"setup_future_usage"},"shipping":{"name":"shipping","check":"hash","validation":"hash","documentation":{"markdown":"Shipping information for this PaymentIntent.","html":"Shipping information for this PaymentIntent."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"address":{"name":"address","check":"hash","validation":"hash","documentation":{"markdown":"Shipping address.","html":"Shipping address."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"address"},"carrier":{"name":"carrier","check":"string","validation":"string","documentation":{"markdown":"The delivery service that shipped a physical product, such as Fedex, UPS, USPS, etc.","html":"The delivery service that shipped a physical product, such as Fedex, UPS, USPS, etc."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"carrier"},"name":{"name":"name","check":"string","validation":"string","documentation":{"markdown":"Recipient name.","html":"Recipient name."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"name"},"phone":{"name":"phone","check":"string","validation":"string","documentation":{"markdown":"Recipient phone (including extension).","html":"Recipient phone (including extension)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"phone"},"tracking_number":{"name":"tracking_number","check":"string","validation":"string","documentation":{"markdown":"The tracking number for a physical product, obtained from the delivery service. If multiple tracking numbers were generated for this purchase, please separate them with commas.","html":"The tracking number for a physical product, obtained from the delivery service. If multiple tracking numbers were generated for this purchase, please separate them with commas."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"tracking_number"}},"object_type":"shipping"},"statement_descriptor":{"name":"statement_descriptor","check":"string","validation":"string","documentation":{"markdown":"For non-card charges, you can use this value as the complete description that appears on your customers’ statements. Must contain at least one letter, maximum 22 characters.","html":"For non-card charges, you can use this value as the complete description that appears on your customers’ statements. Must contain at least one letter, maximum 22 characters."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"statement_descriptor"},"statement_descriptor_suffix":{"name":"statement_descriptor_suffix","check":"string","validation":"string","documentation":{"markdown":"Provides information about a card payment that customers see on their statements. Concatenated with the prefix (shortened descriptor) or statement descriptor that’s set on the account to form the complete statement descriptor. Maximum 22 characters for the concatenated descriptor.","html":"Provides information about a card payment that customers see on their statements. Concatenated with the prefix (shortened descriptor) or statement descriptor that’s set on the account to form the complete statement descriptor. Maximum 22 characters for the concatenated descriptor."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"statement_descriptor_suffix"},"status":{"name":"status","check":"string","validation":"string","documentation":{"markdown":"Status of this PaymentIntent, one of `requires_payment_method`, `requires_confirmation`, `requires_action`, `processing`, `requires_capture`, `canceled`, or `succeeded`. Read more about each PaymentIntent [status](/docs/payments/intents#intent-statuses).","html":"Status of this PaymentIntent, one of \u003Ccode\u003Erequires_payment_method\u003C/code\u003E, \u003Ccode\u003Erequires_confirmation\u003C/code\u003E, \u003Ccode\u003Erequires_action\u003C/code\u003E, \u003Ccode\u003Eprocessing\u003C/code\u003E, \u003Ccode\u003Erequires_capture\u003C/code\u003E, \u003Ccode\u003Ecanceled\u003C/code\u003E, or \u003Ccode\u003Esucceeded\u003C/code\u003E. Read more about each PaymentIntent \u003Ca href=\"/docs/payments/intents#intent-statuses\"\u003Estatus\u003C/a\u003E."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"status"},"transfer_data":{"name":"transfer_data","check":"hash","validation":"hash","documentation":{"markdown":"The data with which to automatically create a Transfer when the payment is finalized. See the PaymentIntents [use case for connected accounts](/docs/payments/connected-accounts) for details.","html":"The data with which to automatically create a Transfer when the payment is finalized. See the PaymentIntents \u003Ca href=\"/docs/payments/connected-accounts\"\u003Euse case for connected accounts\u003C/a\u003E for details."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"amount":{"name":"amount","check":"integer","validation":"integer","documentation":{"markdown":"Amount intended to be collected by this PaymentIntent. A positive integer representing how much to charge in the [smallest currency unit](/docs/currencies#zero-decimal) (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The minimum amount is $0.50 US or [equivalent in charge currency](/docs/currencies#minimum-and-maximum-charge-amounts). The amount value supports up to eight digits (e.g., a value of 99999999 for a USD charge of $999,999.99).","html":"Amount intended to be collected by this PaymentIntent. A positive integer representing how much to charge in the \u003Ca href=\"/docs/currencies#zero-decimal\"\u003Esmallest currency unit\u003C/a\u003E (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The minimum amount is $0.50 US or \u003Ca href=\"/docs/currencies#minimum-and-maximum-charge-amounts\"\u003Eequivalent in charge currency\u003C/a\u003E. The amount value supports up to eight digits (e.g., a value of 99999999 for a USD charge of $999,999.99)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"amount"},"destination":{"name":"destination","check":"string","validation":"string","documentation":{"markdown":"The account (if any) the payment will be attributed to for tax\nreporting, and where funds from the payment will be transferred to upon\npayment success.\n","html":"The account (if any) the payment will be attributed to for tax\nreporting, and where funds from the payment will be transferred to upon\npayment success."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"user_expandable":["account"],"object_type":"destination"}},"object_type":"transfer_data"},"transfer_group":{"name":"transfer_group","check":"string","validation":"string","documentation":{"markdown":"A string that identifies the resulting payment as part of a group. See the PaymentIntents [use case for connected accounts](/docs/payments/connected-accounts) for details.","html":"A string that identifies the resulting payment as part of a group. See the PaymentIntents \u003Ca href=\"/docs/payments/connected-accounts\"\u003Euse case for connected accounts\u003C/a\u003E for details."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"transfer_group"}}},"payment_method":{"name":"payment_method","check":"hash","validation":"hash","documentation":{"markdown":"The PaymentMethod object for errors returned on a request involving a PaymentMethod.","html":"The PaymentMethod object for errors returned on a request involving a PaymentMethod."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"id":{"name":"id","check":"string","validation":"string","documentation":{"markdown":"Unique identifier for the object.","html":"Unique identifier for the object."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"id"},"object":{"name":"object","check":"string","validation":"string","documentation":{"markdown":"String representing the object's type. Objects of the same type share the same value.","html":"String representing the object’s type. Objects of the same type share the same value."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"object"},"billing_details":{"name":"billing_details","check":"hash","validation":"hash","documentation":{"markdown":"Billing information associated with the PaymentMethod that may be used or required by particular types of payment methods.","html":"Billing information associated with the PaymentMethod that may be used or required by particular types of payment methods."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"address":{"name":"address","check":"hash","validation":"hash","documentation":{"markdown":"Billing address.","html":"Billing address."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"address"},"email":{"name":"email","check":"string","validation":"string","documentation":{"markdown":"Email address.","html":"Email address."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"email"},"name":{"name":"name","check":"string","validation":"string","documentation":{"markdown":"Full name.","html":"Full name."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"name"},"phone":{"name":"phone","check":"string","validation":"string","documentation":{"markdown":"Billing phone number (including extension).","html":"Billing phone number (including extension)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"phone"}},"object_type":"billing_details"},"card":{"name":"card","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `card` PaymentMethod, this hash contains details about the card.","html":"If this is a \u003Ccode\u003Ecard\u003C/code\u003E PaymentMethod, this hash contains details about the card."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"brand":{"name":"brand","check":"string","validation":"string","documentation":{"markdown":"Card brand. Can be `amex`, `diners`, `discover`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.","html":"Card brand. Can be \u003Ccode\u003Eamex\u003C/code\u003E, \u003Ccode\u003Ediners\u003C/code\u003E, \u003Ccode\u003Ediscover\u003C/code\u003E, \u003Ccode\u003Ejcb\u003C/code\u003E, \u003Ccode\u003Emastercard\u003C/code\u003E, \u003Ccode\u003Eunionpay\u003C/code\u003E, \u003Ccode\u003Evisa\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"brand"},"checks":{"name":"checks","check":"hash","validation":"hash","documentation":{"markdown":"Checks on Card address and CVC if provided.","html":"Checks on Card address and CVC if provided."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"address_line1_check":{"name":"address_line1_check","check":"string","validation":"string","documentation":{"markdown":"If a address line1 was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.","html":"If a address line1 was provided, results of the check, one of \u003Ccode\u003Epass\u003C/code\u003E, \u003Ccode\u003Efail\u003C/code\u003E, \u003Ccode\u003Eunavailable\u003C/code\u003E, or \u003Ccode\u003Eunchecked\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"address_line1_check"},"address_postal_code_check":{"name":"address_postal_code_check","check":"string","validation":"string","documentation":{"markdown":"If a address postal code was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.","html":"If a address postal code was provided, results of the check, one of \u003Ccode\u003Epass\u003C/code\u003E, \u003Ccode\u003Efail\u003C/code\u003E, \u003Ccode\u003Eunavailable\u003C/code\u003E, or \u003Ccode\u003Eunchecked\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"address_postal_code_check"},"cvc_check":{"name":"cvc_check","check":"string","validation":"string","documentation":{"markdown":"If a CVC was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.","html":"If a CVC was provided, results of the check, one of \u003Ccode\u003Epass\u003C/code\u003E, \u003Ccode\u003Efail\u003C/code\u003E, \u003Ccode\u003Eunavailable\u003C/code\u003E, or \u003Ccode\u003Eunchecked\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"cvc_check"}},"object_type":"checks"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.","html":"Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you’ve collected."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"exp_month":{"name":"exp_month","check":"integer","validation":"integer","documentation":{"markdown":"Two-digit number representing the card's expiration month.","html":"Two-digit number representing the card’s expiration month."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"exp_month"},"exp_year":{"name":"exp_year","check":"integer","validation":"integer","documentation":{"markdown":"Four-digit number representing the card's expiration year.","html":"Four-digit number representing the card’s expiration year."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"exp_year"},"fingerprint":{"name":"fingerprint","check":"string","validation":"string","documentation":{"markdown":"Uniquely identifies this particular card number. You can use this attribute to check whether two customers who've signed up with you are using the same card number, for example.","html":"Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":"card_fingerprint_read","hide_nil":null,"is_country_specific":false,"object_type":"fingerprint"},"funding":{"name":"funding","check":"string","validation":"string","documentation":{"markdown":"Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.","html":"Card funding type. Can be \u003Ccode\u003Ecredit\u003C/code\u003E, \u003Ccode\u003Edebit\u003C/code\u003E, \u003Ccode\u003Eprepaid\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"funding"},"generated_from":{"name":"generated_from","check":"hash","validation":"hash","documentation":{"markdown":"Details of the original PaymentMethod that created this object.","html":"Details of the original PaymentMethod that created this object.","gate_specific":{"sdk_client_public":{"undocumented":true}}},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"charge":{"name":"charge","check":"string","validation":"string","documentation":{"markdown":"The charge that created this object.","html":"The charge that created this object."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"charge"},"payment_method_details":{"name":"payment_method_details","check":"hash","validation":"hash","documentation":{"markdown":"Transaction-specific details of the payment method used in the payment.","html":"Transaction-specific details of the payment method used in the payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"ach_credit_transfer":{"name":"ach_credit_transfer","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `ach_credit_transfer` payment, this hash contains a snapshot of the transaction specific details of the `ach_credit_transfer` payment method.","html":"If this is a \u003Ccode\u003Each_credit_transfer\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Each_credit_transfer\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"account_number":{"name":"account_number","check":"string","validation":"string","documentation":{"markdown":"Account number to transfer funds to.","html":"Account number to transfer funds to."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"account_number"},"bank_name":{"name":"bank_name","check":"string","validation":"string","documentation":{"markdown":"Name of the bank associated with the routing number.","html":"Name of the bank associated with the routing number."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_name"},"routing_number":{"name":"routing_number","check":"string","validation":"string","documentation":{"markdown":"Routing transit number for the bank account to transfer funds to.","html":"Routing transit number for the bank account to transfer funds to."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"routing_number"},"swift_code":{"name":"swift_code","check":"string","validation":"string","documentation":{"markdown":"SWIFT code of the bank associated with the routing number.","html":"SWIFT code of the bank associated with the routing number."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"swift_code"}},"object_type":"ach_credit_transfer"},"ach_debit":{"name":"ach_debit","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `ach_debit` payment, this hash contains a snapshot of the transaction specific details of the `ach_debit` payment method.","html":"If this is a \u003Ccode\u003Each_debit\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Each_debit\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"account_holder_type":{"name":"account_holder_type","check":"string","validation":"string","documentation":{"markdown":"Type of entity that holds the account. This can be either `individual` or `company`.","html":"Type of entity that holds the account. This can be either \u003Ccode\u003Eindividual\u003C/code\u003E or \u003Ccode\u003Ecompany\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"account_holder_type"},"bank_name":{"name":"bank_name","check":"string","validation":"string","documentation":{"markdown":"Name of the bank associated with the bank account.","html":"Name of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_name"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country the bank account is located in.","html":"Two-letter ISO code representing the country the bank account is located in."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"fingerprint":{"name":"fingerprint","check":"string","validation":"string","documentation":{"markdown":"Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.","html":"Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"fingerprint"},"last4":{"name":"last4","check":"string","validation":"string","documentation":{"markdown":"Last four digits of the bank account number.","html":"Last four digits of the bank account number."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"last4"},"routing_number":{"name":"routing_number","check":"string","validation":"string","documentation":{"markdown":"Routing transit number of the bank account.","html":"Routing transit number of the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"routing_number"}},"object_type":"ach_debit"},"alipay":{"name":"alipay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `alipay` payment, this hash contains a snapshot of the transaction specific details of the `alipay` payment method.","html":"If this is a \u003Ccode\u003Ealipay\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Ealipay\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"alipay"},"bancontact":{"name":"bancontact","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `bancontact` payment, this hash contains a snapshot of the transaction specific details of the `bancontact` payment method.","html":"If this is a \u003Ccode\u003Ebancontact\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Ebancontact\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank_code":{"name":"bank_code","check":"string","validation":"string","documentation":{"markdown":"Bank code of bank associated with the bank account.","html":"Bank code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_code"},"bank_name":{"name":"bank_name","check":"string","validation":"string","documentation":{"markdown":"Name of the bank associated with the bank account.","html":"Name of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_name"},"bic":{"name":"bic","check":"string","validation":"string","documentation":{"markdown":"Bank Identifier Code of the bank associated with the bank account.","html":"Bank Identifier Code of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bic"},"iban_last4":{"name":"iban_last4","check":"string","validation":"string","documentation":{"markdown":"Last four characters of the IBAN.","html":"Last four characters of the IBAN."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"iban_last4"},"preferred_language":{"name":"preferred_language","check":"string","validation":"string","documentation":{"markdown":"Preferred language of the Bancontact authorization page that the customer is redirected to.\nCan be one of `en`, `de`, `fr`, or `nl`\n","html":"Preferred language of the Bancontact authorization page that the customer is redirected to.\nCan be one of \u003Ccode\u003Een\u003C/code\u003E, \u003Ccode\u003Ede\u003C/code\u003E, \u003Ccode\u003Efr\u003C/code\u003E, or \u003Ccode\u003Enl\u003C/code\u003E"},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"preferred_language"},"verified_name":{"name":"verified_name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by Bancontact directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated.\n","html":"Owner’s verified full name. Values are verified or provided by Bancontact directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"verified_name"}},"object_type":"bancontact"},"card":{"name":"card","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `card` payment, this hash contains a snapshot of the transaction specific details of the `card` payment method.","html":"If this is a \u003Ccode\u003Ecard\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Ecard\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"brand":{"name":"brand","check":"string","validation":"string","documentation":{"markdown":"Card brand. Can be `amex`, `diners`, `discover`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.","html":"Card brand. Can be \u003Ccode\u003Eamex\u003C/code\u003E, \u003Ccode\u003Ediners\u003C/code\u003E, \u003Ccode\u003Ediscover\u003C/code\u003E, \u003Ccode\u003Ejcb\u003C/code\u003E, \u003Ccode\u003Emastercard\u003C/code\u003E, \u003Ccode\u003Eunionpay\u003C/code\u003E, \u003Ccode\u003Evisa\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"brand"},"checks":{"name":"checks","check":"hash","validation":"hash","documentation":{"markdown":"Check results by Card networks on Card address and CVC at time of payment.","html":"Check results by Card networks on Card address and CVC at time of payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"address_line1_check":{"name":"address_line1_check","check":"string","validation":"string","documentation":{"markdown":"If a address line1 was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.","html":"If a address line1 was provided, results of the check, one of \u003Ccode\u003Epass\u003C/code\u003E, \u003Ccode\u003Efail\u003C/code\u003E, \u003Ccode\u003Eunavailable\u003C/code\u003E, or \u003Ccode\u003Eunchecked\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"address_line1_check"},"address_postal_code_check":{"name":"address_postal_code_check","check":"string","validation":"string","documentation":{"markdown":"If a address postal code was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.","html":"If a address postal code was provided, results of the check, one of \u003Ccode\u003Epass\u003C/code\u003E, \u003Ccode\u003Efail\u003C/code\u003E, \u003Ccode\u003Eunavailable\u003C/code\u003E, or \u003Ccode\u003Eunchecked\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"address_postal_code_check"},"cvc_check":{"name":"cvc_check","check":"string","validation":"string","documentation":{"markdown":"If a CVC was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.","html":"If a CVC was provided, results of the check, one of \u003Ccode\u003Epass\u003C/code\u003E, \u003Ccode\u003Efail\u003C/code\u003E, \u003Ccode\u003Eunavailable\u003C/code\u003E, or \u003Ccode\u003Eunchecked\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"cvc_check"}},"object_type":"checks"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.","html":"Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you’ve collected."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"exp_month":{"name":"exp_month","check":"integer","validation":"integer","documentation":{"markdown":"Two-digit number representing the card's expiration month.","html":"Two-digit number representing the card’s expiration month."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"exp_month"},"exp_year":{"name":"exp_year","check":"integer","validation":"integer","documentation":{"markdown":"Four-digit number representing the card's expiration year.","html":"Four-digit number representing the card’s expiration year."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"exp_year"},"fingerprint":{"name":"fingerprint","check":"string","validation":"string","documentation":{"markdown":"Uniquely identifies this particular card number. You can use this attribute to check whether two customers who've signed up with you are using the same card number, for example.","html":"Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":"card_fingerprint_read","hide_nil":null,"is_country_specific":false,"object_type":"fingerprint"},"funding":{"name":"funding","check":"string","validation":"string","documentation":{"markdown":"Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.","html":"Card funding type. Can be \u003Ccode\u003Ecredit\u003C/code\u003E, \u003Ccode\u003Edebit\u003C/code\u003E, \u003Ccode\u003Eprepaid\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"funding"},"installments":{"name":"installments","check":"hash","validation":"hash","documentation":{"markdown":"Installment details for this payment (Mexico only).\n\nFor more information, see the [installments integration guide](/docs/payments/installments).\n","html":"Installment details for this payment (Mexico only).\u003C/p\u003E\n\n\u003Cp\u003EFor more information, see the \u003Ca href=\"/docs/payments/installments\"\u003Einstallments integration guide\u003C/a\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"plan":{"name":"plan","check":"hash","validation":"hash","documentation":{"markdown":"Installment plan selected for the payment.","html":"Installment plan selected for the payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"count":{"name":"count","check":"integer","validation":"integer","documentation":{"markdown":"For `fixed_count` installment plans, this is the number of installment payments your customer will make to their credit card.","html":"For \u003Ccode\u003Efixed_count\u003C/code\u003E installment plans, this is the number of installment payments your customer will make to their credit card."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"count"},"interval":{"name":"interval","check":"string","validation":"string","documentation":{"markdown":"For `fixed_count` installment plans, this is the interval between installment payments your customer will make to their credit card.\nOne of `month`.\n","html":"For \u003Ccode\u003Efixed_count\u003C/code\u003E installment plans, this is the interval between installment payments your customer will make to their credit card.\nOne of \u003Ccode\u003Emonth\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"interval"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"Type of installment plan, one of `fixed_count`.","html":"Type of installment plan, one of \u003Ccode\u003Efixed_count\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"type"}},"object_type":"plan"}},"object_type":"installments"},"last4":{"name":"last4","check":"string","validation":"string","documentation":{"markdown":"The last four digits of the card.","html":"The last four digits of the card."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"last4"},"network":{"name":"network","check":"string","validation":"string","documentation":{"markdown":"Identifies which network this charge was processed on. Can be `amex`, `diners`, `discover`, `interac`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.","html":"Identifies which network this charge was processed on. Can be \u003Ccode\u003Eamex\u003C/code\u003E, \u003Ccode\u003Ediners\u003C/code\u003E, \u003Ccode\u003Ediscover\u003C/code\u003E, \u003Ccode\u003Einterac\u003C/code\u003E, \u003Ccode\u003Ejcb\u003C/code\u003E, \u003Ccode\u003Emastercard\u003C/code\u003E, \u003Ccode\u003Eunionpay\u003C/code\u003E, \u003Ccode\u003Evisa\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"network"},"three_d_secure":{"name":"three_d_secure","check":"hash","validation":"hash","documentation":{"markdown":"Populated if this transaction used 3D Secure authentication.","html":"Populated if this transaction used 3D Secure authentication."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"authenticated":{"name":"authenticated","check":"boolean","validation":"boolean","documentation":{"markdown":"Whether or not authentication was performed. 3D Secure will succeed without authentication when the card is not enrolled.","html":"Whether or not authentication was performed. 3D Secure will succeed without authentication when the card is not enrolled."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"authenticated"},"succeeded":{"name":"succeeded","check":"boolean","validation":"boolean","documentation":{"markdown":"Whether or not 3D Secure succeeded.","html":"Whether or not 3D Secure succeeded."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"succeeded"},"version":{"name":"version","check":"string","validation":"string","documentation":{"markdown":"The version of 3D Secure that was used for this payment.","html":"The version of 3D Secure that was used for this payment."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"version"}},"object_type":"three_d_secure"},"wallet":{"name":"wallet","check":"hash","validation":"hash","documentation":{"markdown":"If this Card is part of a card wallet, this contains the details of the card wallet.","html":"If this Card is part of a card wallet, this contains the details of the card wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"amex_express_checkout":{"name":"amex_express_checkout","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `amex_express_checkout` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Eamex_express_checkout\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"amex_express_checkout"},"apple_pay":{"name":"apple_pay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `apple_pay` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Eapple_pay\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"apple_pay"},"dynamic_last4":{"name":"dynamic_last4","check":"string","validation":"string","documentation":{"markdown":"(For tokenized numbers only.) The last four digits of the device account number.","html":"(For tokenized numbers only.) The last four digits of the device account number."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"dynamic_last4"},"google_pay":{"name":"google_pay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `google_pay` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Egoogle_pay\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"google_pay"},"masterpass":{"name":"masterpass","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `masterpass` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Emasterpass\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"billing_address":{"name":"billing_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"billing_address"},"email":{"name":"email","check":"string","validation":"string","documentation":{"markdown":"Owner's verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"email"},"name":{"name":"name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"name"},"shipping_address":{"name":"shipping_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"shipping_address"}},"object_type":"masterpass"},"samsung_pay":{"name":"samsung_pay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `samsung_pay` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Esamsung_pay\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"samsung_pay"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"The type of the card wallet, one of `amex_express_checkout`, `apple_pay`, `google_pay`, `masterpass`, `samsung_pay`, or `visa_checkout`. An additional hash is included on the Wallet subhash with a name matching this value. It contains additional information specific to the card wallet type.","html":"The type of the card wallet, one of \u003Ccode\u003Eamex_express_checkout\u003C/code\u003E, \u003Ccode\u003Eapple_pay\u003C/code\u003E, \u003Ccode\u003Egoogle_pay\u003C/code\u003E, \u003Ccode\u003Emasterpass\u003C/code\u003E, \u003Ccode\u003Esamsung_pay\u003C/code\u003E, or \u003Ccode\u003Evisa_checkout\u003C/code\u003E. An additional hash is included on the Wallet subhash with a name matching this value. It contains additional information specific to the card wallet type."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"type"},"visa_checkout":{"name":"visa_checkout","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `visa_checkout` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Evisa_checkout\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"billing_address":{"name":"billing_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"billing_address"},"email":{"name":"email","check":"string","validation":"string","documentation":{"markdown":"Owner's verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"email"},"name":{"name":"name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"name"},"shipping_address":{"name":"shipping_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"shipping_address"}},"object_type":"visa_checkout"}},"object_type":"wallet"}},"object_type":"card"},"card_present":{"name":"card_present","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `card_present` payment, this hash contains a snapshot of the transaction specific details of the `card_present` payment method.","html":"If this is a \u003Ccode\u003Ecard_present\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Ecard_present\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"brand":{"name":"brand","check":"string","validation":"string","documentation":{"markdown":"Card brand. Can be `amex`, `diners`, `discover`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.","html":"Card brand. Can be \u003Ccode\u003Eamex\u003C/code\u003E, \u003Ccode\u003Ediners\u003C/code\u003E, \u003Ccode\u003Ediscover\u003C/code\u003E, \u003Ccode\u003Ejcb\u003C/code\u003E, \u003Ccode\u003Emastercard\u003C/code\u003E, \u003Ccode\u003Eunionpay\u003C/code\u003E, \u003Ccode\u003Evisa\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"brand"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.","html":"Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you’ve collected."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"emv_auth_data":{"name":"emv_auth_data","check":"string","validation":"string","documentation":{"markdown":"Authorization response cryptogram.","html":"Authorization response cryptogram."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"emv_auth_data"},"exp_month":{"name":"exp_month","check":"integer","validation":"integer","documentation":{"markdown":"Two-digit number representing the card's expiration month.","html":"Two-digit number representing the card’s expiration month."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"exp_month"},"exp_year":{"name":"exp_year","check":"integer","validation":"integer","documentation":{"markdown":"Four-digit number representing the card's expiration year.","html":"Four-digit number representing the card’s expiration year."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"exp_year"},"fingerprint":{"name":"fingerprint","check":"string","validation":"string","documentation":{"markdown":"Uniquely identifies this particular card number. You can use this attribute to check whether two customers who've signed up with you are using the same card number, for example.","html":"Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"fingerprint"},"funding":{"name":"funding","check":"string","validation":"string","documentation":{"markdown":"Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.","html":"Card funding type. Can be \u003Ccode\u003Ecredit\u003C/code\u003E, \u003Ccode\u003Edebit\u003C/code\u003E, \u003Ccode\u003Eprepaid\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"funding"},"generated_card":{"name":"generated_card","check":"string","validation":"string","documentation":{"markdown":"ID of a card PaymentMethod generated from the card_present PaymentMethod that may be attached to a Customer for future transactions. Only present if it was possible to generate a card PaymentMethod.","html":"ID of a card PaymentMethod generated from the card_present PaymentMethod that may be attached to a Customer for future transactions. Only present if it was possible to generate a card PaymentMethod."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"generated_card"},"last4":{"name":"last4","check":"string","validation":"string","documentation":{"markdown":"The last four digits of the card.","html":"The last four digits of the card."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"last4"},"network":{"name":"network","check":"string","validation":"string","documentation":{"markdown":"Identifies which network this charge was processed on. Can be `amex`, `diners`, `discover`, `interac`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.","html":"Identifies which network this charge was processed on. Can be \u003Ccode\u003Eamex\u003C/code\u003E, \u003Ccode\u003Ediners\u003C/code\u003E, \u003Ccode\u003Ediscover\u003C/code\u003E, \u003Ccode\u003Einterac\u003C/code\u003E, \u003Ccode\u003Ejcb\u003C/code\u003E, \u003Ccode\u003Emastercard\u003C/code\u003E, \u003Ccode\u003Eunionpay\u003C/code\u003E, \u003Ccode\u003Evisa\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"network"},"read_method":{"name":"read_method","check":"string","validation":"string","documentation":{"markdown":"How were card details read in this transaction. Can be contact_emv, contactless_emv, magnetic_stripe_fallback, magnetic_stripe_track2, or contactless_magstripe_mode","html":"How were card details read in this transaction. Can be contact_emv, contactless_emv, magnetic_stripe_fallback, magnetic_stripe_track2, or contactless_magstripe_mode"},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"read_method"},"receipt":{"name":"receipt","check":"hash","validation":"hash","documentation":{"markdown":"A collection of fields required to be displayed on receipts. Only required for EMV transactions.","html":"A collection of fields required to be displayed on receipts. Only required for EMV transactions."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"application_cryptogram":{"name":"application_cryptogram","check":"string","validation":"string","documentation":{"markdown":"EMV tag 9F26, cryptogram generated by the integrated circuit chip.","html":"EMV tag 9F26, cryptogram generated by the integrated circuit chip."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"application_cryptogram"},"application_preferred_name":{"name":"application_preferred_name","check":"string","validation":"string","documentation":{"markdown":"Mnenomic of the Application Identifier.","html":"Mnenomic of the Application Identifier."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"application_preferred_name"},"authorization_code":{"name":"authorization_code","check":"string","validation":"string","documentation":{"markdown":"Identifier for this transaction.","html":"Identifier for this transaction."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"authorization_code"},"authorization_response_code":{"name":"authorization_response_code","check":"string","validation":"string","documentation":{"markdown":"EMV tag 8A. A code returned by the card issuer.","html":"EMV tag 8A. A code returned by the card issuer."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"authorization_response_code"},"cardholder_verification_method":{"name":"cardholder_verification_method","check":"string","validation":"string","documentation":{"markdown":"How the cardholder verified ownership of the card.","html":"How the cardholder verified ownership of the card."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"cardholder_verification_method"},"dedicated_file_name":{"name":"dedicated_file_name","check":"string","validation":"string","documentation":{"markdown":"EMV tag 84. Similar to the application identifier stored on the integrated circuit chip.","html":"EMV tag 84. Similar to the application identifier stored on the integrated circuit chip."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"dedicated_file_name"},"terminal_verification_results":{"name":"terminal_verification_results","check":"string","validation":"string","documentation":{"markdown":"The outcome of a series of EMV functions performed by the card reader.","html":"The outcome of a series of EMV functions performed by the card reader."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"terminal_verification_results"},"transaction_status_information":{"name":"transaction_status_information","check":"string","validation":"string","documentation":{"markdown":"An indication of various EMV functions performed during the transaction.","html":"An indication of various EMV functions performed during the transaction."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"transaction_status_information"}},"object_type":"receipt"}},"object_type":"card_present"},"eps":{"name":"eps","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `eps` payment, this hash contains a snapshot of the transaction specific details of the `eps` payment method.","html":"If this is a \u003Ccode\u003Eeps\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Eeps\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"verified_name":{"name":"verified_name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by EPS directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated.\n","html":"Owner’s verified full name. Values are verified or provided by EPS directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"verified_name"}},"object_type":"eps"},"giropay":{"name":"giropay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `giropay` payment, this hash contains a snapshot of the transaction specific details of the `giropay` payment method.","html":"If this is a \u003Ccode\u003Egiropay\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Egiropay\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank_code":{"name":"bank_code","check":"string","validation":"string","documentation":{"markdown":"Bank code of bank associated with the bank account.","html":"Bank code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_code"},"bank_name":{"name":"bank_name","check":"string","validation":"string","documentation":{"markdown":"Name of the bank associated with the bank account.","html":"Name of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_name"},"bic":{"name":"bic","check":"string","validation":"string","documentation":{"markdown":"Bank Identifier Code of the bank associated with the bank account.","html":"Bank Identifier Code of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bic"},"verified_name":{"name":"verified_name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by Giropay directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated.\n","html":"Owner’s verified full name. Values are verified or provided by Giropay directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"verified_name"}},"object_type":"giropay"},"ideal":{"name":"ideal","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `ideal` payment, this hash contains a snapshot of the transaction specific details of the `ideal` payment method.","html":"If this is a \u003Ccode\u003Eideal\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Eideal\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank":{"name":"bank","check":"string","validation":"string","documentation":{"markdown":"The customer's bank. Can be one of `abn_amro`, `asn_bank`, `bunq`, `handelsbanken`, `ing`, `knab`, `moneyou`, `rabobank`, `regiobank`, `sns_bank`, `triodos_bank`, or `van_lanschot`.","html":"The customer’s bank. Can be one of \u003Ccode\u003Eabn_amro\u003C/code\u003E, \u003Ccode\u003Easn_bank\u003C/code\u003E, \u003Ccode\u003Ebunq\u003C/code\u003E, \u003Ccode\u003Ehandelsbanken\u003C/code\u003E, \u003Ccode\u003Eing\u003C/code\u003E, \u003Ccode\u003Eknab\u003C/code\u003E, \u003Ccode\u003Emoneyou\u003C/code\u003E, \u003Ccode\u003Erabobank\u003C/code\u003E, \u003Ccode\u003Eregiobank\u003C/code\u003E, \u003Ccode\u003Esns_bank\u003C/code\u003E, \u003Ccode\u003Etriodos_bank\u003C/code\u003E, or \u003Ccode\u003Evan_lanschot\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank"},"bic":{"name":"bic","check":"string","validation":"string","documentation":{"markdown":"The Bank Identifier Code of the customer's bank.","html":"The Bank Identifier Code of the customer’s bank."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bic"},"iban_last4":{"name":"iban_last4","check":"string","validation":"string","documentation":{"markdown":"Last four characters of the IBAN.","html":"Last four characters of the IBAN."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"iban_last4"},"verified_name":{"name":"verified_name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by iDEAL directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated.\n","html":"Owner’s verified full name. Values are verified or provided by iDEAL directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"verified_name"}},"object_type":"ideal"},"klarna":{"name":"klarna","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `klarna` payment, this hash contains a snapshot of the transaction specific details of the `klarna` payment method.","html":"If this is a \u003Ccode\u003Eklarna\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Eklarna\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"klarna"},"multibanco":{"name":"multibanco","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `multibanco` payment, this hash contains a snapshot of the transaction specific details of the `multibanco` payment method.","html":"If this is a \u003Ccode\u003Emultibanco\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Emultibanco\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"entity":{"name":"entity","check":"string","validation":"string","documentation":{"markdown":"Entity number associated with this Multibanco payment.","html":"Entity number associated with this Multibanco payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"entity"},"reference":{"name":"reference","check":"string","validation":"string","documentation":{"markdown":"Reference number associated with this Multibanco payment.","html":"Reference number associated with this Multibanco payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"reference"}},"object_type":"multibanco"},"p24":{"name":"p24","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `p24` payment, this hash contains a snapshot of the transaction specific details of the `p24` payment method.","html":"If this is a \u003Ccode\u003Ep24\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Ep24\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"reference":{"name":"reference","check":"string","validation":"string","documentation":{"markdown":"Unique reference for this Przelewy24 payment.","html":"Unique reference for this Przelewy24 payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"reference"},"verified_name":{"name":"verified_name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by Przelewy24 directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated.\n","html":"Owner’s verified full name. Values are verified or provided by Przelewy24 directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"verified_name"}},"object_type":"p24"},"sepa_debit":{"name":"sepa_debit","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `sepa_debit` payment, this hash contains a snapshot of the transaction specific details of the `sepa_debit` payment method.","html":"If this is a \u003Ccode\u003Esepa_debit\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Esepa_debit\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank_code":{"name":"bank_code","check":"string","validation":"string","documentation":{"markdown":"Bank code of bank associated with the bank account.","html":"Bank code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_code"},"branch_code":{"name":"branch_code","check":"string","validation":"string","documentation":{"markdown":"Branch code of bank associated with the bank account.","html":"Branch code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"branch_code"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country the bank account is located in.","html":"Two-letter ISO code representing the country the bank account is located in."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"fingerprint":{"name":"fingerprint","check":"string","validation":"string","documentation":{"markdown":"Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.","html":"Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"fingerprint"},"last4":{"name":"last4","check":"string","validation":"string","documentation":{"markdown":"Last four characters of the IBAN.","html":"Last four characters of the IBAN."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"last4"},"mandate":{"name":"mandate","check":"string","validation":"string","documentation":{"markdown":"ID of the mandate used to make this payment.","html":"ID of the mandate used to make this payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"mandate"}},"object_type":"sepa_debit"},"sofort":{"name":"sofort","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `sofort` payment, this hash contains a snapshot of the transaction specific details of the `sofort` payment method.","html":"If this is a \u003Ccode\u003Esofort\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Esofort\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank_code":{"name":"bank_code","check":"string","validation":"string","documentation":{"markdown":"Bank code of bank associated with the bank account.","html":"Bank code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_code"},"bank_name":{"name":"bank_name","check":"string","validation":"string","documentation":{"markdown":"Name of the bank associated with the bank account.","html":"Name of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_name"},"bic":{"name":"bic","check":"string","validation":"string","documentation":{"markdown":"Bank Identifier Code of the bank associated with the bank account.","html":"Bank Identifier Code of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bic"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country the bank account is located in.","html":"Two-letter ISO code representing the country the bank account is located in."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"iban_last4":{"name":"iban_last4","check":"string","validation":"string","documentation":{"markdown":"Last four characters of the IBAN.","html":"Last four characters of the IBAN."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"iban_last4"},"verified_name":{"name":"verified_name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by SOFORT directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated.\n","html":"Owner’s verified full name. Values are verified or provided by SOFORT directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"verified_name"}},"object_type":"sofort"},"stripe_account":{"name":"stripe_account","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `stripe_account` payment, this hash contains a snapshot of the transaction specific details of the `stripe_account` payment method.","html":"If this is a \u003Ccode\u003Estripe_account\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Estripe_account\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"stripe_account"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"The type of transaction-specific details of the payment method used in the payment, one of `ach_credit_transfer`, `ach_debit`, `alipay`, `bancontact`, `card`, `card_present`, `eps`, `giropay`, `ideal`, `klarna`, `multibanco`, `p24`, `sepa_debit`, `sofort`, `stripe_account`, or `wechat`.\nAn additional hash is included on `payment_method_details` with a name matching this value.\nIt contains information specific to the payment method.\n","html":"The type of transaction-specific details of the payment method used in the payment, one of \u003Ccode\u003Each_credit_transfer\u003C/code\u003E, \u003Ccode\u003Each_debit\u003C/code\u003E, \u003Ccode\u003Ealipay\u003C/code\u003E, \u003Ccode\u003Ebancontact\u003C/code\u003E, \u003Ccode\u003Ecard\u003C/code\u003E, \u003Ccode\u003Ecard_present\u003C/code\u003E, \u003Ccode\u003Eeps\u003C/code\u003E, \u003Ccode\u003Egiropay\u003C/code\u003E, \u003Ccode\u003Eideal\u003C/code\u003E, \u003Ccode\u003Eklarna\u003C/code\u003E, \u003Ccode\u003Emultibanco\u003C/code\u003E, \u003Ccode\u003Ep24\u003C/code\u003E, \u003Ccode\u003Esepa_debit\u003C/code\u003E, \u003Ccode\u003Esofort\u003C/code\u003E, \u003Ccode\u003Estripe_account\u003C/code\u003E, or \u003Ccode\u003Ewechat\u003C/code\u003E.\nAn additional hash is included on \u003Ccode\u003Epayment_method_details\u003C/code\u003E with a name matching this value.\nIt contains information specific to the payment method."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"type"},"wechat":{"name":"wechat","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `wechat` payment, this hash contains a snapshot of the transaction specific details of the `wechat` payment method.","html":"If this is a \u003Ccode\u003Ewechat\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Ewechat\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"wechat"}},"object_type":"payment_method_details"}},"object_type":"generated_from"},"last4":{"name":"last4","check":"string","validation":"string","documentation":{"markdown":"The last four digits of the card.","html":"The last four digits of the card."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"last4"},"three_d_secure_usage":{"name":"three_d_secure_usage","check":"hash","validation":"hash","documentation":{"markdown":"Contains details on how this Card maybe be used for 3D Secure authentication.","html":"Contains details on how this Card maybe be used for 3D Secure authentication."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"supported":{"name":"supported","check":"boolean","validation":"boolean","documentation":{"markdown":"Whether 3D Secure is supported on this card.","html":"Whether 3D Secure is supported on this card."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"supported"}},"object_type":"three_d_secure_usage"},"wallet":{"name":"wallet","check":"hash","validation":"hash","documentation":{"markdown":"If this Card is part of a card wallet, this contains the details of the card wallet.","html":"If this Card is part of a card wallet, this contains the details of the card wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"amex_express_checkout":{"name":"amex_express_checkout","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `amex_express_checkout` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Eamex_express_checkout\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"amex_express_checkout"},"apple_pay":{"name":"apple_pay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `apple_pay` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Eapple_pay\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"apple_pay"},"dynamic_last4":{"name":"dynamic_last4","check":"string","validation":"string","documentation":{"markdown":"(For tokenized numbers only.) The last four digits of the device account number.","html":"(For tokenized numbers only.) The last four digits of the device account number."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"dynamic_last4"},"google_pay":{"name":"google_pay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `google_pay` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Egoogle_pay\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"google_pay"},"masterpass":{"name":"masterpass","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `masterpass` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Emasterpass\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"billing_address":{"name":"billing_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"billing_address"},"email":{"name":"email","check":"string","validation":"string","documentation":{"markdown":"Owner's verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"email"},"name":{"name":"name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"name"},"shipping_address":{"name":"shipping_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"shipping_address"}},"object_type":"masterpass"},"samsung_pay":{"name":"samsung_pay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `samsung_pay` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Esamsung_pay\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"samsung_pay"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"The type of the card wallet, one of `amex_express_checkout`, `apple_pay`, `google_pay`, `masterpass`, `samsung_pay`, or `visa_checkout`. An additional hash is included on the Wallet subhash with a name matching this value. It contains additional information specific to the card wallet type.","html":"The type of the card wallet, one of \u003Ccode\u003Eamex_express_checkout\u003C/code\u003E, \u003Ccode\u003Eapple_pay\u003C/code\u003E, \u003Ccode\u003Egoogle_pay\u003C/code\u003E, \u003Ccode\u003Emasterpass\u003C/code\u003E, \u003Ccode\u003Esamsung_pay\u003C/code\u003E, or \u003Ccode\u003Evisa_checkout\u003C/code\u003E. An additional hash is included on the Wallet subhash with a name matching this value. It contains additional information specific to the card wallet type."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"type"},"visa_checkout":{"name":"visa_checkout","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `visa_checkout` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Evisa_checkout\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"billing_address":{"name":"billing_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"billing_address"},"email":{"name":"email","check":"string","validation":"string","documentation":{"markdown":"Owner's verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"email"},"name":{"name":"name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"name"},"shipping_address":{"name":"shipping_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"shipping_address"}},"object_type":"visa_checkout"}},"object_type":"wallet"}},"object_type":"card"},"card_present":{"name":"card_present","check":"hash","validation":"hash","documentation":{"markdown":"If this is an `card_present` PaymentMethod, this hash contains details about the Card Present payment method.","html":"If this is an \u003Ccode\u003Ecard_present\u003C/code\u003E PaymentMethod, this hash contains details about the Card Present payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"card_present"},"created":{"name":"created","check":"timestamp","validation":"timestamp","documentation":{"markdown":"Time at which the object was created. Measured in seconds since the Unix epoch.","html":"Time at which the object was created. Measured in seconds since the Unix epoch."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"created"},"customer":{"name":"customer","check":"string","validation":"string","documentation":{"markdown":"The ID of the Customer to which this PaymentMethod is saved. This will not be set when the PaymentMethod has not been saved to a Customer.","html":"The ID of the Customer to which this PaymentMethod is saved. This will not be set when the PaymentMethod has not been saved to a Customer."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"user_expandable":["customer"],"object_type":"customer"},"ideal":{"name":"ideal","check":"hash","validation":"hash","documentation":{"markdown":"If this is an `ideal` PaymentMethod, this hash contains details about the iDEAL payment method.","html":"If this is an \u003Ccode\u003Eideal\u003C/code\u003E PaymentMethod, this hash contains details about the iDEAL payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank":{"name":"bank","check":"string","validation":"string","documentation":{"markdown":"The customer's bank, if provided. Can be one of `abn_amro`, `asn_bank`, `bunq`, `handelsbanken`, `ing`, `knab`, `moneyou`, `rabobank`, `regiobank`, `sns_bank`, `triodos_bank`, or `van_lanschot`.","html":"The customer’s bank, if provided. Can be one of \u003Ccode\u003Eabn_amro\u003C/code\u003E, \u003Ccode\u003Easn_bank\u003C/code\u003E, \u003Ccode\u003Ebunq\u003C/code\u003E, \u003Ccode\u003Ehandelsbanken\u003C/code\u003E, \u003Ccode\u003Eing\u003C/code\u003E, \u003Ccode\u003Eknab\u003C/code\u003E, \u003Ccode\u003Emoneyou\u003C/code\u003E, \u003Ccode\u003Erabobank\u003C/code\u003E, \u003Ccode\u003Eregiobank\u003C/code\u003E, \u003Ccode\u003Esns_bank\u003C/code\u003E, \u003Ccode\u003Etriodos_bank\u003C/code\u003E, or \u003Ccode\u003Evan_lanschot\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank"},"bic":{"name":"bic","check":"string","validation":"string","documentation":{"markdown":"The Bank Identifier Code of the customer's bank, if the bank was provided.","html":"The Bank Identifier Code of the customer’s bank, if the bank was provided."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bic"}},"object_type":"ideal"},"livemode":{"name":"livemode","check":"boolean","validation":"boolean","documentation":{"markdown":"Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.","html":"Has the value \u003Ccode\u003Etrue\u003C/code\u003E if the object exists in live mode or the value \u003Ccode\u003Efalse\u003C/code\u003E if the object exists in test mode."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"livemode"},"metadata":{"name":"metadata","check":"hash","validation":"hash","documentation":{"markdown":"Set of key-value pairs that you can attach to an object. This can be useful for storing additional information about the object in a structured format.","html":"Set of key-value pairs that you can attach to an object. This can be useful for storing additional information about the object in a structured format."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"metadata"},"sepa_debit":{"name":"sepa_debit","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `sepa_debit` PaymentMethod, this hash contains details about the SEPA debit bank account.","html":"If this is a \u003Ccode\u003Esepa_debit\u003C/code\u003E PaymentMethod, this hash contains details about the SEPA debit bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank_code":{"name":"bank_code","check":"string","validation":"string","documentation":{"markdown":"Bank code of bank associated with the bank account.","html":"Bank code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_code"},"branch_code":{"name":"branch_code","check":"string","validation":"string","documentation":{"markdown":"Branch code of bank associated with the bank account.","html":"Branch code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"branch_code"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country the bank account is located in.","html":"Two-letter ISO code representing the country the bank account is located in."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"fingerprint":{"name":"fingerprint","check":"string","validation":"string","documentation":{"markdown":"Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.","html":"Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"fingerprint"},"last4":{"name":"last4","check":"string","validation":"string","documentation":{"markdown":"Last four characters of the IBAN.","html":"Last four characters of the IBAN."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"last4"}},"object_type":"sepa_debit"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"The type of the PaymentMethod. An additional hash is included on the PaymentMethod with a name matching this value. It contains additional information specific to the PaymentMethod type.","html":"The type of the PaymentMethod. An additional hash is included on the PaymentMethod with a name matching this value. It contains additional information specific to the PaymentMethod type."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"enum_values":{"card":{"documentation":null},"ideal":{"documentation":null},"sepa_debit":{"documentation":null}},"object_type":"type"}},"object_type":"payment_method"},"setup_intent":{"name":"setup_intent","check":"hash","validation":"hash","documentation":{"markdown":"The SetupIntent object for errors returned on a request involving a SetupIntent.","html":"The SetupIntent object for errors returned on a request involving a SetupIntent."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"setup_intent","subspec":{"id":{"name":"id","check":"string","validation":"string","documentation":{"markdown":"Unique identifier for the object.","html":"Unique identifier for the object."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"id"},"object":{"name":"object","check":"string","validation":"string","documentation":{"markdown":"String representing the object's type. Objects of the same type share the same value.","html":"String representing the object’s type. Objects of the same type share the same value."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"object"},"application":{"name":"application","check":"string","validation":"string","documentation":{"markdown":"ID of the Connect application that created the SetupIntent.","html":"ID of the Connect application that created the SetupIntent."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"user_expandable":["application"],"object_type":"application"},"cancellation_reason":{"name":"cancellation_reason","check":"string","validation":"string","documentation":{"markdown":"Reason for cancellation of this SetupIntent, one of `abandoned`, `requested_by_customer`, or `duplicate`.","html":"Reason for cancellation of this SetupIntent, one of \u003Ccode\u003Eabandoned\u003C/code\u003E, \u003Ccode\u003Erequested_by_customer\u003C/code\u003E, or \u003Ccode\u003Eduplicate\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"cancellation_reason"},"client_secret":{"name":"client_secret","check":"string","validation":"string","documentation":{"markdown":"The client secret of this SetupIntent. Used for client-side retrieval using a publishable key.\n\nThe client secret can be used to complete payment setup from your frontend. It should not be stored, logged, embedded in URLs, or exposed to anyone other than the customer. Make sure that you have TLS enabled on any page that includes the client secret.","html":"The client secret of this SetupIntent. Used for client-side retrieval using a publishable key.\u003C/p\u003E\n\n\u003Cp\u003EThe client secret can be used to complete payment setup from your frontend. It should not be stored, logged, embedded in URLs, or exposed to anyone other than the customer. Make sure that you have TLS enabled on any page that includes the client secret."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"client_secret"},"created":{"name":"created","check":"timestamp","validation":"timestamp","documentation":{"markdown":"Time at which the object was created. Measured in seconds since the Unix epoch.","html":"Time at which the object was created. Measured in seconds since the Unix epoch."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"created"},"customer":{"name":"customer","check":"string","validation":"string","documentation":{"markdown":"ID of the Customer this SetupIntent belongs to, if one exists.\n\nIf present, payment methods used with this SetupIntent can only be attached to this Customer, and payment methods attached to other Customers cannot be used with this SetupIntent.\n","html":"ID of the Customer this SetupIntent belongs to, if one exists.\u003C/p\u003E\n\n\u003Cp\u003EIf present, payment methods used with this SetupIntent can only be attached to this Customer, and payment methods attached to other Customers cannot be used with this SetupIntent."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"user_expandable":["customer"],"object_type":"customer"},"description":{"name":"description","check":"string","validation":"string","documentation":{"markdown":"An arbitrary string attached to the object. Often useful for displaying to users.","html":"An arbitrary string attached to the object. Often useful for displaying to users."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"description"},"last_setup_error":{"name":"last_setup_error","check":"hash","validation":"hash","documentation":{"markdown":"The error encountered in the previous SetupIntent confirmation.","html":"The error encountered in the previous SetupIntent confirmation."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"code":{"name":"code","check":"string","validation":"string","documentation":{"markdown":"For some errors that could be handled programmatically, a short string indicating the [error code](/docs/error-codes) reported.","html":"For some errors that could be handled programmatically, a short string indicating the \u003Ca href=\"/docs/error-codes\"\u003Eerror code\u003C/a\u003E reported."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"code"},"decline_code":{"name":"decline_code","check":"string","validation":"string","documentation":{"markdown":"For card errors resulting from a card issuer decline, a short string indicating the [card issuer's reason for the decline](/docs/declines#issuer-declines) if they provide one.","html":"For card errors resulting from a card issuer decline, a short string indicating the \u003Ca href=\"/docs/declines#issuer-declines\"\u003Ecard issuer’s reason for the decline\u003C/a\u003E if they provide one."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"decline_code"},"doc_url":{"name":"doc_url","check":"string","validation":"string","documentation":{"markdown":"A URL to more information about the [error code](/docs/error-codes) reported.","html":"A URL to more information about the \u003Ca href=\"/docs/error-codes\"\u003Eerror code\u003C/a\u003E reported."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"doc_url"},"message":{"name":"message","check":"string","validation":"string","documentation":{"markdown":"A human-readable message providing more details about the error. For card errors, these messages can be shown to your users.","html":"A human-readable message providing more details about the error. For card errors, these messages can be shown to your users."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"message"},"param":{"name":"param","check":"string","validation":"string","documentation":{"markdown":"If the error is parameter-specific, the parameter related to the error. For example, you can use this to display a message near the correct form field.","html":"If the error is parameter-specific, the parameter related to the error. For example, you can use this to display a message near the correct form field."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"param"},"payment_method":{"name":"payment_method","check":"hash","validation":"hash","documentation":{"markdown":"The PaymentMethod object for errors returned on a request involving a PaymentMethod.","html":"The PaymentMethod object for errors returned on a request involving a PaymentMethod."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"id":{"name":"id","check":"string","validation":"string","documentation":{"markdown":"Unique identifier for the object.","html":"Unique identifier for the object."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"id"},"object":{"name":"object","check":"string","validation":"string","documentation":{"markdown":"String representing the object's type. Objects of the same type share the same value.","html":"String representing the object’s type. Objects of the same type share the same value."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"object"},"billing_details":{"name":"billing_details","check":"hash","validation":"hash","documentation":{"markdown":"Billing information associated with the PaymentMethod that may be used or required by particular types of payment methods.","html":"Billing information associated with the PaymentMethod that may be used or required by particular types of payment methods."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"address":{"name":"address","check":"hash","validation":"hash","documentation":{"markdown":"Billing address.","html":"Billing address."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"address"},"email":{"name":"email","check":"string","validation":"string","documentation":{"markdown":"Email address.","html":"Email address."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"email"},"name":{"name":"name","check":"string","validation":"string","documentation":{"markdown":"Full name.","html":"Full name."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"name"},"phone":{"name":"phone","check":"string","validation":"string","documentation":{"markdown":"Billing phone number (including extension).","html":"Billing phone number (including extension)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"phone"}},"object_type":"billing_details"},"card":{"name":"card","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `card` PaymentMethod, this hash contains details about the card.","html":"If this is a \u003Ccode\u003Ecard\u003C/code\u003E PaymentMethod, this hash contains details about the card."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"brand":{"name":"brand","check":"string","validation":"string","documentation":{"markdown":"Card brand. Can be `amex`, `diners`, `discover`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.","html":"Card brand. Can be \u003Ccode\u003Eamex\u003C/code\u003E, \u003Ccode\u003Ediners\u003C/code\u003E, \u003Ccode\u003Ediscover\u003C/code\u003E, \u003Ccode\u003Ejcb\u003C/code\u003E, \u003Ccode\u003Emastercard\u003C/code\u003E, \u003Ccode\u003Eunionpay\u003C/code\u003E, \u003Ccode\u003Evisa\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"brand"},"checks":{"name":"checks","check":"hash","validation":"hash","documentation":{"markdown":"Checks on Card address and CVC if provided.","html":"Checks on Card address and CVC if provided."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"address_line1_check":{"name":"address_line1_check","check":"string","validation":"string","documentation":{"markdown":"If a address line1 was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.","html":"If a address line1 was provided, results of the check, one of \u003Ccode\u003Epass\u003C/code\u003E, \u003Ccode\u003Efail\u003C/code\u003E, \u003Ccode\u003Eunavailable\u003C/code\u003E, or \u003Ccode\u003Eunchecked\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"address_line1_check"},"address_postal_code_check":{"name":"address_postal_code_check","check":"string","validation":"string","documentation":{"markdown":"If a address postal code was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.","html":"If a address postal code was provided, results of the check, one of \u003Ccode\u003Epass\u003C/code\u003E, \u003Ccode\u003Efail\u003C/code\u003E, \u003Ccode\u003Eunavailable\u003C/code\u003E, or \u003Ccode\u003Eunchecked\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"address_postal_code_check"},"cvc_check":{"name":"cvc_check","check":"string","validation":"string","documentation":{"markdown":"If a CVC was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.","html":"If a CVC was provided, results of the check, one of \u003Ccode\u003Epass\u003C/code\u003E, \u003Ccode\u003Efail\u003C/code\u003E, \u003Ccode\u003Eunavailable\u003C/code\u003E, or \u003Ccode\u003Eunchecked\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"cvc_check"}},"object_type":"checks"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.","html":"Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you’ve collected."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"exp_month":{"name":"exp_month","check":"integer","validation":"integer","documentation":{"markdown":"Two-digit number representing the card's expiration month.","html":"Two-digit number representing the card’s expiration month."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"exp_month"},"exp_year":{"name":"exp_year","check":"integer","validation":"integer","documentation":{"markdown":"Four-digit number representing the card's expiration year.","html":"Four-digit number representing the card’s expiration year."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"exp_year"},"fingerprint":{"name":"fingerprint","check":"string","validation":"string","documentation":{"markdown":"Uniquely identifies this particular card number. You can use this attribute to check whether two customers who've signed up with you are using the same card number, for example.","html":"Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":"card_fingerprint_read","hide_nil":null,"is_country_specific":false,"object_type":"fingerprint"},"funding":{"name":"funding","check":"string","validation":"string","documentation":{"markdown":"Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.","html":"Card funding type. Can be \u003Ccode\u003Ecredit\u003C/code\u003E, \u003Ccode\u003Edebit\u003C/code\u003E, \u003Ccode\u003Eprepaid\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"funding"},"generated_from":{"name":"generated_from","check":"hash","validation":"hash","documentation":{"markdown":"Details of the original PaymentMethod that created this object.","html":"Details of the original PaymentMethod that created this object.","gate_specific":{"sdk_client_public":{"undocumented":true}}},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"charge":{"name":"charge","check":"string","validation":"string","documentation":{"markdown":"The charge that created this object.","html":"The charge that created this object."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"charge"},"payment_method_details":{"name":"payment_method_details","check":"hash","validation":"hash","documentation":{"markdown":"Transaction-specific details of the payment method used in the payment.","html":"Transaction-specific details of the payment method used in the payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"ach_credit_transfer":{"name":"ach_credit_transfer","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `ach_credit_transfer` payment, this hash contains a snapshot of the transaction specific details of the `ach_credit_transfer` payment method.","html":"If this is a \u003Ccode\u003Each_credit_transfer\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Each_credit_transfer\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"account_number":{"name":"account_number","check":"string","validation":"string","documentation":{"markdown":"Account number to transfer funds to.","html":"Account number to transfer funds to."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"account_number"},"bank_name":{"name":"bank_name","check":"string","validation":"string","documentation":{"markdown":"Name of the bank associated with the routing number.","html":"Name of the bank associated with the routing number."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_name"},"routing_number":{"name":"routing_number","check":"string","validation":"string","documentation":{"markdown":"Routing transit number for the bank account to transfer funds to.","html":"Routing transit number for the bank account to transfer funds to."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"routing_number"},"swift_code":{"name":"swift_code","check":"string","validation":"string","documentation":{"markdown":"SWIFT code of the bank associated with the routing number.","html":"SWIFT code of the bank associated with the routing number."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"swift_code"}},"object_type":"ach_credit_transfer"},"ach_debit":{"name":"ach_debit","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `ach_debit` payment, this hash contains a snapshot of the transaction specific details of the `ach_debit` payment method.","html":"If this is a \u003Ccode\u003Each_debit\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Each_debit\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"account_holder_type":{"name":"account_holder_type","check":"string","validation":"string","documentation":{"markdown":"Type of entity that holds the account. This can be either `individual` or `company`.","html":"Type of entity that holds the account. This can be either \u003Ccode\u003Eindividual\u003C/code\u003E or \u003Ccode\u003Ecompany\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"account_holder_type"},"bank_name":{"name":"bank_name","check":"string","validation":"string","documentation":{"markdown":"Name of the bank associated with the bank account.","html":"Name of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_name"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country the bank account is located in.","html":"Two-letter ISO code representing the country the bank account is located in."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"fingerprint":{"name":"fingerprint","check":"string","validation":"string","documentation":{"markdown":"Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.","html":"Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"fingerprint"},"last4":{"name":"last4","check":"string","validation":"string","documentation":{"markdown":"Last four digits of the bank account number.","html":"Last four digits of the bank account number."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"last4"},"routing_number":{"name":"routing_number","check":"string","validation":"string","documentation":{"markdown":"Routing transit number of the bank account.","html":"Routing transit number of the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"routing_number"}},"object_type":"ach_debit"},"alipay":{"name":"alipay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `alipay` payment, this hash contains a snapshot of the transaction specific details of the `alipay` payment method.","html":"If this is a \u003Ccode\u003Ealipay\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Ealipay\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"alipay"},"bancontact":{"name":"bancontact","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `bancontact` payment, this hash contains a snapshot of the transaction specific details of the `bancontact` payment method.","html":"If this is a \u003Ccode\u003Ebancontact\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Ebancontact\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank_code":{"name":"bank_code","check":"string","validation":"string","documentation":{"markdown":"Bank code of bank associated with the bank account.","html":"Bank code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_code"},"bank_name":{"name":"bank_name","check":"string","validation":"string","documentation":{"markdown":"Name of the bank associated with the bank account.","html":"Name of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_name"},"bic":{"name":"bic","check":"string","validation":"string","documentation":{"markdown":"Bank Identifier Code of the bank associated with the bank account.","html":"Bank Identifier Code of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bic"},"iban_last4":{"name":"iban_last4","check":"string","validation":"string","documentation":{"markdown":"Last four characters of the IBAN.","html":"Last four characters of the IBAN."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"iban_last4"},"preferred_language":{"name":"preferred_language","check":"string","validation":"string","documentation":{"markdown":"Preferred language of the Bancontact authorization page that the customer is redirected to.\nCan be one of `en`, `de`, `fr`, or `nl`\n","html":"Preferred language of the Bancontact authorization page that the customer is redirected to.\nCan be one of \u003Ccode\u003Een\u003C/code\u003E, \u003Ccode\u003Ede\u003C/code\u003E, \u003Ccode\u003Efr\u003C/code\u003E, or \u003Ccode\u003Enl\u003C/code\u003E"},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"preferred_language"},"verified_name":{"name":"verified_name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by Bancontact directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated.\n","html":"Owner’s verified full name. Values are verified or provided by Bancontact directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"verified_name"}},"object_type":"bancontact"},"card":{"name":"card","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `card` payment, this hash contains a snapshot of the transaction specific details of the `card` payment method.","html":"If this is a \u003Ccode\u003Ecard\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Ecard\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"brand":{"name":"brand","check":"string","validation":"string","documentation":{"markdown":"Card brand. Can be `amex`, `diners`, `discover`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.","html":"Card brand. Can be \u003Ccode\u003Eamex\u003C/code\u003E, \u003Ccode\u003Ediners\u003C/code\u003E, \u003Ccode\u003Ediscover\u003C/code\u003E, \u003Ccode\u003Ejcb\u003C/code\u003E, \u003Ccode\u003Emastercard\u003C/code\u003E, \u003Ccode\u003Eunionpay\u003C/code\u003E, \u003Ccode\u003Evisa\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"brand"},"checks":{"name":"checks","check":"hash","validation":"hash","documentation":{"markdown":"Check results by Card networks on Card address and CVC at time of payment.","html":"Check results by Card networks on Card address and CVC at time of payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"address_line1_check":{"name":"address_line1_check","check":"string","validation":"string","documentation":{"markdown":"If a address line1 was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.","html":"If a address line1 was provided, results of the check, one of \u003Ccode\u003Epass\u003C/code\u003E, \u003Ccode\u003Efail\u003C/code\u003E, \u003Ccode\u003Eunavailable\u003C/code\u003E, or \u003Ccode\u003Eunchecked\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"address_line1_check"},"address_postal_code_check":{"name":"address_postal_code_check","check":"string","validation":"string","documentation":{"markdown":"If a address postal code was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.","html":"If a address postal code was provided, results of the check, one of \u003Ccode\u003Epass\u003C/code\u003E, \u003Ccode\u003Efail\u003C/code\u003E, \u003Ccode\u003Eunavailable\u003C/code\u003E, or \u003Ccode\u003Eunchecked\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"address_postal_code_check"},"cvc_check":{"name":"cvc_check","check":"string","validation":"string","documentation":{"markdown":"If a CVC was provided, results of the check, one of `pass`, `fail`, `unavailable`, or `unchecked`.","html":"If a CVC was provided, results of the check, one of \u003Ccode\u003Epass\u003C/code\u003E, \u003Ccode\u003Efail\u003C/code\u003E, \u003Ccode\u003Eunavailable\u003C/code\u003E, or \u003Ccode\u003Eunchecked\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"cvc_check"}},"object_type":"checks"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.","html":"Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you’ve collected."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"exp_month":{"name":"exp_month","check":"integer","validation":"integer","documentation":{"markdown":"Two-digit number representing the card's expiration month.","html":"Two-digit number representing the card’s expiration month."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"exp_month"},"exp_year":{"name":"exp_year","check":"integer","validation":"integer","documentation":{"markdown":"Four-digit number representing the card's expiration year.","html":"Four-digit number representing the card’s expiration year."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"exp_year"},"fingerprint":{"name":"fingerprint","check":"string","validation":"string","documentation":{"markdown":"Uniquely identifies this particular card number. You can use this attribute to check whether two customers who've signed up with you are using the same card number, for example.","html":"Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":"card_fingerprint_read","hide_nil":null,"is_country_specific":false,"object_type":"fingerprint"},"funding":{"name":"funding","check":"string","validation":"string","documentation":{"markdown":"Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.","html":"Card funding type. Can be \u003Ccode\u003Ecredit\u003C/code\u003E, \u003Ccode\u003Edebit\u003C/code\u003E, \u003Ccode\u003Eprepaid\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"funding"},"installments":{"name":"installments","check":"hash","validation":"hash","documentation":{"markdown":"Installment details for this payment (Mexico only).\n\nFor more information, see the [installments integration guide](/docs/payments/installments).\n","html":"Installment details for this payment (Mexico only).\u003C/p\u003E\n\n\u003Cp\u003EFor more information, see the \u003Ca href=\"/docs/payments/installments\"\u003Einstallments integration guide\u003C/a\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"plan":{"name":"plan","check":"hash","validation":"hash","documentation":{"markdown":"Installment plan selected for the payment.","html":"Installment plan selected for the payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"count":{"name":"count","check":"integer","validation":"integer","documentation":{"markdown":"For `fixed_count` installment plans, this is the number of installment payments your customer will make to their credit card.","html":"For \u003Ccode\u003Efixed_count\u003C/code\u003E installment plans, this is the number of installment payments your customer will make to their credit card."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"count"},"interval":{"name":"interval","check":"string","validation":"string","documentation":{"markdown":"For `fixed_count` installment plans, this is the interval between installment payments your customer will make to their credit card.\nOne of `month`.\n","html":"For \u003Ccode\u003Efixed_count\u003C/code\u003E installment plans, this is the interval between installment payments your customer will make to their credit card.\nOne of \u003Ccode\u003Emonth\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"interval"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"Type of installment plan, one of `fixed_count`.","html":"Type of installment plan, one of \u003Ccode\u003Efixed_count\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"type"}},"object_type":"plan"}},"object_type":"installments"},"last4":{"name":"last4","check":"string","validation":"string","documentation":{"markdown":"The last four digits of the card.","html":"The last four digits of the card."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"last4"},"network":{"name":"network","check":"string","validation":"string","documentation":{"markdown":"Identifies which network this charge was processed on. Can be `amex`, `diners`, `discover`, `interac`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.","html":"Identifies which network this charge was processed on. Can be \u003Ccode\u003Eamex\u003C/code\u003E, \u003Ccode\u003Ediners\u003C/code\u003E, \u003Ccode\u003Ediscover\u003C/code\u003E, \u003Ccode\u003Einterac\u003C/code\u003E, \u003Ccode\u003Ejcb\u003C/code\u003E, \u003Ccode\u003Emastercard\u003C/code\u003E, \u003Ccode\u003Eunionpay\u003C/code\u003E, \u003Ccode\u003Evisa\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"network"},"three_d_secure":{"name":"three_d_secure","check":"hash","validation":"hash","documentation":{"markdown":"Populated if this transaction used 3D Secure authentication.","html":"Populated if this transaction used 3D Secure authentication."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"authenticated":{"name":"authenticated","check":"boolean","validation":"boolean","documentation":{"markdown":"Whether or not authentication was performed. 3D Secure will succeed without authentication when the card is not enrolled.","html":"Whether or not authentication was performed. 3D Secure will succeed without authentication when the card is not enrolled."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"authenticated"},"succeeded":{"name":"succeeded","check":"boolean","validation":"boolean","documentation":{"markdown":"Whether or not 3D Secure succeeded.","html":"Whether or not 3D Secure succeeded."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"succeeded"},"version":{"name":"version","check":"string","validation":"string","documentation":{"markdown":"The version of 3D Secure that was used for this payment.","html":"The version of 3D Secure that was used for this payment."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"version"}},"object_type":"three_d_secure"},"wallet":{"name":"wallet","check":"hash","validation":"hash","documentation":{"markdown":"If this Card is part of a card wallet, this contains the details of the card wallet.","html":"If this Card is part of a card wallet, this contains the details of the card wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"amex_express_checkout":{"name":"amex_express_checkout","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `amex_express_checkout` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Eamex_express_checkout\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"amex_express_checkout"},"apple_pay":{"name":"apple_pay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `apple_pay` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Eapple_pay\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"apple_pay"},"dynamic_last4":{"name":"dynamic_last4","check":"string","validation":"string","documentation":{"markdown":"(For tokenized numbers only.) The last four digits of the device account number.","html":"(For tokenized numbers only.) The last four digits of the device account number."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"dynamic_last4"},"google_pay":{"name":"google_pay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `google_pay` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Egoogle_pay\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"google_pay"},"masterpass":{"name":"masterpass","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `masterpass` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Emasterpass\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"billing_address":{"name":"billing_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"billing_address"},"email":{"name":"email","check":"string","validation":"string","documentation":{"markdown":"Owner's verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"email"},"name":{"name":"name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"name"},"shipping_address":{"name":"shipping_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"shipping_address"}},"object_type":"masterpass"},"samsung_pay":{"name":"samsung_pay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `samsung_pay` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Esamsung_pay\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"samsung_pay"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"The type of the card wallet, one of `amex_express_checkout`, `apple_pay`, `google_pay`, `masterpass`, `samsung_pay`, or `visa_checkout`. An additional hash is included on the Wallet subhash with a name matching this value. It contains additional information specific to the card wallet type.","html":"The type of the card wallet, one of \u003Ccode\u003Eamex_express_checkout\u003C/code\u003E, \u003Ccode\u003Eapple_pay\u003C/code\u003E, \u003Ccode\u003Egoogle_pay\u003C/code\u003E, \u003Ccode\u003Emasterpass\u003C/code\u003E, \u003Ccode\u003Esamsung_pay\u003C/code\u003E, or \u003Ccode\u003Evisa_checkout\u003C/code\u003E. An additional hash is included on the Wallet subhash with a name matching this value. It contains additional information specific to the card wallet type."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"type"},"visa_checkout":{"name":"visa_checkout","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `visa_checkout` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Evisa_checkout\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"billing_address":{"name":"billing_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"billing_address"},"email":{"name":"email","check":"string","validation":"string","documentation":{"markdown":"Owner's verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"email"},"name":{"name":"name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"name"},"shipping_address":{"name":"shipping_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"shipping_address"}},"object_type":"visa_checkout"}},"object_type":"wallet"}},"object_type":"card"},"card_present":{"name":"card_present","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `card_present` payment, this hash contains a snapshot of the transaction specific details of the `card_present` payment method.","html":"If this is a \u003Ccode\u003Ecard_present\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Ecard_present\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"brand":{"name":"brand","check":"string","validation":"string","documentation":{"markdown":"Card brand. Can be `amex`, `diners`, `discover`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.","html":"Card brand. Can be \u003Ccode\u003Eamex\u003C/code\u003E, \u003Ccode\u003Ediners\u003C/code\u003E, \u003Ccode\u003Ediscover\u003C/code\u003E, \u003Ccode\u003Ejcb\u003C/code\u003E, \u003Ccode\u003Emastercard\u003C/code\u003E, \u003Ccode\u003Eunionpay\u003C/code\u003E, \u003Ccode\u003Evisa\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"brand"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you've collected.","html":"Two-letter ISO code representing the country of the card. You could use this attribute to get a sense of the international breakdown of cards you’ve collected."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"emv_auth_data":{"name":"emv_auth_data","check":"string","validation":"string","documentation":{"markdown":"Authorization response cryptogram.","html":"Authorization response cryptogram."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"emv_auth_data"},"exp_month":{"name":"exp_month","check":"integer","validation":"integer","documentation":{"markdown":"Two-digit number representing the card's expiration month.","html":"Two-digit number representing the card’s expiration month."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"exp_month"},"exp_year":{"name":"exp_year","check":"integer","validation":"integer","documentation":{"markdown":"Four-digit number representing the card's expiration year.","html":"Four-digit number representing the card’s expiration year."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"exp_year"},"fingerprint":{"name":"fingerprint","check":"string","validation":"string","documentation":{"markdown":"Uniquely identifies this particular card number. You can use this attribute to check whether two customers who've signed up with you are using the same card number, for example.","html":"Uniquely identifies this particular card number. You can use this attribute to check whether two customers who’ve signed up with you are using the same card number, for example."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"fingerprint"},"funding":{"name":"funding","check":"string","validation":"string","documentation":{"markdown":"Card funding type. Can be `credit`, `debit`, `prepaid`, or `unknown`.","html":"Card funding type. Can be \u003Ccode\u003Ecredit\u003C/code\u003E, \u003Ccode\u003Edebit\u003C/code\u003E, \u003Ccode\u003Eprepaid\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"funding"},"generated_card":{"name":"generated_card","check":"string","validation":"string","documentation":{"markdown":"ID of a card PaymentMethod generated from the card_present PaymentMethod that may be attached to a Customer for future transactions. Only present if it was possible to generate a card PaymentMethod.","html":"ID of a card PaymentMethod generated from the card_present PaymentMethod that may be attached to a Customer for future transactions. Only present if it was possible to generate a card PaymentMethod."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"generated_card"},"last4":{"name":"last4","check":"string","validation":"string","documentation":{"markdown":"The last four digits of the card.","html":"The last four digits of the card."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"last4"},"network":{"name":"network","check":"string","validation":"string","documentation":{"markdown":"Identifies which network this charge was processed on. Can be `amex`, `diners`, `discover`, `interac`, `jcb`, `mastercard`, `unionpay`, `visa`, or `unknown`.","html":"Identifies which network this charge was processed on. Can be \u003Ccode\u003Eamex\u003C/code\u003E, \u003Ccode\u003Ediners\u003C/code\u003E, \u003Ccode\u003Ediscover\u003C/code\u003E, \u003Ccode\u003Einterac\u003C/code\u003E, \u003Ccode\u003Ejcb\u003C/code\u003E, \u003Ccode\u003Emastercard\u003C/code\u003E, \u003Ccode\u003Eunionpay\u003C/code\u003E, \u003Ccode\u003Evisa\u003C/code\u003E, or \u003Ccode\u003Eunknown\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"network"},"read_method":{"name":"read_method","check":"string","validation":"string","documentation":{"markdown":"How were card details read in this transaction. Can be contact_emv, contactless_emv, magnetic_stripe_fallback, magnetic_stripe_track2, or contactless_magstripe_mode","html":"How were card details read in this transaction. Can be contact_emv, contactless_emv, magnetic_stripe_fallback, magnetic_stripe_track2, or contactless_magstripe_mode"},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"read_method"},"receipt":{"name":"receipt","check":"hash","validation":"hash","documentation":{"markdown":"A collection of fields required to be displayed on receipts. Only required for EMV transactions.","html":"A collection of fields required to be displayed on receipts. Only required for EMV transactions."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"application_cryptogram":{"name":"application_cryptogram","check":"string","validation":"string","documentation":{"markdown":"EMV tag 9F26, cryptogram generated by the integrated circuit chip.","html":"EMV tag 9F26, cryptogram generated by the integrated circuit chip."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"application_cryptogram"},"application_preferred_name":{"name":"application_preferred_name","check":"string","validation":"string","documentation":{"markdown":"Mnenomic of the Application Identifier.","html":"Mnenomic of the Application Identifier."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"application_preferred_name"},"authorization_code":{"name":"authorization_code","check":"string","validation":"string","documentation":{"markdown":"Identifier for this transaction.","html":"Identifier for this transaction."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"authorization_code"},"authorization_response_code":{"name":"authorization_response_code","check":"string","validation":"string","documentation":{"markdown":"EMV tag 8A. A code returned by the card issuer.","html":"EMV tag 8A. A code returned by the card issuer."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"authorization_response_code"},"cardholder_verification_method":{"name":"cardholder_verification_method","check":"string","validation":"string","documentation":{"markdown":"How the cardholder verified ownership of the card.","html":"How the cardholder verified ownership of the card."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"cardholder_verification_method"},"dedicated_file_name":{"name":"dedicated_file_name","check":"string","validation":"string","documentation":{"markdown":"EMV tag 84. Similar to the application identifier stored on the integrated circuit chip.","html":"EMV tag 84. Similar to the application identifier stored on the integrated circuit chip."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"dedicated_file_name"},"terminal_verification_results":{"name":"terminal_verification_results","check":"string","validation":"string","documentation":{"markdown":"The outcome of a series of EMV functions performed by the card reader.","html":"The outcome of a series of EMV functions performed by the card reader."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"terminal_verification_results"},"transaction_status_information":{"name":"transaction_status_information","check":"string","validation":"string","documentation":{"markdown":"An indication of various EMV functions performed during the transaction.","html":"An indication of various EMV functions performed during the transaction."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"transaction_status_information"}},"object_type":"receipt"}},"object_type":"card_present"},"eps":{"name":"eps","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `eps` payment, this hash contains a snapshot of the transaction specific details of the `eps` payment method.","html":"If this is a \u003Ccode\u003Eeps\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Eeps\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"verified_name":{"name":"verified_name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by EPS directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated.\n","html":"Owner’s verified full name. Values are verified or provided by EPS directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"verified_name"}},"object_type":"eps"},"giropay":{"name":"giropay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `giropay` payment, this hash contains a snapshot of the transaction specific details of the `giropay` payment method.","html":"If this is a \u003Ccode\u003Egiropay\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Egiropay\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank_code":{"name":"bank_code","check":"string","validation":"string","documentation":{"markdown":"Bank code of bank associated with the bank account.","html":"Bank code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_code"},"bank_name":{"name":"bank_name","check":"string","validation":"string","documentation":{"markdown":"Name of the bank associated with the bank account.","html":"Name of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_name"},"bic":{"name":"bic","check":"string","validation":"string","documentation":{"markdown":"Bank Identifier Code of the bank associated with the bank account.","html":"Bank Identifier Code of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bic"},"verified_name":{"name":"verified_name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by Giropay directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated.\n","html":"Owner’s verified full name. Values are verified or provided by Giropay directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"verified_name"}},"object_type":"giropay"},"ideal":{"name":"ideal","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `ideal` payment, this hash contains a snapshot of the transaction specific details of the `ideal` payment method.","html":"If this is a \u003Ccode\u003Eideal\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Eideal\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank":{"name":"bank","check":"string","validation":"string","documentation":{"markdown":"The customer's bank. Can be one of `abn_amro`, `asn_bank`, `bunq`, `handelsbanken`, `ing`, `knab`, `moneyou`, `rabobank`, `regiobank`, `sns_bank`, `triodos_bank`, or `van_lanschot`.","html":"The customer’s bank. Can be one of \u003Ccode\u003Eabn_amro\u003C/code\u003E, \u003Ccode\u003Easn_bank\u003C/code\u003E, \u003Ccode\u003Ebunq\u003C/code\u003E, \u003Ccode\u003Ehandelsbanken\u003C/code\u003E, \u003Ccode\u003Eing\u003C/code\u003E, \u003Ccode\u003Eknab\u003C/code\u003E, \u003Ccode\u003Emoneyou\u003C/code\u003E, \u003Ccode\u003Erabobank\u003C/code\u003E, \u003Ccode\u003Eregiobank\u003C/code\u003E, \u003Ccode\u003Esns_bank\u003C/code\u003E, \u003Ccode\u003Etriodos_bank\u003C/code\u003E, or \u003Ccode\u003Evan_lanschot\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank"},"bic":{"name":"bic","check":"string","validation":"string","documentation":{"markdown":"The Bank Identifier Code of the customer's bank.","html":"The Bank Identifier Code of the customer’s bank."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bic"},"iban_last4":{"name":"iban_last4","check":"string","validation":"string","documentation":{"markdown":"Last four characters of the IBAN.","html":"Last four characters of the IBAN."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"iban_last4"},"verified_name":{"name":"verified_name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by iDEAL directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated.\n","html":"Owner’s verified full name. Values are verified or provided by iDEAL directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"verified_name"}},"object_type":"ideal"},"klarna":{"name":"klarna","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `klarna` payment, this hash contains a snapshot of the transaction specific details of the `klarna` payment method.","html":"If this is a \u003Ccode\u003Eklarna\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Eklarna\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"klarna"},"multibanco":{"name":"multibanco","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `multibanco` payment, this hash contains a snapshot of the transaction specific details of the `multibanco` payment method.","html":"If this is a \u003Ccode\u003Emultibanco\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Emultibanco\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"entity":{"name":"entity","check":"string","validation":"string","documentation":{"markdown":"Entity number associated with this Multibanco payment.","html":"Entity number associated with this Multibanco payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"entity"},"reference":{"name":"reference","check":"string","validation":"string","documentation":{"markdown":"Reference number associated with this Multibanco payment.","html":"Reference number associated with this Multibanco payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"reference"}},"object_type":"multibanco"},"p24":{"name":"p24","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `p24` payment, this hash contains a snapshot of the transaction specific details of the `p24` payment method.","html":"If this is a \u003Ccode\u003Ep24\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Ep24\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"reference":{"name":"reference","check":"string","validation":"string","documentation":{"markdown":"Unique reference for this Przelewy24 payment.","html":"Unique reference for this Przelewy24 payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"reference"},"verified_name":{"name":"verified_name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by Przelewy24 directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated.\n","html":"Owner’s verified full name. Values are verified or provided by Przelewy24 directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"verified_name"}},"object_type":"p24"},"sepa_debit":{"name":"sepa_debit","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `sepa_debit` payment, this hash contains a snapshot of the transaction specific details of the `sepa_debit` payment method.","html":"If this is a \u003Ccode\u003Esepa_debit\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Esepa_debit\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank_code":{"name":"bank_code","check":"string","validation":"string","documentation":{"markdown":"Bank code of bank associated with the bank account.","html":"Bank code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_code"},"branch_code":{"name":"branch_code","check":"string","validation":"string","documentation":{"markdown":"Branch code of bank associated with the bank account.","html":"Branch code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"branch_code"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country the bank account is located in.","html":"Two-letter ISO code representing the country the bank account is located in."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"fingerprint":{"name":"fingerprint","check":"string","validation":"string","documentation":{"markdown":"Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.","html":"Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"fingerprint"},"last4":{"name":"last4","check":"string","validation":"string","documentation":{"markdown":"Last four characters of the IBAN.","html":"Last four characters of the IBAN."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"last4"},"mandate":{"name":"mandate","check":"string","validation":"string","documentation":{"markdown":"ID of the mandate used to make this payment.","html":"ID of the mandate used to make this payment."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"mandate"}},"object_type":"sepa_debit"},"sofort":{"name":"sofort","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `sofort` payment, this hash contains a snapshot of the transaction specific details of the `sofort` payment method.","html":"If this is a \u003Ccode\u003Esofort\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Esofort\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank_code":{"name":"bank_code","check":"string","validation":"string","documentation":{"markdown":"Bank code of bank associated with the bank account.","html":"Bank code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_code"},"bank_name":{"name":"bank_name","check":"string","validation":"string","documentation":{"markdown":"Name of the bank associated with the bank account.","html":"Name of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_name"},"bic":{"name":"bic","check":"string","validation":"string","documentation":{"markdown":"Bank Identifier Code of the bank associated with the bank account.","html":"Bank Identifier Code of the bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bic"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country the bank account is located in.","html":"Two-letter ISO code representing the country the bank account is located in."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"iban_last4":{"name":"iban_last4","check":"string","validation":"string","documentation":{"markdown":"Last four characters of the IBAN.","html":"Last four characters of the IBAN."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"iban_last4"},"verified_name":{"name":"verified_name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by SOFORT directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated.\n","html":"Owner’s verified full name. Values are verified or provided by SOFORT directly\n(if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"verified_name"}},"object_type":"sofort"},"stripe_account":{"name":"stripe_account","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `stripe_account` payment, this hash contains a snapshot of the transaction specific details of the `stripe_account` payment method.","html":"If this is a \u003Ccode\u003Estripe_account\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Estripe_account\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"stripe_account"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"The type of transaction-specific details of the payment method used in the payment, one of `ach_credit_transfer`, `ach_debit`, `alipay`, `bancontact`, `card`, `card_present`, `eps`, `giropay`, `ideal`, `klarna`, `multibanco`, `p24`, `sepa_debit`, `sofort`, `stripe_account`, or `wechat`.\nAn additional hash is included on `payment_method_details` with a name matching this value.\nIt contains information specific to the payment method.\n","html":"The type of transaction-specific details of the payment method used in the payment, one of \u003Ccode\u003Each_credit_transfer\u003C/code\u003E, \u003Ccode\u003Each_debit\u003C/code\u003E, \u003Ccode\u003Ealipay\u003C/code\u003E, \u003Ccode\u003Ebancontact\u003C/code\u003E, \u003Ccode\u003Ecard\u003C/code\u003E, \u003Ccode\u003Ecard_present\u003C/code\u003E, \u003Ccode\u003Eeps\u003C/code\u003E, \u003Ccode\u003Egiropay\u003C/code\u003E, \u003Ccode\u003Eideal\u003C/code\u003E, \u003Ccode\u003Eklarna\u003C/code\u003E, \u003Ccode\u003Emultibanco\u003C/code\u003E, \u003Ccode\u003Ep24\u003C/code\u003E, \u003Ccode\u003Esepa_debit\u003C/code\u003E, \u003Ccode\u003Esofort\u003C/code\u003E, \u003Ccode\u003Estripe_account\u003C/code\u003E, or \u003Ccode\u003Ewechat\u003C/code\u003E.\nAn additional hash is included on \u003Ccode\u003Epayment_method_details\u003C/code\u003E with a name matching this value.\nIt contains information specific to the payment method."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"type"},"wechat":{"name":"wechat","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `wechat` payment, this hash contains a snapshot of the transaction specific details of the `wechat` payment method.","html":"If this is a \u003Ccode\u003Ewechat\u003C/code\u003E payment, this hash contains a snapshot of the transaction specific details of the \u003Ccode\u003Ewechat\u003C/code\u003E payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"wechat"}},"object_type":"payment_method_details"}},"object_type":"generated_from"},"last4":{"name":"last4","check":"string","validation":"string","documentation":{"markdown":"The last four digits of the card.","html":"The last four digits of the card."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"last4"},"three_d_secure_usage":{"name":"three_d_secure_usage","check":"hash","validation":"hash","documentation":{"markdown":"Contains details on how this Card maybe be used for 3D Secure authentication.","html":"Contains details on how this Card maybe be used for 3D Secure authentication."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"supported":{"name":"supported","check":"boolean","validation":"boolean","documentation":{"markdown":"Whether 3D Secure is supported on this card.","html":"Whether 3D Secure is supported on this card."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"supported"}},"object_type":"three_d_secure_usage"},"wallet":{"name":"wallet","check":"hash","validation":"hash","documentation":{"markdown":"If this Card is part of a card wallet, this contains the details of the card wallet.","html":"If this Card is part of a card wallet, this contains the details of the card wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"amex_express_checkout":{"name":"amex_express_checkout","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `amex_express_checkout` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Eamex_express_checkout\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"amex_express_checkout"},"apple_pay":{"name":"apple_pay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `apple_pay` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Eapple_pay\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"apple_pay"},"dynamic_last4":{"name":"dynamic_last4","check":"string","validation":"string","documentation":{"markdown":"(For tokenized numbers only.) The last four digits of the device account number.","html":"(For tokenized numbers only.) The last four digits of the device account number."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"dynamic_last4"},"google_pay":{"name":"google_pay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `google_pay` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Egoogle_pay\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"google_pay"},"masterpass":{"name":"masterpass","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `masterpass` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Emasterpass\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"billing_address":{"name":"billing_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"billing_address"},"email":{"name":"email","check":"string","validation":"string","documentation":{"markdown":"Owner's verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"email"},"name":{"name":"name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"name"},"shipping_address":{"name":"shipping_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"shipping_address"}},"object_type":"masterpass"},"samsung_pay":{"name":"samsung_pay","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `samsung_pay` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Esamsung_pay\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"samsung_pay"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"The type of the card wallet, one of `amex_express_checkout`, `apple_pay`, `google_pay`, `masterpass`, `samsung_pay`, or `visa_checkout`. An additional hash is included on the Wallet subhash with a name matching this value. It contains additional information specific to the card wallet type.","html":"The type of the card wallet, one of \u003Ccode\u003Eamex_express_checkout\u003C/code\u003E, \u003Ccode\u003Eapple_pay\u003C/code\u003E, \u003Ccode\u003Egoogle_pay\u003C/code\u003E, \u003Ccode\u003Emasterpass\u003C/code\u003E, \u003Ccode\u003Esamsung_pay\u003C/code\u003E, or \u003Ccode\u003Evisa_checkout\u003C/code\u003E. An additional hash is included on the Wallet subhash with a name matching this value. It contains additional information specific to the card wallet type."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"type"},"visa_checkout":{"name":"visa_checkout","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `visa_checkout` card wallet, this hash contains details about the wallet.","html":"If this is a \u003Ccode\u003Evisa_checkout\u003C/code\u003E card wallet, this hash contains details about the wallet."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"billing_address":{"name":"billing_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified billing address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"billing_address"},"email":{"name":"email","check":"string","validation":"string","documentation":{"markdown":"Owner's verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified email. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"email"},"name":{"name":"name","check":"string","validation":"string","documentation":{"markdown":"Owner's verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified full name. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"name"},"shipping_address":{"name":"shipping_address","check":"hash","validation":"hash","documentation":{"markdown":"Owner's verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated.","html":"Owner’s verified shipping address. Values are verified or provided by the wallet directly (if supported) at the time of authorization or settlement. They cannot be set or mutated."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"city":{"name":"city","check":"string","validation":"string","documentation":{"markdown":"City/District/Suburb/Town/Village.","html":"City/District/Suburb/Town/Village."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"city"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"2-letter country code.","html":"2-letter country code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"line1":{"name":"line1","check":"string","validation":"string","documentation":{"markdown":"Address line 1 (Street address/PO Box/Company name).","html":"Address line 1 (Street address/PO Box/Company name)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line1"},"line2":{"name":"line2","check":"string","validation":"string","documentation":{"markdown":"Address line 2 (Apartment/Suite/Unit/Building).","html":"Address line 2 (Apartment/Suite/Unit/Building)."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"line2"},"postal_code":{"name":"postal_code","check":"string","validation":"string","documentation":{"markdown":"ZIP or postal code.","html":"ZIP or postal code."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"postal_code"},"state":{"name":"state","check":"string","validation":"string","documentation":{"markdown":"State/County/Province/Region.","html":"State/County/Province/Region."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"state"}},"object_type":"shipping_address"}},"object_type":"visa_checkout"}},"object_type":"wallet"}},"object_type":"card"},"card_present":{"name":"card_present","check":"hash","validation":"hash","documentation":{"markdown":"If this is an `card_present` PaymentMethod, this hash contains details about the Card Present payment method.","html":"If this is an \u003Ccode\u003Ecard_present\u003C/code\u003E PaymentMethod, this hash contains details about the Card Present payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{},"object_type":"card_present"},"created":{"name":"created","check":"timestamp","validation":"timestamp","documentation":{"markdown":"Time at which the object was created. Measured in seconds since the Unix epoch.","html":"Time at which the object was created. Measured in seconds since the Unix epoch."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"created"},"customer":{"name":"customer","check":"string","validation":"string","documentation":{"markdown":"The ID of the Customer to which this PaymentMethod is saved. This will not be set when the PaymentMethod has not been saved to a Customer.","html":"The ID of the Customer to which this PaymentMethod is saved. This will not be set when the PaymentMethod has not been saved to a Customer."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"user_expandable":["customer"],"object_type":"customer"},"ideal":{"name":"ideal","check":"hash","validation":"hash","documentation":{"markdown":"If this is an `ideal` PaymentMethod, this hash contains details about the iDEAL payment method.","html":"If this is an \u003Ccode\u003Eideal\u003C/code\u003E PaymentMethod, this hash contains details about the iDEAL payment method."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank":{"name":"bank","check":"string","validation":"string","documentation":{"markdown":"The customer's bank, if provided. Can be one of `abn_amro`, `asn_bank`, `bunq`, `handelsbanken`, `ing`, `knab`, `moneyou`, `rabobank`, `regiobank`, `sns_bank`, `triodos_bank`, or `van_lanschot`.","html":"The customer’s bank, if provided. Can be one of \u003Ccode\u003Eabn_amro\u003C/code\u003E, \u003Ccode\u003Easn_bank\u003C/code\u003E, \u003Ccode\u003Ebunq\u003C/code\u003E, \u003Ccode\u003Ehandelsbanken\u003C/code\u003E, \u003Ccode\u003Eing\u003C/code\u003E, \u003Ccode\u003Eknab\u003C/code\u003E, \u003Ccode\u003Emoneyou\u003C/code\u003E, \u003Ccode\u003Erabobank\u003C/code\u003E, \u003Ccode\u003Eregiobank\u003C/code\u003E, \u003Ccode\u003Esns_bank\u003C/code\u003E, \u003Ccode\u003Etriodos_bank\u003C/code\u003E, or \u003Ccode\u003Evan_lanschot\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank"},"bic":{"name":"bic","check":"string","validation":"string","documentation":{"markdown":"The Bank Identifier Code of the customer's bank, if the bank was provided.","html":"The Bank Identifier Code of the customer’s bank, if the bank was provided."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bic"}},"object_type":"ideal"},"livemode":{"name":"livemode","check":"boolean","validation":"boolean","documentation":{"markdown":"Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.","html":"Has the value \u003Ccode\u003Etrue\u003C/code\u003E if the object exists in live mode or the value \u003Ccode\u003Efalse\u003C/code\u003E if the object exists in test mode."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"livemode"},"metadata":{"name":"metadata","check":"hash","validation":"hash","documentation":{"markdown":"Set of key-value pairs that you can attach to an object. This can be useful for storing additional information about the object in a structured format.","html":"Set of key-value pairs that you can attach to an object. This can be useful for storing additional information about the object in a structured format."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"metadata"},"sepa_debit":{"name":"sepa_debit","check":"hash","validation":"hash","documentation":{"markdown":"If this is a `sepa_debit` PaymentMethod, this hash contains details about the SEPA debit bank account.","html":"If this is a \u003Ccode\u003Esepa_debit\u003C/code\u003E PaymentMethod, this hash contains details about the SEPA debit bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"bank_code":{"name":"bank_code","check":"string","validation":"string","documentation":{"markdown":"Bank code of bank associated with the bank account.","html":"Bank code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"bank_code"},"branch_code":{"name":"branch_code","check":"string","validation":"string","documentation":{"markdown":"Branch code of bank associated with the bank account.","html":"Branch code of bank associated with the bank account."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"branch_code"},"country":{"name":"country","check":"string","validation":"string","documentation":{"markdown":"Two-letter ISO code representing the country the bank account is located in.","html":"Two-letter ISO code representing the country the bank account is located in."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"country"},"fingerprint":{"name":"fingerprint","check":"string","validation":"string","documentation":{"markdown":"Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same.","html":"Uniquely identifies this particular bank account. You can use this attribute to check whether two bank accounts are the same."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"fingerprint"},"last4":{"name":"last4","check":"string","validation":"string","documentation":{"markdown":"Last four characters of the IBAN.","html":"Last four characters of the IBAN."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"last4"}},"object_type":"sepa_debit"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"The type of the PaymentMethod. An additional hash is included on the PaymentMethod with a name matching this value. It contains additional information specific to the PaymentMethod type.","html":"The type of the PaymentMethod. An additional hash is included on the PaymentMethod with a name matching this value. It contains additional information specific to the PaymentMethod type."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"enum_values":{"card":{"documentation":null},"ideal":{"documentation":null},"sepa_debit":{"documentation":null}},"object_type":"type"}},"object_type":"payment_method"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"The type of error returned. One of `api_connection_error`, `api_error`, `authentication_error`, `card_error`, `idempotency_error`, `invalid_request_error`, or `rate_limit_error`","html":"The type of error returned. One of \u003Ccode\u003Eapi_connection_error\u003C/code\u003E, \u003Ccode\u003Eapi_error\u003C/code\u003E, \u003Ccode\u003Eauthentication_error\u003C/code\u003E, \u003Ccode\u003Ecard_error\u003C/code\u003E, \u003Ccode\u003Eidempotency_error\u003C/code\u003E, \u003Ccode\u003Einvalid_request_error\u003C/code\u003E, or \u003Ccode\u003Erate_limit_error\u003C/code\u003E"},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"type"}},"object_type":"last_setup_error"},"livemode":{"name":"livemode","check":"boolean","validation":"boolean","documentation":{"markdown":"Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.","html":"Has the value \u003Ccode\u003Etrue\u003C/code\u003E if the object exists in live mode or the value \u003Ccode\u003Efalse\u003C/code\u003E if the object exists in test mode."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"livemode"},"mandate":{"name":"mandate","check":"string","validation":"string","documentation":{"markdown":"ID of the multi use Mandate generated by the SetupIntent.","html":"ID of the multi use Mandate generated by the SetupIntent."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"user_expandable":["mandate"],"object_type":"mandate"},"metadata":{"name":"metadata","check":"hash","validation":"hash","documentation":{"markdown":"Set of key-value pairs that you can attach to an object. This can be useful for storing additional information about the object in a structured format.","html":"Set of key-value pairs that you can attach to an object. This can be useful for storing additional information about the object in a structured format."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"metadata"},"next_action":{"name":"next_action","check":"hash","validation":"hash","documentation":{"markdown":"If present, this property tells you what actions you need to take in order for your customer to continue payment setup.","html":"If present, this property tells you what actions you need to take in order for your customer to continue payment setup."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"redirect_to_url":{"name":"redirect_to_url","check":"hash","validation":"hash","documentation":{"markdown":"Contains instructions for authenticating by redirecting your customer to another page or application.","html":"Contains instructions for authenticating by redirecting your customer to another page or application."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"return_url":{"name":"return_url","check":"string","validation":"string","documentation":{"markdown":"If the customer does not exit their browser while authenticating, they will be redirected to this specified URL after completion.","html":"If the customer does not exit their browser while authenticating, they will be redirected to this specified URL after completion."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"return_url"},"url":{"name":"url","check":"string","validation":"string","documentation":{"markdown":"The URL you must redirect your customer to in order to authenticate.","html":"The URL you must redirect your customer to in order to authenticate."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"url"}},"object_type":"redirect_to_url"},"type":{"name":"type","check":"string","validation":"string","documentation":{"markdown":"Type of the next action to perform, one of `redirect_to_url` or `use_stripe_sdk`.","html":"Type of the next action to perform, one of \u003Ccode\u003Eredirect_to_url\u003C/code\u003E or \u003Ccode\u003Euse_stripe_sdk\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"type"},"use_stripe_sdk":{"name":"use_stripe_sdk","check":"hash","validation":"hash","documentation":{"markdown":"When confirming a SetupIntent with Stripe.js, Stripe.js depends on the contents of this \u003Ctranslate\u003Edictionary\u003C/translate\u003E to invoke authentication flows. The shape of the contents is subject to change and is only intended to be used by Stripe.js.","html":"When confirming a SetupIntent with Stripe.js, Stripe.js depends on the contents of this \u003Ctranslate\u003Edictionary\u003C/translate\u003E to invoke authentication flows. The shape of the contents is subject to change and is only intended to be used by Stripe.js."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"use_stripe_sdk"}},"object_type":"next_action"},"on_behalf_of":{"name":"on_behalf_of","check":"string","validation":"string","documentation":{"markdown":"The account (if any) for which the setup is intended.","html":"The account (if any) for which the setup is intended."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"user_expandable":["account"],"object_type":"on_behalf_of"},"payment_method":{"name":"payment_method","check":"string","validation":"string","documentation":{"markdown":"ID of the payment method used with this SetupIntent.","html":"ID of the payment method used with this SetupIntent."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"user_expandable":["payment_method"],"object_type":"payment_method"},"payment_method_options":{"name":"payment_method_options","check":"hash","validation":"hash","documentation":{"markdown":"Payment-method-specific configuration for this SetupIntent.","html":"Payment-method-specific configuration for this SetupIntent."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"card":{"name":"card","check":"hash","validation":"hash","documentation":{"markdown":"If the SetupIntent's payment_method_types includes `card`, this hash contains the configurations that will be applied to each setup attempt of that type.\n","html":"If the SetupIntent’s payment_method_types includes \u003Ccode\u003Ecard\u003C/code\u003E, this hash contains the configurations that will be applied to each setup attempt of that type."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"subspec":{"request_three_d_secure":{"name":"request_three_d_secure","check":"string","validation":"string","documentation":{"markdown":"We strongly recommend that you rely on our SCA Engine to automatically prompt your customers for authentication based on risk level and [other requirements](/docs/strong-customer-authentication). However, if you wish to request 3D Secure based on logic from your own fraud engine, provide this option. Permitted values include: `automatic` or `any`. If not provided, defaults to `automatic`. Read our guide on [manually requesting 3D Secure](/docs/payments/3d-secure#manual-three-ds) for more information on how this configuration interacts with Radar and our SCA Engine.","html":"We strongly recommend that you rely on our SCA Engine to automatically prompt your customers for authentication based on risk level and \u003Ca href=\"/docs/strong-customer-authentication\"\u003Eother requirements\u003C/a\u003E. However, if you wish to request 3D Secure based on logic from your own fraud engine, provide this option. Permitted values include: \u003Ccode\u003Eautomatic\u003C/code\u003E or \u003Ccode\u003Eany\u003C/code\u003E. If not provided, defaults to \u003Ccode\u003Eautomatic\u003C/code\u003E. Read our guide on \u003Ca href=\"/docs/payments/3d-secure#manual-three-ds\"\u003Emanually requesting 3D Secure\u003C/a\u003E for more information on how this configuration interacts with Radar and our SCA Engine."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":"advanced","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"request_three_d_secure"}},"object_type":"card"}},"object_type":"payment_method_options"},"payment_method_types":{"name":"payment_method_types","check":"string_array","validation":"array containing strings","documentation":{"markdown":"The list of payment method types (e.g. card) that this SetupIntent is allowed to set up.","html":"The list of payment method types (e.g. card) that this SetupIntent is allowed to set up."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"payment_method_types"},"single_use_mandate":{"name":"single_use_mandate","check":"string","validation":"string","documentation":{"markdown":"ID of the single_use Mandate generated by the SetupIntent.","html":"ID of the single_use Mandate generated by the SetupIntent."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"user_expandable":["mandate"],"object_type":"single_use_mandate"},"status":{"name":"status","check":"string","validation":"string","documentation":{"markdown":"[Status](/docs/payments/intents#intent-statuses) of this SetupIntent, one of `requires_payment_method`, `requires_confirmation`, `requires_action`, `processing`, `canceled`, or `succeeded`. ","html":"\u003Ca href=\"/docs/payments/intents#intent-statuses\"\u003EStatus\u003C/a\u003E of this SetupIntent, one of \u003Ccode\u003Erequires_payment_method\u003C/code\u003E, \u003Ccode\u003Erequires_confirmation\u003C/code\u003E, \u003Ccode\u003Erequires_action\u003C/code\u003E, \u003Ccode\u003Eprocessing\u003C/code\u003E, \u003Ccode\u003Ecanceled\u003C/code\u003E, or \u003Ccode\u003Esucceeded\u003C/code\u003E. "},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"status"},"usage":{"name":"usage","check":"string","validation":"string","documentation":{"markdown":"Indicates how the payment method is intended to be used in the future.\n\nUse `on_session` if you intend to only reuse the payment method when the customer is in your checkout flow. Use `off_session` if your customer may or may not be in your checkout flow. If not provided, this value defaults to `off_session`.\n","html":"Indicates how the payment method is intended to be used in the future.\u003C/p\u003E\n\n\u003Cp\u003EUse \u003Ccode\u003Eon_session\u003C/code\u003E if you intend to only reuse the payment method when the customer is in your checkout flow. Use \u003Ccode\u003Eoff_session\u003C/code\u003E if your customer may or may not be in your checkout flow. If not provided, this value defaults to \u003Ccode\u003Eoff_session\u003C/code\u003E."},"gate":false,"hide_unset_desc":null,"required":true,"default":null,"badge_text":"retrievable with publishable key","requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"usage"}}},"source":{"name":"source","check":"hash","validation":"hash","documentation":{"markdown":"The source object for errors returned on a request involving a source.","html":"The source object for errors returned on a request involving a source."},"gate":false,"hide_unset_desc":null,"required":false,"default":null,"badge_text":null,"requirement_text":null,"permission":null,"hide_nil":null,"is_country_specific":false,"object_type":"source"}},"status_codes":{"200 - OK":"Everything worked as expected.","400 - Bad Request":"The request was unacceptable, often due to missing a required\n                  parameter.","401 - Unauthorized":"No valid API key provided.","402 - Request Failed":"The parameters were valid but the request failed.","403 - Forbidden":"The API key doesn't have permissions to perform the request.","404 - Not Found":"The requested resource doesn't exist.","409 - Conflict":"The request conflicts with another request (perhaps due to\n                  using the same idempotent key).","429 - Too Many Requests":"Too many requests hit the API too quickly. We recommend an\n                  exponential backoff of your requests.","500, 502, 503, 504 - Server Errors":"Something went wrong on Stripe's end. (These are rare.)"},"error_types":{"api_connection_error":"Failure to connect to Stripe's API.","api_error":"API errors cover any other type of problem (e.g., a temporary\n                  problem with Stripe's servers), and are extremely\n                  uncommon.","authentication_error":"Failure to properly authenticate yourself in the request.","card_error":"Card errors are the most common type of error you should\n                  expect to handle. They result when the user enters a card that\n                  can't be charged for some reason.","idempotency_error":"Idempotency errors occur when an `Idempotency-Key`\n                  is re-used on a request that does not match the first request's\n                  API endpoint and parameters.","invalid_request_error":"Invalid request errors arise when your request has invalid\n                  parameters.","rate_limit_error":"Too many requests hit the API too quickly.","validation_error":"Errors triggered by our client-side libraries when failing to\n                  validate fields (e.g., when a card number or expiration date\n                  is invalid or incomplete)."},"section_type":"override","section_tag":"errors","version":null}},"error_handling":{"title":"Handling errors","group_title":"Topics","group_anchor":"topics","anchor":"error_handling","section_anchor":"errors","subsection_anchors":null,"path":"/errors/handling","gate":false,"display_on_load":true,"data":{"catching_errors":"# Select a client library to see examples of handling different kinds of errors.","section_type":"override","section_tag":"error_handling","version":null}},"expanding_objects":{"title":"Expanding Objects","group_title":"Topics","group_anchor":"topics","anchor":"expanding_objects","section_anchor":"expanding_objects","subsection_anchors":[],"path":"/expanding_objects","gate":false,"display_on_load":true,"data":{"request":"curl https://api.stripe.com/v1/charges/ch_1FsteO2eZvKYlo2C7nk2PpJn \\\n  -u sk_test_4eC39HqLyjWDarjtT1zdp7dc: \\\n  -d \"expand[]\"=customer \\\n  -d \"expand[]\"=\"invoice.subscription\" \\\n  -G \n","response":"{\n  \"id\": \"ch_1FsteO2eZvKYlo2C7nk2PpJn\",\n  \"object\": \"charge\",\n  \"customer\": {\n    \"id\": \"cu_1FstSv2eZvKYlo2CFmhXKWWb\",\n    \"object\": \"customer\",\n    ...\n  },\n  \"invoice\": {\n    \"id\": \"in_19yTU92eZvKYlo2C7uDjvu6v\",\n    \"object\": \"invoice\",\n    \"subscription\": {\n      \"id\": \"su_19Nhzs2eZvKYlo2CSegBNIzh\",\n      \"object\": \"subscription\",\n      ...\n    },\n    ...\n  },\n  ...\n}\n","section_type":"override","section_tag":"expanding_objects","version":null}},"idempotent_requests":{"title":"Idempotent Requests","group_title":"Topics","group_anchor":"topics","anchor":"idempotent_requests","section_anchor":"idempotent_requests","subsection_anchors":[],"path":"/idempotent_requests","gate":false,"display_on_load":true,"data":{"request":"curl https://api.stripe.com/v1/charges \\\n  -u sk_test_4eC39HqLyjWDarjtT1zdp7dc: \\\n  -H \"Idempotency-Key: iBR1380BBGlrjCBW\" \\\n  -d amount=2000 \\\n  -d currency=usd \\\n  -d description=\"Charge for jenny.rosen@example.com\" \\\n  -d source=tok_mastercard\n","section_type":"override","section_tag":"idempotent_requests","version":null}},"metadata":{"title":"Metadata","group_title":"Topics","group_anchor":"topics","anchor":"metadata","section_anchor":"metadata","subsection_anchors":[],"path":"/metadata","gate":false,"display_on_load":true,"data":{"max_metadata_hash_length":50,"max_metadata_key_length":40,"max_metadata_val_length":500,"request":"curl https://api.stripe.com/v1/charges \\\n  -u sk_test_4eC39HqLyjWDarjtT1zdp7dc: \\\n  -d amount=2000 \\\n  -d currency=usd \\\n  -d source=tok_visa \\\n  -d \"metadata[order_id]\"=6735\n","response":"{\n  \"id\": \"ch_1FsteO2eZvKYlo2C7nk2PpJn\",\n  \"object\": \"charge\",\n  \"amount\": 100,\n  \"amount_refunded\": 0,\n  \"application\": null,\n  \"application_fee\": null,\n  \"application_fee_amount\": null,\n  \"balance_transaction\": \"txn_19XJJ02eZvKYlo2ClwuJ1rbA\",\n  \"billing_details\": {\n    \"address\": {\n      \"city\": null,\n      \"country\": null,\n      \"line1\": null,\n      \"line2\": null,\n      \"postal_code\": null,\n      \"state\": null\n    },\n    \"email\": null,\n    \"name\": null,\n    \"phone\": null\n  },\n  \"captured\": false,\n  \"created\": 1577118056,\n  \"currency\": \"usd\",\n  \"customer\": null,\n  \"description\": \"My First Test Charge (created for API docs)\",\n  \"dispute\": null,\n  \"disputed\": false,\n  \"failure_code\": null,\n  \"failure_message\": null,\n  \"fraud_details\": {\n  },\n  \"invoice\": null,\n  \"livemode\": false,\n  \"metadata\": {\n    \"order_id\": \"6735\"\n  },\n  \"on_behalf_of\": null,\n  \"order\": null,\n  \"outcome\": null,\n  \"paid\": true,\n  \"payment_intent\": null,\n  \"payment_method\": \"card_1FsteM2eZvKYlo2CFPgig4W6\",\n  \"payment_method_details\": {\n    \"card\": {\n      \"brand\": \"visa\",\n      \"checks\": {\n        \"address_line1_check\": null,\n        \"address_postal_code_check\": null,\n        \"cvc_check\": null\n      },\n      \"country\": \"US\",\n      \"exp_month\": 8,\n      \"exp_year\": 2020,\n      \"fingerprint\": \"Xt5EWLLDS7FJjR1c\",\n      \"funding\": \"credit\",\n      \"installments\": null,\n      \"last4\": \"4242\",\n      \"network\": \"visa\",\n      \"three_d_secure\": null,\n      \"wallet\": null\n    },\n    \"type\": \"card\"\n  },\n  \"receipt_email\": null,\n  \"receipt_number\": null,\n  \"receipt_url\": \"https://pay.stripe.com/receipts/acct_1032D82eZvKYlo2C/ch_1FsteO2eZvKYlo2C7nk2PpJn/rcpt_GPj6rriD2lPmuLQa4pzUkzvacQZdGuY\",\n  \"refunded\": false,\n  \"refunds\": {\n    \"object\": \"list\",\n    \"data\": [\n\n    ],\n    \"has_more\": false,\n    \"url\": \"/v1/charges/ch_1FsteO2eZvKYlo2C7nk2PpJn/refunds\"\n  },\n  \"review\": null,\n  \"shipping\": null,\n  \"source_transfer\": null,\n  \"statement_descriptor\": null,\n  \"statement_descriptor_suffix\": null,\n  \"status\": \"succeeded\",\n  \"transfer_data\": null,\n  \"transfer_group\": null\n}","section_type":"override","section_tag":"metadata","version":null}},"pagination":{"title":"Pagination","group_title":"Topics","group_anchor":"topics","anchor":"pagination","section_anchor":"pagination","subsection_anchors":["auto_pagination"],"path":"/pagination","gate":false,"display_on_load":true,"data":{"example_auto_pagination":"# The auto-pagination feature is specific to Stripe's\n  # libraries and cannot be used directly with curl.\n","request_data":{"test_key":"sk_test_4eC39HqLyjWDarjtT1zdp7dc","action_type":"list","action_name":null,"resource_name":"customer","parent_resource_name":null,"namespace":null,"request_params":{"limit":3},"url_params":{},"overridden_languages":[],"preamble_comment":null},"response":"{\n  \"object\": \"list\",\n  \"url\": \"/v1/customers\",\n  \"has_more\": false,\n  \"data\": [\n    {\n      \"id\": \"cus_GPiulxaesYviV3\",\n      \"object\": \"customer\",\n      \"address\": null,\n      \"balance\": 0,\n      \"created\": 1577117345,\n      \"currency\": \"usd\",\n      \"default_source\": null,\n      \"delinquent\": false,\n      \"description\": null,\n      \"discount\": null,\n      \"email\": null,\n      \"invoice_prefix\": \"B59E0B9\",\n      \"invoice_settings\": {\n        \"custom_fields\": null,\n        \"default_payment_method\": null,\n        \"footer\": null\n      },\n      \"livemode\": false,\n      \"metadata\": {\n      },\n      \"name\": null,\n      \"phone\": null,\n      \"preferred_locales\": [\n    \n      ],\n      \"shipping\": null,\n      \"sources\": {\n        \"object\": \"list\",\n        \"data\": [\n    \n        ],\n        \"has_more\": false,\n        \"url\": \"/v1/customers/cus_GPiulxaesYviV3/sources\"\n      },\n      \"subscriptions\": {\n        \"object\": \"list\",\n        \"data\": [\n    \n        ],\n        \"has_more\": false,\n        \"url\": \"/v1/customers/cus_GPiulxaesYviV3/subscriptions\"\n      },\n      \"tax_exempt\": \"none\",\n      \"tax_ids\": {\n        \"object\": \"list\",\n        \"data\": [\n    \n        ],\n        \"has_more\": false,\n        \"url\": \"/v1/customers/cus_GPiulxaesYviV3/tax_ids\"\n      }\n    },\n    {...},\n    {...}\n  ]\n}\n","section_type":"override","section_tag":"pagination","version":null}},"auto_pagination":{"title":"Auto-pagination","group_title":"Topics","group_anchor":"topics","anchor":"auto_pagination","section_anchor":"pagination","subsection_anchors":null,"path":"/pagination/auto","gate":false,"display_on_load":true,"data":{"request":"# The auto-pagination feature is specific to Stripe's\n  # libraries and cannot be used directly with curl.\n","section_type":"override","section_tag":"auto_pagination","version":null}},"request_ids":{"title":"Request IDs","group_title":"Topics","group_anchor":"topics","anchor":"request_ids","section_anchor":"request_ids","subsection_anchors":[],"path":"/request_ids","gate":false,"display_on_load":true,"data":{"request":"curl https://api.stripe.com/v1/customers \\\n  -u sk_test_4eC39HqLyjWDarjtT1zdp7dc: \\\n  -D \"-\" \\\n  -X POST\n","section_type":"override","section_tag":"request_ids","version":null}},"versioning":{"title":"Versioning","group_title":"Topics","group_anchor":"topics","anchor":"versioning","section_anchor":"versioning","subsection_anchors":[],"path":"/versioning","gate":false,"display_on_load":true,"data":{"current_version":"2019-12-03","merchant":false,"request":"curl https://api.stripe.com/v1/charges \\\n  -u sk_test_4eC39HqLyjWDarjtT1zdp7dc: \\\n  -H \"Stripe-Version: 2019-12-03\"\n","section_type":"override","section_tag":"versioning","version":null}},"balance":{"title":"Balance","group_title":"Core Resources","group_anchor":"core_resources","anchor":"balance","section_anchor":"balance","subsection_anchors":["balance_object","retrieve_balance"],"path":"/balance","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Balance","description":"This is an object representing your Stripe balance. You can retrieve it to see\nthe balance currently on your Stripe account.\n\nYou can also retrieve the balance history, which contains a list of\n[transactions](/docs/reporting/balance-transaction-types) that contributed to the balance\n(charges, payouts, and so forth).\n\nThe available and pending amounts for each currency are broken down further by\npayment source types.\n\nRelated guide: [Understanding Connect Account Balances](/docs/connect/account-balances).\n","section_tag":"balance","subsection_summaries":[{"anchor":"balance_object","curl_definition":null},{"anchor":"retrieve_balance","curl_definition":"GET /v1/balance"}]}},"balance_object":{"title":"The balance object","group_title":"Core Resources","group_anchor":"core_resources","anchor":"balance_object","section_anchor":"balance","subsection_anchors":null,"path":"/balance/balance_object","gate":false,"display_on_load":false},"retrieve_balance":{"title":"Retrieve balance","group_title":"Core Resources","group_anchor":"core_resources","anchor":"retrieve_balance","section_anchor":"balance","subsection_anchors":null,"path":"/balance/balance_retrieve","gate":false,"display_on_load":false},"balance_transactions":{"title":"Balance Transactions","group_title":"Core Resources","group_anchor":"core_resources","anchor":"balance_transactions","section_anchor":"balance_transactions","subsection_anchors":["balance_transaction_object","balance_transaction_retrieve","balance_transaction_list"],"path":"/balance_transactions","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Balance Transactions","description":"Balance transactions represent funds moving through your Stripe account.\nThey're created for every type of transaction that comes into or flows out of your Stripe account balance.\n\nRelated guide: [Balance Transaction Types](/docs/reports/balance-transaction-types).\n","section_tag":"balance_transactions","subsection_summaries":[{"anchor":"balance_transaction_object","curl_definition":null},{"anchor":"balance_transaction_retrieve","curl_definition":"GET /v1/balance_transactions/:id"},{"anchor":"balance_transaction_list","curl_definition":"GET /v1/balance_transactions"}]}},"balance_transaction_object":{"title":"The balance transaction object","group_title":"Core Resources","group_anchor":"core_resources","anchor":"balance_transaction_object","section_anchor":"balance_transactions","subsection_anchors":null,"path":"/balance_transactions/object","gate":false,"display_on_load":false},"balance_transaction_retrieve":{"title":"Retrieve a balance transaction","group_title":"Core Resources","group_anchor":"core_resources","anchor":"balance_transaction_retrieve","section_anchor":"balance_transactions","subsection_anchors":null,"path":"/balance_transactions/retrieve","gate":false,"display_on_load":false},"balance_transaction_list":{"title":"List all balance transactions","group_title":"Core Resources","group_anchor":"core_resources","anchor":"balance_transaction_list","section_anchor":"balance_transactions","subsection_anchors":null,"path":"/balance_transactions/list","gate":false,"display_on_load":false},"charges":{"title":"Charges","group_title":"Core Resources","group_anchor":"core_resources","anchor":"charges","section_anchor":"charges","subsection_anchors":["charge_object","create_charge","retrieve_charge","update_charge","capture_charge","list_charges"],"path":"/charges","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Charges","description":"To charge a credit or a debit card, you create a `Charge` object. You can\nretrieve and refund individual charges as well as list all charges. Charges\nare identified by a unique, random ID.\n\nRelated guide: [Accept a payment with the Charges API](/docs/payments/accept-a-payment-charges).\n","section_tag":"charges","subsection_summaries":[{"anchor":"charge_object","curl_definition":null},{"anchor":"create_charge","curl_definition":"POST /v1/charges"},{"anchor":"retrieve_charge","curl_definition":"GET /v1/charges/:id"},{"anchor":"update_charge","curl_definition":"POST /v1/charges/:id"},{"anchor":"capture_charge","curl_definition":"POST /v1/charges/:id/capture"},{"anchor":"list_charges","curl_definition":"GET /v1/charges"}]}},"charge_object":{"title":"The charge object","group_title":"Core Resources","group_anchor":"core_resources","anchor":"charge_object","section_anchor":"charges","subsection_anchors":null,"path":"/charges/object","gate":false,"display_on_load":false},"create_charge":{"title":"Create a charge","group_title":"Core Resources","group_anchor":"core_resources","anchor":"create_charge","section_anchor":"charges","subsection_anchors":null,"path":"/charges/create","gate":false,"display_on_load":false},"retrieve_charge":{"title":"Retrieve a charge","group_title":"Core Resources","group_anchor":"core_resources","anchor":"retrieve_charge","section_anchor":"charges","subsection_anchors":null,"path":"/charges/retrieve","gate":false,"display_on_load":false},"update_charge":{"title":"Update a charge","group_title":"Core Resources","group_anchor":"core_resources","anchor":"update_charge","section_anchor":"charges","subsection_anchors":null,"path":"/charges/update","gate":false,"display_on_load":false},"capture_charge":{"title":"Capture a charge","group_title":"Core Resources","group_anchor":"core_resources","anchor":"capture_charge","section_anchor":"charges","subsection_anchors":null,"path":"/charges/capture","gate":false,"display_on_load":false},"list_charges":{"title":"List all charges","group_title":"Core Resources","group_anchor":"core_resources","anchor":"list_charges","section_anchor":"charges","subsection_anchors":null,"path":"/charges/list","gate":false,"display_on_load":false},"customers":{"title":"Customers","group_title":"Core Resources","group_anchor":"core_resources","anchor":"customers","section_anchor":"customers","subsection_anchors":["customer_object","create_customer","retrieve_customer","update_customer","delete_customer","list_customers"],"path":"/customers","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Customers","description":"`Customer` objects allow you to perform recurring charges, and to track\nmultiple charges, that are associated with the same customer. The API allows\nyou to create, delete, and update your customers. You can retrieve individual\ncustomers as well as a list of all your customers.\n\nRelated guide: [Saving Cards with Customers](/docs/saving-cards).\n","section_tag":"customers","subsection_summaries":[{"anchor":"customer_object","curl_definition":null},{"anchor":"create_customer","curl_definition":"POST /v1/customers"},{"anchor":"retrieve_customer","curl_definition":"GET /v1/customers/:id"},{"anchor":"update_customer","curl_definition":"POST /v1/customers/:id"},{"anchor":"delete_customer","curl_definition":"DELETE /v1/customers/:id"},{"anchor":"list_customers","curl_definition":"GET /v1/customers"}]}},"customer_object":{"title":"The customer object","group_title":"Core Resources","group_anchor":"core_resources","anchor":"customer_object","section_anchor":"customers","subsection_anchors":null,"path":"/customers/object","gate":false,"display_on_load":false},"create_customer":{"title":"Create a customer","group_title":"Core Resources","group_anchor":"core_resources","anchor":"create_customer","section_anchor":"customers","subsection_anchors":null,"path":"/customers/create","gate":false,"display_on_load":false},"retrieve_customer":{"title":"Retrieve a customer","group_title":"Core Resources","group_anchor":"core_resources","anchor":"retrieve_customer","section_anchor":"customers","subsection_anchors":null,"path":"/customers/retrieve","gate":false,"display_on_load":false},"update_customer":{"title":"Update a customer","group_title":"Core Resources","group_anchor":"core_resources","anchor":"update_customer","section_anchor":"customers","subsection_anchors":null,"path":"/customers/update","gate":false,"display_on_load":false},"delete_customer":{"title":"Delete a customer","group_title":"Core Resources","group_anchor":"core_resources","anchor":"delete_customer","section_anchor":"customers","subsection_anchors":null,"path":"/customers/delete","gate":false,"display_on_load":false},"list_customers":{"title":"List all customers","group_title":"Core Resources","group_anchor":"core_resources","anchor":"list_customers","section_anchor":"customers","subsection_anchors":null,"path":"/customers/list","gate":false,"display_on_load":false},"disputes":{"title":"Disputes","group_title":"Core Resources","group_anchor":"core_resources","anchor":"disputes","section_anchor":"disputes","subsection_anchors":["dispute_object","dispute_evidence_object","retrieve_dispute","update_dispute","close_dispute","list_disputes"],"path":"/disputes","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Disputes","description":"A dispute occurs when a customer questions your charge with their card issuer.\nWhen this happens, you're given the opportunity to respond to the dispute with\nevidence that shows that the charge is legitimate. You can find more\ninformation about the dispute process in our [Disputes and\nFraud](/docs/disputes) documentation.\n\nRelated guide: [Disputes and Fraud](/docs/disputes).\n","section_tag":"disputes","subsection_summaries":[{"anchor":"dispute_object","curl_definition":null},{"anchor":"dispute_evidence_object","curl_definition":null},{"anchor":"retrieve_dispute","curl_definition":"GET /v1/disputes/:id"},{"anchor":"update_dispute","curl_definition":"POST /v1/disputes/:id"},{"anchor":"close_dispute","curl_definition":"POST /v1/disputes/:id/close"},{"anchor":"list_disputes","curl_definition":"GET /v1/disputes"}]}},"dispute_object":{"title":"The dispute object","group_title":"Core Resources","group_anchor":"core_resources","anchor":"dispute_object","section_anchor":"disputes","subsection_anchors":null,"path":"/disputes/object","gate":false,"display_on_load":false},"dispute_evidence_object":{"title":"The dispute evidence object","group_title":"Core Resources","group_anchor":"core_resources","anchor":"dispute_evidence_object","section_anchor":"disputes","subsection_anchors":null,"path":"/disputes/evidence_object","gate":false,"display_on_load":false},"retrieve_dispute":{"title":"Retrieve a dispute","group_title":"Core Resources","group_anchor":"core_resources","anchor":"retrieve_dispute","section_anchor":"disputes","subsection_anchors":null,"path":"/disputes/retrieve","gate":false,"display_on_load":false},"update_dispute":{"title":"Update a dispute","group_title":"Core Resources","group_anchor":"core_resources","anchor":"update_dispute","section_anchor":"disputes","subsection_anchors":null,"path":"/disputes/update","gate":false,"display_on_load":false},"close_dispute":{"title":"Close a dispute","group_title":"Core Resources","group_anchor":"core_resources","anchor":"close_dispute","section_anchor":"disputes","subsection_anchors":null,"path":"/disputes/close","gate":false,"display_on_load":false},"list_disputes":{"title":"List all disputes","group_title":"Core Resources","group_anchor":"core_resources","anchor":"list_disputes","section_anchor":"disputes","subsection_anchors":null,"path":"/disputes/list","gate":false,"display_on_load":false},"events":{"title":"Events","group_title":"Core Resources","group_anchor":"core_resources","anchor":"events","section_anchor":"events","subsection_anchors":["event_object","retrieve_event","list_events","event_types"],"path":"/events","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Events","description":"Events are our way of letting you know when something interesting happens in\nyour account. When an interesting event occurs, we create a new `Event`\nobject. For example, when a charge succeeds, we create a `charge.succeeded`\nevent; and when an invoice payment attempt fails, we create an\n`invoice.payment_failed` event. Note that many API requests may cause multiple\nevents to be created. For example, if you create a new subscription for a\ncustomer, you will receive both a `customer.subscription.created` event and a\n`charge.succeeded` event.\n\nEvents occur when the state of another API resource changes. The state of that\nresource at the time of the change is embedded in the event's data field. For\nexample, a `charge.succeeded` event will contain a charge, and an\n`invoice.payment_failed` event will contain an invoice.\n\nAs with other API resources, you can use endpoints to retrieve an\n[individual event](#retrieve_event) or a [list of events](#list_events)\nfrom the API. We also have a separate\n[webhooks](http://en.wikipedia.org/wiki/Webhook) system for sending the\n`Event` objects directly to an endpoint on your server. Webhooks are managed\nin your\n[account settings](https://dashboard.stripe.com/account/webhooks),\nand our [Using Webhooks](/docs/webhooks) guide will help you get set up.\n\nWhen using [Connect](/docs/connect), you can also receive notifications of\nevents that occur in connected accounts. For these events, there will be an\nadditional `account` attribute in the received `Event` object.\n\n**NOTE:** Right now, access to events through the [Retrieve Event API](#retrieve_event) is\nguaranteed only for 30 days.\n","section_tag":"events","subsection_summaries":[{"anchor":"event_object","curl_definition":null},{"anchor":"retrieve_event","curl_definition":"GET /v1/events/:id"},{"anchor":"list_events","curl_definition":"GET /v1/events"},{"anchor":"event_types","curl_definition":null}]}},"event_object":{"title":"The event object","group_title":"Core Resources","group_anchor":"core_resources","anchor":"event_object","section_anchor":"events","subsection_anchors":null,"path":"/events/object","gate":false,"display_on_load":false},"retrieve_event":{"title":"Retrieve an event","group_title":"Core Resources","group_anchor":"core_resources","anchor":"retrieve_event","section_anchor":"events","subsection_anchors":null,"path":"/events/retrieve","gate":false,"display_on_load":false},"list_events":{"title":"List all events","group_title":"Core Resources","group_anchor":"core_resources","anchor":"list_events","section_anchor":"events","subsection_anchors":null,"path":"/events/list","gate":false,"display_on_load":false},"event_types":{"title":"Types of events","group_title":"Core Resources","group_anchor":"core_resources","anchor":"event_types","section_anchor":"events","subsection_anchors":null,"path":"/events/types","gate":false,"display_on_load":false},"files":{"title":"Files","group_title":"Core Resources","group_anchor":"core_resources","anchor":"files","section_anchor":"files","subsection_anchors":["file_object","create_file","retrieve_file","list_files"],"path":"/files","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Files","description":"This is an object representing a file hosted on Stripe's servers. The\nfile may have been uploaded by yourself using the [create file](#create_file)\nrequest (for example, when uploading dispute evidence) or it may have\nbeen created by Stripe (for example, the results of a [Sigma scheduled\nquery](#scheduled_queries)).\n\nRelated guide: [File Upload Guide](/docs/file-upload).\n","section_tag":"files","subsection_summaries":[{"anchor":"file_object","curl_definition":null},{"anchor":"create_file","curl_definition":"POST https://files.stripe.com/v1/files"},{"anchor":"retrieve_file","curl_definition":"GET /v1/files/:id"},{"anchor":"list_files","curl_definition":"GET /v1/files"}]}},"file_object":{"title":"The file object","group_title":"Core Resources","group_anchor":"core_resources","anchor":"file_object","section_anchor":"files","subsection_anchors":null,"path":"/files/object","gate":false,"display_on_load":false},"create_file":{"title":"Create a file","group_title":"Core Resources","group_anchor":"core_resources","anchor":"create_file","section_anchor":"files","subsection_anchors":null,"path":"/files/create","gate":false,"display_on_load":false},"retrieve_file":{"title":"Retrieve a file","group_title":"Core Resources","group_anchor":"core_resources","anchor":"retrieve_file","section_anchor":"files","subsection_anchors":null,"path":"/files/retrieve","gate":false,"display_on_load":false},"list_files":{"title":"List all files","group_title":"Core Resources","group_anchor":"core_resources","anchor":"list_files","section_anchor":"files","subsection_anchors":null,"path":"/files/list","gate":false,"display_on_load":false},"file_links":{"title":"File Links","group_title":"Core Resources","group_anchor":"core_resources","anchor":"file_links","section_anchor":"file_links","subsection_anchors":["file_link_object","create_file_link","retrieve_file_link","update_file_link","list_file_links"],"path":"/file_links","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"File Links","description":"To share the contents of a `File` object with non-Stripe users, you can\ncreate a `FileLink`. `FileLink`s contain a URL that can be used to\nretrieve the contents of the file without authentication.\n","section_tag":"file_links","subsection_summaries":[{"anchor":"file_link_object","curl_definition":null},{"anchor":"create_file_link","curl_definition":"POST /v1/file_links"},{"anchor":"retrieve_file_link","curl_definition":"GET /v1/file_links/:id"},{"anchor":"update_file_link","curl_definition":"POST /v1/file_links/:id"},{"anchor":"list_file_links","curl_definition":"GET /v1/file_links"}]}},"file_link_object":{"title":"The file link object","group_title":"Core Resources","group_anchor":"core_resources","anchor":"file_link_object","section_anchor":"file_links","subsection_anchors":null,"path":"/file_links/object","gate":false,"display_on_load":false},"create_file_link":{"title":"Create a file link","group_title":"Core Resources","group_anchor":"core_resources","anchor":"create_file_link","section_anchor":"file_links","subsection_anchors":null,"path":"/file_links/create","gate":false,"display_on_load":false},"retrieve_file_link":{"title":"Retrieve a file link","group_title":"Core Resources","group_anchor":"core_resources","anchor":"retrieve_file_link","section_anchor":"file_links","subsection_anchors":null,"path":"/file_links/retrieve","gate":false,"display_on_load":false},"update_file_link":{"title":"Update a file link","group_title":"Core Resources","group_anchor":"core_resources","anchor":"update_file_link","section_anchor":"file_links","subsection_anchors":null,"path":"/file_links/update","gate":false,"display_on_load":false},"list_file_links":{"title":"List all file links","group_title":"Core Resources","group_anchor":"core_resources","anchor":"list_file_links","section_anchor":"file_links","subsection_anchors":null,"path":"/file_links/list","gate":false,"display_on_load":false},"mandates":{"title":"Mandates","group_title":"Core Resources","group_anchor":"core_resources","anchor":"mandates","section_anchor":"mandates","subsection_anchors":["mandate_object","retrieve_mandate"],"path":"/mandates","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Mandates","description":"A Mandate is a record of the permission a customer has given you to debit their payment method.\n","section_tag":"mandates","subsection_summaries":[{"anchor":"mandate_object","curl_definition":null},{"anchor":"retrieve_mandate","curl_definition":"GET /v1/mandates/:id"}]}},"mandate_object":{"title":"The Mandates object","group_title":"Core Resources","group_anchor":"core_resources","anchor":"mandate_object","section_anchor":"mandates","subsection_anchors":null,"path":"/mandates/object","gate":false,"display_on_load":false},"retrieve_mandate":{"title":"Retrieve a Mandate","group_title":"Core Resources","group_anchor":"core_resources","anchor":"retrieve_mandate","section_anchor":"mandates","subsection_anchors":null,"path":"/mandates/retrieve","gate":false,"display_on_load":false},"payment_intents":{"title":"PaymentIntents","group_title":"Core Resources","group_anchor":"core_resources","anchor":"payment_intents","section_anchor":"payment_intents","subsection_anchors":["payment_intent_object","create_payment_intent","retrieve_payment_intent","update_payment_intent","confirm_payment_intent","capture_payment_intent","cancel_payment_intent","list_payment_intents"],"path":"/payment_intents","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"PaymentIntents","description":"A PaymentIntent guides you through the process of collecting a payment from your customer.\nWe recommend that you create exactly one PaymentIntent for each order or\ncustomer session in your system. You can reference the PaymentIntent later to\nsee the history of payment attempts for a particular session.\n\nA PaymentIntent transitions through\n[multiple statuses](/docs/payments/intents#intent-statuses)\nthroughout its lifetime as it interfaces with Stripe.js to perform\nauthentication flows and ultimately creates at most one successful charge.\n\nRelated guide: [Payment Intents API](/docs/payments/payment-intents/creating-payment-intents).\n","section_tag":"payment_intents","subsection_summaries":[{"anchor":"payment_intent_object","curl_definition":null},{"anchor":"create_payment_intent","curl_definition":"POST /v1/payment_intents"},{"anchor":"retrieve_payment_intent","curl_definition":"GET /v1/payment_intents/:id"},{"anchor":"update_payment_intent","curl_definition":"POST /v1/payment_intents/:id"},{"anchor":"confirm_payment_intent","curl_definition":"POST /v1/payment_intents/:id/confirm"},{"anchor":"capture_payment_intent","curl_definition":"POST /v1/payment_intents/:id/capture"},{"anchor":"cancel_payment_intent","curl_definition":"POST /v1/payment_intents/:id/cancel"},{"anchor":"list_payment_intents","curl_definition":"GET /v1/payment_intents"}]}},"payment_intent_object":{"title":"The PaymentIntent object","group_title":"Core Resources","group_anchor":"core_resources","anchor":"payment_intent_object","section_anchor":"payment_intents","subsection_anchors":null,"path":"/payment_intents/object","gate":false,"display_on_load":false},"create_payment_intent":{"title":"Create a PaymentIntent","group_title":"Core Resources","group_anchor":"core_resources","anchor":"create_payment_intent","section_anchor":"payment_intents","subsection_anchors":null,"path":"/payment_intents/create","gate":false,"display_on_load":false},"retrieve_payment_intent":{"title":"Retrieve a PaymentIntent","group_title":"Core Resources","group_anchor":"core_resources","anchor":"retrieve_payment_intent","section_anchor":"payment_intents","subsection_anchors":null,"path":"/payment_intents/retrieve","gate":false,"display_on_load":false},"update_payment_intent":{"title":"Update a PaymentIntent","group_title":"Core Resources","group_anchor":"core_resources","anchor":"update_payment_intent","section_anchor":"payment_intents","subsection_anchors":null,"path":"/payment_intents/update","gate":false,"display_on_load":false},"confirm_payment_intent":{"title":"Confirm a PaymentIntent","group_title":"Core Resources","group_anchor":"core_resources","anchor":"confirm_payment_intent","section_anchor":"payment_intents","subsection_anchors":null,"path":"/payment_intents/confirm","gate":false,"display_on_load":false},"capture_payment_intent":{"title":"Capture a PaymentIntent","group_title":"Core Resources","group_anchor":"core_resources","anchor":"capture_payment_intent","section_anchor":"payment_intents","subsection_anchors":null,"path":"/payment_intents/capture","gate":false,"display_on_load":false},"cancel_payment_intent":{"title":"Cancel a PaymentIntent","group_title":"Core Resources","group_anchor":"core_resources","anchor":"cancel_payment_intent","section_anchor":"payment_intents","subsection_anchors":null,"path":"/payment_intents/cancel","gate":false,"display_on_load":false},"list_payment_intents":{"title":"List all PaymentIntents","group_title":"Core Resources","group_anchor":"core_resources","anchor":"list_payment_intents","section_anchor":"payment_intents","subsection_anchors":null,"path":"/payment_intents/list","gate":false,"display_on_load":false},"setup_intents":{"title":"SetupIntents","group_title":"Core Resources","group_anchor":"core_resources","anchor":"setup_intents","section_anchor":"setup_intents","subsection_anchors":["setup_intent_object","create_setup_intent","retrieve_setup_intent","update_setup_intent","confirm_setup_intent","cancel_setup_intent","list_setup_intents"],"path":"/setup_intents","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"SetupIntents","description":"A SetupIntent guides you through the process of setting up a customer's payment credentials for future payments.\nFor example, you could use a SetupIntent to set up your customer's card without immediately collecting a payment.\nLater, you can use [PaymentIntents](#payment_intents) to drive the payment flow.\n\nCreate a SetupIntent as soon as you're ready to collect your customer's payment credentials.\nDo not maintain long-lived, unconfirmed SetupIntents as they may no longer be valid.\nThe SetupIntent then transitions through multiple [statuses](/docs/payments/intents#intent-statuses) as it guides\nyou through the setup process.\n\nSuccessful SetupIntents result in payment credentials that are optimized for future payments.\nFor example, cardholders in [certain regions](/guides/strong-customer-authentication) may need to be run through\n[Strong Customer Authentication](/docs/strong-customer-authentication) at the time of payment method collection\nin order to streamline later [off-session payments](/docs/payments/setup-intents).\n\nBy using SetupIntents, you ensure that your customers experience the minimum set of required friction,\neven as regulations change over time.\n","section_tag":"setup_intents","subsection_summaries":[{"anchor":"setup_intent_object","curl_definition":null},{"anchor":"create_setup_intent","curl_definition":"POST /v1/setup_intents"},{"anchor":"retrieve_setup_intent","curl_definition":"GET /v1/setup_intents/:id"},{"anchor":"update_setup_intent","curl_definition":"POST /v1/setup_intents/:id"},{"anchor":"confirm_setup_intent","curl_definition":"POST /v1/setup_intents/:id/confirm"},{"anchor":"cancel_setup_intent","curl_definition":"POST /v1/setup_intents/:id/cancel"},{"anchor":"list_setup_intents","curl_definition":"GET /v1/setup_intents"}]}},"setup_intent_object":{"title":"The SetupIntent object","group_title":"Core Resources","group_anchor":"core_resources","anchor":"setup_intent_object","section_anchor":"setup_intents","subsection_anchors":null,"path":"/setup_intents/object","gate":false,"display_on_load":false},"create_setup_intent":{"title":"Create a SetupIntent","group_title":"Core Resources","group_anchor":"core_resources","anchor":"create_setup_intent","section_anchor":"setup_intents","subsection_anchors":null,"path":"/setup_intents/create","gate":false,"display_on_load":false},"retrieve_setup_intent":{"title":"Retrieve a SetupIntent","group_title":"Core Resources","group_anchor":"core_resources","anchor":"retrieve_setup_intent","section_anchor":"setup_intents","subsection_anchors":null,"path":"/setup_intents/retrieve","gate":false,"display_on_load":false},"update_setup_intent":{"title":"Update a SetupIntent","group_title":"Core Resources","group_anchor":"core_resources","anchor":"update_setup_intent","section_anchor":"setup_intents","subsection_anchors":null,"path":"/setup_intents/update","gate":false,"display_on_load":false},"confirm_setup_intent":{"title":"Confirm a SetupIntent","group_title":"Core Resources","group_anchor":"core_resources","anchor":"confirm_setup_intent","section_anchor":"setup_intents","subsection_anchors":null,"path":"/setup_intents/confirm","gate":false,"display_on_load":false},"cancel_setup_intent":{"title":"Cancel a SetupIntent","group_title":"Core Resources","group_anchor":"core_resources","anchor":"cancel_setup_intent","section_anchor":"setup_intents","subsection_anchors":null,"path":"/setup_intents/cancel","gate":false,"display_on_load":false},"list_setup_intents":{"title":"List all SetupIntents","group_title":"Core Resources","group_anchor":"core_resources","anchor":"list_setup_intents","section_anchor":"setup_intents","subsection_anchors":null,"path":"/setup_intents/list","gate":false,"display_on_load":false},"payouts":{"title":"Payouts","group_title":"Core Resources","group_anchor":"core_resources","anchor":"payouts","section_anchor":"payouts","subsection_anchors":["payout_object","create_payout","retrieve_payout","update_payout","list_payouts","cancel_payout","payout_failures"],"path":"/payouts","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Payouts","description":"A `Payout` object is created when you receive funds from Stripe, or when you\ninitiate a payout to either a bank account or debit card of a [connected\nStripe account](/docs/connect/payouts). You can retrieve individual payouts,\nas well as list all payouts. Payouts are made on [varying\nschedules](/docs/payouts#payout-schedule), depending on your country and\nindustry.\n\nRelated guide: [Receiving Payouts](/docs/payouts).\n","section_tag":"payouts","subsection_summaries":[{"anchor":"payout_object","curl_definition":null},{"anchor":"create_payout","curl_definition":"POST /v1/payouts"},{"anchor":"retrieve_payout","curl_definition":"GET /v1/payouts/:id"},{"anchor":"update_payout","curl_definition":"POST /v1/payouts/:id"},{"anchor":"list_payouts","curl_definition":"GET /v1/payouts"},{"anchor":"cancel_payout","curl_definition":"POST /v1/payouts/:id/cancel"},{"anchor":"payout_failures","curl_definition":null}]}},"payout_object":{"title":"The payout object","group_title":"Core Resources","group_anchor":"core_resources","anchor":"payout_object","section_anchor":"payouts","subsection_anchors":null,"path":"/payouts/object","gate":false,"display_on_load":false},"create_payout":{"title":"Create a payout","group_title":"Core Resources","group_anchor":"core_resources","anchor":"create_payout","section_anchor":"payouts","subsection_anchors":null,"path":"/payouts/create","gate":false,"display_on_load":false},"retrieve_payout":{"title":"Retrieve a payout","group_title":"Core Resources","group_anchor":"core_resources","anchor":"retrieve_payout","section_anchor":"payouts","subsection_anchors":null,"path":"/payouts/retrieve","gate":false,"display_on_load":false},"update_payout":{"title":"Update a payout","group_title":"Core Resources","group_anchor":"core_resources","anchor":"update_payout","section_anchor":"payouts","subsection_anchors":null,"path":"/payouts/update","gate":false,"display_on_load":false},"list_payouts":{"title":"List all payouts","group_title":"Core Resources","group_anchor":"core_resources","anchor":"list_payouts","section_anchor":"payouts","subsection_anchors":null,"path":"/payouts/list","gate":false,"display_on_load":false},"cancel_payout":{"title":"Cancel a payout","group_title":"Core Resources","group_anchor":"core_resources","anchor":"cancel_payout","section_anchor":"payouts","subsection_anchors":null,"path":"/payouts/cancel","gate":false,"display_on_load":false},"payout_failures":{"title":"Types of payout failures","group_title":"Core Resources","group_anchor":"core_resources","anchor":"payout_failures","section_anchor":"payouts","subsection_anchors":null,"path":"/payouts/failures","gate":false,"display_on_load":false},"products":{"title":"Products","group_title":"Core Resources","group_anchor":"core_resources","anchor":"products","section_anchor":"products","subsection_anchors":["product_object","create_product","retrieve_product","update_product","list_products","delete_product"],"path":"/products","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Products","description":"Store representations of products you sell in `Product` objects, used in\nconjunction with [SKUs](#skus). Products may be physical goods, to be shipped, or\ndigital.\n\nDocumentation on `Product`s for use with `Subscription`s can be found at\n[Subscription Products](#service_products).\n\nRelated guide: [Define products and SKUs](/docs/orders#define-products-skus)\n","section_tag":"products","subsection_summaries":[{"anchor":"product_object","curl_definition":null},{"anchor":"create_product","curl_definition":"POST /v1/products"},{"anchor":"retrieve_product","curl_definition":"GET /v1/products/:id"},{"anchor":"update_product","curl_definition":"POST /v1/products/:id"},{"anchor":"list_products","curl_definition":"GET /v1/products"},{"anchor":"delete_product","curl_definition":"DELETE /v1/products/:id"}]}},"product_object":{"title":"The product object","group_title":"Core Resources","group_anchor":"core_resources","anchor":"product_object","section_anchor":"products","subsection_anchors":null,"path":"/products/object","gate":false,"display_on_load":false},"create_product":{"title":"Create a product","group_title":"Core Resources","group_anchor":"core_resources","anchor":"create_product","section_anchor":"products","subsection_anchors":null,"path":"/products/create","gate":false,"display_on_load":false},"retrieve_product":{"title":"Retrieve a product","group_title":"Core Resources","group_anchor":"core_resources","anchor":"retrieve_product","section_anchor":"products","subsection_anchors":null,"path":"/products/retrieve","gate":false,"display_on_load":false},"update_product":{"title":"Update a product","group_title":"Core Resources","group_anchor":"core_resources","anchor":"update_product","section_anchor":"products","subsection_anchors":null,"path":"/products/update","gate":false,"display_on_load":false},"list_products":{"title":"List all products","group_title":"Core Resources","group_anchor":"core_resources","anchor":"list_products","section_anchor":"products","subsection_anchors":null,"path":"/products/list","gate":false,"display_on_load":false},"delete_product":{"title":"Delete a product","group_title":"Core Resources","group_anchor":"core_resources","anchor":"delete_product","section_anchor":"products","subsection_anchors":null,"path":"/products/delete","gate":false,"display_on_load":false},"refunds":{"title":"Refunds","group_title":"Core Resources","group_anchor":"core_resources","anchor":"refunds","section_anchor":"refunds","subsection_anchors":["refund_object","create_refund","retrieve_refund","update_refund","list_refunds"],"path":"/refunds","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Refunds","description":"`Refund` objects allow you to refund a charge that has previously been created\nbut not yet refunded. Funds will be refunded to the credit or debit card that\nwas originally charged.\n\nRelated guide: [Refunds](/docs/refunds).\n","section_tag":"refunds","subsection_summaries":[{"anchor":"refund_object","curl_definition":null},{"anchor":"create_refund","curl_definition":"POST /v1/refunds"},{"anchor":"retrieve_refund","curl_definition":"GET /v1/refunds/:id"},{"anchor":"update_refund","curl_definition":"POST /v1/refunds/:id"},{"anchor":"list_refunds","curl_definition":"GET /v1/refunds"}]}},"refund_object":{"title":"The refund object","group_title":"Core Resources","group_anchor":"core_resources","anchor":"refund_object","section_anchor":"refunds","subsection_anchors":null,"path":"/refunds/object","gate":false,"display_on_load":false},"create_refund":{"title":"Create a refund","group_title":"Core Resources","group_anchor":"core_resources","anchor":"create_refund","section_anchor":"refunds","subsection_anchors":null,"path":"/refunds/create","gate":false,"display_on_load":false},"retrieve_refund":{"title":"Retrieve a refund","group_title":"Core Resources","group_anchor":"core_resources","anchor":"retrieve_refund","section_anchor":"refunds","subsection_anchors":null,"path":"/refunds/retrieve","gate":false,"display_on_load":false},"update_refund":{"title":"Update a refund","group_title":"Core Resources","group_anchor":"core_resources","anchor":"update_refund","section_anchor":"refunds","subsection_anchors":null,"path":"/refunds/update","gate":false,"display_on_load":false},"list_refunds":{"title":"List all refunds","group_title":"Core Resources","group_anchor":"core_resources","anchor":"list_refunds","section_anchor":"refunds","subsection_anchors":null,"path":"/refunds/list","gate":false,"display_on_load":false},"tokens":{"title":"Tokens","group_title":"Core Resources","group_anchor":"core_resources","anchor":"tokens","section_anchor":"tokens","subsection_anchors":["token_object","create_card_token","create_bank_account_token","create_pii_token","create_account_token","create_person_token","retrieve_token"],"path":"/tokens","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Tokens","description":"Tokenization is the process Stripe uses to collect sensitive card or bank\naccount details, or personally identifiable information (PII), directly from\nyour customers in a secure manner. A token representing this information is\nreturned to your server to use. You should use our\n[recommended payments integrations](/docs/payments) to perform this process\nclient-side. This ensures that no sensitive card data touches your server,\nand allows your integration to operate in a PCI-compliant way.\n\nIf you cannot use client-side tokenization, you can also create tokens using\nthe API with either your publishable or secret API key. Keep in mind that if\nyour integration uses this method, you are responsible for any PCI compliance\nthat may be required, and you must keep your secret API key safe. Unlike with\nclient-side tokenization, your customer's information is not sent directly to\nStripe, so we cannot determine how it is handled or stored.\n\nTokens cannot be stored or used more than once. To store card or bank account\ninformation for later use, you can create [Customer](/docs/api#customers)\nobjects or [Custom accounts](/docs/api#external_accounts). Note that\n[Radar](/docs/radar), our integrated solution for automatic fraud protection,\nsupports only integrations that use client-side tokenization.\n\nRelated guide: [Accept a payment](/docs/payments/accept-a-payment-charges#web-create-token)\n","section_tag":"tokens","subsection_summaries":[{"anchor":"token_object","curl_definition":null},{"anchor":"create_card_token","curl_definition":"POST /v1/tokens"},{"anchor":"create_bank_account_token","curl_definition":"POST /v1/tokens"},{"anchor":"create_pii_token","curl_definition":"POST /v1/tokens"},{"anchor":"create_account_token","curl_definition":"POST /v1/tokens"},{"anchor":"create_person_token","curl_definition":"POST /v1/tokens"},{"anchor":"retrieve_token","curl_definition":"GET /v1/tokens/:id"}]}},"token_object":{"title":"The token object","group_title":"Core Resources","group_anchor":"core_resources","anchor":"token_object","section_anchor":"tokens","subsection_anchors":null,"path":"/tokens/object","gate":false,"display_on_load":false},"create_card_token":{"title":"Create a card token","group_title":"Core Resources","group_anchor":"core_resources","anchor":"create_card_token","section_anchor":"tokens","subsection_anchors":null,"path":"/tokens/create_card","gate":false,"display_on_load":false},"create_bank_account_token":{"title":"Create a bank account token","group_title":"Core Resources","group_anchor":"core_resources","anchor":"create_bank_account_token","section_anchor":"tokens","subsection_anchors":null,"path":"/tokens/create_bank_account","gate":false,"display_on_load":false},"create_pii_token":{"title":"Create a PII token","group_title":"Core Resources","group_anchor":"core_resources","anchor":"create_pii_token","section_anchor":"tokens","subsection_anchors":null,"path":"/tokens/create_pii","gate":false,"display_on_load":false},"create_account_token":{"title":"Create an account token","group_title":"Core Resources","group_anchor":"core_resources","anchor":"create_account_token","section_anchor":"tokens","subsection_anchors":null,"path":"/tokens/create_account","gate":false,"display_on_load":false},"create_person_token":{"title":"Create a person token","group_title":"Core Resources","group_anchor":"core_resources","anchor":"create_person_token","section_anchor":"tokens","subsection_anchors":null,"path":"/tokens/create_person","gate":false,"display_on_load":false},"retrieve_token":{"title":"Retrieve a token","group_title":"Core Resources","group_anchor":"core_resources","anchor":"retrieve_token","section_anchor":"tokens","subsection_anchors":null,"path":"/tokens/retrieve","gate":false,"display_on_load":false},"payment_methods":{"title":"PaymentMethods","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"payment_methods","section_anchor":"payment_methods","subsection_anchors":["payment_method_object","create_payment_method","retrieve_payment_method","update_payment_method","list_payment_methods","customer_attach_payment_method","customer_detach_payment_method"],"path":"/payment_methods","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"PaymentMethods","description":"PaymentMethod objects represent your customer's payment instruments.\nThey can be used with [PaymentIntents](/docs/payments/payment-intents) to collect payments or saved to\nCustomer objects to store instrument details for future payments.\n\nRelated guides: [Payment Methods](/docs/payments/payment-methods) and [More Payment Scenarios](/docs/payments/more-payment-scenarios).\n","section_tag":"payment_methods","subsection_summaries":[{"anchor":"payment_method_object","curl_definition":null},{"anchor":"create_payment_method","curl_definition":"POST /v1/payment_methods"},{"anchor":"retrieve_payment_method","curl_definition":"GET /v1/payment_methods/:id"},{"anchor":"update_payment_method","curl_definition":"POST /v1/payment_methods/:id"},{"anchor":"list_payment_methods","curl_definition":"GET /v1/payment_methods"},{"anchor":"customer_attach_payment_method","curl_definition":"POST /v1/payment_methods/:id/attach"},{"anchor":"customer_detach_payment_method","curl_definition":"POST /v1/payment_methods/:id/detach"}]}},"payment_method_object":{"title":"The PaymentMethod object","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"payment_method_object","section_anchor":"payment_methods","subsection_anchors":null,"path":"/payment_methods/object","gate":false,"display_on_load":false},"create_payment_method":{"title":"Create a PaymentMethod","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"create_payment_method","section_anchor":"payment_methods","subsection_anchors":null,"path":"/payment_methods/create","gate":false,"display_on_load":false},"retrieve_payment_method":{"title":"Retrieve a PaymentMethod","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"retrieve_payment_method","section_anchor":"payment_methods","subsection_anchors":null,"path":"/payment_methods/retrieve","gate":false,"display_on_load":false},"update_payment_method":{"title":"Update a PaymentMethod","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"update_payment_method","section_anchor":"payment_methods","subsection_anchors":null,"path":"/payment_methods/update","gate":false,"display_on_load":false},"list_payment_methods":{"title":"List a Customer's PaymentMethods","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"list_payment_methods","section_anchor":"payment_methods","subsection_anchors":null,"path":"/payment_methods/list","gate":false,"display_on_load":false},"customer_attach_payment_method":{"title":"Attach a PaymentMethod to a Customer","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"customer_attach_payment_method","section_anchor":"payment_methods","subsection_anchors":null,"path":"/payment_methods/attach","gate":false,"display_on_load":false},"customer_detach_payment_method":{"title":"Detach a PaymentMethod from a Customer","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"customer_detach_payment_method","section_anchor":"payment_methods","subsection_anchors":null,"path":"/payment_methods/detach","gate":false,"display_on_load":false},"bank_accounts":{"title":"Bank Accounts","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"bank_accounts","section_anchor":"bank_accounts","subsection_anchors":["customer_bank_account_object","customer_create_bank_account","customer_retrieve_bank_account","customer_update_bank_account","customer_verify_bank_account","customer_delete_bank_account","customer_list_bank_accounts"],"path":"/customer_bank_accounts","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Bank Accounts","description":"These bank accounts are payment methods on `Customer` objects.\n\nOn the other hand [External Accounts](/docs/api#external_accounts) are transfer\ndestinations on `Account` objects for [Custom accounts](/docs/connect/custom-accounts).\nThey can be bank accounts or debit cards as well, and are documented in the links above.\n\nRelated guide: [Processing ACH \u0026 Bank Transfers](/docs/payments/ach-bank-transfers).\n","section_tag":"bank_accounts","subsection_summaries":[{"anchor":"customer_bank_account_object","curl_definition":null},{"anchor":"customer_create_bank_account","curl_definition":"POST /v1/customers/:id/sources"},{"anchor":"customer_retrieve_bank_account","curl_definition":"GET /v1/bank_accounts/:id"},{"anchor":"customer_update_bank_account","curl_definition":"POST /v1/customers/:id/sources/:id"},{"anchor":"customer_verify_bank_account","curl_definition":"POST /v1/customers/:id/sources/:id/verify"},{"anchor":"customer_delete_bank_account","curl_definition":"DELETE /v1/customers/:id/sources/:id"},{"anchor":"customer_list_bank_accounts","curl_definition":"GET /v1/customers/:id/sources?object=bank_account"}]}},"customer_bank_account_object":{"title":"The bank account object","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"customer_bank_account_object","section_anchor":"bank_accounts","subsection_anchors":null,"path":"/customer_bank_accounts/object","gate":false,"display_on_load":false},"customer_create_bank_account":{"title":"Create a bank account","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"customer_create_bank_account","section_anchor":"bank_accounts","subsection_anchors":null,"path":"/customer_bank_accounts/create","gate":false,"display_on_load":false},"customer_retrieve_bank_account":{"title":"Retrieve a bank account","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"customer_retrieve_bank_account","section_anchor":"bank_accounts","subsection_anchors":null,"path":"/customer_bank_accounts/retrieve","gate":false,"display_on_load":false},"customer_update_bank_account":{"title":"Update a bank account","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"customer_update_bank_account","section_anchor":"bank_accounts","subsection_anchors":null,"path":"/customer_bank_accounts/update","gate":false,"display_on_load":false},"customer_verify_bank_account":{"title":"Verify a bank account","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"customer_verify_bank_account","section_anchor":"bank_accounts","subsection_anchors":null,"path":"/customer_bank_accounts/verify","gate":false,"display_on_load":false},"customer_delete_bank_account":{"title":"Delete a bank account","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"customer_delete_bank_account","section_anchor":"bank_accounts","subsection_anchors":null,"path":"/customer_bank_accounts/delete","gate":false,"display_on_load":false},"customer_list_bank_accounts":{"title":"List all bank accounts","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"customer_list_bank_accounts","section_anchor":"bank_accounts","subsection_anchors":null,"path":"/customer_bank_accounts/list","gate":false,"display_on_load":false},"cards":{"title":"Cards","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"cards","section_anchor":"cards","subsection_anchors":["card_object","create_card","retrieve_card","update_card","delete_card","list_cards"],"path":"/cards","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Cards","description":"You can store multiple cards on a customer in order to charge the customer\nlater. You can also store multiple debit cards on a recipient in order to\ntransfer to those cards later.\n\nRelated guide: [Card Payments with Sources](/docs/sources/cards).\n","section_tag":"cards","subsection_summaries":[{"anchor":"card_object","curl_definition":null},{"anchor":"create_card","curl_definition":"POST /v1/customers/:id/sources"},{"anchor":"retrieve_card","curl_definition":"GET /v1/customers/:id/sources/:id"},{"anchor":"update_card","curl_definition":"POST /v1/customers/:id/sources/:id"},{"anchor":"delete_card","curl_definition":"DELETE /v1/customers/:id/sources/:id"},{"anchor":"list_cards","curl_definition":"GET /v1/customers/:id/sources?object=card"}]}},"card_object":{"title":"The card object","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"card_object","section_anchor":"cards","subsection_anchors":null,"path":"/cards/object","gate":false,"display_on_load":false},"create_card":{"title":"Create a card","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"create_card","section_anchor":"cards","subsection_anchors":null,"path":"/cards/create","gate":false,"display_on_load":false},"retrieve_card":{"title":"Retrieve a card","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"retrieve_card","section_anchor":"cards","subsection_anchors":null,"path":"/cards/retrieve","gate":false,"display_on_load":false},"update_card":{"title":"Update a card","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"update_card","section_anchor":"cards","subsection_anchors":null,"path":"/cards/update","gate":false,"display_on_load":false},"delete_card":{"title":"Delete a card","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"delete_card","section_anchor":"cards","subsection_anchors":null,"path":"/cards/delete","gate":false,"display_on_load":false},"list_cards":{"title":"List all cards","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"list_cards","section_anchor":"cards","subsection_anchors":null,"path":"/cards/list","gate":false,"display_on_load":false},"sources":{"title":"Sources","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"sources","section_anchor":"sources","subsection_anchors":["source_object","create_source","retrieve_source","update_source","attach_source","detach_source"],"path":"/sources","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Sources","description":"`Source` objects allow you to accept a variety of payment methods. They\nrepresent a customer's payment instrument, and can be used with the Stripe API\njust like a `Card` object: once chargeable, they can be charged, or can be\nattached to customers.\n\nRelated guides: [Sources API](/docs/sources) and [Sources \u0026 Customers](/docs/sources/customers).\n","section_tag":"sources","subsection_summaries":[{"anchor":"source_object","curl_definition":null},{"anchor":"create_source","curl_definition":"POST /v1/sources"},{"anchor":"retrieve_source","curl_definition":"GET /v1/sources/:id"},{"anchor":"update_source","curl_definition":"POST /v1/sources/:id"},{"anchor":"attach_source","curl_definition":"POST /v1/customers/:id/sources"},{"anchor":"detach_source","curl_definition":"DELETE /v1/customers/:id/sources/:id"}]}},"source_object":{"title":"The source object","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"source_object","section_anchor":"sources","subsection_anchors":null,"path":"/sources/object","gate":false,"display_on_load":false},"create_source":{"title":"Create a source","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"create_source","section_anchor":"sources","subsection_anchors":null,"path":"/sources/create","gate":false,"display_on_load":false},"retrieve_source":{"title":"Retrieve a source","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"retrieve_source","section_anchor":"sources","subsection_anchors":null,"path":"/sources/retrieve","gate":false,"display_on_load":false},"update_source":{"title":"Update a source","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"update_source","section_anchor":"sources","subsection_anchors":null,"path":"/sources/update","gate":false,"display_on_load":false},"attach_source":{"title":"Attach a source","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"attach_source","section_anchor":"sources","subsection_anchors":null,"path":"/sources/attach","gate":false,"display_on_load":false},"detach_source":{"title":"Detach a source","group_title":"Payment Methods","group_anchor":"payment_methods_heading","anchor":"detach_source","section_anchor":"sources","subsection_anchors":null,"path":"/sources/detach","gate":false,"display_on_load":false},"checkout_sessions":{"title":"Sessions","group_title":"Checkout","group_anchor":"checkout","anchor":"checkout_sessions","section_anchor":"checkout_sessions","subsection_anchors":["checkout_session_object","create_checkout_session","retrieve_checkout_session"],"path":"/checkout/sessions","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Sessions","description":"A Checkout Session represents your customer's session as they pay for\none-time purchases or subscriptions through [Checkout](/docs/payments/checkout).\nWe recommend creating a new Session each time your customer attempts to pay.\n\nOnce payment is successful, the Checkout Session will contain a reference\nto the [Customer](/docs/api/customers), and either the successful\n[PaymentIntent](/docs/api/payment_intents) or an active\n[Subscription](/docs/api/subscriptions).\n\nYou can create a Checkout Session on your server and pass its ID to the\nclient to begin Checkout.\n\nRelated guide: [Checkout Server Quickstart](/docs/payments/checkout/api).\n","section_tag":"checkout_sessions","subsection_summaries":[{"anchor":"checkout_session_object","curl_definition":null},{"anchor":"create_checkout_session","curl_definition":"POST /v1/checkout/sessions"},{"anchor":"retrieve_checkout_session","curl_definition":"GET /v1/checkout/sessions/:id"}]}},"checkout_session_object":{"title":"The Session object","group_title":"Checkout","group_anchor":"checkout","anchor":"checkout_session_object","section_anchor":"checkout_sessions","subsection_anchors":null,"path":"/checkout/sessions/object","gate":false,"display_on_load":false},"create_checkout_session":{"title":"Create a Session","group_title":"Checkout","group_anchor":"checkout","anchor":"create_checkout_session","section_anchor":"checkout_sessions","subsection_anchors":null,"path":"/checkout/sessions/create","gate":false,"display_on_load":false},"retrieve_checkout_session":{"title":"Retrieve a Session","group_title":"Checkout","group_anchor":"checkout","anchor":"retrieve_checkout_session","section_anchor":"checkout_sessions","subsection_anchors":null,"path":"/checkout/sessions/retrieve","gate":false,"display_on_load":false},"coupons":{"title":"Coupons","group_title":"Billing","group_anchor":"billing","anchor":"coupons","section_anchor":"coupons","subsection_anchors":["coupon_object","create_coupon","retrieve_coupon","update_coupon","delete_coupon","list_coupons"],"path":"/coupons","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Coupons","description":"A coupon contains information about a percent-off or amount-off discount you\nmight want to apply to a customer. Coupons may be applied to [invoices](#invoices) or\n[orders](#create_order-coupon). Coupons do not work with conventional one-off [charges](#create_charge), but you can\nimplement a [custom coupon system](/docs/recipes/coupons-for-charges) in your\napplication.\n","section_tag":"coupons","subsection_summaries":[{"anchor":"coupon_object","curl_definition":null},{"anchor":"create_coupon","curl_definition":"POST /v1/coupons"},{"anchor":"retrieve_coupon","curl_definition":"GET /v1/coupons/:id"},{"anchor":"update_coupon","curl_definition":"POST /v1/coupons/:id"},{"anchor":"delete_coupon","curl_definition":"DELETE /v1/coupons/:id"},{"anchor":"list_coupons","curl_definition":"GET /v1/coupons"}]}},"coupon_object":{"title":"The coupon object","group_title":"Billing","group_anchor":"billing","anchor":"coupon_object","section_anchor":"coupons","subsection_anchors":null,"path":"/coupons/object","gate":false,"display_on_load":false},"create_coupon":{"title":"Create a coupon","group_title":"Billing","group_anchor":"billing","anchor":"create_coupon","section_anchor":"coupons","subsection_anchors":null,"path":"/coupons/create","gate":false,"display_on_load":false},"retrieve_coupon":{"title":"Retrieve a coupon","group_title":"Billing","group_anchor":"billing","anchor":"retrieve_coupon","section_anchor":"coupons","subsection_anchors":null,"path":"/coupons/retrieve","gate":false,"display_on_load":false},"update_coupon":{"title":"Update a coupon","group_title":"Billing","group_anchor":"billing","anchor":"update_coupon","section_anchor":"coupons","subsection_anchors":null,"path":"/coupons/update","gate":false,"display_on_load":false},"delete_coupon":{"title":"Delete a coupon","group_title":"Billing","group_anchor":"billing","anchor":"delete_coupon","section_anchor":"coupons","subsection_anchors":null,"path":"/coupons/delete","gate":false,"display_on_load":false},"list_coupons":{"title":"List all coupons","group_title":"Billing","group_anchor":"billing","anchor":"list_coupons","section_anchor":"coupons","subsection_anchors":null,"path":"/coupons/list","gate":false,"display_on_load":false},"credit_notes":{"title":"Credit Notes","group_title":"Billing","group_anchor":"billing","anchor":"credit_notes","section_anchor":"credit_notes","subsection_anchors":["credit_note_object","preview_credit_note","create_credit_note","retrieve_credit_note","update_credit_note","void_credit_note","list_credit_notes"],"path":"/credit_notes","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Credit Note","description":"Issue a credit note to adjust an invoice's amount after the invoice is finalized.\n\nRelated guide: [Credit Notes](/docs/billing/invoices/credit-notes).\n","section_tag":"credit_notes","subsection_summaries":[{"anchor":"credit_note_object","curl_definition":null},{"anchor":"preview_credit_note","curl_definition":"GET /v1/credit_notes/preview"},{"anchor":"create_credit_note","curl_definition":"POST /v1/credit_notes"},{"anchor":"retrieve_credit_note","curl_definition":"GET /v1/credit_notes/:id"},{"anchor":"update_credit_note","curl_definition":"POST /v1/credit_notes/:id"},{"anchor":"void_credit_note","curl_definition":"POST /v1/credit_notes/:id/void"},{"anchor":"list_credit_notes","curl_definition":"GET /v1/credit_notes"}]}},"credit_note_object":{"title":"The credit note object","group_title":"Billing","group_anchor":"billing","anchor":"credit_note_object","section_anchor":"credit_notes","subsection_anchors":null,"path":"/credit_notes/object","gate":false,"display_on_load":false},"preview_credit_note":{"title":"Preview a credit note","group_title":"Billing","group_anchor":"billing","anchor":"preview_credit_note","section_anchor":"credit_notes","subsection_anchors":null,"path":"/credit_notes/preview","gate":false,"display_on_load":false},"create_credit_note":{"title":"Create a credit note","group_title":"Billing","group_anchor":"billing","anchor":"create_credit_note","section_anchor":"credit_notes","subsection_anchors":null,"path":"/credit_notes/create","gate":false,"display_on_load":false},"retrieve_credit_note":{"title":"Retrieve a credit note","group_title":"Billing","group_anchor":"billing","anchor":"retrieve_credit_note","section_anchor":"credit_notes","subsection_anchors":null,"path":"/credit_notes/retrieve","gate":false,"display_on_load":false},"update_credit_note":{"title":"Update a credit note","group_title":"Billing","group_anchor":"billing","anchor":"update_credit_note","section_anchor":"credit_notes","subsection_anchors":null,"path":"/credit_notes/update","gate":false,"display_on_load":false},"void_credit_note":{"title":"Void a credit note","group_title":"Billing","group_anchor":"billing","anchor":"void_credit_note","section_anchor":"credit_notes","subsection_anchors":null,"path":"/credit_notes/void","gate":false,"display_on_load":false},"list_credit_notes":{"title":"List all credit notes","group_title":"Billing","group_anchor":"billing","anchor":"list_credit_notes","section_anchor":"credit_notes","subsection_anchors":null,"path":"/credit_notes/list","gate":false,"display_on_load":false},"customer_balance_transactions":{"title":"Customer Balance Transactions","group_title":"Billing","group_anchor":"billing","anchor":"customer_balance_transactions","section_anchor":"customer_balance_transactions","subsection_anchors":["customer_balance_transaction_object","create_customer_balance_transaction","retrieve_customer_balance_transaction","update_customer_balance_transaction","list_customer_balance_transactions"],"path":"/customer_balance_transactions","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Customer Balance Transaction","description":"Each customer has a [`balance`](/docs/api/customers/object#customer_object-balance) value,\nwhich denotes a debit or credit that's automatically applied to their next invoice upon finalization.\nYou may modify the value directly by using the [update customer API](/docs/api/customers/update),\nor by creating a Customer Balance Transaction, which increments or decrements the customer's `balance` by the specified `amount`.\n\nRelated guide: [Customer Balance](/docs/billing/customer/balance) to learn more.\n","section_tag":"customer_balance_transactions","subsection_summaries":[{"anchor":"customer_balance_transaction_object","curl_definition":null},{"anchor":"create_customer_balance_transaction","curl_definition":"POST /v1/customers/:id/balance_transactions"},{"anchor":"retrieve_customer_balance_transaction","curl_definition":"GET /v1/customers/:id/balance_transactions/:id"},{"anchor":"update_customer_balance_transaction","curl_definition":"POST /v1/customers/:id/balance_transactions/:id"},{"anchor":"list_customer_balance_transactions","curl_definition":"GET /v1/customers/:id/balance_transactions"}]}},"customer_balance_transaction_object":{"title":"The customer balance transaction object","group_title":"Billing","group_anchor":"billing","anchor":"customer_balance_transaction_object","section_anchor":"customer_balance_transactions","subsection_anchors":null,"path":"/customer_balance_transactions/object","gate":false,"display_on_load":false},"create_customer_balance_transaction":{"title":"Create a customer balance transaction","group_title":"Billing","group_anchor":"billing","anchor":"create_customer_balance_transaction","section_anchor":"customer_balance_transactions","subsection_anchors":null,"path":"/customer_balance_transactions/create","gate":false,"display_on_load":false},"retrieve_customer_balance_transaction":{"title":"Retrieve a customer balance transaction","group_title":"Billing","group_anchor":"billing","anchor":"retrieve_customer_balance_transaction","section_anchor":"customer_balance_transactions","subsection_anchors":null,"path":"/customer_balance_transactions/retrieve","gate":false,"display_on_load":false},"update_customer_balance_transaction":{"title":"Update a customer balance transaction","group_title":"Billing","group_anchor":"billing","anchor":"update_customer_balance_transaction","section_anchor":"customer_balance_transactions","subsection_anchors":null,"path":"/customer_balance_transactions/update","gate":false,"display_on_load":false},"list_customer_balance_transactions":{"title":"List customer balance transactions","group_title":"Billing","group_anchor":"billing","anchor":"list_customer_balance_transactions","section_anchor":"customer_balance_transactions","subsection_anchors":null,"path":"/customer_balance_transactions/list","gate":false,"display_on_load":false},"customer_tax_ids":{"title":"Customer Tax IDs","group_title":"Billing","group_anchor":"billing","anchor":"customer_tax_ids","section_anchor":"customer_tax_ids","subsection_anchors":["tax_id_object","create_tax_id","retrieve_tax_id","delete_tax_id","list_tax_ids"],"path":"/customer_tax_ids","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Customer Tax IDs","description":"You can add one or multiple tax IDs to a [customer](/docs/api/customers).\nA customer's tax IDs are displayed on invoices and credit notes issued for the customer.\n\nRelated guide: [Customer Tax Identification Numbers](/docs/billing/taxes/tax-ids).\n","section_tag":"customer_tax_ids","subsection_summaries":[{"anchor":"tax_id_object","curl_definition":null},{"anchor":"create_tax_id","curl_definition":"POST /v1/customers/:id/tax_ids"},{"anchor":"retrieve_tax_id","curl_definition":"GET /v1/customers/:id/tax_ids/:id"},{"anchor":"delete_tax_id","curl_definition":"DELETE /v1/customers/:id/tax_ids/:id"},{"anchor":"list_tax_ids","curl_definition":"GET /v1/customers/:id/tax_ids"}]}},"tax_id_object":{"title":"The tax ID object","group_title":"Billing","group_anchor":"billing","anchor":"tax_id_object","section_anchor":"customer_tax_ids","subsection_anchors":null,"path":"/customer_tax_ids/object","gate":false,"display_on_load":false},"create_tax_id":{"title":"Create a tax ID","group_title":"Billing","group_anchor":"billing","anchor":"create_tax_id","section_anchor":"customer_tax_ids","subsection_anchors":null,"path":"/customer_tax_ids/create","gate":false,"display_on_load":false},"retrieve_tax_id":{"title":"Retrieve a tax ID","group_title":"Billing","group_anchor":"billing","anchor":"retrieve_tax_id","section_anchor":"customer_tax_ids","subsection_anchors":null,"path":"/customer_tax_ids/retrieve","gate":false,"display_on_load":false},"delete_tax_id":{"title":"Delete a tax ID","group_title":"Billing","group_anchor":"billing","anchor":"delete_tax_id","section_anchor":"customer_tax_ids","subsection_anchors":null,"path":"/customer_tax_ids/delete","gate":false,"display_on_load":false},"list_tax_ids":{"title":"List all tax IDs","group_title":"Billing","group_anchor":"billing","anchor":"list_tax_ids","section_anchor":"customer_tax_ids","subsection_anchors":null,"path":"/customer_tax_ids/list","gate":false,"display_on_load":false},"discounts":{"title":"Discounts","group_title":"Billing","group_anchor":"billing","anchor":"discounts","section_anchor":"discounts","subsection_anchors":["discount_object","delete_discount","delete_subscription_discount"],"path":"/discounts","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Discounts","description":"A discount represents the actual application of a coupon to a particular\ncustomer. It contains information about when the discount began and when it\nwill end.\n\nRelated guide: [Applying Discounts to Subscriptions](/docs/billing/subscriptions/discounts).\n","section_tag":"discounts","subsection_summaries":[{"anchor":"discount_object","curl_definition":null},{"anchor":"delete_discount","curl_definition":"DELETE /v1/customers/:id/discount"},{"anchor":"delete_subscription_discount","curl_definition":"DELETE /v1/subscriptions/:id/discount"}]}},"discount_object":{"title":"The discount object","group_title":"Billing","group_anchor":"billing","anchor":"discount_object","section_anchor":"discounts","subsection_anchors":null,"path":"/discounts/object","gate":false,"display_on_load":false},"delete_discount":{"title":"Delete a customer discount","group_title":"Billing","group_anchor":"billing","anchor":"delete_discount","section_anchor":"discounts","subsection_anchors":null,"path":"/discounts/delete","gate":false,"display_on_load":false},"delete_subscription_discount":{"title":"Delete a subscription discount","group_title":"Billing","group_anchor":"billing","anchor":"delete_subscription_discount","section_anchor":"discounts","subsection_anchors":null,"path":"/discounts/subscription_delete","gate":false,"display_on_load":false},"invoices":{"title":"Invoices","group_title":"Billing","group_anchor":"billing","anchor":"invoices","section_anchor":"invoices","subsection_anchors":["invoice_object","invoice_line_item_object","create_invoice","retrieve_invoice","update_invoice","delete_invoice","finalize_invoice","pay_invoice","send_invoice","void_invoice","mark_uncollectible_invoice","invoice_lines","upcoming_invoice","upcoming_invoice_lines","list_invoices"],"path":"/invoices","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Invoices","description":"Invoices are statements of amounts owed by a customer, and are either\ngenerated one-off, or generated periodically from a subscription.\n\nThey contain [invoice items](#invoiceitems), and proration adjustments\nthat may be caused by subscription upgrades/downgrades (if necessary).\n\nIf your invoice is configured to be billed through automatic charges,\nStripe automatically finalizes your invoice and attempts payment.  Note\nthat finalizing the invoice,\n[when automatic](/docs/billing/invoices/workflow/#auto_advance), does\nnot happen immediately as the invoice is created. Stripe waits\nuntil one hour after the last webhook was successfully sent (or the last\nwebhook timed out after failing). If you (and the platforms you may have\nconnected to) have no webhooks configured, Stripe waits one hour after\ncreation to finalize the invoice.\n\nIf your invoice is configured to be billed by sending an email, then based on your\n[email settings](https://dashboard.stripe.com/account/billing/automatic),\nStripe will email the invoice to your customer and await payment. These\nemails can contain a link to a hosted page to pay the invoice.\n\nStripe applies any customer credit on the account before determining the\namount due for the invoice (i.e., the amount that will be actually\ncharged). If the amount due for the invoice is less than Stripe's [minimum allowed charge\nper currency](/docs/currencies#minimum-and-maximum-charge-amounts), the\ninvoice is automatically marked paid, and we add the amount due to the\ncustomer's running account balance which is applied to the next invoice.\n\nMore details on the customer's account balance are\n[here](/docs/api/customers/object#customer_object-account_balance).\n\nRelated guide: [Send Invoices to Customers](/docs/billing/invoices/sending).\n","section_tag":"invoices","subsection_summaries":[{"anchor":"invoice_object","curl_definition":null},{"anchor":"invoice_line_item_object","curl_definition":null},{"anchor":"create_invoice","curl_definition":"POST /v1/invoices"},{"anchor":"retrieve_invoice","curl_definition":"GET /v1/invoices/:id"},{"anchor":"update_invoice","curl_definition":"POST /v1/invoices/:id"},{"anchor":"delete_invoice","curl_definition":"DELETE /v1/invoices/:id"},{"anchor":"finalize_invoice","curl_definition":"POST /v1/invoices/:id/finalize"},{"anchor":"pay_invoice","curl_definition":"POST /v1/invoices/:id/pay"},{"anchor":"send_invoice","curl_definition":"POST /v1/invoices/:id/send"},{"anchor":"void_invoice","curl_definition":"POST /v1/invoices/:id/void"},{"anchor":"mark_uncollectible_invoice","curl_definition":"POST /v1/invoices/:id/mark_uncollectible"},{"anchor":"invoice_lines","curl_definition":"GET /v1/invoices/:id/lines"},{"anchor":"upcoming_invoice","curl_definition":"GET /v1/invoices/upcoming"},{"anchor":"upcoming_invoice_lines","curl_definition":"GET /v1/invoices/upcoming/lines"},{"anchor":"list_invoices","curl_definition":"GET /v1/invoices"}]}},"invoice_object":{"title":"The Invoice object","group_title":"Billing","group_anchor":"billing","anchor":"invoice_object","section_anchor":"invoices","subsection_anchors":null,"path":"/invoices/object","gate":false,"display_on_load":false},"invoice_line_item_object":{"title":"The (Invoice) Line Item object","group_title":"Billing","group_anchor":"billing","anchor":"invoice_line_item_object","section_anchor":"invoices","subsection_anchors":null,"path":"/invoices/line_item","gate":false,"display_on_load":false},"create_invoice":{"title":"Create an invoice","group_title":"Billing","group_anchor":"billing","anchor":"create_invoice","section_anchor":"invoices","subsection_anchors":null,"path":"/invoices/create","gate":false,"display_on_load":false},"retrieve_invoice":{"title":"Retrieve an invoice","group_title":"Billing","group_anchor":"billing","anchor":"retrieve_invoice","section_anchor":"invoices","subsection_anchors":null,"path":"/invoices/retrieve","gate":false,"display_on_load":false},"update_invoice":{"title":"Update an invoice","group_title":"Billing","group_anchor":"billing","anchor":"update_invoice","section_anchor":"invoices","subsection_anchors":null,"path":"/invoices/update","gate":false,"display_on_load":false},"delete_invoice":{"title":"Delete a draft invoice","group_title":"Billing","group_anchor":"billing","anchor":"delete_invoice","section_anchor":"invoices","subsection_anchors":null,"path":"/invoices/delete","gate":false,"display_on_load":false},"finalize_invoice":{"title":"Finalize an invoice","group_title":"Billing","group_anchor":"billing","anchor":"finalize_invoice","section_anchor":"invoices","subsection_anchors":null,"path":"/invoices/finalize","gate":false,"display_on_load":false},"pay_invoice":{"title":"Pay an invoice","group_title":"Billing","group_anchor":"billing","anchor":"pay_invoice","section_anchor":"invoices","subsection_anchors":null,"path":"/invoices/pay","gate":false,"display_on_load":false},"send_invoice":{"title":"Send an invoice for manual payment","group_title":"Billing","group_anchor":"billing","anchor":"send_invoice","section_anchor":"invoices","subsection_anchors":null,"path":"/invoices/send","gate":false,"display_on_load":false},"void_invoice":{"title":"Void an invoice","group_title":"Billing","group_anchor":"billing","anchor":"void_invoice","section_anchor":"invoices","subsection_anchors":null,"path":"/invoices/void","gate":false,"display_on_load":false},"mark_uncollectible_invoice":{"title":"Mark an invoice as uncollectible","group_title":"Billing","group_anchor":"billing","anchor":"mark_uncollectible_invoice","section_anchor":"invoices","subsection_anchors":null,"path":"/invoices/mark_uncollectible","gate":false,"display_on_load":false},"invoice_lines":{"title":"Retrieve an invoice's line items","group_title":"Billing","group_anchor":"billing","anchor":"invoice_lines","section_anchor":"invoices","subsection_anchors":null,"path":"/invoices/invoice_lines","gate":false,"display_on_load":false},"upcoming_invoice":{"title":"Retrieve an upcoming invoice","group_title":"Billing","group_anchor":"billing","anchor":"upcoming_invoice","section_anchor":"invoices","subsection_anchors":null,"path":"/invoices/upcoming","gate":false,"display_on_load":false},"upcoming_invoice_lines":{"title":"Retrieve an upcoming invoice's line items","group_title":"Billing","group_anchor":"billing","anchor":"upcoming_invoice_lines","section_anchor":"invoices","subsection_anchors":null,"path":"/invoices/upcoming_invoice_lines","gate":false,"display_on_load":false},"list_invoices":{"title":"List all invoices","group_title":"Billing","group_anchor":"billing","anchor":"list_invoices","section_anchor":"invoices","subsection_anchors":null,"path":"/invoices/list","gate":false,"display_on_load":false},"invoiceitems":{"title":"Invoice Items","group_title":"Billing","group_anchor":"billing","anchor":"invoiceitems","section_anchor":"invoiceitems","subsection_anchors":["invoiceitem_object","create_invoiceitem","retrieve_invoiceitem","update_invoiceitem","delete_invoiceitem","list_invoiceitems"],"path":"/invoiceitems","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Invoice Items","description":"Sometimes you want to add a charge or credit to a customer, but actually\ncharge or credit the customer's card only at the end of a regular billing\ncycle. This is useful for combining several charges (to minimize\nper-transaction fees), or for having Stripe tabulate your usage-based billing\ntotals.\n\nRelated guide: [Subscription Invoices](/docs/billing/invoices/subscription#adding-upcoming-invoice-items).\n","section_tag":"invoiceitems","subsection_summaries":[{"anchor":"invoiceitem_object","curl_definition":null},{"anchor":"create_invoiceitem","curl_definition":"POST /v1/invoiceitems"},{"anchor":"retrieve_invoiceitem","curl_definition":"GET /v1/invoiceitems/:id"},{"anchor":"update_invoiceitem","curl_definition":"POST /v1/invoiceitems/:id"},{"anchor":"delete_invoiceitem","curl_definition":"DELETE /v1/invoiceitems/:id"},{"anchor":"list_invoiceitems","curl_definition":"GET /v1/invoiceitems"}]}},"invoiceitem_object":{"title":"The invoiceitem object","group_title":"Billing","group_anchor":"billing","anchor":"invoiceitem_object","section_anchor":"invoiceitems","subsection_anchors":null,"path":"/invoiceitems/object","gate":false,"display_on_load":false},"create_invoiceitem":{"title":"Create an invoice item","group_title":"Billing","group_anchor":"billing","anchor":"create_invoiceitem","section_anchor":"invoiceitems","subsection_anchors":null,"path":"/invoiceitems/create","gate":false,"display_on_load":false},"retrieve_invoiceitem":{"title":"Retrieve an invoice item","group_title":"Billing","group_anchor":"billing","anchor":"retrieve_invoiceitem","section_anchor":"invoiceitems","subsection_anchors":null,"path":"/invoiceitems/retrieve","gate":false,"display_on_load":false},"update_invoiceitem":{"title":"Update an invoice item","group_title":"Billing","group_anchor":"billing","anchor":"update_invoiceitem","section_anchor":"invoiceitems","subsection_anchors":null,"path":"/invoiceitems/update","gate":false,"display_on_load":false},"delete_invoiceitem":{"title":"Delete an invoice item","group_title":"Billing","group_anchor":"billing","anchor":"delete_invoiceitem","section_anchor":"invoiceitems","subsection_anchors":null,"path":"/invoiceitems/delete","gate":false,"display_on_load":false},"list_invoiceitems":{"title":"List all invoice items","group_title":"Billing","group_anchor":"billing","anchor":"list_invoiceitems","section_anchor":"invoiceitems","subsection_anchors":null,"path":"/invoiceitems/list","gate":false,"display_on_load":false},"plans":{"title":"Plans","group_title":"Billing","group_anchor":"billing","anchor":"plans","section_anchor":"plans","subsection_anchors":["plan_object","create_plan","retrieve_plan","update_plan","delete_plan","list_plans"],"path":"/plans","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Plans","description":"Plans define the base price, currency, and billing cycle for subscriptions.\nFor example, you might have a ¥5/month plan\nthat provides limited access to your products, and a\n¥15/month plan that allows full access.\n\nRelated guide: [Managing Products and Plans](/docs/billing/subscriptions/products-and-plans).\n","section_tag":"plans","subsection_summaries":[{"anchor":"plan_object","curl_definition":null},{"anchor":"create_plan","curl_definition":"POST /v1/plans"},{"anchor":"retrieve_plan","curl_definition":"GET /v1/plans/:id"},{"anchor":"update_plan","curl_definition":"POST /v1/plans/:id"},{"anchor":"delete_plan","curl_definition":"DELETE /v1/plans/:id"},{"anchor":"list_plans","curl_definition":"GET /v1/plans"}]}},"plan_object":{"title":"The plan object","group_title":"Billing","group_anchor":"billing","anchor":"plan_object","section_anchor":"plans","subsection_anchors":null,"path":"/plans/object","gate":false,"display_on_load":false},"create_plan":{"title":"Create a plan","group_title":"Billing","group_anchor":"billing","anchor":"create_plan","section_anchor":"plans","subsection_anchors":null,"path":"/plans/create","gate":false,"display_on_load":false},"retrieve_plan":{"title":"Retrieve a plan","group_title":"Billing","group_anchor":"billing","anchor":"retrieve_plan","section_anchor":"plans","subsection_anchors":null,"path":"/plans/retrieve","gate":false,"display_on_load":false},"update_plan":{"title":"Update a plan","group_title":"Billing","group_anchor":"billing","anchor":"update_plan","section_anchor":"plans","subsection_anchors":null,"path":"/plans/update","gate":false,"display_on_load":false},"delete_plan":{"title":"Delete a plan","group_title":"Billing","group_anchor":"billing","anchor":"delete_plan","section_anchor":"plans","subsection_anchors":null,"path":"/plans/delete","gate":false,"display_on_load":false},"list_plans":{"title":"List all plans","group_title":"Billing","group_anchor":"billing","anchor":"list_plans","section_anchor":"plans","subsection_anchors":null,"path":"/plans/list","gate":false,"display_on_load":false},"service_products":{"title":"Products","group_title":"Billing","group_anchor":"billing","anchor":"service_products","section_anchor":"service_products","subsection_anchors":["service_product_object","create_service_product","retrieve_service_product","update_service_product","list_service_products","delete_service_product"],"path":"/service_products","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Products","description":"`Product` objects describe items that your customers can subscribe to with a\n`Subscription`. An associated `Plan` determines the product pricing.\n\nDocumentation on products for use with the [Orders API](/docs/api#orders) can\nbe found at [Products](#products).\n\nRelated guide: [Managing Products and Plans](/docs/billing/subscriptions/products-and-plans#products).\n","section_tag":"service_products","subsection_summaries":[{"anchor":"service_product_object","curl_definition":null},{"anchor":"create_service_product","curl_definition":"POST /v1/products"},{"anchor":"retrieve_service_product","curl_definition":"GET /v1/products/:id"},{"anchor":"update_service_product","curl_definition":"POST /v1/products/:id"},{"anchor":"list_service_products","curl_definition":"GET /v1/products"},{"anchor":"delete_service_product","curl_definition":"DELETE /v1/products/:id"}]}},"service_product_object":{"title":"The product object","group_title":"Billing","group_anchor":"billing","anchor":"service_product_object","section_anchor":"service_products","subsection_anchors":null,"path":"/service_products/object","gate":false,"display_on_load":false},"create_service_product":{"title":"Create a product","group_title":"Billing","group_anchor":"billing","anchor":"create_service_product","section_anchor":"service_products","subsection_anchors":null,"path":"/service_products/create","gate":false,"display_on_load":false},"retrieve_service_product":{"title":"Retrieve a product","group_title":"Billing","group_anchor":"billing","anchor":"retrieve_service_product","section_anchor":"service_products","subsection_anchors":null,"path":"/service_products/retrieve","gate":false,"display_on_load":false},"update_service_product":{"title":"Update a product","group_title":"Billing","group_anchor":"billing","anchor":"update_service_product","section_anchor":"service_products","subsection_anchors":null,"path":"/service_products/update","gate":false,"display_on_load":false},"list_service_products":{"title":"List all products","group_title":"Billing","group_anchor":"billing","anchor":"list_service_products","section_anchor":"service_products","subsection_anchors":null,"path":"/service_products/list","gate":false,"display_on_load":false},"delete_service_product":{"title":"Delete a product","group_title":"Billing","group_anchor":"billing","anchor":"delete_service_product","section_anchor":"service_products","subsection_anchors":null,"path":"/service_products/delete","gate":false,"display_on_load":false},"subscriptions":{"title":"Subscriptions","group_title":"Billing","group_anchor":"billing","anchor":"subscriptions","section_anchor":"subscriptions","subsection_anchors":["subscription_object","create_subscription","retrieve_subscription","update_subscription","cancel_subscription","list_subscriptions"],"path":"/subscriptions","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Subscriptions","description":"Subscriptions allow you to charge a customer on a recurring basis.\n\nRelated guide: [Creating Subscriptions](/docs/billing/subscriptions/creating).\n","section_tag":"subscriptions","subsection_summaries":[{"anchor":"subscription_object","curl_definition":null},{"anchor":"create_subscription","curl_definition":"POST /v1/subscriptions"},{"anchor":"retrieve_subscription","curl_definition":"GET /v1/subscriptions/:id"},{"anchor":"update_subscription","curl_definition":"POST /v1/subscriptions/:id"},{"anchor":"cancel_subscription","curl_definition":"DELETE /v1/subscriptions/:id"},{"anchor":"list_subscriptions","curl_definition":"GET /v1/subscriptions"}]}},"subscription_object":{"title":"The subscription object","group_title":"Billing","group_anchor":"billing","anchor":"subscription_object","section_anchor":"subscriptions","subsection_anchors":null,"path":"/subscriptions/object","gate":false,"display_on_load":false},"create_subscription":{"title":"Create a subscription","group_title":"Billing","group_anchor":"billing","anchor":"create_subscription","section_anchor":"subscriptions","subsection_anchors":null,"path":"/subscriptions/create","gate":false,"display_on_load":false},"retrieve_subscription":{"title":"Retrieve a subscription","group_title":"Billing","group_anchor":"billing","anchor":"retrieve_subscription","section_anchor":"subscriptions","subsection_anchors":null,"path":"/subscriptions/retrieve","gate":false,"display_on_load":false},"update_subscription":{"title":"Update a subscription","group_title":"Billing","group_anchor":"billing","anchor":"update_subscription","section_anchor":"subscriptions","subsection_anchors":null,"path":"/subscriptions/update","gate":false,"display_on_load":false},"cancel_subscription":{"title":"Cancel a subscription","group_title":"Billing","group_anchor":"billing","anchor":"cancel_subscription","section_anchor":"subscriptions","subsection_anchors":null,"path":"/subscriptions/cancel","gate":false,"display_on_load":false},"list_subscriptions":{"title":"List subscriptions","group_title":"Billing","group_anchor":"billing","anchor":"list_subscriptions","section_anchor":"subscriptions","subsection_anchors":null,"path":"/subscriptions/list","gate":false,"display_on_load":false},"subscription_items":{"title":"Subscription Items","group_title":"Billing","group_anchor":"billing","anchor":"subscription_items","section_anchor":"subscription_items","subsection_anchors":["subscription_item_object","create_subscription_item","retrieve_subscription_item","update_subscription_item","delete_subscription_item","list_subscription_items"],"path":"/subscription_items","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Subscription Items","description":"Subscription items allow you to create customer subscriptions with more than\none plan, making it easy to represent complex billing relationships.\n","section_tag":"subscription_items","subsection_summaries":[{"anchor":"subscription_item_object","curl_definition":null},{"anchor":"create_subscription_item","curl_definition":"POST /v1/subscription_items"},{"anchor":"retrieve_subscription_item","curl_definition":"GET /v1/subscription_items/:id"},{"anchor":"update_subscription_item","curl_definition":"POST /v1/subscription_items/:id"},{"anchor":"delete_subscription_item","curl_definition":"DELETE /v1/subscription_items/:id"},{"anchor":"list_subscription_items","curl_definition":"GET /v1/subscription_items"}]}},"subscription_item_object":{"title":"The subscription item object","group_title":"Billing","group_anchor":"billing","anchor":"subscription_item_object","section_anchor":"subscription_items","subsection_anchors":null,"path":"/subscription_items/object","gate":false,"display_on_load":false},"create_subscription_item":{"title":"Create a subscription item","group_title":"Billing","group_anchor":"billing","anchor":"create_subscription_item","section_anchor":"subscription_items","subsection_anchors":null,"path":"/subscription_items/create","gate":false,"display_on_load":false},"retrieve_subscription_item":{"title":"Retrieve a subscription item","group_title":"Billing","group_anchor":"billing","anchor":"retrieve_subscription_item","section_anchor":"subscription_items","subsection_anchors":null,"path":"/subscription_items/retrieve","gate":false,"display_on_load":false},"update_subscription_item":{"title":"Update a subscription item","group_title":"Billing","group_anchor":"billing","anchor":"update_subscription_item","section_anchor":"subscription_items","subsection_anchors":null,"path":"/subscription_items/update","gate":false,"display_on_load":false},"delete_subscription_item":{"title":"Delete a subscription item","group_title":"Billing","group_anchor":"billing","anchor":"delete_subscription_item","section_anchor":"subscription_items","subsection_anchors":null,"path":"/subscription_items/delete","gate":false,"display_on_load":false},"list_subscription_items":{"title":"List all subscription items","group_title":"Billing","group_anchor":"billing","anchor":"list_subscription_items","section_anchor":"subscription_items","subsection_anchors":null,"path":"/subscription_items/list","gate":false,"display_on_load":false},"subscription_schedules":{"title":"Subscription Schedules","group_title":"Billing","group_anchor":"billing","anchor":"subscription_schedules","section_anchor":"subscription_schedules","subsection_anchors":["subscription_schedule_object","create_subscription_schedule","retrieve_subscription_schedule","update_subscription_schedule","cancel_subscription_schedule","release_subscription_schedule","list_subscription_schedules"],"path":"/subscription_schedules","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Subscription Schedule","description":"A subscription schedule allows you to create and manage the lifecycle of a subscription by predefining expected changes.","section_tag":"subscription_schedules","subsection_summaries":[{"anchor":"subscription_schedule_object","curl_definition":null},{"anchor":"create_subscription_schedule","curl_definition":"POST /v1/subscription_schedules"},{"anchor":"retrieve_subscription_schedule","curl_definition":"GET /v1/subscription_schedules/:id"},{"anchor":"update_subscription_schedule","curl_definition":"POST /v1/subscription_schedules/:id"},{"anchor":"cancel_subscription_schedule","curl_definition":"POST /v1/subscription_schedules/:id/cancel"},{"anchor":"release_subscription_schedule","curl_definition":"POST /v1/subscription_schedules/:id/release"},{"anchor":"list_subscription_schedules","curl_definition":"GET /v1/subscription_schedules"}]}},"subscription_schedule_object":{"title":"The schedule object","group_title":"Billing","group_anchor":"billing","anchor":"subscription_schedule_object","section_anchor":"subscription_schedules","subsection_anchors":null,"path":"/subscription_schedules/object","gate":false,"display_on_load":false},"create_subscription_schedule":{"title":"Create a schedule","group_title":"Billing","group_anchor":"billing","anchor":"create_subscription_schedule","section_anchor":"subscription_schedules","subsection_anchors":null,"path":"/subscription_schedules/create","gate":false,"display_on_load":false},"retrieve_subscription_schedule":{"title":"Retrieve a schedule","group_title":"Billing","group_anchor":"billing","anchor":"retrieve_subscription_schedule","section_anchor":"subscription_schedules","subsection_anchors":null,"path":"/subscription_schedules/retrieve","gate":false,"display_on_load":false},"update_subscription_schedule":{"title":"Update a schedule","group_title":"Billing","group_anchor":"billing","anchor":"update_subscription_schedule","section_anchor":"subscription_schedules","subsection_anchors":null,"path":"/subscription_schedules/update","gate":false,"display_on_load":false},"cancel_subscription_schedule":{"title":"Cancel a schedule","group_title":"Billing","group_anchor":"billing","anchor":"cancel_subscription_schedule","section_anchor":"subscription_schedules","subsection_anchors":null,"path":"/subscription_schedules/cancel","gate":false,"display_on_load":false},"release_subscription_schedule":{"title":"Release a schedule","group_title":"Billing","group_anchor":"billing","anchor":"release_subscription_schedule","section_anchor":"subscription_schedules","subsection_anchors":null,"path":"/subscription_schedules/release","gate":false,"display_on_load":false},"list_subscription_schedules":{"title":"List all schedules","group_title":"Billing","group_anchor":"billing","anchor":"list_subscription_schedules","section_anchor":"subscription_schedules","subsection_anchors":null,"path":"/subscription_schedules/list","gate":false,"display_on_load":false},"tax_rates":{"title":"Tax Rates","group_title":"Billing","group_anchor":"billing","anchor":"tax_rates","section_anchor":"tax_rates","subsection_anchors":["tax_rate_object","create_tax_rate","retrieve_tax_rate","update_tax_rate","list_tax_rates"],"path":"/tax_rates","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Tax Rate","description":"Tax rates can be applied to invoices and subscriptions to collect tax.\n\nRelated guide: [Tax Rates](/docs/billing/taxes/tax-rates).\n","section_tag":"tax_rates","subsection_summaries":[{"anchor":"tax_rate_object","curl_definition":null},{"anchor":"create_tax_rate","curl_definition":"POST /v1/tax_rates"},{"anchor":"retrieve_tax_rate","curl_definition":"GET /v1/tax_rates/:id"},{"anchor":"update_tax_rate","curl_definition":"POST /v1/tax_rates/:id"},{"anchor":"list_tax_rates","curl_definition":"GET /v1/tax_rates"}]}},"tax_rate_object":{"title":"The tax rate object","group_title":"Billing","group_anchor":"billing","anchor":"tax_rate_object","section_anchor":"tax_rates","subsection_anchors":null,"path":"/tax_rates/object","gate":false,"display_on_load":false},"create_tax_rate":{"title":"Create a tax rate","group_title":"Billing","group_anchor":"billing","anchor":"create_tax_rate","section_anchor":"tax_rates","subsection_anchors":null,"path":"/tax_rates/create","gate":false,"display_on_load":false},"retrieve_tax_rate":{"title":"Retrieves a tax rate","group_title":"Billing","group_anchor":"billing","anchor":"retrieve_tax_rate","section_anchor":"tax_rates","subsection_anchors":null,"path":"/tax_rates/retrieve","gate":false,"display_on_load":false},"update_tax_rate":{"title":"Update a tax rate","group_title":"Billing","group_anchor":"billing","anchor":"update_tax_rate","section_anchor":"tax_rates","subsection_anchors":null,"path":"/tax_rates/update","gate":false,"display_on_load":false},"list_tax_rates":{"title":"List all tax rates","group_title":"Billing","group_anchor":"billing","anchor":"list_tax_rates","section_anchor":"tax_rates","subsection_anchors":null,"path":"/tax_rates/list","gate":false,"display_on_load":false},"usage_records":{"title":"Usage Records","group_title":"Billing","group_anchor":"billing","anchor":"usage_records","section_anchor":"usage_records","subsection_anchors":["usage_record_object","usage_record_create","usage_record_summary_all"],"path":"/usage_records","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Usage Records","description":"Usage records allow you to report customer usage and metrics to Stripe for\nmetered billing of subscription plans.\n\nRelated guide: [Metered Billing](/docs/billing/subscriptions/metered-billing).\n","section_tag":"usage_records","subsection_summaries":[{"anchor":"usage_record_object","curl_definition":null},{"anchor":"usage_record_create","curl_definition":"POST /v1/subscription_items/:id/usage_records"},{"anchor":"usage_record_summary_all","curl_definition":"GET /v1/subscription_items/:id/usage_record_summaries"}]}},"usage_record_object":{"title":"The usage record object","group_title":"Billing","group_anchor":"billing","anchor":"usage_record_object","section_anchor":"usage_records","subsection_anchors":null,"path":"/usage_records/object","gate":false,"display_on_load":false},"usage_record_create":{"title":"Create a usage record","group_title":"Billing","group_anchor":"billing","anchor":"usage_record_create","section_anchor":"usage_records","subsection_anchors":null,"path":"/usage_records/create","gate":false,"display_on_load":false},"usage_record_summary_all":{"title":"List all subscription item period summaries","group_title":"Billing","group_anchor":"billing","anchor":"usage_record_summary_all","section_anchor":"usage_records","subsection_anchors":null,"path":"/usage_records/subscription_item_summary_list","gate":false,"display_on_load":false},"accounts":{"title":"Accounts","group_title":"Connect","group_anchor":"connect","anchor":"accounts","section_anchor":"accounts","subsection_anchors":["account_object","create_account","retrieve_account","update_account","delete_account","reject_account","list_accounts","login_link_object","create_login_link"],"path":"/accounts","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Accounts","description":"This is an object representing a Stripe account. You can retrieve it to see\nproperties on the account like its current e-mail address or if the account is\nenabled yet to make live charges.\n\nSome properties, marked below, are available only to platforms that want to\n[create and manage Express or Custom accounts](/docs/connect/accounts).\n","section_tag":"accounts","subsection_summaries":[{"anchor":"account_object","curl_definition":null},{"anchor":"create_account","curl_definition":"POST /v1/accounts"},{"anchor":"retrieve_account","curl_definition":"GET /v1/accounts/:id"},{"anchor":"update_account","curl_definition":"POST /v1/accounts/:id"},{"anchor":"delete_account","curl_definition":"DELETE /v1/accounts/:id"},{"anchor":"reject_account","curl_definition":"POST /v1/accounts/:id/reject"},{"anchor":"list_accounts","curl_definition":"GET /v1/accounts"},{"anchor":"login_link_object","curl_definition":null},{"anchor":"create_login_link","curl_definition":"POST /v1/login_links"}]}},"account_object":{"title":"The account object","group_title":"Connect","group_anchor":"connect","anchor":"account_object","section_anchor":"accounts","subsection_anchors":null,"path":"/accounts/object","gate":false,"display_on_load":false},"create_account":{"title":"Create an account","group_title":"Connect","group_anchor":"connect","anchor":"create_account","section_anchor":"accounts","subsection_anchors":null,"path":"/accounts/create","gate":false,"display_on_load":false},"retrieve_account":{"title":"Retrieve account","group_title":"Connect","group_anchor":"connect","anchor":"retrieve_account","section_anchor":"accounts","subsection_anchors":null,"path":"/accounts/retrieve","gate":false,"display_on_load":false},"update_account":{"title":"Update an account","group_title":"Connect","group_anchor":"connect","anchor":"update_account","section_anchor":"accounts","subsection_anchors":null,"path":"/accounts/update","gate":false,"display_on_load":false},"delete_account":{"title":"Delete an account","group_title":"Connect","group_anchor":"connect","anchor":"delete_account","section_anchor":"accounts","subsection_anchors":null,"path":"/accounts/delete","gate":false,"display_on_load":false},"reject_account":{"title":"Reject an account","group_title":"Connect","group_anchor":"connect","anchor":"reject_account","section_anchor":"accounts","subsection_anchors":null,"path":"/account/reject","gate":false,"display_on_load":false},"list_accounts":{"title":"List all connected accounts","group_title":"Connect","group_anchor":"connect","anchor":"list_accounts","section_anchor":"accounts","subsection_anchors":null,"path":"/accounts/list","gate":false,"display_on_load":false},"login_link_object":{"title":"The login link object","group_title":"Connect","group_anchor":"connect","anchor":"login_link_object","section_anchor":"accounts","subsection_anchors":null,"path":"/account/login_link","gate":false,"display_on_load":false},"create_login_link":{"title":"Create a login link","group_title":"Connect","group_anchor":"connect","anchor":"create_login_link","section_anchor":"accounts","subsection_anchors":null,"path":"/account/create_login_link","gate":false,"display_on_load":false},"account_links":{"title":"Account Links","group_title":"Connect","group_anchor":"connect","anchor":"account_links","section_anchor":"account_links","subsection_anchors":["account_link_object","create_account_link"],"path":"/account_links","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Account Links","description":"Account Links are the means by which a Connect platform grants a connected account permission to access\nStripe-hosted applications, such as Connect Onboarding.\n\nRelated guide: [Connect Onboarding](/docs/connect/connect-onboarding).\n","section_tag":"account_links","subsection_summaries":[{"anchor":"account_link_object","curl_definition":null},{"anchor":"create_account_link","curl_definition":"POST /v1/account_links"}]}},"account_link_object":{"title":"The account link object","group_title":"Connect","group_anchor":"connect","anchor":"account_link_object","section_anchor":"account_links","subsection_anchors":null,"path":"/account_links/object","gate":false,"display_on_load":false},"create_account_link":{"title":"Create an account link","group_title":"Connect","group_anchor":"connect","anchor":"create_account_link","section_anchor":"account_links","subsection_anchors":null,"path":"/account_links/create","gate":false,"display_on_load":false},"application_fees":{"title":"Application Fees","group_title":"Connect","group_anchor":"connect","anchor":"application_fees","section_anchor":"application_fees","subsection_anchors":["application_fee_object","retrieve_application_fee","list_application_fees"],"path":"/application_fees","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Application Fees","description":"When you collect a transaction fee on top of a charge made for your user\n(using [Connect](/docs/connect)), an `Application Fee` object is created in\nyour account. You can list, retrieve, and refund application fees.\n\nRelated guide: [Collecting Application Fees](/docs/connect/direct-charges#collecting-fees).\n","section_tag":"application_fees","subsection_summaries":[{"anchor":"application_fee_object","curl_definition":null},{"anchor":"retrieve_application_fee","curl_definition":"GET /v1/application_fees/:id"},{"anchor":"list_application_fees","curl_definition":"GET /v1/application_fees"}]}},"application_fee_object":{"title":"The application fee object","group_title":"Connect","group_anchor":"connect","anchor":"application_fee_object","section_anchor":"application_fees","subsection_anchors":null,"path":"/application_fees/object","gate":false,"display_on_load":false},"retrieve_application_fee":{"title":"Retrieve an application fee","group_title":"Connect","group_anchor":"connect","anchor":"retrieve_application_fee","section_anchor":"application_fees","subsection_anchors":null,"path":"/application_fees/retrieve","gate":false,"display_on_load":false},"list_application_fees":{"title":"List all application fees","group_title":"Connect","group_anchor":"connect","anchor":"list_application_fees","section_anchor":"application_fees","subsection_anchors":null,"path":"/application_fees/list","gate":false,"display_on_load":false},"fee_refunds":{"title":"Application Fee Refunds","group_title":"Connect","group_anchor":"connect","anchor":"fee_refunds","section_anchor":"fee_refunds","subsection_anchors":["fee_refund_object","create_fee_refund","retrieve_fee_refund","update_fee_refund","list_fee_refunds"],"path":"/fee_refunds","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Application Fee Refunds","description":"`Application Fee Refund` objects allow you to refund an application fee that\nhas previously been created but not yet refunded. Funds will be refunded to\nthe Stripe account from which the fee was originally collected.\n\nRelated guide: [Refunding Application Fees](/docs/connect/destination-charges#refunding-app-fee).\n","section_tag":"fee_refunds","subsection_summaries":[{"anchor":"fee_refund_object","curl_definition":null},{"anchor":"create_fee_refund","curl_definition":"POST /v1/application_fees/:id/refunds"},{"anchor":"retrieve_fee_refund","curl_definition":"GET /v1/application_fees/:id/refunds/:id"},{"anchor":"update_fee_refund","curl_definition":"POST /v1/application_fees/:id/refunds/:id"},{"anchor":"list_fee_refunds","curl_definition":"GET /v1/application_fees/:id/refunds"}]}},"fee_refund_object":{"title":"The application fee refund object","group_title":"Connect","group_anchor":"connect","anchor":"fee_refund_object","section_anchor":"fee_refunds","subsection_anchors":null,"path":"/fee_refunds/object","gate":false,"display_on_load":false},"create_fee_refund":{"title":"Create an application fee refund","group_title":"Connect","group_anchor":"connect","anchor":"create_fee_refund","section_anchor":"fee_refunds","subsection_anchors":null,"path":"/fee_refunds/create","gate":false,"display_on_load":false},"retrieve_fee_refund":{"title":"Retrieve an application fee refund","group_title":"Connect","group_anchor":"connect","anchor":"retrieve_fee_refund","section_anchor":"fee_refunds","subsection_anchors":null,"path":"/fee_refunds/retrieve","gate":false,"display_on_load":false},"update_fee_refund":{"title":"Update an application fee refund","group_title":"Connect","group_anchor":"connect","anchor":"update_fee_refund","section_anchor":"fee_refunds","subsection_anchors":null,"path":"/fee_refunds/update","gate":false,"display_on_load":false},"list_fee_refunds":{"title":"List all application fee refunds","group_title":"Connect","group_anchor":"connect","anchor":"list_fee_refunds","section_anchor":"fee_refunds","subsection_anchors":null,"path":"/fee_refunds/list","gate":false,"display_on_load":false},"capabilities":{"title":"Capabilities","group_title":"Connect","group_anchor":"connect","anchor":"capabilities","section_anchor":"capabilities","subsection_anchors":["capability_object","retrieve_capability","update_capability","list_capability"],"path":"/capabilities","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Capabilities","description":"This is an object representing a capability for a Stripe account.\n\nRelated guide: [Capabilities Overview](/docs/connect/capabilities-overview).\n","section_tag":"capabilities","subsection_summaries":[{"anchor":"capability_object","curl_definition":null},{"anchor":"retrieve_capability","curl_definition":"GET /v1/accounts/:id/capabilities/:id"},{"anchor":"update_capability","curl_definition":"POST /v1/accounts/:id/capabilities/:id"},{"anchor":"list_capability","curl_definition":"GET /v1/accounts/:id/capabilities"}]}},"capability_object":{"title":"The capability object","group_title":"Connect","group_anchor":"connect","anchor":"capability_object","section_anchor":"capabilities","subsection_anchors":null,"path":"/capabilities/object","gate":false,"display_on_load":false},"retrieve_capability":{"title":"Retrieve an Account Capability","group_title":"Connect","group_anchor":"connect","anchor":"retrieve_capability","section_anchor":"capabilities","subsection_anchors":null,"path":"/capabilities/retrieve","gate":false,"display_on_load":false},"update_capability":{"title":"Update an Account Capability","group_title":"Connect","group_anchor":"connect","anchor":"update_capability","section_anchor":"capabilities","subsection_anchors":null,"path":"/capabilities/update","gate":false,"display_on_load":false},"list_capability":{"title":"List all account capabilities","group_title":"Connect","group_anchor":"connect","anchor":"list_capability","section_anchor":"capabilities","subsection_anchors":null,"path":"/capabilities/list","gate":false,"display_on_load":false},"country_specs":{"title":"Country Specs","group_title":"Connect","group_anchor":"connect","anchor":"country_specs","section_anchor":"country_specs","subsection_anchors":["country_spec_object","list_country_specs","retrieve_country_spec"],"path":"/country_specs","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Country Specs","description":"Stripe needs to collect certain pieces of information about each account\ncreated. These requirements can differ depending on the account's country. The\nCountry Specs API makes these rules available to your integration.\n\nYou can also view the information from this API call as [an online\nguide](/docs/connect/required-verification-information).\n","section_tag":"country_specs","subsection_summaries":[{"anchor":"country_spec_object","curl_definition":null},{"anchor":"list_country_specs","curl_definition":"GET /v1/country_specs"},{"anchor":"retrieve_country_spec","curl_definition":"GET /v1/country_specs/:id"}]}},"country_spec_object":{"title":"The country spec object","group_title":"Connect","group_anchor":"connect","anchor":"country_spec_object","section_anchor":"country_specs","subsection_anchors":null,"path":"/country_specs/object","gate":false,"display_on_load":false},"list_country_specs":{"title":"List Country Specs","group_title":"Connect","group_anchor":"connect","anchor":"list_country_specs","section_anchor":"country_specs","subsection_anchors":null,"path":"/country_specs/list","gate":false,"display_on_load":false},"retrieve_country_spec":{"title":"Retrieve a Country Spec","group_title":"Connect","group_anchor":"connect","anchor":"retrieve_country_spec","section_anchor":"country_specs","subsection_anchors":null,"path":"/country_specs/retrieve","gate":false,"display_on_load":false},"external_accounts":{"title":"External Accounts","group_title":"Connect","group_anchor":"connect","anchor":"external_accounts","section_anchor":"external_accounts","subsection_anchors":["account_bank_account_object","account_create_bank_account","account_retrieve_bank_account","account_update_bank_account","account_delete_bank_account","account_list_bank_accounts","account_card_object","account_create_card","account_retrieve_card","account_update_card","account_delete_card","account_list_cards"],"path":"/external_accounts","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"External Accounts","description":"These External Accounts are transfer destinations on `Account` objects for\n[Custom accounts](/docs/connect/custom-accounts). They can be bank accounts or\ndebit cards.\n\n[Bank accounts](/docs/api#customer_bank_account_object) and [debit\ncards](/docs/api#card_object) can also be used as payment sources\non regular charges, and are documented in the links above.\n\nRelated guide: [Setting Bank and Debit Card Payouts](/docs/connect/payouts).\n","section_tag":"external_accounts","subsection_summaries":[{"anchor":"account_bank_account_object","curl_definition":null},{"anchor":"account_create_bank_account","curl_definition":"POST /v1/accounts/:id/external_accounts"},{"anchor":"account_retrieve_bank_account","curl_definition":"GET /v1/accounts/:id/external_accounts/:id"},{"anchor":"account_update_bank_account","curl_definition":"POST /v1/accounts/:id/external_accounts/:id"},{"anchor":"account_delete_bank_account","curl_definition":"DELETE /v1/accounts/:id/external_accounts/:id"},{"anchor":"account_list_bank_accounts","curl_definition":"GET /v1/accounts/:id/external_accounts?object=bank_account"},{"anchor":"account_card_object","curl_definition":null},{"anchor":"account_create_card","curl_definition":"POST /v1/accounts/:id/external_accounts"},{"anchor":"account_retrieve_card","curl_definition":"GET /v1/accounts/:id/external_accounts/:id"},{"anchor":"account_update_card","curl_definition":"POST /v1/accounts/:id/external_accounts/:id"},{"anchor":"account_delete_card","curl_definition":"DELETE /v1/accounts/:id/external_accounts/:id"},{"anchor":"account_list_cards","curl_definition":"GET /v1/accounts/:id/external_accounts?object=card"}]}},"account_bank_account_object":{"title":"The (account) bank account object","group_title":"Connect","group_anchor":"connect","anchor":"account_bank_account_object","section_anchor":"external_accounts","subsection_anchors":null,"path":"/external_account_bank_accounts/object","gate":false,"display_on_load":false},"account_create_bank_account":{"title":"Create a bank account","group_title":"Connect","group_anchor":"connect","anchor":"account_create_bank_account","section_anchor":"external_accounts","subsection_anchors":null,"path":"/external_account_bank_accounts/create","gate":false,"display_on_load":false},"account_retrieve_bank_account":{"title":"Retrieve a bank account","group_title":"Connect","group_anchor":"connect","anchor":"account_retrieve_bank_account","section_anchor":"external_accounts","subsection_anchors":null,"path":"/external_account_bank_accounts/retrieve","gate":false,"display_on_load":false},"account_update_bank_account":{"title":"Update a bank account","group_title":"Connect","group_anchor":"connect","anchor":"account_update_bank_account","section_anchor":"external_accounts","subsection_anchors":null,"path":"/external_account_bank_accounts/update","gate":false,"display_on_load":false},"account_delete_bank_account":{"title":"Delete a bank account","group_title":"Connect","group_anchor":"connect","anchor":"account_delete_bank_account","section_anchor":"external_accounts","subsection_anchors":null,"path":"/external_account_bank_accounts/delete","gate":false,"display_on_load":false},"account_list_bank_accounts":{"title":"List all bank accounts","group_title":"Connect","group_anchor":"connect","anchor":"account_list_bank_accounts","section_anchor":"external_accounts","subsection_anchors":null,"path":"/external_account_bank_accounts/list","gate":false,"display_on_load":false},"account_card_object":{"title":"The (account) card object","group_title":"Connect","group_anchor":"connect","anchor":"account_card_object","section_anchor":"external_accounts","subsection_anchors":null,"path":"/external_account_cards/object","gate":false,"display_on_load":false},"account_create_card":{"title":"Create a card","group_title":"Connect","group_anchor":"connect","anchor":"account_create_card","section_anchor":"external_accounts","subsection_anchors":null,"path":"/external_account_cards/create","gate":false,"display_on_load":false},"account_retrieve_card":{"title":"Retrieve a card","group_title":"Connect","group_anchor":"connect","anchor":"account_retrieve_card","section_anchor":"external_accounts","subsection_anchors":null,"path":"/external_account_cards/retrieve","gate":false,"display_on_load":false},"account_update_card":{"title":"Update a card","group_title":"Connect","group_anchor":"connect","anchor":"account_update_card","section_anchor":"external_accounts","subsection_anchors":null,"path":"/external_account_cards/update","gate":false,"display_on_load":false},"account_delete_card":{"title":"Delete a card","group_title":"Connect","group_anchor":"connect","anchor":"account_delete_card","section_anchor":"external_accounts","subsection_anchors":null,"path":"/external_account_cards/delete","gate":false,"display_on_load":false},"account_list_cards":{"title":"List all cards","group_title":"Connect","group_anchor":"connect","anchor":"account_list_cards","section_anchor":"external_accounts","subsection_anchors":null,"path":"/external_account_cards/list","gate":false,"display_on_load":false},"persons":{"title":"Persons","group_title":"Connect","group_anchor":"connect","anchor":"persons","section_anchor":"persons","subsection_anchors":["person_object","create_person","retrieve_person","update_person","delete_person","list_person"],"path":"/persons","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Person","description":"This is an object representing a person associated with a Stripe account.\n\nRelated guide: [Handling Identity Verification with the API](/docs/connect/identity-verification-api#person-information).\n","section_tag":"persons","subsection_summaries":[{"anchor":"person_object","curl_definition":null},{"anchor":"create_person","curl_definition":"POST /v1/accounts/:id/persons"},{"anchor":"retrieve_person","curl_definition":"GET /v1/accounts/:id/persons/:id"},{"anchor":"update_person","curl_definition":"POST /v1/accounts/:id/persons/:id"},{"anchor":"delete_person","curl_definition":"DELETE /v1/accounts/:id/persons/:id"},{"anchor":"list_person","curl_definition":"GET /v1/accounts/:id/persons"}]}},"person_object":{"title":"The person object","group_title":"Connect","group_anchor":"connect","anchor":"person_object","section_anchor":"persons","subsection_anchors":null,"path":"/persons/object","gate":false,"display_on_load":false},"create_person":{"title":"Create a person","group_title":"Connect","group_anchor":"connect","anchor":"create_person","section_anchor":"persons","subsection_anchors":null,"path":"/persons/create","gate":false,"display_on_load":false},"retrieve_person":{"title":"Retrieve a person","group_title":"Connect","group_anchor":"connect","anchor":"retrieve_person","section_anchor":"persons","subsection_anchors":null,"path":"/persons/retrieve","gate":false,"display_on_load":false},"update_person":{"title":"Update a person","group_title":"Connect","group_anchor":"connect","anchor":"update_person","section_anchor":"persons","subsection_anchors":null,"path":"/persons/update","gate":false,"display_on_load":false},"delete_person":{"title":"Delete a person","group_title":"Connect","group_anchor":"connect","anchor":"delete_person","section_anchor":"persons","subsection_anchors":null,"path":"/persons/delete","gate":false,"display_on_load":false},"list_person":{"title":"List all persons","group_title":"Connect","group_anchor":"connect","anchor":"list_person","section_anchor":"persons","subsection_anchors":null,"path":"/persons/list","gate":false,"display_on_load":false},"topups":{"title":"Top-ups","group_title":"Connect","group_anchor":"connect","anchor":"topups","section_anchor":"topups","subsection_anchors":["topup_object","create_topup","retrieve_topup","update_topup","list_topups","cancel_topup"],"path":"/topups","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Top-ups","description":"To top up your Stripe balance, you create a top-up object. You can retrieve\nindividual top-ups, as well as list all top-ups. Top-ups are identified by a\nunique, random ID.\n\nRelated guide: [Topping Up your Platform Account](/docs/connect/top-ups).\n","section_tag":"topups","subsection_summaries":[{"anchor":"topup_object","curl_definition":null},{"anchor":"create_topup","curl_definition":"POST /v1/topups"},{"anchor":"retrieve_topup","curl_definition":"GET /v1/topups/:id"},{"anchor":"update_topup","curl_definition":"POST /v1/topups/:id"},{"anchor":"list_topups","curl_definition":"GET /v1/topups"},{"anchor":"cancel_topup","curl_definition":"POST /v1/topups/:id/cancel"}]}},"topup_object":{"title":"The top-up object","group_title":"Connect","group_anchor":"connect","anchor":"topup_object","section_anchor":"topups","subsection_anchors":null,"path":"/topups/object","gate":false,"display_on_load":false},"create_topup":{"title":"Create a top-up","group_title":"Connect","group_anchor":"connect","anchor":"create_topup","section_anchor":"topups","subsection_anchors":null,"path":"/topups/create","gate":false,"display_on_load":false},"retrieve_topup":{"title":"Retrieve a top-up","group_title":"Connect","group_anchor":"connect","anchor":"retrieve_topup","section_anchor":"topups","subsection_anchors":null,"path":"/topups/retrieve","gate":false,"display_on_load":false},"update_topup":{"title":"Update a top-up","group_title":"Connect","group_anchor":"connect","anchor":"update_topup","section_anchor":"topups","subsection_anchors":null,"path":"/topups/update","gate":false,"display_on_load":false},"list_topups":{"title":"List all top-ups","group_title":"Connect","group_anchor":"connect","anchor":"list_topups","section_anchor":"topups","subsection_anchors":null,"path":"/topups/list","gate":false,"display_on_load":false},"cancel_topup":{"title":"Cancel a top-up","group_title":"Connect","group_anchor":"connect","anchor":"cancel_topup","section_anchor":"topups","subsection_anchors":null,"path":"/topups/cancel","gate":false,"display_on_load":false},"transfers":{"title":"Transfers","group_title":"Connect","group_anchor":"connect","anchor":"transfers","section_anchor":"transfers","subsection_anchors":["transfer_object","create_transfer","retrieve_transfer","update_transfer","list_transfers"],"path":"/transfers","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Transfers","description":"A `Transfer` object is created when you move funds between Stripe accounts as\npart of Connect.\n\nBefore April 6, 2017, transfers also represented movement of funds from a\nStripe account to a card or bank account. This behavior has since been split\nout into a [Payout](#payout_object) object, with corresponding payout endpoints. For more\ninformation, read about the\n[transfer/payout split](/docs/transfer-payout-split).\n\nRelated guide: [Creating Separate Charges and Transfers](/docs/connect/charges-transfers).\n","section_tag":"transfers","subsection_summaries":[{"anchor":"transfer_object","curl_definition":null},{"anchor":"create_transfer","curl_definition":"POST /v1/transfers"},{"anchor":"retrieve_transfer","curl_definition":"GET /v1/transfers/:id"},{"anchor":"update_transfer","curl_definition":"POST /v1/transfers/:id"},{"anchor":"list_transfers","curl_definition":"GET /v1/transfers"}]}},"transfer_object":{"title":"The transfer object","group_title":"Connect","group_anchor":"connect","anchor":"transfer_object","section_anchor":"transfers","subsection_anchors":null,"path":"/transfers/object","gate":false,"display_on_load":false},"create_transfer":{"title":"Create a transfer","group_title":"Connect","group_anchor":"connect","anchor":"create_transfer","section_anchor":"transfers","subsection_anchors":null,"path":"/transfers/create","gate":false,"display_on_load":false},"retrieve_transfer":{"title":"Retrieve a transfer","group_title":"Connect","group_anchor":"connect","anchor":"retrieve_transfer","section_anchor":"transfers","subsection_anchors":null,"path":"/transfers/retrieve","gate":false,"display_on_load":false},"update_transfer":{"title":"Update a transfer","group_title":"Connect","group_anchor":"connect","anchor":"update_transfer","section_anchor":"transfers","subsection_anchors":null,"path":"/transfers/update","gate":false,"display_on_load":false},"list_transfers":{"title":"List all transfers","group_title":"Connect","group_anchor":"connect","anchor":"list_transfers","section_anchor":"transfers","subsection_anchors":null,"path":"/transfers/list","gate":false,"display_on_load":false},"transfer_reversals":{"title":"Transfer Reversals","group_title":"Connect","group_anchor":"connect","anchor":"transfer_reversals","section_anchor":"transfer_reversals","subsection_anchors":["transfer_reversal_object","create_transfer_reversal","retrieve_transfer_reversal","update_transfer_reversal","list_transfer_reversals"],"path":"/transfer_reversals","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Transfer Reversals","description":"[Stripe Connect](/docs/connect) platforms can reverse transfers made to a\nconnected account, either entirely or partially, and can also specify whether\nto refund any related application fees. Transfer reversals add to the\nplatform's balance and subtract from the destination account's balance.\n\nReversing a transfer that was made for a [destination\ncharge](/docs/connect/destination-charges) is allowed only up to the amount of\nthe charge. It is possible to reverse a\n[transfer_group](/docs/connect/charges-transfers#grouping-transactions)\ntransfer only if the destination account has enough balance to cover the\nreversal.\n\nRelated guide: [Reversing Transfers](/docs/connect/charges-transfers#reversing-transfers).\n","section_tag":"transfer_reversals","subsection_summaries":[{"anchor":"transfer_reversal_object","curl_definition":null},{"anchor":"create_transfer_reversal","curl_definition":"POST /v1/transfers/:id/reversals"},{"anchor":"retrieve_transfer_reversal","curl_definition":"GET /v1/transfers/:id/reversals/:id"},{"anchor":"update_transfer_reversal","curl_definition":"POST /v1/transfers/:id/reversals/:id"},{"anchor":"list_transfer_reversals","curl_definition":"GET /v1/transfers/:id/reversals"}]}},"transfer_reversal_object":{"title":"The transfer reversal object","group_title":"Connect","group_anchor":"connect","anchor":"transfer_reversal_object","section_anchor":"transfer_reversals","subsection_anchors":null,"path":"/transfer_reversals/object","gate":false,"display_on_load":false},"create_transfer_reversal":{"title":"Create a transfer reversal","group_title":"Connect","group_anchor":"connect","anchor":"create_transfer_reversal","section_anchor":"transfer_reversals","subsection_anchors":null,"path":"/transfer_reversals/create","gate":false,"display_on_load":false},"retrieve_transfer_reversal":{"title":"Retrieve a reversal","group_title":"Connect","group_anchor":"connect","anchor":"retrieve_transfer_reversal","section_anchor":"transfer_reversals","subsection_anchors":null,"path":"/transfer_reversals/retrieve","gate":false,"display_on_load":false},"update_transfer_reversal":{"title":"Update a reversal","group_title":"Connect","group_anchor":"connect","anchor":"update_transfer_reversal","section_anchor":"transfer_reversals","subsection_anchors":null,"path":"/transfer_reversals/update","gate":false,"display_on_load":false},"list_transfer_reversals":{"title":"List all reversals","group_title":"Connect","group_anchor":"connect","anchor":"list_transfer_reversals","section_anchor":"transfer_reversals","subsection_anchors":null,"path":"/transfer_reversals/list","gate":false,"display_on_load":false},"early_fraud_warnings":{"title":"Early Fraud Warnings","group_title":"Fraud","group_anchor":"fraud","anchor":"early_fraud_warnings","section_anchor":"early_fraud_warnings","subsection_anchors":["early_fraud_warning_object","retrieve_early_fraud_warning","list_early_fraud_warnings"],"path":"/radar/early_fraud_warnings","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Early Fraud Warning","description":"An early fraud warning indicates that the card issuer has notified us that a\ncharge may be fraudulent.\n\nRelated guide: [Early Fraud Warnings](/docs/disputes/measuring#early-fraud-warnings).\n","section_tag":"early_fraud_warnings","subsection_summaries":[{"anchor":"early_fraud_warning_object","curl_definition":null},{"anchor":"retrieve_early_fraud_warning","curl_definition":"GET /v1/radar/early_fraud_warnings/:id"},{"anchor":"list_early_fraud_warnings","curl_definition":"GET /v1/radar/early_fraud_warnings"}]}},"early_fraud_warning_object":{"title":"The early fraud warning object","group_title":"Fraud","group_anchor":"fraud","anchor":"early_fraud_warning_object","section_anchor":"early_fraud_warnings","subsection_anchors":null,"path":"/radar/early_fraud_warnings/object","gate":false,"display_on_load":false},"retrieve_early_fraud_warning":{"title":"Retrieve an early fraud warning","group_title":"Fraud","group_anchor":"fraud","anchor":"retrieve_early_fraud_warning","section_anchor":"early_fraud_warnings","subsection_anchors":null,"path":"/radar/early_fraud_warnings/retrieve","gate":false,"display_on_load":false},"list_early_fraud_warnings":{"title":"List all early fraud warnings","group_title":"Fraud","group_anchor":"fraud","anchor":"list_early_fraud_warnings","section_anchor":"early_fraud_warnings","subsection_anchors":null,"path":"/radar/early_fraud_warnings/list","gate":false,"display_on_load":false},"reviews":{"title":"Reviews","group_title":"Fraud","group_anchor":"fraud","anchor":"reviews","section_anchor":"reviews","subsection_anchors":["review_object","approve_review","retrieve_review","list_reviews"],"path":"/radar/reviews","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Reviews","description":"Reviews can be used to supplement automated fraud detection with human expertise.\n\nLearn more about [Radar](/radar) and reviewing payments\n[here](/docs/radar/reviews).\n","section_tag":"reviews","subsection_summaries":[{"anchor":"review_object","curl_definition":null},{"anchor":"approve_review","curl_definition":"POST /v1/reviews/:id/approve"},{"anchor":"retrieve_review","curl_definition":"GET /v1/reviews/:id"},{"anchor":"list_reviews","curl_definition":"GET /v1/reviews"}]}},"review_object":{"title":"The review object","group_title":"Fraud","group_anchor":"fraud","anchor":"review_object","section_anchor":"reviews","subsection_anchors":null,"path":"/radar/reviews/object","gate":false,"display_on_load":false},"approve_review":{"title":"Approve a review","group_title":"Fraud","group_anchor":"fraud","anchor":"approve_review","section_anchor":"reviews","subsection_anchors":null,"path":"/radar/reviews/approve","gate":false,"display_on_load":false},"retrieve_review":{"title":"Retrieve a review","group_title":"Fraud","group_anchor":"fraud","anchor":"retrieve_review","section_anchor":"reviews","subsection_anchors":null,"path":"/radar/reviews/retrieve","gate":false,"display_on_load":false},"list_reviews":{"title":"List all open reviews","group_title":"Fraud","group_anchor":"fraud","anchor":"list_reviews","section_anchor":"reviews","subsection_anchors":null,"path":"/radar/reviews/list","gate":false,"display_on_load":false},"value_lists":{"title":"Value Lists","group_title":"Fraud","group_anchor":"fraud","anchor":"value_lists","section_anchor":"value_lists","subsection_anchors":["radar_value_list_object","create_value_list","retrieve_value_list","update_value_list","delete_value_list","list_value_lists"],"path":"/radar/value_lists","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Value Lists","description":"Value lists allow you to group values together which can then be referenced in rules.\n\nRelated guide: [Default Stripe Lists](/docs/radar/lists#managing-list-items).\n","section_tag":"value_lists","subsection_summaries":[{"anchor":"radar_value_list_object","curl_definition":null},{"anchor":"create_value_list","curl_definition":"POST /v1/radar/value_lists"},{"anchor":"retrieve_value_list","curl_definition":"GET /v1/radar/value_lists/:id"},{"anchor":"update_value_list","curl_definition":"POST /v1/radar/value_lists/:id"},{"anchor":"delete_value_list","curl_definition":"DELETE /v1/radar/value_lists/:id"},{"anchor":"list_value_lists","curl_definition":"GET /v1/radar/value_lists"}]}},"radar_value_list_object":{"title":"The value list object","group_title":"Fraud","group_anchor":"fraud","anchor":"radar_value_list_object","section_anchor":"value_lists","subsection_anchors":null,"path":"/radar/value_lists/object","gate":false,"display_on_load":false},"create_value_list":{"title":"Create a value list","group_title":"Fraud","group_anchor":"fraud","anchor":"create_value_list","section_anchor":"value_lists","subsection_anchors":null,"path":"/radar/value_lists/create","gate":false,"display_on_load":false},"retrieve_value_list":{"title":"Retrieve a value list","group_title":"Fraud","group_anchor":"fraud","anchor":"retrieve_value_list","section_anchor":"value_lists","subsection_anchors":null,"path":"/radar/value_lists/retrieve","gate":false,"display_on_load":false},"update_value_list":{"title":"Update a value list","group_title":"Fraud","group_anchor":"fraud","anchor":"update_value_list","section_anchor":"value_lists","subsection_anchors":null,"path":"/radar/value_lists/update","gate":false,"display_on_load":false},"delete_value_list":{"title":"Delete a value list","group_title":"Fraud","group_anchor":"fraud","anchor":"delete_value_list","section_anchor":"value_lists","subsection_anchors":null,"path":"/radar/value_lists/delete","gate":false,"display_on_load":false},"list_value_lists":{"title":"List all value lists","group_title":"Fraud","group_anchor":"fraud","anchor":"list_value_lists","section_anchor":"value_lists","subsection_anchors":null,"path":"/radar/value_lists/list","gate":false,"display_on_load":false},"value_list_items":{"title":"Value List Items","group_title":"Fraud","group_anchor":"fraud","anchor":"value_list_items","section_anchor":"value_list_items","subsection_anchors":["radar_value_list_item_object","create_value_list_item","retrieve_value_list_item","delete_value_list_item","list_value_list_items"],"path":"/radar/value_list_items","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Value List Items","description":"Value list items allow you to add specific values to a given Radar value list, which can then be used in rules.\n\nRelated guide: [Managing List Items](/docs/radar/lists#managing-list-items).\n","section_tag":"value_list_items","subsection_summaries":[{"anchor":"radar_value_list_item_object","curl_definition":null},{"anchor":"create_value_list_item","curl_definition":"POST /v1/radar/value_list_items"},{"anchor":"retrieve_value_list_item","curl_definition":"GET /v1/radar/value_list_items/:id"},{"anchor":"delete_value_list_item","curl_definition":"DELETE /v1/radar/value_list_items/:id"},{"anchor":"list_value_list_items","curl_definition":"GET /v1/radar/value_list_items"}]}},"radar_value_list_item_object":{"title":"The value list item object","group_title":"Fraud","group_anchor":"fraud","anchor":"radar_value_list_item_object","section_anchor":"value_list_items","subsection_anchors":null,"path":"/radar/value_list_items/object","gate":false,"display_on_load":false},"create_value_list_item":{"title":"Create a value list item","group_title":"Fraud","group_anchor":"fraud","anchor":"create_value_list_item","section_anchor":"value_list_items","subsection_anchors":null,"path":"/radar/value_list_items/create","gate":false,"display_on_load":false},"retrieve_value_list_item":{"title":"Retrieve a value list item","group_title":"Fraud","group_anchor":"fraud","anchor":"retrieve_value_list_item","section_anchor":"value_list_items","subsection_anchors":null,"path":"/radar/value_list_items/retrieve","gate":false,"display_on_load":false},"delete_value_list_item":{"title":"Delete a value list item","group_title":"Fraud","group_anchor":"fraud","anchor":"delete_value_list_item","section_anchor":"value_list_items","subsection_anchors":null,"path":"/radar/value_list_items/delete","gate":false,"display_on_load":false},"list_value_list_items":{"title":"List all value list items","group_title":"Fraud","group_anchor":"fraud","anchor":"list_value_list_items","section_anchor":"value_list_items","subsection_anchors":null,"path":"/radar/value_list_items/list","gate":false,"display_on_load":false},"issuing_authorizations":{"title":"Authorizations","group_title":"Issuing","group_anchor":"issuing","anchor":"issuing_authorizations","section_anchor":"issuing_authorizations","subsection_anchors":["issuing_authorization_object","retrieve_issuing_authorization","update_issuing_authorization","approve_issuing_authorization","decline_issuing_authorization","list_issuing_authorizations"],"path":"/issuing/authorizations","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Authorizations","description":"When an [issued card](/docs/issuing) is used to make a purchase, an Issuing `Authorization`\nobject is created. [Authorizations](/docs/issuing/authorizations) must be approved for the\npurchase to be completed successfully.\n\nRelated guide: [Issued Card Authorizations](/docs/issuing/authorizations).\n","section_tag":"issuing_authorizations","subsection_summaries":[{"anchor":"issuing_authorization_object","curl_definition":null},{"anchor":"retrieve_issuing_authorization","curl_definition":"GET /v1/issuing/authorizations/:id"},{"anchor":"update_issuing_authorization","curl_definition":"POST /v1/issuing/authorizations/:id"},{"anchor":"approve_issuing_authorization","curl_definition":"POST /v1/issuing/authorizations/:id/approve"},{"anchor":"decline_issuing_authorization","curl_definition":"POST /v1/issuing/authorizations/:id/decline"},{"anchor":"list_issuing_authorizations","curl_definition":"GET /v1/issuing/authorizations"}]}},"issuing_authorization_object":{"title":"The Authorization object","group_title":"Issuing","group_anchor":"issuing","anchor":"issuing_authorization_object","section_anchor":"issuing_authorizations","subsection_anchors":null,"path":"/issuing/authorizations/object","gate":false,"display_on_load":false},"retrieve_issuing_authorization":{"title":"Retrieve an authorization","group_title":"Issuing","group_anchor":"issuing","anchor":"retrieve_issuing_authorization","section_anchor":"issuing_authorizations","subsection_anchors":null,"path":"/issuing/authorizations/retrieve","gate":false,"display_on_load":false},"update_issuing_authorization":{"title":"Update an authorization","group_title":"Issuing","group_anchor":"issuing","anchor":"update_issuing_authorization","section_anchor":"issuing_authorizations","subsection_anchors":null,"path":"/issuing/authorizations/update","gate":false,"display_on_load":false},"approve_issuing_authorization":{"title":"Approve an authorization","group_title":"Issuing","group_anchor":"issuing","anchor":"approve_issuing_authorization","section_anchor":"issuing_authorizations","subsection_anchors":null,"path":"/issuing/authorizations/approve","gate":false,"display_on_load":false},"decline_issuing_authorization":{"title":"Decline an authorization","group_title":"Issuing","group_anchor":"issuing","anchor":"decline_issuing_authorization","section_anchor":"issuing_authorizations","subsection_anchors":null,"path":"/issuing/authorizations/decline","gate":false,"display_on_load":false},"list_issuing_authorizations":{"title":"List all authorizations","group_title":"Issuing","group_anchor":"issuing","anchor":"list_issuing_authorizations","section_anchor":"issuing_authorizations","subsection_anchors":null,"path":"/issuing/authorizations/list","gate":false,"display_on_load":false},"issuing_cardholders":{"title":"Cardholders","group_title":"Issuing","group_anchor":"issuing","anchor":"issuing_cardholders","section_anchor":"issuing_cardholders","subsection_anchors":["issuing_cardholder_object","create_issuing_cardholder","retrieve_issuing_cardholder","update_issuing_cardholder","list_issuing_cardholders"],"path":"/issuing/cardholders","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Cardholders","description":"An Issuing `Cardholder` object represents an individual or business entity who is [issued](/docs/issuing) cards.\n\nRelated guide: [How to create a Cardholder](/docs/issuing/cards#create-cardholder)\n","section_tag":"issuing_cardholders","subsection_summaries":[{"anchor":"issuing_cardholder_object","curl_definition":null},{"anchor":"create_issuing_cardholder","curl_definition":"POST /v1/issuing/cardholders"},{"anchor":"retrieve_issuing_cardholder","curl_definition":"GET /v1/issuing/cardholders/:id"},{"anchor":"update_issuing_cardholder","curl_definition":"POST /v1/issuing/cardholders/:id"},{"anchor":"list_issuing_cardholders","curl_definition":"GET /v1/issuing/cardholders"}]}},"issuing_cardholder_object":{"title":"The Cardholder object","group_title":"Issuing","group_anchor":"issuing","anchor":"issuing_cardholder_object","section_anchor":"issuing_cardholders","subsection_anchors":null,"path":"/issuing/cardholders/object","gate":false,"display_on_load":false},"create_issuing_cardholder":{"title":"Create a cardholder","group_title":"Issuing","group_anchor":"issuing","anchor":"create_issuing_cardholder","section_anchor":"issuing_cardholders","subsection_anchors":null,"path":"/issuing/cardholders/create","gate":false,"display_on_load":false},"retrieve_issuing_cardholder":{"title":"Retrieve a cardholder","group_title":"Issuing","group_anchor":"issuing","anchor":"retrieve_issuing_cardholder","section_anchor":"issuing_cardholders","subsection_anchors":null,"path":"/issuing/cardholders/retrieve","gate":false,"display_on_load":false},"update_issuing_cardholder":{"title":"Update a cardholder","group_title":"Issuing","group_anchor":"issuing","anchor":"update_issuing_cardholder","section_anchor":"issuing_cardholders","subsection_anchors":null,"path":"/issuing/cardholders/update","gate":false,"display_on_load":false},"list_issuing_cardholders":{"title":"List all cardholders","group_title":"Issuing","group_anchor":"issuing","anchor":"list_issuing_cardholders","section_anchor":"issuing_cardholders","subsection_anchors":null,"path":"/issuing/cardholders/list","gate":false,"display_on_load":false},"issuing_cards":{"title":"Cards","group_title":"Issuing","group_anchor":"issuing","anchor":"issuing_cards","section_anchor":"issuing_cards","subsection_anchors":["issuing_card_object","create_issuing_card","retrieve_issuing_card","retrieve_issuing_card_details","update_issuing_card","list_issuing_cards"],"path":"/issuing/cards","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Cards","description":"You can [create physical or virtual cards](/docs/issuing/cards) that are issued to cardholders.","section_tag":"issuing_cards","subsection_summaries":[{"anchor":"issuing_card_object","curl_definition":null},{"anchor":"create_issuing_card","curl_definition":"POST /v1/issuing/cards"},{"anchor":"retrieve_issuing_card","curl_definition":"GET /v1/issuing/cards/:id"},{"anchor":"retrieve_issuing_card_details","curl_definition":"GET /v1/issuing/cards/:id/details"},{"anchor":"update_issuing_card","curl_definition":"POST /v1/issuing/cards/:id"},{"anchor":"list_issuing_cards","curl_definition":"GET /v1/issuing/cards"}]}},"issuing_card_object":{"title":"The Card object","group_title":"Issuing","group_anchor":"issuing","anchor":"issuing_card_object","section_anchor":"issuing_cards","subsection_anchors":null,"path":"/issuing/cards/object","gate":false,"display_on_load":false},"create_issuing_card":{"title":"Create a card","group_title":"Issuing","group_anchor":"issuing","anchor":"create_issuing_card","section_anchor":"issuing_cards","subsection_anchors":null,"path":"/issuing/cards/create","gate":false,"display_on_load":false},"retrieve_issuing_card":{"title":"Retrieve a card","group_title":"Issuing","group_anchor":"issuing","anchor":"retrieve_issuing_card","section_anchor":"issuing_cards","subsection_anchors":null,"path":"/issuing/cards/retrieve","gate":false,"display_on_load":false},"retrieve_issuing_card_details":{"title":"Retrieve card details","group_title":"Issuing","group_anchor":"issuing","anchor":"retrieve_issuing_card_details","section_anchor":"issuing_cards","subsection_anchors":null,"path":"/issuing/cards/retrieve_details","gate":false,"display_on_load":false},"update_issuing_card":{"title":"Update a card","group_title":"Issuing","group_anchor":"issuing","anchor":"update_issuing_card","section_anchor":"issuing_cards","subsection_anchors":null,"path":"/issuing/cards/update","gate":false,"display_on_load":false},"list_issuing_cards":{"title":"List all cards","group_title":"Issuing","group_anchor":"issuing","anchor":"list_issuing_cards","section_anchor":"issuing_cards","subsection_anchors":null,"path":"/issuing/cards/list","gate":false,"display_on_load":false},"issuing_disputes":{"title":"Disputes","group_title":"Issuing","group_anchor":"issuing","anchor":"issuing_disputes","section_anchor":"issuing_disputes","subsection_anchors":["issuing_dispute_object","create_issuing_dispute","retrieve_issuing_dispute","update_issuing_dispute","list_issuing_disputes"],"path":"/issuing/disputes","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Disputes","description":"As a [card issuer](/docs/issuing), you can [dispute](/docs/issuing/disputes) transactions that you do not recognize, suspect to be fraudulent, or have some other issue.\n\nRelated guide: [Disputing Transactions](/docs/issuing/disputes)\n","section_tag":"issuing_disputes","subsection_summaries":[{"anchor":"issuing_dispute_object","curl_definition":null},{"anchor":"create_issuing_dispute","curl_definition":"POST /v1/issuing/disputes"},{"anchor":"retrieve_issuing_dispute","curl_definition":"GET /v1/issuing/disputes/:id"},{"anchor":"update_issuing_dispute","curl_definition":"POST /v1/issuing/disputes/:id"},{"anchor":"list_issuing_disputes","curl_definition":"GET /v1/issuing/disputes"}]}},"issuing_dispute_object":{"title":"The Dispute object","group_title":"Issuing","group_anchor":"issuing","anchor":"issuing_dispute_object","section_anchor":"issuing_disputes","subsection_anchors":null,"path":"/issuing/disputes/object","gate":false,"display_on_load":false},"create_issuing_dispute":{"title":"Create a dispute","group_title":"Issuing","group_anchor":"issuing","anchor":"create_issuing_dispute","section_anchor":"issuing_disputes","subsection_anchors":null,"path":"/issuing/disputes/create","gate":false,"display_on_load":false},"retrieve_issuing_dispute":{"title":"Retrieve a dispute","group_title":"Issuing","group_anchor":"issuing","anchor":"retrieve_issuing_dispute","section_anchor":"issuing_disputes","subsection_anchors":null,"path":"/issuing/disputes/retrieve","gate":false,"display_on_load":false},"update_issuing_dispute":{"title":"Update a dispute","group_title":"Issuing","group_anchor":"issuing","anchor":"update_issuing_dispute","section_anchor":"issuing_disputes","subsection_anchors":null,"path":"/issuing/disputes/update","gate":false,"display_on_load":false},"list_issuing_disputes":{"title":"List all disputes","group_title":"Issuing","group_anchor":"issuing","anchor":"list_issuing_disputes","section_anchor":"issuing_disputes","subsection_anchors":null,"path":"/issuing/disputes/list","gate":false,"display_on_load":false},"issuing_transactions":{"title":"Transactions","group_title":"Issuing","group_anchor":"issuing","anchor":"issuing_transactions","section_anchor":"issuing_transactions","subsection_anchors":["issuing_transaction_object","retrieve_issuing_transaction","update_issuing_transaction","list_issuing_transactions"],"path":"/issuing/transactions","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Transactions","description":"Any use of an [issued card](/docs/issuing) that results in funds entering or leaving\nyour Stripe account, such as a completed purchase or refund, is represented by an Issuing\n`Transaction` object.\n\nRelated guide: [Issued Card Transactions](/docs/issuing/transactions).\n","section_tag":"issuing_transactions","subsection_summaries":[{"anchor":"issuing_transaction_object","curl_definition":null},{"anchor":"retrieve_issuing_transaction","curl_definition":"GET /v1/issuing/transactions/:id"},{"anchor":"update_issuing_transaction","curl_definition":"POST /v1/issuing/transactions/:id"},{"anchor":"list_issuing_transactions","curl_definition":"GET /v1/issuing/transactions"}]}},"issuing_transaction_object":{"title":"The Transaction object","group_title":"Issuing","group_anchor":"issuing","anchor":"issuing_transaction_object","section_anchor":"issuing_transactions","subsection_anchors":null,"path":"/issuing/transactions/object","gate":false,"display_on_load":false},"retrieve_issuing_transaction":{"title":"Retrieve a transaction","group_title":"Issuing","group_anchor":"issuing","anchor":"retrieve_issuing_transaction","section_anchor":"issuing_transactions","subsection_anchors":null,"path":"/issuing/transactions/retrieve","gate":false,"display_on_load":false},"update_issuing_transaction":{"title":"Update a transaction","group_title":"Issuing","group_anchor":"issuing","anchor":"update_issuing_transaction","section_anchor":"issuing_transactions","subsection_anchors":null,"path":"/issuing/transactions/update","gate":false,"display_on_load":false},"list_issuing_transactions":{"title":"List all transactions","group_title":"Issuing","group_anchor":"issuing","anchor":"list_issuing_transactions","section_anchor":"issuing_transactions","subsection_anchors":null,"path":"/issuing/transactions/list","gate":false,"display_on_load":false},"terminal_connection_tokens":{"title":"Connection Tokens","group_title":"Terminal","group_anchor":"terminal","anchor":"terminal_connection_tokens","section_anchor":"terminal_connection_tokens","subsection_anchors":["terminal_connection_token_object","create_terminal_connection_token"],"path":"/terminal/connection_tokens","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Connection Token","description":"A Connection Token is used by the Stripe Terminal SDK to connect to a reader.\n\nRelated guide: [Fleet Management](/docs/terminal/readers/fleet-management#create).\n","section_tag":"terminal_connection_tokens","subsection_summaries":[{"anchor":"terminal_connection_token_object","curl_definition":null},{"anchor":"create_terminal_connection_token","curl_definition":"POST /v1/terminal/connection_tokens"}]}},"terminal_connection_token_object":{"title":"The connection token object","group_title":"Terminal","group_anchor":"terminal","anchor":"terminal_connection_token_object","section_anchor":"terminal_connection_tokens","subsection_anchors":null,"path":"/terminal/connection_tokens/object","gate":false,"display_on_load":false},"create_terminal_connection_token":{"title":"Create a Connection Token","group_title":"Terminal","group_anchor":"terminal","anchor":"create_terminal_connection_token","section_anchor":"terminal_connection_tokens","subsection_anchors":null,"path":"/terminal/connection_tokens/create","gate":false,"display_on_load":false},"terminal_locations":{"title":"Locations","group_title":"Terminal","group_anchor":"terminal","anchor":"terminal_locations","section_anchor":"terminal_locations","subsection_anchors":["terminal_location_object","create_terminal_location","retrieve_terminal_location","update_terminal_location","delete_terminal_location","list_terminal_locations"],"path":"/terminal/locations","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Location","description":"A Location represents a grouping of readers.\n\nRelated guide: [Fleet Management](/docs/terminal/readers/fleet-management#create).\n","section_tag":"terminal_locations","subsection_summaries":[{"anchor":"terminal_location_object","curl_definition":null},{"anchor":"create_terminal_location","curl_definition":"POST /v1/terminal/locations"},{"anchor":"retrieve_terminal_location","curl_definition":"GET /v1/terminal/locations/:id"},{"anchor":"update_terminal_location","curl_definition":"POST /v1/terminal/locations/:id"},{"anchor":"delete_terminal_location","curl_definition":"DELETE /v1/terminal/locations/:id"},{"anchor":"list_terminal_locations","curl_definition":"GET /v1/terminal/locations"}]}},"terminal_location_object":{"title":"The location object","group_title":"Terminal","group_anchor":"terminal","anchor":"terminal_location_object","section_anchor":"terminal_locations","subsection_anchors":null,"path":"/terminal/locations/object","gate":false,"display_on_load":false},"create_terminal_location":{"title":"Create a Location","group_title":"Terminal","group_anchor":"terminal","anchor":"create_terminal_location","section_anchor":"terminal_locations","subsection_anchors":null,"path":"/terminal/locations/create","gate":false,"display_on_load":false},"retrieve_terminal_location":{"title":"Retrieve a Location","group_title":"Terminal","group_anchor":"terminal","anchor":"retrieve_terminal_location","section_anchor":"terminal_locations","subsection_anchors":null,"path":"/terminal/locations/retrieve","gate":false,"display_on_load":false},"update_terminal_location":{"title":"Update a Location","group_title":"Terminal","group_anchor":"terminal","anchor":"update_terminal_location","section_anchor":"terminal_locations","subsection_anchors":null,"path":"/terminal/locations/update","gate":false,"display_on_load":false},"delete_terminal_location":{"title":"Delete a Location","group_title":"Terminal","group_anchor":"terminal","anchor":"delete_terminal_location","section_anchor":"terminal_locations","subsection_anchors":null,"path":"/terminal/locations/delete","gate":false,"display_on_load":false},"list_terminal_locations":{"title":"List all Locations","group_title":"Terminal","group_anchor":"terminal","anchor":"list_terminal_locations","section_anchor":"terminal_locations","subsection_anchors":null,"path":"/terminal/locations/list","gate":false,"display_on_load":false},"terminal_readers":{"title":"Readers","group_title":"Terminal","group_anchor":"terminal","anchor":"terminal_readers","section_anchor":"terminal_readers","subsection_anchors":["terminal_reader_object","create_terminal_reader","retrieve_terminal_reader","update_terminal_reader","delete_terminal_reader","list_terminal_reader"],"path":"/terminal/readers","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Reader","description":"A Reader represents a physical device for accepting payment details.\n\nRelated guide: [Connecting to a Reader](/docs/terminal/readers/connecting).\n","section_tag":"terminal_readers","subsection_summaries":[{"anchor":"terminal_reader_object","curl_definition":null},{"anchor":"create_terminal_reader","curl_definition":"POST /v1/terminal/readers"},{"anchor":"retrieve_terminal_reader","curl_definition":"GET /v1/terminal/readers/:id"},{"anchor":"update_terminal_reader","curl_definition":"POST /v1/terminal/readers/:id"},{"anchor":"delete_terminal_reader","curl_definition":"DELETE /v1/terminal/readers/:id"},{"anchor":"list_terminal_reader","curl_definition":"GET /v1/terminal/readers"}]}},"terminal_reader_object":{"title":"The reader object","group_title":"Terminal","group_anchor":"terminal","anchor":"terminal_reader_object","section_anchor":"terminal_readers","subsection_anchors":null,"path":"/terminal/readers/object","gate":false,"display_on_load":false},"create_terminal_reader":{"title":"Create a Reader","group_title":"Terminal","group_anchor":"terminal","anchor":"create_terminal_reader","section_anchor":"terminal_readers","subsection_anchors":null,"path":"/terminal/readers/create","gate":false,"display_on_load":false},"retrieve_terminal_reader":{"title":"Retrieve a Reader","group_title":"Terminal","group_anchor":"terminal","anchor":"retrieve_terminal_reader","section_anchor":"terminal_readers","subsection_anchors":null,"path":"/terminal/readers/retrieve","gate":false,"display_on_load":false},"update_terminal_reader":{"title":"Update a Reader","group_title":"Terminal","group_anchor":"terminal","anchor":"update_terminal_reader","section_anchor":"terminal_readers","subsection_anchors":null,"path":"/terminal/readers/update","gate":false,"display_on_load":false},"delete_terminal_reader":{"title":"Delete a Reader","group_title":"Terminal","group_anchor":"terminal","anchor":"delete_terminal_reader","section_anchor":"terminal_readers","subsection_anchors":null,"path":"/terminal/readers/delete","gate":false,"display_on_load":false},"list_terminal_reader":{"title":"List all Readers","group_title":"Terminal","group_anchor":"terminal","anchor":"list_terminal_reader","section_anchor":"terminal_readers","subsection_anchors":null,"path":"/terminal/readers/list","gate":false,"display_on_load":false},"orders":{"title":"Orders","group_title":"Orders","group_anchor":"orders_api","anchor":"orders","section_anchor":"orders","subsection_anchors":["order_object","create_order","retrieve_order","update_order","pay_order","list_orders","return_order"],"path":"/orders","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Orders","description":"Order objects are created to handle end customers' purchases of previously\ndefined [products](#products). You can create, retrieve, and pay individual orders, as well\nas list all orders. Orders are identified by a unique, random ID.\n\nRelated guide: [Tax, Shipping, and Inventory](/docs/orders).\n","section_tag":"orders","subsection_summaries":[{"anchor":"order_object","curl_definition":null},{"anchor":"create_order","curl_definition":"POST /v1/orders"},{"anchor":"retrieve_order","curl_definition":"GET /v1/orders/:id"},{"anchor":"update_order","curl_definition":"POST /v1/orders/:id"},{"anchor":"pay_order","curl_definition":"POST /v1/orders/:id/pay"},{"anchor":"list_orders","curl_definition":"GET /v1/orders"},{"anchor":"return_order","curl_definition":"POST /v1/orders/:id/returns"}]}},"order_object":{"title":"The order object","group_title":"Orders","group_anchor":"orders_api","anchor":"order_object","section_anchor":"orders","subsection_anchors":null,"path":"/orders/object","gate":false,"display_on_load":false},"create_order":{"title":"Create an order","group_title":"Orders","group_anchor":"orders_api","anchor":"create_order","section_anchor":"orders","subsection_anchors":null,"path":"/orders/create","gate":false,"display_on_load":false},"retrieve_order":{"title":"Retrieve an order","group_title":"Orders","group_anchor":"orders_api","anchor":"retrieve_order","section_anchor":"orders","subsection_anchors":null,"path":"/orders/retrieve","gate":false,"display_on_load":false},"update_order":{"title":"Update an order","group_title":"Orders","group_anchor":"orders_api","anchor":"update_order","section_anchor":"orders","subsection_anchors":null,"path":"/orders/update","gate":false,"display_on_load":false},"pay_order":{"title":"Pay an order","group_title":"Orders","group_anchor":"orders_api","anchor":"pay_order","section_anchor":"orders","subsection_anchors":null,"path":"/orders/pay","gate":false,"display_on_load":false},"list_orders":{"title":"List all orders","group_title":"Orders","group_anchor":"orders_api","anchor":"list_orders","section_anchor":"orders","subsection_anchors":null,"path":"/orders/list","gate":false,"display_on_load":false},"return_order":{"title":"Return an order","group_title":"Orders","group_anchor":"orders_api","anchor":"return_order","section_anchor":"orders","subsection_anchors":null,"path":"/orders/return","gate":false,"display_on_load":false},"order_items":{"title":"Order Items","group_title":"Orders","group_anchor":"orders_api","anchor":"order_items","section_anchor":"order_items","subsection_anchors":["order_item_object"],"path":"/order_items","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Order Items","description":"A representation of the constituent items of any given order. Can be used to\nrepresent [SKUs](#skus), shipping costs, or taxes owed on the order.\n\nRelated guide: [Orders](/docs/orders/guide).\n","section_tag":"order_items","subsection_summaries":[{"anchor":"order_item_object","curl_definition":null}]}},"order_item_object":{"title":"The order item object","group_title":"Orders","group_anchor":"orders_api","anchor":"order_item_object","section_anchor":"order_items","subsection_anchors":null,"path":"/order_items/object","gate":false,"display_on_load":false},"order_returns":{"title":"Returns","group_title":"Orders","group_anchor":"orders_api","anchor":"order_returns","section_anchor":"order_returns","subsection_anchors":["order_return_object","retrieve_order_return","list_order_returns"],"path":"/order_returns","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Returns","description":"A return represents the full or partial return of a number of [order items](#order_items).\nReturns always belong to an order, and may optionally contain a refund.\n\nRelated guide: [Handling Returns](/docs/orders/guide#handling-returns).\n","section_tag":"order_returns","subsection_summaries":[{"anchor":"order_return_object","curl_definition":null},{"anchor":"retrieve_order_return","curl_definition":"GET /v1/order_returns/:id"},{"anchor":"list_order_returns","curl_definition":"GET /v1/order_returns"}]}},"order_return_object":{"title":"The return object","group_title":"Orders","group_anchor":"orders_api","anchor":"order_return_object","section_anchor":"order_returns","subsection_anchors":null,"path":"/order_returns/object","gate":false,"display_on_load":false},"retrieve_order_return":{"title":"Retrieve an order return","group_title":"Orders","group_anchor":"orders_api","anchor":"retrieve_order_return","section_anchor":"order_returns","subsection_anchors":null,"path":"/order_returns/retrieve","gate":false,"display_on_load":false},"list_order_returns":{"title":"List all order returns","group_title":"Orders","group_anchor":"orders_api","anchor":"list_order_returns","section_anchor":"order_returns","subsection_anchors":null,"path":"/order_returns/list","gate":false,"display_on_load":false},"skus":{"title":"SKUs","group_title":"Orders","group_anchor":"orders_api","anchor":"skus","section_anchor":"skus","subsection_anchors":["sku_object","create_sku","retrieve_sku","update_sku","list_skus","delete_sku"],"path":"/skus","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"SKUs","description":"Stores representations of [stock keeping units](http://en.wikipedia.org/wiki/Stock_keeping_unit).\nSKUs describe specific product variations, taking into account any combination of: attributes,\ncurrency, and cost. For example, a product may be a T-shirt, whereas a specific SKU represents\nthe `size: large`, `color: red` version of that shirt.\n\nCan also be used to manage inventory.\n\nRelated guide: [Tax, Shipping, and Inventory](/docs/orders).\n","section_tag":"skus","subsection_summaries":[{"anchor":"sku_object","curl_definition":null},{"anchor":"create_sku","curl_definition":"POST /v1/skus"},{"anchor":"retrieve_sku","curl_definition":"GET /v1/skus/:id"},{"anchor":"update_sku","curl_definition":"POST /v1/skus/:id"},{"anchor":"list_skus","curl_definition":"GET /v1/skus"},{"anchor":"delete_sku","curl_definition":"DELETE /v1/skus/:id"}]}},"sku_object":{"title":"The SKU object","group_title":"Orders","group_anchor":"orders_api","anchor":"sku_object","section_anchor":"skus","subsection_anchors":null,"path":"/skus/object","gate":false,"display_on_load":false},"create_sku":{"title":"Create a SKU","group_title":"Orders","group_anchor":"orders_api","anchor":"create_sku","section_anchor":"skus","subsection_anchors":null,"path":"/skus/create","gate":false,"display_on_load":false},"retrieve_sku":{"title":"Retrieve a SKU","group_title":"Orders","group_anchor":"orders_api","anchor":"retrieve_sku","section_anchor":"skus","subsection_anchors":null,"path":"/skus/retrieve","gate":false,"display_on_load":false},"update_sku":{"title":"Update a SKU","group_title":"Orders","group_anchor":"orders_api","anchor":"update_sku","section_anchor":"skus","subsection_anchors":null,"path":"/skus/update","gate":false,"display_on_load":false},"list_skus":{"title":"List all SKUs","group_title":"Orders","group_anchor":"orders_api","anchor":"list_skus","section_anchor":"skus","subsection_anchors":null,"path":"/skus/list","gate":false,"display_on_load":false},"delete_sku":{"title":"Delete a SKU","group_title":"Orders","group_anchor":"orders_api","anchor":"delete_sku","section_anchor":"skus","subsection_anchors":null,"path":"/skus/delete","gate":false,"display_on_load":false},"scheduled_queries":{"title":"Scheduled Queries","group_title":"Sigma","group_anchor":"sigma","anchor":"scheduled_queries","section_anchor":"scheduled_queries","subsection_anchors":["scheduled_query_run_object","retrieve_scheduled_query_run","list_scheduled_query_run"],"path":"/sigma/scheduled_queries","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Scheduled Queries","description":"If you have [scheduled a Sigma query](/docs/sigma/scheduled-queries), you'll\nreceive a `sigma.scheduled_query_run.created` webhook each time the query\nruns. The webhook contains a `ScheduledQueryRun` object, which you can use to\nretrieve the query results.\n","section_tag":"scheduled_queries","subsection_summaries":[{"anchor":"scheduled_query_run_object","curl_definition":null},{"anchor":"retrieve_scheduled_query_run","curl_definition":"GET /v1/sigma/scheduled_query_runs/:id"},{"anchor":"list_scheduled_query_run","curl_definition":"GET /v1/sigma/scheduled_query_runs"}]}},"scheduled_query_run_object":{"title":"The scheduled query run object","group_title":"Sigma","group_anchor":"sigma","anchor":"scheduled_query_run_object","section_anchor":"scheduled_queries","subsection_anchors":null,"path":"/sigma/scheduled_queries/object","gate":false,"display_on_load":false},"retrieve_scheduled_query_run":{"title":"Retrieve a scheduled query run","group_title":"Sigma","group_anchor":"sigma","anchor":"retrieve_scheduled_query_run","section_anchor":"scheduled_queries","subsection_anchors":null,"path":"/sigma/scheduled_queries/retrieve","gate":false,"display_on_load":false},"list_scheduled_query_run":{"title":"List all scheduled query runs","group_title":"Sigma","group_anchor":"sigma","anchor":"list_scheduled_query_run","section_anchor":"scheduled_queries","subsection_anchors":null,"path":"/sigma/scheduled_queries/list","gate":false,"display_on_load":false},"reporting_report_run":{"title":"Report Runs","group_title":"Reporting","group_anchor":"reporting","anchor":"reporting_report_run","section_anchor":"reporting_report_run","subsection_anchors":["reporting_report_run_object","create_reporting_report_run","retrieve_reporting_report_run","list_reporting_report_run"],"path":"/reporting/report_run","gate":true,"display_on_load":false,"data":{"section_type":"resource","title":"Report Runs","description":"The Report Run object represents an instance of a report type generated with\nspecific run parameters. Once the object is created, Stripe begins processing the report.\nWhen the report has finished running, it will give you a reference to a file\nwhere you can retrieve your results. For an overview, see\n[API Access to Reports](/docs/reporting/statements/api).\n\nNote that reports can only be run based on your live-mode data (not test-mode\ndata), and thus related requests must be made with a\n[live-mode API key](/docs/keys#test-live-modes).\n","section_tag":"reporting_report_run","subsection_summaries":[{"anchor":"reporting_report_run_object","curl_definition":null},{"anchor":"create_reporting_report_run","curl_definition":"POST /v1/reporting/report_runs"},{"anchor":"retrieve_reporting_report_run","curl_definition":"GET /v1/reporting/report_runs/:id"},{"anchor":"list_reporting_report_run","curl_definition":"GET /v1/reporting/report_runs"}]}},"reporting_report_run_object":{"title":"The Report Run object","group_title":"Reporting","group_anchor":"reporting","anchor":"reporting_report_run_object","section_anchor":"reporting_report_run","subsection_anchors":null,"path":"/reporting/report_run/object","gate":false,"display_on_load":false},"create_reporting_report_run":{"title":"Create a Report Run","group_title":"Reporting","group_anchor":"reporting","anchor":"create_reporting_report_run","section_anchor":"reporting_report_run","subsection_anchors":null,"path":"/reporting/report_run/create","gate":false,"display_on_load":false},"retrieve_reporting_report_run":{"title":"Retrieve a Report Run","group_title":"Reporting","group_anchor":"reporting","anchor":"retrieve_reporting_report_run","section_anchor":"reporting_report_run","subsection_anchors":null,"path":"/reporting/report_run/retrieve","gate":false,"display_on_load":false},"list_reporting_report_run":{"title":"List all Report Runs","group_title":"Reporting","group_anchor":"reporting","anchor":"list_reporting_report_run","section_anchor":"reporting_report_run","subsection_anchors":null,"path":"/reporting/report_run/list","gate":false,"display_on_load":false},"reporting_report_type":{"title":"Report Types","group_title":"Reporting","group_anchor":"reporting","anchor":"reporting_report_type","section_anchor":"reporting_report_type","subsection_anchors":["reporting_report_type_object","retrieve_reporting_report_type","list_reporting_report_type"],"path":"/reporting/report_type","gate":true,"display_on_load":false,"data":{"section_type":"resource","title":"Report Types","description":"The Report Type resource corresponds to a particular type of report, such as\nthe \"Activity summary\" or \"Itemized payouts\" reports. These objects are\nidentified by an ID belonging to a set of enumerated values. See\n[API Access to Reports documentation](/docs/reporting/statements/api)\nfor those Report Type IDs, along with required and optional parameters.\n\nNote that reports can only be run based on your live-mode data (not test-mode\ndata), and thus related requests must be made with a\n[live-mode API key](/docs/keys#test-live-modes).\n","section_tag":"reporting_report_type","subsection_summaries":[{"anchor":"reporting_report_type_object","curl_definition":null},{"anchor":"retrieve_reporting_report_type","curl_definition":"GET /v1/reporting/report_types/:id"},{"anchor":"list_reporting_report_type","curl_definition":"GET /v1/reporting/report_types"}]}},"reporting_report_type_object":{"title":"The Report Type object","group_title":"Reporting","group_anchor":"reporting","anchor":"reporting_report_type_object","section_anchor":"reporting_report_type","subsection_anchors":null,"path":"/reporting/report_type/object","gate":false,"display_on_load":false},"retrieve_reporting_report_type":{"title":"Retrieve a Report Type","group_title":"Reporting","group_anchor":"reporting","anchor":"retrieve_reporting_report_type","section_anchor":"reporting_report_type","subsection_anchors":null,"path":"/reporting/report_type/retrieve","gate":false,"display_on_load":false},"list_reporting_report_type":{"title":"List all Report Types","group_title":"Reporting","group_anchor":"reporting","anchor":"list_reporting_report_type","section_anchor":"reporting_report_type","subsection_anchors":null,"path":"/reporting/report_type/list","gate":false,"display_on_load":false},"webhook_endpoints":{"title":"Webhook Endpoints","group_title":"Webhooks","group_anchor":"webhooks","anchor":"webhook_endpoints","section_anchor":"webhook_endpoints","subsection_anchors":["webhook_endpoint_object","create_webhook_endpoint","retrieve_webhook_endpoint","update_webhook_endpoint","list_webhook_endpoints","delete_webhook_endpoints"],"path":"/webhook_endpoints","gate":false,"display_on_load":false,"data":{"section_type":"resource","title":"Webhook Endpoints","description":"You can configure [webhook endpoints](/docs/webhooks/) via the API to be\nnotified about events that happen in your Stripe account or connected\naccounts.\n\nMost users configure webhooks from [the dashboard](https://dashboard.stripe.com/webhooks), which provides a user interface for registering and testing your webhook endpoints.\n\nRelated guide: [Setting up Webhooks](/docs/webhooks/configure).\n","section_tag":"webhook_endpoints","subsection_summaries":[{"anchor":"webhook_endpoint_object","curl_definition":null},{"anchor":"create_webhook_endpoint","curl_definition":"POST /v1/webhook_endpoints"},{"anchor":"retrieve_webhook_endpoint","curl_definition":"GET /v1/webhook_endpoints/:id"},{"anchor":"update_webhook_endpoint","curl_definition":"POST /v1/webhook_endpoints/:id"},{"anchor":"list_webhook_endpoints","curl_definition":"GET /v1/webhook_endpoints"},{"anchor":"delete_webhook_endpoints","curl_definition":"DELETE /v1/webhook_endpoints/:id"}]}},"webhook_endpoint_object":{"title":"The webhook endpoint object","group_title":"Webhooks","group_anchor":"webhooks","anchor":"webhook_endpoint_object","section_anchor":"webhook_endpoints","subsection_anchors":null,"path":"/webhook_endpoints/object","gate":false,"display_on_load":false},"create_webhook_endpoint":{"title":"Create a webhook endpoint","group_title":"Webhooks","group_anchor":"webhooks","anchor":"create_webhook_endpoint","section_anchor":"webhook_endpoints","subsection_anchors":null,"path":"/webhook_endpoints/create","gate":false,"display_on_load":false},"retrieve_webhook_endpoint":{"title":"Retrieve a webhook endpoint","group_title":"Webhooks","group_anchor":"webhooks","anchor":"retrieve_webhook_endpoint","section_anchor":"webhook_endpoints","subsection_anchors":null,"path":"/webhook_endpoints/retrieve","gate":false,"display_on_load":false},"update_webhook_endpoint":{"title":"Update a webhook endpoint","group_title":"Webhooks","group_anchor":"webhooks","anchor":"update_webhook_endpoint","section_anchor":"webhook_endpoints","subsection_anchors":null,"path":"/webhook_endpoints/update","gate":false,"display_on_load":false},"list_webhook_endpoints":{"title":"List all webhook endpoints","group_title":"Webhooks","group_anchor":"webhooks","anchor":"list_webhook_endpoints","section_anchor":"webhook_endpoints","subsection_anchors":null,"path":"/webhook_endpoints/list","gate":false,"display_on_load":false},"delete_webhook_endpoints":{"title":"Delete a webhook endpoint","group_title":"Webhooks","group_anchor":"webhooks","anchor":"delete_webhook_endpoints","section_anchor":"webhook_endpoints","subsection_anchors":null,"path":"/webhook_endpoints/delete","gate":false,"display_on_load":false}},
          "serviceWorkerPath": "/docs/apiRefServiceWorker.js",
          "fuseWebWorkerPath": "/assets/compiled/js/apiRefFuseWebWorker-a39f2c4466813957fba0.min.js",
          "cacheControlVersion": 4,
          "showAllGatedContent": false,
          "accountSwitcherData": {"user":null,"login_url":"https://dashboard.stripe.com/login?redirect=https%3A%2F%2Fstripe.com%2Fdocs%2Fapi","dashboard_host":"https://dashboard.stripe.com"},
          "stripeJsEnabled": true
        }