use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME                => 'CLASS',
    AUTHOR              => 'Jacques Deguest <jack@deguest.jp>',
    VERSION_FROM        => 'lib/Class.pm',
    ABSTRACT_FROM       => 'lib/Class.pm',
    PL_FILES            => {},
    PREREQ_PM           => {
        'parent'        => 0,
        'strict'        => 0,
        'version'       => 0,
        'warnings'      => 0,
        'Module::Generic'   => 'v0.21.4',
    },
    TEST_REQUIRES =>
    {
        'File::Find'    => 0,
        'Test::More'    => '1.302162',
        'Test::Pod'     => '1.52',
    },
    LICENSE             => 'perl_5',
    MIN_PERL_VERSION    => 'v5.26.1',
    dist                => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean               => { FILES => 'Class-*' },
    ( eval { ExtUtils::MakeMaker->VERSION(6.46) } ? ( META_MERGE => {
        'meta-spec' => { version => 2 },
        dynamic_config => 1,
        resources => {
        #    homepage    => undef,
            repository  => {
                url         => 'git@git.deguest.jp:jack/Class.git',
                web         => 'https://git.deguest.jp/jack/Class',
                type        => 'git',
            },
            bugtracker => {
                web         => 'https://git.deguest.jp/jack/Class/issues',
            },
        },
    }) : ()),
);
