#!perl -T
use Test::More;
use lib '.';
BEGIN {
    use_ok( 'Devel::GlobalSub' ) || print "Bail out!\n";
}
BEGIN {
    use_ok( 'MyGlobalSubs' ) || print "Bail out!\n";
}
use MyGLobalSubs;
use 5.006;
use strict;
use warnings;

for my $namespace (qw(main Test::More strict warnings)) {
	for my $sub_name (qw(test_a test_b)) {
		my $name = "${namespace}::$sub_name";
		is defined(&{$name}), 1, "Sub $sub_name is defined in $namespace";
		my $result = do {
			no strict 'refs';
			&{$name};
		};
		is $result, "$sub_name OK", "Result of $sub_name in $namespace is the expected";
	}
}

plan tests => 18;
