use utf8;

package SemanticWeb::Schema::VoteAction;

# ABSTRACT: The act of expressing a preference from a fixed/finite/structured set of choices/options.

use Moo;

extends qw/ SemanticWeb::Schema::ChooseAction /;


use MooX::JSON_LD 'VoteAction';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v10.0.0';


has candidate => (
    is        => 'rw',
    predicate => '_has_candidate',
    json_ld   => 'candidate',
);





1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::VoteAction - The act of expressing a preference from a fixed/finite/structured set of choices/options.

=head1 VERSION

version v10.0.0

=head1 DESCRIPTION

The act of expressing a preference from a fixed/finite/structured set of
choices/options.

=head1 ATTRIBUTES

=head2 C<candidate>

A sub property of object. The candidate subject of this action.

A candidate should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::Person']>

=back

=head2 C<_has_candidate>

A predicate for the L</candidate> attribute.

=head1 SEE ALSO

L<SemanticWeb::Schema::ChooseAction>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2020 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
