package Chart::Plotly::Trace::Pie;
use Moose;

our $VERSION = '0.002';    # VERSION

=encoding utf-8

=head1 NAME 

Chart::Plotly::Trace::Pie

=head1 SYNOPSIS

	use HTML::Show;
	use Chart::Plotly;
	use Chart::Plotly::Trace::Pie;
	my $pie = Chart::Plotly::Trace::Pie->new(x => [1 .. 5], y => [1 .. 5]);
	
	HTML::Show::show(Chart::Plotly::render_full_html(data => [$pie]));


=head1 DESCRIPTION

This file has been autogenerated from the official plotly.js source.

If you like Plotly, please support them: L<https://plot.ly/> 
Open source announcement: L<https://plot.ly/javascript/open-source-announcement/>

Full reference: L<https://plot.ly/javascript/reference/#pie>

=head1 DISCLAIMER

This is an unofficial Plotly Perl module. Currently I'm not affiliated in any way with Plotly. 
But I think plotly.js is a great library and I want to use it with perl.

=head1 METHODS

=cut

=head2 TO_JSON

Serialize the trace to JSON. This method should be called only by L<JSON> serializer.

=cut

sub TO_JSON {
    my $self = shift;
    my %hash = %$self;
    $hash{type} = $self->type();
    return \%hash;
}

=head2 type

Trace type.

=cut

sub type {
    my @components = split( /::/, __PACKAGE__ );
    return lc( $components[-1] );
}

=head1 ATTRIBUTES

=over

=cut

=item * dlabel

Sets the label step. See `label0` for more info.

=cut

has dlabel => ( is            => 'rw',
                documentation => "Sets the label step. See `label0` for more info.", );

=item * labels

Sets the sector labels.

=cut

has labels => ( is            => 'rw',
                documentation => "Sets the sector labels.", );

=item * hoverinfo

Determines which trace information appear on hover. If `none` or `skip` are set, no information is displayed upon hovering. But, if `none` is set, click and hover events are still fired.

=cut

has hoverinfo => (
    is => 'rw',
    documentation =>
      "Determines which trace information appear on hover. If `none` or `skip` are set, no information is displayed upon hovering. But, if `none` is set, click and hover events are still fired.",
);

=item * hole

Sets the fraction of the radius to cut out of the pie. Use this to make a donut chart.

=cut

has hole => ( is            => 'rw',
              documentation => "Sets the fraction of the radius to cut out of the pie. Use this to make a donut chart.",
);

=item * scalegroup

If there are multiple pies that should be sized according to their totals, link them by providing a non-empty group id here shared by every trace in the same group.

=cut

has scalegroup => (
    is => 'rw',
    documentation =>
      "If there are multiple pies that should be sized according to their totals, link them by providing a non-empty group id here shared by every trace in the same group.",
);

=item * textfont

Sets the font used for `textinfo`.

=cut

has textfont => ( is            => 'rw',
                  documentation => "Sets the font used for `textinfo`.", );

=item * textinfo

Determines which trace information appear on the graph.

=cut

has textinfo => ( is            => 'rw',
                  documentation => "Determines which trace information appear on the graph.", );

=item * values

Sets the values of the sectors of this pie chart.

=cut

has values => ( is            => 'rw',
                documentation => "Sets the values of the sectors of this pie chart.", );

=item * marker


=cut

has marker => ( is => 'rw', );

=item * label0

Alternate to `labels`. Builds a numeric set of labels. Use with `dlabel` where `label0` is the starting label and `dlabel` the step.

=cut

has label0 => (
    is => 'rw',
    documentation =>
      "Alternate to `labels`. Builds a numeric set of labels. Use with `dlabel` where `label0` is the starting label and `dlabel` the step.",
);

=item * rotation

Instead of the first slice starting at 12 o'clock, rotate to some other angle.

=cut

has rotation => ( is            => 'rw',
                  documentation => "Instead of the first slice starting at 12 o'clock, rotate to some other angle.", );

=item * text

Sets text elements associated with each sector.

=cut

has text => ( is            => 'rw',
              documentation => "Sets text elements associated with each sector.", );

=item * insidetextfont

Sets the font used for `textinfo` lying inside the pie.

=cut

has insidetextfont => ( is            => 'rw',
                        documentation => "Sets the font used for `textinfo` lying inside the pie.", );

=item * sort

Determines whether or not the sectors of reordered from largest to smallest.

=cut

has sort => ( is            => 'rw',
              documentation => "Determines whether or not the sectors of reordered from largest to smallest.", );

=item * domain


=cut

has domain => ( is => 'rw', );

=item * pull

Sets the fraction of larger radius to pull the sectors out from the center. This can be a constant to pull all slices apart from each other equally or an array to highlight one or more slices.

=cut

has pull => (
    is => 'rw',
    documentation =>
      "Sets the fraction of larger radius to pull the sectors out from the center. This can be a constant to pull all slices apart from each other equally or an array to highlight one or more slices.",
);

=item * outsidetextfont

Sets the font used for `textinfo` lying outside the pie.

=cut

has outsidetextfont => ( is            => 'rw',
                         documentation => "Sets the font used for `textinfo` lying outside the pie.", );

=item * direction

Specifies the direction at which succeeding sectors follow one another.

=cut

has direction => ( is            => 'rw',
                   documentation => "Specifies the direction at which succeeding sectors follow one another.", );

=item * textposition

Specifies the location of the `textinfo`.

=cut

has textposition => ( is            => 'rw',
                      documentation => "Specifies the location of the `textinfo`.", );

=pod

=back

=cut

__PACKAGE__->meta->make_immutable();
1;
