package Acme::CPANAuthors::CPAN::Streaks::MonthlyDistributions::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-06'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240506.0'; # VERSION

use Acme::CPANAuthors::Register (
    'PERLANCAR' => '',
    'SKIM' => '',
    'DJERIUS' => '',
    'BRIANDFOY' => '',
    'DAVECROSS' => '',
    'ARISTOTLE' => '',
    'CORION' => '',
    'MATHIAS' => '',
    'GBROWN' => '',
    'GDT' => '',
    'LNATION' => '',
    'BIGPRESH' => '',
    'CAPOEIRAB' => '',
    'CROMEDOME' => '',
    'DAMI' => '',
    'EGOR' => '',
    'HIGHTOWE' => '',
    'ISHIGAKI' => '',
    'JFORGET' => '',
    'JMATES' => '',
    'LEONT' => '',
    'MGUBIN' => '',
    'MYSOCIETY' => '',
    'PHILIPPE' => '',
    'RSPIER' => '',
    'SPWHITTON' => '',
    'TEAM' => '',
    'TIMKA' => '',
    'TYRRMINAL' => '',
    'UXYZAB' => '',
    'VNEALV' => '',
    'WATERKIP' => '',
);


1;
# ABSTRACT: Authors with ongoing monthly distributions streak (release a new [for them] distribution every month)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::MonthlyDistributions::Current - Authors with ongoing monthly distributions streak (release a new [for them] distribution every month)

=head1 VERSION

This document describes version 20240506.0 of Acme::CPANAuthors::CPAN::Streaks::MonthlyDistributions::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-05-06.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-05-06, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | PERLANCAR | 118 | 2014-08    | ongoing     |
  | SKIM      |  15 | 2023-03    | ongoing     |
  | DJERIUS   |   6 | 2023-12    | ongoing     |
  | BRIANDFOY |   3 | 2024-02    | might-break |
  | DAVECROSS |   3 | 2024-02    | might-break |
  | ARISTOTLE |   2 | 2024-03    | might-break |
  | CORION    |   2 | 2024-03    | might-break |
  | MATHIAS   |   2 | 2024-03    | might-break |
  | GBROWN    |   2 | 2024-04    | ongoing     |
  | GDT       |   2 | 2024-04    | ongoing     |
  | LNATION   |   2 | 2024-04    | ongoing     |
  | BIGPRESH  |   1 | 2024-04    | might-break |
  | CAPOEIRAB |   1 | 2024-04    | might-break |
  | CROMEDOME |   1 | 2024-04    | might-break |
  | DAMI      |   1 | 2024-04    | might-break |
  | EGOR      |   1 | 2024-04    | might-break |
  | HIGHTOWE  |   1 | 2024-04    | might-break |
  | ISHIGAKI  |   1 | 2024-04    | might-break |
  | JFORGET   |   1 | 2024-04    | might-break |
  | JMATES    |   1 | 2024-04    | might-break |
  | LEONT     |   1 | 2024-04    | might-break |
  | MGUBIN    |   1 | 2024-04    | might-break |
  | MYSOCIETY |   1 | 2024-04    | might-break |
  | PHILIPPE  |   1 | 2024-04    | might-break |
  | RSPIER    |   1 | 2024-04    | might-break |
  | SPWHITTON |   1 | 2024-04    | might-break |
  | TEAM      |   1 | 2024-04    | might-break |
  | TIMKA     |   1 | 2024-04    | might-break |
  | TYRRMINAL |   1 | 2024-04    | might-break |
  | UXYZAB    |   1 | 2024-04    | might-break |
  | VNEALV    |   1 | 2024-04    | might-break |
  | WATERKIP  |   1 | 2024-04    | might-break |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
